/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/batches.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * A representation of a batch workload in the service.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.Batch}
 */
public final class Batch extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.Batch)
    BatchOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Batch.newBuilder() to construct.
  private Batch(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Batch() {
    name_ = "";
    uuid_ = "";
    state_ = 0;
    stateMessage_ = "";
    creator_ = "";
    operation_ = "";
    stateHistory_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Batch();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.BatchesProto
        .internal_static_google_cloud_dataproc_v1_Batch_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 13:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.BatchesProto
        .internal_static_google_cloud_dataproc_v1_Batch_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.Batch.class,
            com.google.cloud.dataproc.v1.Batch.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The batch state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dataproc.v1.Batch.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The batch state is unknown.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The batch is created before running.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    PENDING(1),
    /**
     *
     *
     * <pre>
     * The batch is running.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * The batch is cancelling.
     * </pre>
     *
     * <code>CANCELLING = 3;</code>
     */
    CANCELLING(3),
    /**
     *
     *
     * <pre>
     * The batch cancellation was successful.
     * </pre>
     *
     * <code>CANCELLED = 4;</code>
     */
    CANCELLED(4),
    /**
     *
     *
     * <pre>
     * The batch completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 5;</code>
     */
    SUCCEEDED(5),
    /**
     *
     *
     * <pre>
     * The batch is no longer running due to an error.
     * </pre>
     *
     * <code>FAILED = 6;</code>
     */
    FAILED(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The batch state is unknown.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The batch is created before running.
     * </pre>
     *
     * <code>PENDING = 1;</code>
     */
    public static final int PENDING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The batch is running.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The batch is cancelling.
     * </pre>
     *
     * <code>CANCELLING = 3;</code>
     */
    public static final int CANCELLING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The batch cancellation was successful.
     * </pre>
     *
     * <code>CANCELLED = 4;</code>
     */
    public static final int CANCELLED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The batch completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 5;</code>
     */
    public static final int SUCCEEDED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The batch is no longer running due to an error.
     * </pre>
     *
     * <code>FAILED = 6;</code>
     */
    public static final int FAILED_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return PENDING;
        case 2:
          return RUNNING;
        case 3:
          return CANCELLING;
        case 4:
          return CANCELLED;
        case 5:
          return SUCCEEDED;
        case 6:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.Batch.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dataproc.v1.Batch.State)
  }

  public interface StateHistoryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.Batch.StateHistory)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The state of the batch at this point in history.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Batch.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     *
     *
     * <pre>
     * Output only. The state of the batch at this point in history.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Batch.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    com.google.cloud.dataproc.v1.Batch.State getState();

    /**
     *
     *
     * <pre>
     * Output only. Details about the state at this point in history.
     * </pre>
     *
     * <code>string state_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stateMessage.
     */
    java.lang.String getStateMessage();
    /**
     *
     *
     * <pre>
     * Output only. Details about the state at this point in history.
     * </pre>
     *
     * <code>string state_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stateMessage.
     */
    com.google.protobuf.ByteString getStateMessageBytes();

    /**
     *
     *
     * <pre>
     * Output only. The time when the batch entered the historical state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the stateStartTime field is set.
     */
    boolean hasStateStartTime();
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch entered the historical state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The stateStartTime.
     */
    com.google.protobuf.Timestamp getStateStartTime();
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch entered the historical state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getStateStartTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Historical state information.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.Batch.StateHistory}
   */
  public static final class StateHistory extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.Batch.StateHistory)
      StateHistoryOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use StateHistory.newBuilder() to construct.
    private StateHistory(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private StateHistory() {
      state_ = 0;
      stateMessage_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new StateHistory();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.BatchesProto
          .internal_static_google_cloud_dataproc_v1_Batch_StateHistory_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.BatchesProto
          .internal_static_google_cloud_dataproc_v1_Batch_StateHistory_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.Batch.StateHistory.class,
              com.google.cloud.dataproc.v1.Batch.StateHistory.Builder.class);
    }

    private int bitField0_;
    public static final int STATE_FIELD_NUMBER = 1;
    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of the batch at this point in history.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Batch.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the batch at this point in history.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Batch.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.Batch.State getState() {
      com.google.cloud.dataproc.v1.Batch.State result =
          com.google.cloud.dataproc.v1.Batch.State.forNumber(state_);
      return result == null ? com.google.cloud.dataproc.v1.Batch.State.UNRECOGNIZED : result;
    }

    public static final int STATE_MESSAGE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object stateMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Details about the state at this point in history.
     * </pre>
     *
     * <code>string state_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stateMessage.
     */
    @java.lang.Override
    public java.lang.String getStateMessage() {
      java.lang.Object ref = stateMessage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateMessage_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Details about the state at this point in history.
     * </pre>
     *
     * <code>string state_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stateMessage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStateMessageBytes() {
      java.lang.Object ref = stateMessage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stateMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATE_START_TIME_FIELD_NUMBER = 3;
    private com.google.protobuf.Timestamp stateStartTime_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch entered the historical state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the stateStartTime field is set.
     */
    @java.lang.Override
    public boolean hasStateStartTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch entered the historical state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The stateStartTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getStateStartTime() {
      return stateStartTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : stateStartTime_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch entered the historical state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getStateStartTimeOrBuilder() {
      return stateStartTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : stateStartTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (state_ != com.google.cloud.dataproc.v1.Batch.State.STATE_UNSPECIFIED.getNumber()) {
        output.writeEnum(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateMessage_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, stateMessage_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getStateStartTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (state_ != com.google.cloud.dataproc.v1.Batch.State.STATE_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateMessage_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, stateMessage_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStateStartTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataproc.v1.Batch.StateHistory)) {
        return super.equals(obj);
      }
      com.google.cloud.dataproc.v1.Batch.StateHistory other =
          (com.google.cloud.dataproc.v1.Batch.StateHistory) obj;

      if (state_ != other.state_) return false;
      if (!getStateMessage().equals(other.getStateMessage())) return false;
      if (hasStateStartTime() != other.hasStateStartTime()) return false;
      if (hasStateStartTime()) {
        if (!getStateStartTime().equals(other.getStateStartTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      hash = (37 * hash) + STATE_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getStateMessage().hashCode();
      if (hasStateStartTime()) {
        hash = (37 * hash) + STATE_START_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getStateStartTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataproc.v1.Batch.StateHistory parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.Batch.StateHistory parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.Batch.StateHistory parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.Batch.StateHistory parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.Batch.StateHistory parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.Batch.StateHistory parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.Batch.StateHistory parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.Batch.StateHistory parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.Batch.StateHistory parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.Batch.StateHistory parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.Batch.StateHistory parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.Batch.StateHistory parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.dataproc.v1.Batch.StateHistory prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Historical state information.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataproc.v1.Batch.StateHistory}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.Batch.StateHistory)
        com.google.cloud.dataproc.v1.Batch.StateHistoryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataproc.v1.BatchesProto
            .internal_static_google_cloud_dataproc_v1_Batch_StateHistory_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataproc.v1.BatchesProto
            .internal_static_google_cloud_dataproc_v1_Batch_StateHistory_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataproc.v1.Batch.StateHistory.class,
                com.google.cloud.dataproc.v1.Batch.StateHistory.Builder.class);
      }

      // Construct using com.google.cloud.dataproc.v1.Batch.StateHistory.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getStateStartTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        state_ = 0;
        stateMessage_ = "";
        stateStartTime_ = null;
        if (stateStartTimeBuilder_ != null) {
          stateStartTimeBuilder_.dispose();
          stateStartTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataproc.v1.BatchesProto
            .internal_static_google_cloud_dataproc_v1_Batch_StateHistory_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.Batch.StateHistory getDefaultInstanceForType() {
        return com.google.cloud.dataproc.v1.Batch.StateHistory.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.Batch.StateHistory build() {
        com.google.cloud.dataproc.v1.Batch.StateHistory result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.Batch.StateHistory buildPartial() {
        com.google.cloud.dataproc.v1.Batch.StateHistory result =
            new com.google.cloud.dataproc.v1.Batch.StateHistory(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.dataproc.v1.Batch.StateHistory result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.state_ = state_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.stateMessage_ = stateMessage_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.stateStartTime_ =
              stateStartTimeBuilder_ == null ? stateStartTime_ : stateStartTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dataproc.v1.Batch.StateHistory) {
          return mergeFrom((com.google.cloud.dataproc.v1.Batch.StateHistory) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dataproc.v1.Batch.StateHistory other) {
        if (other == com.google.cloud.dataproc.v1.Batch.StateHistory.getDefaultInstance())
          return this;
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (!other.getStateMessage().isEmpty()) {
          stateMessage_ = other.stateMessage_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasStateStartTime()) {
          mergeStateStartTime(other.getStateStartTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  stateMessage_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getStateStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int state_ = 0;
      /**
       *
       *
       * <pre>
       * Output only. The state of the batch at this point in history.
       * </pre>
       *
       * <code>
       * .google.cloud.dataproc.v1.Batch.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The state of the batch at this point in history.
       * </pre>
       *
       * <code>
       * .google.cloud.dataproc.v1.Batch.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The state of the batch at this point in history.
       * </pre>
       *
       * <code>
       * .google.cloud.dataproc.v1.Batch.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.cloud.dataproc.v1.Batch.State getState() {
        com.google.cloud.dataproc.v1.Batch.State result =
            com.google.cloud.dataproc.v1.Batch.State.forNumber(state_);
        return result == null ? com.google.cloud.dataproc.v1.Batch.State.UNRECOGNIZED : result;
      }
      /**
       *
       *
       * <pre>
       * Output only. The state of the batch at this point in history.
       * </pre>
       *
       * <code>
       * .google.cloud.dataproc.v1.Batch.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(com.google.cloud.dataproc.v1.Batch.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The state of the batch at this point in history.
       * </pre>
       *
       * <code>
       * .google.cloud.dataproc.v1.Batch.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000001);
        state_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object stateMessage_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Details about the state at this point in history.
       * </pre>
       *
       * <code>string state_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The stateMessage.
       */
      public java.lang.String getStateMessage() {
        java.lang.Object ref = stateMessage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          stateMessage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Details about the state at this point in history.
       * </pre>
       *
       * <code>string state_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for stateMessage.
       */
      public com.google.protobuf.ByteString getStateMessageBytes() {
        java.lang.Object ref = stateMessage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          stateMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Details about the state at this point in history.
       * </pre>
       *
       * <code>string state_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The stateMessage to set.
       * @return This builder for chaining.
       */
      public Builder setStateMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        stateMessage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Details about the state at this point in history.
       * </pre>
       *
       * <code>string state_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStateMessage() {
        stateMessage_ = getDefaultInstance().getStateMessage();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Details about the state at this point in history.
       * </pre>
       *
       * <code>string state_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for stateMessage to set.
       * @return This builder for chaining.
       */
      public Builder setStateMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        stateMessage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp stateStartTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          stateStartTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. The time when the batch entered the historical state.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the stateStartTime field is set.
       */
      public boolean hasStateStartTime() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when the batch entered the historical state.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The stateStartTime.
       */
      public com.google.protobuf.Timestamp getStateStartTime() {
        if (stateStartTimeBuilder_ == null) {
          return stateStartTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : stateStartTime_;
        } else {
          return stateStartTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when the batch entered the historical state.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setStateStartTime(com.google.protobuf.Timestamp value) {
        if (stateStartTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          stateStartTime_ = value;
        } else {
          stateStartTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when the batch entered the historical state.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setStateStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (stateStartTimeBuilder_ == null) {
          stateStartTime_ = builderForValue.build();
        } else {
          stateStartTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when the batch entered the historical state.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeStateStartTime(com.google.protobuf.Timestamp value) {
        if (stateStartTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && stateStartTime_ != null
              && stateStartTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getStateStartTimeBuilder().mergeFrom(value);
          } else {
            stateStartTime_ = value;
          }
        } else {
          stateStartTimeBuilder_.mergeFrom(value);
        }
        if (stateStartTime_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when the batch entered the historical state.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearStateStartTime() {
        bitField0_ = (bitField0_ & ~0x00000004);
        stateStartTime_ = null;
        if (stateStartTimeBuilder_ != null) {
          stateStartTimeBuilder_.dispose();
          stateStartTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when the batch entered the historical state.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getStateStartTimeBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getStateStartTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when the batch entered the historical state.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getStateStartTimeOrBuilder() {
        if (stateStartTimeBuilder_ != null) {
          return stateStartTimeBuilder_.getMessageOrBuilder();
        } else {
          return stateStartTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : stateStartTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when the batch entered the historical state.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getStateStartTimeFieldBuilder() {
        if (stateStartTimeBuilder_ == null) {
          stateStartTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getStateStartTime(), getParentForChildren(), isClean());
          stateStartTime_ = null;
        }
        return stateStartTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.Batch.StateHistory)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.Batch.StateHistory)
    private static final com.google.cloud.dataproc.v1.Batch.StateHistory DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.Batch.StateHistory();
    }

    public static com.google.cloud.dataproc.v1.Batch.StateHistory getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<StateHistory> PARSER =
        new com.google.protobuf.AbstractParser<StateHistory>() {
          @java.lang.Override
          public StateHistory parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<StateHistory> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StateHistory> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.Batch.StateHistory getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int batchConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object batchConfig_;

  public enum BatchConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PYSPARK_BATCH(4),
    SPARK_BATCH(5),
    SPARK_R_BATCH(6),
    SPARK_SQL_BATCH(7),
    BATCHCONFIG_NOT_SET(0);
    private final int value;

    private BatchConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BatchConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static BatchConfigCase forNumber(int value) {
      switch (value) {
        case 4:
          return PYSPARK_BATCH;
        case 5:
          return SPARK_BATCH;
        case 6:
          return SPARK_R_BATCH;
        case 7:
          return SPARK_SQL_BATCH;
        case 0:
          return BATCHCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public BatchConfigCase getBatchConfigCase() {
    return BatchConfigCase.forNumber(batchConfigCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the batch.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the batch.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UUID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uuid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. A batch UUID (Unique Universal Identifier). The service
   * generates this value when it creates the batch.
   * </pre>
   *
   * <code>string uuid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uuid.
   */
  @java.lang.Override
  public java.lang.String getUuid() {
    java.lang.Object ref = uuid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uuid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. A batch UUID (Unique Universal Identifier). The service
   * generates this value when it creates the batch.
   * </pre>
   *
   * <code>string uuid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uuid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUuidBytes() {
    java.lang.Object ref = uuid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uuid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the batch was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the batch was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the batch was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int PYSPARK_BATCH_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Optional. PySpark batch config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.PySparkBatch pyspark_batch = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the pysparkBatch field is set.
   */
  @java.lang.Override
  public boolean hasPysparkBatch() {
    return batchConfigCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Optional. PySpark batch config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.PySparkBatch pyspark_batch = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The pysparkBatch.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.PySparkBatch getPysparkBatch() {
    if (batchConfigCase_ == 4) {
      return (com.google.cloud.dataproc.v1.PySparkBatch) batchConfig_;
    }
    return com.google.cloud.dataproc.v1.PySparkBatch.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. PySpark batch config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.PySparkBatch pyspark_batch = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.PySparkBatchOrBuilder getPysparkBatchOrBuilder() {
    if (batchConfigCase_ == 4) {
      return (com.google.cloud.dataproc.v1.PySparkBatch) batchConfig_;
    }
    return com.google.cloud.dataproc.v1.PySparkBatch.getDefaultInstance();
  }

  public static final int SPARK_BATCH_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Optional. Spark batch config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkBatch spark_batch = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the sparkBatch field is set.
   */
  @java.lang.Override
  public boolean hasSparkBatch() {
    return batchConfigCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Optional. Spark batch config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkBatch spark_batch = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The sparkBatch.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.SparkBatch getSparkBatch() {
    if (batchConfigCase_ == 5) {
      return (com.google.cloud.dataproc.v1.SparkBatch) batchConfig_;
    }
    return com.google.cloud.dataproc.v1.SparkBatch.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Spark batch config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkBatch spark_batch = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.SparkBatchOrBuilder getSparkBatchOrBuilder() {
    if (batchConfigCase_ == 5) {
      return (com.google.cloud.dataproc.v1.SparkBatch) batchConfig_;
    }
    return com.google.cloud.dataproc.v1.SparkBatch.getDefaultInstance();
  }

  public static final int SPARK_R_BATCH_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Optional. SparkR batch config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkRBatch spark_r_batch = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the sparkRBatch field is set.
   */
  @java.lang.Override
  public boolean hasSparkRBatch() {
    return batchConfigCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Optional. SparkR batch config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkRBatch spark_r_batch = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The sparkRBatch.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.SparkRBatch getSparkRBatch() {
    if (batchConfigCase_ == 6) {
      return (com.google.cloud.dataproc.v1.SparkRBatch) batchConfig_;
    }
    return com.google.cloud.dataproc.v1.SparkRBatch.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. SparkR batch config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkRBatch spark_r_batch = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.SparkRBatchOrBuilder getSparkRBatchOrBuilder() {
    if (batchConfigCase_ == 6) {
      return (com.google.cloud.dataproc.v1.SparkRBatch) batchConfig_;
    }
    return com.google.cloud.dataproc.v1.SparkRBatch.getDefaultInstance();
  }

  public static final int SPARK_SQL_BATCH_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Optional. SparkSql batch config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkSqlBatch spark_sql_batch = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the sparkSqlBatch field is set.
   */
  @java.lang.Override
  public boolean hasSparkSqlBatch() {
    return batchConfigCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Optional. SparkSql batch config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkSqlBatch spark_sql_batch = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The sparkSqlBatch.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.SparkSqlBatch getSparkSqlBatch() {
    if (batchConfigCase_ == 7) {
      return (com.google.cloud.dataproc.v1.SparkSqlBatch) batchConfig_;
    }
    return com.google.cloud.dataproc.v1.SparkSqlBatch.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. SparkSql batch config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkSqlBatch spark_sql_batch = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.SparkSqlBatchOrBuilder getSparkSqlBatchOrBuilder() {
    if (batchConfigCase_ == 7) {
      return (com.google.cloud.dataproc.v1.SparkSqlBatch) batchConfig_;
    }
    return com.google.cloud.dataproc.v1.SparkSqlBatch.getDefaultInstance();
  }

  public static final int RUNTIME_INFO_FIELD_NUMBER = 8;
  private com.google.cloud.dataproc.v1.RuntimeInfo runtimeInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Runtime information about batch execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the runtimeInfo field is set.
   */
  @java.lang.Override
  public boolean hasRuntimeInfo() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Runtime information about batch execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The runtimeInfo.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.RuntimeInfo getRuntimeInfo() {
    return runtimeInfo_ == null
        ? com.google.cloud.dataproc.v1.RuntimeInfo.getDefaultInstance()
        : runtimeInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Runtime information about batch execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.RuntimeInfoOrBuilder getRuntimeInfoOrBuilder() {
    return runtimeInfo_ == null
        ? com.google.cloud.dataproc.v1.RuntimeInfo.getDefaultInstance()
        : runtimeInfo_;
  }

  public static final int STATE_FIELD_NUMBER = 9;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state of the batch.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.Batch.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of the batch.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.Batch.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.Batch.State getState() {
    com.google.cloud.dataproc.v1.Batch.State result =
        com.google.cloud.dataproc.v1.Batch.State.forNumber(state_);
    return result == null ? com.google.cloud.dataproc.v1.Batch.State.UNRECOGNIZED : result;
  }

  public static final int STATE_MESSAGE_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stateMessage_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Batch state details, such as a failure
   * description if the state is `FAILED`.
   * </pre>
   *
   * <code>string state_message = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The stateMessage.
   */
  @java.lang.Override
  public java.lang.String getStateMessage() {
    java.lang.Object ref = stateMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stateMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Batch state details, such as a failure
   * description if the state is `FAILED`.
   * </pre>
   *
   * <code>string state_message = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for stateMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateMessageBytes() {
    java.lang.Object ref = stateMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stateMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp stateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the batch entered a current state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp state_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the stateTime field is set.
   */
  @java.lang.Override
  public boolean hasStateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the batch entered a current state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp state_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The stateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStateTime() {
    return stateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : stateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the batch entered a current state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp state_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStateTimeOrBuilder() {
    return stateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : stateTime_;
  }

  public static final int CREATOR_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creator_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The email address of the user who created the batch.
   * </pre>
   *
   * <code>string creator = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The creator.
   */
  @java.lang.Override
  public java.lang.String getCreator() {
    java.lang.Object ref = creator_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creator_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The email address of the user who created the batch.
   * </pre>
   *
   * <code>string creator = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for creator.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreatorBytes() {
    java.lang.Object ref = creator_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creator_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 13;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataproc.v1.BatchesProto
                .internal_static_google_cloud_dataproc_v1_Batch_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this batch.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a batch.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this batch.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a batch.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this batch.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a batch.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this batch.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a batch.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int RUNTIME_CONFIG_FIELD_NUMBER = 14;
  private com.google.cloud.dataproc.v1.RuntimeConfig runtimeConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Runtime configuration for the batch execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the runtimeConfig field is set.
   */
  @java.lang.Override
  public boolean hasRuntimeConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Runtime configuration for the batch execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The runtimeConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.RuntimeConfig getRuntimeConfig() {
    return runtimeConfig_ == null
        ? com.google.cloud.dataproc.v1.RuntimeConfig.getDefaultInstance()
        : runtimeConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Runtime configuration for the batch execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 14 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.RuntimeConfigOrBuilder getRuntimeConfigOrBuilder() {
    return runtimeConfig_ == null
        ? com.google.cloud.dataproc.v1.RuntimeConfig.getDefaultInstance()
        : runtimeConfig_;
  }

  public static final int ENVIRONMENT_CONFIG_FIELD_NUMBER = 15;
  private com.google.cloud.dataproc.v1.EnvironmentConfig environmentConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Environment configuration for the batch execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the environmentConfig field is set.
   */
  @java.lang.Override
  public boolean hasEnvironmentConfig() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Environment configuration for the batch execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The environmentConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.EnvironmentConfig getEnvironmentConfig() {
    return environmentConfig_ == null
        ? com.google.cloud.dataproc.v1.EnvironmentConfig.getDefaultInstance()
        : environmentConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Environment configuration for the batch execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 15 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.EnvironmentConfigOrBuilder getEnvironmentConfigOrBuilder() {
    return environmentConfig_ == null
        ? com.google.cloud.dataproc.v1.EnvironmentConfig.getDefaultInstance()
        : environmentConfig_;
  }

  public static final int OPERATION_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object operation_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the operation associated with this batch.
   * </pre>
   *
   * <code>string operation = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The operation.
   */
  @java.lang.Override
  public java.lang.String getOperation() {
    java.lang.Object ref = operation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      operation_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource name of the operation associated with this batch.
   * </pre>
   *
   * <code>string operation = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for operation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOperationBytes() {
    java.lang.Object ref = operation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      operation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_HISTORY_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dataproc.v1.Batch.StateHistory> stateHistory_;
  /**
   *
   *
   * <pre>
   * Output only. Historical state information for the batch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dataproc.v1.Batch.StateHistory> getStateHistoryList() {
    return stateHistory_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Historical state information for the batch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dataproc.v1.Batch.StateHistoryOrBuilder>
      getStateHistoryOrBuilderList() {
    return stateHistory_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Historical state information for the batch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getStateHistoryCount() {
    return stateHistory_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Historical state information for the batch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.Batch.StateHistory getStateHistory(int index) {
    return stateHistory_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Historical state information for the batch.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.Batch.StateHistoryOrBuilder getStateHistoryOrBuilder(
      int index) {
    return stateHistory_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uuid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uuid_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (batchConfigCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.dataproc.v1.PySparkBatch) batchConfig_);
    }
    if (batchConfigCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.dataproc.v1.SparkBatch) batchConfig_);
    }
    if (batchConfigCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.dataproc.v1.SparkRBatch) batchConfig_);
    }
    if (batchConfigCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.dataproc.v1.SparkSqlBatch) batchConfig_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(8, getRuntimeInfo());
    }
    if (state_ != com.google.cloud.dataproc.v1.Batch.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(9, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, stateMessage_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(11, getStateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(creator_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, creator_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 13);
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(14, getRuntimeConfig());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(15, getEnvironmentConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(operation_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, operation_);
    }
    for (int i = 0; i < stateHistory_.size(); i++) {
      output.writeMessage(17, stateHistory_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uuid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uuid_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (batchConfigCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.dataproc.v1.PySparkBatch) batchConfig_);
    }
    if (batchConfigCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.dataproc.v1.SparkBatch) batchConfig_);
    }
    if (batchConfigCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.dataproc.v1.SparkRBatch) batchConfig_);
    }
    if (batchConfigCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.dataproc.v1.SparkSqlBatch) batchConfig_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getRuntimeInfo());
    }
    if (state_ != com.google.cloud.dataproc.v1.Batch.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, stateMessage_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getStateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(creator_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, creator_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, labels__);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getRuntimeConfig());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, getEnvironmentConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(operation_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, operation_);
    }
    for (int i = 0; i < stateHistory_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, stateHistory_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.Batch)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.Batch other = (com.google.cloud.dataproc.v1.Batch) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUuid().equals(other.getUuid())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasRuntimeInfo() != other.hasRuntimeInfo()) return false;
    if (hasRuntimeInfo()) {
      if (!getRuntimeInfo().equals(other.getRuntimeInfo())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getStateMessage().equals(other.getStateMessage())) return false;
    if (hasStateTime() != other.hasStateTime()) return false;
    if (hasStateTime()) {
      if (!getStateTime().equals(other.getStateTime())) return false;
    }
    if (!getCreator().equals(other.getCreator())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasRuntimeConfig() != other.hasRuntimeConfig()) return false;
    if (hasRuntimeConfig()) {
      if (!getRuntimeConfig().equals(other.getRuntimeConfig())) return false;
    }
    if (hasEnvironmentConfig() != other.hasEnvironmentConfig()) return false;
    if (hasEnvironmentConfig()) {
      if (!getEnvironmentConfig().equals(other.getEnvironmentConfig())) return false;
    }
    if (!getOperation().equals(other.getOperation())) return false;
    if (!getStateHistoryList().equals(other.getStateHistoryList())) return false;
    if (!getBatchConfigCase().equals(other.getBatchConfigCase())) return false;
    switch (batchConfigCase_) {
      case 4:
        if (!getPysparkBatch().equals(other.getPysparkBatch())) return false;
        break;
      case 5:
        if (!getSparkBatch().equals(other.getSparkBatch())) return false;
        break;
      case 6:
        if (!getSparkRBatch().equals(other.getSparkRBatch())) return false;
        break;
      case 7:
        if (!getSparkSqlBatch().equals(other.getSparkSqlBatch())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UUID_FIELD_NUMBER;
    hash = (53 * hash) + getUuid().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasRuntimeInfo()) {
      hash = (37 * hash) + RUNTIME_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getRuntimeInfo().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + STATE_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getStateMessage().hashCode();
    if (hasStateTime()) {
      hash = (37 * hash) + STATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStateTime().hashCode();
    }
    hash = (37 * hash) + CREATOR_FIELD_NUMBER;
    hash = (53 * hash) + getCreator().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasRuntimeConfig()) {
      hash = (37 * hash) + RUNTIME_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRuntimeConfig().hashCode();
    }
    if (hasEnvironmentConfig()) {
      hash = (37 * hash) + ENVIRONMENT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEnvironmentConfig().hashCode();
    }
    hash = (37 * hash) + OPERATION_FIELD_NUMBER;
    hash = (53 * hash) + getOperation().hashCode();
    if (getStateHistoryCount() > 0) {
      hash = (37 * hash) + STATE_HISTORY_FIELD_NUMBER;
      hash = (53 * hash) + getStateHistoryList().hashCode();
    }
    switch (batchConfigCase_) {
      case 4:
        hash = (37 * hash) + PYSPARK_BATCH_FIELD_NUMBER;
        hash = (53 * hash) + getPysparkBatch().hashCode();
        break;
      case 5:
        hash = (37 * hash) + SPARK_BATCH_FIELD_NUMBER;
        hash = (53 * hash) + getSparkBatch().hashCode();
        break;
      case 6:
        hash = (37 * hash) + SPARK_R_BATCH_FIELD_NUMBER;
        hash = (53 * hash) + getSparkRBatch().hashCode();
        break;
      case 7:
        hash = (37 * hash) + SPARK_SQL_BATCH_FIELD_NUMBER;
        hash = (53 * hash) + getSparkSqlBatch().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.Batch parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.Batch parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.Batch parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.Batch parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.Batch parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.Batch parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.Batch parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.Batch parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.Batch parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.Batch parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.Batch parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.Batch parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.Batch prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A representation of a batch workload in the service.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.Batch}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.Batch)
      com.google.cloud.dataproc.v1.BatchOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.BatchesProto
          .internal_static_google_cloud_dataproc_v1_Batch_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 13:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 13:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.BatchesProto
          .internal_static_google_cloud_dataproc_v1_Batch_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.Batch.class,
              com.google.cloud.dataproc.v1.Batch.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.Batch.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getRuntimeInfoFieldBuilder();
        getStateTimeFieldBuilder();
        getRuntimeConfigFieldBuilder();
        getEnvironmentConfigFieldBuilder();
        getStateHistoryFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      uuid_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      if (pysparkBatchBuilder_ != null) {
        pysparkBatchBuilder_.clear();
      }
      if (sparkBatchBuilder_ != null) {
        sparkBatchBuilder_.clear();
      }
      if (sparkRBatchBuilder_ != null) {
        sparkRBatchBuilder_.clear();
      }
      if (sparkSqlBatchBuilder_ != null) {
        sparkSqlBatchBuilder_.clear();
      }
      runtimeInfo_ = null;
      if (runtimeInfoBuilder_ != null) {
        runtimeInfoBuilder_.dispose();
        runtimeInfoBuilder_ = null;
      }
      state_ = 0;
      stateMessage_ = "";
      stateTime_ = null;
      if (stateTimeBuilder_ != null) {
        stateTimeBuilder_.dispose();
        stateTimeBuilder_ = null;
      }
      creator_ = "";
      internalGetMutableLabels().clear();
      runtimeConfig_ = null;
      if (runtimeConfigBuilder_ != null) {
        runtimeConfigBuilder_.dispose();
        runtimeConfigBuilder_ = null;
      }
      environmentConfig_ = null;
      if (environmentConfigBuilder_ != null) {
        environmentConfigBuilder_.dispose();
        environmentConfigBuilder_ = null;
      }
      operation_ = "";
      if (stateHistoryBuilder_ == null) {
        stateHistory_ = java.util.Collections.emptyList();
      } else {
        stateHistory_ = null;
        stateHistoryBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00010000);
      batchConfigCase_ = 0;
      batchConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.BatchesProto
          .internal_static_google_cloud_dataproc_v1_Batch_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.Batch getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.Batch.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.Batch build() {
      com.google.cloud.dataproc.v1.Batch result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.Batch buildPartial() {
      com.google.cloud.dataproc.v1.Batch result = new com.google.cloud.dataproc.v1.Batch(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dataproc.v1.Batch result) {
      if (stateHistoryBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)) {
          stateHistory_ = java.util.Collections.unmodifiableList(stateHistory_);
          bitField0_ = (bitField0_ & ~0x00010000);
        }
        result.stateHistory_ = stateHistory_;
      } else {
        result.stateHistory_ = stateHistoryBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.Batch result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uuid_ = uuid_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.runtimeInfo_ =
            runtimeInfoBuilder_ == null ? runtimeInfo_ : runtimeInfoBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.stateMessage_ = stateMessage_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.stateTime_ = stateTimeBuilder_ == null ? stateTime_ : stateTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.creator_ = creator_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.runtimeConfig_ =
            runtimeConfigBuilder_ == null ? runtimeConfig_ : runtimeConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.environmentConfig_ =
            environmentConfigBuilder_ == null
                ? environmentConfig_
                : environmentConfigBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.operation_ = operation_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.dataproc.v1.Batch result) {
      result.batchConfigCase_ = batchConfigCase_;
      result.batchConfig_ = this.batchConfig_;
      if (batchConfigCase_ == 4 && pysparkBatchBuilder_ != null) {
        result.batchConfig_ = pysparkBatchBuilder_.build();
      }
      if (batchConfigCase_ == 5 && sparkBatchBuilder_ != null) {
        result.batchConfig_ = sparkBatchBuilder_.build();
      }
      if (batchConfigCase_ == 6 && sparkRBatchBuilder_ != null) {
        result.batchConfig_ = sparkRBatchBuilder_.build();
      }
      if (batchConfigCase_ == 7 && sparkSqlBatchBuilder_ != null) {
        result.batchConfig_ = sparkSqlBatchBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.Batch) {
        return mergeFrom((com.google.cloud.dataproc.v1.Batch) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.Batch other) {
      if (other == com.google.cloud.dataproc.v1.Batch.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUuid().isEmpty()) {
        uuid_ = other.uuid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasRuntimeInfo()) {
        mergeRuntimeInfo(other.getRuntimeInfo());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getStateMessage().isEmpty()) {
        stateMessage_ = other.stateMessage_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasStateTime()) {
        mergeStateTime(other.getStateTime());
      }
      if (!other.getCreator().isEmpty()) {
        creator_ = other.creator_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00001000;
      if (other.hasRuntimeConfig()) {
        mergeRuntimeConfig(other.getRuntimeConfig());
      }
      if (other.hasEnvironmentConfig()) {
        mergeEnvironmentConfig(other.getEnvironmentConfig());
      }
      if (!other.getOperation().isEmpty()) {
        operation_ = other.operation_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (stateHistoryBuilder_ == null) {
        if (!other.stateHistory_.isEmpty()) {
          if (stateHistory_.isEmpty()) {
            stateHistory_ = other.stateHistory_;
            bitField0_ = (bitField0_ & ~0x00010000);
          } else {
            ensureStateHistoryIsMutable();
            stateHistory_.addAll(other.stateHistory_);
          }
          onChanged();
        }
      } else {
        if (!other.stateHistory_.isEmpty()) {
          if (stateHistoryBuilder_.isEmpty()) {
            stateHistoryBuilder_.dispose();
            stateHistoryBuilder_ = null;
            stateHistory_ = other.stateHistory_;
            bitField0_ = (bitField0_ & ~0x00010000);
            stateHistoryBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStateHistoryFieldBuilder()
                    : null;
          } else {
            stateHistoryBuilder_.addAllMessages(other.stateHistory_);
          }
        }
      }
      switch (other.getBatchConfigCase()) {
        case PYSPARK_BATCH:
          {
            mergePysparkBatch(other.getPysparkBatch());
            break;
          }
        case SPARK_BATCH:
          {
            mergeSparkBatch(other.getSparkBatch());
            break;
          }
        case SPARK_R_BATCH:
          {
            mergeSparkRBatch(other.getSparkRBatch());
            break;
          }
        case SPARK_SQL_BATCH:
          {
            mergeSparkSqlBatch(other.getSparkSqlBatch());
            break;
          }
        case BATCHCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uuid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getPysparkBatchFieldBuilder().getBuilder(), extensionRegistry);
                batchConfigCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getSparkBatchFieldBuilder().getBuilder(), extensionRegistry);
                batchConfigCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getSparkRBatchFieldBuilder().getBuilder(), extensionRegistry);
                batchConfigCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getSparkSqlBatchFieldBuilder().getBuilder(), extensionRegistry);
                batchConfigCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getRuntimeInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 72:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 82:
              {
                stateMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getStateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                creator_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 106:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getRuntimeConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 114
            case 122:
              {
                input.readMessage(
                    getEnvironmentConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00004000;
                break;
              } // case 122
            case 130:
              {
                operation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 130
            case 138:
              {
                com.google.cloud.dataproc.v1.Batch.StateHistory m =
                    input.readMessage(
                        com.google.cloud.dataproc.v1.Batch.StateHistory.parser(),
                        extensionRegistry);
                if (stateHistoryBuilder_ == null) {
                  ensureStateHistoryIsMutable();
                  stateHistory_.add(m);
                } else {
                  stateHistoryBuilder_.addMessage(m);
                }
                break;
              } // case 138
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int batchConfigCase_ = 0;
    private java.lang.Object batchConfig_;

    public BatchConfigCase getBatchConfigCase() {
      return BatchConfigCase.forNumber(batchConfigCase_);
    }

    public Builder clearBatchConfig() {
      batchConfigCase_ = 0;
      batchConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the batch.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the batch.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the batch.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the batch.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the batch.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uuid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. A batch UUID (Unique Universal Identifier). The service
     * generates this value when it creates the batch.
     * </pre>
     *
     * <code>string uuid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uuid.
     */
    public java.lang.String getUuid() {
      java.lang.Object ref = uuid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uuid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A batch UUID (Unique Universal Identifier). The service
     * generates this value when it creates the batch.
     * </pre>
     *
     * <code>string uuid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uuid.
     */
    public com.google.protobuf.ByteString getUuidBytes() {
      java.lang.Object ref = uuid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uuid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A batch UUID (Unique Universal Identifier). The service
     * generates this value when it creates the batch.
     * </pre>
     *
     * <code>string uuid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uuid to set.
     * @return This builder for chaining.
     */
    public Builder setUuid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uuid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A batch UUID (Unique Universal Identifier). The service
     * generates this value when it creates the batch.
     * </pre>
     *
     * <code>string uuid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUuid() {
      uuid_ = getDefaultInstance().getUuid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A batch UUID (Unique Universal Identifier). The service
     * generates this value when it creates the batch.
     * </pre>
     *
     * <code>string uuid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uuid to set.
     * @return This builder for chaining.
     */
    public Builder setUuidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uuid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.PySparkBatch,
            com.google.cloud.dataproc.v1.PySparkBatch.Builder,
            com.google.cloud.dataproc.v1.PySparkBatchOrBuilder>
        pysparkBatchBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. PySpark batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PySparkBatch pyspark_batch = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the pysparkBatch field is set.
     */
    @java.lang.Override
    public boolean hasPysparkBatch() {
      return batchConfigCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Optional. PySpark batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PySparkBatch pyspark_batch = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The pysparkBatch.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.PySparkBatch getPysparkBatch() {
      if (pysparkBatchBuilder_ == null) {
        if (batchConfigCase_ == 4) {
          return (com.google.cloud.dataproc.v1.PySparkBatch) batchConfig_;
        }
        return com.google.cloud.dataproc.v1.PySparkBatch.getDefaultInstance();
      } else {
        if (batchConfigCase_ == 4) {
          return pysparkBatchBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.PySparkBatch.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. PySpark batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PySparkBatch pyspark_batch = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPysparkBatch(com.google.cloud.dataproc.v1.PySparkBatch value) {
      if (pysparkBatchBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        batchConfig_ = value;
        onChanged();
      } else {
        pysparkBatchBuilder_.setMessage(value);
      }
      batchConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. PySpark batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PySparkBatch pyspark_batch = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPysparkBatch(
        com.google.cloud.dataproc.v1.PySparkBatch.Builder builderForValue) {
      if (pysparkBatchBuilder_ == null) {
        batchConfig_ = builderForValue.build();
        onChanged();
      } else {
        pysparkBatchBuilder_.setMessage(builderForValue.build());
      }
      batchConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. PySpark batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PySparkBatch pyspark_batch = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePysparkBatch(com.google.cloud.dataproc.v1.PySparkBatch value) {
      if (pysparkBatchBuilder_ == null) {
        if (batchConfigCase_ == 4
            && batchConfig_ != com.google.cloud.dataproc.v1.PySparkBatch.getDefaultInstance()) {
          batchConfig_ =
              com.google.cloud.dataproc.v1.PySparkBatch.newBuilder(
                      (com.google.cloud.dataproc.v1.PySparkBatch) batchConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          batchConfig_ = value;
        }
        onChanged();
      } else {
        if (batchConfigCase_ == 4) {
          pysparkBatchBuilder_.mergeFrom(value);
        } else {
          pysparkBatchBuilder_.setMessage(value);
        }
      }
      batchConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. PySpark batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PySparkBatch pyspark_batch = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPysparkBatch() {
      if (pysparkBatchBuilder_ == null) {
        if (batchConfigCase_ == 4) {
          batchConfigCase_ = 0;
          batchConfig_ = null;
          onChanged();
        }
      } else {
        if (batchConfigCase_ == 4) {
          batchConfigCase_ = 0;
          batchConfig_ = null;
        }
        pysparkBatchBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. PySpark batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PySparkBatch pyspark_batch = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.PySparkBatch.Builder getPysparkBatchBuilder() {
      return getPysparkBatchFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. PySpark batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PySparkBatch pyspark_batch = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.PySparkBatchOrBuilder getPysparkBatchOrBuilder() {
      if ((batchConfigCase_ == 4) && (pysparkBatchBuilder_ != null)) {
        return pysparkBatchBuilder_.getMessageOrBuilder();
      } else {
        if (batchConfigCase_ == 4) {
          return (com.google.cloud.dataproc.v1.PySparkBatch) batchConfig_;
        }
        return com.google.cloud.dataproc.v1.PySparkBatch.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. PySpark batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PySparkBatch pyspark_batch = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.PySparkBatch,
            com.google.cloud.dataproc.v1.PySparkBatch.Builder,
            com.google.cloud.dataproc.v1.PySparkBatchOrBuilder>
        getPysparkBatchFieldBuilder() {
      if (pysparkBatchBuilder_ == null) {
        if (!(batchConfigCase_ == 4)) {
          batchConfig_ = com.google.cloud.dataproc.v1.PySparkBatch.getDefaultInstance();
        }
        pysparkBatchBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.PySparkBatch,
                com.google.cloud.dataproc.v1.PySparkBatch.Builder,
                com.google.cloud.dataproc.v1.PySparkBatchOrBuilder>(
                (com.google.cloud.dataproc.v1.PySparkBatch) batchConfig_,
                getParentForChildren(),
                isClean());
        batchConfig_ = null;
      }
      batchConfigCase_ = 4;
      onChanged();
      return pysparkBatchBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.SparkBatch,
            com.google.cloud.dataproc.v1.SparkBatch.Builder,
            com.google.cloud.dataproc.v1.SparkBatchOrBuilder>
        sparkBatchBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Spark batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkBatch spark_batch = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sparkBatch field is set.
     */
    @java.lang.Override
    public boolean hasSparkBatch() {
      return batchConfigCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkBatch spark_batch = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sparkBatch.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkBatch getSparkBatch() {
      if (sparkBatchBuilder_ == null) {
        if (batchConfigCase_ == 5) {
          return (com.google.cloud.dataproc.v1.SparkBatch) batchConfig_;
        }
        return com.google.cloud.dataproc.v1.SparkBatch.getDefaultInstance();
      } else {
        if (batchConfigCase_ == 5) {
          return sparkBatchBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.SparkBatch.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkBatch spark_batch = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSparkBatch(com.google.cloud.dataproc.v1.SparkBatch value) {
      if (sparkBatchBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        batchConfig_ = value;
        onChanged();
      } else {
        sparkBatchBuilder_.setMessage(value);
      }
      batchConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkBatch spark_batch = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSparkBatch(com.google.cloud.dataproc.v1.SparkBatch.Builder builderForValue) {
      if (sparkBatchBuilder_ == null) {
        batchConfig_ = builderForValue.build();
        onChanged();
      } else {
        sparkBatchBuilder_.setMessage(builderForValue.build());
      }
      batchConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkBatch spark_batch = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSparkBatch(com.google.cloud.dataproc.v1.SparkBatch value) {
      if (sparkBatchBuilder_ == null) {
        if (batchConfigCase_ == 5
            && batchConfig_ != com.google.cloud.dataproc.v1.SparkBatch.getDefaultInstance()) {
          batchConfig_ =
              com.google.cloud.dataproc.v1.SparkBatch.newBuilder(
                      (com.google.cloud.dataproc.v1.SparkBatch) batchConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          batchConfig_ = value;
        }
        onChanged();
      } else {
        if (batchConfigCase_ == 5) {
          sparkBatchBuilder_.mergeFrom(value);
        } else {
          sparkBatchBuilder_.setMessage(value);
        }
      }
      batchConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkBatch spark_batch = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSparkBatch() {
      if (sparkBatchBuilder_ == null) {
        if (batchConfigCase_ == 5) {
          batchConfigCase_ = 0;
          batchConfig_ = null;
          onChanged();
        }
      } else {
        if (batchConfigCase_ == 5) {
          batchConfigCase_ = 0;
          batchConfig_ = null;
        }
        sparkBatchBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkBatch spark_batch = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.SparkBatch.Builder getSparkBatchBuilder() {
      return getSparkBatchFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkBatch spark_batch = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkBatchOrBuilder getSparkBatchOrBuilder() {
      if ((batchConfigCase_ == 5) && (sparkBatchBuilder_ != null)) {
        return sparkBatchBuilder_.getMessageOrBuilder();
      } else {
        if (batchConfigCase_ == 5) {
          return (com.google.cloud.dataproc.v1.SparkBatch) batchConfig_;
        }
        return com.google.cloud.dataproc.v1.SparkBatch.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkBatch spark_batch = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.SparkBatch,
            com.google.cloud.dataproc.v1.SparkBatch.Builder,
            com.google.cloud.dataproc.v1.SparkBatchOrBuilder>
        getSparkBatchFieldBuilder() {
      if (sparkBatchBuilder_ == null) {
        if (!(batchConfigCase_ == 5)) {
          batchConfig_ = com.google.cloud.dataproc.v1.SparkBatch.getDefaultInstance();
        }
        sparkBatchBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.SparkBatch,
                com.google.cloud.dataproc.v1.SparkBatch.Builder,
                com.google.cloud.dataproc.v1.SparkBatchOrBuilder>(
                (com.google.cloud.dataproc.v1.SparkBatch) batchConfig_,
                getParentForChildren(),
                isClean());
        batchConfig_ = null;
      }
      batchConfigCase_ = 5;
      onChanged();
      return sparkBatchBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.SparkRBatch,
            com.google.cloud.dataproc.v1.SparkRBatch.Builder,
            com.google.cloud.dataproc.v1.SparkRBatchOrBuilder>
        sparkRBatchBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. SparkR batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkRBatch spark_r_batch = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sparkRBatch field is set.
     */
    @java.lang.Override
    public boolean hasSparkRBatch() {
      return batchConfigCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Optional. SparkR batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkRBatch spark_r_batch = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sparkRBatch.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkRBatch getSparkRBatch() {
      if (sparkRBatchBuilder_ == null) {
        if (batchConfigCase_ == 6) {
          return (com.google.cloud.dataproc.v1.SparkRBatch) batchConfig_;
        }
        return com.google.cloud.dataproc.v1.SparkRBatch.getDefaultInstance();
      } else {
        if (batchConfigCase_ == 6) {
          return sparkRBatchBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.SparkRBatch.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. SparkR batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkRBatch spark_r_batch = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSparkRBatch(com.google.cloud.dataproc.v1.SparkRBatch value) {
      if (sparkRBatchBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        batchConfig_ = value;
        onChanged();
      } else {
        sparkRBatchBuilder_.setMessage(value);
      }
      batchConfigCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. SparkR batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkRBatch spark_r_batch = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSparkRBatch(
        com.google.cloud.dataproc.v1.SparkRBatch.Builder builderForValue) {
      if (sparkRBatchBuilder_ == null) {
        batchConfig_ = builderForValue.build();
        onChanged();
      } else {
        sparkRBatchBuilder_.setMessage(builderForValue.build());
      }
      batchConfigCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. SparkR batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkRBatch spark_r_batch = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSparkRBatch(com.google.cloud.dataproc.v1.SparkRBatch value) {
      if (sparkRBatchBuilder_ == null) {
        if (batchConfigCase_ == 6
            && batchConfig_ != com.google.cloud.dataproc.v1.SparkRBatch.getDefaultInstance()) {
          batchConfig_ =
              com.google.cloud.dataproc.v1.SparkRBatch.newBuilder(
                      (com.google.cloud.dataproc.v1.SparkRBatch) batchConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          batchConfig_ = value;
        }
        onChanged();
      } else {
        if (batchConfigCase_ == 6) {
          sparkRBatchBuilder_.mergeFrom(value);
        } else {
          sparkRBatchBuilder_.setMessage(value);
        }
      }
      batchConfigCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. SparkR batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkRBatch spark_r_batch = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSparkRBatch() {
      if (sparkRBatchBuilder_ == null) {
        if (batchConfigCase_ == 6) {
          batchConfigCase_ = 0;
          batchConfig_ = null;
          onChanged();
        }
      } else {
        if (batchConfigCase_ == 6) {
          batchConfigCase_ = 0;
          batchConfig_ = null;
        }
        sparkRBatchBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. SparkR batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkRBatch spark_r_batch = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.SparkRBatch.Builder getSparkRBatchBuilder() {
      return getSparkRBatchFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. SparkR batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkRBatch spark_r_batch = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkRBatchOrBuilder getSparkRBatchOrBuilder() {
      if ((batchConfigCase_ == 6) && (sparkRBatchBuilder_ != null)) {
        return sparkRBatchBuilder_.getMessageOrBuilder();
      } else {
        if (batchConfigCase_ == 6) {
          return (com.google.cloud.dataproc.v1.SparkRBatch) batchConfig_;
        }
        return com.google.cloud.dataproc.v1.SparkRBatch.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. SparkR batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkRBatch spark_r_batch = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.SparkRBatch,
            com.google.cloud.dataproc.v1.SparkRBatch.Builder,
            com.google.cloud.dataproc.v1.SparkRBatchOrBuilder>
        getSparkRBatchFieldBuilder() {
      if (sparkRBatchBuilder_ == null) {
        if (!(batchConfigCase_ == 6)) {
          batchConfig_ = com.google.cloud.dataproc.v1.SparkRBatch.getDefaultInstance();
        }
        sparkRBatchBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.SparkRBatch,
                com.google.cloud.dataproc.v1.SparkRBatch.Builder,
                com.google.cloud.dataproc.v1.SparkRBatchOrBuilder>(
                (com.google.cloud.dataproc.v1.SparkRBatch) batchConfig_,
                getParentForChildren(),
                isClean());
        batchConfig_ = null;
      }
      batchConfigCase_ = 6;
      onChanged();
      return sparkRBatchBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.SparkSqlBatch,
            com.google.cloud.dataproc.v1.SparkSqlBatch.Builder,
            com.google.cloud.dataproc.v1.SparkSqlBatchOrBuilder>
        sparkSqlBatchBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. SparkSql batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkSqlBatch spark_sql_batch = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sparkSqlBatch field is set.
     */
    @java.lang.Override
    public boolean hasSparkSqlBatch() {
      return batchConfigCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Optional. SparkSql batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkSqlBatch spark_sql_batch = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sparkSqlBatch.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkSqlBatch getSparkSqlBatch() {
      if (sparkSqlBatchBuilder_ == null) {
        if (batchConfigCase_ == 7) {
          return (com.google.cloud.dataproc.v1.SparkSqlBatch) batchConfig_;
        }
        return com.google.cloud.dataproc.v1.SparkSqlBatch.getDefaultInstance();
      } else {
        if (batchConfigCase_ == 7) {
          return sparkSqlBatchBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.SparkSqlBatch.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. SparkSql batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkSqlBatch spark_sql_batch = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSparkSqlBatch(com.google.cloud.dataproc.v1.SparkSqlBatch value) {
      if (sparkSqlBatchBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        batchConfig_ = value;
        onChanged();
      } else {
        sparkSqlBatchBuilder_.setMessage(value);
      }
      batchConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. SparkSql batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkSqlBatch spark_sql_batch = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSparkSqlBatch(
        com.google.cloud.dataproc.v1.SparkSqlBatch.Builder builderForValue) {
      if (sparkSqlBatchBuilder_ == null) {
        batchConfig_ = builderForValue.build();
        onChanged();
      } else {
        sparkSqlBatchBuilder_.setMessage(builderForValue.build());
      }
      batchConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. SparkSql batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkSqlBatch spark_sql_batch = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSparkSqlBatch(com.google.cloud.dataproc.v1.SparkSqlBatch value) {
      if (sparkSqlBatchBuilder_ == null) {
        if (batchConfigCase_ == 7
            && batchConfig_ != com.google.cloud.dataproc.v1.SparkSqlBatch.getDefaultInstance()) {
          batchConfig_ =
              com.google.cloud.dataproc.v1.SparkSqlBatch.newBuilder(
                      (com.google.cloud.dataproc.v1.SparkSqlBatch) batchConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          batchConfig_ = value;
        }
        onChanged();
      } else {
        if (batchConfigCase_ == 7) {
          sparkSqlBatchBuilder_.mergeFrom(value);
        } else {
          sparkSqlBatchBuilder_.setMessage(value);
        }
      }
      batchConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. SparkSql batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkSqlBatch spark_sql_batch = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSparkSqlBatch() {
      if (sparkSqlBatchBuilder_ == null) {
        if (batchConfigCase_ == 7) {
          batchConfigCase_ = 0;
          batchConfig_ = null;
          onChanged();
        }
      } else {
        if (batchConfigCase_ == 7) {
          batchConfigCase_ = 0;
          batchConfig_ = null;
        }
        sparkSqlBatchBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. SparkSql batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkSqlBatch spark_sql_batch = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.SparkSqlBatch.Builder getSparkSqlBatchBuilder() {
      return getSparkSqlBatchFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. SparkSql batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkSqlBatch spark_sql_batch = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkSqlBatchOrBuilder getSparkSqlBatchOrBuilder() {
      if ((batchConfigCase_ == 7) && (sparkSqlBatchBuilder_ != null)) {
        return sparkSqlBatchBuilder_.getMessageOrBuilder();
      } else {
        if (batchConfigCase_ == 7) {
          return (com.google.cloud.dataproc.v1.SparkSqlBatch) batchConfig_;
        }
        return com.google.cloud.dataproc.v1.SparkSqlBatch.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. SparkSql batch config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkSqlBatch spark_sql_batch = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.SparkSqlBatch,
            com.google.cloud.dataproc.v1.SparkSqlBatch.Builder,
            com.google.cloud.dataproc.v1.SparkSqlBatchOrBuilder>
        getSparkSqlBatchFieldBuilder() {
      if (sparkSqlBatchBuilder_ == null) {
        if (!(batchConfigCase_ == 7)) {
          batchConfig_ = com.google.cloud.dataproc.v1.SparkSqlBatch.getDefaultInstance();
        }
        sparkSqlBatchBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.SparkSqlBatch,
                com.google.cloud.dataproc.v1.SparkSqlBatch.Builder,
                com.google.cloud.dataproc.v1.SparkSqlBatchOrBuilder>(
                (com.google.cloud.dataproc.v1.SparkSqlBatch) batchConfig_,
                getParentForChildren(),
                isClean());
        batchConfig_ = null;
      }
      batchConfigCase_ = 7;
      onChanged();
      return sparkSqlBatchBuilder_;
    }

    private com.google.cloud.dataproc.v1.RuntimeInfo runtimeInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.RuntimeInfo,
            com.google.cloud.dataproc.v1.RuntimeInfo.Builder,
            com.google.cloud.dataproc.v1.RuntimeInfoOrBuilder>
        runtimeInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Runtime information about batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the runtimeInfo field is set.
     */
    public boolean hasRuntimeInfo() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime information about batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The runtimeInfo.
     */
    public com.google.cloud.dataproc.v1.RuntimeInfo getRuntimeInfo() {
      if (runtimeInfoBuilder_ == null) {
        return runtimeInfo_ == null
            ? com.google.cloud.dataproc.v1.RuntimeInfo.getDefaultInstance()
            : runtimeInfo_;
      } else {
        return runtimeInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime information about batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRuntimeInfo(com.google.cloud.dataproc.v1.RuntimeInfo value) {
      if (runtimeInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runtimeInfo_ = value;
      } else {
        runtimeInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime information about batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRuntimeInfo(
        com.google.cloud.dataproc.v1.RuntimeInfo.Builder builderForValue) {
      if (runtimeInfoBuilder_ == null) {
        runtimeInfo_ = builderForValue.build();
      } else {
        runtimeInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime information about batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRuntimeInfo(com.google.cloud.dataproc.v1.RuntimeInfo value) {
      if (runtimeInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && runtimeInfo_ != null
            && runtimeInfo_ != com.google.cloud.dataproc.v1.RuntimeInfo.getDefaultInstance()) {
          getRuntimeInfoBuilder().mergeFrom(value);
        } else {
          runtimeInfo_ = value;
        }
      } else {
        runtimeInfoBuilder_.mergeFrom(value);
      }
      if (runtimeInfo_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime information about batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRuntimeInfo() {
      bitField0_ = (bitField0_ & ~0x00000080);
      runtimeInfo_ = null;
      if (runtimeInfoBuilder_ != null) {
        runtimeInfoBuilder_.dispose();
        runtimeInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime information about batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.RuntimeInfo.Builder getRuntimeInfoBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getRuntimeInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime information about batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.RuntimeInfoOrBuilder getRuntimeInfoOrBuilder() {
      if (runtimeInfoBuilder_ != null) {
        return runtimeInfoBuilder_.getMessageOrBuilder();
      } else {
        return runtimeInfo_ == null
            ? com.google.cloud.dataproc.v1.RuntimeInfo.getDefaultInstance()
            : runtimeInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime information about batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.RuntimeInfo,
            com.google.cloud.dataproc.v1.RuntimeInfo.Builder,
            com.google.cloud.dataproc.v1.RuntimeInfoOrBuilder>
        getRuntimeInfoFieldBuilder() {
      if (runtimeInfoBuilder_ == null) {
        runtimeInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.RuntimeInfo,
                com.google.cloud.dataproc.v1.RuntimeInfo.Builder,
                com.google.cloud.dataproc.v1.RuntimeInfoOrBuilder>(
                getRuntimeInfo(), getParentForChildren(), isClean());
        runtimeInfo_ = null;
      }
      return runtimeInfoBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of the batch.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Batch.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the batch.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Batch.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the batch.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Batch.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.Batch.State getState() {
      com.google.cloud.dataproc.v1.Batch.State result =
          com.google.cloud.dataproc.v1.Batch.State.forNumber(state_);
      return result == null ? com.google.cloud.dataproc.v1.Batch.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the batch.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Batch.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.dataproc.v1.Batch.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the batch.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Batch.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000100);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object stateMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Batch state details, such as a failure
     * description if the state is `FAILED`.
     * </pre>
     *
     * <code>string state_message = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stateMessage.
     */
    public java.lang.String getStateMessage() {
      java.lang.Object ref = stateMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Batch state details, such as a failure
     * description if the state is `FAILED`.
     * </pre>
     *
     * <code>string state_message = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stateMessage.
     */
    public com.google.protobuf.ByteString getStateMessageBytes() {
      java.lang.Object ref = stateMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stateMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Batch state details, such as a failure
     * description if the state is `FAILED`.
     * </pre>
     *
     * <code>string state_message = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The stateMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStateMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stateMessage_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Batch state details, such as a failure
     * description if the state is `FAILED`.
     * </pre>
     *
     * <code>string state_message = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStateMessage() {
      stateMessage_ = getDefaultInstance().getStateMessage();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Batch state details, such as a failure
     * description if the state is `FAILED`.
     * </pre>
     *
     * <code>string state_message = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for stateMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStateMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stateMessage_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp stateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        stateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch entered a current state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the stateTime field is set.
     */
    public boolean hasStateTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch entered a current state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The stateTime.
     */
    public com.google.protobuf.Timestamp getStateTime() {
      if (stateTimeBuilder_ == null) {
        return stateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : stateTime_;
      } else {
        return stateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch entered a current state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStateTime(com.google.protobuf.Timestamp value) {
      if (stateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stateTime_ = value;
      } else {
        stateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch entered a current state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (stateTimeBuilder_ == null) {
        stateTime_ = builderForValue.build();
      } else {
        stateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch entered a current state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStateTime(com.google.protobuf.Timestamp value) {
      if (stateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && stateTime_ != null
            && stateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStateTimeBuilder().mergeFrom(value);
        } else {
          stateTime_ = value;
        }
      } else {
        stateTimeBuilder_.mergeFrom(value);
      }
      if (stateTime_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch entered a current state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStateTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      stateTime_ = null;
      if (stateTimeBuilder_ != null) {
        stateTimeBuilder_.dispose();
        stateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch entered a current state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStateTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getStateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch entered a current state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStateTimeOrBuilder() {
      if (stateTimeBuilder_ != null) {
        return stateTimeBuilder_.getMessageOrBuilder();
      } else {
        return stateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : stateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the batch entered a current state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStateTimeFieldBuilder() {
      if (stateTimeBuilder_ == null) {
        stateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStateTime(), getParentForChildren(), isClean());
        stateTime_ = null;
      }
      return stateTimeBuilder_;
    }

    private java.lang.Object creator_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The email address of the user who created the batch.
     * </pre>
     *
     * <code>string creator = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The creator.
     */
    public java.lang.String getCreator() {
      java.lang.Object ref = creator_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creator_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The email address of the user who created the batch.
     * </pre>
     *
     * <code>string creator = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for creator.
     */
    public com.google.protobuf.ByteString getCreatorBytes() {
      java.lang.Object ref = creator_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creator_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The email address of the user who created the batch.
     * </pre>
     *
     * <code>string creator = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The creator to set.
     * @return This builder for chaining.
     */
    public Builder setCreator(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creator_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The email address of the user who created the batch.
     * </pre>
     *
     * <code>string creator = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreator() {
      creator_ = getDefaultInstance().getCreator();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The email address of the user who created the batch.
     * </pre>
     *
     * <code>string creator = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for creator to set.
     * @return This builder for chaining.
     */
    public Builder setCreatorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creator_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this batch.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a batch.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this batch.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a batch.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this batch.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a batch.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this batch.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a batch.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00001000);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this batch.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a batch.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00001000;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this batch.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a batch.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00001000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this batch.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a batch.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00001000;
      return this;
    }

    private com.google.cloud.dataproc.v1.RuntimeConfig runtimeConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.RuntimeConfig,
            com.google.cloud.dataproc.v1.RuntimeConfig.Builder,
            com.google.cloud.dataproc.v1.RuntimeConfigOrBuilder>
        runtimeConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for the batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the runtimeConfig field is set.
     */
    public boolean hasRuntimeConfig() {
      return ((bitField0_ & 0x00002000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for the batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The runtimeConfig.
     */
    public com.google.cloud.dataproc.v1.RuntimeConfig getRuntimeConfig() {
      if (runtimeConfigBuilder_ == null) {
        return runtimeConfig_ == null
            ? com.google.cloud.dataproc.v1.RuntimeConfig.getDefaultInstance()
            : runtimeConfig_;
      } else {
        return runtimeConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for the batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRuntimeConfig(com.google.cloud.dataproc.v1.RuntimeConfig value) {
      if (runtimeConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runtimeConfig_ = value;
      } else {
        runtimeConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for the batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRuntimeConfig(
        com.google.cloud.dataproc.v1.RuntimeConfig.Builder builderForValue) {
      if (runtimeConfigBuilder_ == null) {
        runtimeConfig_ = builderForValue.build();
      } else {
        runtimeConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for the batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRuntimeConfig(com.google.cloud.dataproc.v1.RuntimeConfig value) {
      if (runtimeConfigBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && runtimeConfig_ != null
            && runtimeConfig_ != com.google.cloud.dataproc.v1.RuntimeConfig.getDefaultInstance()) {
          getRuntimeConfigBuilder().mergeFrom(value);
        } else {
          runtimeConfig_ = value;
        }
      } else {
        runtimeConfigBuilder_.mergeFrom(value);
      }
      if (runtimeConfig_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for the batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRuntimeConfig() {
      bitField0_ = (bitField0_ & ~0x00002000);
      runtimeConfig_ = null;
      if (runtimeConfigBuilder_ != null) {
        runtimeConfigBuilder_.dispose();
        runtimeConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for the batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.RuntimeConfig.Builder getRuntimeConfigBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getRuntimeConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for the batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.RuntimeConfigOrBuilder getRuntimeConfigOrBuilder() {
      if (runtimeConfigBuilder_ != null) {
        return runtimeConfigBuilder_.getMessageOrBuilder();
      } else {
        return runtimeConfig_ == null
            ? com.google.cloud.dataproc.v1.RuntimeConfig.getDefaultInstance()
            : runtimeConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for the batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 14 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.RuntimeConfig,
            com.google.cloud.dataproc.v1.RuntimeConfig.Builder,
            com.google.cloud.dataproc.v1.RuntimeConfigOrBuilder>
        getRuntimeConfigFieldBuilder() {
      if (runtimeConfigBuilder_ == null) {
        runtimeConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.RuntimeConfig,
                com.google.cloud.dataproc.v1.RuntimeConfig.Builder,
                com.google.cloud.dataproc.v1.RuntimeConfigOrBuilder>(
                getRuntimeConfig(), getParentForChildren(), isClean());
        runtimeConfig_ = null;
      }
      return runtimeConfigBuilder_;
    }

    private com.google.cloud.dataproc.v1.EnvironmentConfig environmentConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.EnvironmentConfig,
            com.google.cloud.dataproc.v1.EnvironmentConfig.Builder,
            com.google.cloud.dataproc.v1.EnvironmentConfigOrBuilder>
        environmentConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for the batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the environmentConfig field is set.
     */
    public boolean hasEnvironmentConfig() {
      return ((bitField0_ & 0x00004000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for the batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The environmentConfig.
     */
    public com.google.cloud.dataproc.v1.EnvironmentConfig getEnvironmentConfig() {
      if (environmentConfigBuilder_ == null) {
        return environmentConfig_ == null
            ? com.google.cloud.dataproc.v1.EnvironmentConfig.getDefaultInstance()
            : environmentConfig_;
      } else {
        return environmentConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for the batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEnvironmentConfig(com.google.cloud.dataproc.v1.EnvironmentConfig value) {
      if (environmentConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        environmentConfig_ = value;
      } else {
        environmentConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for the batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEnvironmentConfig(
        com.google.cloud.dataproc.v1.EnvironmentConfig.Builder builderForValue) {
      if (environmentConfigBuilder_ == null) {
        environmentConfig_ = builderForValue.build();
      } else {
        environmentConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for the batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEnvironmentConfig(com.google.cloud.dataproc.v1.EnvironmentConfig value) {
      if (environmentConfigBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)
            && environmentConfig_ != null
            && environmentConfig_
                != com.google.cloud.dataproc.v1.EnvironmentConfig.getDefaultInstance()) {
          getEnvironmentConfigBuilder().mergeFrom(value);
        } else {
          environmentConfig_ = value;
        }
      } else {
        environmentConfigBuilder_.mergeFrom(value);
      }
      if (environmentConfig_ != null) {
        bitField0_ |= 0x00004000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for the batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEnvironmentConfig() {
      bitField0_ = (bitField0_ & ~0x00004000);
      environmentConfig_ = null;
      if (environmentConfigBuilder_ != null) {
        environmentConfigBuilder_.dispose();
        environmentConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for the batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.EnvironmentConfig.Builder getEnvironmentConfigBuilder() {
      bitField0_ |= 0x00004000;
      onChanged();
      return getEnvironmentConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for the batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.EnvironmentConfigOrBuilder getEnvironmentConfigOrBuilder() {
      if (environmentConfigBuilder_ != null) {
        return environmentConfigBuilder_.getMessageOrBuilder();
      } else {
        return environmentConfig_ == null
            ? com.google.cloud.dataproc.v1.EnvironmentConfig.getDefaultInstance()
            : environmentConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for the batch execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.EnvironmentConfig,
            com.google.cloud.dataproc.v1.EnvironmentConfig.Builder,
            com.google.cloud.dataproc.v1.EnvironmentConfigOrBuilder>
        getEnvironmentConfigFieldBuilder() {
      if (environmentConfigBuilder_ == null) {
        environmentConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.EnvironmentConfig,
                com.google.cloud.dataproc.v1.EnvironmentConfig.Builder,
                com.google.cloud.dataproc.v1.EnvironmentConfigOrBuilder>(
                getEnvironmentConfig(), getParentForChildren(), isClean());
        environmentConfig_ = null;
      }
      return environmentConfigBuilder_;
    }

    private java.lang.Object operation_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the operation associated with this batch.
     * </pre>
     *
     * <code>string operation = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The operation.
     */
    public java.lang.String getOperation() {
      java.lang.Object ref = operation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        operation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the operation associated with this batch.
     * </pre>
     *
     * <code>string operation = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for operation.
     */
    public com.google.protobuf.ByteString getOperationBytes() {
      java.lang.Object ref = operation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        operation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the operation associated with this batch.
     * </pre>
     *
     * <code>string operation = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The operation to set.
     * @return This builder for chaining.
     */
    public Builder setOperation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      operation_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the operation associated with this batch.
     * </pre>
     *
     * <code>string operation = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperation() {
      operation_ = getDefaultInstance().getOperation();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the operation associated with this batch.
     * </pre>
     *
     * <code>string operation = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for operation to set.
     * @return This builder for chaining.
     */
    public Builder setOperationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      operation_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dataproc.v1.Batch.StateHistory> stateHistory_ =
        java.util.Collections.emptyList();

    private void ensureStateHistoryIsMutable() {
      if (!((bitField0_ & 0x00010000) != 0)) {
        stateHistory_ =
            new java.util.ArrayList<com.google.cloud.dataproc.v1.Batch.StateHistory>(stateHistory_);
        bitField0_ |= 0x00010000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.Batch.StateHistory,
            com.google.cloud.dataproc.v1.Batch.StateHistory.Builder,
            com.google.cloud.dataproc.v1.Batch.StateHistoryOrBuilder>
        stateHistoryBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.Batch.StateHistory> getStateHistoryList() {
      if (stateHistoryBuilder_ == null) {
        return java.util.Collections.unmodifiableList(stateHistory_);
      } else {
        return stateHistoryBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getStateHistoryCount() {
      if (stateHistoryBuilder_ == null) {
        return stateHistory_.size();
      } else {
        return stateHistoryBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.Batch.StateHistory getStateHistory(int index) {
      if (stateHistoryBuilder_ == null) {
        return stateHistory_.get(index);
      } else {
        return stateHistoryBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStateHistory(
        int index, com.google.cloud.dataproc.v1.Batch.StateHistory value) {
      if (stateHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStateHistoryIsMutable();
        stateHistory_.set(index, value);
        onChanged();
      } else {
        stateHistoryBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStateHistory(
        int index, com.google.cloud.dataproc.v1.Batch.StateHistory.Builder builderForValue) {
      if (stateHistoryBuilder_ == null) {
        ensureStateHistoryIsMutable();
        stateHistory_.set(index, builderForValue.build());
        onChanged();
      } else {
        stateHistoryBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStateHistory(com.google.cloud.dataproc.v1.Batch.StateHistory value) {
      if (stateHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStateHistoryIsMutable();
        stateHistory_.add(value);
        onChanged();
      } else {
        stateHistoryBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStateHistory(
        int index, com.google.cloud.dataproc.v1.Batch.StateHistory value) {
      if (stateHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStateHistoryIsMutable();
        stateHistory_.add(index, value);
        onChanged();
      } else {
        stateHistoryBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStateHistory(
        com.google.cloud.dataproc.v1.Batch.StateHistory.Builder builderForValue) {
      if (stateHistoryBuilder_ == null) {
        ensureStateHistoryIsMutable();
        stateHistory_.add(builderForValue.build());
        onChanged();
      } else {
        stateHistoryBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStateHistory(
        int index, com.google.cloud.dataproc.v1.Batch.StateHistory.Builder builderForValue) {
      if (stateHistoryBuilder_ == null) {
        ensureStateHistoryIsMutable();
        stateHistory_.add(index, builderForValue.build());
        onChanged();
      } else {
        stateHistoryBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllStateHistory(
        java.lang.Iterable<? extends com.google.cloud.dataproc.v1.Batch.StateHistory> values) {
      if (stateHistoryBuilder_ == null) {
        ensureStateHistoryIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, stateHistory_);
        onChanged();
      } else {
        stateHistoryBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStateHistory() {
      if (stateHistoryBuilder_ == null) {
        stateHistory_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00010000);
        onChanged();
      } else {
        stateHistoryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeStateHistory(int index) {
      if (stateHistoryBuilder_ == null) {
        ensureStateHistoryIsMutable();
        stateHistory_.remove(index);
        onChanged();
      } else {
        stateHistoryBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.Batch.StateHistory.Builder getStateHistoryBuilder(
        int index) {
      return getStateHistoryFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.Batch.StateHistoryOrBuilder getStateHistoryOrBuilder(
        int index) {
      if (stateHistoryBuilder_ == null) {
        return stateHistory_.get(index);
      } else {
        return stateHistoryBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dataproc.v1.Batch.StateHistoryOrBuilder>
        getStateHistoryOrBuilderList() {
      if (stateHistoryBuilder_ != null) {
        return stateHistoryBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(stateHistory_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.Batch.StateHistory.Builder addStateHistoryBuilder() {
      return getStateHistoryFieldBuilder()
          .addBuilder(com.google.cloud.dataproc.v1.Batch.StateHistory.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.Batch.StateHistory.Builder addStateHistoryBuilder(
        int index) {
      return getStateHistoryFieldBuilder()
          .addBuilder(index, com.google.cloud.dataproc.v1.Batch.StateHistory.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the batch.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Batch.StateHistory state_history = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.Batch.StateHistory.Builder>
        getStateHistoryBuilderList() {
      return getStateHistoryFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.Batch.StateHistory,
            com.google.cloud.dataproc.v1.Batch.StateHistory.Builder,
            com.google.cloud.dataproc.v1.Batch.StateHistoryOrBuilder>
        getStateHistoryFieldBuilder() {
      if (stateHistoryBuilder_ == null) {
        stateHistoryBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataproc.v1.Batch.StateHistory,
                com.google.cloud.dataproc.v1.Batch.StateHistory.Builder,
                com.google.cloud.dataproc.v1.Batch.StateHistoryOrBuilder>(
                stateHistory_, ((bitField0_ & 0x00010000) != 0), getParentForChildren(), isClean());
        stateHistory_ = null;
      }
      return stateHistoryBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.Batch)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.Batch)
  private static final com.google.cloud.dataproc.v1.Batch DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.Batch();
  }

  public static com.google.cloud.dataproc.v1.Batch getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Batch> PARSER =
      new com.google.protobuf.AbstractParser<Batch>() {
        @java.lang.Override
        public Batch parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Batch> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Batch> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.Batch getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
