/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/sessions.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dataproc.v1;

public interface CreateSessionRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.CreateSessionRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The parent resource where this session will be created.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();
  /**
   *
   *
   * <pre>
   * Required. The parent resource where this session will be created.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Required. The interactive session to create.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.Session session = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the session field is set.
   */
  boolean hasSession();
  /**
   *
   *
   * <pre>
   * Required. The interactive session to create.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.Session session = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The session.
   */
  com.google.cloud.dataproc.v1.Session getSession();
  /**
   *
   *
   * <pre>
   * Required. The interactive session to create.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.Session session = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.dataproc.v1.SessionOrBuilder getSessionOrBuilder();

  /**
   *
   *
   * <pre>
   * Required. The ID to use for the session, which becomes the final component
   * of the session's resource name.
   *
   * This value must be 4-63 characters. Valid characters
   * are /[a-z][0-9]-/.
   * </pre>
   *
   * <code>string session_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The sessionId.
   */
  java.lang.String getSessionId();
  /**
   *
   *
   * <pre>
   * Required. The ID to use for the session, which becomes the final component
   * of the session's resource name.
   *
   * This value must be 4-63 characters. Valid characters
   * are /[a-z][0-9]-/.
   * </pre>
   *
   * <code>string session_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for sessionId.
   */
  com.google.protobuf.ByteString getSessionIdBytes();

  /**
   *
   *
   * <pre>
   * Optional. A unique ID used to identify the request. If the service
   * receives two
   * [CreateSessionRequests](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.CreateSessionRequest)s
   * with the same ID, the second request is ignored, and the
   * first [Session][google.cloud.dataproc.v1.Session] is created and stored in
   * the backend.
   *
   * Recommendation: Set this value to a
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
   *
   * The value must contain only letters (a-z, A-Z), numbers (0-9),
   * underscores (_), and hyphens (-). The maximum length is 40 characters.
   * </pre>
   *
   * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  java.lang.String getRequestId();
  /**
   *
   *
   * <pre>
   * Optional. A unique ID used to identify the request. If the service
   * receives two
   * [CreateSessionRequests](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.CreateSessionRequest)s
   * with the same ID, the second request is ignored, and the
   * first [Session][google.cloud.dataproc.v1.Session] is created and stored in
   * the backend.
   *
   * Recommendation: Set this value to a
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
   *
   * The value must contain only letters (a-z, A-Z), numbers (0-9),
   * underscores (_), and hyphens (-). The maximum length is 40 characters.
   * </pre>
   *
   * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  com.google.protobuf.ByteString getRequestIdBytes();
}
