/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/clusters.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dataproc.v1;

public interface DiagnoseClusterRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.DiagnoseClusterRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The ID of the Google Cloud Platform project that the cluster
   * belongs to.
   * </pre>
   *
   * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The projectId.
   */
  java.lang.String getProjectId();
  /**
   *
   *
   * <pre>
   * Required. The ID of the Google Cloud Platform project that the cluster
   * belongs to.
   * </pre>
   *
   * <code>string project_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for projectId.
   */
  com.google.protobuf.ByteString getProjectIdBytes();

  /**
   *
   *
   * <pre>
   * Required. The Dataproc region in which to handle the request.
   * </pre>
   *
   * <code>string region = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The region.
   */
  java.lang.String getRegion();
  /**
   *
   *
   * <pre>
   * Required. The Dataproc region in which to handle the request.
   * </pre>
   *
   * <code>string region = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for region.
   */
  com.google.protobuf.ByteString getRegionBytes();

  /**
   *
   *
   * <pre>
   * Required. The cluster name.
   * </pre>
   *
   * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The clusterName.
   */
  java.lang.String getClusterName();
  /**
   *
   *
   * <pre>
   * Required. The cluster name.
   * </pre>
   *
   * <code>string cluster_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for clusterName.
   */
  com.google.protobuf.ByteString getClusterNameBytes();

  /**
   *
   *
   * <pre>
   * Optional. (Optional) The output Cloud Storage directory for the diagnostic
   * tarball. If not specified, a task-specific directory in the cluster's
   * staging bucket will be used.
   * </pre>
   *
   * <code>string tarball_gcs_dir = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The tarballGcsDir.
   */
  java.lang.String getTarballGcsDir();
  /**
   *
   *
   * <pre>
   * Optional. (Optional) The output Cloud Storage directory for the diagnostic
   * tarball. If not specified, a task-specific directory in the cluster's
   * staging bucket will be used.
   * </pre>
   *
   * <code>string tarball_gcs_dir = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for tarballGcsDir.
   */
  com.google.protobuf.ByteString getTarballGcsDirBytes();

  /**
   *
   *
   * <pre>
   * Optional. (Optional) The access type to the diagnostic tarball. If not
   * specified, falls back to default access of the bucket
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.DiagnoseClusterRequest.TarballAccess tarball_access = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for tarballAccess.
   */
  int getTarballAccessValue();
  /**
   *
   *
   * <pre>
   * Optional. (Optional) The access type to the diagnostic tarball. If not
   * specified, falls back to default access of the bucket
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.DiagnoseClusterRequest.TarballAccess tarball_access = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The tarballAccess.
   */
  com.google.cloud.dataproc.v1.DiagnoseClusterRequest.TarballAccess getTarballAccess();

  /**
   *
   *
   * <pre>
   * Optional. Time interval in which diagnosis should be carried out on the
   * cluster.
   * </pre>
   *
   * <code>.google.type.Interval diagnosis_interval = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the diagnosisInterval field is set.
   */
  boolean hasDiagnosisInterval();
  /**
   *
   *
   * <pre>
   * Optional. Time interval in which diagnosis should be carried out on the
   * cluster.
   * </pre>
   *
   * <code>.google.type.Interval diagnosis_interval = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The diagnosisInterval.
   */
  com.google.type.Interval getDiagnosisInterval();
  /**
   *
   *
   * <pre>
   * Optional. Time interval in which diagnosis should be carried out on the
   * cluster.
   * </pre>
   *
   * <code>.google.type.Interval diagnosis_interval = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.type.IntervalOrBuilder getDiagnosisIntervalOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. Specifies a list of jobs on which diagnosis is to be performed.
   * Format: projects/{project}/regions/{region}/jobs/{job}
   * </pre>
   *
   * <code>repeated string jobs = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the jobs.
   */
  java.util.List<java.lang.String> getJobsList();
  /**
   *
   *
   * <pre>
   * Optional. Specifies a list of jobs on which diagnosis is to be performed.
   * Format: projects/{project}/regions/{region}/jobs/{job}
   * </pre>
   *
   * <code>repeated string jobs = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of jobs.
   */
  int getJobsCount();
  /**
   *
   *
   * <pre>
   * Optional. Specifies a list of jobs on which diagnosis is to be performed.
   * Format: projects/{project}/regions/{region}/jobs/{job}
   * </pre>
   *
   * <code>repeated string jobs = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The jobs at the given index.
   */
  java.lang.String getJobs(int index);
  /**
   *
   *
   * <pre>
   * Optional. Specifies a list of jobs on which diagnosis is to be performed.
   * Format: projects/{project}/regions/{region}/jobs/{job}
   * </pre>
   *
   * <code>repeated string jobs = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the jobs at the given index.
   */
  com.google.protobuf.ByteString getJobsBytes(int index);

  /**
   *
   *
   * <pre>
   * Optional. Specifies a list of yarn applications on which diagnosis is to be
   * performed.
   * </pre>
   *
   * <code>repeated string yarn_application_ids = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the yarnApplicationIds.
   */
  java.util.List<java.lang.String> getYarnApplicationIdsList();
  /**
   *
   *
   * <pre>
   * Optional. Specifies a list of yarn applications on which diagnosis is to be
   * performed.
   * </pre>
   *
   * <code>repeated string yarn_application_ids = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of yarnApplicationIds.
   */
  int getYarnApplicationIdsCount();
  /**
   *
   *
   * <pre>
   * Optional. Specifies a list of yarn applications on which diagnosis is to be
   * performed.
   * </pre>
   *
   * <code>repeated string yarn_application_ids = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The yarnApplicationIds at the given index.
   */
  java.lang.String getYarnApplicationIds(int index);
  /**
   *
   *
   * <pre>
   * Optional. Specifies a list of yarn applications on which diagnosis is to be
   * performed.
   * </pre>
   *
   * <code>repeated string yarn_application_ids = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the yarnApplicationIds at the given index.
   */
  com.google.protobuf.ByteString getYarnApplicationIdsBytes(int index);
}
