/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/clusters.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dataproc.v1;

public interface EncryptionConfigOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.EncryptionConfig)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Optional. The Cloud KMS key resource name to use for persistent disk
   * encryption for all instances in the cluster. See [Use CMEK with cluster
   * data]
   * (https://cloud.google.com//dataproc/docs/concepts/configuring-clusters/customer-managed-encryption#use_cmek_with_cluster_data)
   * for more information.
   * </pre>
   *
   * <code>string gce_pd_kms_key_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The gcePdKmsKeyName.
   */
  java.lang.String getGcePdKmsKeyName();
  /**
   *
   *
   * <pre>
   * Optional. The Cloud KMS key resource name to use for persistent disk
   * encryption for all instances in the cluster. See [Use CMEK with cluster
   * data]
   * (https://cloud.google.com//dataproc/docs/concepts/configuring-clusters/customer-managed-encryption#use_cmek_with_cluster_data)
   * for more information.
   * </pre>
   *
   * <code>string gce_pd_kms_key_name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for gcePdKmsKeyName.
   */
  com.google.protobuf.ByteString getGcePdKmsKeyNameBytes();

  /**
   *
   *
   * <pre>
   * Optional. The Cloud KMS key resource name to use for cluster persistent
   * disk and job argument encryption. See [Use CMEK with cluster data]
   * (https://cloud.google.com//dataproc/docs/concepts/configuring-clusters/customer-managed-encryption#use_cmek_with_cluster_data)
   * for more information.
   *
   * When this key resource name is provided, the following job arguments of
   * the following job types submitted to the cluster are encrypted using CMEK:
   *
   * * [FlinkJob
   * args](https://cloud.google.com/dataproc/docs/reference/rest/v1/FlinkJob)
   * * [HadoopJob
   * args](https://cloud.google.com/dataproc/docs/reference/rest/v1/HadoopJob)
   * * [SparkJob
   * args](https://cloud.google.com/dataproc/docs/reference/rest/v1/SparkJob)
   * * [SparkRJob
   * args](https://cloud.google.com/dataproc/docs/reference/rest/v1/SparkRJob)
   * * [PySparkJob
   * args](https://cloud.google.com/dataproc/docs/reference/rest/v1/PySparkJob)
   * * [SparkSqlJob](https://cloud.google.com/dataproc/docs/reference/rest/v1/SparkSqlJob)
   *   scriptVariables and queryList.queries
   * * [HiveJob](https://cloud.google.com/dataproc/docs/reference/rest/v1/HiveJob)
   *   scriptVariables and queryList.queries
   * * [PigJob](https://cloud.google.com/dataproc/docs/reference/rest/v1/PigJob)
   *   scriptVariables and queryList.queries
   * * [PrestoJob](https://cloud.google.com/dataproc/docs/reference/rest/v1/PrestoJob)
   *   scriptVariables and queryList.queries
   * </pre>
   *
   * <code>
   * string kms_key = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The kmsKey.
   */
  java.lang.String getKmsKey();
  /**
   *
   *
   * <pre>
   * Optional. The Cloud KMS key resource name to use for cluster persistent
   * disk and job argument encryption. See [Use CMEK with cluster data]
   * (https://cloud.google.com//dataproc/docs/concepts/configuring-clusters/customer-managed-encryption#use_cmek_with_cluster_data)
   * for more information.
   *
   * When this key resource name is provided, the following job arguments of
   * the following job types submitted to the cluster are encrypted using CMEK:
   *
   * * [FlinkJob
   * args](https://cloud.google.com/dataproc/docs/reference/rest/v1/FlinkJob)
   * * [HadoopJob
   * args](https://cloud.google.com/dataproc/docs/reference/rest/v1/HadoopJob)
   * * [SparkJob
   * args](https://cloud.google.com/dataproc/docs/reference/rest/v1/SparkJob)
   * * [SparkRJob
   * args](https://cloud.google.com/dataproc/docs/reference/rest/v1/SparkRJob)
   * * [PySparkJob
   * args](https://cloud.google.com/dataproc/docs/reference/rest/v1/PySparkJob)
   * * [SparkSqlJob](https://cloud.google.com/dataproc/docs/reference/rest/v1/SparkSqlJob)
   *   scriptVariables and queryList.queries
   * * [HiveJob](https://cloud.google.com/dataproc/docs/reference/rest/v1/HiveJob)
   *   scriptVariables and queryList.queries
   * * [PigJob](https://cloud.google.com/dataproc/docs/reference/rest/v1/PigJob)
   *   scriptVariables and queryList.queries
   * * [PrestoJob](https://cloud.google.com/dataproc/docs/reference/rest/v1/PrestoJob)
   *   scriptVariables and queryList.queries
   * </pre>
   *
   * <code>
   * string kms_key = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for kmsKey.
   */
  com.google.protobuf.ByteString getKmsKeyBytes();
}
