/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/shared.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * The cluster's GKE config.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.GkeClusterConfig}
 */
public final class GkeClusterConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.GkeClusterConfig)
    GkeClusterConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GkeClusterConfig.newBuilder() to construct.
  private GkeClusterConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GkeClusterConfig() {
    gkeClusterTarget_ = "";
    nodePoolTarget_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GkeClusterConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.SharedProto
        .internal_static_google_cloud_dataproc_v1_GkeClusterConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.SharedProto
        .internal_static_google_cloud_dataproc_v1_GkeClusterConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.GkeClusterConfig.class,
            com.google.cloud.dataproc.v1.GkeClusterConfig.Builder.class);
  }

  public static final int GKE_CLUSTER_TARGET_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object gkeClusterTarget_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A target GKE cluster to deploy to. It must be in the same project
   * and region as the Dataproc cluster (the GKE cluster can be zonal or
   * regional). Format:
   * 'projects/{project}/locations/{location}/clusters/{cluster_id}'
   * </pre>
   *
   * <code>
   * string gke_cluster_target = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The gkeClusterTarget.
   */
  @java.lang.Override
  public java.lang.String getGkeClusterTarget() {
    java.lang.Object ref = gkeClusterTarget_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      gkeClusterTarget_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A target GKE cluster to deploy to. It must be in the same project
   * and region as the Dataproc cluster (the GKE cluster can be zonal or
   * regional). Format:
   * 'projects/{project}/locations/{location}/clusters/{cluster_id}'
   * </pre>
   *
   * <code>
   * string gke_cluster_target = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for gkeClusterTarget.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getGkeClusterTargetBytes() {
    java.lang.Object ref = gkeClusterTarget_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      gkeClusterTarget_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NODE_POOL_TARGET_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dataproc.v1.GkeNodePoolTarget> nodePoolTarget_;
  /**
   *
   *
   * <pre>
   * Optional. GKE node pools where workloads will be scheduled. At least one
   * node pool must be assigned the `DEFAULT`
   * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
   * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
   * `GkeNodePoolTarget`. Each role can be given to only one
   * `GkeNodePoolTarget`. All node pools must have the same location settings.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dataproc.v1.GkeNodePoolTarget> getNodePoolTargetList() {
    return nodePoolTarget_;
  }
  /**
   *
   *
   * <pre>
   * Optional. GKE node pools where workloads will be scheduled. At least one
   * node pool must be assigned the `DEFAULT`
   * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
   * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
   * `GkeNodePoolTarget`. Each role can be given to only one
   * `GkeNodePoolTarget`. All node pools must have the same location settings.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dataproc.v1.GkeNodePoolTargetOrBuilder>
      getNodePoolTargetOrBuilderList() {
    return nodePoolTarget_;
  }
  /**
   *
   *
   * <pre>
   * Optional. GKE node pools where workloads will be scheduled. At least one
   * node pool must be assigned the `DEFAULT`
   * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
   * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
   * `GkeNodePoolTarget`. Each role can be given to only one
   * `GkeNodePoolTarget`. All node pools must have the same location settings.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getNodePoolTargetCount() {
    return nodePoolTarget_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. GKE node pools where workloads will be scheduled. At least one
   * node pool must be assigned the `DEFAULT`
   * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
   * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
   * `GkeNodePoolTarget`. Each role can be given to only one
   * `GkeNodePoolTarget`. All node pools must have the same location settings.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.GkeNodePoolTarget getNodePoolTarget(int index) {
    return nodePoolTarget_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. GKE node pools where workloads will be scheduled. At least one
   * node pool must be assigned the `DEFAULT`
   * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
   * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
   * `GkeNodePoolTarget`. Each role can be given to only one
   * `GkeNodePoolTarget`. All node pools must have the same location settings.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.GkeNodePoolTargetOrBuilder getNodePoolTargetOrBuilder(
      int index) {
    return nodePoolTarget_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gkeClusterTarget_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, gkeClusterTarget_);
    }
    for (int i = 0; i < nodePoolTarget_.size(); i++) {
      output.writeMessage(3, nodePoolTarget_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(gkeClusterTarget_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, gkeClusterTarget_);
    }
    for (int i = 0; i < nodePoolTarget_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, nodePoolTarget_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.GkeClusterConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.GkeClusterConfig other =
        (com.google.cloud.dataproc.v1.GkeClusterConfig) obj;

    if (!getGkeClusterTarget().equals(other.getGkeClusterTarget())) return false;
    if (!getNodePoolTargetList().equals(other.getNodePoolTargetList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + GKE_CLUSTER_TARGET_FIELD_NUMBER;
    hash = (53 * hash) + getGkeClusterTarget().hashCode();
    if (getNodePoolTargetCount() > 0) {
      hash = (37 * hash) + NODE_POOL_TARGET_FIELD_NUMBER;
      hash = (53 * hash) + getNodePoolTargetList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.GkeClusterConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.GkeClusterConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GkeClusterConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.GkeClusterConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GkeClusterConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.GkeClusterConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GkeClusterConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.GkeClusterConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GkeClusterConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.GkeClusterConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.GkeClusterConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.GkeClusterConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.GkeClusterConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The cluster's GKE config.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.GkeClusterConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.GkeClusterConfig)
      com.google.cloud.dataproc.v1.GkeClusterConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeClusterConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeClusterConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.GkeClusterConfig.class,
              com.google.cloud.dataproc.v1.GkeClusterConfig.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.GkeClusterConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      gkeClusterTarget_ = "";
      if (nodePoolTargetBuilder_ == null) {
        nodePoolTarget_ = java.util.Collections.emptyList();
      } else {
        nodePoolTarget_ = null;
        nodePoolTargetBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_GkeClusterConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeClusterConfig getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.GkeClusterConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeClusterConfig build() {
      com.google.cloud.dataproc.v1.GkeClusterConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.GkeClusterConfig buildPartial() {
      com.google.cloud.dataproc.v1.GkeClusterConfig result =
          new com.google.cloud.dataproc.v1.GkeClusterConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dataproc.v1.GkeClusterConfig result) {
      if (nodePoolTargetBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          nodePoolTarget_ = java.util.Collections.unmodifiableList(nodePoolTarget_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.nodePoolTarget_ = nodePoolTarget_;
      } else {
        result.nodePoolTarget_ = nodePoolTargetBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.GkeClusterConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.gkeClusterTarget_ = gkeClusterTarget_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.GkeClusterConfig) {
        return mergeFrom((com.google.cloud.dataproc.v1.GkeClusterConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.GkeClusterConfig other) {
      if (other == com.google.cloud.dataproc.v1.GkeClusterConfig.getDefaultInstance()) return this;
      if (!other.getGkeClusterTarget().isEmpty()) {
        gkeClusterTarget_ = other.gkeClusterTarget_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (nodePoolTargetBuilder_ == null) {
        if (!other.nodePoolTarget_.isEmpty()) {
          if (nodePoolTarget_.isEmpty()) {
            nodePoolTarget_ = other.nodePoolTarget_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureNodePoolTargetIsMutable();
            nodePoolTarget_.addAll(other.nodePoolTarget_);
          }
          onChanged();
        }
      } else {
        if (!other.nodePoolTarget_.isEmpty()) {
          if (nodePoolTargetBuilder_.isEmpty()) {
            nodePoolTargetBuilder_.dispose();
            nodePoolTargetBuilder_ = null;
            nodePoolTarget_ = other.nodePoolTarget_;
            bitField0_ = (bitField0_ & ~0x00000002);
            nodePoolTargetBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNodePoolTargetFieldBuilder()
                    : null;
          } else {
            nodePoolTargetBuilder_.addAllMessages(other.nodePoolTarget_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                gkeClusterTarget_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.dataproc.v1.GkeNodePoolTarget m =
                    input.readMessage(
                        com.google.cloud.dataproc.v1.GkeNodePoolTarget.parser(), extensionRegistry);
                if (nodePoolTargetBuilder_ == null) {
                  ensureNodePoolTargetIsMutable();
                  nodePoolTarget_.add(m);
                } else {
                  nodePoolTargetBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object gkeClusterTarget_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A target GKE cluster to deploy to. It must be in the same project
     * and region as the Dataproc cluster (the GKE cluster can be zonal or
     * regional). Format:
     * 'projects/{project}/locations/{location}/clusters/{cluster_id}'
     * </pre>
     *
     * <code>
     * string gke_cluster_target = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The gkeClusterTarget.
     */
    public java.lang.String getGkeClusterTarget() {
      java.lang.Object ref = gkeClusterTarget_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        gkeClusterTarget_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A target GKE cluster to deploy to. It must be in the same project
     * and region as the Dataproc cluster (the GKE cluster can be zonal or
     * regional). Format:
     * 'projects/{project}/locations/{location}/clusters/{cluster_id}'
     * </pre>
     *
     * <code>
     * string gke_cluster_target = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for gkeClusterTarget.
     */
    public com.google.protobuf.ByteString getGkeClusterTargetBytes() {
      java.lang.Object ref = gkeClusterTarget_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        gkeClusterTarget_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A target GKE cluster to deploy to. It must be in the same project
     * and region as the Dataproc cluster (the GKE cluster can be zonal or
     * regional). Format:
     * 'projects/{project}/locations/{location}/clusters/{cluster_id}'
     * </pre>
     *
     * <code>
     * string gke_cluster_target = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The gkeClusterTarget to set.
     * @return This builder for chaining.
     */
    public Builder setGkeClusterTarget(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      gkeClusterTarget_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A target GKE cluster to deploy to. It must be in the same project
     * and region as the Dataproc cluster (the GKE cluster can be zonal or
     * regional). Format:
     * 'projects/{project}/locations/{location}/clusters/{cluster_id}'
     * </pre>
     *
     * <code>
     * string gke_cluster_target = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearGkeClusterTarget() {
      gkeClusterTarget_ = getDefaultInstance().getGkeClusterTarget();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A target GKE cluster to deploy to. It must be in the same project
     * and region as the Dataproc cluster (the GKE cluster can be zonal or
     * regional). Format:
     * 'projects/{project}/locations/{location}/clusters/{cluster_id}'
     * </pre>
     *
     * <code>
     * string gke_cluster_target = 2 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for gkeClusterTarget to set.
     * @return This builder for chaining.
     */
    public Builder setGkeClusterTargetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      gkeClusterTarget_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dataproc.v1.GkeNodePoolTarget> nodePoolTarget_ =
        java.util.Collections.emptyList();

    private void ensureNodePoolTargetIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        nodePoolTarget_ =
            new java.util.ArrayList<com.google.cloud.dataproc.v1.GkeNodePoolTarget>(
                nodePoolTarget_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.GkeNodePoolTarget,
            com.google.cloud.dataproc.v1.GkeNodePoolTarget.Builder,
            com.google.cloud.dataproc.v1.GkeNodePoolTargetOrBuilder>
        nodePoolTargetBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. GKE node pools where workloads will be scheduled. At least one
     * node pool must be assigned the `DEFAULT`
     * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
     * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
     * `GkeNodePoolTarget`. Each role can be given to only one
     * `GkeNodePoolTarget`. All node pools must have the same location settings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.GkeNodePoolTarget> getNodePoolTargetList() {
      if (nodePoolTargetBuilder_ == null) {
        return java.util.Collections.unmodifiableList(nodePoolTarget_);
      } else {
        return nodePoolTargetBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE node pools where workloads will be scheduled. At least one
     * node pool must be assigned the `DEFAULT`
     * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
     * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
     * `GkeNodePoolTarget`. Each role can be given to only one
     * `GkeNodePoolTarget`. All node pools must have the same location settings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getNodePoolTargetCount() {
      if (nodePoolTargetBuilder_ == null) {
        return nodePoolTarget_.size();
      } else {
        return nodePoolTargetBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE node pools where workloads will be scheduled. At least one
     * node pool must be assigned the `DEFAULT`
     * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
     * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
     * `GkeNodePoolTarget`. Each role can be given to only one
     * `GkeNodePoolTarget`. All node pools must have the same location settings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolTarget getNodePoolTarget(int index) {
      if (nodePoolTargetBuilder_ == null) {
        return nodePoolTarget_.get(index);
      } else {
        return nodePoolTargetBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE node pools where workloads will be scheduled. At least one
     * node pool must be assigned the `DEFAULT`
     * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
     * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
     * `GkeNodePoolTarget`. Each role can be given to only one
     * `GkeNodePoolTarget`. All node pools must have the same location settings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNodePoolTarget(
        int index, com.google.cloud.dataproc.v1.GkeNodePoolTarget value) {
      if (nodePoolTargetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodePoolTargetIsMutable();
        nodePoolTarget_.set(index, value);
        onChanged();
      } else {
        nodePoolTargetBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE node pools where workloads will be scheduled. At least one
     * node pool must be assigned the `DEFAULT`
     * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
     * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
     * `GkeNodePoolTarget`. Each role can be given to only one
     * `GkeNodePoolTarget`. All node pools must have the same location settings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNodePoolTarget(
        int index, com.google.cloud.dataproc.v1.GkeNodePoolTarget.Builder builderForValue) {
      if (nodePoolTargetBuilder_ == null) {
        ensureNodePoolTargetIsMutable();
        nodePoolTarget_.set(index, builderForValue.build());
        onChanged();
      } else {
        nodePoolTargetBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE node pools where workloads will be scheduled. At least one
     * node pool must be assigned the `DEFAULT`
     * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
     * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
     * `GkeNodePoolTarget`. Each role can be given to only one
     * `GkeNodePoolTarget`. All node pools must have the same location settings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNodePoolTarget(com.google.cloud.dataproc.v1.GkeNodePoolTarget value) {
      if (nodePoolTargetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodePoolTargetIsMutable();
        nodePoolTarget_.add(value);
        onChanged();
      } else {
        nodePoolTargetBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE node pools where workloads will be scheduled. At least one
     * node pool must be assigned the `DEFAULT`
     * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
     * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
     * `GkeNodePoolTarget`. Each role can be given to only one
     * `GkeNodePoolTarget`. All node pools must have the same location settings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNodePoolTarget(
        int index, com.google.cloud.dataproc.v1.GkeNodePoolTarget value) {
      if (nodePoolTargetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNodePoolTargetIsMutable();
        nodePoolTarget_.add(index, value);
        onChanged();
      } else {
        nodePoolTargetBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE node pools where workloads will be scheduled. At least one
     * node pool must be assigned the `DEFAULT`
     * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
     * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
     * `GkeNodePoolTarget`. Each role can be given to only one
     * `GkeNodePoolTarget`. All node pools must have the same location settings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNodePoolTarget(
        com.google.cloud.dataproc.v1.GkeNodePoolTarget.Builder builderForValue) {
      if (nodePoolTargetBuilder_ == null) {
        ensureNodePoolTargetIsMutable();
        nodePoolTarget_.add(builderForValue.build());
        onChanged();
      } else {
        nodePoolTargetBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE node pools where workloads will be scheduled. At least one
     * node pool must be assigned the `DEFAULT`
     * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
     * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
     * `GkeNodePoolTarget`. Each role can be given to only one
     * `GkeNodePoolTarget`. All node pools must have the same location settings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNodePoolTarget(
        int index, com.google.cloud.dataproc.v1.GkeNodePoolTarget.Builder builderForValue) {
      if (nodePoolTargetBuilder_ == null) {
        ensureNodePoolTargetIsMutable();
        nodePoolTarget_.add(index, builderForValue.build());
        onChanged();
      } else {
        nodePoolTargetBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE node pools where workloads will be scheduled. At least one
     * node pool must be assigned the `DEFAULT`
     * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
     * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
     * `GkeNodePoolTarget`. Each role can be given to only one
     * `GkeNodePoolTarget`. All node pools must have the same location settings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllNodePoolTarget(
        java.lang.Iterable<? extends com.google.cloud.dataproc.v1.GkeNodePoolTarget> values) {
      if (nodePoolTargetBuilder_ == null) {
        ensureNodePoolTargetIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, nodePoolTarget_);
        onChanged();
      } else {
        nodePoolTargetBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE node pools where workloads will be scheduled. At least one
     * node pool must be assigned the `DEFAULT`
     * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
     * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
     * `GkeNodePoolTarget`. Each role can be given to only one
     * `GkeNodePoolTarget`. All node pools must have the same location settings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearNodePoolTarget() {
      if (nodePoolTargetBuilder_ == null) {
        nodePoolTarget_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        nodePoolTargetBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE node pools where workloads will be scheduled. At least one
     * node pool must be assigned the `DEFAULT`
     * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
     * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
     * `GkeNodePoolTarget`. Each role can be given to only one
     * `GkeNodePoolTarget`. All node pools must have the same location settings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeNodePoolTarget(int index) {
      if (nodePoolTargetBuilder_ == null) {
        ensureNodePoolTargetIsMutable();
        nodePoolTarget_.remove(index);
        onChanged();
      } else {
        nodePoolTargetBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE node pools where workloads will be scheduled. At least one
     * node pool must be assigned the `DEFAULT`
     * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
     * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
     * `GkeNodePoolTarget`. Each role can be given to only one
     * `GkeNodePoolTarget`. All node pools must have the same location settings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolTarget.Builder getNodePoolTargetBuilder(
        int index) {
      return getNodePoolTargetFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE node pools where workloads will be scheduled. At least one
     * node pool must be assigned the `DEFAULT`
     * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
     * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
     * `GkeNodePoolTarget`. Each role can be given to only one
     * `GkeNodePoolTarget`. All node pools must have the same location settings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolTargetOrBuilder getNodePoolTargetOrBuilder(
        int index) {
      if (nodePoolTargetBuilder_ == null) {
        return nodePoolTarget_.get(index);
      } else {
        return nodePoolTargetBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE node pools where workloads will be scheduled. At least one
     * node pool must be assigned the `DEFAULT`
     * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
     * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
     * `GkeNodePoolTarget`. Each role can be given to only one
     * `GkeNodePoolTarget`. All node pools must have the same location settings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dataproc.v1.GkeNodePoolTargetOrBuilder>
        getNodePoolTargetOrBuilderList() {
      if (nodePoolTargetBuilder_ != null) {
        return nodePoolTargetBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(nodePoolTarget_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE node pools where workloads will be scheduled. At least one
     * node pool must be assigned the `DEFAULT`
     * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
     * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
     * `GkeNodePoolTarget`. Each role can be given to only one
     * `GkeNodePoolTarget`. All node pools must have the same location settings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolTarget.Builder addNodePoolTargetBuilder() {
      return getNodePoolTargetFieldBuilder()
          .addBuilder(com.google.cloud.dataproc.v1.GkeNodePoolTarget.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE node pools where workloads will be scheduled. At least one
     * node pool must be assigned the `DEFAULT`
     * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
     * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
     * `GkeNodePoolTarget`. Each role can be given to only one
     * `GkeNodePoolTarget`. All node pools must have the same location settings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.GkeNodePoolTarget.Builder addNodePoolTargetBuilder(
        int index) {
      return getNodePoolTargetFieldBuilder()
          .addBuilder(index, com.google.cloud.dataproc.v1.GkeNodePoolTarget.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. GKE node pools where workloads will be scheduled. At least one
     * node pool must be assigned the `DEFAULT`
     * [GkeNodePoolTarget.Role][google.cloud.dataproc.v1.GkeNodePoolTarget.Role].
     * If a `GkeNodePoolTarget` is not specified, Dataproc constructs a `DEFAULT`
     * `GkeNodePoolTarget`. Each role can be given to only one
     * `GkeNodePoolTarget`. All node pools must have the same location settings.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.GkeNodePoolTarget node_pool_target = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.GkeNodePoolTarget.Builder>
        getNodePoolTargetBuilderList() {
      return getNodePoolTargetFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.GkeNodePoolTarget,
            com.google.cloud.dataproc.v1.GkeNodePoolTarget.Builder,
            com.google.cloud.dataproc.v1.GkeNodePoolTargetOrBuilder>
        getNodePoolTargetFieldBuilder() {
      if (nodePoolTargetBuilder_ == null) {
        nodePoolTargetBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataproc.v1.GkeNodePoolTarget,
                com.google.cloud.dataproc.v1.GkeNodePoolTarget.Builder,
                com.google.cloud.dataproc.v1.GkeNodePoolTargetOrBuilder>(
                nodePoolTarget_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        nodePoolTarget_ = null;
      }
      return nodePoolTargetBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.GkeClusterConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.GkeClusterConfig)
  private static final com.google.cloud.dataproc.v1.GkeClusterConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.GkeClusterConfig();
  }

  public static com.google.cloud.dataproc.v1.GkeClusterConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GkeClusterConfig> PARSER =
      new com.google.protobuf.AbstractParser<GkeClusterConfig>() {
        @java.lang.Override
        public GkeClusterConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GkeClusterConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GkeClusterConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.GkeClusterConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
