/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/clusters.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * Instance flexibility Policy allowing a mixture of VM shapes and provisioning
 * models.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.InstanceFlexibilityPolicy}
 */
public final class InstanceFlexibilityPolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.InstanceFlexibilityPolicy)
    InstanceFlexibilityPolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InstanceFlexibilityPolicy.newBuilder() to construct.
  private InstanceFlexibilityPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InstanceFlexibilityPolicy() {
    instanceSelectionList_ = java.util.Collections.emptyList();
    instanceSelectionResults_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InstanceFlexibilityPolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_InstanceFlexibilityPolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_InstanceFlexibilityPolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.class,
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.Builder.class);
  }

  public interface ProvisioningModelMixOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The base capacity that will always use Standard VMs to avoid
     * risk of more preemption than the minimum capacity you need. Dataproc will
     * create only standard VMs until it reaches standard_capacity_base, then it
     * will start using standard_capacity_percent_above_base to mix Spot with
     * Standard VMs. eg. If 15 instances are requested and
     * standard_capacity_base is 5, Dataproc will create 5 standard VMs and then
     * start mixing spot and standard VMs for remaining 10 instances.
     * </pre>
     *
     * <code>optional int32 standard_capacity_base = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the standardCapacityBase field is set.
     */
    boolean hasStandardCapacityBase();
    /**
     *
     *
     * <pre>
     * Optional. The base capacity that will always use Standard VMs to avoid
     * risk of more preemption than the minimum capacity you need. Dataproc will
     * create only standard VMs until it reaches standard_capacity_base, then it
     * will start using standard_capacity_percent_above_base to mix Spot with
     * Standard VMs. eg. If 15 instances are requested and
     * standard_capacity_base is 5, Dataproc will create 5 standard VMs and then
     * start mixing spot and standard VMs for remaining 10 instances.
     * </pre>
     *
     * <code>optional int32 standard_capacity_base = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The standardCapacityBase.
     */
    int getStandardCapacityBase();

    /**
     *
     *
     * <pre>
     * Optional. The percentage of target capacity that should use Standard VM.
     * The remaining percentage will use Spot VMs. The percentage applies only
     * to the capacity above standard_capacity_base. eg. If 15 instances are
     * requested and standard_capacity_base is 5 and
     * standard_capacity_percent_above_base is 30, Dataproc will create 5
     * standard VMs and then start mixing spot and standard VMs for remaining 10
     * instances. The mix will be 30% standard and 70% spot.
     * </pre>
     *
     * <code>
     * optional int32 standard_capacity_percent_above_base = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the standardCapacityPercentAboveBase field is set.
     */
    boolean hasStandardCapacityPercentAboveBase();
    /**
     *
     *
     * <pre>
     * Optional. The percentage of target capacity that should use Standard VM.
     * The remaining percentage will use Spot VMs. The percentage applies only
     * to the capacity above standard_capacity_base. eg. If 15 instances are
     * requested and standard_capacity_base is 5 and
     * standard_capacity_percent_above_base is 30, Dataproc will create 5
     * standard VMs and then start mixing spot and standard VMs for remaining 10
     * instances. The mix will be 30% standard and 70% spot.
     * </pre>
     *
     * <code>
     * optional int32 standard_capacity_percent_above_base = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The standardCapacityPercentAboveBase.
     */
    int getStandardCapacityPercentAboveBase();
  }
  /**
   *
   *
   * <pre>
   * Defines how Dataproc should create VMs with a mixture of provisioning
   * models.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix}
   */
  public static final class ProvisioningModelMix extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix)
      ProvisioningModelMixOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ProvisioningModelMix.newBuilder() to construct.
    private ProvisioningModelMix(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ProvisioningModelMix() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ProvisioningModelMix();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_InstanceFlexibilityPolicy_ProvisioningModelMix_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_InstanceFlexibilityPolicy_ProvisioningModelMix_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix.class,
              com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix.Builder
                  .class);
    }

    private int bitField0_;
    public static final int STANDARD_CAPACITY_BASE_FIELD_NUMBER = 1;
    private int standardCapacityBase_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The base capacity that will always use Standard VMs to avoid
     * risk of more preemption than the minimum capacity you need. Dataproc will
     * create only standard VMs until it reaches standard_capacity_base, then it
     * will start using standard_capacity_percent_above_base to mix Spot with
     * Standard VMs. eg. If 15 instances are requested and
     * standard_capacity_base is 5, Dataproc will create 5 standard VMs and then
     * start mixing spot and standard VMs for remaining 10 instances.
     * </pre>
     *
     * <code>optional int32 standard_capacity_base = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the standardCapacityBase field is set.
     */
    @java.lang.Override
    public boolean hasStandardCapacityBase() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The base capacity that will always use Standard VMs to avoid
     * risk of more preemption than the minimum capacity you need. Dataproc will
     * create only standard VMs until it reaches standard_capacity_base, then it
     * will start using standard_capacity_percent_above_base to mix Spot with
     * Standard VMs. eg. If 15 instances are requested and
     * standard_capacity_base is 5, Dataproc will create 5 standard VMs and then
     * start mixing spot and standard VMs for remaining 10 instances.
     * </pre>
     *
     * <code>optional int32 standard_capacity_base = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The standardCapacityBase.
     */
    @java.lang.Override
    public int getStandardCapacityBase() {
      return standardCapacityBase_;
    }

    public static final int STANDARD_CAPACITY_PERCENT_ABOVE_BASE_FIELD_NUMBER = 2;
    private int standardCapacityPercentAboveBase_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The percentage of target capacity that should use Standard VM.
     * The remaining percentage will use Spot VMs. The percentage applies only
     * to the capacity above standard_capacity_base. eg. If 15 instances are
     * requested and standard_capacity_base is 5 and
     * standard_capacity_percent_above_base is 30, Dataproc will create 5
     * standard VMs and then start mixing spot and standard VMs for remaining 10
     * instances. The mix will be 30% standard and 70% spot.
     * </pre>
     *
     * <code>
     * optional int32 standard_capacity_percent_above_base = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the standardCapacityPercentAboveBase field is set.
     */
    @java.lang.Override
    public boolean hasStandardCapacityPercentAboveBase() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The percentage of target capacity that should use Standard VM.
     * The remaining percentage will use Spot VMs. The percentage applies only
     * to the capacity above standard_capacity_base. eg. If 15 instances are
     * requested and standard_capacity_base is 5 and
     * standard_capacity_percent_above_base is 30, Dataproc will create 5
     * standard VMs and then start mixing spot and standard VMs for remaining 10
     * instances. The mix will be 30% standard and 70% spot.
     * </pre>
     *
     * <code>
     * optional int32 standard_capacity_percent_above_base = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The standardCapacityPercentAboveBase.
     */
    @java.lang.Override
    public int getStandardCapacityPercentAboveBase() {
      return standardCapacityPercentAboveBase_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeInt32(1, standardCapacityBase_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeInt32(2, standardCapacityPercentAboveBase_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, standardCapacityBase_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(
                2, standardCapacityPercentAboveBase_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix)) {
        return super.equals(obj);
      }
      com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix other =
          (com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix) obj;

      if (hasStandardCapacityBase() != other.hasStandardCapacityBase()) return false;
      if (hasStandardCapacityBase()) {
        if (getStandardCapacityBase() != other.getStandardCapacityBase()) return false;
      }
      if (hasStandardCapacityPercentAboveBase() != other.hasStandardCapacityPercentAboveBase())
        return false;
      if (hasStandardCapacityPercentAboveBase()) {
        if (getStandardCapacityPercentAboveBase() != other.getStandardCapacityPercentAboveBase())
          return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStandardCapacityBase()) {
        hash = (37 * hash) + STANDARD_CAPACITY_BASE_FIELD_NUMBER;
        hash = (53 * hash) + getStandardCapacityBase();
      }
      if (hasStandardCapacityPercentAboveBase()) {
        hash = (37 * hash) + STANDARD_CAPACITY_PERCENT_ABOVE_BASE_FIELD_NUMBER;
        hash = (53 * hash) + getStandardCapacityPercentAboveBase();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Defines how Dataproc should create VMs with a mixture of provisioning
     * models.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix)
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMixOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataproc.v1.ClustersProto
            .internal_static_google_cloud_dataproc_v1_InstanceFlexibilityPolicy_ProvisioningModelMix_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataproc.v1.ClustersProto
            .internal_static_google_cloud_dataproc_v1_InstanceFlexibilityPolicy_ProvisioningModelMix_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix.class,
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        standardCapacityBase_ = 0;
        standardCapacityPercentAboveBase_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataproc.v1.ClustersProto
            .internal_static_google_cloud_dataproc_v1_InstanceFlexibilityPolicy_ProvisioningModelMix_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
          getDefaultInstanceForType() {
        return com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix build() {
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
          buildPartial() {
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix result =
            new com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.standardCapacityBase_ = standardCapacityBase_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.standardCapacityPercentAboveBase_ = standardCapacityPercentAboveBase_;
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix) {
          return mergeFrom(
              (com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix other) {
        if (other
            == com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
                .getDefaultInstance()) return this;
        if (other.hasStandardCapacityBase()) {
          setStandardCapacityBase(other.getStandardCapacityBase());
        }
        if (other.hasStandardCapacityPercentAboveBase()) {
          setStandardCapacityPercentAboveBase(other.getStandardCapacityPercentAboveBase());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  standardCapacityBase_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  standardCapacityPercentAboveBase_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int standardCapacityBase_;
      /**
       *
       *
       * <pre>
       * Optional. The base capacity that will always use Standard VMs to avoid
       * risk of more preemption than the minimum capacity you need. Dataproc will
       * create only standard VMs until it reaches standard_capacity_base, then it
       * will start using standard_capacity_percent_above_base to mix Spot with
       * Standard VMs. eg. If 15 instances are requested and
       * standard_capacity_base is 5, Dataproc will create 5 standard VMs and then
       * start mixing spot and standard VMs for remaining 10 instances.
       * </pre>
       *
       * <code>optional int32 standard_capacity_base = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the standardCapacityBase field is set.
       */
      @java.lang.Override
      public boolean hasStandardCapacityBase() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. The base capacity that will always use Standard VMs to avoid
       * risk of more preemption than the minimum capacity you need. Dataproc will
       * create only standard VMs until it reaches standard_capacity_base, then it
       * will start using standard_capacity_percent_above_base to mix Spot with
       * Standard VMs. eg. If 15 instances are requested and
       * standard_capacity_base is 5, Dataproc will create 5 standard VMs and then
       * start mixing spot and standard VMs for remaining 10 instances.
       * </pre>
       *
       * <code>optional int32 standard_capacity_base = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The standardCapacityBase.
       */
      @java.lang.Override
      public int getStandardCapacityBase() {
        return standardCapacityBase_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The base capacity that will always use Standard VMs to avoid
       * risk of more preemption than the minimum capacity you need. Dataproc will
       * create only standard VMs until it reaches standard_capacity_base, then it
       * will start using standard_capacity_percent_above_base to mix Spot with
       * Standard VMs. eg. If 15 instances are requested and
       * standard_capacity_base is 5, Dataproc will create 5 standard VMs and then
       * start mixing spot and standard VMs for remaining 10 instances.
       * </pre>
       *
       * <code>optional int32 standard_capacity_base = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The standardCapacityBase to set.
       * @return This builder for chaining.
       */
      public Builder setStandardCapacityBase(int value) {

        standardCapacityBase_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The base capacity that will always use Standard VMs to avoid
       * risk of more preemption than the minimum capacity you need. Dataproc will
       * create only standard VMs until it reaches standard_capacity_base, then it
       * will start using standard_capacity_percent_above_base to mix Spot with
       * Standard VMs. eg. If 15 instances are requested and
       * standard_capacity_base is 5, Dataproc will create 5 standard VMs and then
       * start mixing spot and standard VMs for remaining 10 instances.
       * </pre>
       *
       * <code>optional int32 standard_capacity_base = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStandardCapacityBase() {
        bitField0_ = (bitField0_ & ~0x00000001);
        standardCapacityBase_ = 0;
        onChanged();
        return this;
      }

      private int standardCapacityPercentAboveBase_;
      /**
       *
       *
       * <pre>
       * Optional. The percentage of target capacity that should use Standard VM.
       * The remaining percentage will use Spot VMs. The percentage applies only
       * to the capacity above standard_capacity_base. eg. If 15 instances are
       * requested and standard_capacity_base is 5 and
       * standard_capacity_percent_above_base is 30, Dataproc will create 5
       * standard VMs and then start mixing spot and standard VMs for remaining 10
       * instances. The mix will be 30% standard and 70% spot.
       * </pre>
       *
       * <code>
       * optional int32 standard_capacity_percent_above_base = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the standardCapacityPercentAboveBase field is set.
       */
      @java.lang.Override
      public boolean hasStandardCapacityPercentAboveBase() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. The percentage of target capacity that should use Standard VM.
       * The remaining percentage will use Spot VMs. The percentage applies only
       * to the capacity above standard_capacity_base. eg. If 15 instances are
       * requested and standard_capacity_base is 5 and
       * standard_capacity_percent_above_base is 30, Dataproc will create 5
       * standard VMs and then start mixing spot and standard VMs for remaining 10
       * instances. The mix will be 30% standard and 70% spot.
       * </pre>
       *
       * <code>
       * optional int32 standard_capacity_percent_above_base = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The standardCapacityPercentAboveBase.
       */
      @java.lang.Override
      public int getStandardCapacityPercentAboveBase() {
        return standardCapacityPercentAboveBase_;
      }
      /**
       *
       *
       * <pre>
       * Optional. The percentage of target capacity that should use Standard VM.
       * The remaining percentage will use Spot VMs. The percentage applies only
       * to the capacity above standard_capacity_base. eg. If 15 instances are
       * requested and standard_capacity_base is 5 and
       * standard_capacity_percent_above_base is 30, Dataproc will create 5
       * standard VMs and then start mixing spot and standard VMs for remaining 10
       * instances. The mix will be 30% standard and 70% spot.
       * </pre>
       *
       * <code>
       * optional int32 standard_capacity_percent_above_base = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The standardCapacityPercentAboveBase to set.
       * @return This builder for chaining.
       */
      public Builder setStandardCapacityPercentAboveBase(int value) {

        standardCapacityPercentAboveBase_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The percentage of target capacity that should use Standard VM.
       * The remaining percentage will use Spot VMs. The percentage applies only
       * to the capacity above standard_capacity_base. eg. If 15 instances are
       * requested and standard_capacity_base is 5 and
       * standard_capacity_percent_above_base is 30, Dataproc will create 5
       * standard VMs and then start mixing spot and standard VMs for remaining 10
       * instances. The mix will be 30% standard and 70% spot.
       * </pre>
       *
       * <code>
       * optional int32 standard_capacity_percent_above_base = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStandardCapacityPercentAboveBase() {
        bitField0_ = (bitField0_ & ~0x00000002);
        standardCapacityPercentAboveBase_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix)
    private static final com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix();
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ProvisioningModelMix> PARSER =
        new com.google.protobuf.AbstractParser<ProvisioningModelMix>() {
          @java.lang.Override
          public ProvisioningModelMix parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ProvisioningModelMix> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ProvisioningModelMix> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface InstanceSelectionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Full machine-type names, e.g. "n1-standard-16".
     * </pre>
     *
     * <code>repeated string machine_types = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the machineTypes.
     */
    java.util.List<java.lang.String> getMachineTypesList();
    /**
     *
     *
     * <pre>
     * Optional. Full machine-type names, e.g. "n1-standard-16".
     * </pre>
     *
     * <code>repeated string machine_types = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of machineTypes.
     */
    int getMachineTypesCount();
    /**
     *
     *
     * <pre>
     * Optional. Full machine-type names, e.g. "n1-standard-16".
     * </pre>
     *
     * <code>repeated string machine_types = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The machineTypes at the given index.
     */
    java.lang.String getMachineTypes(int index);
    /**
     *
     *
     * <pre>
     * Optional. Full machine-type names, e.g. "n1-standard-16".
     * </pre>
     *
     * <code>repeated string machine_types = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the machineTypes at the given index.
     */
    com.google.protobuf.ByteString getMachineTypesBytes(int index);

    /**
     *
     *
     * <pre>
     * Optional. Preference of this instance selection. Lower number means
     * higher preference. Dataproc will first try to create a VM based on the
     * machine-type with priority rank and fallback to next rank based on
     * availability. Machine types and instance selections with the same
     * priority have the same preference.
     * </pre>
     *
     * <code>int32 rank = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The rank.
     */
    int getRank();
  }
  /**
   *
   *
   * <pre>
   * Defines machines types and a rank to which the machines types belong.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection}
   */
  public static final class InstanceSelection extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection)
      InstanceSelectionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use InstanceSelection.newBuilder() to construct.
    private InstanceSelection(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InstanceSelection() {
      machineTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InstanceSelection();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_InstanceFlexibilityPolicy_InstanceSelection_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_InstanceFlexibilityPolicy_InstanceSelection_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection.class,
              com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection.Builder
                  .class);
    }

    public static final int MACHINE_TYPES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList machineTypes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Optional. Full machine-type names, e.g. "n1-standard-16".
     * </pre>
     *
     * <code>repeated string machine_types = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the machineTypes.
     */
    public com.google.protobuf.ProtocolStringList getMachineTypesList() {
      return machineTypes_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Full machine-type names, e.g. "n1-standard-16".
     * </pre>
     *
     * <code>repeated string machine_types = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of machineTypes.
     */
    public int getMachineTypesCount() {
      return machineTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Full machine-type names, e.g. "n1-standard-16".
     * </pre>
     *
     * <code>repeated string machine_types = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The machineTypes at the given index.
     */
    public java.lang.String getMachineTypes(int index) {
      return machineTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Full machine-type names, e.g. "n1-standard-16".
     * </pre>
     *
     * <code>repeated string machine_types = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the machineTypes at the given index.
     */
    public com.google.protobuf.ByteString getMachineTypesBytes(int index) {
      return machineTypes_.getByteString(index);
    }

    public static final int RANK_FIELD_NUMBER = 2;
    private int rank_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. Preference of this instance selection. Lower number means
     * higher preference. Dataproc will first try to create a VM based on the
     * machine-type with priority rank and fallback to next rank based on
     * availability. Machine types and instance selections with the same
     * priority have the same preference.
     * </pre>
     *
     * <code>int32 rank = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The rank.
     */
    @java.lang.Override
    public int getRank() {
      return rank_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < machineTypes_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, machineTypes_.getRaw(i));
      }
      if (rank_ != 0) {
        output.writeInt32(2, rank_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < machineTypes_.size(); i++) {
          dataSize += computeStringSizeNoTag(machineTypes_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getMachineTypesList().size();
      }
      if (rank_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, rank_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection)) {
        return super.equals(obj);
      }
      com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection other =
          (com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection) obj;

      if (!getMachineTypesList().equals(other.getMachineTypesList())) return false;
      if (getRank() != other.getRank()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getMachineTypesCount() > 0) {
        hash = (37 * hash) + MACHINE_TYPES_FIELD_NUMBER;
        hash = (53 * hash) + getMachineTypesList().hashCode();
      }
      hash = (37 * hash) + RANK_FIELD_NUMBER;
      hash = (53 * hash) + getRank();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Defines machines types and a rank to which the machines types belong.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection)
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataproc.v1.ClustersProto
            .internal_static_google_cloud_dataproc_v1_InstanceFlexibilityPolicy_InstanceSelection_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataproc.v1.ClustersProto
            .internal_static_google_cloud_dataproc_v1_InstanceFlexibilityPolicy_InstanceSelection_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection.class,
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        machineTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        rank_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataproc.v1.ClustersProto
            .internal_static_google_cloud_dataproc_v1_InstanceFlexibilityPolicy_InstanceSelection_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
          getDefaultInstanceForType() {
        return com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection build() {
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
          buildPartial() {
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection result =
            new com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          machineTypes_.makeImmutable();
          result.machineTypes_ = machineTypes_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.rank_ = rank_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection) {
          return mergeFrom(
              (com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection other) {
        if (other
            == com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
                .getDefaultInstance()) return this;
        if (!other.machineTypes_.isEmpty()) {
          if (machineTypes_.isEmpty()) {
            machineTypes_ = other.machineTypes_;
            bitField0_ |= 0x00000001;
          } else {
            ensureMachineTypesIsMutable();
            machineTypes_.addAll(other.machineTypes_);
          }
          onChanged();
        }
        if (other.getRank() != 0) {
          setRank(other.getRank());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureMachineTypesIsMutable();
                  machineTypes_.add(s);
                  break;
                } // case 10
              case 16:
                {
                  rank_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList machineTypes_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureMachineTypesIsMutable() {
        if (!machineTypes_.isModifiable()) {
          machineTypes_ = new com.google.protobuf.LazyStringArrayList(machineTypes_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Optional. Full machine-type names, e.g. "n1-standard-16".
       * </pre>
       *
       * <code>repeated string machine_types = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the machineTypes.
       */
      public com.google.protobuf.ProtocolStringList getMachineTypesList() {
        machineTypes_.makeImmutable();
        return machineTypes_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Full machine-type names, e.g. "n1-standard-16".
       * </pre>
       *
       * <code>repeated string machine_types = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of machineTypes.
       */
      public int getMachineTypesCount() {
        return machineTypes_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. Full machine-type names, e.g. "n1-standard-16".
       * </pre>
       *
       * <code>repeated string machine_types = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The machineTypes at the given index.
       */
      public java.lang.String getMachineTypes(int index) {
        return machineTypes_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Full machine-type names, e.g. "n1-standard-16".
       * </pre>
       *
       * <code>repeated string machine_types = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the machineTypes at the given index.
       */
      public com.google.protobuf.ByteString getMachineTypesBytes(int index) {
        return machineTypes_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. Full machine-type names, e.g. "n1-standard-16".
       * </pre>
       *
       * <code>repeated string machine_types = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The machineTypes to set.
       * @return This builder for chaining.
       */
      public Builder setMachineTypes(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMachineTypesIsMutable();
        machineTypes_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Full machine-type names, e.g. "n1-standard-16".
       * </pre>
       *
       * <code>repeated string machine_types = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The machineTypes to add.
       * @return This builder for chaining.
       */
      public Builder addMachineTypes(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMachineTypesIsMutable();
        machineTypes_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Full machine-type names, e.g. "n1-standard-16".
       * </pre>
       *
       * <code>repeated string machine_types = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The machineTypes to add.
       * @return This builder for chaining.
       */
      public Builder addAllMachineTypes(java.lang.Iterable<java.lang.String> values) {
        ensureMachineTypesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, machineTypes_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Full machine-type names, e.g. "n1-standard-16".
       * </pre>
       *
       * <code>repeated string machine_types = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMachineTypes() {
        machineTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Full machine-type names, e.g. "n1-standard-16".
       * </pre>
       *
       * <code>repeated string machine_types = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes of the machineTypes to add.
       * @return This builder for chaining.
       */
      public Builder addMachineTypesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureMachineTypesIsMutable();
        machineTypes_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int rank_;
      /**
       *
       *
       * <pre>
       * Optional. Preference of this instance selection. Lower number means
       * higher preference. Dataproc will first try to create a VM based on the
       * machine-type with priority rank and fallback to next rank based on
       * availability. Machine types and instance selections with the same
       * priority have the same preference.
       * </pre>
       *
       * <code>int32 rank = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The rank.
       */
      @java.lang.Override
      public int getRank() {
        return rank_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Preference of this instance selection. Lower number means
       * higher preference. Dataproc will first try to create a VM based on the
       * machine-type with priority rank and fallback to next rank based on
       * availability. Machine types and instance selections with the same
       * priority have the same preference.
       * </pre>
       *
       * <code>int32 rank = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The rank to set.
       * @return This builder for chaining.
       */
      public Builder setRank(int value) {

        rank_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Preference of this instance selection. Lower number means
       * higher preference. Dataproc will first try to create a VM based on the
       * machine-type with priority rank and fallback to next rank based on
       * availability. Machine types and instance selections with the same
       * priority have the same preference.
       * </pre>
       *
       * <code>int32 rank = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRank() {
        bitField0_ = (bitField0_ & ~0x00000002);
        rank_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection)
    private static final com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection();
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InstanceSelection> PARSER =
        new com.google.protobuf.AbstractParser<InstanceSelection>() {
          @java.lang.Override
          public InstanceSelection parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InstanceSelection> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InstanceSelection> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface InstanceSelectionResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. Full machine-type names, e.g. "n1-standard-16".
     * </pre>
     *
     * <code>optional string machine_type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the machineType field is set.
     */
    boolean hasMachineType();
    /**
     *
     *
     * <pre>
     * Output only. Full machine-type names, e.g. "n1-standard-16".
     * </pre>
     *
     * <code>optional string machine_type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The machineType.
     */
    java.lang.String getMachineType();
    /**
     *
     *
     * <pre>
     * Output only. Full machine-type names, e.g. "n1-standard-16".
     * </pre>
     *
     * <code>optional string machine_type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for machineType.
     */
    com.google.protobuf.ByteString getMachineTypeBytes();

    /**
     *
     *
     * <pre>
     * Output only. Number of VM provisioned with the machine_type.
     * </pre>
     *
     * <code>optional int32 vm_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the vmCount field is set.
     */
    boolean hasVmCount();
    /**
     *
     *
     * <pre>
     * Output only. Number of VM provisioned with the machine_type.
     * </pre>
     *
     * <code>optional int32 vm_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The vmCount.
     */
    int getVmCount();
  }
  /**
   *
   *
   * <pre>
   * Defines a mapping from machine types to the number of VMs that are created
   * with each machine type.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult}
   */
  public static final class InstanceSelectionResult extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult)
      InstanceSelectionResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use InstanceSelectionResult.newBuilder() to construct.
    private InstanceSelectionResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InstanceSelectionResult() {
      machineType_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InstanceSelectionResult();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_InstanceFlexibilityPolicy_InstanceSelectionResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_InstanceFlexibilityPolicy_InstanceSelectionResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult.class,
              com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult.Builder
                  .class);
    }

    private int bitField0_;
    public static final int MACHINE_TYPE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object machineType_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Full machine-type names, e.g. "n1-standard-16".
     * </pre>
     *
     * <code>optional string machine_type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the machineType field is set.
     */
    @java.lang.Override
    public boolean hasMachineType() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Full machine-type names, e.g. "n1-standard-16".
     * </pre>
     *
     * <code>optional string machine_type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The machineType.
     */
    @java.lang.Override
    public java.lang.String getMachineType() {
      java.lang.Object ref = machineType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        machineType_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Full machine-type names, e.g. "n1-standard-16".
     * </pre>
     *
     * <code>optional string machine_type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for machineType.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMachineTypeBytes() {
      java.lang.Object ref = machineType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        machineType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VM_COUNT_FIELD_NUMBER = 2;
    private int vmCount_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Number of VM provisioned with the machine_type.
     * </pre>
     *
     * <code>optional int32 vm_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the vmCount field is set.
     */
    @java.lang.Override
    public boolean hasVmCount() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Number of VM provisioned with the machine_type.
     * </pre>
     *
     * <code>optional int32 vm_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The vmCount.
     */
    @java.lang.Override
    public int getVmCount() {
      return vmCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, machineType_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeInt32(2, vmCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, machineType_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, vmCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult)) {
        return super.equals(obj);
      }
      com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult other =
          (com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult) obj;

      if (hasMachineType() != other.hasMachineType()) return false;
      if (hasMachineType()) {
        if (!getMachineType().equals(other.getMachineType())) return false;
      }
      if (hasVmCount() != other.hasVmCount()) return false;
      if (hasVmCount()) {
        if (getVmCount() != other.getVmCount()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMachineType()) {
        hash = (37 * hash) + MACHINE_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getMachineType().hashCode();
      }
      if (hasVmCount()) {
        hash = (37 * hash) + VM_COUNT_FIELD_NUMBER;
        hash = (53 * hash) + getVmCount();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Defines a mapping from machine types to the number of VMs that are created
     * with each machine type.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult)
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataproc.v1.ClustersProto
            .internal_static_google_cloud_dataproc_v1_InstanceFlexibilityPolicy_InstanceSelectionResult_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataproc.v1.ClustersProto
            .internal_static_google_cloud_dataproc_v1_InstanceFlexibilityPolicy_InstanceSelectionResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
                    .class,
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        machineType_ = "";
        vmCount_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataproc.v1.ClustersProto
            .internal_static_google_cloud_dataproc_v1_InstanceFlexibilityPolicy_InstanceSelectionResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
          getDefaultInstanceForType() {
        return com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
          build() {
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
          buildPartial() {
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult result =
            new com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.machineType_ = machineType_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.vmCount_ = vmCount_;
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult) {
          return mergeFrom(
              (com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult other) {
        if (other
            == com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
                .getDefaultInstance()) return this;
        if (other.hasMachineType()) {
          machineType_ = other.machineType_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasVmCount()) {
          setVmCount(other.getVmCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  machineType_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  vmCount_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object machineType_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Full machine-type names, e.g. "n1-standard-16".
       * </pre>
       *
       * <code>optional string machine_type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return Whether the machineType field is set.
       */
      public boolean hasMachineType() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. Full machine-type names, e.g. "n1-standard-16".
       * </pre>
       *
       * <code>optional string machine_type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The machineType.
       */
      public java.lang.String getMachineType() {
        java.lang.Object ref = machineType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          machineType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Full machine-type names, e.g. "n1-standard-16".
       * </pre>
       *
       * <code>optional string machine_type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for machineType.
       */
      public com.google.protobuf.ByteString getMachineTypeBytes() {
        java.lang.Object ref = machineType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          machineType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Full machine-type names, e.g. "n1-standard-16".
       * </pre>
       *
       * <code>optional string machine_type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The machineType to set.
       * @return This builder for chaining.
       */
      public Builder setMachineType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        machineType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Full machine-type names, e.g. "n1-standard-16".
       * </pre>
       *
       * <code>optional string machine_type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMachineType() {
        machineType_ = getDefaultInstance().getMachineType();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Full machine-type names, e.g. "n1-standard-16".
       * </pre>
       *
       * <code>optional string machine_type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for machineType to set.
       * @return This builder for chaining.
       */
      public Builder setMachineTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        machineType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int vmCount_;
      /**
       *
       *
       * <pre>
       * Output only. Number of VM provisioned with the machine_type.
       * </pre>
       *
       * <code>optional int32 vm_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return Whether the vmCount field is set.
       */
      @java.lang.Override
      public boolean hasVmCount() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. Number of VM provisioned with the machine_type.
       * </pre>
       *
       * <code>optional int32 vm_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The vmCount.
       */
      @java.lang.Override
      public int getVmCount() {
        return vmCount_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Number of VM provisioned with the machine_type.
       * </pre>
       *
       * <code>optional int32 vm_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The vmCount to set.
       * @return This builder for chaining.
       */
      public Builder setVmCount(int value) {

        vmCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Number of VM provisioned with the machine_type.
       * </pre>
       *
       * <code>optional int32 vm_count = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearVmCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        vmCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult)
    private static final com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy
            .InstanceSelectionResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult();
    }

    public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InstanceSelectionResult> PARSER =
        new com.google.protobuf.AbstractParser<InstanceSelectionResult>() {
          @java.lang.Override
          public InstanceSelectionResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InstanceSelectionResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InstanceSelectionResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int PROVISIONING_MODEL_MIX_FIELD_NUMBER = 1;
  private com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
      provisioningModelMix_;
  /**
   *
   *
   * <pre>
   * Optional. Defines how the Group selects the provisioning model to ensure
   * required reliability.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix provisioning_model_mix = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the provisioningModelMix field is set.
   */
  @java.lang.Override
  public boolean hasProvisioningModelMix() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Defines how the Group selects the provisioning model to ensure
   * required reliability.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix provisioning_model_mix = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The provisioningModelMix.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
      getProvisioningModelMix() {
    return provisioningModelMix_ == null
        ? com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
            .getDefaultInstance()
        : provisioningModelMix_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Defines how the Group selects the provisioning model to ensure
   * required reliability.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix provisioning_model_mix = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMixOrBuilder
      getProvisioningModelMixOrBuilder() {
    return provisioningModelMix_ == null
        ? com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
            .getDefaultInstance()
        : provisioningModelMix_;
  }

  public static final int INSTANCE_SELECTION_LIST_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection>
      instanceSelectionList_;
  /**
   *
   *
   * <pre>
   * Optional. List of instance selection options that the group will use when
   * creating new VMs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection>
      getInstanceSelectionListList() {
    return instanceSelectionList_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of instance selection options that the group will use when
   * creating new VMs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionOrBuilder>
      getInstanceSelectionListOrBuilderList() {
    return instanceSelectionList_;
  }
  /**
   *
   *
   * <pre>
   * Optional. List of instance selection options that the group will use when
   * creating new VMs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getInstanceSelectionListCount() {
    return instanceSelectionList_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. List of instance selection options that the group will use when
   * creating new VMs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
      getInstanceSelectionList(int index) {
    return instanceSelectionList_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. List of instance selection options that the group will use when
   * creating new VMs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionOrBuilder
      getInstanceSelectionListOrBuilder(int index) {
    return instanceSelectionList_.get(index);
  }

  public static final int INSTANCE_SELECTION_RESULTS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult>
      instanceSelectionResults_;
  /**
   *
   *
   * <pre>
   * Output only. A list of instance selection results in the group.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult>
      getInstanceSelectionResultsList() {
    return instanceSelectionResults_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of instance selection results in the group.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy
                  .InstanceSelectionResultOrBuilder>
      getInstanceSelectionResultsOrBuilderList() {
    return instanceSelectionResults_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of instance selection results in the group.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getInstanceSelectionResultsCount() {
    return instanceSelectionResults_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of instance selection results in the group.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
      getInstanceSelectionResults(int index) {
    return instanceSelectionResults_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of instance selection results in the group.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResultOrBuilder
      getInstanceSelectionResultsOrBuilder(int index) {
    return instanceSelectionResults_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getProvisioningModelMix());
    }
    for (int i = 0; i < instanceSelectionList_.size(); i++) {
      output.writeMessage(2, instanceSelectionList_.get(i));
    }
    for (int i = 0; i < instanceSelectionResults_.size(); i++) {
      output.writeMessage(3, instanceSelectionResults_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, getProvisioningModelMix());
    }
    for (int i = 0; i < instanceSelectionList_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, instanceSelectionList_.get(i));
    }
    for (int i = 0; i < instanceSelectionResults_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, instanceSelectionResults_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy other =
        (com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy) obj;

    if (hasProvisioningModelMix() != other.hasProvisioningModelMix()) return false;
    if (hasProvisioningModelMix()) {
      if (!getProvisioningModelMix().equals(other.getProvisioningModelMix())) return false;
    }
    if (!getInstanceSelectionListList().equals(other.getInstanceSelectionListList())) return false;
    if (!getInstanceSelectionResultsList().equals(other.getInstanceSelectionResultsList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasProvisioningModelMix()) {
      hash = (37 * hash) + PROVISIONING_MODEL_MIX_FIELD_NUMBER;
      hash = (53 * hash) + getProvisioningModelMix().hashCode();
    }
    if (getInstanceSelectionListCount() > 0) {
      hash = (37 * hash) + INSTANCE_SELECTION_LIST_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceSelectionListList().hashCode();
    }
    if (getInstanceSelectionResultsCount() > 0) {
      hash = (37 * hash) + INSTANCE_SELECTION_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getInstanceSelectionResultsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Instance flexibility Policy allowing a mixture of VM shapes and provisioning
   * models.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.InstanceFlexibilityPolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.InstanceFlexibilityPolicy)
      com.google.cloud.dataproc.v1.InstanceFlexibilityPolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_InstanceFlexibilityPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_InstanceFlexibilityPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.class,
              com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getProvisioningModelMixFieldBuilder();
        getInstanceSelectionListFieldBuilder();
        getInstanceSelectionResultsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      provisioningModelMix_ = null;
      if (provisioningModelMixBuilder_ != null) {
        provisioningModelMixBuilder_.dispose();
        provisioningModelMixBuilder_ = null;
      }
      if (instanceSelectionListBuilder_ == null) {
        instanceSelectionList_ = java.util.Collections.emptyList();
      } else {
        instanceSelectionList_ = null;
        instanceSelectionListBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (instanceSelectionResultsBuilder_ == null) {
        instanceSelectionResults_ = java.util.Collections.emptyList();
      } else {
        instanceSelectionResults_ = null;
        instanceSelectionResultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_InstanceFlexibilityPolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy build() {
      com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy buildPartial() {
      com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy result =
          new com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy result) {
      if (instanceSelectionListBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          instanceSelectionList_ = java.util.Collections.unmodifiableList(instanceSelectionList_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.instanceSelectionList_ = instanceSelectionList_;
      } else {
        result.instanceSelectionList_ = instanceSelectionListBuilder_.build();
      }
      if (instanceSelectionResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          instanceSelectionResults_ =
              java.util.Collections.unmodifiableList(instanceSelectionResults_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.instanceSelectionResults_ = instanceSelectionResults_;
      } else {
        result.instanceSelectionResults_ = instanceSelectionResultsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.provisioningModelMix_ =
            provisioningModelMixBuilder_ == null
                ? provisioningModelMix_
                : provisioningModelMixBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy) {
        return mergeFrom((com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy other) {
      if (other == com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.getDefaultInstance())
        return this;
      if (other.hasProvisioningModelMix()) {
        mergeProvisioningModelMix(other.getProvisioningModelMix());
      }
      if (instanceSelectionListBuilder_ == null) {
        if (!other.instanceSelectionList_.isEmpty()) {
          if (instanceSelectionList_.isEmpty()) {
            instanceSelectionList_ = other.instanceSelectionList_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureInstanceSelectionListIsMutable();
            instanceSelectionList_.addAll(other.instanceSelectionList_);
          }
          onChanged();
        }
      } else {
        if (!other.instanceSelectionList_.isEmpty()) {
          if (instanceSelectionListBuilder_.isEmpty()) {
            instanceSelectionListBuilder_.dispose();
            instanceSelectionListBuilder_ = null;
            instanceSelectionList_ = other.instanceSelectionList_;
            bitField0_ = (bitField0_ & ~0x00000002);
            instanceSelectionListBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInstanceSelectionListFieldBuilder()
                    : null;
          } else {
            instanceSelectionListBuilder_.addAllMessages(other.instanceSelectionList_);
          }
        }
      }
      if (instanceSelectionResultsBuilder_ == null) {
        if (!other.instanceSelectionResults_.isEmpty()) {
          if (instanceSelectionResults_.isEmpty()) {
            instanceSelectionResults_ = other.instanceSelectionResults_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureInstanceSelectionResultsIsMutable();
            instanceSelectionResults_.addAll(other.instanceSelectionResults_);
          }
          onChanged();
        }
      } else {
        if (!other.instanceSelectionResults_.isEmpty()) {
          if (instanceSelectionResultsBuilder_.isEmpty()) {
            instanceSelectionResultsBuilder_.dispose();
            instanceSelectionResultsBuilder_ = null;
            instanceSelectionResults_ = other.instanceSelectionResults_;
            bitField0_ = (bitField0_ & ~0x00000004);
            instanceSelectionResultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInstanceSelectionResultsFieldBuilder()
                    : null;
          } else {
            instanceSelectionResultsBuilder_.addAllMessages(other.instanceSelectionResults_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getProvisioningModelMixFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection m =
                    input.readMessage(
                        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
                            .parser(),
                        extensionRegistry);
                if (instanceSelectionListBuilder_ == null) {
                  ensureInstanceSelectionListIsMutable();
                  instanceSelectionList_.add(m);
                } else {
                  instanceSelectionListBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult m =
                    input.readMessage(
                        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy
                            .InstanceSelectionResult.parser(),
                        extensionRegistry);
                if (instanceSelectionResultsBuilder_ == null) {
                  ensureInstanceSelectionResultsIsMutable();
                  instanceSelectionResults_.add(m);
                } else {
                  instanceSelectionResultsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
        provisioningModelMix_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix,
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix.Builder,
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMixOrBuilder>
        provisioningModelMixBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Defines how the Group selects the provisioning model to ensure
     * required reliability.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix provisioning_model_mix = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the provisioningModelMix field is set.
     */
    public boolean hasProvisioningModelMix() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines how the Group selects the provisioning model to ensure
     * required reliability.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix provisioning_model_mix = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The provisioningModelMix.
     */
    public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
        getProvisioningModelMix() {
      if (provisioningModelMixBuilder_ == null) {
        return provisioningModelMix_ == null
            ? com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
                .getDefaultInstance()
            : provisioningModelMix_;
      } else {
        return provisioningModelMixBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines how the Group selects the provisioning model to ensure
     * required reliability.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix provisioning_model_mix = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setProvisioningModelMix(
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix value) {
      if (provisioningModelMixBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        provisioningModelMix_ = value;
      } else {
        provisioningModelMixBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines how the Group selects the provisioning model to ensure
     * required reliability.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix provisioning_model_mix = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setProvisioningModelMix(
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix.Builder
            builderForValue) {
      if (provisioningModelMixBuilder_ == null) {
        provisioningModelMix_ = builderForValue.build();
      } else {
        provisioningModelMixBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines how the Group selects the provisioning model to ensure
     * required reliability.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix provisioning_model_mix = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeProvisioningModelMix(
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix value) {
      if (provisioningModelMixBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && provisioningModelMix_ != null
            && provisioningModelMix_
                != com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
                    .getDefaultInstance()) {
          getProvisioningModelMixBuilder().mergeFrom(value);
        } else {
          provisioningModelMix_ = value;
        }
      } else {
        provisioningModelMixBuilder_.mergeFrom(value);
      }
      if (provisioningModelMix_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines how the Group selects the provisioning model to ensure
     * required reliability.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix provisioning_model_mix = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearProvisioningModelMix() {
      bitField0_ = (bitField0_ & ~0x00000001);
      provisioningModelMix_ = null;
      if (provisioningModelMixBuilder_ != null) {
        provisioningModelMixBuilder_.dispose();
        provisioningModelMixBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines how the Group selects the provisioning model to ensure
     * required reliability.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix provisioning_model_mix = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix.Builder
        getProvisioningModelMixBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getProvisioningModelMixFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines how the Group selects the provisioning model to ensure
     * required reliability.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix provisioning_model_mix = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMixOrBuilder
        getProvisioningModelMixOrBuilder() {
      if (provisioningModelMixBuilder_ != null) {
        return provisioningModelMixBuilder_.getMessageOrBuilder();
      } else {
        return provisioningModelMix_ == null
            ? com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix
                .getDefaultInstance()
            : provisioningModelMix_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Defines how the Group selects the provisioning model to ensure
     * required reliability.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix provisioning_model_mix = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix,
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix.Builder,
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMixOrBuilder>
        getProvisioningModelMixFieldBuilder() {
      if (provisioningModelMixBuilder_ == null) {
        provisioningModelMixBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix,
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.ProvisioningModelMix.Builder,
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy
                    .ProvisioningModelMixOrBuilder>(
                getProvisioningModelMix(), getParentForChildren(), isClean());
        provisioningModelMix_ = null;
      }
      return provisioningModelMixBuilder_;
    }

    private java.util.List<com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection>
        instanceSelectionList_ = java.util.Collections.emptyList();

    private void ensureInstanceSelectionListIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        instanceSelectionList_ =
            new java.util.ArrayList<
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection>(
                instanceSelectionList_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection,
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection.Builder,
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionOrBuilder>
        instanceSelectionListBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. List of instance selection options that the group will use when
     * creating new VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection>
        getInstanceSelectionListList() {
      if (instanceSelectionListBuilder_ == null) {
        return java.util.Collections.unmodifiableList(instanceSelectionList_);
      } else {
        return instanceSelectionListBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of instance selection options that the group will use when
     * creating new VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getInstanceSelectionListCount() {
      if (instanceSelectionListBuilder_ == null) {
        return instanceSelectionList_.size();
      } else {
        return instanceSelectionListBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of instance selection options that the group will use when
     * creating new VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
        getInstanceSelectionList(int index) {
      if (instanceSelectionListBuilder_ == null) {
        return instanceSelectionList_.get(index);
      } else {
        return instanceSelectionListBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of instance selection options that the group will use when
     * creating new VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInstanceSelectionList(
        int index, com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection value) {
      if (instanceSelectionListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstanceSelectionListIsMutable();
        instanceSelectionList_.set(index, value);
        onChanged();
      } else {
        instanceSelectionListBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of instance selection options that the group will use when
     * creating new VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setInstanceSelectionList(
        int index,
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection.Builder
            builderForValue) {
      if (instanceSelectionListBuilder_ == null) {
        ensureInstanceSelectionListIsMutable();
        instanceSelectionList_.set(index, builderForValue.build());
        onChanged();
      } else {
        instanceSelectionListBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of instance selection options that the group will use when
     * creating new VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addInstanceSelectionList(
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection value) {
      if (instanceSelectionListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstanceSelectionListIsMutable();
        instanceSelectionList_.add(value);
        onChanged();
      } else {
        instanceSelectionListBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of instance selection options that the group will use when
     * creating new VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addInstanceSelectionList(
        int index, com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection value) {
      if (instanceSelectionListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstanceSelectionListIsMutable();
        instanceSelectionList_.add(index, value);
        onChanged();
      } else {
        instanceSelectionListBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of instance selection options that the group will use when
     * creating new VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addInstanceSelectionList(
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection.Builder
            builderForValue) {
      if (instanceSelectionListBuilder_ == null) {
        ensureInstanceSelectionListIsMutable();
        instanceSelectionList_.add(builderForValue.build());
        onChanged();
      } else {
        instanceSelectionListBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of instance selection options that the group will use when
     * creating new VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addInstanceSelectionList(
        int index,
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection.Builder
            builderForValue) {
      if (instanceSelectionListBuilder_ == null) {
        ensureInstanceSelectionListIsMutable();
        instanceSelectionList_.add(index, builderForValue.build());
        onChanged();
      } else {
        instanceSelectionListBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of instance selection options that the group will use when
     * creating new VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllInstanceSelectionList(
        java.lang.Iterable<
                ? extends com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection>
            values) {
      if (instanceSelectionListBuilder_ == null) {
        ensureInstanceSelectionListIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, instanceSelectionList_);
        onChanged();
      } else {
        instanceSelectionListBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of instance selection options that the group will use when
     * creating new VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearInstanceSelectionList() {
      if (instanceSelectionListBuilder_ == null) {
        instanceSelectionList_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        instanceSelectionListBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of instance selection options that the group will use when
     * creating new VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeInstanceSelectionList(int index) {
      if (instanceSelectionListBuilder_ == null) {
        ensureInstanceSelectionListIsMutable();
        instanceSelectionList_.remove(index);
        onChanged();
      } else {
        instanceSelectionListBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. List of instance selection options that the group will use when
     * creating new VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection.Builder
        getInstanceSelectionListBuilder(int index) {
      return getInstanceSelectionListFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. List of instance selection options that the group will use when
     * creating new VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionOrBuilder
        getInstanceSelectionListOrBuilder(int index) {
      if (instanceSelectionListBuilder_ == null) {
        return instanceSelectionList_.get(index);
      } else {
        return instanceSelectionListBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of instance selection options that the group will use when
     * creating new VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionOrBuilder>
        getInstanceSelectionListOrBuilderList() {
      if (instanceSelectionListBuilder_ != null) {
        return instanceSelectionListBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(instanceSelectionList_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. List of instance selection options that the group will use when
     * creating new VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection.Builder
        addInstanceSelectionListBuilder() {
      return getInstanceSelectionListFieldBuilder()
          .addBuilder(
              com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of instance selection options that the group will use when
     * creating new VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection.Builder
        addInstanceSelectionListBuilder(int index) {
      return getInstanceSelectionListFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. List of instance selection options that the group will use when
     * creating new VMs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection instance_selection_list = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection.Builder>
        getInstanceSelectionListBuilderList() {
      return getInstanceSelectionListFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection,
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection.Builder,
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionOrBuilder>
        getInstanceSelectionListFieldBuilder() {
      if (instanceSelectionListBuilder_ == null) {
        instanceSelectionListBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection,
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelection.Builder,
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionOrBuilder>(
                instanceSelectionList_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        instanceSelectionList_ = null;
      }
      return instanceSelectionListBuilder_;
    }

    private java.util.List<
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult>
        instanceSelectionResults_ = java.util.Collections.emptyList();

    private void ensureInstanceSelectionResultsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        instanceSelectionResults_ =
            new java.util.ArrayList<
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult>(
                instanceSelectionResults_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult,
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult.Builder,
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResultOrBuilder>
        instanceSelectionResultsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. A list of instance selection results in the group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult>
        getInstanceSelectionResultsList() {
      if (instanceSelectionResultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(instanceSelectionResults_);
      } else {
        return instanceSelectionResultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of instance selection results in the group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getInstanceSelectionResultsCount() {
      if (instanceSelectionResultsBuilder_ == null) {
        return instanceSelectionResults_.size();
      } else {
        return instanceSelectionResultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of instance selection results in the group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
        getInstanceSelectionResults(int index) {
      if (instanceSelectionResultsBuilder_ == null) {
        return instanceSelectionResults_.get(index);
      } else {
        return instanceSelectionResultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of instance selection results in the group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setInstanceSelectionResults(
        int index,
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult value) {
      if (instanceSelectionResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstanceSelectionResultsIsMutable();
        instanceSelectionResults_.set(index, value);
        onChanged();
      } else {
        instanceSelectionResultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of instance selection results in the group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setInstanceSelectionResults(
        int index,
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult.Builder
            builderForValue) {
      if (instanceSelectionResultsBuilder_ == null) {
        ensureInstanceSelectionResultsIsMutable();
        instanceSelectionResults_.set(index, builderForValue.build());
        onChanged();
      } else {
        instanceSelectionResultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of instance selection results in the group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addInstanceSelectionResults(
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult value) {
      if (instanceSelectionResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstanceSelectionResultsIsMutable();
        instanceSelectionResults_.add(value);
        onChanged();
      } else {
        instanceSelectionResultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of instance selection results in the group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addInstanceSelectionResults(
        int index,
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult value) {
      if (instanceSelectionResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInstanceSelectionResultsIsMutable();
        instanceSelectionResults_.add(index, value);
        onChanged();
      } else {
        instanceSelectionResultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of instance selection results in the group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addInstanceSelectionResults(
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult.Builder
            builderForValue) {
      if (instanceSelectionResultsBuilder_ == null) {
        ensureInstanceSelectionResultsIsMutable();
        instanceSelectionResults_.add(builderForValue.build());
        onChanged();
      } else {
        instanceSelectionResultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of instance selection results in the group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addInstanceSelectionResults(
        int index,
        com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult.Builder
            builderForValue) {
      if (instanceSelectionResultsBuilder_ == null) {
        ensureInstanceSelectionResultsIsMutable();
        instanceSelectionResults_.add(index, builderForValue.build());
        onChanged();
      } else {
        instanceSelectionResultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of instance selection results in the group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllInstanceSelectionResults(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult>
            values) {
      if (instanceSelectionResultsBuilder_ == null) {
        ensureInstanceSelectionResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, instanceSelectionResults_);
        onChanged();
      } else {
        instanceSelectionResultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of instance selection results in the group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearInstanceSelectionResults() {
      if (instanceSelectionResultsBuilder_ == null) {
        instanceSelectionResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        instanceSelectionResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of instance selection results in the group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeInstanceSelectionResults(int index) {
      if (instanceSelectionResultsBuilder_ == null) {
        ensureInstanceSelectionResultsIsMutable();
        instanceSelectionResults_.remove(index);
        onChanged();
      } else {
        instanceSelectionResultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of instance selection results in the group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult.Builder
        getInstanceSelectionResultsBuilder(int index) {
      return getInstanceSelectionResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of instance selection results in the group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResultOrBuilder
        getInstanceSelectionResultsOrBuilder(int index) {
      if (instanceSelectionResultsBuilder_ == null) {
        return instanceSelectionResults_.get(index);
      } else {
        return instanceSelectionResultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of instance selection results in the group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy
                    .InstanceSelectionResultOrBuilder>
        getInstanceSelectionResultsOrBuilderList() {
      if (instanceSelectionResultsBuilder_ != null) {
        return instanceSelectionResultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(instanceSelectionResults_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of instance selection results in the group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult.Builder
        addInstanceSelectionResultsBuilder() {
      return getInstanceSelectionResultsFieldBuilder()
          .addBuilder(
              com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of instance selection results in the group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult.Builder
        addInstanceSelectionResultsBuilder(int index) {
      return getInstanceSelectionResultsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of instance selection results in the group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult instance_selection_results = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult.Builder>
        getInstanceSelectionResultsBuilderList() {
      return getInstanceSelectionResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult,
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult.Builder,
            com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResultOrBuilder>
        getInstanceSelectionResultsFieldBuilder() {
      if (instanceSelectionResultsBuilder_ == null) {
        instanceSelectionResultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult,
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy.InstanceSelectionResult
                    .Builder,
                com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy
                    .InstanceSelectionResultOrBuilder>(
                instanceSelectionResults_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        instanceSelectionResults_ = null;
      }
      return instanceSelectionResultsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.InstanceFlexibilityPolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.InstanceFlexibilityPolicy)
  private static final com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy();
  }

  public static com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InstanceFlexibilityPolicy> PARSER =
      new com.google.protobuf.AbstractParser<InstanceFlexibilityPolicy>() {
        @java.lang.Override
        public InstanceFlexibilityPolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InstanceFlexibilityPolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InstanceFlexibilityPolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.InstanceFlexibilityPolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
