/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/jobs.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * A Dataproc job resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.Job}
 */
public final class Job extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.Job)
    JobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Job.newBuilder() to construct.
  private Job(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Job() {
    statusHistory_ = java.util.Collections.emptyList();
    yarnApplications_ = java.util.Collections.emptyList();
    driverOutputResourceUri_ = "";
    driverControlFilesUri_ = "";
    jobUuid_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Job();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.JobsProto
        .internal_static_google_cloud_dataproc_v1_Job_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 18:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.JobsProto
        .internal_static_google_cloud_dataproc_v1_Job_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.Job.class, com.google.cloud.dataproc.v1.Job.Builder.class);
  }

  private int bitField0_;
  private int typeJobCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object typeJob_;

  public enum TypeJobCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    HADOOP_JOB(3),
    SPARK_JOB(4),
    PYSPARK_JOB(5),
    HIVE_JOB(6),
    PIG_JOB(7),
    SPARK_R_JOB(21),
    SPARK_SQL_JOB(12),
    PRESTO_JOB(23),
    TRINO_JOB(28),
    FLINK_JOB(29),
    TYPEJOB_NOT_SET(0);
    private final int value;

    private TypeJobCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TypeJobCase valueOf(int value) {
      return forNumber(value);
    }

    public static TypeJobCase forNumber(int value) {
      switch (value) {
        case 3:
          return HADOOP_JOB;
        case 4:
          return SPARK_JOB;
        case 5:
          return PYSPARK_JOB;
        case 6:
          return HIVE_JOB;
        case 7:
          return PIG_JOB;
        case 21:
          return SPARK_R_JOB;
        case 12:
          return SPARK_SQL_JOB;
        case 23:
          return PRESTO_JOB;
        case 28:
          return TRINO_JOB;
        case 29:
          return FLINK_JOB;
        case 0:
          return TYPEJOB_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TypeJobCase getTypeJobCase() {
    return TypeJobCase.forNumber(typeJobCase_);
  }

  public static final int REFERENCE_FIELD_NUMBER = 1;
  private com.google.cloud.dataproc.v1.JobReference reference_;
  /**
   *
   *
   * <pre>
   * Optional. The fully qualified reference to the job, which can be used to
   * obtain the equivalent REST path of the job resource. If this property
   * is not specified when a job is created, the server generates a
   * &lt;code&gt;job_id&lt;/code&gt;.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.JobReference reference = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the reference field is set.
   */
  @java.lang.Override
  public boolean hasReference() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The fully qualified reference to the job, which can be used to
   * obtain the equivalent REST path of the job resource. If this property
   * is not specified when a job is created, the server generates a
   * &lt;code&gt;job_id&lt;/code&gt;.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.JobReference reference = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The reference.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.JobReference getReference() {
    return reference_ == null
        ? com.google.cloud.dataproc.v1.JobReference.getDefaultInstance()
        : reference_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The fully qualified reference to the job, which can be used to
   * obtain the equivalent REST path of the job resource. If this property
   * is not specified when a job is created, the server generates a
   * &lt;code&gt;job_id&lt;/code&gt;.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.JobReference reference = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.JobReferenceOrBuilder getReferenceOrBuilder() {
    return reference_ == null
        ? com.google.cloud.dataproc.v1.JobReference.getDefaultInstance()
        : reference_;
  }

  public static final int PLACEMENT_FIELD_NUMBER = 2;
  private com.google.cloud.dataproc.v1.JobPlacement placement_;
  /**
   *
   *
   * <pre>
   * Required. Job information, including how, when, and where to
   * run the job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.JobPlacement placement = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the placement field is set.
   */
  @java.lang.Override
  public boolean hasPlacement() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Job information, including how, when, and where to
   * run the job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.JobPlacement placement = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The placement.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.JobPlacement getPlacement() {
    return placement_ == null
        ? com.google.cloud.dataproc.v1.JobPlacement.getDefaultInstance()
        : placement_;
  }
  /**
   *
   *
   * <pre>
   * Required. Job information, including how, when, and where to
   * run the job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.JobPlacement placement = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.JobPlacementOrBuilder getPlacementOrBuilder() {
    return placement_ == null
        ? com.google.cloud.dataproc.v1.JobPlacement.getDefaultInstance()
        : placement_;
  }

  public static final int HADOOP_JOB_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Optional. Job is a Hadoop job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.HadoopJob hadoop_job = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the hadoopJob field is set.
   */
  @java.lang.Override
  public boolean hasHadoopJob() {
    return typeJobCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Optional. Job is a Hadoop job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.HadoopJob hadoop_job = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The hadoopJob.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.HadoopJob getHadoopJob() {
    if (typeJobCase_ == 3) {
      return (com.google.cloud.dataproc.v1.HadoopJob) typeJob_;
    }
    return com.google.cloud.dataproc.v1.HadoopJob.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Job is a Hadoop job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.HadoopJob hadoop_job = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.HadoopJobOrBuilder getHadoopJobOrBuilder() {
    if (typeJobCase_ == 3) {
      return (com.google.cloud.dataproc.v1.HadoopJob) typeJob_;
    }
    return com.google.cloud.dataproc.v1.HadoopJob.getDefaultInstance();
  }

  public static final int SPARK_JOB_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Optional. Job is a Spark job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkJob spark_job = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the sparkJob field is set.
   */
  @java.lang.Override
  public boolean hasSparkJob() {
    return typeJobCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Optional. Job is a Spark job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkJob spark_job = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The sparkJob.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.SparkJob getSparkJob() {
    if (typeJobCase_ == 4) {
      return (com.google.cloud.dataproc.v1.SparkJob) typeJob_;
    }
    return com.google.cloud.dataproc.v1.SparkJob.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Job is a Spark job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkJob spark_job = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.SparkJobOrBuilder getSparkJobOrBuilder() {
    if (typeJobCase_ == 4) {
      return (com.google.cloud.dataproc.v1.SparkJob) typeJob_;
    }
    return com.google.cloud.dataproc.v1.SparkJob.getDefaultInstance();
  }

  public static final int PYSPARK_JOB_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Optional. Job is a PySpark job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.PySparkJob pyspark_job = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the pysparkJob field is set.
   */
  @java.lang.Override
  public boolean hasPysparkJob() {
    return typeJobCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Optional. Job is a PySpark job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.PySparkJob pyspark_job = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The pysparkJob.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.PySparkJob getPysparkJob() {
    if (typeJobCase_ == 5) {
      return (com.google.cloud.dataproc.v1.PySparkJob) typeJob_;
    }
    return com.google.cloud.dataproc.v1.PySparkJob.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Job is a PySpark job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.PySparkJob pyspark_job = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.PySparkJobOrBuilder getPysparkJobOrBuilder() {
    if (typeJobCase_ == 5) {
      return (com.google.cloud.dataproc.v1.PySparkJob) typeJob_;
    }
    return com.google.cloud.dataproc.v1.PySparkJob.getDefaultInstance();
  }

  public static final int HIVE_JOB_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Optional. Job is a Hive job.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.HiveJob hive_job = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the hiveJob field is set.
   */
  @java.lang.Override
  public boolean hasHiveJob() {
    return typeJobCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Optional. Job is a Hive job.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.HiveJob hive_job = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The hiveJob.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.HiveJob getHiveJob() {
    if (typeJobCase_ == 6) {
      return (com.google.cloud.dataproc.v1.HiveJob) typeJob_;
    }
    return com.google.cloud.dataproc.v1.HiveJob.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Job is a Hive job.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.HiveJob hive_job = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.HiveJobOrBuilder getHiveJobOrBuilder() {
    if (typeJobCase_ == 6) {
      return (com.google.cloud.dataproc.v1.HiveJob) typeJob_;
    }
    return com.google.cloud.dataproc.v1.HiveJob.getDefaultInstance();
  }

  public static final int PIG_JOB_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Optional. Job is a Pig job.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.PigJob pig_job = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the pigJob field is set.
   */
  @java.lang.Override
  public boolean hasPigJob() {
    return typeJobCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Optional. Job is a Pig job.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.PigJob pig_job = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The pigJob.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.PigJob getPigJob() {
    if (typeJobCase_ == 7) {
      return (com.google.cloud.dataproc.v1.PigJob) typeJob_;
    }
    return com.google.cloud.dataproc.v1.PigJob.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Job is a Pig job.
   * </pre>
   *
   * <code>.google.cloud.dataproc.v1.PigJob pig_job = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.PigJobOrBuilder getPigJobOrBuilder() {
    if (typeJobCase_ == 7) {
      return (com.google.cloud.dataproc.v1.PigJob) typeJob_;
    }
    return com.google.cloud.dataproc.v1.PigJob.getDefaultInstance();
  }

  public static final int SPARK_R_JOB_FIELD_NUMBER = 21;
  /**
   *
   *
   * <pre>
   * Optional. Job is a SparkR job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkRJob spark_r_job = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the sparkRJob field is set.
   */
  @java.lang.Override
  public boolean hasSparkRJob() {
    return typeJobCase_ == 21;
  }
  /**
   *
   *
   * <pre>
   * Optional. Job is a SparkR job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkRJob spark_r_job = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The sparkRJob.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.SparkRJob getSparkRJob() {
    if (typeJobCase_ == 21) {
      return (com.google.cloud.dataproc.v1.SparkRJob) typeJob_;
    }
    return com.google.cloud.dataproc.v1.SparkRJob.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Job is a SparkR job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkRJob spark_r_job = 21 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.SparkRJobOrBuilder getSparkRJobOrBuilder() {
    if (typeJobCase_ == 21) {
      return (com.google.cloud.dataproc.v1.SparkRJob) typeJob_;
    }
    return com.google.cloud.dataproc.v1.SparkRJob.getDefaultInstance();
  }

  public static final int SPARK_SQL_JOB_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * Optional. Job is a SparkSql job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkSqlJob spark_sql_job = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the sparkSqlJob field is set.
   */
  @java.lang.Override
  public boolean hasSparkSqlJob() {
    return typeJobCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * Optional. Job is a SparkSql job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkSqlJob spark_sql_job = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The sparkSqlJob.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.SparkSqlJob getSparkSqlJob() {
    if (typeJobCase_ == 12) {
      return (com.google.cloud.dataproc.v1.SparkSqlJob) typeJob_;
    }
    return com.google.cloud.dataproc.v1.SparkSqlJob.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Job is a SparkSql job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkSqlJob spark_sql_job = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.SparkSqlJobOrBuilder getSparkSqlJobOrBuilder() {
    if (typeJobCase_ == 12) {
      return (com.google.cloud.dataproc.v1.SparkSqlJob) typeJob_;
    }
    return com.google.cloud.dataproc.v1.SparkSqlJob.getDefaultInstance();
  }

  public static final int PRESTO_JOB_FIELD_NUMBER = 23;
  /**
   *
   *
   * <pre>
   * Optional. Job is a Presto job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.PrestoJob presto_job = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the prestoJob field is set.
   */
  @java.lang.Override
  public boolean hasPrestoJob() {
    return typeJobCase_ == 23;
  }
  /**
   *
   *
   * <pre>
   * Optional. Job is a Presto job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.PrestoJob presto_job = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The prestoJob.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.PrestoJob getPrestoJob() {
    if (typeJobCase_ == 23) {
      return (com.google.cloud.dataproc.v1.PrestoJob) typeJob_;
    }
    return com.google.cloud.dataproc.v1.PrestoJob.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Job is a Presto job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.PrestoJob presto_job = 23 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.PrestoJobOrBuilder getPrestoJobOrBuilder() {
    if (typeJobCase_ == 23) {
      return (com.google.cloud.dataproc.v1.PrestoJob) typeJob_;
    }
    return com.google.cloud.dataproc.v1.PrestoJob.getDefaultInstance();
  }

  public static final int TRINO_JOB_FIELD_NUMBER = 28;
  /**
   *
   *
   * <pre>
   * Optional. Job is a Trino job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.TrinoJob trino_job = 28 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the trinoJob field is set.
   */
  @java.lang.Override
  public boolean hasTrinoJob() {
    return typeJobCase_ == 28;
  }
  /**
   *
   *
   * <pre>
   * Optional. Job is a Trino job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.TrinoJob trino_job = 28 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The trinoJob.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.TrinoJob getTrinoJob() {
    if (typeJobCase_ == 28) {
      return (com.google.cloud.dataproc.v1.TrinoJob) typeJob_;
    }
    return com.google.cloud.dataproc.v1.TrinoJob.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Job is a Trino job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.TrinoJob trino_job = 28 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.TrinoJobOrBuilder getTrinoJobOrBuilder() {
    if (typeJobCase_ == 28) {
      return (com.google.cloud.dataproc.v1.TrinoJob) typeJob_;
    }
    return com.google.cloud.dataproc.v1.TrinoJob.getDefaultInstance();
  }

  public static final int FLINK_JOB_FIELD_NUMBER = 29;
  /**
   *
   *
   * <pre>
   * Optional. Job is a Flink job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.FlinkJob flink_job = 29 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the flinkJob field is set.
   */
  @java.lang.Override
  public boolean hasFlinkJob() {
    return typeJobCase_ == 29;
  }
  /**
   *
   *
   * <pre>
   * Optional. Job is a Flink job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.FlinkJob flink_job = 29 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The flinkJob.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.FlinkJob getFlinkJob() {
    if (typeJobCase_ == 29) {
      return (com.google.cloud.dataproc.v1.FlinkJob) typeJob_;
    }
    return com.google.cloud.dataproc.v1.FlinkJob.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Job is a Flink job.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.FlinkJob flink_job = 29 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.FlinkJobOrBuilder getFlinkJobOrBuilder() {
    if (typeJobCase_ == 29) {
      return (com.google.cloud.dataproc.v1.FlinkJob) typeJob_;
    }
    return com.google.cloud.dataproc.v1.FlinkJob.getDefaultInstance();
  }

  public static final int STATUS_FIELD_NUMBER = 8;
  private com.google.cloud.dataproc.v1.JobStatus status_;
  /**
   *
   *
   * <pre>
   * Output only. The job status. Additional application-specific
   * status information might be contained in the &lt;code&gt;type_job&lt;/code&gt;
   * and &lt;code&gt;yarn_applications&lt;/code&gt; fields.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.JobStatus status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The job status. Additional application-specific
   * status information might be contained in the &lt;code&gt;type_job&lt;/code&gt;
   * and &lt;code&gt;yarn_applications&lt;/code&gt; fields.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.JobStatus status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.JobStatus getStatus() {
    return status_ == null ? com.google.cloud.dataproc.v1.JobStatus.getDefaultInstance() : status_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The job status. Additional application-specific
   * status information might be contained in the &lt;code&gt;type_job&lt;/code&gt;
   * and &lt;code&gt;yarn_applications&lt;/code&gt; fields.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.JobStatus status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.JobStatusOrBuilder getStatusOrBuilder() {
    return status_ == null ? com.google.cloud.dataproc.v1.JobStatus.getDefaultInstance() : status_;
  }

  public static final int STATUS_HISTORY_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dataproc.v1.JobStatus> statusHistory_;
  /**
   *
   *
   * <pre>
   * Output only. The previous job status.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dataproc.v1.JobStatus> getStatusHistoryList() {
    return statusHistory_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The previous job status.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dataproc.v1.JobStatusOrBuilder>
      getStatusHistoryOrBuilderList() {
    return statusHistory_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The previous job status.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getStatusHistoryCount() {
    return statusHistory_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The previous job status.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.JobStatus getStatusHistory(int index) {
    return statusHistory_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The previous job status.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.JobStatusOrBuilder getStatusHistoryOrBuilder(int index) {
    return statusHistory_.get(index);
  }

  public static final int YARN_APPLICATIONS_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dataproc.v1.YarnApplication> yarnApplications_;
  /**
   *
   *
   * <pre>
   * Output only. The collection of YARN applications spun up by this job.
   *
   * **Beta** Feature: This report is available for testing purposes only. It
   * might be changed before final release.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dataproc.v1.YarnApplication> getYarnApplicationsList() {
    return yarnApplications_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The collection of YARN applications spun up by this job.
   *
   * **Beta** Feature: This report is available for testing purposes only. It
   * might be changed before final release.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dataproc.v1.YarnApplicationOrBuilder>
      getYarnApplicationsOrBuilderList() {
    return yarnApplications_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The collection of YARN applications spun up by this job.
   *
   * **Beta** Feature: This report is available for testing purposes only. It
   * might be changed before final release.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getYarnApplicationsCount() {
    return yarnApplications_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The collection of YARN applications spun up by this job.
   *
   * **Beta** Feature: This report is available for testing purposes only. It
   * might be changed before final release.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.YarnApplication getYarnApplications(int index) {
    return yarnApplications_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The collection of YARN applications spun up by this job.
   *
   * **Beta** Feature: This report is available for testing purposes only. It
   * might be changed before final release.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.YarnApplicationOrBuilder getYarnApplicationsOrBuilder(
      int index) {
    return yarnApplications_.get(index);
  }

  public static final int DRIVER_OUTPUT_RESOURCE_URI_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private volatile java.lang.Object driverOutputResourceUri_ = "";
  /**
   *
   *
   * <pre>
   * Output only. A URI pointing to the location of the stdout of the job's
   * driver program.
   * </pre>
   *
   * <code>string driver_output_resource_uri = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The driverOutputResourceUri.
   */
  @java.lang.Override
  public java.lang.String getDriverOutputResourceUri() {
    java.lang.Object ref = driverOutputResourceUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      driverOutputResourceUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. A URI pointing to the location of the stdout of the job's
   * driver program.
   * </pre>
   *
   * <code>string driver_output_resource_uri = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for driverOutputResourceUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDriverOutputResourceUriBytes() {
    java.lang.Object ref = driverOutputResourceUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      driverOutputResourceUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DRIVER_CONTROL_FILES_URI_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object driverControlFilesUri_ = "";
  /**
   *
   *
   * <pre>
   * Output only. If present, the location of miscellaneous control files
   * which can be used as part of job setup and handling. If not present,
   * control files might be placed in the same location as `driver_output_uri`.
   * </pre>
   *
   * <code>string driver_control_files_uri = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The driverControlFilesUri.
   */
  @java.lang.Override
  public java.lang.String getDriverControlFilesUri() {
    java.lang.Object ref = driverControlFilesUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      driverControlFilesUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. If present, the location of miscellaneous control files
   * which can be used as part of job setup and handling. If not present,
   * control files might be placed in the same location as `driver_output_uri`.
   * </pre>
   *
   * <code>string driver_control_files_uri = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for driverControlFilesUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDriverControlFilesUriBytes() {
    java.lang.Object ref = driverControlFilesUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      driverControlFilesUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 18;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataproc.v1.JobsProto
                .internal_static_google_cloud_dataproc_v1_Job_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this job.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** can be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a job.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this job.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** can be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a job.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this job.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** can be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a job.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with this job.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** can be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a job.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int SCHEDULING_FIELD_NUMBER = 20;
  private com.google.cloud.dataproc.v1.JobScheduling scheduling_;
  /**
   *
   *
   * <pre>
   * Optional. Job scheduling configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.JobScheduling scheduling = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the scheduling field is set.
   */
  @java.lang.Override
  public boolean hasScheduling() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Job scheduling configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.JobScheduling scheduling = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The scheduling.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.JobScheduling getScheduling() {
    return scheduling_ == null
        ? com.google.cloud.dataproc.v1.JobScheduling.getDefaultInstance()
        : scheduling_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Job scheduling configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.JobScheduling scheduling = 20 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.JobSchedulingOrBuilder getSchedulingOrBuilder() {
    return scheduling_ == null
        ? com.google.cloud.dataproc.v1.JobScheduling.getDefaultInstance()
        : scheduling_;
  }

  public static final int JOB_UUID_FIELD_NUMBER = 22;

  @SuppressWarnings("serial")
  private volatile java.lang.Object jobUuid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. A UUID that uniquely identifies a job within the project
   * over time. This is in contrast to a user-settable reference.job_id that
   * might be reused over time.
   * </pre>
   *
   * <code>string job_uuid = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The jobUuid.
   */
  @java.lang.Override
  public java.lang.String getJobUuid() {
    java.lang.Object ref = jobUuid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      jobUuid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. A UUID that uniquely identifies a job within the project
   * over time. This is in contrast to a user-settable reference.job_id that
   * might be reused over time.
   * </pre>
   *
   * <code>string job_uuid = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for jobUuid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getJobUuidBytes() {
    java.lang.Object ref = jobUuid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      jobUuid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DONE_FIELD_NUMBER = 24;
  private boolean done_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Indicates whether the job is completed. If the value is
   * `false`, the job is still in progress. If `true`, the job is completed, and
   * `status.state` field will indicate if it was successful, failed,
   * or cancelled.
   * </pre>
   *
   * <code>bool done = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The done.
   */
  @java.lang.Override
  public boolean getDone() {
    return done_;
  }

  public static final int DRIVER_SCHEDULING_CONFIG_FIELD_NUMBER = 27;
  private com.google.cloud.dataproc.v1.DriverSchedulingConfig driverSchedulingConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Driver scheduling configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.DriverSchedulingConfig driver_scheduling_config = 27 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the driverSchedulingConfig field is set.
   */
  @java.lang.Override
  public boolean hasDriverSchedulingConfig() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Driver scheduling configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.DriverSchedulingConfig driver_scheduling_config = 27 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The driverSchedulingConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.DriverSchedulingConfig getDriverSchedulingConfig() {
    return driverSchedulingConfig_ == null
        ? com.google.cloud.dataproc.v1.DriverSchedulingConfig.getDefaultInstance()
        : driverSchedulingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Driver scheduling configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.DriverSchedulingConfig driver_scheduling_config = 27 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.DriverSchedulingConfigOrBuilder
      getDriverSchedulingConfigOrBuilder() {
    return driverSchedulingConfig_ == null
        ? com.google.cloud.dataproc.v1.DriverSchedulingConfig.getDefaultInstance()
        : driverSchedulingConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getReference());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getPlacement());
    }
    if (typeJobCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.dataproc.v1.HadoopJob) typeJob_);
    }
    if (typeJobCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.dataproc.v1.SparkJob) typeJob_);
    }
    if (typeJobCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.dataproc.v1.PySparkJob) typeJob_);
    }
    if (typeJobCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.dataproc.v1.HiveJob) typeJob_);
    }
    if (typeJobCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.dataproc.v1.PigJob) typeJob_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getStatus());
    }
    for (int i = 0; i < yarnApplications_.size(); i++) {
      output.writeMessage(9, yarnApplications_.get(i));
    }
    if (typeJobCase_ == 12) {
      output.writeMessage(12, (com.google.cloud.dataproc.v1.SparkSqlJob) typeJob_);
    }
    for (int i = 0; i < statusHistory_.size(); i++) {
      output.writeMessage(13, statusHistory_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(driverControlFilesUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, driverControlFilesUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(driverOutputResourceUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, driverOutputResourceUri_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 18);
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(20, getScheduling());
    }
    if (typeJobCase_ == 21) {
      output.writeMessage(21, (com.google.cloud.dataproc.v1.SparkRJob) typeJob_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobUuid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 22, jobUuid_);
    }
    if (typeJobCase_ == 23) {
      output.writeMessage(23, (com.google.cloud.dataproc.v1.PrestoJob) typeJob_);
    }
    if (done_ != false) {
      output.writeBool(24, done_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(27, getDriverSchedulingConfig());
    }
    if (typeJobCase_ == 28) {
      output.writeMessage(28, (com.google.cloud.dataproc.v1.TrinoJob) typeJob_);
    }
    if (typeJobCase_ == 29) {
      output.writeMessage(29, (com.google.cloud.dataproc.v1.FlinkJob) typeJob_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getReference());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPlacement());
    }
    if (typeJobCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.dataproc.v1.HadoopJob) typeJob_);
    }
    if (typeJobCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.dataproc.v1.SparkJob) typeJob_);
    }
    if (typeJobCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.dataproc.v1.PySparkJob) typeJob_);
    }
    if (typeJobCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.dataproc.v1.HiveJob) typeJob_);
    }
    if (typeJobCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.dataproc.v1.PigJob) typeJob_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getStatus());
    }
    for (int i = 0; i < yarnApplications_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, yarnApplications_.get(i));
    }
    if (typeJobCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.cloud.dataproc.v1.SparkSqlJob) typeJob_);
    }
    for (int i = 0; i < statusHistory_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, statusHistory_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(driverControlFilesUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, driverControlFilesUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(driverOutputResourceUri_)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(17, driverOutputResourceUri_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(18, labels__);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, getScheduling());
    }
    if (typeJobCase_ == 21) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              21, (com.google.cloud.dataproc.v1.SparkRJob) typeJob_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobUuid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(22, jobUuid_);
    }
    if (typeJobCase_ == 23) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              23, (com.google.cloud.dataproc.v1.PrestoJob) typeJob_);
    }
    if (done_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(24, done_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(27, getDriverSchedulingConfig());
    }
    if (typeJobCase_ == 28) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              28, (com.google.cloud.dataproc.v1.TrinoJob) typeJob_);
    }
    if (typeJobCase_ == 29) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              29, (com.google.cloud.dataproc.v1.FlinkJob) typeJob_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.Job)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.Job other = (com.google.cloud.dataproc.v1.Job) obj;

    if (hasReference() != other.hasReference()) return false;
    if (hasReference()) {
      if (!getReference().equals(other.getReference())) return false;
    }
    if (hasPlacement() != other.hasPlacement()) return false;
    if (hasPlacement()) {
      if (!getPlacement().equals(other.getPlacement())) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!getStatusHistoryList().equals(other.getStatusHistoryList())) return false;
    if (!getYarnApplicationsList().equals(other.getYarnApplicationsList())) return false;
    if (!getDriverOutputResourceUri().equals(other.getDriverOutputResourceUri())) return false;
    if (!getDriverControlFilesUri().equals(other.getDriverControlFilesUri())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasScheduling() != other.hasScheduling()) return false;
    if (hasScheduling()) {
      if (!getScheduling().equals(other.getScheduling())) return false;
    }
    if (!getJobUuid().equals(other.getJobUuid())) return false;
    if (getDone() != other.getDone()) return false;
    if (hasDriverSchedulingConfig() != other.hasDriverSchedulingConfig()) return false;
    if (hasDriverSchedulingConfig()) {
      if (!getDriverSchedulingConfig().equals(other.getDriverSchedulingConfig())) return false;
    }
    if (!getTypeJobCase().equals(other.getTypeJobCase())) return false;
    switch (typeJobCase_) {
      case 3:
        if (!getHadoopJob().equals(other.getHadoopJob())) return false;
        break;
      case 4:
        if (!getSparkJob().equals(other.getSparkJob())) return false;
        break;
      case 5:
        if (!getPysparkJob().equals(other.getPysparkJob())) return false;
        break;
      case 6:
        if (!getHiveJob().equals(other.getHiveJob())) return false;
        break;
      case 7:
        if (!getPigJob().equals(other.getPigJob())) return false;
        break;
      case 21:
        if (!getSparkRJob().equals(other.getSparkRJob())) return false;
        break;
      case 12:
        if (!getSparkSqlJob().equals(other.getSparkSqlJob())) return false;
        break;
      case 23:
        if (!getPrestoJob().equals(other.getPrestoJob())) return false;
        break;
      case 28:
        if (!getTrinoJob().equals(other.getTrinoJob())) return false;
        break;
      case 29:
        if (!getFlinkJob().equals(other.getFlinkJob())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasReference()) {
      hash = (37 * hash) + REFERENCE_FIELD_NUMBER;
      hash = (53 * hash) + getReference().hashCode();
    }
    if (hasPlacement()) {
      hash = (37 * hash) + PLACEMENT_FIELD_NUMBER;
      hash = (53 * hash) + getPlacement().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (getStatusHistoryCount() > 0) {
      hash = (37 * hash) + STATUS_HISTORY_FIELD_NUMBER;
      hash = (53 * hash) + getStatusHistoryList().hashCode();
    }
    if (getYarnApplicationsCount() > 0) {
      hash = (37 * hash) + YARN_APPLICATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getYarnApplicationsList().hashCode();
    }
    hash = (37 * hash) + DRIVER_OUTPUT_RESOURCE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getDriverOutputResourceUri().hashCode();
    hash = (37 * hash) + DRIVER_CONTROL_FILES_URI_FIELD_NUMBER;
    hash = (53 * hash) + getDriverControlFilesUri().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasScheduling()) {
      hash = (37 * hash) + SCHEDULING_FIELD_NUMBER;
      hash = (53 * hash) + getScheduling().hashCode();
    }
    hash = (37 * hash) + JOB_UUID_FIELD_NUMBER;
    hash = (53 * hash) + getJobUuid().hashCode();
    hash = (37 * hash) + DONE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDone());
    if (hasDriverSchedulingConfig()) {
      hash = (37 * hash) + DRIVER_SCHEDULING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDriverSchedulingConfig().hashCode();
    }
    switch (typeJobCase_) {
      case 3:
        hash = (37 * hash) + HADOOP_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getHadoopJob().hashCode();
        break;
      case 4:
        hash = (37 * hash) + SPARK_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getSparkJob().hashCode();
        break;
      case 5:
        hash = (37 * hash) + PYSPARK_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getPysparkJob().hashCode();
        break;
      case 6:
        hash = (37 * hash) + HIVE_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getHiveJob().hashCode();
        break;
      case 7:
        hash = (37 * hash) + PIG_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getPigJob().hashCode();
        break;
      case 21:
        hash = (37 * hash) + SPARK_R_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getSparkRJob().hashCode();
        break;
      case 12:
        hash = (37 * hash) + SPARK_SQL_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getSparkSqlJob().hashCode();
        break;
      case 23:
        hash = (37 * hash) + PRESTO_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getPrestoJob().hashCode();
        break;
      case 28:
        hash = (37 * hash) + TRINO_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getTrinoJob().hashCode();
        break;
      case 29:
        hash = (37 * hash) + FLINK_JOB_FIELD_NUMBER;
        hash = (53 * hash) + getFlinkJob().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.Job parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.Job parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.Job parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.Job parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.Job parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.Job parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.Job parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.Job parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.Job parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.Job parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.Job parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.Job parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.Job prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Dataproc job resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.Job}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.Job)
      com.google.cloud.dataproc.v1.JobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.JobsProto
          .internal_static_google_cloud_dataproc_v1_Job_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 18:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 18:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.JobsProto
          .internal_static_google_cloud_dataproc_v1_Job_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.Job.class,
              com.google.cloud.dataproc.v1.Job.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.Job.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getReferenceFieldBuilder();
        getPlacementFieldBuilder();
        getStatusFieldBuilder();
        getStatusHistoryFieldBuilder();
        getYarnApplicationsFieldBuilder();
        getSchedulingFieldBuilder();
        getDriverSchedulingConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      reference_ = null;
      if (referenceBuilder_ != null) {
        referenceBuilder_.dispose();
        referenceBuilder_ = null;
      }
      placement_ = null;
      if (placementBuilder_ != null) {
        placementBuilder_.dispose();
        placementBuilder_ = null;
      }
      if (hadoopJobBuilder_ != null) {
        hadoopJobBuilder_.clear();
      }
      if (sparkJobBuilder_ != null) {
        sparkJobBuilder_.clear();
      }
      if (pysparkJobBuilder_ != null) {
        pysparkJobBuilder_.clear();
      }
      if (hiveJobBuilder_ != null) {
        hiveJobBuilder_.clear();
      }
      if (pigJobBuilder_ != null) {
        pigJobBuilder_.clear();
      }
      if (sparkRJobBuilder_ != null) {
        sparkRJobBuilder_.clear();
      }
      if (sparkSqlJobBuilder_ != null) {
        sparkSqlJobBuilder_.clear();
      }
      if (prestoJobBuilder_ != null) {
        prestoJobBuilder_.clear();
      }
      if (trinoJobBuilder_ != null) {
        trinoJobBuilder_.clear();
      }
      if (flinkJobBuilder_ != null) {
        flinkJobBuilder_.clear();
      }
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      if (statusHistoryBuilder_ == null) {
        statusHistory_ = java.util.Collections.emptyList();
      } else {
        statusHistory_ = null;
        statusHistoryBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00002000);
      if (yarnApplicationsBuilder_ == null) {
        yarnApplications_ = java.util.Collections.emptyList();
      } else {
        yarnApplications_ = null;
        yarnApplicationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00004000);
      driverOutputResourceUri_ = "";
      driverControlFilesUri_ = "";
      internalGetMutableLabels().clear();
      scheduling_ = null;
      if (schedulingBuilder_ != null) {
        schedulingBuilder_.dispose();
        schedulingBuilder_ = null;
      }
      jobUuid_ = "";
      done_ = false;
      driverSchedulingConfig_ = null;
      if (driverSchedulingConfigBuilder_ != null) {
        driverSchedulingConfigBuilder_.dispose();
        driverSchedulingConfigBuilder_ = null;
      }
      typeJobCase_ = 0;
      typeJob_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.JobsProto
          .internal_static_google_cloud_dataproc_v1_Job_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.Job getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.Job.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.Job build() {
      com.google.cloud.dataproc.v1.Job result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.Job buildPartial() {
      com.google.cloud.dataproc.v1.Job result = new com.google.cloud.dataproc.v1.Job(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dataproc.v1.Job result) {
      if (statusHistoryBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)) {
          statusHistory_ = java.util.Collections.unmodifiableList(statusHistory_);
          bitField0_ = (bitField0_ & ~0x00002000);
        }
        result.statusHistory_ = statusHistory_;
      } else {
        result.statusHistory_ = statusHistoryBuilder_.build();
      }
      if (yarnApplicationsBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)) {
          yarnApplications_ = java.util.Collections.unmodifiableList(yarnApplications_);
          bitField0_ = (bitField0_ & ~0x00004000);
        }
        result.yarnApplications_ = yarnApplications_;
      } else {
        result.yarnApplications_ = yarnApplicationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.Job result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.reference_ = referenceBuilder_ == null ? reference_ : referenceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.placement_ = placementBuilder_ == null ? placement_ : placementBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.driverOutputResourceUri_ = driverOutputResourceUri_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.driverControlFilesUri_ = driverControlFilesUri_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.scheduling_ = schedulingBuilder_ == null ? scheduling_ : schedulingBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.jobUuid_ = jobUuid_;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.done_ = done_;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.driverSchedulingConfig_ =
            driverSchedulingConfigBuilder_ == null
                ? driverSchedulingConfig_
                : driverSchedulingConfigBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.dataproc.v1.Job result) {
      result.typeJobCase_ = typeJobCase_;
      result.typeJob_ = this.typeJob_;
      if (typeJobCase_ == 3 && hadoopJobBuilder_ != null) {
        result.typeJob_ = hadoopJobBuilder_.build();
      }
      if (typeJobCase_ == 4 && sparkJobBuilder_ != null) {
        result.typeJob_ = sparkJobBuilder_.build();
      }
      if (typeJobCase_ == 5 && pysparkJobBuilder_ != null) {
        result.typeJob_ = pysparkJobBuilder_.build();
      }
      if (typeJobCase_ == 6 && hiveJobBuilder_ != null) {
        result.typeJob_ = hiveJobBuilder_.build();
      }
      if (typeJobCase_ == 7 && pigJobBuilder_ != null) {
        result.typeJob_ = pigJobBuilder_.build();
      }
      if (typeJobCase_ == 21 && sparkRJobBuilder_ != null) {
        result.typeJob_ = sparkRJobBuilder_.build();
      }
      if (typeJobCase_ == 12 && sparkSqlJobBuilder_ != null) {
        result.typeJob_ = sparkSqlJobBuilder_.build();
      }
      if (typeJobCase_ == 23 && prestoJobBuilder_ != null) {
        result.typeJob_ = prestoJobBuilder_.build();
      }
      if (typeJobCase_ == 28 && trinoJobBuilder_ != null) {
        result.typeJob_ = trinoJobBuilder_.build();
      }
      if (typeJobCase_ == 29 && flinkJobBuilder_ != null) {
        result.typeJob_ = flinkJobBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.Job) {
        return mergeFrom((com.google.cloud.dataproc.v1.Job) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.Job other) {
      if (other == com.google.cloud.dataproc.v1.Job.getDefaultInstance()) return this;
      if (other.hasReference()) {
        mergeReference(other.getReference());
      }
      if (other.hasPlacement()) {
        mergePlacement(other.getPlacement());
      }
      if (other.hasStatus()) {
        mergeStatus(other.getStatus());
      }
      if (statusHistoryBuilder_ == null) {
        if (!other.statusHistory_.isEmpty()) {
          if (statusHistory_.isEmpty()) {
            statusHistory_ = other.statusHistory_;
            bitField0_ = (bitField0_ & ~0x00002000);
          } else {
            ensureStatusHistoryIsMutable();
            statusHistory_.addAll(other.statusHistory_);
          }
          onChanged();
        }
      } else {
        if (!other.statusHistory_.isEmpty()) {
          if (statusHistoryBuilder_.isEmpty()) {
            statusHistoryBuilder_.dispose();
            statusHistoryBuilder_ = null;
            statusHistory_ = other.statusHistory_;
            bitField0_ = (bitField0_ & ~0x00002000);
            statusHistoryBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStatusHistoryFieldBuilder()
                    : null;
          } else {
            statusHistoryBuilder_.addAllMessages(other.statusHistory_);
          }
        }
      }
      if (yarnApplicationsBuilder_ == null) {
        if (!other.yarnApplications_.isEmpty()) {
          if (yarnApplications_.isEmpty()) {
            yarnApplications_ = other.yarnApplications_;
            bitField0_ = (bitField0_ & ~0x00004000);
          } else {
            ensureYarnApplicationsIsMutable();
            yarnApplications_.addAll(other.yarnApplications_);
          }
          onChanged();
        }
      } else {
        if (!other.yarnApplications_.isEmpty()) {
          if (yarnApplicationsBuilder_.isEmpty()) {
            yarnApplicationsBuilder_.dispose();
            yarnApplicationsBuilder_ = null;
            yarnApplications_ = other.yarnApplications_;
            bitField0_ = (bitField0_ & ~0x00004000);
            yarnApplicationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getYarnApplicationsFieldBuilder()
                    : null;
          } else {
            yarnApplicationsBuilder_.addAllMessages(other.yarnApplications_);
          }
        }
      }
      if (!other.getDriverOutputResourceUri().isEmpty()) {
        driverOutputResourceUri_ = other.driverOutputResourceUri_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (!other.getDriverControlFilesUri().isEmpty()) {
        driverControlFilesUri_ = other.driverControlFilesUri_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00020000;
      if (other.hasScheduling()) {
        mergeScheduling(other.getScheduling());
      }
      if (!other.getJobUuid().isEmpty()) {
        jobUuid_ = other.jobUuid_;
        bitField0_ |= 0x00080000;
        onChanged();
      }
      if (other.getDone() != false) {
        setDone(other.getDone());
      }
      if (other.hasDriverSchedulingConfig()) {
        mergeDriverSchedulingConfig(other.getDriverSchedulingConfig());
      }
      switch (other.getTypeJobCase()) {
        case HADOOP_JOB:
          {
            mergeHadoopJob(other.getHadoopJob());
            break;
          }
        case SPARK_JOB:
          {
            mergeSparkJob(other.getSparkJob());
            break;
          }
        case PYSPARK_JOB:
          {
            mergePysparkJob(other.getPysparkJob());
            break;
          }
        case HIVE_JOB:
          {
            mergeHiveJob(other.getHiveJob());
            break;
          }
        case PIG_JOB:
          {
            mergePigJob(other.getPigJob());
            break;
          }
        case SPARK_R_JOB:
          {
            mergeSparkRJob(other.getSparkRJob());
            break;
          }
        case SPARK_SQL_JOB:
          {
            mergeSparkSqlJob(other.getSparkSqlJob());
            break;
          }
        case PRESTO_JOB:
          {
            mergePrestoJob(other.getPrestoJob());
            break;
          }
        case TRINO_JOB:
          {
            mergeTrinoJob(other.getTrinoJob());
            break;
          }
        case FLINK_JOB:
          {
            mergeFlinkJob(other.getFlinkJob());
            break;
          }
        case TYPEJOB_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getReferenceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getPlacementFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getHadoopJobFieldBuilder().getBuilder(), extensionRegistry);
                typeJobCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getSparkJobFieldBuilder().getBuilder(), extensionRegistry);
                typeJobCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getPysparkJobFieldBuilder().getBuilder(), extensionRegistry);
                typeJobCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getHiveJobFieldBuilder().getBuilder(), extensionRegistry);
                typeJobCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getPigJobFieldBuilder().getBuilder(), extensionRegistry);
                typeJobCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 66
            case 74:
              {
                com.google.cloud.dataproc.v1.YarnApplication m =
                    input.readMessage(
                        com.google.cloud.dataproc.v1.YarnApplication.parser(), extensionRegistry);
                if (yarnApplicationsBuilder_ == null) {
                  ensureYarnApplicationsIsMutable();
                  yarnApplications_.add(m);
                } else {
                  yarnApplicationsBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 98:
              {
                input.readMessage(getSparkSqlJobFieldBuilder().getBuilder(), extensionRegistry);
                typeJobCase_ = 12;
                break;
              } // case 98
            case 106:
              {
                com.google.cloud.dataproc.v1.JobStatus m =
                    input.readMessage(
                        com.google.cloud.dataproc.v1.JobStatus.parser(), extensionRegistry);
                if (statusHistoryBuilder_ == null) {
                  ensureStatusHistoryIsMutable();
                  statusHistory_.add(m);
                } else {
                  statusHistoryBuilder_.addMessage(m);
                }
                break;
              } // case 106
            case 122:
              {
                driverControlFilesUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 122
            case 138:
              {
                driverOutputResourceUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 138
            case 146:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00020000;
                break;
              } // case 146
            case 162:
              {
                input.readMessage(getSchedulingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00040000;
                break;
              } // case 162
            case 170:
              {
                input.readMessage(getSparkRJobFieldBuilder().getBuilder(), extensionRegistry);
                typeJobCase_ = 21;
                break;
              } // case 170
            case 178:
              {
                jobUuid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00080000;
                break;
              } // case 178
            case 186:
              {
                input.readMessage(getPrestoJobFieldBuilder().getBuilder(), extensionRegistry);
                typeJobCase_ = 23;
                break;
              } // case 186
            case 192:
              {
                done_ = input.readBool();
                bitField0_ |= 0x00100000;
                break;
              } // case 192
            case 218:
              {
                input.readMessage(
                    getDriverSchedulingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00200000;
                break;
              } // case 218
            case 226:
              {
                input.readMessage(getTrinoJobFieldBuilder().getBuilder(), extensionRegistry);
                typeJobCase_ = 28;
                break;
              } // case 226
            case 234:
              {
                input.readMessage(getFlinkJobFieldBuilder().getBuilder(), extensionRegistry);
                typeJobCase_ = 29;
                break;
              } // case 234
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int typeJobCase_ = 0;
    private java.lang.Object typeJob_;

    public TypeJobCase getTypeJobCase() {
      return TypeJobCase.forNumber(typeJobCase_);
    }

    public Builder clearTypeJob() {
      typeJobCase_ = 0;
      typeJob_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.cloud.dataproc.v1.JobReference reference_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.JobReference,
            com.google.cloud.dataproc.v1.JobReference.Builder,
            com.google.cloud.dataproc.v1.JobReferenceOrBuilder>
        referenceBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The fully qualified reference to the job, which can be used to
     * obtain the equivalent REST path of the job resource. If this property
     * is not specified when a job is created, the server generates a
     * &lt;code&gt;job_id&lt;/code&gt;.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobReference reference = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the reference field is set.
     */
    public boolean hasReference() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The fully qualified reference to the job, which can be used to
     * obtain the equivalent REST path of the job resource. If this property
     * is not specified when a job is created, the server generates a
     * &lt;code&gt;job_id&lt;/code&gt;.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobReference reference = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The reference.
     */
    public com.google.cloud.dataproc.v1.JobReference getReference() {
      if (referenceBuilder_ == null) {
        return reference_ == null
            ? com.google.cloud.dataproc.v1.JobReference.getDefaultInstance()
            : reference_;
      } else {
        return referenceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The fully qualified reference to the job, which can be used to
     * obtain the equivalent REST path of the job resource. If this property
     * is not specified when a job is created, the server generates a
     * &lt;code&gt;job_id&lt;/code&gt;.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobReference reference = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setReference(com.google.cloud.dataproc.v1.JobReference value) {
      if (referenceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        reference_ = value;
      } else {
        referenceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The fully qualified reference to the job, which can be used to
     * obtain the equivalent REST path of the job resource. If this property
     * is not specified when a job is created, the server generates a
     * &lt;code&gt;job_id&lt;/code&gt;.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobReference reference = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setReference(com.google.cloud.dataproc.v1.JobReference.Builder builderForValue) {
      if (referenceBuilder_ == null) {
        reference_ = builderForValue.build();
      } else {
        referenceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The fully qualified reference to the job, which can be used to
     * obtain the equivalent REST path of the job resource. If this property
     * is not specified when a job is created, the server generates a
     * &lt;code&gt;job_id&lt;/code&gt;.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobReference reference = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeReference(com.google.cloud.dataproc.v1.JobReference value) {
      if (referenceBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && reference_ != null
            && reference_ != com.google.cloud.dataproc.v1.JobReference.getDefaultInstance()) {
          getReferenceBuilder().mergeFrom(value);
        } else {
          reference_ = value;
        }
      } else {
        referenceBuilder_.mergeFrom(value);
      }
      if (reference_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The fully qualified reference to the job, which can be used to
     * obtain the equivalent REST path of the job resource. If this property
     * is not specified when a job is created, the server generates a
     * &lt;code&gt;job_id&lt;/code&gt;.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobReference reference = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearReference() {
      bitField0_ = (bitField0_ & ~0x00000001);
      reference_ = null;
      if (referenceBuilder_ != null) {
        referenceBuilder_.dispose();
        referenceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The fully qualified reference to the job, which can be used to
     * obtain the equivalent REST path of the job resource. If this property
     * is not specified when a job is created, the server generates a
     * &lt;code&gt;job_id&lt;/code&gt;.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobReference reference = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.JobReference.Builder getReferenceBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getReferenceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The fully qualified reference to the job, which can be used to
     * obtain the equivalent REST path of the job resource. If this property
     * is not specified when a job is created, the server generates a
     * &lt;code&gt;job_id&lt;/code&gt;.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobReference reference = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.JobReferenceOrBuilder getReferenceOrBuilder() {
      if (referenceBuilder_ != null) {
        return referenceBuilder_.getMessageOrBuilder();
      } else {
        return reference_ == null
            ? com.google.cloud.dataproc.v1.JobReference.getDefaultInstance()
            : reference_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The fully qualified reference to the job, which can be used to
     * obtain the equivalent REST path of the job resource. If this property
     * is not specified when a job is created, the server generates a
     * &lt;code&gt;job_id&lt;/code&gt;.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobReference reference = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.JobReference,
            com.google.cloud.dataproc.v1.JobReference.Builder,
            com.google.cloud.dataproc.v1.JobReferenceOrBuilder>
        getReferenceFieldBuilder() {
      if (referenceBuilder_ == null) {
        referenceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.JobReference,
                com.google.cloud.dataproc.v1.JobReference.Builder,
                com.google.cloud.dataproc.v1.JobReferenceOrBuilder>(
                getReference(), getParentForChildren(), isClean());
        reference_ = null;
      }
      return referenceBuilder_;
    }

    private com.google.cloud.dataproc.v1.JobPlacement placement_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.JobPlacement,
            com.google.cloud.dataproc.v1.JobPlacement.Builder,
            com.google.cloud.dataproc.v1.JobPlacementOrBuilder>
        placementBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Job information, including how, when, and where to
     * run the job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobPlacement placement = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the placement field is set.
     */
    public boolean hasPlacement() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Job information, including how, when, and where to
     * run the job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobPlacement placement = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The placement.
     */
    public com.google.cloud.dataproc.v1.JobPlacement getPlacement() {
      if (placementBuilder_ == null) {
        return placement_ == null
            ? com.google.cloud.dataproc.v1.JobPlacement.getDefaultInstance()
            : placement_;
      } else {
        return placementBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Job information, including how, when, and where to
     * run the job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobPlacement placement = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPlacement(com.google.cloud.dataproc.v1.JobPlacement value) {
      if (placementBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        placement_ = value;
      } else {
        placementBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Job information, including how, when, and where to
     * run the job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobPlacement placement = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setPlacement(com.google.cloud.dataproc.v1.JobPlacement.Builder builderForValue) {
      if (placementBuilder_ == null) {
        placement_ = builderForValue.build();
      } else {
        placementBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Job information, including how, when, and where to
     * run the job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobPlacement placement = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergePlacement(com.google.cloud.dataproc.v1.JobPlacement value) {
      if (placementBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && placement_ != null
            && placement_ != com.google.cloud.dataproc.v1.JobPlacement.getDefaultInstance()) {
          getPlacementBuilder().mergeFrom(value);
        } else {
          placement_ = value;
        }
      } else {
        placementBuilder_.mergeFrom(value);
      }
      if (placement_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Job information, including how, when, and where to
     * run the job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobPlacement placement = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearPlacement() {
      bitField0_ = (bitField0_ & ~0x00000002);
      placement_ = null;
      if (placementBuilder_ != null) {
        placementBuilder_.dispose();
        placementBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Job information, including how, when, and where to
     * run the job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobPlacement placement = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.JobPlacement.Builder getPlacementBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getPlacementFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Job information, including how, when, and where to
     * run the job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobPlacement placement = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.dataproc.v1.JobPlacementOrBuilder getPlacementOrBuilder() {
      if (placementBuilder_ != null) {
        return placementBuilder_.getMessageOrBuilder();
      } else {
        return placement_ == null
            ? com.google.cloud.dataproc.v1.JobPlacement.getDefaultInstance()
            : placement_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Job information, including how, when, and where to
     * run the job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobPlacement placement = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.JobPlacement,
            com.google.cloud.dataproc.v1.JobPlacement.Builder,
            com.google.cloud.dataproc.v1.JobPlacementOrBuilder>
        getPlacementFieldBuilder() {
      if (placementBuilder_ == null) {
        placementBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.JobPlacement,
                com.google.cloud.dataproc.v1.JobPlacement.Builder,
                com.google.cloud.dataproc.v1.JobPlacementOrBuilder>(
                getPlacement(), getParentForChildren(), isClean());
        placement_ = null;
      }
      return placementBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.HadoopJob,
            com.google.cloud.dataproc.v1.HadoopJob.Builder,
            com.google.cloud.dataproc.v1.HadoopJobOrBuilder>
        hadoopJobBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Job is a Hadoop job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.HadoopJob hadoop_job = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the hadoopJob field is set.
     */
    @java.lang.Override
    public boolean hasHadoopJob() {
      return typeJobCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Hadoop job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.HadoopJob hadoop_job = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The hadoopJob.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.HadoopJob getHadoopJob() {
      if (hadoopJobBuilder_ == null) {
        if (typeJobCase_ == 3) {
          return (com.google.cloud.dataproc.v1.HadoopJob) typeJob_;
        }
        return com.google.cloud.dataproc.v1.HadoopJob.getDefaultInstance();
      } else {
        if (typeJobCase_ == 3) {
          return hadoopJobBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.HadoopJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Hadoop job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.HadoopJob hadoop_job = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setHadoopJob(com.google.cloud.dataproc.v1.HadoopJob value) {
      if (hadoopJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        typeJob_ = value;
        onChanged();
      } else {
        hadoopJobBuilder_.setMessage(value);
      }
      typeJobCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Hadoop job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.HadoopJob hadoop_job = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setHadoopJob(com.google.cloud.dataproc.v1.HadoopJob.Builder builderForValue) {
      if (hadoopJobBuilder_ == null) {
        typeJob_ = builderForValue.build();
        onChanged();
      } else {
        hadoopJobBuilder_.setMessage(builderForValue.build());
      }
      typeJobCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Hadoop job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.HadoopJob hadoop_job = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeHadoopJob(com.google.cloud.dataproc.v1.HadoopJob value) {
      if (hadoopJobBuilder_ == null) {
        if (typeJobCase_ == 3
            && typeJob_ != com.google.cloud.dataproc.v1.HadoopJob.getDefaultInstance()) {
          typeJob_ =
              com.google.cloud.dataproc.v1.HadoopJob.newBuilder(
                      (com.google.cloud.dataproc.v1.HadoopJob) typeJob_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          typeJob_ = value;
        }
        onChanged();
      } else {
        if (typeJobCase_ == 3) {
          hadoopJobBuilder_.mergeFrom(value);
        } else {
          hadoopJobBuilder_.setMessage(value);
        }
      }
      typeJobCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Hadoop job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.HadoopJob hadoop_job = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearHadoopJob() {
      if (hadoopJobBuilder_ == null) {
        if (typeJobCase_ == 3) {
          typeJobCase_ = 0;
          typeJob_ = null;
          onChanged();
        }
      } else {
        if (typeJobCase_ == 3) {
          typeJobCase_ = 0;
          typeJob_ = null;
        }
        hadoopJobBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Hadoop job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.HadoopJob hadoop_job = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.HadoopJob.Builder getHadoopJobBuilder() {
      return getHadoopJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Hadoop job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.HadoopJob hadoop_job = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.HadoopJobOrBuilder getHadoopJobOrBuilder() {
      if ((typeJobCase_ == 3) && (hadoopJobBuilder_ != null)) {
        return hadoopJobBuilder_.getMessageOrBuilder();
      } else {
        if (typeJobCase_ == 3) {
          return (com.google.cloud.dataproc.v1.HadoopJob) typeJob_;
        }
        return com.google.cloud.dataproc.v1.HadoopJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Hadoop job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.HadoopJob hadoop_job = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.HadoopJob,
            com.google.cloud.dataproc.v1.HadoopJob.Builder,
            com.google.cloud.dataproc.v1.HadoopJobOrBuilder>
        getHadoopJobFieldBuilder() {
      if (hadoopJobBuilder_ == null) {
        if (!(typeJobCase_ == 3)) {
          typeJob_ = com.google.cloud.dataproc.v1.HadoopJob.getDefaultInstance();
        }
        hadoopJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.HadoopJob,
                com.google.cloud.dataproc.v1.HadoopJob.Builder,
                com.google.cloud.dataproc.v1.HadoopJobOrBuilder>(
                (com.google.cloud.dataproc.v1.HadoopJob) typeJob_,
                getParentForChildren(),
                isClean());
        typeJob_ = null;
      }
      typeJobCase_ = 3;
      onChanged();
      return hadoopJobBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.SparkJob,
            com.google.cloud.dataproc.v1.SparkJob.Builder,
            com.google.cloud.dataproc.v1.SparkJobOrBuilder>
        sparkJobBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Job is a Spark job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkJob spark_job = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sparkJob field is set.
     */
    @java.lang.Override
    public boolean hasSparkJob() {
      return typeJobCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Spark job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkJob spark_job = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sparkJob.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkJob getSparkJob() {
      if (sparkJobBuilder_ == null) {
        if (typeJobCase_ == 4) {
          return (com.google.cloud.dataproc.v1.SparkJob) typeJob_;
        }
        return com.google.cloud.dataproc.v1.SparkJob.getDefaultInstance();
      } else {
        if (typeJobCase_ == 4) {
          return sparkJobBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.SparkJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Spark job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkJob spark_job = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSparkJob(com.google.cloud.dataproc.v1.SparkJob value) {
      if (sparkJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        typeJob_ = value;
        onChanged();
      } else {
        sparkJobBuilder_.setMessage(value);
      }
      typeJobCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Spark job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkJob spark_job = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSparkJob(com.google.cloud.dataproc.v1.SparkJob.Builder builderForValue) {
      if (sparkJobBuilder_ == null) {
        typeJob_ = builderForValue.build();
        onChanged();
      } else {
        sparkJobBuilder_.setMessage(builderForValue.build());
      }
      typeJobCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Spark job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkJob spark_job = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSparkJob(com.google.cloud.dataproc.v1.SparkJob value) {
      if (sparkJobBuilder_ == null) {
        if (typeJobCase_ == 4
            && typeJob_ != com.google.cloud.dataproc.v1.SparkJob.getDefaultInstance()) {
          typeJob_ =
              com.google.cloud.dataproc.v1.SparkJob.newBuilder(
                      (com.google.cloud.dataproc.v1.SparkJob) typeJob_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          typeJob_ = value;
        }
        onChanged();
      } else {
        if (typeJobCase_ == 4) {
          sparkJobBuilder_.mergeFrom(value);
        } else {
          sparkJobBuilder_.setMessage(value);
        }
      }
      typeJobCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Spark job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkJob spark_job = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSparkJob() {
      if (sparkJobBuilder_ == null) {
        if (typeJobCase_ == 4) {
          typeJobCase_ = 0;
          typeJob_ = null;
          onChanged();
        }
      } else {
        if (typeJobCase_ == 4) {
          typeJobCase_ = 0;
          typeJob_ = null;
        }
        sparkJobBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Spark job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkJob spark_job = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.SparkJob.Builder getSparkJobBuilder() {
      return getSparkJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Spark job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkJob spark_job = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkJobOrBuilder getSparkJobOrBuilder() {
      if ((typeJobCase_ == 4) && (sparkJobBuilder_ != null)) {
        return sparkJobBuilder_.getMessageOrBuilder();
      } else {
        if (typeJobCase_ == 4) {
          return (com.google.cloud.dataproc.v1.SparkJob) typeJob_;
        }
        return com.google.cloud.dataproc.v1.SparkJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Spark job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkJob spark_job = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.SparkJob,
            com.google.cloud.dataproc.v1.SparkJob.Builder,
            com.google.cloud.dataproc.v1.SparkJobOrBuilder>
        getSparkJobFieldBuilder() {
      if (sparkJobBuilder_ == null) {
        if (!(typeJobCase_ == 4)) {
          typeJob_ = com.google.cloud.dataproc.v1.SparkJob.getDefaultInstance();
        }
        sparkJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.SparkJob,
                com.google.cloud.dataproc.v1.SparkJob.Builder,
                com.google.cloud.dataproc.v1.SparkJobOrBuilder>(
                (com.google.cloud.dataproc.v1.SparkJob) typeJob_,
                getParentForChildren(),
                isClean());
        typeJob_ = null;
      }
      typeJobCase_ = 4;
      onChanged();
      return sparkJobBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.PySparkJob,
            com.google.cloud.dataproc.v1.PySparkJob.Builder,
            com.google.cloud.dataproc.v1.PySparkJobOrBuilder>
        pysparkJobBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Job is a PySpark job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PySparkJob pyspark_job = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the pysparkJob field is set.
     */
    @java.lang.Override
    public boolean hasPysparkJob() {
      return typeJobCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a PySpark job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PySparkJob pyspark_job = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The pysparkJob.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.PySparkJob getPysparkJob() {
      if (pysparkJobBuilder_ == null) {
        if (typeJobCase_ == 5) {
          return (com.google.cloud.dataproc.v1.PySparkJob) typeJob_;
        }
        return com.google.cloud.dataproc.v1.PySparkJob.getDefaultInstance();
      } else {
        if (typeJobCase_ == 5) {
          return pysparkJobBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.PySparkJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a PySpark job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PySparkJob pyspark_job = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPysparkJob(com.google.cloud.dataproc.v1.PySparkJob value) {
      if (pysparkJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        typeJob_ = value;
        onChanged();
      } else {
        pysparkJobBuilder_.setMessage(value);
      }
      typeJobCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a PySpark job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PySparkJob pyspark_job = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPysparkJob(com.google.cloud.dataproc.v1.PySparkJob.Builder builderForValue) {
      if (pysparkJobBuilder_ == null) {
        typeJob_ = builderForValue.build();
        onChanged();
      } else {
        pysparkJobBuilder_.setMessage(builderForValue.build());
      }
      typeJobCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a PySpark job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PySparkJob pyspark_job = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePysparkJob(com.google.cloud.dataproc.v1.PySparkJob value) {
      if (pysparkJobBuilder_ == null) {
        if (typeJobCase_ == 5
            && typeJob_ != com.google.cloud.dataproc.v1.PySparkJob.getDefaultInstance()) {
          typeJob_ =
              com.google.cloud.dataproc.v1.PySparkJob.newBuilder(
                      (com.google.cloud.dataproc.v1.PySparkJob) typeJob_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          typeJob_ = value;
        }
        onChanged();
      } else {
        if (typeJobCase_ == 5) {
          pysparkJobBuilder_.mergeFrom(value);
        } else {
          pysparkJobBuilder_.setMessage(value);
        }
      }
      typeJobCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a PySpark job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PySparkJob pyspark_job = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPysparkJob() {
      if (pysparkJobBuilder_ == null) {
        if (typeJobCase_ == 5) {
          typeJobCase_ = 0;
          typeJob_ = null;
          onChanged();
        }
      } else {
        if (typeJobCase_ == 5) {
          typeJobCase_ = 0;
          typeJob_ = null;
        }
        pysparkJobBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a PySpark job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PySparkJob pyspark_job = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.PySparkJob.Builder getPysparkJobBuilder() {
      return getPysparkJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a PySpark job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PySparkJob pyspark_job = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.PySparkJobOrBuilder getPysparkJobOrBuilder() {
      if ((typeJobCase_ == 5) && (pysparkJobBuilder_ != null)) {
        return pysparkJobBuilder_.getMessageOrBuilder();
      } else {
        if (typeJobCase_ == 5) {
          return (com.google.cloud.dataproc.v1.PySparkJob) typeJob_;
        }
        return com.google.cloud.dataproc.v1.PySparkJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a PySpark job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PySparkJob pyspark_job = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.PySparkJob,
            com.google.cloud.dataproc.v1.PySparkJob.Builder,
            com.google.cloud.dataproc.v1.PySparkJobOrBuilder>
        getPysparkJobFieldBuilder() {
      if (pysparkJobBuilder_ == null) {
        if (!(typeJobCase_ == 5)) {
          typeJob_ = com.google.cloud.dataproc.v1.PySparkJob.getDefaultInstance();
        }
        pysparkJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.PySparkJob,
                com.google.cloud.dataproc.v1.PySparkJob.Builder,
                com.google.cloud.dataproc.v1.PySparkJobOrBuilder>(
                (com.google.cloud.dataproc.v1.PySparkJob) typeJob_,
                getParentForChildren(),
                isClean());
        typeJob_ = null;
      }
      typeJobCase_ = 5;
      onChanged();
      return pysparkJobBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.HiveJob,
            com.google.cloud.dataproc.v1.HiveJob.Builder,
            com.google.cloud.dataproc.v1.HiveJobOrBuilder>
        hiveJobBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Job is a Hive job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.HiveJob hive_job = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the hiveJob field is set.
     */
    @java.lang.Override
    public boolean hasHiveJob() {
      return typeJobCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Hive job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.HiveJob hive_job = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The hiveJob.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.HiveJob getHiveJob() {
      if (hiveJobBuilder_ == null) {
        if (typeJobCase_ == 6) {
          return (com.google.cloud.dataproc.v1.HiveJob) typeJob_;
        }
        return com.google.cloud.dataproc.v1.HiveJob.getDefaultInstance();
      } else {
        if (typeJobCase_ == 6) {
          return hiveJobBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.HiveJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Hive job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.HiveJob hive_job = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setHiveJob(com.google.cloud.dataproc.v1.HiveJob value) {
      if (hiveJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        typeJob_ = value;
        onChanged();
      } else {
        hiveJobBuilder_.setMessage(value);
      }
      typeJobCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Hive job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.HiveJob hive_job = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setHiveJob(com.google.cloud.dataproc.v1.HiveJob.Builder builderForValue) {
      if (hiveJobBuilder_ == null) {
        typeJob_ = builderForValue.build();
        onChanged();
      } else {
        hiveJobBuilder_.setMessage(builderForValue.build());
      }
      typeJobCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Hive job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.HiveJob hive_job = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeHiveJob(com.google.cloud.dataproc.v1.HiveJob value) {
      if (hiveJobBuilder_ == null) {
        if (typeJobCase_ == 6
            && typeJob_ != com.google.cloud.dataproc.v1.HiveJob.getDefaultInstance()) {
          typeJob_ =
              com.google.cloud.dataproc.v1.HiveJob.newBuilder(
                      (com.google.cloud.dataproc.v1.HiveJob) typeJob_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          typeJob_ = value;
        }
        onChanged();
      } else {
        if (typeJobCase_ == 6) {
          hiveJobBuilder_.mergeFrom(value);
        } else {
          hiveJobBuilder_.setMessage(value);
        }
      }
      typeJobCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Hive job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.HiveJob hive_job = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearHiveJob() {
      if (hiveJobBuilder_ == null) {
        if (typeJobCase_ == 6) {
          typeJobCase_ = 0;
          typeJob_ = null;
          onChanged();
        }
      } else {
        if (typeJobCase_ == 6) {
          typeJobCase_ = 0;
          typeJob_ = null;
        }
        hiveJobBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Hive job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.HiveJob hive_job = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.HiveJob.Builder getHiveJobBuilder() {
      return getHiveJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Hive job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.HiveJob hive_job = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.HiveJobOrBuilder getHiveJobOrBuilder() {
      if ((typeJobCase_ == 6) && (hiveJobBuilder_ != null)) {
        return hiveJobBuilder_.getMessageOrBuilder();
      } else {
        if (typeJobCase_ == 6) {
          return (com.google.cloud.dataproc.v1.HiveJob) typeJob_;
        }
        return com.google.cloud.dataproc.v1.HiveJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Hive job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.HiveJob hive_job = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.HiveJob,
            com.google.cloud.dataproc.v1.HiveJob.Builder,
            com.google.cloud.dataproc.v1.HiveJobOrBuilder>
        getHiveJobFieldBuilder() {
      if (hiveJobBuilder_ == null) {
        if (!(typeJobCase_ == 6)) {
          typeJob_ = com.google.cloud.dataproc.v1.HiveJob.getDefaultInstance();
        }
        hiveJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.HiveJob,
                com.google.cloud.dataproc.v1.HiveJob.Builder,
                com.google.cloud.dataproc.v1.HiveJobOrBuilder>(
                (com.google.cloud.dataproc.v1.HiveJob) typeJob_, getParentForChildren(), isClean());
        typeJob_ = null;
      }
      typeJobCase_ = 6;
      onChanged();
      return hiveJobBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.PigJob,
            com.google.cloud.dataproc.v1.PigJob.Builder,
            com.google.cloud.dataproc.v1.PigJobOrBuilder>
        pigJobBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Job is a Pig job.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.PigJob pig_job = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the pigJob field is set.
     */
    @java.lang.Override
    public boolean hasPigJob() {
      return typeJobCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Pig job.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.PigJob pig_job = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The pigJob.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.PigJob getPigJob() {
      if (pigJobBuilder_ == null) {
        if (typeJobCase_ == 7) {
          return (com.google.cloud.dataproc.v1.PigJob) typeJob_;
        }
        return com.google.cloud.dataproc.v1.PigJob.getDefaultInstance();
      } else {
        if (typeJobCase_ == 7) {
          return pigJobBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.PigJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Pig job.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.PigJob pig_job = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPigJob(com.google.cloud.dataproc.v1.PigJob value) {
      if (pigJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        typeJob_ = value;
        onChanged();
      } else {
        pigJobBuilder_.setMessage(value);
      }
      typeJobCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Pig job.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.PigJob pig_job = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPigJob(com.google.cloud.dataproc.v1.PigJob.Builder builderForValue) {
      if (pigJobBuilder_ == null) {
        typeJob_ = builderForValue.build();
        onChanged();
      } else {
        pigJobBuilder_.setMessage(builderForValue.build());
      }
      typeJobCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Pig job.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.PigJob pig_job = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePigJob(com.google.cloud.dataproc.v1.PigJob value) {
      if (pigJobBuilder_ == null) {
        if (typeJobCase_ == 7
            && typeJob_ != com.google.cloud.dataproc.v1.PigJob.getDefaultInstance()) {
          typeJob_ =
              com.google.cloud.dataproc.v1.PigJob.newBuilder(
                      (com.google.cloud.dataproc.v1.PigJob) typeJob_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          typeJob_ = value;
        }
        onChanged();
      } else {
        if (typeJobCase_ == 7) {
          pigJobBuilder_.mergeFrom(value);
        } else {
          pigJobBuilder_.setMessage(value);
        }
      }
      typeJobCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Pig job.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.PigJob pig_job = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPigJob() {
      if (pigJobBuilder_ == null) {
        if (typeJobCase_ == 7) {
          typeJobCase_ = 0;
          typeJob_ = null;
          onChanged();
        }
      } else {
        if (typeJobCase_ == 7) {
          typeJobCase_ = 0;
          typeJob_ = null;
        }
        pigJobBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Pig job.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.PigJob pig_job = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.PigJob.Builder getPigJobBuilder() {
      return getPigJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Pig job.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.PigJob pig_job = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.PigJobOrBuilder getPigJobOrBuilder() {
      if ((typeJobCase_ == 7) && (pigJobBuilder_ != null)) {
        return pigJobBuilder_.getMessageOrBuilder();
      } else {
        if (typeJobCase_ == 7) {
          return (com.google.cloud.dataproc.v1.PigJob) typeJob_;
        }
        return com.google.cloud.dataproc.v1.PigJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Pig job.
     * </pre>
     *
     * <code>.google.cloud.dataproc.v1.PigJob pig_job = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.PigJob,
            com.google.cloud.dataproc.v1.PigJob.Builder,
            com.google.cloud.dataproc.v1.PigJobOrBuilder>
        getPigJobFieldBuilder() {
      if (pigJobBuilder_ == null) {
        if (!(typeJobCase_ == 7)) {
          typeJob_ = com.google.cloud.dataproc.v1.PigJob.getDefaultInstance();
        }
        pigJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.PigJob,
                com.google.cloud.dataproc.v1.PigJob.Builder,
                com.google.cloud.dataproc.v1.PigJobOrBuilder>(
                (com.google.cloud.dataproc.v1.PigJob) typeJob_, getParentForChildren(), isClean());
        typeJob_ = null;
      }
      typeJobCase_ = 7;
      onChanged();
      return pigJobBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.SparkRJob,
            com.google.cloud.dataproc.v1.SparkRJob.Builder,
            com.google.cloud.dataproc.v1.SparkRJobOrBuilder>
        sparkRJobBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Job is a SparkR job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkRJob spark_r_job = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sparkRJob field is set.
     */
    @java.lang.Override
    public boolean hasSparkRJob() {
      return typeJobCase_ == 21;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a SparkR job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkRJob spark_r_job = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sparkRJob.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkRJob getSparkRJob() {
      if (sparkRJobBuilder_ == null) {
        if (typeJobCase_ == 21) {
          return (com.google.cloud.dataproc.v1.SparkRJob) typeJob_;
        }
        return com.google.cloud.dataproc.v1.SparkRJob.getDefaultInstance();
      } else {
        if (typeJobCase_ == 21) {
          return sparkRJobBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.SparkRJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a SparkR job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkRJob spark_r_job = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSparkRJob(com.google.cloud.dataproc.v1.SparkRJob value) {
      if (sparkRJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        typeJob_ = value;
        onChanged();
      } else {
        sparkRJobBuilder_.setMessage(value);
      }
      typeJobCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a SparkR job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkRJob spark_r_job = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSparkRJob(com.google.cloud.dataproc.v1.SparkRJob.Builder builderForValue) {
      if (sparkRJobBuilder_ == null) {
        typeJob_ = builderForValue.build();
        onChanged();
      } else {
        sparkRJobBuilder_.setMessage(builderForValue.build());
      }
      typeJobCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a SparkR job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkRJob spark_r_job = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSparkRJob(com.google.cloud.dataproc.v1.SparkRJob value) {
      if (sparkRJobBuilder_ == null) {
        if (typeJobCase_ == 21
            && typeJob_ != com.google.cloud.dataproc.v1.SparkRJob.getDefaultInstance()) {
          typeJob_ =
              com.google.cloud.dataproc.v1.SparkRJob.newBuilder(
                      (com.google.cloud.dataproc.v1.SparkRJob) typeJob_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          typeJob_ = value;
        }
        onChanged();
      } else {
        if (typeJobCase_ == 21) {
          sparkRJobBuilder_.mergeFrom(value);
        } else {
          sparkRJobBuilder_.setMessage(value);
        }
      }
      typeJobCase_ = 21;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a SparkR job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkRJob spark_r_job = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSparkRJob() {
      if (sparkRJobBuilder_ == null) {
        if (typeJobCase_ == 21) {
          typeJobCase_ = 0;
          typeJob_ = null;
          onChanged();
        }
      } else {
        if (typeJobCase_ == 21) {
          typeJobCase_ = 0;
          typeJob_ = null;
        }
        sparkRJobBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a SparkR job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkRJob spark_r_job = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.SparkRJob.Builder getSparkRJobBuilder() {
      return getSparkRJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a SparkR job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkRJob spark_r_job = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkRJobOrBuilder getSparkRJobOrBuilder() {
      if ((typeJobCase_ == 21) && (sparkRJobBuilder_ != null)) {
        return sparkRJobBuilder_.getMessageOrBuilder();
      } else {
        if (typeJobCase_ == 21) {
          return (com.google.cloud.dataproc.v1.SparkRJob) typeJob_;
        }
        return com.google.cloud.dataproc.v1.SparkRJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a SparkR job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkRJob spark_r_job = 21 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.SparkRJob,
            com.google.cloud.dataproc.v1.SparkRJob.Builder,
            com.google.cloud.dataproc.v1.SparkRJobOrBuilder>
        getSparkRJobFieldBuilder() {
      if (sparkRJobBuilder_ == null) {
        if (!(typeJobCase_ == 21)) {
          typeJob_ = com.google.cloud.dataproc.v1.SparkRJob.getDefaultInstance();
        }
        sparkRJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.SparkRJob,
                com.google.cloud.dataproc.v1.SparkRJob.Builder,
                com.google.cloud.dataproc.v1.SparkRJobOrBuilder>(
                (com.google.cloud.dataproc.v1.SparkRJob) typeJob_,
                getParentForChildren(),
                isClean());
        typeJob_ = null;
      }
      typeJobCase_ = 21;
      onChanged();
      return sparkRJobBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.SparkSqlJob,
            com.google.cloud.dataproc.v1.SparkSqlJob.Builder,
            com.google.cloud.dataproc.v1.SparkSqlJobOrBuilder>
        sparkSqlJobBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Job is a SparkSql job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkSqlJob spark_sql_job = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sparkSqlJob field is set.
     */
    @java.lang.Override
    public boolean hasSparkSqlJob() {
      return typeJobCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a SparkSql job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkSqlJob spark_sql_job = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sparkSqlJob.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkSqlJob getSparkSqlJob() {
      if (sparkSqlJobBuilder_ == null) {
        if (typeJobCase_ == 12) {
          return (com.google.cloud.dataproc.v1.SparkSqlJob) typeJob_;
        }
        return com.google.cloud.dataproc.v1.SparkSqlJob.getDefaultInstance();
      } else {
        if (typeJobCase_ == 12) {
          return sparkSqlJobBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.SparkSqlJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a SparkSql job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkSqlJob spark_sql_job = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSparkSqlJob(com.google.cloud.dataproc.v1.SparkSqlJob value) {
      if (sparkSqlJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        typeJob_ = value;
        onChanged();
      } else {
        sparkSqlJobBuilder_.setMessage(value);
      }
      typeJobCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a SparkSql job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkSqlJob spark_sql_job = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSparkSqlJob(
        com.google.cloud.dataproc.v1.SparkSqlJob.Builder builderForValue) {
      if (sparkSqlJobBuilder_ == null) {
        typeJob_ = builderForValue.build();
        onChanged();
      } else {
        sparkSqlJobBuilder_.setMessage(builderForValue.build());
      }
      typeJobCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a SparkSql job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkSqlJob spark_sql_job = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSparkSqlJob(com.google.cloud.dataproc.v1.SparkSqlJob value) {
      if (sparkSqlJobBuilder_ == null) {
        if (typeJobCase_ == 12
            && typeJob_ != com.google.cloud.dataproc.v1.SparkSqlJob.getDefaultInstance()) {
          typeJob_ =
              com.google.cloud.dataproc.v1.SparkSqlJob.newBuilder(
                      (com.google.cloud.dataproc.v1.SparkSqlJob) typeJob_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          typeJob_ = value;
        }
        onChanged();
      } else {
        if (typeJobCase_ == 12) {
          sparkSqlJobBuilder_.mergeFrom(value);
        } else {
          sparkSqlJobBuilder_.setMessage(value);
        }
      }
      typeJobCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a SparkSql job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkSqlJob spark_sql_job = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSparkSqlJob() {
      if (sparkSqlJobBuilder_ == null) {
        if (typeJobCase_ == 12) {
          typeJobCase_ = 0;
          typeJob_ = null;
          onChanged();
        }
      } else {
        if (typeJobCase_ == 12) {
          typeJobCase_ = 0;
          typeJob_ = null;
        }
        sparkSqlJobBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a SparkSql job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkSqlJob spark_sql_job = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.SparkSqlJob.Builder getSparkSqlJobBuilder() {
      return getSparkSqlJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a SparkSql job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkSqlJob spark_sql_job = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkSqlJobOrBuilder getSparkSqlJobOrBuilder() {
      if ((typeJobCase_ == 12) && (sparkSqlJobBuilder_ != null)) {
        return sparkSqlJobBuilder_.getMessageOrBuilder();
      } else {
        if (typeJobCase_ == 12) {
          return (com.google.cloud.dataproc.v1.SparkSqlJob) typeJob_;
        }
        return com.google.cloud.dataproc.v1.SparkSqlJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a SparkSql job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkSqlJob spark_sql_job = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.SparkSqlJob,
            com.google.cloud.dataproc.v1.SparkSqlJob.Builder,
            com.google.cloud.dataproc.v1.SparkSqlJobOrBuilder>
        getSparkSqlJobFieldBuilder() {
      if (sparkSqlJobBuilder_ == null) {
        if (!(typeJobCase_ == 12)) {
          typeJob_ = com.google.cloud.dataproc.v1.SparkSqlJob.getDefaultInstance();
        }
        sparkSqlJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.SparkSqlJob,
                com.google.cloud.dataproc.v1.SparkSqlJob.Builder,
                com.google.cloud.dataproc.v1.SparkSqlJobOrBuilder>(
                (com.google.cloud.dataproc.v1.SparkSqlJob) typeJob_,
                getParentForChildren(),
                isClean());
        typeJob_ = null;
      }
      typeJobCase_ = 12;
      onChanged();
      return sparkSqlJobBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.PrestoJob,
            com.google.cloud.dataproc.v1.PrestoJob.Builder,
            com.google.cloud.dataproc.v1.PrestoJobOrBuilder>
        prestoJobBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Job is a Presto job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PrestoJob presto_job = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the prestoJob field is set.
     */
    @java.lang.Override
    public boolean hasPrestoJob() {
      return typeJobCase_ == 23;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Presto job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PrestoJob presto_job = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The prestoJob.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.PrestoJob getPrestoJob() {
      if (prestoJobBuilder_ == null) {
        if (typeJobCase_ == 23) {
          return (com.google.cloud.dataproc.v1.PrestoJob) typeJob_;
        }
        return com.google.cloud.dataproc.v1.PrestoJob.getDefaultInstance();
      } else {
        if (typeJobCase_ == 23) {
          return prestoJobBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.PrestoJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Presto job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PrestoJob presto_job = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPrestoJob(com.google.cloud.dataproc.v1.PrestoJob value) {
      if (prestoJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        typeJob_ = value;
        onChanged();
      } else {
        prestoJobBuilder_.setMessage(value);
      }
      typeJobCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Presto job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PrestoJob presto_job = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPrestoJob(com.google.cloud.dataproc.v1.PrestoJob.Builder builderForValue) {
      if (prestoJobBuilder_ == null) {
        typeJob_ = builderForValue.build();
        onChanged();
      } else {
        prestoJobBuilder_.setMessage(builderForValue.build());
      }
      typeJobCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Presto job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PrestoJob presto_job = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePrestoJob(com.google.cloud.dataproc.v1.PrestoJob value) {
      if (prestoJobBuilder_ == null) {
        if (typeJobCase_ == 23
            && typeJob_ != com.google.cloud.dataproc.v1.PrestoJob.getDefaultInstance()) {
          typeJob_ =
              com.google.cloud.dataproc.v1.PrestoJob.newBuilder(
                      (com.google.cloud.dataproc.v1.PrestoJob) typeJob_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          typeJob_ = value;
        }
        onChanged();
      } else {
        if (typeJobCase_ == 23) {
          prestoJobBuilder_.mergeFrom(value);
        } else {
          prestoJobBuilder_.setMessage(value);
        }
      }
      typeJobCase_ = 23;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Presto job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PrestoJob presto_job = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPrestoJob() {
      if (prestoJobBuilder_ == null) {
        if (typeJobCase_ == 23) {
          typeJobCase_ = 0;
          typeJob_ = null;
          onChanged();
        }
      } else {
        if (typeJobCase_ == 23) {
          typeJobCase_ = 0;
          typeJob_ = null;
        }
        prestoJobBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Presto job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PrestoJob presto_job = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.PrestoJob.Builder getPrestoJobBuilder() {
      return getPrestoJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Presto job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PrestoJob presto_job = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.PrestoJobOrBuilder getPrestoJobOrBuilder() {
      if ((typeJobCase_ == 23) && (prestoJobBuilder_ != null)) {
        return prestoJobBuilder_.getMessageOrBuilder();
      } else {
        if (typeJobCase_ == 23) {
          return (com.google.cloud.dataproc.v1.PrestoJob) typeJob_;
        }
        return com.google.cloud.dataproc.v1.PrestoJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Presto job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.PrestoJob presto_job = 23 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.PrestoJob,
            com.google.cloud.dataproc.v1.PrestoJob.Builder,
            com.google.cloud.dataproc.v1.PrestoJobOrBuilder>
        getPrestoJobFieldBuilder() {
      if (prestoJobBuilder_ == null) {
        if (!(typeJobCase_ == 23)) {
          typeJob_ = com.google.cloud.dataproc.v1.PrestoJob.getDefaultInstance();
        }
        prestoJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.PrestoJob,
                com.google.cloud.dataproc.v1.PrestoJob.Builder,
                com.google.cloud.dataproc.v1.PrestoJobOrBuilder>(
                (com.google.cloud.dataproc.v1.PrestoJob) typeJob_,
                getParentForChildren(),
                isClean());
        typeJob_ = null;
      }
      typeJobCase_ = 23;
      onChanged();
      return prestoJobBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.TrinoJob,
            com.google.cloud.dataproc.v1.TrinoJob.Builder,
            com.google.cloud.dataproc.v1.TrinoJobOrBuilder>
        trinoJobBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Job is a Trino job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.TrinoJob trino_job = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the trinoJob field is set.
     */
    @java.lang.Override
    public boolean hasTrinoJob() {
      return typeJobCase_ == 28;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Trino job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.TrinoJob trino_job = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The trinoJob.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.TrinoJob getTrinoJob() {
      if (trinoJobBuilder_ == null) {
        if (typeJobCase_ == 28) {
          return (com.google.cloud.dataproc.v1.TrinoJob) typeJob_;
        }
        return com.google.cloud.dataproc.v1.TrinoJob.getDefaultInstance();
      } else {
        if (typeJobCase_ == 28) {
          return trinoJobBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.TrinoJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Trino job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.TrinoJob trino_job = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTrinoJob(com.google.cloud.dataproc.v1.TrinoJob value) {
      if (trinoJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        typeJob_ = value;
        onChanged();
      } else {
        trinoJobBuilder_.setMessage(value);
      }
      typeJobCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Trino job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.TrinoJob trino_job = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTrinoJob(com.google.cloud.dataproc.v1.TrinoJob.Builder builderForValue) {
      if (trinoJobBuilder_ == null) {
        typeJob_ = builderForValue.build();
        onChanged();
      } else {
        trinoJobBuilder_.setMessage(builderForValue.build());
      }
      typeJobCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Trino job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.TrinoJob trino_job = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeTrinoJob(com.google.cloud.dataproc.v1.TrinoJob value) {
      if (trinoJobBuilder_ == null) {
        if (typeJobCase_ == 28
            && typeJob_ != com.google.cloud.dataproc.v1.TrinoJob.getDefaultInstance()) {
          typeJob_ =
              com.google.cloud.dataproc.v1.TrinoJob.newBuilder(
                      (com.google.cloud.dataproc.v1.TrinoJob) typeJob_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          typeJob_ = value;
        }
        onChanged();
      } else {
        if (typeJobCase_ == 28) {
          trinoJobBuilder_.mergeFrom(value);
        } else {
          trinoJobBuilder_.setMessage(value);
        }
      }
      typeJobCase_ = 28;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Trino job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.TrinoJob trino_job = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTrinoJob() {
      if (trinoJobBuilder_ == null) {
        if (typeJobCase_ == 28) {
          typeJobCase_ = 0;
          typeJob_ = null;
          onChanged();
        }
      } else {
        if (typeJobCase_ == 28) {
          typeJobCase_ = 0;
          typeJob_ = null;
        }
        trinoJobBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Trino job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.TrinoJob trino_job = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.TrinoJob.Builder getTrinoJobBuilder() {
      return getTrinoJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Trino job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.TrinoJob trino_job = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.TrinoJobOrBuilder getTrinoJobOrBuilder() {
      if ((typeJobCase_ == 28) && (trinoJobBuilder_ != null)) {
        return trinoJobBuilder_.getMessageOrBuilder();
      } else {
        if (typeJobCase_ == 28) {
          return (com.google.cloud.dataproc.v1.TrinoJob) typeJob_;
        }
        return com.google.cloud.dataproc.v1.TrinoJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Trino job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.TrinoJob trino_job = 28 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.TrinoJob,
            com.google.cloud.dataproc.v1.TrinoJob.Builder,
            com.google.cloud.dataproc.v1.TrinoJobOrBuilder>
        getTrinoJobFieldBuilder() {
      if (trinoJobBuilder_ == null) {
        if (!(typeJobCase_ == 28)) {
          typeJob_ = com.google.cloud.dataproc.v1.TrinoJob.getDefaultInstance();
        }
        trinoJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.TrinoJob,
                com.google.cloud.dataproc.v1.TrinoJob.Builder,
                com.google.cloud.dataproc.v1.TrinoJobOrBuilder>(
                (com.google.cloud.dataproc.v1.TrinoJob) typeJob_,
                getParentForChildren(),
                isClean());
        typeJob_ = null;
      }
      typeJobCase_ = 28;
      onChanged();
      return trinoJobBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.FlinkJob,
            com.google.cloud.dataproc.v1.FlinkJob.Builder,
            com.google.cloud.dataproc.v1.FlinkJobOrBuilder>
        flinkJobBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Job is a Flink job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.FlinkJob flink_job = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the flinkJob field is set.
     */
    @java.lang.Override
    public boolean hasFlinkJob() {
      return typeJobCase_ == 29;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Flink job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.FlinkJob flink_job = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The flinkJob.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.FlinkJob getFlinkJob() {
      if (flinkJobBuilder_ == null) {
        if (typeJobCase_ == 29) {
          return (com.google.cloud.dataproc.v1.FlinkJob) typeJob_;
        }
        return com.google.cloud.dataproc.v1.FlinkJob.getDefaultInstance();
      } else {
        if (typeJobCase_ == 29) {
          return flinkJobBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.FlinkJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Flink job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.FlinkJob flink_job = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFlinkJob(com.google.cloud.dataproc.v1.FlinkJob value) {
      if (flinkJobBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        typeJob_ = value;
        onChanged();
      } else {
        flinkJobBuilder_.setMessage(value);
      }
      typeJobCase_ = 29;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Flink job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.FlinkJob flink_job = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFlinkJob(com.google.cloud.dataproc.v1.FlinkJob.Builder builderForValue) {
      if (flinkJobBuilder_ == null) {
        typeJob_ = builderForValue.build();
        onChanged();
      } else {
        flinkJobBuilder_.setMessage(builderForValue.build());
      }
      typeJobCase_ = 29;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Flink job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.FlinkJob flink_job = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeFlinkJob(com.google.cloud.dataproc.v1.FlinkJob value) {
      if (flinkJobBuilder_ == null) {
        if (typeJobCase_ == 29
            && typeJob_ != com.google.cloud.dataproc.v1.FlinkJob.getDefaultInstance()) {
          typeJob_ =
              com.google.cloud.dataproc.v1.FlinkJob.newBuilder(
                      (com.google.cloud.dataproc.v1.FlinkJob) typeJob_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          typeJob_ = value;
        }
        onChanged();
      } else {
        if (typeJobCase_ == 29) {
          flinkJobBuilder_.mergeFrom(value);
        } else {
          flinkJobBuilder_.setMessage(value);
        }
      }
      typeJobCase_ = 29;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Flink job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.FlinkJob flink_job = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFlinkJob() {
      if (flinkJobBuilder_ == null) {
        if (typeJobCase_ == 29) {
          typeJobCase_ = 0;
          typeJob_ = null;
          onChanged();
        }
      } else {
        if (typeJobCase_ == 29) {
          typeJobCase_ = 0;
          typeJob_ = null;
        }
        flinkJobBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Flink job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.FlinkJob flink_job = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.FlinkJob.Builder getFlinkJobBuilder() {
      return getFlinkJobFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Flink job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.FlinkJob flink_job = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.FlinkJobOrBuilder getFlinkJobOrBuilder() {
      if ((typeJobCase_ == 29) && (flinkJobBuilder_ != null)) {
        return flinkJobBuilder_.getMessageOrBuilder();
      } else {
        if (typeJobCase_ == 29) {
          return (com.google.cloud.dataproc.v1.FlinkJob) typeJob_;
        }
        return com.google.cloud.dataproc.v1.FlinkJob.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job is a Flink job.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.FlinkJob flink_job = 29 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.FlinkJob,
            com.google.cloud.dataproc.v1.FlinkJob.Builder,
            com.google.cloud.dataproc.v1.FlinkJobOrBuilder>
        getFlinkJobFieldBuilder() {
      if (flinkJobBuilder_ == null) {
        if (!(typeJobCase_ == 29)) {
          typeJob_ = com.google.cloud.dataproc.v1.FlinkJob.getDefaultInstance();
        }
        flinkJobBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.FlinkJob,
                com.google.cloud.dataproc.v1.FlinkJob.Builder,
                com.google.cloud.dataproc.v1.FlinkJobOrBuilder>(
                (com.google.cloud.dataproc.v1.FlinkJob) typeJob_,
                getParentForChildren(),
                isClean());
        typeJob_ = null;
      }
      typeJobCase_ = 29;
      onChanged();
      return flinkJobBuilder_;
    }

    private com.google.cloud.dataproc.v1.JobStatus status_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.JobStatus,
            com.google.cloud.dataproc.v1.JobStatus.Builder,
            com.google.cloud.dataproc.v1.JobStatusOrBuilder>
        statusBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The job status. Additional application-specific
     * status information might be contained in the &lt;code&gt;type_job&lt;/code&gt;
     * and &lt;code&gt;yarn_applications&lt;/code&gt; fields.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobStatus status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The job status. Additional application-specific
     * status information might be contained in the &lt;code&gt;type_job&lt;/code&gt;
     * and &lt;code&gt;yarn_applications&lt;/code&gt; fields.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobStatus status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The status.
     */
    public com.google.cloud.dataproc.v1.JobStatus getStatus() {
      if (statusBuilder_ == null) {
        return status_ == null
            ? com.google.cloud.dataproc.v1.JobStatus.getDefaultInstance()
            : status_;
      } else {
        return statusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The job status. Additional application-specific
     * status information might be contained in the &lt;code&gt;type_job&lt;/code&gt;
     * and &lt;code&gt;yarn_applications&lt;/code&gt; fields.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobStatus status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatus(com.google.cloud.dataproc.v1.JobStatus value) {
      if (statusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
      } else {
        statusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The job status. Additional application-specific
     * status information might be contained in the &lt;code&gt;type_job&lt;/code&gt;
     * and &lt;code&gt;yarn_applications&lt;/code&gt; fields.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobStatus status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatus(com.google.cloud.dataproc.v1.JobStatus.Builder builderForValue) {
      if (statusBuilder_ == null) {
        status_ = builderForValue.build();
      } else {
        statusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The job status. Additional application-specific
     * status information might be contained in the &lt;code&gt;type_job&lt;/code&gt;
     * and &lt;code&gt;yarn_applications&lt;/code&gt; fields.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobStatus status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStatus(com.google.cloud.dataproc.v1.JobStatus value) {
      if (statusBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && status_ != null
            && status_ != com.google.cloud.dataproc.v1.JobStatus.getDefaultInstance()) {
          getStatusBuilder().mergeFrom(value);
        } else {
          status_ = value;
        }
      } else {
        statusBuilder_.mergeFrom(value);
      }
      if (status_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The job status. Additional application-specific
     * status information might be contained in the &lt;code&gt;type_job&lt;/code&gt;
     * and &lt;code&gt;yarn_applications&lt;/code&gt; fields.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobStatus status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00001000);
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The job status. Additional application-specific
     * status information might be contained in the &lt;code&gt;type_job&lt;/code&gt;
     * and &lt;code&gt;yarn_applications&lt;/code&gt; fields.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobStatus status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.JobStatus.Builder getStatusBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The job status. Additional application-specific
     * status information might be contained in the &lt;code&gt;type_job&lt;/code&gt;
     * and &lt;code&gt;yarn_applications&lt;/code&gt; fields.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobStatus status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.JobStatusOrBuilder getStatusOrBuilder() {
      if (statusBuilder_ != null) {
        return statusBuilder_.getMessageOrBuilder();
      } else {
        return status_ == null
            ? com.google.cloud.dataproc.v1.JobStatus.getDefaultInstance()
            : status_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The job status. Additional application-specific
     * status information might be contained in the &lt;code&gt;type_job&lt;/code&gt;
     * and &lt;code&gt;yarn_applications&lt;/code&gt; fields.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobStatus status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.JobStatus,
            com.google.cloud.dataproc.v1.JobStatus.Builder,
            com.google.cloud.dataproc.v1.JobStatusOrBuilder>
        getStatusFieldBuilder() {
      if (statusBuilder_ == null) {
        statusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.JobStatus,
                com.google.cloud.dataproc.v1.JobStatus.Builder,
                com.google.cloud.dataproc.v1.JobStatusOrBuilder>(
                getStatus(), getParentForChildren(), isClean());
        status_ = null;
      }
      return statusBuilder_;
    }

    private java.util.List<com.google.cloud.dataproc.v1.JobStatus> statusHistory_ =
        java.util.Collections.emptyList();

    private void ensureStatusHistoryIsMutable() {
      if (!((bitField0_ & 0x00002000) != 0)) {
        statusHistory_ =
            new java.util.ArrayList<com.google.cloud.dataproc.v1.JobStatus>(statusHistory_);
        bitField0_ |= 0x00002000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.JobStatus,
            com.google.cloud.dataproc.v1.JobStatus.Builder,
            com.google.cloud.dataproc.v1.JobStatusOrBuilder>
        statusHistoryBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The previous job status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.JobStatus> getStatusHistoryList() {
      if (statusHistoryBuilder_ == null) {
        return java.util.Collections.unmodifiableList(statusHistory_);
      } else {
        return statusHistoryBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous job status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getStatusHistoryCount() {
      if (statusHistoryBuilder_ == null) {
        return statusHistory_.size();
      } else {
        return statusHistoryBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous job status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.JobStatus getStatusHistory(int index) {
      if (statusHistoryBuilder_ == null) {
        return statusHistory_.get(index);
      } else {
        return statusHistoryBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous job status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatusHistory(int index, com.google.cloud.dataproc.v1.JobStatus value) {
      if (statusHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusHistoryIsMutable();
        statusHistory_.set(index, value);
        onChanged();
      } else {
        statusHistoryBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous job status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStatusHistory(
        int index, com.google.cloud.dataproc.v1.JobStatus.Builder builderForValue) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        statusHistory_.set(index, builderForValue.build());
        onChanged();
      } else {
        statusHistoryBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous job status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStatusHistory(com.google.cloud.dataproc.v1.JobStatus value) {
      if (statusHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusHistoryIsMutable();
        statusHistory_.add(value);
        onChanged();
      } else {
        statusHistoryBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous job status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStatusHistory(int index, com.google.cloud.dataproc.v1.JobStatus value) {
      if (statusHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusHistoryIsMutable();
        statusHistory_.add(index, value);
        onChanged();
      } else {
        statusHistoryBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous job status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStatusHistory(
        com.google.cloud.dataproc.v1.JobStatus.Builder builderForValue) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        statusHistory_.add(builderForValue.build());
        onChanged();
      } else {
        statusHistoryBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous job status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStatusHistory(
        int index, com.google.cloud.dataproc.v1.JobStatus.Builder builderForValue) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        statusHistory_.add(index, builderForValue.build());
        onChanged();
      } else {
        statusHistoryBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous job status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllStatusHistory(
        java.lang.Iterable<? extends com.google.cloud.dataproc.v1.JobStatus> values) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, statusHistory_);
        onChanged();
      } else {
        statusHistoryBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous job status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStatusHistory() {
      if (statusHistoryBuilder_ == null) {
        statusHistory_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00002000);
        onChanged();
      } else {
        statusHistoryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous job status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeStatusHistory(int index) {
      if (statusHistoryBuilder_ == null) {
        ensureStatusHistoryIsMutable();
        statusHistory_.remove(index);
        onChanged();
      } else {
        statusHistoryBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous job status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.JobStatus.Builder getStatusHistoryBuilder(int index) {
      return getStatusHistoryFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous job status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.JobStatusOrBuilder getStatusHistoryOrBuilder(int index) {
      if (statusHistoryBuilder_ == null) {
        return statusHistory_.get(index);
      } else {
        return statusHistoryBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous job status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dataproc.v1.JobStatusOrBuilder>
        getStatusHistoryOrBuilderList() {
      if (statusHistoryBuilder_ != null) {
        return statusHistoryBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(statusHistory_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous job status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.JobStatus.Builder addStatusHistoryBuilder() {
      return getStatusHistoryFieldBuilder()
          .addBuilder(com.google.cloud.dataproc.v1.JobStatus.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous job status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.JobStatus.Builder addStatusHistoryBuilder(int index) {
      return getStatusHistoryFieldBuilder()
          .addBuilder(index, com.google.cloud.dataproc.v1.JobStatus.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The previous job status.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.JobStatus status_history = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.JobStatus.Builder>
        getStatusHistoryBuilderList() {
      return getStatusHistoryFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.JobStatus,
            com.google.cloud.dataproc.v1.JobStatus.Builder,
            com.google.cloud.dataproc.v1.JobStatusOrBuilder>
        getStatusHistoryFieldBuilder() {
      if (statusHistoryBuilder_ == null) {
        statusHistoryBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataproc.v1.JobStatus,
                com.google.cloud.dataproc.v1.JobStatus.Builder,
                com.google.cloud.dataproc.v1.JobStatusOrBuilder>(
                statusHistory_,
                ((bitField0_ & 0x00002000) != 0),
                getParentForChildren(),
                isClean());
        statusHistory_ = null;
      }
      return statusHistoryBuilder_;
    }

    private java.util.List<com.google.cloud.dataproc.v1.YarnApplication> yarnApplications_ =
        java.util.Collections.emptyList();

    private void ensureYarnApplicationsIsMutable() {
      if (!((bitField0_ & 0x00004000) != 0)) {
        yarnApplications_ =
            new java.util.ArrayList<com.google.cloud.dataproc.v1.YarnApplication>(
                yarnApplications_);
        bitField0_ |= 0x00004000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.YarnApplication,
            com.google.cloud.dataproc.v1.YarnApplication.Builder,
            com.google.cloud.dataproc.v1.YarnApplicationOrBuilder>
        yarnApplicationsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The collection of YARN applications spun up by this job.
     *
     * **Beta** Feature: This report is available for testing purposes only. It
     * might be changed before final release.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.YarnApplication> getYarnApplicationsList() {
      if (yarnApplicationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(yarnApplications_);
      } else {
        return yarnApplicationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The collection of YARN applications spun up by this job.
     *
     * **Beta** Feature: This report is available for testing purposes only. It
     * might be changed before final release.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getYarnApplicationsCount() {
      if (yarnApplicationsBuilder_ == null) {
        return yarnApplications_.size();
      } else {
        return yarnApplicationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The collection of YARN applications spun up by this job.
     *
     * **Beta** Feature: This report is available for testing purposes only. It
     * might be changed before final release.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.YarnApplication getYarnApplications(int index) {
      if (yarnApplicationsBuilder_ == null) {
        return yarnApplications_.get(index);
      } else {
        return yarnApplicationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The collection of YARN applications spun up by this job.
     *
     * **Beta** Feature: This report is available for testing purposes only. It
     * might be changed before final release.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setYarnApplications(
        int index, com.google.cloud.dataproc.v1.YarnApplication value) {
      if (yarnApplicationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureYarnApplicationsIsMutable();
        yarnApplications_.set(index, value);
        onChanged();
      } else {
        yarnApplicationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The collection of YARN applications spun up by this job.
     *
     * **Beta** Feature: This report is available for testing purposes only. It
     * might be changed before final release.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setYarnApplications(
        int index, com.google.cloud.dataproc.v1.YarnApplication.Builder builderForValue) {
      if (yarnApplicationsBuilder_ == null) {
        ensureYarnApplicationsIsMutable();
        yarnApplications_.set(index, builderForValue.build());
        onChanged();
      } else {
        yarnApplicationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The collection of YARN applications spun up by this job.
     *
     * **Beta** Feature: This report is available for testing purposes only. It
     * might be changed before final release.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addYarnApplications(com.google.cloud.dataproc.v1.YarnApplication value) {
      if (yarnApplicationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureYarnApplicationsIsMutable();
        yarnApplications_.add(value);
        onChanged();
      } else {
        yarnApplicationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The collection of YARN applications spun up by this job.
     *
     * **Beta** Feature: This report is available for testing purposes only. It
     * might be changed before final release.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addYarnApplications(
        int index, com.google.cloud.dataproc.v1.YarnApplication value) {
      if (yarnApplicationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureYarnApplicationsIsMutable();
        yarnApplications_.add(index, value);
        onChanged();
      } else {
        yarnApplicationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The collection of YARN applications spun up by this job.
     *
     * **Beta** Feature: This report is available for testing purposes only. It
     * might be changed before final release.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addYarnApplications(
        com.google.cloud.dataproc.v1.YarnApplication.Builder builderForValue) {
      if (yarnApplicationsBuilder_ == null) {
        ensureYarnApplicationsIsMutable();
        yarnApplications_.add(builderForValue.build());
        onChanged();
      } else {
        yarnApplicationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The collection of YARN applications spun up by this job.
     *
     * **Beta** Feature: This report is available for testing purposes only. It
     * might be changed before final release.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addYarnApplications(
        int index, com.google.cloud.dataproc.v1.YarnApplication.Builder builderForValue) {
      if (yarnApplicationsBuilder_ == null) {
        ensureYarnApplicationsIsMutable();
        yarnApplications_.add(index, builderForValue.build());
        onChanged();
      } else {
        yarnApplicationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The collection of YARN applications spun up by this job.
     *
     * **Beta** Feature: This report is available for testing purposes only. It
     * might be changed before final release.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllYarnApplications(
        java.lang.Iterable<? extends com.google.cloud.dataproc.v1.YarnApplication> values) {
      if (yarnApplicationsBuilder_ == null) {
        ensureYarnApplicationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, yarnApplications_);
        onChanged();
      } else {
        yarnApplicationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The collection of YARN applications spun up by this job.
     *
     * **Beta** Feature: This report is available for testing purposes only. It
     * might be changed before final release.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearYarnApplications() {
      if (yarnApplicationsBuilder_ == null) {
        yarnApplications_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00004000);
        onChanged();
      } else {
        yarnApplicationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The collection of YARN applications spun up by this job.
     *
     * **Beta** Feature: This report is available for testing purposes only. It
     * might be changed before final release.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeYarnApplications(int index) {
      if (yarnApplicationsBuilder_ == null) {
        ensureYarnApplicationsIsMutable();
        yarnApplications_.remove(index);
        onChanged();
      } else {
        yarnApplicationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The collection of YARN applications spun up by this job.
     *
     * **Beta** Feature: This report is available for testing purposes only. It
     * might be changed before final release.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.YarnApplication.Builder getYarnApplicationsBuilder(
        int index) {
      return getYarnApplicationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The collection of YARN applications spun up by this job.
     *
     * **Beta** Feature: This report is available for testing purposes only. It
     * might be changed before final release.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.YarnApplicationOrBuilder getYarnApplicationsOrBuilder(
        int index) {
      if (yarnApplicationsBuilder_ == null) {
        return yarnApplications_.get(index);
      } else {
        return yarnApplicationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The collection of YARN applications spun up by this job.
     *
     * **Beta** Feature: This report is available for testing purposes only. It
     * might be changed before final release.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.dataproc.v1.YarnApplicationOrBuilder>
        getYarnApplicationsOrBuilderList() {
      if (yarnApplicationsBuilder_ != null) {
        return yarnApplicationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(yarnApplications_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The collection of YARN applications spun up by this job.
     *
     * **Beta** Feature: This report is available for testing purposes only. It
     * might be changed before final release.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.YarnApplication.Builder addYarnApplicationsBuilder() {
      return getYarnApplicationsFieldBuilder()
          .addBuilder(com.google.cloud.dataproc.v1.YarnApplication.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The collection of YARN applications spun up by this job.
     *
     * **Beta** Feature: This report is available for testing purposes only. It
     * might be changed before final release.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.YarnApplication.Builder addYarnApplicationsBuilder(
        int index) {
      return getYarnApplicationsFieldBuilder()
          .addBuilder(index, com.google.cloud.dataproc.v1.YarnApplication.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The collection of YARN applications spun up by this job.
     *
     * **Beta** Feature: This report is available for testing purposes only. It
     * might be changed before final release.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.YarnApplication yarn_applications = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.YarnApplication.Builder>
        getYarnApplicationsBuilderList() {
      return getYarnApplicationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.YarnApplication,
            com.google.cloud.dataproc.v1.YarnApplication.Builder,
            com.google.cloud.dataproc.v1.YarnApplicationOrBuilder>
        getYarnApplicationsFieldBuilder() {
      if (yarnApplicationsBuilder_ == null) {
        yarnApplicationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataproc.v1.YarnApplication,
                com.google.cloud.dataproc.v1.YarnApplication.Builder,
                com.google.cloud.dataproc.v1.YarnApplicationOrBuilder>(
                yarnApplications_,
                ((bitField0_ & 0x00004000) != 0),
                getParentForChildren(),
                isClean());
        yarnApplications_ = null;
      }
      return yarnApplicationsBuilder_;
    }

    private java.lang.Object driverOutputResourceUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. A URI pointing to the location of the stdout of the job's
     * driver program.
     * </pre>
     *
     * <code>string driver_output_resource_uri = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The driverOutputResourceUri.
     */
    public java.lang.String getDriverOutputResourceUri() {
      java.lang.Object ref = driverOutputResourceUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        driverOutputResourceUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A URI pointing to the location of the stdout of the job's
     * driver program.
     * </pre>
     *
     * <code>string driver_output_resource_uri = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for driverOutputResourceUri.
     */
    public com.google.protobuf.ByteString getDriverOutputResourceUriBytes() {
      java.lang.Object ref = driverOutputResourceUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        driverOutputResourceUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A URI pointing to the location of the stdout of the job's
     * driver program.
     * </pre>
     *
     * <code>string driver_output_resource_uri = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The driverOutputResourceUri to set.
     * @return This builder for chaining.
     */
    public Builder setDriverOutputResourceUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      driverOutputResourceUri_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A URI pointing to the location of the stdout of the job's
     * driver program.
     * </pre>
     *
     * <code>string driver_output_resource_uri = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDriverOutputResourceUri() {
      driverOutputResourceUri_ = getDefaultInstance().getDriverOutputResourceUri();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A URI pointing to the location of the stdout of the job's
     * driver program.
     * </pre>
     *
     * <code>string driver_output_resource_uri = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for driverOutputResourceUri to set.
     * @return This builder for chaining.
     */
    public Builder setDriverOutputResourceUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      driverOutputResourceUri_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.lang.Object driverControlFilesUri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. If present, the location of miscellaneous control files
     * which can be used as part of job setup and handling. If not present,
     * control files might be placed in the same location as `driver_output_uri`.
     * </pre>
     *
     * <code>string driver_control_files_uri = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The driverControlFilesUri.
     */
    public java.lang.String getDriverControlFilesUri() {
      java.lang.Object ref = driverControlFilesUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        driverControlFilesUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If present, the location of miscellaneous control files
     * which can be used as part of job setup and handling. If not present,
     * control files might be placed in the same location as `driver_output_uri`.
     * </pre>
     *
     * <code>string driver_control_files_uri = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The bytes for driverControlFilesUri.
     */
    public com.google.protobuf.ByteString getDriverControlFilesUriBytes() {
      java.lang.Object ref = driverControlFilesUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        driverControlFilesUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. If present, the location of miscellaneous control files
     * which can be used as part of job setup and handling. If not present,
     * control files might be placed in the same location as `driver_output_uri`.
     * </pre>
     *
     * <code>string driver_control_files_uri = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The driverControlFilesUri to set.
     * @return This builder for chaining.
     */
    public Builder setDriverControlFilesUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      driverControlFilesUri_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If present, the location of miscellaneous control files
     * which can be used as part of job setup and handling. If not present,
     * control files might be placed in the same location as `driver_output_uri`.
     * </pre>
     *
     * <code>string driver_control_files_uri = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDriverControlFilesUri() {
      driverControlFilesUri_ = getDefaultInstance().getDriverControlFilesUri();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. If present, the location of miscellaneous control files
     * which can be used as part of job setup and handling. If not present,
     * control files might be placed in the same location as `driver_output_uri`.
     * </pre>
     *
     * <code>string driver_control_files_uri = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes for driverControlFilesUri to set.
     * @return This builder for chaining.
     */
    public Builder setDriverControlFilesUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      driverControlFilesUri_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this job.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** can be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a job.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this job.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** can be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a job.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this job.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** can be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a job.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this job.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** can be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a job.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00020000);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this job.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** can be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a job.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00020000;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this job.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** can be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a job.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00020000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with this job.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** can be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a job.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00020000;
      return this;
    }

    private com.google.cloud.dataproc.v1.JobScheduling scheduling_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.JobScheduling,
            com.google.cloud.dataproc.v1.JobScheduling.Builder,
            com.google.cloud.dataproc.v1.JobSchedulingOrBuilder>
        schedulingBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Job scheduling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobScheduling scheduling = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the scheduling field is set.
     */
    public boolean hasScheduling() {
      return ((bitField0_ & 0x00040000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Job scheduling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobScheduling scheduling = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The scheduling.
     */
    public com.google.cloud.dataproc.v1.JobScheduling getScheduling() {
      if (schedulingBuilder_ == null) {
        return scheduling_ == null
            ? com.google.cloud.dataproc.v1.JobScheduling.getDefaultInstance()
            : scheduling_;
      } else {
        return schedulingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job scheduling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobScheduling scheduling = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setScheduling(com.google.cloud.dataproc.v1.JobScheduling value) {
      if (schedulingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scheduling_ = value;
      } else {
        schedulingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job scheduling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobScheduling scheduling = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setScheduling(
        com.google.cloud.dataproc.v1.JobScheduling.Builder builderForValue) {
      if (schedulingBuilder_ == null) {
        scheduling_ = builderForValue.build();
      } else {
        schedulingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job scheduling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobScheduling scheduling = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeScheduling(com.google.cloud.dataproc.v1.JobScheduling value) {
      if (schedulingBuilder_ == null) {
        if (((bitField0_ & 0x00040000) != 0)
            && scheduling_ != null
            && scheduling_ != com.google.cloud.dataproc.v1.JobScheduling.getDefaultInstance()) {
          getSchedulingBuilder().mergeFrom(value);
        } else {
          scheduling_ = value;
        }
      } else {
        schedulingBuilder_.mergeFrom(value);
      }
      if (scheduling_ != null) {
        bitField0_ |= 0x00040000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job scheduling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobScheduling scheduling = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearScheduling() {
      bitField0_ = (bitField0_ & ~0x00040000);
      scheduling_ = null;
      if (schedulingBuilder_ != null) {
        schedulingBuilder_.dispose();
        schedulingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Job scheduling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobScheduling scheduling = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.JobScheduling.Builder getSchedulingBuilder() {
      bitField0_ |= 0x00040000;
      onChanged();
      return getSchedulingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Job scheduling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobScheduling scheduling = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.JobSchedulingOrBuilder getSchedulingOrBuilder() {
      if (schedulingBuilder_ != null) {
        return schedulingBuilder_.getMessageOrBuilder();
      } else {
        return scheduling_ == null
            ? com.google.cloud.dataproc.v1.JobScheduling.getDefaultInstance()
            : scheduling_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Job scheduling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JobScheduling scheduling = 20 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.JobScheduling,
            com.google.cloud.dataproc.v1.JobScheduling.Builder,
            com.google.cloud.dataproc.v1.JobSchedulingOrBuilder>
        getSchedulingFieldBuilder() {
      if (schedulingBuilder_ == null) {
        schedulingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.JobScheduling,
                com.google.cloud.dataproc.v1.JobScheduling.Builder,
                com.google.cloud.dataproc.v1.JobSchedulingOrBuilder>(
                getScheduling(), getParentForChildren(), isClean());
        scheduling_ = null;
      }
      return schedulingBuilder_;
    }

    private java.lang.Object jobUuid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. A UUID that uniquely identifies a job within the project
     * over time. This is in contrast to a user-settable reference.job_id that
     * might be reused over time.
     * </pre>
     *
     * <code>string job_uuid = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The jobUuid.
     */
    public java.lang.String getJobUuid() {
      java.lang.Object ref = jobUuid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jobUuid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A UUID that uniquely identifies a job within the project
     * over time. This is in contrast to a user-settable reference.job_id that
     * might be reused over time.
     * </pre>
     *
     * <code>string job_uuid = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for jobUuid.
     */
    public com.google.protobuf.ByteString getJobUuidBytes() {
      java.lang.Object ref = jobUuid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jobUuid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A UUID that uniquely identifies a job within the project
     * over time. This is in contrast to a user-settable reference.job_id that
     * might be reused over time.
     * </pre>
     *
     * <code>string job_uuid = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The jobUuid to set.
     * @return This builder for chaining.
     */
    public Builder setJobUuid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      jobUuid_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A UUID that uniquely identifies a job within the project
     * over time. This is in contrast to a user-settable reference.job_id that
     * might be reused over time.
     * </pre>
     *
     * <code>string job_uuid = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJobUuid() {
      jobUuid_ = getDefaultInstance().getJobUuid();
      bitField0_ = (bitField0_ & ~0x00080000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A UUID that uniquely identifies a job within the project
     * over time. This is in contrast to a user-settable reference.job_id that
     * might be reused over time.
     * </pre>
     *
     * <code>string job_uuid = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for jobUuid to set.
     * @return This builder for chaining.
     */
    public Builder setJobUuidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      jobUuid_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }

    private boolean done_;
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether the job is completed. If the value is
     * `false`, the job is still in progress. If `true`, the job is completed, and
     * `status.state` field will indicate if it was successful, failed,
     * or cancelled.
     * </pre>
     *
     * <code>bool done = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The done.
     */
    @java.lang.Override
    public boolean getDone() {
      return done_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether the job is completed. If the value is
     * `false`, the job is still in progress. If `true`, the job is completed, and
     * `status.state` field will indicate if it was successful, failed,
     * or cancelled.
     * </pre>
     *
     * <code>bool done = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The done to set.
     * @return This builder for chaining.
     */
    public Builder setDone(boolean value) {

      done_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether the job is completed. If the value is
     * `false`, the job is still in progress. If `true`, the job is completed, and
     * `status.state` field will indicate if it was successful, failed,
     * or cancelled.
     * </pre>
     *
     * <code>bool done = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDone() {
      bitField0_ = (bitField0_ & ~0x00100000);
      done_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.dataproc.v1.DriverSchedulingConfig driverSchedulingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.DriverSchedulingConfig,
            com.google.cloud.dataproc.v1.DriverSchedulingConfig.Builder,
            com.google.cloud.dataproc.v1.DriverSchedulingConfigOrBuilder>
        driverSchedulingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Driver scheduling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DriverSchedulingConfig driver_scheduling_config = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the driverSchedulingConfig field is set.
     */
    public boolean hasDriverSchedulingConfig() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Driver scheduling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DriverSchedulingConfig driver_scheduling_config = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The driverSchedulingConfig.
     */
    public com.google.cloud.dataproc.v1.DriverSchedulingConfig getDriverSchedulingConfig() {
      if (driverSchedulingConfigBuilder_ == null) {
        return driverSchedulingConfig_ == null
            ? com.google.cloud.dataproc.v1.DriverSchedulingConfig.getDefaultInstance()
            : driverSchedulingConfig_;
      } else {
        return driverSchedulingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Driver scheduling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DriverSchedulingConfig driver_scheduling_config = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDriverSchedulingConfig(
        com.google.cloud.dataproc.v1.DriverSchedulingConfig value) {
      if (driverSchedulingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        driverSchedulingConfig_ = value;
      } else {
        driverSchedulingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Driver scheduling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DriverSchedulingConfig driver_scheduling_config = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDriverSchedulingConfig(
        com.google.cloud.dataproc.v1.DriverSchedulingConfig.Builder builderForValue) {
      if (driverSchedulingConfigBuilder_ == null) {
        driverSchedulingConfig_ = builderForValue.build();
      } else {
        driverSchedulingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Driver scheduling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DriverSchedulingConfig driver_scheduling_config = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDriverSchedulingConfig(
        com.google.cloud.dataproc.v1.DriverSchedulingConfig value) {
      if (driverSchedulingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)
            && driverSchedulingConfig_ != null
            && driverSchedulingConfig_
                != com.google.cloud.dataproc.v1.DriverSchedulingConfig.getDefaultInstance()) {
          getDriverSchedulingConfigBuilder().mergeFrom(value);
        } else {
          driverSchedulingConfig_ = value;
        }
      } else {
        driverSchedulingConfigBuilder_.mergeFrom(value);
      }
      if (driverSchedulingConfig_ != null) {
        bitField0_ |= 0x00200000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Driver scheduling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DriverSchedulingConfig driver_scheduling_config = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDriverSchedulingConfig() {
      bitField0_ = (bitField0_ & ~0x00200000);
      driverSchedulingConfig_ = null;
      if (driverSchedulingConfigBuilder_ != null) {
        driverSchedulingConfigBuilder_.dispose();
        driverSchedulingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Driver scheduling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DriverSchedulingConfig driver_scheduling_config = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.DriverSchedulingConfig.Builder
        getDriverSchedulingConfigBuilder() {
      bitField0_ |= 0x00200000;
      onChanged();
      return getDriverSchedulingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Driver scheduling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DriverSchedulingConfig driver_scheduling_config = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.DriverSchedulingConfigOrBuilder
        getDriverSchedulingConfigOrBuilder() {
      if (driverSchedulingConfigBuilder_ != null) {
        return driverSchedulingConfigBuilder_.getMessageOrBuilder();
      } else {
        return driverSchedulingConfig_ == null
            ? com.google.cloud.dataproc.v1.DriverSchedulingConfig.getDefaultInstance()
            : driverSchedulingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Driver scheduling configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.DriverSchedulingConfig driver_scheduling_config = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.DriverSchedulingConfig,
            com.google.cloud.dataproc.v1.DriverSchedulingConfig.Builder,
            com.google.cloud.dataproc.v1.DriverSchedulingConfigOrBuilder>
        getDriverSchedulingConfigFieldBuilder() {
      if (driverSchedulingConfigBuilder_ == null) {
        driverSchedulingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.DriverSchedulingConfig,
                com.google.cloud.dataproc.v1.DriverSchedulingConfig.Builder,
                com.google.cloud.dataproc.v1.DriverSchedulingConfigOrBuilder>(
                getDriverSchedulingConfig(), getParentForChildren(), isClean());
        driverSchedulingConfig_ = null;
      }
      return driverSchedulingConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.Job)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.Job)
  private static final com.google.cloud.dataproc.v1.Job DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.Job();
  }

  public static com.google.cloud.dataproc.v1.Job getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Job> PARSER =
      new com.google.protobuf.AbstractParser<Job>() {
        @java.lang.Override
        public Job parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Job> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Job> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.Job getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
