/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/clusters.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * Specifies the cluster auto-delete schedule configuration.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.LifecycleConfig}
 */
public final class LifecycleConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.LifecycleConfig)
    LifecycleConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LifecycleConfig.newBuilder() to construct.
  private LifecycleConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LifecycleConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LifecycleConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_LifecycleConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.ClustersProto
        .internal_static_google_cloud_dataproc_v1_LifecycleConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.LifecycleConfig.class,
            com.google.cloud.dataproc.v1.LifecycleConfig.Builder.class);
  }

  private int bitField0_;
  private int ttlCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object ttl_;

  public enum TtlCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AUTO_DELETE_TIME(2),
    AUTO_DELETE_TTL(3),
    TTL_NOT_SET(0);
    private final int value;

    private TtlCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TtlCase valueOf(int value) {
      return forNumber(value);
    }

    public static TtlCase forNumber(int value) {
      switch (value) {
        case 2:
          return AUTO_DELETE_TIME;
        case 3:
          return AUTO_DELETE_TTL;
        case 0:
          return TTL_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TtlCase getTtlCase() {
    return TtlCase.forNumber(ttlCase_);
  }

  public static final int IDLE_DELETE_TTL_FIELD_NUMBER = 1;
  private com.google.protobuf.Duration idleDeleteTtl_;
  /**
   *
   *
   * <pre>
   * Optional. The duration to keep the cluster alive while idling (when no jobs
   * are running). Passing this threshold will cause the cluster to be
   * deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON
   * representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * </pre>
   *
   * <code>.google.protobuf.Duration idle_delete_ttl = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the idleDeleteTtl field is set.
   */
  @java.lang.Override
  public boolean hasIdleDeleteTtl() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The duration to keep the cluster alive while idling (when no jobs
   * are running). Passing this threshold will cause the cluster to be
   * deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON
   * representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * </pre>
   *
   * <code>.google.protobuf.Duration idle_delete_ttl = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The idleDeleteTtl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getIdleDeleteTtl() {
    return idleDeleteTtl_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : idleDeleteTtl_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The duration to keep the cluster alive while idling (when no jobs
   * are running). Passing this threshold will cause the cluster to be
   * deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON
   * representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * </pre>
   *
   * <code>.google.protobuf.Duration idle_delete_ttl = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getIdleDeleteTtlOrBuilder() {
    return idleDeleteTtl_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : idleDeleteTtl_;
  }

  public static final int AUTO_DELETE_TIME_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Optional. The time when cluster will be auto-deleted (see JSON
   * representation of
   * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp auto_delete_time = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the autoDeleteTime field is set.
   */
  @java.lang.Override
  public boolean hasAutoDeleteTime() {
    return ttlCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Optional. The time when cluster will be auto-deleted (see JSON
   * representation of
   * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp auto_delete_time = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The autoDeleteTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getAutoDeleteTime() {
    if (ttlCase_ == 2) {
      return (com.google.protobuf.Timestamp) ttl_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. The time when cluster will be auto-deleted (see JSON
   * representation of
   * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp auto_delete_time = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getAutoDeleteTimeOrBuilder() {
    if (ttlCase_ == 2) {
      return (com.google.protobuf.Timestamp) ttl_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  public static final int AUTO_DELETE_TTL_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Optional. The lifetime duration of cluster. The cluster will be
   * auto-deleted at the end of this period. Minimum value is 10 minutes;
   * maximum value is 14 days (see JSON representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * </pre>
   *
   * <code>.google.protobuf.Duration auto_delete_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the autoDeleteTtl field is set.
   */
  @java.lang.Override
  public boolean hasAutoDeleteTtl() {
    return ttlCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Optional. The lifetime duration of cluster. The cluster will be
   * auto-deleted at the end of this period. Minimum value is 10 minutes;
   * maximum value is 14 days (see JSON representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * </pre>
   *
   * <code>.google.protobuf.Duration auto_delete_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The autoDeleteTtl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getAutoDeleteTtl() {
    if (ttlCase_ == 3) {
      return (com.google.protobuf.Duration) ttl_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. The lifetime duration of cluster. The cluster will be
   * auto-deleted at the end of this period. Minimum value is 10 minutes;
   * maximum value is 14 days (see JSON representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * </pre>
   *
   * <code>.google.protobuf.Duration auto_delete_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getAutoDeleteTtlOrBuilder() {
    if (ttlCase_ == 3) {
      return (com.google.protobuf.Duration) ttl_;
    }
    return com.google.protobuf.Duration.getDefaultInstance();
  }

  public static final int IDLE_START_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp idleStartTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when cluster became idle (most recent job finished)
   * and became eligible for deletion due to idleness (see JSON representation
   * of
   * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp idle_start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the idleStartTime field is set.
   */
  @java.lang.Override
  public boolean hasIdleStartTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when cluster became idle (most recent job finished)
   * and became eligible for deletion due to idleness (see JSON representation
   * of
   * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp idle_start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The idleStartTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getIdleStartTime() {
    return idleStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : idleStartTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when cluster became idle (most recent job finished)
   * and became eligible for deletion due to idleness (see JSON representation
   * of
   * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp idle_start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getIdleStartTimeOrBuilder() {
    return idleStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : idleStartTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getIdleDeleteTtl());
    }
    if (ttlCase_ == 2) {
      output.writeMessage(2, (com.google.protobuf.Timestamp) ttl_);
    }
    if (ttlCase_ == 3) {
      output.writeMessage(3, (com.google.protobuf.Duration) ttl_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getIdleStartTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getIdleDeleteTtl());
    }
    if (ttlCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.protobuf.Timestamp) ttl_);
    }
    if (ttlCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.protobuf.Duration) ttl_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getIdleStartTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.LifecycleConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.LifecycleConfig other =
        (com.google.cloud.dataproc.v1.LifecycleConfig) obj;

    if (hasIdleDeleteTtl() != other.hasIdleDeleteTtl()) return false;
    if (hasIdleDeleteTtl()) {
      if (!getIdleDeleteTtl().equals(other.getIdleDeleteTtl())) return false;
    }
    if (hasIdleStartTime() != other.hasIdleStartTime()) return false;
    if (hasIdleStartTime()) {
      if (!getIdleStartTime().equals(other.getIdleStartTime())) return false;
    }
    if (!getTtlCase().equals(other.getTtlCase())) return false;
    switch (ttlCase_) {
      case 2:
        if (!getAutoDeleteTime().equals(other.getAutoDeleteTime())) return false;
        break;
      case 3:
        if (!getAutoDeleteTtl().equals(other.getAutoDeleteTtl())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasIdleDeleteTtl()) {
      hash = (37 * hash) + IDLE_DELETE_TTL_FIELD_NUMBER;
      hash = (53 * hash) + getIdleDeleteTtl().hashCode();
    }
    if (hasIdleStartTime()) {
      hash = (37 * hash) + IDLE_START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getIdleStartTime().hashCode();
    }
    switch (ttlCase_) {
      case 2:
        hash = (37 * hash) + AUTO_DELETE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getAutoDeleteTime().hashCode();
        break;
      case 3:
        hash = (37 * hash) + AUTO_DELETE_TTL_FIELD_NUMBER;
        hash = (53 * hash) + getAutoDeleteTtl().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.LifecycleConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.LifecycleConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.LifecycleConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.LifecycleConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.LifecycleConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.LifecycleConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.LifecycleConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.LifecycleConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.LifecycleConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.LifecycleConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.LifecycleConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.LifecycleConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.LifecycleConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specifies the cluster auto-delete schedule configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.LifecycleConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.LifecycleConfig)
      com.google.cloud.dataproc.v1.LifecycleConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_LifecycleConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_LifecycleConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.LifecycleConfig.class,
              com.google.cloud.dataproc.v1.LifecycleConfig.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.LifecycleConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getIdleDeleteTtlFieldBuilder();
        getIdleStartTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      idleDeleteTtl_ = null;
      if (idleDeleteTtlBuilder_ != null) {
        idleDeleteTtlBuilder_.dispose();
        idleDeleteTtlBuilder_ = null;
      }
      if (autoDeleteTimeBuilder_ != null) {
        autoDeleteTimeBuilder_.clear();
      }
      if (autoDeleteTtlBuilder_ != null) {
        autoDeleteTtlBuilder_.clear();
      }
      idleStartTime_ = null;
      if (idleStartTimeBuilder_ != null) {
        idleStartTimeBuilder_.dispose();
        idleStartTimeBuilder_ = null;
      }
      ttlCase_ = 0;
      ttl_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.ClustersProto
          .internal_static_google_cloud_dataproc_v1_LifecycleConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.LifecycleConfig getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.LifecycleConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.LifecycleConfig build() {
      com.google.cloud.dataproc.v1.LifecycleConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.LifecycleConfig buildPartial() {
      com.google.cloud.dataproc.v1.LifecycleConfig result =
          new com.google.cloud.dataproc.v1.LifecycleConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.LifecycleConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.idleDeleteTtl_ =
            idleDeleteTtlBuilder_ == null ? idleDeleteTtl_ : idleDeleteTtlBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.idleStartTime_ =
            idleStartTimeBuilder_ == null ? idleStartTime_ : idleStartTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.dataproc.v1.LifecycleConfig result) {
      result.ttlCase_ = ttlCase_;
      result.ttl_ = this.ttl_;
      if (ttlCase_ == 2 && autoDeleteTimeBuilder_ != null) {
        result.ttl_ = autoDeleteTimeBuilder_.build();
      }
      if (ttlCase_ == 3 && autoDeleteTtlBuilder_ != null) {
        result.ttl_ = autoDeleteTtlBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.LifecycleConfig) {
        return mergeFrom((com.google.cloud.dataproc.v1.LifecycleConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.LifecycleConfig other) {
      if (other == com.google.cloud.dataproc.v1.LifecycleConfig.getDefaultInstance()) return this;
      if (other.hasIdleDeleteTtl()) {
        mergeIdleDeleteTtl(other.getIdleDeleteTtl());
      }
      if (other.hasIdleStartTime()) {
        mergeIdleStartTime(other.getIdleStartTime());
      }
      switch (other.getTtlCase()) {
        case AUTO_DELETE_TIME:
          {
            mergeAutoDeleteTime(other.getAutoDeleteTime());
            break;
          }
        case AUTO_DELETE_TTL:
          {
            mergeAutoDeleteTtl(other.getAutoDeleteTtl());
            break;
          }
        case TTL_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getIdleDeleteTtlFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getAutoDeleteTimeFieldBuilder().getBuilder(), extensionRegistry);
                ttlCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getAutoDeleteTtlFieldBuilder().getBuilder(), extensionRegistry);
                ttlCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getIdleStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int ttlCase_ = 0;
    private java.lang.Object ttl_;

    public TtlCase getTtlCase() {
      return TtlCase.forNumber(ttlCase_);
    }

    public Builder clearTtl() {
      ttlCase_ = 0;
      ttl_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Duration idleDeleteTtl_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        idleDeleteTtlBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The duration to keep the cluster alive while idling (when no jobs
     * are running). Passing this threshold will cause the cluster to be
     * deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration idle_delete_ttl = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the idleDeleteTtl field is set.
     */
    public boolean hasIdleDeleteTtl() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The duration to keep the cluster alive while idling (when no jobs
     * are running). Passing this threshold will cause the cluster to be
     * deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration idle_delete_ttl = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The idleDeleteTtl.
     */
    public com.google.protobuf.Duration getIdleDeleteTtl() {
      if (idleDeleteTtlBuilder_ == null) {
        return idleDeleteTtl_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : idleDeleteTtl_;
      } else {
        return idleDeleteTtlBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The duration to keep the cluster alive while idling (when no jobs
     * are running). Passing this threshold will cause the cluster to be
     * deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration idle_delete_ttl = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setIdleDeleteTtl(com.google.protobuf.Duration value) {
      if (idleDeleteTtlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        idleDeleteTtl_ = value;
      } else {
        idleDeleteTtlBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The duration to keep the cluster alive while idling (when no jobs
     * are running). Passing this threshold will cause the cluster to be
     * deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration idle_delete_ttl = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setIdleDeleteTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (idleDeleteTtlBuilder_ == null) {
        idleDeleteTtl_ = builderForValue.build();
      } else {
        idleDeleteTtlBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The duration to keep the cluster alive while idling (when no jobs
     * are running). Passing this threshold will cause the cluster to be
     * deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration idle_delete_ttl = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeIdleDeleteTtl(com.google.protobuf.Duration value) {
      if (idleDeleteTtlBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && idleDeleteTtl_ != null
            && idleDeleteTtl_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getIdleDeleteTtlBuilder().mergeFrom(value);
        } else {
          idleDeleteTtl_ = value;
        }
      } else {
        idleDeleteTtlBuilder_.mergeFrom(value);
      }
      if (idleDeleteTtl_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The duration to keep the cluster alive while idling (when no jobs
     * are running). Passing this threshold will cause the cluster to be
     * deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration idle_delete_ttl = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearIdleDeleteTtl() {
      bitField0_ = (bitField0_ & ~0x00000001);
      idleDeleteTtl_ = null;
      if (idleDeleteTtlBuilder_ != null) {
        idleDeleteTtlBuilder_.dispose();
        idleDeleteTtlBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The duration to keep the cluster alive while idling (when no jobs
     * are running). Passing this threshold will cause the cluster to be
     * deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration idle_delete_ttl = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getIdleDeleteTtlBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getIdleDeleteTtlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The duration to keep the cluster alive while idling (when no jobs
     * are running). Passing this threshold will cause the cluster to be
     * deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration idle_delete_ttl = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getIdleDeleteTtlOrBuilder() {
      if (idleDeleteTtlBuilder_ != null) {
        return idleDeleteTtlBuilder_.getMessageOrBuilder();
      } else {
        return idleDeleteTtl_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : idleDeleteTtl_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The duration to keep the cluster alive while idling (when no jobs
     * are running). Passing this threshold will cause the cluster to be
     * deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration idle_delete_ttl = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getIdleDeleteTtlFieldBuilder() {
      if (idleDeleteTtlBuilder_ == null) {
        idleDeleteTtlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getIdleDeleteTtl(), getParentForChildren(), isClean());
        idleDeleteTtl_ = null;
      }
      return idleDeleteTtlBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        autoDeleteTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The time when cluster will be auto-deleted (see JSON
     * representation of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp auto_delete_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the autoDeleteTime field is set.
     */
    @java.lang.Override
    public boolean hasAutoDeleteTime() {
      return ttlCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when cluster will be auto-deleted (see JSON
     * representation of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp auto_delete_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The autoDeleteTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getAutoDeleteTime() {
      if (autoDeleteTimeBuilder_ == null) {
        if (ttlCase_ == 2) {
          return (com.google.protobuf.Timestamp) ttl_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (ttlCase_ == 2) {
          return autoDeleteTimeBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when cluster will be auto-deleted (see JSON
     * representation of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp auto_delete_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutoDeleteTime(com.google.protobuf.Timestamp value) {
      if (autoDeleteTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ttl_ = value;
        onChanged();
      } else {
        autoDeleteTimeBuilder_.setMessage(value);
      }
      ttlCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when cluster will be auto-deleted (see JSON
     * representation of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp auto_delete_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutoDeleteTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (autoDeleteTimeBuilder_ == null) {
        ttl_ = builderForValue.build();
        onChanged();
      } else {
        autoDeleteTimeBuilder_.setMessage(builderForValue.build());
      }
      ttlCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when cluster will be auto-deleted (see JSON
     * representation of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp auto_delete_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAutoDeleteTime(com.google.protobuf.Timestamp value) {
      if (autoDeleteTimeBuilder_ == null) {
        if (ttlCase_ == 2 && ttl_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          ttl_ =
              com.google.protobuf.Timestamp.newBuilder((com.google.protobuf.Timestamp) ttl_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          ttl_ = value;
        }
        onChanged();
      } else {
        if (ttlCase_ == 2) {
          autoDeleteTimeBuilder_.mergeFrom(value);
        } else {
          autoDeleteTimeBuilder_.setMessage(value);
        }
      }
      ttlCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when cluster will be auto-deleted (see JSON
     * representation of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp auto_delete_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAutoDeleteTime() {
      if (autoDeleteTimeBuilder_ == null) {
        if (ttlCase_ == 2) {
          ttlCase_ = 0;
          ttl_ = null;
          onChanged();
        }
      } else {
        if (ttlCase_ == 2) {
          ttlCase_ = 0;
          ttl_ = null;
        }
        autoDeleteTimeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when cluster will be auto-deleted (see JSON
     * representation of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp auto_delete_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getAutoDeleteTimeBuilder() {
      return getAutoDeleteTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when cluster will be auto-deleted (see JSON
     * representation of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp auto_delete_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getAutoDeleteTimeOrBuilder() {
      if ((ttlCase_ == 2) && (autoDeleteTimeBuilder_ != null)) {
        return autoDeleteTimeBuilder_.getMessageOrBuilder();
      } else {
        if (ttlCase_ == 2) {
          return (com.google.protobuf.Timestamp) ttl_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The time when cluster will be auto-deleted (see JSON
     * representation of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp auto_delete_time = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getAutoDeleteTimeFieldBuilder() {
      if (autoDeleteTimeBuilder_ == null) {
        if (!(ttlCase_ == 2)) {
          ttl_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        autoDeleteTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) ttl_, getParentForChildren(), isClean());
        ttl_ = null;
      }
      ttlCase_ = 2;
      onChanged();
      return autoDeleteTimeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        autoDeleteTtlBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The lifetime duration of cluster. The cluster will be
     * auto-deleted at the end of this period. Minimum value is 10 minutes;
     * maximum value is 14 days (see JSON representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration auto_delete_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the autoDeleteTtl field is set.
     */
    @java.lang.Override
    public boolean hasAutoDeleteTtl() {
      return ttlCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Optional. The lifetime duration of cluster. The cluster will be
     * auto-deleted at the end of this period. Minimum value is 10 minutes;
     * maximum value is 14 days (see JSON representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration auto_delete_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The autoDeleteTtl.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getAutoDeleteTtl() {
      if (autoDeleteTtlBuilder_ == null) {
        if (ttlCase_ == 3) {
          return (com.google.protobuf.Duration) ttl_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      } else {
        if (ttlCase_ == 3) {
          return autoDeleteTtlBuilder_.getMessage();
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The lifetime duration of cluster. The cluster will be
     * auto-deleted at the end of this period. Minimum value is 10 minutes;
     * maximum value is 14 days (see JSON representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration auto_delete_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutoDeleteTtl(com.google.protobuf.Duration value) {
      if (autoDeleteTtlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ttl_ = value;
        onChanged();
      } else {
        autoDeleteTtlBuilder_.setMessage(value);
      }
      ttlCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The lifetime duration of cluster. The cluster will be
     * auto-deleted at the end of this period. Minimum value is 10 minutes;
     * maximum value is 14 days (see JSON representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration auto_delete_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutoDeleteTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (autoDeleteTtlBuilder_ == null) {
        ttl_ = builderForValue.build();
        onChanged();
      } else {
        autoDeleteTtlBuilder_.setMessage(builderForValue.build());
      }
      ttlCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The lifetime duration of cluster. The cluster will be
     * auto-deleted at the end of this period. Minimum value is 10 minutes;
     * maximum value is 14 days (see JSON representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration auto_delete_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAutoDeleteTtl(com.google.protobuf.Duration value) {
      if (autoDeleteTtlBuilder_ == null) {
        if (ttlCase_ == 3 && ttl_ != com.google.protobuf.Duration.getDefaultInstance()) {
          ttl_ =
              com.google.protobuf.Duration.newBuilder((com.google.protobuf.Duration) ttl_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          ttl_ = value;
        }
        onChanged();
      } else {
        if (ttlCase_ == 3) {
          autoDeleteTtlBuilder_.mergeFrom(value);
        } else {
          autoDeleteTtlBuilder_.setMessage(value);
        }
      }
      ttlCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The lifetime duration of cluster. The cluster will be
     * auto-deleted at the end of this period. Minimum value is 10 minutes;
     * maximum value is 14 days (see JSON representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration auto_delete_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAutoDeleteTtl() {
      if (autoDeleteTtlBuilder_ == null) {
        if (ttlCase_ == 3) {
          ttlCase_ = 0;
          ttl_ = null;
          onChanged();
        }
      } else {
        if (ttlCase_ == 3) {
          ttlCase_ = 0;
          ttl_ = null;
        }
        autoDeleteTtlBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The lifetime duration of cluster. The cluster will be
     * auto-deleted at the end of this period. Minimum value is 10 minutes;
     * maximum value is 14 days (see JSON representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration auto_delete_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getAutoDeleteTtlBuilder() {
      return getAutoDeleteTtlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The lifetime duration of cluster. The cluster will be
     * auto-deleted at the end of this period. Minimum value is 10 minutes;
     * maximum value is 14 days (see JSON representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration auto_delete_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getAutoDeleteTtlOrBuilder() {
      if ((ttlCase_ == 3) && (autoDeleteTtlBuilder_ != null)) {
        return autoDeleteTtlBuilder_.getMessageOrBuilder();
      } else {
        if (ttlCase_ == 3) {
          return (com.google.protobuf.Duration) ttl_;
        }
        return com.google.protobuf.Duration.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The lifetime duration of cluster. The cluster will be
     * auto-deleted at the end of this period. Minimum value is 10 minutes;
     * maximum value is 14 days (see JSON representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration auto_delete_ttl = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getAutoDeleteTtlFieldBuilder() {
      if (autoDeleteTtlBuilder_ == null) {
        if (!(ttlCase_ == 3)) {
          ttl_ = com.google.protobuf.Duration.getDefaultInstance();
        }
        autoDeleteTtlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                (com.google.protobuf.Duration) ttl_, getParentForChildren(), isClean());
        ttl_ = null;
      }
      ttlCase_ = 3;
      onChanged();
      return autoDeleteTtlBuilder_;
    }

    private com.google.protobuf.Timestamp idleStartTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        idleStartTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when cluster became idle (most recent job finished)
     * and became eligible for deletion due to idleness (see JSON representation
     * of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp idle_start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the idleStartTime field is set.
     */
    public boolean hasIdleStartTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when cluster became idle (most recent job finished)
     * and became eligible for deletion due to idleness (see JSON representation
     * of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp idle_start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The idleStartTime.
     */
    public com.google.protobuf.Timestamp getIdleStartTime() {
      if (idleStartTimeBuilder_ == null) {
        return idleStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : idleStartTime_;
      } else {
        return idleStartTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when cluster became idle (most recent job finished)
     * and became eligible for deletion due to idleness (see JSON representation
     * of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp idle_start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setIdleStartTime(com.google.protobuf.Timestamp value) {
      if (idleStartTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        idleStartTime_ = value;
      } else {
        idleStartTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when cluster became idle (most recent job finished)
     * and became eligible for deletion due to idleness (see JSON representation
     * of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp idle_start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setIdleStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (idleStartTimeBuilder_ == null) {
        idleStartTime_ = builderForValue.build();
      } else {
        idleStartTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when cluster became idle (most recent job finished)
     * and became eligible for deletion due to idleness (see JSON representation
     * of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp idle_start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeIdleStartTime(com.google.protobuf.Timestamp value) {
      if (idleStartTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && idleStartTime_ != null
            && idleStartTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getIdleStartTimeBuilder().mergeFrom(value);
        } else {
          idleStartTime_ = value;
        }
      } else {
        idleStartTimeBuilder_.mergeFrom(value);
      }
      if (idleStartTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when cluster became idle (most recent job finished)
     * and became eligible for deletion due to idleness (see JSON representation
     * of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp idle_start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearIdleStartTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      idleStartTime_ = null;
      if (idleStartTimeBuilder_ != null) {
        idleStartTimeBuilder_.dispose();
        idleStartTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when cluster became idle (most recent job finished)
     * and became eligible for deletion due to idleness (see JSON representation
     * of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp idle_start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getIdleStartTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getIdleStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when cluster became idle (most recent job finished)
     * and became eligible for deletion due to idleness (see JSON representation
     * of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp idle_start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getIdleStartTimeOrBuilder() {
      if (idleStartTimeBuilder_ != null) {
        return idleStartTimeBuilder_.getMessageOrBuilder();
      } else {
        return idleStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : idleStartTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when cluster became idle (most recent job finished)
     * and became eligible for deletion due to idleness (see JSON representation
     * of
     * [Timestamp](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp idle_start_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getIdleStartTimeFieldBuilder() {
      if (idleStartTimeBuilder_ == null) {
        idleStartTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getIdleStartTime(), getParentForChildren(), isClean());
        idleStartTime_ = null;
      }
      return idleStartTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.LifecycleConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.LifecycleConfig)
  private static final com.google.cloud.dataproc.v1.LifecycleConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.LifecycleConfig();
  }

  public static com.google.cloud.dataproc.v1.LifecycleConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LifecycleConfig> PARSER =
      new com.google.protobuf.AbstractParser<LifecycleConfig>() {
        @java.lang.Override
        public LifecycleConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LifecycleConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LifecycleConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.LifecycleConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
