/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/jobs.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * A Dataproc job for running
 * [Apache
 * PySpark](https://spark.apache.org/docs/0.9.0/python-programming-guide.html)
 * applications on YARN.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.PySparkJob}
 */
public final class PySparkJob extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.PySparkJob)
    PySparkJobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PySparkJob.newBuilder() to construct.
  private PySparkJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PySparkJob() {
    mainPythonFileUri_ = "";
    args_ = com.google.protobuf.LazyStringArrayList.emptyList();
    pythonFileUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
    jarFileUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
    fileUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
    archiveUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PySparkJob();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.JobsProto
        .internal_static_google_cloud_dataproc_v1_PySparkJob_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 7:
        return internalGetProperties();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.JobsProto
        .internal_static_google_cloud_dataproc_v1_PySparkJob_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.PySparkJob.class,
            com.google.cloud.dataproc.v1.PySparkJob.Builder.class);
  }

  private int bitField0_;
  public static final int MAIN_PYTHON_FILE_URI_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object mainPythonFileUri_ = "";
  /**
   *
   *
   * <pre>
   * Required. The HCFS URI of the main Python file to use as the driver. Must
   * be a .py file.
   * </pre>
   *
   * <code>string main_python_file_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The mainPythonFileUri.
   */
  @java.lang.Override
  public java.lang.String getMainPythonFileUri() {
    java.lang.Object ref = mainPythonFileUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      mainPythonFileUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The HCFS URI of the main Python file to use as the driver. Must
   * be a .py file.
   * </pre>
   *
   * <code>string main_python_file_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for mainPythonFileUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMainPythonFileUriBytes() {
    java.lang.Object ref = mainPythonFileUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      mainPythonFileUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ARGS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList args_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. The arguments to pass to the driver.  Do not include arguments,
   * such as `--conf`, that can be set as job properties, since a collision may
   * occur that causes an incorrect job submission.
   * </pre>
   *
   * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the args.
   */
  public com.google.protobuf.ProtocolStringList getArgsList() {
    return args_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The arguments to pass to the driver.  Do not include arguments,
   * such as `--conf`, that can be set as job properties, since a collision may
   * occur that causes an incorrect job submission.
   * </pre>
   *
   * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of args.
   */
  public int getArgsCount() {
    return args_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The arguments to pass to the driver.  Do not include arguments,
   * such as `--conf`, that can be set as job properties, since a collision may
   * occur that causes an incorrect job submission.
   * </pre>
   *
   * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The args at the given index.
   */
  public java.lang.String getArgs(int index) {
    return args_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The arguments to pass to the driver.  Do not include arguments,
   * such as `--conf`, that can be set as job properties, since a collision may
   * occur that causes an incorrect job submission.
   * </pre>
   *
   * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the args at the given index.
   */
  public com.google.protobuf.ByteString getArgsBytes(int index) {
    return args_.getByteString(index);
  }

  public static final int PYTHON_FILE_URIS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList pythonFileUris_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. HCFS file URIs of Python files to pass to the PySpark
   * framework. Supported file types: .py, .egg, and .zip.
   * </pre>
   *
   * <code>repeated string python_file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the pythonFileUris.
   */
  public com.google.protobuf.ProtocolStringList getPythonFileUrisList() {
    return pythonFileUris_;
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS file URIs of Python files to pass to the PySpark
   * framework. Supported file types: .py, .egg, and .zip.
   * </pre>
   *
   * <code>repeated string python_file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of pythonFileUris.
   */
  public int getPythonFileUrisCount() {
    return pythonFileUris_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS file URIs of Python files to pass to the PySpark
   * framework. Supported file types: .py, .egg, and .zip.
   * </pre>
   *
   * <code>repeated string python_file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The pythonFileUris at the given index.
   */
  public java.lang.String getPythonFileUris(int index) {
    return pythonFileUris_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS file URIs of Python files to pass to the PySpark
   * framework. Supported file types: .py, .egg, and .zip.
   * </pre>
   *
   * <code>repeated string python_file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the pythonFileUris at the given index.
   */
  public com.google.protobuf.ByteString getPythonFileUrisBytes(int index) {
    return pythonFileUris_.getByteString(index);
  }

  public static final int JAR_FILE_URIS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList jarFileUris_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the
   * Python driver and tasks.
   * </pre>
   *
   * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the jarFileUris.
   */
  public com.google.protobuf.ProtocolStringList getJarFileUrisList() {
    return jarFileUris_;
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the
   * Python driver and tasks.
   * </pre>
   *
   * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of jarFileUris.
   */
  public int getJarFileUrisCount() {
    return jarFileUris_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the
   * Python driver and tasks.
   * </pre>
   *
   * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The jarFileUris at the given index.
   */
  public java.lang.String getJarFileUris(int index) {
    return jarFileUris_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the
   * Python driver and tasks.
   * </pre>
   *
   * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the jarFileUris at the given index.
   */
  public com.google.protobuf.ByteString getJarFileUrisBytes(int index) {
    return jarFileUris_.getByteString(index);
  }

  public static final int FILE_URIS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList fileUris_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of files to be placed in the working directory of
   * each executor. Useful for naively parallel tasks.
   * </pre>
   *
   * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the fileUris.
   */
  public com.google.protobuf.ProtocolStringList getFileUrisList() {
    return fileUris_;
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of files to be placed in the working directory of
   * each executor. Useful for naively parallel tasks.
   * </pre>
   *
   * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of fileUris.
   */
  public int getFileUrisCount() {
    return fileUris_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of files to be placed in the working directory of
   * each executor. Useful for naively parallel tasks.
   * </pre>
   *
   * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The fileUris at the given index.
   */
  public java.lang.String getFileUris(int index) {
    return fileUris_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of files to be placed in the working directory of
   * each executor. Useful for naively parallel tasks.
   * </pre>
   *
   * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the fileUris at the given index.
   */
  public com.google.protobuf.ByteString getFileUrisBytes(int index) {
    return fileUris_.getByteString(index);
  }

  public static final int ARCHIVE_URIS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList archiveUris_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of archives to be extracted into the working directory
   * of each executor. Supported file types:
   * .jar, .tar, .tar.gz, .tgz, and .zip.
   * </pre>
   *
   * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the archiveUris.
   */
  public com.google.protobuf.ProtocolStringList getArchiveUrisList() {
    return archiveUris_;
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of archives to be extracted into the working directory
   * of each executor. Supported file types:
   * .jar, .tar, .tar.gz, .tgz, and .zip.
   * </pre>
   *
   * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of archiveUris.
   */
  public int getArchiveUrisCount() {
    return archiveUris_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of archives to be extracted into the working directory
   * of each executor. Supported file types:
   * .jar, .tar, .tar.gz, .tgz, and .zip.
   * </pre>
   *
   * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The archiveUris at the given index.
   */
  public java.lang.String getArchiveUris(int index) {
    return archiveUris_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of archives to be extracted into the working directory
   * of each executor. Supported file types:
   * .jar, .tar, .tar.gz, .tgz, and .zip.
   * </pre>
   *
   * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the archiveUris at the given index.
   */
  public com.google.protobuf.ByteString getArchiveUrisBytes(int index) {
    return archiveUris_.getByteString(index);
  }

  public static final int PROPERTIES_FIELD_NUMBER = 7;

  private static final class PropertiesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataproc.v1.JobsProto
                .internal_static_google_cloud_dataproc_v1_PySparkJob_PropertiesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> properties_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetProperties() {
    if (properties_ == null) {
      return com.google.protobuf.MapField.emptyMapField(PropertiesDefaultEntryHolder.defaultEntry);
    }
    return properties_;
  }

  public int getPropertiesCount() {
    return internalGetProperties().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A mapping of property names to values, used to configure PySpark.
   * Properties that conflict with values set by the Dataproc API might be
   * overwritten. Can include properties set in
   * /etc/spark/conf/spark-defaults.conf and classes in user code.
   * </pre>
   *
   * <code>map&lt;string, string&gt; properties = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsProperties(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetProperties().getMap().containsKey(key);
  }
  /** Use {@link #getPropertiesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getProperties() {
    return getPropertiesMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. A mapping of property names to values, used to configure PySpark.
   * Properties that conflict with values set by the Dataproc API might be
   * overwritten. Can include properties set in
   * /etc/spark/conf/spark-defaults.conf and classes in user code.
   * </pre>
   *
   * <code>map&lt;string, string&gt; properties = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getPropertiesMap() {
    return internalGetProperties().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. A mapping of property names to values, used to configure PySpark.
   * Properties that conflict with values set by the Dataproc API might be
   * overwritten. Can include properties set in
   * /etc/spark/conf/spark-defaults.conf and classes in user code.
   * </pre>
   *
   * <code>map&lt;string, string&gt; properties = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getPropertiesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetProperties().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. A mapping of property names to values, used to configure PySpark.
   * Properties that conflict with values set by the Dataproc API might be
   * overwritten. Can include properties set in
   * /etc/spark/conf/spark-defaults.conf and classes in user code.
   * </pre>
   *
   * <code>map&lt;string, string&gt; properties = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getPropertiesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetProperties().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LOGGING_CONFIG_FIELD_NUMBER = 8;
  private com.google.cloud.dataproc.v1.LoggingConfig loggingConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The runtime log config for job execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.LoggingConfig logging_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the loggingConfig field is set.
   */
  @java.lang.Override
  public boolean hasLoggingConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The runtime log config for job execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.LoggingConfig logging_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The loggingConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.LoggingConfig getLoggingConfig() {
    return loggingConfig_ == null
        ? com.google.cloud.dataproc.v1.LoggingConfig.getDefaultInstance()
        : loggingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The runtime log config for job execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.LoggingConfig logging_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.LoggingConfigOrBuilder getLoggingConfigOrBuilder() {
    return loggingConfig_ == null
        ? com.google.cloud.dataproc.v1.LoggingConfig.getDefaultInstance()
        : loggingConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mainPythonFileUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, mainPythonFileUri_);
    }
    for (int i = 0; i < args_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, args_.getRaw(i));
    }
    for (int i = 0; i < pythonFileUris_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pythonFileUris_.getRaw(i));
    }
    for (int i = 0; i < jarFileUris_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, jarFileUris_.getRaw(i));
    }
    for (int i = 0; i < fileUris_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, fileUris_.getRaw(i));
    }
    for (int i = 0; i < archiveUris_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, archiveUris_.getRaw(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetProperties(), PropertiesDefaultEntryHolder.defaultEntry, 7);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(8, getLoggingConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mainPythonFileUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, mainPythonFileUri_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < args_.size(); i++) {
        dataSize += computeStringSizeNoTag(args_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getArgsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < pythonFileUris_.size(); i++) {
        dataSize += computeStringSizeNoTag(pythonFileUris_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getPythonFileUrisList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < jarFileUris_.size(); i++) {
        dataSize += computeStringSizeNoTag(jarFileUris_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getJarFileUrisList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < fileUris_.size(); i++) {
        dataSize += computeStringSizeNoTag(fileUris_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFileUrisList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < archiveUris_.size(); i++) {
        dataSize += computeStringSizeNoTag(archiveUris_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getArchiveUrisList().size();
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetProperties().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> properties__ =
          PropertiesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, properties__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getLoggingConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.PySparkJob)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.PySparkJob other = (com.google.cloud.dataproc.v1.PySparkJob) obj;

    if (!getMainPythonFileUri().equals(other.getMainPythonFileUri())) return false;
    if (!getArgsList().equals(other.getArgsList())) return false;
    if (!getPythonFileUrisList().equals(other.getPythonFileUrisList())) return false;
    if (!getJarFileUrisList().equals(other.getJarFileUrisList())) return false;
    if (!getFileUrisList().equals(other.getFileUrisList())) return false;
    if (!getArchiveUrisList().equals(other.getArchiveUrisList())) return false;
    if (!internalGetProperties().equals(other.internalGetProperties())) return false;
    if (hasLoggingConfig() != other.hasLoggingConfig()) return false;
    if (hasLoggingConfig()) {
      if (!getLoggingConfig().equals(other.getLoggingConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MAIN_PYTHON_FILE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getMainPythonFileUri().hashCode();
    if (getArgsCount() > 0) {
      hash = (37 * hash) + ARGS_FIELD_NUMBER;
      hash = (53 * hash) + getArgsList().hashCode();
    }
    if (getPythonFileUrisCount() > 0) {
      hash = (37 * hash) + PYTHON_FILE_URIS_FIELD_NUMBER;
      hash = (53 * hash) + getPythonFileUrisList().hashCode();
    }
    if (getJarFileUrisCount() > 0) {
      hash = (37 * hash) + JAR_FILE_URIS_FIELD_NUMBER;
      hash = (53 * hash) + getJarFileUrisList().hashCode();
    }
    if (getFileUrisCount() > 0) {
      hash = (37 * hash) + FILE_URIS_FIELD_NUMBER;
      hash = (53 * hash) + getFileUrisList().hashCode();
    }
    if (getArchiveUrisCount() > 0) {
      hash = (37 * hash) + ARCHIVE_URIS_FIELD_NUMBER;
      hash = (53 * hash) + getArchiveUrisList().hashCode();
    }
    if (!internalGetProperties().getMap().isEmpty()) {
      hash = (37 * hash) + PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetProperties().hashCode();
    }
    if (hasLoggingConfig()) {
      hash = (37 * hash) + LOGGING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getLoggingConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.PySparkJob parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.PySparkJob parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.PySparkJob parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.PySparkJob parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.PySparkJob parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.PySparkJob parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.PySparkJob parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.PySparkJob parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.PySparkJob parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.PySparkJob parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.PySparkJob parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.PySparkJob parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.PySparkJob prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Dataproc job for running
   * [Apache
   * PySpark](https://spark.apache.org/docs/0.9.0/python-programming-guide.html)
   * applications on YARN.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.PySparkJob}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.PySparkJob)
      com.google.cloud.dataproc.v1.PySparkJobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.JobsProto
          .internal_static_google_cloud_dataproc_v1_PySparkJob_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 7:
          return internalGetProperties();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 7:
          return internalGetMutableProperties();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.JobsProto
          .internal_static_google_cloud_dataproc_v1_PySparkJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.PySparkJob.class,
              com.google.cloud.dataproc.v1.PySparkJob.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.PySparkJob.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLoggingConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      mainPythonFileUri_ = "";
      args_ = com.google.protobuf.LazyStringArrayList.emptyList();
      pythonFileUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      jarFileUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      fileUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      archiveUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      internalGetMutableProperties().clear();
      loggingConfig_ = null;
      if (loggingConfigBuilder_ != null) {
        loggingConfigBuilder_.dispose();
        loggingConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.JobsProto
          .internal_static_google_cloud_dataproc_v1_PySparkJob_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.PySparkJob getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.PySparkJob.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.PySparkJob build() {
      com.google.cloud.dataproc.v1.PySparkJob result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.PySparkJob buildPartial() {
      com.google.cloud.dataproc.v1.PySparkJob result =
          new com.google.cloud.dataproc.v1.PySparkJob(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.PySparkJob result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.mainPythonFileUri_ = mainPythonFileUri_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        args_.makeImmutable();
        result.args_ = args_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        pythonFileUris_.makeImmutable();
        result.pythonFileUris_ = pythonFileUris_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        jarFileUris_.makeImmutable();
        result.jarFileUris_ = jarFileUris_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        fileUris_.makeImmutable();
        result.fileUris_ = fileUris_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        archiveUris_.makeImmutable();
        result.archiveUris_ = archiveUris_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.properties_ = internalGetProperties();
        result.properties_.makeImmutable();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.loggingConfig_ =
            loggingConfigBuilder_ == null ? loggingConfig_ : loggingConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.PySparkJob) {
        return mergeFrom((com.google.cloud.dataproc.v1.PySparkJob) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.PySparkJob other) {
      if (other == com.google.cloud.dataproc.v1.PySparkJob.getDefaultInstance()) return this;
      if (!other.getMainPythonFileUri().isEmpty()) {
        mainPythonFileUri_ = other.mainPythonFileUri_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.args_.isEmpty()) {
        if (args_.isEmpty()) {
          args_ = other.args_;
          bitField0_ |= 0x00000002;
        } else {
          ensureArgsIsMutable();
          args_.addAll(other.args_);
        }
        onChanged();
      }
      if (!other.pythonFileUris_.isEmpty()) {
        if (pythonFileUris_.isEmpty()) {
          pythonFileUris_ = other.pythonFileUris_;
          bitField0_ |= 0x00000004;
        } else {
          ensurePythonFileUrisIsMutable();
          pythonFileUris_.addAll(other.pythonFileUris_);
        }
        onChanged();
      }
      if (!other.jarFileUris_.isEmpty()) {
        if (jarFileUris_.isEmpty()) {
          jarFileUris_ = other.jarFileUris_;
          bitField0_ |= 0x00000008;
        } else {
          ensureJarFileUrisIsMutable();
          jarFileUris_.addAll(other.jarFileUris_);
        }
        onChanged();
      }
      if (!other.fileUris_.isEmpty()) {
        if (fileUris_.isEmpty()) {
          fileUris_ = other.fileUris_;
          bitField0_ |= 0x00000010;
        } else {
          ensureFileUrisIsMutable();
          fileUris_.addAll(other.fileUris_);
        }
        onChanged();
      }
      if (!other.archiveUris_.isEmpty()) {
        if (archiveUris_.isEmpty()) {
          archiveUris_ = other.archiveUris_;
          bitField0_ |= 0x00000020;
        } else {
          ensureArchiveUrisIsMutable();
          archiveUris_.addAll(other.archiveUris_);
        }
        onChanged();
      }
      internalGetMutableProperties().mergeFrom(other.internalGetProperties());
      bitField0_ |= 0x00000040;
      if (other.hasLoggingConfig()) {
        mergeLoggingConfig(other.getLoggingConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                mainPythonFileUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureArgsIsMutable();
                args_.add(s);
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensurePythonFileUrisIsMutable();
                pythonFileUris_.add(s);
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureJarFileUrisIsMutable();
                jarFileUris_.add(s);
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureFileUrisIsMutable();
                fileUris_.add(s);
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureArchiveUrisIsMutable();
                archiveUris_.add(s);
                break;
              } // case 50
            case 58:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> properties__ =
                    input.readMessage(
                        PropertiesDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableProperties()
                    .getMutableMap()
                    .put(properties__.getKey(), properties__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getLoggingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object mainPythonFileUri_ = "";
    /**
     *
     *
     * <pre>
     * Required. The HCFS URI of the main Python file to use as the driver. Must
     * be a .py file.
     * </pre>
     *
     * <code>string main_python_file_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The mainPythonFileUri.
     */
    public java.lang.String getMainPythonFileUri() {
      java.lang.Object ref = mainPythonFileUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mainPythonFileUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The HCFS URI of the main Python file to use as the driver. Must
     * be a .py file.
     * </pre>
     *
     * <code>string main_python_file_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for mainPythonFileUri.
     */
    public com.google.protobuf.ByteString getMainPythonFileUriBytes() {
      java.lang.Object ref = mainPythonFileUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mainPythonFileUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The HCFS URI of the main Python file to use as the driver. Must
     * be a .py file.
     * </pre>
     *
     * <code>string main_python_file_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The mainPythonFileUri to set.
     * @return This builder for chaining.
     */
    public Builder setMainPythonFileUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      mainPythonFileUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The HCFS URI of the main Python file to use as the driver. Must
     * be a .py file.
     * </pre>
     *
     * <code>string main_python_file_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMainPythonFileUri() {
      mainPythonFileUri_ = getDefaultInstance().getMainPythonFileUri();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The HCFS URI of the main Python file to use as the driver. Must
     * be a .py file.
     * </pre>
     *
     * <code>string main_python_file_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for mainPythonFileUri to set.
     * @return This builder for chaining.
     */
    public Builder setMainPythonFileUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      mainPythonFileUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList args_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureArgsIsMutable() {
      if (!args_.isModifiable()) {
        args_ = new com.google.protobuf.LazyStringArrayList(args_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the driver.  Do not include arguments,
     * such as `--conf`, that can be set as job properties, since a collision may
     * occur that causes an incorrect job submission.
     * </pre>
     *
     * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the args.
     */
    public com.google.protobuf.ProtocolStringList getArgsList() {
      args_.makeImmutable();
      return args_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the driver.  Do not include arguments,
     * such as `--conf`, that can be set as job properties, since a collision may
     * occur that causes an incorrect job submission.
     * </pre>
     *
     * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of args.
     */
    public int getArgsCount() {
      return args_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the driver.  Do not include arguments,
     * such as `--conf`, that can be set as job properties, since a collision may
     * occur that causes an incorrect job submission.
     * </pre>
     *
     * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The args at the given index.
     */
    public java.lang.String getArgs(int index) {
      return args_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the driver.  Do not include arguments,
     * such as `--conf`, that can be set as job properties, since a collision may
     * occur that causes an incorrect job submission.
     * </pre>
     *
     * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the args at the given index.
     */
    public com.google.protobuf.ByteString getArgsBytes(int index) {
      return args_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the driver.  Do not include arguments,
     * such as `--conf`, that can be set as job properties, since a collision may
     * occur that causes an incorrect job submission.
     * </pre>
     *
     * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The args to set.
     * @return This builder for chaining.
     */
    public Builder setArgs(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the driver.  Do not include arguments,
     * such as `--conf`, that can be set as job properties, since a collision may
     * occur that causes an incorrect job submission.
     * </pre>
     *
     * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The args to add.
     * @return This builder for chaining.
     */
    public Builder addArgs(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the driver.  Do not include arguments,
     * such as `--conf`, that can be set as job properties, since a collision may
     * occur that causes an incorrect job submission.
     * </pre>
     *
     * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The args to add.
     * @return This builder for chaining.
     */
    public Builder addAllArgs(java.lang.Iterable<java.lang.String> values) {
      ensureArgsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, args_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the driver.  Do not include arguments,
     * such as `--conf`, that can be set as job properties, since a collision may
     * occur that causes an incorrect job submission.
     * </pre>
     *
     * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArgs() {
      args_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the driver.  Do not include arguments,
     * such as `--conf`, that can be set as job properties, since a collision may
     * occur that causes an incorrect job submission.
     * </pre>
     *
     * <code>repeated string args = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the args to add.
     * @return This builder for chaining.
     */
    public Builder addArgsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureArgsIsMutable();
      args_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList pythonFileUris_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensurePythonFileUrisIsMutable() {
      if (!pythonFileUris_.isModifiable()) {
        pythonFileUris_ = new com.google.protobuf.LazyStringArrayList(pythonFileUris_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS file URIs of Python files to pass to the PySpark
     * framework. Supported file types: .py, .egg, and .zip.
     * </pre>
     *
     * <code>repeated string python_file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the pythonFileUris.
     */
    public com.google.protobuf.ProtocolStringList getPythonFileUrisList() {
      pythonFileUris_.makeImmutable();
      return pythonFileUris_;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS file URIs of Python files to pass to the PySpark
     * framework. Supported file types: .py, .egg, and .zip.
     * </pre>
     *
     * <code>repeated string python_file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of pythonFileUris.
     */
    public int getPythonFileUrisCount() {
      return pythonFileUris_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS file URIs of Python files to pass to the PySpark
     * framework. Supported file types: .py, .egg, and .zip.
     * </pre>
     *
     * <code>repeated string python_file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The pythonFileUris at the given index.
     */
    public java.lang.String getPythonFileUris(int index) {
      return pythonFileUris_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS file URIs of Python files to pass to the PySpark
     * framework. Supported file types: .py, .egg, and .zip.
     * </pre>
     *
     * <code>repeated string python_file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the pythonFileUris at the given index.
     */
    public com.google.protobuf.ByteString getPythonFileUrisBytes(int index) {
      return pythonFileUris_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS file URIs of Python files to pass to the PySpark
     * framework. Supported file types: .py, .egg, and .zip.
     * </pre>
     *
     * <code>repeated string python_file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The pythonFileUris to set.
     * @return This builder for chaining.
     */
    public Builder setPythonFileUris(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePythonFileUrisIsMutable();
      pythonFileUris_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS file URIs of Python files to pass to the PySpark
     * framework. Supported file types: .py, .egg, and .zip.
     * </pre>
     *
     * <code>repeated string python_file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pythonFileUris to add.
     * @return This builder for chaining.
     */
    public Builder addPythonFileUris(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePythonFileUrisIsMutable();
      pythonFileUris_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS file URIs of Python files to pass to the PySpark
     * framework. Supported file types: .py, .egg, and .zip.
     * </pre>
     *
     * <code>repeated string python_file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The pythonFileUris to add.
     * @return This builder for chaining.
     */
    public Builder addAllPythonFileUris(java.lang.Iterable<java.lang.String> values) {
      ensurePythonFileUrisIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, pythonFileUris_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS file URIs of Python files to pass to the PySpark
     * framework. Supported file types: .py, .egg, and .zip.
     * </pre>
     *
     * <code>repeated string python_file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPythonFileUris() {
      pythonFileUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS file URIs of Python files to pass to the PySpark
     * framework. Supported file types: .py, .egg, and .zip.
     * </pre>
     *
     * <code>repeated string python_file_uris = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the pythonFileUris to add.
     * @return This builder for chaining.
     */
    public Builder addPythonFileUrisBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensurePythonFileUrisIsMutable();
      pythonFileUris_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList jarFileUris_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureJarFileUrisIsMutable() {
      if (!jarFileUris_.isModifiable()) {
        jarFileUris_ = new com.google.protobuf.LazyStringArrayList(jarFileUris_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the
     * Python driver and tasks.
     * </pre>
     *
     * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the jarFileUris.
     */
    public com.google.protobuf.ProtocolStringList getJarFileUrisList() {
      jarFileUris_.makeImmutable();
      return jarFileUris_;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the
     * Python driver and tasks.
     * </pre>
     *
     * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of jarFileUris.
     */
    public int getJarFileUrisCount() {
      return jarFileUris_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the
     * Python driver and tasks.
     * </pre>
     *
     * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The jarFileUris at the given index.
     */
    public java.lang.String getJarFileUris(int index) {
      return jarFileUris_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the
     * Python driver and tasks.
     * </pre>
     *
     * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the jarFileUris at the given index.
     */
    public com.google.protobuf.ByteString getJarFileUrisBytes(int index) {
      return jarFileUris_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the
     * Python driver and tasks.
     * </pre>
     *
     * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The jarFileUris to set.
     * @return This builder for chaining.
     */
    public Builder setJarFileUris(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureJarFileUrisIsMutable();
      jarFileUris_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the
     * Python driver and tasks.
     * </pre>
     *
     * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The jarFileUris to add.
     * @return This builder for chaining.
     */
    public Builder addJarFileUris(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureJarFileUrisIsMutable();
      jarFileUris_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the
     * Python driver and tasks.
     * </pre>
     *
     * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The jarFileUris to add.
     * @return This builder for chaining.
     */
    public Builder addAllJarFileUris(java.lang.Iterable<java.lang.String> values) {
      ensureJarFileUrisIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, jarFileUris_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the
     * Python driver and tasks.
     * </pre>
     *
     * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJarFileUris() {
      jarFileUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of jar files to add to the CLASSPATHs of the
     * Python driver and tasks.
     * </pre>
     *
     * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the jarFileUris to add.
     * @return This builder for chaining.
     */
    public Builder addJarFileUrisBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureJarFileUrisIsMutable();
      jarFileUris_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList fileUris_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureFileUrisIsMutable() {
      if (!fileUris_.isModifiable()) {
        fileUris_ = new com.google.protobuf.LazyStringArrayList(fileUris_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor. Useful for naively parallel tasks.
     * </pre>
     *
     * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the fileUris.
     */
    public com.google.protobuf.ProtocolStringList getFileUrisList() {
      fileUris_.makeImmutable();
      return fileUris_;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor. Useful for naively parallel tasks.
     * </pre>
     *
     * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of fileUris.
     */
    public int getFileUrisCount() {
      return fileUris_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor. Useful for naively parallel tasks.
     * </pre>
     *
     * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The fileUris at the given index.
     */
    public java.lang.String getFileUris(int index) {
      return fileUris_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor. Useful for naively parallel tasks.
     * </pre>
     *
     * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the fileUris at the given index.
     */
    public com.google.protobuf.ByteString getFileUrisBytes(int index) {
      return fileUris_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor. Useful for naively parallel tasks.
     * </pre>
     *
     * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The fileUris to set.
     * @return This builder for chaining.
     */
    public Builder setFileUris(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFileUrisIsMutable();
      fileUris_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor. Useful for naively parallel tasks.
     * </pre>
     *
     * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The fileUris to add.
     * @return This builder for chaining.
     */
    public Builder addFileUris(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFileUrisIsMutable();
      fileUris_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor. Useful for naively parallel tasks.
     * </pre>
     *
     * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The fileUris to add.
     * @return This builder for chaining.
     */
    public Builder addAllFileUris(java.lang.Iterable<java.lang.String> values) {
      ensureFileUrisIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fileUris_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor. Useful for naively parallel tasks.
     * </pre>
     *
     * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFileUris() {
      fileUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor. Useful for naively parallel tasks.
     * </pre>
     *
     * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the fileUris to add.
     * @return This builder for chaining.
     */
    public Builder addFileUrisBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureFileUrisIsMutable();
      fileUris_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList archiveUris_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureArchiveUrisIsMutable() {
      if (!archiveUris_.isModifiable()) {
        archiveUris_ = new com.google.protobuf.LazyStringArrayList(archiveUris_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * .jar, .tar, .tar.gz, .tgz, and .zip.
     * </pre>
     *
     * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the archiveUris.
     */
    public com.google.protobuf.ProtocolStringList getArchiveUrisList() {
      archiveUris_.makeImmutable();
      return archiveUris_;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * .jar, .tar, .tar.gz, .tgz, and .zip.
     * </pre>
     *
     * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of archiveUris.
     */
    public int getArchiveUrisCount() {
      return archiveUris_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * .jar, .tar, .tar.gz, .tgz, and .zip.
     * </pre>
     *
     * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The archiveUris at the given index.
     */
    public java.lang.String getArchiveUris(int index) {
      return archiveUris_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * .jar, .tar, .tar.gz, .tgz, and .zip.
     * </pre>
     *
     * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the archiveUris at the given index.
     */
    public com.google.protobuf.ByteString getArchiveUrisBytes(int index) {
      return archiveUris_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * .jar, .tar, .tar.gz, .tgz, and .zip.
     * </pre>
     *
     * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The archiveUris to set.
     * @return This builder for chaining.
     */
    public Builder setArchiveUris(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArchiveUrisIsMutable();
      archiveUris_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * .jar, .tar, .tar.gz, .tgz, and .zip.
     * </pre>
     *
     * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The archiveUris to add.
     * @return This builder for chaining.
     */
    public Builder addArchiveUris(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArchiveUrisIsMutable();
      archiveUris_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * .jar, .tar, .tar.gz, .tgz, and .zip.
     * </pre>
     *
     * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The archiveUris to add.
     * @return This builder for chaining.
     */
    public Builder addAllArchiveUris(java.lang.Iterable<java.lang.String> values) {
      ensureArchiveUrisIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, archiveUris_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * .jar, .tar, .tar.gz, .tgz, and .zip.
     * </pre>
     *
     * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArchiveUris() {
      archiveUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * .jar, .tar, .tar.gz, .tgz, and .zip.
     * </pre>
     *
     * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the archiveUris to add.
     * @return This builder for chaining.
     */
    public Builder addArchiveUrisBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureArchiveUrisIsMutable();
      archiveUris_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> properties_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetProperties() {
      if (properties_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            PropertiesDefaultEntryHolder.defaultEntry);
      }
      return properties_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableProperties() {
      if (properties_ == null) {
        properties_ =
            com.google.protobuf.MapField.newMapField(PropertiesDefaultEntryHolder.defaultEntry);
      }
      if (!properties_.isMutable()) {
        properties_ = properties_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return properties_;
    }

    public int getPropertiesCount() {
      return internalGetProperties().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values, used to configure PySpark.
     * Properties that conflict with values set by the Dataproc API might be
     * overwritten. Can include properties set in
     * /etc/spark/conf/spark-defaults.conf and classes in user code.
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsProperties(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetProperties().getMap().containsKey(key);
    }
    /** Use {@link #getPropertiesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getProperties() {
      return getPropertiesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values, used to configure PySpark.
     * Properties that conflict with values set by the Dataproc API might be
     * overwritten. Can include properties set in
     * /etc/spark/conf/spark-defaults.conf and classes in user code.
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getPropertiesMap() {
      return internalGetProperties().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values, used to configure PySpark.
     * Properties that conflict with values set by the Dataproc API might be
     * overwritten. Can include properties set in
     * /etc/spark/conf/spark-defaults.conf and classes in user code.
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getPropertiesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetProperties().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values, used to configure PySpark.
     * Properties that conflict with values set by the Dataproc API might be
     * overwritten. Can include properties set in
     * /etc/spark/conf/spark-defaults.conf and classes in user code.
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getPropertiesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetProperties().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearProperties() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableProperties().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values, used to configure PySpark.
     * Properties that conflict with values set by the Dataproc API might be
     * overwritten. Can include properties set in
     * /etc/spark/conf/spark-defaults.conf and classes in user code.
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeProperties(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableProperties().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableProperties() {
      bitField0_ |= 0x00000040;
      return internalGetMutableProperties().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values, used to configure PySpark.
     * Properties that conflict with values set by the Dataproc API might be
     * overwritten. Can include properties set in
     * /etc/spark/conf/spark-defaults.conf and classes in user code.
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putProperties(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableProperties().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values, used to configure PySpark.
     * Properties that conflict with values set by the Dataproc API might be
     * overwritten. Can include properties set in
     * /etc/spark/conf/spark-defaults.conf and classes in user code.
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllProperties(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableProperties().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private com.google.cloud.dataproc.v1.LoggingConfig loggingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.LoggingConfig,
            com.google.cloud.dataproc.v1.LoggingConfig.Builder,
            com.google.cloud.dataproc.v1.LoggingConfigOrBuilder>
        loggingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The runtime log config for job execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.LoggingConfig logging_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the loggingConfig field is set.
     */
    public boolean hasLoggingConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime log config for job execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.LoggingConfig logging_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The loggingConfig.
     */
    public com.google.cloud.dataproc.v1.LoggingConfig getLoggingConfig() {
      if (loggingConfigBuilder_ == null) {
        return loggingConfig_ == null
            ? com.google.cloud.dataproc.v1.LoggingConfig.getDefaultInstance()
            : loggingConfig_;
      } else {
        return loggingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime log config for job execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.LoggingConfig logging_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLoggingConfig(com.google.cloud.dataproc.v1.LoggingConfig value) {
      if (loggingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        loggingConfig_ = value;
      } else {
        loggingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime log config for job execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.LoggingConfig logging_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setLoggingConfig(
        com.google.cloud.dataproc.v1.LoggingConfig.Builder builderForValue) {
      if (loggingConfigBuilder_ == null) {
        loggingConfig_ = builderForValue.build();
      } else {
        loggingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime log config for job execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.LoggingConfig logging_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeLoggingConfig(com.google.cloud.dataproc.v1.LoggingConfig value) {
      if (loggingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && loggingConfig_ != null
            && loggingConfig_ != com.google.cloud.dataproc.v1.LoggingConfig.getDefaultInstance()) {
          getLoggingConfigBuilder().mergeFrom(value);
        } else {
          loggingConfig_ = value;
        }
      } else {
        loggingConfigBuilder_.mergeFrom(value);
      }
      if (loggingConfig_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime log config for job execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.LoggingConfig logging_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearLoggingConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      loggingConfig_ = null;
      if (loggingConfigBuilder_ != null) {
        loggingConfigBuilder_.dispose();
        loggingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime log config for job execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.LoggingConfig logging_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.LoggingConfig.Builder getLoggingConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getLoggingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime log config for job execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.LoggingConfig logging_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.LoggingConfigOrBuilder getLoggingConfigOrBuilder() {
      if (loggingConfigBuilder_ != null) {
        return loggingConfigBuilder_.getMessageOrBuilder();
      } else {
        return loggingConfig_ == null
            ? com.google.cloud.dataproc.v1.LoggingConfig.getDefaultInstance()
            : loggingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The runtime log config for job execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.LoggingConfig logging_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.LoggingConfig,
            com.google.cloud.dataproc.v1.LoggingConfig.Builder,
            com.google.cloud.dataproc.v1.LoggingConfigOrBuilder>
        getLoggingConfigFieldBuilder() {
      if (loggingConfigBuilder_ == null) {
        loggingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.LoggingConfig,
                com.google.cloud.dataproc.v1.LoggingConfig.Builder,
                com.google.cloud.dataproc.v1.LoggingConfigOrBuilder>(
                getLoggingConfig(), getParentForChildren(), isClean());
        loggingConfig_ = null;
      }
      return loggingConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.PySparkJob)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.PySparkJob)
  private static final com.google.cloud.dataproc.v1.PySparkJob DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.PySparkJob();
  }

  public static com.google.cloud.dataproc.v1.PySparkJob getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PySparkJob> PARSER =
      new com.google.protobuf.AbstractParser<PySparkJob>() {
        @java.lang.Override
        public PySparkJob parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PySparkJob> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PySparkJob> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.PySparkJob getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
