/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/node_groups.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * A request to resize a node group.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.ResizeNodeGroupRequest}
 */
public final class ResizeNodeGroupRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.ResizeNodeGroupRequest)
    ResizeNodeGroupRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ResizeNodeGroupRequest.newBuilder() to construct.
  private ResizeNodeGroupRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ResizeNodeGroupRequest() {
    name_ = "";
    requestId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ResizeNodeGroupRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.NodeGroupsProto
        .internal_static_google_cloud_dataproc_v1_ResizeNodeGroupRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.NodeGroupsProto
        .internal_static_google_cloud_dataproc_v1_ResizeNodeGroupRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.ResizeNodeGroupRequest.class,
            com.google.cloud.dataproc.v1.ResizeNodeGroupRequest.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the node group to resize.
   * Format:
   * `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{nodeGroup}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the node group to resize.
   * Format:
   * `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{nodeGroup}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SIZE_FIELD_NUMBER = 2;
  private int size_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The number of running instances for the node group to maintain.
   * The group adds or removes instances to maintain the number of instances
   * specified by this parameter.
   * </pre>
   *
   * <code>int32 size = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The size.
   */
  @java.lang.Override
  public int getSize() {
    return size_;
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A unique ID used to identify the request. If the server receives
   * two
   * [ResizeNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.ResizeNodeGroupRequests)
   * with the same ID, the second request is ignored and the
   * first [google.longrunning.Operation][google.longrunning.Operation] created
   * and stored in the backend is returned.
   *
   * Recommendation: Set this value to a
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
   *
   * The ID must contain only letters (a-z, A-Z), numbers (0-9),
   * underscores (_), and hyphens (-). The maximum length is 40 characters.
   * </pre>
   *
   * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A unique ID used to identify the request. If the server receives
   * two
   * [ResizeNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.ResizeNodeGroupRequests)
   * with the same ID, the second request is ignored and the
   * first [google.longrunning.Operation][google.longrunning.Operation] created
   * and stored in the backend is returned.
   *
   * Recommendation: Set this value to a
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
   *
   * The ID must contain only letters (a-z, A-Z), numbers (0-9),
   * underscores (_), and hyphens (-). The maximum length is 40 characters.
   * </pre>
   *
   * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GRACEFUL_DECOMMISSION_TIMEOUT_FIELD_NUMBER = 4;
  private com.google.protobuf.Duration gracefulDecommissionTimeout_;
  /**
   *
   *
   * <pre>
   * Optional. Timeout for graceful YARN decommissioning. [Graceful
   * decommissioning]
   * (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
   * allows the removal of nodes from the Compute Engine node group
   * without interrupting jobs in progress. This timeout specifies how long to
   * wait for jobs in progress to finish before forcefully removing nodes (and
   * potentially interrupting jobs). Default timeout is 0 (for forceful
   * decommission), and the maximum allowed timeout is 1 day. (see JSON
   * representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   *
   * Only supported on Dataproc image versions 1.2 and higher.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration graceful_decommission_timeout = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the gracefulDecommissionTimeout field is set.
   */
  @java.lang.Override
  public boolean hasGracefulDecommissionTimeout() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Timeout for graceful YARN decommissioning. [Graceful
   * decommissioning]
   * (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
   * allows the removal of nodes from the Compute Engine node group
   * without interrupting jobs in progress. This timeout specifies how long to
   * wait for jobs in progress to finish before forcefully removing nodes (and
   * potentially interrupting jobs). Default timeout is 0 (for forceful
   * decommission), and the maximum allowed timeout is 1 day. (see JSON
   * representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   *
   * Only supported on Dataproc image versions 1.2 and higher.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration graceful_decommission_timeout = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The gracefulDecommissionTimeout.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getGracefulDecommissionTimeout() {
    return gracefulDecommissionTimeout_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : gracefulDecommissionTimeout_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Timeout for graceful YARN decommissioning. [Graceful
   * decommissioning]
   * (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
   * allows the removal of nodes from the Compute Engine node group
   * without interrupting jobs in progress. This timeout specifies how long to
   * wait for jobs in progress to finish before forcefully removing nodes (and
   * potentially interrupting jobs). Default timeout is 0 (for forceful
   * decommission), and the maximum allowed timeout is 1 day. (see JSON
   * representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   *
   * Only supported on Dataproc image versions 1.2 and higher.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration graceful_decommission_timeout = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getGracefulDecommissionTimeoutOrBuilder() {
    return gracefulDecommissionTimeout_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : gracefulDecommissionTimeout_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (size_ != 0) {
      output.writeInt32(2, size_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, requestId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getGracefulDecommissionTimeout());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (size_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, size_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, requestId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, getGracefulDecommissionTimeout());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.ResizeNodeGroupRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.ResizeNodeGroupRequest other =
        (com.google.cloud.dataproc.v1.ResizeNodeGroupRequest) obj;

    if (!getName().equals(other.getName())) return false;
    if (getSize() != other.getSize()) return false;
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (hasGracefulDecommissionTimeout() != other.hasGracefulDecommissionTimeout()) return false;
    if (hasGracefulDecommissionTimeout()) {
      if (!getGracefulDecommissionTimeout().equals(other.getGracefulDecommissionTimeout()))
        return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getSize();
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    if (hasGracefulDecommissionTimeout()) {
      hash = (37 * hash) + GRACEFUL_DECOMMISSION_TIMEOUT_FIELD_NUMBER;
      hash = (53 * hash) + getGracefulDecommissionTimeout().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.ResizeNodeGroupRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.ResizeNodeGroupRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.ResizeNodeGroupRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.ResizeNodeGroupRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.ResizeNodeGroupRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.ResizeNodeGroupRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.ResizeNodeGroupRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.ResizeNodeGroupRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.ResizeNodeGroupRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.ResizeNodeGroupRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.ResizeNodeGroupRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.ResizeNodeGroupRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.ResizeNodeGroupRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A request to resize a node group.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.ResizeNodeGroupRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.ResizeNodeGroupRequest)
      com.google.cloud.dataproc.v1.ResizeNodeGroupRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.NodeGroupsProto
          .internal_static_google_cloud_dataproc_v1_ResizeNodeGroupRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.NodeGroupsProto
          .internal_static_google_cloud_dataproc_v1_ResizeNodeGroupRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.ResizeNodeGroupRequest.class,
              com.google.cloud.dataproc.v1.ResizeNodeGroupRequest.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.ResizeNodeGroupRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getGracefulDecommissionTimeoutFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      size_ = 0;
      requestId_ = "";
      gracefulDecommissionTimeout_ = null;
      if (gracefulDecommissionTimeoutBuilder_ != null) {
        gracefulDecommissionTimeoutBuilder_.dispose();
        gracefulDecommissionTimeoutBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.NodeGroupsProto
          .internal_static_google_cloud_dataproc_v1_ResizeNodeGroupRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.ResizeNodeGroupRequest getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.ResizeNodeGroupRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.ResizeNodeGroupRequest build() {
      com.google.cloud.dataproc.v1.ResizeNodeGroupRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.ResizeNodeGroupRequest buildPartial() {
      com.google.cloud.dataproc.v1.ResizeNodeGroupRequest result =
          new com.google.cloud.dataproc.v1.ResizeNodeGroupRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.ResizeNodeGroupRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.size_ = size_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.requestId_ = requestId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.gracefulDecommissionTimeout_ =
            gracefulDecommissionTimeoutBuilder_ == null
                ? gracefulDecommissionTimeout_
                : gracefulDecommissionTimeoutBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.ResizeNodeGroupRequest) {
        return mergeFrom((com.google.cloud.dataproc.v1.ResizeNodeGroupRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.ResizeNodeGroupRequest other) {
      if (other == com.google.cloud.dataproc.v1.ResizeNodeGroupRequest.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getSize() != 0) {
        setSize(other.getSize());
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasGracefulDecommissionTimeout()) {
        mergeGracefulDecommissionTimeout(other.getGracefulDecommissionTimeout());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                size_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getGracefulDecommissionTimeoutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the node group to resize.
     * Format:
     * `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{nodeGroup}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the node group to resize.
     * Format:
     * `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{nodeGroup}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the node group to resize.
     * Format:
     * `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{nodeGroup}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the node group to resize.
     * Format:
     * `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{nodeGroup}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the node group to resize.
     * Format:
     * `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{nodeGroup}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int size_;
    /**
     *
     *
     * <pre>
     * Required. The number of running instances for the node group to maintain.
     * The group adds or removes instances to maintain the number of instances
     * specified by this parameter.
     * </pre>
     *
     * <code>int32 size = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The size.
     */
    @java.lang.Override
    public int getSize() {
      return size_;
    }
    /**
     *
     *
     * <pre>
     * Required. The number of running instances for the node group to maintain.
     * The group adds or removes instances to maintain the number of instances
     * specified by this parameter.
     * </pre>
     *
     * <code>int32 size = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The size to set.
     * @return This builder for chaining.
     */
    public Builder setSize(int value) {

      size_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The number of running instances for the node group to maintain.
     * The group adds or removes instances to maintain the number of instances
     * specified by this parameter.
     * </pre>
     *
     * <code>int32 size = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSize() {
      bitField0_ = (bitField0_ & ~0x00000002);
      size_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A unique ID used to identify the request. If the server receives
     * two
     * [ResizeNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.ResizeNodeGroupRequests)
     * with the same ID, the second request is ignored and the
     * first [google.longrunning.Operation][google.longrunning.Operation] created
     * and stored in the backend is returned.
     *
     * Recommendation: Set this value to a
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). The maximum length is 40 characters.
     * </pre>
     *
     * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique ID used to identify the request. If the server receives
     * two
     * [ResizeNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.ResizeNodeGroupRequests)
     * with the same ID, the second request is ignored and the
     * first [google.longrunning.Operation][google.longrunning.Operation] created
     * and stored in the backend is returned.
     *
     * Recommendation: Set this value to a
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). The maximum length is 40 characters.
     * </pre>
     *
     * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique ID used to identify the request. If the server receives
     * two
     * [ResizeNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.ResizeNodeGroupRequests)
     * with the same ID, the second request is ignored and the
     * first [google.longrunning.Operation][google.longrunning.Operation] created
     * and stored in the backend is returned.
     *
     * Recommendation: Set this value to a
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). The maximum length is 40 characters.
     * </pre>
     *
     * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique ID used to identify the request. If the server receives
     * two
     * [ResizeNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.ResizeNodeGroupRequests)
     * with the same ID, the second request is ignored and the
     * first [google.longrunning.Operation][google.longrunning.Operation] created
     * and stored in the backend is returned.
     *
     * Recommendation: Set this value to a
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). The maximum length is 40 characters.
     * </pre>
     *
     * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique ID used to identify the request. If the server receives
     * two
     * [ResizeNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.ResizeNodeGroupRequests)
     * with the same ID, the second request is ignored and the
     * first [google.longrunning.Operation][google.longrunning.Operation] created
     * and stored in the backend is returned.
     *
     * Recommendation: Set this value to a
     * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9),
     * underscores (_), and hyphens (-). The maximum length is 40 characters.
     * </pre>
     *
     * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration gracefulDecommissionTimeout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        gracefulDecommissionTimeoutBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Timeout for graceful YARN decommissioning. [Graceful
     * decommissioning]
     * (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
     * allows the removal of nodes from the Compute Engine node group
     * without interrupting jobs in progress. This timeout specifies how long to
     * wait for jobs in progress to finish before forcefully removing nodes (and
     * potentially interrupting jobs). Default timeout is 0 (for forceful
     * decommission), and the maximum allowed timeout is 1 day. (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Only supported on Dataproc image versions 1.2 and higher.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration graceful_decommission_timeout = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the gracefulDecommissionTimeout field is set.
     */
    public boolean hasGracefulDecommissionTimeout() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout for graceful YARN decommissioning. [Graceful
     * decommissioning]
     * (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
     * allows the removal of nodes from the Compute Engine node group
     * without interrupting jobs in progress. This timeout specifies how long to
     * wait for jobs in progress to finish before forcefully removing nodes (and
     * potentially interrupting jobs). Default timeout is 0 (for forceful
     * decommission), and the maximum allowed timeout is 1 day. (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Only supported on Dataproc image versions 1.2 and higher.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration graceful_decommission_timeout = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The gracefulDecommissionTimeout.
     */
    public com.google.protobuf.Duration getGracefulDecommissionTimeout() {
      if (gracefulDecommissionTimeoutBuilder_ == null) {
        return gracefulDecommissionTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : gracefulDecommissionTimeout_;
      } else {
        return gracefulDecommissionTimeoutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout for graceful YARN decommissioning. [Graceful
     * decommissioning]
     * (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
     * allows the removal of nodes from the Compute Engine node group
     * without interrupting jobs in progress. This timeout specifies how long to
     * wait for jobs in progress to finish before forcefully removing nodes (and
     * potentially interrupting jobs). Default timeout is 0 (for forceful
     * decommission), and the maximum allowed timeout is 1 day. (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Only supported on Dataproc image versions 1.2 and higher.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration graceful_decommission_timeout = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGracefulDecommissionTimeout(com.google.protobuf.Duration value) {
      if (gracefulDecommissionTimeoutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        gracefulDecommissionTimeout_ = value;
      } else {
        gracefulDecommissionTimeoutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout for graceful YARN decommissioning. [Graceful
     * decommissioning]
     * (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
     * allows the removal of nodes from the Compute Engine node group
     * without interrupting jobs in progress. This timeout specifies how long to
     * wait for jobs in progress to finish before forcefully removing nodes (and
     * potentially interrupting jobs). Default timeout is 0 (for forceful
     * decommission), and the maximum allowed timeout is 1 day. (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Only supported on Dataproc image versions 1.2 and higher.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration graceful_decommission_timeout = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGracefulDecommissionTimeout(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (gracefulDecommissionTimeoutBuilder_ == null) {
        gracefulDecommissionTimeout_ = builderForValue.build();
      } else {
        gracefulDecommissionTimeoutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout for graceful YARN decommissioning. [Graceful
     * decommissioning]
     * (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
     * allows the removal of nodes from the Compute Engine node group
     * without interrupting jobs in progress. This timeout specifies how long to
     * wait for jobs in progress to finish before forcefully removing nodes (and
     * potentially interrupting jobs). Default timeout is 0 (for forceful
     * decommission), and the maximum allowed timeout is 1 day. (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Only supported on Dataproc image versions 1.2 and higher.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration graceful_decommission_timeout = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGracefulDecommissionTimeout(com.google.protobuf.Duration value) {
      if (gracefulDecommissionTimeoutBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && gracefulDecommissionTimeout_ != null
            && gracefulDecommissionTimeout_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getGracefulDecommissionTimeoutBuilder().mergeFrom(value);
        } else {
          gracefulDecommissionTimeout_ = value;
        }
      } else {
        gracefulDecommissionTimeoutBuilder_.mergeFrom(value);
      }
      if (gracefulDecommissionTimeout_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout for graceful YARN decommissioning. [Graceful
     * decommissioning]
     * (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
     * allows the removal of nodes from the Compute Engine node group
     * without interrupting jobs in progress. This timeout specifies how long to
     * wait for jobs in progress to finish before forcefully removing nodes (and
     * potentially interrupting jobs). Default timeout is 0 (for forceful
     * decommission), and the maximum allowed timeout is 1 day. (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Only supported on Dataproc image versions 1.2 and higher.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration graceful_decommission_timeout = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGracefulDecommissionTimeout() {
      bitField0_ = (bitField0_ & ~0x00000008);
      gracefulDecommissionTimeout_ = null;
      if (gracefulDecommissionTimeoutBuilder_ != null) {
        gracefulDecommissionTimeoutBuilder_.dispose();
        gracefulDecommissionTimeoutBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout for graceful YARN decommissioning. [Graceful
     * decommissioning]
     * (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
     * allows the removal of nodes from the Compute Engine node group
     * without interrupting jobs in progress. This timeout specifies how long to
     * wait for jobs in progress to finish before forcefully removing nodes (and
     * potentially interrupting jobs). Default timeout is 0 (for forceful
     * decommission), and the maximum allowed timeout is 1 day. (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Only supported on Dataproc image versions 1.2 and higher.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration graceful_decommission_timeout = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getGracefulDecommissionTimeoutBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getGracefulDecommissionTimeoutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout for graceful YARN decommissioning. [Graceful
     * decommissioning]
     * (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
     * allows the removal of nodes from the Compute Engine node group
     * without interrupting jobs in progress. This timeout specifies how long to
     * wait for jobs in progress to finish before forcefully removing nodes (and
     * potentially interrupting jobs). Default timeout is 0 (for forceful
     * decommission), and the maximum allowed timeout is 1 day. (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Only supported on Dataproc image versions 1.2 and higher.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration graceful_decommission_timeout = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getGracefulDecommissionTimeoutOrBuilder() {
      if (gracefulDecommissionTimeoutBuilder_ != null) {
        return gracefulDecommissionTimeoutBuilder_.getMessageOrBuilder();
      } else {
        return gracefulDecommissionTimeout_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : gracefulDecommissionTimeout_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Timeout for graceful YARN decommissioning. [Graceful
     * decommissioning]
     * (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
     * allows the removal of nodes from the Compute Engine node group
     * without interrupting jobs in progress. This timeout specifies how long to
     * wait for jobs in progress to finish before forcefully removing nodes (and
     * potentially interrupting jobs). Default timeout is 0 (for forceful
     * decommission), and the maximum allowed timeout is 1 day. (see JSON
     * representation of
     * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
     *
     * Only supported on Dataproc image versions 1.2 and higher.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration graceful_decommission_timeout = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getGracefulDecommissionTimeoutFieldBuilder() {
      if (gracefulDecommissionTimeoutBuilder_ == null) {
        gracefulDecommissionTimeoutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getGracefulDecommissionTimeout(), getParentForChildren(), isClean());
        gracefulDecommissionTimeout_ = null;
      }
      return gracefulDecommissionTimeoutBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.ResizeNodeGroupRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.ResizeNodeGroupRequest)
  private static final com.google.cloud.dataproc.v1.ResizeNodeGroupRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.ResizeNodeGroupRequest();
  }

  public static com.google.cloud.dataproc.v1.ResizeNodeGroupRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ResizeNodeGroupRequest> PARSER =
      new com.google.protobuf.AbstractParser<ResizeNodeGroupRequest>() {
        @java.lang.Override
        public ResizeNodeGroupRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ResizeNodeGroupRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResizeNodeGroupRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.ResizeNodeGroupRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
