/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/node_groups.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dataproc.v1;

public interface ResizeNodeGroupRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.ResizeNodeGroupRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The name of the node group to resize.
   * Format:
   * `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{nodeGroup}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Required. The name of the node group to resize.
   * Format:
   * `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{nodeGroup}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The number of running instances for the node group to maintain.
   * The group adds or removes instances to maintain the number of instances
   * specified by this parameter.
   * </pre>
   *
   * <code>int32 size = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The size.
   */
  int getSize();

  /**
   *
   *
   * <pre>
   * Optional. A unique ID used to identify the request. If the server receives
   * two
   * [ResizeNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.ResizeNodeGroupRequests)
   * with the same ID, the second request is ignored and the
   * first [google.longrunning.Operation][google.longrunning.Operation] created
   * and stored in the backend is returned.
   *
   * Recommendation: Set this value to a
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
   *
   * The ID must contain only letters (a-z, A-Z), numbers (0-9),
   * underscores (_), and hyphens (-). The maximum length is 40 characters.
   * </pre>
   *
   * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  java.lang.String getRequestId();
  /**
   *
   *
   * <pre>
   * Optional. A unique ID used to identify the request. If the server receives
   * two
   * [ResizeNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.ResizeNodeGroupRequests)
   * with the same ID, the second request is ignored and the
   * first [google.longrunning.Operation][google.longrunning.Operation] created
   * and stored in the backend is returned.
   *
   * Recommendation: Set this value to a
   * [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
   *
   * The ID must contain only letters (a-z, A-Z), numbers (0-9),
   * underscores (_), and hyphens (-). The maximum length is 40 characters.
   * </pre>
   *
   * <code>string request_id = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  com.google.protobuf.ByteString getRequestIdBytes();

  /**
   *
   *
   * <pre>
   * Optional. Timeout for graceful YARN decommissioning. [Graceful
   * decommissioning]
   * (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
   * allows the removal of nodes from the Compute Engine node group
   * without interrupting jobs in progress. This timeout specifies how long to
   * wait for jobs in progress to finish before forcefully removing nodes (and
   * potentially interrupting jobs). Default timeout is 0 (for forceful
   * decommission), and the maximum allowed timeout is 1 day. (see JSON
   * representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   *
   * Only supported on Dataproc image versions 1.2 and higher.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration graceful_decommission_timeout = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the gracefulDecommissionTimeout field is set.
   */
  boolean hasGracefulDecommissionTimeout();
  /**
   *
   *
   * <pre>
   * Optional. Timeout for graceful YARN decommissioning. [Graceful
   * decommissioning]
   * (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
   * allows the removal of nodes from the Compute Engine node group
   * without interrupting jobs in progress. This timeout specifies how long to
   * wait for jobs in progress to finish before forcefully removing nodes (and
   * potentially interrupting jobs). Default timeout is 0 (for forceful
   * decommission), and the maximum allowed timeout is 1 day. (see JSON
   * representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   *
   * Only supported on Dataproc image versions 1.2 and higher.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration graceful_decommission_timeout = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The gracefulDecommissionTimeout.
   */
  com.google.protobuf.Duration getGracefulDecommissionTimeout();
  /**
   *
   *
   * <pre>
   * Optional. Timeout for graceful YARN decommissioning. [Graceful
   * decommissioning]
   * (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
   * allows the removal of nodes from the Compute Engine node group
   * without interrupting jobs in progress. This timeout specifies how long to
   * wait for jobs in progress to finish before forcefully removing nodes (and
   * potentially interrupting jobs). Default timeout is 0 (for forceful
   * decommission), and the maximum allowed timeout is 1 day. (see JSON
   * representation of
   * [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
   *
   * Only supported on Dataproc image versions 1.2 and higher.
   * </pre>
   *
   * <code>
   * .google.protobuf.Duration graceful_decommission_timeout = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.protobuf.DurationOrBuilder getGracefulDecommissionTimeoutOrBuilder();
}
