/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/shared.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * Runtime configuration for a workload.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.RuntimeConfig}
 */
public final class RuntimeConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.RuntimeConfig)
    RuntimeConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RuntimeConfig.newBuilder() to construct.
  private RuntimeConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RuntimeConfig() {
    version_ = "";
    containerImage_ = "";
    cohort_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RuntimeConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.SharedProto
        .internal_static_google_cloud_dataproc_v1_RuntimeConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 3:
        return internalGetProperties();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.SharedProto
        .internal_static_google_cloud_dataproc_v1_RuntimeConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.RuntimeConfig.class,
            com.google.cloud.dataproc.v1.RuntimeConfig.Builder.class);
  }

  private int bitField0_;
  public static final int VERSION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object version_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Version of the batch runtime.
   * </pre>
   *
   * <code>string version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public java.lang.String getVersion() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      version_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Version of the batch runtime.
   * </pre>
   *
   * <code>string version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for version.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionBytes() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      version_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTAINER_IMAGE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object containerImage_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Optional custom container image for the job runtime environment.
   * If not specified, a default container image will be used.
   * </pre>
   *
   * <code>string container_image = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The containerImage.
   */
  @java.lang.Override
  public java.lang.String getContainerImage() {
    java.lang.Object ref = containerImage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      containerImage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Optional custom container image for the job runtime environment.
   * If not specified, a default container image will be used.
   * </pre>
   *
   * <code>string container_image = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for containerImage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContainerImageBytes() {
    java.lang.Object ref = containerImage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      containerImage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROPERTIES_FIELD_NUMBER = 3;

  private static final class PropertiesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataproc.v1.SharedProto
                .internal_static_google_cloud_dataproc_v1_RuntimeConfig_PropertiesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> properties_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetProperties() {
    if (properties_ == null) {
      return com.google.protobuf.MapField.emptyMapField(PropertiesDefaultEntryHolder.defaultEntry);
    }
    return properties_;
  }

  public int getPropertiesCount() {
    return internalGetProperties().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A mapping of property names to values, which are used to
   * configure workload execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsProperties(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetProperties().getMap().containsKey(key);
  }
  /** Use {@link #getPropertiesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getProperties() {
    return getPropertiesMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. A mapping of property names to values, which are used to
   * configure workload execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getPropertiesMap() {
    return internalGetProperties().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. A mapping of property names to values, which are used to
   * configure workload execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getPropertiesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetProperties().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. A mapping of property names to values, which are used to
   * configure workload execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getPropertiesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetProperties().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int REPOSITORY_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.dataproc.v1.RepositoryConfig repositoryConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Dependency repository configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.RepositoryConfig repository_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the repositoryConfig field is set.
   */
  @java.lang.Override
  public boolean hasRepositoryConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Dependency repository configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.RepositoryConfig repository_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The repositoryConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.RepositoryConfig getRepositoryConfig() {
    return repositoryConfig_ == null
        ? com.google.cloud.dataproc.v1.RepositoryConfig.getDefaultInstance()
        : repositoryConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Dependency repository configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.RepositoryConfig repository_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.RepositoryConfigOrBuilder getRepositoryConfigOrBuilder() {
    return repositoryConfig_ == null
        ? com.google.cloud.dataproc.v1.RepositoryConfig.getDefaultInstance()
        : repositoryConfig_;
  }

  public static final int AUTOTUNING_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.dataproc.v1.AutotuningConfig autotuningConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Autotuning configuration of the workload.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.AutotuningConfig autotuning_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the autotuningConfig field is set.
   */
  @java.lang.Override
  public boolean hasAutotuningConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Autotuning configuration of the workload.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.AutotuningConfig autotuning_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The autotuningConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.AutotuningConfig getAutotuningConfig() {
    return autotuningConfig_ == null
        ? com.google.cloud.dataproc.v1.AutotuningConfig.getDefaultInstance()
        : autotuningConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Autotuning configuration of the workload.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.AutotuningConfig autotuning_config = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.AutotuningConfigOrBuilder getAutotuningConfigOrBuilder() {
    return autotuningConfig_ == null
        ? com.google.cloud.dataproc.v1.AutotuningConfig.getDefaultInstance()
        : autotuningConfig_;
  }

  public static final int COHORT_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object cohort_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Cohort identifier. Identifies families of the workloads having
   * the same shape, e.g. daily ETL jobs.
   * </pre>
   *
   * <code>string cohort = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The cohort.
   */
  @java.lang.Override
  public java.lang.String getCohort() {
    java.lang.Object ref = cohort_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      cohort_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Cohort identifier. Identifies families of the workloads having
   * the same shape, e.g. daily ETL jobs.
   * </pre>
   *
   * <code>string cohort = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for cohort.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCohortBytes() {
    java.lang.Object ref = cohort_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      cohort_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, version_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(containerImage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, containerImage_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetProperties(), PropertiesDefaultEntryHolder.defaultEntry, 3);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getRepositoryConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getAutotuningConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cohort_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, cohort_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, version_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(containerImage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, containerImage_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetProperties().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> properties__ =
          PropertiesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, properties__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getRepositoryConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getAutotuningConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(cohort_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, cohort_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.RuntimeConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.RuntimeConfig other =
        (com.google.cloud.dataproc.v1.RuntimeConfig) obj;

    if (!getVersion().equals(other.getVersion())) return false;
    if (!getContainerImage().equals(other.getContainerImage())) return false;
    if (!internalGetProperties().equals(other.internalGetProperties())) return false;
    if (hasRepositoryConfig() != other.hasRepositoryConfig()) return false;
    if (hasRepositoryConfig()) {
      if (!getRepositoryConfig().equals(other.getRepositoryConfig())) return false;
    }
    if (hasAutotuningConfig() != other.hasAutotuningConfig()) return false;
    if (hasAutotuningConfig()) {
      if (!getAutotuningConfig().equals(other.getAutotuningConfig())) return false;
    }
    if (!getCohort().equals(other.getCohort())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion().hashCode();
    hash = (37 * hash) + CONTAINER_IMAGE_FIELD_NUMBER;
    hash = (53 * hash) + getContainerImage().hashCode();
    if (!internalGetProperties().getMap().isEmpty()) {
      hash = (37 * hash) + PROPERTIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetProperties().hashCode();
    }
    if (hasRepositoryConfig()) {
      hash = (37 * hash) + REPOSITORY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRepositoryConfig().hashCode();
    }
    if (hasAutotuningConfig()) {
      hash = (37 * hash) + AUTOTUNING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAutotuningConfig().hashCode();
    }
    hash = (37 * hash) + COHORT_FIELD_NUMBER;
    hash = (53 * hash) + getCohort().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.RuntimeConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.RuntimeConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.RuntimeConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.RuntimeConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.RuntimeConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.RuntimeConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.RuntimeConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.RuntimeConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.RuntimeConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.RuntimeConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.RuntimeConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.RuntimeConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.RuntimeConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Runtime configuration for a workload.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.RuntimeConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.RuntimeConfig)
      com.google.cloud.dataproc.v1.RuntimeConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_RuntimeConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetProperties();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMutableProperties();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_RuntimeConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.RuntimeConfig.class,
              com.google.cloud.dataproc.v1.RuntimeConfig.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.RuntimeConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRepositoryConfigFieldBuilder();
        getAutotuningConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      version_ = "";
      containerImage_ = "";
      internalGetMutableProperties().clear();
      repositoryConfig_ = null;
      if (repositoryConfigBuilder_ != null) {
        repositoryConfigBuilder_.dispose();
        repositoryConfigBuilder_ = null;
      }
      autotuningConfig_ = null;
      if (autotuningConfigBuilder_ != null) {
        autotuningConfigBuilder_.dispose();
        autotuningConfigBuilder_ = null;
      }
      cohort_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_RuntimeConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.RuntimeConfig getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.RuntimeConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.RuntimeConfig build() {
      com.google.cloud.dataproc.v1.RuntimeConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.RuntimeConfig buildPartial() {
      com.google.cloud.dataproc.v1.RuntimeConfig result =
          new com.google.cloud.dataproc.v1.RuntimeConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.RuntimeConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.version_ = version_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.containerImage_ = containerImage_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.properties_ = internalGetProperties();
        result.properties_.makeImmutable();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.repositoryConfig_ =
            repositoryConfigBuilder_ == null ? repositoryConfig_ : repositoryConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.autotuningConfig_ =
            autotuningConfigBuilder_ == null ? autotuningConfig_ : autotuningConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.cohort_ = cohort_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.RuntimeConfig) {
        return mergeFrom((com.google.cloud.dataproc.v1.RuntimeConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.RuntimeConfig other) {
      if (other == com.google.cloud.dataproc.v1.RuntimeConfig.getDefaultInstance()) return this;
      if (!other.getVersion().isEmpty()) {
        version_ = other.version_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getContainerImage().isEmpty()) {
        containerImage_ = other.containerImage_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      internalGetMutableProperties().mergeFrom(other.internalGetProperties());
      bitField0_ |= 0x00000004;
      if (other.hasRepositoryConfig()) {
        mergeRepositoryConfig(other.getRepositoryConfig());
      }
      if (other.hasAutotuningConfig()) {
        mergeAutotuningConfig(other.getAutotuningConfig());
      }
      if (!other.getCohort().isEmpty()) {
        cohort_ = other.cohort_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                version_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                containerImage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> properties__ =
                    input.readMessage(
                        PropertiesDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableProperties()
                    .getMutableMap()
                    .put(properties__.getKey(), properties__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(
                    getRepositoryConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getAutotuningConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 58:
              {
                cohort_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Version of the batch runtime.
     * </pre>
     *
     * <code>string version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The version.
     */
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Version of the batch runtime.
     * </pre>
     *
     * <code>string version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for version.
     */
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Version of the batch runtime.
     * </pre>
     *
     * <code>string version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      version_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Version of the batch runtime.
     * </pre>
     *
     * <code>string version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {
      version_ = getDefaultInstance().getVersion();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Version of the batch runtime.
     * </pre>
     *
     * <code>string version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for version to set.
     * @return This builder for chaining.
     */
    public Builder setVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      version_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object containerImage_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Optional custom container image for the job runtime environment.
     * If not specified, a default container image will be used.
     * </pre>
     *
     * <code>string container_image = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The containerImage.
     */
    public java.lang.String getContainerImage() {
      java.lang.Object ref = containerImage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        containerImage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional custom container image for the job runtime environment.
     * If not specified, a default container image will be used.
     * </pre>
     *
     * <code>string container_image = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for containerImage.
     */
    public com.google.protobuf.ByteString getContainerImageBytes() {
      java.lang.Object ref = containerImage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        containerImage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional custom container image for the job runtime environment.
     * If not specified, a default container image will be used.
     * </pre>
     *
     * <code>string container_image = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The containerImage to set.
     * @return This builder for chaining.
     */
    public Builder setContainerImage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      containerImage_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional custom container image for the job runtime environment.
     * If not specified, a default container image will be used.
     * </pre>
     *
     * <code>string container_image = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContainerImage() {
      containerImage_ = getDefaultInstance().getContainerImage();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional custom container image for the job runtime environment.
     * If not specified, a default container image will be used.
     * </pre>
     *
     * <code>string container_image = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for containerImage to set.
     * @return This builder for chaining.
     */
    public Builder setContainerImageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      containerImage_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> properties_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetProperties() {
      if (properties_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            PropertiesDefaultEntryHolder.defaultEntry);
      }
      return properties_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableProperties() {
      if (properties_ == null) {
        properties_ =
            com.google.protobuf.MapField.newMapField(PropertiesDefaultEntryHolder.defaultEntry);
      }
      if (!properties_.isMutable()) {
        properties_ = properties_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return properties_;
    }

    public int getPropertiesCount() {
      return internalGetProperties().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values, which are used to
     * configure workload execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsProperties(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetProperties().getMap().containsKey(key);
    }
    /** Use {@link #getPropertiesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getProperties() {
      return getPropertiesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values, which are used to
     * configure workload execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getPropertiesMap() {
      return internalGetProperties().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values, which are used to
     * configure workload execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getPropertiesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetProperties().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values, which are used to
     * configure workload execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getPropertiesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetProperties().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearProperties() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableProperties().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values, which are used to
     * configure workload execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeProperties(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableProperties().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableProperties() {
      bitField0_ |= 0x00000004;
      return internalGetMutableProperties().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values, which are used to
     * configure workload execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putProperties(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableProperties().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A mapping of property names to values, which are used to
     * configure workload execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; properties = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllProperties(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableProperties().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    private com.google.cloud.dataproc.v1.RepositoryConfig repositoryConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.RepositoryConfig,
            com.google.cloud.dataproc.v1.RepositoryConfig.Builder,
            com.google.cloud.dataproc.v1.RepositoryConfigOrBuilder>
        repositoryConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Dependency repository configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RepositoryConfig repository_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the repositoryConfig field is set.
     */
    public boolean hasRepositoryConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Dependency repository configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RepositoryConfig repository_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The repositoryConfig.
     */
    public com.google.cloud.dataproc.v1.RepositoryConfig getRepositoryConfig() {
      if (repositoryConfigBuilder_ == null) {
        return repositoryConfig_ == null
            ? com.google.cloud.dataproc.v1.RepositoryConfig.getDefaultInstance()
            : repositoryConfig_;
      } else {
        return repositoryConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Dependency repository configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RepositoryConfig repository_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRepositoryConfig(com.google.cloud.dataproc.v1.RepositoryConfig value) {
      if (repositoryConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        repositoryConfig_ = value;
      } else {
        repositoryConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Dependency repository configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RepositoryConfig repository_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRepositoryConfig(
        com.google.cloud.dataproc.v1.RepositoryConfig.Builder builderForValue) {
      if (repositoryConfigBuilder_ == null) {
        repositoryConfig_ = builderForValue.build();
      } else {
        repositoryConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Dependency repository configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RepositoryConfig repository_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRepositoryConfig(com.google.cloud.dataproc.v1.RepositoryConfig value) {
      if (repositoryConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && repositoryConfig_ != null
            && repositoryConfig_
                != com.google.cloud.dataproc.v1.RepositoryConfig.getDefaultInstance()) {
          getRepositoryConfigBuilder().mergeFrom(value);
        } else {
          repositoryConfig_ = value;
        }
      } else {
        repositoryConfigBuilder_.mergeFrom(value);
      }
      if (repositoryConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Dependency repository configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RepositoryConfig repository_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRepositoryConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      repositoryConfig_ = null;
      if (repositoryConfigBuilder_ != null) {
        repositoryConfigBuilder_.dispose();
        repositoryConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Dependency repository configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RepositoryConfig repository_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.RepositoryConfig.Builder getRepositoryConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRepositoryConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Dependency repository configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RepositoryConfig repository_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.RepositoryConfigOrBuilder getRepositoryConfigOrBuilder() {
      if (repositoryConfigBuilder_ != null) {
        return repositoryConfigBuilder_.getMessageOrBuilder();
      } else {
        return repositoryConfig_ == null
            ? com.google.cloud.dataproc.v1.RepositoryConfig.getDefaultInstance()
            : repositoryConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Dependency repository configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RepositoryConfig repository_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.RepositoryConfig,
            com.google.cloud.dataproc.v1.RepositoryConfig.Builder,
            com.google.cloud.dataproc.v1.RepositoryConfigOrBuilder>
        getRepositoryConfigFieldBuilder() {
      if (repositoryConfigBuilder_ == null) {
        repositoryConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.RepositoryConfig,
                com.google.cloud.dataproc.v1.RepositoryConfig.Builder,
                com.google.cloud.dataproc.v1.RepositoryConfigOrBuilder>(
                getRepositoryConfig(), getParentForChildren(), isClean());
        repositoryConfig_ = null;
      }
      return repositoryConfigBuilder_;
    }

    private com.google.cloud.dataproc.v1.AutotuningConfig autotuningConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.AutotuningConfig,
            com.google.cloud.dataproc.v1.AutotuningConfig.Builder,
            com.google.cloud.dataproc.v1.AutotuningConfigOrBuilder>
        autotuningConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Autotuning configuration of the workload.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.AutotuningConfig autotuning_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the autotuningConfig field is set.
     */
    public boolean hasAutotuningConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Autotuning configuration of the workload.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.AutotuningConfig autotuning_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The autotuningConfig.
     */
    public com.google.cloud.dataproc.v1.AutotuningConfig getAutotuningConfig() {
      if (autotuningConfigBuilder_ == null) {
        return autotuningConfig_ == null
            ? com.google.cloud.dataproc.v1.AutotuningConfig.getDefaultInstance()
            : autotuningConfig_;
      } else {
        return autotuningConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Autotuning configuration of the workload.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.AutotuningConfig autotuning_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutotuningConfig(com.google.cloud.dataproc.v1.AutotuningConfig value) {
      if (autotuningConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autotuningConfig_ = value;
      } else {
        autotuningConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Autotuning configuration of the workload.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.AutotuningConfig autotuning_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAutotuningConfig(
        com.google.cloud.dataproc.v1.AutotuningConfig.Builder builderForValue) {
      if (autotuningConfigBuilder_ == null) {
        autotuningConfig_ = builderForValue.build();
      } else {
        autotuningConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Autotuning configuration of the workload.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.AutotuningConfig autotuning_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeAutotuningConfig(com.google.cloud.dataproc.v1.AutotuningConfig value) {
      if (autotuningConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && autotuningConfig_ != null
            && autotuningConfig_
                != com.google.cloud.dataproc.v1.AutotuningConfig.getDefaultInstance()) {
          getAutotuningConfigBuilder().mergeFrom(value);
        } else {
          autotuningConfig_ = value;
        }
      } else {
        autotuningConfigBuilder_.mergeFrom(value);
      }
      if (autotuningConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Autotuning configuration of the workload.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.AutotuningConfig autotuning_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAutotuningConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      autotuningConfig_ = null;
      if (autotuningConfigBuilder_ != null) {
        autotuningConfigBuilder_.dispose();
        autotuningConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Autotuning configuration of the workload.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.AutotuningConfig autotuning_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.AutotuningConfig.Builder getAutotuningConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getAutotuningConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Autotuning configuration of the workload.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.AutotuningConfig autotuning_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.AutotuningConfigOrBuilder getAutotuningConfigOrBuilder() {
      if (autotuningConfigBuilder_ != null) {
        return autotuningConfigBuilder_.getMessageOrBuilder();
      } else {
        return autotuningConfig_ == null
            ? com.google.cloud.dataproc.v1.AutotuningConfig.getDefaultInstance()
            : autotuningConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Autotuning configuration of the workload.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.AutotuningConfig autotuning_config = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.AutotuningConfig,
            com.google.cloud.dataproc.v1.AutotuningConfig.Builder,
            com.google.cloud.dataproc.v1.AutotuningConfigOrBuilder>
        getAutotuningConfigFieldBuilder() {
      if (autotuningConfigBuilder_ == null) {
        autotuningConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.AutotuningConfig,
                com.google.cloud.dataproc.v1.AutotuningConfig.Builder,
                com.google.cloud.dataproc.v1.AutotuningConfigOrBuilder>(
                getAutotuningConfig(), getParentForChildren(), isClean());
        autotuningConfig_ = null;
      }
      return autotuningConfigBuilder_;
    }

    private java.lang.Object cohort_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Cohort identifier. Identifies families of the workloads having
     * the same shape, e.g. daily ETL jobs.
     * </pre>
     *
     * <code>string cohort = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The cohort.
     */
    public java.lang.String getCohort() {
      java.lang.Object ref = cohort_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cohort_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Cohort identifier. Identifies families of the workloads having
     * the same shape, e.g. daily ETL jobs.
     * </pre>
     *
     * <code>string cohort = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for cohort.
     */
    public com.google.protobuf.ByteString getCohortBytes() {
      java.lang.Object ref = cohort_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cohort_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Cohort identifier. Identifies families of the workloads having
     * the same shape, e.g. daily ETL jobs.
     * </pre>
     *
     * <code>string cohort = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The cohort to set.
     * @return This builder for chaining.
     */
    public Builder setCohort(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      cohort_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Cohort identifier. Identifies families of the workloads having
     * the same shape, e.g. daily ETL jobs.
     * </pre>
     *
     * <code>string cohort = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCohort() {
      cohort_ = getDefaultInstance().getCohort();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Cohort identifier. Identifies families of the workloads having
     * the same shape, e.g. daily ETL jobs.
     * </pre>
     *
     * <code>string cohort = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for cohort to set.
     * @return This builder for chaining.
     */
    public Builder setCohortBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      cohort_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.RuntimeConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.RuntimeConfig)
  private static final com.google.cloud.dataproc.v1.RuntimeConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.RuntimeConfig();
  }

  public static com.google.cloud.dataproc.v1.RuntimeConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RuntimeConfig> PARSER =
      new com.google.protobuf.AbstractParser<RuntimeConfig>() {
        @java.lang.Override
        public RuntimeConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RuntimeConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RuntimeConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.RuntimeConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
