/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/sessions.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * A representation of a session.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.Session}
 */
public final class Session extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.Session)
    SessionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Session.newBuilder() to construct.
  private Session(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Session() {
    name_ = "";
    uuid_ = "";
    state_ = 0;
    stateMessage_ = "";
    creator_ = "";
    user_ = "";
    stateHistory_ = java.util.Collections.emptyList();
    sessionTemplate_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Session();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.SessionsProto
        .internal_static_google_cloud_dataproc_v1_Session_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 11:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.SessionsProto
        .internal_static_google_cloud_dataproc_v1_Session_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.Session.class,
            com.google.cloud.dataproc.v1.Session.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The session state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dataproc.v1.Session.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The session state is unknown.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The session is created prior to running.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    CREATING(1),
    /**
     *
     *
     * <pre>
     * The session is running.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    ACTIVE(2),
    /**
     *
     *
     * <pre>
     * The session is terminating.
     * </pre>
     *
     * <code>TERMINATING = 3;</code>
     */
    TERMINATING(3),
    /**
     *
     *
     * <pre>
     * The session is terminated successfully.
     * </pre>
     *
     * <code>TERMINATED = 4;</code>
     */
    TERMINATED(4),
    /**
     *
     *
     * <pre>
     * The session is no longer running due to an error.
     * </pre>
     *
     * <code>FAILED = 5;</code>
     */
    FAILED(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The session state is unknown.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The session is created prior to running.
     * </pre>
     *
     * <code>CREATING = 1;</code>
     */
    public static final int CREATING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The session is running.
     * </pre>
     *
     * <code>ACTIVE = 2;</code>
     */
    public static final int ACTIVE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The session is terminating.
     * </pre>
     *
     * <code>TERMINATING = 3;</code>
     */
    public static final int TERMINATING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The session is terminated successfully.
     * </pre>
     *
     * <code>TERMINATED = 4;</code>
     */
    public static final int TERMINATED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The session is no longer running due to an error.
     * </pre>
     *
     * <code>FAILED = 5;</code>
     */
    public static final int FAILED_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATING;
        case 2:
          return ACTIVE;
        case 3:
          return TERMINATING;
        case 4:
          return TERMINATED;
        case 5:
          return FAILED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.Session.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dataproc.v1.Session.State)
  }

  public interface SessionStateHistoryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.dataproc.v1.Session.SessionStateHistory)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The state of the session at this point in the session
     * history.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Session.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     *
     *
     * <pre>
     * Output only. The state of the session at this point in the session
     * history.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Session.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    com.google.cloud.dataproc.v1.Session.State getState();

    /**
     *
     *
     * <pre>
     * Output only. Details about the state at this point in the session
     * history.
     * </pre>
     *
     * <code>string state_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stateMessage.
     */
    java.lang.String getStateMessage();
    /**
     *
     *
     * <pre>
     * Output only. Details about the state at this point in the session
     * history.
     * </pre>
     *
     * <code>string state_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stateMessage.
     */
    com.google.protobuf.ByteString getStateMessageBytes();

    /**
     *
     *
     * <pre>
     * Output only. The time when the session entered the historical state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the stateStartTime field is set.
     */
    boolean hasStateStartTime();
    /**
     *
     *
     * <pre>
     * Output only. The time when the session entered the historical state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The stateStartTime.
     */
    com.google.protobuf.Timestamp getStateStartTime();
    /**
     *
     *
     * <pre>
     * Output only. The time when the session entered the historical state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.protobuf.TimestampOrBuilder getStateStartTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Historical state information.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.Session.SessionStateHistory}
   */
  public static final class SessionStateHistory extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.Session.SessionStateHistory)
      SessionStateHistoryOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SessionStateHistory.newBuilder() to construct.
    private SessionStateHistory(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SessionStateHistory() {
      state_ = 0;
      stateMessage_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SessionStateHistory();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.SessionsProto
          .internal_static_google_cloud_dataproc_v1_Session_SessionStateHistory_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.SessionsProto
          .internal_static_google_cloud_dataproc_v1_Session_SessionStateHistory_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.Session.SessionStateHistory.class,
              com.google.cloud.dataproc.v1.Session.SessionStateHistory.Builder.class);
    }

    private int bitField0_;
    public static final int STATE_FIELD_NUMBER = 1;
    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of the session at this point in the session
     * history.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Session.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the session at this point in the session
     * history.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Session.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.Session.State getState() {
      com.google.cloud.dataproc.v1.Session.State result =
          com.google.cloud.dataproc.v1.Session.State.forNumber(state_);
      return result == null ? com.google.cloud.dataproc.v1.Session.State.UNRECOGNIZED : result;
    }

    public static final int STATE_MESSAGE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object stateMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Details about the state at this point in the session
     * history.
     * </pre>
     *
     * <code>string state_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stateMessage.
     */
    @java.lang.Override
    public java.lang.String getStateMessage() {
      java.lang.Object ref = stateMessage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateMessage_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Details about the state at this point in the session
     * history.
     * </pre>
     *
     * <code>string state_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stateMessage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStateMessageBytes() {
      java.lang.Object ref = stateMessage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stateMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATE_START_TIME_FIELD_NUMBER = 3;
    private com.google.protobuf.Timestamp stateStartTime_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the session entered the historical state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the stateStartTime field is set.
     */
    @java.lang.Override
    public boolean hasStateStartTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the session entered the historical state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The stateStartTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getStateStartTime() {
      return stateStartTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : stateStartTime_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the session entered the historical state.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getStateStartTimeOrBuilder() {
      return stateStartTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : stateStartTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (state_ != com.google.cloud.dataproc.v1.Session.State.STATE_UNSPECIFIED.getNumber()) {
        output.writeEnum(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateMessage_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, stateMessage_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getStateStartTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (state_ != com.google.cloud.dataproc.v1.Session.State.STATE_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateMessage_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, stateMessage_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStateStartTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.dataproc.v1.Session.SessionStateHistory)) {
        return super.equals(obj);
      }
      com.google.cloud.dataproc.v1.Session.SessionStateHistory other =
          (com.google.cloud.dataproc.v1.Session.SessionStateHistory) obj;

      if (state_ != other.state_) return false;
      if (!getStateMessage().equals(other.getStateMessage())) return false;
      if (hasStateStartTime() != other.hasStateStartTime()) return false;
      if (hasStateStartTime()) {
        if (!getStateStartTime().equals(other.getStateStartTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      hash = (37 * hash) + STATE_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getStateMessage().hashCode();
      if (hasStateStartTime()) {
        hash = (37 * hash) + STATE_START_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getStateStartTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.dataproc.v1.Session.SessionStateHistory parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.Session.SessionStateHistory parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.Session.SessionStateHistory parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.Session.SessionStateHistory parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.Session.SessionStateHistory parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.dataproc.v1.Session.SessionStateHistory parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.Session.SessionStateHistory parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.Session.SessionStateHistory parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.Session.SessionStateHistory parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.Session.SessionStateHistory parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.dataproc.v1.Session.SessionStateHistory parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.dataproc.v1.Session.SessionStateHistory parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.dataproc.v1.Session.SessionStateHistory prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Historical state information.
     * </pre>
     *
     * Protobuf type {@code google.cloud.dataproc.v1.Session.SessionStateHistory}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.Session.SessionStateHistory)
        com.google.cloud.dataproc.v1.Session.SessionStateHistoryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.dataproc.v1.SessionsProto
            .internal_static_google_cloud_dataproc_v1_Session_SessionStateHistory_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.dataproc.v1.SessionsProto
            .internal_static_google_cloud_dataproc_v1_Session_SessionStateHistory_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.dataproc.v1.Session.SessionStateHistory.class,
                com.google.cloud.dataproc.v1.Session.SessionStateHistory.Builder.class);
      }

      // Construct using com.google.cloud.dataproc.v1.Session.SessionStateHistory.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getStateStartTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        state_ = 0;
        stateMessage_ = "";
        stateStartTime_ = null;
        if (stateStartTimeBuilder_ != null) {
          stateStartTimeBuilder_.dispose();
          stateStartTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.dataproc.v1.SessionsProto
            .internal_static_google_cloud_dataproc_v1_Session_SessionStateHistory_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.Session.SessionStateHistory getDefaultInstanceForType() {
        return com.google.cloud.dataproc.v1.Session.SessionStateHistory.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.Session.SessionStateHistory build() {
        com.google.cloud.dataproc.v1.Session.SessionStateHistory result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.dataproc.v1.Session.SessionStateHistory buildPartial() {
        com.google.cloud.dataproc.v1.Session.SessionStateHistory result =
            new com.google.cloud.dataproc.v1.Session.SessionStateHistory(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.dataproc.v1.Session.SessionStateHistory result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.state_ = state_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.stateMessage_ = stateMessage_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.stateStartTime_ =
              stateStartTimeBuilder_ == null ? stateStartTime_ : stateStartTimeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.dataproc.v1.Session.SessionStateHistory) {
          return mergeFrom((com.google.cloud.dataproc.v1.Session.SessionStateHistory) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.dataproc.v1.Session.SessionStateHistory other) {
        if (other == com.google.cloud.dataproc.v1.Session.SessionStateHistory.getDefaultInstance())
          return this;
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        if (!other.getStateMessage().isEmpty()) {
          stateMessage_ = other.stateMessage_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasStateStartTime()) {
          mergeStateStartTime(other.getStateStartTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  stateMessage_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getStateStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int state_ = 0;
      /**
       *
       *
       * <pre>
       * Output only. The state of the session at this point in the session
       * history.
       * </pre>
       *
       * <code>
       * .google.cloud.dataproc.v1.Session.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       *
       *
       * <pre>
       * Output only. The state of the session at this point in the session
       * history.
       * </pre>
       *
       * <code>
       * .google.cloud.dataproc.v1.Session.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The state of the session at this point in the session
       * history.
       * </pre>
       *
       * <code>
       * .google.cloud.dataproc.v1.Session.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.cloud.dataproc.v1.Session.State getState() {
        com.google.cloud.dataproc.v1.Session.State result =
            com.google.cloud.dataproc.v1.Session.State.forNumber(state_);
        return result == null ? com.google.cloud.dataproc.v1.Session.State.UNRECOGNIZED : result;
      }
      /**
       *
       *
       * <pre>
       * Output only. The state of the session at this point in the session
       * history.
       * </pre>
       *
       * <code>
       * .google.cloud.dataproc.v1.Session.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(com.google.cloud.dataproc.v1.Session.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The state of the session at this point in the session
       * history.
       * </pre>
       *
       * <code>
       * .google.cloud.dataproc.v1.Session.State state = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000001);
        state_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object stateMessage_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Details about the state at this point in the session
       * history.
       * </pre>
       *
       * <code>string state_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The stateMessage.
       */
      public java.lang.String getStateMessage() {
        java.lang.Object ref = stateMessage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          stateMessage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Details about the state at this point in the session
       * history.
       * </pre>
       *
       * <code>string state_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for stateMessage.
       */
      public com.google.protobuf.ByteString getStateMessageBytes() {
        java.lang.Object ref = stateMessage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          stateMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Details about the state at this point in the session
       * history.
       * </pre>
       *
       * <code>string state_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The stateMessage to set.
       * @return This builder for chaining.
       */
      public Builder setStateMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        stateMessage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Details about the state at this point in the session
       * history.
       * </pre>
       *
       * <code>string state_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStateMessage() {
        stateMessage_ = getDefaultInstance().getStateMessage();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Details about the state at this point in the session
       * history.
       * </pre>
       *
       * <code>string state_message = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for stateMessage to set.
       * @return This builder for chaining.
       */
      public Builder setStateMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        stateMessage_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp stateStartTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          stateStartTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. The time when the session entered the historical state.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the stateStartTime field is set.
       */
      public boolean hasStateStartTime() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when the session entered the historical state.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The stateStartTime.
       */
      public com.google.protobuf.Timestamp getStateStartTime() {
        if (stateStartTimeBuilder_ == null) {
          return stateStartTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : stateStartTime_;
        } else {
          return stateStartTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when the session entered the historical state.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setStateStartTime(com.google.protobuf.Timestamp value) {
        if (stateStartTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          stateStartTime_ = value;
        } else {
          stateStartTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when the session entered the historical state.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setStateStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (stateStartTimeBuilder_ == null) {
          stateStartTime_ = builderForValue.build();
        } else {
          stateStartTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when the session entered the historical state.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeStateStartTime(com.google.protobuf.Timestamp value) {
        if (stateStartTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && stateStartTime_ != null
              && stateStartTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getStateStartTimeBuilder().mergeFrom(value);
          } else {
            stateStartTime_ = value;
          }
        } else {
          stateStartTimeBuilder_.mergeFrom(value);
        }
        if (stateStartTime_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when the session entered the historical state.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearStateStartTime() {
        bitField0_ = (bitField0_ & ~0x00000004);
        stateStartTime_ = null;
        if (stateStartTimeBuilder_ != null) {
          stateStartTimeBuilder_.dispose();
          stateStartTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when the session entered the historical state.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.Timestamp.Builder getStateStartTimeBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getStateStartTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when the session entered the historical state.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.protobuf.TimestampOrBuilder getStateStartTimeOrBuilder() {
        if (stateStartTimeBuilder_ != null) {
          return stateStartTimeBuilder_.getMessageOrBuilder();
        } else {
          return stateStartTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : stateStartTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The time when the session entered the historical state.
       * </pre>
       *
       * <code>
       * .google.protobuf.Timestamp state_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getStateStartTimeFieldBuilder() {
        if (stateStartTimeBuilder_ == null) {
          stateStartTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getStateStartTime(), getParentForChildren(), isClean());
          stateStartTime_ = null;
        }
        return stateStartTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.Session.SessionStateHistory)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.Session.SessionStateHistory)
    private static final com.google.cloud.dataproc.v1.Session.SessionStateHistory DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.Session.SessionStateHistory();
    }

    public static com.google.cloud.dataproc.v1.Session.SessionStateHistory getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SessionStateHistory> PARSER =
        new com.google.protobuf.AbstractParser<SessionStateHistory>() {
          @java.lang.Override
          public SessionStateHistory parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SessionStateHistory> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SessionStateHistory> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.Session.SessionStateHistory getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int sessionConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object sessionConfig_;

  public enum SessionConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    JUPYTER_SESSION(4),
    SPARK_CONNECT_SESSION(17),
    SESSIONCONFIG_NOT_SET(0);
    private final int value;

    private SessionConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SessionConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static SessionConfigCase forNumber(int value) {
      switch (value) {
        case 4:
          return JUPYTER_SESSION;
        case 17:
          return SPARK_CONNECT_SESSION;
        case 0:
          return SESSIONCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SessionConfigCase getSessionConfigCase() {
    return SessionConfigCase.forNumber(sessionConfigCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the session.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the session.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UUID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uuid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. A session UUID (Unique Universal Identifier). The service
   * generates this value when it creates the session.
   * </pre>
   *
   * <code>string uuid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uuid.
   */
  @java.lang.Override
  public java.lang.String getUuid() {
    java.lang.Object ref = uuid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uuid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. A session UUID (Unique Universal Identifier). The service
   * generates this value when it creates the session.
   * </pre>
   *
   * <code>string uuid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uuid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUuidBytes() {
    java.lang.Object ref = uuid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uuid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the session was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the session was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the session was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int JUPYTER_SESSION_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Optional. Jupyter session config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the jupyterSession field is set.
   */
  @java.lang.Override
  public boolean hasJupyterSession() {
    return sessionConfigCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Optional. Jupyter session config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The jupyterSession.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.JupyterConfig getJupyterSession() {
    if (sessionConfigCase_ == 4) {
      return (com.google.cloud.dataproc.v1.JupyterConfig) sessionConfig_;
    }
    return com.google.cloud.dataproc.v1.JupyterConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Jupyter session config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.JupyterConfigOrBuilder getJupyterSessionOrBuilder() {
    if (sessionConfigCase_ == 4) {
      return (com.google.cloud.dataproc.v1.JupyterConfig) sessionConfig_;
    }
    return com.google.cloud.dataproc.v1.JupyterConfig.getDefaultInstance();
  }

  public static final int SPARK_CONNECT_SESSION_FIELD_NUMBER = 17;
  /**
   *
   *
   * <pre>
   * Optional. Spark Connect session config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the sparkConnectSession field is set.
   */
  @java.lang.Override
  public boolean hasSparkConnectSession() {
    return sessionConfigCase_ == 17;
  }
  /**
   *
   *
   * <pre>
   * Optional. Spark Connect session config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The sparkConnectSession.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.SparkConnectConfig getSparkConnectSession() {
    if (sessionConfigCase_ == 17) {
      return (com.google.cloud.dataproc.v1.SparkConnectConfig) sessionConfig_;
    }
    return com.google.cloud.dataproc.v1.SparkConnectConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Spark Connect session config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.SparkConnectConfigOrBuilder
      getSparkConnectSessionOrBuilder() {
    if (sessionConfigCase_ == 17) {
      return (com.google.cloud.dataproc.v1.SparkConnectConfig) sessionConfig_;
    }
    return com.google.cloud.dataproc.v1.SparkConnectConfig.getDefaultInstance();
  }

  public static final int RUNTIME_INFO_FIELD_NUMBER = 6;
  private com.google.cloud.dataproc.v1.RuntimeInfo runtimeInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Runtime information about session execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the runtimeInfo field is set.
   */
  @java.lang.Override
  public boolean hasRuntimeInfo() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Runtime information about session execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The runtimeInfo.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.RuntimeInfo getRuntimeInfo() {
    return runtimeInfo_ == null
        ? com.google.cloud.dataproc.v1.RuntimeInfo.getDefaultInstance()
        : runtimeInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Runtime information about session execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.RuntimeInfoOrBuilder getRuntimeInfoOrBuilder() {
    return runtimeInfo_ == null
        ? com.google.cloud.dataproc.v1.RuntimeInfo.getDefaultInstance()
        : runtimeInfo_;
  }

  public static final int STATE_FIELD_NUMBER = 7;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. A state of the session.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.Session.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A state of the session.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.Session.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.Session.State getState() {
    com.google.cloud.dataproc.v1.Session.State result =
        com.google.cloud.dataproc.v1.Session.State.forNumber(state_);
    return result == null ? com.google.cloud.dataproc.v1.Session.State.UNRECOGNIZED : result;
  }

  public static final int STATE_MESSAGE_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stateMessage_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Session state details, such as the failure
   * description if the state is `FAILED`.
   * </pre>
   *
   * <code>string state_message = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The stateMessage.
   */
  @java.lang.Override
  public java.lang.String getStateMessage() {
    java.lang.Object ref = stateMessage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stateMessage_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Session state details, such as the failure
   * description if the state is `FAILED`.
   * </pre>
   *
   * <code>string state_message = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for stateMessage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateMessageBytes() {
    java.lang.Object ref = stateMessage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stateMessage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp stateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the session entered the current state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp state_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the stateTime field is set.
   */
  @java.lang.Override
  public boolean hasStateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the session entered the current state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp state_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The stateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStateTime() {
    return stateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : stateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the session entered the current state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp state_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStateTimeOrBuilder() {
    return stateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : stateTime_;
  }

  public static final int CREATOR_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creator_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The email address of the user who created the session.
   * </pre>
   *
   * <code>string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The creator.
   */
  @java.lang.Override
  public java.lang.String getCreator() {
    java.lang.Object ref = creator_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creator_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The email address of the user who created the session.
   * </pre>
   *
   * <code>string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for creator.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreatorBytes() {
    java.lang.Object ref = creator_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creator_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 11;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataproc.v1.SessionsProto
                .internal_static_google_cloud_dataproc_v1_Session_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with the session.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a session.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with the session.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a session.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with the session.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a session.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The labels to associate with the session.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** may be empty, but, if present, must contain 1 to 63
   * characters, and must conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a session.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int RUNTIME_CONFIG_FIELD_NUMBER = 12;
  private com.google.cloud.dataproc.v1.RuntimeConfig runtimeConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Runtime configuration for the session execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the runtimeConfig field is set.
   */
  @java.lang.Override
  public boolean hasRuntimeConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Runtime configuration for the session execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The runtimeConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.RuntimeConfig getRuntimeConfig() {
    return runtimeConfig_ == null
        ? com.google.cloud.dataproc.v1.RuntimeConfig.getDefaultInstance()
        : runtimeConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Runtime configuration for the session execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.RuntimeConfigOrBuilder getRuntimeConfigOrBuilder() {
    return runtimeConfig_ == null
        ? com.google.cloud.dataproc.v1.RuntimeConfig.getDefaultInstance()
        : runtimeConfig_;
  }

  public static final int ENVIRONMENT_CONFIG_FIELD_NUMBER = 13;
  private com.google.cloud.dataproc.v1.EnvironmentConfig environmentConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Environment configuration for the session execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the environmentConfig field is set.
   */
  @java.lang.Override
  public boolean hasEnvironmentConfig() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Environment configuration for the session execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The environmentConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.EnvironmentConfig getEnvironmentConfig() {
    return environmentConfig_ == null
        ? com.google.cloud.dataproc.v1.EnvironmentConfig.getDefaultInstance()
        : environmentConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Environment configuration for the session execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.EnvironmentConfigOrBuilder getEnvironmentConfigOrBuilder() {
    return environmentConfig_ == null
        ? com.google.cloud.dataproc.v1.EnvironmentConfig.getDefaultInstance()
        : environmentConfig_;
  }

  public static final int USER_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object user_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The email address of the user who owns the session.
   * </pre>
   *
   * <code>string user = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The user.
   */
  @java.lang.Override
  public java.lang.String getUser() {
    java.lang.Object ref = user_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      user_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The email address of the user who owns the session.
   * </pre>
   *
   * <code>string user = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for user.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserBytes() {
    java.lang.Object ref = user_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      user_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_HISTORY_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.dataproc.v1.Session.SessionStateHistory> stateHistory_;
  /**
   *
   *
   * <pre>
   * Output only. Historical state information for the session.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.dataproc.v1.Session.SessionStateHistory>
      getStateHistoryList() {
    return stateHistory_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Historical state information for the session.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.dataproc.v1.Session.SessionStateHistoryOrBuilder>
      getStateHistoryOrBuilderList() {
    return stateHistory_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Historical state information for the session.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getStateHistoryCount() {
    return stateHistory_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Historical state information for the session.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.Session.SessionStateHistory getStateHistory(int index) {
    return stateHistory_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Historical state information for the session.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.Session.SessionStateHistoryOrBuilder getStateHistoryOrBuilder(
      int index) {
    return stateHistory_.get(index);
  }

  public static final int SESSION_TEMPLATE_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sessionTemplate_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The session template used by the session.
   *
   * Only resource names, including project ID and location, are valid.
   *
   * Example:
   * * `https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
   * * `projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
   *
   * The template must be in the same project and Dataproc region as the
   * session.
   * </pre>
   *
   * <code>
   * string session_template = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The sessionTemplate.
   */
  @java.lang.Override
  public java.lang.String getSessionTemplate() {
    java.lang.Object ref = sessionTemplate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sessionTemplate_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The session template used by the session.
   *
   * Only resource names, including project ID and location, are valid.
   *
   * Example:
   * * `https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
   * * `projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
   *
   * The template must be in the same project and Dataproc region as the
   * session.
   * </pre>
   *
   * <code>
   * string session_template = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for sessionTemplate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSessionTemplateBytes() {
    java.lang.Object ref = sessionTemplate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sessionTemplate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uuid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uuid_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (sessionConfigCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.dataproc.v1.JupyterConfig) sessionConfig_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getRuntimeInfo());
    }
    if (state_ != com.google.cloud.dataproc.v1.Session.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(7, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateMessage_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, stateMessage_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(9, getStateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(creator_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, creator_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 11);
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(12, getRuntimeConfig());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(13, getEnvironmentConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(user_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, user_);
    }
    for (int i = 0; i < stateHistory_.size(); i++) {
      output.writeMessage(15, stateHistory_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sessionTemplate_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, sessionTemplate_);
    }
    if (sessionConfigCase_ == 17) {
      output.writeMessage(17, (com.google.cloud.dataproc.v1.SparkConnectConfig) sessionConfig_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uuid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uuid_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (sessionConfigCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.dataproc.v1.JupyterConfig) sessionConfig_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getRuntimeInfo());
    }
    if (state_ != com.google.cloud.dataproc.v1.Session.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateMessage_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, stateMessage_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getStateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(creator_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, creator_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, labels__);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getRuntimeConfig());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getEnvironmentConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(user_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, user_);
    }
    for (int i = 0; i < stateHistory_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(15, stateHistory_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sessionTemplate_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, sessionTemplate_);
    }
    if (sessionConfigCase_ == 17) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, (com.google.cloud.dataproc.v1.SparkConnectConfig) sessionConfig_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.Session)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.Session other = (com.google.cloud.dataproc.v1.Session) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUuid().equals(other.getUuid())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasRuntimeInfo() != other.hasRuntimeInfo()) return false;
    if (hasRuntimeInfo()) {
      if (!getRuntimeInfo().equals(other.getRuntimeInfo())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getStateMessage().equals(other.getStateMessage())) return false;
    if (hasStateTime() != other.hasStateTime()) return false;
    if (hasStateTime()) {
      if (!getStateTime().equals(other.getStateTime())) return false;
    }
    if (!getCreator().equals(other.getCreator())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasRuntimeConfig() != other.hasRuntimeConfig()) return false;
    if (hasRuntimeConfig()) {
      if (!getRuntimeConfig().equals(other.getRuntimeConfig())) return false;
    }
    if (hasEnvironmentConfig() != other.hasEnvironmentConfig()) return false;
    if (hasEnvironmentConfig()) {
      if (!getEnvironmentConfig().equals(other.getEnvironmentConfig())) return false;
    }
    if (!getUser().equals(other.getUser())) return false;
    if (!getStateHistoryList().equals(other.getStateHistoryList())) return false;
    if (!getSessionTemplate().equals(other.getSessionTemplate())) return false;
    if (!getSessionConfigCase().equals(other.getSessionConfigCase())) return false;
    switch (sessionConfigCase_) {
      case 4:
        if (!getJupyterSession().equals(other.getJupyterSession())) return false;
        break;
      case 17:
        if (!getSparkConnectSession().equals(other.getSparkConnectSession())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UUID_FIELD_NUMBER;
    hash = (53 * hash) + getUuid().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasRuntimeInfo()) {
      hash = (37 * hash) + RUNTIME_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getRuntimeInfo().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + STATE_MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getStateMessage().hashCode();
    if (hasStateTime()) {
      hash = (37 * hash) + STATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStateTime().hashCode();
    }
    hash = (37 * hash) + CREATOR_FIELD_NUMBER;
    hash = (53 * hash) + getCreator().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasRuntimeConfig()) {
      hash = (37 * hash) + RUNTIME_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRuntimeConfig().hashCode();
    }
    if (hasEnvironmentConfig()) {
      hash = (37 * hash) + ENVIRONMENT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEnvironmentConfig().hashCode();
    }
    hash = (37 * hash) + USER_FIELD_NUMBER;
    hash = (53 * hash) + getUser().hashCode();
    if (getStateHistoryCount() > 0) {
      hash = (37 * hash) + STATE_HISTORY_FIELD_NUMBER;
      hash = (53 * hash) + getStateHistoryList().hashCode();
    }
    hash = (37 * hash) + SESSION_TEMPLATE_FIELD_NUMBER;
    hash = (53 * hash) + getSessionTemplate().hashCode();
    switch (sessionConfigCase_) {
      case 4:
        hash = (37 * hash) + JUPYTER_SESSION_FIELD_NUMBER;
        hash = (53 * hash) + getJupyterSession().hashCode();
        break;
      case 17:
        hash = (37 * hash) + SPARK_CONNECT_SESSION_FIELD_NUMBER;
        hash = (53 * hash) + getSparkConnectSession().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.Session parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.Session parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.Session parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.Session parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.Session parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.Session parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.Session parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.Session parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.Session parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.Session parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.Session parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.Session parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.Session prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A representation of a session.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.Session}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.Session)
      com.google.cloud.dataproc.v1.SessionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.SessionsProto
          .internal_static_google_cloud_dataproc_v1_Session_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 11:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 11:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.SessionsProto
          .internal_static_google_cloud_dataproc_v1_Session_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.Session.class,
              com.google.cloud.dataproc.v1.Session.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.Session.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getRuntimeInfoFieldBuilder();
        getStateTimeFieldBuilder();
        getRuntimeConfigFieldBuilder();
        getEnvironmentConfigFieldBuilder();
        getStateHistoryFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      uuid_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      if (jupyterSessionBuilder_ != null) {
        jupyterSessionBuilder_.clear();
      }
      if (sparkConnectSessionBuilder_ != null) {
        sparkConnectSessionBuilder_.clear();
      }
      runtimeInfo_ = null;
      if (runtimeInfoBuilder_ != null) {
        runtimeInfoBuilder_.dispose();
        runtimeInfoBuilder_ = null;
      }
      state_ = 0;
      stateMessage_ = "";
      stateTime_ = null;
      if (stateTimeBuilder_ != null) {
        stateTimeBuilder_.dispose();
        stateTimeBuilder_ = null;
      }
      creator_ = "";
      internalGetMutableLabels().clear();
      runtimeConfig_ = null;
      if (runtimeConfigBuilder_ != null) {
        runtimeConfigBuilder_.dispose();
        runtimeConfigBuilder_ = null;
      }
      environmentConfig_ = null;
      if (environmentConfigBuilder_ != null) {
        environmentConfigBuilder_.dispose();
        environmentConfigBuilder_ = null;
      }
      user_ = "";
      if (stateHistoryBuilder_ == null) {
        stateHistory_ = java.util.Collections.emptyList();
      } else {
        stateHistory_ = null;
        stateHistoryBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00004000);
      sessionTemplate_ = "";
      sessionConfigCase_ = 0;
      sessionConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.SessionsProto
          .internal_static_google_cloud_dataproc_v1_Session_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.Session getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.Session.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.Session build() {
      com.google.cloud.dataproc.v1.Session result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.Session buildPartial() {
      com.google.cloud.dataproc.v1.Session result = new com.google.cloud.dataproc.v1.Session(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.dataproc.v1.Session result) {
      if (stateHistoryBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)) {
          stateHistory_ = java.util.Collections.unmodifiableList(stateHistory_);
          bitField0_ = (bitField0_ & ~0x00004000);
        }
        result.stateHistory_ = stateHistory_;
      } else {
        result.stateHistory_ = stateHistoryBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.Session result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uuid_ = uuid_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.runtimeInfo_ =
            runtimeInfoBuilder_ == null ? runtimeInfo_ : runtimeInfoBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.stateMessage_ = stateMessage_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.stateTime_ = stateTimeBuilder_ == null ? stateTime_ : stateTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.creator_ = creator_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.runtimeConfig_ =
            runtimeConfigBuilder_ == null ? runtimeConfig_ : runtimeConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.environmentConfig_ =
            environmentConfigBuilder_ == null
                ? environmentConfig_
                : environmentConfigBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.user_ = user_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.sessionTemplate_ = sessionTemplate_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.dataproc.v1.Session result) {
      result.sessionConfigCase_ = sessionConfigCase_;
      result.sessionConfig_ = this.sessionConfig_;
      if (sessionConfigCase_ == 4 && jupyterSessionBuilder_ != null) {
        result.sessionConfig_ = jupyterSessionBuilder_.build();
      }
      if (sessionConfigCase_ == 17 && sparkConnectSessionBuilder_ != null) {
        result.sessionConfig_ = sparkConnectSessionBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.Session) {
        return mergeFrom((com.google.cloud.dataproc.v1.Session) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.Session other) {
      if (other == com.google.cloud.dataproc.v1.Session.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUuid().isEmpty()) {
        uuid_ = other.uuid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasRuntimeInfo()) {
        mergeRuntimeInfo(other.getRuntimeInfo());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getStateMessage().isEmpty()) {
        stateMessage_ = other.stateMessage_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasStateTime()) {
        mergeStateTime(other.getStateTime());
      }
      if (!other.getCreator().isEmpty()) {
        creator_ = other.creator_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000400;
      if (other.hasRuntimeConfig()) {
        mergeRuntimeConfig(other.getRuntimeConfig());
      }
      if (other.hasEnvironmentConfig()) {
        mergeEnvironmentConfig(other.getEnvironmentConfig());
      }
      if (!other.getUser().isEmpty()) {
        user_ = other.user_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (stateHistoryBuilder_ == null) {
        if (!other.stateHistory_.isEmpty()) {
          if (stateHistory_.isEmpty()) {
            stateHistory_ = other.stateHistory_;
            bitField0_ = (bitField0_ & ~0x00004000);
          } else {
            ensureStateHistoryIsMutable();
            stateHistory_.addAll(other.stateHistory_);
          }
          onChanged();
        }
      } else {
        if (!other.stateHistory_.isEmpty()) {
          if (stateHistoryBuilder_.isEmpty()) {
            stateHistoryBuilder_.dispose();
            stateHistoryBuilder_ = null;
            stateHistory_ = other.stateHistory_;
            bitField0_ = (bitField0_ & ~0x00004000);
            stateHistoryBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStateHistoryFieldBuilder()
                    : null;
          } else {
            stateHistoryBuilder_.addAllMessages(other.stateHistory_);
          }
        }
      }
      if (!other.getSessionTemplate().isEmpty()) {
        sessionTemplate_ = other.sessionTemplate_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      switch (other.getSessionConfigCase()) {
        case JUPYTER_SESSION:
          {
            mergeJupyterSession(other.getJupyterSession());
            break;
          }
        case SPARK_CONNECT_SESSION:
          {
            mergeSparkConnectSession(other.getSparkConnectSession());
            break;
          }
        case SESSIONCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uuid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getJupyterSessionFieldBuilder().getBuilder(), extensionRegistry);
                sessionConfigCase_ = 4;
                break;
              } // case 34
            case 50:
              {
                input.readMessage(getRuntimeInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 56:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 66:
              {
                stateMessage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getStateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                creator_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getRuntimeConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getEnvironmentConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            case 114:
              {
                user_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 114
            case 122:
              {
                com.google.cloud.dataproc.v1.Session.SessionStateHistory m =
                    input.readMessage(
                        com.google.cloud.dataproc.v1.Session.SessionStateHistory.parser(),
                        extensionRegistry);
                if (stateHistoryBuilder_ == null) {
                  ensureStateHistoryIsMutable();
                  stateHistory_.add(m);
                } else {
                  stateHistoryBuilder_.addMessage(m);
                }
                break;
              } // case 122
            case 130:
              {
                sessionTemplate_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(
                    getSparkConnectSessionFieldBuilder().getBuilder(), extensionRegistry);
                sessionConfigCase_ = 17;
                break;
              } // case 138
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sessionConfigCase_ = 0;
    private java.lang.Object sessionConfig_;

    public SessionConfigCase getSessionConfigCase() {
      return SessionConfigCase.forNumber(sessionConfigCase_);
    }

    public Builder clearSessionConfig() {
      sessionConfigCase_ = 0;
      sessionConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the session.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the session.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the session.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the session.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the session.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uuid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. A session UUID (Unique Universal Identifier). The service
     * generates this value when it creates the session.
     * </pre>
     *
     * <code>string uuid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uuid.
     */
    public java.lang.String getUuid() {
      java.lang.Object ref = uuid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uuid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A session UUID (Unique Universal Identifier). The service
     * generates this value when it creates the session.
     * </pre>
     *
     * <code>string uuid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uuid.
     */
    public com.google.protobuf.ByteString getUuidBytes() {
      java.lang.Object ref = uuid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uuid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A session UUID (Unique Universal Identifier). The service
     * generates this value when it creates the session.
     * </pre>
     *
     * <code>string uuid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uuid to set.
     * @return This builder for chaining.
     */
    public Builder setUuid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uuid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A session UUID (Unique Universal Identifier). The service
     * generates this value when it creates the session.
     * </pre>
     *
     * <code>string uuid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUuid() {
      uuid_ = getDefaultInstance().getUuid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A session UUID (Unique Universal Identifier). The service
     * generates this value when it creates the session.
     * </pre>
     *
     * <code>string uuid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uuid to set.
     * @return This builder for chaining.
     */
    public Builder setUuidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uuid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the session was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the session was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the session was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the session was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the session was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the session was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the session was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the session was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the session was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.JupyterConfig,
            com.google.cloud.dataproc.v1.JupyterConfig.Builder,
            com.google.cloud.dataproc.v1.JupyterConfigOrBuilder>
        jupyterSessionBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Jupyter session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the jupyterSession field is set.
     */
    @java.lang.Override
    public boolean hasJupyterSession() {
      return sessionConfigCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Optional. Jupyter session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The jupyterSession.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.JupyterConfig getJupyterSession() {
      if (jupyterSessionBuilder_ == null) {
        if (sessionConfigCase_ == 4) {
          return (com.google.cloud.dataproc.v1.JupyterConfig) sessionConfig_;
        }
        return com.google.cloud.dataproc.v1.JupyterConfig.getDefaultInstance();
      } else {
        if (sessionConfigCase_ == 4) {
          return jupyterSessionBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.JupyterConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Jupyter session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setJupyterSession(com.google.cloud.dataproc.v1.JupyterConfig value) {
      if (jupyterSessionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sessionConfig_ = value;
        onChanged();
      } else {
        jupyterSessionBuilder_.setMessage(value);
      }
      sessionConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Jupyter session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setJupyterSession(
        com.google.cloud.dataproc.v1.JupyterConfig.Builder builderForValue) {
      if (jupyterSessionBuilder_ == null) {
        sessionConfig_ = builderForValue.build();
        onChanged();
      } else {
        jupyterSessionBuilder_.setMessage(builderForValue.build());
      }
      sessionConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Jupyter session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeJupyterSession(com.google.cloud.dataproc.v1.JupyterConfig value) {
      if (jupyterSessionBuilder_ == null) {
        if (sessionConfigCase_ == 4
            && sessionConfig_ != com.google.cloud.dataproc.v1.JupyterConfig.getDefaultInstance()) {
          sessionConfig_ =
              com.google.cloud.dataproc.v1.JupyterConfig.newBuilder(
                      (com.google.cloud.dataproc.v1.JupyterConfig) sessionConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sessionConfig_ = value;
        }
        onChanged();
      } else {
        if (sessionConfigCase_ == 4) {
          jupyterSessionBuilder_.mergeFrom(value);
        } else {
          jupyterSessionBuilder_.setMessage(value);
        }
      }
      sessionConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Jupyter session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearJupyterSession() {
      if (jupyterSessionBuilder_ == null) {
        if (sessionConfigCase_ == 4) {
          sessionConfigCase_ = 0;
          sessionConfig_ = null;
          onChanged();
        }
      } else {
        if (sessionConfigCase_ == 4) {
          sessionConfigCase_ = 0;
          sessionConfig_ = null;
        }
        jupyterSessionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Jupyter session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.JupyterConfig.Builder getJupyterSessionBuilder() {
      return getJupyterSessionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Jupyter session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.JupyterConfigOrBuilder getJupyterSessionOrBuilder() {
      if ((sessionConfigCase_ == 4) && (jupyterSessionBuilder_ != null)) {
        return jupyterSessionBuilder_.getMessageOrBuilder();
      } else {
        if (sessionConfigCase_ == 4) {
          return (com.google.cloud.dataproc.v1.JupyterConfig) sessionConfig_;
        }
        return com.google.cloud.dataproc.v1.JupyterConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Jupyter session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.JupyterConfig,
            com.google.cloud.dataproc.v1.JupyterConfig.Builder,
            com.google.cloud.dataproc.v1.JupyterConfigOrBuilder>
        getJupyterSessionFieldBuilder() {
      if (jupyterSessionBuilder_ == null) {
        if (!(sessionConfigCase_ == 4)) {
          sessionConfig_ = com.google.cloud.dataproc.v1.JupyterConfig.getDefaultInstance();
        }
        jupyterSessionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.JupyterConfig,
                com.google.cloud.dataproc.v1.JupyterConfig.Builder,
                com.google.cloud.dataproc.v1.JupyterConfigOrBuilder>(
                (com.google.cloud.dataproc.v1.JupyterConfig) sessionConfig_,
                getParentForChildren(),
                isClean());
        sessionConfig_ = null;
      }
      sessionConfigCase_ = 4;
      onChanged();
      return jupyterSessionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.SparkConnectConfig,
            com.google.cloud.dataproc.v1.SparkConnectConfig.Builder,
            com.google.cloud.dataproc.v1.SparkConnectConfigOrBuilder>
        sparkConnectSessionBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Spark Connect session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sparkConnectSession field is set.
     */
    @java.lang.Override
    public boolean hasSparkConnectSession() {
      return sessionConfigCase_ == 17;
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark Connect session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sparkConnectSession.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkConnectConfig getSparkConnectSession() {
      if (sparkConnectSessionBuilder_ == null) {
        if (sessionConfigCase_ == 17) {
          return (com.google.cloud.dataproc.v1.SparkConnectConfig) sessionConfig_;
        }
        return com.google.cloud.dataproc.v1.SparkConnectConfig.getDefaultInstance();
      } else {
        if (sessionConfigCase_ == 17) {
          return sparkConnectSessionBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.SparkConnectConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark Connect session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSparkConnectSession(com.google.cloud.dataproc.v1.SparkConnectConfig value) {
      if (sparkConnectSessionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sessionConfig_ = value;
        onChanged();
      } else {
        sparkConnectSessionBuilder_.setMessage(value);
      }
      sessionConfigCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark Connect session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSparkConnectSession(
        com.google.cloud.dataproc.v1.SparkConnectConfig.Builder builderForValue) {
      if (sparkConnectSessionBuilder_ == null) {
        sessionConfig_ = builderForValue.build();
        onChanged();
      } else {
        sparkConnectSessionBuilder_.setMessage(builderForValue.build());
      }
      sessionConfigCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark Connect session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSparkConnectSession(com.google.cloud.dataproc.v1.SparkConnectConfig value) {
      if (sparkConnectSessionBuilder_ == null) {
        if (sessionConfigCase_ == 17
            && sessionConfig_
                != com.google.cloud.dataproc.v1.SparkConnectConfig.getDefaultInstance()) {
          sessionConfig_ =
              com.google.cloud.dataproc.v1.SparkConnectConfig.newBuilder(
                      (com.google.cloud.dataproc.v1.SparkConnectConfig) sessionConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sessionConfig_ = value;
        }
        onChanged();
      } else {
        if (sessionConfigCase_ == 17) {
          sparkConnectSessionBuilder_.mergeFrom(value);
        } else {
          sparkConnectSessionBuilder_.setMessage(value);
        }
      }
      sessionConfigCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark Connect session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSparkConnectSession() {
      if (sparkConnectSessionBuilder_ == null) {
        if (sessionConfigCase_ == 17) {
          sessionConfigCase_ = 0;
          sessionConfig_ = null;
          onChanged();
        }
      } else {
        if (sessionConfigCase_ == 17) {
          sessionConfigCase_ = 0;
          sessionConfig_ = null;
        }
        sparkConnectSessionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark Connect session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.SparkConnectConfig.Builder getSparkConnectSessionBuilder() {
      return getSparkConnectSessionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark Connect session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkConnectConfigOrBuilder
        getSparkConnectSessionOrBuilder() {
      if ((sessionConfigCase_ == 17) && (sparkConnectSessionBuilder_ != null)) {
        return sparkConnectSessionBuilder_.getMessageOrBuilder();
      } else {
        if (sessionConfigCase_ == 17) {
          return (com.google.cloud.dataproc.v1.SparkConnectConfig) sessionConfig_;
        }
        return com.google.cloud.dataproc.v1.SparkConnectConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark Connect session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.SparkConnectConfig,
            com.google.cloud.dataproc.v1.SparkConnectConfig.Builder,
            com.google.cloud.dataproc.v1.SparkConnectConfigOrBuilder>
        getSparkConnectSessionFieldBuilder() {
      if (sparkConnectSessionBuilder_ == null) {
        if (!(sessionConfigCase_ == 17)) {
          sessionConfig_ = com.google.cloud.dataproc.v1.SparkConnectConfig.getDefaultInstance();
        }
        sparkConnectSessionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.SparkConnectConfig,
                com.google.cloud.dataproc.v1.SparkConnectConfig.Builder,
                com.google.cloud.dataproc.v1.SparkConnectConfigOrBuilder>(
                (com.google.cloud.dataproc.v1.SparkConnectConfig) sessionConfig_,
                getParentForChildren(),
                isClean());
        sessionConfig_ = null;
      }
      sessionConfigCase_ = 17;
      onChanged();
      return sparkConnectSessionBuilder_;
    }

    private com.google.cloud.dataproc.v1.RuntimeInfo runtimeInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.RuntimeInfo,
            com.google.cloud.dataproc.v1.RuntimeInfo.Builder,
            com.google.cloud.dataproc.v1.RuntimeInfoOrBuilder>
        runtimeInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Runtime information about session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the runtimeInfo field is set.
     */
    public boolean hasRuntimeInfo() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime information about session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The runtimeInfo.
     */
    public com.google.cloud.dataproc.v1.RuntimeInfo getRuntimeInfo() {
      if (runtimeInfoBuilder_ == null) {
        return runtimeInfo_ == null
            ? com.google.cloud.dataproc.v1.RuntimeInfo.getDefaultInstance()
            : runtimeInfo_;
      } else {
        return runtimeInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime information about session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRuntimeInfo(com.google.cloud.dataproc.v1.RuntimeInfo value) {
      if (runtimeInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runtimeInfo_ = value;
      } else {
        runtimeInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime information about session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRuntimeInfo(
        com.google.cloud.dataproc.v1.RuntimeInfo.Builder builderForValue) {
      if (runtimeInfoBuilder_ == null) {
        runtimeInfo_ = builderForValue.build();
      } else {
        runtimeInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime information about session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRuntimeInfo(com.google.cloud.dataproc.v1.RuntimeInfo value) {
      if (runtimeInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && runtimeInfo_ != null
            && runtimeInfo_ != com.google.cloud.dataproc.v1.RuntimeInfo.getDefaultInstance()) {
          getRuntimeInfoBuilder().mergeFrom(value);
        } else {
          runtimeInfo_ = value;
        }
      } else {
        runtimeInfoBuilder_.mergeFrom(value);
      }
      if (runtimeInfo_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime information about session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRuntimeInfo() {
      bitField0_ = (bitField0_ & ~0x00000020);
      runtimeInfo_ = null;
      if (runtimeInfoBuilder_ != null) {
        runtimeInfoBuilder_.dispose();
        runtimeInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime information about session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.RuntimeInfo.Builder getRuntimeInfoBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getRuntimeInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime information about session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.RuntimeInfoOrBuilder getRuntimeInfoOrBuilder() {
      if (runtimeInfoBuilder_ != null) {
        return runtimeInfoBuilder_.getMessageOrBuilder();
      } else {
        return runtimeInfo_ == null
            ? com.google.cloud.dataproc.v1.RuntimeInfo.getDefaultInstance()
            : runtimeInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Runtime information about session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeInfo runtime_info = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.RuntimeInfo,
            com.google.cloud.dataproc.v1.RuntimeInfo.Builder,
            com.google.cloud.dataproc.v1.RuntimeInfoOrBuilder>
        getRuntimeInfoFieldBuilder() {
      if (runtimeInfoBuilder_ == null) {
        runtimeInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.RuntimeInfo,
                com.google.cloud.dataproc.v1.RuntimeInfo.Builder,
                com.google.cloud.dataproc.v1.RuntimeInfoOrBuilder>(
                getRuntimeInfo(), getParentForChildren(), isClean());
        runtimeInfo_ = null;
      }
      return runtimeInfoBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. A state of the session.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Session.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. A state of the session.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Session.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A state of the session.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Session.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.Session.State getState() {
      com.google.cloud.dataproc.v1.Session.State result =
          com.google.cloud.dataproc.v1.Session.State.forNumber(state_);
      return result == null ? com.google.cloud.dataproc.v1.Session.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. A state of the session.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Session.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.dataproc.v1.Session.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A state of the session.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.Session.State state = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000040);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object stateMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Session state details, such as the failure
     * description if the state is `FAILED`.
     * </pre>
     *
     * <code>string state_message = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stateMessage.
     */
    public java.lang.String getStateMessage() {
      java.lang.Object ref = stateMessage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateMessage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Session state details, such as the failure
     * description if the state is `FAILED`.
     * </pre>
     *
     * <code>string state_message = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stateMessage.
     */
    public com.google.protobuf.ByteString getStateMessageBytes() {
      java.lang.Object ref = stateMessage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stateMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Session state details, such as the failure
     * description if the state is `FAILED`.
     * </pre>
     *
     * <code>string state_message = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The stateMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStateMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stateMessage_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Session state details, such as the failure
     * description if the state is `FAILED`.
     * </pre>
     *
     * <code>string state_message = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStateMessage() {
      stateMessage_ = getDefaultInstance().getStateMessage();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Session state details, such as the failure
     * description if the state is `FAILED`.
     * </pre>
     *
     * <code>string state_message = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for stateMessage to set.
     * @return This builder for chaining.
     */
    public Builder setStateMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stateMessage_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp stateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        stateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the session entered the current state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp state_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the stateTime field is set.
     */
    public boolean hasStateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the session entered the current state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp state_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The stateTime.
     */
    public com.google.protobuf.Timestamp getStateTime() {
      if (stateTimeBuilder_ == null) {
        return stateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : stateTime_;
      } else {
        return stateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the session entered the current state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp state_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStateTime(com.google.protobuf.Timestamp value) {
      if (stateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stateTime_ = value;
      } else {
        stateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the session entered the current state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp state_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (stateTimeBuilder_ == null) {
        stateTime_ = builderForValue.build();
      } else {
        stateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the session entered the current state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp state_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStateTime(com.google.protobuf.Timestamp value) {
      if (stateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && stateTime_ != null
            && stateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStateTimeBuilder().mergeFrom(value);
        } else {
          stateTime_ = value;
        }
      } else {
        stateTimeBuilder_.mergeFrom(value);
      }
      if (stateTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the session entered the current state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp state_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      stateTime_ = null;
      if (stateTimeBuilder_ != null) {
        stateTimeBuilder_.dispose();
        stateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the session entered the current state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp state_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getStateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the session entered the current state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp state_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStateTimeOrBuilder() {
      if (stateTimeBuilder_ != null) {
        return stateTimeBuilder_.getMessageOrBuilder();
      } else {
        return stateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : stateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the session entered the current state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp state_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStateTimeFieldBuilder() {
      if (stateTimeBuilder_ == null) {
        stateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStateTime(), getParentForChildren(), isClean());
        stateTime_ = null;
      }
      return stateTimeBuilder_;
    }

    private java.lang.Object creator_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The email address of the user who created the session.
     * </pre>
     *
     * <code>string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The creator.
     */
    public java.lang.String getCreator() {
      java.lang.Object ref = creator_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creator_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The email address of the user who created the session.
     * </pre>
     *
     * <code>string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for creator.
     */
    public com.google.protobuf.ByteString getCreatorBytes() {
      java.lang.Object ref = creator_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creator_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The email address of the user who created the session.
     * </pre>
     *
     * <code>string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The creator to set.
     * @return This builder for chaining.
     */
    public Builder setCreator(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creator_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The email address of the user who created the session.
     * </pre>
     *
     * <code>string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreator() {
      creator_ = getDefaultInstance().getCreator();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The email address of the user who created the session.
     * </pre>
     *
     * <code>string creator = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for creator to set.
     * @return This builder for chaining.
     */
    public Builder setCreatorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creator_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with the session.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a session.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with the session.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a session.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with the session.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a session.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with the session.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a session.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000400);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with the session.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a session.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000400;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with the session.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a session.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000400;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The labels to associate with the session.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** may be empty, but, if present, must contain 1 to 63
     * characters, and must conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a session.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000400;
      return this;
    }

    private com.google.cloud.dataproc.v1.RuntimeConfig runtimeConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.RuntimeConfig,
            com.google.cloud.dataproc.v1.RuntimeConfig.Builder,
            com.google.cloud.dataproc.v1.RuntimeConfigOrBuilder>
        runtimeConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for the session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the runtimeConfig field is set.
     */
    public boolean hasRuntimeConfig() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for the session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The runtimeConfig.
     */
    public com.google.cloud.dataproc.v1.RuntimeConfig getRuntimeConfig() {
      if (runtimeConfigBuilder_ == null) {
        return runtimeConfig_ == null
            ? com.google.cloud.dataproc.v1.RuntimeConfig.getDefaultInstance()
            : runtimeConfig_;
      } else {
        return runtimeConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for the session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRuntimeConfig(com.google.cloud.dataproc.v1.RuntimeConfig value) {
      if (runtimeConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runtimeConfig_ = value;
      } else {
        runtimeConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for the session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRuntimeConfig(
        com.google.cloud.dataproc.v1.RuntimeConfig.Builder builderForValue) {
      if (runtimeConfigBuilder_ == null) {
        runtimeConfig_ = builderForValue.build();
      } else {
        runtimeConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for the session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRuntimeConfig(com.google.cloud.dataproc.v1.RuntimeConfig value) {
      if (runtimeConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && runtimeConfig_ != null
            && runtimeConfig_ != com.google.cloud.dataproc.v1.RuntimeConfig.getDefaultInstance()) {
          getRuntimeConfigBuilder().mergeFrom(value);
        } else {
          runtimeConfig_ = value;
        }
      } else {
        runtimeConfigBuilder_.mergeFrom(value);
      }
      if (runtimeConfig_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for the session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRuntimeConfig() {
      bitField0_ = (bitField0_ & ~0x00000800);
      runtimeConfig_ = null;
      if (runtimeConfigBuilder_ != null) {
        runtimeConfigBuilder_.dispose();
        runtimeConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for the session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.RuntimeConfig.Builder getRuntimeConfigBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getRuntimeConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for the session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.RuntimeConfigOrBuilder getRuntimeConfigOrBuilder() {
      if (runtimeConfigBuilder_ != null) {
        return runtimeConfigBuilder_.getMessageOrBuilder();
      } else {
        return runtimeConfig_ == null
            ? com.google.cloud.dataproc.v1.RuntimeConfig.getDefaultInstance()
            : runtimeConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for the session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.RuntimeConfig,
            com.google.cloud.dataproc.v1.RuntimeConfig.Builder,
            com.google.cloud.dataproc.v1.RuntimeConfigOrBuilder>
        getRuntimeConfigFieldBuilder() {
      if (runtimeConfigBuilder_ == null) {
        runtimeConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.RuntimeConfig,
                com.google.cloud.dataproc.v1.RuntimeConfig.Builder,
                com.google.cloud.dataproc.v1.RuntimeConfigOrBuilder>(
                getRuntimeConfig(), getParentForChildren(), isClean());
        runtimeConfig_ = null;
      }
      return runtimeConfigBuilder_;
    }

    private com.google.cloud.dataproc.v1.EnvironmentConfig environmentConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.EnvironmentConfig,
            com.google.cloud.dataproc.v1.EnvironmentConfig.Builder,
            com.google.cloud.dataproc.v1.EnvironmentConfigOrBuilder>
        environmentConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for the session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the environmentConfig field is set.
     */
    public boolean hasEnvironmentConfig() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for the session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The environmentConfig.
     */
    public com.google.cloud.dataproc.v1.EnvironmentConfig getEnvironmentConfig() {
      if (environmentConfigBuilder_ == null) {
        return environmentConfig_ == null
            ? com.google.cloud.dataproc.v1.EnvironmentConfig.getDefaultInstance()
            : environmentConfig_;
      } else {
        return environmentConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for the session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEnvironmentConfig(com.google.cloud.dataproc.v1.EnvironmentConfig value) {
      if (environmentConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        environmentConfig_ = value;
      } else {
        environmentConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for the session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEnvironmentConfig(
        com.google.cloud.dataproc.v1.EnvironmentConfig.Builder builderForValue) {
      if (environmentConfigBuilder_ == null) {
        environmentConfig_ = builderForValue.build();
      } else {
        environmentConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for the session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEnvironmentConfig(com.google.cloud.dataproc.v1.EnvironmentConfig value) {
      if (environmentConfigBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && environmentConfig_ != null
            && environmentConfig_
                != com.google.cloud.dataproc.v1.EnvironmentConfig.getDefaultInstance()) {
          getEnvironmentConfigBuilder().mergeFrom(value);
        } else {
          environmentConfig_ = value;
        }
      } else {
        environmentConfigBuilder_.mergeFrom(value);
      }
      if (environmentConfig_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for the session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEnvironmentConfig() {
      bitField0_ = (bitField0_ & ~0x00001000);
      environmentConfig_ = null;
      if (environmentConfigBuilder_ != null) {
        environmentConfigBuilder_.dispose();
        environmentConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for the session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.EnvironmentConfig.Builder getEnvironmentConfigBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getEnvironmentConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for the session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.EnvironmentConfigOrBuilder getEnvironmentConfigOrBuilder() {
      if (environmentConfigBuilder_ != null) {
        return environmentConfigBuilder_.getMessageOrBuilder();
      } else {
        return environmentConfig_ == null
            ? com.google.cloud.dataproc.v1.EnvironmentConfig.getDefaultInstance()
            : environmentConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for the session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.EnvironmentConfig,
            com.google.cloud.dataproc.v1.EnvironmentConfig.Builder,
            com.google.cloud.dataproc.v1.EnvironmentConfigOrBuilder>
        getEnvironmentConfigFieldBuilder() {
      if (environmentConfigBuilder_ == null) {
        environmentConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.EnvironmentConfig,
                com.google.cloud.dataproc.v1.EnvironmentConfig.Builder,
                com.google.cloud.dataproc.v1.EnvironmentConfigOrBuilder>(
                getEnvironmentConfig(), getParentForChildren(), isClean());
        environmentConfig_ = null;
      }
      return environmentConfigBuilder_;
    }

    private java.lang.Object user_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The email address of the user who owns the session.
     * </pre>
     *
     * <code>string user = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The user.
     */
    public java.lang.String getUser() {
      java.lang.Object ref = user_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        user_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The email address of the user who owns the session.
     * </pre>
     *
     * <code>string user = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for user.
     */
    public com.google.protobuf.ByteString getUserBytes() {
      java.lang.Object ref = user_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        user_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The email address of the user who owns the session.
     * </pre>
     *
     * <code>string user = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The user to set.
     * @return This builder for chaining.
     */
    public Builder setUser(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      user_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The email address of the user who owns the session.
     * </pre>
     *
     * <code>string user = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUser() {
      user_ = getDefaultInstance().getUser();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The email address of the user who owns the session.
     * </pre>
     *
     * <code>string user = 14 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for user to set.
     * @return This builder for chaining.
     */
    public Builder setUserBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      user_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.dataproc.v1.Session.SessionStateHistory> stateHistory_ =
        java.util.Collections.emptyList();

    private void ensureStateHistoryIsMutable() {
      if (!((bitField0_ & 0x00004000) != 0)) {
        stateHistory_ =
            new java.util.ArrayList<com.google.cloud.dataproc.v1.Session.SessionStateHistory>(
                stateHistory_);
        bitField0_ |= 0x00004000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.Session.SessionStateHistory,
            com.google.cloud.dataproc.v1.Session.SessionStateHistory.Builder,
            com.google.cloud.dataproc.v1.Session.SessionStateHistoryOrBuilder>
        stateHistoryBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.Session.SessionStateHistory>
        getStateHistoryList() {
      if (stateHistoryBuilder_ == null) {
        return java.util.Collections.unmodifiableList(stateHistory_);
      } else {
        return stateHistoryBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getStateHistoryCount() {
      if (stateHistoryBuilder_ == null) {
        return stateHistory_.size();
      } else {
        return stateHistoryBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.Session.SessionStateHistory getStateHistory(int index) {
      if (stateHistoryBuilder_ == null) {
        return stateHistory_.get(index);
      } else {
        return stateHistoryBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStateHistory(
        int index, com.google.cloud.dataproc.v1.Session.SessionStateHistory value) {
      if (stateHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStateHistoryIsMutable();
        stateHistory_.set(index, value);
        onChanged();
      } else {
        stateHistoryBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStateHistory(
        int index,
        com.google.cloud.dataproc.v1.Session.SessionStateHistory.Builder builderForValue) {
      if (stateHistoryBuilder_ == null) {
        ensureStateHistoryIsMutable();
        stateHistory_.set(index, builderForValue.build());
        onChanged();
      } else {
        stateHistoryBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStateHistory(com.google.cloud.dataproc.v1.Session.SessionStateHistory value) {
      if (stateHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStateHistoryIsMutable();
        stateHistory_.add(value);
        onChanged();
      } else {
        stateHistoryBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStateHistory(
        int index, com.google.cloud.dataproc.v1.Session.SessionStateHistory value) {
      if (stateHistoryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStateHistoryIsMutable();
        stateHistory_.add(index, value);
        onChanged();
      } else {
        stateHistoryBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStateHistory(
        com.google.cloud.dataproc.v1.Session.SessionStateHistory.Builder builderForValue) {
      if (stateHistoryBuilder_ == null) {
        ensureStateHistoryIsMutable();
        stateHistory_.add(builderForValue.build());
        onChanged();
      } else {
        stateHistoryBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStateHistory(
        int index,
        com.google.cloud.dataproc.v1.Session.SessionStateHistory.Builder builderForValue) {
      if (stateHistoryBuilder_ == null) {
        ensureStateHistoryIsMutable();
        stateHistory_.add(index, builderForValue.build());
        onChanged();
      } else {
        stateHistoryBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllStateHistory(
        java.lang.Iterable<? extends com.google.cloud.dataproc.v1.Session.SessionStateHistory>
            values) {
      if (stateHistoryBuilder_ == null) {
        ensureStateHistoryIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, stateHistory_);
        onChanged();
      } else {
        stateHistoryBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStateHistory() {
      if (stateHistoryBuilder_ == null) {
        stateHistory_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00004000);
        onChanged();
      } else {
        stateHistoryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeStateHistory(int index) {
      if (stateHistoryBuilder_ == null) {
        ensureStateHistoryIsMutable();
        stateHistory_.remove(index);
        onChanged();
      } else {
        stateHistoryBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.Session.SessionStateHistory.Builder getStateHistoryBuilder(
        int index) {
      return getStateHistoryFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.Session.SessionStateHistoryOrBuilder
        getStateHistoryOrBuilder(int index) {
      if (stateHistoryBuilder_ == null) {
        return stateHistory_.get(index);
      } else {
        return stateHistoryBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.dataproc.v1.Session.SessionStateHistoryOrBuilder>
        getStateHistoryOrBuilderList() {
      if (stateHistoryBuilder_ != null) {
        return stateHistoryBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(stateHistory_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.Session.SessionStateHistory.Builder
        addStateHistoryBuilder() {
      return getStateHistoryFieldBuilder()
          .addBuilder(
              com.google.cloud.dataproc.v1.Session.SessionStateHistory.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.dataproc.v1.Session.SessionStateHistory.Builder addStateHistoryBuilder(
        int index) {
      return getStateHistoryFieldBuilder()
          .addBuilder(
              index, com.google.cloud.dataproc.v1.Session.SessionStateHistory.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Historical state information for the session.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.dataproc.v1.Session.SessionStateHistory state_history = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.dataproc.v1.Session.SessionStateHistory.Builder>
        getStateHistoryBuilderList() {
      return getStateHistoryFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.dataproc.v1.Session.SessionStateHistory,
            com.google.cloud.dataproc.v1.Session.SessionStateHistory.Builder,
            com.google.cloud.dataproc.v1.Session.SessionStateHistoryOrBuilder>
        getStateHistoryFieldBuilder() {
      if (stateHistoryBuilder_ == null) {
        stateHistoryBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.dataproc.v1.Session.SessionStateHistory,
                com.google.cloud.dataproc.v1.Session.SessionStateHistory.Builder,
                com.google.cloud.dataproc.v1.Session.SessionStateHistoryOrBuilder>(
                stateHistory_, ((bitField0_ & 0x00004000) != 0), getParentForChildren(), isClean());
        stateHistory_ = null;
      }
      return stateHistoryBuilder_;
    }

    private java.lang.Object sessionTemplate_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The session template used by the session.
     *
     * Only resource names, including project ID and location, are valid.
     *
     * Example:
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
     * * `projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
     *
     * The template must be in the same project and Dataproc region as the
     * session.
     * </pre>
     *
     * <code>
     * string session_template = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The sessionTemplate.
     */
    public java.lang.String getSessionTemplate() {
      java.lang.Object ref = sessionTemplate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sessionTemplate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The session template used by the session.
     *
     * Only resource names, including project ID and location, are valid.
     *
     * Example:
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
     * * `projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
     *
     * The template must be in the same project and Dataproc region as the
     * session.
     * </pre>
     *
     * <code>
     * string session_template = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for sessionTemplate.
     */
    public com.google.protobuf.ByteString getSessionTemplateBytes() {
      java.lang.Object ref = sessionTemplate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sessionTemplate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The session template used by the session.
     *
     * Only resource names, including project ID and location, are valid.
     *
     * Example:
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
     * * `projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
     *
     * The template must be in the same project and Dataproc region as the
     * session.
     * </pre>
     *
     * <code>
     * string session_template = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The sessionTemplate to set.
     * @return This builder for chaining.
     */
    public Builder setSessionTemplate(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sessionTemplate_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The session template used by the session.
     *
     * Only resource names, including project ID and location, are valid.
     *
     * Example:
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
     * * `projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
     *
     * The template must be in the same project and Dataproc region as the
     * session.
     * </pre>
     *
     * <code>
     * string session_template = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSessionTemplate() {
      sessionTemplate_ = getDefaultInstance().getSessionTemplate();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The session template used by the session.
     *
     * Only resource names, including project ID and location, are valid.
     *
     * Example:
     * * `https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
     * * `projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
     *
     * The template must be in the same project and Dataproc region as the
     * session.
     * </pre>
     *
     * <code>
     * string session_template = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for sessionTemplate to set.
     * @return This builder for chaining.
     */
    public Builder setSessionTemplateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sessionTemplate_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.Session)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.Session)
  private static final com.google.cloud.dataproc.v1.Session DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.Session();
  }

  public static com.google.cloud.dataproc.v1.Session getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Session> PARSER =
      new com.google.protobuf.AbstractParser<Session>() {
        @java.lang.Override
        public Session parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Session> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Session> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.Session getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
