/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/operations.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * Metadata describing the Session operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.SessionOperationMetadata}
 */
public final class SessionOperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.SessionOperationMetadata)
    SessionOperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SessionOperationMetadata.newBuilder() to construct.
  private SessionOperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SessionOperationMetadata() {
    session_ = "";
    sessionUuid_ = "";
    operationType_ = 0;
    description_ = "";
    warnings_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SessionOperationMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.OperationsProto
        .internal_static_google_cloud_dataproc_v1_SessionOperationMetadata_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 8:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.OperationsProto
        .internal_static_google_cloud_dataproc_v1_SessionOperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.SessionOperationMetadata.class,
            com.google.cloud.dataproc.v1.SessionOperationMetadata.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Operation type for Session resources
   * </pre>
   *
   * Protobuf enum {@code google.cloud.dataproc.v1.SessionOperationMetadata.SessionOperationType}
   */
  public enum SessionOperationType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Session operation type is unknown.
     * </pre>
     *
     * <code>SESSION_OPERATION_TYPE_UNSPECIFIED = 0;</code>
     */
    SESSION_OPERATION_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Create Session operation type.
     * </pre>
     *
     * <code>CREATE = 1;</code>
     */
    CREATE(1),
    /**
     *
     *
     * <pre>
     * Terminate Session operation type.
     * </pre>
     *
     * <code>TERMINATE = 2;</code>
     */
    TERMINATE(2),
    /**
     *
     *
     * <pre>
     * Delete Session operation type.
     * </pre>
     *
     * <code>DELETE = 3;</code>
     */
    DELETE(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Session operation type is unknown.
     * </pre>
     *
     * <code>SESSION_OPERATION_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int SESSION_OPERATION_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Create Session operation type.
     * </pre>
     *
     * <code>CREATE = 1;</code>
     */
    public static final int CREATE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Terminate Session operation type.
     * </pre>
     *
     * <code>TERMINATE = 2;</code>
     */
    public static final int TERMINATE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Delete Session operation type.
     * </pre>
     *
     * <code>DELETE = 3;</code>
     */
    public static final int DELETE_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SessionOperationType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SessionOperationType forNumber(int value) {
      switch (value) {
        case 0:
          return SESSION_OPERATION_TYPE_UNSPECIFIED;
        case 1:
          return CREATE;
        case 2:
          return TERMINATE;
        case 3:
          return DELETE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SessionOperationType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SessionOperationType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SessionOperationType>() {
              public SessionOperationType findValueByNumber(int number) {
                return SessionOperationType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.SessionOperationMetadata.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final SessionOperationType[] VALUES = values();

    public static SessionOperationType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SessionOperationType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.dataproc.v1.SessionOperationMetadata.SessionOperationType)
  }

  private int bitField0_;
  public static final int SESSION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object session_ = "";
  /**
   *
   *
   * <pre>
   * Name of the session for the operation.
   * </pre>
   *
   * <code>string session = 1;</code>
   *
   * @return The session.
   */
  @java.lang.Override
  public java.lang.String getSession() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      session_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Name of the session for the operation.
   * </pre>
   *
   * <code>string session = 1;</code>
   *
   * @return The bytes for session.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSessionBytes() {
    java.lang.Object ref = session_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      session_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SESSION_UUID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sessionUuid_ = "";
  /**
   *
   *
   * <pre>
   * Session UUID for the operation.
   * </pre>
   *
   * <code>string session_uuid = 2;</code>
   *
   * @return The sessionUuid.
   */
  @java.lang.Override
  public java.lang.String getSessionUuid() {
    java.lang.Object ref = sessionUuid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sessionUuid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Session UUID for the operation.
   * </pre>
   *
   * <code>string session_uuid = 2;</code>
   *
   * @return The bytes for sessionUuid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSessionUuidBytes() {
    java.lang.Object ref = sessionUuid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sessionUuid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * The time when the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time when the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * The time when the operation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int DONE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp doneTime_;
  /**
   *
   *
   * <pre>
   * The time when the operation was finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp done_time = 4;</code>
   *
   * @return Whether the doneTime field is set.
   */
  @java.lang.Override
  public boolean hasDoneTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time when the operation was finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp done_time = 4;</code>
   *
   * @return The doneTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDoneTime() {
    return doneTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : doneTime_;
  }
  /**
   *
   *
   * <pre>
   * The time when the operation was finished.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp done_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDoneTimeOrBuilder() {
    return doneTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : doneTime_;
  }

  public static final int OPERATION_TYPE_FIELD_NUMBER = 6;
  private int operationType_ = 0;
  /**
   *
   *
   * <pre>
   * The operation type.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SessionOperationMetadata.SessionOperationType operation_type = 6;
   * </code>
   *
   * @return The enum numeric value on the wire for operationType.
   */
  @java.lang.Override
  public int getOperationTypeValue() {
    return operationType_;
  }
  /**
   *
   *
   * <pre>
   * The operation type.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SessionOperationMetadata.SessionOperationType operation_type = 6;
   * </code>
   *
   * @return The operationType.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.SessionOperationMetadata.SessionOperationType
      getOperationType() {
    com.google.cloud.dataproc.v1.SessionOperationMetadata.SessionOperationType result =
        com.google.cloud.dataproc.v1.SessionOperationMetadata.SessionOperationType.forNumber(
            operationType_);
    return result == null
        ? com.google.cloud.dataproc.v1.SessionOperationMetadata.SessionOperationType.UNRECOGNIZED
        : result;
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Short description of the operation.
   * </pre>
   *
   * <code>string description = 7;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Short description of the operation.
   * </pre>
   *
   * <code>string description = 7;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 8;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataproc.v1.OperationsProto
                .internal_static_google_cloud_dataproc_v1_SessionOperationMetadata_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with the operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with the operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with the operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels associated with the operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int WARNINGS_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList warnings_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Warnings encountered during operation execution.
   * </pre>
   *
   * <code>repeated string warnings = 9;</code>
   *
   * @return A list containing the warnings.
   */
  public com.google.protobuf.ProtocolStringList getWarningsList() {
    return warnings_;
  }
  /**
   *
   *
   * <pre>
   * Warnings encountered during operation execution.
   * </pre>
   *
   * <code>repeated string warnings = 9;</code>
   *
   * @return The count of warnings.
   */
  public int getWarningsCount() {
    return warnings_.size();
  }
  /**
   *
   *
   * <pre>
   * Warnings encountered during operation execution.
   * </pre>
   *
   * <code>repeated string warnings = 9;</code>
   *
   * @param index The index of the element to return.
   * @return The warnings at the given index.
   */
  public java.lang.String getWarnings(int index) {
    return warnings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Warnings encountered during operation execution.
   * </pre>
   *
   * <code>repeated string warnings = 9;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the warnings at the given index.
   */
  public com.google.protobuf.ByteString getWarningsBytes(int index) {
    return warnings_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, session_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sessionUuid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sessionUuid_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getDoneTime());
    }
    if (operationType_
        != com.google.cloud.dataproc.v1.SessionOperationMetadata.SessionOperationType
            .SESSION_OPERATION_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, operationType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, description_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 8);
    for (int i = 0; i < warnings_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, warnings_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(session_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, session_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sessionUuid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, sessionUuid_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDoneTime());
    }
    if (operationType_
        != com.google.cloud.dataproc.v1.SessionOperationMetadata.SessionOperationType
            .SESSION_OPERATION_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, operationType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, description_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, labels__);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < warnings_.size(); i++) {
        dataSize += computeStringSizeNoTag(warnings_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getWarningsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.SessionOperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.SessionOperationMetadata other =
        (com.google.cloud.dataproc.v1.SessionOperationMetadata) obj;

    if (!getSession().equals(other.getSession())) return false;
    if (!getSessionUuid().equals(other.getSessionUuid())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasDoneTime() != other.hasDoneTime()) return false;
    if (hasDoneTime()) {
      if (!getDoneTime().equals(other.getDoneTime())) return false;
    }
    if (operationType_ != other.operationType_) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getWarningsList().equals(other.getWarningsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SESSION_FIELD_NUMBER;
    hash = (53 * hash) + getSession().hashCode();
    hash = (37 * hash) + SESSION_UUID_FIELD_NUMBER;
    hash = (53 * hash) + getSessionUuid().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasDoneTime()) {
      hash = (37 * hash) + DONE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDoneTime().hashCode();
    }
    hash = (37 * hash) + OPERATION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + operationType_;
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getWarningsCount() > 0) {
      hash = (37 * hash) + WARNINGS_FIELD_NUMBER;
      hash = (53 * hash) + getWarningsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.SessionOperationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.SessionOperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.SessionOperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.SessionOperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.SessionOperationMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.SessionOperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.SessionOperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.SessionOperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.SessionOperationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.SessionOperationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.SessionOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.SessionOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.dataproc.v1.SessionOperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata describing the Session operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.SessionOperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.SessionOperationMetadata)
      com.google.cloud.dataproc.v1.SessionOperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.OperationsProto
          .internal_static_google_cloud_dataproc_v1_SessionOperationMetadata_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 8:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 8:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.OperationsProto
          .internal_static_google_cloud_dataproc_v1_SessionOperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.SessionOperationMetadata.class,
              com.google.cloud.dataproc.v1.SessionOperationMetadata.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.SessionOperationMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getDoneTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      session_ = "";
      sessionUuid_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      doneTime_ = null;
      if (doneTimeBuilder_ != null) {
        doneTimeBuilder_.dispose();
        doneTimeBuilder_ = null;
      }
      operationType_ = 0;
      description_ = "";
      internalGetMutableLabels().clear();
      warnings_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.OperationsProto
          .internal_static_google_cloud_dataproc_v1_SessionOperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.SessionOperationMetadata getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.SessionOperationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.SessionOperationMetadata build() {
      com.google.cloud.dataproc.v1.SessionOperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.SessionOperationMetadata buildPartial() {
      com.google.cloud.dataproc.v1.SessionOperationMetadata result =
          new com.google.cloud.dataproc.v1.SessionOperationMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.SessionOperationMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.session_ = session_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.sessionUuid_ = sessionUuid_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.doneTime_ = doneTimeBuilder_ == null ? doneTime_ : doneTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.operationType_ = operationType_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        warnings_.makeImmutable();
        result.warnings_ = warnings_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.SessionOperationMetadata) {
        return mergeFrom((com.google.cloud.dataproc.v1.SessionOperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.SessionOperationMetadata other) {
      if (other == com.google.cloud.dataproc.v1.SessionOperationMetadata.getDefaultInstance())
        return this;
      if (!other.getSession().isEmpty()) {
        session_ = other.session_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getSessionUuid().isEmpty()) {
        sessionUuid_ = other.sessionUuid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasDoneTime()) {
        mergeDoneTime(other.getDoneTime());
      }
      if (other.operationType_ != 0) {
        setOperationTypeValue(other.getOperationTypeValue());
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000040;
      if (!other.warnings_.isEmpty()) {
        if (warnings_.isEmpty()) {
          warnings_ = other.warnings_;
          bitField0_ |= 0x00000080;
        } else {
          ensureWarningsIsMutable();
          warnings_.addAll(other.warnings_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                session_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                sessionUuid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getDoneTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 48:
              {
                operationType_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            case 58:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 74:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureWarningsIsMutable();
                warnings_.add(s);
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object session_ = "";
    /**
     *
     *
     * <pre>
     * Name of the session for the operation.
     * </pre>
     *
     * <code>string session = 1;</code>
     *
     * @return The session.
     */
    public java.lang.String getSession() {
      java.lang.Object ref = session_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        session_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the session for the operation.
     * </pre>
     *
     * <code>string session = 1;</code>
     *
     * @return The bytes for session.
     */
    public com.google.protobuf.ByteString getSessionBytes() {
      java.lang.Object ref = session_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        session_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of the session for the operation.
     * </pre>
     *
     * <code>string session = 1;</code>
     *
     * @param value The session to set.
     * @return This builder for chaining.
     */
    public Builder setSession(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      session_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the session for the operation.
     * </pre>
     *
     * <code>string session = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSession() {
      session_ = getDefaultInstance().getSession();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Name of the session for the operation.
     * </pre>
     *
     * <code>string session = 1;</code>
     *
     * @param value The bytes for session to set.
     * @return This builder for chaining.
     */
    public Builder setSessionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      session_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object sessionUuid_ = "";
    /**
     *
     *
     * <pre>
     * Session UUID for the operation.
     * </pre>
     *
     * <code>string session_uuid = 2;</code>
     *
     * @return The sessionUuid.
     */
    public java.lang.String getSessionUuid() {
      java.lang.Object ref = sessionUuid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sessionUuid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Session UUID for the operation.
     * </pre>
     *
     * <code>string session_uuid = 2;</code>
     *
     * @return The bytes for sessionUuid.
     */
    public com.google.protobuf.ByteString getSessionUuidBytes() {
      java.lang.Object ref = sessionUuid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sessionUuid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Session UUID for the operation.
     * </pre>
     *
     * <code>string session_uuid = 2;</code>
     *
     * @param value The sessionUuid to set.
     * @return This builder for chaining.
     */
    public Builder setSessionUuid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sessionUuid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Session UUID for the operation.
     * </pre>
     *
     * <code>string session_uuid = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSessionUuid() {
      sessionUuid_ = getDefaultInstance().getSessionUuid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Session UUID for the operation.
     * </pre>
     *
     * <code>string session_uuid = 2;</code>
     *
     * @param value The bytes for sessionUuid to set.
     * @return This builder for chaining.
     */
    public Builder setSessionUuidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sessionUuid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp doneTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        doneTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time when the operation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp done_time = 4;</code>
     *
     * @return Whether the doneTime field is set.
     */
    public boolean hasDoneTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp done_time = 4;</code>
     *
     * @return The doneTime.
     */
    public com.google.protobuf.Timestamp getDoneTime() {
      if (doneTimeBuilder_ == null) {
        return doneTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : doneTime_;
      } else {
        return doneTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp done_time = 4;</code>
     */
    public Builder setDoneTime(com.google.protobuf.Timestamp value) {
      if (doneTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        doneTime_ = value;
      } else {
        doneTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp done_time = 4;</code>
     */
    public Builder setDoneTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (doneTimeBuilder_ == null) {
        doneTime_ = builderForValue.build();
      } else {
        doneTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp done_time = 4;</code>
     */
    public Builder mergeDoneTime(com.google.protobuf.Timestamp value) {
      if (doneTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && doneTime_ != null
            && doneTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDoneTimeBuilder().mergeFrom(value);
        } else {
          doneTime_ = value;
        }
      } else {
        doneTimeBuilder_.mergeFrom(value);
      }
      if (doneTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp done_time = 4;</code>
     */
    public Builder clearDoneTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      doneTime_ = null;
      if (doneTimeBuilder_ != null) {
        doneTimeBuilder_.dispose();
        doneTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp done_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getDoneTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getDoneTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp done_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getDoneTimeOrBuilder() {
      if (doneTimeBuilder_ != null) {
        return doneTimeBuilder_.getMessageOrBuilder();
      } else {
        return doneTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : doneTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the operation was finished.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp done_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDoneTimeFieldBuilder() {
      if (doneTimeBuilder_ == null) {
        doneTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDoneTime(), getParentForChildren(), isClean());
        doneTime_ = null;
      }
      return doneTimeBuilder_;
    }

    private int operationType_ = 0;
    /**
     *
     *
     * <pre>
     * The operation type.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SessionOperationMetadata.SessionOperationType operation_type = 6;
     * </code>
     *
     * @return The enum numeric value on the wire for operationType.
     */
    @java.lang.Override
    public int getOperationTypeValue() {
      return operationType_;
    }
    /**
     *
     *
     * <pre>
     * The operation type.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SessionOperationMetadata.SessionOperationType operation_type = 6;
     * </code>
     *
     * @param value The enum numeric value on the wire for operationType to set.
     * @return This builder for chaining.
     */
    public Builder setOperationTypeValue(int value) {
      operationType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The operation type.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SessionOperationMetadata.SessionOperationType operation_type = 6;
     * </code>
     *
     * @return The operationType.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.SessionOperationMetadata.SessionOperationType
        getOperationType() {
      com.google.cloud.dataproc.v1.SessionOperationMetadata.SessionOperationType result =
          com.google.cloud.dataproc.v1.SessionOperationMetadata.SessionOperationType.forNumber(
              operationType_);
      return result == null
          ? com.google.cloud.dataproc.v1.SessionOperationMetadata.SessionOperationType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The operation type.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SessionOperationMetadata.SessionOperationType operation_type = 6;
     * </code>
     *
     * @param value The operationType to set.
     * @return This builder for chaining.
     */
    public Builder setOperationType(
        com.google.cloud.dataproc.v1.SessionOperationMetadata.SessionOperationType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      operationType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The operation type.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SessionOperationMetadata.SessionOperationType operation_type = 6;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOperationType() {
      bitField0_ = (bitField0_ & ~0x00000010);
      operationType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Short description of the operation.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Short description of the operation.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Short description of the operation.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Short description of the operation.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Short description of the operation.
     * </pre>
     *
     * <code>string description = 7;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private com.google.protobuf.LazyStringArrayList warnings_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureWarningsIsMutable() {
      if (!warnings_.isModifiable()) {
        warnings_ = new com.google.protobuf.LazyStringArrayList(warnings_);
      }
      bitField0_ |= 0x00000080;
    }
    /**
     *
     *
     * <pre>
     * Warnings encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 9;</code>
     *
     * @return A list containing the warnings.
     */
    public com.google.protobuf.ProtocolStringList getWarningsList() {
      warnings_.makeImmutable();
      return warnings_;
    }
    /**
     *
     *
     * <pre>
     * Warnings encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 9;</code>
     *
     * @return The count of warnings.
     */
    public int getWarningsCount() {
      return warnings_.size();
    }
    /**
     *
     *
     * <pre>
     * Warnings encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 9;</code>
     *
     * @param index The index of the element to return.
     * @return The warnings at the given index.
     */
    public java.lang.String getWarnings(int index) {
      return warnings_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Warnings encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 9;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the warnings at the given index.
     */
    public com.google.protobuf.ByteString getWarningsBytes(int index) {
      return warnings_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Warnings encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 9;</code>
     *
     * @param index The index to set the value at.
     * @param value The warnings to set.
     * @return This builder for chaining.
     */
    public Builder setWarnings(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWarningsIsMutable();
      warnings_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Warnings encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 9;</code>
     *
     * @param value The warnings to add.
     * @return This builder for chaining.
     */
    public Builder addWarnings(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureWarningsIsMutable();
      warnings_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Warnings encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 9;</code>
     *
     * @param values The warnings to add.
     * @return This builder for chaining.
     */
    public Builder addAllWarnings(java.lang.Iterable<java.lang.String> values) {
      ensureWarningsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, warnings_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Warnings encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWarnings() {
      warnings_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Warnings encountered during operation execution.
     * </pre>
     *
     * <code>repeated string warnings = 9;</code>
     *
     * @param value The bytes of the warnings to add.
     * @return This builder for chaining.
     */
    public Builder addWarningsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureWarningsIsMutable();
      warnings_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.SessionOperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.SessionOperationMetadata)
  private static final com.google.cloud.dataproc.v1.SessionOperationMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.SessionOperationMetadata();
  }

  public static com.google.cloud.dataproc.v1.SessionOperationMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SessionOperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<SessionOperationMetadata>() {
        @java.lang.Override
        public SessionOperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SessionOperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SessionOperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.SessionOperationMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
