/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/session_templates.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * A representation of a session template.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.SessionTemplate}
 */
public final class SessionTemplate extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.SessionTemplate)
    SessionTemplateOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SessionTemplate.newBuilder() to construct.
  private SessionTemplate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SessionTemplate() {
    name_ = "";
    description_ = "";
    creator_ = "";
    uuid_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SessionTemplate();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.SessionTemplatesProto
        .internal_static_google_cloud_dataproc_v1_SessionTemplate_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 6:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.SessionTemplatesProto
        .internal_static_google_cloud_dataproc_v1_SessionTemplate_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.SessionTemplate.class,
            com.google.cloud.dataproc.v1.SessionTemplate.Builder.class);
  }

  private int bitField0_;
  private int sessionConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object sessionConfig_;

  public enum SessionConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    JUPYTER_SESSION(3),
    SPARK_CONNECT_SESSION(11),
    SESSIONCONFIG_NOT_SET(0);
    private final int value;

    private SessionConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SessionConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static SessionConfigCase forNumber(int value) {
      switch (value) {
        case 3:
          return JUPYTER_SESSION;
        case 11:
          return SPARK_CONNECT_SESSION;
        case 0:
          return SESSIONCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SessionConfigCase getSessionConfigCase() {
    return SessionConfigCase.forNumber(sessionConfigCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the session template.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the session template.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Brief description of the template.
   * </pre>
   *
   * <code>string description = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Brief description of the template.
   * </pre>
   *
   * <code>string description = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time when the template was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the template was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time when the template was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int JUPYTER_SESSION_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Optional. Jupyter session config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the jupyterSession field is set.
   */
  @java.lang.Override
  public boolean hasJupyterSession() {
    return sessionConfigCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Optional. Jupyter session config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The jupyterSession.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.JupyterConfig getJupyterSession() {
    if (sessionConfigCase_ == 3) {
      return (com.google.cloud.dataproc.v1.JupyterConfig) sessionConfig_;
    }
    return com.google.cloud.dataproc.v1.JupyterConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Jupyter session config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.JupyterConfigOrBuilder getJupyterSessionOrBuilder() {
    if (sessionConfigCase_ == 3) {
      return (com.google.cloud.dataproc.v1.JupyterConfig) sessionConfig_;
    }
    return com.google.cloud.dataproc.v1.JupyterConfig.getDefaultInstance();
  }

  public static final int SPARK_CONNECT_SESSION_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Optional. Spark Connect session config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the sparkConnectSession field is set.
   */
  @java.lang.Override
  public boolean hasSparkConnectSession() {
    return sessionConfigCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Optional. Spark Connect session config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The sparkConnectSession.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.SparkConnectConfig getSparkConnectSession() {
    if (sessionConfigCase_ == 11) {
      return (com.google.cloud.dataproc.v1.SparkConnectConfig) sessionConfig_;
    }
    return com.google.cloud.dataproc.v1.SparkConnectConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Optional. Spark Connect session config.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.SparkConnectConfigOrBuilder
      getSparkConnectSessionOrBuilder() {
    if (sessionConfigCase_ == 11) {
      return (com.google.cloud.dataproc.v1.SparkConnectConfig) sessionConfig_;
    }
    return com.google.cloud.dataproc.v1.SparkConnectConfig.getDefaultInstance();
  }

  public static final int CREATOR_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creator_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The email address of the user who created the template.
   * </pre>
   *
   * <code>string creator = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The creator.
   */
  @java.lang.Override
  public java.lang.String getCreator() {
    java.lang.Object ref = creator_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creator_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The email address of the user who created the template.
   * </pre>
   *
   * <code>string creator = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for creator.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreatorBytes() {
    java.lang.Object ref = creator_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creator_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 6;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.dataproc.v1.SessionTemplatesProto
                .internal_static_google_cloud_dataproc_v1_SessionTemplate_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Labels to associate with sessions created using this template.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** can be empty, but, if present, must contain 1 to 63
   * characters and conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a session.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Labels to associate with sessions created using this template.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** can be empty, but, if present, must contain 1 to 63
   * characters and conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a session.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Labels to associate with sessions created using this template.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** can be empty, but, if present, must contain 1 to 63
   * characters and conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a session.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Labels to associate with sessions created using this template.
   * Label **keys** must contain 1 to 63 characters, and must conform to
   * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
   * Label **values** can be empty, but, if present, must contain 1 to 63
   * characters and conform to [RFC
   * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
   * associated with a session.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int RUNTIME_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.dataproc.v1.RuntimeConfig runtimeConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Runtime configuration for session execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the runtimeConfig field is set.
   */
  @java.lang.Override
  public boolean hasRuntimeConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Runtime configuration for session execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The runtimeConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.RuntimeConfig getRuntimeConfig() {
    return runtimeConfig_ == null
        ? com.google.cloud.dataproc.v1.RuntimeConfig.getDefaultInstance()
        : runtimeConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Runtime configuration for session execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.RuntimeConfigOrBuilder getRuntimeConfigOrBuilder() {
    return runtimeConfig_ == null
        ? com.google.cloud.dataproc.v1.RuntimeConfig.getDefaultInstance()
        : runtimeConfig_;
  }

  public static final int ENVIRONMENT_CONFIG_FIELD_NUMBER = 8;
  private com.google.cloud.dataproc.v1.EnvironmentConfig environmentConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Environment configuration for session execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the environmentConfig field is set.
   */
  @java.lang.Override
  public boolean hasEnvironmentConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Environment configuration for session execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The environmentConfig.
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.EnvironmentConfig getEnvironmentConfig() {
    return environmentConfig_ == null
        ? com.google.cloud.dataproc.v1.EnvironmentConfig.getDefaultInstance()
        : environmentConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Environment configuration for session execution.
   * </pre>
   *
   * <code>
   * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.dataproc.v1.EnvironmentConfigOrBuilder getEnvironmentConfigOrBuilder() {
    return environmentConfig_ == null
        ? com.google.cloud.dataproc.v1.EnvironmentConfig.getDefaultInstance()
        : environmentConfig_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time the template was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the template was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time the template was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int UUID_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uuid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. A session template UUID (Unique Universal Identifier). The
   * service generates this value when it creates the session template.
   * </pre>
   *
   * <code>string uuid = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uuid.
   */
  @java.lang.Override
  public java.lang.String getUuid() {
    java.lang.Object ref = uuid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uuid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. A session template UUID (Unique Universal Identifier). The
   * service generates this value when it creates the session template.
   * </pre>
   *
   * <code>string uuid = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uuid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUuidBytes() {
    java.lang.Object ref = uuid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uuid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCreateTime());
    }
    if (sessionConfigCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.dataproc.v1.JupyterConfig) sessionConfig_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(creator_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, creator_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 6);
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getRuntimeConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getEnvironmentConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, description_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(10, getUpdateTime());
    }
    if (sessionConfigCase_ == 11) {
      output.writeMessage(11, (com.google.cloud.dataproc.v1.SparkConnectConfig) sessionConfig_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uuid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, uuid_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (sessionConfigCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.dataproc.v1.JupyterConfig) sessionConfig_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(creator_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, creator_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, labels__);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getRuntimeConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getEnvironmentConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, description_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getUpdateTime());
    }
    if (sessionConfigCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.cloud.dataproc.v1.SparkConnectConfig) sessionConfig_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uuid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, uuid_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.SessionTemplate)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.SessionTemplate other =
        (com.google.cloud.dataproc.v1.SessionTemplate) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getCreator().equals(other.getCreator())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasRuntimeConfig() != other.hasRuntimeConfig()) return false;
    if (hasRuntimeConfig()) {
      if (!getRuntimeConfig().equals(other.getRuntimeConfig())) return false;
    }
    if (hasEnvironmentConfig() != other.hasEnvironmentConfig()) return false;
    if (hasEnvironmentConfig()) {
      if (!getEnvironmentConfig().equals(other.getEnvironmentConfig())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getUuid().equals(other.getUuid())) return false;
    if (!getSessionConfigCase().equals(other.getSessionConfigCase())) return false;
    switch (sessionConfigCase_) {
      case 3:
        if (!getJupyterSession().equals(other.getJupyterSession())) return false;
        break;
      case 11:
        if (!getSparkConnectSession().equals(other.getSparkConnectSession())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + CREATOR_FIELD_NUMBER;
    hash = (53 * hash) + getCreator().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasRuntimeConfig()) {
      hash = (37 * hash) + RUNTIME_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRuntimeConfig().hashCode();
    }
    if (hasEnvironmentConfig()) {
      hash = (37 * hash) + ENVIRONMENT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEnvironmentConfig().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + UUID_FIELD_NUMBER;
    hash = (53 * hash) + getUuid().hashCode();
    switch (sessionConfigCase_) {
      case 3:
        hash = (37 * hash) + JUPYTER_SESSION_FIELD_NUMBER;
        hash = (53 * hash) + getJupyterSession().hashCode();
        break;
      case 11:
        hash = (37 * hash) + SPARK_CONNECT_SESSION_FIELD_NUMBER;
        hash = (53 * hash) + getSparkConnectSession().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.SessionTemplate parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.SessionTemplate parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.SessionTemplate parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.SessionTemplate parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.SessionTemplate parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.SessionTemplate parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.SessionTemplate parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.SessionTemplate parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.SessionTemplate parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.SessionTemplate parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.SessionTemplate parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.SessionTemplate parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.SessionTemplate prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A representation of a session template.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.SessionTemplate}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.SessionTemplate)
      com.google.cloud.dataproc.v1.SessionTemplateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.SessionTemplatesProto
          .internal_static_google_cloud_dataproc_v1_SessionTemplate_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.SessionTemplatesProto
          .internal_static_google_cloud_dataproc_v1_SessionTemplate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.SessionTemplate.class,
              com.google.cloud.dataproc.v1.SessionTemplate.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.SessionTemplate.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getRuntimeConfigFieldBuilder();
        getEnvironmentConfigFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      if (jupyterSessionBuilder_ != null) {
        jupyterSessionBuilder_.clear();
      }
      if (sparkConnectSessionBuilder_ != null) {
        sparkConnectSessionBuilder_.clear();
      }
      creator_ = "";
      internalGetMutableLabels().clear();
      runtimeConfig_ = null;
      if (runtimeConfigBuilder_ != null) {
        runtimeConfigBuilder_.dispose();
        runtimeConfigBuilder_ = null;
      }
      environmentConfig_ = null;
      if (environmentConfigBuilder_ != null) {
        environmentConfigBuilder_.dispose();
        environmentConfigBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      uuid_ = "";
      sessionConfigCase_ = 0;
      sessionConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.SessionTemplatesProto
          .internal_static_google_cloud_dataproc_v1_SessionTemplate_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.SessionTemplate getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.SessionTemplate.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.SessionTemplate build() {
      com.google.cloud.dataproc.v1.SessionTemplate result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.SessionTemplate buildPartial() {
      com.google.cloud.dataproc.v1.SessionTemplate result =
          new com.google.cloud.dataproc.v1.SessionTemplate(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.SessionTemplate result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.creator_ = creator_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.runtimeConfig_ =
            runtimeConfigBuilder_ == null ? runtimeConfig_ : runtimeConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.environmentConfig_ =
            environmentConfigBuilder_ == null
                ? environmentConfig_
                : environmentConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.uuid_ = uuid_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.dataproc.v1.SessionTemplate result) {
      result.sessionConfigCase_ = sessionConfigCase_;
      result.sessionConfig_ = this.sessionConfig_;
      if (sessionConfigCase_ == 3 && jupyterSessionBuilder_ != null) {
        result.sessionConfig_ = jupyterSessionBuilder_.build();
      }
      if (sessionConfigCase_ == 11 && sparkConnectSessionBuilder_ != null) {
        result.sessionConfig_ = sparkConnectSessionBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.SessionTemplate) {
        return mergeFrom((com.google.cloud.dataproc.v1.SessionTemplate) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.SessionTemplate other) {
      if (other == com.google.cloud.dataproc.v1.SessionTemplate.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (!other.getCreator().isEmpty()) {
        creator_ = other.creator_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000040;
      if (other.hasRuntimeConfig()) {
        mergeRuntimeConfig(other.getRuntimeConfig());
      }
      if (other.hasEnvironmentConfig()) {
        mergeEnvironmentConfig(other.getEnvironmentConfig());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getUuid().isEmpty()) {
        uuid_ = other.uuid_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      switch (other.getSessionConfigCase()) {
        case JUPYTER_SESSION:
          {
            mergeJupyterSession(other.getJupyterSession());
            break;
          }
        case SPARK_CONNECT_SESSION:
          {
            mergeSparkConnectSession(other.getSparkConnectSession());
            break;
          }
        case SESSIONCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getJupyterSessionFieldBuilder().getBuilder(), extensionRegistry);
                sessionConfigCase_ = 3;
                break;
              } // case 26
            case 42:
              {
                creator_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getRuntimeConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(
                    getEnvironmentConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(
                    getSparkConnectSessionFieldBuilder().getBuilder(), extensionRegistry);
                sessionConfigCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                uuid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sessionConfigCase_ = 0;
    private java.lang.Object sessionConfig_;

    public SessionConfigCase getSessionConfigCase() {
      return SessionConfigCase.forNumber(sessionConfigCase_);
    }

    public Builder clearSessionConfig() {
      sessionConfigCase_ = 0;
      sessionConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the session template.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the session template.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the session template.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the session template.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the session template.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Brief description of the template.
     * </pre>
     *
     * <code>string description = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Brief description of the template.
     * </pre>
     *
     * <code>string description = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Brief description of the template.
     * </pre>
     *
     * <code>string description = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Brief description of the template.
     * </pre>
     *
     * <code>string description = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Brief description of the template.
     * </pre>
     *
     * <code>string description = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time when the template was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the template was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the template was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the template was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the template was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the template was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the template was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the template was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time when the template was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.JupyterConfig,
            com.google.cloud.dataproc.v1.JupyterConfig.Builder,
            com.google.cloud.dataproc.v1.JupyterConfigOrBuilder>
        jupyterSessionBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Jupyter session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the jupyterSession field is set.
     */
    @java.lang.Override
    public boolean hasJupyterSession() {
      return sessionConfigCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Optional. Jupyter session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The jupyterSession.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.JupyterConfig getJupyterSession() {
      if (jupyterSessionBuilder_ == null) {
        if (sessionConfigCase_ == 3) {
          return (com.google.cloud.dataproc.v1.JupyterConfig) sessionConfig_;
        }
        return com.google.cloud.dataproc.v1.JupyterConfig.getDefaultInstance();
      } else {
        if (sessionConfigCase_ == 3) {
          return jupyterSessionBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.JupyterConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Jupyter session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setJupyterSession(com.google.cloud.dataproc.v1.JupyterConfig value) {
      if (jupyterSessionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sessionConfig_ = value;
        onChanged();
      } else {
        jupyterSessionBuilder_.setMessage(value);
      }
      sessionConfigCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Jupyter session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setJupyterSession(
        com.google.cloud.dataproc.v1.JupyterConfig.Builder builderForValue) {
      if (jupyterSessionBuilder_ == null) {
        sessionConfig_ = builderForValue.build();
        onChanged();
      } else {
        jupyterSessionBuilder_.setMessage(builderForValue.build());
      }
      sessionConfigCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Jupyter session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeJupyterSession(com.google.cloud.dataproc.v1.JupyterConfig value) {
      if (jupyterSessionBuilder_ == null) {
        if (sessionConfigCase_ == 3
            && sessionConfig_ != com.google.cloud.dataproc.v1.JupyterConfig.getDefaultInstance()) {
          sessionConfig_ =
              com.google.cloud.dataproc.v1.JupyterConfig.newBuilder(
                      (com.google.cloud.dataproc.v1.JupyterConfig) sessionConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sessionConfig_ = value;
        }
        onChanged();
      } else {
        if (sessionConfigCase_ == 3) {
          jupyterSessionBuilder_.mergeFrom(value);
        } else {
          jupyterSessionBuilder_.setMessage(value);
        }
      }
      sessionConfigCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Jupyter session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearJupyterSession() {
      if (jupyterSessionBuilder_ == null) {
        if (sessionConfigCase_ == 3) {
          sessionConfigCase_ = 0;
          sessionConfig_ = null;
          onChanged();
        }
      } else {
        if (sessionConfigCase_ == 3) {
          sessionConfigCase_ = 0;
          sessionConfig_ = null;
        }
        jupyterSessionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Jupyter session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.JupyterConfig.Builder getJupyterSessionBuilder() {
      return getJupyterSessionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Jupyter session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.JupyterConfigOrBuilder getJupyterSessionOrBuilder() {
      if ((sessionConfigCase_ == 3) && (jupyterSessionBuilder_ != null)) {
        return jupyterSessionBuilder_.getMessageOrBuilder();
      } else {
        if (sessionConfigCase_ == 3) {
          return (com.google.cloud.dataproc.v1.JupyterConfig) sessionConfig_;
        }
        return com.google.cloud.dataproc.v1.JupyterConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Jupyter session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.JupyterConfig jupyter_session = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.JupyterConfig,
            com.google.cloud.dataproc.v1.JupyterConfig.Builder,
            com.google.cloud.dataproc.v1.JupyterConfigOrBuilder>
        getJupyterSessionFieldBuilder() {
      if (jupyterSessionBuilder_ == null) {
        if (!(sessionConfigCase_ == 3)) {
          sessionConfig_ = com.google.cloud.dataproc.v1.JupyterConfig.getDefaultInstance();
        }
        jupyterSessionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.JupyterConfig,
                com.google.cloud.dataproc.v1.JupyterConfig.Builder,
                com.google.cloud.dataproc.v1.JupyterConfigOrBuilder>(
                (com.google.cloud.dataproc.v1.JupyterConfig) sessionConfig_,
                getParentForChildren(),
                isClean());
        sessionConfig_ = null;
      }
      sessionConfigCase_ = 3;
      onChanged();
      return jupyterSessionBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.SparkConnectConfig,
            com.google.cloud.dataproc.v1.SparkConnectConfig.Builder,
            com.google.cloud.dataproc.v1.SparkConnectConfigOrBuilder>
        sparkConnectSessionBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Spark Connect session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the sparkConnectSession field is set.
     */
    @java.lang.Override
    public boolean hasSparkConnectSession() {
      return sessionConfigCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark Connect session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The sparkConnectSession.
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkConnectConfig getSparkConnectSession() {
      if (sparkConnectSessionBuilder_ == null) {
        if (sessionConfigCase_ == 11) {
          return (com.google.cloud.dataproc.v1.SparkConnectConfig) sessionConfig_;
        }
        return com.google.cloud.dataproc.v1.SparkConnectConfig.getDefaultInstance();
      } else {
        if (sessionConfigCase_ == 11) {
          return sparkConnectSessionBuilder_.getMessage();
        }
        return com.google.cloud.dataproc.v1.SparkConnectConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark Connect session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSparkConnectSession(com.google.cloud.dataproc.v1.SparkConnectConfig value) {
      if (sparkConnectSessionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sessionConfig_ = value;
        onChanged();
      } else {
        sparkConnectSessionBuilder_.setMessage(value);
      }
      sessionConfigCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark Connect session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSparkConnectSession(
        com.google.cloud.dataproc.v1.SparkConnectConfig.Builder builderForValue) {
      if (sparkConnectSessionBuilder_ == null) {
        sessionConfig_ = builderForValue.build();
        onChanged();
      } else {
        sparkConnectSessionBuilder_.setMessage(builderForValue.build());
      }
      sessionConfigCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark Connect session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSparkConnectSession(com.google.cloud.dataproc.v1.SparkConnectConfig value) {
      if (sparkConnectSessionBuilder_ == null) {
        if (sessionConfigCase_ == 11
            && sessionConfig_
                != com.google.cloud.dataproc.v1.SparkConnectConfig.getDefaultInstance()) {
          sessionConfig_ =
              com.google.cloud.dataproc.v1.SparkConnectConfig.newBuilder(
                      (com.google.cloud.dataproc.v1.SparkConnectConfig) sessionConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sessionConfig_ = value;
        }
        onChanged();
      } else {
        if (sessionConfigCase_ == 11) {
          sparkConnectSessionBuilder_.mergeFrom(value);
        } else {
          sparkConnectSessionBuilder_.setMessage(value);
        }
      }
      sessionConfigCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark Connect session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSparkConnectSession() {
      if (sparkConnectSessionBuilder_ == null) {
        if (sessionConfigCase_ == 11) {
          sessionConfigCase_ = 0;
          sessionConfig_ = null;
          onChanged();
        }
      } else {
        if (sessionConfigCase_ == 11) {
          sessionConfigCase_ = 0;
          sessionConfig_ = null;
        }
        sparkConnectSessionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark Connect session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.SparkConnectConfig.Builder getSparkConnectSessionBuilder() {
      return getSparkConnectSessionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark Connect session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkConnectConfigOrBuilder
        getSparkConnectSessionOrBuilder() {
      if ((sessionConfigCase_ == 11) && (sparkConnectSessionBuilder_ != null)) {
        return sparkConnectSessionBuilder_.getMessageOrBuilder();
      } else {
        if (sessionConfigCase_ == 11) {
          return (com.google.cloud.dataproc.v1.SparkConnectConfig) sessionConfig_;
        }
        return com.google.cloud.dataproc.v1.SparkConnectConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Spark Connect session config.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.SparkConnectConfig spark_connect_session = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.SparkConnectConfig,
            com.google.cloud.dataproc.v1.SparkConnectConfig.Builder,
            com.google.cloud.dataproc.v1.SparkConnectConfigOrBuilder>
        getSparkConnectSessionFieldBuilder() {
      if (sparkConnectSessionBuilder_ == null) {
        if (!(sessionConfigCase_ == 11)) {
          sessionConfig_ = com.google.cloud.dataproc.v1.SparkConnectConfig.getDefaultInstance();
        }
        sparkConnectSessionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.SparkConnectConfig,
                com.google.cloud.dataproc.v1.SparkConnectConfig.Builder,
                com.google.cloud.dataproc.v1.SparkConnectConfigOrBuilder>(
                (com.google.cloud.dataproc.v1.SparkConnectConfig) sessionConfig_,
                getParentForChildren(),
                isClean());
        sessionConfig_ = null;
      }
      sessionConfigCase_ = 11;
      onChanged();
      return sparkConnectSessionBuilder_;
    }

    private java.lang.Object creator_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The email address of the user who created the template.
     * </pre>
     *
     * <code>string creator = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The creator.
     */
    public java.lang.String getCreator() {
      java.lang.Object ref = creator_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creator_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The email address of the user who created the template.
     * </pre>
     *
     * <code>string creator = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for creator.
     */
    public com.google.protobuf.ByteString getCreatorBytes() {
      java.lang.Object ref = creator_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creator_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The email address of the user who created the template.
     * </pre>
     *
     * <code>string creator = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The creator to set.
     * @return This builder for chaining.
     */
    public Builder setCreator(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creator_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The email address of the user who created the template.
     * </pre>
     *
     * <code>string creator = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreator() {
      creator_ = getDefaultInstance().getCreator();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The email address of the user who created the template.
     * </pre>
     *
     * <code>string creator = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for creator to set.
     * @return This builder for chaining.
     */
    public Builder setCreatorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creator_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels to associate with sessions created using this template.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** can be empty, but, if present, must contain 1 to 63
     * characters and conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a session.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels to associate with sessions created using this template.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** can be empty, but, if present, must contain 1 to 63
     * characters and conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a session.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels to associate with sessions created using this template.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** can be empty, but, if present, must contain 1 to 63
     * characters and conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a session.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels to associate with sessions created using this template.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** can be empty, but, if present, must contain 1 to 63
     * characters and conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a session.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels to associate with sessions created using this template.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** can be empty, but, if present, must contain 1 to 63
     * characters and conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a session.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels to associate with sessions created using this template.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** can be empty, but, if present, must contain 1 to 63
     * characters and conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a session.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels to associate with sessions created using this template.
     * Label **keys** must contain 1 to 63 characters, and must conform to
     * [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
     * Label **values** can be empty, but, if present, must contain 1 to 63
     * characters and conform to [RFC
     * 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
     * associated with a session.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private com.google.cloud.dataproc.v1.RuntimeConfig runtimeConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.RuntimeConfig,
            com.google.cloud.dataproc.v1.RuntimeConfig.Builder,
            com.google.cloud.dataproc.v1.RuntimeConfigOrBuilder>
        runtimeConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the runtimeConfig field is set.
     */
    public boolean hasRuntimeConfig() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The runtimeConfig.
     */
    public com.google.cloud.dataproc.v1.RuntimeConfig getRuntimeConfig() {
      if (runtimeConfigBuilder_ == null) {
        return runtimeConfig_ == null
            ? com.google.cloud.dataproc.v1.RuntimeConfig.getDefaultInstance()
            : runtimeConfig_;
      } else {
        return runtimeConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRuntimeConfig(com.google.cloud.dataproc.v1.RuntimeConfig value) {
      if (runtimeConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        runtimeConfig_ = value;
      } else {
        runtimeConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRuntimeConfig(
        com.google.cloud.dataproc.v1.RuntimeConfig.Builder builderForValue) {
      if (runtimeConfigBuilder_ == null) {
        runtimeConfig_ = builderForValue.build();
      } else {
        runtimeConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRuntimeConfig(com.google.cloud.dataproc.v1.RuntimeConfig value) {
      if (runtimeConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && runtimeConfig_ != null
            && runtimeConfig_ != com.google.cloud.dataproc.v1.RuntimeConfig.getDefaultInstance()) {
          getRuntimeConfigBuilder().mergeFrom(value);
        } else {
          runtimeConfig_ = value;
        }
      } else {
        runtimeConfigBuilder_.mergeFrom(value);
      }
      if (runtimeConfig_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRuntimeConfig() {
      bitField0_ = (bitField0_ & ~0x00000080);
      runtimeConfig_ = null;
      if (runtimeConfigBuilder_ != null) {
        runtimeConfigBuilder_.dispose();
        runtimeConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.RuntimeConfig.Builder getRuntimeConfigBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getRuntimeConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.RuntimeConfigOrBuilder getRuntimeConfigOrBuilder() {
      if (runtimeConfigBuilder_ != null) {
        return runtimeConfigBuilder_.getMessageOrBuilder();
      } else {
        return runtimeConfig_ == null
            ? com.google.cloud.dataproc.v1.RuntimeConfig.getDefaultInstance()
            : runtimeConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Runtime configuration for session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.RuntimeConfig runtime_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.RuntimeConfig,
            com.google.cloud.dataproc.v1.RuntimeConfig.Builder,
            com.google.cloud.dataproc.v1.RuntimeConfigOrBuilder>
        getRuntimeConfigFieldBuilder() {
      if (runtimeConfigBuilder_ == null) {
        runtimeConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.RuntimeConfig,
                com.google.cloud.dataproc.v1.RuntimeConfig.Builder,
                com.google.cloud.dataproc.v1.RuntimeConfigOrBuilder>(
                getRuntimeConfig(), getParentForChildren(), isClean());
        runtimeConfig_ = null;
      }
      return runtimeConfigBuilder_;
    }

    private com.google.cloud.dataproc.v1.EnvironmentConfig environmentConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.EnvironmentConfig,
            com.google.cloud.dataproc.v1.EnvironmentConfig.Builder,
            com.google.cloud.dataproc.v1.EnvironmentConfigOrBuilder>
        environmentConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the environmentConfig field is set.
     */
    public boolean hasEnvironmentConfig() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The environmentConfig.
     */
    public com.google.cloud.dataproc.v1.EnvironmentConfig getEnvironmentConfig() {
      if (environmentConfigBuilder_ == null) {
        return environmentConfig_ == null
            ? com.google.cloud.dataproc.v1.EnvironmentConfig.getDefaultInstance()
            : environmentConfig_;
      } else {
        return environmentConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEnvironmentConfig(com.google.cloud.dataproc.v1.EnvironmentConfig value) {
      if (environmentConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        environmentConfig_ = value;
      } else {
        environmentConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEnvironmentConfig(
        com.google.cloud.dataproc.v1.EnvironmentConfig.Builder builderForValue) {
      if (environmentConfigBuilder_ == null) {
        environmentConfig_ = builderForValue.build();
      } else {
        environmentConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEnvironmentConfig(com.google.cloud.dataproc.v1.EnvironmentConfig value) {
      if (environmentConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && environmentConfig_ != null
            && environmentConfig_
                != com.google.cloud.dataproc.v1.EnvironmentConfig.getDefaultInstance()) {
          getEnvironmentConfigBuilder().mergeFrom(value);
        } else {
          environmentConfig_ = value;
        }
      } else {
        environmentConfigBuilder_.mergeFrom(value);
      }
      if (environmentConfig_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEnvironmentConfig() {
      bitField0_ = (bitField0_ & ~0x00000100);
      environmentConfig_ = null;
      if (environmentConfigBuilder_ != null) {
        environmentConfigBuilder_.dispose();
        environmentConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.EnvironmentConfig.Builder getEnvironmentConfigBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getEnvironmentConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.dataproc.v1.EnvironmentConfigOrBuilder getEnvironmentConfigOrBuilder() {
      if (environmentConfigBuilder_ != null) {
        return environmentConfigBuilder_.getMessageOrBuilder();
      } else {
        return environmentConfig_ == null
            ? com.google.cloud.dataproc.v1.EnvironmentConfig.getDefaultInstance()
            : environmentConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Environment configuration for session execution.
     * </pre>
     *
     * <code>
     * .google.cloud.dataproc.v1.EnvironmentConfig environment_config = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.dataproc.v1.EnvironmentConfig,
            com.google.cloud.dataproc.v1.EnvironmentConfig.Builder,
            com.google.cloud.dataproc.v1.EnvironmentConfigOrBuilder>
        getEnvironmentConfigFieldBuilder() {
      if (environmentConfigBuilder_ == null) {
        environmentConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.dataproc.v1.EnvironmentConfig,
                com.google.cloud.dataproc.v1.EnvironmentConfig.Builder,
                com.google.cloud.dataproc.v1.EnvironmentConfigOrBuilder>(
                getEnvironmentConfig(), getParentForChildren(), isClean());
        environmentConfig_ = null;
      }
      return environmentConfigBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time the template was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the template was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the template was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the template was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the template was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the template was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the template was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the template was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time the template was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object uuid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. A session template UUID (Unique Universal Identifier). The
     * service generates this value when it creates the session template.
     * </pre>
     *
     * <code>string uuid = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uuid.
     */
    public java.lang.String getUuid() {
      java.lang.Object ref = uuid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uuid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A session template UUID (Unique Universal Identifier). The
     * service generates this value when it creates the session template.
     * </pre>
     *
     * <code>string uuid = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uuid.
     */
    public com.google.protobuf.ByteString getUuidBytes() {
      java.lang.Object ref = uuid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uuid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A session template UUID (Unique Universal Identifier). The
     * service generates this value when it creates the session template.
     * </pre>
     *
     * <code>string uuid = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uuid to set.
     * @return This builder for chaining.
     */
    public Builder setUuid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uuid_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A session template UUID (Unique Universal Identifier). The
     * service generates this value when it creates the session template.
     * </pre>
     *
     * <code>string uuid = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUuid() {
      uuid_ = getDefaultInstance().getUuid();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A session template UUID (Unique Universal Identifier). The
     * service generates this value when it creates the session template.
     * </pre>
     *
     * <code>string uuid = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uuid to set.
     * @return This builder for chaining.
     */
    public Builder setUuidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uuid_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.SessionTemplate)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.SessionTemplate)
  private static final com.google.cloud.dataproc.v1.SessionTemplate DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.SessionTemplate();
  }

  public static com.google.cloud.dataproc.v1.SessionTemplate getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SessionTemplate> PARSER =
      new com.google.protobuf.AbstractParser<SessionTemplate>() {
        @java.lang.Override
        public SessionTemplate parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SessionTemplate> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SessionTemplate> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.SessionTemplate getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
