/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/batches.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * A configuration for running an [Apache Spark](https://spark.apache.org/)
 * batch workload.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.SparkBatch}
 */
public final class SparkBatch extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.SparkBatch)
    SparkBatchOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SparkBatch.newBuilder() to construct.
  private SparkBatch(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SparkBatch() {
    args_ = com.google.protobuf.LazyStringArrayList.emptyList();
    jarFileUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
    fileUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
    archiveUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SparkBatch();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.BatchesProto
        .internal_static_google_cloud_dataproc_v1_SparkBatch_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.BatchesProto
        .internal_static_google_cloud_dataproc_v1_SparkBatch_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.SparkBatch.class,
            com.google.cloud.dataproc.v1.SparkBatch.Builder.class);
  }

  private int driverCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object driver_;

  public enum DriverCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    MAIN_JAR_FILE_URI(1),
    MAIN_CLASS(2),
    DRIVER_NOT_SET(0);
    private final int value;

    private DriverCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DriverCase valueOf(int value) {
      return forNumber(value);
    }

    public static DriverCase forNumber(int value) {
      switch (value) {
        case 1:
          return MAIN_JAR_FILE_URI;
        case 2:
          return MAIN_CLASS;
        case 0:
          return DRIVER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DriverCase getDriverCase() {
    return DriverCase.forNumber(driverCase_);
  }

  public static final int MAIN_JAR_FILE_URI_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Optional. The HCFS URI of the jar file that contains the main class.
   * </pre>
   *
   * <code>string main_jar_file_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the mainJarFileUri field is set.
   */
  public boolean hasMainJarFileUri() {
    return driverCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Optional. The HCFS URI of the jar file that contains the main class.
   * </pre>
   *
   * <code>string main_jar_file_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The mainJarFileUri.
   */
  public java.lang.String getMainJarFileUri() {
    java.lang.Object ref = "";
    if (driverCase_ == 1) {
      ref = driver_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (driverCase_ == 1) {
        driver_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The HCFS URI of the jar file that contains the main class.
   * </pre>
   *
   * <code>string main_jar_file_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for mainJarFileUri.
   */
  public com.google.protobuf.ByteString getMainJarFileUriBytes() {
    java.lang.Object ref = "";
    if (driverCase_ == 1) {
      ref = driver_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (driverCase_ == 1) {
        driver_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAIN_CLASS_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Optional. The name of the driver main class. The jar file that contains
   * the class must be in the classpath or specified in `jar_file_uris`.
   * </pre>
   *
   * <code>string main_class = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the mainClass field is set.
   */
  public boolean hasMainClass() {
    return driverCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of the driver main class. The jar file that contains
   * the class must be in the classpath or specified in `jar_file_uris`.
   * </pre>
   *
   * <code>string main_class = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The mainClass.
   */
  public java.lang.String getMainClass() {
    java.lang.Object ref = "";
    if (driverCase_ == 2) {
      ref = driver_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (driverCase_ == 2) {
        driver_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of the driver main class. The jar file that contains
   * the class must be in the classpath or specified in `jar_file_uris`.
   * </pre>
   *
   * <code>string main_class = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for mainClass.
   */
  public com.google.protobuf.ByteString getMainClassBytes() {
    java.lang.Object ref = "";
    if (driverCase_ == 2) {
      ref = driver_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (driverCase_ == 2) {
        driver_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ARGS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList args_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. The arguments to pass to the driver. Do not include arguments
   * that can be set as batch properties, such as `--conf`, since a collision
   * can occur that causes an incorrect batch submission.
   * </pre>
   *
   * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the args.
   */
  public com.google.protobuf.ProtocolStringList getArgsList() {
    return args_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The arguments to pass to the driver. Do not include arguments
   * that can be set as batch properties, such as `--conf`, since a collision
   * can occur that causes an incorrect batch submission.
   * </pre>
   *
   * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of args.
   */
  public int getArgsCount() {
    return args_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The arguments to pass to the driver. Do not include arguments
   * that can be set as batch properties, such as `--conf`, since a collision
   * can occur that causes an incorrect batch submission.
   * </pre>
   *
   * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The args at the given index.
   */
  public java.lang.String getArgs(int index) {
    return args_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The arguments to pass to the driver. Do not include arguments
   * that can be set as batch properties, such as `--conf`, since a collision
   * can occur that causes an incorrect batch submission.
   * </pre>
   *
   * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the args at the given index.
   */
  public com.google.protobuf.ByteString getArgsBytes(int index) {
    return args_.getByteString(index);
  }

  public static final int JAR_FILE_URIS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList jarFileUris_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of jar files to add to the classpath of the
   * Spark driver and tasks.
   * </pre>
   *
   * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the jarFileUris.
   */
  public com.google.protobuf.ProtocolStringList getJarFileUrisList() {
    return jarFileUris_;
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of jar files to add to the classpath of the
   * Spark driver and tasks.
   * </pre>
   *
   * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of jarFileUris.
   */
  public int getJarFileUrisCount() {
    return jarFileUris_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of jar files to add to the classpath of the
   * Spark driver and tasks.
   * </pre>
   *
   * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The jarFileUris at the given index.
   */
  public java.lang.String getJarFileUris(int index) {
    return jarFileUris_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of jar files to add to the classpath of the
   * Spark driver and tasks.
   * </pre>
   *
   * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the jarFileUris at the given index.
   */
  public com.google.protobuf.ByteString getJarFileUrisBytes(int index) {
    return jarFileUris_.getByteString(index);
  }

  public static final int FILE_URIS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList fileUris_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of files to be placed in the working directory of
   * each executor.
   * </pre>
   *
   * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the fileUris.
   */
  public com.google.protobuf.ProtocolStringList getFileUrisList() {
    return fileUris_;
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of files to be placed in the working directory of
   * each executor.
   * </pre>
   *
   * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of fileUris.
   */
  public int getFileUrisCount() {
    return fileUris_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of files to be placed in the working directory of
   * each executor.
   * </pre>
   *
   * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The fileUris at the given index.
   */
  public java.lang.String getFileUris(int index) {
    return fileUris_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of files to be placed in the working directory of
   * each executor.
   * </pre>
   *
   * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the fileUris at the given index.
   */
  public com.google.protobuf.ByteString getFileUrisBytes(int index) {
    return fileUris_.getByteString(index);
  }

  public static final int ARCHIVE_URIS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList archiveUris_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of archives to be extracted into the working directory
   * of each executor. Supported file types:
   * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
   * </pre>
   *
   * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the archiveUris.
   */
  public com.google.protobuf.ProtocolStringList getArchiveUrisList() {
    return archiveUris_;
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of archives to be extracted into the working directory
   * of each executor. Supported file types:
   * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
   * </pre>
   *
   * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of archiveUris.
   */
  public int getArchiveUrisCount() {
    return archiveUris_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of archives to be extracted into the working directory
   * of each executor. Supported file types:
   * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
   * </pre>
   *
   * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The archiveUris at the given index.
   */
  public java.lang.String getArchiveUris(int index) {
    return archiveUris_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. HCFS URIs of archives to be extracted into the working directory
   * of each executor. Supported file types:
   * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
   * </pre>
   *
   * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the archiveUris at the given index.
   */
  public com.google.protobuf.ByteString getArchiveUrisBytes(int index) {
    return archiveUris_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (driverCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, driver_);
    }
    if (driverCase_ == 2) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, driver_);
    }
    for (int i = 0; i < args_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, args_.getRaw(i));
    }
    for (int i = 0; i < jarFileUris_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, jarFileUris_.getRaw(i));
    }
    for (int i = 0; i < fileUris_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, fileUris_.getRaw(i));
    }
    for (int i = 0; i < archiveUris_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, archiveUris_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (driverCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, driver_);
    }
    if (driverCase_ == 2) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, driver_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < args_.size(); i++) {
        dataSize += computeStringSizeNoTag(args_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getArgsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < jarFileUris_.size(); i++) {
        dataSize += computeStringSizeNoTag(jarFileUris_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getJarFileUrisList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < fileUris_.size(); i++) {
        dataSize += computeStringSizeNoTag(fileUris_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFileUrisList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < archiveUris_.size(); i++) {
        dataSize += computeStringSizeNoTag(archiveUris_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getArchiveUrisList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.SparkBatch)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.SparkBatch other = (com.google.cloud.dataproc.v1.SparkBatch) obj;

    if (!getArgsList().equals(other.getArgsList())) return false;
    if (!getJarFileUrisList().equals(other.getJarFileUrisList())) return false;
    if (!getFileUrisList().equals(other.getFileUrisList())) return false;
    if (!getArchiveUrisList().equals(other.getArchiveUrisList())) return false;
    if (!getDriverCase().equals(other.getDriverCase())) return false;
    switch (driverCase_) {
      case 1:
        if (!getMainJarFileUri().equals(other.getMainJarFileUri())) return false;
        break;
      case 2:
        if (!getMainClass().equals(other.getMainClass())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getArgsCount() > 0) {
      hash = (37 * hash) + ARGS_FIELD_NUMBER;
      hash = (53 * hash) + getArgsList().hashCode();
    }
    if (getJarFileUrisCount() > 0) {
      hash = (37 * hash) + JAR_FILE_URIS_FIELD_NUMBER;
      hash = (53 * hash) + getJarFileUrisList().hashCode();
    }
    if (getFileUrisCount() > 0) {
      hash = (37 * hash) + FILE_URIS_FIELD_NUMBER;
      hash = (53 * hash) + getFileUrisList().hashCode();
    }
    if (getArchiveUrisCount() > 0) {
      hash = (37 * hash) + ARCHIVE_URIS_FIELD_NUMBER;
      hash = (53 * hash) + getArchiveUrisList().hashCode();
    }
    switch (driverCase_) {
      case 1:
        hash = (37 * hash) + MAIN_JAR_FILE_URI_FIELD_NUMBER;
        hash = (53 * hash) + getMainJarFileUri().hashCode();
        break;
      case 2:
        hash = (37 * hash) + MAIN_CLASS_FIELD_NUMBER;
        hash = (53 * hash) + getMainClass().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.SparkBatch parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.SparkBatch parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.SparkBatch parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.SparkBatch parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.SparkBatch parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.SparkBatch parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.SparkBatch parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.SparkBatch parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.SparkBatch parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.SparkBatch parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.SparkBatch parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.SparkBatch parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.SparkBatch prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A configuration for running an [Apache Spark](https://spark.apache.org/)
   * batch workload.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.SparkBatch}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.SparkBatch)
      com.google.cloud.dataproc.v1.SparkBatchOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.BatchesProto
          .internal_static_google_cloud_dataproc_v1_SparkBatch_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.BatchesProto
          .internal_static_google_cloud_dataproc_v1_SparkBatch_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.SparkBatch.class,
              com.google.cloud.dataproc.v1.SparkBatch.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.SparkBatch.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      args_ = com.google.protobuf.LazyStringArrayList.emptyList();
      jarFileUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      fileUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      archiveUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      driverCase_ = 0;
      driver_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.BatchesProto
          .internal_static_google_cloud_dataproc_v1_SparkBatch_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkBatch getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.SparkBatch.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkBatch build() {
      com.google.cloud.dataproc.v1.SparkBatch result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.SparkBatch buildPartial() {
      com.google.cloud.dataproc.v1.SparkBatch result =
          new com.google.cloud.dataproc.v1.SparkBatch(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.SparkBatch result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        args_.makeImmutable();
        result.args_ = args_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        jarFileUris_.makeImmutable();
        result.jarFileUris_ = jarFileUris_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        fileUris_.makeImmutable();
        result.fileUris_ = fileUris_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        archiveUris_.makeImmutable();
        result.archiveUris_ = archiveUris_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.dataproc.v1.SparkBatch result) {
      result.driverCase_ = driverCase_;
      result.driver_ = this.driver_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.SparkBatch) {
        return mergeFrom((com.google.cloud.dataproc.v1.SparkBatch) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.SparkBatch other) {
      if (other == com.google.cloud.dataproc.v1.SparkBatch.getDefaultInstance()) return this;
      if (!other.args_.isEmpty()) {
        if (args_.isEmpty()) {
          args_ = other.args_;
          bitField0_ |= 0x00000004;
        } else {
          ensureArgsIsMutable();
          args_.addAll(other.args_);
        }
        onChanged();
      }
      if (!other.jarFileUris_.isEmpty()) {
        if (jarFileUris_.isEmpty()) {
          jarFileUris_ = other.jarFileUris_;
          bitField0_ |= 0x00000008;
        } else {
          ensureJarFileUrisIsMutable();
          jarFileUris_.addAll(other.jarFileUris_);
        }
        onChanged();
      }
      if (!other.fileUris_.isEmpty()) {
        if (fileUris_.isEmpty()) {
          fileUris_ = other.fileUris_;
          bitField0_ |= 0x00000010;
        } else {
          ensureFileUrisIsMutable();
          fileUris_.addAll(other.fileUris_);
        }
        onChanged();
      }
      if (!other.archiveUris_.isEmpty()) {
        if (archiveUris_.isEmpty()) {
          archiveUris_ = other.archiveUris_;
          bitField0_ |= 0x00000020;
        } else {
          ensureArchiveUrisIsMutable();
          archiveUris_.addAll(other.archiveUris_);
        }
        onChanged();
      }
      switch (other.getDriverCase()) {
        case MAIN_JAR_FILE_URI:
          {
            driverCase_ = 1;
            driver_ = other.driver_;
            onChanged();
            break;
          }
        case MAIN_CLASS:
          {
            driverCase_ = 2;
            driver_ = other.driver_;
            onChanged();
            break;
          }
        case DRIVER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                driverCase_ = 1;
                driver_ = s;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                driverCase_ = 2;
                driver_ = s;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureArgsIsMutable();
                args_.add(s);
                break;
              } // case 26
            case 34:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureJarFileUrisIsMutable();
                jarFileUris_.add(s);
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureFileUrisIsMutable();
                fileUris_.add(s);
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureArchiveUrisIsMutable();
                archiveUris_.add(s);
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int driverCase_ = 0;
    private java.lang.Object driver_;

    public DriverCase getDriverCase() {
      return DriverCase.forNumber(driverCase_);
    }

    public Builder clearDriver() {
      driverCase_ = 0;
      driver_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Optional. The HCFS URI of the jar file that contains the main class.
     * </pre>
     *
     * <code>string main_jar_file_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the mainJarFileUri field is set.
     */
    @java.lang.Override
    public boolean hasMainJarFileUri() {
      return driverCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Optional. The HCFS URI of the jar file that contains the main class.
     * </pre>
     *
     * <code>string main_jar_file_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The mainJarFileUri.
     */
    @java.lang.Override
    public java.lang.String getMainJarFileUri() {
      java.lang.Object ref = "";
      if (driverCase_ == 1) {
        ref = driver_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (driverCase_ == 1) {
          driver_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The HCFS URI of the jar file that contains the main class.
     * </pre>
     *
     * <code>string main_jar_file_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for mainJarFileUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMainJarFileUriBytes() {
      java.lang.Object ref = "";
      if (driverCase_ == 1) {
        ref = driver_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (driverCase_ == 1) {
          driver_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The HCFS URI of the jar file that contains the main class.
     * </pre>
     *
     * <code>string main_jar_file_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The mainJarFileUri to set.
     * @return This builder for chaining.
     */
    public Builder setMainJarFileUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      driverCase_ = 1;
      driver_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The HCFS URI of the jar file that contains the main class.
     * </pre>
     *
     * <code>string main_jar_file_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMainJarFileUri() {
      if (driverCase_ == 1) {
        driverCase_ = 0;
        driver_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The HCFS URI of the jar file that contains the main class.
     * </pre>
     *
     * <code>string main_jar_file_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for mainJarFileUri to set.
     * @return This builder for chaining.
     */
    public Builder setMainJarFileUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      driverCase_ = 1;
      driver_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The name of the driver main class. The jar file that contains
     * the class must be in the classpath or specified in `jar_file_uris`.
     * </pre>
     *
     * <code>string main_class = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the mainClass field is set.
     */
    @java.lang.Override
    public boolean hasMainClass() {
      return driverCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the driver main class. The jar file that contains
     * the class must be in the classpath or specified in `jar_file_uris`.
     * </pre>
     *
     * <code>string main_class = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The mainClass.
     */
    @java.lang.Override
    public java.lang.String getMainClass() {
      java.lang.Object ref = "";
      if (driverCase_ == 2) {
        ref = driver_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (driverCase_ == 2) {
          driver_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the driver main class. The jar file that contains
     * the class must be in the classpath or specified in `jar_file_uris`.
     * </pre>
     *
     * <code>string main_class = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for mainClass.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMainClassBytes() {
      java.lang.Object ref = "";
      if (driverCase_ == 2) {
        ref = driver_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (driverCase_ == 2) {
          driver_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the driver main class. The jar file that contains
     * the class must be in the classpath or specified in `jar_file_uris`.
     * </pre>
     *
     * <code>string main_class = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The mainClass to set.
     * @return This builder for chaining.
     */
    public Builder setMainClass(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      driverCase_ = 2;
      driver_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the driver main class. The jar file that contains
     * the class must be in the classpath or specified in `jar_file_uris`.
     * </pre>
     *
     * <code>string main_class = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMainClass() {
      if (driverCase_ == 2) {
        driverCase_ = 0;
        driver_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the driver main class. The jar file that contains
     * the class must be in the classpath or specified in `jar_file_uris`.
     * </pre>
     *
     * <code>string main_class = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for mainClass to set.
     * @return This builder for chaining.
     */
    public Builder setMainClassBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      driverCase_ = 2;
      driver_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList args_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureArgsIsMutable() {
      if (!args_.isModifiable()) {
        args_ = new com.google.protobuf.LazyStringArrayList(args_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the args.
     */
    public com.google.protobuf.ProtocolStringList getArgsList() {
      args_.makeImmutable();
      return args_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of args.
     */
    public int getArgsCount() {
      return args_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The args at the given index.
     */
    public java.lang.String getArgs(int index) {
      return args_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the args at the given index.
     */
    public com.google.protobuf.ByteString getArgsBytes(int index) {
      return args_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The args to set.
     * @return This builder for chaining.
     */
    public Builder setArgs(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The args to add.
     * @return This builder for chaining.
     */
    public Builder addArgs(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The args to add.
     * @return This builder for chaining.
     */
    public Builder addAllArgs(java.lang.Iterable<java.lang.String> values) {
      ensureArgsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, args_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArgs() {
      args_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The arguments to pass to the driver. Do not include arguments
     * that can be set as batch properties, such as `--conf`, since a collision
     * can occur that causes an incorrect batch submission.
     * </pre>
     *
     * <code>repeated string args = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the args to add.
     * @return This builder for chaining.
     */
    public Builder addArgsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureArgsIsMutable();
      args_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList jarFileUris_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureJarFileUrisIsMutable() {
      if (!jarFileUris_.isModifiable()) {
        jarFileUris_ = new com.google.protobuf.LazyStringArrayList(jarFileUris_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of jar files to add to the classpath of the
     * Spark driver and tasks.
     * </pre>
     *
     * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the jarFileUris.
     */
    public com.google.protobuf.ProtocolStringList getJarFileUrisList() {
      jarFileUris_.makeImmutable();
      return jarFileUris_;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of jar files to add to the classpath of the
     * Spark driver and tasks.
     * </pre>
     *
     * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of jarFileUris.
     */
    public int getJarFileUrisCount() {
      return jarFileUris_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of jar files to add to the classpath of the
     * Spark driver and tasks.
     * </pre>
     *
     * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The jarFileUris at the given index.
     */
    public java.lang.String getJarFileUris(int index) {
      return jarFileUris_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of jar files to add to the classpath of the
     * Spark driver and tasks.
     * </pre>
     *
     * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the jarFileUris at the given index.
     */
    public com.google.protobuf.ByteString getJarFileUrisBytes(int index) {
      return jarFileUris_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of jar files to add to the classpath of the
     * Spark driver and tasks.
     * </pre>
     *
     * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The jarFileUris to set.
     * @return This builder for chaining.
     */
    public Builder setJarFileUris(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureJarFileUrisIsMutable();
      jarFileUris_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of jar files to add to the classpath of the
     * Spark driver and tasks.
     * </pre>
     *
     * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The jarFileUris to add.
     * @return This builder for chaining.
     */
    public Builder addJarFileUris(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureJarFileUrisIsMutable();
      jarFileUris_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of jar files to add to the classpath of the
     * Spark driver and tasks.
     * </pre>
     *
     * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The jarFileUris to add.
     * @return This builder for chaining.
     */
    public Builder addAllJarFileUris(java.lang.Iterable<java.lang.String> values) {
      ensureJarFileUrisIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, jarFileUris_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of jar files to add to the classpath of the
     * Spark driver and tasks.
     * </pre>
     *
     * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJarFileUris() {
      jarFileUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of jar files to add to the classpath of the
     * Spark driver and tasks.
     * </pre>
     *
     * <code>repeated string jar_file_uris = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the jarFileUris to add.
     * @return This builder for chaining.
     */
    public Builder addJarFileUrisBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureJarFileUrisIsMutable();
      jarFileUris_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList fileUris_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureFileUrisIsMutable() {
      if (!fileUris_.isModifiable()) {
        fileUris_ = new com.google.protobuf.LazyStringArrayList(fileUris_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     * </pre>
     *
     * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the fileUris.
     */
    public com.google.protobuf.ProtocolStringList getFileUrisList() {
      fileUris_.makeImmutable();
      return fileUris_;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     * </pre>
     *
     * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of fileUris.
     */
    public int getFileUrisCount() {
      return fileUris_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     * </pre>
     *
     * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The fileUris at the given index.
     */
    public java.lang.String getFileUris(int index) {
      return fileUris_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     * </pre>
     *
     * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the fileUris at the given index.
     */
    public com.google.protobuf.ByteString getFileUrisBytes(int index) {
      return fileUris_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     * </pre>
     *
     * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The fileUris to set.
     * @return This builder for chaining.
     */
    public Builder setFileUris(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFileUrisIsMutable();
      fileUris_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     * </pre>
     *
     * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The fileUris to add.
     * @return This builder for chaining.
     */
    public Builder addFileUris(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFileUrisIsMutable();
      fileUris_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     * </pre>
     *
     * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The fileUris to add.
     * @return This builder for chaining.
     */
    public Builder addAllFileUris(java.lang.Iterable<java.lang.String> values) {
      ensureFileUrisIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fileUris_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     * </pre>
     *
     * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFileUris() {
      fileUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of files to be placed in the working directory of
     * each executor.
     * </pre>
     *
     * <code>repeated string file_uris = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the fileUris to add.
     * @return This builder for chaining.
     */
    public Builder addFileUrisBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureFileUrisIsMutable();
      fileUris_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList archiveUris_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureArchiveUrisIsMutable() {
      if (!archiveUris_.isModifiable()) {
        archiveUris_ = new com.google.protobuf.LazyStringArrayList(archiveUris_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     * </pre>
     *
     * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the archiveUris.
     */
    public com.google.protobuf.ProtocolStringList getArchiveUrisList() {
      archiveUris_.makeImmutable();
      return archiveUris_;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     * </pre>
     *
     * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of archiveUris.
     */
    public int getArchiveUrisCount() {
      return archiveUris_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     * </pre>
     *
     * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The archiveUris at the given index.
     */
    public java.lang.String getArchiveUris(int index) {
      return archiveUris_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     * </pre>
     *
     * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the archiveUris at the given index.
     */
    public com.google.protobuf.ByteString getArchiveUrisBytes(int index) {
      return archiveUris_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     * </pre>
     *
     * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The archiveUris to set.
     * @return This builder for chaining.
     */
    public Builder setArchiveUris(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArchiveUrisIsMutable();
      archiveUris_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     * </pre>
     *
     * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The archiveUris to add.
     * @return This builder for chaining.
     */
    public Builder addArchiveUris(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArchiveUrisIsMutable();
      archiveUris_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     * </pre>
     *
     * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The archiveUris to add.
     * @return This builder for chaining.
     */
    public Builder addAllArchiveUris(java.lang.Iterable<java.lang.String> values) {
      ensureArchiveUrisIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, archiveUris_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     * </pre>
     *
     * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArchiveUris() {
      archiveUris_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. HCFS URIs of archives to be extracted into the working directory
     * of each executor. Supported file types:
     * `.jar`, `.tar`, `.tar.gz`, `.tgz`, and `.zip`.
     * </pre>
     *
     * <code>repeated string archive_uris = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the archiveUris to add.
     * @return This builder for chaining.
     */
    public Builder addArchiveUrisBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureArchiveUrisIsMutable();
      archiveUris_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.SparkBatch)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.SparkBatch)
  private static final com.google.cloud.dataproc.v1.SparkBatch DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.SparkBatch();
  }

  public static com.google.cloud.dataproc.v1.SparkBatch getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SparkBatch> PARSER =
      new com.google.protobuf.AbstractParser<SparkBatch>() {
        @java.lang.Override
        public SparkBatch parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SparkBatch> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SparkBatch> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.SparkBatch getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
