/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/dataproc/v1/shared.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.dataproc.v1;

/**
 *
 *
 * <pre>
 * The usage snapshot represents the resources consumed by a workload at a
 * specified time.
 * </pre>
 *
 * Protobuf type {@code google.cloud.dataproc.v1.UsageSnapshot}
 */
public final class UsageSnapshot extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.dataproc.v1.UsageSnapshot)
    UsageSnapshotOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UsageSnapshot.newBuilder() to construct.
  private UsageSnapshot(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UsageSnapshot() {
    acceleratorType_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UsageSnapshot();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.dataproc.v1.SharedProto
        .internal_static_google_cloud_dataproc_v1_UsageSnapshot_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.dataproc.v1.SharedProto
        .internal_static_google_cloud_dataproc_v1_UsageSnapshot_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.dataproc.v1.UsageSnapshot.class,
            com.google.cloud.dataproc.v1.UsageSnapshot.Builder.class);
  }

  private int bitField0_;
  public static final int MILLI_DCU_FIELD_NUMBER = 1;
  private long milliDcu_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional. Milli (one-thousandth) Dataproc Compute Units (DCUs) (see
   * [Dataproc Serverless pricing]
   * (https://cloud.google.com/dataproc-serverless/pricing)).
   * </pre>
   *
   * <code>int64 milli_dcu = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The milliDcu.
   */
  @java.lang.Override
  public long getMilliDcu() {
    return milliDcu_;
  }

  public static final int SHUFFLE_STORAGE_GB_FIELD_NUMBER = 2;
  private long shuffleStorageGb_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional. Shuffle Storage in gigabytes (GB). (see [Dataproc Serverless
   * pricing] (https://cloud.google.com/dataproc-serverless/pricing))
   * </pre>
   *
   * <code>int64 shuffle_storage_gb = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The shuffleStorageGb.
   */
  @java.lang.Override
  public long getShuffleStorageGb() {
    return shuffleStorageGb_;
  }

  public static final int MILLI_DCU_PREMIUM_FIELD_NUMBER = 4;
  private long milliDcuPremium_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional. Milli (one-thousandth) Dataproc Compute Units (DCUs) charged at
   * premium tier (see [Dataproc Serverless pricing]
   * (https://cloud.google.com/dataproc-serverless/pricing)).
   * </pre>
   *
   * <code>int64 milli_dcu_premium = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The milliDcuPremium.
   */
  @java.lang.Override
  public long getMilliDcuPremium() {
    return milliDcuPremium_;
  }

  public static final int SHUFFLE_STORAGE_GB_PREMIUM_FIELD_NUMBER = 5;
  private long shuffleStorageGbPremium_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional. Shuffle Storage in gigabytes (GB) charged at premium tier. (see
   * [Dataproc Serverless pricing]
   * (https://cloud.google.com/dataproc-serverless/pricing))
   * </pre>
   *
   * <code>int64 shuffle_storage_gb_premium = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The shuffleStorageGbPremium.
   */
  @java.lang.Override
  public long getShuffleStorageGbPremium() {
    return shuffleStorageGbPremium_;
  }

  public static final int MILLI_ACCELERATOR_FIELD_NUMBER = 6;
  private long milliAccelerator_ = 0L;
  /**
   *
   *
   * <pre>
   * Optional. Milli (one-thousandth) accelerator. (see [Dataproc
   * Serverless pricing] (https://cloud.google.com/dataproc-serverless/pricing))
   * </pre>
   *
   * <code>int64 milli_accelerator = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The milliAccelerator.
   */
  @java.lang.Override
  public long getMilliAccelerator() {
    return milliAccelerator_;
  }

  public static final int ACCELERATOR_TYPE_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object acceleratorType_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Accelerator type being used, if any
   * </pre>
   *
   * <code>string accelerator_type = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The acceleratorType.
   */
  @java.lang.Override
  public java.lang.String getAcceleratorType() {
    java.lang.Object ref = acceleratorType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      acceleratorType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Accelerator type being used, if any
   * </pre>
   *
   * <code>string accelerator_type = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for acceleratorType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAcceleratorTypeBytes() {
    java.lang.Object ref = acceleratorType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      acceleratorType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SNAPSHOT_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp snapshotTime_;
  /**
   *
   *
   * <pre>
   * Optional. The timestamp of the usage snapshot.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the snapshotTime field is set.
   */
  @java.lang.Override
  public boolean hasSnapshotTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The timestamp of the usage snapshot.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The snapshotTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getSnapshotTime() {
    return snapshotTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : snapshotTime_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The timestamp of the usage snapshot.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder() {
    return snapshotTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : snapshotTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (milliDcu_ != 0L) {
      output.writeInt64(1, milliDcu_);
    }
    if (shuffleStorageGb_ != 0L) {
      output.writeInt64(2, shuffleStorageGb_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getSnapshotTime());
    }
    if (milliDcuPremium_ != 0L) {
      output.writeInt64(4, milliDcuPremium_);
    }
    if (shuffleStorageGbPremium_ != 0L) {
      output.writeInt64(5, shuffleStorageGbPremium_);
    }
    if (milliAccelerator_ != 0L) {
      output.writeInt64(6, milliAccelerator_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(acceleratorType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, acceleratorType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (milliDcu_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, milliDcu_);
    }
    if (shuffleStorageGb_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, shuffleStorageGb_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSnapshotTime());
    }
    if (milliDcuPremium_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, milliDcuPremium_);
    }
    if (shuffleStorageGbPremium_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(5, shuffleStorageGbPremium_);
    }
    if (milliAccelerator_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, milliAccelerator_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(acceleratorType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, acceleratorType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.dataproc.v1.UsageSnapshot)) {
      return super.equals(obj);
    }
    com.google.cloud.dataproc.v1.UsageSnapshot other =
        (com.google.cloud.dataproc.v1.UsageSnapshot) obj;

    if (getMilliDcu() != other.getMilliDcu()) return false;
    if (getShuffleStorageGb() != other.getShuffleStorageGb()) return false;
    if (getMilliDcuPremium() != other.getMilliDcuPremium()) return false;
    if (getShuffleStorageGbPremium() != other.getShuffleStorageGbPremium()) return false;
    if (getMilliAccelerator() != other.getMilliAccelerator()) return false;
    if (!getAcceleratorType().equals(other.getAcceleratorType())) return false;
    if (hasSnapshotTime() != other.hasSnapshotTime()) return false;
    if (hasSnapshotTime()) {
      if (!getSnapshotTime().equals(other.getSnapshotTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MILLI_DCU_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMilliDcu());
    hash = (37 * hash) + SHUFFLE_STORAGE_GB_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getShuffleStorageGb());
    hash = (37 * hash) + MILLI_DCU_PREMIUM_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMilliDcuPremium());
    hash = (37 * hash) + SHUFFLE_STORAGE_GB_PREMIUM_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getShuffleStorageGbPremium());
    hash = (37 * hash) + MILLI_ACCELERATOR_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMilliAccelerator());
    hash = (37 * hash) + ACCELERATOR_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getAcceleratorType().hashCode();
    if (hasSnapshotTime()) {
      hash = (37 * hash) + SNAPSHOT_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getSnapshotTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.dataproc.v1.UsageSnapshot parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.UsageSnapshot parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.UsageSnapshot parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.UsageSnapshot parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.UsageSnapshot parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.dataproc.v1.UsageSnapshot parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.UsageSnapshot parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.UsageSnapshot parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.UsageSnapshot parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.UsageSnapshot parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.dataproc.v1.UsageSnapshot parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.dataproc.v1.UsageSnapshot parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.dataproc.v1.UsageSnapshot prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The usage snapshot represents the resources consumed by a workload at a
   * specified time.
   * </pre>
   *
   * Protobuf type {@code google.cloud.dataproc.v1.UsageSnapshot}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.dataproc.v1.UsageSnapshot)
      com.google.cloud.dataproc.v1.UsageSnapshotOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_UsageSnapshot_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_UsageSnapshot_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.dataproc.v1.UsageSnapshot.class,
              com.google.cloud.dataproc.v1.UsageSnapshot.Builder.class);
    }

    // Construct using com.google.cloud.dataproc.v1.UsageSnapshot.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSnapshotTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      milliDcu_ = 0L;
      shuffleStorageGb_ = 0L;
      milliDcuPremium_ = 0L;
      shuffleStorageGbPremium_ = 0L;
      milliAccelerator_ = 0L;
      acceleratorType_ = "";
      snapshotTime_ = null;
      if (snapshotTimeBuilder_ != null) {
        snapshotTimeBuilder_.dispose();
        snapshotTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.dataproc.v1.SharedProto
          .internal_static_google_cloud_dataproc_v1_UsageSnapshot_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.UsageSnapshot getDefaultInstanceForType() {
      return com.google.cloud.dataproc.v1.UsageSnapshot.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.UsageSnapshot build() {
      com.google.cloud.dataproc.v1.UsageSnapshot result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.dataproc.v1.UsageSnapshot buildPartial() {
      com.google.cloud.dataproc.v1.UsageSnapshot result =
          new com.google.cloud.dataproc.v1.UsageSnapshot(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.dataproc.v1.UsageSnapshot result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.milliDcu_ = milliDcu_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.shuffleStorageGb_ = shuffleStorageGb_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.milliDcuPremium_ = milliDcuPremium_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.shuffleStorageGbPremium_ = shuffleStorageGbPremium_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.milliAccelerator_ = milliAccelerator_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.acceleratorType_ = acceleratorType_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.snapshotTime_ =
            snapshotTimeBuilder_ == null ? snapshotTime_ : snapshotTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.dataproc.v1.UsageSnapshot) {
        return mergeFrom((com.google.cloud.dataproc.v1.UsageSnapshot) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.dataproc.v1.UsageSnapshot other) {
      if (other == com.google.cloud.dataproc.v1.UsageSnapshot.getDefaultInstance()) return this;
      if (other.getMilliDcu() != 0L) {
        setMilliDcu(other.getMilliDcu());
      }
      if (other.getShuffleStorageGb() != 0L) {
        setShuffleStorageGb(other.getShuffleStorageGb());
      }
      if (other.getMilliDcuPremium() != 0L) {
        setMilliDcuPremium(other.getMilliDcuPremium());
      }
      if (other.getShuffleStorageGbPremium() != 0L) {
        setShuffleStorageGbPremium(other.getShuffleStorageGbPremium());
      }
      if (other.getMilliAccelerator() != 0L) {
        setMilliAccelerator(other.getMilliAccelerator());
      }
      if (!other.getAcceleratorType().isEmpty()) {
        acceleratorType_ = other.acceleratorType_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasSnapshotTime()) {
        mergeSnapshotTime(other.getSnapshotTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                milliDcu_ = input.readInt64();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                shuffleStorageGb_ = input.readInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getSnapshotTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 26
            case 32:
              {
                milliDcuPremium_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 32
            case 40:
              {
                shuffleStorageGbPremium_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            case 48:
              {
                milliAccelerator_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            case 58:
              {
                acceleratorType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private long milliDcu_;
    /**
     *
     *
     * <pre>
     * Optional. Milli (one-thousandth) Dataproc Compute Units (DCUs) (see
     * [Dataproc Serverless pricing]
     * (https://cloud.google.com/dataproc-serverless/pricing)).
     * </pre>
     *
     * <code>int64 milli_dcu = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The milliDcu.
     */
    @java.lang.Override
    public long getMilliDcu() {
      return milliDcu_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Milli (one-thousandth) Dataproc Compute Units (DCUs) (see
     * [Dataproc Serverless pricing]
     * (https://cloud.google.com/dataproc-serverless/pricing)).
     * </pre>
     *
     * <code>int64 milli_dcu = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The milliDcu to set.
     * @return This builder for chaining.
     */
    public Builder setMilliDcu(long value) {

      milliDcu_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Milli (one-thousandth) Dataproc Compute Units (DCUs) (see
     * [Dataproc Serverless pricing]
     * (https://cloud.google.com/dataproc-serverless/pricing)).
     * </pre>
     *
     * <code>int64 milli_dcu = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMilliDcu() {
      bitField0_ = (bitField0_ & ~0x00000001);
      milliDcu_ = 0L;
      onChanged();
      return this;
    }

    private long shuffleStorageGb_;
    /**
     *
     *
     * <pre>
     * Optional. Shuffle Storage in gigabytes (GB). (see [Dataproc Serverless
     * pricing] (https://cloud.google.com/dataproc-serverless/pricing))
     * </pre>
     *
     * <code>int64 shuffle_storage_gb = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The shuffleStorageGb.
     */
    @java.lang.Override
    public long getShuffleStorageGb() {
      return shuffleStorageGb_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Shuffle Storage in gigabytes (GB). (see [Dataproc Serverless
     * pricing] (https://cloud.google.com/dataproc-serverless/pricing))
     * </pre>
     *
     * <code>int64 shuffle_storage_gb = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The shuffleStorageGb to set.
     * @return This builder for chaining.
     */
    public Builder setShuffleStorageGb(long value) {

      shuffleStorageGb_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Shuffle Storage in gigabytes (GB). (see [Dataproc Serverless
     * pricing] (https://cloud.google.com/dataproc-serverless/pricing))
     * </pre>
     *
     * <code>int64 shuffle_storage_gb = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearShuffleStorageGb() {
      bitField0_ = (bitField0_ & ~0x00000002);
      shuffleStorageGb_ = 0L;
      onChanged();
      return this;
    }

    private long milliDcuPremium_;
    /**
     *
     *
     * <pre>
     * Optional. Milli (one-thousandth) Dataproc Compute Units (DCUs) charged at
     * premium tier (see [Dataproc Serverless pricing]
     * (https://cloud.google.com/dataproc-serverless/pricing)).
     * </pre>
     *
     * <code>int64 milli_dcu_premium = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The milliDcuPremium.
     */
    @java.lang.Override
    public long getMilliDcuPremium() {
      return milliDcuPremium_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Milli (one-thousandth) Dataproc Compute Units (DCUs) charged at
     * premium tier (see [Dataproc Serverless pricing]
     * (https://cloud.google.com/dataproc-serverless/pricing)).
     * </pre>
     *
     * <code>int64 milli_dcu_premium = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The milliDcuPremium to set.
     * @return This builder for chaining.
     */
    public Builder setMilliDcuPremium(long value) {

      milliDcuPremium_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Milli (one-thousandth) Dataproc Compute Units (DCUs) charged at
     * premium tier (see [Dataproc Serverless pricing]
     * (https://cloud.google.com/dataproc-serverless/pricing)).
     * </pre>
     *
     * <code>int64 milli_dcu_premium = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMilliDcuPremium() {
      bitField0_ = (bitField0_ & ~0x00000004);
      milliDcuPremium_ = 0L;
      onChanged();
      return this;
    }

    private long shuffleStorageGbPremium_;
    /**
     *
     *
     * <pre>
     * Optional. Shuffle Storage in gigabytes (GB) charged at premium tier. (see
     * [Dataproc Serverless pricing]
     * (https://cloud.google.com/dataproc-serverless/pricing))
     * </pre>
     *
     * <code>int64 shuffle_storage_gb_premium = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The shuffleStorageGbPremium.
     */
    @java.lang.Override
    public long getShuffleStorageGbPremium() {
      return shuffleStorageGbPremium_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Shuffle Storage in gigabytes (GB) charged at premium tier. (see
     * [Dataproc Serverless pricing]
     * (https://cloud.google.com/dataproc-serverless/pricing))
     * </pre>
     *
     * <code>int64 shuffle_storage_gb_premium = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The shuffleStorageGbPremium to set.
     * @return This builder for chaining.
     */
    public Builder setShuffleStorageGbPremium(long value) {

      shuffleStorageGbPremium_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Shuffle Storage in gigabytes (GB) charged at premium tier. (see
     * [Dataproc Serverless pricing]
     * (https://cloud.google.com/dataproc-serverless/pricing))
     * </pre>
     *
     * <code>int64 shuffle_storage_gb_premium = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearShuffleStorageGbPremium() {
      bitField0_ = (bitField0_ & ~0x00000008);
      shuffleStorageGbPremium_ = 0L;
      onChanged();
      return this;
    }

    private long milliAccelerator_;
    /**
     *
     *
     * <pre>
     * Optional. Milli (one-thousandth) accelerator. (see [Dataproc
     * Serverless pricing] (https://cloud.google.com/dataproc-serverless/pricing))
     * </pre>
     *
     * <code>int64 milli_accelerator = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The milliAccelerator.
     */
    @java.lang.Override
    public long getMilliAccelerator() {
      return milliAccelerator_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Milli (one-thousandth) accelerator. (see [Dataproc
     * Serverless pricing] (https://cloud.google.com/dataproc-serverless/pricing))
     * </pre>
     *
     * <code>int64 milli_accelerator = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The milliAccelerator to set.
     * @return This builder for chaining.
     */
    public Builder setMilliAccelerator(long value) {

      milliAccelerator_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Milli (one-thousandth) accelerator. (see [Dataproc
     * Serverless pricing] (https://cloud.google.com/dataproc-serverless/pricing))
     * </pre>
     *
     * <code>int64 milli_accelerator = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMilliAccelerator() {
      bitField0_ = (bitField0_ & ~0x00000010);
      milliAccelerator_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object acceleratorType_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Accelerator type being used, if any
     * </pre>
     *
     * <code>string accelerator_type = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The acceleratorType.
     */
    public java.lang.String getAcceleratorType() {
      java.lang.Object ref = acceleratorType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        acceleratorType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Accelerator type being used, if any
     * </pre>
     *
     * <code>string accelerator_type = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for acceleratorType.
     */
    public com.google.protobuf.ByteString getAcceleratorTypeBytes() {
      java.lang.Object ref = acceleratorType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        acceleratorType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Accelerator type being used, if any
     * </pre>
     *
     * <code>string accelerator_type = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The acceleratorType to set.
     * @return This builder for chaining.
     */
    public Builder setAcceleratorType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      acceleratorType_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Accelerator type being used, if any
     * </pre>
     *
     * <code>string accelerator_type = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAcceleratorType() {
      acceleratorType_ = getDefaultInstance().getAcceleratorType();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Accelerator type being used, if any
     * </pre>
     *
     * <code>string accelerator_type = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for acceleratorType to set.
     * @return This builder for chaining.
     */
    public Builder setAcceleratorTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      acceleratorType_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp snapshotTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        snapshotTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The timestamp of the usage snapshot.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the snapshotTime field is set.
     */
    public boolean hasSnapshotTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The timestamp of the usage snapshot.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The snapshotTime.
     */
    public com.google.protobuf.Timestamp getSnapshotTime() {
      if (snapshotTimeBuilder_ == null) {
        return snapshotTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : snapshotTime_;
      } else {
        return snapshotTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The timestamp of the usage snapshot.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSnapshotTime(com.google.protobuf.Timestamp value) {
      if (snapshotTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        snapshotTime_ = value;
      } else {
        snapshotTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The timestamp of the usage snapshot.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setSnapshotTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (snapshotTimeBuilder_ == null) {
        snapshotTime_ = builderForValue.build();
      } else {
        snapshotTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The timestamp of the usage snapshot.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeSnapshotTime(com.google.protobuf.Timestamp value) {
      if (snapshotTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && snapshotTime_ != null
            && snapshotTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getSnapshotTimeBuilder().mergeFrom(value);
        } else {
          snapshotTime_ = value;
        }
      } else {
        snapshotTimeBuilder_.mergeFrom(value);
      }
      if (snapshotTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The timestamp of the usage snapshot.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearSnapshotTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      snapshotTime_ = null;
      if (snapshotTimeBuilder_ != null) {
        snapshotTimeBuilder_.dispose();
        snapshotTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The timestamp of the usage snapshot.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getSnapshotTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getSnapshotTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The timestamp of the usage snapshot.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder() {
      if (snapshotTimeBuilder_ != null) {
        return snapshotTimeBuilder_.getMessageOrBuilder();
      } else {
        return snapshotTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : snapshotTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The timestamp of the usage snapshot.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getSnapshotTimeFieldBuilder() {
      if (snapshotTimeBuilder_ == null) {
        snapshotTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getSnapshotTime(), getParentForChildren(), isClean());
        snapshotTime_ = null;
      }
      return snapshotTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.dataproc.v1.UsageSnapshot)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.dataproc.v1.UsageSnapshot)
  private static final com.google.cloud.dataproc.v1.UsageSnapshot DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.dataproc.v1.UsageSnapshot();
  }

  public static com.google.cloud.dataproc.v1.UsageSnapshot getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UsageSnapshot> PARSER =
      new com.google.protobuf.AbstractParser<UsageSnapshot>() {
        @java.lang.Override
        public UsageSnapshot parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UsageSnapshot> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UsageSnapshot> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.dataproc.v1.UsageSnapshot getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
