/*
 * Decompiled with CFR 0.152.
 */
package com.google.datastore.admin.v1;

import com.google.datastore.admin.v1.IndexOrBuilder;
import com.google.datastore.admin.v1.IndexProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Index
extends GeneratedMessageV3
implements IndexOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int PROJECT_ID_FIELD_NUMBER = 1;
    private volatile Object projectId_ = "";
    public static final int INDEX_ID_FIELD_NUMBER = 3;
    private volatile Object indexId_ = "";
    public static final int KIND_FIELD_NUMBER = 4;
    private volatile Object kind_ = "";
    public static final int ANCESTOR_FIELD_NUMBER = 5;
    private int ancestor_ = 0;
    public static final int PROPERTIES_FIELD_NUMBER = 6;
    private List<IndexedProperty> properties_;
    public static final int STATE_FIELD_NUMBER = 7;
    private int state_ = 0;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Index DEFAULT_INSTANCE = new Index();
    private static final Parser<Index> PARSER = new AbstractParser<Index>(){

        public Index parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Index.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Index(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Index() {
        this.projectId_ = "";
        this.indexId_ = "";
        this.kind_ = "";
        this.ancestor_ = 0;
        this.properties_ = Collections.emptyList();
        this.state_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Index();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return IndexProto.internal_static_google_datastore_admin_v1_Index_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return IndexProto.internal_static_google_datastore_admin_v1_Index_fieldAccessorTable.ensureFieldAccessorsInitialized(Index.class, Builder.class);
    }

    @Override
    public String getProjectId() {
        Object ref = this.projectId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.projectId_ = s;
        return s;
    }

    @Override
    public ByteString getProjectIdBytes() {
        Object ref = this.projectId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.projectId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getIndexId() {
        Object ref = this.indexId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.indexId_ = s;
        return s;
    }

    @Override
    public ByteString getIndexIdBytes() {
        Object ref = this.indexId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.indexId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getKind() {
        Object ref = this.kind_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.kind_ = s;
        return s;
    }

    @Override
    public ByteString getKindBytes() {
        Object ref = this.kind_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.kind_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getAncestorValue() {
        return this.ancestor_;
    }

    @Override
    public AncestorMode getAncestor() {
        AncestorMode result = AncestorMode.forNumber(this.ancestor_);
        return result == null ? AncestorMode.UNRECOGNIZED : result;
    }

    @Override
    public List<IndexedProperty> getPropertiesList() {
        return this.properties_;
    }

    @Override
    public List<? extends IndexedPropertyOrBuilder> getPropertiesOrBuilderList() {
        return this.properties_;
    }

    @Override
    public int getPropertiesCount() {
        return this.properties_.size();
    }

    @Override
    public IndexedProperty getProperties(int index) {
        return this.properties_.get(index);
    }

    @Override
    public IndexedPropertyOrBuilder getPropertiesOrBuilder(int index) {
        return this.properties_.get(index);
    }

    @Override
    public int getStateValue() {
        return this.state_;
    }

    @Override
    public State getState() {
        State result = State.forNumber(this.state_);
        return result == null ? State.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.projectId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.projectId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.indexId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.indexId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.kind_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.kind_);
        }
        if (this.ancestor_ != AncestorMode.ANCESTOR_MODE_UNSPECIFIED.getNumber()) {
            output.writeEnum(5, this.ancestor_);
        }
        for (int i = 0; i < this.properties_.size(); ++i) {
            output.writeMessage(6, (MessageLite)this.properties_.get(i));
        }
        if (this.state_ != State.STATE_UNSPECIFIED.getNumber()) {
            output.writeEnum(7, this.state_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.projectId_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.projectId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.indexId_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.indexId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.kind_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.kind_);
        }
        if (this.ancestor_ != AncestorMode.ANCESTOR_MODE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.ancestor_);
        }
        for (int i = 0; i < this.properties_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)((MessageLite)this.properties_.get(i)));
        }
        if (this.state_ != State.STATE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)7, (int)this.state_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Index)) {
            return super.equals(obj);
        }
        Index other = (Index)obj;
        if (!this.getProjectId().equals(other.getProjectId())) {
            return false;
        }
        if (!this.getIndexId().equals(other.getIndexId())) {
            return false;
        }
        if (!this.getKind().equals(other.getKind())) {
            return false;
        }
        if (this.ancestor_ != other.ancestor_) {
            return false;
        }
        if (!this.getPropertiesList().equals(other.getPropertiesList())) {
            return false;
        }
        if (this.state_ != other.state_) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Index.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getProjectId().hashCode();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getIndexId().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getKind().hashCode();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.ancestor_;
        if (this.getPropertiesCount() > 0) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getPropertiesList().hashCode();
        }
        hash = 37 * hash + 7;
        hash = 53 * hash + this.state_;
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Index parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Index)PARSER.parseFrom(data);
    }

    public static Index parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Index)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Index parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Index)PARSER.parseFrom(data);
    }

    public static Index parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Index)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Index parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Index)PARSER.parseFrom(data);
    }

    public static Index parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Index)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Index parseFrom(InputStream input) throws IOException {
        return (Index)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Index parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Index)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Index parseDelimitedFrom(InputStream input) throws IOException {
        return (Index)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Index parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Index)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Index parseFrom(CodedInputStream input) throws IOException {
        return (Index)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Index parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Index)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Index.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Index prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Index getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Index> parser() {
        return PARSER;
    }

    public Parser<Index> getParserForType() {
        return PARSER;
    }

    public Index getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements IndexOrBuilder {
        private int bitField0_;
        private Object projectId_ = "";
        private Object indexId_ = "";
        private Object kind_ = "";
        private int ancestor_ = 0;
        private List<IndexedProperty> properties_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<IndexedProperty, IndexedProperty.Builder, IndexedPropertyOrBuilder> propertiesBuilder_;
        private int state_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return IndexProto.internal_static_google_datastore_admin_v1_Index_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return IndexProto.internal_static_google_datastore_admin_v1_Index_fieldAccessorTable.ensureFieldAccessorsInitialized(Index.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.projectId_ = "";
            this.indexId_ = "";
            this.kind_ = "";
            this.ancestor_ = 0;
            if (this.propertiesBuilder_ == null) {
                this.properties_ = Collections.emptyList();
            } else {
                this.properties_ = null;
                this.propertiesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFEF;
            this.state_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return IndexProto.internal_static_google_datastore_admin_v1_Index_descriptor;
        }

        public Index getDefaultInstanceForType() {
            return Index.getDefaultInstance();
        }

        public Index build() {
            Index result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Index buildPartial() {
            Index result = new Index(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Index result) {
            if (this.propertiesBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0) {
                    this.properties_ = Collections.unmodifiableList(this.properties_);
                    this.bitField0_ &= 0xFFFFFFEF;
                }
                result.properties_ = this.properties_;
            } else {
                result.properties_ = this.propertiesBuilder_.build();
            }
        }

        private void buildPartial0(Index result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.projectId_ = this.projectId_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.indexId_ = this.indexId_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.kind_ = this.kind_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.ancestor_ = this.ancestor_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.state_ = this.state_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Index) {
                return this.mergeFrom((Index)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Index other) {
            if (other == Index.getDefaultInstance()) {
                return this;
            }
            if (!other.getProjectId().isEmpty()) {
                this.projectId_ = other.projectId_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getIndexId().isEmpty()) {
                this.indexId_ = other.indexId_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (!other.getKind().isEmpty()) {
                this.kind_ = other.kind_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (other.ancestor_ != 0) {
                this.setAncestorValue(other.getAncestorValue());
            }
            if (this.propertiesBuilder_ == null) {
                if (!other.properties_.isEmpty()) {
                    if (this.properties_.isEmpty()) {
                        this.properties_ = other.properties_;
                        this.bitField0_ &= 0xFFFFFFEF;
                    } else {
                        this.ensurePropertiesIsMutable();
                        this.properties_.addAll(other.properties_);
                    }
                    this.onChanged();
                }
            } else if (!other.properties_.isEmpty()) {
                if (this.propertiesBuilder_.isEmpty()) {
                    this.propertiesBuilder_.dispose();
                    this.propertiesBuilder_ = null;
                    this.properties_ = other.properties_;
                    this.bitField0_ &= 0xFFFFFFEF;
                    this.propertiesBuilder_ = alwaysUseFieldBuilders ? this.getPropertiesFieldBuilder() : null;
                } else {
                    this.propertiesBuilder_.addAllMessages((Iterable)other.properties_);
                }
            }
            if (other.state_ != 0) {
                this.setStateValue(other.getStateValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block14: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block14;
                        }
                        case 10: {
                            this.projectId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block14;
                        }
                        case 26: {
                            this.indexId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block14;
                        }
                        case 34: {
                            this.kind_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block14;
                        }
                        case 40: {
                            this.ancestor_ = input.readEnum();
                            this.bitField0_ |= 8;
                            continue block14;
                        }
                        case 50: {
                            IndexedProperty m = (IndexedProperty)input.readMessage(IndexedProperty.parser(), extensionRegistry);
                            if (this.propertiesBuilder_ == null) {
                                this.ensurePropertiesIsMutable();
                                this.properties_.add(m);
                                continue block14;
                            }
                            this.propertiesBuilder_.addMessage((AbstractMessage)m);
                            continue block14;
                        }
                        case 56: {
                            this.state_ = input.readEnum();
                            this.bitField0_ |= 0x20;
                            continue block14;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getProjectId() {
            Object ref = this.projectId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.projectId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getProjectIdBytes() {
            Object ref = this.projectId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.projectId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setProjectId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.projectId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearProjectId() {
            this.projectId_ = Index.getDefaultInstance().getProjectId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setProjectIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Index.checkByteStringIsUtf8((ByteString)value);
            this.projectId_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getIndexId() {
            Object ref = this.indexId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.indexId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getIndexIdBytes() {
            Object ref = this.indexId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.indexId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setIndexId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.indexId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearIndexId() {
            this.indexId_ = Index.getDefaultInstance().getIndexId();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setIndexIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Index.checkByteStringIsUtf8((ByteString)value);
            this.indexId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public String getKind() {
            Object ref = this.kind_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.kind_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getKindBytes() {
            Object ref = this.kind_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.kind_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setKind(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.kind_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearKind() {
            this.kind_ = Index.getDefaultInstance().getKind();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setKindBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Index.checkByteStringIsUtf8((ByteString)value);
            this.kind_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public int getAncestorValue() {
            return this.ancestor_;
        }

        public Builder setAncestorValue(int value) {
            this.ancestor_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        @Override
        public AncestorMode getAncestor() {
            AncestorMode result = AncestorMode.forNumber(this.ancestor_);
            return result == null ? AncestorMode.UNRECOGNIZED : result;
        }

        public Builder setAncestor(AncestorMode value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 8;
            this.ancestor_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAncestor() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.ancestor_ = 0;
            this.onChanged();
            return this;
        }

        private void ensurePropertiesIsMutable() {
            if ((this.bitField0_ & 0x10) == 0) {
                this.properties_ = new ArrayList<IndexedProperty>(this.properties_);
                this.bitField0_ |= 0x10;
            }
        }

        @Override
        public List<IndexedProperty> getPropertiesList() {
            if (this.propertiesBuilder_ == null) {
                return Collections.unmodifiableList(this.properties_);
            }
            return this.propertiesBuilder_.getMessageList();
        }

        @Override
        public int getPropertiesCount() {
            if (this.propertiesBuilder_ == null) {
                return this.properties_.size();
            }
            return this.propertiesBuilder_.getCount();
        }

        @Override
        public IndexedProperty getProperties(int index) {
            if (this.propertiesBuilder_ == null) {
                return this.properties_.get(index);
            }
            return (IndexedProperty)this.propertiesBuilder_.getMessage(index);
        }

        public Builder setProperties(int index, IndexedProperty value) {
            if (this.propertiesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePropertiesIsMutable();
                this.properties_.set(index, value);
                this.onChanged();
            } else {
                this.propertiesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setProperties(int index, IndexedProperty.Builder builderForValue) {
            if (this.propertiesBuilder_ == null) {
                this.ensurePropertiesIsMutable();
                this.properties_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.propertiesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addProperties(IndexedProperty value) {
            if (this.propertiesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePropertiesIsMutable();
                this.properties_.add(value);
                this.onChanged();
            } else {
                this.propertiesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addProperties(int index, IndexedProperty value) {
            if (this.propertiesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensurePropertiesIsMutable();
                this.properties_.add(index, value);
                this.onChanged();
            } else {
                this.propertiesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addProperties(IndexedProperty.Builder builderForValue) {
            if (this.propertiesBuilder_ == null) {
                this.ensurePropertiesIsMutable();
                this.properties_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.propertiesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addProperties(int index, IndexedProperty.Builder builderForValue) {
            if (this.propertiesBuilder_ == null) {
                this.ensurePropertiesIsMutable();
                this.properties_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.propertiesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllProperties(Iterable<? extends IndexedProperty> values) {
            if (this.propertiesBuilder_ == null) {
                this.ensurePropertiesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.properties_);
                this.onChanged();
            } else {
                this.propertiesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearProperties() {
            if (this.propertiesBuilder_ == null) {
                this.properties_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFEF;
                this.onChanged();
            } else {
                this.propertiesBuilder_.clear();
            }
            return this;
        }

        public Builder removeProperties(int index) {
            if (this.propertiesBuilder_ == null) {
                this.ensurePropertiesIsMutable();
                this.properties_.remove(index);
                this.onChanged();
            } else {
                this.propertiesBuilder_.remove(index);
            }
            return this;
        }

        public IndexedProperty.Builder getPropertiesBuilder(int index) {
            return (IndexedProperty.Builder)this.getPropertiesFieldBuilder().getBuilder(index);
        }

        @Override
        public IndexedPropertyOrBuilder getPropertiesOrBuilder(int index) {
            if (this.propertiesBuilder_ == null) {
                return this.properties_.get(index);
            }
            return (IndexedPropertyOrBuilder)this.propertiesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends IndexedPropertyOrBuilder> getPropertiesOrBuilderList() {
            if (this.propertiesBuilder_ != null) {
                return this.propertiesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.properties_);
        }

        public IndexedProperty.Builder addPropertiesBuilder() {
            return (IndexedProperty.Builder)this.getPropertiesFieldBuilder().addBuilder((AbstractMessage)IndexedProperty.getDefaultInstance());
        }

        public IndexedProperty.Builder addPropertiesBuilder(int index) {
            return (IndexedProperty.Builder)this.getPropertiesFieldBuilder().addBuilder(index, (AbstractMessage)IndexedProperty.getDefaultInstance());
        }

        public List<IndexedProperty.Builder> getPropertiesBuilderList() {
            return this.getPropertiesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<IndexedProperty, IndexedProperty.Builder, IndexedPropertyOrBuilder> getPropertiesFieldBuilder() {
            if (this.propertiesBuilder_ == null) {
                this.propertiesBuilder_ = new RepeatedFieldBuilderV3(this.properties_, (this.bitField0_ & 0x10) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.properties_ = null;
            }
            return this.propertiesBuilder_;
        }

        @Override
        public int getStateValue() {
            return this.state_;
        }

        public Builder setStateValue(int value) {
            this.state_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public State getState() {
            State result = State.forNumber(this.state_);
            return result == null ? State.UNRECOGNIZED : result;
        }

        public Builder setState(State value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x20;
            this.state_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearState() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.state_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class IndexedProperty
    extends GeneratedMessageV3
    implements IndexedPropertyOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int NAME_FIELD_NUMBER = 1;
        private volatile Object name_ = "";
        public static final int DIRECTION_FIELD_NUMBER = 2;
        private int direction_ = 0;
        private byte memoizedIsInitialized = (byte)-1;
        private static final IndexedProperty DEFAULT_INSTANCE = new IndexedProperty();
        private static final Parser<IndexedProperty> PARSER = new AbstractParser<IndexedProperty>(){

            public IndexedProperty parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = IndexedProperty.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private IndexedProperty(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private IndexedProperty() {
            this.name_ = "";
            this.direction_ = 0;
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new IndexedProperty();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return IndexProto.internal_static_google_datastore_admin_v1_Index_IndexedProperty_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return IndexProto.internal_static_google_datastore_admin_v1_Index_IndexedProperty_fieldAccessorTable.ensureFieldAccessorsInitialized(IndexedProperty.class, Builder.class);
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.name_ = s;
            return s;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public int getDirectionValue() {
            return this.direction_;
        }

        @Override
        public Direction getDirection() {
            Direction result = Direction.forNumber(this.direction_);
            return result == null ? Direction.UNRECOGNIZED : result;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
            }
            if (this.direction_ != Direction.DIRECTION_UNSPECIFIED.getNumber()) {
                output.writeEnum(2, this.direction_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
                size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
            }
            if (this.direction_ != Direction.DIRECTION_UNSPECIFIED.getNumber()) {
                size += CodedOutputStream.computeEnumSize((int)2, (int)this.direction_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof IndexedProperty)) {
                return super.equals(obj);
            }
            IndexedProperty other = (IndexedProperty)obj;
            if (!this.getName().equals(other.getName())) {
                return false;
            }
            if (this.direction_ != other.direction_) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + IndexedProperty.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getName().hashCode();
            hash = 37 * hash + 2;
            hash = 53 * hash + this.direction_;
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static IndexedProperty parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (IndexedProperty)PARSER.parseFrom(data);
        }

        public static IndexedProperty parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (IndexedProperty)PARSER.parseFrom(data, extensionRegistry);
        }

        public static IndexedProperty parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (IndexedProperty)PARSER.parseFrom(data);
        }

        public static IndexedProperty parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (IndexedProperty)PARSER.parseFrom(data, extensionRegistry);
        }

        public static IndexedProperty parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (IndexedProperty)PARSER.parseFrom(data);
        }

        public static IndexedProperty parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (IndexedProperty)PARSER.parseFrom(data, extensionRegistry);
        }

        public static IndexedProperty parseFrom(InputStream input) throws IOException {
            return (IndexedProperty)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static IndexedProperty parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (IndexedProperty)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static IndexedProperty parseDelimitedFrom(InputStream input) throws IOException {
            return (IndexedProperty)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static IndexedProperty parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (IndexedProperty)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static IndexedProperty parseFrom(CodedInputStream input) throws IOException {
            return (IndexedProperty)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static IndexedProperty parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (IndexedProperty)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return IndexedProperty.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(IndexedProperty prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static IndexedProperty getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<IndexedProperty> parser() {
            return PARSER;
        }

        public Parser<IndexedProperty> getParserForType() {
            return PARSER;
        }

        public IndexedProperty getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements IndexedPropertyOrBuilder {
            private int bitField0_;
            private Object name_ = "";
            private int direction_ = 0;

            public static final Descriptors.Descriptor getDescriptor() {
                return IndexProto.internal_static_google_datastore_admin_v1_Index_IndexedProperty_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return IndexProto.internal_static_google_datastore_admin_v1_Index_IndexedProperty_fieldAccessorTable.ensureFieldAccessorsInitialized(IndexedProperty.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.name_ = "";
                this.direction_ = 0;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return IndexProto.internal_static_google_datastore_admin_v1_Index_IndexedProperty_descriptor;
            }

            public IndexedProperty getDefaultInstanceForType() {
                return IndexedProperty.getDefaultInstance();
            }

            public IndexedProperty build() {
                IndexedProperty result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public IndexedProperty buildPartial() {
                IndexedProperty result = new IndexedProperty(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(IndexedProperty result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.name_ = this.name_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.direction_ = this.direction_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof IndexedProperty) {
                    return this.mergeFrom((IndexedProperty)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(IndexedProperty other) {
                if (other == IndexedProperty.getDefaultInstance()) {
                    return this;
                }
                if (!other.getName().isEmpty()) {
                    this.name_ = other.name_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                if (other.direction_ != 0) {
                    this.setDirectionValue(other.getDirectionValue());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 10: {
                                this.name_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block10;
                            }
                            case 16: {
                                this.direction_ = input.readEnum();
                                this.bitField0_ |= 2;
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public String getName() {
                Object ref = this.name_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.name_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getNameBytes() {
                Object ref = this.name_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.name_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setName(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.name_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearName() {
                this.name_ = IndexedProperty.getDefaultInstance().getName();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setNameBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                IndexedProperty.checkByteStringIsUtf8((ByteString)value);
                this.name_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public int getDirectionValue() {
                return this.direction_;
            }

            public Builder setDirectionValue(int value) {
                this.direction_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            @Override
            public Direction getDirection() {
                Direction result = Direction.forNumber(this.direction_);
                return result == null ? Direction.UNRECOGNIZED : result;
            }

            public Builder setDirection(Direction value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 2;
                this.direction_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearDirection() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.direction_ = 0;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface IndexedPropertyOrBuilder
    extends MessageOrBuilder {
        public String getName();

        public ByteString getNameBytes();

        public int getDirectionValue();

        public Direction getDirection();
    }

    public static enum State implements ProtocolMessageEnum
    {
        STATE_UNSPECIFIED(0),
        CREATING(1),
        READY(2),
        DELETING(3),
        ERROR(4),
        UNRECOGNIZED(-1);

        public static final int STATE_UNSPECIFIED_VALUE = 0;
        public static final int CREATING_VALUE = 1;
        public static final int READY_VALUE = 2;
        public static final int DELETING_VALUE = 3;
        public static final int ERROR_VALUE = 4;
        private static final Internal.EnumLiteMap<State> internalValueMap;
        private static final State[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static State valueOf(int value) {
            return State.forNumber(value);
        }

        public static State forNumber(int value) {
            switch (value) {
                case 0: {
                    return STATE_UNSPECIFIED;
                }
                case 1: {
                    return CREATING;
                }
                case 2: {
                    return READY;
                }
                case 3: {
                    return DELETING;
                }
                case 4: {
                    return ERROR;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<State> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)State.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return State.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Index.getDescriptor().getEnumTypes().get(2);
        }

        public static State valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != State.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private State(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<State>(){

                public State findValueByNumber(int number) {
                    return State.forNumber(number);
                }
            };
            VALUES = State.values();
        }
    }

    public static enum Direction implements ProtocolMessageEnum
    {
        DIRECTION_UNSPECIFIED(0),
        ASCENDING(1),
        DESCENDING(2),
        UNRECOGNIZED(-1);

        public static final int DIRECTION_UNSPECIFIED_VALUE = 0;
        public static final int ASCENDING_VALUE = 1;
        public static final int DESCENDING_VALUE = 2;
        private static final Internal.EnumLiteMap<Direction> internalValueMap;
        private static final Direction[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static Direction valueOf(int value) {
            return Direction.forNumber(value);
        }

        public static Direction forNumber(int value) {
            switch (value) {
                case 0: {
                    return DIRECTION_UNSPECIFIED;
                }
                case 1: {
                    return ASCENDING;
                }
                case 2: {
                    return DESCENDING;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<Direction> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)Direction.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return Direction.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Index.getDescriptor().getEnumTypes().get(1);
        }

        public static Direction valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != Direction.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private Direction(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<Direction>(){

                public Direction findValueByNumber(int number) {
                    return Direction.forNumber(number);
                }
            };
            VALUES = Direction.values();
        }
    }

    public static enum AncestorMode implements ProtocolMessageEnum
    {
        ANCESTOR_MODE_UNSPECIFIED(0),
        NONE(1),
        ALL_ANCESTORS(2),
        UNRECOGNIZED(-1);

        public static final int ANCESTOR_MODE_UNSPECIFIED_VALUE = 0;
        public static final int NONE_VALUE = 1;
        public static final int ALL_ANCESTORS_VALUE = 2;
        private static final Internal.EnumLiteMap<AncestorMode> internalValueMap;
        private static final AncestorMode[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static AncestorMode valueOf(int value) {
            return AncestorMode.forNumber(value);
        }

        public static AncestorMode forNumber(int value) {
            switch (value) {
                case 0: {
                    return ANCESTOR_MODE_UNSPECIFIED;
                }
                case 1: {
                    return NONE;
                }
                case 2: {
                    return ALL_ANCESTORS;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<AncestorMode> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)AncestorMode.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return AncestorMode.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Index.getDescriptor().getEnumTypes().get(0);
        }

        public static AncestorMode valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != AncestorMode.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private AncestorMode(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<AncestorMode>(){

                public AncestorMode findValueByNumber(int number) {
                    return AncestorMode.forNumber(number);
                }
            };
            VALUES = AncestorMode.values();
        }
    }
}

