/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/v1/query.proto

package com.google.datastore.v1;

/**
 *
 *
 * <pre>
 * A [GQL
 * query](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
 * </pre>
 *
 * Protobuf type {@code google.datastore.v1.GqlQuery}
 */
public final class GqlQuery extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.datastore.v1.GqlQuery)
    GqlQueryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GqlQuery.newBuilder() to construct.
  private GqlQuery(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GqlQuery() {
    queryString_ = "";
    positionalBindings_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GqlQuery();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private GqlQuery(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              queryString_ = s;
              break;
            }
          case 16:
            {
              allowLiterals_ = input.readBool();
              break;
            }
          case 34:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                positionalBindings_ =
                    new java.util.ArrayList<com.google.datastore.v1.GqlQueryParameter>();
                mutable_bitField0_ |= 0x00000002;
              }
              positionalBindings_.add(
                  input.readMessage(
                      com.google.datastore.v1.GqlQueryParameter.parser(), extensionRegistry));
              break;
            }
          case 42:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                namedBindings_ =
                    com.google.protobuf.MapField.newMapField(
                        NamedBindingsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000001;
              }
              com.google.protobuf.MapEntry<
                      java.lang.String, com.google.datastore.v1.GqlQueryParameter>
                  namedBindings__ =
                      input.readMessage(
                          NamedBindingsDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
              namedBindings_
                  .getMutableMap()
                  .put(namedBindings__.getKey(), namedBindings__.getValue());
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        positionalBindings_ = java.util.Collections.unmodifiableList(positionalBindings_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.datastore.v1.QueryProto
        .internal_static_google_datastore_v1_GqlQuery_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 5:
        return internalGetNamedBindings();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.datastore.v1.QueryProto
        .internal_static_google_datastore_v1_GqlQuery_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.datastore.v1.GqlQuery.class, com.google.datastore.v1.GqlQuery.Builder.class);
  }

  public static final int QUERY_STRING_FIELD_NUMBER = 1;
  private volatile java.lang.Object queryString_;
  /**
   *
   *
   * <pre>
   * A string of the format described
   * [here](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
   * </pre>
   *
   * <code>string query_string = 1;</code>
   *
   * @return The queryString.
   */
  @java.lang.Override
  public java.lang.String getQueryString() {
    java.lang.Object ref = queryString_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      queryString_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A string of the format described
   * [here](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
   * </pre>
   *
   * <code>string query_string = 1;</code>
   *
   * @return The bytes for queryString.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQueryStringBytes() {
    java.lang.Object ref = queryString_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      queryString_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALLOW_LITERALS_FIELD_NUMBER = 2;
  private boolean allowLiterals_;
  /**
   *
   *
   * <pre>
   * When false, the query string must not contain any literals and instead must
   * bind all values. For example,
   * `SELECT * FROM Kind WHERE a = 'string literal'` is not allowed, while
   * `SELECT * FROM Kind WHERE a = &#64;value` is.
   * </pre>
   *
   * <code>bool allow_literals = 2;</code>
   *
   * @return The allowLiterals.
   */
  @java.lang.Override
  public boolean getAllowLiterals() {
    return allowLiterals_;
  }

  public static final int NAMED_BINDINGS_FIELD_NUMBER = 5;

  private static final class NamedBindingsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.datastore.v1.GqlQueryParameter>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.datastore.v1.GqlQueryParameter>newDefaultInstance(
                    com.google.datastore.v1.QueryProto
                        .internal_static_google_datastore_v1_GqlQuery_NamedBindingsEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.datastore.v1.GqlQueryParameter.getDefaultInstance());
  }

  private com.google.protobuf.MapField<java.lang.String, com.google.datastore.v1.GqlQueryParameter>
      namedBindings_;

  private com.google.protobuf.MapField<java.lang.String, com.google.datastore.v1.GqlQueryParameter>
      internalGetNamedBindings() {
    if (namedBindings_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          NamedBindingsDefaultEntryHolder.defaultEntry);
    }
    return namedBindings_;
  }

  public int getNamedBindingsCount() {
    return internalGetNamedBindings().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * For each non-reserved named binding site in the query string, there must be
   * a named parameter with that name, but not necessarily the inverse.
   * Key must match regex `[A-Za-z_$][A-Za-z_$0-9]*`, must not match regex
   * `__.*__`, and must not be `""`.
   * </pre>
   *
   * <code>map&lt;string, .google.datastore.v1.GqlQueryParameter&gt; named_bindings = 5;</code>
   */
  @java.lang.Override
  public boolean containsNamedBindings(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetNamedBindings().getMap().containsKey(key);
  }
  /** Use {@link #getNamedBindingsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.datastore.v1.GqlQueryParameter>
      getNamedBindings() {
    return getNamedBindingsMap();
  }
  /**
   *
   *
   * <pre>
   * For each non-reserved named binding site in the query string, there must be
   * a named parameter with that name, but not necessarily the inverse.
   * Key must match regex `[A-Za-z_$][A-Za-z_$0-9]*`, must not match regex
   * `__.*__`, and must not be `""`.
   * </pre>
   *
   * <code>map&lt;string, .google.datastore.v1.GqlQueryParameter&gt; named_bindings = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.datastore.v1.GqlQueryParameter>
      getNamedBindingsMap() {
    return internalGetNamedBindings().getMap();
  }
  /**
   *
   *
   * <pre>
   * For each non-reserved named binding site in the query string, there must be
   * a named parameter with that name, but not necessarily the inverse.
   * Key must match regex `[A-Za-z_$][A-Za-z_$0-9]*`, must not match regex
   * `__.*__`, and must not be `""`.
   * </pre>
   *
   * <code>map&lt;string, .google.datastore.v1.GqlQueryParameter&gt; named_bindings = 5;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.GqlQueryParameter getNamedBindingsOrDefault(
      java.lang.String key, com.google.datastore.v1.GqlQueryParameter defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.datastore.v1.GqlQueryParameter> map =
        internalGetNamedBindings().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * For each non-reserved named binding site in the query string, there must be
   * a named parameter with that name, but not necessarily the inverse.
   * Key must match regex `[A-Za-z_$][A-Za-z_$0-9]*`, must not match regex
   * `__.*__`, and must not be `""`.
   * </pre>
   *
   * <code>map&lt;string, .google.datastore.v1.GqlQueryParameter&gt; named_bindings = 5;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.GqlQueryParameter getNamedBindingsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.datastore.v1.GqlQueryParameter> map =
        internalGetNamedBindings().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int POSITIONAL_BINDINGS_FIELD_NUMBER = 4;
  private java.util.List<com.google.datastore.v1.GqlQueryParameter> positionalBindings_;
  /**
   *
   *
   * <pre>
   * Numbered binding site &#64;1 references the first numbered parameter,
   * effectively using 1-based indexing, rather than the usual 0.
   * For each binding site numbered i in `query_string`, there must be an i-th
   * numbered parameter. The inverse must also be true.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.datastore.v1.GqlQueryParameter> getPositionalBindingsList() {
    return positionalBindings_;
  }
  /**
   *
   *
   * <pre>
   * Numbered binding site &#64;1 references the first numbered parameter,
   * effectively using 1-based indexing, rather than the usual 0.
   * For each binding site numbered i in `query_string`, there must be an i-th
   * numbered parameter. The inverse must also be true.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.datastore.v1.GqlQueryParameterOrBuilder>
      getPositionalBindingsOrBuilderList() {
    return positionalBindings_;
  }
  /**
   *
   *
   * <pre>
   * Numbered binding site &#64;1 references the first numbered parameter,
   * effectively using 1-based indexing, rather than the usual 0.
   * For each binding site numbered i in `query_string`, there must be an i-th
   * numbered parameter. The inverse must also be true.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
   */
  @java.lang.Override
  public int getPositionalBindingsCount() {
    return positionalBindings_.size();
  }
  /**
   *
   *
   * <pre>
   * Numbered binding site &#64;1 references the first numbered parameter,
   * effectively using 1-based indexing, rather than the usual 0.
   * For each binding site numbered i in `query_string`, there must be an i-th
   * numbered parameter. The inverse must also be true.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.GqlQueryParameter getPositionalBindings(int index) {
    return positionalBindings_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Numbered binding site &#64;1 references the first numbered parameter,
   * effectively using 1-based indexing, rather than the usual 0.
   * For each binding site numbered i in `query_string`, there must be an i-th
   * numbered parameter. The inverse must also be true.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.GqlQueryParameterOrBuilder getPositionalBindingsOrBuilder(
      int index) {
    return positionalBindings_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(queryString_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, queryString_);
    }
    if (allowLiterals_ != false) {
      output.writeBool(2, allowLiterals_);
    }
    for (int i = 0; i < positionalBindings_.size(); i++) {
      output.writeMessage(4, positionalBindings_.get(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetNamedBindings(), NamedBindingsDefaultEntryHolder.defaultEntry, 5);
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(queryString_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, queryString_);
    }
    if (allowLiterals_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, allowLiterals_);
    }
    for (int i = 0; i < positionalBindings_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, positionalBindings_.get(i));
    }
    for (java.util.Map.Entry<java.lang.String, com.google.datastore.v1.GqlQueryParameter> entry :
        internalGetNamedBindings().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.datastore.v1.GqlQueryParameter>
          namedBindings__ =
              NamedBindingsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, namedBindings__);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.datastore.v1.GqlQuery)) {
      return super.equals(obj);
    }
    com.google.datastore.v1.GqlQuery other = (com.google.datastore.v1.GqlQuery) obj;

    if (!getQueryString().equals(other.getQueryString())) return false;
    if (getAllowLiterals() != other.getAllowLiterals()) return false;
    if (!internalGetNamedBindings().equals(other.internalGetNamedBindings())) return false;
    if (!getPositionalBindingsList().equals(other.getPositionalBindingsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + QUERY_STRING_FIELD_NUMBER;
    hash = (53 * hash) + getQueryString().hashCode();
    hash = (37 * hash) + ALLOW_LITERALS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowLiterals());
    if (!internalGetNamedBindings().getMap().isEmpty()) {
      hash = (37 * hash) + NAMED_BINDINGS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetNamedBindings().hashCode();
    }
    if (getPositionalBindingsCount() > 0) {
      hash = (37 * hash) + POSITIONAL_BINDINGS_FIELD_NUMBER;
      hash = (53 * hash) + getPositionalBindingsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.datastore.v1.GqlQuery parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.GqlQuery parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.GqlQuery parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.GqlQuery parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.GqlQuery parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.GqlQuery parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.GqlQuery parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.GqlQuery parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.GqlQuery parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.GqlQuery parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.GqlQuery parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.GqlQuery parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.datastore.v1.GqlQuery prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A [GQL
   * query](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.GqlQuery}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.datastore.v1.GqlQuery)
      com.google.datastore.v1.GqlQueryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.QueryProto
          .internal_static_google_datastore_v1_GqlQuery_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 5:
          return internalGetNamedBindings();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 5:
          return internalGetMutableNamedBindings();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.QueryProto
          .internal_static_google_datastore_v1_GqlQuery_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.GqlQuery.class,
              com.google.datastore.v1.GqlQuery.Builder.class);
    }

    // Construct using com.google.datastore.v1.GqlQuery.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPositionalBindingsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      queryString_ = "";

      allowLiterals_ = false;

      internalGetMutableNamedBindings().clear();
      if (positionalBindingsBuilder_ == null) {
        positionalBindings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        positionalBindingsBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.datastore.v1.QueryProto
          .internal_static_google_datastore_v1_GqlQuery_descriptor;
    }

    @java.lang.Override
    public com.google.datastore.v1.GqlQuery getDefaultInstanceForType() {
      return com.google.datastore.v1.GqlQuery.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.datastore.v1.GqlQuery build() {
      com.google.datastore.v1.GqlQuery result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.datastore.v1.GqlQuery buildPartial() {
      com.google.datastore.v1.GqlQuery result = new com.google.datastore.v1.GqlQuery(this);
      int from_bitField0_ = bitField0_;
      result.queryString_ = queryString_;
      result.allowLiterals_ = allowLiterals_;
      result.namedBindings_ = internalGetNamedBindings();
      result.namedBindings_.makeImmutable();
      if (positionalBindingsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          positionalBindings_ = java.util.Collections.unmodifiableList(positionalBindings_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.positionalBindings_ = positionalBindings_;
      } else {
        result.positionalBindings_ = positionalBindingsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.datastore.v1.GqlQuery) {
        return mergeFrom((com.google.datastore.v1.GqlQuery) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.datastore.v1.GqlQuery other) {
      if (other == com.google.datastore.v1.GqlQuery.getDefaultInstance()) return this;
      if (!other.getQueryString().isEmpty()) {
        queryString_ = other.queryString_;
        onChanged();
      }
      if (other.getAllowLiterals() != false) {
        setAllowLiterals(other.getAllowLiterals());
      }
      internalGetMutableNamedBindings().mergeFrom(other.internalGetNamedBindings());
      if (positionalBindingsBuilder_ == null) {
        if (!other.positionalBindings_.isEmpty()) {
          if (positionalBindings_.isEmpty()) {
            positionalBindings_ = other.positionalBindings_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePositionalBindingsIsMutable();
            positionalBindings_.addAll(other.positionalBindings_);
          }
          onChanged();
        }
      } else {
        if (!other.positionalBindings_.isEmpty()) {
          if (positionalBindingsBuilder_.isEmpty()) {
            positionalBindingsBuilder_.dispose();
            positionalBindingsBuilder_ = null;
            positionalBindings_ = other.positionalBindings_;
            bitField0_ = (bitField0_ & ~0x00000002);
            positionalBindingsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPositionalBindingsFieldBuilder()
                    : null;
          } else {
            positionalBindingsBuilder_.addAllMessages(other.positionalBindings_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.datastore.v1.GqlQuery parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.datastore.v1.GqlQuery) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object queryString_ = "";
    /**
     *
     *
     * <pre>
     * A string of the format described
     * [here](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
     * </pre>
     *
     * <code>string query_string = 1;</code>
     *
     * @return The queryString.
     */
    public java.lang.String getQueryString() {
      java.lang.Object ref = queryString_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        queryString_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A string of the format described
     * [here](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
     * </pre>
     *
     * <code>string query_string = 1;</code>
     *
     * @return The bytes for queryString.
     */
    public com.google.protobuf.ByteString getQueryStringBytes() {
      java.lang.Object ref = queryString_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        queryString_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A string of the format described
     * [here](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
     * </pre>
     *
     * <code>string query_string = 1;</code>
     *
     * @param value The queryString to set.
     * @return This builder for chaining.
     */
    public Builder setQueryString(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      queryString_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A string of the format described
     * [here](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
     * </pre>
     *
     * <code>string query_string = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQueryString() {

      queryString_ = getDefaultInstance().getQueryString();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A string of the format described
     * [here](https://cloud.google.com/datastore/docs/apis/gql/gql_reference).
     * </pre>
     *
     * <code>string query_string = 1;</code>
     *
     * @param value The bytes for queryString to set.
     * @return This builder for chaining.
     */
    public Builder setQueryStringBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      queryString_ = value;
      onChanged();
      return this;
    }

    private boolean allowLiterals_;
    /**
     *
     *
     * <pre>
     * When false, the query string must not contain any literals and instead must
     * bind all values. For example,
     * `SELECT * FROM Kind WHERE a = 'string literal'` is not allowed, while
     * `SELECT * FROM Kind WHERE a = &#64;value` is.
     * </pre>
     *
     * <code>bool allow_literals = 2;</code>
     *
     * @return The allowLiterals.
     */
    @java.lang.Override
    public boolean getAllowLiterals() {
      return allowLiterals_;
    }
    /**
     *
     *
     * <pre>
     * When false, the query string must not contain any literals and instead must
     * bind all values. For example,
     * `SELECT * FROM Kind WHERE a = 'string literal'` is not allowed, while
     * `SELECT * FROM Kind WHERE a = &#64;value` is.
     * </pre>
     *
     * <code>bool allow_literals = 2;</code>
     *
     * @param value The allowLiterals to set.
     * @return This builder for chaining.
     */
    public Builder setAllowLiterals(boolean value) {

      allowLiterals_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When false, the query string must not contain any literals and instead must
     * bind all values. For example,
     * `SELECT * FROM Kind WHERE a = 'string literal'` is not allowed, while
     * `SELECT * FROM Kind WHERE a = &#64;value` is.
     * </pre>
     *
     * <code>bool allow_literals = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowLiterals() {

      allowLiterals_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.datastore.v1.GqlQueryParameter>
        namedBindings_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.datastore.v1.GqlQueryParameter>
        internalGetNamedBindings() {
      if (namedBindings_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            NamedBindingsDefaultEntryHolder.defaultEntry);
      }
      return namedBindings_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.datastore.v1.GqlQueryParameter>
        internalGetMutableNamedBindings() {
      onChanged();
      ;
      if (namedBindings_ == null) {
        namedBindings_ =
            com.google.protobuf.MapField.newMapField(NamedBindingsDefaultEntryHolder.defaultEntry);
      }
      if (!namedBindings_.isMutable()) {
        namedBindings_ = namedBindings_.copy();
      }
      return namedBindings_;
    }

    public int getNamedBindingsCount() {
      return internalGetNamedBindings().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * For each non-reserved named binding site in the query string, there must be
     * a named parameter with that name, but not necessarily the inverse.
     * Key must match regex `[A-Za-z_$][A-Za-z_$0-9]*`, must not match regex
     * `__.*__`, and must not be `""`.
     * </pre>
     *
     * <code>map&lt;string, .google.datastore.v1.GqlQueryParameter&gt; named_bindings = 5;</code>
     */
    @java.lang.Override
    public boolean containsNamedBindings(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetNamedBindings().getMap().containsKey(key);
    }
    /** Use {@link #getNamedBindingsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.datastore.v1.GqlQueryParameter>
        getNamedBindings() {
      return getNamedBindingsMap();
    }
    /**
     *
     *
     * <pre>
     * For each non-reserved named binding site in the query string, there must be
     * a named parameter with that name, but not necessarily the inverse.
     * Key must match regex `[A-Za-z_$][A-Za-z_$0-9]*`, must not match regex
     * `__.*__`, and must not be `""`.
     * </pre>
     *
     * <code>map&lt;string, .google.datastore.v1.GqlQueryParameter&gt; named_bindings = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.datastore.v1.GqlQueryParameter>
        getNamedBindingsMap() {
      return internalGetNamedBindings().getMap();
    }
    /**
     *
     *
     * <pre>
     * For each non-reserved named binding site in the query string, there must be
     * a named parameter with that name, but not necessarily the inverse.
     * Key must match regex `[A-Za-z_$][A-Za-z_$0-9]*`, must not match regex
     * `__.*__`, and must not be `""`.
     * </pre>
     *
     * <code>map&lt;string, .google.datastore.v1.GqlQueryParameter&gt; named_bindings = 5;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.GqlQueryParameter getNamedBindingsOrDefault(
        java.lang.String key, com.google.datastore.v1.GqlQueryParameter defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.datastore.v1.GqlQueryParameter> map =
          internalGetNamedBindings().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * For each non-reserved named binding site in the query string, there must be
     * a named parameter with that name, but not necessarily the inverse.
     * Key must match regex `[A-Za-z_$][A-Za-z_$0-9]*`, must not match regex
     * `__.*__`, and must not be `""`.
     * </pre>
     *
     * <code>map&lt;string, .google.datastore.v1.GqlQueryParameter&gt; named_bindings = 5;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.GqlQueryParameter getNamedBindingsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.datastore.v1.GqlQueryParameter> map =
          internalGetNamedBindings().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearNamedBindings() {
      internalGetMutableNamedBindings().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For each non-reserved named binding site in the query string, there must be
     * a named parameter with that name, but not necessarily the inverse.
     * Key must match regex `[A-Za-z_$][A-Za-z_$0-9]*`, must not match regex
     * `__.*__`, and must not be `""`.
     * </pre>
     *
     * <code>map&lt;string, .google.datastore.v1.GqlQueryParameter&gt; named_bindings = 5;</code>
     */
    public Builder removeNamedBindings(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableNamedBindings().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.datastore.v1.GqlQueryParameter>
        getMutableNamedBindings() {
      return internalGetMutableNamedBindings().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * For each non-reserved named binding site in the query string, there must be
     * a named parameter with that name, but not necessarily the inverse.
     * Key must match regex `[A-Za-z_$][A-Za-z_$0-9]*`, must not match regex
     * `__.*__`, and must not be `""`.
     * </pre>
     *
     * <code>map&lt;string, .google.datastore.v1.GqlQueryParameter&gt; named_bindings = 5;</code>
     */
    public Builder putNamedBindings(
        java.lang.String key, com.google.datastore.v1.GqlQueryParameter value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableNamedBindings().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * For each non-reserved named binding site in the query string, there must be
     * a named parameter with that name, but not necessarily the inverse.
     * Key must match regex `[A-Za-z_$][A-Za-z_$0-9]*`, must not match regex
     * `__.*__`, and must not be `""`.
     * </pre>
     *
     * <code>map&lt;string, .google.datastore.v1.GqlQueryParameter&gt; named_bindings = 5;</code>
     */
    public Builder putAllNamedBindings(
        java.util.Map<java.lang.String, com.google.datastore.v1.GqlQueryParameter> values) {
      internalGetMutableNamedBindings().getMutableMap().putAll(values);
      return this;
    }

    private java.util.List<com.google.datastore.v1.GqlQueryParameter> positionalBindings_ =
        java.util.Collections.emptyList();

    private void ensurePositionalBindingsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        positionalBindings_ =
            new java.util.ArrayList<com.google.datastore.v1.GqlQueryParameter>(positionalBindings_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.GqlQueryParameter,
            com.google.datastore.v1.GqlQueryParameter.Builder,
            com.google.datastore.v1.GqlQueryParameterOrBuilder>
        positionalBindingsBuilder_;

    /**
     *
     *
     * <pre>
     * Numbered binding site &#64;1 references the first numbered parameter,
     * effectively using 1-based indexing, rather than the usual 0.
     * For each binding site numbered i in `query_string`, there must be an i-th
     * numbered parameter. The inverse must also be true.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
     */
    public java.util.List<com.google.datastore.v1.GqlQueryParameter> getPositionalBindingsList() {
      if (positionalBindingsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(positionalBindings_);
      } else {
        return positionalBindingsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Numbered binding site &#64;1 references the first numbered parameter,
     * effectively using 1-based indexing, rather than the usual 0.
     * For each binding site numbered i in `query_string`, there must be an i-th
     * numbered parameter. The inverse must also be true.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
     */
    public int getPositionalBindingsCount() {
      if (positionalBindingsBuilder_ == null) {
        return positionalBindings_.size();
      } else {
        return positionalBindingsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Numbered binding site &#64;1 references the first numbered parameter,
     * effectively using 1-based indexing, rather than the usual 0.
     * For each binding site numbered i in `query_string`, there must be an i-th
     * numbered parameter. The inverse must also be true.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
     */
    public com.google.datastore.v1.GqlQueryParameter getPositionalBindings(int index) {
      if (positionalBindingsBuilder_ == null) {
        return positionalBindings_.get(index);
      } else {
        return positionalBindingsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Numbered binding site &#64;1 references the first numbered parameter,
     * effectively using 1-based indexing, rather than the usual 0.
     * For each binding site numbered i in `query_string`, there must be an i-th
     * numbered parameter. The inverse must also be true.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
     */
    public Builder setPositionalBindings(
        int index, com.google.datastore.v1.GqlQueryParameter value) {
      if (positionalBindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePositionalBindingsIsMutable();
        positionalBindings_.set(index, value);
        onChanged();
      } else {
        positionalBindingsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Numbered binding site &#64;1 references the first numbered parameter,
     * effectively using 1-based indexing, rather than the usual 0.
     * For each binding site numbered i in `query_string`, there must be an i-th
     * numbered parameter. The inverse must also be true.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
     */
    public Builder setPositionalBindings(
        int index, com.google.datastore.v1.GqlQueryParameter.Builder builderForValue) {
      if (positionalBindingsBuilder_ == null) {
        ensurePositionalBindingsIsMutable();
        positionalBindings_.set(index, builderForValue.build());
        onChanged();
      } else {
        positionalBindingsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Numbered binding site &#64;1 references the first numbered parameter,
     * effectively using 1-based indexing, rather than the usual 0.
     * For each binding site numbered i in `query_string`, there must be an i-th
     * numbered parameter. The inverse must also be true.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
     */
    public Builder addPositionalBindings(com.google.datastore.v1.GqlQueryParameter value) {
      if (positionalBindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePositionalBindingsIsMutable();
        positionalBindings_.add(value);
        onChanged();
      } else {
        positionalBindingsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Numbered binding site &#64;1 references the first numbered parameter,
     * effectively using 1-based indexing, rather than the usual 0.
     * For each binding site numbered i in `query_string`, there must be an i-th
     * numbered parameter. The inverse must also be true.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
     */
    public Builder addPositionalBindings(
        int index, com.google.datastore.v1.GqlQueryParameter value) {
      if (positionalBindingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePositionalBindingsIsMutable();
        positionalBindings_.add(index, value);
        onChanged();
      } else {
        positionalBindingsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Numbered binding site &#64;1 references the first numbered parameter,
     * effectively using 1-based indexing, rather than the usual 0.
     * For each binding site numbered i in `query_string`, there must be an i-th
     * numbered parameter. The inverse must also be true.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
     */
    public Builder addPositionalBindings(
        com.google.datastore.v1.GqlQueryParameter.Builder builderForValue) {
      if (positionalBindingsBuilder_ == null) {
        ensurePositionalBindingsIsMutable();
        positionalBindings_.add(builderForValue.build());
        onChanged();
      } else {
        positionalBindingsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Numbered binding site &#64;1 references the first numbered parameter,
     * effectively using 1-based indexing, rather than the usual 0.
     * For each binding site numbered i in `query_string`, there must be an i-th
     * numbered parameter. The inverse must also be true.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
     */
    public Builder addPositionalBindings(
        int index, com.google.datastore.v1.GqlQueryParameter.Builder builderForValue) {
      if (positionalBindingsBuilder_ == null) {
        ensurePositionalBindingsIsMutable();
        positionalBindings_.add(index, builderForValue.build());
        onChanged();
      } else {
        positionalBindingsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Numbered binding site &#64;1 references the first numbered parameter,
     * effectively using 1-based indexing, rather than the usual 0.
     * For each binding site numbered i in `query_string`, there must be an i-th
     * numbered parameter. The inverse must also be true.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
     */
    public Builder addAllPositionalBindings(
        java.lang.Iterable<? extends com.google.datastore.v1.GqlQueryParameter> values) {
      if (positionalBindingsBuilder_ == null) {
        ensurePositionalBindingsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, positionalBindings_);
        onChanged();
      } else {
        positionalBindingsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Numbered binding site &#64;1 references the first numbered parameter,
     * effectively using 1-based indexing, rather than the usual 0.
     * For each binding site numbered i in `query_string`, there must be an i-th
     * numbered parameter. The inverse must also be true.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
     */
    public Builder clearPositionalBindings() {
      if (positionalBindingsBuilder_ == null) {
        positionalBindings_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        positionalBindingsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Numbered binding site &#64;1 references the first numbered parameter,
     * effectively using 1-based indexing, rather than the usual 0.
     * For each binding site numbered i in `query_string`, there must be an i-th
     * numbered parameter. The inverse must also be true.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
     */
    public Builder removePositionalBindings(int index) {
      if (positionalBindingsBuilder_ == null) {
        ensurePositionalBindingsIsMutable();
        positionalBindings_.remove(index);
        onChanged();
      } else {
        positionalBindingsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Numbered binding site &#64;1 references the first numbered parameter,
     * effectively using 1-based indexing, rather than the usual 0.
     * For each binding site numbered i in `query_string`, there must be an i-th
     * numbered parameter. The inverse must also be true.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
     */
    public com.google.datastore.v1.GqlQueryParameter.Builder getPositionalBindingsBuilder(
        int index) {
      return getPositionalBindingsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Numbered binding site &#64;1 references the first numbered parameter,
     * effectively using 1-based indexing, rather than the usual 0.
     * For each binding site numbered i in `query_string`, there must be an i-th
     * numbered parameter. The inverse must also be true.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
     */
    public com.google.datastore.v1.GqlQueryParameterOrBuilder getPositionalBindingsOrBuilder(
        int index) {
      if (positionalBindingsBuilder_ == null) {
        return positionalBindings_.get(index);
      } else {
        return positionalBindingsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Numbered binding site &#64;1 references the first numbered parameter,
     * effectively using 1-based indexing, rather than the usual 0.
     * For each binding site numbered i in `query_string`, there must be an i-th
     * numbered parameter. The inverse must also be true.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
     */
    public java.util.List<? extends com.google.datastore.v1.GqlQueryParameterOrBuilder>
        getPositionalBindingsOrBuilderList() {
      if (positionalBindingsBuilder_ != null) {
        return positionalBindingsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(positionalBindings_);
      }
    }
    /**
     *
     *
     * <pre>
     * Numbered binding site &#64;1 references the first numbered parameter,
     * effectively using 1-based indexing, rather than the usual 0.
     * For each binding site numbered i in `query_string`, there must be an i-th
     * numbered parameter. The inverse must also be true.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
     */
    public com.google.datastore.v1.GqlQueryParameter.Builder addPositionalBindingsBuilder() {
      return getPositionalBindingsFieldBuilder()
          .addBuilder(com.google.datastore.v1.GqlQueryParameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Numbered binding site &#64;1 references the first numbered parameter,
     * effectively using 1-based indexing, rather than the usual 0.
     * For each binding site numbered i in `query_string`, there must be an i-th
     * numbered parameter. The inverse must also be true.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
     */
    public com.google.datastore.v1.GqlQueryParameter.Builder addPositionalBindingsBuilder(
        int index) {
      return getPositionalBindingsFieldBuilder()
          .addBuilder(index, com.google.datastore.v1.GqlQueryParameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Numbered binding site &#64;1 references the first numbered parameter,
     * effectively using 1-based indexing, rather than the usual 0.
     * For each binding site numbered i in `query_string`, there must be an i-th
     * numbered parameter. The inverse must also be true.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.GqlQueryParameter positional_bindings = 4;</code>
     */
    public java.util.List<com.google.datastore.v1.GqlQueryParameter.Builder>
        getPositionalBindingsBuilderList() {
      return getPositionalBindingsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.GqlQueryParameter,
            com.google.datastore.v1.GqlQueryParameter.Builder,
            com.google.datastore.v1.GqlQueryParameterOrBuilder>
        getPositionalBindingsFieldBuilder() {
      if (positionalBindingsBuilder_ == null) {
        positionalBindingsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.datastore.v1.GqlQueryParameter,
                com.google.datastore.v1.GqlQueryParameter.Builder,
                com.google.datastore.v1.GqlQueryParameterOrBuilder>(
                positionalBindings_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        positionalBindings_ = null;
      }
      return positionalBindingsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.datastore.v1.GqlQuery)
  }

  // @@protoc_insertion_point(class_scope:google.datastore.v1.GqlQuery)
  private static final com.google.datastore.v1.GqlQuery DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.datastore.v1.GqlQuery();
  }

  public static com.google.datastore.v1.GqlQuery getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GqlQuery> PARSER =
      new com.google.protobuf.AbstractParser<GqlQuery>() {
        @java.lang.Override
        public GqlQuery parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new GqlQuery(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<GqlQuery> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GqlQuery> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.datastore.v1.GqlQuery getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
