/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/v1/aggregation_result.proto

package com.google.datastore.v1;

/**
 *
 *
 * <pre>
 * A batch of aggregation results produced by an aggregation query.
 * </pre>
 *
 * Protobuf type {@code google.datastore.v1.AggregationResultBatch}
 */
public final class AggregationResultBatch extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.datastore.v1.AggregationResultBatch)
    AggregationResultBatchOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AggregationResultBatch.newBuilder() to construct.
  private AggregationResultBatch(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AggregationResultBatch() {
    aggregationResults_ = java.util.Collections.emptyList();
    moreResults_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AggregationResultBatch();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.datastore.v1.AggregationResultProto
        .internal_static_google_datastore_v1_AggregationResultBatch_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.datastore.v1.AggregationResultProto
        .internal_static_google_datastore_v1_AggregationResultBatch_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.datastore.v1.AggregationResultBatch.class,
            com.google.datastore.v1.AggregationResultBatch.Builder.class);
  }

  public static final int AGGREGATION_RESULTS_FIELD_NUMBER = 1;
  private java.util.List<com.google.datastore.v1.AggregationResult> aggregationResults_;
  /**
   *
   *
   * <pre>
   * The aggregation results for this batch.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.datastore.v1.AggregationResult> getAggregationResultsList() {
    return aggregationResults_;
  }
  /**
   *
   *
   * <pre>
   * The aggregation results for this batch.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.datastore.v1.AggregationResultOrBuilder>
      getAggregationResultsOrBuilderList() {
    return aggregationResults_;
  }
  /**
   *
   *
   * <pre>
   * The aggregation results for this batch.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
   */
  @java.lang.Override
  public int getAggregationResultsCount() {
    return aggregationResults_.size();
  }
  /**
   *
   *
   * <pre>
   * The aggregation results for this batch.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.AggregationResult getAggregationResults(int index) {
    return aggregationResults_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The aggregation results for this batch.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.AggregationResultOrBuilder getAggregationResultsOrBuilder(
      int index) {
    return aggregationResults_.get(index);
  }

  public static final int MORE_RESULTS_FIELD_NUMBER = 2;
  private int moreResults_;
  /**
   *
   *
   * <pre>
   * The state of the query after the current batch.
   * Only COUNT(*) aggregations are supported in the initial launch. Therefore,
   * expected result type is limited to `NO_MORE_RESULTS`.
   * </pre>
   *
   * <code>.google.datastore.v1.QueryResultBatch.MoreResultsType more_results = 2;</code>
   *
   * @return The enum numeric value on the wire for moreResults.
   */
  @java.lang.Override
  public int getMoreResultsValue() {
    return moreResults_;
  }
  /**
   *
   *
   * <pre>
   * The state of the query after the current batch.
   * Only COUNT(*) aggregations are supported in the initial launch. Therefore,
   * expected result type is limited to `NO_MORE_RESULTS`.
   * </pre>
   *
   * <code>.google.datastore.v1.QueryResultBatch.MoreResultsType more_results = 2;</code>
   *
   * @return The moreResults.
   */
  @java.lang.Override
  public com.google.datastore.v1.QueryResultBatch.MoreResultsType getMoreResults() {
    @SuppressWarnings("deprecation")
    com.google.datastore.v1.QueryResultBatch.MoreResultsType result =
        com.google.datastore.v1.QueryResultBatch.MoreResultsType.valueOf(moreResults_);
    return result == null
        ? com.google.datastore.v1.QueryResultBatch.MoreResultsType.UNRECOGNIZED
        : result;
  }

  public static final int READ_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp readTime_;
  /**
   *
   *
   * <pre>
   * Read timestamp this batch was returned from.
   * In a single transaction, subsequent query result batches for the same query
   * can have a greater timestamp. Each batch's read timestamp
   * is valid for all preceding batches.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 3;</code>
   *
   * @return Whether the readTime field is set.
   */
  @java.lang.Override
  public boolean hasReadTime() {
    return readTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Read timestamp this batch was returned from.
   * In a single transaction, subsequent query result batches for the same query
   * can have a greater timestamp. Each batch's read timestamp
   * is valid for all preceding batches.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 3;</code>
   *
   * @return The readTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getReadTime() {
    return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
  }
  /**
   *
   *
   * <pre>
   * Read timestamp this batch was returned from.
   * In a single transaction, subsequent query result batches for the same query
   * can have a greater timestamp. Each batch's read timestamp
   * is valid for all preceding batches.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
    return getReadTime();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < aggregationResults_.size(); i++) {
      output.writeMessage(1, aggregationResults_.get(i));
    }
    if (moreResults_
        != com.google.datastore.v1.QueryResultBatch.MoreResultsType.MORE_RESULTS_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, moreResults_);
    }
    if (readTime_ != null) {
      output.writeMessage(3, getReadTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < aggregationResults_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, aggregationResults_.get(i));
    }
    if (moreResults_
        != com.google.datastore.v1.QueryResultBatch.MoreResultsType.MORE_RESULTS_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, moreResults_);
    }
    if (readTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getReadTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.datastore.v1.AggregationResultBatch)) {
      return super.equals(obj);
    }
    com.google.datastore.v1.AggregationResultBatch other =
        (com.google.datastore.v1.AggregationResultBatch) obj;

    if (!getAggregationResultsList().equals(other.getAggregationResultsList())) return false;
    if (moreResults_ != other.moreResults_) return false;
    if (hasReadTime() != other.hasReadTime()) return false;
    if (hasReadTime()) {
      if (!getReadTime().equals(other.getReadTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAggregationResultsCount() > 0) {
      hash = (37 * hash) + AGGREGATION_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getAggregationResultsList().hashCode();
    }
    hash = (37 * hash) + MORE_RESULTS_FIELD_NUMBER;
    hash = (53 * hash) + moreResults_;
    if (hasReadTime()) {
      hash = (37 * hash) + READ_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getReadTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.datastore.v1.AggregationResultBatch parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.AggregationResultBatch parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.AggregationResultBatch parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.AggregationResultBatch parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.AggregationResultBatch parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.AggregationResultBatch parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.AggregationResultBatch parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.AggregationResultBatch parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.AggregationResultBatch parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.AggregationResultBatch parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.AggregationResultBatch parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.AggregationResultBatch parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.datastore.v1.AggregationResultBatch prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A batch of aggregation results produced by an aggregation query.
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.AggregationResultBatch}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.datastore.v1.AggregationResultBatch)
      com.google.datastore.v1.AggregationResultBatchOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.AggregationResultProto
          .internal_static_google_datastore_v1_AggregationResultBatch_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.AggregationResultProto
          .internal_static_google_datastore_v1_AggregationResultBatch_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.AggregationResultBatch.class,
              com.google.datastore.v1.AggregationResultBatch.Builder.class);
    }

    // Construct using com.google.datastore.v1.AggregationResultBatch.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (aggregationResultsBuilder_ == null) {
        aggregationResults_ = java.util.Collections.emptyList();
      } else {
        aggregationResults_ = null;
        aggregationResultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      moreResults_ = 0;

      if (readTimeBuilder_ == null) {
        readTime_ = null;
      } else {
        readTime_ = null;
        readTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.datastore.v1.AggregationResultProto
          .internal_static_google_datastore_v1_AggregationResultBatch_descriptor;
    }

    @java.lang.Override
    public com.google.datastore.v1.AggregationResultBatch getDefaultInstanceForType() {
      return com.google.datastore.v1.AggregationResultBatch.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.datastore.v1.AggregationResultBatch build() {
      com.google.datastore.v1.AggregationResultBatch result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.datastore.v1.AggregationResultBatch buildPartial() {
      com.google.datastore.v1.AggregationResultBatch result =
          new com.google.datastore.v1.AggregationResultBatch(this);
      int from_bitField0_ = bitField0_;
      if (aggregationResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          aggregationResults_ = java.util.Collections.unmodifiableList(aggregationResults_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.aggregationResults_ = aggregationResults_;
      } else {
        result.aggregationResults_ = aggregationResultsBuilder_.build();
      }
      result.moreResults_ = moreResults_;
      if (readTimeBuilder_ == null) {
        result.readTime_ = readTime_;
      } else {
        result.readTime_ = readTimeBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.datastore.v1.AggregationResultBatch) {
        return mergeFrom((com.google.datastore.v1.AggregationResultBatch) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.datastore.v1.AggregationResultBatch other) {
      if (other == com.google.datastore.v1.AggregationResultBatch.getDefaultInstance()) return this;
      if (aggregationResultsBuilder_ == null) {
        if (!other.aggregationResults_.isEmpty()) {
          if (aggregationResults_.isEmpty()) {
            aggregationResults_ = other.aggregationResults_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAggregationResultsIsMutable();
            aggregationResults_.addAll(other.aggregationResults_);
          }
          onChanged();
        }
      } else {
        if (!other.aggregationResults_.isEmpty()) {
          if (aggregationResultsBuilder_.isEmpty()) {
            aggregationResultsBuilder_.dispose();
            aggregationResultsBuilder_ = null;
            aggregationResults_ = other.aggregationResults_;
            bitField0_ = (bitField0_ & ~0x00000001);
            aggregationResultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAggregationResultsFieldBuilder()
                    : null;
          } else {
            aggregationResultsBuilder_.addAllMessages(other.aggregationResults_);
          }
        }
      }
      if (other.moreResults_ != 0) {
        setMoreResultsValue(other.getMoreResultsValue());
      }
      if (other.hasReadTime()) {
        mergeReadTime(other.getReadTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.datastore.v1.AggregationResult m =
                    input.readMessage(
                        com.google.datastore.v1.AggregationResult.parser(), extensionRegistry);
                if (aggregationResultsBuilder_ == null) {
                  ensureAggregationResultsIsMutable();
                  aggregationResults_.add(m);
                } else {
                  aggregationResultsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 16:
              {
                moreResults_ = input.readEnum();

                break;
              } // case 16
            case 26:
              {
                input.readMessage(getReadTimeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.datastore.v1.AggregationResult> aggregationResults_ =
        java.util.Collections.emptyList();

    private void ensureAggregationResultsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        aggregationResults_ =
            new java.util.ArrayList<com.google.datastore.v1.AggregationResult>(aggregationResults_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.AggregationResult,
            com.google.datastore.v1.AggregationResult.Builder,
            com.google.datastore.v1.AggregationResultOrBuilder>
        aggregationResultsBuilder_;

    /**
     *
     *
     * <pre>
     * The aggregation results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
     */
    public java.util.List<com.google.datastore.v1.AggregationResult> getAggregationResultsList() {
      if (aggregationResultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(aggregationResults_);
      } else {
        return aggregationResultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The aggregation results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
     */
    public int getAggregationResultsCount() {
      if (aggregationResultsBuilder_ == null) {
        return aggregationResults_.size();
      } else {
        return aggregationResultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The aggregation results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
     */
    public com.google.datastore.v1.AggregationResult getAggregationResults(int index) {
      if (aggregationResultsBuilder_ == null) {
        return aggregationResults_.get(index);
      } else {
        return aggregationResultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The aggregation results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
     */
    public Builder setAggregationResults(
        int index, com.google.datastore.v1.AggregationResult value) {
      if (aggregationResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregationResultsIsMutable();
        aggregationResults_.set(index, value);
        onChanged();
      } else {
        aggregationResultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The aggregation results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
     */
    public Builder setAggregationResults(
        int index, com.google.datastore.v1.AggregationResult.Builder builderForValue) {
      if (aggregationResultsBuilder_ == null) {
        ensureAggregationResultsIsMutable();
        aggregationResults_.set(index, builderForValue.build());
        onChanged();
      } else {
        aggregationResultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The aggregation results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
     */
    public Builder addAggregationResults(com.google.datastore.v1.AggregationResult value) {
      if (aggregationResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregationResultsIsMutable();
        aggregationResults_.add(value);
        onChanged();
      } else {
        aggregationResultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The aggregation results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
     */
    public Builder addAggregationResults(
        int index, com.google.datastore.v1.AggregationResult value) {
      if (aggregationResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregationResultsIsMutable();
        aggregationResults_.add(index, value);
        onChanged();
      } else {
        aggregationResultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The aggregation results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
     */
    public Builder addAggregationResults(
        com.google.datastore.v1.AggregationResult.Builder builderForValue) {
      if (aggregationResultsBuilder_ == null) {
        ensureAggregationResultsIsMutable();
        aggregationResults_.add(builderForValue.build());
        onChanged();
      } else {
        aggregationResultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The aggregation results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
     */
    public Builder addAggregationResults(
        int index, com.google.datastore.v1.AggregationResult.Builder builderForValue) {
      if (aggregationResultsBuilder_ == null) {
        ensureAggregationResultsIsMutable();
        aggregationResults_.add(index, builderForValue.build());
        onChanged();
      } else {
        aggregationResultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The aggregation results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
     */
    public Builder addAllAggregationResults(
        java.lang.Iterable<? extends com.google.datastore.v1.AggregationResult> values) {
      if (aggregationResultsBuilder_ == null) {
        ensureAggregationResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, aggregationResults_);
        onChanged();
      } else {
        aggregationResultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The aggregation results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
     */
    public Builder clearAggregationResults() {
      if (aggregationResultsBuilder_ == null) {
        aggregationResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        aggregationResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The aggregation results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
     */
    public Builder removeAggregationResults(int index) {
      if (aggregationResultsBuilder_ == null) {
        ensureAggregationResultsIsMutable();
        aggregationResults_.remove(index);
        onChanged();
      } else {
        aggregationResultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The aggregation results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
     */
    public com.google.datastore.v1.AggregationResult.Builder getAggregationResultsBuilder(
        int index) {
      return getAggregationResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The aggregation results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
     */
    public com.google.datastore.v1.AggregationResultOrBuilder getAggregationResultsOrBuilder(
        int index) {
      if (aggregationResultsBuilder_ == null) {
        return aggregationResults_.get(index);
      } else {
        return aggregationResultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The aggregation results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
     */
    public java.util.List<? extends com.google.datastore.v1.AggregationResultOrBuilder>
        getAggregationResultsOrBuilderList() {
      if (aggregationResultsBuilder_ != null) {
        return aggregationResultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(aggregationResults_);
      }
    }
    /**
     *
     *
     * <pre>
     * The aggregation results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
     */
    public com.google.datastore.v1.AggregationResult.Builder addAggregationResultsBuilder() {
      return getAggregationResultsFieldBuilder()
          .addBuilder(com.google.datastore.v1.AggregationResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The aggregation results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
     */
    public com.google.datastore.v1.AggregationResult.Builder addAggregationResultsBuilder(
        int index) {
      return getAggregationResultsFieldBuilder()
          .addBuilder(index, com.google.datastore.v1.AggregationResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The aggregation results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.AggregationResult aggregation_results = 1;</code>
     */
    public java.util.List<com.google.datastore.v1.AggregationResult.Builder>
        getAggregationResultsBuilderList() {
      return getAggregationResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.AggregationResult,
            com.google.datastore.v1.AggregationResult.Builder,
            com.google.datastore.v1.AggregationResultOrBuilder>
        getAggregationResultsFieldBuilder() {
      if (aggregationResultsBuilder_ == null) {
        aggregationResultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.datastore.v1.AggregationResult,
                com.google.datastore.v1.AggregationResult.Builder,
                com.google.datastore.v1.AggregationResultOrBuilder>(
                aggregationResults_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        aggregationResults_ = null;
      }
      return aggregationResultsBuilder_;
    }

    private int moreResults_ = 0;
    /**
     *
     *
     * <pre>
     * The state of the query after the current batch.
     * Only COUNT(*) aggregations are supported in the initial launch. Therefore,
     * expected result type is limited to `NO_MORE_RESULTS`.
     * </pre>
     *
     * <code>.google.datastore.v1.QueryResultBatch.MoreResultsType more_results = 2;</code>
     *
     * @return The enum numeric value on the wire for moreResults.
     */
    @java.lang.Override
    public int getMoreResultsValue() {
      return moreResults_;
    }
    /**
     *
     *
     * <pre>
     * The state of the query after the current batch.
     * Only COUNT(*) aggregations are supported in the initial launch. Therefore,
     * expected result type is limited to `NO_MORE_RESULTS`.
     * </pre>
     *
     * <code>.google.datastore.v1.QueryResultBatch.MoreResultsType more_results = 2;</code>
     *
     * @param value The enum numeric value on the wire for moreResults to set.
     * @return This builder for chaining.
     */
    public Builder setMoreResultsValue(int value) {

      moreResults_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the query after the current batch.
     * Only COUNT(*) aggregations are supported in the initial launch. Therefore,
     * expected result type is limited to `NO_MORE_RESULTS`.
     * </pre>
     *
     * <code>.google.datastore.v1.QueryResultBatch.MoreResultsType more_results = 2;</code>
     *
     * @return The moreResults.
     */
    @java.lang.Override
    public com.google.datastore.v1.QueryResultBatch.MoreResultsType getMoreResults() {
      @SuppressWarnings("deprecation")
      com.google.datastore.v1.QueryResultBatch.MoreResultsType result =
          com.google.datastore.v1.QueryResultBatch.MoreResultsType.valueOf(moreResults_);
      return result == null
          ? com.google.datastore.v1.QueryResultBatch.MoreResultsType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The state of the query after the current batch.
     * Only COUNT(*) aggregations are supported in the initial launch. Therefore,
     * expected result type is limited to `NO_MORE_RESULTS`.
     * </pre>
     *
     * <code>.google.datastore.v1.QueryResultBatch.MoreResultsType more_results = 2;</code>
     *
     * @param value The moreResults to set.
     * @return This builder for chaining.
     */
    public Builder setMoreResults(com.google.datastore.v1.QueryResultBatch.MoreResultsType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      moreResults_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the query after the current batch.
     * Only COUNT(*) aggregations are supported in the initial launch. Therefore,
     * expected result type is limited to `NO_MORE_RESULTS`.
     * </pre>
     *
     * <code>.google.datastore.v1.QueryResultBatch.MoreResultsType more_results = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMoreResults() {

      moreResults_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp readTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        readTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Read timestamp this batch was returned from.
     * In a single transaction, subsequent query result batches for the same query
     * can have a greater timestamp. Each batch's read timestamp
     * is valid for all preceding batches.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     *
     * @return Whether the readTime field is set.
     */
    public boolean hasReadTime() {
      return readTimeBuilder_ != null || readTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Read timestamp this batch was returned from.
     * In a single transaction, subsequent query result batches for the same query
     * can have a greater timestamp. Each batch's read timestamp
     * is valid for all preceding batches.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     *
     * @return The readTime.
     */
    public com.google.protobuf.Timestamp getReadTime() {
      if (readTimeBuilder_ == null) {
        return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
      } else {
        return readTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Read timestamp this batch was returned from.
     * In a single transaction, subsequent query result batches for the same query
     * can have a greater timestamp. Each batch's read timestamp
     * is valid for all preceding batches.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readTime_ = value;
        onChanged();
      } else {
        readTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Read timestamp this batch was returned from.
     * In a single transaction, subsequent query result batches for the same query
     * can have a greater timestamp. Each batch's read timestamp
     * is valid for all preceding batches.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (readTimeBuilder_ == null) {
        readTime_ = builderForValue.build();
        onChanged();
      } else {
        readTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Read timestamp this batch was returned from.
     * In a single transaction, subsequent query result batches for the same query
     * can have a greater timestamp. Each batch's read timestamp
     * is valid for all preceding batches.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    public Builder mergeReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (readTime_ != null) {
          readTime_ =
              com.google.protobuf.Timestamp.newBuilder(readTime_).mergeFrom(value).buildPartial();
        } else {
          readTime_ = value;
        }
        onChanged();
      } else {
        readTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Read timestamp this batch was returned from.
     * In a single transaction, subsequent query result batches for the same query
     * can have a greater timestamp. Each batch's read timestamp
     * is valid for all preceding batches.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    public Builder clearReadTime() {
      if (readTimeBuilder_ == null) {
        readTime_ = null;
        onChanged();
      } else {
        readTime_ = null;
        readTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Read timestamp this batch was returned from.
     * In a single transaction, subsequent query result batches for the same query
     * can have a greater timestamp. Each batch's read timestamp
     * is valid for all preceding batches.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getReadTimeBuilder() {

      onChanged();
      return getReadTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Read timestamp this batch was returned from.
     * In a single transaction, subsequent query result batches for the same query
     * can have a greater timestamp. Each batch's read timestamp
     * is valid for all preceding batches.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
      if (readTimeBuilder_ != null) {
        return readTimeBuilder_.getMessageOrBuilder();
      } else {
        return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Read timestamp this batch was returned from.
     * In a single transaction, subsequent query result batches for the same query
     * can have a greater timestamp. Each batch's read timestamp
     * is valid for all preceding batches.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getReadTimeFieldBuilder() {
      if (readTimeBuilder_ == null) {
        readTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getReadTime(), getParentForChildren(), isClean());
        readTime_ = null;
      }
      return readTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.datastore.v1.AggregationResultBatch)
  }

  // @@protoc_insertion_point(class_scope:google.datastore.v1.AggregationResultBatch)
  private static final com.google.datastore.v1.AggregationResultBatch DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.datastore.v1.AggregationResultBatch();
  }

  public static com.google.datastore.v1.AggregationResultBatch getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AggregationResultBatch> PARSER =
      new com.google.protobuf.AbstractParser<AggregationResultBatch>() {
        @java.lang.Override
        public AggregationResultBatch parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AggregationResultBatch> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AggregationResultBatch> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.datastore.v1.AggregationResultBatch getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
