/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/v1/entity.proto

package com.google.datastore.v1;

/**
 *
 *
 * <pre>
 * A unique identifier for an entity.
 * If a key's partition ID or any of its path kinds or names are
 * reserved/read-only, the key is reserved/read-only.
 * A reserved/read-only key is forbidden in certain documented contexts.
 * </pre>
 *
 * Protobuf type {@code google.datastore.v1.Key}
 */
public final class Key extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.datastore.v1.Key)
    KeyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Key.newBuilder() to construct.
  private Key(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Key() {
    path_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Key();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.datastore.v1.EntityProto.internal_static_google_datastore_v1_Key_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.datastore.v1.EntityProto
        .internal_static_google_datastore_v1_Key_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.datastore.v1.Key.class, com.google.datastore.v1.Key.Builder.class);
  }

  public interface PathElementOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.datastore.v1.Key.PathElement)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The kind of the entity.
     * A kind matching regex `__.*__` is reserved/read-only.
     * A kind must not contain more than 1500 bytes when UTF-8 encoded.
     * Cannot be `""`.
     * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
     * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
     * bytes.
     * </pre>
     *
     * <code>string kind = 1;</code>
     *
     * @return The kind.
     */
    java.lang.String getKind();
    /**
     *
     *
     * <pre>
     * The kind of the entity.
     * A kind matching regex `__.*__` is reserved/read-only.
     * A kind must not contain more than 1500 bytes when UTF-8 encoded.
     * Cannot be `""`.
     * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
     * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
     * bytes.
     * </pre>
     *
     * <code>string kind = 1;</code>
     *
     * @return The bytes for kind.
     */
    com.google.protobuf.ByteString getKindBytes();

    /**
     *
     *
     * <pre>
     * The auto-allocated ID of the entity.
     * Never equal to zero. Values less than zero are discouraged and may not
     * be supported in the future.
     * </pre>
     *
     * <code>int64 id = 2;</code>
     *
     * @return Whether the id field is set.
     */
    boolean hasId();
    /**
     *
     *
     * <pre>
     * The auto-allocated ID of the entity.
     * Never equal to zero. Values less than zero are discouraged and may not
     * be supported in the future.
     * </pre>
     *
     * <code>int64 id = 2;</code>
     *
     * @return The id.
     */
    long getId();

    /**
     *
     *
     * <pre>
     * The name of the entity.
     * A name matching regex `__.*__` is reserved/read-only.
     * A name must not be more than 1500 bytes when UTF-8 encoded.
     * Cannot be `""`.
     * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
     * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
     * bytes.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return Whether the name field is set.
     */
    boolean hasName();
    /**
     *
     *
     * <pre>
     * The name of the entity.
     * A name matching regex `__.*__` is reserved/read-only.
     * A name must not be more than 1500 bytes when UTF-8 encoded.
     * Cannot be `""`.
     * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
     * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
     * bytes.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * The name of the entity.
     * A name matching regex `__.*__` is reserved/read-only.
     * A name must not be more than 1500 bytes when UTF-8 encoded.
     * Cannot be `""`.
     * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
     * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
     * bytes.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    public com.google.datastore.v1.Key.PathElement.IdTypeCase getIdTypeCase();
  }
  /**
   *
   *
   * <pre>
   * A (kind, ID/name) pair used to construct a key path.
   * If either name or ID is set, the element is complete.
   * If neither is set, the element is incomplete.
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.Key.PathElement}
   */
  public static final class PathElement extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.datastore.v1.Key.PathElement)
      PathElementOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use PathElement.newBuilder() to construct.
    private PathElement(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PathElement() {
      kind_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PathElement();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.EntityProto
          .internal_static_google_datastore_v1_Key_PathElement_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.EntityProto
          .internal_static_google_datastore_v1_Key_PathElement_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.Key.PathElement.class,
              com.google.datastore.v1.Key.PathElement.Builder.class);
    }

    private int idTypeCase_ = 0;
    private java.lang.Object idType_;

    public enum IdTypeCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      ID(2),
      NAME(3),
      IDTYPE_NOT_SET(0);
      private final int value;

      private IdTypeCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static IdTypeCase valueOf(int value) {
        return forNumber(value);
      }

      public static IdTypeCase forNumber(int value) {
        switch (value) {
          case 2:
            return ID;
          case 3:
            return NAME;
          case 0:
            return IDTYPE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public IdTypeCase getIdTypeCase() {
      return IdTypeCase.forNumber(idTypeCase_);
    }

    public static final int KIND_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object kind_ = "";
    /**
     *
     *
     * <pre>
     * The kind of the entity.
     * A kind matching regex `__.*__` is reserved/read-only.
     * A kind must not contain more than 1500 bytes when UTF-8 encoded.
     * Cannot be `""`.
     * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
     * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
     * bytes.
     * </pre>
     *
     * <code>string kind = 1;</code>
     *
     * @return The kind.
     */
    @java.lang.Override
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The kind of the entity.
     * A kind matching regex `__.*__` is reserved/read-only.
     * A kind must not contain more than 1500 bytes when UTF-8 encoded.
     * Cannot be `""`.
     * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
     * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
     * bytes.
     * </pre>
     *
     * <code>string kind = 1;</code>
     *
     * @return The bytes for kind.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ID_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * The auto-allocated ID of the entity.
     * Never equal to zero. Values less than zero are discouraged and may not
     * be supported in the future.
     * </pre>
     *
     * <code>int64 id = 2;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return idTypeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The auto-allocated ID of the entity.
     * Never equal to zero. Values less than zero are discouraged and may not
     * be supported in the future.
     * </pre>
     *
     * <code>int64 id = 2;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      if (idTypeCase_ == 2) {
        return (java.lang.Long) idType_;
      }
      return 0L;
    }

    public static final int NAME_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * The name of the entity.
     * A name matching regex `__.*__` is reserved/read-only.
     * A name must not be more than 1500 bytes when UTF-8 encoded.
     * Cannot be `""`.
     * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
     * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
     * bytes.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return idTypeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The name of the entity.
     * A name matching regex `__.*__` is reserved/read-only.
     * A name must not be more than 1500 bytes when UTF-8 encoded.
     * Cannot be `""`.
     * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
     * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
     * bytes.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = "";
      if (idTypeCase_ == 3) {
        ref = idType_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (idTypeCase_ == 3) {
          idType_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the entity.
     * A name matching regex `__.*__` is reserved/read-only.
     * A name must not be more than 1500 bytes when UTF-8 encoded.
     * Cannot be `""`.
     * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
     * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
     * bytes.
     * </pre>
     *
     * <code>string name = 3;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = "";
      if (idTypeCase_ == 3) {
        ref = idType_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (idTypeCase_ == 3) {
          idType_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kind_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, kind_);
      }
      if (idTypeCase_ == 2) {
        output.writeInt64(2, (long) ((java.lang.Long) idType_));
      }
      if (idTypeCase_ == 3) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, idType_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kind_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, kind_);
      }
      if (idTypeCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt64Size(
                2, (long) ((java.lang.Long) idType_));
      }
      if (idTypeCase_ == 3) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, idType_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.datastore.v1.Key.PathElement)) {
        return super.equals(obj);
      }
      com.google.datastore.v1.Key.PathElement other = (com.google.datastore.v1.Key.PathElement) obj;

      if (!getKind().equals(other.getKind())) return false;
      if (!getIdTypeCase().equals(other.getIdTypeCase())) return false;
      switch (idTypeCase_) {
        case 2:
          if (getId() != other.getId()) return false;
          break;
        case 3:
          if (!getName().equals(other.getName())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
      switch (idTypeCase_) {
        case 2:
          hash = (37 * hash) + ID_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
          break;
        case 3:
          hash = (37 * hash) + NAME_FIELD_NUMBER;
          hash = (53 * hash) + getName().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.datastore.v1.Key.PathElement parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.v1.Key.PathElement parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.v1.Key.PathElement parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.v1.Key.PathElement parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.v1.Key.PathElement parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.v1.Key.PathElement parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.v1.Key.PathElement parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.datastore.v1.Key.PathElement parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.datastore.v1.Key.PathElement parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.datastore.v1.Key.PathElement parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.datastore.v1.Key.PathElement parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.datastore.v1.Key.PathElement parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.datastore.v1.Key.PathElement prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A (kind, ID/name) pair used to construct a key path.
     * If either name or ID is set, the element is complete.
     * If neither is set, the element is incomplete.
     * </pre>
     *
     * Protobuf type {@code google.datastore.v1.Key.PathElement}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.datastore.v1.Key.PathElement)
        com.google.datastore.v1.Key.PathElementOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.datastore.v1.EntityProto
            .internal_static_google_datastore_v1_Key_PathElement_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.datastore.v1.EntityProto
            .internal_static_google_datastore_v1_Key_PathElement_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.datastore.v1.Key.PathElement.class,
                com.google.datastore.v1.Key.PathElement.Builder.class);
      }

      // Construct using com.google.datastore.v1.Key.PathElement.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        kind_ = "";
        idTypeCase_ = 0;
        idType_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.datastore.v1.EntityProto
            .internal_static_google_datastore_v1_Key_PathElement_descriptor;
      }

      @java.lang.Override
      public com.google.datastore.v1.Key.PathElement getDefaultInstanceForType() {
        return com.google.datastore.v1.Key.PathElement.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.datastore.v1.Key.PathElement build() {
        com.google.datastore.v1.Key.PathElement result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.datastore.v1.Key.PathElement buildPartial() {
        com.google.datastore.v1.Key.PathElement result =
            new com.google.datastore.v1.Key.PathElement(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.datastore.v1.Key.PathElement result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.kind_ = kind_;
        }
      }

      private void buildPartialOneofs(com.google.datastore.v1.Key.PathElement result) {
        result.idTypeCase_ = idTypeCase_;
        result.idType_ = this.idType_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.datastore.v1.Key.PathElement) {
          return mergeFrom((com.google.datastore.v1.Key.PathElement) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.datastore.v1.Key.PathElement other) {
        if (other == com.google.datastore.v1.Key.PathElement.getDefaultInstance()) return this;
        if (!other.getKind().isEmpty()) {
          kind_ = other.kind_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        switch (other.getIdTypeCase()) {
          case ID:
            {
              setId(other.getId());
              break;
            }
          case NAME:
            {
              idTypeCase_ = 3;
              idType_ = other.idType_;
              onChanged();
              break;
            }
          case IDTYPE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  kind_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  idType_ = input.readInt64();
                  idTypeCase_ = 2;
                  break;
                } // case 16
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  idTypeCase_ = 3;
                  idType_ = s;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int idTypeCase_ = 0;
      private java.lang.Object idType_;

      public IdTypeCase getIdTypeCase() {
        return IdTypeCase.forNumber(idTypeCase_);
      }

      public Builder clearIdType() {
        idTypeCase_ = 0;
        idType_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private java.lang.Object kind_ = "";
      /**
       *
       *
       * <pre>
       * The kind of the entity.
       * A kind matching regex `__.*__` is reserved/read-only.
       * A kind must not contain more than 1500 bytes when UTF-8 encoded.
       * Cannot be `""`.
       * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
       * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
       * bytes.
       * </pre>
       *
       * <code>string kind = 1;</code>
       *
       * @return The kind.
       */
      public java.lang.String getKind() {
        java.lang.Object ref = kind_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          kind_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The kind of the entity.
       * A kind matching regex `__.*__` is reserved/read-only.
       * A kind must not contain more than 1500 bytes when UTF-8 encoded.
       * Cannot be `""`.
       * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
       * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
       * bytes.
       * </pre>
       *
       * <code>string kind = 1;</code>
       *
       * @return The bytes for kind.
       */
      public com.google.protobuf.ByteString getKindBytes() {
        java.lang.Object ref = kind_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          kind_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The kind of the entity.
       * A kind matching regex `__.*__` is reserved/read-only.
       * A kind must not contain more than 1500 bytes when UTF-8 encoded.
       * Cannot be `""`.
       * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
       * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
       * bytes.
       * </pre>
       *
       * <code>string kind = 1;</code>
       *
       * @param value The kind to set.
       * @return This builder for chaining.
       */
      public Builder setKind(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The kind of the entity.
       * A kind matching regex `__.*__` is reserved/read-only.
       * A kind must not contain more than 1500 bytes when UTF-8 encoded.
       * Cannot be `""`.
       * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
       * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
       * bytes.
       * </pre>
       *
       * <code>string kind = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearKind() {
        kind_ = getDefaultInstance().getKind();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The kind of the entity.
       * A kind matching regex `__.*__` is reserved/read-only.
       * A kind must not contain more than 1500 bytes when UTF-8 encoded.
       * Cannot be `""`.
       * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
       * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
       * bytes.
       * </pre>
       *
       * <code>string kind = 1;</code>
       *
       * @param value The bytes for kind to set.
       * @return This builder for chaining.
       */
      public Builder setKindBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        kind_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The auto-allocated ID of the entity.
       * Never equal to zero. Values less than zero are discouraged and may not
       * be supported in the future.
       * </pre>
       *
       * <code>int64 id = 2;</code>
       *
       * @return Whether the id field is set.
       */
      public boolean hasId() {
        return idTypeCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The auto-allocated ID of the entity.
       * Never equal to zero. Values less than zero are discouraged and may not
       * be supported in the future.
       * </pre>
       *
       * <code>int64 id = 2;</code>
       *
       * @return The id.
       */
      public long getId() {
        if (idTypeCase_ == 2) {
          return (java.lang.Long) idType_;
        }
        return 0L;
      }
      /**
       *
       *
       * <pre>
       * The auto-allocated ID of the entity.
       * Never equal to zero. Values less than zero are discouraged and may not
       * be supported in the future.
       * </pre>
       *
       * <code>int64 id = 2;</code>
       *
       * @param value The id to set.
       * @return This builder for chaining.
       */
      public Builder setId(long value) {

        idTypeCase_ = 2;
        idType_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The auto-allocated ID of the entity.
       * Never equal to zero. Values less than zero are discouraged and may not
       * be supported in the future.
       * </pre>
       *
       * <code>int64 id = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearId() {
        if (idTypeCase_ == 2) {
          idTypeCase_ = 0;
          idType_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the entity.
       * A name matching regex `__.*__` is reserved/read-only.
       * A name must not be more than 1500 bytes when UTF-8 encoded.
       * Cannot be `""`.
       * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
       * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
       * bytes.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @return Whether the name field is set.
       */
      @java.lang.Override
      public boolean hasName() {
        return idTypeCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * The name of the entity.
       * A name matching regex `__.*__` is reserved/read-only.
       * A name must not be more than 1500 bytes when UTF-8 encoded.
       * Cannot be `""`.
       * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
       * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
       * bytes.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @return The name.
       */
      @java.lang.Override
      public java.lang.String getName() {
        java.lang.Object ref = "";
        if (idTypeCase_ == 3) {
          ref = idType_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (idTypeCase_ == 3) {
            idType_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the entity.
       * A name matching regex `__.*__` is reserved/read-only.
       * A name must not be more than 1500 bytes when UTF-8 encoded.
       * Cannot be `""`.
       * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
       * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
       * bytes.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @return The bytes for name.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = "";
        if (idTypeCase_ == 3) {
          ref = idType_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (idTypeCase_ == 3) {
            idType_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the entity.
       * A name matching regex `__.*__` is reserved/read-only.
       * A name must not be more than 1500 bytes when UTF-8 encoded.
       * Cannot be `""`.
       * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
       * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
       * bytes.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        idTypeCase_ = 3;
        idType_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the entity.
       * A name matching regex `__.*__` is reserved/read-only.
       * A name must not be more than 1500 bytes when UTF-8 encoded.
       * Cannot be `""`.
       * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
       * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
       * bytes.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        if (idTypeCase_ == 3) {
          idTypeCase_ = 0;
          idType_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the entity.
       * A name matching regex `__.*__` is reserved/read-only.
       * A name must not be more than 1500 bytes when UTF-8 encoded.
       * Cannot be `""`.
       * Must be valid UTF-8 bytes. Legacy values that are not valid UTF-8 are
       * encoded as `__bytes&lt;X&gt;__` where `&lt;X&gt;` is the base-64 encoding of the
       * bytes.
       * </pre>
       *
       * <code>string name = 3;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        idTypeCase_ = 3;
        idType_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.datastore.v1.Key.PathElement)
    }

    // @@protoc_insertion_point(class_scope:google.datastore.v1.Key.PathElement)
    private static final com.google.datastore.v1.Key.PathElement DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.datastore.v1.Key.PathElement();
    }

    public static com.google.datastore.v1.Key.PathElement getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PathElement> PARSER =
        new com.google.protobuf.AbstractParser<PathElement>() {
          @java.lang.Override
          public PathElement parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PathElement> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PathElement> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.datastore.v1.Key.PathElement getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int PARTITION_ID_FIELD_NUMBER = 1;
  private com.google.datastore.v1.PartitionId partitionId_;
  /**
   *
   *
   * <pre>
   * Entities are partitioned into subsets, currently identified by a project
   * ID and namespace ID.
   * Queries are scoped to a single partition.
   * </pre>
   *
   * <code>.google.datastore.v1.PartitionId partition_id = 1;</code>
   *
   * @return Whether the partitionId field is set.
   */
  @java.lang.Override
  public boolean hasPartitionId() {
    return partitionId_ != null;
  }
  /**
   *
   *
   * <pre>
   * Entities are partitioned into subsets, currently identified by a project
   * ID and namespace ID.
   * Queries are scoped to a single partition.
   * </pre>
   *
   * <code>.google.datastore.v1.PartitionId partition_id = 1;</code>
   *
   * @return The partitionId.
   */
  @java.lang.Override
  public com.google.datastore.v1.PartitionId getPartitionId() {
    return partitionId_ == null
        ? com.google.datastore.v1.PartitionId.getDefaultInstance()
        : partitionId_;
  }
  /**
   *
   *
   * <pre>
   * Entities are partitioned into subsets, currently identified by a project
   * ID and namespace ID.
   * Queries are scoped to a single partition.
   * </pre>
   *
   * <code>.google.datastore.v1.PartitionId partition_id = 1;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.PartitionIdOrBuilder getPartitionIdOrBuilder() {
    return partitionId_ == null
        ? com.google.datastore.v1.PartitionId.getDefaultInstance()
        : partitionId_;
  }

  public static final int PATH_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.datastore.v1.Key.PathElement> path_;
  /**
   *
   *
   * <pre>
   * The entity path.
   * An entity path consists of one or more elements composed of a kind and a
   * string or numerical identifier, which identify entities. The first
   * element identifies a _root entity_, the second element identifies
   * a _child_ of the root entity, the third element identifies a child of the
   * second entity, and so forth. The entities identified by all prefixes of
   * the path are called the element's _ancestors_.
   * An entity path is always fully complete: *all* of the entity's ancestors
   * are required to be in the path along with the entity identifier itself.
   * The only exception is that in some documented cases, the identifier in the
   * last path element (for the entity) itself may be omitted. For example,
   * the last path element of the key of `Mutation.insert` may have no
   * identifier.
   * A path can never be empty, and a path can have at most 100 elements.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.datastore.v1.Key.PathElement> getPathList() {
    return path_;
  }
  /**
   *
   *
   * <pre>
   * The entity path.
   * An entity path consists of one or more elements composed of a kind and a
   * string or numerical identifier, which identify entities. The first
   * element identifies a _root entity_, the second element identifies
   * a _child_ of the root entity, the third element identifies a child of the
   * second entity, and so forth. The entities identified by all prefixes of
   * the path are called the element's _ancestors_.
   * An entity path is always fully complete: *all* of the entity's ancestors
   * are required to be in the path along with the entity identifier itself.
   * The only exception is that in some documented cases, the identifier in the
   * last path element (for the entity) itself may be omitted. For example,
   * the last path element of the key of `Mutation.insert` may have no
   * identifier.
   * A path can never be empty, and a path can have at most 100 elements.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.datastore.v1.Key.PathElementOrBuilder>
      getPathOrBuilderList() {
    return path_;
  }
  /**
   *
   *
   * <pre>
   * The entity path.
   * An entity path consists of one or more elements composed of a kind and a
   * string or numerical identifier, which identify entities. The first
   * element identifies a _root entity_, the second element identifies
   * a _child_ of the root entity, the third element identifies a child of the
   * second entity, and so forth. The entities identified by all prefixes of
   * the path are called the element's _ancestors_.
   * An entity path is always fully complete: *all* of the entity's ancestors
   * are required to be in the path along with the entity identifier itself.
   * The only exception is that in some documented cases, the identifier in the
   * last path element (for the entity) itself may be omitted. For example,
   * the last path element of the key of `Mutation.insert` may have no
   * identifier.
   * A path can never be empty, and a path can have at most 100 elements.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
   */
  @java.lang.Override
  public int getPathCount() {
    return path_.size();
  }
  /**
   *
   *
   * <pre>
   * The entity path.
   * An entity path consists of one or more elements composed of a kind and a
   * string or numerical identifier, which identify entities. The first
   * element identifies a _root entity_, the second element identifies
   * a _child_ of the root entity, the third element identifies a child of the
   * second entity, and so forth. The entities identified by all prefixes of
   * the path are called the element's _ancestors_.
   * An entity path is always fully complete: *all* of the entity's ancestors
   * are required to be in the path along with the entity identifier itself.
   * The only exception is that in some documented cases, the identifier in the
   * last path element (for the entity) itself may be omitted. For example,
   * the last path element of the key of `Mutation.insert` may have no
   * identifier.
   * A path can never be empty, and a path can have at most 100 elements.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.Key.PathElement getPath(int index) {
    return path_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The entity path.
   * An entity path consists of one or more elements composed of a kind and a
   * string or numerical identifier, which identify entities. The first
   * element identifies a _root entity_, the second element identifies
   * a _child_ of the root entity, the third element identifies a child of the
   * second entity, and so forth. The entities identified by all prefixes of
   * the path are called the element's _ancestors_.
   * An entity path is always fully complete: *all* of the entity's ancestors
   * are required to be in the path along with the entity identifier itself.
   * The only exception is that in some documented cases, the identifier in the
   * last path element (for the entity) itself may be omitted. For example,
   * the last path element of the key of `Mutation.insert` may have no
   * identifier.
   * A path can never be empty, and a path can have at most 100 elements.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.Key.PathElementOrBuilder getPathOrBuilder(int index) {
    return path_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (partitionId_ != null) {
      output.writeMessage(1, getPartitionId());
    }
    for (int i = 0; i < path_.size(); i++) {
      output.writeMessage(2, path_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (partitionId_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getPartitionId());
    }
    for (int i = 0; i < path_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, path_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.datastore.v1.Key)) {
      return super.equals(obj);
    }
    com.google.datastore.v1.Key other = (com.google.datastore.v1.Key) obj;

    if (hasPartitionId() != other.hasPartitionId()) return false;
    if (hasPartitionId()) {
      if (!getPartitionId().equals(other.getPartitionId())) return false;
    }
    if (!getPathList().equals(other.getPathList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasPartitionId()) {
      hash = (37 * hash) + PARTITION_ID_FIELD_NUMBER;
      hash = (53 * hash) + getPartitionId().hashCode();
    }
    if (getPathCount() > 0) {
      hash = (37 * hash) + PATH_FIELD_NUMBER;
      hash = (53 * hash) + getPathList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.datastore.v1.Key parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.Key parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.Key parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.Key parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.Key parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.Key parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.Key parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.Key parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.Key parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.Key parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.Key parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.Key parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.datastore.v1.Key prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A unique identifier for an entity.
   * If a key's partition ID or any of its path kinds or names are
   * reserved/read-only, the key is reserved/read-only.
   * A reserved/read-only key is forbidden in certain documented contexts.
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.Key}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.datastore.v1.Key)
      com.google.datastore.v1.KeyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.EntityProto.internal_static_google_datastore_v1_Key_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.EntityProto
          .internal_static_google_datastore_v1_Key_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.Key.class, com.google.datastore.v1.Key.Builder.class);
    }

    // Construct using com.google.datastore.v1.Key.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      partitionId_ = null;
      if (partitionIdBuilder_ != null) {
        partitionIdBuilder_.dispose();
        partitionIdBuilder_ = null;
      }
      if (pathBuilder_ == null) {
        path_ = java.util.Collections.emptyList();
      } else {
        path_ = null;
        pathBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.datastore.v1.EntityProto.internal_static_google_datastore_v1_Key_descriptor;
    }

    @java.lang.Override
    public com.google.datastore.v1.Key getDefaultInstanceForType() {
      return com.google.datastore.v1.Key.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.datastore.v1.Key build() {
      com.google.datastore.v1.Key result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.datastore.v1.Key buildPartial() {
      com.google.datastore.v1.Key result = new com.google.datastore.v1.Key(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.datastore.v1.Key result) {
      if (pathBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          path_ = java.util.Collections.unmodifiableList(path_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.path_ = path_;
      } else {
        result.path_ = pathBuilder_.build();
      }
    }

    private void buildPartial0(com.google.datastore.v1.Key result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.partitionId_ =
            partitionIdBuilder_ == null ? partitionId_ : partitionIdBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.datastore.v1.Key) {
        return mergeFrom((com.google.datastore.v1.Key) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.datastore.v1.Key other) {
      if (other == com.google.datastore.v1.Key.getDefaultInstance()) return this;
      if (other.hasPartitionId()) {
        mergePartitionId(other.getPartitionId());
      }
      if (pathBuilder_ == null) {
        if (!other.path_.isEmpty()) {
          if (path_.isEmpty()) {
            path_ = other.path_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePathIsMutable();
            path_.addAll(other.path_);
          }
          onChanged();
        }
      } else {
        if (!other.path_.isEmpty()) {
          if (pathBuilder_.isEmpty()) {
            pathBuilder_.dispose();
            pathBuilder_ = null;
            path_ = other.path_;
            bitField0_ = (bitField0_ & ~0x00000002);
            pathBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPathFieldBuilder()
                    : null;
          } else {
            pathBuilder_.addAllMessages(other.path_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getPartitionIdFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.datastore.v1.Key.PathElement m =
                    input.readMessage(
                        com.google.datastore.v1.Key.PathElement.parser(), extensionRegistry);
                if (pathBuilder_ == null) {
                  ensurePathIsMutable();
                  path_.add(m);
                } else {
                  pathBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.datastore.v1.PartitionId partitionId_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.PartitionId,
            com.google.datastore.v1.PartitionId.Builder,
            com.google.datastore.v1.PartitionIdOrBuilder>
        partitionIdBuilder_;
    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, currently identified by a project
     * ID and namespace ID.
     * Queries are scoped to a single partition.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 1;</code>
     *
     * @return Whether the partitionId field is set.
     */
    public boolean hasPartitionId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, currently identified by a project
     * ID and namespace ID.
     * Queries are scoped to a single partition.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 1;</code>
     *
     * @return The partitionId.
     */
    public com.google.datastore.v1.PartitionId getPartitionId() {
      if (partitionIdBuilder_ == null) {
        return partitionId_ == null
            ? com.google.datastore.v1.PartitionId.getDefaultInstance()
            : partitionId_;
      } else {
        return partitionIdBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, currently identified by a project
     * ID and namespace ID.
     * Queries are scoped to a single partition.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 1;</code>
     */
    public Builder setPartitionId(com.google.datastore.v1.PartitionId value) {
      if (partitionIdBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        partitionId_ = value;
      } else {
        partitionIdBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, currently identified by a project
     * ID and namespace ID.
     * Queries are scoped to a single partition.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 1;</code>
     */
    public Builder setPartitionId(com.google.datastore.v1.PartitionId.Builder builderForValue) {
      if (partitionIdBuilder_ == null) {
        partitionId_ = builderForValue.build();
      } else {
        partitionIdBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, currently identified by a project
     * ID and namespace ID.
     * Queries are scoped to a single partition.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 1;</code>
     */
    public Builder mergePartitionId(com.google.datastore.v1.PartitionId value) {
      if (partitionIdBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && partitionId_ != null
            && partitionId_ != com.google.datastore.v1.PartitionId.getDefaultInstance()) {
          getPartitionIdBuilder().mergeFrom(value);
        } else {
          partitionId_ = value;
        }
      } else {
        partitionIdBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, currently identified by a project
     * ID and namespace ID.
     * Queries are scoped to a single partition.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 1;</code>
     */
    public Builder clearPartitionId() {
      bitField0_ = (bitField0_ & ~0x00000001);
      partitionId_ = null;
      if (partitionIdBuilder_ != null) {
        partitionIdBuilder_.dispose();
        partitionIdBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, currently identified by a project
     * ID and namespace ID.
     * Queries are scoped to a single partition.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 1;</code>
     */
    public com.google.datastore.v1.PartitionId.Builder getPartitionIdBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getPartitionIdFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, currently identified by a project
     * ID and namespace ID.
     * Queries are scoped to a single partition.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 1;</code>
     */
    public com.google.datastore.v1.PartitionIdOrBuilder getPartitionIdOrBuilder() {
      if (partitionIdBuilder_ != null) {
        return partitionIdBuilder_.getMessageOrBuilder();
      } else {
        return partitionId_ == null
            ? com.google.datastore.v1.PartitionId.getDefaultInstance()
            : partitionId_;
      }
    }
    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, currently identified by a project
     * ID and namespace ID.
     * Queries are scoped to a single partition.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.PartitionId,
            com.google.datastore.v1.PartitionId.Builder,
            com.google.datastore.v1.PartitionIdOrBuilder>
        getPartitionIdFieldBuilder() {
      if (partitionIdBuilder_ == null) {
        partitionIdBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.PartitionId,
                com.google.datastore.v1.PartitionId.Builder,
                com.google.datastore.v1.PartitionIdOrBuilder>(
                getPartitionId(), getParentForChildren(), isClean());
        partitionId_ = null;
      }
      return partitionIdBuilder_;
    }

    private java.util.List<com.google.datastore.v1.Key.PathElement> path_ =
        java.util.Collections.emptyList();

    private void ensurePathIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        path_ = new java.util.ArrayList<com.google.datastore.v1.Key.PathElement>(path_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.Key.PathElement,
            com.google.datastore.v1.Key.PathElement.Builder,
            com.google.datastore.v1.Key.PathElementOrBuilder>
        pathBuilder_;

    /**
     *
     *
     * <pre>
     * The entity path.
     * An entity path consists of one or more elements composed of a kind and a
     * string or numerical identifier, which identify entities. The first
     * element identifies a _root entity_, the second element identifies
     * a _child_ of the root entity, the third element identifies a child of the
     * second entity, and so forth. The entities identified by all prefixes of
     * the path are called the element's _ancestors_.
     * An entity path is always fully complete: *all* of the entity's ancestors
     * are required to be in the path along with the entity identifier itself.
     * The only exception is that in some documented cases, the identifier in the
     * last path element (for the entity) itself may be omitted. For example,
     * the last path element of the key of `Mutation.insert` may have no
     * identifier.
     * A path can never be empty, and a path can have at most 100 elements.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
     */
    public java.util.List<com.google.datastore.v1.Key.PathElement> getPathList() {
      if (pathBuilder_ == null) {
        return java.util.Collections.unmodifiableList(path_);
      } else {
        return pathBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The entity path.
     * An entity path consists of one or more elements composed of a kind and a
     * string or numerical identifier, which identify entities. The first
     * element identifies a _root entity_, the second element identifies
     * a _child_ of the root entity, the third element identifies a child of the
     * second entity, and so forth. The entities identified by all prefixes of
     * the path are called the element's _ancestors_.
     * An entity path is always fully complete: *all* of the entity's ancestors
     * are required to be in the path along with the entity identifier itself.
     * The only exception is that in some documented cases, the identifier in the
     * last path element (for the entity) itself may be omitted. For example,
     * the last path element of the key of `Mutation.insert` may have no
     * identifier.
     * A path can never be empty, and a path can have at most 100 elements.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
     */
    public int getPathCount() {
      if (pathBuilder_ == null) {
        return path_.size();
      } else {
        return pathBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The entity path.
     * An entity path consists of one or more elements composed of a kind and a
     * string or numerical identifier, which identify entities. The first
     * element identifies a _root entity_, the second element identifies
     * a _child_ of the root entity, the third element identifies a child of the
     * second entity, and so forth. The entities identified by all prefixes of
     * the path are called the element's _ancestors_.
     * An entity path is always fully complete: *all* of the entity's ancestors
     * are required to be in the path along with the entity identifier itself.
     * The only exception is that in some documented cases, the identifier in the
     * last path element (for the entity) itself may be omitted. For example,
     * the last path element of the key of `Mutation.insert` may have no
     * identifier.
     * A path can never be empty, and a path can have at most 100 elements.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
     */
    public com.google.datastore.v1.Key.PathElement getPath(int index) {
      if (pathBuilder_ == null) {
        return path_.get(index);
      } else {
        return pathBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The entity path.
     * An entity path consists of one or more elements composed of a kind and a
     * string or numerical identifier, which identify entities. The first
     * element identifies a _root entity_, the second element identifies
     * a _child_ of the root entity, the third element identifies a child of the
     * second entity, and so forth. The entities identified by all prefixes of
     * the path are called the element's _ancestors_.
     * An entity path is always fully complete: *all* of the entity's ancestors
     * are required to be in the path along with the entity identifier itself.
     * The only exception is that in some documented cases, the identifier in the
     * last path element (for the entity) itself may be omitted. For example,
     * the last path element of the key of `Mutation.insert` may have no
     * identifier.
     * A path can never be empty, and a path can have at most 100 elements.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
     */
    public Builder setPath(int index, com.google.datastore.v1.Key.PathElement value) {
      if (pathBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePathIsMutable();
        path_.set(index, value);
        onChanged();
      } else {
        pathBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity path.
     * An entity path consists of one or more elements composed of a kind and a
     * string or numerical identifier, which identify entities. The first
     * element identifies a _root entity_, the second element identifies
     * a _child_ of the root entity, the third element identifies a child of the
     * second entity, and so forth. The entities identified by all prefixes of
     * the path are called the element's _ancestors_.
     * An entity path is always fully complete: *all* of the entity's ancestors
     * are required to be in the path along with the entity identifier itself.
     * The only exception is that in some documented cases, the identifier in the
     * last path element (for the entity) itself may be omitted. For example,
     * the last path element of the key of `Mutation.insert` may have no
     * identifier.
     * A path can never be empty, and a path can have at most 100 elements.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
     */
    public Builder setPath(
        int index, com.google.datastore.v1.Key.PathElement.Builder builderForValue) {
      if (pathBuilder_ == null) {
        ensurePathIsMutable();
        path_.set(index, builderForValue.build());
        onChanged();
      } else {
        pathBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity path.
     * An entity path consists of one or more elements composed of a kind and a
     * string or numerical identifier, which identify entities. The first
     * element identifies a _root entity_, the second element identifies
     * a _child_ of the root entity, the third element identifies a child of the
     * second entity, and so forth. The entities identified by all prefixes of
     * the path are called the element's _ancestors_.
     * An entity path is always fully complete: *all* of the entity's ancestors
     * are required to be in the path along with the entity identifier itself.
     * The only exception is that in some documented cases, the identifier in the
     * last path element (for the entity) itself may be omitted. For example,
     * the last path element of the key of `Mutation.insert` may have no
     * identifier.
     * A path can never be empty, and a path can have at most 100 elements.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
     */
    public Builder addPath(com.google.datastore.v1.Key.PathElement value) {
      if (pathBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePathIsMutable();
        path_.add(value);
        onChanged();
      } else {
        pathBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity path.
     * An entity path consists of one or more elements composed of a kind and a
     * string or numerical identifier, which identify entities. The first
     * element identifies a _root entity_, the second element identifies
     * a _child_ of the root entity, the third element identifies a child of the
     * second entity, and so forth. The entities identified by all prefixes of
     * the path are called the element's _ancestors_.
     * An entity path is always fully complete: *all* of the entity's ancestors
     * are required to be in the path along with the entity identifier itself.
     * The only exception is that in some documented cases, the identifier in the
     * last path element (for the entity) itself may be omitted. For example,
     * the last path element of the key of `Mutation.insert` may have no
     * identifier.
     * A path can never be empty, and a path can have at most 100 elements.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
     */
    public Builder addPath(int index, com.google.datastore.v1.Key.PathElement value) {
      if (pathBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePathIsMutable();
        path_.add(index, value);
        onChanged();
      } else {
        pathBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity path.
     * An entity path consists of one or more elements composed of a kind and a
     * string or numerical identifier, which identify entities. The first
     * element identifies a _root entity_, the second element identifies
     * a _child_ of the root entity, the third element identifies a child of the
     * second entity, and so forth. The entities identified by all prefixes of
     * the path are called the element's _ancestors_.
     * An entity path is always fully complete: *all* of the entity's ancestors
     * are required to be in the path along with the entity identifier itself.
     * The only exception is that in some documented cases, the identifier in the
     * last path element (for the entity) itself may be omitted. For example,
     * the last path element of the key of `Mutation.insert` may have no
     * identifier.
     * A path can never be empty, and a path can have at most 100 elements.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
     */
    public Builder addPath(com.google.datastore.v1.Key.PathElement.Builder builderForValue) {
      if (pathBuilder_ == null) {
        ensurePathIsMutable();
        path_.add(builderForValue.build());
        onChanged();
      } else {
        pathBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity path.
     * An entity path consists of one or more elements composed of a kind and a
     * string or numerical identifier, which identify entities. The first
     * element identifies a _root entity_, the second element identifies
     * a _child_ of the root entity, the third element identifies a child of the
     * second entity, and so forth. The entities identified by all prefixes of
     * the path are called the element's _ancestors_.
     * An entity path is always fully complete: *all* of the entity's ancestors
     * are required to be in the path along with the entity identifier itself.
     * The only exception is that in some documented cases, the identifier in the
     * last path element (for the entity) itself may be omitted. For example,
     * the last path element of the key of `Mutation.insert` may have no
     * identifier.
     * A path can never be empty, and a path can have at most 100 elements.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
     */
    public Builder addPath(
        int index, com.google.datastore.v1.Key.PathElement.Builder builderForValue) {
      if (pathBuilder_ == null) {
        ensurePathIsMutable();
        path_.add(index, builderForValue.build());
        onChanged();
      } else {
        pathBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity path.
     * An entity path consists of one or more elements composed of a kind and a
     * string or numerical identifier, which identify entities. The first
     * element identifies a _root entity_, the second element identifies
     * a _child_ of the root entity, the third element identifies a child of the
     * second entity, and so forth. The entities identified by all prefixes of
     * the path are called the element's _ancestors_.
     * An entity path is always fully complete: *all* of the entity's ancestors
     * are required to be in the path along with the entity identifier itself.
     * The only exception is that in some documented cases, the identifier in the
     * last path element (for the entity) itself may be omitted. For example,
     * the last path element of the key of `Mutation.insert` may have no
     * identifier.
     * A path can never be empty, and a path can have at most 100 elements.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
     */
    public Builder addAllPath(
        java.lang.Iterable<? extends com.google.datastore.v1.Key.PathElement> values) {
      if (pathBuilder_ == null) {
        ensurePathIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, path_);
        onChanged();
      } else {
        pathBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity path.
     * An entity path consists of one or more elements composed of a kind and a
     * string or numerical identifier, which identify entities. The first
     * element identifies a _root entity_, the second element identifies
     * a _child_ of the root entity, the third element identifies a child of the
     * second entity, and so forth. The entities identified by all prefixes of
     * the path are called the element's _ancestors_.
     * An entity path is always fully complete: *all* of the entity's ancestors
     * are required to be in the path along with the entity identifier itself.
     * The only exception is that in some documented cases, the identifier in the
     * last path element (for the entity) itself may be omitted. For example,
     * the last path element of the key of `Mutation.insert` may have no
     * identifier.
     * A path can never be empty, and a path can have at most 100 elements.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
     */
    public Builder clearPath() {
      if (pathBuilder_ == null) {
        path_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        pathBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity path.
     * An entity path consists of one or more elements composed of a kind and a
     * string or numerical identifier, which identify entities. The first
     * element identifies a _root entity_, the second element identifies
     * a _child_ of the root entity, the third element identifies a child of the
     * second entity, and so forth. The entities identified by all prefixes of
     * the path are called the element's _ancestors_.
     * An entity path is always fully complete: *all* of the entity's ancestors
     * are required to be in the path along with the entity identifier itself.
     * The only exception is that in some documented cases, the identifier in the
     * last path element (for the entity) itself may be omitted. For example,
     * the last path element of the key of `Mutation.insert` may have no
     * identifier.
     * A path can never be empty, and a path can have at most 100 elements.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
     */
    public Builder removePath(int index) {
      if (pathBuilder_ == null) {
        ensurePathIsMutable();
        path_.remove(index);
        onChanged();
      } else {
        pathBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity path.
     * An entity path consists of one or more elements composed of a kind and a
     * string or numerical identifier, which identify entities. The first
     * element identifies a _root entity_, the second element identifies
     * a _child_ of the root entity, the third element identifies a child of the
     * second entity, and so forth. The entities identified by all prefixes of
     * the path are called the element's _ancestors_.
     * An entity path is always fully complete: *all* of the entity's ancestors
     * are required to be in the path along with the entity identifier itself.
     * The only exception is that in some documented cases, the identifier in the
     * last path element (for the entity) itself may be omitted. For example,
     * the last path element of the key of `Mutation.insert` may have no
     * identifier.
     * A path can never be empty, and a path can have at most 100 elements.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
     */
    public com.google.datastore.v1.Key.PathElement.Builder getPathBuilder(int index) {
      return getPathFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The entity path.
     * An entity path consists of one or more elements composed of a kind and a
     * string or numerical identifier, which identify entities. The first
     * element identifies a _root entity_, the second element identifies
     * a _child_ of the root entity, the third element identifies a child of the
     * second entity, and so forth. The entities identified by all prefixes of
     * the path are called the element's _ancestors_.
     * An entity path is always fully complete: *all* of the entity's ancestors
     * are required to be in the path along with the entity identifier itself.
     * The only exception is that in some documented cases, the identifier in the
     * last path element (for the entity) itself may be omitted. For example,
     * the last path element of the key of `Mutation.insert` may have no
     * identifier.
     * A path can never be empty, and a path can have at most 100 elements.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
     */
    public com.google.datastore.v1.Key.PathElementOrBuilder getPathOrBuilder(int index) {
      if (pathBuilder_ == null) {
        return path_.get(index);
      } else {
        return pathBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The entity path.
     * An entity path consists of one or more elements composed of a kind and a
     * string or numerical identifier, which identify entities. The first
     * element identifies a _root entity_, the second element identifies
     * a _child_ of the root entity, the third element identifies a child of the
     * second entity, and so forth. The entities identified by all prefixes of
     * the path are called the element's _ancestors_.
     * An entity path is always fully complete: *all* of the entity's ancestors
     * are required to be in the path along with the entity identifier itself.
     * The only exception is that in some documented cases, the identifier in the
     * last path element (for the entity) itself may be omitted. For example,
     * the last path element of the key of `Mutation.insert` may have no
     * identifier.
     * A path can never be empty, and a path can have at most 100 elements.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
     */
    public java.util.List<? extends com.google.datastore.v1.Key.PathElementOrBuilder>
        getPathOrBuilderList() {
      if (pathBuilder_ != null) {
        return pathBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(path_);
      }
    }
    /**
     *
     *
     * <pre>
     * The entity path.
     * An entity path consists of one or more elements composed of a kind and a
     * string or numerical identifier, which identify entities. The first
     * element identifies a _root entity_, the second element identifies
     * a _child_ of the root entity, the third element identifies a child of the
     * second entity, and so forth. The entities identified by all prefixes of
     * the path are called the element's _ancestors_.
     * An entity path is always fully complete: *all* of the entity's ancestors
     * are required to be in the path along with the entity identifier itself.
     * The only exception is that in some documented cases, the identifier in the
     * last path element (for the entity) itself may be omitted. For example,
     * the last path element of the key of `Mutation.insert` may have no
     * identifier.
     * A path can never be empty, and a path can have at most 100 elements.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
     */
    public com.google.datastore.v1.Key.PathElement.Builder addPathBuilder() {
      return getPathFieldBuilder()
          .addBuilder(com.google.datastore.v1.Key.PathElement.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The entity path.
     * An entity path consists of one or more elements composed of a kind and a
     * string or numerical identifier, which identify entities. The first
     * element identifies a _root entity_, the second element identifies
     * a _child_ of the root entity, the third element identifies a child of the
     * second entity, and so forth. The entities identified by all prefixes of
     * the path are called the element's _ancestors_.
     * An entity path is always fully complete: *all* of the entity's ancestors
     * are required to be in the path along with the entity identifier itself.
     * The only exception is that in some documented cases, the identifier in the
     * last path element (for the entity) itself may be omitted. For example,
     * the last path element of the key of `Mutation.insert` may have no
     * identifier.
     * A path can never be empty, and a path can have at most 100 elements.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
     */
    public com.google.datastore.v1.Key.PathElement.Builder addPathBuilder(int index) {
      return getPathFieldBuilder()
          .addBuilder(index, com.google.datastore.v1.Key.PathElement.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The entity path.
     * An entity path consists of one or more elements composed of a kind and a
     * string or numerical identifier, which identify entities. The first
     * element identifies a _root entity_, the second element identifies
     * a _child_ of the root entity, the third element identifies a child of the
     * second entity, and so forth. The entities identified by all prefixes of
     * the path are called the element's _ancestors_.
     * An entity path is always fully complete: *all* of the entity's ancestors
     * are required to be in the path along with the entity identifier itself.
     * The only exception is that in some documented cases, the identifier in the
     * last path element (for the entity) itself may be omitted. For example,
     * the last path element of the key of `Mutation.insert` may have no
     * identifier.
     * A path can never be empty, and a path can have at most 100 elements.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key.PathElement path = 2;</code>
     */
    public java.util.List<com.google.datastore.v1.Key.PathElement.Builder> getPathBuilderList() {
      return getPathFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.Key.PathElement,
            com.google.datastore.v1.Key.PathElement.Builder,
            com.google.datastore.v1.Key.PathElementOrBuilder>
        getPathFieldBuilder() {
      if (pathBuilder_ == null) {
        pathBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.datastore.v1.Key.PathElement,
                com.google.datastore.v1.Key.PathElement.Builder,
                com.google.datastore.v1.Key.PathElementOrBuilder>(
                path_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        path_ = null;
      }
      return pathBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.datastore.v1.Key)
  }

  // @@protoc_insertion_point(class_scope:google.datastore.v1.Key)
  private static final com.google.datastore.v1.Key DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.datastore.v1.Key();
  }

  public static com.google.datastore.v1.Key getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Key> PARSER =
      new com.google.protobuf.AbstractParser<Key>() {
        @java.lang.Override
        public Key parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Key> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Key> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.datastore.v1.Key getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
