/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/v1/query.proto

package com.google.datastore.v1;

/**
 *
 *
 * <pre>
 * Datastore query for running an aggregation over a
 * [Query][google.datastore.v1.Query].
 * </pre>
 *
 * Protobuf type {@code google.datastore.v1.AggregationQuery}
 */
public final class AggregationQuery extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.datastore.v1.AggregationQuery)
    AggregationQueryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AggregationQuery.newBuilder() to construct.
  private AggregationQuery(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AggregationQuery() {
    aggregations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AggregationQuery();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.datastore.v1.QueryProto
        .internal_static_google_datastore_v1_AggregationQuery_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.datastore.v1.QueryProto
        .internal_static_google_datastore_v1_AggregationQuery_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.datastore.v1.AggregationQuery.class,
            com.google.datastore.v1.AggregationQuery.Builder.class);
  }

  public interface AggregationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.datastore.v1.AggregationQuery.Aggregation)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Count aggregator.
     * </pre>
     *
     * <code>.google.datastore.v1.AggregationQuery.Aggregation.Count count = 1;</code>
     *
     * @return Whether the count field is set.
     */
    boolean hasCount();
    /**
     *
     *
     * <pre>
     * Count aggregator.
     * </pre>
     *
     * <code>.google.datastore.v1.AggregationQuery.Aggregation.Count count = 1;</code>
     *
     * @return The count.
     */
    com.google.datastore.v1.AggregationQuery.Aggregation.Count getCount();
    /**
     *
     *
     * <pre>
     * Count aggregator.
     * </pre>
     *
     * <code>.google.datastore.v1.AggregationQuery.Aggregation.Count count = 1;</code>
     */
    com.google.datastore.v1.AggregationQuery.Aggregation.CountOrBuilder getCountOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Optional name of the property to store the result of the
     * aggregation.
     *
     * If not provided, Datastore will pick a default name following the format
     * `property_&lt;incremental_id++&gt;`. For example:
     *
     * ```
     * AGGREGATE
     *   COUNT_UP_TO(1) AS count_up_to_1,
     *   COUNT_UP_TO(2),
     *   COUNT_UP_TO(3) AS count_up_to_3,
     *   COUNT(*)
     * OVER (
     *   ...
     * );
     * ```
     *
     * becomes:
     *
     * ```
     * AGGREGATE
     *   COUNT_UP_TO(1) AS count_up_to_1,
     *   COUNT_UP_TO(2) AS property_1,
     *   COUNT_UP_TO(3) AS count_up_to_3,
     *   COUNT(*) AS property_2
     * OVER (
     *   ...
     * );
     * ```
     *
     * Requires:
     *
     * * Must be unique across all aggregation aliases.
     * * Conform to [entity property
     * name][google.datastore.v1.Entity.properties] limitations.
     * </pre>
     *
     * <code>string alias = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The alias.
     */
    java.lang.String getAlias();
    /**
     *
     *
     * <pre>
     * Optional. Optional name of the property to store the result of the
     * aggregation.
     *
     * If not provided, Datastore will pick a default name following the format
     * `property_&lt;incremental_id++&gt;`. For example:
     *
     * ```
     * AGGREGATE
     *   COUNT_UP_TO(1) AS count_up_to_1,
     *   COUNT_UP_TO(2),
     *   COUNT_UP_TO(3) AS count_up_to_3,
     *   COUNT(*)
     * OVER (
     *   ...
     * );
     * ```
     *
     * becomes:
     *
     * ```
     * AGGREGATE
     *   COUNT_UP_TO(1) AS count_up_to_1,
     *   COUNT_UP_TO(2) AS property_1,
     *   COUNT_UP_TO(3) AS count_up_to_3,
     *   COUNT(*) AS property_2
     * OVER (
     *   ...
     * );
     * ```
     *
     * Requires:
     *
     * * Must be unique across all aggregation aliases.
     * * Conform to [entity property
     * name][google.datastore.v1.Entity.properties] limitations.
     * </pre>
     *
     * <code>string alias = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for alias.
     */
    com.google.protobuf.ByteString getAliasBytes();

    com.google.datastore.v1.AggregationQuery.Aggregation.OperatorCase getOperatorCase();
  }
  /**
   *
   *
   * <pre>
   * Defines an aggregation that produces a single result.
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.AggregationQuery.Aggregation}
   */
  public static final class Aggregation extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.datastore.v1.AggregationQuery.Aggregation)
      AggregationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Aggregation.newBuilder() to construct.
    private Aggregation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Aggregation() {
      alias_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Aggregation();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.QueryProto
          .internal_static_google_datastore_v1_AggregationQuery_Aggregation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.QueryProto
          .internal_static_google_datastore_v1_AggregationQuery_Aggregation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.AggregationQuery.Aggregation.class,
              com.google.datastore.v1.AggregationQuery.Aggregation.Builder.class);
    }

    public interface CountOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.datastore.v1.AggregationQuery.Aggregation.Count)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. Optional constraint on the maximum number of entities to
       * count.
       *
       * This provides a way to set an upper bound on the number of entities
       * to scan, limiting latency, and cost.
       *
       * Unspecified is interpreted as no bound.
       *
       * If a zero value is provided, a count result of zero should always be
       * expected.
       *
       * High-Level Example:
       *
       * ```
       * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
       * ```
       *
       * Requires:
       *
       * * Must be non-negative when present.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the upTo field is set.
       */
      boolean hasUpTo();
      /**
       *
       *
       * <pre>
       * Optional. Optional constraint on the maximum number of entities to
       * count.
       *
       * This provides a way to set an upper bound on the number of entities
       * to scan, limiting latency, and cost.
       *
       * Unspecified is interpreted as no bound.
       *
       * If a zero value is provided, a count result of zero should always be
       * expected.
       *
       * High-Level Example:
       *
       * ```
       * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
       * ```
       *
       * Requires:
       *
       * * Must be non-negative when present.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The upTo.
       */
      com.google.protobuf.Int64Value getUpTo();
      /**
       *
       *
       * <pre>
       * Optional. Optional constraint on the maximum number of entities to
       * count.
       *
       * This provides a way to set an upper bound on the number of entities
       * to scan, limiting latency, and cost.
       *
       * Unspecified is interpreted as no bound.
       *
       * If a zero value is provided, a count result of zero should always be
       * expected.
       *
       * High-Level Example:
       *
       * ```
       * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
       * ```
       *
       * Requires:
       *
       * * Must be non-negative when present.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.protobuf.Int64ValueOrBuilder getUpToOrBuilder();
    }
    /**
     *
     *
     * <pre>
     * Count of entities that match the query.
     *
     * The `COUNT(*)` aggregation function operates on the entire entity
     * so it does not require a field reference.
     * </pre>
     *
     * Protobuf type {@code google.datastore.v1.AggregationQuery.Aggregation.Count}
     */
    public static final class Count extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.datastore.v1.AggregationQuery.Aggregation.Count)
        CountOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use Count.newBuilder() to construct.
      private Count(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Count() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Count();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.datastore.v1.QueryProto
            .internal_static_google_datastore_v1_AggregationQuery_Aggregation_Count_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.datastore.v1.QueryProto
            .internal_static_google_datastore_v1_AggregationQuery_Aggregation_Count_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.datastore.v1.AggregationQuery.Aggregation.Count.class,
                com.google.datastore.v1.AggregationQuery.Aggregation.Count.Builder.class);
      }

      public static final int UP_TO_FIELD_NUMBER = 1;
      private com.google.protobuf.Int64Value upTo_;
      /**
       *
       *
       * <pre>
       * Optional. Optional constraint on the maximum number of entities to
       * count.
       *
       * This provides a way to set an upper bound on the number of entities
       * to scan, limiting latency, and cost.
       *
       * Unspecified is interpreted as no bound.
       *
       * If a zero value is provided, a count result of zero should always be
       * expected.
       *
       * High-Level Example:
       *
       * ```
       * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
       * ```
       *
       * Requires:
       *
       * * Must be non-negative when present.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the upTo field is set.
       */
      @java.lang.Override
      public boolean hasUpTo() {
        return upTo_ != null;
      }
      /**
       *
       *
       * <pre>
       * Optional. Optional constraint on the maximum number of entities to
       * count.
       *
       * This provides a way to set an upper bound on the number of entities
       * to scan, limiting latency, and cost.
       *
       * Unspecified is interpreted as no bound.
       *
       * If a zero value is provided, a count result of zero should always be
       * expected.
       *
       * High-Level Example:
       *
       * ```
       * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
       * ```
       *
       * Requires:
       *
       * * Must be non-negative when present.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The upTo.
       */
      @java.lang.Override
      public com.google.protobuf.Int64Value getUpTo() {
        return upTo_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : upTo_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Optional constraint on the maximum number of entities to
       * count.
       *
       * This provides a way to set an upper bound on the number of entities
       * to scan, limiting latency, and cost.
       *
       * Unspecified is interpreted as no bound.
       *
       * If a zero value is provided, a count result of zero should always be
       * expected.
       *
       * High-Level Example:
       *
       * ```
       * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
       * ```
       *
       * Requires:
       *
       * * Must be non-negative when present.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.protobuf.Int64ValueOrBuilder getUpToOrBuilder() {
        return upTo_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : upTo_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (upTo_ != null) {
          output.writeMessage(1, getUpTo());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (upTo_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getUpTo());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.datastore.v1.AggregationQuery.Aggregation.Count)) {
          return super.equals(obj);
        }
        com.google.datastore.v1.AggregationQuery.Aggregation.Count other =
            (com.google.datastore.v1.AggregationQuery.Aggregation.Count) obj;

        if (hasUpTo() != other.hasUpTo()) return false;
        if (hasUpTo()) {
          if (!getUpTo().equals(other.getUpTo())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasUpTo()) {
          hash = (37 * hash) + UP_TO_FIELD_NUMBER;
          hash = (53 * hash) + getUpTo().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.datastore.v1.AggregationQuery.Aggregation.Count parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.datastore.v1.AggregationQuery.Aggregation.Count parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.datastore.v1.AggregationQuery.Aggregation.Count parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.datastore.v1.AggregationQuery.Aggregation.Count parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.datastore.v1.AggregationQuery.Aggregation.Count parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.datastore.v1.AggregationQuery.Aggregation.Count parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.datastore.v1.AggregationQuery.Aggregation.Count parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.datastore.v1.AggregationQuery.Aggregation.Count parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.datastore.v1.AggregationQuery.Aggregation.Count parseDelimitedFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.datastore.v1.AggregationQuery.Aggregation.Count parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.datastore.v1.AggregationQuery.Aggregation.Count parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.datastore.v1.AggregationQuery.Aggregation.Count parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.datastore.v1.AggregationQuery.Aggregation.Count prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Count of entities that match the query.
       *
       * The `COUNT(*)` aggregation function operates on the entire entity
       * so it does not require a field reference.
       * </pre>
       *
       * Protobuf type {@code google.datastore.v1.AggregationQuery.Aggregation.Count}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.datastore.v1.AggregationQuery.Aggregation.Count)
          com.google.datastore.v1.AggregationQuery.Aggregation.CountOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.datastore.v1.QueryProto
              .internal_static_google_datastore_v1_AggregationQuery_Aggregation_Count_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.datastore.v1.QueryProto
              .internal_static_google_datastore_v1_AggregationQuery_Aggregation_Count_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.datastore.v1.AggregationQuery.Aggregation.Count.class,
                  com.google.datastore.v1.AggregationQuery.Aggregation.Count.Builder.class);
        }

        // Construct using com.google.datastore.v1.AggregationQuery.Aggregation.Count.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          upTo_ = null;
          if (upToBuilder_ != null) {
            upToBuilder_.dispose();
            upToBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.datastore.v1.QueryProto
              .internal_static_google_datastore_v1_AggregationQuery_Aggregation_Count_descriptor;
        }

        @java.lang.Override
        public com.google.datastore.v1.AggregationQuery.Aggregation.Count
            getDefaultInstanceForType() {
          return com.google.datastore.v1.AggregationQuery.Aggregation.Count.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.datastore.v1.AggregationQuery.Aggregation.Count build() {
          com.google.datastore.v1.AggregationQuery.Aggregation.Count result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.datastore.v1.AggregationQuery.Aggregation.Count buildPartial() {
          com.google.datastore.v1.AggregationQuery.Aggregation.Count result =
              new com.google.datastore.v1.AggregationQuery.Aggregation.Count(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.datastore.v1.AggregationQuery.Aggregation.Count result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.upTo_ = upToBuilder_ == null ? upTo_ : upToBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.datastore.v1.AggregationQuery.Aggregation.Count) {
            return mergeFrom((com.google.datastore.v1.AggregationQuery.Aggregation.Count) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.datastore.v1.AggregationQuery.Aggregation.Count other) {
          if (other
              == com.google.datastore.v1.AggregationQuery.Aggregation.Count.getDefaultInstance())
            return this;
          if (other.hasUpTo()) {
            mergeUpTo(other.getUpTo());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(getUpToFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.Int64Value upTo_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>
            upToBuilder_;
        /**
         *
         *
         * <pre>
         * Optional. Optional constraint on the maximum number of entities to
         * count.
         *
         * This provides a way to set an upper bound on the number of entities
         * to scan, limiting latency, and cost.
         *
         * Unspecified is interpreted as no bound.
         *
         * If a zero value is provided, a count result of zero should always be
         * expected.
         *
         * High-Level Example:
         *
         * ```
         * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
         * ```
         *
         * Requires:
         *
         * * Must be non-negative when present.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the upTo field is set.
         */
        public boolean hasUpTo() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         *
         *
         * <pre>
         * Optional. Optional constraint on the maximum number of entities to
         * count.
         *
         * This provides a way to set an upper bound on the number of entities
         * to scan, limiting latency, and cost.
         *
         * Unspecified is interpreted as no bound.
         *
         * If a zero value is provided, a count result of zero should always be
         * expected.
         *
         * High-Level Example:
         *
         * ```
         * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
         * ```
         *
         * Requires:
         *
         * * Must be non-negative when present.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The upTo.
         */
        public com.google.protobuf.Int64Value getUpTo() {
          if (upToBuilder_ == null) {
            return upTo_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : upTo_;
          } else {
            return upToBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Optional constraint on the maximum number of entities to
         * count.
         *
         * This provides a way to set an upper bound on the number of entities
         * to scan, limiting latency, and cost.
         *
         * Unspecified is interpreted as no bound.
         *
         * If a zero value is provided, a count result of zero should always be
         * expected.
         *
         * High-Level Example:
         *
         * ```
         * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
         * ```
         *
         * Requires:
         *
         * * Must be non-negative when present.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setUpTo(com.google.protobuf.Int64Value value) {
          if (upToBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            upTo_ = value;
          } else {
            upToBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Optional constraint on the maximum number of entities to
         * count.
         *
         * This provides a way to set an upper bound on the number of entities
         * to scan, limiting latency, and cost.
         *
         * Unspecified is interpreted as no bound.
         *
         * If a zero value is provided, a count result of zero should always be
         * expected.
         *
         * High-Level Example:
         *
         * ```
         * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
         * ```
         *
         * Requires:
         *
         * * Must be non-negative when present.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setUpTo(com.google.protobuf.Int64Value.Builder builderForValue) {
          if (upToBuilder_ == null) {
            upTo_ = builderForValue.build();
          } else {
            upToBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Optional constraint on the maximum number of entities to
         * count.
         *
         * This provides a way to set an upper bound on the number of entities
         * to scan, limiting latency, and cost.
         *
         * Unspecified is interpreted as no bound.
         *
         * If a zero value is provided, a count result of zero should always be
         * expected.
         *
         * High-Level Example:
         *
         * ```
         * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
         * ```
         *
         * Requires:
         *
         * * Must be non-negative when present.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeUpTo(com.google.protobuf.Int64Value value) {
          if (upToBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && upTo_ != null
                && upTo_ != com.google.protobuf.Int64Value.getDefaultInstance()) {
              getUpToBuilder().mergeFrom(value);
            } else {
              upTo_ = value;
            }
          } else {
            upToBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Optional constraint on the maximum number of entities to
         * count.
         *
         * This provides a way to set an upper bound on the number of entities
         * to scan, limiting latency, and cost.
         *
         * Unspecified is interpreted as no bound.
         *
         * If a zero value is provided, a count result of zero should always be
         * expected.
         *
         * High-Level Example:
         *
         * ```
         * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
         * ```
         *
         * Requires:
         *
         * * Must be non-negative when present.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearUpTo() {
          bitField0_ = (bitField0_ & ~0x00000001);
          upTo_ = null;
          if (upToBuilder_ != null) {
            upToBuilder_.dispose();
            upToBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Optional. Optional constraint on the maximum number of entities to
         * count.
         *
         * This provides a way to set an upper bound on the number of entities
         * to scan, limiting latency, and cost.
         *
         * Unspecified is interpreted as no bound.
         *
         * If a zero value is provided, a count result of zero should always be
         * expected.
         *
         * High-Level Example:
         *
         * ```
         * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
         * ```
         *
         * Requires:
         *
         * * Must be non-negative when present.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.Int64Value.Builder getUpToBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getUpToFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Optional. Optional constraint on the maximum number of entities to
         * count.
         *
         * This provides a way to set an upper bound on the number of entities
         * to scan, limiting latency, and cost.
         *
         * Unspecified is interpreted as no bound.
         *
         * If a zero value is provided, a count result of zero should always be
         * expected.
         *
         * High-Level Example:
         *
         * ```
         * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
         * ```
         *
         * Requires:
         *
         * * Must be non-negative when present.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.protobuf.Int64ValueOrBuilder getUpToOrBuilder() {
          if (upToBuilder_ != null) {
            return upToBuilder_.getMessageOrBuilder();
          } else {
            return upTo_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : upTo_;
          }
        }
        /**
         *
         *
         * <pre>
         * Optional. Optional constraint on the maximum number of entities to
         * count.
         *
         * This provides a way to set an upper bound on the number of entities
         * to scan, limiting latency, and cost.
         *
         * Unspecified is interpreted as no bound.
         *
         * If a zero value is provided, a count result of zero should always be
         * expected.
         *
         * High-Level Example:
         *
         * ```
         * AGGREGATE COUNT_UP_TO(1000) OVER ( SELECT * FROM k );
         * ```
         *
         * Requires:
         *
         * * Must be non-negative when present.
         * </pre>
         *
         * <code>.google.protobuf.Int64Value up_to = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>
            getUpToFieldBuilder() {
          if (upToBuilder_ == null) {
            upToBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Int64Value,
                    com.google.protobuf.Int64Value.Builder,
                    com.google.protobuf.Int64ValueOrBuilder>(
                    getUpTo(), getParentForChildren(), isClean());
            upTo_ = null;
          }
          return upToBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.datastore.v1.AggregationQuery.Aggregation.Count)
      }

      // @@protoc_insertion_point(class_scope:google.datastore.v1.AggregationQuery.Aggregation.Count)
      private static final com.google.datastore.v1.AggregationQuery.Aggregation.Count
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.datastore.v1.AggregationQuery.Aggregation.Count();
      }

      public static com.google.datastore.v1.AggregationQuery.Aggregation.Count
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Count> PARSER =
          new com.google.protobuf.AbstractParser<Count>() {
            @java.lang.Override
            public Count parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Count> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Count> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.datastore.v1.AggregationQuery.Aggregation.Count
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int operatorCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object operator_;

    public enum OperatorCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      COUNT(1),
      OPERATOR_NOT_SET(0);
      private final int value;

      private OperatorCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static OperatorCase valueOf(int value) {
        return forNumber(value);
      }

      public static OperatorCase forNumber(int value) {
        switch (value) {
          case 1:
            return COUNT;
          case 0:
            return OPERATOR_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public OperatorCase getOperatorCase() {
      return OperatorCase.forNumber(operatorCase_);
    }

    public static final int COUNT_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Count aggregator.
     * </pre>
     *
     * <code>.google.datastore.v1.AggregationQuery.Aggregation.Count count = 1;</code>
     *
     * @return Whether the count field is set.
     */
    @java.lang.Override
    public boolean hasCount() {
      return operatorCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Count aggregator.
     * </pre>
     *
     * <code>.google.datastore.v1.AggregationQuery.Aggregation.Count count = 1;</code>
     *
     * @return The count.
     */
    @java.lang.Override
    public com.google.datastore.v1.AggregationQuery.Aggregation.Count getCount() {
      if (operatorCase_ == 1) {
        return (com.google.datastore.v1.AggregationQuery.Aggregation.Count) operator_;
      }
      return com.google.datastore.v1.AggregationQuery.Aggregation.Count.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Count aggregator.
     * </pre>
     *
     * <code>.google.datastore.v1.AggregationQuery.Aggregation.Count count = 1;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.AggregationQuery.Aggregation.CountOrBuilder getCountOrBuilder() {
      if (operatorCase_ == 1) {
        return (com.google.datastore.v1.AggregationQuery.Aggregation.Count) operator_;
      }
      return com.google.datastore.v1.AggregationQuery.Aggregation.Count.getDefaultInstance();
    }

    public static final int ALIAS_FIELD_NUMBER = 7;

    @SuppressWarnings("serial")
    private volatile java.lang.Object alias_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Optional name of the property to store the result of the
     * aggregation.
     *
     * If not provided, Datastore will pick a default name following the format
     * `property_&lt;incremental_id++&gt;`. For example:
     *
     * ```
     * AGGREGATE
     *   COUNT_UP_TO(1) AS count_up_to_1,
     *   COUNT_UP_TO(2),
     *   COUNT_UP_TO(3) AS count_up_to_3,
     *   COUNT(*)
     * OVER (
     *   ...
     * );
     * ```
     *
     * becomes:
     *
     * ```
     * AGGREGATE
     *   COUNT_UP_TO(1) AS count_up_to_1,
     *   COUNT_UP_TO(2) AS property_1,
     *   COUNT_UP_TO(3) AS count_up_to_3,
     *   COUNT(*) AS property_2
     * OVER (
     *   ...
     * );
     * ```
     *
     * Requires:
     *
     * * Must be unique across all aggregation aliases.
     * * Conform to [entity property
     * name][google.datastore.v1.Entity.properties] limitations.
     * </pre>
     *
     * <code>string alias = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The alias.
     */
    @java.lang.Override
    public java.lang.String getAlias() {
      java.lang.Object ref = alias_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        alias_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Optional name of the property to store the result of the
     * aggregation.
     *
     * If not provided, Datastore will pick a default name following the format
     * `property_&lt;incremental_id++&gt;`. For example:
     *
     * ```
     * AGGREGATE
     *   COUNT_UP_TO(1) AS count_up_to_1,
     *   COUNT_UP_TO(2),
     *   COUNT_UP_TO(3) AS count_up_to_3,
     *   COUNT(*)
     * OVER (
     *   ...
     * );
     * ```
     *
     * becomes:
     *
     * ```
     * AGGREGATE
     *   COUNT_UP_TO(1) AS count_up_to_1,
     *   COUNT_UP_TO(2) AS property_1,
     *   COUNT_UP_TO(3) AS count_up_to_3,
     *   COUNT(*) AS property_2
     * OVER (
     *   ...
     * );
     * ```
     *
     * Requires:
     *
     * * Must be unique across all aggregation aliases.
     * * Conform to [entity property
     * name][google.datastore.v1.Entity.properties] limitations.
     * </pre>
     *
     * <code>string alias = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for alias.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAliasBytes() {
      java.lang.Object ref = alias_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        alias_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (operatorCase_ == 1) {
        output.writeMessage(
            1, (com.google.datastore.v1.AggregationQuery.Aggregation.Count) operator_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(alias_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, alias_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (operatorCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.datastore.v1.AggregationQuery.Aggregation.Count) operator_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(alias_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, alias_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.datastore.v1.AggregationQuery.Aggregation)) {
        return super.equals(obj);
      }
      com.google.datastore.v1.AggregationQuery.Aggregation other =
          (com.google.datastore.v1.AggregationQuery.Aggregation) obj;

      if (!getAlias().equals(other.getAlias())) return false;
      if (!getOperatorCase().equals(other.getOperatorCase())) return false;
      switch (operatorCase_) {
        case 1:
          if (!getCount().equals(other.getCount())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ALIAS_FIELD_NUMBER;
      hash = (53 * hash) + getAlias().hashCode();
      switch (operatorCase_) {
        case 1:
          hash = (37 * hash) + COUNT_FIELD_NUMBER;
          hash = (53 * hash) + getCount().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.datastore.v1.AggregationQuery.Aggregation parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.v1.AggregationQuery.Aggregation parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.v1.AggregationQuery.Aggregation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.v1.AggregationQuery.Aggregation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.v1.AggregationQuery.Aggregation parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.datastore.v1.AggregationQuery.Aggregation parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.datastore.v1.AggregationQuery.Aggregation parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.datastore.v1.AggregationQuery.Aggregation parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.datastore.v1.AggregationQuery.Aggregation parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.datastore.v1.AggregationQuery.Aggregation parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.datastore.v1.AggregationQuery.Aggregation parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.datastore.v1.AggregationQuery.Aggregation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.datastore.v1.AggregationQuery.Aggregation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Defines an aggregation that produces a single result.
     * </pre>
     *
     * Protobuf type {@code google.datastore.v1.AggregationQuery.Aggregation}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.datastore.v1.AggregationQuery.Aggregation)
        com.google.datastore.v1.AggregationQuery.AggregationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.datastore.v1.QueryProto
            .internal_static_google_datastore_v1_AggregationQuery_Aggregation_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.datastore.v1.QueryProto
            .internal_static_google_datastore_v1_AggregationQuery_Aggregation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.datastore.v1.AggregationQuery.Aggregation.class,
                com.google.datastore.v1.AggregationQuery.Aggregation.Builder.class);
      }

      // Construct using com.google.datastore.v1.AggregationQuery.Aggregation.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (countBuilder_ != null) {
          countBuilder_.clear();
        }
        alias_ = "";
        operatorCase_ = 0;
        operator_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.datastore.v1.QueryProto
            .internal_static_google_datastore_v1_AggregationQuery_Aggregation_descriptor;
      }

      @java.lang.Override
      public com.google.datastore.v1.AggregationQuery.Aggregation getDefaultInstanceForType() {
        return com.google.datastore.v1.AggregationQuery.Aggregation.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.datastore.v1.AggregationQuery.Aggregation build() {
        com.google.datastore.v1.AggregationQuery.Aggregation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.datastore.v1.AggregationQuery.Aggregation buildPartial() {
        com.google.datastore.v1.AggregationQuery.Aggregation result =
            new com.google.datastore.v1.AggregationQuery.Aggregation(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.datastore.v1.AggregationQuery.Aggregation result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.alias_ = alias_;
        }
      }

      private void buildPartialOneofs(com.google.datastore.v1.AggregationQuery.Aggregation result) {
        result.operatorCase_ = operatorCase_;
        result.operator_ = this.operator_;
        if (operatorCase_ == 1 && countBuilder_ != null) {
          result.operator_ = countBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.datastore.v1.AggregationQuery.Aggregation) {
          return mergeFrom((com.google.datastore.v1.AggregationQuery.Aggregation) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.datastore.v1.AggregationQuery.Aggregation other) {
        if (other == com.google.datastore.v1.AggregationQuery.Aggregation.getDefaultInstance())
          return this;
        if (!other.getAlias().isEmpty()) {
          alias_ = other.alias_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        switch (other.getOperatorCase()) {
          case COUNT:
            {
              mergeCount(other.getCount());
              break;
            }
          case OPERATOR_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getCountFieldBuilder().getBuilder(), extensionRegistry);
                  operatorCase_ = 1;
                  break;
                } // case 10
              case 58:
                {
                  alias_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 58
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int operatorCase_ = 0;
      private java.lang.Object operator_;

      public OperatorCase getOperatorCase() {
        return OperatorCase.forNumber(operatorCase_);
      }

      public Builder clearOperator() {
        operatorCase_ = 0;
        operator_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.datastore.v1.AggregationQuery.Aggregation.Count,
              com.google.datastore.v1.AggregationQuery.Aggregation.Count.Builder,
              com.google.datastore.v1.AggregationQuery.Aggregation.CountOrBuilder>
          countBuilder_;
      /**
       *
       *
       * <pre>
       * Count aggregator.
       * </pre>
       *
       * <code>.google.datastore.v1.AggregationQuery.Aggregation.Count count = 1;</code>
       *
       * @return Whether the count field is set.
       */
      @java.lang.Override
      public boolean hasCount() {
        return operatorCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Count aggregator.
       * </pre>
       *
       * <code>.google.datastore.v1.AggregationQuery.Aggregation.Count count = 1;</code>
       *
       * @return The count.
       */
      @java.lang.Override
      public com.google.datastore.v1.AggregationQuery.Aggregation.Count getCount() {
        if (countBuilder_ == null) {
          if (operatorCase_ == 1) {
            return (com.google.datastore.v1.AggregationQuery.Aggregation.Count) operator_;
          }
          return com.google.datastore.v1.AggregationQuery.Aggregation.Count.getDefaultInstance();
        } else {
          if (operatorCase_ == 1) {
            return countBuilder_.getMessage();
          }
          return com.google.datastore.v1.AggregationQuery.Aggregation.Count.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Count aggregator.
       * </pre>
       *
       * <code>.google.datastore.v1.AggregationQuery.Aggregation.Count count = 1;</code>
       */
      public Builder setCount(com.google.datastore.v1.AggregationQuery.Aggregation.Count value) {
        if (countBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          operator_ = value;
          onChanged();
        } else {
          countBuilder_.setMessage(value);
        }
        operatorCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count aggregator.
       * </pre>
       *
       * <code>.google.datastore.v1.AggregationQuery.Aggregation.Count count = 1;</code>
       */
      public Builder setCount(
          com.google.datastore.v1.AggregationQuery.Aggregation.Count.Builder builderForValue) {
        if (countBuilder_ == null) {
          operator_ = builderForValue.build();
          onChanged();
        } else {
          countBuilder_.setMessage(builderForValue.build());
        }
        operatorCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count aggregator.
       * </pre>
       *
       * <code>.google.datastore.v1.AggregationQuery.Aggregation.Count count = 1;</code>
       */
      public Builder mergeCount(com.google.datastore.v1.AggregationQuery.Aggregation.Count value) {
        if (countBuilder_ == null) {
          if (operatorCase_ == 1
              && operator_
                  != com.google.datastore.v1.AggregationQuery.Aggregation.Count
                      .getDefaultInstance()) {
            operator_ =
                com.google.datastore.v1.AggregationQuery.Aggregation.Count.newBuilder(
                        (com.google.datastore.v1.AggregationQuery.Aggregation.Count) operator_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            operator_ = value;
          }
          onChanged();
        } else {
          if (operatorCase_ == 1) {
            countBuilder_.mergeFrom(value);
          } else {
            countBuilder_.setMessage(value);
          }
        }
        operatorCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count aggregator.
       * </pre>
       *
       * <code>.google.datastore.v1.AggregationQuery.Aggregation.Count count = 1;</code>
       */
      public Builder clearCount() {
        if (countBuilder_ == null) {
          if (operatorCase_ == 1) {
            operatorCase_ = 0;
            operator_ = null;
            onChanged();
          }
        } else {
          if (operatorCase_ == 1) {
            operatorCase_ = 0;
            operator_ = null;
          }
          countBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count aggregator.
       * </pre>
       *
       * <code>.google.datastore.v1.AggregationQuery.Aggregation.Count count = 1;</code>
       */
      public com.google.datastore.v1.AggregationQuery.Aggregation.Count.Builder getCountBuilder() {
        return getCountFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Count aggregator.
       * </pre>
       *
       * <code>.google.datastore.v1.AggregationQuery.Aggregation.Count count = 1;</code>
       */
      @java.lang.Override
      public com.google.datastore.v1.AggregationQuery.Aggregation.CountOrBuilder
          getCountOrBuilder() {
        if ((operatorCase_ == 1) && (countBuilder_ != null)) {
          return countBuilder_.getMessageOrBuilder();
        } else {
          if (operatorCase_ == 1) {
            return (com.google.datastore.v1.AggregationQuery.Aggregation.Count) operator_;
          }
          return com.google.datastore.v1.AggregationQuery.Aggregation.Count.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Count aggregator.
       * </pre>
       *
       * <code>.google.datastore.v1.AggregationQuery.Aggregation.Count count = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.datastore.v1.AggregationQuery.Aggregation.Count,
              com.google.datastore.v1.AggregationQuery.Aggregation.Count.Builder,
              com.google.datastore.v1.AggregationQuery.Aggregation.CountOrBuilder>
          getCountFieldBuilder() {
        if (countBuilder_ == null) {
          if (!(operatorCase_ == 1)) {
            operator_ =
                com.google.datastore.v1.AggregationQuery.Aggregation.Count.getDefaultInstance();
          }
          countBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.datastore.v1.AggregationQuery.Aggregation.Count,
                  com.google.datastore.v1.AggregationQuery.Aggregation.Count.Builder,
                  com.google.datastore.v1.AggregationQuery.Aggregation.CountOrBuilder>(
                  (com.google.datastore.v1.AggregationQuery.Aggregation.Count) operator_,
                  getParentForChildren(),
                  isClean());
          operator_ = null;
        }
        operatorCase_ = 1;
        onChanged();
        return countBuilder_;
      }

      private java.lang.Object alias_ = "";
      /**
       *
       *
       * <pre>
       * Optional. Optional name of the property to store the result of the
       * aggregation.
       *
       * If not provided, Datastore will pick a default name following the format
       * `property_&lt;incremental_id++&gt;`. For example:
       *
       * ```
       * AGGREGATE
       *   COUNT_UP_TO(1) AS count_up_to_1,
       *   COUNT_UP_TO(2),
       *   COUNT_UP_TO(3) AS count_up_to_3,
       *   COUNT(*)
       * OVER (
       *   ...
       * );
       * ```
       *
       * becomes:
       *
       * ```
       * AGGREGATE
       *   COUNT_UP_TO(1) AS count_up_to_1,
       *   COUNT_UP_TO(2) AS property_1,
       *   COUNT_UP_TO(3) AS count_up_to_3,
       *   COUNT(*) AS property_2
       * OVER (
       *   ...
       * );
       * ```
       *
       * Requires:
       *
       * * Must be unique across all aggregation aliases.
       * * Conform to [entity property
       * name][google.datastore.v1.Entity.properties] limitations.
       * </pre>
       *
       * <code>string alias = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The alias.
       */
      public java.lang.String getAlias() {
        java.lang.Object ref = alias_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          alias_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Optional name of the property to store the result of the
       * aggregation.
       *
       * If not provided, Datastore will pick a default name following the format
       * `property_&lt;incremental_id++&gt;`. For example:
       *
       * ```
       * AGGREGATE
       *   COUNT_UP_TO(1) AS count_up_to_1,
       *   COUNT_UP_TO(2),
       *   COUNT_UP_TO(3) AS count_up_to_3,
       *   COUNT(*)
       * OVER (
       *   ...
       * );
       * ```
       *
       * becomes:
       *
       * ```
       * AGGREGATE
       *   COUNT_UP_TO(1) AS count_up_to_1,
       *   COUNT_UP_TO(2) AS property_1,
       *   COUNT_UP_TO(3) AS count_up_to_3,
       *   COUNT(*) AS property_2
       * OVER (
       *   ...
       * );
       * ```
       *
       * Requires:
       *
       * * Must be unique across all aggregation aliases.
       * * Conform to [entity property
       * name][google.datastore.v1.Entity.properties] limitations.
       * </pre>
       *
       * <code>string alias = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for alias.
       */
      public com.google.protobuf.ByteString getAliasBytes() {
        java.lang.Object ref = alias_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          alias_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Optional name of the property to store the result of the
       * aggregation.
       *
       * If not provided, Datastore will pick a default name following the format
       * `property_&lt;incremental_id++&gt;`. For example:
       *
       * ```
       * AGGREGATE
       *   COUNT_UP_TO(1) AS count_up_to_1,
       *   COUNT_UP_TO(2),
       *   COUNT_UP_TO(3) AS count_up_to_3,
       *   COUNT(*)
       * OVER (
       *   ...
       * );
       * ```
       *
       * becomes:
       *
       * ```
       * AGGREGATE
       *   COUNT_UP_TO(1) AS count_up_to_1,
       *   COUNT_UP_TO(2) AS property_1,
       *   COUNT_UP_TO(3) AS count_up_to_3,
       *   COUNT(*) AS property_2
       * OVER (
       *   ...
       * );
       * ```
       *
       * Requires:
       *
       * * Must be unique across all aggregation aliases.
       * * Conform to [entity property
       * name][google.datastore.v1.Entity.properties] limitations.
       * </pre>
       *
       * <code>string alias = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The alias to set.
       * @return This builder for chaining.
       */
      public Builder setAlias(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        alias_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Optional name of the property to store the result of the
       * aggregation.
       *
       * If not provided, Datastore will pick a default name following the format
       * `property_&lt;incremental_id++&gt;`. For example:
       *
       * ```
       * AGGREGATE
       *   COUNT_UP_TO(1) AS count_up_to_1,
       *   COUNT_UP_TO(2),
       *   COUNT_UP_TO(3) AS count_up_to_3,
       *   COUNT(*)
       * OVER (
       *   ...
       * );
       * ```
       *
       * becomes:
       *
       * ```
       * AGGREGATE
       *   COUNT_UP_TO(1) AS count_up_to_1,
       *   COUNT_UP_TO(2) AS property_1,
       *   COUNT_UP_TO(3) AS count_up_to_3,
       *   COUNT(*) AS property_2
       * OVER (
       *   ...
       * );
       * ```
       *
       * Requires:
       *
       * * Must be unique across all aggregation aliases.
       * * Conform to [entity property
       * name][google.datastore.v1.Entity.properties] limitations.
       * </pre>
       *
       * <code>string alias = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAlias() {
        alias_ = getDefaultInstance().getAlias();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Optional name of the property to store the result of the
       * aggregation.
       *
       * If not provided, Datastore will pick a default name following the format
       * `property_&lt;incremental_id++&gt;`. For example:
       *
       * ```
       * AGGREGATE
       *   COUNT_UP_TO(1) AS count_up_to_1,
       *   COUNT_UP_TO(2),
       *   COUNT_UP_TO(3) AS count_up_to_3,
       *   COUNT(*)
       * OVER (
       *   ...
       * );
       * ```
       *
       * becomes:
       *
       * ```
       * AGGREGATE
       *   COUNT_UP_TO(1) AS count_up_to_1,
       *   COUNT_UP_TO(2) AS property_1,
       *   COUNT_UP_TO(3) AS count_up_to_3,
       *   COUNT(*) AS property_2
       * OVER (
       *   ...
       * );
       * ```
       *
       * Requires:
       *
       * * Must be unique across all aggregation aliases.
       * * Conform to [entity property
       * name][google.datastore.v1.Entity.properties] limitations.
       * </pre>
       *
       * <code>string alias = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for alias to set.
       * @return This builder for chaining.
       */
      public Builder setAliasBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        alias_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.datastore.v1.AggregationQuery.Aggregation)
    }

    // @@protoc_insertion_point(class_scope:google.datastore.v1.AggregationQuery.Aggregation)
    private static final com.google.datastore.v1.AggregationQuery.Aggregation DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.datastore.v1.AggregationQuery.Aggregation();
    }

    public static com.google.datastore.v1.AggregationQuery.Aggregation getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Aggregation> PARSER =
        new com.google.protobuf.AbstractParser<Aggregation>() {
          @java.lang.Override
          public Aggregation parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Aggregation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Aggregation> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.datastore.v1.AggregationQuery.Aggregation getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int queryTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object queryType_;

  public enum QueryTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    NESTED_QUERY(1),
    QUERYTYPE_NOT_SET(0);
    private final int value;

    private QueryTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static QueryTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static QueryTypeCase forNumber(int value) {
      switch (value) {
        case 1:
          return NESTED_QUERY;
        case 0:
          return QUERYTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public QueryTypeCase getQueryTypeCase() {
    return QueryTypeCase.forNumber(queryTypeCase_);
  }

  public static final int NESTED_QUERY_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Nested query for aggregation
   * </pre>
   *
   * <code>.google.datastore.v1.Query nested_query = 1;</code>
   *
   * @return Whether the nestedQuery field is set.
   */
  @java.lang.Override
  public boolean hasNestedQuery() {
    return queryTypeCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Nested query for aggregation
   * </pre>
   *
   * <code>.google.datastore.v1.Query nested_query = 1;</code>
   *
   * @return The nestedQuery.
   */
  @java.lang.Override
  public com.google.datastore.v1.Query getNestedQuery() {
    if (queryTypeCase_ == 1) {
      return (com.google.datastore.v1.Query) queryType_;
    }
    return com.google.datastore.v1.Query.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Nested query for aggregation
   * </pre>
   *
   * <code>.google.datastore.v1.Query nested_query = 1;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.QueryOrBuilder getNestedQueryOrBuilder() {
    if (queryTypeCase_ == 1) {
      return (com.google.datastore.v1.Query) queryType_;
    }
    return com.google.datastore.v1.Query.getDefaultInstance();
  }

  public static final int AGGREGATIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.datastore.v1.AggregationQuery.Aggregation> aggregations_;
  /**
   *
   *
   * <pre>
   * Optional. Series of aggregations to apply over the results of the
   * `nested_query`.
   *
   * Requires:
   *
   * * A minimum of one and maximum of five aggregations per query.
   * </pre>
   *
   * <code>
   * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.datastore.v1.AggregationQuery.Aggregation>
      getAggregationsList() {
    return aggregations_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Series of aggregations to apply over the results of the
   * `nested_query`.
   *
   * Requires:
   *
   * * A minimum of one and maximum of five aggregations per query.
   * </pre>
   *
   * <code>
   * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.datastore.v1.AggregationQuery.AggregationOrBuilder>
      getAggregationsOrBuilderList() {
    return aggregations_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Series of aggregations to apply over the results of the
   * `nested_query`.
   *
   * Requires:
   *
   * * A minimum of one and maximum of five aggregations per query.
   * </pre>
   *
   * <code>
   * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getAggregationsCount() {
    return aggregations_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Series of aggregations to apply over the results of the
   * `nested_query`.
   *
   * Requires:
   *
   * * A minimum of one and maximum of five aggregations per query.
   * </pre>
   *
   * <code>
   * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.datastore.v1.AggregationQuery.Aggregation getAggregations(int index) {
    return aggregations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Series of aggregations to apply over the results of the
   * `nested_query`.
   *
   * Requires:
   *
   * * A minimum of one and maximum of five aggregations per query.
   * </pre>
   *
   * <code>
   * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.datastore.v1.AggregationQuery.AggregationOrBuilder getAggregationsOrBuilder(
      int index) {
    return aggregations_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (queryTypeCase_ == 1) {
      output.writeMessage(1, (com.google.datastore.v1.Query) queryType_);
    }
    for (int i = 0; i < aggregations_.size(); i++) {
      output.writeMessage(3, aggregations_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (queryTypeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.datastore.v1.Query) queryType_);
    }
    for (int i = 0; i < aggregations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, aggregations_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.datastore.v1.AggregationQuery)) {
      return super.equals(obj);
    }
    com.google.datastore.v1.AggregationQuery other = (com.google.datastore.v1.AggregationQuery) obj;

    if (!getAggregationsList().equals(other.getAggregationsList())) return false;
    if (!getQueryTypeCase().equals(other.getQueryTypeCase())) return false;
    switch (queryTypeCase_) {
      case 1:
        if (!getNestedQuery().equals(other.getNestedQuery())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAggregationsCount() > 0) {
      hash = (37 * hash) + AGGREGATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getAggregationsList().hashCode();
    }
    switch (queryTypeCase_) {
      case 1:
        hash = (37 * hash) + NESTED_QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getNestedQuery().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.datastore.v1.AggregationQuery parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.AggregationQuery parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.AggregationQuery parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.AggregationQuery parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.AggregationQuery parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.AggregationQuery parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.AggregationQuery parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.AggregationQuery parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.AggregationQuery parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.AggregationQuery parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.AggregationQuery parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.AggregationQuery parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.datastore.v1.AggregationQuery prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Datastore query for running an aggregation over a
   * [Query][google.datastore.v1.Query].
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.AggregationQuery}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.datastore.v1.AggregationQuery)
      com.google.datastore.v1.AggregationQueryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.QueryProto
          .internal_static_google_datastore_v1_AggregationQuery_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.QueryProto
          .internal_static_google_datastore_v1_AggregationQuery_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.AggregationQuery.class,
              com.google.datastore.v1.AggregationQuery.Builder.class);
    }

    // Construct using com.google.datastore.v1.AggregationQuery.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (nestedQueryBuilder_ != null) {
        nestedQueryBuilder_.clear();
      }
      if (aggregationsBuilder_ == null) {
        aggregations_ = java.util.Collections.emptyList();
      } else {
        aggregations_ = null;
        aggregationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      queryTypeCase_ = 0;
      queryType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.datastore.v1.QueryProto
          .internal_static_google_datastore_v1_AggregationQuery_descriptor;
    }

    @java.lang.Override
    public com.google.datastore.v1.AggregationQuery getDefaultInstanceForType() {
      return com.google.datastore.v1.AggregationQuery.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.datastore.v1.AggregationQuery build() {
      com.google.datastore.v1.AggregationQuery result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.datastore.v1.AggregationQuery buildPartial() {
      com.google.datastore.v1.AggregationQuery result =
          new com.google.datastore.v1.AggregationQuery(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.datastore.v1.AggregationQuery result) {
      if (aggregationsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          aggregations_ = java.util.Collections.unmodifiableList(aggregations_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.aggregations_ = aggregations_;
      } else {
        result.aggregations_ = aggregationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.datastore.v1.AggregationQuery result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.datastore.v1.AggregationQuery result) {
      result.queryTypeCase_ = queryTypeCase_;
      result.queryType_ = this.queryType_;
      if (queryTypeCase_ == 1 && nestedQueryBuilder_ != null) {
        result.queryType_ = nestedQueryBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.datastore.v1.AggregationQuery) {
        return mergeFrom((com.google.datastore.v1.AggregationQuery) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.datastore.v1.AggregationQuery other) {
      if (other == com.google.datastore.v1.AggregationQuery.getDefaultInstance()) return this;
      if (aggregationsBuilder_ == null) {
        if (!other.aggregations_.isEmpty()) {
          if (aggregations_.isEmpty()) {
            aggregations_ = other.aggregations_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureAggregationsIsMutable();
            aggregations_.addAll(other.aggregations_);
          }
          onChanged();
        }
      } else {
        if (!other.aggregations_.isEmpty()) {
          if (aggregationsBuilder_.isEmpty()) {
            aggregationsBuilder_.dispose();
            aggregationsBuilder_ = null;
            aggregations_ = other.aggregations_;
            bitField0_ = (bitField0_ & ~0x00000002);
            aggregationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAggregationsFieldBuilder()
                    : null;
          } else {
            aggregationsBuilder_.addAllMessages(other.aggregations_);
          }
        }
      }
      switch (other.getQueryTypeCase()) {
        case NESTED_QUERY:
          {
            mergeNestedQuery(other.getNestedQuery());
            break;
          }
        case QUERYTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getNestedQueryFieldBuilder().getBuilder(), extensionRegistry);
                queryTypeCase_ = 1;
                break;
              } // case 10
            case 26:
              {
                com.google.datastore.v1.AggregationQuery.Aggregation m =
                    input.readMessage(
                        com.google.datastore.v1.AggregationQuery.Aggregation.parser(),
                        extensionRegistry);
                if (aggregationsBuilder_ == null) {
                  ensureAggregationsIsMutable();
                  aggregations_.add(m);
                } else {
                  aggregationsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int queryTypeCase_ = 0;
    private java.lang.Object queryType_;

    public QueryTypeCase getQueryTypeCase() {
      return QueryTypeCase.forNumber(queryTypeCase_);
    }

    public Builder clearQueryType() {
      queryTypeCase_ = 0;
      queryType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Query,
            com.google.datastore.v1.Query.Builder,
            com.google.datastore.v1.QueryOrBuilder>
        nestedQueryBuilder_;
    /**
     *
     *
     * <pre>
     * Nested query for aggregation
     * </pre>
     *
     * <code>.google.datastore.v1.Query nested_query = 1;</code>
     *
     * @return Whether the nestedQuery field is set.
     */
    @java.lang.Override
    public boolean hasNestedQuery() {
      return queryTypeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Nested query for aggregation
     * </pre>
     *
     * <code>.google.datastore.v1.Query nested_query = 1;</code>
     *
     * @return The nestedQuery.
     */
    @java.lang.Override
    public com.google.datastore.v1.Query getNestedQuery() {
      if (nestedQueryBuilder_ == null) {
        if (queryTypeCase_ == 1) {
          return (com.google.datastore.v1.Query) queryType_;
        }
        return com.google.datastore.v1.Query.getDefaultInstance();
      } else {
        if (queryTypeCase_ == 1) {
          return nestedQueryBuilder_.getMessage();
        }
        return com.google.datastore.v1.Query.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Nested query for aggregation
     * </pre>
     *
     * <code>.google.datastore.v1.Query nested_query = 1;</code>
     */
    public Builder setNestedQuery(com.google.datastore.v1.Query value) {
      if (nestedQueryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryType_ = value;
        onChanged();
      } else {
        nestedQueryBuilder_.setMessage(value);
      }
      queryTypeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Nested query for aggregation
     * </pre>
     *
     * <code>.google.datastore.v1.Query nested_query = 1;</code>
     */
    public Builder setNestedQuery(com.google.datastore.v1.Query.Builder builderForValue) {
      if (nestedQueryBuilder_ == null) {
        queryType_ = builderForValue.build();
        onChanged();
      } else {
        nestedQueryBuilder_.setMessage(builderForValue.build());
      }
      queryTypeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Nested query for aggregation
     * </pre>
     *
     * <code>.google.datastore.v1.Query nested_query = 1;</code>
     */
    public Builder mergeNestedQuery(com.google.datastore.v1.Query value) {
      if (nestedQueryBuilder_ == null) {
        if (queryTypeCase_ == 1
            && queryType_ != com.google.datastore.v1.Query.getDefaultInstance()) {
          queryType_ =
              com.google.datastore.v1.Query.newBuilder((com.google.datastore.v1.Query) queryType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          queryType_ = value;
        }
        onChanged();
      } else {
        if (queryTypeCase_ == 1) {
          nestedQueryBuilder_.mergeFrom(value);
        } else {
          nestedQueryBuilder_.setMessage(value);
        }
      }
      queryTypeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Nested query for aggregation
     * </pre>
     *
     * <code>.google.datastore.v1.Query nested_query = 1;</code>
     */
    public Builder clearNestedQuery() {
      if (nestedQueryBuilder_ == null) {
        if (queryTypeCase_ == 1) {
          queryTypeCase_ = 0;
          queryType_ = null;
          onChanged();
        }
      } else {
        if (queryTypeCase_ == 1) {
          queryTypeCase_ = 0;
          queryType_ = null;
        }
        nestedQueryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Nested query for aggregation
     * </pre>
     *
     * <code>.google.datastore.v1.Query nested_query = 1;</code>
     */
    public com.google.datastore.v1.Query.Builder getNestedQueryBuilder() {
      return getNestedQueryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Nested query for aggregation
     * </pre>
     *
     * <code>.google.datastore.v1.Query nested_query = 1;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.QueryOrBuilder getNestedQueryOrBuilder() {
      if ((queryTypeCase_ == 1) && (nestedQueryBuilder_ != null)) {
        return nestedQueryBuilder_.getMessageOrBuilder();
      } else {
        if (queryTypeCase_ == 1) {
          return (com.google.datastore.v1.Query) queryType_;
        }
        return com.google.datastore.v1.Query.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Nested query for aggregation
     * </pre>
     *
     * <code>.google.datastore.v1.Query nested_query = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Query,
            com.google.datastore.v1.Query.Builder,
            com.google.datastore.v1.QueryOrBuilder>
        getNestedQueryFieldBuilder() {
      if (nestedQueryBuilder_ == null) {
        if (!(queryTypeCase_ == 1)) {
          queryType_ = com.google.datastore.v1.Query.getDefaultInstance();
        }
        nestedQueryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.Query,
                com.google.datastore.v1.Query.Builder,
                com.google.datastore.v1.QueryOrBuilder>(
                (com.google.datastore.v1.Query) queryType_, getParentForChildren(), isClean());
        queryType_ = null;
      }
      queryTypeCase_ = 1;
      onChanged();
      return nestedQueryBuilder_;
    }

    private java.util.List<com.google.datastore.v1.AggregationQuery.Aggregation> aggregations_ =
        java.util.Collections.emptyList();

    private void ensureAggregationsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        aggregations_ =
            new java.util.ArrayList<com.google.datastore.v1.AggregationQuery.Aggregation>(
                aggregations_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.AggregationQuery.Aggregation,
            com.google.datastore.v1.AggregationQuery.Aggregation.Builder,
            com.google.datastore.v1.AggregationQuery.AggregationOrBuilder>
        aggregationsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `nested_query`.
     *
     * Requires:
     *
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.datastore.v1.AggregationQuery.Aggregation>
        getAggregationsList() {
      if (aggregationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(aggregations_);
      } else {
        return aggregationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `nested_query`.
     *
     * Requires:
     *
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getAggregationsCount() {
      if (aggregationsBuilder_ == null) {
        return aggregations_.size();
      } else {
        return aggregationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `nested_query`.
     *
     * Requires:
     *
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.datastore.v1.AggregationQuery.Aggregation getAggregations(int index) {
      if (aggregationsBuilder_ == null) {
        return aggregations_.get(index);
      } else {
        return aggregationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `nested_query`.
     *
     * Requires:
     *
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAggregations(
        int index, com.google.datastore.v1.AggregationQuery.Aggregation value) {
      if (aggregationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregationsIsMutable();
        aggregations_.set(index, value);
        onChanged();
      } else {
        aggregationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `nested_query`.
     *
     * Requires:
     *
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAggregations(
        int index, com.google.datastore.v1.AggregationQuery.Aggregation.Builder builderForValue) {
      if (aggregationsBuilder_ == null) {
        ensureAggregationsIsMutable();
        aggregations_.set(index, builderForValue.build());
        onChanged();
      } else {
        aggregationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `nested_query`.
     *
     * Requires:
     *
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAggregations(com.google.datastore.v1.AggregationQuery.Aggregation value) {
      if (aggregationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregationsIsMutable();
        aggregations_.add(value);
        onChanged();
      } else {
        aggregationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `nested_query`.
     *
     * Requires:
     *
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAggregations(
        int index, com.google.datastore.v1.AggregationQuery.Aggregation value) {
      if (aggregationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAggregationsIsMutable();
        aggregations_.add(index, value);
        onChanged();
      } else {
        aggregationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `nested_query`.
     *
     * Requires:
     *
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAggregations(
        com.google.datastore.v1.AggregationQuery.Aggregation.Builder builderForValue) {
      if (aggregationsBuilder_ == null) {
        ensureAggregationsIsMutable();
        aggregations_.add(builderForValue.build());
        onChanged();
      } else {
        aggregationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `nested_query`.
     *
     * Requires:
     *
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAggregations(
        int index, com.google.datastore.v1.AggregationQuery.Aggregation.Builder builderForValue) {
      if (aggregationsBuilder_ == null) {
        ensureAggregationsIsMutable();
        aggregations_.add(index, builderForValue.build());
        onChanged();
      } else {
        aggregationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `nested_query`.
     *
     * Requires:
     *
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllAggregations(
        java.lang.Iterable<? extends com.google.datastore.v1.AggregationQuery.Aggregation> values) {
      if (aggregationsBuilder_ == null) {
        ensureAggregationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, aggregations_);
        onChanged();
      } else {
        aggregationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `nested_query`.
     *
     * Requires:
     *
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAggregations() {
      if (aggregationsBuilder_ == null) {
        aggregations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        aggregationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `nested_query`.
     *
     * Requires:
     *
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAggregations(int index) {
      if (aggregationsBuilder_ == null) {
        ensureAggregationsIsMutable();
        aggregations_.remove(index);
        onChanged();
      } else {
        aggregationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `nested_query`.
     *
     * Requires:
     *
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.datastore.v1.AggregationQuery.Aggregation.Builder getAggregationsBuilder(
        int index) {
      return getAggregationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `nested_query`.
     *
     * Requires:
     *
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.datastore.v1.AggregationQuery.AggregationOrBuilder getAggregationsOrBuilder(
        int index) {
      if (aggregationsBuilder_ == null) {
        return aggregations_.get(index);
      } else {
        return aggregationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `nested_query`.
     *
     * Requires:
     *
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.datastore.v1.AggregationQuery.AggregationOrBuilder>
        getAggregationsOrBuilderList() {
      if (aggregationsBuilder_ != null) {
        return aggregationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(aggregations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `nested_query`.
     *
     * Requires:
     *
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.datastore.v1.AggregationQuery.Aggregation.Builder addAggregationsBuilder() {
      return getAggregationsFieldBuilder()
          .addBuilder(com.google.datastore.v1.AggregationQuery.Aggregation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `nested_query`.
     *
     * Requires:
     *
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.datastore.v1.AggregationQuery.Aggregation.Builder addAggregationsBuilder(
        int index) {
      return getAggregationsFieldBuilder()
          .addBuilder(
              index, com.google.datastore.v1.AggregationQuery.Aggregation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Series of aggregations to apply over the results of the
     * `nested_query`.
     *
     * Requires:
     *
     * * A minimum of one and maximum of five aggregations per query.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.AggregationQuery.Aggregation aggregations = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.datastore.v1.AggregationQuery.Aggregation.Builder>
        getAggregationsBuilderList() {
      return getAggregationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.AggregationQuery.Aggregation,
            com.google.datastore.v1.AggregationQuery.Aggregation.Builder,
            com.google.datastore.v1.AggregationQuery.AggregationOrBuilder>
        getAggregationsFieldBuilder() {
      if (aggregationsBuilder_ == null) {
        aggregationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.datastore.v1.AggregationQuery.Aggregation,
                com.google.datastore.v1.AggregationQuery.Aggregation.Builder,
                com.google.datastore.v1.AggregationQuery.AggregationOrBuilder>(
                aggregations_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        aggregations_ = null;
      }
      return aggregationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.datastore.v1.AggregationQuery)
  }

  // @@protoc_insertion_point(class_scope:google.datastore.v1.AggregationQuery)
  private static final com.google.datastore.v1.AggregationQuery DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.datastore.v1.AggregationQuery();
  }

  public static com.google.datastore.v1.AggregationQuery getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AggregationQuery> PARSER =
      new com.google.protobuf.AbstractParser<AggregationQuery>() {
        @java.lang.Override
        public AggregationQuery parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AggregationQuery> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AggregationQuery> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.datastore.v1.AggregationQuery getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
