/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/v1/datastore.proto

// Protobuf Java Version: 3.25.5
package com.google.datastore.v1;

/**
 *
 *
 * <pre>
 * A transformation of an entity property.
 * </pre>
 *
 * Protobuf type {@code google.datastore.v1.PropertyTransform}
 */
public final class PropertyTransform extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.datastore.v1.PropertyTransform)
    PropertyTransformOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PropertyTransform.newBuilder() to construct.
  private PropertyTransform(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PropertyTransform() {
    property_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PropertyTransform();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.datastore.v1.DatastoreProto
        .internal_static_google_datastore_v1_PropertyTransform_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.datastore.v1.DatastoreProto
        .internal_static_google_datastore_v1_PropertyTransform_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.datastore.v1.PropertyTransform.class,
            com.google.datastore.v1.PropertyTransform.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * A value that is calculated by the server.
   * </pre>
   *
   * Protobuf enum {@code google.datastore.v1.PropertyTransform.ServerValue}
   */
  public enum ServerValue implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified. This value must not be used.
     * </pre>
     *
     * <code>SERVER_VALUE_UNSPECIFIED = 0;</code>
     */
    SERVER_VALUE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The time at which the server processed the request, with millisecond
     * precision. If used on multiple properties (same or different entities)
     * in a transaction, all the properties will get the same server timestamp.
     * </pre>
     *
     * <code>REQUEST_TIME = 1;</code>
     */
    REQUEST_TIME(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified. This value must not be used.
     * </pre>
     *
     * <code>SERVER_VALUE_UNSPECIFIED = 0;</code>
     */
    public static final int SERVER_VALUE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The time at which the server processed the request, with millisecond
     * precision. If used on multiple properties (same or different entities)
     * in a transaction, all the properties will get the same server timestamp.
     * </pre>
     *
     * <code>REQUEST_TIME = 1;</code>
     */
    public static final int REQUEST_TIME_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ServerValue valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ServerValue forNumber(int value) {
      switch (value) {
        case 0:
          return SERVER_VALUE_UNSPECIFIED;
        case 1:
          return REQUEST_TIME;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ServerValue> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ServerValue> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ServerValue>() {
          public ServerValue findValueByNumber(int number) {
            return ServerValue.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.datastore.v1.PropertyTransform.getDescriptor().getEnumTypes().get(0);
    }

    private static final ServerValue[] VALUES = values();

    public static ServerValue valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ServerValue(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.datastore.v1.PropertyTransform.ServerValue)
  }

  private int transformTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object transformType_;

  public enum TransformTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SET_TO_SERVER_VALUE(2),
    INCREMENT(3),
    MAXIMUM(4),
    MINIMUM(5),
    APPEND_MISSING_ELEMENTS(6),
    REMOVE_ALL_FROM_ARRAY(7),
    TRANSFORMTYPE_NOT_SET(0);
    private final int value;

    private TransformTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TransformTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static TransformTypeCase forNumber(int value) {
      switch (value) {
        case 2:
          return SET_TO_SERVER_VALUE;
        case 3:
          return INCREMENT;
        case 4:
          return MAXIMUM;
        case 5:
          return MINIMUM;
        case 6:
          return APPEND_MISSING_ELEMENTS;
        case 7:
          return REMOVE_ALL_FROM_ARRAY;
        case 0:
          return TRANSFORMTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TransformTypeCase getTransformTypeCase() {
    return TransformTypeCase.forNumber(transformTypeCase_);
  }

  public static final int PROPERTY_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object property_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The name of the property.
   *
   * Property paths (a list of property names separated by dots (`.`)) may be
   * used to refer to properties inside entity values. For example `foo.bar`
   * means the property `bar` inside the entity property `foo`.
   *
   * If a property name contains a dot `.` or a backlslash `&#92;`, then that name
   * must be escaped.
   * </pre>
   *
   * <code>string property = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The property.
   */
  @java.lang.Override
  public java.lang.String getProperty() {
    java.lang.Object ref = property_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      property_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The name of the property.
   *
   * Property paths (a list of property names separated by dots (`.`)) may be
   * used to refer to properties inside entity values. For example `foo.bar`
   * means the property `bar` inside the entity property `foo`.
   *
   * If a property name contains a dot `.` or a backlslash `&#92;`, then that name
   * must be escaped.
   * </pre>
   *
   * <code>string property = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for property.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPropertyBytes() {
    java.lang.Object ref = property_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      property_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SET_TO_SERVER_VALUE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Sets the property to the given server value.
   * </pre>
   *
   * <code>.google.datastore.v1.PropertyTransform.ServerValue set_to_server_value = 2;</code>
   *
   * @return Whether the setToServerValue field is set.
   */
  public boolean hasSetToServerValue() {
    return transformTypeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Sets the property to the given server value.
   * </pre>
   *
   * <code>.google.datastore.v1.PropertyTransform.ServerValue set_to_server_value = 2;</code>
   *
   * @return The enum numeric value on the wire for setToServerValue.
   */
  public int getSetToServerValueValue() {
    if (transformTypeCase_ == 2) {
      return (java.lang.Integer) transformType_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * Sets the property to the given server value.
   * </pre>
   *
   * <code>.google.datastore.v1.PropertyTransform.ServerValue set_to_server_value = 2;</code>
   *
   * @return The setToServerValue.
   */
  public com.google.datastore.v1.PropertyTransform.ServerValue getSetToServerValue() {
    if (transformTypeCase_ == 2) {
      com.google.datastore.v1.PropertyTransform.ServerValue result =
          com.google.datastore.v1.PropertyTransform.ServerValue.forNumber(
              (java.lang.Integer) transformType_);
      return result == null
          ? com.google.datastore.v1.PropertyTransform.ServerValue.UNRECOGNIZED
          : result;
    }
    return com.google.datastore.v1.PropertyTransform.ServerValue.SERVER_VALUE_UNSPECIFIED;
  }

  public static final int INCREMENT_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Adds the given value to the property's current value.
   *
   * This must be an integer or a double value.
   * If the property is not an integer or double, or if the property does not
   * yet exist, the transformation will set the property to the given value.
   * If either of the given value or the current property value are doubles,
   * both values will be interpreted as doubles. Double arithmetic and
   * representation of double values follows IEEE 754 semantics.
   * If there is positive/negative integer overflow, the property is resolved
   * to the largest magnitude positive/negative integer.
   * </pre>
   *
   * <code>.google.datastore.v1.Value increment = 3;</code>
   *
   * @return Whether the increment field is set.
   */
  @java.lang.Override
  public boolean hasIncrement() {
    return transformTypeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Adds the given value to the property's current value.
   *
   * This must be an integer or a double value.
   * If the property is not an integer or double, or if the property does not
   * yet exist, the transformation will set the property to the given value.
   * If either of the given value or the current property value are doubles,
   * both values will be interpreted as doubles. Double arithmetic and
   * representation of double values follows IEEE 754 semantics.
   * If there is positive/negative integer overflow, the property is resolved
   * to the largest magnitude positive/negative integer.
   * </pre>
   *
   * <code>.google.datastore.v1.Value increment = 3;</code>
   *
   * @return The increment.
   */
  @java.lang.Override
  public com.google.datastore.v1.Value getIncrement() {
    if (transformTypeCase_ == 3) {
      return (com.google.datastore.v1.Value) transformType_;
    }
    return com.google.datastore.v1.Value.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Adds the given value to the property's current value.
   *
   * This must be an integer or a double value.
   * If the property is not an integer or double, or if the property does not
   * yet exist, the transformation will set the property to the given value.
   * If either of the given value or the current property value are doubles,
   * both values will be interpreted as doubles. Double arithmetic and
   * representation of double values follows IEEE 754 semantics.
   * If there is positive/negative integer overflow, the property is resolved
   * to the largest magnitude positive/negative integer.
   * </pre>
   *
   * <code>.google.datastore.v1.Value increment = 3;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.ValueOrBuilder getIncrementOrBuilder() {
    if (transformTypeCase_ == 3) {
      return (com.google.datastore.v1.Value) transformType_;
    }
    return com.google.datastore.v1.Value.getDefaultInstance();
  }

  public static final int MAXIMUM_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Sets the property to the maximum of its current value and the given
   * value.
   *
   * This must be an integer or a double value.
   * If the property is not an integer or double, or if the property does not
   * yet exist, the transformation will set the property to the given value.
   * If a maximum operation is applied where the property and the input value
   * are of mixed types (that is - one is an integer and one is a double)
   * the property takes on the type of the larger operand. If the operands are
   * equivalent (e.g. 3 and 3.0), the property does not change.
   * 0, 0.0, and -0.0 are all zero. The maximum of a zero stored value and
   * zero input value is always the stored value.
   * The maximum of any numeric value x and NaN is NaN.
   * </pre>
   *
   * <code>.google.datastore.v1.Value maximum = 4;</code>
   *
   * @return Whether the maximum field is set.
   */
  @java.lang.Override
  public boolean hasMaximum() {
    return transformTypeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Sets the property to the maximum of its current value and the given
   * value.
   *
   * This must be an integer or a double value.
   * If the property is not an integer or double, or if the property does not
   * yet exist, the transformation will set the property to the given value.
   * If a maximum operation is applied where the property and the input value
   * are of mixed types (that is - one is an integer and one is a double)
   * the property takes on the type of the larger operand. If the operands are
   * equivalent (e.g. 3 and 3.0), the property does not change.
   * 0, 0.0, and -0.0 are all zero. The maximum of a zero stored value and
   * zero input value is always the stored value.
   * The maximum of any numeric value x and NaN is NaN.
   * </pre>
   *
   * <code>.google.datastore.v1.Value maximum = 4;</code>
   *
   * @return The maximum.
   */
  @java.lang.Override
  public com.google.datastore.v1.Value getMaximum() {
    if (transformTypeCase_ == 4) {
      return (com.google.datastore.v1.Value) transformType_;
    }
    return com.google.datastore.v1.Value.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Sets the property to the maximum of its current value and the given
   * value.
   *
   * This must be an integer or a double value.
   * If the property is not an integer or double, or if the property does not
   * yet exist, the transformation will set the property to the given value.
   * If a maximum operation is applied where the property and the input value
   * are of mixed types (that is - one is an integer and one is a double)
   * the property takes on the type of the larger operand. If the operands are
   * equivalent (e.g. 3 and 3.0), the property does not change.
   * 0, 0.0, and -0.0 are all zero. The maximum of a zero stored value and
   * zero input value is always the stored value.
   * The maximum of any numeric value x and NaN is NaN.
   * </pre>
   *
   * <code>.google.datastore.v1.Value maximum = 4;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.ValueOrBuilder getMaximumOrBuilder() {
    if (transformTypeCase_ == 4) {
      return (com.google.datastore.v1.Value) transformType_;
    }
    return com.google.datastore.v1.Value.getDefaultInstance();
  }

  public static final int MINIMUM_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Sets the property to the minimum of its current value and the given
   * value.
   *
   * This must be an integer or a double value.
   * If the property is not an integer or double, or if the property does not
   * yet exist, the transformation will set the property to the input value.
   * If a minimum operation is applied where the property and the input value
   * are of mixed types (that is - one is an integer and one is a double)
   * the property takes on the type of the smaller operand. If the operands
   * are equivalent (e.g. 3 and 3.0), the property does not change. 0, 0.0,
   * and -0.0 are all zero. The minimum of a zero stored value and zero input
   * value is always the stored value. The minimum of any numeric value x and
   * NaN is NaN.
   * </pre>
   *
   * <code>.google.datastore.v1.Value minimum = 5;</code>
   *
   * @return Whether the minimum field is set.
   */
  @java.lang.Override
  public boolean hasMinimum() {
    return transformTypeCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Sets the property to the minimum of its current value and the given
   * value.
   *
   * This must be an integer or a double value.
   * If the property is not an integer or double, or if the property does not
   * yet exist, the transformation will set the property to the input value.
   * If a minimum operation is applied where the property and the input value
   * are of mixed types (that is - one is an integer and one is a double)
   * the property takes on the type of the smaller operand. If the operands
   * are equivalent (e.g. 3 and 3.0), the property does not change. 0, 0.0,
   * and -0.0 are all zero. The minimum of a zero stored value and zero input
   * value is always the stored value. The minimum of any numeric value x and
   * NaN is NaN.
   * </pre>
   *
   * <code>.google.datastore.v1.Value minimum = 5;</code>
   *
   * @return The minimum.
   */
  @java.lang.Override
  public com.google.datastore.v1.Value getMinimum() {
    if (transformTypeCase_ == 5) {
      return (com.google.datastore.v1.Value) transformType_;
    }
    return com.google.datastore.v1.Value.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Sets the property to the minimum of its current value and the given
   * value.
   *
   * This must be an integer or a double value.
   * If the property is not an integer or double, or if the property does not
   * yet exist, the transformation will set the property to the input value.
   * If a minimum operation is applied where the property and the input value
   * are of mixed types (that is - one is an integer and one is a double)
   * the property takes on the type of the smaller operand. If the operands
   * are equivalent (e.g. 3 and 3.0), the property does not change. 0, 0.0,
   * and -0.0 are all zero. The minimum of a zero stored value and zero input
   * value is always the stored value. The minimum of any numeric value x and
   * NaN is NaN.
   * </pre>
   *
   * <code>.google.datastore.v1.Value minimum = 5;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.ValueOrBuilder getMinimumOrBuilder() {
    if (transformTypeCase_ == 5) {
      return (com.google.datastore.v1.Value) transformType_;
    }
    return com.google.datastore.v1.Value.getDefaultInstance();
  }

  public static final int APPEND_MISSING_ELEMENTS_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Appends the given elements in order if they are not already present in
   * the current property value.
   * If the property is not an array, or if the property does not yet exist,
   * it is first set to the empty array.
   *
   * Equivalent numbers of different types (e.g. 3L and 3.0) are
   * considered equal when checking if a value is missing.
   * NaN is equal to NaN, and the null value is equal to the null value.
   * If the input contains multiple equivalent values, only the first will
   * be considered.
   *
   * The corresponding transform result will be the null value.
   * </pre>
   *
   * <code>.google.datastore.v1.ArrayValue append_missing_elements = 6;</code>
   *
   * @return Whether the appendMissingElements field is set.
   */
  @java.lang.Override
  public boolean hasAppendMissingElements() {
    return transformTypeCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Appends the given elements in order if they are not already present in
   * the current property value.
   * If the property is not an array, or if the property does not yet exist,
   * it is first set to the empty array.
   *
   * Equivalent numbers of different types (e.g. 3L and 3.0) are
   * considered equal when checking if a value is missing.
   * NaN is equal to NaN, and the null value is equal to the null value.
   * If the input contains multiple equivalent values, only the first will
   * be considered.
   *
   * The corresponding transform result will be the null value.
   * </pre>
   *
   * <code>.google.datastore.v1.ArrayValue append_missing_elements = 6;</code>
   *
   * @return The appendMissingElements.
   */
  @java.lang.Override
  public com.google.datastore.v1.ArrayValue getAppendMissingElements() {
    if (transformTypeCase_ == 6) {
      return (com.google.datastore.v1.ArrayValue) transformType_;
    }
    return com.google.datastore.v1.ArrayValue.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Appends the given elements in order if they are not already present in
   * the current property value.
   * If the property is not an array, or if the property does not yet exist,
   * it is first set to the empty array.
   *
   * Equivalent numbers of different types (e.g. 3L and 3.0) are
   * considered equal when checking if a value is missing.
   * NaN is equal to NaN, and the null value is equal to the null value.
   * If the input contains multiple equivalent values, only the first will
   * be considered.
   *
   * The corresponding transform result will be the null value.
   * </pre>
   *
   * <code>.google.datastore.v1.ArrayValue append_missing_elements = 6;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.ArrayValueOrBuilder getAppendMissingElementsOrBuilder() {
    if (transformTypeCase_ == 6) {
      return (com.google.datastore.v1.ArrayValue) transformType_;
    }
    return com.google.datastore.v1.ArrayValue.getDefaultInstance();
  }

  public static final int REMOVE_ALL_FROM_ARRAY_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Removes all of the given elements from the array in the property.
   * If the property is not an array, or if the property does not yet exist,
   * it is set to the empty array.
   *
   * Equivalent numbers of different types (e.g. 3L and 3.0) are
   * considered equal when deciding whether an element should be removed.
   * NaN is equal to NaN, and the null value is equal to the null value.
   * This will remove all equivalent values if there are duplicates.
   *
   * The corresponding transform result will be the null value.
   * </pre>
   *
   * <code>.google.datastore.v1.ArrayValue remove_all_from_array = 7;</code>
   *
   * @return Whether the removeAllFromArray field is set.
   */
  @java.lang.Override
  public boolean hasRemoveAllFromArray() {
    return transformTypeCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Removes all of the given elements from the array in the property.
   * If the property is not an array, or if the property does not yet exist,
   * it is set to the empty array.
   *
   * Equivalent numbers of different types (e.g. 3L and 3.0) are
   * considered equal when deciding whether an element should be removed.
   * NaN is equal to NaN, and the null value is equal to the null value.
   * This will remove all equivalent values if there are duplicates.
   *
   * The corresponding transform result will be the null value.
   * </pre>
   *
   * <code>.google.datastore.v1.ArrayValue remove_all_from_array = 7;</code>
   *
   * @return The removeAllFromArray.
   */
  @java.lang.Override
  public com.google.datastore.v1.ArrayValue getRemoveAllFromArray() {
    if (transformTypeCase_ == 7) {
      return (com.google.datastore.v1.ArrayValue) transformType_;
    }
    return com.google.datastore.v1.ArrayValue.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Removes all of the given elements from the array in the property.
   * If the property is not an array, or if the property does not yet exist,
   * it is set to the empty array.
   *
   * Equivalent numbers of different types (e.g. 3L and 3.0) are
   * considered equal when deciding whether an element should be removed.
   * NaN is equal to NaN, and the null value is equal to the null value.
   * This will remove all equivalent values if there are duplicates.
   *
   * The corresponding transform result will be the null value.
   * </pre>
   *
   * <code>.google.datastore.v1.ArrayValue remove_all_from_array = 7;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.ArrayValueOrBuilder getRemoveAllFromArrayOrBuilder() {
    if (transformTypeCase_ == 7) {
      return (com.google.datastore.v1.ArrayValue) transformType_;
    }
    return com.google.datastore.v1.ArrayValue.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(property_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, property_);
    }
    if (transformTypeCase_ == 2) {
      output.writeEnum(2, ((java.lang.Integer) transformType_));
    }
    if (transformTypeCase_ == 3) {
      output.writeMessage(3, (com.google.datastore.v1.Value) transformType_);
    }
    if (transformTypeCase_ == 4) {
      output.writeMessage(4, (com.google.datastore.v1.Value) transformType_);
    }
    if (transformTypeCase_ == 5) {
      output.writeMessage(5, (com.google.datastore.v1.Value) transformType_);
    }
    if (transformTypeCase_ == 6) {
      output.writeMessage(6, (com.google.datastore.v1.ArrayValue) transformType_);
    }
    if (transformTypeCase_ == 7) {
      output.writeMessage(7, (com.google.datastore.v1.ArrayValue) transformType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(property_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, property_);
    }
    if (transformTypeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(
              2, ((java.lang.Integer) transformType_));
    }
    if (transformTypeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.datastore.v1.Value) transformType_);
    }
    if (transformTypeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.datastore.v1.Value) transformType_);
    }
    if (transformTypeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.datastore.v1.Value) transformType_);
    }
    if (transformTypeCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.datastore.v1.ArrayValue) transformType_);
    }
    if (transformTypeCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.datastore.v1.ArrayValue) transformType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.datastore.v1.PropertyTransform)) {
      return super.equals(obj);
    }
    com.google.datastore.v1.PropertyTransform other =
        (com.google.datastore.v1.PropertyTransform) obj;

    if (!getProperty().equals(other.getProperty())) return false;
    if (!getTransformTypeCase().equals(other.getTransformTypeCase())) return false;
    switch (transformTypeCase_) {
      case 2:
        if (getSetToServerValueValue() != other.getSetToServerValueValue()) return false;
        break;
      case 3:
        if (!getIncrement().equals(other.getIncrement())) return false;
        break;
      case 4:
        if (!getMaximum().equals(other.getMaximum())) return false;
        break;
      case 5:
        if (!getMinimum().equals(other.getMinimum())) return false;
        break;
      case 6:
        if (!getAppendMissingElements().equals(other.getAppendMissingElements())) return false;
        break;
      case 7:
        if (!getRemoveAllFromArray().equals(other.getRemoveAllFromArray())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROPERTY_FIELD_NUMBER;
    hash = (53 * hash) + getProperty().hashCode();
    switch (transformTypeCase_) {
      case 2:
        hash = (37 * hash) + SET_TO_SERVER_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getSetToServerValueValue();
        break;
      case 3:
        hash = (37 * hash) + INCREMENT_FIELD_NUMBER;
        hash = (53 * hash) + getIncrement().hashCode();
        break;
      case 4:
        hash = (37 * hash) + MAXIMUM_FIELD_NUMBER;
        hash = (53 * hash) + getMaximum().hashCode();
        break;
      case 5:
        hash = (37 * hash) + MINIMUM_FIELD_NUMBER;
        hash = (53 * hash) + getMinimum().hashCode();
        break;
      case 6:
        hash = (37 * hash) + APPEND_MISSING_ELEMENTS_FIELD_NUMBER;
        hash = (53 * hash) + getAppendMissingElements().hashCode();
        break;
      case 7:
        hash = (37 * hash) + REMOVE_ALL_FROM_ARRAY_FIELD_NUMBER;
        hash = (53 * hash) + getRemoveAllFromArray().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.datastore.v1.PropertyTransform parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.PropertyTransform parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.PropertyTransform parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.PropertyTransform parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.PropertyTransform parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.PropertyTransform parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.PropertyTransform parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.PropertyTransform parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.PropertyTransform parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.PropertyTransform parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.PropertyTransform parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.PropertyTransform parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.datastore.v1.PropertyTransform prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A transformation of an entity property.
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.PropertyTransform}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.datastore.v1.PropertyTransform)
      com.google.datastore.v1.PropertyTransformOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_PropertyTransform_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_PropertyTransform_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.PropertyTransform.class,
              com.google.datastore.v1.PropertyTransform.Builder.class);
    }

    // Construct using com.google.datastore.v1.PropertyTransform.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      property_ = "";
      if (incrementBuilder_ != null) {
        incrementBuilder_.clear();
      }
      if (maximumBuilder_ != null) {
        maximumBuilder_.clear();
      }
      if (minimumBuilder_ != null) {
        minimumBuilder_.clear();
      }
      if (appendMissingElementsBuilder_ != null) {
        appendMissingElementsBuilder_.clear();
      }
      if (removeAllFromArrayBuilder_ != null) {
        removeAllFromArrayBuilder_.clear();
      }
      transformTypeCase_ = 0;
      transformType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_PropertyTransform_descriptor;
    }

    @java.lang.Override
    public com.google.datastore.v1.PropertyTransform getDefaultInstanceForType() {
      return com.google.datastore.v1.PropertyTransform.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.datastore.v1.PropertyTransform build() {
      com.google.datastore.v1.PropertyTransform result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.datastore.v1.PropertyTransform buildPartial() {
      com.google.datastore.v1.PropertyTransform result =
          new com.google.datastore.v1.PropertyTransform(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.datastore.v1.PropertyTransform result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.property_ = property_;
      }
    }

    private void buildPartialOneofs(com.google.datastore.v1.PropertyTransform result) {
      result.transformTypeCase_ = transformTypeCase_;
      result.transformType_ = this.transformType_;
      if (transformTypeCase_ == 3 && incrementBuilder_ != null) {
        result.transformType_ = incrementBuilder_.build();
      }
      if (transformTypeCase_ == 4 && maximumBuilder_ != null) {
        result.transformType_ = maximumBuilder_.build();
      }
      if (transformTypeCase_ == 5 && minimumBuilder_ != null) {
        result.transformType_ = minimumBuilder_.build();
      }
      if (transformTypeCase_ == 6 && appendMissingElementsBuilder_ != null) {
        result.transformType_ = appendMissingElementsBuilder_.build();
      }
      if (transformTypeCase_ == 7 && removeAllFromArrayBuilder_ != null) {
        result.transformType_ = removeAllFromArrayBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.datastore.v1.PropertyTransform) {
        return mergeFrom((com.google.datastore.v1.PropertyTransform) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.datastore.v1.PropertyTransform other) {
      if (other == com.google.datastore.v1.PropertyTransform.getDefaultInstance()) return this;
      if (!other.getProperty().isEmpty()) {
        property_ = other.property_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      switch (other.getTransformTypeCase()) {
        case SET_TO_SERVER_VALUE:
          {
            setSetToServerValueValue(other.getSetToServerValueValue());
            break;
          }
        case INCREMENT:
          {
            mergeIncrement(other.getIncrement());
            break;
          }
        case MAXIMUM:
          {
            mergeMaximum(other.getMaximum());
            break;
          }
        case MINIMUM:
          {
            mergeMinimum(other.getMinimum());
            break;
          }
        case APPEND_MISSING_ELEMENTS:
          {
            mergeAppendMissingElements(other.getAppendMissingElements());
            break;
          }
        case REMOVE_ALL_FROM_ARRAY:
          {
            mergeRemoveAllFromArray(other.getRemoveAllFromArray());
            break;
          }
        case TRANSFORMTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                property_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                int rawValue = input.readEnum();
                transformTypeCase_ = 2;
                transformType_ = rawValue;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getIncrementFieldBuilder().getBuilder(), extensionRegistry);
                transformTypeCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getMaximumFieldBuilder().getBuilder(), extensionRegistry);
                transformTypeCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getMinimumFieldBuilder().getBuilder(), extensionRegistry);
                transformTypeCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getAppendMissingElementsFieldBuilder().getBuilder(), extensionRegistry);
                transformTypeCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getRemoveAllFromArrayFieldBuilder().getBuilder(), extensionRegistry);
                transformTypeCase_ = 7;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int transformTypeCase_ = 0;
    private java.lang.Object transformType_;

    public TransformTypeCase getTransformTypeCase() {
      return TransformTypeCase.forNumber(transformTypeCase_);
    }

    public Builder clearTransformType() {
      transformTypeCase_ = 0;
      transformType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object property_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The name of the property.
     *
     * Property paths (a list of property names separated by dots (`.`)) may be
     * used to refer to properties inside entity values. For example `foo.bar`
     * means the property `bar` inside the entity property `foo`.
     *
     * If a property name contains a dot `.` or a backlslash `&#92;`, then that name
     * must be escaped.
     * </pre>
     *
     * <code>string property = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The property.
     */
    public java.lang.String getProperty() {
      java.lang.Object ref = property_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        property_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the property.
     *
     * Property paths (a list of property names separated by dots (`.`)) may be
     * used to refer to properties inside entity values. For example `foo.bar`
     * means the property `bar` inside the entity property `foo`.
     *
     * If a property name contains a dot `.` or a backlslash `&#92;`, then that name
     * must be escaped.
     * </pre>
     *
     * <code>string property = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for property.
     */
    public com.google.protobuf.ByteString getPropertyBytes() {
      java.lang.Object ref = property_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        property_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the property.
     *
     * Property paths (a list of property names separated by dots (`.`)) may be
     * used to refer to properties inside entity values. For example `foo.bar`
     * means the property `bar` inside the entity property `foo`.
     *
     * If a property name contains a dot `.` or a backlslash `&#92;`, then that name
     * must be escaped.
     * </pre>
     *
     * <code>string property = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The property to set.
     * @return This builder for chaining.
     */
    public Builder setProperty(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      property_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the property.
     *
     * Property paths (a list of property names separated by dots (`.`)) may be
     * used to refer to properties inside entity values. For example `foo.bar`
     * means the property `bar` inside the entity property `foo`.
     *
     * If a property name contains a dot `.` or a backlslash `&#92;`, then that name
     * must be escaped.
     * </pre>
     *
     * <code>string property = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProperty() {
      property_ = getDefaultInstance().getProperty();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The name of the property.
     *
     * Property paths (a list of property names separated by dots (`.`)) may be
     * used to refer to properties inside entity values. For example `foo.bar`
     * means the property `bar` inside the entity property `foo`.
     *
     * If a property name contains a dot `.` or a backlslash `&#92;`, then that name
     * must be escaped.
     * </pre>
     *
     * <code>string property = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for property to set.
     * @return This builder for chaining.
     */
    public Builder setPropertyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      property_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Sets the property to the given server value.
     * </pre>
     *
     * <code>.google.datastore.v1.PropertyTransform.ServerValue set_to_server_value = 2;</code>
     *
     * @return Whether the setToServerValue field is set.
     */
    @java.lang.Override
    public boolean hasSetToServerValue() {
      return transformTypeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the given server value.
     * </pre>
     *
     * <code>.google.datastore.v1.PropertyTransform.ServerValue set_to_server_value = 2;</code>
     *
     * @return The enum numeric value on the wire for setToServerValue.
     */
    @java.lang.Override
    public int getSetToServerValueValue() {
      if (transformTypeCase_ == 2) {
        return ((java.lang.Integer) transformType_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the given server value.
     * </pre>
     *
     * <code>.google.datastore.v1.PropertyTransform.ServerValue set_to_server_value = 2;</code>
     *
     * @param value The enum numeric value on the wire for setToServerValue to set.
     * @return This builder for chaining.
     */
    public Builder setSetToServerValueValue(int value) {
      transformTypeCase_ = 2;
      transformType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the given server value.
     * </pre>
     *
     * <code>.google.datastore.v1.PropertyTransform.ServerValue set_to_server_value = 2;</code>
     *
     * @return The setToServerValue.
     */
    @java.lang.Override
    public com.google.datastore.v1.PropertyTransform.ServerValue getSetToServerValue() {
      if (transformTypeCase_ == 2) {
        com.google.datastore.v1.PropertyTransform.ServerValue result =
            com.google.datastore.v1.PropertyTransform.ServerValue.forNumber(
                (java.lang.Integer) transformType_);
        return result == null
            ? com.google.datastore.v1.PropertyTransform.ServerValue.UNRECOGNIZED
            : result;
      }
      return com.google.datastore.v1.PropertyTransform.ServerValue.SERVER_VALUE_UNSPECIFIED;
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the given server value.
     * </pre>
     *
     * <code>.google.datastore.v1.PropertyTransform.ServerValue set_to_server_value = 2;</code>
     *
     * @param value The setToServerValue to set.
     * @return This builder for chaining.
     */
    public Builder setSetToServerValue(
        com.google.datastore.v1.PropertyTransform.ServerValue value) {
      if (value == null) {
        throw new NullPointerException();
      }
      transformTypeCase_ = 2;
      transformType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the given server value.
     * </pre>
     *
     * <code>.google.datastore.v1.PropertyTransform.ServerValue set_to_server_value = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSetToServerValue() {
      if (transformTypeCase_ == 2) {
        transformTypeCase_ = 0;
        transformType_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Value,
            com.google.datastore.v1.Value.Builder,
            com.google.datastore.v1.ValueOrBuilder>
        incrementBuilder_;
    /**
     *
     *
     * <pre>
     * Adds the given value to the property's current value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the given value.
     * If either of the given value or the current property value are doubles,
     * both values will be interpreted as doubles. Double arithmetic and
     * representation of double values follows IEEE 754 semantics.
     * If there is positive/negative integer overflow, the property is resolved
     * to the largest magnitude positive/negative integer.
     * </pre>
     *
     * <code>.google.datastore.v1.Value increment = 3;</code>
     *
     * @return Whether the increment field is set.
     */
    @java.lang.Override
    public boolean hasIncrement() {
      return transformTypeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Adds the given value to the property's current value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the given value.
     * If either of the given value or the current property value are doubles,
     * both values will be interpreted as doubles. Double arithmetic and
     * representation of double values follows IEEE 754 semantics.
     * If there is positive/negative integer overflow, the property is resolved
     * to the largest magnitude positive/negative integer.
     * </pre>
     *
     * <code>.google.datastore.v1.Value increment = 3;</code>
     *
     * @return The increment.
     */
    @java.lang.Override
    public com.google.datastore.v1.Value getIncrement() {
      if (incrementBuilder_ == null) {
        if (transformTypeCase_ == 3) {
          return (com.google.datastore.v1.Value) transformType_;
        }
        return com.google.datastore.v1.Value.getDefaultInstance();
      } else {
        if (transformTypeCase_ == 3) {
          return incrementBuilder_.getMessage();
        }
        return com.google.datastore.v1.Value.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Adds the given value to the property's current value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the given value.
     * If either of the given value or the current property value are doubles,
     * both values will be interpreted as doubles. Double arithmetic and
     * representation of double values follows IEEE 754 semantics.
     * If there is positive/negative integer overflow, the property is resolved
     * to the largest magnitude positive/negative integer.
     * </pre>
     *
     * <code>.google.datastore.v1.Value increment = 3;</code>
     */
    public Builder setIncrement(com.google.datastore.v1.Value value) {
      if (incrementBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformType_ = value;
        onChanged();
      } else {
        incrementBuilder_.setMessage(value);
      }
      transformTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Adds the given value to the property's current value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the given value.
     * If either of the given value or the current property value are doubles,
     * both values will be interpreted as doubles. Double arithmetic and
     * representation of double values follows IEEE 754 semantics.
     * If there is positive/negative integer overflow, the property is resolved
     * to the largest magnitude positive/negative integer.
     * </pre>
     *
     * <code>.google.datastore.v1.Value increment = 3;</code>
     */
    public Builder setIncrement(com.google.datastore.v1.Value.Builder builderForValue) {
      if (incrementBuilder_ == null) {
        transformType_ = builderForValue.build();
        onChanged();
      } else {
        incrementBuilder_.setMessage(builderForValue.build());
      }
      transformTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Adds the given value to the property's current value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the given value.
     * If either of the given value or the current property value are doubles,
     * both values will be interpreted as doubles. Double arithmetic and
     * representation of double values follows IEEE 754 semantics.
     * If there is positive/negative integer overflow, the property is resolved
     * to the largest magnitude positive/negative integer.
     * </pre>
     *
     * <code>.google.datastore.v1.Value increment = 3;</code>
     */
    public Builder mergeIncrement(com.google.datastore.v1.Value value) {
      if (incrementBuilder_ == null) {
        if (transformTypeCase_ == 3
            && transformType_ != com.google.datastore.v1.Value.getDefaultInstance()) {
          transformType_ =
              com.google.datastore.v1.Value.newBuilder(
                      (com.google.datastore.v1.Value) transformType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformType_ = value;
        }
        onChanged();
      } else {
        if (transformTypeCase_ == 3) {
          incrementBuilder_.mergeFrom(value);
        } else {
          incrementBuilder_.setMessage(value);
        }
      }
      transformTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Adds the given value to the property's current value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the given value.
     * If either of the given value or the current property value are doubles,
     * both values will be interpreted as doubles. Double arithmetic and
     * representation of double values follows IEEE 754 semantics.
     * If there is positive/negative integer overflow, the property is resolved
     * to the largest magnitude positive/negative integer.
     * </pre>
     *
     * <code>.google.datastore.v1.Value increment = 3;</code>
     */
    public Builder clearIncrement() {
      if (incrementBuilder_ == null) {
        if (transformTypeCase_ == 3) {
          transformTypeCase_ = 0;
          transformType_ = null;
          onChanged();
        }
      } else {
        if (transformTypeCase_ == 3) {
          transformTypeCase_ = 0;
          transformType_ = null;
        }
        incrementBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Adds the given value to the property's current value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the given value.
     * If either of the given value or the current property value are doubles,
     * both values will be interpreted as doubles. Double arithmetic and
     * representation of double values follows IEEE 754 semantics.
     * If there is positive/negative integer overflow, the property is resolved
     * to the largest magnitude positive/negative integer.
     * </pre>
     *
     * <code>.google.datastore.v1.Value increment = 3;</code>
     */
    public com.google.datastore.v1.Value.Builder getIncrementBuilder() {
      return getIncrementFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Adds the given value to the property's current value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the given value.
     * If either of the given value or the current property value are doubles,
     * both values will be interpreted as doubles. Double arithmetic and
     * representation of double values follows IEEE 754 semantics.
     * If there is positive/negative integer overflow, the property is resolved
     * to the largest magnitude positive/negative integer.
     * </pre>
     *
     * <code>.google.datastore.v1.Value increment = 3;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.ValueOrBuilder getIncrementOrBuilder() {
      if ((transformTypeCase_ == 3) && (incrementBuilder_ != null)) {
        return incrementBuilder_.getMessageOrBuilder();
      } else {
        if (transformTypeCase_ == 3) {
          return (com.google.datastore.v1.Value) transformType_;
        }
        return com.google.datastore.v1.Value.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Adds the given value to the property's current value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the given value.
     * If either of the given value or the current property value are doubles,
     * both values will be interpreted as doubles. Double arithmetic and
     * representation of double values follows IEEE 754 semantics.
     * If there is positive/negative integer overflow, the property is resolved
     * to the largest magnitude positive/negative integer.
     * </pre>
     *
     * <code>.google.datastore.v1.Value increment = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Value,
            com.google.datastore.v1.Value.Builder,
            com.google.datastore.v1.ValueOrBuilder>
        getIncrementFieldBuilder() {
      if (incrementBuilder_ == null) {
        if (!(transformTypeCase_ == 3)) {
          transformType_ = com.google.datastore.v1.Value.getDefaultInstance();
        }
        incrementBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.Value,
                com.google.datastore.v1.Value.Builder,
                com.google.datastore.v1.ValueOrBuilder>(
                (com.google.datastore.v1.Value) transformType_, getParentForChildren(), isClean());
        transformType_ = null;
      }
      transformTypeCase_ = 3;
      onChanged();
      return incrementBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Value,
            com.google.datastore.v1.Value.Builder,
            com.google.datastore.v1.ValueOrBuilder>
        maximumBuilder_;
    /**
     *
     *
     * <pre>
     * Sets the property to the maximum of its current value and the given
     * value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the given value.
     * If a maximum operation is applied where the property and the input value
     * are of mixed types (that is - one is an integer and one is a double)
     * the property takes on the type of the larger operand. If the operands are
     * equivalent (e.g. 3 and 3.0), the property does not change.
     * 0, 0.0, and -0.0 are all zero. The maximum of a zero stored value and
     * zero input value is always the stored value.
     * The maximum of any numeric value x and NaN is NaN.
     * </pre>
     *
     * <code>.google.datastore.v1.Value maximum = 4;</code>
     *
     * @return Whether the maximum field is set.
     */
    @java.lang.Override
    public boolean hasMaximum() {
      return transformTypeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the maximum of its current value and the given
     * value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the given value.
     * If a maximum operation is applied where the property and the input value
     * are of mixed types (that is - one is an integer and one is a double)
     * the property takes on the type of the larger operand. If the operands are
     * equivalent (e.g. 3 and 3.0), the property does not change.
     * 0, 0.0, and -0.0 are all zero. The maximum of a zero stored value and
     * zero input value is always the stored value.
     * The maximum of any numeric value x and NaN is NaN.
     * </pre>
     *
     * <code>.google.datastore.v1.Value maximum = 4;</code>
     *
     * @return The maximum.
     */
    @java.lang.Override
    public com.google.datastore.v1.Value getMaximum() {
      if (maximumBuilder_ == null) {
        if (transformTypeCase_ == 4) {
          return (com.google.datastore.v1.Value) transformType_;
        }
        return com.google.datastore.v1.Value.getDefaultInstance();
      } else {
        if (transformTypeCase_ == 4) {
          return maximumBuilder_.getMessage();
        }
        return com.google.datastore.v1.Value.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the maximum of its current value and the given
     * value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the given value.
     * If a maximum operation is applied where the property and the input value
     * are of mixed types (that is - one is an integer and one is a double)
     * the property takes on the type of the larger operand. If the operands are
     * equivalent (e.g. 3 and 3.0), the property does not change.
     * 0, 0.0, and -0.0 are all zero. The maximum of a zero stored value and
     * zero input value is always the stored value.
     * The maximum of any numeric value x and NaN is NaN.
     * </pre>
     *
     * <code>.google.datastore.v1.Value maximum = 4;</code>
     */
    public Builder setMaximum(com.google.datastore.v1.Value value) {
      if (maximumBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformType_ = value;
        onChanged();
      } else {
        maximumBuilder_.setMessage(value);
      }
      transformTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the maximum of its current value and the given
     * value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the given value.
     * If a maximum operation is applied where the property and the input value
     * are of mixed types (that is - one is an integer and one is a double)
     * the property takes on the type of the larger operand. If the operands are
     * equivalent (e.g. 3 and 3.0), the property does not change.
     * 0, 0.0, and -0.0 are all zero. The maximum of a zero stored value and
     * zero input value is always the stored value.
     * The maximum of any numeric value x and NaN is NaN.
     * </pre>
     *
     * <code>.google.datastore.v1.Value maximum = 4;</code>
     */
    public Builder setMaximum(com.google.datastore.v1.Value.Builder builderForValue) {
      if (maximumBuilder_ == null) {
        transformType_ = builderForValue.build();
        onChanged();
      } else {
        maximumBuilder_.setMessage(builderForValue.build());
      }
      transformTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the maximum of its current value and the given
     * value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the given value.
     * If a maximum operation is applied where the property and the input value
     * are of mixed types (that is - one is an integer and one is a double)
     * the property takes on the type of the larger operand. If the operands are
     * equivalent (e.g. 3 and 3.0), the property does not change.
     * 0, 0.0, and -0.0 are all zero. The maximum of a zero stored value and
     * zero input value is always the stored value.
     * The maximum of any numeric value x and NaN is NaN.
     * </pre>
     *
     * <code>.google.datastore.v1.Value maximum = 4;</code>
     */
    public Builder mergeMaximum(com.google.datastore.v1.Value value) {
      if (maximumBuilder_ == null) {
        if (transformTypeCase_ == 4
            && transformType_ != com.google.datastore.v1.Value.getDefaultInstance()) {
          transformType_ =
              com.google.datastore.v1.Value.newBuilder(
                      (com.google.datastore.v1.Value) transformType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformType_ = value;
        }
        onChanged();
      } else {
        if (transformTypeCase_ == 4) {
          maximumBuilder_.mergeFrom(value);
        } else {
          maximumBuilder_.setMessage(value);
        }
      }
      transformTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the maximum of its current value and the given
     * value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the given value.
     * If a maximum operation is applied where the property and the input value
     * are of mixed types (that is - one is an integer and one is a double)
     * the property takes on the type of the larger operand. If the operands are
     * equivalent (e.g. 3 and 3.0), the property does not change.
     * 0, 0.0, and -0.0 are all zero. The maximum of a zero stored value and
     * zero input value is always the stored value.
     * The maximum of any numeric value x and NaN is NaN.
     * </pre>
     *
     * <code>.google.datastore.v1.Value maximum = 4;</code>
     */
    public Builder clearMaximum() {
      if (maximumBuilder_ == null) {
        if (transformTypeCase_ == 4) {
          transformTypeCase_ = 0;
          transformType_ = null;
          onChanged();
        }
      } else {
        if (transformTypeCase_ == 4) {
          transformTypeCase_ = 0;
          transformType_ = null;
        }
        maximumBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the maximum of its current value and the given
     * value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the given value.
     * If a maximum operation is applied where the property and the input value
     * are of mixed types (that is - one is an integer and one is a double)
     * the property takes on the type of the larger operand. If the operands are
     * equivalent (e.g. 3 and 3.0), the property does not change.
     * 0, 0.0, and -0.0 are all zero. The maximum of a zero stored value and
     * zero input value is always the stored value.
     * The maximum of any numeric value x and NaN is NaN.
     * </pre>
     *
     * <code>.google.datastore.v1.Value maximum = 4;</code>
     */
    public com.google.datastore.v1.Value.Builder getMaximumBuilder() {
      return getMaximumFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the maximum of its current value and the given
     * value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the given value.
     * If a maximum operation is applied where the property and the input value
     * are of mixed types (that is - one is an integer and one is a double)
     * the property takes on the type of the larger operand. If the operands are
     * equivalent (e.g. 3 and 3.0), the property does not change.
     * 0, 0.0, and -0.0 are all zero. The maximum of a zero stored value and
     * zero input value is always the stored value.
     * The maximum of any numeric value x and NaN is NaN.
     * </pre>
     *
     * <code>.google.datastore.v1.Value maximum = 4;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.ValueOrBuilder getMaximumOrBuilder() {
      if ((transformTypeCase_ == 4) && (maximumBuilder_ != null)) {
        return maximumBuilder_.getMessageOrBuilder();
      } else {
        if (transformTypeCase_ == 4) {
          return (com.google.datastore.v1.Value) transformType_;
        }
        return com.google.datastore.v1.Value.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the maximum of its current value and the given
     * value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the given value.
     * If a maximum operation is applied where the property and the input value
     * are of mixed types (that is - one is an integer and one is a double)
     * the property takes on the type of the larger operand. If the operands are
     * equivalent (e.g. 3 and 3.0), the property does not change.
     * 0, 0.0, and -0.0 are all zero. The maximum of a zero stored value and
     * zero input value is always the stored value.
     * The maximum of any numeric value x and NaN is NaN.
     * </pre>
     *
     * <code>.google.datastore.v1.Value maximum = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Value,
            com.google.datastore.v1.Value.Builder,
            com.google.datastore.v1.ValueOrBuilder>
        getMaximumFieldBuilder() {
      if (maximumBuilder_ == null) {
        if (!(transformTypeCase_ == 4)) {
          transformType_ = com.google.datastore.v1.Value.getDefaultInstance();
        }
        maximumBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.Value,
                com.google.datastore.v1.Value.Builder,
                com.google.datastore.v1.ValueOrBuilder>(
                (com.google.datastore.v1.Value) transformType_, getParentForChildren(), isClean());
        transformType_ = null;
      }
      transformTypeCase_ = 4;
      onChanged();
      return maximumBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Value,
            com.google.datastore.v1.Value.Builder,
            com.google.datastore.v1.ValueOrBuilder>
        minimumBuilder_;
    /**
     *
     *
     * <pre>
     * Sets the property to the minimum of its current value and the given
     * value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the input value.
     * If a minimum operation is applied where the property and the input value
     * are of mixed types (that is - one is an integer and one is a double)
     * the property takes on the type of the smaller operand. If the operands
     * are equivalent (e.g. 3 and 3.0), the property does not change. 0, 0.0,
     * and -0.0 are all zero. The minimum of a zero stored value and zero input
     * value is always the stored value. The minimum of any numeric value x and
     * NaN is NaN.
     * </pre>
     *
     * <code>.google.datastore.v1.Value minimum = 5;</code>
     *
     * @return Whether the minimum field is set.
     */
    @java.lang.Override
    public boolean hasMinimum() {
      return transformTypeCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the minimum of its current value and the given
     * value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the input value.
     * If a minimum operation is applied where the property and the input value
     * are of mixed types (that is - one is an integer and one is a double)
     * the property takes on the type of the smaller operand. If the operands
     * are equivalent (e.g. 3 and 3.0), the property does not change. 0, 0.0,
     * and -0.0 are all zero. The minimum of a zero stored value and zero input
     * value is always the stored value. The minimum of any numeric value x and
     * NaN is NaN.
     * </pre>
     *
     * <code>.google.datastore.v1.Value minimum = 5;</code>
     *
     * @return The minimum.
     */
    @java.lang.Override
    public com.google.datastore.v1.Value getMinimum() {
      if (minimumBuilder_ == null) {
        if (transformTypeCase_ == 5) {
          return (com.google.datastore.v1.Value) transformType_;
        }
        return com.google.datastore.v1.Value.getDefaultInstance();
      } else {
        if (transformTypeCase_ == 5) {
          return minimumBuilder_.getMessage();
        }
        return com.google.datastore.v1.Value.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the minimum of its current value and the given
     * value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the input value.
     * If a minimum operation is applied where the property and the input value
     * are of mixed types (that is - one is an integer and one is a double)
     * the property takes on the type of the smaller operand. If the operands
     * are equivalent (e.g. 3 and 3.0), the property does not change. 0, 0.0,
     * and -0.0 are all zero. The minimum of a zero stored value and zero input
     * value is always the stored value. The minimum of any numeric value x and
     * NaN is NaN.
     * </pre>
     *
     * <code>.google.datastore.v1.Value minimum = 5;</code>
     */
    public Builder setMinimum(com.google.datastore.v1.Value value) {
      if (minimumBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformType_ = value;
        onChanged();
      } else {
        minimumBuilder_.setMessage(value);
      }
      transformTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the minimum of its current value and the given
     * value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the input value.
     * If a minimum operation is applied where the property and the input value
     * are of mixed types (that is - one is an integer and one is a double)
     * the property takes on the type of the smaller operand. If the operands
     * are equivalent (e.g. 3 and 3.0), the property does not change. 0, 0.0,
     * and -0.0 are all zero. The minimum of a zero stored value and zero input
     * value is always the stored value. The minimum of any numeric value x and
     * NaN is NaN.
     * </pre>
     *
     * <code>.google.datastore.v1.Value minimum = 5;</code>
     */
    public Builder setMinimum(com.google.datastore.v1.Value.Builder builderForValue) {
      if (minimumBuilder_ == null) {
        transformType_ = builderForValue.build();
        onChanged();
      } else {
        minimumBuilder_.setMessage(builderForValue.build());
      }
      transformTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the minimum of its current value and the given
     * value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the input value.
     * If a minimum operation is applied where the property and the input value
     * are of mixed types (that is - one is an integer and one is a double)
     * the property takes on the type of the smaller operand. If the operands
     * are equivalent (e.g. 3 and 3.0), the property does not change. 0, 0.0,
     * and -0.0 are all zero. The minimum of a zero stored value and zero input
     * value is always the stored value. The minimum of any numeric value x and
     * NaN is NaN.
     * </pre>
     *
     * <code>.google.datastore.v1.Value minimum = 5;</code>
     */
    public Builder mergeMinimum(com.google.datastore.v1.Value value) {
      if (minimumBuilder_ == null) {
        if (transformTypeCase_ == 5
            && transformType_ != com.google.datastore.v1.Value.getDefaultInstance()) {
          transformType_ =
              com.google.datastore.v1.Value.newBuilder(
                      (com.google.datastore.v1.Value) transformType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformType_ = value;
        }
        onChanged();
      } else {
        if (transformTypeCase_ == 5) {
          minimumBuilder_.mergeFrom(value);
        } else {
          minimumBuilder_.setMessage(value);
        }
      }
      transformTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the minimum of its current value and the given
     * value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the input value.
     * If a minimum operation is applied where the property and the input value
     * are of mixed types (that is - one is an integer and one is a double)
     * the property takes on the type of the smaller operand. If the operands
     * are equivalent (e.g. 3 and 3.0), the property does not change. 0, 0.0,
     * and -0.0 are all zero. The minimum of a zero stored value and zero input
     * value is always the stored value. The minimum of any numeric value x and
     * NaN is NaN.
     * </pre>
     *
     * <code>.google.datastore.v1.Value minimum = 5;</code>
     */
    public Builder clearMinimum() {
      if (minimumBuilder_ == null) {
        if (transformTypeCase_ == 5) {
          transformTypeCase_ = 0;
          transformType_ = null;
          onChanged();
        }
      } else {
        if (transformTypeCase_ == 5) {
          transformTypeCase_ = 0;
          transformType_ = null;
        }
        minimumBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the minimum of its current value and the given
     * value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the input value.
     * If a minimum operation is applied where the property and the input value
     * are of mixed types (that is - one is an integer and one is a double)
     * the property takes on the type of the smaller operand. If the operands
     * are equivalent (e.g. 3 and 3.0), the property does not change. 0, 0.0,
     * and -0.0 are all zero. The minimum of a zero stored value and zero input
     * value is always the stored value. The minimum of any numeric value x and
     * NaN is NaN.
     * </pre>
     *
     * <code>.google.datastore.v1.Value minimum = 5;</code>
     */
    public com.google.datastore.v1.Value.Builder getMinimumBuilder() {
      return getMinimumFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the minimum of its current value and the given
     * value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the input value.
     * If a minimum operation is applied where the property and the input value
     * are of mixed types (that is - one is an integer and one is a double)
     * the property takes on the type of the smaller operand. If the operands
     * are equivalent (e.g. 3 and 3.0), the property does not change. 0, 0.0,
     * and -0.0 are all zero. The minimum of a zero stored value and zero input
     * value is always the stored value. The minimum of any numeric value x and
     * NaN is NaN.
     * </pre>
     *
     * <code>.google.datastore.v1.Value minimum = 5;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.ValueOrBuilder getMinimumOrBuilder() {
      if ((transformTypeCase_ == 5) && (minimumBuilder_ != null)) {
        return minimumBuilder_.getMessageOrBuilder();
      } else {
        if (transformTypeCase_ == 5) {
          return (com.google.datastore.v1.Value) transformType_;
        }
        return com.google.datastore.v1.Value.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Sets the property to the minimum of its current value and the given
     * value.
     *
     * This must be an integer or a double value.
     * If the property is not an integer or double, or if the property does not
     * yet exist, the transformation will set the property to the input value.
     * If a minimum operation is applied where the property and the input value
     * are of mixed types (that is - one is an integer and one is a double)
     * the property takes on the type of the smaller operand. If the operands
     * are equivalent (e.g. 3 and 3.0), the property does not change. 0, 0.0,
     * and -0.0 are all zero. The minimum of a zero stored value and zero input
     * value is always the stored value. The minimum of any numeric value x and
     * NaN is NaN.
     * </pre>
     *
     * <code>.google.datastore.v1.Value minimum = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Value,
            com.google.datastore.v1.Value.Builder,
            com.google.datastore.v1.ValueOrBuilder>
        getMinimumFieldBuilder() {
      if (minimumBuilder_ == null) {
        if (!(transformTypeCase_ == 5)) {
          transformType_ = com.google.datastore.v1.Value.getDefaultInstance();
        }
        minimumBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.Value,
                com.google.datastore.v1.Value.Builder,
                com.google.datastore.v1.ValueOrBuilder>(
                (com.google.datastore.v1.Value) transformType_, getParentForChildren(), isClean());
        transformType_ = null;
      }
      transformTypeCase_ = 5;
      onChanged();
      return minimumBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.ArrayValue,
            com.google.datastore.v1.ArrayValue.Builder,
            com.google.datastore.v1.ArrayValueOrBuilder>
        appendMissingElementsBuilder_;
    /**
     *
     *
     * <pre>
     * Appends the given elements in order if they are not already present in
     * the current property value.
     * If the property is not an array, or if the property does not yet exist,
     * it is first set to the empty array.
     *
     * Equivalent numbers of different types (e.g. 3L and 3.0) are
     * considered equal when checking if a value is missing.
     * NaN is equal to NaN, and the null value is equal to the null value.
     * If the input contains multiple equivalent values, only the first will
     * be considered.
     *
     * The corresponding transform result will be the null value.
     * </pre>
     *
     * <code>.google.datastore.v1.ArrayValue append_missing_elements = 6;</code>
     *
     * @return Whether the appendMissingElements field is set.
     */
    @java.lang.Override
    public boolean hasAppendMissingElements() {
      return transformTypeCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Appends the given elements in order if they are not already present in
     * the current property value.
     * If the property is not an array, or if the property does not yet exist,
     * it is first set to the empty array.
     *
     * Equivalent numbers of different types (e.g. 3L and 3.0) are
     * considered equal when checking if a value is missing.
     * NaN is equal to NaN, and the null value is equal to the null value.
     * If the input contains multiple equivalent values, only the first will
     * be considered.
     *
     * The corresponding transform result will be the null value.
     * </pre>
     *
     * <code>.google.datastore.v1.ArrayValue append_missing_elements = 6;</code>
     *
     * @return The appendMissingElements.
     */
    @java.lang.Override
    public com.google.datastore.v1.ArrayValue getAppendMissingElements() {
      if (appendMissingElementsBuilder_ == null) {
        if (transformTypeCase_ == 6) {
          return (com.google.datastore.v1.ArrayValue) transformType_;
        }
        return com.google.datastore.v1.ArrayValue.getDefaultInstance();
      } else {
        if (transformTypeCase_ == 6) {
          return appendMissingElementsBuilder_.getMessage();
        }
        return com.google.datastore.v1.ArrayValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Appends the given elements in order if they are not already present in
     * the current property value.
     * If the property is not an array, or if the property does not yet exist,
     * it is first set to the empty array.
     *
     * Equivalent numbers of different types (e.g. 3L and 3.0) are
     * considered equal when checking if a value is missing.
     * NaN is equal to NaN, and the null value is equal to the null value.
     * If the input contains multiple equivalent values, only the first will
     * be considered.
     *
     * The corresponding transform result will be the null value.
     * </pre>
     *
     * <code>.google.datastore.v1.ArrayValue append_missing_elements = 6;</code>
     */
    public Builder setAppendMissingElements(com.google.datastore.v1.ArrayValue value) {
      if (appendMissingElementsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformType_ = value;
        onChanged();
      } else {
        appendMissingElementsBuilder_.setMessage(value);
      }
      transformTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Appends the given elements in order if they are not already present in
     * the current property value.
     * If the property is not an array, or if the property does not yet exist,
     * it is first set to the empty array.
     *
     * Equivalent numbers of different types (e.g. 3L and 3.0) are
     * considered equal when checking if a value is missing.
     * NaN is equal to NaN, and the null value is equal to the null value.
     * If the input contains multiple equivalent values, only the first will
     * be considered.
     *
     * The corresponding transform result will be the null value.
     * </pre>
     *
     * <code>.google.datastore.v1.ArrayValue append_missing_elements = 6;</code>
     */
    public Builder setAppendMissingElements(
        com.google.datastore.v1.ArrayValue.Builder builderForValue) {
      if (appendMissingElementsBuilder_ == null) {
        transformType_ = builderForValue.build();
        onChanged();
      } else {
        appendMissingElementsBuilder_.setMessage(builderForValue.build());
      }
      transformTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Appends the given elements in order if they are not already present in
     * the current property value.
     * If the property is not an array, or if the property does not yet exist,
     * it is first set to the empty array.
     *
     * Equivalent numbers of different types (e.g. 3L and 3.0) are
     * considered equal when checking if a value is missing.
     * NaN is equal to NaN, and the null value is equal to the null value.
     * If the input contains multiple equivalent values, only the first will
     * be considered.
     *
     * The corresponding transform result will be the null value.
     * </pre>
     *
     * <code>.google.datastore.v1.ArrayValue append_missing_elements = 6;</code>
     */
    public Builder mergeAppendMissingElements(com.google.datastore.v1.ArrayValue value) {
      if (appendMissingElementsBuilder_ == null) {
        if (transformTypeCase_ == 6
            && transformType_ != com.google.datastore.v1.ArrayValue.getDefaultInstance()) {
          transformType_ =
              com.google.datastore.v1.ArrayValue.newBuilder(
                      (com.google.datastore.v1.ArrayValue) transformType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformType_ = value;
        }
        onChanged();
      } else {
        if (transformTypeCase_ == 6) {
          appendMissingElementsBuilder_.mergeFrom(value);
        } else {
          appendMissingElementsBuilder_.setMessage(value);
        }
      }
      transformTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Appends the given elements in order if they are not already present in
     * the current property value.
     * If the property is not an array, or if the property does not yet exist,
     * it is first set to the empty array.
     *
     * Equivalent numbers of different types (e.g. 3L and 3.0) are
     * considered equal when checking if a value is missing.
     * NaN is equal to NaN, and the null value is equal to the null value.
     * If the input contains multiple equivalent values, only the first will
     * be considered.
     *
     * The corresponding transform result will be the null value.
     * </pre>
     *
     * <code>.google.datastore.v1.ArrayValue append_missing_elements = 6;</code>
     */
    public Builder clearAppendMissingElements() {
      if (appendMissingElementsBuilder_ == null) {
        if (transformTypeCase_ == 6) {
          transformTypeCase_ = 0;
          transformType_ = null;
          onChanged();
        }
      } else {
        if (transformTypeCase_ == 6) {
          transformTypeCase_ = 0;
          transformType_ = null;
        }
        appendMissingElementsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Appends the given elements in order if they are not already present in
     * the current property value.
     * If the property is not an array, or if the property does not yet exist,
     * it is first set to the empty array.
     *
     * Equivalent numbers of different types (e.g. 3L and 3.0) are
     * considered equal when checking if a value is missing.
     * NaN is equal to NaN, and the null value is equal to the null value.
     * If the input contains multiple equivalent values, only the first will
     * be considered.
     *
     * The corresponding transform result will be the null value.
     * </pre>
     *
     * <code>.google.datastore.v1.ArrayValue append_missing_elements = 6;</code>
     */
    public com.google.datastore.v1.ArrayValue.Builder getAppendMissingElementsBuilder() {
      return getAppendMissingElementsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Appends the given elements in order if they are not already present in
     * the current property value.
     * If the property is not an array, or if the property does not yet exist,
     * it is first set to the empty array.
     *
     * Equivalent numbers of different types (e.g. 3L and 3.0) are
     * considered equal when checking if a value is missing.
     * NaN is equal to NaN, and the null value is equal to the null value.
     * If the input contains multiple equivalent values, only the first will
     * be considered.
     *
     * The corresponding transform result will be the null value.
     * </pre>
     *
     * <code>.google.datastore.v1.ArrayValue append_missing_elements = 6;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.ArrayValueOrBuilder getAppendMissingElementsOrBuilder() {
      if ((transformTypeCase_ == 6) && (appendMissingElementsBuilder_ != null)) {
        return appendMissingElementsBuilder_.getMessageOrBuilder();
      } else {
        if (transformTypeCase_ == 6) {
          return (com.google.datastore.v1.ArrayValue) transformType_;
        }
        return com.google.datastore.v1.ArrayValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Appends the given elements in order if they are not already present in
     * the current property value.
     * If the property is not an array, or if the property does not yet exist,
     * it is first set to the empty array.
     *
     * Equivalent numbers of different types (e.g. 3L and 3.0) are
     * considered equal when checking if a value is missing.
     * NaN is equal to NaN, and the null value is equal to the null value.
     * If the input contains multiple equivalent values, only the first will
     * be considered.
     *
     * The corresponding transform result will be the null value.
     * </pre>
     *
     * <code>.google.datastore.v1.ArrayValue append_missing_elements = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.ArrayValue,
            com.google.datastore.v1.ArrayValue.Builder,
            com.google.datastore.v1.ArrayValueOrBuilder>
        getAppendMissingElementsFieldBuilder() {
      if (appendMissingElementsBuilder_ == null) {
        if (!(transformTypeCase_ == 6)) {
          transformType_ = com.google.datastore.v1.ArrayValue.getDefaultInstance();
        }
        appendMissingElementsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.ArrayValue,
                com.google.datastore.v1.ArrayValue.Builder,
                com.google.datastore.v1.ArrayValueOrBuilder>(
                (com.google.datastore.v1.ArrayValue) transformType_,
                getParentForChildren(),
                isClean());
        transformType_ = null;
      }
      transformTypeCase_ = 6;
      onChanged();
      return appendMissingElementsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.ArrayValue,
            com.google.datastore.v1.ArrayValue.Builder,
            com.google.datastore.v1.ArrayValueOrBuilder>
        removeAllFromArrayBuilder_;
    /**
     *
     *
     * <pre>
     * Removes all of the given elements from the array in the property.
     * If the property is not an array, or if the property does not yet exist,
     * it is set to the empty array.
     *
     * Equivalent numbers of different types (e.g. 3L and 3.0) are
     * considered equal when deciding whether an element should be removed.
     * NaN is equal to NaN, and the null value is equal to the null value.
     * This will remove all equivalent values if there are duplicates.
     *
     * The corresponding transform result will be the null value.
     * </pre>
     *
     * <code>.google.datastore.v1.ArrayValue remove_all_from_array = 7;</code>
     *
     * @return Whether the removeAllFromArray field is set.
     */
    @java.lang.Override
    public boolean hasRemoveAllFromArray() {
      return transformTypeCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Removes all of the given elements from the array in the property.
     * If the property is not an array, or if the property does not yet exist,
     * it is set to the empty array.
     *
     * Equivalent numbers of different types (e.g. 3L and 3.0) are
     * considered equal when deciding whether an element should be removed.
     * NaN is equal to NaN, and the null value is equal to the null value.
     * This will remove all equivalent values if there are duplicates.
     *
     * The corresponding transform result will be the null value.
     * </pre>
     *
     * <code>.google.datastore.v1.ArrayValue remove_all_from_array = 7;</code>
     *
     * @return The removeAllFromArray.
     */
    @java.lang.Override
    public com.google.datastore.v1.ArrayValue getRemoveAllFromArray() {
      if (removeAllFromArrayBuilder_ == null) {
        if (transformTypeCase_ == 7) {
          return (com.google.datastore.v1.ArrayValue) transformType_;
        }
        return com.google.datastore.v1.ArrayValue.getDefaultInstance();
      } else {
        if (transformTypeCase_ == 7) {
          return removeAllFromArrayBuilder_.getMessage();
        }
        return com.google.datastore.v1.ArrayValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Removes all of the given elements from the array in the property.
     * If the property is not an array, or if the property does not yet exist,
     * it is set to the empty array.
     *
     * Equivalent numbers of different types (e.g. 3L and 3.0) are
     * considered equal when deciding whether an element should be removed.
     * NaN is equal to NaN, and the null value is equal to the null value.
     * This will remove all equivalent values if there are duplicates.
     *
     * The corresponding transform result will be the null value.
     * </pre>
     *
     * <code>.google.datastore.v1.ArrayValue remove_all_from_array = 7;</code>
     */
    public Builder setRemoveAllFromArray(com.google.datastore.v1.ArrayValue value) {
      if (removeAllFromArrayBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        transformType_ = value;
        onChanged();
      } else {
        removeAllFromArrayBuilder_.setMessage(value);
      }
      transformTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Removes all of the given elements from the array in the property.
     * If the property is not an array, or if the property does not yet exist,
     * it is set to the empty array.
     *
     * Equivalent numbers of different types (e.g. 3L and 3.0) are
     * considered equal when deciding whether an element should be removed.
     * NaN is equal to NaN, and the null value is equal to the null value.
     * This will remove all equivalent values if there are duplicates.
     *
     * The corresponding transform result will be the null value.
     * </pre>
     *
     * <code>.google.datastore.v1.ArrayValue remove_all_from_array = 7;</code>
     */
    public Builder setRemoveAllFromArray(
        com.google.datastore.v1.ArrayValue.Builder builderForValue) {
      if (removeAllFromArrayBuilder_ == null) {
        transformType_ = builderForValue.build();
        onChanged();
      } else {
        removeAllFromArrayBuilder_.setMessage(builderForValue.build());
      }
      transformTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Removes all of the given elements from the array in the property.
     * If the property is not an array, or if the property does not yet exist,
     * it is set to the empty array.
     *
     * Equivalent numbers of different types (e.g. 3L and 3.0) are
     * considered equal when deciding whether an element should be removed.
     * NaN is equal to NaN, and the null value is equal to the null value.
     * This will remove all equivalent values if there are duplicates.
     *
     * The corresponding transform result will be the null value.
     * </pre>
     *
     * <code>.google.datastore.v1.ArrayValue remove_all_from_array = 7;</code>
     */
    public Builder mergeRemoveAllFromArray(com.google.datastore.v1.ArrayValue value) {
      if (removeAllFromArrayBuilder_ == null) {
        if (transformTypeCase_ == 7
            && transformType_ != com.google.datastore.v1.ArrayValue.getDefaultInstance()) {
          transformType_ =
              com.google.datastore.v1.ArrayValue.newBuilder(
                      (com.google.datastore.v1.ArrayValue) transformType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          transformType_ = value;
        }
        onChanged();
      } else {
        if (transformTypeCase_ == 7) {
          removeAllFromArrayBuilder_.mergeFrom(value);
        } else {
          removeAllFromArrayBuilder_.setMessage(value);
        }
      }
      transformTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Removes all of the given elements from the array in the property.
     * If the property is not an array, or if the property does not yet exist,
     * it is set to the empty array.
     *
     * Equivalent numbers of different types (e.g. 3L and 3.0) are
     * considered equal when deciding whether an element should be removed.
     * NaN is equal to NaN, and the null value is equal to the null value.
     * This will remove all equivalent values if there are duplicates.
     *
     * The corresponding transform result will be the null value.
     * </pre>
     *
     * <code>.google.datastore.v1.ArrayValue remove_all_from_array = 7;</code>
     */
    public Builder clearRemoveAllFromArray() {
      if (removeAllFromArrayBuilder_ == null) {
        if (transformTypeCase_ == 7) {
          transformTypeCase_ = 0;
          transformType_ = null;
          onChanged();
        }
      } else {
        if (transformTypeCase_ == 7) {
          transformTypeCase_ = 0;
          transformType_ = null;
        }
        removeAllFromArrayBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Removes all of the given elements from the array in the property.
     * If the property is not an array, or if the property does not yet exist,
     * it is set to the empty array.
     *
     * Equivalent numbers of different types (e.g. 3L and 3.0) are
     * considered equal when deciding whether an element should be removed.
     * NaN is equal to NaN, and the null value is equal to the null value.
     * This will remove all equivalent values if there are duplicates.
     *
     * The corresponding transform result will be the null value.
     * </pre>
     *
     * <code>.google.datastore.v1.ArrayValue remove_all_from_array = 7;</code>
     */
    public com.google.datastore.v1.ArrayValue.Builder getRemoveAllFromArrayBuilder() {
      return getRemoveAllFromArrayFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Removes all of the given elements from the array in the property.
     * If the property is not an array, or if the property does not yet exist,
     * it is set to the empty array.
     *
     * Equivalent numbers of different types (e.g. 3L and 3.0) are
     * considered equal when deciding whether an element should be removed.
     * NaN is equal to NaN, and the null value is equal to the null value.
     * This will remove all equivalent values if there are duplicates.
     *
     * The corresponding transform result will be the null value.
     * </pre>
     *
     * <code>.google.datastore.v1.ArrayValue remove_all_from_array = 7;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.ArrayValueOrBuilder getRemoveAllFromArrayOrBuilder() {
      if ((transformTypeCase_ == 7) && (removeAllFromArrayBuilder_ != null)) {
        return removeAllFromArrayBuilder_.getMessageOrBuilder();
      } else {
        if (transformTypeCase_ == 7) {
          return (com.google.datastore.v1.ArrayValue) transformType_;
        }
        return com.google.datastore.v1.ArrayValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Removes all of the given elements from the array in the property.
     * If the property is not an array, or if the property does not yet exist,
     * it is set to the empty array.
     *
     * Equivalent numbers of different types (e.g. 3L and 3.0) are
     * considered equal when deciding whether an element should be removed.
     * NaN is equal to NaN, and the null value is equal to the null value.
     * This will remove all equivalent values if there are duplicates.
     *
     * The corresponding transform result will be the null value.
     * </pre>
     *
     * <code>.google.datastore.v1.ArrayValue remove_all_from_array = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.ArrayValue,
            com.google.datastore.v1.ArrayValue.Builder,
            com.google.datastore.v1.ArrayValueOrBuilder>
        getRemoveAllFromArrayFieldBuilder() {
      if (removeAllFromArrayBuilder_ == null) {
        if (!(transformTypeCase_ == 7)) {
          transformType_ = com.google.datastore.v1.ArrayValue.getDefaultInstance();
        }
        removeAllFromArrayBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.ArrayValue,
                com.google.datastore.v1.ArrayValue.Builder,
                com.google.datastore.v1.ArrayValueOrBuilder>(
                (com.google.datastore.v1.ArrayValue) transformType_,
                getParentForChildren(),
                isClean());
        transformType_ = null;
      }
      transformTypeCase_ = 7;
      onChanged();
      return removeAllFromArrayBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.datastore.v1.PropertyTransform)
  }

  // @@protoc_insertion_point(class_scope:google.datastore.v1.PropertyTransform)
  private static final com.google.datastore.v1.PropertyTransform DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.datastore.v1.PropertyTransform();
  }

  public static com.google.datastore.v1.PropertyTransform getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PropertyTransform> PARSER =
      new com.google.protobuf.AbstractParser<PropertyTransform>() {
        @java.lang.Override
        public PropertyTransform parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PropertyTransform> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PropertyTransform> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.datastore.v1.PropertyTransform getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
