/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/v1/datastore.proto

// Protobuf Java Version: 3.25.5
package com.google.datastore.v1;

/**
 *
 *
 * <pre>
 * The response for [Datastore.Lookup][google.datastore.v1.Datastore.Lookup].
 * </pre>
 *
 * Protobuf type {@code google.datastore.v1.LookupResponse}
 */
public final class LookupResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.datastore.v1.LookupResponse)
    LookupResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use LookupResponse.newBuilder() to construct.
  private LookupResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LookupResponse() {
    found_ = java.util.Collections.emptyList();
    missing_ = java.util.Collections.emptyList();
    deferred_ = java.util.Collections.emptyList();
    transaction_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LookupResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.datastore.v1.DatastoreProto
        .internal_static_google_datastore_v1_LookupResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.datastore.v1.DatastoreProto
        .internal_static_google_datastore_v1_LookupResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.datastore.v1.LookupResponse.class,
            com.google.datastore.v1.LookupResponse.Builder.class);
  }

  private int bitField0_;
  public static final int FOUND_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.datastore.v1.EntityResult> found_;

  /**
   *
   *
   * <pre>
   * Entities found as `ResultType.FULL` entities. The order of results in this
   * field is undefined and has no relation to the order of the keys in the
   * input.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.datastore.v1.EntityResult> getFoundList() {
    return found_;
  }

  /**
   *
   *
   * <pre>
   * Entities found as `ResultType.FULL` entities. The order of results in this
   * field is undefined and has no relation to the order of the keys in the
   * input.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.datastore.v1.EntityResultOrBuilder>
      getFoundOrBuilderList() {
    return found_;
  }

  /**
   *
   *
   * <pre>
   * Entities found as `ResultType.FULL` entities. The order of results in this
   * field is undefined and has no relation to the order of the keys in the
   * input.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
   */
  @java.lang.Override
  public int getFoundCount() {
    return found_.size();
  }

  /**
   *
   *
   * <pre>
   * Entities found as `ResultType.FULL` entities. The order of results in this
   * field is undefined and has no relation to the order of the keys in the
   * input.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.EntityResult getFound(int index) {
    return found_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Entities found as `ResultType.FULL` entities. The order of results in this
   * field is undefined and has no relation to the order of the keys in the
   * input.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.EntityResultOrBuilder getFoundOrBuilder(int index) {
    return found_.get(index);
  }

  public static final int MISSING_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.datastore.v1.EntityResult> missing_;

  /**
   *
   *
   * <pre>
   * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
   * in this field is undefined and has no relation to the order of the keys
   * in the input.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.datastore.v1.EntityResult> getMissingList() {
    return missing_;
  }

  /**
   *
   *
   * <pre>
   * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
   * in this field is undefined and has no relation to the order of the keys
   * in the input.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.datastore.v1.EntityResultOrBuilder>
      getMissingOrBuilderList() {
    return missing_;
  }

  /**
   *
   *
   * <pre>
   * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
   * in this field is undefined and has no relation to the order of the keys
   * in the input.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
   */
  @java.lang.Override
  public int getMissingCount() {
    return missing_.size();
  }

  /**
   *
   *
   * <pre>
   * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
   * in this field is undefined and has no relation to the order of the keys
   * in the input.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.EntityResult getMissing(int index) {
    return missing_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
   * in this field is undefined and has no relation to the order of the keys
   * in the input.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.EntityResultOrBuilder getMissingOrBuilder(int index) {
    return missing_.get(index);
  }

  public static final int DEFERRED_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.datastore.v1.Key> deferred_;

  /**
   *
   *
   * <pre>
   * A list of keys that were not looked up due to resource constraints. The
   * order of results in this field is undefined and has no relation to the
   * order of the keys in the input.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.datastore.v1.Key> getDeferredList() {
    return deferred_;
  }

  /**
   *
   *
   * <pre>
   * A list of keys that were not looked up due to resource constraints. The
   * order of results in this field is undefined and has no relation to the
   * order of the keys in the input.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.datastore.v1.KeyOrBuilder> getDeferredOrBuilderList() {
    return deferred_;
  }

  /**
   *
   *
   * <pre>
   * A list of keys that were not looked up due to resource constraints. The
   * order of results in this field is undefined and has no relation to the
   * order of the keys in the input.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
   */
  @java.lang.Override
  public int getDeferredCount() {
    return deferred_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of keys that were not looked up due to resource constraints. The
   * order of results in this field is undefined and has no relation to the
   * order of the keys in the input.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.Key getDeferred(int index) {
    return deferred_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of keys that were not looked up due to resource constraints. The
   * order of results in this field is undefined and has no relation to the
   * order of the keys in the input.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.KeyOrBuilder getDeferredOrBuilder(int index) {
    return deferred_.get(index);
  }

  public static final int TRANSACTION_FIELD_NUMBER = 5;
  private com.google.protobuf.ByteString transaction_ = com.google.protobuf.ByteString.EMPTY;

  /**
   *
   *
   * <pre>
   * The identifier of the transaction that was started as part of this Lookup
   * request.
   *
   * Set only when
   * [ReadOptions.new_transaction][google.datastore.v1.ReadOptions.new_transaction]
   * was set in
   * [LookupRequest.read_options][google.datastore.v1.LookupRequest.read_options].
   * </pre>
   *
   * <code>bytes transaction = 5;</code>
   *
   * @return The transaction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTransaction() {
    return transaction_;
  }

  public static final int READ_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp readTime_;

  /**
   *
   *
   * <pre>
   * The time at which these entities were read or found missing.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 7;</code>
   *
   * @return Whether the readTime field is set.
   */
  @java.lang.Override
  public boolean hasReadTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The time at which these entities were read or found missing.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 7;</code>
   *
   * @return The readTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getReadTime() {
    return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
  }

  /**
   *
   *
   * <pre>
   * The time at which these entities were read or found missing.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp read_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
    return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < found_.size(); i++) {
      output.writeMessage(1, found_.get(i));
    }
    for (int i = 0; i < missing_.size(); i++) {
      output.writeMessage(2, missing_.get(i));
    }
    for (int i = 0; i < deferred_.size(); i++) {
      output.writeMessage(3, deferred_.get(i));
    }
    if (!transaction_.isEmpty()) {
      output.writeBytes(5, transaction_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getReadTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < found_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, found_.get(i));
    }
    for (int i = 0; i < missing_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, missing_.get(i));
    }
    for (int i = 0; i < deferred_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, deferred_.get(i));
    }
    if (!transaction_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(5, transaction_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getReadTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.datastore.v1.LookupResponse)) {
      return super.equals(obj);
    }
    com.google.datastore.v1.LookupResponse other = (com.google.datastore.v1.LookupResponse) obj;

    if (!getFoundList().equals(other.getFoundList())) return false;
    if (!getMissingList().equals(other.getMissingList())) return false;
    if (!getDeferredList().equals(other.getDeferredList())) return false;
    if (!getTransaction().equals(other.getTransaction())) return false;
    if (hasReadTime() != other.hasReadTime()) return false;
    if (hasReadTime()) {
      if (!getReadTime().equals(other.getReadTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getFoundCount() > 0) {
      hash = (37 * hash) + FOUND_FIELD_NUMBER;
      hash = (53 * hash) + getFoundList().hashCode();
    }
    if (getMissingCount() > 0) {
      hash = (37 * hash) + MISSING_FIELD_NUMBER;
      hash = (53 * hash) + getMissingList().hashCode();
    }
    if (getDeferredCount() > 0) {
      hash = (37 * hash) + DEFERRED_FIELD_NUMBER;
      hash = (53 * hash) + getDeferredList().hashCode();
    }
    hash = (37 * hash) + TRANSACTION_FIELD_NUMBER;
    hash = (53 * hash) + getTransaction().hashCode();
    if (hasReadTime()) {
      hash = (37 * hash) + READ_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getReadTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.datastore.v1.LookupResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.LookupResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.LookupResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.LookupResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.LookupResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.LookupResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.LookupResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.LookupResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.LookupResponse parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.LookupResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.LookupResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.LookupResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.datastore.v1.LookupResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The response for [Datastore.Lookup][google.datastore.v1.Datastore.Lookup].
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.LookupResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.datastore.v1.LookupResponse)
      com.google.datastore.v1.LookupResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_LookupResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_LookupResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.LookupResponse.class,
              com.google.datastore.v1.LookupResponse.Builder.class);
    }

    // Construct using com.google.datastore.v1.LookupResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFoundFieldBuilder();
        getMissingFieldBuilder();
        getDeferredFieldBuilder();
        getReadTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (foundBuilder_ == null) {
        found_ = java.util.Collections.emptyList();
      } else {
        found_ = null;
        foundBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (missingBuilder_ == null) {
        missing_ = java.util.Collections.emptyList();
      } else {
        missing_ = null;
        missingBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (deferredBuilder_ == null) {
        deferred_ = java.util.Collections.emptyList();
      } else {
        deferred_ = null;
        deferredBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      transaction_ = com.google.protobuf.ByteString.EMPTY;
      readTime_ = null;
      if (readTimeBuilder_ != null) {
        readTimeBuilder_.dispose();
        readTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_LookupResponse_descriptor;
    }

    @java.lang.Override
    public com.google.datastore.v1.LookupResponse getDefaultInstanceForType() {
      return com.google.datastore.v1.LookupResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.datastore.v1.LookupResponse build() {
      com.google.datastore.v1.LookupResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.datastore.v1.LookupResponse buildPartial() {
      com.google.datastore.v1.LookupResponse result =
          new com.google.datastore.v1.LookupResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.datastore.v1.LookupResponse result) {
      if (foundBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          found_ = java.util.Collections.unmodifiableList(found_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.found_ = found_;
      } else {
        result.found_ = foundBuilder_.build();
      }
      if (missingBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          missing_ = java.util.Collections.unmodifiableList(missing_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.missing_ = missing_;
      } else {
        result.missing_ = missingBuilder_.build();
      }
      if (deferredBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          deferred_ = java.util.Collections.unmodifiableList(deferred_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.deferred_ = deferred_;
      } else {
        result.deferred_ = deferredBuilder_.build();
      }
    }

    private void buildPartial0(com.google.datastore.v1.LookupResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.transaction_ = transaction_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.readTime_ = readTimeBuilder_ == null ? readTime_ : readTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.datastore.v1.LookupResponse) {
        return mergeFrom((com.google.datastore.v1.LookupResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.datastore.v1.LookupResponse other) {
      if (other == com.google.datastore.v1.LookupResponse.getDefaultInstance()) return this;
      if (foundBuilder_ == null) {
        if (!other.found_.isEmpty()) {
          if (found_.isEmpty()) {
            found_ = other.found_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureFoundIsMutable();
            found_.addAll(other.found_);
          }
          onChanged();
        }
      } else {
        if (!other.found_.isEmpty()) {
          if (foundBuilder_.isEmpty()) {
            foundBuilder_.dispose();
            foundBuilder_ = null;
            found_ = other.found_;
            bitField0_ = (bitField0_ & ~0x00000001);
            foundBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFoundFieldBuilder()
                    : null;
          } else {
            foundBuilder_.addAllMessages(other.found_);
          }
        }
      }
      if (missingBuilder_ == null) {
        if (!other.missing_.isEmpty()) {
          if (missing_.isEmpty()) {
            missing_ = other.missing_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureMissingIsMutable();
            missing_.addAll(other.missing_);
          }
          onChanged();
        }
      } else {
        if (!other.missing_.isEmpty()) {
          if (missingBuilder_.isEmpty()) {
            missingBuilder_.dispose();
            missingBuilder_ = null;
            missing_ = other.missing_;
            bitField0_ = (bitField0_ & ~0x00000002);
            missingBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMissingFieldBuilder()
                    : null;
          } else {
            missingBuilder_.addAllMessages(other.missing_);
          }
        }
      }
      if (deferredBuilder_ == null) {
        if (!other.deferred_.isEmpty()) {
          if (deferred_.isEmpty()) {
            deferred_ = other.deferred_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureDeferredIsMutable();
            deferred_.addAll(other.deferred_);
          }
          onChanged();
        }
      } else {
        if (!other.deferred_.isEmpty()) {
          if (deferredBuilder_.isEmpty()) {
            deferredBuilder_.dispose();
            deferredBuilder_ = null;
            deferred_ = other.deferred_;
            bitField0_ = (bitField0_ & ~0x00000004);
            deferredBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDeferredFieldBuilder()
                    : null;
          } else {
            deferredBuilder_.addAllMessages(other.deferred_);
          }
        }
      }
      if (other.getTransaction() != com.google.protobuf.ByteString.EMPTY) {
        setTransaction(other.getTransaction());
      }
      if (other.hasReadTime()) {
        mergeReadTime(other.getReadTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.datastore.v1.EntityResult m =
                    input.readMessage(
                        com.google.datastore.v1.EntityResult.parser(), extensionRegistry);
                if (foundBuilder_ == null) {
                  ensureFoundIsMutable();
                  found_.add(m);
                } else {
                  foundBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.datastore.v1.EntityResult m =
                    input.readMessage(
                        com.google.datastore.v1.EntityResult.parser(), extensionRegistry);
                if (missingBuilder_ == null) {
                  ensureMissingIsMutable();
                  missing_.add(m);
                } else {
                  missingBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.datastore.v1.Key m =
                    input.readMessage(com.google.datastore.v1.Key.parser(), extensionRegistry);
                if (deferredBuilder_ == null) {
                  ensureDeferredIsMutable();
                  deferred_.add(m);
                } else {
                  deferredBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 42:
              {
                transaction_ = input.readBytes();
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 58:
              {
                input.readMessage(getReadTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.datastore.v1.EntityResult> found_ =
        java.util.Collections.emptyList();

    private void ensureFoundIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        found_ = new java.util.ArrayList<com.google.datastore.v1.EntityResult>(found_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.EntityResult,
            com.google.datastore.v1.EntityResult.Builder,
            com.google.datastore.v1.EntityResultOrBuilder>
        foundBuilder_;

    /**
     *
     *
     * <pre>
     * Entities found as `ResultType.FULL` entities. The order of results in this
     * field is undefined and has no relation to the order of the keys in the
     * input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
     */
    public java.util.List<com.google.datastore.v1.EntityResult> getFoundList() {
      if (foundBuilder_ == null) {
        return java.util.Collections.unmodifiableList(found_);
      } else {
        return foundBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Entities found as `ResultType.FULL` entities. The order of results in this
     * field is undefined and has no relation to the order of the keys in the
     * input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
     */
    public int getFoundCount() {
      if (foundBuilder_ == null) {
        return found_.size();
      } else {
        return foundBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Entities found as `ResultType.FULL` entities. The order of results in this
     * field is undefined and has no relation to the order of the keys in the
     * input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
     */
    public com.google.datastore.v1.EntityResult getFound(int index) {
      if (foundBuilder_ == null) {
        return found_.get(index);
      } else {
        return foundBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Entities found as `ResultType.FULL` entities. The order of results in this
     * field is undefined and has no relation to the order of the keys in the
     * input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
     */
    public Builder setFound(int index, com.google.datastore.v1.EntityResult value) {
      if (foundBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFoundIsMutable();
        found_.set(index, value);
        onChanged();
      } else {
        foundBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities found as `ResultType.FULL` entities. The order of results in this
     * field is undefined and has no relation to the order of the keys in the
     * input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
     */
    public Builder setFound(
        int index, com.google.datastore.v1.EntityResult.Builder builderForValue) {
      if (foundBuilder_ == null) {
        ensureFoundIsMutable();
        found_.set(index, builderForValue.build());
        onChanged();
      } else {
        foundBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities found as `ResultType.FULL` entities. The order of results in this
     * field is undefined and has no relation to the order of the keys in the
     * input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
     */
    public Builder addFound(com.google.datastore.v1.EntityResult value) {
      if (foundBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFoundIsMutable();
        found_.add(value);
        onChanged();
      } else {
        foundBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities found as `ResultType.FULL` entities. The order of results in this
     * field is undefined and has no relation to the order of the keys in the
     * input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
     */
    public Builder addFound(int index, com.google.datastore.v1.EntityResult value) {
      if (foundBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFoundIsMutable();
        found_.add(index, value);
        onChanged();
      } else {
        foundBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities found as `ResultType.FULL` entities. The order of results in this
     * field is undefined and has no relation to the order of the keys in the
     * input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
     */
    public Builder addFound(com.google.datastore.v1.EntityResult.Builder builderForValue) {
      if (foundBuilder_ == null) {
        ensureFoundIsMutable();
        found_.add(builderForValue.build());
        onChanged();
      } else {
        foundBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities found as `ResultType.FULL` entities. The order of results in this
     * field is undefined and has no relation to the order of the keys in the
     * input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
     */
    public Builder addFound(
        int index, com.google.datastore.v1.EntityResult.Builder builderForValue) {
      if (foundBuilder_ == null) {
        ensureFoundIsMutable();
        found_.add(index, builderForValue.build());
        onChanged();
      } else {
        foundBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities found as `ResultType.FULL` entities. The order of results in this
     * field is undefined and has no relation to the order of the keys in the
     * input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
     */
    public Builder addAllFound(
        java.lang.Iterable<? extends com.google.datastore.v1.EntityResult> values) {
      if (foundBuilder_ == null) {
        ensureFoundIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, found_);
        onChanged();
      } else {
        foundBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities found as `ResultType.FULL` entities. The order of results in this
     * field is undefined and has no relation to the order of the keys in the
     * input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
     */
    public Builder clearFound() {
      if (foundBuilder_ == null) {
        found_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        foundBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities found as `ResultType.FULL` entities. The order of results in this
     * field is undefined and has no relation to the order of the keys in the
     * input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
     */
    public Builder removeFound(int index) {
      if (foundBuilder_ == null) {
        ensureFoundIsMutable();
        found_.remove(index);
        onChanged();
      } else {
        foundBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities found as `ResultType.FULL` entities. The order of results in this
     * field is undefined and has no relation to the order of the keys in the
     * input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
     */
    public com.google.datastore.v1.EntityResult.Builder getFoundBuilder(int index) {
      return getFoundFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Entities found as `ResultType.FULL` entities. The order of results in this
     * field is undefined and has no relation to the order of the keys in the
     * input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
     */
    public com.google.datastore.v1.EntityResultOrBuilder getFoundOrBuilder(int index) {
      if (foundBuilder_ == null) {
        return found_.get(index);
      } else {
        return foundBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Entities found as `ResultType.FULL` entities. The order of results in this
     * field is undefined and has no relation to the order of the keys in the
     * input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
     */
    public java.util.List<? extends com.google.datastore.v1.EntityResultOrBuilder>
        getFoundOrBuilderList() {
      if (foundBuilder_ != null) {
        return foundBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(found_);
      }
    }

    /**
     *
     *
     * <pre>
     * Entities found as `ResultType.FULL` entities. The order of results in this
     * field is undefined and has no relation to the order of the keys in the
     * input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
     */
    public com.google.datastore.v1.EntityResult.Builder addFoundBuilder() {
      return getFoundFieldBuilder()
          .addBuilder(com.google.datastore.v1.EntityResult.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Entities found as `ResultType.FULL` entities. The order of results in this
     * field is undefined and has no relation to the order of the keys in the
     * input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
     */
    public com.google.datastore.v1.EntityResult.Builder addFoundBuilder(int index) {
      return getFoundFieldBuilder()
          .addBuilder(index, com.google.datastore.v1.EntityResult.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Entities found as `ResultType.FULL` entities. The order of results in this
     * field is undefined and has no relation to the order of the keys in the
     * input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult found = 1;</code>
     */
    public java.util.List<com.google.datastore.v1.EntityResult.Builder> getFoundBuilderList() {
      return getFoundFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.EntityResult,
            com.google.datastore.v1.EntityResult.Builder,
            com.google.datastore.v1.EntityResultOrBuilder>
        getFoundFieldBuilder() {
      if (foundBuilder_ == null) {
        foundBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.datastore.v1.EntityResult,
                com.google.datastore.v1.EntityResult.Builder,
                com.google.datastore.v1.EntityResultOrBuilder>(
                found_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        found_ = null;
      }
      return foundBuilder_;
    }

    private java.util.List<com.google.datastore.v1.EntityResult> missing_ =
        java.util.Collections.emptyList();

    private void ensureMissingIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        missing_ = new java.util.ArrayList<com.google.datastore.v1.EntityResult>(missing_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.EntityResult,
            com.google.datastore.v1.EntityResult.Builder,
            com.google.datastore.v1.EntityResultOrBuilder>
        missingBuilder_;

    /**
     *
     *
     * <pre>
     * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
     * in this field is undefined and has no relation to the order of the keys
     * in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
     */
    public java.util.List<com.google.datastore.v1.EntityResult> getMissingList() {
      if (missingBuilder_ == null) {
        return java.util.Collections.unmodifiableList(missing_);
      } else {
        return missingBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
     * in this field is undefined and has no relation to the order of the keys
     * in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
     */
    public int getMissingCount() {
      if (missingBuilder_ == null) {
        return missing_.size();
      } else {
        return missingBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
     * in this field is undefined and has no relation to the order of the keys
     * in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
     */
    public com.google.datastore.v1.EntityResult getMissing(int index) {
      if (missingBuilder_ == null) {
        return missing_.get(index);
      } else {
        return missingBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
     * in this field is undefined and has no relation to the order of the keys
     * in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
     */
    public Builder setMissing(int index, com.google.datastore.v1.EntityResult value) {
      if (missingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMissingIsMutable();
        missing_.set(index, value);
        onChanged();
      } else {
        missingBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
     * in this field is undefined and has no relation to the order of the keys
     * in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
     */
    public Builder setMissing(
        int index, com.google.datastore.v1.EntityResult.Builder builderForValue) {
      if (missingBuilder_ == null) {
        ensureMissingIsMutable();
        missing_.set(index, builderForValue.build());
        onChanged();
      } else {
        missingBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
     * in this field is undefined and has no relation to the order of the keys
     * in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
     */
    public Builder addMissing(com.google.datastore.v1.EntityResult value) {
      if (missingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMissingIsMutable();
        missing_.add(value);
        onChanged();
      } else {
        missingBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
     * in this field is undefined and has no relation to the order of the keys
     * in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
     */
    public Builder addMissing(int index, com.google.datastore.v1.EntityResult value) {
      if (missingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMissingIsMutable();
        missing_.add(index, value);
        onChanged();
      } else {
        missingBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
     * in this field is undefined and has no relation to the order of the keys
     * in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
     */
    public Builder addMissing(com.google.datastore.v1.EntityResult.Builder builderForValue) {
      if (missingBuilder_ == null) {
        ensureMissingIsMutable();
        missing_.add(builderForValue.build());
        onChanged();
      } else {
        missingBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
     * in this field is undefined and has no relation to the order of the keys
     * in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
     */
    public Builder addMissing(
        int index, com.google.datastore.v1.EntityResult.Builder builderForValue) {
      if (missingBuilder_ == null) {
        ensureMissingIsMutable();
        missing_.add(index, builderForValue.build());
        onChanged();
      } else {
        missingBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
     * in this field is undefined and has no relation to the order of the keys
     * in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
     */
    public Builder addAllMissing(
        java.lang.Iterable<? extends com.google.datastore.v1.EntityResult> values) {
      if (missingBuilder_ == null) {
        ensureMissingIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, missing_);
        onChanged();
      } else {
        missingBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
     * in this field is undefined and has no relation to the order of the keys
     * in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
     */
    public Builder clearMissing() {
      if (missingBuilder_ == null) {
        missing_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        missingBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
     * in this field is undefined and has no relation to the order of the keys
     * in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
     */
    public Builder removeMissing(int index) {
      if (missingBuilder_ == null) {
        ensureMissingIsMutable();
        missing_.remove(index);
        onChanged();
      } else {
        missingBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
     * in this field is undefined and has no relation to the order of the keys
     * in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
     */
    public com.google.datastore.v1.EntityResult.Builder getMissingBuilder(int index) {
      return getMissingFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
     * in this field is undefined and has no relation to the order of the keys
     * in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
     */
    public com.google.datastore.v1.EntityResultOrBuilder getMissingOrBuilder(int index) {
      if (missingBuilder_ == null) {
        return missing_.get(index);
      } else {
        return missingBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
     * in this field is undefined and has no relation to the order of the keys
     * in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
     */
    public java.util.List<? extends com.google.datastore.v1.EntityResultOrBuilder>
        getMissingOrBuilderList() {
      if (missingBuilder_ != null) {
        return missingBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(missing_);
      }
    }

    /**
     *
     *
     * <pre>
     * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
     * in this field is undefined and has no relation to the order of the keys
     * in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
     */
    public com.google.datastore.v1.EntityResult.Builder addMissingBuilder() {
      return getMissingFieldBuilder()
          .addBuilder(com.google.datastore.v1.EntityResult.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
     * in this field is undefined and has no relation to the order of the keys
     * in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
     */
    public com.google.datastore.v1.EntityResult.Builder addMissingBuilder(int index) {
      return getMissingFieldBuilder()
          .addBuilder(index, com.google.datastore.v1.EntityResult.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Entities not found as `ResultType.KEY_ONLY` entities. The order of results
     * in this field is undefined and has no relation to the order of the keys
     * in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult missing = 2;</code>
     */
    public java.util.List<com.google.datastore.v1.EntityResult.Builder> getMissingBuilderList() {
      return getMissingFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.EntityResult,
            com.google.datastore.v1.EntityResult.Builder,
            com.google.datastore.v1.EntityResultOrBuilder>
        getMissingFieldBuilder() {
      if (missingBuilder_ == null) {
        missingBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.datastore.v1.EntityResult,
                com.google.datastore.v1.EntityResult.Builder,
                com.google.datastore.v1.EntityResultOrBuilder>(
                missing_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        missing_ = null;
      }
      return missingBuilder_;
    }

    private java.util.List<com.google.datastore.v1.Key> deferred_ =
        java.util.Collections.emptyList();

    private void ensureDeferredIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        deferred_ = new java.util.ArrayList<com.google.datastore.v1.Key>(deferred_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.Key,
            com.google.datastore.v1.Key.Builder,
            com.google.datastore.v1.KeyOrBuilder>
        deferredBuilder_;

    /**
     *
     *
     * <pre>
     * A list of keys that were not looked up due to resource constraints. The
     * order of results in this field is undefined and has no relation to the
     * order of the keys in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
     */
    public java.util.List<com.google.datastore.v1.Key> getDeferredList() {
      if (deferredBuilder_ == null) {
        return java.util.Collections.unmodifiableList(deferred_);
      } else {
        return deferredBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of keys that were not looked up due to resource constraints. The
     * order of results in this field is undefined and has no relation to the
     * order of the keys in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
     */
    public int getDeferredCount() {
      if (deferredBuilder_ == null) {
        return deferred_.size();
      } else {
        return deferredBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of keys that were not looked up due to resource constraints. The
     * order of results in this field is undefined and has no relation to the
     * order of the keys in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
     */
    public com.google.datastore.v1.Key getDeferred(int index) {
      if (deferredBuilder_ == null) {
        return deferred_.get(index);
      } else {
        return deferredBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of keys that were not looked up due to resource constraints. The
     * order of results in this field is undefined and has no relation to the
     * order of the keys in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
     */
    public Builder setDeferred(int index, com.google.datastore.v1.Key value) {
      if (deferredBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeferredIsMutable();
        deferred_.set(index, value);
        onChanged();
      } else {
        deferredBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of keys that were not looked up due to resource constraints. The
     * order of results in this field is undefined and has no relation to the
     * order of the keys in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
     */
    public Builder setDeferred(int index, com.google.datastore.v1.Key.Builder builderForValue) {
      if (deferredBuilder_ == null) {
        ensureDeferredIsMutable();
        deferred_.set(index, builderForValue.build());
        onChanged();
      } else {
        deferredBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of keys that were not looked up due to resource constraints. The
     * order of results in this field is undefined and has no relation to the
     * order of the keys in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
     */
    public Builder addDeferred(com.google.datastore.v1.Key value) {
      if (deferredBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeferredIsMutable();
        deferred_.add(value);
        onChanged();
      } else {
        deferredBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of keys that were not looked up due to resource constraints. The
     * order of results in this field is undefined and has no relation to the
     * order of the keys in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
     */
    public Builder addDeferred(int index, com.google.datastore.v1.Key value) {
      if (deferredBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDeferredIsMutable();
        deferred_.add(index, value);
        onChanged();
      } else {
        deferredBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of keys that were not looked up due to resource constraints. The
     * order of results in this field is undefined and has no relation to the
     * order of the keys in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
     */
    public Builder addDeferred(com.google.datastore.v1.Key.Builder builderForValue) {
      if (deferredBuilder_ == null) {
        ensureDeferredIsMutable();
        deferred_.add(builderForValue.build());
        onChanged();
      } else {
        deferredBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of keys that were not looked up due to resource constraints. The
     * order of results in this field is undefined and has no relation to the
     * order of the keys in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
     */
    public Builder addDeferred(int index, com.google.datastore.v1.Key.Builder builderForValue) {
      if (deferredBuilder_ == null) {
        ensureDeferredIsMutable();
        deferred_.add(index, builderForValue.build());
        onChanged();
      } else {
        deferredBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of keys that were not looked up due to resource constraints. The
     * order of results in this field is undefined and has no relation to the
     * order of the keys in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
     */
    public Builder addAllDeferred(
        java.lang.Iterable<? extends com.google.datastore.v1.Key> values) {
      if (deferredBuilder_ == null) {
        ensureDeferredIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, deferred_);
        onChanged();
      } else {
        deferredBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of keys that were not looked up due to resource constraints. The
     * order of results in this field is undefined and has no relation to the
     * order of the keys in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
     */
    public Builder clearDeferred() {
      if (deferredBuilder_ == null) {
        deferred_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        deferredBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of keys that were not looked up due to resource constraints. The
     * order of results in this field is undefined and has no relation to the
     * order of the keys in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
     */
    public Builder removeDeferred(int index) {
      if (deferredBuilder_ == null) {
        ensureDeferredIsMutable();
        deferred_.remove(index);
        onChanged();
      } else {
        deferredBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of keys that were not looked up due to resource constraints. The
     * order of results in this field is undefined and has no relation to the
     * order of the keys in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
     */
    public com.google.datastore.v1.Key.Builder getDeferredBuilder(int index) {
      return getDeferredFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A list of keys that were not looked up due to resource constraints. The
     * order of results in this field is undefined and has no relation to the
     * order of the keys in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
     */
    public com.google.datastore.v1.KeyOrBuilder getDeferredOrBuilder(int index) {
      if (deferredBuilder_ == null) {
        return deferred_.get(index);
      } else {
        return deferredBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of keys that were not looked up due to resource constraints. The
     * order of results in this field is undefined and has no relation to the
     * order of the keys in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
     */
    public java.util.List<? extends com.google.datastore.v1.KeyOrBuilder>
        getDeferredOrBuilderList() {
      if (deferredBuilder_ != null) {
        return deferredBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(deferred_);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of keys that were not looked up due to resource constraints. The
     * order of results in this field is undefined and has no relation to the
     * order of the keys in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
     */
    public com.google.datastore.v1.Key.Builder addDeferredBuilder() {
      return getDeferredFieldBuilder().addBuilder(com.google.datastore.v1.Key.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of keys that were not looked up due to resource constraints. The
     * order of results in this field is undefined and has no relation to the
     * order of the keys in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
     */
    public com.google.datastore.v1.Key.Builder addDeferredBuilder(int index) {
      return getDeferredFieldBuilder()
          .addBuilder(index, com.google.datastore.v1.Key.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of keys that were not looked up due to resource constraints. The
     * order of results in this field is undefined and has no relation to the
     * order of the keys in the input.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Key deferred = 3;</code>
     */
    public java.util.List<com.google.datastore.v1.Key.Builder> getDeferredBuilderList() {
      return getDeferredFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.Key,
            com.google.datastore.v1.Key.Builder,
            com.google.datastore.v1.KeyOrBuilder>
        getDeferredFieldBuilder() {
      if (deferredBuilder_ == null) {
        deferredBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.datastore.v1.Key,
                com.google.datastore.v1.Key.Builder,
                com.google.datastore.v1.KeyOrBuilder>(
                deferred_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        deferred_ = null;
      }
      return deferredBuilder_;
    }

    private com.google.protobuf.ByteString transaction_ = com.google.protobuf.ByteString.EMPTY;

    /**
     *
     *
     * <pre>
     * The identifier of the transaction that was started as part of this Lookup
     * request.
     *
     * Set only when
     * [ReadOptions.new_transaction][google.datastore.v1.ReadOptions.new_transaction]
     * was set in
     * [LookupRequest.read_options][google.datastore.v1.LookupRequest.read_options].
     * </pre>
     *
     * <code>bytes transaction = 5;</code>
     *
     * @return The transaction.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTransaction() {
      return transaction_;
    }

    /**
     *
     *
     * <pre>
     * The identifier of the transaction that was started as part of this Lookup
     * request.
     *
     * Set only when
     * [ReadOptions.new_transaction][google.datastore.v1.ReadOptions.new_transaction]
     * was set in
     * [LookupRequest.read_options][google.datastore.v1.LookupRequest.read_options].
     * </pre>
     *
     * <code>bytes transaction = 5;</code>
     *
     * @param value The transaction to set.
     * @return This builder for chaining.
     */
    public Builder setTransaction(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      transaction_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The identifier of the transaction that was started as part of this Lookup
     * request.
     *
     * Set only when
     * [ReadOptions.new_transaction][google.datastore.v1.ReadOptions.new_transaction]
     * was set in
     * [LookupRequest.read_options][google.datastore.v1.LookupRequest.read_options].
     * </pre>
     *
     * <code>bytes transaction = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransaction() {
      bitField0_ = (bitField0_ & ~0x00000008);
      transaction_ = getDefaultInstance().getTransaction();
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp readTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        readTimeBuilder_;

    /**
     *
     *
     * <pre>
     * The time at which these entities were read or found missing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     *
     * @return Whether the readTime field is set.
     */
    public boolean hasReadTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * The time at which these entities were read or found missing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     *
     * @return The readTime.
     */
    public com.google.protobuf.Timestamp getReadTime() {
      if (readTimeBuilder_ == null) {
        return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
      } else {
        return readTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The time at which these entities were read or found missing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readTime_ = value;
      } else {
        readTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time at which these entities were read or found missing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public Builder setReadTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (readTimeBuilder_ == null) {
        readTime_ = builderForValue.build();
      } else {
        readTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time at which these entities were read or found missing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public Builder mergeReadTime(com.google.protobuf.Timestamp value) {
      if (readTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && readTime_ != null
            && readTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getReadTimeBuilder().mergeFrom(value);
        } else {
          readTime_ = value;
        }
      } else {
        readTimeBuilder_.mergeFrom(value);
      }
      if (readTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time at which these entities were read or found missing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public Builder clearReadTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      readTime_ = null;
      if (readTimeBuilder_ != null) {
        readTimeBuilder_.dispose();
        readTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The time at which these entities were read or found missing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getReadTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getReadTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The time at which these entities were read or found missing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getReadTimeOrBuilder() {
      if (readTimeBuilder_ != null) {
        return readTimeBuilder_.getMessageOrBuilder();
      } else {
        return readTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : readTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * The time at which these entities were read or found missing.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp read_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getReadTimeFieldBuilder() {
      if (readTimeBuilder_ == null) {
        readTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getReadTime(), getParentForChildren(), isClean());
        readTime_ = null;
      }
      return readTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.datastore.v1.LookupResponse)
  }

  // @@protoc_insertion_point(class_scope:google.datastore.v1.LookupResponse)
  private static final com.google.datastore.v1.LookupResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.datastore.v1.LookupResponse();
  }

  public static com.google.datastore.v1.LookupResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LookupResponse> PARSER =
      new com.google.protobuf.AbstractParser<LookupResponse>() {
        @java.lang.Override
        public LookupResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LookupResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LookupResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.datastore.v1.LookupResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
