/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/v1/datastore.proto

// Protobuf Java Version: 3.25.5
package com.google.datastore.v1;

public interface PropertyTransformOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.datastore.v1.PropertyTransform)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Optional. The name of the property.
   *
   * Property paths (a list of property names separated by dots (`.`)) may be
   * used to refer to properties inside entity values. For example `foo.bar`
   * means the property `bar` inside the entity property `foo`.
   *
   * If a property name contains a dot `.` or a backlslash `&#92;`, then that name
   * must be escaped.
   * </pre>
   *
   * <code>string property = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The property.
   */
  java.lang.String getProperty();

  /**
   *
   *
   * <pre>
   * Optional. The name of the property.
   *
   * Property paths (a list of property names separated by dots (`.`)) may be
   * used to refer to properties inside entity values. For example `foo.bar`
   * means the property `bar` inside the entity property `foo`.
   *
   * If a property name contains a dot `.` or a backlslash `&#92;`, then that name
   * must be escaped.
   * </pre>
   *
   * <code>string property = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for property.
   */
  com.google.protobuf.ByteString getPropertyBytes();

  /**
   *
   *
   * <pre>
   * Sets the property to the given server value.
   * </pre>
   *
   * <code>.google.datastore.v1.PropertyTransform.ServerValue set_to_server_value = 2;</code>
   *
   * @return Whether the setToServerValue field is set.
   */
  boolean hasSetToServerValue();

  /**
   *
   *
   * <pre>
   * Sets the property to the given server value.
   * </pre>
   *
   * <code>.google.datastore.v1.PropertyTransform.ServerValue set_to_server_value = 2;</code>
   *
   * @return The enum numeric value on the wire for setToServerValue.
   */
  int getSetToServerValueValue();

  /**
   *
   *
   * <pre>
   * Sets the property to the given server value.
   * </pre>
   *
   * <code>.google.datastore.v1.PropertyTransform.ServerValue set_to_server_value = 2;</code>
   *
   * @return The setToServerValue.
   */
  com.google.datastore.v1.PropertyTransform.ServerValue getSetToServerValue();

  /**
   *
   *
   * <pre>
   * Adds the given value to the property's current value.
   *
   * This must be an integer or a double value.
   * If the property is not an integer or double, or if the property does not
   * yet exist, the transformation will set the property to the given value.
   * If either of the given value or the current property value are doubles,
   * both values will be interpreted as doubles. Double arithmetic and
   * representation of double values follows IEEE 754 semantics.
   * If there is positive/negative integer overflow, the property is resolved
   * to the largest magnitude positive/negative integer.
   * </pre>
   *
   * <code>.google.datastore.v1.Value increment = 3;</code>
   *
   * @return Whether the increment field is set.
   */
  boolean hasIncrement();

  /**
   *
   *
   * <pre>
   * Adds the given value to the property's current value.
   *
   * This must be an integer or a double value.
   * If the property is not an integer or double, or if the property does not
   * yet exist, the transformation will set the property to the given value.
   * If either of the given value or the current property value are doubles,
   * both values will be interpreted as doubles. Double arithmetic and
   * representation of double values follows IEEE 754 semantics.
   * If there is positive/negative integer overflow, the property is resolved
   * to the largest magnitude positive/negative integer.
   * </pre>
   *
   * <code>.google.datastore.v1.Value increment = 3;</code>
   *
   * @return The increment.
   */
  com.google.datastore.v1.Value getIncrement();

  /**
   *
   *
   * <pre>
   * Adds the given value to the property's current value.
   *
   * This must be an integer or a double value.
   * If the property is not an integer or double, or if the property does not
   * yet exist, the transformation will set the property to the given value.
   * If either of the given value or the current property value are doubles,
   * both values will be interpreted as doubles. Double arithmetic and
   * representation of double values follows IEEE 754 semantics.
   * If there is positive/negative integer overflow, the property is resolved
   * to the largest magnitude positive/negative integer.
   * </pre>
   *
   * <code>.google.datastore.v1.Value increment = 3;</code>
   */
  com.google.datastore.v1.ValueOrBuilder getIncrementOrBuilder();

  /**
   *
   *
   * <pre>
   * Sets the property to the maximum of its current value and the given
   * value.
   *
   * This must be an integer or a double value.
   * If the property is not an integer or double, or if the property does not
   * yet exist, the transformation will set the property to the given value.
   * If a maximum operation is applied where the property and the input value
   * are of mixed types (that is - one is an integer and one is a double)
   * the property takes on the type of the larger operand. If the operands are
   * equivalent (e.g. 3 and 3.0), the property does not change.
   * 0, 0.0, and -0.0 are all zero. The maximum of a zero stored value and
   * zero input value is always the stored value.
   * The maximum of any numeric value x and NaN is NaN.
   * </pre>
   *
   * <code>.google.datastore.v1.Value maximum = 4;</code>
   *
   * @return Whether the maximum field is set.
   */
  boolean hasMaximum();

  /**
   *
   *
   * <pre>
   * Sets the property to the maximum of its current value and the given
   * value.
   *
   * This must be an integer or a double value.
   * If the property is not an integer or double, or if the property does not
   * yet exist, the transformation will set the property to the given value.
   * If a maximum operation is applied where the property and the input value
   * are of mixed types (that is - one is an integer and one is a double)
   * the property takes on the type of the larger operand. If the operands are
   * equivalent (e.g. 3 and 3.0), the property does not change.
   * 0, 0.0, and -0.0 are all zero. The maximum of a zero stored value and
   * zero input value is always the stored value.
   * The maximum of any numeric value x and NaN is NaN.
   * </pre>
   *
   * <code>.google.datastore.v1.Value maximum = 4;</code>
   *
   * @return The maximum.
   */
  com.google.datastore.v1.Value getMaximum();

  /**
   *
   *
   * <pre>
   * Sets the property to the maximum of its current value and the given
   * value.
   *
   * This must be an integer or a double value.
   * If the property is not an integer or double, or if the property does not
   * yet exist, the transformation will set the property to the given value.
   * If a maximum operation is applied where the property and the input value
   * are of mixed types (that is - one is an integer and one is a double)
   * the property takes on the type of the larger operand. If the operands are
   * equivalent (e.g. 3 and 3.0), the property does not change.
   * 0, 0.0, and -0.0 are all zero. The maximum of a zero stored value and
   * zero input value is always the stored value.
   * The maximum of any numeric value x and NaN is NaN.
   * </pre>
   *
   * <code>.google.datastore.v1.Value maximum = 4;</code>
   */
  com.google.datastore.v1.ValueOrBuilder getMaximumOrBuilder();

  /**
   *
   *
   * <pre>
   * Sets the property to the minimum of its current value and the given
   * value.
   *
   * This must be an integer or a double value.
   * If the property is not an integer or double, or if the property does not
   * yet exist, the transformation will set the property to the input value.
   * If a minimum operation is applied where the property and the input value
   * are of mixed types (that is - one is an integer and one is a double)
   * the property takes on the type of the smaller operand. If the operands
   * are equivalent (e.g. 3 and 3.0), the property does not change. 0, 0.0,
   * and -0.0 are all zero. The minimum of a zero stored value and zero input
   * value is always the stored value. The minimum of any numeric value x and
   * NaN is NaN.
   * </pre>
   *
   * <code>.google.datastore.v1.Value minimum = 5;</code>
   *
   * @return Whether the minimum field is set.
   */
  boolean hasMinimum();

  /**
   *
   *
   * <pre>
   * Sets the property to the minimum of its current value and the given
   * value.
   *
   * This must be an integer or a double value.
   * If the property is not an integer or double, or if the property does not
   * yet exist, the transformation will set the property to the input value.
   * If a minimum operation is applied where the property and the input value
   * are of mixed types (that is - one is an integer and one is a double)
   * the property takes on the type of the smaller operand. If the operands
   * are equivalent (e.g. 3 and 3.0), the property does not change. 0, 0.0,
   * and -0.0 are all zero. The minimum of a zero stored value and zero input
   * value is always the stored value. The minimum of any numeric value x and
   * NaN is NaN.
   * </pre>
   *
   * <code>.google.datastore.v1.Value minimum = 5;</code>
   *
   * @return The minimum.
   */
  com.google.datastore.v1.Value getMinimum();

  /**
   *
   *
   * <pre>
   * Sets the property to the minimum of its current value and the given
   * value.
   *
   * This must be an integer or a double value.
   * If the property is not an integer or double, or if the property does not
   * yet exist, the transformation will set the property to the input value.
   * If a minimum operation is applied where the property and the input value
   * are of mixed types (that is - one is an integer and one is a double)
   * the property takes on the type of the smaller operand. If the operands
   * are equivalent (e.g. 3 and 3.0), the property does not change. 0, 0.0,
   * and -0.0 are all zero. The minimum of a zero stored value and zero input
   * value is always the stored value. The minimum of any numeric value x and
   * NaN is NaN.
   * </pre>
   *
   * <code>.google.datastore.v1.Value minimum = 5;</code>
   */
  com.google.datastore.v1.ValueOrBuilder getMinimumOrBuilder();

  /**
   *
   *
   * <pre>
   * Appends the given elements in order if they are not already present in
   * the current property value.
   * If the property is not an array, or if the property does not yet exist,
   * it is first set to the empty array.
   *
   * Equivalent numbers of different types (e.g. 3L and 3.0) are
   * considered equal when checking if a value is missing.
   * NaN is equal to NaN, and the null value is equal to the null value.
   * If the input contains multiple equivalent values, only the first will
   * be considered.
   *
   * The corresponding transform result will be the null value.
   * </pre>
   *
   * <code>.google.datastore.v1.ArrayValue append_missing_elements = 6;</code>
   *
   * @return Whether the appendMissingElements field is set.
   */
  boolean hasAppendMissingElements();

  /**
   *
   *
   * <pre>
   * Appends the given elements in order if they are not already present in
   * the current property value.
   * If the property is not an array, or if the property does not yet exist,
   * it is first set to the empty array.
   *
   * Equivalent numbers of different types (e.g. 3L and 3.0) are
   * considered equal when checking if a value is missing.
   * NaN is equal to NaN, and the null value is equal to the null value.
   * If the input contains multiple equivalent values, only the first will
   * be considered.
   *
   * The corresponding transform result will be the null value.
   * </pre>
   *
   * <code>.google.datastore.v1.ArrayValue append_missing_elements = 6;</code>
   *
   * @return The appendMissingElements.
   */
  com.google.datastore.v1.ArrayValue getAppendMissingElements();

  /**
   *
   *
   * <pre>
   * Appends the given elements in order if they are not already present in
   * the current property value.
   * If the property is not an array, or if the property does not yet exist,
   * it is first set to the empty array.
   *
   * Equivalent numbers of different types (e.g. 3L and 3.0) are
   * considered equal when checking if a value is missing.
   * NaN is equal to NaN, and the null value is equal to the null value.
   * If the input contains multiple equivalent values, only the first will
   * be considered.
   *
   * The corresponding transform result will be the null value.
   * </pre>
   *
   * <code>.google.datastore.v1.ArrayValue append_missing_elements = 6;</code>
   */
  com.google.datastore.v1.ArrayValueOrBuilder getAppendMissingElementsOrBuilder();

  /**
   *
   *
   * <pre>
   * Removes all of the given elements from the array in the property.
   * If the property is not an array, or if the property does not yet exist,
   * it is set to the empty array.
   *
   * Equivalent numbers of different types (e.g. 3L and 3.0) are
   * considered equal when deciding whether an element should be removed.
   * NaN is equal to NaN, and the null value is equal to the null value.
   * This will remove all equivalent values if there are duplicates.
   *
   * The corresponding transform result will be the null value.
   * </pre>
   *
   * <code>.google.datastore.v1.ArrayValue remove_all_from_array = 7;</code>
   *
   * @return Whether the removeAllFromArray field is set.
   */
  boolean hasRemoveAllFromArray();

  /**
   *
   *
   * <pre>
   * Removes all of the given elements from the array in the property.
   * If the property is not an array, or if the property does not yet exist,
   * it is set to the empty array.
   *
   * Equivalent numbers of different types (e.g. 3L and 3.0) are
   * considered equal when deciding whether an element should be removed.
   * NaN is equal to NaN, and the null value is equal to the null value.
   * This will remove all equivalent values if there are duplicates.
   *
   * The corresponding transform result will be the null value.
   * </pre>
   *
   * <code>.google.datastore.v1.ArrayValue remove_all_from_array = 7;</code>
   *
   * @return The removeAllFromArray.
   */
  com.google.datastore.v1.ArrayValue getRemoveAllFromArray();

  /**
   *
   *
   * <pre>
   * Removes all of the given elements from the array in the property.
   * If the property is not an array, or if the property does not yet exist,
   * it is set to the empty array.
   *
   * Equivalent numbers of different types (e.g. 3L and 3.0) are
   * considered equal when deciding whether an element should be removed.
   * NaN is equal to NaN, and the null value is equal to the null value.
   * This will remove all equivalent values if there are duplicates.
   *
   * The corresponding transform result will be the null value.
   * </pre>
   *
   * <code>.google.datastore.v1.ArrayValue remove_all_from_array = 7;</code>
   */
  com.google.datastore.v1.ArrayValueOrBuilder getRemoveAllFromArrayOrBuilder();

  com.google.datastore.v1.PropertyTransform.TransformTypeCase getTransformTypeCase();
}
