/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/v1/datastore.proto

// Protobuf Java Version: 3.25.5
package com.google.datastore.v1;

/**
 *
 *
 * <pre>
 * A mutation to apply to an entity.
 * </pre>
 *
 * Protobuf type {@code google.datastore.v1.Mutation}
 */
public final class Mutation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.datastore.v1.Mutation)
    MutationOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Mutation.newBuilder() to construct.
  private Mutation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Mutation() {
    conflictResolutionStrategy_ = 0;
    propertyTransforms_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Mutation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.datastore.v1.DatastoreProto
        .internal_static_google_datastore_v1_Mutation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.datastore.v1.DatastoreProto
        .internal_static_google_datastore_v1_Mutation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.datastore.v1.Mutation.class, com.google.datastore.v1.Mutation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The possible ways to resolve a conflict detected in a mutation.
   * </pre>
   *
   * Protobuf enum {@code google.datastore.v1.Mutation.ConflictResolutionStrategy}
   */
  public enum ConflictResolutionStrategy implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified. Defaults to `SERVER_VALUE`.
     * </pre>
     *
     * <code>STRATEGY_UNSPECIFIED = 0;</code>
     */
    STRATEGY_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The server entity is kept.
     * </pre>
     *
     * <code>SERVER_VALUE = 1;</code>
     */
    SERVER_VALUE(1),
    /**
     *
     *
     * <pre>
     * The whole commit request fails.
     * </pre>
     *
     * <code>FAIL = 3;</code>
     */
    FAIL(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified. Defaults to `SERVER_VALUE`.
     * </pre>
     *
     * <code>STRATEGY_UNSPECIFIED = 0;</code>
     */
    public static final int STRATEGY_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The server entity is kept.
     * </pre>
     *
     * <code>SERVER_VALUE = 1;</code>
     */
    public static final int SERVER_VALUE_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The whole commit request fails.
     * </pre>
     *
     * <code>FAIL = 3;</code>
     */
    public static final int FAIL_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConflictResolutionStrategy valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ConflictResolutionStrategy forNumber(int value) {
      switch (value) {
        case 0:
          return STRATEGY_UNSPECIFIED;
        case 1:
          return SERVER_VALUE;
        case 3:
          return FAIL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ConflictResolutionStrategy>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ConflictResolutionStrategy>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ConflictResolutionStrategy>() {
              public ConflictResolutionStrategy findValueByNumber(int number) {
                return ConflictResolutionStrategy.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.datastore.v1.Mutation.getDescriptor().getEnumTypes().get(0);
    }

    private static final ConflictResolutionStrategy[] VALUES = values();

    public static ConflictResolutionStrategy valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ConflictResolutionStrategy(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.datastore.v1.Mutation.ConflictResolutionStrategy)
  }

  private int bitField0_;
  private int operationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object operation_;

  public enum OperationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INSERT(4),
    UPDATE(5),
    UPSERT(6),
    DELETE(7),
    OPERATION_NOT_SET(0);
    private final int value;

    private OperationCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OperationCase valueOf(int value) {
      return forNumber(value);
    }

    public static OperationCase forNumber(int value) {
      switch (value) {
        case 4:
          return INSERT;
        case 5:
          return UPDATE;
        case 6:
          return UPSERT;
        case 7:
          return DELETE;
        case 0:
          return OPERATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public OperationCase getOperationCase() {
    return OperationCase.forNumber(operationCase_);
  }

  private int conflictDetectionStrategyCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object conflictDetectionStrategy_;

  public enum ConflictDetectionStrategyCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BASE_VERSION(8),
    UPDATE_TIME(11),
    CONFLICTDETECTIONSTRATEGY_NOT_SET(0);
    private final int value;

    private ConflictDetectionStrategyCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConflictDetectionStrategyCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConflictDetectionStrategyCase forNumber(int value) {
      switch (value) {
        case 8:
          return BASE_VERSION;
        case 11:
          return UPDATE_TIME;
        case 0:
          return CONFLICTDETECTIONSTRATEGY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConflictDetectionStrategyCase getConflictDetectionStrategyCase() {
    return ConflictDetectionStrategyCase.forNumber(conflictDetectionStrategyCase_);
  }

  public static final int INSERT_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * The entity to insert. The entity must not already exist.
   * The entity key's final path element may be incomplete.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity insert = 4;</code>
   *
   * @return Whether the insert field is set.
   */
  @java.lang.Override
  public boolean hasInsert() {
    return operationCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * The entity to insert. The entity must not already exist.
   * The entity key's final path element may be incomplete.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity insert = 4;</code>
   *
   * @return The insert.
   */
  @java.lang.Override
  public com.google.datastore.v1.Entity getInsert() {
    if (operationCase_ == 4) {
      return (com.google.datastore.v1.Entity) operation_;
    }
    return com.google.datastore.v1.Entity.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The entity to insert. The entity must not already exist.
   * The entity key's final path element may be incomplete.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity insert = 4;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.EntityOrBuilder getInsertOrBuilder() {
    if (operationCase_ == 4) {
      return (com.google.datastore.v1.Entity) operation_;
    }
    return com.google.datastore.v1.Entity.getDefaultInstance();
  }

  public static final int UPDATE_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * The entity to update. The entity must already exist.
   * Must have a complete key path.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity update = 5;</code>
   *
   * @return Whether the update field is set.
   */
  @java.lang.Override
  public boolean hasUpdate() {
    return operationCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * The entity to update. The entity must already exist.
   * Must have a complete key path.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity update = 5;</code>
   *
   * @return The update.
   */
  @java.lang.Override
  public com.google.datastore.v1.Entity getUpdate() {
    if (operationCase_ == 5) {
      return (com.google.datastore.v1.Entity) operation_;
    }
    return com.google.datastore.v1.Entity.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The entity to update. The entity must already exist.
   * Must have a complete key path.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity update = 5;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.EntityOrBuilder getUpdateOrBuilder() {
    if (operationCase_ == 5) {
      return (com.google.datastore.v1.Entity) operation_;
    }
    return com.google.datastore.v1.Entity.getDefaultInstance();
  }

  public static final int UPSERT_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * The entity to upsert. The entity may or may not already exist.
   * The entity key's final path element may be incomplete.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity upsert = 6;</code>
   *
   * @return Whether the upsert field is set.
   */
  @java.lang.Override
  public boolean hasUpsert() {
    return operationCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * The entity to upsert. The entity may or may not already exist.
   * The entity key's final path element may be incomplete.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity upsert = 6;</code>
   *
   * @return The upsert.
   */
  @java.lang.Override
  public com.google.datastore.v1.Entity getUpsert() {
    if (operationCase_ == 6) {
      return (com.google.datastore.v1.Entity) operation_;
    }
    return com.google.datastore.v1.Entity.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The entity to upsert. The entity may or may not already exist.
   * The entity key's final path element may be incomplete.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity upsert = 6;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.EntityOrBuilder getUpsertOrBuilder() {
    if (operationCase_ == 6) {
      return (com.google.datastore.v1.Entity) operation_;
    }
    return com.google.datastore.v1.Entity.getDefaultInstance();
  }

  public static final int DELETE_FIELD_NUMBER = 7;

  /**
   *
   *
   * <pre>
   * The key of the entity to delete. The entity may or may not already exist.
   * Must have a complete key path and must not be reserved/read-only.
   * </pre>
   *
   * <code>.google.datastore.v1.Key delete = 7;</code>
   *
   * @return Whether the delete field is set.
   */
  @java.lang.Override
  public boolean hasDelete() {
    return operationCase_ == 7;
  }

  /**
   *
   *
   * <pre>
   * The key of the entity to delete. The entity may or may not already exist.
   * Must have a complete key path and must not be reserved/read-only.
   * </pre>
   *
   * <code>.google.datastore.v1.Key delete = 7;</code>
   *
   * @return The delete.
   */
  @java.lang.Override
  public com.google.datastore.v1.Key getDelete() {
    if (operationCase_ == 7) {
      return (com.google.datastore.v1.Key) operation_;
    }
    return com.google.datastore.v1.Key.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The key of the entity to delete. The entity may or may not already exist.
   * Must have a complete key path and must not be reserved/read-only.
   * </pre>
   *
   * <code>.google.datastore.v1.Key delete = 7;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.KeyOrBuilder getDeleteOrBuilder() {
    if (operationCase_ == 7) {
      return (com.google.datastore.v1.Key) operation_;
    }
    return com.google.datastore.v1.Key.getDefaultInstance();
  }

  public static final int BASE_VERSION_FIELD_NUMBER = 8;

  /**
   *
   *
   * <pre>
   * The version of the entity that this mutation is being applied
   * to. If this does not match the current version on the server, the
   * mutation conflicts.
   * </pre>
   *
   * <code>int64 base_version = 8;</code>
   *
   * @return Whether the baseVersion field is set.
   */
  @java.lang.Override
  public boolean hasBaseVersion() {
    return conflictDetectionStrategyCase_ == 8;
  }

  /**
   *
   *
   * <pre>
   * The version of the entity that this mutation is being applied
   * to. If this does not match the current version on the server, the
   * mutation conflicts.
   * </pre>
   *
   * <code>int64 base_version = 8;</code>
   *
   * @return The baseVersion.
   */
  @java.lang.Override
  public long getBaseVersion() {
    if (conflictDetectionStrategyCase_ == 8) {
      return (java.lang.Long) conflictDetectionStrategy_;
    }
    return 0L;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 11;

  /**
   *
   *
   * <pre>
   * The update time of the entity that this mutation is being applied
   * to. If this does not match the current update time on the server, the
   * mutation conflicts.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11;</code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return conflictDetectionStrategyCase_ == 11;
  }

  /**
   *
   *
   * <pre>
   * The update time of the entity that this mutation is being applied
   * to. If this does not match the current update time on the server, the
   * mutation conflicts.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11;</code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    if (conflictDetectionStrategyCase_ == 11) {
      return (com.google.protobuf.Timestamp) conflictDetectionStrategy_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The update time of the entity that this mutation is being applied
   * to. If this does not match the current update time on the server, the
   * mutation conflicts.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 11;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    if (conflictDetectionStrategyCase_ == 11) {
      return (com.google.protobuf.Timestamp) conflictDetectionStrategy_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  public static final int CONFLICT_RESOLUTION_STRATEGY_FIELD_NUMBER = 10;
  private int conflictResolutionStrategy_ = 0;

  /**
   *
   *
   * <pre>
   * The strategy to use when a conflict is detected. Defaults to
   * `SERVER_VALUE`.
   * If this is set, then `conflict_detection_strategy` must also be set.
   * </pre>
   *
   * <code>
   * .google.datastore.v1.Mutation.ConflictResolutionStrategy conflict_resolution_strategy = 10;
   * </code>
   *
   * @return The enum numeric value on the wire for conflictResolutionStrategy.
   */
  @java.lang.Override
  public int getConflictResolutionStrategyValue() {
    return conflictResolutionStrategy_;
  }

  /**
   *
   *
   * <pre>
   * The strategy to use when a conflict is detected. Defaults to
   * `SERVER_VALUE`.
   * If this is set, then `conflict_detection_strategy` must also be set.
   * </pre>
   *
   * <code>
   * .google.datastore.v1.Mutation.ConflictResolutionStrategy conflict_resolution_strategy = 10;
   * </code>
   *
   * @return The conflictResolutionStrategy.
   */
  @java.lang.Override
  public com.google.datastore.v1.Mutation.ConflictResolutionStrategy
      getConflictResolutionStrategy() {
    com.google.datastore.v1.Mutation.ConflictResolutionStrategy result =
        com.google.datastore.v1.Mutation.ConflictResolutionStrategy.forNumber(
            conflictResolutionStrategy_);
    return result == null
        ? com.google.datastore.v1.Mutation.ConflictResolutionStrategy.UNRECOGNIZED
        : result;
  }

  public static final int PROPERTY_MASK_FIELD_NUMBER = 9;
  private com.google.datastore.v1.PropertyMask propertyMask_;

  /**
   *
   *
   * <pre>
   * The properties to write in this mutation.
   * None of the properties in the mask may have a reserved name, except for
   * `__key__`.
   * This field is ignored for `delete`.
   *
   * If the entity already exists, only properties referenced in the mask are
   * updated, others are left untouched.
   * Properties referenced in the mask but not in the entity are deleted.
   * </pre>
   *
   * <code>.google.datastore.v1.PropertyMask property_mask = 9;</code>
   *
   * @return Whether the propertyMask field is set.
   */
  @java.lang.Override
  public boolean hasPropertyMask() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The properties to write in this mutation.
   * None of the properties in the mask may have a reserved name, except for
   * `__key__`.
   * This field is ignored for `delete`.
   *
   * If the entity already exists, only properties referenced in the mask are
   * updated, others are left untouched.
   * Properties referenced in the mask but not in the entity are deleted.
   * </pre>
   *
   * <code>.google.datastore.v1.PropertyMask property_mask = 9;</code>
   *
   * @return The propertyMask.
   */
  @java.lang.Override
  public com.google.datastore.v1.PropertyMask getPropertyMask() {
    return propertyMask_ == null
        ? com.google.datastore.v1.PropertyMask.getDefaultInstance()
        : propertyMask_;
  }

  /**
   *
   *
   * <pre>
   * The properties to write in this mutation.
   * None of the properties in the mask may have a reserved name, except for
   * `__key__`.
   * This field is ignored for `delete`.
   *
   * If the entity already exists, only properties referenced in the mask are
   * updated, others are left untouched.
   * Properties referenced in the mask but not in the entity are deleted.
   * </pre>
   *
   * <code>.google.datastore.v1.PropertyMask property_mask = 9;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.PropertyMaskOrBuilder getPropertyMaskOrBuilder() {
    return propertyMask_ == null
        ? com.google.datastore.v1.PropertyMask.getDefaultInstance()
        : propertyMask_;
  }

  public static final int PROPERTY_TRANSFORMS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private java.util.List<com.google.datastore.v1.PropertyTransform> propertyTransforms_;

  /**
   *
   *
   * <pre>
   * Optional. The transforms to perform on the entity.
   *
   * This field can be set only when the operation is `insert`, `update`,
   * or `upsert`. If present, the transforms are be applied to the entity
   * regardless of the property mask, in order, after the operation.
   * </pre>
   *
   * <code>
   * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.datastore.v1.PropertyTransform> getPropertyTransformsList() {
    return propertyTransforms_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The transforms to perform on the entity.
   *
   * This field can be set only when the operation is `insert`, `update`,
   * or `upsert`. If present, the transforms are be applied to the entity
   * regardless of the property mask, in order, after the operation.
   * </pre>
   *
   * <code>
   * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.datastore.v1.PropertyTransformOrBuilder>
      getPropertyTransformsOrBuilderList() {
    return propertyTransforms_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The transforms to perform on the entity.
   *
   * This field can be set only when the operation is `insert`, `update`,
   * or `upsert`. If present, the transforms are be applied to the entity
   * regardless of the property mask, in order, after the operation.
   * </pre>
   *
   * <code>
   * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getPropertyTransformsCount() {
    return propertyTransforms_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. The transforms to perform on the entity.
   *
   * This field can be set only when the operation is `insert`, `update`,
   * or `upsert`. If present, the transforms are be applied to the entity
   * regardless of the property mask, in order, after the operation.
   * </pre>
   *
   * <code>
   * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.datastore.v1.PropertyTransform getPropertyTransforms(int index) {
    return propertyTransforms_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. The transforms to perform on the entity.
   *
   * This field can be set only when the operation is `insert`, `update`,
   * or `upsert`. If present, the transforms are be applied to the entity
   * regardless of the property mask, in order, after the operation.
   * </pre>
   *
   * <code>
   * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.datastore.v1.PropertyTransformOrBuilder getPropertyTransformsOrBuilder(
      int index) {
    return propertyTransforms_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (operationCase_ == 4) {
      output.writeMessage(4, (com.google.datastore.v1.Entity) operation_);
    }
    if (operationCase_ == 5) {
      output.writeMessage(5, (com.google.datastore.v1.Entity) operation_);
    }
    if (operationCase_ == 6) {
      output.writeMessage(6, (com.google.datastore.v1.Entity) operation_);
    }
    if (operationCase_ == 7) {
      output.writeMessage(7, (com.google.datastore.v1.Key) operation_);
    }
    if (conflictDetectionStrategyCase_ == 8) {
      output.writeInt64(8, (long) ((java.lang.Long) conflictDetectionStrategy_));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(9, getPropertyMask());
    }
    if (conflictResolutionStrategy_
        != com.google.datastore.v1.Mutation.ConflictResolutionStrategy.STRATEGY_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(10, conflictResolutionStrategy_);
    }
    if (conflictDetectionStrategyCase_ == 11) {
      output.writeMessage(11, (com.google.protobuf.Timestamp) conflictDetectionStrategy_);
    }
    for (int i = 0; i < propertyTransforms_.size(); i++) {
      output.writeMessage(12, propertyTransforms_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (operationCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.datastore.v1.Entity) operation_);
    }
    if (operationCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.datastore.v1.Entity) operation_);
    }
    if (operationCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.datastore.v1.Entity) operation_);
    }
    if (operationCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.datastore.v1.Key) operation_);
    }
    if (conflictDetectionStrategyCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              8, (long) ((java.lang.Long) conflictDetectionStrategy_));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getPropertyMask());
    }
    if (conflictResolutionStrategy_
        != com.google.datastore.v1.Mutation.ConflictResolutionStrategy.STRATEGY_UNSPECIFIED
            .getNumber()) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(10, conflictResolutionStrategy_);
    }
    if (conflictDetectionStrategyCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.protobuf.Timestamp) conflictDetectionStrategy_);
    }
    for (int i = 0; i < propertyTransforms_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(12, propertyTransforms_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.datastore.v1.Mutation)) {
      return super.equals(obj);
    }
    com.google.datastore.v1.Mutation other = (com.google.datastore.v1.Mutation) obj;

    if (conflictResolutionStrategy_ != other.conflictResolutionStrategy_) return false;
    if (hasPropertyMask() != other.hasPropertyMask()) return false;
    if (hasPropertyMask()) {
      if (!getPropertyMask().equals(other.getPropertyMask())) return false;
    }
    if (!getPropertyTransformsList().equals(other.getPropertyTransformsList())) return false;
    if (!getOperationCase().equals(other.getOperationCase())) return false;
    switch (operationCase_) {
      case 4:
        if (!getInsert().equals(other.getInsert())) return false;
        break;
      case 5:
        if (!getUpdate().equals(other.getUpdate())) return false;
        break;
      case 6:
        if (!getUpsert().equals(other.getUpsert())) return false;
        break;
      case 7:
        if (!getDelete().equals(other.getDelete())) return false;
        break;
      case 0:
      default:
    }
    if (!getConflictDetectionStrategyCase().equals(other.getConflictDetectionStrategyCase()))
      return false;
    switch (conflictDetectionStrategyCase_) {
      case 8:
        if (getBaseVersion() != other.getBaseVersion()) return false;
        break;
      case 11:
        if (!getUpdateTime().equals(other.getUpdateTime())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CONFLICT_RESOLUTION_STRATEGY_FIELD_NUMBER;
    hash = (53 * hash) + conflictResolutionStrategy_;
    if (hasPropertyMask()) {
      hash = (37 * hash) + PROPERTY_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getPropertyMask().hashCode();
    }
    if (getPropertyTransformsCount() > 0) {
      hash = (37 * hash) + PROPERTY_TRANSFORMS_FIELD_NUMBER;
      hash = (53 * hash) + getPropertyTransformsList().hashCode();
    }
    switch (operationCase_) {
      case 4:
        hash = (37 * hash) + INSERT_FIELD_NUMBER;
        hash = (53 * hash) + getInsert().hashCode();
        break;
      case 5:
        hash = (37 * hash) + UPDATE_FIELD_NUMBER;
        hash = (53 * hash) + getUpdate().hashCode();
        break;
      case 6:
        hash = (37 * hash) + UPSERT_FIELD_NUMBER;
        hash = (53 * hash) + getUpsert().hashCode();
        break;
      case 7:
        hash = (37 * hash) + DELETE_FIELD_NUMBER;
        hash = (53 * hash) + getDelete().hashCode();
        break;
      case 0:
      default:
    }
    switch (conflictDetectionStrategyCase_) {
      case 8:
        hash = (37 * hash) + BASE_VERSION_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getBaseVersion());
        break;
      case 11:
        hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateTime().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.datastore.v1.Mutation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.Mutation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.Mutation parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.Mutation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.Mutation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.Mutation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.Mutation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.Mutation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.Mutation parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.Mutation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.Mutation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.Mutation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.datastore.v1.Mutation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A mutation to apply to an entity.
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.Mutation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.datastore.v1.Mutation)
      com.google.datastore.v1.MutationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_Mutation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_Mutation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.Mutation.class,
              com.google.datastore.v1.Mutation.Builder.class);
    }

    // Construct using com.google.datastore.v1.Mutation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPropertyMaskFieldBuilder();
        getPropertyTransformsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (insertBuilder_ != null) {
        insertBuilder_.clear();
      }
      if (updateBuilder_ != null) {
        updateBuilder_.clear();
      }
      if (upsertBuilder_ != null) {
        upsertBuilder_.clear();
      }
      if (deleteBuilder_ != null) {
        deleteBuilder_.clear();
      }
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.clear();
      }
      conflictResolutionStrategy_ = 0;
      propertyMask_ = null;
      if (propertyMaskBuilder_ != null) {
        propertyMaskBuilder_.dispose();
        propertyMaskBuilder_ = null;
      }
      if (propertyTransformsBuilder_ == null) {
        propertyTransforms_ = java.util.Collections.emptyList();
      } else {
        propertyTransforms_ = null;
        propertyTransformsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      operationCase_ = 0;
      operation_ = null;
      conflictDetectionStrategyCase_ = 0;
      conflictDetectionStrategy_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_Mutation_descriptor;
    }

    @java.lang.Override
    public com.google.datastore.v1.Mutation getDefaultInstanceForType() {
      return com.google.datastore.v1.Mutation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.datastore.v1.Mutation build() {
      com.google.datastore.v1.Mutation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.datastore.v1.Mutation buildPartial() {
      com.google.datastore.v1.Mutation result = new com.google.datastore.v1.Mutation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.datastore.v1.Mutation result) {
      if (propertyTransformsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          propertyTransforms_ = java.util.Collections.unmodifiableList(propertyTransforms_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.propertyTransforms_ = propertyTransforms_;
      } else {
        result.propertyTransforms_ = propertyTransformsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.datastore.v1.Mutation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.conflictResolutionStrategy_ = conflictResolutionStrategy_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.propertyMask_ =
            propertyMaskBuilder_ == null ? propertyMask_ : propertyMaskBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.datastore.v1.Mutation result) {
      result.operationCase_ = operationCase_;
      result.operation_ = this.operation_;
      if (operationCase_ == 4 && insertBuilder_ != null) {
        result.operation_ = insertBuilder_.build();
      }
      if (operationCase_ == 5 && updateBuilder_ != null) {
        result.operation_ = updateBuilder_.build();
      }
      if (operationCase_ == 6 && upsertBuilder_ != null) {
        result.operation_ = upsertBuilder_.build();
      }
      if (operationCase_ == 7 && deleteBuilder_ != null) {
        result.operation_ = deleteBuilder_.build();
      }
      result.conflictDetectionStrategyCase_ = conflictDetectionStrategyCase_;
      result.conflictDetectionStrategy_ = this.conflictDetectionStrategy_;
      if (conflictDetectionStrategyCase_ == 11 && updateTimeBuilder_ != null) {
        result.conflictDetectionStrategy_ = updateTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.datastore.v1.Mutation) {
        return mergeFrom((com.google.datastore.v1.Mutation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.datastore.v1.Mutation other) {
      if (other == com.google.datastore.v1.Mutation.getDefaultInstance()) return this;
      if (other.conflictResolutionStrategy_ != 0) {
        setConflictResolutionStrategyValue(other.getConflictResolutionStrategyValue());
      }
      if (other.hasPropertyMask()) {
        mergePropertyMask(other.getPropertyMask());
      }
      if (propertyTransformsBuilder_ == null) {
        if (!other.propertyTransforms_.isEmpty()) {
          if (propertyTransforms_.isEmpty()) {
            propertyTransforms_ = other.propertyTransforms_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensurePropertyTransformsIsMutable();
            propertyTransforms_.addAll(other.propertyTransforms_);
          }
          onChanged();
        }
      } else {
        if (!other.propertyTransforms_.isEmpty()) {
          if (propertyTransformsBuilder_.isEmpty()) {
            propertyTransformsBuilder_.dispose();
            propertyTransformsBuilder_ = null;
            propertyTransforms_ = other.propertyTransforms_;
            bitField0_ = (bitField0_ & ~0x00000100);
            propertyTransformsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPropertyTransformsFieldBuilder()
                    : null;
          } else {
            propertyTransformsBuilder_.addAllMessages(other.propertyTransforms_);
          }
        }
      }
      switch (other.getOperationCase()) {
        case INSERT:
          {
            mergeInsert(other.getInsert());
            break;
          }
        case UPDATE:
          {
            mergeUpdate(other.getUpdate());
            break;
          }
        case UPSERT:
          {
            mergeUpsert(other.getUpsert());
            break;
          }
        case DELETE:
          {
            mergeDelete(other.getDelete());
            break;
          }
        case OPERATION_NOT_SET:
          {
            break;
          }
      }
      switch (other.getConflictDetectionStrategyCase()) {
        case BASE_VERSION:
          {
            setBaseVersion(other.getBaseVersion());
            break;
          }
        case UPDATE_TIME:
          {
            mergeUpdateTime(other.getUpdateTime());
            break;
          }
        case CONFLICTDETECTIONSTRATEGY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 34:
              {
                input.readMessage(getInsertFieldBuilder().getBuilder(), extensionRegistry);
                operationCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getUpdateFieldBuilder().getBuilder(), extensionRegistry);
                operationCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getUpsertFieldBuilder().getBuilder(), extensionRegistry);
                operationCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getDeleteFieldBuilder().getBuilder(), extensionRegistry);
                operationCase_ = 7;
                break;
              } // case 58
            case 64:
              {
                conflictDetectionStrategy_ = input.readInt64();
                conflictDetectionStrategyCase_ = 8;
                break;
              } // case 64
            case 74:
              {
                input.readMessage(getPropertyMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 80:
              {
                conflictResolutionStrategy_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 80
            case 90:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                conflictDetectionStrategyCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                com.google.datastore.v1.PropertyTransform m =
                    input.readMessage(
                        com.google.datastore.v1.PropertyTransform.parser(), extensionRegistry);
                if (propertyTransformsBuilder_ == null) {
                  ensurePropertyTransformsIsMutable();
                  propertyTransforms_.add(m);
                } else {
                  propertyTransformsBuilder_.addMessage(m);
                }
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int operationCase_ = 0;
    private java.lang.Object operation_;

    public OperationCase getOperationCase() {
      return OperationCase.forNumber(operationCase_);
    }

    public Builder clearOperation() {
      operationCase_ = 0;
      operation_ = null;
      onChanged();
      return this;
    }

    private int conflictDetectionStrategyCase_ = 0;
    private java.lang.Object conflictDetectionStrategy_;

    public ConflictDetectionStrategyCase getConflictDetectionStrategyCase() {
      return ConflictDetectionStrategyCase.forNumber(conflictDetectionStrategyCase_);
    }

    public Builder clearConflictDetectionStrategy() {
      conflictDetectionStrategyCase_ = 0;
      conflictDetectionStrategy_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Entity,
            com.google.datastore.v1.Entity.Builder,
            com.google.datastore.v1.EntityOrBuilder>
        insertBuilder_;

    /**
     *
     *
     * <pre>
     * The entity to insert. The entity must not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity insert = 4;</code>
     *
     * @return Whether the insert field is set.
     */
    @java.lang.Override
    public boolean hasInsert() {
      return operationCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * The entity to insert. The entity must not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity insert = 4;</code>
     *
     * @return The insert.
     */
    @java.lang.Override
    public com.google.datastore.v1.Entity getInsert() {
      if (insertBuilder_ == null) {
        if (operationCase_ == 4) {
          return (com.google.datastore.v1.Entity) operation_;
        }
        return com.google.datastore.v1.Entity.getDefaultInstance();
      } else {
        if (operationCase_ == 4) {
          return insertBuilder_.getMessage();
        }
        return com.google.datastore.v1.Entity.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The entity to insert. The entity must not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity insert = 4;</code>
     */
    public Builder setInsert(com.google.datastore.v1.Entity value) {
      if (insertBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
        onChanged();
      } else {
        insertBuilder_.setMessage(value);
      }
      operationCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The entity to insert. The entity must not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity insert = 4;</code>
     */
    public Builder setInsert(com.google.datastore.v1.Entity.Builder builderForValue) {
      if (insertBuilder_ == null) {
        operation_ = builderForValue.build();
        onChanged();
      } else {
        insertBuilder_.setMessage(builderForValue.build());
      }
      operationCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The entity to insert. The entity must not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity insert = 4;</code>
     */
    public Builder mergeInsert(com.google.datastore.v1.Entity value) {
      if (insertBuilder_ == null) {
        if (operationCase_ == 4
            && operation_ != com.google.datastore.v1.Entity.getDefaultInstance()) {
          operation_ =
              com.google.datastore.v1.Entity.newBuilder((com.google.datastore.v1.Entity) operation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          operation_ = value;
        }
        onChanged();
      } else {
        if (operationCase_ == 4) {
          insertBuilder_.mergeFrom(value);
        } else {
          insertBuilder_.setMessage(value);
        }
      }
      operationCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The entity to insert. The entity must not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity insert = 4;</code>
     */
    public Builder clearInsert() {
      if (insertBuilder_ == null) {
        if (operationCase_ == 4) {
          operationCase_ = 0;
          operation_ = null;
          onChanged();
        }
      } else {
        if (operationCase_ == 4) {
          operationCase_ = 0;
          operation_ = null;
        }
        insertBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The entity to insert. The entity must not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity insert = 4;</code>
     */
    public com.google.datastore.v1.Entity.Builder getInsertBuilder() {
      return getInsertFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The entity to insert. The entity must not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity insert = 4;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.EntityOrBuilder getInsertOrBuilder() {
      if ((operationCase_ == 4) && (insertBuilder_ != null)) {
        return insertBuilder_.getMessageOrBuilder();
      } else {
        if (operationCase_ == 4) {
          return (com.google.datastore.v1.Entity) operation_;
        }
        return com.google.datastore.v1.Entity.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The entity to insert. The entity must not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity insert = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Entity,
            com.google.datastore.v1.Entity.Builder,
            com.google.datastore.v1.EntityOrBuilder>
        getInsertFieldBuilder() {
      if (insertBuilder_ == null) {
        if (!(operationCase_ == 4)) {
          operation_ = com.google.datastore.v1.Entity.getDefaultInstance();
        }
        insertBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.Entity,
                com.google.datastore.v1.Entity.Builder,
                com.google.datastore.v1.EntityOrBuilder>(
                (com.google.datastore.v1.Entity) operation_, getParentForChildren(), isClean());
        operation_ = null;
      }
      operationCase_ = 4;
      onChanged();
      return insertBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Entity,
            com.google.datastore.v1.Entity.Builder,
            com.google.datastore.v1.EntityOrBuilder>
        updateBuilder_;

    /**
     *
     *
     * <pre>
     * The entity to update. The entity must already exist.
     * Must have a complete key path.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity update = 5;</code>
     *
     * @return Whether the update field is set.
     */
    @java.lang.Override
    public boolean hasUpdate() {
      return operationCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * The entity to update. The entity must already exist.
     * Must have a complete key path.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity update = 5;</code>
     *
     * @return The update.
     */
    @java.lang.Override
    public com.google.datastore.v1.Entity getUpdate() {
      if (updateBuilder_ == null) {
        if (operationCase_ == 5) {
          return (com.google.datastore.v1.Entity) operation_;
        }
        return com.google.datastore.v1.Entity.getDefaultInstance();
      } else {
        if (operationCase_ == 5) {
          return updateBuilder_.getMessage();
        }
        return com.google.datastore.v1.Entity.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The entity to update. The entity must already exist.
     * Must have a complete key path.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity update = 5;</code>
     */
    public Builder setUpdate(com.google.datastore.v1.Entity value) {
      if (updateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
        onChanged();
      } else {
        updateBuilder_.setMessage(value);
      }
      operationCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The entity to update. The entity must already exist.
     * Must have a complete key path.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity update = 5;</code>
     */
    public Builder setUpdate(com.google.datastore.v1.Entity.Builder builderForValue) {
      if (updateBuilder_ == null) {
        operation_ = builderForValue.build();
        onChanged();
      } else {
        updateBuilder_.setMessage(builderForValue.build());
      }
      operationCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The entity to update. The entity must already exist.
     * Must have a complete key path.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity update = 5;</code>
     */
    public Builder mergeUpdate(com.google.datastore.v1.Entity value) {
      if (updateBuilder_ == null) {
        if (operationCase_ == 5
            && operation_ != com.google.datastore.v1.Entity.getDefaultInstance()) {
          operation_ =
              com.google.datastore.v1.Entity.newBuilder((com.google.datastore.v1.Entity) operation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          operation_ = value;
        }
        onChanged();
      } else {
        if (operationCase_ == 5) {
          updateBuilder_.mergeFrom(value);
        } else {
          updateBuilder_.setMessage(value);
        }
      }
      operationCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The entity to update. The entity must already exist.
     * Must have a complete key path.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity update = 5;</code>
     */
    public Builder clearUpdate() {
      if (updateBuilder_ == null) {
        if (operationCase_ == 5) {
          operationCase_ = 0;
          operation_ = null;
          onChanged();
        }
      } else {
        if (operationCase_ == 5) {
          operationCase_ = 0;
          operation_ = null;
        }
        updateBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The entity to update. The entity must already exist.
     * Must have a complete key path.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity update = 5;</code>
     */
    public com.google.datastore.v1.Entity.Builder getUpdateBuilder() {
      return getUpdateFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The entity to update. The entity must already exist.
     * Must have a complete key path.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity update = 5;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.EntityOrBuilder getUpdateOrBuilder() {
      if ((operationCase_ == 5) && (updateBuilder_ != null)) {
        return updateBuilder_.getMessageOrBuilder();
      } else {
        if (operationCase_ == 5) {
          return (com.google.datastore.v1.Entity) operation_;
        }
        return com.google.datastore.v1.Entity.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The entity to update. The entity must already exist.
     * Must have a complete key path.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity update = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Entity,
            com.google.datastore.v1.Entity.Builder,
            com.google.datastore.v1.EntityOrBuilder>
        getUpdateFieldBuilder() {
      if (updateBuilder_ == null) {
        if (!(operationCase_ == 5)) {
          operation_ = com.google.datastore.v1.Entity.getDefaultInstance();
        }
        updateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.Entity,
                com.google.datastore.v1.Entity.Builder,
                com.google.datastore.v1.EntityOrBuilder>(
                (com.google.datastore.v1.Entity) operation_, getParentForChildren(), isClean());
        operation_ = null;
      }
      operationCase_ = 5;
      onChanged();
      return updateBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Entity,
            com.google.datastore.v1.Entity.Builder,
            com.google.datastore.v1.EntityOrBuilder>
        upsertBuilder_;

    /**
     *
     *
     * <pre>
     * The entity to upsert. The entity may or may not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity upsert = 6;</code>
     *
     * @return Whether the upsert field is set.
     */
    @java.lang.Override
    public boolean hasUpsert() {
      return operationCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * The entity to upsert. The entity may or may not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity upsert = 6;</code>
     *
     * @return The upsert.
     */
    @java.lang.Override
    public com.google.datastore.v1.Entity getUpsert() {
      if (upsertBuilder_ == null) {
        if (operationCase_ == 6) {
          return (com.google.datastore.v1.Entity) operation_;
        }
        return com.google.datastore.v1.Entity.getDefaultInstance();
      } else {
        if (operationCase_ == 6) {
          return upsertBuilder_.getMessage();
        }
        return com.google.datastore.v1.Entity.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The entity to upsert. The entity may or may not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity upsert = 6;</code>
     */
    public Builder setUpsert(com.google.datastore.v1.Entity value) {
      if (upsertBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
        onChanged();
      } else {
        upsertBuilder_.setMessage(value);
      }
      operationCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The entity to upsert. The entity may or may not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity upsert = 6;</code>
     */
    public Builder setUpsert(com.google.datastore.v1.Entity.Builder builderForValue) {
      if (upsertBuilder_ == null) {
        operation_ = builderForValue.build();
        onChanged();
      } else {
        upsertBuilder_.setMessage(builderForValue.build());
      }
      operationCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The entity to upsert. The entity may or may not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity upsert = 6;</code>
     */
    public Builder mergeUpsert(com.google.datastore.v1.Entity value) {
      if (upsertBuilder_ == null) {
        if (operationCase_ == 6
            && operation_ != com.google.datastore.v1.Entity.getDefaultInstance()) {
          operation_ =
              com.google.datastore.v1.Entity.newBuilder((com.google.datastore.v1.Entity) operation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          operation_ = value;
        }
        onChanged();
      } else {
        if (operationCase_ == 6) {
          upsertBuilder_.mergeFrom(value);
        } else {
          upsertBuilder_.setMessage(value);
        }
      }
      operationCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The entity to upsert. The entity may or may not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity upsert = 6;</code>
     */
    public Builder clearUpsert() {
      if (upsertBuilder_ == null) {
        if (operationCase_ == 6) {
          operationCase_ = 0;
          operation_ = null;
          onChanged();
        }
      } else {
        if (operationCase_ == 6) {
          operationCase_ = 0;
          operation_ = null;
        }
        upsertBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The entity to upsert. The entity may or may not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity upsert = 6;</code>
     */
    public com.google.datastore.v1.Entity.Builder getUpsertBuilder() {
      return getUpsertFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The entity to upsert. The entity may or may not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity upsert = 6;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.EntityOrBuilder getUpsertOrBuilder() {
      if ((operationCase_ == 6) && (upsertBuilder_ != null)) {
        return upsertBuilder_.getMessageOrBuilder();
      } else {
        if (operationCase_ == 6) {
          return (com.google.datastore.v1.Entity) operation_;
        }
        return com.google.datastore.v1.Entity.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The entity to upsert. The entity may or may not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity upsert = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Entity,
            com.google.datastore.v1.Entity.Builder,
            com.google.datastore.v1.EntityOrBuilder>
        getUpsertFieldBuilder() {
      if (upsertBuilder_ == null) {
        if (!(operationCase_ == 6)) {
          operation_ = com.google.datastore.v1.Entity.getDefaultInstance();
        }
        upsertBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.Entity,
                com.google.datastore.v1.Entity.Builder,
                com.google.datastore.v1.EntityOrBuilder>(
                (com.google.datastore.v1.Entity) operation_, getParentForChildren(), isClean());
        operation_ = null;
      }
      operationCase_ = 6;
      onChanged();
      return upsertBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Key,
            com.google.datastore.v1.Key.Builder,
            com.google.datastore.v1.KeyOrBuilder>
        deleteBuilder_;

    /**
     *
     *
     * <pre>
     * The key of the entity to delete. The entity may or may not already exist.
     * Must have a complete key path and must not be reserved/read-only.
     * </pre>
     *
     * <code>.google.datastore.v1.Key delete = 7;</code>
     *
     * @return Whether the delete field is set.
     */
    @java.lang.Override
    public boolean hasDelete() {
      return operationCase_ == 7;
    }

    /**
     *
     *
     * <pre>
     * The key of the entity to delete. The entity may or may not already exist.
     * Must have a complete key path and must not be reserved/read-only.
     * </pre>
     *
     * <code>.google.datastore.v1.Key delete = 7;</code>
     *
     * @return The delete.
     */
    @java.lang.Override
    public com.google.datastore.v1.Key getDelete() {
      if (deleteBuilder_ == null) {
        if (operationCase_ == 7) {
          return (com.google.datastore.v1.Key) operation_;
        }
        return com.google.datastore.v1.Key.getDefaultInstance();
      } else {
        if (operationCase_ == 7) {
          return deleteBuilder_.getMessage();
        }
        return com.google.datastore.v1.Key.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The key of the entity to delete. The entity may or may not already exist.
     * Must have a complete key path and must not be reserved/read-only.
     * </pre>
     *
     * <code>.google.datastore.v1.Key delete = 7;</code>
     */
    public Builder setDelete(com.google.datastore.v1.Key value) {
      if (deleteBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
        onChanged();
      } else {
        deleteBuilder_.setMessage(value);
      }
      operationCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The key of the entity to delete. The entity may or may not already exist.
     * Must have a complete key path and must not be reserved/read-only.
     * </pre>
     *
     * <code>.google.datastore.v1.Key delete = 7;</code>
     */
    public Builder setDelete(com.google.datastore.v1.Key.Builder builderForValue) {
      if (deleteBuilder_ == null) {
        operation_ = builderForValue.build();
        onChanged();
      } else {
        deleteBuilder_.setMessage(builderForValue.build());
      }
      operationCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The key of the entity to delete. The entity may or may not already exist.
     * Must have a complete key path and must not be reserved/read-only.
     * </pre>
     *
     * <code>.google.datastore.v1.Key delete = 7;</code>
     */
    public Builder mergeDelete(com.google.datastore.v1.Key value) {
      if (deleteBuilder_ == null) {
        if (operationCase_ == 7 && operation_ != com.google.datastore.v1.Key.getDefaultInstance()) {
          operation_ =
              com.google.datastore.v1.Key.newBuilder((com.google.datastore.v1.Key) operation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          operation_ = value;
        }
        onChanged();
      } else {
        if (operationCase_ == 7) {
          deleteBuilder_.mergeFrom(value);
        } else {
          deleteBuilder_.setMessage(value);
        }
      }
      operationCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The key of the entity to delete. The entity may or may not already exist.
     * Must have a complete key path and must not be reserved/read-only.
     * </pre>
     *
     * <code>.google.datastore.v1.Key delete = 7;</code>
     */
    public Builder clearDelete() {
      if (deleteBuilder_ == null) {
        if (operationCase_ == 7) {
          operationCase_ = 0;
          operation_ = null;
          onChanged();
        }
      } else {
        if (operationCase_ == 7) {
          operationCase_ = 0;
          operation_ = null;
        }
        deleteBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The key of the entity to delete. The entity may or may not already exist.
     * Must have a complete key path and must not be reserved/read-only.
     * </pre>
     *
     * <code>.google.datastore.v1.Key delete = 7;</code>
     */
    public com.google.datastore.v1.Key.Builder getDeleteBuilder() {
      return getDeleteFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The key of the entity to delete. The entity may or may not already exist.
     * Must have a complete key path and must not be reserved/read-only.
     * </pre>
     *
     * <code>.google.datastore.v1.Key delete = 7;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.KeyOrBuilder getDeleteOrBuilder() {
      if ((operationCase_ == 7) && (deleteBuilder_ != null)) {
        return deleteBuilder_.getMessageOrBuilder();
      } else {
        if (operationCase_ == 7) {
          return (com.google.datastore.v1.Key) operation_;
        }
        return com.google.datastore.v1.Key.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The key of the entity to delete. The entity may or may not already exist.
     * Must have a complete key path and must not be reserved/read-only.
     * </pre>
     *
     * <code>.google.datastore.v1.Key delete = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Key,
            com.google.datastore.v1.Key.Builder,
            com.google.datastore.v1.KeyOrBuilder>
        getDeleteFieldBuilder() {
      if (deleteBuilder_ == null) {
        if (!(operationCase_ == 7)) {
          operation_ = com.google.datastore.v1.Key.getDefaultInstance();
        }
        deleteBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.Key,
                com.google.datastore.v1.Key.Builder,
                com.google.datastore.v1.KeyOrBuilder>(
                (com.google.datastore.v1.Key) operation_, getParentForChildren(), isClean());
        operation_ = null;
      }
      operationCase_ = 7;
      onChanged();
      return deleteBuilder_;
    }

    /**
     *
     *
     * <pre>
     * The version of the entity that this mutation is being applied
     * to. If this does not match the current version on the server, the
     * mutation conflicts.
     * </pre>
     *
     * <code>int64 base_version = 8;</code>
     *
     * @return Whether the baseVersion field is set.
     */
    public boolean hasBaseVersion() {
      return conflictDetectionStrategyCase_ == 8;
    }

    /**
     *
     *
     * <pre>
     * The version of the entity that this mutation is being applied
     * to. If this does not match the current version on the server, the
     * mutation conflicts.
     * </pre>
     *
     * <code>int64 base_version = 8;</code>
     *
     * @return The baseVersion.
     */
    public long getBaseVersion() {
      if (conflictDetectionStrategyCase_ == 8) {
        return (java.lang.Long) conflictDetectionStrategy_;
      }
      return 0L;
    }

    /**
     *
     *
     * <pre>
     * The version of the entity that this mutation is being applied
     * to. If this does not match the current version on the server, the
     * mutation conflicts.
     * </pre>
     *
     * <code>int64 base_version = 8;</code>
     *
     * @param value The baseVersion to set.
     * @return This builder for chaining.
     */
    public Builder setBaseVersion(long value) {

      conflictDetectionStrategyCase_ = 8;
      conflictDetectionStrategy_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The version of the entity that this mutation is being applied
     * to. If this does not match the current version on the server, the
     * mutation conflicts.
     * </pre>
     *
     * <code>int64 base_version = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBaseVersion() {
      if (conflictDetectionStrategyCase_ == 8) {
        conflictDetectionStrategyCase_ = 0;
        conflictDetectionStrategy_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * The update time of the entity that this mutation is being applied
     * to. If this does not match the current update time on the server, the
     * mutation conflicts.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 11;</code>
     *
     * @return Whether the updateTime field is set.
     */
    @java.lang.Override
    public boolean hasUpdateTime() {
      return conflictDetectionStrategyCase_ == 11;
    }

    /**
     *
     *
     * <pre>
     * The update time of the entity that this mutation is being applied
     * to. If this does not match the current update time on the server, the
     * mutation conflicts.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 11;</code>
     *
     * @return The updateTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        if (conflictDetectionStrategyCase_ == 11) {
          return (com.google.protobuf.Timestamp) conflictDetectionStrategy_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (conflictDetectionStrategyCase_ == 11) {
          return updateTimeBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The update time of the entity that this mutation is being applied
     * to. If this does not match the current update time on the server, the
     * mutation conflicts.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 11;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        conflictDetectionStrategy_ = value;
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      conflictDetectionStrategyCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The update time of the entity that this mutation is being applied
     * to. If this does not match the current update time on the server, the
     * mutation conflicts.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 11;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        conflictDetectionStrategy_ = builderForValue.build();
        onChanged();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      conflictDetectionStrategyCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The update time of the entity that this mutation is being applied
     * to. If this does not match the current update time on the server, the
     * mutation conflicts.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 11;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (conflictDetectionStrategyCase_ == 11
            && conflictDetectionStrategy_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          conflictDetectionStrategy_ =
              com.google.protobuf.Timestamp.newBuilder(
                      (com.google.protobuf.Timestamp) conflictDetectionStrategy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          conflictDetectionStrategy_ = value;
        }
        onChanged();
      } else {
        if (conflictDetectionStrategyCase_ == 11) {
          updateTimeBuilder_.mergeFrom(value);
        } else {
          updateTimeBuilder_.setMessage(value);
        }
      }
      conflictDetectionStrategyCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The update time of the entity that this mutation is being applied
     * to. If this does not match the current update time on the server, the
     * mutation conflicts.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 11;</code>
     */
    public Builder clearUpdateTime() {
      if (updateTimeBuilder_ == null) {
        if (conflictDetectionStrategyCase_ == 11) {
          conflictDetectionStrategyCase_ = 0;
          conflictDetectionStrategy_ = null;
          onChanged();
        }
      } else {
        if (conflictDetectionStrategyCase_ == 11) {
          conflictDetectionStrategyCase_ = 0;
          conflictDetectionStrategy_ = null;
        }
        updateTimeBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The update time of the entity that this mutation is being applied
     * to. If this does not match the current update time on the server, the
     * mutation conflicts.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 11;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The update time of the entity that this mutation is being applied
     * to. If this does not match the current update time on the server, the
     * mutation conflicts.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 11;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if ((conflictDetectionStrategyCase_ == 11) && (updateTimeBuilder_ != null)) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        if (conflictDetectionStrategyCase_ == 11) {
          return (com.google.protobuf.Timestamp) conflictDetectionStrategy_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The update time of the entity that this mutation is being applied
     * to. If this does not match the current update time on the server, the
     * mutation conflicts.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        if (!(conflictDetectionStrategyCase_ == 11)) {
          conflictDetectionStrategy_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) conflictDetectionStrategy_,
                getParentForChildren(),
                isClean());
        conflictDetectionStrategy_ = null;
      }
      conflictDetectionStrategyCase_ = 11;
      onChanged();
      return updateTimeBuilder_;
    }

    private int conflictResolutionStrategy_ = 0;

    /**
     *
     *
     * <pre>
     * The strategy to use when a conflict is detected. Defaults to
     * `SERVER_VALUE`.
     * If this is set, then `conflict_detection_strategy` must also be set.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.Mutation.ConflictResolutionStrategy conflict_resolution_strategy = 10;
     * </code>
     *
     * @return The enum numeric value on the wire for conflictResolutionStrategy.
     */
    @java.lang.Override
    public int getConflictResolutionStrategyValue() {
      return conflictResolutionStrategy_;
    }

    /**
     *
     *
     * <pre>
     * The strategy to use when a conflict is detected. Defaults to
     * `SERVER_VALUE`.
     * If this is set, then `conflict_detection_strategy` must also be set.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.Mutation.ConflictResolutionStrategy conflict_resolution_strategy = 10;
     * </code>
     *
     * @param value The enum numeric value on the wire for conflictResolutionStrategy to set.
     * @return This builder for chaining.
     */
    public Builder setConflictResolutionStrategyValue(int value) {
      conflictResolutionStrategy_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The strategy to use when a conflict is detected. Defaults to
     * `SERVER_VALUE`.
     * If this is set, then `conflict_detection_strategy` must also be set.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.Mutation.ConflictResolutionStrategy conflict_resolution_strategy = 10;
     * </code>
     *
     * @return The conflictResolutionStrategy.
     */
    @java.lang.Override
    public com.google.datastore.v1.Mutation.ConflictResolutionStrategy
        getConflictResolutionStrategy() {
      com.google.datastore.v1.Mutation.ConflictResolutionStrategy result =
          com.google.datastore.v1.Mutation.ConflictResolutionStrategy.forNumber(
              conflictResolutionStrategy_);
      return result == null
          ? com.google.datastore.v1.Mutation.ConflictResolutionStrategy.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * The strategy to use when a conflict is detected. Defaults to
     * `SERVER_VALUE`.
     * If this is set, then `conflict_detection_strategy` must also be set.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.Mutation.ConflictResolutionStrategy conflict_resolution_strategy = 10;
     * </code>
     *
     * @param value The conflictResolutionStrategy to set.
     * @return This builder for chaining.
     */
    public Builder setConflictResolutionStrategy(
        com.google.datastore.v1.Mutation.ConflictResolutionStrategy value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      conflictResolutionStrategy_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The strategy to use when a conflict is detected. Defaults to
     * `SERVER_VALUE`.
     * If this is set, then `conflict_detection_strategy` must also be set.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.Mutation.ConflictResolutionStrategy conflict_resolution_strategy = 10;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConflictResolutionStrategy() {
      bitField0_ = (bitField0_ & ~0x00000040);
      conflictResolutionStrategy_ = 0;
      onChanged();
      return this;
    }

    private com.google.datastore.v1.PropertyMask propertyMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.PropertyMask,
            com.google.datastore.v1.PropertyMask.Builder,
            com.google.datastore.v1.PropertyMaskOrBuilder>
        propertyMaskBuilder_;

    /**
     *
     *
     * <pre>
     * The properties to write in this mutation.
     * None of the properties in the mask may have a reserved name, except for
     * `__key__`.
     * This field is ignored for `delete`.
     *
     * If the entity already exists, only properties referenced in the mask are
     * updated, others are left untouched.
     * Properties referenced in the mask but not in the entity are deleted.
     * </pre>
     *
     * <code>.google.datastore.v1.PropertyMask property_mask = 9;</code>
     *
     * @return Whether the propertyMask field is set.
     */
    public boolean hasPropertyMask() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * The properties to write in this mutation.
     * None of the properties in the mask may have a reserved name, except for
     * `__key__`.
     * This field is ignored for `delete`.
     *
     * If the entity already exists, only properties referenced in the mask are
     * updated, others are left untouched.
     * Properties referenced in the mask but not in the entity are deleted.
     * </pre>
     *
     * <code>.google.datastore.v1.PropertyMask property_mask = 9;</code>
     *
     * @return The propertyMask.
     */
    public com.google.datastore.v1.PropertyMask getPropertyMask() {
      if (propertyMaskBuilder_ == null) {
        return propertyMask_ == null
            ? com.google.datastore.v1.PropertyMask.getDefaultInstance()
            : propertyMask_;
      } else {
        return propertyMaskBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The properties to write in this mutation.
     * None of the properties in the mask may have a reserved name, except for
     * `__key__`.
     * This field is ignored for `delete`.
     *
     * If the entity already exists, only properties referenced in the mask are
     * updated, others are left untouched.
     * Properties referenced in the mask but not in the entity are deleted.
     * </pre>
     *
     * <code>.google.datastore.v1.PropertyMask property_mask = 9;</code>
     */
    public Builder setPropertyMask(com.google.datastore.v1.PropertyMask value) {
      if (propertyMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        propertyMask_ = value;
      } else {
        propertyMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The properties to write in this mutation.
     * None of the properties in the mask may have a reserved name, except for
     * `__key__`.
     * This field is ignored for `delete`.
     *
     * If the entity already exists, only properties referenced in the mask are
     * updated, others are left untouched.
     * Properties referenced in the mask but not in the entity are deleted.
     * </pre>
     *
     * <code>.google.datastore.v1.PropertyMask property_mask = 9;</code>
     */
    public Builder setPropertyMask(com.google.datastore.v1.PropertyMask.Builder builderForValue) {
      if (propertyMaskBuilder_ == null) {
        propertyMask_ = builderForValue.build();
      } else {
        propertyMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The properties to write in this mutation.
     * None of the properties in the mask may have a reserved name, except for
     * `__key__`.
     * This field is ignored for `delete`.
     *
     * If the entity already exists, only properties referenced in the mask are
     * updated, others are left untouched.
     * Properties referenced in the mask but not in the entity are deleted.
     * </pre>
     *
     * <code>.google.datastore.v1.PropertyMask property_mask = 9;</code>
     */
    public Builder mergePropertyMask(com.google.datastore.v1.PropertyMask value) {
      if (propertyMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && propertyMask_ != null
            && propertyMask_ != com.google.datastore.v1.PropertyMask.getDefaultInstance()) {
          getPropertyMaskBuilder().mergeFrom(value);
        } else {
          propertyMask_ = value;
        }
      } else {
        propertyMaskBuilder_.mergeFrom(value);
      }
      if (propertyMask_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The properties to write in this mutation.
     * None of the properties in the mask may have a reserved name, except for
     * `__key__`.
     * This field is ignored for `delete`.
     *
     * If the entity already exists, only properties referenced in the mask are
     * updated, others are left untouched.
     * Properties referenced in the mask but not in the entity are deleted.
     * </pre>
     *
     * <code>.google.datastore.v1.PropertyMask property_mask = 9;</code>
     */
    public Builder clearPropertyMask() {
      bitField0_ = (bitField0_ & ~0x00000080);
      propertyMask_ = null;
      if (propertyMaskBuilder_ != null) {
        propertyMaskBuilder_.dispose();
        propertyMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The properties to write in this mutation.
     * None of the properties in the mask may have a reserved name, except for
     * `__key__`.
     * This field is ignored for `delete`.
     *
     * If the entity already exists, only properties referenced in the mask are
     * updated, others are left untouched.
     * Properties referenced in the mask but not in the entity are deleted.
     * </pre>
     *
     * <code>.google.datastore.v1.PropertyMask property_mask = 9;</code>
     */
    public com.google.datastore.v1.PropertyMask.Builder getPropertyMaskBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getPropertyMaskFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The properties to write in this mutation.
     * None of the properties in the mask may have a reserved name, except for
     * `__key__`.
     * This field is ignored for `delete`.
     *
     * If the entity already exists, only properties referenced in the mask are
     * updated, others are left untouched.
     * Properties referenced in the mask but not in the entity are deleted.
     * </pre>
     *
     * <code>.google.datastore.v1.PropertyMask property_mask = 9;</code>
     */
    public com.google.datastore.v1.PropertyMaskOrBuilder getPropertyMaskOrBuilder() {
      if (propertyMaskBuilder_ != null) {
        return propertyMaskBuilder_.getMessageOrBuilder();
      } else {
        return propertyMask_ == null
            ? com.google.datastore.v1.PropertyMask.getDefaultInstance()
            : propertyMask_;
      }
    }

    /**
     *
     *
     * <pre>
     * The properties to write in this mutation.
     * None of the properties in the mask may have a reserved name, except for
     * `__key__`.
     * This field is ignored for `delete`.
     *
     * If the entity already exists, only properties referenced in the mask are
     * updated, others are left untouched.
     * Properties referenced in the mask but not in the entity are deleted.
     * </pre>
     *
     * <code>.google.datastore.v1.PropertyMask property_mask = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.PropertyMask,
            com.google.datastore.v1.PropertyMask.Builder,
            com.google.datastore.v1.PropertyMaskOrBuilder>
        getPropertyMaskFieldBuilder() {
      if (propertyMaskBuilder_ == null) {
        propertyMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.PropertyMask,
                com.google.datastore.v1.PropertyMask.Builder,
                com.google.datastore.v1.PropertyMaskOrBuilder>(
                getPropertyMask(), getParentForChildren(), isClean());
        propertyMask_ = null;
      }
      return propertyMaskBuilder_;
    }

    private java.util.List<com.google.datastore.v1.PropertyTransform> propertyTransforms_ =
        java.util.Collections.emptyList();

    private void ensurePropertyTransformsIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        propertyTransforms_ =
            new java.util.ArrayList<com.google.datastore.v1.PropertyTransform>(propertyTransforms_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.PropertyTransform,
            com.google.datastore.v1.PropertyTransform.Builder,
            com.google.datastore.v1.PropertyTransformOrBuilder>
        propertyTransformsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The transforms to perform on the entity.
     *
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.datastore.v1.PropertyTransform> getPropertyTransformsList() {
      if (propertyTransformsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(propertyTransforms_);
      } else {
        return propertyTransformsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The transforms to perform on the entity.
     *
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getPropertyTransformsCount() {
      if (propertyTransformsBuilder_ == null) {
        return propertyTransforms_.size();
      } else {
        return propertyTransformsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The transforms to perform on the entity.
     *
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.datastore.v1.PropertyTransform getPropertyTransforms(int index) {
      if (propertyTransformsBuilder_ == null) {
        return propertyTransforms_.get(index);
      } else {
        return propertyTransformsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The transforms to perform on the entity.
     *
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPropertyTransforms(
        int index, com.google.datastore.v1.PropertyTransform value) {
      if (propertyTransformsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePropertyTransformsIsMutable();
        propertyTransforms_.set(index, value);
        onChanged();
      } else {
        propertyTransformsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The transforms to perform on the entity.
     *
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPropertyTransforms(
        int index, com.google.datastore.v1.PropertyTransform.Builder builderForValue) {
      if (propertyTransformsBuilder_ == null) {
        ensurePropertyTransformsIsMutable();
        propertyTransforms_.set(index, builderForValue.build());
        onChanged();
      } else {
        propertyTransformsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The transforms to perform on the entity.
     *
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPropertyTransforms(com.google.datastore.v1.PropertyTransform value) {
      if (propertyTransformsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePropertyTransformsIsMutable();
        propertyTransforms_.add(value);
        onChanged();
      } else {
        propertyTransformsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The transforms to perform on the entity.
     *
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPropertyTransforms(
        int index, com.google.datastore.v1.PropertyTransform value) {
      if (propertyTransformsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePropertyTransformsIsMutable();
        propertyTransforms_.add(index, value);
        onChanged();
      } else {
        propertyTransformsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The transforms to perform on the entity.
     *
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPropertyTransforms(
        com.google.datastore.v1.PropertyTransform.Builder builderForValue) {
      if (propertyTransformsBuilder_ == null) {
        ensurePropertyTransformsIsMutable();
        propertyTransforms_.add(builderForValue.build());
        onChanged();
      } else {
        propertyTransformsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The transforms to perform on the entity.
     *
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPropertyTransforms(
        int index, com.google.datastore.v1.PropertyTransform.Builder builderForValue) {
      if (propertyTransformsBuilder_ == null) {
        ensurePropertyTransformsIsMutable();
        propertyTransforms_.add(index, builderForValue.build());
        onChanged();
      } else {
        propertyTransformsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The transforms to perform on the entity.
     *
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllPropertyTransforms(
        java.lang.Iterable<? extends com.google.datastore.v1.PropertyTransform> values) {
      if (propertyTransformsBuilder_ == null) {
        ensurePropertyTransformsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, propertyTransforms_);
        onChanged();
      } else {
        propertyTransformsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The transforms to perform on the entity.
     *
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPropertyTransforms() {
      if (propertyTransformsBuilder_ == null) {
        propertyTransforms_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        propertyTransformsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The transforms to perform on the entity.
     *
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removePropertyTransforms(int index) {
      if (propertyTransformsBuilder_ == null) {
        ensurePropertyTransformsIsMutable();
        propertyTransforms_.remove(index);
        onChanged();
      } else {
        propertyTransformsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The transforms to perform on the entity.
     *
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.datastore.v1.PropertyTransform.Builder getPropertyTransformsBuilder(
        int index) {
      return getPropertyTransformsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The transforms to perform on the entity.
     *
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.datastore.v1.PropertyTransformOrBuilder getPropertyTransformsOrBuilder(
        int index) {
      if (propertyTransformsBuilder_ == null) {
        return propertyTransforms_.get(index);
      } else {
        return propertyTransformsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The transforms to perform on the entity.
     *
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.datastore.v1.PropertyTransformOrBuilder>
        getPropertyTransformsOrBuilderList() {
      if (propertyTransformsBuilder_ != null) {
        return propertyTransformsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(propertyTransforms_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The transforms to perform on the entity.
     *
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.datastore.v1.PropertyTransform.Builder addPropertyTransformsBuilder() {
      return getPropertyTransformsFieldBuilder()
          .addBuilder(com.google.datastore.v1.PropertyTransform.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. The transforms to perform on the entity.
     *
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.datastore.v1.PropertyTransform.Builder addPropertyTransformsBuilder(
        int index) {
      return getPropertyTransformsFieldBuilder()
          .addBuilder(index, com.google.datastore.v1.PropertyTransform.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. The transforms to perform on the entity.
     *
     * This field can be set only when the operation is `insert`, `update`,
     * or `upsert`. If present, the transforms are be applied to the entity
     * regardless of the property mask, in order, after the operation.
     * </pre>
     *
     * <code>
     * repeated .google.datastore.v1.PropertyTransform property_transforms = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.datastore.v1.PropertyTransform.Builder>
        getPropertyTransformsBuilderList() {
      return getPropertyTransformsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.PropertyTransform,
            com.google.datastore.v1.PropertyTransform.Builder,
            com.google.datastore.v1.PropertyTransformOrBuilder>
        getPropertyTransformsFieldBuilder() {
      if (propertyTransformsBuilder_ == null) {
        propertyTransformsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.datastore.v1.PropertyTransform,
                com.google.datastore.v1.PropertyTransform.Builder,
                com.google.datastore.v1.PropertyTransformOrBuilder>(
                propertyTransforms_,
                ((bitField0_ & 0x00000100) != 0),
                getParentForChildren(),
                isClean());
        propertyTransforms_ = null;
      }
      return propertyTransformsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.datastore.v1.Mutation)
  }

  // @@protoc_insertion_point(class_scope:google.datastore.v1.Mutation)
  private static final com.google.datastore.v1.Mutation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.datastore.v1.Mutation();
  }

  public static com.google.datastore.v1.Mutation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Mutation> PARSER =
      new com.google.protobuf.AbstractParser<Mutation>() {
        @java.lang.Override
        public Mutation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Mutation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Mutation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.datastore.v1.Mutation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
