/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/v1/query.proto

// Protobuf Java Version: 3.25.8
package com.google.datastore.v1;

/**
 *
 *
 * <pre>
 * A query for entities.
 *
 * The query stages are executed in the following order:
 * 1. kind
 * 2. filter
 * 3. projection
 * 4. order + start_cursor + end_cursor
 * 5. offset
 * 6. limit
 * 7. find_nearest
 * </pre>
 *
 * Protobuf type {@code google.datastore.v1.Query}
 */
public final class Query extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.datastore.v1.Query)
    QueryOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Query.newBuilder() to construct.
  private Query(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Query() {
    projection_ = java.util.Collections.emptyList();
    kind_ = java.util.Collections.emptyList();
    order_ = java.util.Collections.emptyList();
    distinctOn_ = java.util.Collections.emptyList();
    startCursor_ = com.google.protobuf.ByteString.EMPTY;
    endCursor_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Query();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.datastore.v1.QueryProto.internal_static_google_datastore_v1_Query_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.datastore.v1.QueryProto
        .internal_static_google_datastore_v1_Query_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.datastore.v1.Query.class, com.google.datastore.v1.Query.Builder.class);
  }

  private int bitField0_;
  public static final int PROJECTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.datastore.v1.Projection> projection_;

  /**
   *
   *
   * <pre>
   * The projection to return. Defaults to returning all properties.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.datastore.v1.Projection> getProjectionList() {
    return projection_;
  }

  /**
   *
   *
   * <pre>
   * The projection to return. Defaults to returning all properties.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.datastore.v1.ProjectionOrBuilder>
      getProjectionOrBuilderList() {
    return projection_;
  }

  /**
   *
   *
   * <pre>
   * The projection to return. Defaults to returning all properties.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
   */
  @java.lang.Override
  public int getProjectionCount() {
    return projection_.size();
  }

  /**
   *
   *
   * <pre>
   * The projection to return. Defaults to returning all properties.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.Projection getProjection(int index) {
    return projection_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The projection to return. Defaults to returning all properties.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.ProjectionOrBuilder getProjectionOrBuilder(int index) {
    return projection_.get(index);
  }

  public static final int KIND_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.datastore.v1.KindExpression> kind_;

  /**
   *
   *
   * <pre>
   * The kinds to query (if empty, returns entities of all kinds).
   * Currently at most 1 kind may be specified.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.datastore.v1.KindExpression> getKindList() {
    return kind_;
  }

  /**
   *
   *
   * <pre>
   * The kinds to query (if empty, returns entities of all kinds).
   * Currently at most 1 kind may be specified.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.datastore.v1.KindExpressionOrBuilder>
      getKindOrBuilderList() {
    return kind_;
  }

  /**
   *
   *
   * <pre>
   * The kinds to query (if empty, returns entities of all kinds).
   * Currently at most 1 kind may be specified.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
   */
  @java.lang.Override
  public int getKindCount() {
    return kind_.size();
  }

  /**
   *
   *
   * <pre>
   * The kinds to query (if empty, returns entities of all kinds).
   * Currently at most 1 kind may be specified.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.KindExpression getKind(int index) {
    return kind_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The kinds to query (if empty, returns entities of all kinds).
   * Currently at most 1 kind may be specified.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.KindExpressionOrBuilder getKindOrBuilder(int index) {
    return kind_.get(index);
  }

  public static final int FILTER_FIELD_NUMBER = 4;
  private com.google.datastore.v1.Filter filter_;

  /**
   *
   *
   * <pre>
   * The filter to apply.
   * </pre>
   *
   * <code>.google.datastore.v1.Filter filter = 4;</code>
   *
   * @return Whether the filter field is set.
   */
  @java.lang.Override
  public boolean hasFilter() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The filter to apply.
   * </pre>
   *
   * <code>.google.datastore.v1.Filter filter = 4;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public com.google.datastore.v1.Filter getFilter() {
    return filter_ == null ? com.google.datastore.v1.Filter.getDefaultInstance() : filter_;
  }

  /**
   *
   *
   * <pre>
   * The filter to apply.
   * </pre>
   *
   * <code>.google.datastore.v1.Filter filter = 4;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.FilterOrBuilder getFilterOrBuilder() {
    return filter_ == null ? com.google.datastore.v1.Filter.getDefaultInstance() : filter_;
  }

  public static final int ORDER_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.datastore.v1.PropertyOrder> order_;

  /**
   *
   *
   * <pre>
   * The order to apply to the query results (if empty, order is unspecified).
   * </pre>
   *
   * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.datastore.v1.PropertyOrder> getOrderList() {
    return order_;
  }

  /**
   *
   *
   * <pre>
   * The order to apply to the query results (if empty, order is unspecified).
   * </pre>
   *
   * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.datastore.v1.PropertyOrderOrBuilder>
      getOrderOrBuilderList() {
    return order_;
  }

  /**
   *
   *
   * <pre>
   * The order to apply to the query results (if empty, order is unspecified).
   * </pre>
   *
   * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
   */
  @java.lang.Override
  public int getOrderCount() {
    return order_.size();
  }

  /**
   *
   *
   * <pre>
   * The order to apply to the query results (if empty, order is unspecified).
   * </pre>
   *
   * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.PropertyOrder getOrder(int index) {
    return order_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The order to apply to the query results (if empty, order is unspecified).
   * </pre>
   *
   * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.PropertyOrderOrBuilder getOrderOrBuilder(int index) {
    return order_.get(index);
  }

  public static final int DISTINCT_ON_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.datastore.v1.PropertyReference> distinctOn_;

  /**
   *
   *
   * <pre>
   * The properties to make distinct. The query results will contain the first
   * result for each distinct combination of values for the given properties
   * (if empty, all results are returned).
   *
   * Requires:
   *
   * * If `order` is specified, the set of distinct on properties must appear
   * before the non-distinct on properties in `order`.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.datastore.v1.PropertyReference> getDistinctOnList() {
    return distinctOn_;
  }

  /**
   *
   *
   * <pre>
   * The properties to make distinct. The query results will contain the first
   * result for each distinct combination of values for the given properties
   * (if empty, all results are returned).
   *
   * Requires:
   *
   * * If `order` is specified, the set of distinct on properties must appear
   * before the non-distinct on properties in `order`.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.datastore.v1.PropertyReferenceOrBuilder>
      getDistinctOnOrBuilderList() {
    return distinctOn_;
  }

  /**
   *
   *
   * <pre>
   * The properties to make distinct. The query results will contain the first
   * result for each distinct combination of values for the given properties
   * (if empty, all results are returned).
   *
   * Requires:
   *
   * * If `order` is specified, the set of distinct on properties must appear
   * before the non-distinct on properties in `order`.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
   */
  @java.lang.Override
  public int getDistinctOnCount() {
    return distinctOn_.size();
  }

  /**
   *
   *
   * <pre>
   * The properties to make distinct. The query results will contain the first
   * result for each distinct combination of values for the given properties
   * (if empty, all results are returned).
   *
   * Requires:
   *
   * * If `order` is specified, the set of distinct on properties must appear
   * before the non-distinct on properties in `order`.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.PropertyReference getDistinctOn(int index) {
    return distinctOn_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The properties to make distinct. The query results will contain the first
   * result for each distinct combination of values for the given properties
   * (if empty, all results are returned).
   *
   * Requires:
   *
   * * If `order` is specified, the set of distinct on properties must appear
   * before the non-distinct on properties in `order`.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.PropertyReferenceOrBuilder getDistinctOnOrBuilder(int index) {
    return distinctOn_.get(index);
  }

  public static final int START_CURSOR_FIELD_NUMBER = 7;
  private com.google.protobuf.ByteString startCursor_ = com.google.protobuf.ByteString.EMPTY;

  /**
   *
   *
   * <pre>
   * A starting point for the query results. Query cursors are
   * returned in query result batches and
   * [can only be used to continue the same
   * query](https://cloud.google.com/datastore/docs/concepts/queries#cursors_limits_and_offsets).
   * </pre>
   *
   * <code>bytes start_cursor = 7;</code>
   *
   * @return The startCursor.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStartCursor() {
    return startCursor_;
  }

  public static final int END_CURSOR_FIELD_NUMBER = 8;
  private com.google.protobuf.ByteString endCursor_ = com.google.protobuf.ByteString.EMPTY;

  /**
   *
   *
   * <pre>
   * An ending point for the query results. Query cursors are
   * returned in query result batches and
   * [can only be used to limit the same
   * query](https://cloud.google.com/datastore/docs/concepts/queries#cursors_limits_and_offsets).
   * </pre>
   *
   * <code>bytes end_cursor = 8;</code>
   *
   * @return The endCursor.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEndCursor() {
    return endCursor_;
  }

  public static final int OFFSET_FIELD_NUMBER = 10;
  private int offset_ = 0;

  /**
   *
   *
   * <pre>
   * The number of results to skip. Applies before limit, but after all other
   * constraints. Optional. Must be &gt;= 0 if specified.
   * </pre>
   *
   * <code>int32 offset = 10;</code>
   *
   * @return The offset.
   */
  @java.lang.Override
  public int getOffset() {
    return offset_;
  }

  public static final int LIMIT_FIELD_NUMBER = 12;
  private com.google.protobuf.Int32Value limit_;

  /**
   *
   *
   * <pre>
   * The maximum number of results to return. Applies after all other
   * constraints. Optional.
   * Unspecified is interpreted as no limit.
   * Must be &gt;= 0 if specified.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value limit = 12;</code>
   *
   * @return Whether the limit field is set.
   */
  @java.lang.Override
  public boolean hasLimit() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The maximum number of results to return. Applies after all other
   * constraints. Optional.
   * Unspecified is interpreted as no limit.
   * Must be &gt;= 0 if specified.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value limit = 12;</code>
   *
   * @return The limit.
   */
  @java.lang.Override
  public com.google.protobuf.Int32Value getLimit() {
    return limit_ == null ? com.google.protobuf.Int32Value.getDefaultInstance() : limit_;
  }

  /**
   *
   *
   * <pre>
   * The maximum number of results to return. Applies after all other
   * constraints. Optional.
   * Unspecified is interpreted as no limit.
   * Must be &gt;= 0 if specified.
   * </pre>
   *
   * <code>.google.protobuf.Int32Value limit = 12;</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int32ValueOrBuilder getLimitOrBuilder() {
    return limit_ == null ? com.google.protobuf.Int32Value.getDefaultInstance() : limit_;
  }

  public static final int FIND_NEAREST_FIELD_NUMBER = 13;
  private com.google.datastore.v1.FindNearest findNearest_;

  /**
   *
   *
   * <pre>
   * Optional. A potential Nearest Neighbors Search.
   *
   * Applies after all other filters and ordering.
   *
   * Finds the closest vector embeddings to the given query vector.
   * </pre>
   *
   * <code>
   * .google.datastore.v1.FindNearest find_nearest = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the findNearest field is set.
   */
  @java.lang.Override
  public boolean hasFindNearest() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. A potential Nearest Neighbors Search.
   *
   * Applies after all other filters and ordering.
   *
   * Finds the closest vector embeddings to the given query vector.
   * </pre>
   *
   * <code>
   * .google.datastore.v1.FindNearest find_nearest = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The findNearest.
   */
  @java.lang.Override
  public com.google.datastore.v1.FindNearest getFindNearest() {
    return findNearest_ == null
        ? com.google.datastore.v1.FindNearest.getDefaultInstance()
        : findNearest_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A potential Nearest Neighbors Search.
   *
   * Applies after all other filters and ordering.
   *
   * Finds the closest vector embeddings to the given query vector.
   * </pre>
   *
   * <code>
   * .google.datastore.v1.FindNearest find_nearest = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.datastore.v1.FindNearestOrBuilder getFindNearestOrBuilder() {
    return findNearest_ == null
        ? com.google.datastore.v1.FindNearest.getDefaultInstance()
        : findNearest_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < projection_.size(); i++) {
      output.writeMessage(2, projection_.get(i));
    }
    for (int i = 0; i < kind_.size(); i++) {
      output.writeMessage(3, kind_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getFilter());
    }
    for (int i = 0; i < order_.size(); i++) {
      output.writeMessage(5, order_.get(i));
    }
    for (int i = 0; i < distinctOn_.size(); i++) {
      output.writeMessage(6, distinctOn_.get(i));
    }
    if (!startCursor_.isEmpty()) {
      output.writeBytes(7, startCursor_);
    }
    if (!endCursor_.isEmpty()) {
      output.writeBytes(8, endCursor_);
    }
    if (offset_ != 0) {
      output.writeInt32(10, offset_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(12, getLimit());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(13, getFindNearest());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < projection_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, projection_.get(i));
    }
    for (int i = 0; i < kind_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, kind_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getFilter());
    }
    for (int i = 0; i < order_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, order_.get(i));
    }
    for (int i = 0; i < distinctOn_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, distinctOn_.get(i));
    }
    if (!startCursor_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(7, startCursor_);
    }
    if (!endCursor_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(8, endCursor_);
    }
    if (offset_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(10, offset_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getLimit());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getFindNearest());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.datastore.v1.Query)) {
      return super.equals(obj);
    }
    com.google.datastore.v1.Query other = (com.google.datastore.v1.Query) obj;

    if (!getProjectionList().equals(other.getProjectionList())) return false;
    if (!getKindList().equals(other.getKindList())) return false;
    if (hasFilter() != other.hasFilter()) return false;
    if (hasFilter()) {
      if (!getFilter().equals(other.getFilter())) return false;
    }
    if (!getOrderList().equals(other.getOrderList())) return false;
    if (!getDistinctOnList().equals(other.getDistinctOnList())) return false;
    if (!getStartCursor().equals(other.getStartCursor())) return false;
    if (!getEndCursor().equals(other.getEndCursor())) return false;
    if (getOffset() != other.getOffset()) return false;
    if (hasLimit() != other.hasLimit()) return false;
    if (hasLimit()) {
      if (!getLimit().equals(other.getLimit())) return false;
    }
    if (hasFindNearest() != other.hasFindNearest()) return false;
    if (hasFindNearest()) {
      if (!getFindNearest().equals(other.getFindNearest())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getProjectionCount() > 0) {
      hash = (37 * hash) + PROJECTION_FIELD_NUMBER;
      hash = (53 * hash) + getProjectionList().hashCode();
    }
    if (getKindCount() > 0) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKindList().hashCode();
    }
    if (hasFilter()) {
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
    }
    if (getOrderCount() > 0) {
      hash = (37 * hash) + ORDER_FIELD_NUMBER;
      hash = (53 * hash) + getOrderList().hashCode();
    }
    if (getDistinctOnCount() > 0) {
      hash = (37 * hash) + DISTINCT_ON_FIELD_NUMBER;
      hash = (53 * hash) + getDistinctOnList().hashCode();
    }
    hash = (37 * hash) + START_CURSOR_FIELD_NUMBER;
    hash = (53 * hash) + getStartCursor().hashCode();
    hash = (37 * hash) + END_CURSOR_FIELD_NUMBER;
    hash = (53 * hash) + getEndCursor().hashCode();
    hash = (37 * hash) + OFFSET_FIELD_NUMBER;
    hash = (53 * hash) + getOffset();
    if (hasLimit()) {
      hash = (37 * hash) + LIMIT_FIELD_NUMBER;
      hash = (53 * hash) + getLimit().hashCode();
    }
    if (hasFindNearest()) {
      hash = (37 * hash) + FIND_NEAREST_FIELD_NUMBER;
      hash = (53 * hash) + getFindNearest().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.datastore.v1.Query parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.Query parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.Query parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.Query parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.Query parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.Query parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.Query parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.Query parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.Query parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.Query parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.Query parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.Query parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.datastore.v1.Query prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A query for entities.
   *
   * The query stages are executed in the following order:
   * 1. kind
   * 2. filter
   * 3. projection
   * 4. order + start_cursor + end_cursor
   * 5. offset
   * 6. limit
   * 7. find_nearest
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.Query}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.datastore.v1.Query)
      com.google.datastore.v1.QueryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.QueryProto
          .internal_static_google_datastore_v1_Query_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.QueryProto
          .internal_static_google_datastore_v1_Query_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.Query.class, com.google.datastore.v1.Query.Builder.class);
    }

    // Construct using com.google.datastore.v1.Query.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getProjectionFieldBuilder();
        getKindFieldBuilder();
        getFilterFieldBuilder();
        getOrderFieldBuilder();
        getDistinctOnFieldBuilder();
        getLimitFieldBuilder();
        getFindNearestFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (projectionBuilder_ == null) {
        projection_ = java.util.Collections.emptyList();
      } else {
        projection_ = null;
        projectionBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (kindBuilder_ == null) {
        kind_ = java.util.Collections.emptyList();
      } else {
        kind_ = null;
        kindBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      filter_ = null;
      if (filterBuilder_ != null) {
        filterBuilder_.dispose();
        filterBuilder_ = null;
      }
      if (orderBuilder_ == null) {
        order_ = java.util.Collections.emptyList();
      } else {
        order_ = null;
        orderBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (distinctOnBuilder_ == null) {
        distinctOn_ = java.util.Collections.emptyList();
      } else {
        distinctOn_ = null;
        distinctOnBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      startCursor_ = com.google.protobuf.ByteString.EMPTY;
      endCursor_ = com.google.protobuf.ByteString.EMPTY;
      offset_ = 0;
      limit_ = null;
      if (limitBuilder_ != null) {
        limitBuilder_.dispose();
        limitBuilder_ = null;
      }
      findNearest_ = null;
      if (findNearestBuilder_ != null) {
        findNearestBuilder_.dispose();
        findNearestBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.datastore.v1.QueryProto
          .internal_static_google_datastore_v1_Query_descriptor;
    }

    @java.lang.Override
    public com.google.datastore.v1.Query getDefaultInstanceForType() {
      return com.google.datastore.v1.Query.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.datastore.v1.Query build() {
      com.google.datastore.v1.Query result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.datastore.v1.Query buildPartial() {
      com.google.datastore.v1.Query result = new com.google.datastore.v1.Query(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.datastore.v1.Query result) {
      if (projectionBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          projection_ = java.util.Collections.unmodifiableList(projection_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.projection_ = projection_;
      } else {
        result.projection_ = projectionBuilder_.build();
      }
      if (kindBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          kind_ = java.util.Collections.unmodifiableList(kind_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.kind_ = kind_;
      } else {
        result.kind_ = kindBuilder_.build();
      }
      if (orderBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          order_ = java.util.Collections.unmodifiableList(order_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.order_ = order_;
      } else {
        result.order_ = orderBuilder_.build();
      }
      if (distinctOnBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          distinctOn_ = java.util.Collections.unmodifiableList(distinctOn_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.distinctOn_ = distinctOn_;
      } else {
        result.distinctOn_ = distinctOnBuilder_.build();
      }
    }

    private void buildPartial0(com.google.datastore.v1.Query result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.filter_ = filterBuilder_ == null ? filter_ : filterBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.startCursor_ = startCursor_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.endCursor_ = endCursor_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.offset_ = offset_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.limit_ = limitBuilder_ == null ? limit_ : limitBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.findNearest_ =
            findNearestBuilder_ == null ? findNearest_ : findNearestBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.datastore.v1.Query) {
        return mergeFrom((com.google.datastore.v1.Query) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.datastore.v1.Query other) {
      if (other == com.google.datastore.v1.Query.getDefaultInstance()) return this;
      if (projectionBuilder_ == null) {
        if (!other.projection_.isEmpty()) {
          if (projection_.isEmpty()) {
            projection_ = other.projection_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureProjectionIsMutable();
            projection_.addAll(other.projection_);
          }
          onChanged();
        }
      } else {
        if (!other.projection_.isEmpty()) {
          if (projectionBuilder_.isEmpty()) {
            projectionBuilder_.dispose();
            projectionBuilder_ = null;
            projection_ = other.projection_;
            bitField0_ = (bitField0_ & ~0x00000001);
            projectionBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getProjectionFieldBuilder()
                    : null;
          } else {
            projectionBuilder_.addAllMessages(other.projection_);
          }
        }
      }
      if (kindBuilder_ == null) {
        if (!other.kind_.isEmpty()) {
          if (kind_.isEmpty()) {
            kind_ = other.kind_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureKindIsMutable();
            kind_.addAll(other.kind_);
          }
          onChanged();
        }
      } else {
        if (!other.kind_.isEmpty()) {
          if (kindBuilder_.isEmpty()) {
            kindBuilder_.dispose();
            kindBuilder_ = null;
            kind_ = other.kind_;
            bitField0_ = (bitField0_ & ~0x00000002);
            kindBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getKindFieldBuilder()
                    : null;
          } else {
            kindBuilder_.addAllMessages(other.kind_);
          }
        }
      }
      if (other.hasFilter()) {
        mergeFilter(other.getFilter());
      }
      if (orderBuilder_ == null) {
        if (!other.order_.isEmpty()) {
          if (order_.isEmpty()) {
            order_ = other.order_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureOrderIsMutable();
            order_.addAll(other.order_);
          }
          onChanged();
        }
      } else {
        if (!other.order_.isEmpty()) {
          if (orderBuilder_.isEmpty()) {
            orderBuilder_.dispose();
            orderBuilder_ = null;
            order_ = other.order_;
            bitField0_ = (bitField0_ & ~0x00000008);
            orderBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getOrderFieldBuilder()
                    : null;
          } else {
            orderBuilder_.addAllMessages(other.order_);
          }
        }
      }
      if (distinctOnBuilder_ == null) {
        if (!other.distinctOn_.isEmpty()) {
          if (distinctOn_.isEmpty()) {
            distinctOn_ = other.distinctOn_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureDistinctOnIsMutable();
            distinctOn_.addAll(other.distinctOn_);
          }
          onChanged();
        }
      } else {
        if (!other.distinctOn_.isEmpty()) {
          if (distinctOnBuilder_.isEmpty()) {
            distinctOnBuilder_.dispose();
            distinctOnBuilder_ = null;
            distinctOn_ = other.distinctOn_;
            bitField0_ = (bitField0_ & ~0x00000010);
            distinctOnBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDistinctOnFieldBuilder()
                    : null;
          } else {
            distinctOnBuilder_.addAllMessages(other.distinctOn_);
          }
        }
      }
      if (other.getStartCursor() != com.google.protobuf.ByteString.EMPTY) {
        setStartCursor(other.getStartCursor());
      }
      if (other.getEndCursor() != com.google.protobuf.ByteString.EMPTY) {
        setEndCursor(other.getEndCursor());
      }
      if (other.getOffset() != 0) {
        setOffset(other.getOffset());
      }
      if (other.hasLimit()) {
        mergeLimit(other.getLimit());
      }
      if (other.hasFindNearest()) {
        mergeFindNearest(other.getFindNearest());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 18:
              {
                com.google.datastore.v1.Projection m =
                    input.readMessage(
                        com.google.datastore.v1.Projection.parser(), extensionRegistry);
                if (projectionBuilder_ == null) {
                  ensureProjectionIsMutable();
                  projection_.add(m);
                } else {
                  projectionBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.datastore.v1.KindExpression m =
                    input.readMessage(
                        com.google.datastore.v1.KindExpression.parser(), extensionRegistry);
                if (kindBuilder_ == null) {
                  ensureKindIsMutable();
                  kind_.add(m);
                } else {
                  kindBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getFilterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                com.google.datastore.v1.PropertyOrder m =
                    input.readMessage(
                        com.google.datastore.v1.PropertyOrder.parser(), extensionRegistry);
                if (orderBuilder_ == null) {
                  ensureOrderIsMutable();
                  order_.add(m);
                } else {
                  orderBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                com.google.datastore.v1.PropertyReference m =
                    input.readMessage(
                        com.google.datastore.v1.PropertyReference.parser(), extensionRegistry);
                if (distinctOnBuilder_ == null) {
                  ensureDistinctOnIsMutable();
                  distinctOn_.add(m);
                } else {
                  distinctOnBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                startCursor_ = input.readBytes();
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                endCursor_ = input.readBytes();
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 80:
              {
                offset_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 80
            case 98:
              {
                input.readMessage(getLimitFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getFindNearestFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.datastore.v1.Projection> projection_ =
        java.util.Collections.emptyList();

    private void ensureProjectionIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        projection_ = new java.util.ArrayList<com.google.datastore.v1.Projection>(projection_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.Projection,
            com.google.datastore.v1.Projection.Builder,
            com.google.datastore.v1.ProjectionOrBuilder>
        projectionBuilder_;

    /**
     *
     *
     * <pre>
     * The projection to return. Defaults to returning all properties.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
     */
    public java.util.List<com.google.datastore.v1.Projection> getProjectionList() {
      if (projectionBuilder_ == null) {
        return java.util.Collections.unmodifiableList(projection_);
      } else {
        return projectionBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The projection to return. Defaults to returning all properties.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
     */
    public int getProjectionCount() {
      if (projectionBuilder_ == null) {
        return projection_.size();
      } else {
        return projectionBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The projection to return. Defaults to returning all properties.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
     */
    public com.google.datastore.v1.Projection getProjection(int index) {
      if (projectionBuilder_ == null) {
        return projection_.get(index);
      } else {
        return projectionBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The projection to return. Defaults to returning all properties.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
     */
    public Builder setProjection(int index, com.google.datastore.v1.Projection value) {
      if (projectionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProjectionIsMutable();
        projection_.set(index, value);
        onChanged();
      } else {
        projectionBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The projection to return. Defaults to returning all properties.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
     */
    public Builder setProjection(
        int index, com.google.datastore.v1.Projection.Builder builderForValue) {
      if (projectionBuilder_ == null) {
        ensureProjectionIsMutable();
        projection_.set(index, builderForValue.build());
        onChanged();
      } else {
        projectionBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The projection to return. Defaults to returning all properties.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
     */
    public Builder addProjection(com.google.datastore.v1.Projection value) {
      if (projectionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProjectionIsMutable();
        projection_.add(value);
        onChanged();
      } else {
        projectionBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The projection to return. Defaults to returning all properties.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
     */
    public Builder addProjection(int index, com.google.datastore.v1.Projection value) {
      if (projectionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProjectionIsMutable();
        projection_.add(index, value);
        onChanged();
      } else {
        projectionBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The projection to return. Defaults to returning all properties.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
     */
    public Builder addProjection(com.google.datastore.v1.Projection.Builder builderForValue) {
      if (projectionBuilder_ == null) {
        ensureProjectionIsMutable();
        projection_.add(builderForValue.build());
        onChanged();
      } else {
        projectionBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The projection to return. Defaults to returning all properties.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
     */
    public Builder addProjection(
        int index, com.google.datastore.v1.Projection.Builder builderForValue) {
      if (projectionBuilder_ == null) {
        ensureProjectionIsMutable();
        projection_.add(index, builderForValue.build());
        onChanged();
      } else {
        projectionBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The projection to return. Defaults to returning all properties.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
     */
    public Builder addAllProjection(
        java.lang.Iterable<? extends com.google.datastore.v1.Projection> values) {
      if (projectionBuilder_ == null) {
        ensureProjectionIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, projection_);
        onChanged();
      } else {
        projectionBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The projection to return. Defaults to returning all properties.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
     */
    public Builder clearProjection() {
      if (projectionBuilder_ == null) {
        projection_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        projectionBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The projection to return. Defaults to returning all properties.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
     */
    public Builder removeProjection(int index) {
      if (projectionBuilder_ == null) {
        ensureProjectionIsMutable();
        projection_.remove(index);
        onChanged();
      } else {
        projectionBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The projection to return. Defaults to returning all properties.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
     */
    public com.google.datastore.v1.Projection.Builder getProjectionBuilder(int index) {
      return getProjectionFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The projection to return. Defaults to returning all properties.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
     */
    public com.google.datastore.v1.ProjectionOrBuilder getProjectionOrBuilder(int index) {
      if (projectionBuilder_ == null) {
        return projection_.get(index);
      } else {
        return projectionBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The projection to return. Defaults to returning all properties.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
     */
    public java.util.List<? extends com.google.datastore.v1.ProjectionOrBuilder>
        getProjectionOrBuilderList() {
      if (projectionBuilder_ != null) {
        return projectionBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(projection_);
      }
    }

    /**
     *
     *
     * <pre>
     * The projection to return. Defaults to returning all properties.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
     */
    public com.google.datastore.v1.Projection.Builder addProjectionBuilder() {
      return getProjectionFieldBuilder()
          .addBuilder(com.google.datastore.v1.Projection.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The projection to return. Defaults to returning all properties.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
     */
    public com.google.datastore.v1.Projection.Builder addProjectionBuilder(int index) {
      return getProjectionFieldBuilder()
          .addBuilder(index, com.google.datastore.v1.Projection.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The projection to return. Defaults to returning all properties.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Projection projection = 2;</code>
     */
    public java.util.List<com.google.datastore.v1.Projection.Builder> getProjectionBuilderList() {
      return getProjectionFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.Projection,
            com.google.datastore.v1.Projection.Builder,
            com.google.datastore.v1.ProjectionOrBuilder>
        getProjectionFieldBuilder() {
      if (projectionBuilder_ == null) {
        projectionBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.datastore.v1.Projection,
                com.google.datastore.v1.Projection.Builder,
                com.google.datastore.v1.ProjectionOrBuilder>(
                projection_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        projection_ = null;
      }
      return projectionBuilder_;
    }

    private java.util.List<com.google.datastore.v1.KindExpression> kind_ =
        java.util.Collections.emptyList();

    private void ensureKindIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        kind_ = new java.util.ArrayList<com.google.datastore.v1.KindExpression>(kind_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.KindExpression,
            com.google.datastore.v1.KindExpression.Builder,
            com.google.datastore.v1.KindExpressionOrBuilder>
        kindBuilder_;

    /**
     *
     *
     * <pre>
     * The kinds to query (if empty, returns entities of all kinds).
     * Currently at most 1 kind may be specified.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
     */
    public java.util.List<com.google.datastore.v1.KindExpression> getKindList() {
      if (kindBuilder_ == null) {
        return java.util.Collections.unmodifiableList(kind_);
      } else {
        return kindBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The kinds to query (if empty, returns entities of all kinds).
     * Currently at most 1 kind may be specified.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
     */
    public int getKindCount() {
      if (kindBuilder_ == null) {
        return kind_.size();
      } else {
        return kindBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The kinds to query (if empty, returns entities of all kinds).
     * Currently at most 1 kind may be specified.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
     */
    public com.google.datastore.v1.KindExpression getKind(int index) {
      if (kindBuilder_ == null) {
        return kind_.get(index);
      } else {
        return kindBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The kinds to query (if empty, returns entities of all kinds).
     * Currently at most 1 kind may be specified.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
     */
    public Builder setKind(int index, com.google.datastore.v1.KindExpression value) {
      if (kindBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureKindIsMutable();
        kind_.set(index, value);
        onChanged();
      } else {
        kindBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The kinds to query (if empty, returns entities of all kinds).
     * Currently at most 1 kind may be specified.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
     */
    public Builder setKind(
        int index, com.google.datastore.v1.KindExpression.Builder builderForValue) {
      if (kindBuilder_ == null) {
        ensureKindIsMutable();
        kind_.set(index, builderForValue.build());
        onChanged();
      } else {
        kindBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The kinds to query (if empty, returns entities of all kinds).
     * Currently at most 1 kind may be specified.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
     */
    public Builder addKind(com.google.datastore.v1.KindExpression value) {
      if (kindBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureKindIsMutable();
        kind_.add(value);
        onChanged();
      } else {
        kindBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The kinds to query (if empty, returns entities of all kinds).
     * Currently at most 1 kind may be specified.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
     */
    public Builder addKind(int index, com.google.datastore.v1.KindExpression value) {
      if (kindBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureKindIsMutable();
        kind_.add(index, value);
        onChanged();
      } else {
        kindBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The kinds to query (if empty, returns entities of all kinds).
     * Currently at most 1 kind may be specified.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
     */
    public Builder addKind(com.google.datastore.v1.KindExpression.Builder builderForValue) {
      if (kindBuilder_ == null) {
        ensureKindIsMutable();
        kind_.add(builderForValue.build());
        onChanged();
      } else {
        kindBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The kinds to query (if empty, returns entities of all kinds).
     * Currently at most 1 kind may be specified.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
     */
    public Builder addKind(
        int index, com.google.datastore.v1.KindExpression.Builder builderForValue) {
      if (kindBuilder_ == null) {
        ensureKindIsMutable();
        kind_.add(index, builderForValue.build());
        onChanged();
      } else {
        kindBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The kinds to query (if empty, returns entities of all kinds).
     * Currently at most 1 kind may be specified.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
     */
    public Builder addAllKind(
        java.lang.Iterable<? extends com.google.datastore.v1.KindExpression> values) {
      if (kindBuilder_ == null) {
        ensureKindIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, kind_);
        onChanged();
      } else {
        kindBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The kinds to query (if empty, returns entities of all kinds).
     * Currently at most 1 kind may be specified.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
     */
    public Builder clearKind() {
      if (kindBuilder_ == null) {
        kind_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        kindBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The kinds to query (if empty, returns entities of all kinds).
     * Currently at most 1 kind may be specified.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
     */
    public Builder removeKind(int index) {
      if (kindBuilder_ == null) {
        ensureKindIsMutable();
        kind_.remove(index);
        onChanged();
      } else {
        kindBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The kinds to query (if empty, returns entities of all kinds).
     * Currently at most 1 kind may be specified.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
     */
    public com.google.datastore.v1.KindExpression.Builder getKindBuilder(int index) {
      return getKindFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The kinds to query (if empty, returns entities of all kinds).
     * Currently at most 1 kind may be specified.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
     */
    public com.google.datastore.v1.KindExpressionOrBuilder getKindOrBuilder(int index) {
      if (kindBuilder_ == null) {
        return kind_.get(index);
      } else {
        return kindBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The kinds to query (if empty, returns entities of all kinds).
     * Currently at most 1 kind may be specified.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
     */
    public java.util.List<? extends com.google.datastore.v1.KindExpressionOrBuilder>
        getKindOrBuilderList() {
      if (kindBuilder_ != null) {
        return kindBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(kind_);
      }
    }

    /**
     *
     *
     * <pre>
     * The kinds to query (if empty, returns entities of all kinds).
     * Currently at most 1 kind may be specified.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
     */
    public com.google.datastore.v1.KindExpression.Builder addKindBuilder() {
      return getKindFieldBuilder()
          .addBuilder(com.google.datastore.v1.KindExpression.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The kinds to query (if empty, returns entities of all kinds).
     * Currently at most 1 kind may be specified.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
     */
    public com.google.datastore.v1.KindExpression.Builder addKindBuilder(int index) {
      return getKindFieldBuilder()
          .addBuilder(index, com.google.datastore.v1.KindExpression.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The kinds to query (if empty, returns entities of all kinds).
     * Currently at most 1 kind may be specified.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.KindExpression kind = 3;</code>
     */
    public java.util.List<com.google.datastore.v1.KindExpression.Builder> getKindBuilderList() {
      return getKindFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.KindExpression,
            com.google.datastore.v1.KindExpression.Builder,
            com.google.datastore.v1.KindExpressionOrBuilder>
        getKindFieldBuilder() {
      if (kindBuilder_ == null) {
        kindBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.datastore.v1.KindExpression,
                com.google.datastore.v1.KindExpression.Builder,
                com.google.datastore.v1.KindExpressionOrBuilder>(
                kind_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        kind_ = null;
      }
      return kindBuilder_;
    }

    private com.google.datastore.v1.Filter filter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Filter,
            com.google.datastore.v1.Filter.Builder,
            com.google.datastore.v1.FilterOrBuilder>
        filterBuilder_;

    /**
     *
     *
     * <pre>
     * The filter to apply.
     * </pre>
     *
     * <code>.google.datastore.v1.Filter filter = 4;</code>
     *
     * @return Whether the filter field is set.
     */
    public boolean hasFilter() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The filter to apply.
     * </pre>
     *
     * <code>.google.datastore.v1.Filter filter = 4;</code>
     *
     * @return The filter.
     */
    public com.google.datastore.v1.Filter getFilter() {
      if (filterBuilder_ == null) {
        return filter_ == null ? com.google.datastore.v1.Filter.getDefaultInstance() : filter_;
      } else {
        return filterBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The filter to apply.
     * </pre>
     *
     * <code>.google.datastore.v1.Filter filter = 4;</code>
     */
    public Builder setFilter(com.google.datastore.v1.Filter value) {
      if (filterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
      } else {
        filterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The filter to apply.
     * </pre>
     *
     * <code>.google.datastore.v1.Filter filter = 4;</code>
     */
    public Builder setFilter(com.google.datastore.v1.Filter.Builder builderForValue) {
      if (filterBuilder_ == null) {
        filter_ = builderForValue.build();
      } else {
        filterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The filter to apply.
     * </pre>
     *
     * <code>.google.datastore.v1.Filter filter = 4;</code>
     */
    public Builder mergeFilter(com.google.datastore.v1.Filter value) {
      if (filterBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && filter_ != null
            && filter_ != com.google.datastore.v1.Filter.getDefaultInstance()) {
          getFilterBuilder().mergeFrom(value);
        } else {
          filter_ = value;
        }
      } else {
        filterBuilder_.mergeFrom(value);
      }
      if (filter_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The filter to apply.
     * </pre>
     *
     * <code>.google.datastore.v1.Filter filter = 4;</code>
     */
    public Builder clearFilter() {
      bitField0_ = (bitField0_ & ~0x00000004);
      filter_ = null;
      if (filterBuilder_ != null) {
        filterBuilder_.dispose();
        filterBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The filter to apply.
     * </pre>
     *
     * <code>.google.datastore.v1.Filter filter = 4;</code>
     */
    public com.google.datastore.v1.Filter.Builder getFilterBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getFilterFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The filter to apply.
     * </pre>
     *
     * <code>.google.datastore.v1.Filter filter = 4;</code>
     */
    public com.google.datastore.v1.FilterOrBuilder getFilterOrBuilder() {
      if (filterBuilder_ != null) {
        return filterBuilder_.getMessageOrBuilder();
      } else {
        return filter_ == null ? com.google.datastore.v1.Filter.getDefaultInstance() : filter_;
      }
    }

    /**
     *
     *
     * <pre>
     * The filter to apply.
     * </pre>
     *
     * <code>.google.datastore.v1.Filter filter = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Filter,
            com.google.datastore.v1.Filter.Builder,
            com.google.datastore.v1.FilterOrBuilder>
        getFilterFieldBuilder() {
      if (filterBuilder_ == null) {
        filterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.Filter,
                com.google.datastore.v1.Filter.Builder,
                com.google.datastore.v1.FilterOrBuilder>(
                getFilter(), getParentForChildren(), isClean());
        filter_ = null;
      }
      return filterBuilder_;
    }

    private java.util.List<com.google.datastore.v1.PropertyOrder> order_ =
        java.util.Collections.emptyList();

    private void ensureOrderIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        order_ = new java.util.ArrayList<com.google.datastore.v1.PropertyOrder>(order_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.PropertyOrder,
            com.google.datastore.v1.PropertyOrder.Builder,
            com.google.datastore.v1.PropertyOrderOrBuilder>
        orderBuilder_;

    /**
     *
     *
     * <pre>
     * The order to apply to the query results (if empty, order is unspecified).
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
     */
    public java.util.List<com.google.datastore.v1.PropertyOrder> getOrderList() {
      if (orderBuilder_ == null) {
        return java.util.Collections.unmodifiableList(order_);
      } else {
        return orderBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The order to apply to the query results (if empty, order is unspecified).
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
     */
    public int getOrderCount() {
      if (orderBuilder_ == null) {
        return order_.size();
      } else {
        return orderBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The order to apply to the query results (if empty, order is unspecified).
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
     */
    public com.google.datastore.v1.PropertyOrder getOrder(int index) {
      if (orderBuilder_ == null) {
        return order_.get(index);
      } else {
        return orderBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The order to apply to the query results (if empty, order is unspecified).
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
     */
    public Builder setOrder(int index, com.google.datastore.v1.PropertyOrder value) {
      if (orderBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOrderIsMutable();
        order_.set(index, value);
        onChanged();
      } else {
        orderBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The order to apply to the query results (if empty, order is unspecified).
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
     */
    public Builder setOrder(
        int index, com.google.datastore.v1.PropertyOrder.Builder builderForValue) {
      if (orderBuilder_ == null) {
        ensureOrderIsMutable();
        order_.set(index, builderForValue.build());
        onChanged();
      } else {
        orderBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The order to apply to the query results (if empty, order is unspecified).
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
     */
    public Builder addOrder(com.google.datastore.v1.PropertyOrder value) {
      if (orderBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOrderIsMutable();
        order_.add(value);
        onChanged();
      } else {
        orderBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The order to apply to the query results (if empty, order is unspecified).
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
     */
    public Builder addOrder(int index, com.google.datastore.v1.PropertyOrder value) {
      if (orderBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureOrderIsMutable();
        order_.add(index, value);
        onChanged();
      } else {
        orderBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The order to apply to the query results (if empty, order is unspecified).
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
     */
    public Builder addOrder(com.google.datastore.v1.PropertyOrder.Builder builderForValue) {
      if (orderBuilder_ == null) {
        ensureOrderIsMutable();
        order_.add(builderForValue.build());
        onChanged();
      } else {
        orderBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The order to apply to the query results (if empty, order is unspecified).
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
     */
    public Builder addOrder(
        int index, com.google.datastore.v1.PropertyOrder.Builder builderForValue) {
      if (orderBuilder_ == null) {
        ensureOrderIsMutable();
        order_.add(index, builderForValue.build());
        onChanged();
      } else {
        orderBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The order to apply to the query results (if empty, order is unspecified).
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
     */
    public Builder addAllOrder(
        java.lang.Iterable<? extends com.google.datastore.v1.PropertyOrder> values) {
      if (orderBuilder_ == null) {
        ensureOrderIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, order_);
        onChanged();
      } else {
        orderBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The order to apply to the query results (if empty, order is unspecified).
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
     */
    public Builder clearOrder() {
      if (orderBuilder_ == null) {
        order_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        orderBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The order to apply to the query results (if empty, order is unspecified).
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
     */
    public Builder removeOrder(int index) {
      if (orderBuilder_ == null) {
        ensureOrderIsMutable();
        order_.remove(index);
        onChanged();
      } else {
        orderBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The order to apply to the query results (if empty, order is unspecified).
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
     */
    public com.google.datastore.v1.PropertyOrder.Builder getOrderBuilder(int index) {
      return getOrderFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The order to apply to the query results (if empty, order is unspecified).
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
     */
    public com.google.datastore.v1.PropertyOrderOrBuilder getOrderOrBuilder(int index) {
      if (orderBuilder_ == null) {
        return order_.get(index);
      } else {
        return orderBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The order to apply to the query results (if empty, order is unspecified).
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
     */
    public java.util.List<? extends com.google.datastore.v1.PropertyOrderOrBuilder>
        getOrderOrBuilderList() {
      if (orderBuilder_ != null) {
        return orderBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(order_);
      }
    }

    /**
     *
     *
     * <pre>
     * The order to apply to the query results (if empty, order is unspecified).
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
     */
    public com.google.datastore.v1.PropertyOrder.Builder addOrderBuilder() {
      return getOrderFieldBuilder()
          .addBuilder(com.google.datastore.v1.PropertyOrder.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The order to apply to the query results (if empty, order is unspecified).
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
     */
    public com.google.datastore.v1.PropertyOrder.Builder addOrderBuilder(int index) {
      return getOrderFieldBuilder()
          .addBuilder(index, com.google.datastore.v1.PropertyOrder.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The order to apply to the query results (if empty, order is unspecified).
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyOrder order = 5;</code>
     */
    public java.util.List<com.google.datastore.v1.PropertyOrder.Builder> getOrderBuilderList() {
      return getOrderFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.PropertyOrder,
            com.google.datastore.v1.PropertyOrder.Builder,
            com.google.datastore.v1.PropertyOrderOrBuilder>
        getOrderFieldBuilder() {
      if (orderBuilder_ == null) {
        orderBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.datastore.v1.PropertyOrder,
                com.google.datastore.v1.PropertyOrder.Builder,
                com.google.datastore.v1.PropertyOrderOrBuilder>(
                order_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        order_ = null;
      }
      return orderBuilder_;
    }

    private java.util.List<com.google.datastore.v1.PropertyReference> distinctOn_ =
        java.util.Collections.emptyList();

    private void ensureDistinctOnIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        distinctOn_ =
            new java.util.ArrayList<com.google.datastore.v1.PropertyReference>(distinctOn_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.PropertyReference,
            com.google.datastore.v1.PropertyReference.Builder,
            com.google.datastore.v1.PropertyReferenceOrBuilder>
        distinctOnBuilder_;

    /**
     *
     *
     * <pre>
     * The properties to make distinct. The query results will contain the first
     * result for each distinct combination of values for the given properties
     * (if empty, all results are returned).
     *
     * Requires:
     *
     * * If `order` is specified, the set of distinct on properties must appear
     * before the non-distinct on properties in `order`.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
     */
    public java.util.List<com.google.datastore.v1.PropertyReference> getDistinctOnList() {
      if (distinctOnBuilder_ == null) {
        return java.util.Collections.unmodifiableList(distinctOn_);
      } else {
        return distinctOnBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The properties to make distinct. The query results will contain the first
     * result for each distinct combination of values for the given properties
     * (if empty, all results are returned).
     *
     * Requires:
     *
     * * If `order` is specified, the set of distinct on properties must appear
     * before the non-distinct on properties in `order`.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
     */
    public int getDistinctOnCount() {
      if (distinctOnBuilder_ == null) {
        return distinctOn_.size();
      } else {
        return distinctOnBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The properties to make distinct. The query results will contain the first
     * result for each distinct combination of values for the given properties
     * (if empty, all results are returned).
     *
     * Requires:
     *
     * * If `order` is specified, the set of distinct on properties must appear
     * before the non-distinct on properties in `order`.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
     */
    public com.google.datastore.v1.PropertyReference getDistinctOn(int index) {
      if (distinctOnBuilder_ == null) {
        return distinctOn_.get(index);
      } else {
        return distinctOnBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The properties to make distinct. The query results will contain the first
     * result for each distinct combination of values for the given properties
     * (if empty, all results are returned).
     *
     * Requires:
     *
     * * If `order` is specified, the set of distinct on properties must appear
     * before the non-distinct on properties in `order`.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
     */
    public Builder setDistinctOn(int index, com.google.datastore.v1.PropertyReference value) {
      if (distinctOnBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDistinctOnIsMutable();
        distinctOn_.set(index, value);
        onChanged();
      } else {
        distinctOnBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The properties to make distinct. The query results will contain the first
     * result for each distinct combination of values for the given properties
     * (if empty, all results are returned).
     *
     * Requires:
     *
     * * If `order` is specified, the set of distinct on properties must appear
     * before the non-distinct on properties in `order`.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
     */
    public Builder setDistinctOn(
        int index, com.google.datastore.v1.PropertyReference.Builder builderForValue) {
      if (distinctOnBuilder_ == null) {
        ensureDistinctOnIsMutable();
        distinctOn_.set(index, builderForValue.build());
        onChanged();
      } else {
        distinctOnBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The properties to make distinct. The query results will contain the first
     * result for each distinct combination of values for the given properties
     * (if empty, all results are returned).
     *
     * Requires:
     *
     * * If `order` is specified, the set of distinct on properties must appear
     * before the non-distinct on properties in `order`.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
     */
    public Builder addDistinctOn(com.google.datastore.v1.PropertyReference value) {
      if (distinctOnBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDistinctOnIsMutable();
        distinctOn_.add(value);
        onChanged();
      } else {
        distinctOnBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The properties to make distinct. The query results will contain the first
     * result for each distinct combination of values for the given properties
     * (if empty, all results are returned).
     *
     * Requires:
     *
     * * If `order` is specified, the set of distinct on properties must appear
     * before the non-distinct on properties in `order`.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
     */
    public Builder addDistinctOn(int index, com.google.datastore.v1.PropertyReference value) {
      if (distinctOnBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDistinctOnIsMutable();
        distinctOn_.add(index, value);
        onChanged();
      } else {
        distinctOnBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The properties to make distinct. The query results will contain the first
     * result for each distinct combination of values for the given properties
     * (if empty, all results are returned).
     *
     * Requires:
     *
     * * If `order` is specified, the set of distinct on properties must appear
     * before the non-distinct on properties in `order`.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
     */
    public Builder addDistinctOn(
        com.google.datastore.v1.PropertyReference.Builder builderForValue) {
      if (distinctOnBuilder_ == null) {
        ensureDistinctOnIsMutable();
        distinctOn_.add(builderForValue.build());
        onChanged();
      } else {
        distinctOnBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The properties to make distinct. The query results will contain the first
     * result for each distinct combination of values for the given properties
     * (if empty, all results are returned).
     *
     * Requires:
     *
     * * If `order` is specified, the set of distinct on properties must appear
     * before the non-distinct on properties in `order`.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
     */
    public Builder addDistinctOn(
        int index, com.google.datastore.v1.PropertyReference.Builder builderForValue) {
      if (distinctOnBuilder_ == null) {
        ensureDistinctOnIsMutable();
        distinctOn_.add(index, builderForValue.build());
        onChanged();
      } else {
        distinctOnBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The properties to make distinct. The query results will contain the first
     * result for each distinct combination of values for the given properties
     * (if empty, all results are returned).
     *
     * Requires:
     *
     * * If `order` is specified, the set of distinct on properties must appear
     * before the non-distinct on properties in `order`.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
     */
    public Builder addAllDistinctOn(
        java.lang.Iterable<? extends com.google.datastore.v1.PropertyReference> values) {
      if (distinctOnBuilder_ == null) {
        ensureDistinctOnIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, distinctOn_);
        onChanged();
      } else {
        distinctOnBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The properties to make distinct. The query results will contain the first
     * result for each distinct combination of values for the given properties
     * (if empty, all results are returned).
     *
     * Requires:
     *
     * * If `order` is specified, the set of distinct on properties must appear
     * before the non-distinct on properties in `order`.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
     */
    public Builder clearDistinctOn() {
      if (distinctOnBuilder_ == null) {
        distinctOn_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        distinctOnBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The properties to make distinct. The query results will contain the first
     * result for each distinct combination of values for the given properties
     * (if empty, all results are returned).
     *
     * Requires:
     *
     * * If `order` is specified, the set of distinct on properties must appear
     * before the non-distinct on properties in `order`.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
     */
    public Builder removeDistinctOn(int index) {
      if (distinctOnBuilder_ == null) {
        ensureDistinctOnIsMutable();
        distinctOn_.remove(index);
        onChanged();
      } else {
        distinctOnBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The properties to make distinct. The query results will contain the first
     * result for each distinct combination of values for the given properties
     * (if empty, all results are returned).
     *
     * Requires:
     *
     * * If `order` is specified, the set of distinct on properties must appear
     * before the non-distinct on properties in `order`.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
     */
    public com.google.datastore.v1.PropertyReference.Builder getDistinctOnBuilder(int index) {
      return getDistinctOnFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The properties to make distinct. The query results will contain the first
     * result for each distinct combination of values for the given properties
     * (if empty, all results are returned).
     *
     * Requires:
     *
     * * If `order` is specified, the set of distinct on properties must appear
     * before the non-distinct on properties in `order`.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
     */
    public com.google.datastore.v1.PropertyReferenceOrBuilder getDistinctOnOrBuilder(int index) {
      if (distinctOnBuilder_ == null) {
        return distinctOn_.get(index);
      } else {
        return distinctOnBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The properties to make distinct. The query results will contain the first
     * result for each distinct combination of values for the given properties
     * (if empty, all results are returned).
     *
     * Requires:
     *
     * * If `order` is specified, the set of distinct on properties must appear
     * before the non-distinct on properties in `order`.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
     */
    public java.util.List<? extends com.google.datastore.v1.PropertyReferenceOrBuilder>
        getDistinctOnOrBuilderList() {
      if (distinctOnBuilder_ != null) {
        return distinctOnBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(distinctOn_);
      }
    }

    /**
     *
     *
     * <pre>
     * The properties to make distinct. The query results will contain the first
     * result for each distinct combination of values for the given properties
     * (if empty, all results are returned).
     *
     * Requires:
     *
     * * If `order` is specified, the set of distinct on properties must appear
     * before the non-distinct on properties in `order`.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
     */
    public com.google.datastore.v1.PropertyReference.Builder addDistinctOnBuilder() {
      return getDistinctOnFieldBuilder()
          .addBuilder(com.google.datastore.v1.PropertyReference.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The properties to make distinct. The query results will contain the first
     * result for each distinct combination of values for the given properties
     * (if empty, all results are returned).
     *
     * Requires:
     *
     * * If `order` is specified, the set of distinct on properties must appear
     * before the non-distinct on properties in `order`.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
     */
    public com.google.datastore.v1.PropertyReference.Builder addDistinctOnBuilder(int index) {
      return getDistinctOnFieldBuilder()
          .addBuilder(index, com.google.datastore.v1.PropertyReference.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The properties to make distinct. The query results will contain the first
     * result for each distinct combination of values for the given properties
     * (if empty, all results are returned).
     *
     * Requires:
     *
     * * If `order` is specified, the set of distinct on properties must appear
     * before the non-distinct on properties in `order`.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.PropertyReference distinct_on = 6;</code>
     */
    public java.util.List<com.google.datastore.v1.PropertyReference.Builder>
        getDistinctOnBuilderList() {
      return getDistinctOnFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.PropertyReference,
            com.google.datastore.v1.PropertyReference.Builder,
            com.google.datastore.v1.PropertyReferenceOrBuilder>
        getDistinctOnFieldBuilder() {
      if (distinctOnBuilder_ == null) {
        distinctOnBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.datastore.v1.PropertyReference,
                com.google.datastore.v1.PropertyReference.Builder,
                com.google.datastore.v1.PropertyReferenceOrBuilder>(
                distinctOn_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        distinctOn_ = null;
      }
      return distinctOnBuilder_;
    }

    private com.google.protobuf.ByteString startCursor_ = com.google.protobuf.ByteString.EMPTY;

    /**
     *
     *
     * <pre>
     * A starting point for the query results. Query cursors are
     * returned in query result batches and
     * [can only be used to continue the same
     * query](https://cloud.google.com/datastore/docs/concepts/queries#cursors_limits_and_offsets).
     * </pre>
     *
     * <code>bytes start_cursor = 7;</code>
     *
     * @return The startCursor.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStartCursor() {
      return startCursor_;
    }

    /**
     *
     *
     * <pre>
     * A starting point for the query results. Query cursors are
     * returned in query result batches and
     * [can only be used to continue the same
     * query](https://cloud.google.com/datastore/docs/concepts/queries#cursors_limits_and_offsets).
     * </pre>
     *
     * <code>bytes start_cursor = 7;</code>
     *
     * @param value The startCursor to set.
     * @return This builder for chaining.
     */
    public Builder setStartCursor(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      startCursor_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A starting point for the query results. Query cursors are
     * returned in query result batches and
     * [can only be used to continue the same
     * query](https://cloud.google.com/datastore/docs/concepts/queries#cursors_limits_and_offsets).
     * </pre>
     *
     * <code>bytes start_cursor = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStartCursor() {
      bitField0_ = (bitField0_ & ~0x00000020);
      startCursor_ = getDefaultInstance().getStartCursor();
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString endCursor_ = com.google.protobuf.ByteString.EMPTY;

    /**
     *
     *
     * <pre>
     * An ending point for the query results. Query cursors are
     * returned in query result batches and
     * [can only be used to limit the same
     * query](https://cloud.google.com/datastore/docs/concepts/queries#cursors_limits_and_offsets).
     * </pre>
     *
     * <code>bytes end_cursor = 8;</code>
     *
     * @return The endCursor.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEndCursor() {
      return endCursor_;
    }

    /**
     *
     *
     * <pre>
     * An ending point for the query results. Query cursors are
     * returned in query result batches and
     * [can only be used to limit the same
     * query](https://cloud.google.com/datastore/docs/concepts/queries#cursors_limits_and_offsets).
     * </pre>
     *
     * <code>bytes end_cursor = 8;</code>
     *
     * @param value The endCursor to set.
     * @return This builder for chaining.
     */
    public Builder setEndCursor(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      endCursor_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An ending point for the query results. Query cursors are
     * returned in query result batches and
     * [can only be used to limit the same
     * query](https://cloud.google.com/datastore/docs/concepts/queries#cursors_limits_and_offsets).
     * </pre>
     *
     * <code>bytes end_cursor = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndCursor() {
      bitField0_ = (bitField0_ & ~0x00000040);
      endCursor_ = getDefaultInstance().getEndCursor();
      onChanged();
      return this;
    }

    private int offset_;

    /**
     *
     *
     * <pre>
     * The number of results to skip. Applies before limit, but after all other
     * constraints. Optional. Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>int32 offset = 10;</code>
     *
     * @return The offset.
     */
    @java.lang.Override
    public int getOffset() {
      return offset_;
    }

    /**
     *
     *
     * <pre>
     * The number of results to skip. Applies before limit, but after all other
     * constraints. Optional. Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>int32 offset = 10;</code>
     *
     * @param value The offset to set.
     * @return This builder for chaining.
     */
    public Builder setOffset(int value) {

      offset_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The number of results to skip. Applies before limit, but after all other
     * constraints. Optional. Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>int32 offset = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOffset() {
      bitField0_ = (bitField0_ & ~0x00000080);
      offset_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Int32Value limit_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int32Value,
            com.google.protobuf.Int32Value.Builder,
            com.google.protobuf.Int32ValueOrBuilder>
        limitBuilder_;

    /**
     *
     *
     * <pre>
     * The maximum number of results to return. Applies after all other
     * constraints. Optional.
     * Unspecified is interpreted as no limit.
     * Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 12;</code>
     *
     * @return Whether the limit field is set.
     */
    public boolean hasLimit() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * The maximum number of results to return. Applies after all other
     * constraints. Optional.
     * Unspecified is interpreted as no limit.
     * Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 12;</code>
     *
     * @return The limit.
     */
    public com.google.protobuf.Int32Value getLimit() {
      if (limitBuilder_ == null) {
        return limit_ == null ? com.google.protobuf.Int32Value.getDefaultInstance() : limit_;
      } else {
        return limitBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The maximum number of results to return. Applies after all other
     * constraints. Optional.
     * Unspecified is interpreted as no limit.
     * Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 12;</code>
     */
    public Builder setLimit(com.google.protobuf.Int32Value value) {
      if (limitBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        limit_ = value;
      } else {
        limitBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The maximum number of results to return. Applies after all other
     * constraints. Optional.
     * Unspecified is interpreted as no limit.
     * Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 12;</code>
     */
    public Builder setLimit(com.google.protobuf.Int32Value.Builder builderForValue) {
      if (limitBuilder_ == null) {
        limit_ = builderForValue.build();
      } else {
        limitBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The maximum number of results to return. Applies after all other
     * constraints. Optional.
     * Unspecified is interpreted as no limit.
     * Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 12;</code>
     */
    public Builder mergeLimit(com.google.protobuf.Int32Value value) {
      if (limitBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && limit_ != null
            && limit_ != com.google.protobuf.Int32Value.getDefaultInstance()) {
          getLimitBuilder().mergeFrom(value);
        } else {
          limit_ = value;
        }
      } else {
        limitBuilder_.mergeFrom(value);
      }
      if (limit_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The maximum number of results to return. Applies after all other
     * constraints. Optional.
     * Unspecified is interpreted as no limit.
     * Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 12;</code>
     */
    public Builder clearLimit() {
      bitField0_ = (bitField0_ & ~0x00000100);
      limit_ = null;
      if (limitBuilder_ != null) {
        limitBuilder_.dispose();
        limitBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The maximum number of results to return. Applies after all other
     * constraints. Optional.
     * Unspecified is interpreted as no limit.
     * Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 12;</code>
     */
    public com.google.protobuf.Int32Value.Builder getLimitBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getLimitFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The maximum number of results to return. Applies after all other
     * constraints. Optional.
     * Unspecified is interpreted as no limit.
     * Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 12;</code>
     */
    public com.google.protobuf.Int32ValueOrBuilder getLimitOrBuilder() {
      if (limitBuilder_ != null) {
        return limitBuilder_.getMessageOrBuilder();
      } else {
        return limit_ == null ? com.google.protobuf.Int32Value.getDefaultInstance() : limit_;
      }
    }

    /**
     *
     *
     * <pre>
     * The maximum number of results to return. Applies after all other
     * constraints. Optional.
     * Unspecified is interpreted as no limit.
     * Must be &gt;= 0 if specified.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value limit = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int32Value,
            com.google.protobuf.Int32Value.Builder,
            com.google.protobuf.Int32ValueOrBuilder>
        getLimitFieldBuilder() {
      if (limitBuilder_ == null) {
        limitBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int32Value,
                com.google.protobuf.Int32Value.Builder,
                com.google.protobuf.Int32ValueOrBuilder>(
                getLimit(), getParentForChildren(), isClean());
        limit_ = null;
      }
      return limitBuilder_;
    }

    private com.google.datastore.v1.FindNearest findNearest_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.FindNearest,
            com.google.datastore.v1.FindNearest.Builder,
            com.google.datastore.v1.FindNearestOrBuilder>
        findNearestBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A potential Nearest Neighbors Search.
     *
     * Applies after all other filters and ordering.
     *
     * Finds the closest vector embeddings to the given query vector.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.FindNearest find_nearest = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the findNearest field is set.
     */
    public boolean hasFindNearest() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. A potential Nearest Neighbors Search.
     *
     * Applies after all other filters and ordering.
     *
     * Finds the closest vector embeddings to the given query vector.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.FindNearest find_nearest = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The findNearest.
     */
    public com.google.datastore.v1.FindNearest getFindNearest() {
      if (findNearestBuilder_ == null) {
        return findNearest_ == null
            ? com.google.datastore.v1.FindNearest.getDefaultInstance()
            : findNearest_;
      } else {
        return findNearestBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A potential Nearest Neighbors Search.
     *
     * Applies after all other filters and ordering.
     *
     * Finds the closest vector embeddings to the given query vector.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.FindNearest find_nearest = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFindNearest(com.google.datastore.v1.FindNearest value) {
      if (findNearestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        findNearest_ = value;
      } else {
        findNearestBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A potential Nearest Neighbors Search.
     *
     * Applies after all other filters and ordering.
     *
     * Finds the closest vector embeddings to the given query vector.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.FindNearest find_nearest = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFindNearest(com.google.datastore.v1.FindNearest.Builder builderForValue) {
      if (findNearestBuilder_ == null) {
        findNearest_ = builderForValue.build();
      } else {
        findNearestBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A potential Nearest Neighbors Search.
     *
     * Applies after all other filters and ordering.
     *
     * Finds the closest vector embeddings to the given query vector.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.FindNearest find_nearest = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeFindNearest(com.google.datastore.v1.FindNearest value) {
      if (findNearestBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && findNearest_ != null
            && findNearest_ != com.google.datastore.v1.FindNearest.getDefaultInstance()) {
          getFindNearestBuilder().mergeFrom(value);
        } else {
          findNearest_ = value;
        }
      } else {
        findNearestBuilder_.mergeFrom(value);
      }
      if (findNearest_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A potential Nearest Neighbors Search.
     *
     * Applies after all other filters and ordering.
     *
     * Finds the closest vector embeddings to the given query vector.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.FindNearest find_nearest = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFindNearest() {
      bitField0_ = (bitField0_ & ~0x00000200);
      findNearest_ = null;
      if (findNearestBuilder_ != null) {
        findNearestBuilder_.dispose();
        findNearestBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A potential Nearest Neighbors Search.
     *
     * Applies after all other filters and ordering.
     *
     * Finds the closest vector embeddings to the given query vector.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.FindNearest find_nearest = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.datastore.v1.FindNearest.Builder getFindNearestBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getFindNearestFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. A potential Nearest Neighbors Search.
     *
     * Applies after all other filters and ordering.
     *
     * Finds the closest vector embeddings to the given query vector.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.FindNearest find_nearest = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.datastore.v1.FindNearestOrBuilder getFindNearestOrBuilder() {
      if (findNearestBuilder_ != null) {
        return findNearestBuilder_.getMessageOrBuilder();
      } else {
        return findNearest_ == null
            ? com.google.datastore.v1.FindNearest.getDefaultInstance()
            : findNearest_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A potential Nearest Neighbors Search.
     *
     * Applies after all other filters and ordering.
     *
     * Finds the closest vector embeddings to the given query vector.
     * </pre>
     *
     * <code>
     * .google.datastore.v1.FindNearest find_nearest = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.FindNearest,
            com.google.datastore.v1.FindNearest.Builder,
            com.google.datastore.v1.FindNearestOrBuilder>
        getFindNearestFieldBuilder() {
      if (findNearestBuilder_ == null) {
        findNearestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.FindNearest,
                com.google.datastore.v1.FindNearest.Builder,
                com.google.datastore.v1.FindNearestOrBuilder>(
                getFindNearest(), getParentForChildren(), isClean());
        findNearest_ = null;
      }
      return findNearestBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.datastore.v1.Query)
  }

  // @@protoc_insertion_point(class_scope:google.datastore.v1.Query)
  private static final com.google.datastore.v1.Query DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.datastore.v1.Query();
  }

  public static com.google.datastore.v1.Query getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Query> PARSER =
      new com.google.protobuf.AbstractParser<Query>() {
        @java.lang.Override
        public Query parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Query> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Query> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.datastore.v1.Query getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
