/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/v1/datastore.proto

package com.google.datastore.v1;

/**
 *
 *
 * <pre>
 * The request for [Datastore.Commit][google.datastore.v1.Datastore.Commit].
 * </pre>
 *
 * Protobuf type {@code google.datastore.v1.CommitRequest}
 */
public final class CommitRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.datastore.v1.CommitRequest)
    CommitRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CommitRequest.newBuilder() to construct.
  private CommitRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CommitRequest() {
    projectId_ = "";
    mode_ = 0;
    mutations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CommitRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private CommitRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              transactionSelectorCase_ = 1;
              transactionSelector_ = input.readBytes();
              break;
            }
          case 40:
            {
              int rawValue = input.readEnum();

              mode_ = rawValue;
              break;
            }
          case 50:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                mutations_ = new java.util.ArrayList<com.google.datastore.v1.Mutation>();
                mutable_bitField0_ |= 0x00000001;
              }
              mutations_.add(
                  input.readMessage(com.google.datastore.v1.Mutation.parser(), extensionRegistry));
              break;
            }
          case 66:
            {
              java.lang.String s = input.readStringRequireUtf8();

              projectId_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        mutations_ = java.util.Collections.unmodifiableList(mutations_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.datastore.v1.DatastoreProto
        .internal_static_google_datastore_v1_CommitRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.datastore.v1.DatastoreProto
        .internal_static_google_datastore_v1_CommitRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.datastore.v1.CommitRequest.class,
            com.google.datastore.v1.CommitRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The modes available for commits.
   * </pre>
   *
   * Protobuf enum {@code google.datastore.v1.CommitRequest.Mode}
   */
  public enum Mode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified. This value must not be used.
     * </pre>
     *
     * <code>MODE_UNSPECIFIED = 0;</code>
     */
    MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Transactional: The mutations are either all applied, or none are applied.
     * Learn about transactions
     * [here](https://cloud.google.com/datastore/docs/concepts/transactions).
     * </pre>
     *
     * <code>TRANSACTIONAL = 1;</code>
     */
    TRANSACTIONAL(1),
    /**
     *
     *
     * <pre>
     * Non-transactional: The mutations may not apply as all or none.
     * </pre>
     *
     * <code>NON_TRANSACTIONAL = 2;</code>
     */
    NON_TRANSACTIONAL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified. This value must not be used.
     * </pre>
     *
     * <code>MODE_UNSPECIFIED = 0;</code>
     */
    public static final int MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Transactional: The mutations are either all applied, or none are applied.
     * Learn about transactions
     * [here](https://cloud.google.com/datastore/docs/concepts/transactions).
     * </pre>
     *
     * <code>TRANSACTIONAL = 1;</code>
     */
    public static final int TRANSACTIONAL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Non-transactional: The mutations may not apply as all or none.
     * </pre>
     *
     * <code>NON_TRANSACTIONAL = 2;</code>
     */
    public static final int NON_TRANSACTIONAL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Mode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Mode forNumber(int value) {
      switch (value) {
        case 0:
          return MODE_UNSPECIFIED;
        case 1:
          return TRANSACTIONAL;
        case 2:
          return NON_TRANSACTIONAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Mode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Mode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Mode>() {
          public Mode findValueByNumber(int number) {
            return Mode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.datastore.v1.CommitRequest.getDescriptor().getEnumTypes().get(0);
    }

    private static final Mode[] VALUES = values();

    public static Mode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Mode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.datastore.v1.CommitRequest.Mode)
  }

  private int transactionSelectorCase_ = 0;
  private java.lang.Object transactionSelector_;

  public enum TransactionSelectorCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TRANSACTION(1),
    TRANSACTIONSELECTOR_NOT_SET(0);
    private final int value;

    private TransactionSelectorCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TransactionSelectorCase valueOf(int value) {
      return forNumber(value);
    }

    public static TransactionSelectorCase forNumber(int value) {
      switch (value) {
        case 1:
          return TRANSACTION;
        case 0:
          return TRANSACTIONSELECTOR_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TransactionSelectorCase getTransactionSelectorCase() {
    return TransactionSelectorCase.forNumber(transactionSelectorCase_);
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 8;
  private volatile java.lang.Object projectId_;
  /**
   *
   *
   * <pre>
   * Required. The ID of the project against which to make the request.
   * </pre>
   *
   * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The ID of the project against which to make the request.
   * </pre>
   *
   * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODE_FIELD_NUMBER = 5;
  private int mode_;
  /**
   *
   *
   * <pre>
   * The type of commit to perform. Defaults to `TRANSACTIONAL`.
   * </pre>
   *
   * <code>.google.datastore.v1.CommitRequest.Mode mode = 5;</code>
   *
   * @return The enum numeric value on the wire for mode.
   */
  @java.lang.Override
  public int getModeValue() {
    return mode_;
  }
  /**
   *
   *
   * <pre>
   * The type of commit to perform. Defaults to `TRANSACTIONAL`.
   * </pre>
   *
   * <code>.google.datastore.v1.CommitRequest.Mode mode = 5;</code>
   *
   * @return The mode.
   */
  @java.lang.Override
  public com.google.datastore.v1.CommitRequest.Mode getMode() {
    @SuppressWarnings("deprecation")
    com.google.datastore.v1.CommitRequest.Mode result =
        com.google.datastore.v1.CommitRequest.Mode.valueOf(mode_);
    return result == null ? com.google.datastore.v1.CommitRequest.Mode.UNRECOGNIZED : result;
  }

  public static final int TRANSACTION_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * The identifier of the transaction associated with the commit. A
   * transaction identifier is returned by a call to
   * [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
   * </pre>
   *
   * <code>bytes transaction = 1;</code>
   *
   * @return Whether the transaction field is set.
   */
  @java.lang.Override
  public boolean hasTransaction() {
    return transactionSelectorCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * The identifier of the transaction associated with the commit. A
   * transaction identifier is returned by a call to
   * [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
   * </pre>
   *
   * <code>bytes transaction = 1;</code>
   *
   * @return The transaction.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTransaction() {
    if (transactionSelectorCase_ == 1) {
      return (com.google.protobuf.ByteString) transactionSelector_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int MUTATIONS_FIELD_NUMBER = 6;
  private java.util.List<com.google.datastore.v1.Mutation> mutations_;
  /**
   *
   *
   * <pre>
   * The mutations to perform.
   * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
   * applied in order. The following sequences of mutations affecting a single
   * entity are not permitted in a single `Commit` request:
   * - `insert` followed by `insert`
   * - `update` followed by `insert`
   * - `upsert` followed by `insert`
   * - `delete` followed by `update`
   * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
   * entity.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.datastore.v1.Mutation> getMutationsList() {
    return mutations_;
  }
  /**
   *
   *
   * <pre>
   * The mutations to perform.
   * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
   * applied in order. The following sequences of mutations affecting a single
   * entity are not permitted in a single `Commit` request:
   * - `insert` followed by `insert`
   * - `update` followed by `insert`
   * - `upsert` followed by `insert`
   * - `delete` followed by `update`
   * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
   * entity.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.datastore.v1.MutationOrBuilder>
      getMutationsOrBuilderList() {
    return mutations_;
  }
  /**
   *
   *
   * <pre>
   * The mutations to perform.
   * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
   * applied in order. The following sequences of mutations affecting a single
   * entity are not permitted in a single `Commit` request:
   * - `insert` followed by `insert`
   * - `update` followed by `insert`
   * - `upsert` followed by `insert`
   * - `delete` followed by `update`
   * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
   * entity.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
   */
  @java.lang.Override
  public int getMutationsCount() {
    return mutations_.size();
  }
  /**
   *
   *
   * <pre>
   * The mutations to perform.
   * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
   * applied in order. The following sequences of mutations affecting a single
   * entity are not permitted in a single `Commit` request:
   * - `insert` followed by `insert`
   * - `update` followed by `insert`
   * - `upsert` followed by `insert`
   * - `delete` followed by `update`
   * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
   * entity.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.Mutation getMutations(int index) {
    return mutations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The mutations to perform.
   * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
   * applied in order. The following sequences of mutations affecting a single
   * entity are not permitted in a single `Commit` request:
   * - `insert` followed by `insert`
   * - `update` followed by `insert`
   * - `upsert` followed by `insert`
   * - `delete` followed by `update`
   * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
   * entity.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.MutationOrBuilder getMutationsOrBuilder(int index) {
    return mutations_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (transactionSelectorCase_ == 1) {
      output.writeBytes(1, (com.google.protobuf.ByteString) transactionSelector_);
    }
    if (mode_ != com.google.datastore.v1.CommitRequest.Mode.MODE_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, mode_);
    }
    for (int i = 0; i < mutations_.size(); i++) {
      output.writeMessage(6, mutations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, projectId_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (transactionSelectorCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              1, (com.google.protobuf.ByteString) transactionSelector_);
    }
    if (mode_ != com.google.datastore.v1.CommitRequest.Mode.MODE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, mode_);
    }
    for (int i = 0; i < mutations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, mutations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, projectId_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.datastore.v1.CommitRequest)) {
      return super.equals(obj);
    }
    com.google.datastore.v1.CommitRequest other = (com.google.datastore.v1.CommitRequest) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (mode_ != other.mode_) return false;
    if (!getMutationsList().equals(other.getMutationsList())) return false;
    if (!getTransactionSelectorCase().equals(other.getTransactionSelectorCase())) return false;
    switch (transactionSelectorCase_) {
      case 1:
        if (!getTransaction().equals(other.getTransaction())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    hash = (37 * hash) + MODE_FIELD_NUMBER;
    hash = (53 * hash) + mode_;
    if (getMutationsCount() > 0) {
      hash = (37 * hash) + MUTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getMutationsList().hashCode();
    }
    switch (transactionSelectorCase_) {
      case 1:
        hash = (37 * hash) + TRANSACTION_FIELD_NUMBER;
        hash = (53 * hash) + getTransaction().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.datastore.v1.CommitRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.CommitRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.CommitRequest parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.CommitRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.CommitRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.CommitRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.CommitRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.CommitRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.CommitRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.CommitRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.CommitRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.CommitRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.datastore.v1.CommitRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for [Datastore.Commit][google.datastore.v1.Datastore.Commit].
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.CommitRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.datastore.v1.CommitRequest)
      com.google.datastore.v1.CommitRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_CommitRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_CommitRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.CommitRequest.class,
              com.google.datastore.v1.CommitRequest.Builder.class);
    }

    // Construct using com.google.datastore.v1.CommitRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMutationsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      projectId_ = "";

      mode_ = 0;

      if (mutationsBuilder_ == null) {
        mutations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        mutationsBuilder_.clear();
      }
      transactionSelectorCase_ = 0;
      transactionSelector_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_CommitRequest_descriptor;
    }

    @java.lang.Override
    public com.google.datastore.v1.CommitRequest getDefaultInstanceForType() {
      return com.google.datastore.v1.CommitRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.datastore.v1.CommitRequest build() {
      com.google.datastore.v1.CommitRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.datastore.v1.CommitRequest buildPartial() {
      com.google.datastore.v1.CommitRequest result =
          new com.google.datastore.v1.CommitRequest(this);
      int from_bitField0_ = bitField0_;
      result.projectId_ = projectId_;
      result.mode_ = mode_;
      if (transactionSelectorCase_ == 1) {
        result.transactionSelector_ = transactionSelector_;
      }
      if (mutationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          mutations_ = java.util.Collections.unmodifiableList(mutations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.mutations_ = mutations_;
      } else {
        result.mutations_ = mutationsBuilder_.build();
      }
      result.transactionSelectorCase_ = transactionSelectorCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.datastore.v1.CommitRequest) {
        return mergeFrom((com.google.datastore.v1.CommitRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.datastore.v1.CommitRequest other) {
      if (other == com.google.datastore.v1.CommitRequest.getDefaultInstance()) return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        onChanged();
      }
      if (other.mode_ != 0) {
        setModeValue(other.getModeValue());
      }
      if (mutationsBuilder_ == null) {
        if (!other.mutations_.isEmpty()) {
          if (mutations_.isEmpty()) {
            mutations_ = other.mutations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureMutationsIsMutable();
            mutations_.addAll(other.mutations_);
          }
          onChanged();
        }
      } else {
        if (!other.mutations_.isEmpty()) {
          if (mutationsBuilder_.isEmpty()) {
            mutationsBuilder_.dispose();
            mutationsBuilder_ = null;
            mutations_ = other.mutations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            mutationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMutationsFieldBuilder()
                    : null;
          } else {
            mutationsBuilder_.addAllMessages(other.mutations_);
          }
        }
      }
      switch (other.getTransactionSelectorCase()) {
        case TRANSACTION:
          {
            setTransaction(other.getTransaction());
            break;
          }
        case TRANSACTIONSELECTOR_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.datastore.v1.CommitRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.datastore.v1.CommitRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int transactionSelectorCase_ = 0;
    private java.lang.Object transactionSelector_;

    public TransactionSelectorCase getTransactionSelectorCase() {
      return TransactionSelectorCase.forNumber(transactionSelectorCase_);
    }

    public Builder clearTransactionSelector() {
      transactionSelectorCase_ = 0;
      transactionSelector_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID of the project against which to make the request.
     * </pre>
     *
     * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the project against which to make the request.
     * </pre>
     *
     * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the project against which to make the request.
     * </pre>
     *
     * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      projectId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the project against which to make the request.
     * </pre>
     *
     * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {

      projectId_ = getDefaultInstance().getProjectId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the project against which to make the request.
     * </pre>
     *
     * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      projectId_ = value;
      onChanged();
      return this;
    }

    private int mode_ = 0;
    /**
     *
     *
     * <pre>
     * The type of commit to perform. Defaults to `TRANSACTIONAL`.
     * </pre>
     *
     * <code>.google.datastore.v1.CommitRequest.Mode mode = 5;</code>
     *
     * @return The enum numeric value on the wire for mode.
     */
    @java.lang.Override
    public int getModeValue() {
      return mode_;
    }
    /**
     *
     *
     * <pre>
     * The type of commit to perform. Defaults to `TRANSACTIONAL`.
     * </pre>
     *
     * <code>.google.datastore.v1.CommitRequest.Mode mode = 5;</code>
     *
     * @param value The enum numeric value on the wire for mode to set.
     * @return This builder for chaining.
     */
    public Builder setModeValue(int value) {

      mode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of commit to perform. Defaults to `TRANSACTIONAL`.
     * </pre>
     *
     * <code>.google.datastore.v1.CommitRequest.Mode mode = 5;</code>
     *
     * @return The mode.
     */
    @java.lang.Override
    public com.google.datastore.v1.CommitRequest.Mode getMode() {
      @SuppressWarnings("deprecation")
      com.google.datastore.v1.CommitRequest.Mode result =
          com.google.datastore.v1.CommitRequest.Mode.valueOf(mode_);
      return result == null ? com.google.datastore.v1.CommitRequest.Mode.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The type of commit to perform. Defaults to `TRANSACTIONAL`.
     * </pre>
     *
     * <code>.google.datastore.v1.CommitRequest.Mode mode = 5;</code>
     *
     * @param value The mode to set.
     * @return This builder for chaining.
     */
    public Builder setMode(com.google.datastore.v1.CommitRequest.Mode value) {
      if (value == null) {
        throw new NullPointerException();
      }

      mode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of commit to perform. Defaults to `TRANSACTIONAL`.
     * </pre>
     *
     * <code>.google.datastore.v1.CommitRequest.Mode mode = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMode() {

      mode_ = 0;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The identifier of the transaction associated with the commit. A
     * transaction identifier is returned by a call to
     * [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
     * </pre>
     *
     * <code>bytes transaction = 1;</code>
     *
     * @return Whether the transaction field is set.
     */
    public boolean hasTransaction() {
      return transactionSelectorCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The identifier of the transaction associated with the commit. A
     * transaction identifier is returned by a call to
     * [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
     * </pre>
     *
     * <code>bytes transaction = 1;</code>
     *
     * @return The transaction.
     */
    public com.google.protobuf.ByteString getTransaction() {
      if (transactionSelectorCase_ == 1) {
        return (com.google.protobuf.ByteString) transactionSelector_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * The identifier of the transaction associated with the commit. A
     * transaction identifier is returned by a call to
     * [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
     * </pre>
     *
     * <code>bytes transaction = 1;</code>
     *
     * @param value The transaction to set.
     * @return This builder for chaining.
     */
    public Builder setTransaction(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      transactionSelectorCase_ = 1;
      transactionSelector_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The identifier of the transaction associated with the commit. A
     * transaction identifier is returned by a call to
     * [Datastore.BeginTransaction][google.datastore.v1.Datastore.BeginTransaction].
     * </pre>
     *
     * <code>bytes transaction = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTransaction() {
      if (transactionSelectorCase_ == 1) {
        transactionSelectorCase_ = 0;
        transactionSelector_ = null;
        onChanged();
      }
      return this;
    }

    private java.util.List<com.google.datastore.v1.Mutation> mutations_ =
        java.util.Collections.emptyList();

    private void ensureMutationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        mutations_ = new java.util.ArrayList<com.google.datastore.v1.Mutation>(mutations_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.Mutation,
            com.google.datastore.v1.Mutation.Builder,
            com.google.datastore.v1.MutationOrBuilder>
        mutationsBuilder_;

    /**
     *
     *
     * <pre>
     * The mutations to perform.
     * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
     * applied in order. The following sequences of mutations affecting a single
     * entity are not permitted in a single `Commit` request:
     * - `insert` followed by `insert`
     * - `update` followed by `insert`
     * - `upsert` followed by `insert`
     * - `delete` followed by `update`
     * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
     * entity.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
     */
    public java.util.List<com.google.datastore.v1.Mutation> getMutationsList() {
      if (mutationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(mutations_);
      } else {
        return mutationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The mutations to perform.
     * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
     * applied in order. The following sequences of mutations affecting a single
     * entity are not permitted in a single `Commit` request:
     * - `insert` followed by `insert`
     * - `update` followed by `insert`
     * - `upsert` followed by `insert`
     * - `delete` followed by `update`
     * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
     * entity.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
     */
    public int getMutationsCount() {
      if (mutationsBuilder_ == null) {
        return mutations_.size();
      } else {
        return mutationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The mutations to perform.
     * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
     * applied in order. The following sequences of mutations affecting a single
     * entity are not permitted in a single `Commit` request:
     * - `insert` followed by `insert`
     * - `update` followed by `insert`
     * - `upsert` followed by `insert`
     * - `delete` followed by `update`
     * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
     * entity.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
     */
    public com.google.datastore.v1.Mutation getMutations(int index) {
      if (mutationsBuilder_ == null) {
        return mutations_.get(index);
      } else {
        return mutationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The mutations to perform.
     * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
     * applied in order. The following sequences of mutations affecting a single
     * entity are not permitted in a single `Commit` request:
     * - `insert` followed by `insert`
     * - `update` followed by `insert`
     * - `upsert` followed by `insert`
     * - `delete` followed by `update`
     * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
     * entity.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
     */
    public Builder setMutations(int index, com.google.datastore.v1.Mutation value) {
      if (mutationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMutationsIsMutable();
        mutations_.set(index, value);
        onChanged();
      } else {
        mutationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mutations to perform.
     * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
     * applied in order. The following sequences of mutations affecting a single
     * entity are not permitted in a single `Commit` request:
     * - `insert` followed by `insert`
     * - `update` followed by `insert`
     * - `upsert` followed by `insert`
     * - `delete` followed by `update`
     * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
     * entity.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
     */
    public Builder setMutations(
        int index, com.google.datastore.v1.Mutation.Builder builderForValue) {
      if (mutationsBuilder_ == null) {
        ensureMutationsIsMutable();
        mutations_.set(index, builderForValue.build());
        onChanged();
      } else {
        mutationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mutations to perform.
     * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
     * applied in order. The following sequences of mutations affecting a single
     * entity are not permitted in a single `Commit` request:
     * - `insert` followed by `insert`
     * - `update` followed by `insert`
     * - `upsert` followed by `insert`
     * - `delete` followed by `update`
     * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
     * entity.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
     */
    public Builder addMutations(com.google.datastore.v1.Mutation value) {
      if (mutationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMutationsIsMutable();
        mutations_.add(value);
        onChanged();
      } else {
        mutationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mutations to perform.
     * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
     * applied in order. The following sequences of mutations affecting a single
     * entity are not permitted in a single `Commit` request:
     * - `insert` followed by `insert`
     * - `update` followed by `insert`
     * - `upsert` followed by `insert`
     * - `delete` followed by `update`
     * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
     * entity.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
     */
    public Builder addMutations(int index, com.google.datastore.v1.Mutation value) {
      if (mutationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMutationsIsMutable();
        mutations_.add(index, value);
        onChanged();
      } else {
        mutationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mutations to perform.
     * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
     * applied in order. The following sequences of mutations affecting a single
     * entity are not permitted in a single `Commit` request:
     * - `insert` followed by `insert`
     * - `update` followed by `insert`
     * - `upsert` followed by `insert`
     * - `delete` followed by `update`
     * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
     * entity.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
     */
    public Builder addMutations(com.google.datastore.v1.Mutation.Builder builderForValue) {
      if (mutationsBuilder_ == null) {
        ensureMutationsIsMutable();
        mutations_.add(builderForValue.build());
        onChanged();
      } else {
        mutationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mutations to perform.
     * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
     * applied in order. The following sequences of mutations affecting a single
     * entity are not permitted in a single `Commit` request:
     * - `insert` followed by `insert`
     * - `update` followed by `insert`
     * - `upsert` followed by `insert`
     * - `delete` followed by `update`
     * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
     * entity.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
     */
    public Builder addMutations(
        int index, com.google.datastore.v1.Mutation.Builder builderForValue) {
      if (mutationsBuilder_ == null) {
        ensureMutationsIsMutable();
        mutations_.add(index, builderForValue.build());
        onChanged();
      } else {
        mutationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mutations to perform.
     * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
     * applied in order. The following sequences of mutations affecting a single
     * entity are not permitted in a single `Commit` request:
     * - `insert` followed by `insert`
     * - `update` followed by `insert`
     * - `upsert` followed by `insert`
     * - `delete` followed by `update`
     * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
     * entity.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
     */
    public Builder addAllMutations(
        java.lang.Iterable<? extends com.google.datastore.v1.Mutation> values) {
      if (mutationsBuilder_ == null) {
        ensureMutationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, mutations_);
        onChanged();
      } else {
        mutationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mutations to perform.
     * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
     * applied in order. The following sequences of mutations affecting a single
     * entity are not permitted in a single `Commit` request:
     * - `insert` followed by `insert`
     * - `update` followed by `insert`
     * - `upsert` followed by `insert`
     * - `delete` followed by `update`
     * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
     * entity.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
     */
    public Builder clearMutations() {
      if (mutationsBuilder_ == null) {
        mutations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        mutationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mutations to perform.
     * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
     * applied in order. The following sequences of mutations affecting a single
     * entity are not permitted in a single `Commit` request:
     * - `insert` followed by `insert`
     * - `update` followed by `insert`
     * - `upsert` followed by `insert`
     * - `delete` followed by `update`
     * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
     * entity.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
     */
    public Builder removeMutations(int index) {
      if (mutationsBuilder_ == null) {
        ensureMutationsIsMutable();
        mutations_.remove(index);
        onChanged();
      } else {
        mutationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The mutations to perform.
     * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
     * applied in order. The following sequences of mutations affecting a single
     * entity are not permitted in a single `Commit` request:
     * - `insert` followed by `insert`
     * - `update` followed by `insert`
     * - `upsert` followed by `insert`
     * - `delete` followed by `update`
     * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
     * entity.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
     */
    public com.google.datastore.v1.Mutation.Builder getMutationsBuilder(int index) {
      return getMutationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The mutations to perform.
     * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
     * applied in order. The following sequences of mutations affecting a single
     * entity are not permitted in a single `Commit` request:
     * - `insert` followed by `insert`
     * - `update` followed by `insert`
     * - `upsert` followed by `insert`
     * - `delete` followed by `update`
     * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
     * entity.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
     */
    public com.google.datastore.v1.MutationOrBuilder getMutationsOrBuilder(int index) {
      if (mutationsBuilder_ == null) {
        return mutations_.get(index);
      } else {
        return mutationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The mutations to perform.
     * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
     * applied in order. The following sequences of mutations affecting a single
     * entity are not permitted in a single `Commit` request:
     * - `insert` followed by `insert`
     * - `update` followed by `insert`
     * - `upsert` followed by `insert`
     * - `delete` followed by `update`
     * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
     * entity.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
     */
    public java.util.List<? extends com.google.datastore.v1.MutationOrBuilder>
        getMutationsOrBuilderList() {
      if (mutationsBuilder_ != null) {
        return mutationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(mutations_);
      }
    }
    /**
     *
     *
     * <pre>
     * The mutations to perform.
     * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
     * applied in order. The following sequences of mutations affecting a single
     * entity are not permitted in a single `Commit` request:
     * - `insert` followed by `insert`
     * - `update` followed by `insert`
     * - `upsert` followed by `insert`
     * - `delete` followed by `update`
     * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
     * entity.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
     */
    public com.google.datastore.v1.Mutation.Builder addMutationsBuilder() {
      return getMutationsFieldBuilder()
          .addBuilder(com.google.datastore.v1.Mutation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The mutations to perform.
     * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
     * applied in order. The following sequences of mutations affecting a single
     * entity are not permitted in a single `Commit` request:
     * - `insert` followed by `insert`
     * - `update` followed by `insert`
     * - `upsert` followed by `insert`
     * - `delete` followed by `update`
     * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
     * entity.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
     */
    public com.google.datastore.v1.Mutation.Builder addMutationsBuilder(int index) {
      return getMutationsFieldBuilder()
          .addBuilder(index, com.google.datastore.v1.Mutation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The mutations to perform.
     * When mode is `TRANSACTIONAL`, mutations affecting a single entity are
     * applied in order. The following sequences of mutations affecting a single
     * entity are not permitted in a single `Commit` request:
     * - `insert` followed by `insert`
     * - `update` followed by `insert`
     * - `upsert` followed by `insert`
     * - `delete` followed by `update`
     * When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
     * entity.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.Mutation mutations = 6;</code>
     */
    public java.util.List<com.google.datastore.v1.Mutation.Builder> getMutationsBuilderList() {
      return getMutationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.Mutation,
            com.google.datastore.v1.Mutation.Builder,
            com.google.datastore.v1.MutationOrBuilder>
        getMutationsFieldBuilder() {
      if (mutationsBuilder_ == null) {
        mutationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.datastore.v1.Mutation,
                com.google.datastore.v1.Mutation.Builder,
                com.google.datastore.v1.MutationOrBuilder>(
                mutations_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        mutations_ = null;
      }
      return mutationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.datastore.v1.CommitRequest)
  }

  // @@protoc_insertion_point(class_scope:google.datastore.v1.CommitRequest)
  private static final com.google.datastore.v1.CommitRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.datastore.v1.CommitRequest();
  }

  public static com.google.datastore.v1.CommitRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CommitRequest> PARSER =
      new com.google.protobuf.AbstractParser<CommitRequest>() {
        @java.lang.Override
        public CommitRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new CommitRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<CommitRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CommitRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.datastore.v1.CommitRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
