/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/v1/datastore.proto

package com.google.datastore.v1;

/**
 *
 *
 * <pre>
 * A mutation to apply to an entity.
 * </pre>
 *
 * Protobuf type {@code google.datastore.v1.Mutation}
 */
public final class Mutation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.datastore.v1.Mutation)
    MutationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Mutation.newBuilder() to construct.
  private Mutation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Mutation() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Mutation();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Mutation(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 34:
            {
              com.google.datastore.v1.Entity.Builder subBuilder = null;
              if (operationCase_ == 4) {
                subBuilder = ((com.google.datastore.v1.Entity) operation_).toBuilder();
              }
              operation_ =
                  input.readMessage(com.google.datastore.v1.Entity.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.datastore.v1.Entity) operation_);
                operation_ = subBuilder.buildPartial();
              }
              operationCase_ = 4;
              break;
            }
          case 42:
            {
              com.google.datastore.v1.Entity.Builder subBuilder = null;
              if (operationCase_ == 5) {
                subBuilder = ((com.google.datastore.v1.Entity) operation_).toBuilder();
              }
              operation_ =
                  input.readMessage(com.google.datastore.v1.Entity.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.datastore.v1.Entity) operation_);
                operation_ = subBuilder.buildPartial();
              }
              operationCase_ = 5;
              break;
            }
          case 50:
            {
              com.google.datastore.v1.Entity.Builder subBuilder = null;
              if (operationCase_ == 6) {
                subBuilder = ((com.google.datastore.v1.Entity) operation_).toBuilder();
              }
              operation_ =
                  input.readMessage(com.google.datastore.v1.Entity.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.datastore.v1.Entity) operation_);
                operation_ = subBuilder.buildPartial();
              }
              operationCase_ = 6;
              break;
            }
          case 58:
            {
              com.google.datastore.v1.Key.Builder subBuilder = null;
              if (operationCase_ == 7) {
                subBuilder = ((com.google.datastore.v1.Key) operation_).toBuilder();
              }
              operation_ =
                  input.readMessage(com.google.datastore.v1.Key.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.datastore.v1.Key) operation_);
                operation_ = subBuilder.buildPartial();
              }
              operationCase_ = 7;
              break;
            }
          case 64:
            {
              conflictDetectionStrategyCase_ = 8;
              conflictDetectionStrategy_ = input.readInt64();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.datastore.v1.DatastoreProto
        .internal_static_google_datastore_v1_Mutation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.datastore.v1.DatastoreProto
        .internal_static_google_datastore_v1_Mutation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.datastore.v1.Mutation.class, com.google.datastore.v1.Mutation.Builder.class);
  }

  private int operationCase_ = 0;
  private java.lang.Object operation_;

  public enum OperationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INSERT(4),
    UPDATE(5),
    UPSERT(6),
    DELETE(7),
    OPERATION_NOT_SET(0);
    private final int value;

    private OperationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OperationCase valueOf(int value) {
      return forNumber(value);
    }

    public static OperationCase forNumber(int value) {
      switch (value) {
        case 4:
          return INSERT;
        case 5:
          return UPDATE;
        case 6:
          return UPSERT;
        case 7:
          return DELETE;
        case 0:
          return OPERATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public OperationCase getOperationCase() {
    return OperationCase.forNumber(operationCase_);
  }

  private int conflictDetectionStrategyCase_ = 0;
  private java.lang.Object conflictDetectionStrategy_;

  public enum ConflictDetectionStrategyCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BASE_VERSION(8),
    CONFLICTDETECTIONSTRATEGY_NOT_SET(0);
    private final int value;

    private ConflictDetectionStrategyCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConflictDetectionStrategyCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConflictDetectionStrategyCase forNumber(int value) {
      switch (value) {
        case 8:
          return BASE_VERSION;
        case 0:
          return CONFLICTDETECTIONSTRATEGY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConflictDetectionStrategyCase getConflictDetectionStrategyCase() {
    return ConflictDetectionStrategyCase.forNumber(conflictDetectionStrategyCase_);
  }

  public static final int INSERT_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * The entity to insert. The entity must not already exist.
   * The entity key's final path element may be incomplete.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity insert = 4;</code>
   *
   * @return Whether the insert field is set.
   */
  @java.lang.Override
  public boolean hasInsert() {
    return operationCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * The entity to insert. The entity must not already exist.
   * The entity key's final path element may be incomplete.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity insert = 4;</code>
   *
   * @return The insert.
   */
  @java.lang.Override
  public com.google.datastore.v1.Entity getInsert() {
    if (operationCase_ == 4) {
      return (com.google.datastore.v1.Entity) operation_;
    }
    return com.google.datastore.v1.Entity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The entity to insert. The entity must not already exist.
   * The entity key's final path element may be incomplete.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity insert = 4;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.EntityOrBuilder getInsertOrBuilder() {
    if (operationCase_ == 4) {
      return (com.google.datastore.v1.Entity) operation_;
    }
    return com.google.datastore.v1.Entity.getDefaultInstance();
  }

  public static final int UPDATE_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * The entity to update. The entity must already exist.
   * Must have a complete key path.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity update = 5;</code>
   *
   * @return Whether the update field is set.
   */
  @java.lang.Override
  public boolean hasUpdate() {
    return operationCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * The entity to update. The entity must already exist.
   * Must have a complete key path.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity update = 5;</code>
   *
   * @return The update.
   */
  @java.lang.Override
  public com.google.datastore.v1.Entity getUpdate() {
    if (operationCase_ == 5) {
      return (com.google.datastore.v1.Entity) operation_;
    }
    return com.google.datastore.v1.Entity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The entity to update. The entity must already exist.
   * Must have a complete key path.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity update = 5;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.EntityOrBuilder getUpdateOrBuilder() {
    if (operationCase_ == 5) {
      return (com.google.datastore.v1.Entity) operation_;
    }
    return com.google.datastore.v1.Entity.getDefaultInstance();
  }

  public static final int UPSERT_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * The entity to upsert. The entity may or may not already exist.
   * The entity key's final path element may be incomplete.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity upsert = 6;</code>
   *
   * @return Whether the upsert field is set.
   */
  @java.lang.Override
  public boolean hasUpsert() {
    return operationCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * The entity to upsert. The entity may or may not already exist.
   * The entity key's final path element may be incomplete.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity upsert = 6;</code>
   *
   * @return The upsert.
   */
  @java.lang.Override
  public com.google.datastore.v1.Entity getUpsert() {
    if (operationCase_ == 6) {
      return (com.google.datastore.v1.Entity) operation_;
    }
    return com.google.datastore.v1.Entity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The entity to upsert. The entity may or may not already exist.
   * The entity key's final path element may be incomplete.
   * </pre>
   *
   * <code>.google.datastore.v1.Entity upsert = 6;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.EntityOrBuilder getUpsertOrBuilder() {
    if (operationCase_ == 6) {
      return (com.google.datastore.v1.Entity) operation_;
    }
    return com.google.datastore.v1.Entity.getDefaultInstance();
  }

  public static final int DELETE_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * The key of the entity to delete. The entity may or may not already exist.
   * Must have a complete key path and must not be reserved/read-only.
   * </pre>
   *
   * <code>.google.datastore.v1.Key delete = 7;</code>
   *
   * @return Whether the delete field is set.
   */
  @java.lang.Override
  public boolean hasDelete() {
    return operationCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * The key of the entity to delete. The entity may or may not already exist.
   * Must have a complete key path and must not be reserved/read-only.
   * </pre>
   *
   * <code>.google.datastore.v1.Key delete = 7;</code>
   *
   * @return The delete.
   */
  @java.lang.Override
  public com.google.datastore.v1.Key getDelete() {
    if (operationCase_ == 7) {
      return (com.google.datastore.v1.Key) operation_;
    }
    return com.google.datastore.v1.Key.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The key of the entity to delete. The entity may or may not already exist.
   * Must have a complete key path and must not be reserved/read-only.
   * </pre>
   *
   * <code>.google.datastore.v1.Key delete = 7;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.KeyOrBuilder getDeleteOrBuilder() {
    if (operationCase_ == 7) {
      return (com.google.datastore.v1.Key) operation_;
    }
    return com.google.datastore.v1.Key.getDefaultInstance();
  }

  public static final int BASE_VERSION_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * The version of the entity that this mutation is being applied
   * to. If this does not match the current version on the server, the
   * mutation conflicts.
   * </pre>
   *
   * <code>int64 base_version = 8;</code>
   *
   * @return Whether the baseVersion field is set.
   */
  @java.lang.Override
  public boolean hasBaseVersion() {
    return conflictDetectionStrategyCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * The version of the entity that this mutation is being applied
   * to. If this does not match the current version on the server, the
   * mutation conflicts.
   * </pre>
   *
   * <code>int64 base_version = 8;</code>
   *
   * @return The baseVersion.
   */
  @java.lang.Override
  public long getBaseVersion() {
    if (conflictDetectionStrategyCase_ == 8) {
      return (java.lang.Long) conflictDetectionStrategy_;
    }
    return 0L;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (operationCase_ == 4) {
      output.writeMessage(4, (com.google.datastore.v1.Entity) operation_);
    }
    if (operationCase_ == 5) {
      output.writeMessage(5, (com.google.datastore.v1.Entity) operation_);
    }
    if (operationCase_ == 6) {
      output.writeMessage(6, (com.google.datastore.v1.Entity) operation_);
    }
    if (operationCase_ == 7) {
      output.writeMessage(7, (com.google.datastore.v1.Key) operation_);
    }
    if (conflictDetectionStrategyCase_ == 8) {
      output.writeInt64(8, (long) ((java.lang.Long) conflictDetectionStrategy_));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (operationCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.datastore.v1.Entity) operation_);
    }
    if (operationCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.datastore.v1.Entity) operation_);
    }
    if (operationCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.datastore.v1.Entity) operation_);
    }
    if (operationCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.datastore.v1.Key) operation_);
    }
    if (conflictDetectionStrategyCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              8, (long) ((java.lang.Long) conflictDetectionStrategy_));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.datastore.v1.Mutation)) {
      return super.equals(obj);
    }
    com.google.datastore.v1.Mutation other = (com.google.datastore.v1.Mutation) obj;

    if (!getOperationCase().equals(other.getOperationCase())) return false;
    switch (operationCase_) {
      case 4:
        if (!getInsert().equals(other.getInsert())) return false;
        break;
      case 5:
        if (!getUpdate().equals(other.getUpdate())) return false;
        break;
      case 6:
        if (!getUpsert().equals(other.getUpsert())) return false;
        break;
      case 7:
        if (!getDelete().equals(other.getDelete())) return false;
        break;
      case 0:
      default:
    }
    if (!getConflictDetectionStrategyCase().equals(other.getConflictDetectionStrategyCase()))
      return false;
    switch (conflictDetectionStrategyCase_) {
      case 8:
        if (getBaseVersion() != other.getBaseVersion()) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (operationCase_) {
      case 4:
        hash = (37 * hash) + INSERT_FIELD_NUMBER;
        hash = (53 * hash) + getInsert().hashCode();
        break;
      case 5:
        hash = (37 * hash) + UPDATE_FIELD_NUMBER;
        hash = (53 * hash) + getUpdate().hashCode();
        break;
      case 6:
        hash = (37 * hash) + UPSERT_FIELD_NUMBER;
        hash = (53 * hash) + getUpsert().hashCode();
        break;
      case 7:
        hash = (37 * hash) + DELETE_FIELD_NUMBER;
        hash = (53 * hash) + getDelete().hashCode();
        break;
      case 0:
      default:
    }
    switch (conflictDetectionStrategyCase_) {
      case 8:
        hash = (37 * hash) + BASE_VERSION_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getBaseVersion());
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.datastore.v1.Mutation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.Mutation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.Mutation parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.Mutation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.Mutation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.Mutation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.Mutation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.Mutation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.Mutation parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.Mutation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.Mutation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.Mutation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.datastore.v1.Mutation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A mutation to apply to an entity.
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.Mutation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.datastore.v1.Mutation)
      com.google.datastore.v1.MutationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_Mutation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_Mutation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.Mutation.class,
              com.google.datastore.v1.Mutation.Builder.class);
    }

    // Construct using com.google.datastore.v1.Mutation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      operationCase_ = 0;
      operation_ = null;
      conflictDetectionStrategyCase_ = 0;
      conflictDetectionStrategy_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_Mutation_descriptor;
    }

    @java.lang.Override
    public com.google.datastore.v1.Mutation getDefaultInstanceForType() {
      return com.google.datastore.v1.Mutation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.datastore.v1.Mutation build() {
      com.google.datastore.v1.Mutation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.datastore.v1.Mutation buildPartial() {
      com.google.datastore.v1.Mutation result = new com.google.datastore.v1.Mutation(this);
      if (operationCase_ == 4) {
        if (insertBuilder_ == null) {
          result.operation_ = operation_;
        } else {
          result.operation_ = insertBuilder_.build();
        }
      }
      if (operationCase_ == 5) {
        if (updateBuilder_ == null) {
          result.operation_ = operation_;
        } else {
          result.operation_ = updateBuilder_.build();
        }
      }
      if (operationCase_ == 6) {
        if (upsertBuilder_ == null) {
          result.operation_ = operation_;
        } else {
          result.operation_ = upsertBuilder_.build();
        }
      }
      if (operationCase_ == 7) {
        if (deleteBuilder_ == null) {
          result.operation_ = operation_;
        } else {
          result.operation_ = deleteBuilder_.build();
        }
      }
      if (conflictDetectionStrategyCase_ == 8) {
        result.conflictDetectionStrategy_ = conflictDetectionStrategy_;
      }
      result.operationCase_ = operationCase_;
      result.conflictDetectionStrategyCase_ = conflictDetectionStrategyCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.datastore.v1.Mutation) {
        return mergeFrom((com.google.datastore.v1.Mutation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.datastore.v1.Mutation other) {
      if (other == com.google.datastore.v1.Mutation.getDefaultInstance()) return this;
      switch (other.getOperationCase()) {
        case INSERT:
          {
            mergeInsert(other.getInsert());
            break;
          }
        case UPDATE:
          {
            mergeUpdate(other.getUpdate());
            break;
          }
        case UPSERT:
          {
            mergeUpsert(other.getUpsert());
            break;
          }
        case DELETE:
          {
            mergeDelete(other.getDelete());
            break;
          }
        case OPERATION_NOT_SET:
          {
            break;
          }
      }
      switch (other.getConflictDetectionStrategyCase()) {
        case BASE_VERSION:
          {
            setBaseVersion(other.getBaseVersion());
            break;
          }
        case CONFLICTDETECTIONSTRATEGY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.datastore.v1.Mutation parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.datastore.v1.Mutation) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int operationCase_ = 0;
    private java.lang.Object operation_;

    public OperationCase getOperationCase() {
      return OperationCase.forNumber(operationCase_);
    }

    public Builder clearOperation() {
      operationCase_ = 0;
      operation_ = null;
      onChanged();
      return this;
    }

    private int conflictDetectionStrategyCase_ = 0;
    private java.lang.Object conflictDetectionStrategy_;

    public ConflictDetectionStrategyCase getConflictDetectionStrategyCase() {
      return ConflictDetectionStrategyCase.forNumber(conflictDetectionStrategyCase_);
    }

    public Builder clearConflictDetectionStrategy() {
      conflictDetectionStrategyCase_ = 0;
      conflictDetectionStrategy_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Entity,
            com.google.datastore.v1.Entity.Builder,
            com.google.datastore.v1.EntityOrBuilder>
        insertBuilder_;
    /**
     *
     *
     * <pre>
     * The entity to insert. The entity must not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity insert = 4;</code>
     *
     * @return Whether the insert field is set.
     */
    @java.lang.Override
    public boolean hasInsert() {
      return operationCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * The entity to insert. The entity must not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity insert = 4;</code>
     *
     * @return The insert.
     */
    @java.lang.Override
    public com.google.datastore.v1.Entity getInsert() {
      if (insertBuilder_ == null) {
        if (operationCase_ == 4) {
          return (com.google.datastore.v1.Entity) operation_;
        }
        return com.google.datastore.v1.Entity.getDefaultInstance();
      } else {
        if (operationCase_ == 4) {
          return insertBuilder_.getMessage();
        }
        return com.google.datastore.v1.Entity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The entity to insert. The entity must not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity insert = 4;</code>
     */
    public Builder setInsert(com.google.datastore.v1.Entity value) {
      if (insertBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
        onChanged();
      } else {
        insertBuilder_.setMessage(value);
      }
      operationCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity to insert. The entity must not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity insert = 4;</code>
     */
    public Builder setInsert(com.google.datastore.v1.Entity.Builder builderForValue) {
      if (insertBuilder_ == null) {
        operation_ = builderForValue.build();
        onChanged();
      } else {
        insertBuilder_.setMessage(builderForValue.build());
      }
      operationCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity to insert. The entity must not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity insert = 4;</code>
     */
    public Builder mergeInsert(com.google.datastore.v1.Entity value) {
      if (insertBuilder_ == null) {
        if (operationCase_ == 4
            && operation_ != com.google.datastore.v1.Entity.getDefaultInstance()) {
          operation_ =
              com.google.datastore.v1.Entity.newBuilder((com.google.datastore.v1.Entity) operation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          operation_ = value;
        }
        onChanged();
      } else {
        if (operationCase_ == 4) {
          insertBuilder_.mergeFrom(value);
        }
        insertBuilder_.setMessage(value);
      }
      operationCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity to insert. The entity must not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity insert = 4;</code>
     */
    public Builder clearInsert() {
      if (insertBuilder_ == null) {
        if (operationCase_ == 4) {
          operationCase_ = 0;
          operation_ = null;
          onChanged();
        }
      } else {
        if (operationCase_ == 4) {
          operationCase_ = 0;
          operation_ = null;
        }
        insertBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity to insert. The entity must not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity insert = 4;</code>
     */
    public com.google.datastore.v1.Entity.Builder getInsertBuilder() {
      return getInsertFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The entity to insert. The entity must not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity insert = 4;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.EntityOrBuilder getInsertOrBuilder() {
      if ((operationCase_ == 4) && (insertBuilder_ != null)) {
        return insertBuilder_.getMessageOrBuilder();
      } else {
        if (operationCase_ == 4) {
          return (com.google.datastore.v1.Entity) operation_;
        }
        return com.google.datastore.v1.Entity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The entity to insert. The entity must not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity insert = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Entity,
            com.google.datastore.v1.Entity.Builder,
            com.google.datastore.v1.EntityOrBuilder>
        getInsertFieldBuilder() {
      if (insertBuilder_ == null) {
        if (!(operationCase_ == 4)) {
          operation_ = com.google.datastore.v1.Entity.getDefaultInstance();
        }
        insertBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.Entity,
                com.google.datastore.v1.Entity.Builder,
                com.google.datastore.v1.EntityOrBuilder>(
                (com.google.datastore.v1.Entity) operation_, getParentForChildren(), isClean());
        operation_ = null;
      }
      operationCase_ = 4;
      onChanged();
      ;
      return insertBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Entity,
            com.google.datastore.v1.Entity.Builder,
            com.google.datastore.v1.EntityOrBuilder>
        updateBuilder_;
    /**
     *
     *
     * <pre>
     * The entity to update. The entity must already exist.
     * Must have a complete key path.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity update = 5;</code>
     *
     * @return Whether the update field is set.
     */
    @java.lang.Override
    public boolean hasUpdate() {
      return operationCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The entity to update. The entity must already exist.
     * Must have a complete key path.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity update = 5;</code>
     *
     * @return The update.
     */
    @java.lang.Override
    public com.google.datastore.v1.Entity getUpdate() {
      if (updateBuilder_ == null) {
        if (operationCase_ == 5) {
          return (com.google.datastore.v1.Entity) operation_;
        }
        return com.google.datastore.v1.Entity.getDefaultInstance();
      } else {
        if (operationCase_ == 5) {
          return updateBuilder_.getMessage();
        }
        return com.google.datastore.v1.Entity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The entity to update. The entity must already exist.
     * Must have a complete key path.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity update = 5;</code>
     */
    public Builder setUpdate(com.google.datastore.v1.Entity value) {
      if (updateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
        onChanged();
      } else {
        updateBuilder_.setMessage(value);
      }
      operationCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity to update. The entity must already exist.
     * Must have a complete key path.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity update = 5;</code>
     */
    public Builder setUpdate(com.google.datastore.v1.Entity.Builder builderForValue) {
      if (updateBuilder_ == null) {
        operation_ = builderForValue.build();
        onChanged();
      } else {
        updateBuilder_.setMessage(builderForValue.build());
      }
      operationCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity to update. The entity must already exist.
     * Must have a complete key path.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity update = 5;</code>
     */
    public Builder mergeUpdate(com.google.datastore.v1.Entity value) {
      if (updateBuilder_ == null) {
        if (operationCase_ == 5
            && operation_ != com.google.datastore.v1.Entity.getDefaultInstance()) {
          operation_ =
              com.google.datastore.v1.Entity.newBuilder((com.google.datastore.v1.Entity) operation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          operation_ = value;
        }
        onChanged();
      } else {
        if (operationCase_ == 5) {
          updateBuilder_.mergeFrom(value);
        }
        updateBuilder_.setMessage(value);
      }
      operationCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity to update. The entity must already exist.
     * Must have a complete key path.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity update = 5;</code>
     */
    public Builder clearUpdate() {
      if (updateBuilder_ == null) {
        if (operationCase_ == 5) {
          operationCase_ = 0;
          operation_ = null;
          onChanged();
        }
      } else {
        if (operationCase_ == 5) {
          operationCase_ = 0;
          operation_ = null;
        }
        updateBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity to update. The entity must already exist.
     * Must have a complete key path.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity update = 5;</code>
     */
    public com.google.datastore.v1.Entity.Builder getUpdateBuilder() {
      return getUpdateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The entity to update. The entity must already exist.
     * Must have a complete key path.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity update = 5;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.EntityOrBuilder getUpdateOrBuilder() {
      if ((operationCase_ == 5) && (updateBuilder_ != null)) {
        return updateBuilder_.getMessageOrBuilder();
      } else {
        if (operationCase_ == 5) {
          return (com.google.datastore.v1.Entity) operation_;
        }
        return com.google.datastore.v1.Entity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The entity to update. The entity must already exist.
     * Must have a complete key path.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity update = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Entity,
            com.google.datastore.v1.Entity.Builder,
            com.google.datastore.v1.EntityOrBuilder>
        getUpdateFieldBuilder() {
      if (updateBuilder_ == null) {
        if (!(operationCase_ == 5)) {
          operation_ = com.google.datastore.v1.Entity.getDefaultInstance();
        }
        updateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.Entity,
                com.google.datastore.v1.Entity.Builder,
                com.google.datastore.v1.EntityOrBuilder>(
                (com.google.datastore.v1.Entity) operation_, getParentForChildren(), isClean());
        operation_ = null;
      }
      operationCase_ = 5;
      onChanged();
      ;
      return updateBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Entity,
            com.google.datastore.v1.Entity.Builder,
            com.google.datastore.v1.EntityOrBuilder>
        upsertBuilder_;
    /**
     *
     *
     * <pre>
     * The entity to upsert. The entity may or may not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity upsert = 6;</code>
     *
     * @return Whether the upsert field is set.
     */
    @java.lang.Override
    public boolean hasUpsert() {
      return operationCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * The entity to upsert. The entity may or may not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity upsert = 6;</code>
     *
     * @return The upsert.
     */
    @java.lang.Override
    public com.google.datastore.v1.Entity getUpsert() {
      if (upsertBuilder_ == null) {
        if (operationCase_ == 6) {
          return (com.google.datastore.v1.Entity) operation_;
        }
        return com.google.datastore.v1.Entity.getDefaultInstance();
      } else {
        if (operationCase_ == 6) {
          return upsertBuilder_.getMessage();
        }
        return com.google.datastore.v1.Entity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The entity to upsert. The entity may or may not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity upsert = 6;</code>
     */
    public Builder setUpsert(com.google.datastore.v1.Entity value) {
      if (upsertBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
        onChanged();
      } else {
        upsertBuilder_.setMessage(value);
      }
      operationCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity to upsert. The entity may or may not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity upsert = 6;</code>
     */
    public Builder setUpsert(com.google.datastore.v1.Entity.Builder builderForValue) {
      if (upsertBuilder_ == null) {
        operation_ = builderForValue.build();
        onChanged();
      } else {
        upsertBuilder_.setMessage(builderForValue.build());
      }
      operationCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity to upsert. The entity may or may not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity upsert = 6;</code>
     */
    public Builder mergeUpsert(com.google.datastore.v1.Entity value) {
      if (upsertBuilder_ == null) {
        if (operationCase_ == 6
            && operation_ != com.google.datastore.v1.Entity.getDefaultInstance()) {
          operation_ =
              com.google.datastore.v1.Entity.newBuilder((com.google.datastore.v1.Entity) operation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          operation_ = value;
        }
        onChanged();
      } else {
        if (operationCase_ == 6) {
          upsertBuilder_.mergeFrom(value);
        }
        upsertBuilder_.setMessage(value);
      }
      operationCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity to upsert. The entity may or may not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity upsert = 6;</code>
     */
    public Builder clearUpsert() {
      if (upsertBuilder_ == null) {
        if (operationCase_ == 6) {
          operationCase_ = 0;
          operation_ = null;
          onChanged();
        }
      } else {
        if (operationCase_ == 6) {
          operationCase_ = 0;
          operation_ = null;
        }
        upsertBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The entity to upsert. The entity may or may not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity upsert = 6;</code>
     */
    public com.google.datastore.v1.Entity.Builder getUpsertBuilder() {
      return getUpsertFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The entity to upsert. The entity may or may not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity upsert = 6;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.EntityOrBuilder getUpsertOrBuilder() {
      if ((operationCase_ == 6) && (upsertBuilder_ != null)) {
        return upsertBuilder_.getMessageOrBuilder();
      } else {
        if (operationCase_ == 6) {
          return (com.google.datastore.v1.Entity) operation_;
        }
        return com.google.datastore.v1.Entity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The entity to upsert. The entity may or may not already exist.
     * The entity key's final path element may be incomplete.
     * </pre>
     *
     * <code>.google.datastore.v1.Entity upsert = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Entity,
            com.google.datastore.v1.Entity.Builder,
            com.google.datastore.v1.EntityOrBuilder>
        getUpsertFieldBuilder() {
      if (upsertBuilder_ == null) {
        if (!(operationCase_ == 6)) {
          operation_ = com.google.datastore.v1.Entity.getDefaultInstance();
        }
        upsertBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.Entity,
                com.google.datastore.v1.Entity.Builder,
                com.google.datastore.v1.EntityOrBuilder>(
                (com.google.datastore.v1.Entity) operation_, getParentForChildren(), isClean());
        operation_ = null;
      }
      operationCase_ = 6;
      onChanged();
      ;
      return upsertBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Key,
            com.google.datastore.v1.Key.Builder,
            com.google.datastore.v1.KeyOrBuilder>
        deleteBuilder_;
    /**
     *
     *
     * <pre>
     * The key of the entity to delete. The entity may or may not already exist.
     * Must have a complete key path and must not be reserved/read-only.
     * </pre>
     *
     * <code>.google.datastore.v1.Key delete = 7;</code>
     *
     * @return Whether the delete field is set.
     */
    @java.lang.Override
    public boolean hasDelete() {
      return operationCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * The key of the entity to delete. The entity may or may not already exist.
     * Must have a complete key path and must not be reserved/read-only.
     * </pre>
     *
     * <code>.google.datastore.v1.Key delete = 7;</code>
     *
     * @return The delete.
     */
    @java.lang.Override
    public com.google.datastore.v1.Key getDelete() {
      if (deleteBuilder_ == null) {
        if (operationCase_ == 7) {
          return (com.google.datastore.v1.Key) operation_;
        }
        return com.google.datastore.v1.Key.getDefaultInstance();
      } else {
        if (operationCase_ == 7) {
          return deleteBuilder_.getMessage();
        }
        return com.google.datastore.v1.Key.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The key of the entity to delete. The entity may or may not already exist.
     * Must have a complete key path and must not be reserved/read-only.
     * </pre>
     *
     * <code>.google.datastore.v1.Key delete = 7;</code>
     */
    public Builder setDelete(com.google.datastore.v1.Key value) {
      if (deleteBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
        onChanged();
      } else {
        deleteBuilder_.setMessage(value);
      }
      operationCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key of the entity to delete. The entity may or may not already exist.
     * Must have a complete key path and must not be reserved/read-only.
     * </pre>
     *
     * <code>.google.datastore.v1.Key delete = 7;</code>
     */
    public Builder setDelete(com.google.datastore.v1.Key.Builder builderForValue) {
      if (deleteBuilder_ == null) {
        operation_ = builderForValue.build();
        onChanged();
      } else {
        deleteBuilder_.setMessage(builderForValue.build());
      }
      operationCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key of the entity to delete. The entity may or may not already exist.
     * Must have a complete key path and must not be reserved/read-only.
     * </pre>
     *
     * <code>.google.datastore.v1.Key delete = 7;</code>
     */
    public Builder mergeDelete(com.google.datastore.v1.Key value) {
      if (deleteBuilder_ == null) {
        if (operationCase_ == 7 && operation_ != com.google.datastore.v1.Key.getDefaultInstance()) {
          operation_ =
              com.google.datastore.v1.Key.newBuilder((com.google.datastore.v1.Key) operation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          operation_ = value;
        }
        onChanged();
      } else {
        if (operationCase_ == 7) {
          deleteBuilder_.mergeFrom(value);
        }
        deleteBuilder_.setMessage(value);
      }
      operationCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key of the entity to delete. The entity may or may not already exist.
     * Must have a complete key path and must not be reserved/read-only.
     * </pre>
     *
     * <code>.google.datastore.v1.Key delete = 7;</code>
     */
    public Builder clearDelete() {
      if (deleteBuilder_ == null) {
        if (operationCase_ == 7) {
          operationCase_ = 0;
          operation_ = null;
          onChanged();
        }
      } else {
        if (operationCase_ == 7) {
          operationCase_ = 0;
          operation_ = null;
        }
        deleteBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The key of the entity to delete. The entity may or may not already exist.
     * Must have a complete key path and must not be reserved/read-only.
     * </pre>
     *
     * <code>.google.datastore.v1.Key delete = 7;</code>
     */
    public com.google.datastore.v1.Key.Builder getDeleteBuilder() {
      return getDeleteFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The key of the entity to delete. The entity may or may not already exist.
     * Must have a complete key path and must not be reserved/read-only.
     * </pre>
     *
     * <code>.google.datastore.v1.Key delete = 7;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.KeyOrBuilder getDeleteOrBuilder() {
      if ((operationCase_ == 7) && (deleteBuilder_ != null)) {
        return deleteBuilder_.getMessageOrBuilder();
      } else {
        if (operationCase_ == 7) {
          return (com.google.datastore.v1.Key) operation_;
        }
        return com.google.datastore.v1.Key.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The key of the entity to delete. The entity may or may not already exist.
     * Must have a complete key path and must not be reserved/read-only.
     * </pre>
     *
     * <code>.google.datastore.v1.Key delete = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Key,
            com.google.datastore.v1.Key.Builder,
            com.google.datastore.v1.KeyOrBuilder>
        getDeleteFieldBuilder() {
      if (deleteBuilder_ == null) {
        if (!(operationCase_ == 7)) {
          operation_ = com.google.datastore.v1.Key.getDefaultInstance();
        }
        deleteBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.Key,
                com.google.datastore.v1.Key.Builder,
                com.google.datastore.v1.KeyOrBuilder>(
                (com.google.datastore.v1.Key) operation_, getParentForChildren(), isClean());
        operation_ = null;
      }
      operationCase_ = 7;
      onChanged();
      ;
      return deleteBuilder_;
    }

    /**
     *
     *
     * <pre>
     * The version of the entity that this mutation is being applied
     * to. If this does not match the current version on the server, the
     * mutation conflicts.
     * </pre>
     *
     * <code>int64 base_version = 8;</code>
     *
     * @return Whether the baseVersion field is set.
     */
    public boolean hasBaseVersion() {
      return conflictDetectionStrategyCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * The version of the entity that this mutation is being applied
     * to. If this does not match the current version on the server, the
     * mutation conflicts.
     * </pre>
     *
     * <code>int64 base_version = 8;</code>
     *
     * @return The baseVersion.
     */
    public long getBaseVersion() {
      if (conflictDetectionStrategyCase_ == 8) {
        return (java.lang.Long) conflictDetectionStrategy_;
      }
      return 0L;
    }
    /**
     *
     *
     * <pre>
     * The version of the entity that this mutation is being applied
     * to. If this does not match the current version on the server, the
     * mutation conflicts.
     * </pre>
     *
     * <code>int64 base_version = 8;</code>
     *
     * @param value The baseVersion to set.
     * @return This builder for chaining.
     */
    public Builder setBaseVersion(long value) {
      conflictDetectionStrategyCase_ = 8;
      conflictDetectionStrategy_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The version of the entity that this mutation is being applied
     * to. If this does not match the current version on the server, the
     * mutation conflicts.
     * </pre>
     *
     * <code>int64 base_version = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBaseVersion() {
      if (conflictDetectionStrategyCase_ == 8) {
        conflictDetectionStrategyCase_ = 0;
        conflictDetectionStrategy_ = null;
        onChanged();
      }
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.datastore.v1.Mutation)
  }

  // @@protoc_insertion_point(class_scope:google.datastore.v1.Mutation)
  private static final com.google.datastore.v1.Mutation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.datastore.v1.Mutation();
  }

  public static com.google.datastore.v1.Mutation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Mutation> PARSER =
      new com.google.protobuf.AbstractParser<Mutation>() {
        @java.lang.Override
        public Mutation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Mutation(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Mutation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Mutation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.datastore.v1.Mutation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
