/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/v1/query.proto

package com.google.datastore.v1;

/**
 *
 *
 * <pre>
 * A batch of results produced by a query.
 * </pre>
 *
 * Protobuf type {@code google.datastore.v1.QueryResultBatch}
 */
public final class QueryResultBatch extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.datastore.v1.QueryResultBatch)
    QueryResultBatchOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use QueryResultBatch.newBuilder() to construct.
  private QueryResultBatch(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QueryResultBatch() {
    skippedCursor_ = com.google.protobuf.ByteString.EMPTY;
    entityResultType_ = 0;
    entityResults_ = java.util.Collections.emptyList();
    endCursor_ = com.google.protobuf.ByteString.EMPTY;
    moreResults_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QueryResultBatch();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private QueryResultBatch(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8:
            {
              int rawValue = input.readEnum();

              entityResultType_ = rawValue;
              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                entityResults_ = new java.util.ArrayList<com.google.datastore.v1.EntityResult>();
                mutable_bitField0_ |= 0x00000001;
              }
              entityResults_.add(
                  input.readMessage(
                      com.google.datastore.v1.EntityResult.parser(), extensionRegistry));
              break;
            }
          case 26:
            {
              skippedCursor_ = input.readBytes();
              break;
            }
          case 34:
            {
              endCursor_ = input.readBytes();
              break;
            }
          case 40:
            {
              int rawValue = input.readEnum();

              moreResults_ = rawValue;
              break;
            }
          case 48:
            {
              skippedResults_ = input.readInt32();
              break;
            }
          case 56:
            {
              snapshotVersion_ = input.readInt64();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        entityResults_ = java.util.Collections.unmodifiableList(entityResults_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.datastore.v1.QueryProto
        .internal_static_google_datastore_v1_QueryResultBatch_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.datastore.v1.QueryProto
        .internal_static_google_datastore_v1_QueryResultBatch_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.datastore.v1.QueryResultBatch.class,
            com.google.datastore.v1.QueryResultBatch.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The possible values for the `more_results` field.
   * </pre>
   *
   * Protobuf enum {@code google.datastore.v1.QueryResultBatch.MoreResultsType}
   */
  public enum MoreResultsType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified. This value is never used.
     * </pre>
     *
     * <code>MORE_RESULTS_TYPE_UNSPECIFIED = 0;</code>
     */
    MORE_RESULTS_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * There may be additional batches to fetch from this query.
     * </pre>
     *
     * <code>NOT_FINISHED = 1;</code>
     */
    NOT_FINISHED(1),
    /**
     *
     *
     * <pre>
     * The query is finished, but there may be more results after the limit.
     * </pre>
     *
     * <code>MORE_RESULTS_AFTER_LIMIT = 2;</code>
     */
    MORE_RESULTS_AFTER_LIMIT(2),
    /**
     *
     *
     * <pre>
     * The query is finished, but there may be more results after the end
     * cursor.
     * </pre>
     *
     * <code>MORE_RESULTS_AFTER_CURSOR = 4;</code>
     */
    MORE_RESULTS_AFTER_CURSOR(4),
    /**
     *
     *
     * <pre>
     * The query is finished, and there are no more results.
     * </pre>
     *
     * <code>NO_MORE_RESULTS = 3;</code>
     */
    NO_MORE_RESULTS(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified. This value is never used.
     * </pre>
     *
     * <code>MORE_RESULTS_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int MORE_RESULTS_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * There may be additional batches to fetch from this query.
     * </pre>
     *
     * <code>NOT_FINISHED = 1;</code>
     */
    public static final int NOT_FINISHED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The query is finished, but there may be more results after the limit.
     * </pre>
     *
     * <code>MORE_RESULTS_AFTER_LIMIT = 2;</code>
     */
    public static final int MORE_RESULTS_AFTER_LIMIT_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The query is finished, but there may be more results after the end
     * cursor.
     * </pre>
     *
     * <code>MORE_RESULTS_AFTER_CURSOR = 4;</code>
     */
    public static final int MORE_RESULTS_AFTER_CURSOR_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The query is finished, and there are no more results.
     * </pre>
     *
     * <code>NO_MORE_RESULTS = 3;</code>
     */
    public static final int NO_MORE_RESULTS_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MoreResultsType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MoreResultsType forNumber(int value) {
      switch (value) {
        case 0:
          return MORE_RESULTS_TYPE_UNSPECIFIED;
        case 1:
          return NOT_FINISHED;
        case 2:
          return MORE_RESULTS_AFTER_LIMIT;
        case 4:
          return MORE_RESULTS_AFTER_CURSOR;
        case 3:
          return NO_MORE_RESULTS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MoreResultsType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MoreResultsType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<MoreResultsType>() {
              public MoreResultsType findValueByNumber(int number) {
                return MoreResultsType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.datastore.v1.QueryResultBatch.getDescriptor().getEnumTypes().get(0);
    }

    private static final MoreResultsType[] VALUES = values();

    public static MoreResultsType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MoreResultsType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.datastore.v1.QueryResultBatch.MoreResultsType)
  }

  public static final int SKIPPED_RESULTS_FIELD_NUMBER = 6;
  private int skippedResults_;
  /**
   *
   *
   * <pre>
   * The number of results skipped, typically because of an offset.
   * </pre>
   *
   * <code>int32 skipped_results = 6;</code>
   *
   * @return The skippedResults.
   */
  @java.lang.Override
  public int getSkippedResults() {
    return skippedResults_;
  }

  public static final int SKIPPED_CURSOR_FIELD_NUMBER = 3;
  private com.google.protobuf.ByteString skippedCursor_;
  /**
   *
   *
   * <pre>
   * A cursor that points to the position after the last skipped result.
   * Will be set when `skipped_results` != 0.
   * </pre>
   *
   * <code>bytes skipped_cursor = 3;</code>
   *
   * @return The skippedCursor.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSkippedCursor() {
    return skippedCursor_;
  }

  public static final int ENTITY_RESULT_TYPE_FIELD_NUMBER = 1;
  private int entityResultType_;
  /**
   *
   *
   * <pre>
   * The result type for every entity in `entity_results`.
   * </pre>
   *
   * <code>.google.datastore.v1.EntityResult.ResultType entity_result_type = 1;</code>
   *
   * @return The enum numeric value on the wire for entityResultType.
   */
  @java.lang.Override
  public int getEntityResultTypeValue() {
    return entityResultType_;
  }
  /**
   *
   *
   * <pre>
   * The result type for every entity in `entity_results`.
   * </pre>
   *
   * <code>.google.datastore.v1.EntityResult.ResultType entity_result_type = 1;</code>
   *
   * @return The entityResultType.
   */
  @java.lang.Override
  public com.google.datastore.v1.EntityResult.ResultType getEntityResultType() {
    @SuppressWarnings("deprecation")
    com.google.datastore.v1.EntityResult.ResultType result =
        com.google.datastore.v1.EntityResult.ResultType.valueOf(entityResultType_);
    return result == null ? com.google.datastore.v1.EntityResult.ResultType.UNRECOGNIZED : result;
  }

  public static final int ENTITY_RESULTS_FIELD_NUMBER = 2;
  private java.util.List<com.google.datastore.v1.EntityResult> entityResults_;
  /**
   *
   *
   * <pre>
   * The results for this batch.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.datastore.v1.EntityResult> getEntityResultsList() {
    return entityResults_;
  }
  /**
   *
   *
   * <pre>
   * The results for this batch.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.datastore.v1.EntityResultOrBuilder>
      getEntityResultsOrBuilderList() {
    return entityResults_;
  }
  /**
   *
   *
   * <pre>
   * The results for this batch.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
   */
  @java.lang.Override
  public int getEntityResultsCount() {
    return entityResults_.size();
  }
  /**
   *
   *
   * <pre>
   * The results for this batch.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.EntityResult getEntityResults(int index) {
    return entityResults_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The results for this batch.
   * </pre>
   *
   * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.EntityResultOrBuilder getEntityResultsOrBuilder(int index) {
    return entityResults_.get(index);
  }

  public static final int END_CURSOR_FIELD_NUMBER = 4;
  private com.google.protobuf.ByteString endCursor_;
  /**
   *
   *
   * <pre>
   * A cursor that points to the position after the last result in the batch.
   * </pre>
   *
   * <code>bytes end_cursor = 4;</code>
   *
   * @return The endCursor.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEndCursor() {
    return endCursor_;
  }

  public static final int MORE_RESULTS_FIELD_NUMBER = 5;
  private int moreResults_;
  /**
   *
   *
   * <pre>
   * The state of the query after the current batch.
   * </pre>
   *
   * <code>.google.datastore.v1.QueryResultBatch.MoreResultsType more_results = 5;</code>
   *
   * @return The enum numeric value on the wire for moreResults.
   */
  @java.lang.Override
  public int getMoreResultsValue() {
    return moreResults_;
  }
  /**
   *
   *
   * <pre>
   * The state of the query after the current batch.
   * </pre>
   *
   * <code>.google.datastore.v1.QueryResultBatch.MoreResultsType more_results = 5;</code>
   *
   * @return The moreResults.
   */
  @java.lang.Override
  public com.google.datastore.v1.QueryResultBatch.MoreResultsType getMoreResults() {
    @SuppressWarnings("deprecation")
    com.google.datastore.v1.QueryResultBatch.MoreResultsType result =
        com.google.datastore.v1.QueryResultBatch.MoreResultsType.valueOf(moreResults_);
    return result == null
        ? com.google.datastore.v1.QueryResultBatch.MoreResultsType.UNRECOGNIZED
        : result;
  }

  public static final int SNAPSHOT_VERSION_FIELD_NUMBER = 7;
  private long snapshotVersion_;
  /**
   *
   *
   * <pre>
   * The version number of the snapshot this batch was returned from.
   * This applies to the range of results from the query's `start_cursor` (or
   * the beginning of the query if no cursor was given) to this batch's
   * `end_cursor` (not the query's `end_cursor`).
   * In a single transaction, subsequent query result batches for the same query
   * can have a greater snapshot version number. Each batch's snapshot version
   * is valid for all preceding batches.
   * The value will be zero for eventually consistent queries.
   * </pre>
   *
   * <code>int64 snapshot_version = 7;</code>
   *
   * @return The snapshotVersion.
   */
  @java.lang.Override
  public long getSnapshotVersion() {
    return snapshotVersion_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (entityResultType_
        != com.google.datastore.v1.EntityResult.ResultType.RESULT_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, entityResultType_);
    }
    for (int i = 0; i < entityResults_.size(); i++) {
      output.writeMessage(2, entityResults_.get(i));
    }
    if (!skippedCursor_.isEmpty()) {
      output.writeBytes(3, skippedCursor_);
    }
    if (!endCursor_.isEmpty()) {
      output.writeBytes(4, endCursor_);
    }
    if (moreResults_
        != com.google.datastore.v1.QueryResultBatch.MoreResultsType.MORE_RESULTS_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, moreResults_);
    }
    if (skippedResults_ != 0) {
      output.writeInt32(6, skippedResults_);
    }
    if (snapshotVersion_ != 0L) {
      output.writeInt64(7, snapshotVersion_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (entityResultType_
        != com.google.datastore.v1.EntityResult.ResultType.RESULT_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, entityResultType_);
    }
    for (int i = 0; i < entityResults_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, entityResults_.get(i));
    }
    if (!skippedCursor_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(3, skippedCursor_);
    }
    if (!endCursor_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(4, endCursor_);
    }
    if (moreResults_
        != com.google.datastore.v1.QueryResultBatch.MoreResultsType.MORE_RESULTS_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, moreResults_);
    }
    if (skippedResults_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, skippedResults_);
    }
    if (snapshotVersion_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(7, snapshotVersion_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.datastore.v1.QueryResultBatch)) {
      return super.equals(obj);
    }
    com.google.datastore.v1.QueryResultBatch other = (com.google.datastore.v1.QueryResultBatch) obj;

    if (getSkippedResults() != other.getSkippedResults()) return false;
    if (!getSkippedCursor().equals(other.getSkippedCursor())) return false;
    if (entityResultType_ != other.entityResultType_) return false;
    if (!getEntityResultsList().equals(other.getEntityResultsList())) return false;
    if (!getEndCursor().equals(other.getEndCursor())) return false;
    if (moreResults_ != other.moreResults_) return false;
    if (getSnapshotVersion() != other.getSnapshotVersion()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SKIPPED_RESULTS_FIELD_NUMBER;
    hash = (53 * hash) + getSkippedResults();
    hash = (37 * hash) + SKIPPED_CURSOR_FIELD_NUMBER;
    hash = (53 * hash) + getSkippedCursor().hashCode();
    hash = (37 * hash) + ENTITY_RESULT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + entityResultType_;
    if (getEntityResultsCount() > 0) {
      hash = (37 * hash) + ENTITY_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getEntityResultsList().hashCode();
    }
    hash = (37 * hash) + END_CURSOR_FIELD_NUMBER;
    hash = (53 * hash) + getEndCursor().hashCode();
    hash = (37 * hash) + MORE_RESULTS_FIELD_NUMBER;
    hash = (53 * hash) + moreResults_;
    hash = (37 * hash) + SNAPSHOT_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getSnapshotVersion());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.datastore.v1.QueryResultBatch parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.QueryResultBatch parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.QueryResultBatch parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.QueryResultBatch parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.QueryResultBatch parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.QueryResultBatch parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.QueryResultBatch parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.QueryResultBatch parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.QueryResultBatch parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.QueryResultBatch parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.QueryResultBatch parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.QueryResultBatch parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.datastore.v1.QueryResultBatch prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A batch of results produced by a query.
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.QueryResultBatch}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.datastore.v1.QueryResultBatch)
      com.google.datastore.v1.QueryResultBatchOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.QueryProto
          .internal_static_google_datastore_v1_QueryResultBatch_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.QueryProto
          .internal_static_google_datastore_v1_QueryResultBatch_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.QueryResultBatch.class,
              com.google.datastore.v1.QueryResultBatch.Builder.class);
    }

    // Construct using com.google.datastore.v1.QueryResultBatch.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getEntityResultsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      skippedResults_ = 0;

      skippedCursor_ = com.google.protobuf.ByteString.EMPTY;

      entityResultType_ = 0;

      if (entityResultsBuilder_ == null) {
        entityResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        entityResultsBuilder_.clear();
      }
      endCursor_ = com.google.protobuf.ByteString.EMPTY;

      moreResults_ = 0;

      snapshotVersion_ = 0L;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.datastore.v1.QueryProto
          .internal_static_google_datastore_v1_QueryResultBatch_descriptor;
    }

    @java.lang.Override
    public com.google.datastore.v1.QueryResultBatch getDefaultInstanceForType() {
      return com.google.datastore.v1.QueryResultBatch.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.datastore.v1.QueryResultBatch build() {
      com.google.datastore.v1.QueryResultBatch result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.datastore.v1.QueryResultBatch buildPartial() {
      com.google.datastore.v1.QueryResultBatch result =
          new com.google.datastore.v1.QueryResultBatch(this);
      int from_bitField0_ = bitField0_;
      result.skippedResults_ = skippedResults_;
      result.skippedCursor_ = skippedCursor_;
      result.entityResultType_ = entityResultType_;
      if (entityResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          entityResults_ = java.util.Collections.unmodifiableList(entityResults_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.entityResults_ = entityResults_;
      } else {
        result.entityResults_ = entityResultsBuilder_.build();
      }
      result.endCursor_ = endCursor_;
      result.moreResults_ = moreResults_;
      result.snapshotVersion_ = snapshotVersion_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.datastore.v1.QueryResultBatch) {
        return mergeFrom((com.google.datastore.v1.QueryResultBatch) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.datastore.v1.QueryResultBatch other) {
      if (other == com.google.datastore.v1.QueryResultBatch.getDefaultInstance()) return this;
      if (other.getSkippedResults() != 0) {
        setSkippedResults(other.getSkippedResults());
      }
      if (other.getSkippedCursor() != com.google.protobuf.ByteString.EMPTY) {
        setSkippedCursor(other.getSkippedCursor());
      }
      if (other.entityResultType_ != 0) {
        setEntityResultTypeValue(other.getEntityResultTypeValue());
      }
      if (entityResultsBuilder_ == null) {
        if (!other.entityResults_.isEmpty()) {
          if (entityResults_.isEmpty()) {
            entityResults_ = other.entityResults_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureEntityResultsIsMutable();
            entityResults_.addAll(other.entityResults_);
          }
          onChanged();
        }
      } else {
        if (!other.entityResults_.isEmpty()) {
          if (entityResultsBuilder_.isEmpty()) {
            entityResultsBuilder_.dispose();
            entityResultsBuilder_ = null;
            entityResults_ = other.entityResults_;
            bitField0_ = (bitField0_ & ~0x00000001);
            entityResultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEntityResultsFieldBuilder()
                    : null;
          } else {
            entityResultsBuilder_.addAllMessages(other.entityResults_);
          }
        }
      }
      if (other.getEndCursor() != com.google.protobuf.ByteString.EMPTY) {
        setEndCursor(other.getEndCursor());
      }
      if (other.moreResults_ != 0) {
        setMoreResultsValue(other.getMoreResultsValue());
      }
      if (other.getSnapshotVersion() != 0L) {
        setSnapshotVersion(other.getSnapshotVersion());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.datastore.v1.QueryResultBatch parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.datastore.v1.QueryResultBatch) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private int skippedResults_;
    /**
     *
     *
     * <pre>
     * The number of results skipped, typically because of an offset.
     * </pre>
     *
     * <code>int32 skipped_results = 6;</code>
     *
     * @return The skippedResults.
     */
    @java.lang.Override
    public int getSkippedResults() {
      return skippedResults_;
    }
    /**
     *
     *
     * <pre>
     * The number of results skipped, typically because of an offset.
     * </pre>
     *
     * <code>int32 skipped_results = 6;</code>
     *
     * @param value The skippedResults to set.
     * @return This builder for chaining.
     */
    public Builder setSkippedResults(int value) {

      skippedResults_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of results skipped, typically because of an offset.
     * </pre>
     *
     * <code>int32 skipped_results = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSkippedResults() {

      skippedResults_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString skippedCursor_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * A cursor that points to the position after the last skipped result.
     * Will be set when `skipped_results` != 0.
     * </pre>
     *
     * <code>bytes skipped_cursor = 3;</code>
     *
     * @return The skippedCursor.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSkippedCursor() {
      return skippedCursor_;
    }
    /**
     *
     *
     * <pre>
     * A cursor that points to the position after the last skipped result.
     * Will be set when `skipped_results` != 0.
     * </pre>
     *
     * <code>bytes skipped_cursor = 3;</code>
     *
     * @param value The skippedCursor to set.
     * @return This builder for chaining.
     */
    public Builder setSkippedCursor(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      skippedCursor_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cursor that points to the position after the last skipped result.
     * Will be set when `skipped_results` != 0.
     * </pre>
     *
     * <code>bytes skipped_cursor = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSkippedCursor() {

      skippedCursor_ = getDefaultInstance().getSkippedCursor();
      onChanged();
      return this;
    }

    private int entityResultType_ = 0;
    /**
     *
     *
     * <pre>
     * The result type for every entity in `entity_results`.
     * </pre>
     *
     * <code>.google.datastore.v1.EntityResult.ResultType entity_result_type = 1;</code>
     *
     * @return The enum numeric value on the wire for entityResultType.
     */
    @java.lang.Override
    public int getEntityResultTypeValue() {
      return entityResultType_;
    }
    /**
     *
     *
     * <pre>
     * The result type for every entity in `entity_results`.
     * </pre>
     *
     * <code>.google.datastore.v1.EntityResult.ResultType entity_result_type = 1;</code>
     *
     * @param value The enum numeric value on the wire for entityResultType to set.
     * @return This builder for chaining.
     */
    public Builder setEntityResultTypeValue(int value) {

      entityResultType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result type for every entity in `entity_results`.
     * </pre>
     *
     * <code>.google.datastore.v1.EntityResult.ResultType entity_result_type = 1;</code>
     *
     * @return The entityResultType.
     */
    @java.lang.Override
    public com.google.datastore.v1.EntityResult.ResultType getEntityResultType() {
      @SuppressWarnings("deprecation")
      com.google.datastore.v1.EntityResult.ResultType result =
          com.google.datastore.v1.EntityResult.ResultType.valueOf(entityResultType_);
      return result == null ? com.google.datastore.v1.EntityResult.ResultType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The result type for every entity in `entity_results`.
     * </pre>
     *
     * <code>.google.datastore.v1.EntityResult.ResultType entity_result_type = 1;</code>
     *
     * @param value The entityResultType to set.
     * @return This builder for chaining.
     */
    public Builder setEntityResultType(com.google.datastore.v1.EntityResult.ResultType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      entityResultType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The result type for every entity in `entity_results`.
     * </pre>
     *
     * <code>.google.datastore.v1.EntityResult.ResultType entity_result_type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntityResultType() {

      entityResultType_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.datastore.v1.EntityResult> entityResults_ =
        java.util.Collections.emptyList();

    private void ensureEntityResultsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        entityResults_ =
            new java.util.ArrayList<com.google.datastore.v1.EntityResult>(entityResults_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.EntityResult,
            com.google.datastore.v1.EntityResult.Builder,
            com.google.datastore.v1.EntityResultOrBuilder>
        entityResultsBuilder_;

    /**
     *
     *
     * <pre>
     * The results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
     */
    public java.util.List<com.google.datastore.v1.EntityResult> getEntityResultsList() {
      if (entityResultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(entityResults_);
      } else {
        return entityResultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
     */
    public int getEntityResultsCount() {
      if (entityResultsBuilder_ == null) {
        return entityResults_.size();
      } else {
        return entityResultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
     */
    public com.google.datastore.v1.EntityResult getEntityResults(int index) {
      if (entityResultsBuilder_ == null) {
        return entityResults_.get(index);
      } else {
        return entityResultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
     */
    public Builder setEntityResults(int index, com.google.datastore.v1.EntityResult value) {
      if (entityResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntityResultsIsMutable();
        entityResults_.set(index, value);
        onChanged();
      } else {
        entityResultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
     */
    public Builder setEntityResults(
        int index, com.google.datastore.v1.EntityResult.Builder builderForValue) {
      if (entityResultsBuilder_ == null) {
        ensureEntityResultsIsMutable();
        entityResults_.set(index, builderForValue.build());
        onChanged();
      } else {
        entityResultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
     */
    public Builder addEntityResults(com.google.datastore.v1.EntityResult value) {
      if (entityResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntityResultsIsMutable();
        entityResults_.add(value);
        onChanged();
      } else {
        entityResultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
     */
    public Builder addEntityResults(int index, com.google.datastore.v1.EntityResult value) {
      if (entityResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntityResultsIsMutable();
        entityResults_.add(index, value);
        onChanged();
      } else {
        entityResultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
     */
    public Builder addEntityResults(com.google.datastore.v1.EntityResult.Builder builderForValue) {
      if (entityResultsBuilder_ == null) {
        ensureEntityResultsIsMutable();
        entityResults_.add(builderForValue.build());
        onChanged();
      } else {
        entityResultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
     */
    public Builder addEntityResults(
        int index, com.google.datastore.v1.EntityResult.Builder builderForValue) {
      if (entityResultsBuilder_ == null) {
        ensureEntityResultsIsMutable();
        entityResults_.add(index, builderForValue.build());
        onChanged();
      } else {
        entityResultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
     */
    public Builder addAllEntityResults(
        java.lang.Iterable<? extends com.google.datastore.v1.EntityResult> values) {
      if (entityResultsBuilder_ == null) {
        ensureEntityResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, entityResults_);
        onChanged();
      } else {
        entityResultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
     */
    public Builder clearEntityResults() {
      if (entityResultsBuilder_ == null) {
        entityResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        entityResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
     */
    public Builder removeEntityResults(int index) {
      if (entityResultsBuilder_ == null) {
        ensureEntityResultsIsMutable();
        entityResults_.remove(index);
        onChanged();
      } else {
        entityResultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
     */
    public com.google.datastore.v1.EntityResult.Builder getEntityResultsBuilder(int index) {
      return getEntityResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
     */
    public com.google.datastore.v1.EntityResultOrBuilder getEntityResultsOrBuilder(int index) {
      if (entityResultsBuilder_ == null) {
        return entityResults_.get(index);
      } else {
        return entityResultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
     */
    public java.util.List<? extends com.google.datastore.v1.EntityResultOrBuilder>
        getEntityResultsOrBuilderList() {
      if (entityResultsBuilder_ != null) {
        return entityResultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(entityResults_);
      }
    }
    /**
     *
     *
     * <pre>
     * The results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
     */
    public com.google.datastore.v1.EntityResult.Builder addEntityResultsBuilder() {
      return getEntityResultsFieldBuilder()
          .addBuilder(com.google.datastore.v1.EntityResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
     */
    public com.google.datastore.v1.EntityResult.Builder addEntityResultsBuilder(int index) {
      return getEntityResultsFieldBuilder()
          .addBuilder(index, com.google.datastore.v1.EntityResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The results for this batch.
     * </pre>
     *
     * <code>repeated .google.datastore.v1.EntityResult entity_results = 2;</code>
     */
    public java.util.List<com.google.datastore.v1.EntityResult.Builder>
        getEntityResultsBuilderList() {
      return getEntityResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.datastore.v1.EntityResult,
            com.google.datastore.v1.EntityResult.Builder,
            com.google.datastore.v1.EntityResultOrBuilder>
        getEntityResultsFieldBuilder() {
      if (entityResultsBuilder_ == null) {
        entityResultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.datastore.v1.EntityResult,
                com.google.datastore.v1.EntityResult.Builder,
                com.google.datastore.v1.EntityResultOrBuilder>(
                entityResults_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        entityResults_ = null;
      }
      return entityResultsBuilder_;
    }

    private com.google.protobuf.ByteString endCursor_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * A cursor that points to the position after the last result in the batch.
     * </pre>
     *
     * <code>bytes end_cursor = 4;</code>
     *
     * @return The endCursor.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEndCursor() {
      return endCursor_;
    }
    /**
     *
     *
     * <pre>
     * A cursor that points to the position after the last result in the batch.
     * </pre>
     *
     * <code>bytes end_cursor = 4;</code>
     *
     * @param value The endCursor to set.
     * @return This builder for chaining.
     */
    public Builder setEndCursor(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      endCursor_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A cursor that points to the position after the last result in the batch.
     * </pre>
     *
     * <code>bytes end_cursor = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndCursor() {

      endCursor_ = getDefaultInstance().getEndCursor();
      onChanged();
      return this;
    }

    private int moreResults_ = 0;
    /**
     *
     *
     * <pre>
     * The state of the query after the current batch.
     * </pre>
     *
     * <code>.google.datastore.v1.QueryResultBatch.MoreResultsType more_results = 5;</code>
     *
     * @return The enum numeric value on the wire for moreResults.
     */
    @java.lang.Override
    public int getMoreResultsValue() {
      return moreResults_;
    }
    /**
     *
     *
     * <pre>
     * The state of the query after the current batch.
     * </pre>
     *
     * <code>.google.datastore.v1.QueryResultBatch.MoreResultsType more_results = 5;</code>
     *
     * @param value The enum numeric value on the wire for moreResults to set.
     * @return This builder for chaining.
     */
    public Builder setMoreResultsValue(int value) {

      moreResults_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the query after the current batch.
     * </pre>
     *
     * <code>.google.datastore.v1.QueryResultBatch.MoreResultsType more_results = 5;</code>
     *
     * @return The moreResults.
     */
    @java.lang.Override
    public com.google.datastore.v1.QueryResultBatch.MoreResultsType getMoreResults() {
      @SuppressWarnings("deprecation")
      com.google.datastore.v1.QueryResultBatch.MoreResultsType result =
          com.google.datastore.v1.QueryResultBatch.MoreResultsType.valueOf(moreResults_);
      return result == null
          ? com.google.datastore.v1.QueryResultBatch.MoreResultsType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The state of the query after the current batch.
     * </pre>
     *
     * <code>.google.datastore.v1.QueryResultBatch.MoreResultsType more_results = 5;</code>
     *
     * @param value The moreResults to set.
     * @return This builder for chaining.
     */
    public Builder setMoreResults(com.google.datastore.v1.QueryResultBatch.MoreResultsType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      moreResults_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the query after the current batch.
     * </pre>
     *
     * <code>.google.datastore.v1.QueryResultBatch.MoreResultsType more_results = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMoreResults() {

      moreResults_ = 0;
      onChanged();
      return this;
    }

    private long snapshotVersion_;
    /**
     *
     *
     * <pre>
     * The version number of the snapshot this batch was returned from.
     * This applies to the range of results from the query's `start_cursor` (or
     * the beginning of the query if no cursor was given) to this batch's
     * `end_cursor` (not the query's `end_cursor`).
     * In a single transaction, subsequent query result batches for the same query
     * can have a greater snapshot version number. Each batch's snapshot version
     * is valid for all preceding batches.
     * The value will be zero for eventually consistent queries.
     * </pre>
     *
     * <code>int64 snapshot_version = 7;</code>
     *
     * @return The snapshotVersion.
     */
    @java.lang.Override
    public long getSnapshotVersion() {
      return snapshotVersion_;
    }
    /**
     *
     *
     * <pre>
     * The version number of the snapshot this batch was returned from.
     * This applies to the range of results from the query's `start_cursor` (or
     * the beginning of the query if no cursor was given) to this batch's
     * `end_cursor` (not the query's `end_cursor`).
     * In a single transaction, subsequent query result batches for the same query
     * can have a greater snapshot version number. Each batch's snapshot version
     * is valid for all preceding batches.
     * The value will be zero for eventually consistent queries.
     * </pre>
     *
     * <code>int64 snapshot_version = 7;</code>
     *
     * @param value The snapshotVersion to set.
     * @return This builder for chaining.
     */
    public Builder setSnapshotVersion(long value) {

      snapshotVersion_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The version number of the snapshot this batch was returned from.
     * This applies to the range of results from the query's `start_cursor` (or
     * the beginning of the query if no cursor was given) to this batch's
     * `end_cursor` (not the query's `end_cursor`).
     * In a single transaction, subsequent query result batches for the same query
     * can have a greater snapshot version number. Each batch's snapshot version
     * is valid for all preceding batches.
     * The value will be zero for eventually consistent queries.
     * </pre>
     *
     * <code>int64 snapshot_version = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSnapshotVersion() {

      snapshotVersion_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.datastore.v1.QueryResultBatch)
  }

  // @@protoc_insertion_point(class_scope:google.datastore.v1.QueryResultBatch)
  private static final com.google.datastore.v1.QueryResultBatch DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.datastore.v1.QueryResultBatch();
  }

  public static com.google.datastore.v1.QueryResultBatch getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QueryResultBatch> PARSER =
      new com.google.protobuf.AbstractParser<QueryResultBatch>() {
        @java.lang.Override
        public QueryResultBatch parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new QueryResultBatch(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<QueryResultBatch> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QueryResultBatch> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.datastore.v1.QueryResultBatch getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
