/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datastream/v1/datastream_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.datastream.v1;

/**
 *
 *
 * <pre>
 * Represents a backfill job on a specific stream object.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datastream.v1.BackfillJob}
 */
public final class BackfillJob extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1.BackfillJob)
    BackfillJobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BackfillJob.newBuilder() to construct.
  private BackfillJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BackfillJob() {
    state_ = 0;
    trigger_ = 0;
    errors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BackfillJob();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datastream.v1.DatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1_BackfillJob_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datastream.v1.DatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1_BackfillJob_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datastream.v1.BackfillJob.class,
            com.google.cloud.datastream.v1.BackfillJob.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * State of the stream object's backfill job.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.datastream.v1.BackfillJob.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Backfill job was never started for the stream object (stream has backfill
     * strategy defined as manual or object was explicitly excluded from
     * automatic backfill).
     * </pre>
     *
     * <code>NOT_STARTED = 1;</code>
     */
    NOT_STARTED(1),
    /**
     *
     *
     * <pre>
     * Backfill job will start pending available resources.
     * </pre>
     *
     * <code>PENDING = 2;</code>
     */
    PENDING(2),
    /**
     *
     *
     * <pre>
     * Backfill job is running.
     * </pre>
     *
     * <code>ACTIVE = 3;</code>
     */
    ACTIVE(3),
    /**
     *
     *
     * <pre>
     * Backfill job stopped (next job run will start from beginning).
     * </pre>
     *
     * <code>STOPPED = 4;</code>
     */
    STOPPED(4),
    /**
     *
     *
     * <pre>
     * Backfill job failed (due to an error).
     * </pre>
     *
     * <code>FAILED = 5;</code>
     */
    FAILED(5),
    /**
     *
     *
     * <pre>
     * Backfill completed successfully.
     * </pre>
     *
     * <code>COMPLETED = 6;</code>
     */
    COMPLETED(6),
    /**
     *
     *
     * <pre>
     * Backfill job failed since the table structure is currently unsupported
     * for backfill.
     * </pre>
     *
     * <code>UNSUPPORTED = 7;</code>
     */
    UNSUPPORTED(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Backfill job was never started for the stream object (stream has backfill
     * strategy defined as manual or object was explicitly excluded from
     * automatic backfill).
     * </pre>
     *
     * <code>NOT_STARTED = 1;</code>
     */
    public static final int NOT_STARTED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Backfill job will start pending available resources.
     * </pre>
     *
     * <code>PENDING = 2;</code>
     */
    public static final int PENDING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Backfill job is running.
     * </pre>
     *
     * <code>ACTIVE = 3;</code>
     */
    public static final int ACTIVE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Backfill job stopped (next job run will start from beginning).
     * </pre>
     *
     * <code>STOPPED = 4;</code>
     */
    public static final int STOPPED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Backfill job failed (due to an error).
     * </pre>
     *
     * <code>FAILED = 5;</code>
     */
    public static final int FAILED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Backfill completed successfully.
     * </pre>
     *
     * <code>COMPLETED = 6;</code>
     */
    public static final int COMPLETED_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Backfill job failed since the table structure is currently unsupported
     * for backfill.
     * </pre>
     *
     * <code>UNSUPPORTED = 7;</code>
     */
    public static final int UNSUPPORTED_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return NOT_STARTED;
        case 2:
          return PENDING;
        case 3:
          return ACTIVE;
        case 4:
          return STOPPED;
        case 5:
          return FAILED;
        case 6:
          return COMPLETED;
        case 7:
          return UNSUPPORTED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.datastream.v1.BackfillJob.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.datastream.v1.BackfillJob.State)
  }

  /**
   *
   *
   * <pre>
   * Triggering reason for a backfill job.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.datastream.v1.BackfillJob.Trigger}
   */
  public enum Trigger implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>TRIGGER_UNSPECIFIED = 0;</code>
     */
    TRIGGER_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Object backfill job was triggered automatically according to the stream's
     * backfill strategy.
     * </pre>
     *
     * <code>AUTOMATIC = 1;</code>
     */
    AUTOMATIC(1),
    /**
     *
     *
     * <pre>
     * Object backfill job was triggered manually using the dedicated API.
     * </pre>
     *
     * <code>MANUAL = 2;</code>
     */
    MANUAL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>TRIGGER_UNSPECIFIED = 0;</code>
     */
    public static final int TRIGGER_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Object backfill job was triggered automatically according to the stream's
     * backfill strategy.
     * </pre>
     *
     * <code>AUTOMATIC = 1;</code>
     */
    public static final int AUTOMATIC_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Object backfill job was triggered manually using the dedicated API.
     * </pre>
     *
     * <code>MANUAL = 2;</code>
     */
    public static final int MANUAL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Trigger valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Trigger forNumber(int value) {
      switch (value) {
        case 0:
          return TRIGGER_UNSPECIFIED;
        case 1:
          return AUTOMATIC;
        case 2:
          return MANUAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Trigger> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Trigger> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Trigger>() {
          public Trigger findValueByNumber(int number) {
            return Trigger.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.datastream.v1.BackfillJob.getDescriptor().getEnumTypes().get(1);
    }

    private static final Trigger[] VALUES = values();

    public static Trigger valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Trigger(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.datastream.v1.BackfillJob.Trigger)
  }

  private int bitField0_;
  public static final int STATE_FIELD_NUMBER = 1;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Backfill job state.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.BackfillJob.State state = 1;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Backfill job state.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.BackfillJob.State state = 1;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.BackfillJob.State getState() {
    com.google.cloud.datastream.v1.BackfillJob.State result =
        com.google.cloud.datastream.v1.BackfillJob.State.forNumber(state_);
    return result == null ? com.google.cloud.datastream.v1.BackfillJob.State.UNRECOGNIZED : result;
  }

  public static final int TRIGGER_FIELD_NUMBER = 2;
  private int trigger_ = 0;
  /**
   *
   *
   * <pre>
   * Backfill job's triggering reason.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.BackfillJob.Trigger trigger = 2;</code>
   *
   * @return The enum numeric value on the wire for trigger.
   */
  @java.lang.Override
  public int getTriggerValue() {
    return trigger_;
  }
  /**
   *
   *
   * <pre>
   * Backfill job's triggering reason.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.BackfillJob.Trigger trigger = 2;</code>
   *
   * @return The trigger.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.BackfillJob.Trigger getTrigger() {
    com.google.cloud.datastream.v1.BackfillJob.Trigger result =
        com.google.cloud.datastream.v1.BackfillJob.Trigger.forNumber(trigger_);
    return result == null
        ? com.google.cloud.datastream.v1.BackfillJob.Trigger.UNRECOGNIZED
        : result;
  }

  public static final int LAST_START_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp lastStartTime_;
  /**
   *
   *
   * <pre>
   * Output only. Backfill job's start time.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastStartTime field is set.
   */
  @java.lang.Override
  public boolean hasLastStartTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Backfill job's start time.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastStartTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastStartTime() {
    return lastStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastStartTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Backfill job's start time.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastStartTimeOrBuilder() {
    return lastStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : lastStartTime_;
  }

  public static final int LAST_END_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp lastEndTime_;
  /**
   *
   *
   * <pre>
   * Output only. Backfill job's end time.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_end_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the lastEndTime field is set.
   */
  @java.lang.Override
  public boolean hasLastEndTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Backfill job's end time.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_end_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The lastEndTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getLastEndTime() {
    return lastEndTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : lastEndTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Backfill job's end time.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp last_end_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getLastEndTimeOrBuilder() {
    return lastEndTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : lastEndTime_;
  }

  public static final int ERRORS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.datastream.v1.Error> errors_;
  /**
   *
   *
   * <pre>
   * Output only. Errors which caused the backfill job to fail.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datastream.v1.Error> getErrorsList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors which caused the backfill job to fail.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.datastream.v1.ErrorOrBuilder>
      getErrorsOrBuilderList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors which caused the backfill job to fail.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getErrorsCount() {
    return errors_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors which caused the backfill job to fail.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.Error getErrors(int index) {
    return errors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors which caused the backfill job to fail.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.ErrorOrBuilder getErrorsOrBuilder(int index) {
    return errors_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (state_ != com.google.cloud.datastream.v1.BackfillJob.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, state_);
    }
    if (trigger_
        != com.google.cloud.datastream.v1.BackfillJob.Trigger.TRIGGER_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, trigger_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getLastStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getLastEndTime());
    }
    for (int i = 0; i < errors_.size(); i++) {
      output.writeMessage(5, errors_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (state_ != com.google.cloud.datastream.v1.BackfillJob.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
    }
    if (trigger_
        != com.google.cloud.datastream.v1.BackfillJob.Trigger.TRIGGER_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, trigger_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getLastStartTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getLastEndTime());
    }
    for (int i = 0; i < errors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, errors_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datastream.v1.BackfillJob)) {
      return super.equals(obj);
    }
    com.google.cloud.datastream.v1.BackfillJob other =
        (com.google.cloud.datastream.v1.BackfillJob) obj;

    if (state_ != other.state_) return false;
    if (trigger_ != other.trigger_) return false;
    if (hasLastStartTime() != other.hasLastStartTime()) return false;
    if (hasLastStartTime()) {
      if (!getLastStartTime().equals(other.getLastStartTime())) return false;
    }
    if (hasLastEndTime() != other.hasLastEndTime()) return false;
    if (hasLastEndTime()) {
      if (!getLastEndTime().equals(other.getLastEndTime())) return false;
    }
    if (!getErrorsList().equals(other.getErrorsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + TRIGGER_FIELD_NUMBER;
    hash = (53 * hash) + trigger_;
    if (hasLastStartTime()) {
      hash = (37 * hash) + LAST_START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastStartTime().hashCode();
    }
    if (hasLastEndTime()) {
      hash = (37 * hash) + LAST_END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getLastEndTime().hashCode();
    }
    if (getErrorsCount() > 0) {
      hash = (37 * hash) + ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getErrorsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datastream.v1.BackfillJob parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.BackfillJob parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.BackfillJob parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.BackfillJob parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.BackfillJob parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.BackfillJob parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.BackfillJob parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.BackfillJob parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.BackfillJob parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.BackfillJob parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.BackfillJob parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.BackfillJob parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datastream.v1.BackfillJob prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents a backfill job on a specific stream object.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datastream.v1.BackfillJob}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1.BackfillJob)
      com.google.cloud.datastream.v1.BackfillJobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_BackfillJob_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_BackfillJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1.BackfillJob.class,
              com.google.cloud.datastream.v1.BackfillJob.Builder.class);
    }

    // Construct using com.google.cloud.datastream.v1.BackfillJob.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLastStartTimeFieldBuilder();
        getLastEndTimeFieldBuilder();
        getErrorsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      state_ = 0;
      trigger_ = 0;
      lastStartTime_ = null;
      if (lastStartTimeBuilder_ != null) {
        lastStartTimeBuilder_.dispose();
        lastStartTimeBuilder_ = null;
      }
      lastEndTime_ = null;
      if (lastEndTimeBuilder_ != null) {
        lastEndTimeBuilder_.dispose();
        lastEndTimeBuilder_ = null;
      }
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
      } else {
        errors_ = null;
        errorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_BackfillJob_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.BackfillJob getDefaultInstanceForType() {
      return com.google.cloud.datastream.v1.BackfillJob.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.BackfillJob build() {
      com.google.cloud.datastream.v1.BackfillJob result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.BackfillJob buildPartial() {
      com.google.cloud.datastream.v1.BackfillJob result =
          new com.google.cloud.datastream.v1.BackfillJob(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.datastream.v1.BackfillJob result) {
      if (errorsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          errors_ = java.util.Collections.unmodifiableList(errors_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.errors_ = errors_;
      } else {
        result.errors_ = errorsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.datastream.v1.BackfillJob result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.trigger_ = trigger_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.lastStartTime_ =
            lastStartTimeBuilder_ == null ? lastStartTime_ : lastStartTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.lastEndTime_ =
            lastEndTimeBuilder_ == null ? lastEndTime_ : lastEndTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datastream.v1.BackfillJob) {
        return mergeFrom((com.google.cloud.datastream.v1.BackfillJob) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datastream.v1.BackfillJob other) {
      if (other == com.google.cloud.datastream.v1.BackfillJob.getDefaultInstance()) return this;
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.trigger_ != 0) {
        setTriggerValue(other.getTriggerValue());
      }
      if (other.hasLastStartTime()) {
        mergeLastStartTime(other.getLastStartTime());
      }
      if (other.hasLastEndTime()) {
        mergeLastEndTime(other.getLastEndTime());
      }
      if (errorsBuilder_ == null) {
        if (!other.errors_.isEmpty()) {
          if (errors_.isEmpty()) {
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureErrorsIsMutable();
            errors_.addAll(other.errors_);
          }
          onChanged();
        }
      } else {
        if (!other.errors_.isEmpty()) {
          if (errorsBuilder_.isEmpty()) {
            errorsBuilder_.dispose();
            errorsBuilder_ = null;
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000010);
            errorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getErrorsFieldBuilder()
                    : null;
          } else {
            errorsBuilder_.addAllMessages(other.errors_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 16:
              {
                trigger_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getLastStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getLastEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.datastream.v1.Error m =
                    input.readMessage(
                        com.google.cloud.datastream.v1.Error.parser(), extensionRegistry);
                if (errorsBuilder_ == null) {
                  ensureErrorsIsMutable();
                  errors_.add(m);
                } else {
                  errorsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Backfill job state.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.BackfillJob.State state = 1;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Backfill job state.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.BackfillJob.State state = 1;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Backfill job state.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.BackfillJob.State state = 1;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.BackfillJob.State getState() {
      com.google.cloud.datastream.v1.BackfillJob.State result =
          com.google.cloud.datastream.v1.BackfillJob.State.forNumber(state_);
      return result == null
          ? com.google.cloud.datastream.v1.BackfillJob.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Backfill job state.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.BackfillJob.State state = 1;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.datastream.v1.BackfillJob.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Backfill job state.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.BackfillJob.State state = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000001);
      state_ = 0;
      onChanged();
      return this;
    }

    private int trigger_ = 0;
    /**
     *
     *
     * <pre>
     * Backfill job's triggering reason.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.BackfillJob.Trigger trigger = 2;</code>
     *
     * @return The enum numeric value on the wire for trigger.
     */
    @java.lang.Override
    public int getTriggerValue() {
      return trigger_;
    }
    /**
     *
     *
     * <pre>
     * Backfill job's triggering reason.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.BackfillJob.Trigger trigger = 2;</code>
     *
     * @param value The enum numeric value on the wire for trigger to set.
     * @return This builder for chaining.
     */
    public Builder setTriggerValue(int value) {
      trigger_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Backfill job's triggering reason.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.BackfillJob.Trigger trigger = 2;</code>
     *
     * @return The trigger.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.BackfillJob.Trigger getTrigger() {
      com.google.cloud.datastream.v1.BackfillJob.Trigger result =
          com.google.cloud.datastream.v1.BackfillJob.Trigger.forNumber(trigger_);
      return result == null
          ? com.google.cloud.datastream.v1.BackfillJob.Trigger.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Backfill job's triggering reason.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.BackfillJob.Trigger trigger = 2;</code>
     *
     * @param value The trigger to set.
     * @return This builder for chaining.
     */
    public Builder setTrigger(com.google.cloud.datastream.v1.BackfillJob.Trigger value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      trigger_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Backfill job's triggering reason.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.BackfillJob.Trigger trigger = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTrigger() {
      bitField0_ = (bitField0_ & ~0x00000002);
      trigger_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp lastStartTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastStartTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Backfill job's start time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastStartTime field is set.
     */
    public boolean hasLastStartTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Backfill job's start time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastStartTime.
     */
    public com.google.protobuf.Timestamp getLastStartTime() {
      if (lastStartTimeBuilder_ == null) {
        return lastStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastStartTime_;
      } else {
        return lastStartTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Backfill job's start time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastStartTime(com.google.protobuf.Timestamp value) {
      if (lastStartTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastStartTime_ = value;
      } else {
        lastStartTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Backfill job's start time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastStartTimeBuilder_ == null) {
        lastStartTime_ = builderForValue.build();
      } else {
        lastStartTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Backfill job's start time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastStartTime(com.google.protobuf.Timestamp value) {
      if (lastStartTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && lastStartTime_ != null
            && lastStartTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastStartTimeBuilder().mergeFrom(value);
        } else {
          lastStartTime_ = value;
        }
      } else {
        lastStartTimeBuilder_.mergeFrom(value);
      }
      if (lastStartTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Backfill job's start time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastStartTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      lastStartTime_ = null;
      if (lastStartTimeBuilder_ != null) {
        lastStartTimeBuilder_.dispose();
        lastStartTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Backfill job's start time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLastStartTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getLastStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Backfill job's start time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastStartTimeOrBuilder() {
      if (lastStartTimeBuilder_ != null) {
        return lastStartTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastStartTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Backfill job's start time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_start_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastStartTimeFieldBuilder() {
      if (lastStartTimeBuilder_ == null) {
        lastStartTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastStartTime(), getParentForChildren(), isClean());
        lastStartTime_ = null;
      }
      return lastStartTimeBuilder_;
    }

    private com.google.protobuf.Timestamp lastEndTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        lastEndTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Backfill job's end time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_end_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the lastEndTime field is set.
     */
    public boolean hasLastEndTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Backfill job's end time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_end_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The lastEndTime.
     */
    public com.google.protobuf.Timestamp getLastEndTime() {
      if (lastEndTimeBuilder_ == null) {
        return lastEndTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastEndTime_;
      } else {
        return lastEndTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Backfill job's end time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_end_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastEndTime(com.google.protobuf.Timestamp value) {
      if (lastEndTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastEndTime_ = value;
      } else {
        lastEndTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Backfill job's end time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_end_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setLastEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (lastEndTimeBuilder_ == null) {
        lastEndTime_ = builderForValue.build();
      } else {
        lastEndTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Backfill job's end time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_end_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeLastEndTime(com.google.protobuf.Timestamp value) {
      if (lastEndTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && lastEndTime_ != null
            && lastEndTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getLastEndTimeBuilder().mergeFrom(value);
        } else {
          lastEndTime_ = value;
        }
      } else {
        lastEndTimeBuilder_.mergeFrom(value);
      }
      if (lastEndTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Backfill job's end time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_end_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearLastEndTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      lastEndTime_ = null;
      if (lastEndTimeBuilder_ != null) {
        lastEndTimeBuilder_.dispose();
        lastEndTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Backfill job's end time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_end_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getLastEndTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getLastEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Backfill job's end time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_end_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getLastEndTimeOrBuilder() {
      if (lastEndTimeBuilder_ != null) {
        return lastEndTimeBuilder_.getMessageOrBuilder();
      } else {
        return lastEndTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : lastEndTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Backfill job's end time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp last_end_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getLastEndTimeFieldBuilder() {
      if (lastEndTimeBuilder_ == null) {
        lastEndTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getLastEndTime(), getParentForChildren(), isClean());
        lastEndTime_ = null;
      }
      return lastEndTimeBuilder_;
    }

    private java.util.List<com.google.cloud.datastream.v1.Error> errors_ =
        java.util.Collections.emptyList();

    private void ensureErrorsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        errors_ = new java.util.ArrayList<com.google.cloud.datastream.v1.Error>(errors_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datastream.v1.Error,
            com.google.cloud.datastream.v1.Error.Builder,
            com.google.cloud.datastream.v1.ErrorOrBuilder>
        errorsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Errors which caused the backfill job to fail.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.datastream.v1.Error> getErrorsList() {
      if (errorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(errors_);
      } else {
        return errorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors which caused the backfill job to fail.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getErrorsCount() {
      if (errorsBuilder_ == null) {
        return errors_.size();
      } else {
        return errorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors which caused the backfill job to fail.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datastream.v1.Error getErrors(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors which caused the backfill job to fail.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setErrors(int index, com.google.cloud.datastream.v1.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.set(index, value);
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors which caused the backfill job to fail.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setErrors(
        int index, com.google.cloud.datastream.v1.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.set(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors which caused the backfill job to fail.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(com.google.cloud.datastream.v1.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors which caused the backfill job to fail.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(int index, com.google.cloud.datastream.v1.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(index, value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors which caused the backfill job to fail.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(com.google.cloud.datastream.v1.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors which caused the backfill job to fail.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(
        int index, com.google.cloud.datastream.v1.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors which caused the backfill job to fail.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllErrors(
        java.lang.Iterable<? extends com.google.cloud.datastream.v1.Error> values) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, errors_);
        onChanged();
      } else {
        errorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors which caused the backfill job to fail.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearErrors() {
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        errorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors which caused the backfill job to fail.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeErrors(int index) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.remove(index);
        onChanged();
      } else {
        errorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors which caused the backfill job to fail.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datastream.v1.Error.Builder getErrorsBuilder(int index) {
      return getErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors which caused the backfill job to fail.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datastream.v1.ErrorOrBuilder getErrorsOrBuilder(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors which caused the backfill job to fail.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.datastream.v1.ErrorOrBuilder>
        getErrorsOrBuilderList() {
      if (errorsBuilder_ != null) {
        return errorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(errors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors which caused the backfill job to fail.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datastream.v1.Error.Builder addErrorsBuilder() {
      return getErrorsFieldBuilder()
          .addBuilder(com.google.cloud.datastream.v1.Error.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors which caused the backfill job to fail.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datastream.v1.Error.Builder addErrorsBuilder(int index) {
      return getErrorsFieldBuilder()
          .addBuilder(index, com.google.cloud.datastream.v1.Error.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors which caused the backfill job to fail.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1.Error errors = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.datastream.v1.Error.Builder> getErrorsBuilderList() {
      return getErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datastream.v1.Error,
            com.google.cloud.datastream.v1.Error.Builder,
            com.google.cloud.datastream.v1.ErrorOrBuilder>
        getErrorsFieldBuilder() {
      if (errorsBuilder_ == null) {
        errorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datastream.v1.Error,
                com.google.cloud.datastream.v1.Error.Builder,
                com.google.cloud.datastream.v1.ErrorOrBuilder>(
                errors_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        errors_ = null;
      }
      return errorsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1.BackfillJob)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1.BackfillJob)
  private static final com.google.cloud.datastream.v1.BackfillJob DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datastream.v1.BackfillJob();
  }

  public static com.google.cloud.datastream.v1.BackfillJob getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BackfillJob> PARSER =
      new com.google.protobuf.AbstractParser<BackfillJob>() {
        @java.lang.Override
        public BackfillJob parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BackfillJob> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BackfillJob> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datastream.v1.BackfillJob getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
