/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datastream/v1/datastream_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.datastream.v1;

/**
 *
 *
 * <pre>
 * Represent a user-facing Error.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datastream.v1.Error}
 */
public final class Error extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1.Error)
    ErrorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Error.newBuilder() to construct.
  private Error(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Error() {
    reason_ = "";
    errorUuid_ = "";
    message_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Error();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datastream.v1.DatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1_Error_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 5:
        return internalGetDetails();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datastream.v1.DatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1_Error_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datastream.v1.Error.class,
            com.google.cloud.datastream.v1.Error.Builder.class);
  }

  private int bitField0_;
  public static final int REASON_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object reason_ = "";
  /**
   *
   *
   * <pre>
   * A title that explains the reason for the error.
   * </pre>
   *
   * <code>string reason = 1;</code>
   *
   * @return The reason.
   */
  @java.lang.Override
  public java.lang.String getReason() {
    java.lang.Object ref = reason_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      reason_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A title that explains the reason for the error.
   * </pre>
   *
   * <code>string reason = 1;</code>
   *
   * @return The bytes for reason.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReasonBytes() {
    java.lang.Object ref = reason_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      reason_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERROR_UUID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object errorUuid_ = "";
  /**
   *
   *
   * <pre>
   * A unique identifier for this specific error,
   * allowing it to be traced throughout the system in logs and API responses.
   * </pre>
   *
   * <code>string error_uuid = 2;</code>
   *
   * @return The errorUuid.
   */
  @java.lang.Override
  public java.lang.String getErrorUuid() {
    java.lang.Object ref = errorUuid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      errorUuid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A unique identifier for this specific error,
   * allowing it to be traced throughout the system in logs and API responses.
   * </pre>
   *
   * <code>string error_uuid = 2;</code>
   *
   * @return The bytes for errorUuid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getErrorUuidBytes() {
    java.lang.Object ref = errorUuid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      errorUuid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MESSAGE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object message_ = "";
  /**
   *
   *
   * <pre>
   * A message containing more information about the error that occurred.
   * </pre>
   *
   * <code>string message = 3;</code>
   *
   * @return The message.
   */
  @java.lang.Override
  public java.lang.String getMessage() {
    java.lang.Object ref = message_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      message_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A message containing more information about the error that occurred.
   * </pre>
   *
   * <code>string message = 3;</code>
   *
   * @return The bytes for message.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMessageBytes() {
    java.lang.Object ref = message_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      message_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ERROR_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp errorTime_;
  /**
   *
   *
   * <pre>
   * The time when the error occurred.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp error_time = 4;</code>
   *
   * @return Whether the errorTime field is set.
   */
  @java.lang.Override
  public boolean hasErrorTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The time when the error occurred.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp error_time = 4;</code>
   *
   * @return The errorTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getErrorTime() {
    return errorTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : errorTime_;
  }
  /**
   *
   *
   * <pre>
   * The time when the error occurred.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp error_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getErrorTimeOrBuilder() {
    return errorTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : errorTime_;
  }

  public static final int DETAILS_FIELD_NUMBER = 5;

  private static final class DetailsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.datastream.v1.DatastreamResourcesProto
                .internal_static_google_cloud_datastream_v1_Error_DetailsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> details_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetDetails() {
    if (details_ == null) {
      return com.google.protobuf.MapField.emptyMapField(DetailsDefaultEntryHolder.defaultEntry);
    }
    return details_;
  }

  public int getDetailsCount() {
    return internalGetDetails().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Additional information about the error.
   * </pre>
   *
   * <code>map&lt;string, string&gt; details = 5;</code>
   */
  @java.lang.Override
  public boolean containsDetails(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetDetails().getMap().containsKey(key);
  }
  /** Use {@link #getDetailsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getDetails() {
    return getDetailsMap();
  }
  /**
   *
   *
   * <pre>
   * Additional information about the error.
   * </pre>
   *
   * <code>map&lt;string, string&gt; details = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getDetailsMap() {
    return internalGetDetails().getMap();
  }
  /**
   *
   *
   * <pre>
   * Additional information about the error.
   * </pre>
   *
   * <code>map&lt;string, string&gt; details = 5;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getDetailsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDetails().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Additional information about the error.
   * </pre>
   *
   * <code>map&lt;string, string&gt; details = 5;</code>
   */
  @java.lang.Override
  public java.lang.String getDetailsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDetails().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reason_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, reason_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorUuid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, errorUuid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, message_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getErrorTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetDetails(), DetailsDefaultEntryHolder.defaultEntry, 5);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(reason_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, reason_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(errorUuid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, errorUuid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(message_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, message_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getErrorTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetDetails().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> details__ =
          DetailsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, details__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datastream.v1.Error)) {
      return super.equals(obj);
    }
    com.google.cloud.datastream.v1.Error other = (com.google.cloud.datastream.v1.Error) obj;

    if (!getReason().equals(other.getReason())) return false;
    if (!getErrorUuid().equals(other.getErrorUuid())) return false;
    if (!getMessage().equals(other.getMessage())) return false;
    if (hasErrorTime() != other.hasErrorTime()) return false;
    if (hasErrorTime()) {
      if (!getErrorTime().equals(other.getErrorTime())) return false;
    }
    if (!internalGetDetails().equals(other.internalGetDetails())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + REASON_FIELD_NUMBER;
    hash = (53 * hash) + getReason().hashCode();
    hash = (37 * hash) + ERROR_UUID_FIELD_NUMBER;
    hash = (53 * hash) + getErrorUuid().hashCode();
    hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
    hash = (53 * hash) + getMessage().hashCode();
    if (hasErrorTime()) {
      hash = (37 * hash) + ERROR_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getErrorTime().hashCode();
    }
    if (!internalGetDetails().getMap().isEmpty()) {
      hash = (37 * hash) + DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetDetails().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datastream.v1.Error parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.Error parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.Error parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.Error parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.Error parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.Error parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.Error parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.Error parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.Error parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.Error parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.Error parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.Error parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datastream.v1.Error prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represent a user-facing Error.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datastream.v1.Error}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1.Error)
      com.google.cloud.datastream.v1.ErrorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_Error_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetDetails();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 5:
          return internalGetMutableDetails();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_Error_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1.Error.class,
              com.google.cloud.datastream.v1.Error.Builder.class);
    }

    // Construct using com.google.cloud.datastream.v1.Error.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getErrorTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      reason_ = "";
      errorUuid_ = "";
      message_ = "";
      errorTime_ = null;
      if (errorTimeBuilder_ != null) {
        errorTimeBuilder_.dispose();
        errorTimeBuilder_ = null;
      }
      internalGetMutableDetails().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_Error_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.Error getDefaultInstanceForType() {
      return com.google.cloud.datastream.v1.Error.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.Error build() {
      com.google.cloud.datastream.v1.Error result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.Error buildPartial() {
      com.google.cloud.datastream.v1.Error result = new com.google.cloud.datastream.v1.Error(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datastream.v1.Error result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.reason_ = reason_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.errorUuid_ = errorUuid_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.message_ = message_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.errorTime_ = errorTimeBuilder_ == null ? errorTime_ : errorTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.details_ = internalGetDetails();
        result.details_.makeImmutable();
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datastream.v1.Error) {
        return mergeFrom((com.google.cloud.datastream.v1.Error) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datastream.v1.Error other) {
      if (other == com.google.cloud.datastream.v1.Error.getDefaultInstance()) return this;
      if (!other.getReason().isEmpty()) {
        reason_ = other.reason_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getErrorUuid().isEmpty()) {
        errorUuid_ = other.errorUuid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getMessage().isEmpty()) {
        message_ = other.message_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasErrorTime()) {
        mergeErrorTime(other.getErrorTime());
      }
      internalGetMutableDetails().mergeFrom(other.internalGetDetails());
      bitField0_ |= 0x00000010;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                reason_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                errorUuid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                message_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getErrorTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> details__ =
                    input.readMessage(
                        DetailsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableDetails()
                    .getMutableMap()
                    .put(details__.getKey(), details__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object reason_ = "";
    /**
     *
     *
     * <pre>
     * A title that explains the reason for the error.
     * </pre>
     *
     * <code>string reason = 1;</code>
     *
     * @return The reason.
     */
    public java.lang.String getReason() {
      java.lang.Object ref = reason_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        reason_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A title that explains the reason for the error.
     * </pre>
     *
     * <code>string reason = 1;</code>
     *
     * @return The bytes for reason.
     */
    public com.google.protobuf.ByteString getReasonBytes() {
      java.lang.Object ref = reason_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        reason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A title that explains the reason for the error.
     * </pre>
     *
     * <code>string reason = 1;</code>
     *
     * @param value The reason to set.
     * @return This builder for chaining.
     */
    public Builder setReason(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      reason_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A title that explains the reason for the error.
     * </pre>
     *
     * <code>string reason = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReason() {
      reason_ = getDefaultInstance().getReason();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A title that explains the reason for the error.
     * </pre>
     *
     * <code>string reason = 1;</code>
     *
     * @param value The bytes for reason to set.
     * @return This builder for chaining.
     */
    public Builder setReasonBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      reason_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object errorUuid_ = "";
    /**
     *
     *
     * <pre>
     * A unique identifier for this specific error,
     * allowing it to be traced throughout the system in logs and API responses.
     * </pre>
     *
     * <code>string error_uuid = 2;</code>
     *
     * @return The errorUuid.
     */
    public java.lang.String getErrorUuid() {
      java.lang.Object ref = errorUuid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorUuid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for this specific error,
     * allowing it to be traced throughout the system in logs and API responses.
     * </pre>
     *
     * <code>string error_uuid = 2;</code>
     *
     * @return The bytes for errorUuid.
     */
    public com.google.protobuf.ByteString getErrorUuidBytes() {
      java.lang.Object ref = errorUuid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        errorUuid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for this specific error,
     * allowing it to be traced throughout the system in logs and API responses.
     * </pre>
     *
     * <code>string error_uuid = 2;</code>
     *
     * @param value The errorUuid to set.
     * @return This builder for chaining.
     */
    public Builder setErrorUuid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      errorUuid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for this specific error,
     * allowing it to be traced throughout the system in logs and API responses.
     * </pre>
     *
     * <code>string error_uuid = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearErrorUuid() {
      errorUuid_ = getDefaultInstance().getErrorUuid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A unique identifier for this specific error,
     * allowing it to be traced throughout the system in logs and API responses.
     * </pre>
     *
     * <code>string error_uuid = 2;</code>
     *
     * @param value The bytes for errorUuid to set.
     * @return This builder for chaining.
     */
    public Builder setErrorUuidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      errorUuid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object message_ = "";
    /**
     *
     *
     * <pre>
     * A message containing more information about the error that occurred.
     * </pre>
     *
     * <code>string message = 3;</code>
     *
     * @return The message.
     */
    public java.lang.String getMessage() {
      java.lang.Object ref = message_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        message_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A message containing more information about the error that occurred.
     * </pre>
     *
     * <code>string message = 3;</code>
     *
     * @return The bytes for message.
     */
    public com.google.protobuf.ByteString getMessageBytes() {
      java.lang.Object ref = message_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        message_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A message containing more information about the error that occurred.
     * </pre>
     *
     * <code>string message = 3;</code>
     *
     * @param value The message to set.
     * @return This builder for chaining.
     */
    public Builder setMessage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      message_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A message containing more information about the error that occurred.
     * </pre>
     *
     * <code>string message = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMessage() {
      message_ = getDefaultInstance().getMessage();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A message containing more information about the error that occurred.
     * </pre>
     *
     * <code>string message = 3;</code>
     *
     * @param value The bytes for message to set.
     * @return This builder for chaining.
     */
    public Builder setMessageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      message_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp errorTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        errorTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time when the error occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp error_time = 4;</code>
     *
     * @return Whether the errorTime field is set.
     */
    public boolean hasErrorTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time when the error occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp error_time = 4;</code>
     *
     * @return The errorTime.
     */
    public com.google.protobuf.Timestamp getErrorTime() {
      if (errorTimeBuilder_ == null) {
        return errorTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : errorTime_;
      } else {
        return errorTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the error occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp error_time = 4;</code>
     */
    public Builder setErrorTime(com.google.protobuf.Timestamp value) {
      if (errorTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        errorTime_ = value;
      } else {
        errorTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the error occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp error_time = 4;</code>
     */
    public Builder setErrorTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (errorTimeBuilder_ == null) {
        errorTime_ = builderForValue.build();
      } else {
        errorTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the error occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp error_time = 4;</code>
     */
    public Builder mergeErrorTime(com.google.protobuf.Timestamp value) {
      if (errorTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && errorTime_ != null
            && errorTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getErrorTimeBuilder().mergeFrom(value);
        } else {
          errorTime_ = value;
        }
      } else {
        errorTimeBuilder_.mergeFrom(value);
      }
      if (errorTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the error occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp error_time = 4;</code>
     */
    public Builder clearErrorTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      errorTime_ = null;
      if (errorTimeBuilder_ != null) {
        errorTimeBuilder_.dispose();
        errorTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the error occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp error_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getErrorTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getErrorTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time when the error occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp error_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getErrorTimeOrBuilder() {
      if (errorTimeBuilder_ != null) {
        return errorTimeBuilder_.getMessageOrBuilder();
      } else {
        return errorTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : errorTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the error occurred.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp error_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getErrorTimeFieldBuilder() {
      if (errorTimeBuilder_ == null) {
        errorTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getErrorTime(), getParentForChildren(), isClean());
        errorTime_ = null;
      }
      return errorTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> details_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetDetails() {
      if (details_ == null) {
        return com.google.protobuf.MapField.emptyMapField(DetailsDefaultEntryHolder.defaultEntry);
      }
      return details_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableDetails() {
      if (details_ == null) {
        details_ = com.google.protobuf.MapField.newMapField(DetailsDefaultEntryHolder.defaultEntry);
      }
      if (!details_.isMutable()) {
        details_ = details_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return details_;
    }

    public int getDetailsCount() {
      return internalGetDetails().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Additional information about the error.
     * </pre>
     *
     * <code>map&lt;string, string&gt; details = 5;</code>
     */
    @java.lang.Override
    public boolean containsDetails(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetDetails().getMap().containsKey(key);
    }
    /** Use {@link #getDetailsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getDetails() {
      return getDetailsMap();
    }
    /**
     *
     *
     * <pre>
     * Additional information about the error.
     * </pre>
     *
     * <code>map&lt;string, string&gt; details = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getDetailsMap() {
      return internalGetDetails().getMap();
    }
    /**
     *
     *
     * <pre>
     * Additional information about the error.
     * </pre>
     *
     * <code>map&lt;string, string&gt; details = 5;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getDetailsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDetails().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Additional information about the error.
     * </pre>
     *
     * <code>map&lt;string, string&gt; details = 5;</code>
     */
    @java.lang.Override
    public java.lang.String getDetailsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDetails().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearDetails() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableDetails().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information about the error.
     * </pre>
     *
     * <code>map&lt;string, string&gt; details = 5;</code>
     */
    public Builder removeDetails(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableDetails().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableDetails() {
      bitField0_ |= 0x00000010;
      return internalGetMutableDetails().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Additional information about the error.
     * </pre>
     *
     * <code>map&lt;string, string&gt; details = 5;</code>
     */
    public Builder putDetails(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableDetails().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information about the error.
     * </pre>
     *
     * <code>map&lt;string, string&gt; details = 5;</code>
     */
    public Builder putAllDetails(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableDetails().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1.Error)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1.Error)
  private static final com.google.cloud.datastream.v1.Error DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datastream.v1.Error();
  }

  public static com.google.cloud.datastream.v1.Error getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Error> PARSER =
      new com.google.protobuf.AbstractParser<Error>() {
        @java.lang.Override
        public Error parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Error> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Error> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datastream.v1.Error getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
