/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datastream/v1/datastream_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.datastream.v1;

/**
 *
 *
 * <pre>
 * Oracle database profile.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datastream.v1.OracleProfile}
 */
public final class OracleProfile extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1.OracleProfile)
    OracleProfileOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OracleProfile.newBuilder() to construct.
  private OracleProfile(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OracleProfile() {
    hostname_ = "";
    username_ = "";
    password_ = "";
    databaseService_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OracleProfile();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datastream.v1.DatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1_OracleProfile_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 6:
        return internalGetConnectionAttributes();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datastream.v1.DatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1_OracleProfile_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datastream.v1.OracleProfile.class,
            com.google.cloud.datastream.v1.OracleProfile.Builder.class);
  }

  public static final int HOSTNAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object hostname_ = "";
  /**
   *
   *
   * <pre>
   * Required. Hostname for the Oracle connection.
   * </pre>
   *
   * <code>string hostname = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The hostname.
   */
  @java.lang.Override
  public java.lang.String getHostname() {
    java.lang.Object ref = hostname_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      hostname_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Hostname for the Oracle connection.
   * </pre>
   *
   * <code>string hostname = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for hostname.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHostnameBytes() {
    java.lang.Object ref = hostname_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      hostname_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PORT_FIELD_NUMBER = 2;
  private int port_ = 0;
  /**
   *
   *
   * <pre>
   * Port for the Oracle connection, default value is 1521.
   * </pre>
   *
   * <code>int32 port = 2;</code>
   *
   * @return The port.
   */
  @java.lang.Override
  public int getPort() {
    return port_;
  }

  public static final int USERNAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object username_ = "";
  /**
   *
   *
   * <pre>
   * Required. Username for the Oracle connection.
   * </pre>
   *
   * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The username.
   */
  @java.lang.Override
  public java.lang.String getUsername() {
    java.lang.Object ref = username_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      username_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Username for the Oracle connection.
   * </pre>
   *
   * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for username.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUsernameBytes() {
    java.lang.Object ref = username_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      username_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PASSWORD_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object password_ = "";
  /**
   *
   *
   * <pre>
   * Required. Password for the Oracle connection.
   * </pre>
   *
   * <code>string password = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The password.
   */
  @java.lang.Override
  public java.lang.String getPassword() {
    java.lang.Object ref = password_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      password_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Password for the Oracle connection.
   * </pre>
   *
   * <code>string password = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for password.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPasswordBytes() {
    java.lang.Object ref = password_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      password_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATABASE_SERVICE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object databaseService_ = "";
  /**
   *
   *
   * <pre>
   * Required. Database for the Oracle connection.
   * </pre>
   *
   * <code>string database_service = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The databaseService.
   */
  @java.lang.Override
  public java.lang.String getDatabaseService() {
    java.lang.Object ref = databaseService_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      databaseService_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Database for the Oracle connection.
   * </pre>
   *
   * <code>string database_service = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for databaseService.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatabaseServiceBytes() {
    java.lang.Object ref = databaseService_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      databaseService_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONNECTION_ATTRIBUTES_FIELD_NUMBER = 6;

  private static final class ConnectionAttributesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.datastream.v1.DatastreamResourcesProto
                .internal_static_google_cloud_datastream_v1_OracleProfile_ConnectionAttributesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> connectionAttributes_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetConnectionAttributes() {
    if (connectionAttributes_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          ConnectionAttributesDefaultEntryHolder.defaultEntry);
    }
    return connectionAttributes_;
  }

  public int getConnectionAttributesCount() {
    return internalGetConnectionAttributes().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Connection string attributes
   * </pre>
   *
   * <code>map&lt;string, string&gt; connection_attributes = 6;</code>
   */
  @java.lang.Override
  public boolean containsConnectionAttributes(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetConnectionAttributes().getMap().containsKey(key);
  }
  /** Use {@link #getConnectionAttributesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getConnectionAttributes() {
    return getConnectionAttributesMap();
  }
  /**
   *
   *
   * <pre>
   * Connection string attributes
   * </pre>
   *
   * <code>map&lt;string, string&gt; connection_attributes = 6;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getConnectionAttributesMap() {
    return internalGetConnectionAttributes().getMap();
  }
  /**
   *
   *
   * <pre>
   * Connection string attributes
   * </pre>
   *
   * <code>map&lt;string, string&gt; connection_attributes = 6;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getConnectionAttributesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetConnectionAttributes().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Connection string attributes
   * </pre>
   *
   * <code>map&lt;string, string&gt; connection_attributes = 6;</code>
   */
  @java.lang.Override
  public java.lang.String getConnectionAttributesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetConnectionAttributes().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostname_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, hostname_);
    }
    if (port_ != 0) {
      output.writeInt32(2, port_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, username_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, password_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(databaseService_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, databaseService_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetConnectionAttributes(),
        ConnectionAttributesDefaultEntryHolder.defaultEntry,
        6);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(hostname_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, hostname_);
    }
    if (port_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, port_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(username_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, username_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(password_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, password_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(databaseService_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, databaseService_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetConnectionAttributes().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> connectionAttributes__ =
          ConnectionAttributesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, connectionAttributes__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datastream.v1.OracleProfile)) {
      return super.equals(obj);
    }
    com.google.cloud.datastream.v1.OracleProfile other =
        (com.google.cloud.datastream.v1.OracleProfile) obj;

    if (!getHostname().equals(other.getHostname())) return false;
    if (getPort() != other.getPort()) return false;
    if (!getUsername().equals(other.getUsername())) return false;
    if (!getPassword().equals(other.getPassword())) return false;
    if (!getDatabaseService().equals(other.getDatabaseService())) return false;
    if (!internalGetConnectionAttributes().equals(other.internalGetConnectionAttributes()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + HOSTNAME_FIELD_NUMBER;
    hash = (53 * hash) + getHostname().hashCode();
    hash = (37 * hash) + PORT_FIELD_NUMBER;
    hash = (53 * hash) + getPort();
    hash = (37 * hash) + USERNAME_FIELD_NUMBER;
    hash = (53 * hash) + getUsername().hashCode();
    hash = (37 * hash) + PASSWORD_FIELD_NUMBER;
    hash = (53 * hash) + getPassword().hashCode();
    hash = (37 * hash) + DATABASE_SERVICE_FIELD_NUMBER;
    hash = (53 * hash) + getDatabaseService().hashCode();
    if (!internalGetConnectionAttributes().getMap().isEmpty()) {
      hash = (37 * hash) + CONNECTION_ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetConnectionAttributes().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datastream.v1.OracleProfile parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.OracleProfile parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.OracleProfile parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.OracleProfile parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.OracleProfile parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.OracleProfile parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.OracleProfile parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.OracleProfile parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.OracleProfile parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.OracleProfile parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.OracleProfile parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.OracleProfile parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datastream.v1.OracleProfile prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Oracle database profile.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datastream.v1.OracleProfile}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1.OracleProfile)
      com.google.cloud.datastream.v1.OracleProfileOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_OracleProfile_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetConnectionAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 6:
          return internalGetMutableConnectionAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_OracleProfile_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1.OracleProfile.class,
              com.google.cloud.datastream.v1.OracleProfile.Builder.class);
    }

    // Construct using com.google.cloud.datastream.v1.OracleProfile.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      hostname_ = "";
      port_ = 0;
      username_ = "";
      password_ = "";
      databaseService_ = "";
      internalGetMutableConnectionAttributes().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_OracleProfile_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.OracleProfile getDefaultInstanceForType() {
      return com.google.cloud.datastream.v1.OracleProfile.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.OracleProfile build() {
      com.google.cloud.datastream.v1.OracleProfile result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.OracleProfile buildPartial() {
      com.google.cloud.datastream.v1.OracleProfile result =
          new com.google.cloud.datastream.v1.OracleProfile(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datastream.v1.OracleProfile result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.hostname_ = hostname_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.port_ = port_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.username_ = username_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.password_ = password_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.databaseService_ = databaseService_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.connectionAttributes_ = internalGetConnectionAttributes();
        result.connectionAttributes_.makeImmutable();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datastream.v1.OracleProfile) {
        return mergeFrom((com.google.cloud.datastream.v1.OracleProfile) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datastream.v1.OracleProfile other) {
      if (other == com.google.cloud.datastream.v1.OracleProfile.getDefaultInstance()) return this;
      if (!other.getHostname().isEmpty()) {
        hostname_ = other.hostname_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getPort() != 0) {
        setPort(other.getPort());
      }
      if (!other.getUsername().isEmpty()) {
        username_ = other.username_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getPassword().isEmpty()) {
        password_ = other.password_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDatabaseService().isEmpty()) {
        databaseService_ = other.databaseService_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      internalGetMutableConnectionAttributes().mergeFrom(other.internalGetConnectionAttributes());
      bitField0_ |= 0x00000020;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                hostname_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                port_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                username_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                password_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                databaseService_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    connectionAttributes__ =
                        input.readMessage(
                            ConnectionAttributesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableConnectionAttributes()
                    .getMutableMap()
                    .put(connectionAttributes__.getKey(), connectionAttributes__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object hostname_ = "";
    /**
     *
     *
     * <pre>
     * Required. Hostname for the Oracle connection.
     * </pre>
     *
     * <code>string hostname = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The hostname.
     */
    public java.lang.String getHostname() {
      java.lang.Object ref = hostname_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        hostname_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Hostname for the Oracle connection.
     * </pre>
     *
     * <code>string hostname = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for hostname.
     */
    public com.google.protobuf.ByteString getHostnameBytes() {
      java.lang.Object ref = hostname_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        hostname_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Hostname for the Oracle connection.
     * </pre>
     *
     * <code>string hostname = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The hostname to set.
     * @return This builder for chaining.
     */
    public Builder setHostname(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      hostname_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Hostname for the Oracle connection.
     * </pre>
     *
     * <code>string hostname = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHostname() {
      hostname_ = getDefaultInstance().getHostname();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Hostname for the Oracle connection.
     * </pre>
     *
     * <code>string hostname = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for hostname to set.
     * @return This builder for chaining.
     */
    public Builder setHostnameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      hostname_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int port_;
    /**
     *
     *
     * <pre>
     * Port for the Oracle connection, default value is 1521.
     * </pre>
     *
     * <code>int32 port = 2;</code>
     *
     * @return The port.
     */
    @java.lang.Override
    public int getPort() {
      return port_;
    }
    /**
     *
     *
     * <pre>
     * Port for the Oracle connection, default value is 1521.
     * </pre>
     *
     * <code>int32 port = 2;</code>
     *
     * @param value The port to set.
     * @return This builder for chaining.
     */
    public Builder setPort(int value) {

      port_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Port for the Oracle connection, default value is 1521.
     * </pre>
     *
     * <code>int32 port = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPort() {
      bitField0_ = (bitField0_ & ~0x00000002);
      port_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object username_ = "";
    /**
     *
     *
     * <pre>
     * Required. Username for the Oracle connection.
     * </pre>
     *
     * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The username.
     */
    public java.lang.String getUsername() {
      java.lang.Object ref = username_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        username_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Username for the Oracle connection.
     * </pre>
     *
     * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for username.
     */
    public com.google.protobuf.ByteString getUsernameBytes() {
      java.lang.Object ref = username_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        username_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Username for the Oracle connection.
     * </pre>
     *
     * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The username to set.
     * @return This builder for chaining.
     */
    public Builder setUsername(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      username_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Username for the Oracle connection.
     * </pre>
     *
     * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUsername() {
      username_ = getDefaultInstance().getUsername();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Username for the Oracle connection.
     * </pre>
     *
     * <code>string username = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for username to set.
     * @return This builder for chaining.
     */
    public Builder setUsernameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      username_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object password_ = "";
    /**
     *
     *
     * <pre>
     * Required. Password for the Oracle connection.
     * </pre>
     *
     * <code>string password = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The password.
     */
    public java.lang.String getPassword() {
      java.lang.Object ref = password_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        password_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Password for the Oracle connection.
     * </pre>
     *
     * <code>string password = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for password.
     */
    public com.google.protobuf.ByteString getPasswordBytes() {
      java.lang.Object ref = password_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        password_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Password for the Oracle connection.
     * </pre>
     *
     * <code>string password = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The password to set.
     * @return This builder for chaining.
     */
    public Builder setPassword(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      password_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Password for the Oracle connection.
     * </pre>
     *
     * <code>string password = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPassword() {
      password_ = getDefaultInstance().getPassword();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Password for the Oracle connection.
     * </pre>
     *
     * <code>string password = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for password to set.
     * @return This builder for chaining.
     */
    public Builder setPasswordBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      password_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object databaseService_ = "";
    /**
     *
     *
     * <pre>
     * Required. Database for the Oracle connection.
     * </pre>
     *
     * <code>string database_service = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The databaseService.
     */
    public java.lang.String getDatabaseService() {
      java.lang.Object ref = databaseService_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        databaseService_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Database for the Oracle connection.
     * </pre>
     *
     * <code>string database_service = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for databaseService.
     */
    public com.google.protobuf.ByteString getDatabaseServiceBytes() {
      java.lang.Object ref = databaseService_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        databaseService_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Database for the Oracle connection.
     * </pre>
     *
     * <code>string database_service = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The databaseService to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      databaseService_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Database for the Oracle connection.
     * </pre>
     *
     * <code>string database_service = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatabaseService() {
      databaseService_ = getDefaultInstance().getDatabaseService();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Database for the Oracle connection.
     * </pre>
     *
     * <code>string database_service = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for databaseService to set.
     * @return This builder for chaining.
     */
    public Builder setDatabaseServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      databaseService_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> connectionAttributes_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetConnectionAttributes() {
      if (connectionAttributes_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ConnectionAttributesDefaultEntryHolder.defaultEntry);
      }
      return connectionAttributes_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableConnectionAttributes() {
      if (connectionAttributes_ == null) {
        connectionAttributes_ =
            com.google.protobuf.MapField.newMapField(
                ConnectionAttributesDefaultEntryHolder.defaultEntry);
      }
      if (!connectionAttributes_.isMutable()) {
        connectionAttributes_ = connectionAttributes_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return connectionAttributes_;
    }

    public int getConnectionAttributesCount() {
      return internalGetConnectionAttributes().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Connection string attributes
     * </pre>
     *
     * <code>map&lt;string, string&gt; connection_attributes = 6;</code>
     */
    @java.lang.Override
    public boolean containsConnectionAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetConnectionAttributes().getMap().containsKey(key);
    }
    /** Use {@link #getConnectionAttributesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getConnectionAttributes() {
      return getConnectionAttributesMap();
    }
    /**
     *
     *
     * <pre>
     * Connection string attributes
     * </pre>
     *
     * <code>map&lt;string, string&gt; connection_attributes = 6;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getConnectionAttributesMap() {
      return internalGetConnectionAttributes().getMap();
    }
    /**
     *
     *
     * <pre>
     * Connection string attributes
     * </pre>
     *
     * <code>map&lt;string, string&gt; connection_attributes = 6;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getConnectionAttributesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetConnectionAttributes().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Connection string attributes
     * </pre>
     *
     * <code>map&lt;string, string&gt; connection_attributes = 6;</code>
     */
    @java.lang.Override
    public java.lang.String getConnectionAttributesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetConnectionAttributes().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearConnectionAttributes() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableConnectionAttributes().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Connection string attributes
     * </pre>
     *
     * <code>map&lt;string, string&gt; connection_attributes = 6;</code>
     */
    public Builder removeConnectionAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableConnectionAttributes().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableConnectionAttributes() {
      bitField0_ |= 0x00000020;
      return internalGetMutableConnectionAttributes().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Connection string attributes
     * </pre>
     *
     * <code>map&lt;string, string&gt; connection_attributes = 6;</code>
     */
    public Builder putConnectionAttributes(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableConnectionAttributes().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Connection string attributes
     * </pre>
     *
     * <code>map&lt;string, string&gt; connection_attributes = 6;</code>
     */
    public Builder putAllConnectionAttributes(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableConnectionAttributes().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1.OracleProfile)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1.OracleProfile)
  private static final com.google.cloud.datastream.v1.OracleProfile DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datastream.v1.OracleProfile();
  }

  public static com.google.cloud.datastream.v1.OracleProfile getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OracleProfile> PARSER =
      new com.google.protobuf.AbstractParser<OracleProfile>() {
        @java.lang.Override
        public OracleProfile parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OracleProfile> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OracleProfile> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datastream.v1.OracleProfile getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
