/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datastream/v1/datastream_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.datastream.v1;

/**
 *
 *
 * <pre>
 * The configuration of the stream source.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datastream.v1.SourceConfig}
 */
public final class SourceConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1.SourceConfig)
    SourceConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SourceConfig.newBuilder() to construct.
  private SourceConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SourceConfig() {
    sourceConnectionProfile_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SourceConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datastream.v1.DatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1_SourceConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datastream.v1.DatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1_SourceConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datastream.v1.SourceConfig.class,
            com.google.cloud.datastream.v1.SourceConfig.Builder.class);
  }

  private int sourceStreamConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object sourceStreamConfig_;

  public enum SourceStreamConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ORACLE_SOURCE_CONFIG(100),
    MYSQL_SOURCE_CONFIG(101),
    POSTGRESQL_SOURCE_CONFIG(102),
    SOURCESTREAMCONFIG_NOT_SET(0);
    private final int value;

    private SourceStreamConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceStreamConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceStreamConfigCase forNumber(int value) {
      switch (value) {
        case 100:
          return ORACLE_SOURCE_CONFIG;
        case 101:
          return MYSQL_SOURCE_CONFIG;
        case 102:
          return POSTGRESQL_SOURCE_CONFIG;
        case 0:
          return SOURCESTREAMCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceStreamConfigCase getSourceStreamConfigCase() {
    return SourceStreamConfigCase.forNumber(sourceStreamConfigCase_);
  }

  public static final int SOURCE_CONNECTION_PROFILE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceConnectionProfile_ = "";
  /**
   *
   *
   * <pre>
   * Required. Source connection profile resoource.
   * Format: `projects/{project}/locations/{location}/connectionProfiles/{name}`
   * </pre>
   *
   * <code>
   * string source_connection_profile = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The sourceConnectionProfile.
   */
  @java.lang.Override
  public java.lang.String getSourceConnectionProfile() {
    java.lang.Object ref = sourceConnectionProfile_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceConnectionProfile_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Source connection profile resoource.
   * Format: `projects/{project}/locations/{location}/connectionProfiles/{name}`
   * </pre>
   *
   * <code>
   * string source_connection_profile = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for sourceConnectionProfile.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceConnectionProfileBytes() {
    java.lang.Object ref = sourceConnectionProfile_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceConnectionProfile_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORACLE_SOURCE_CONFIG_FIELD_NUMBER = 100;
  /**
   *
   *
   * <pre>
   * Oracle data source configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.OracleSourceConfig oracle_source_config = 100;</code>
   *
   * @return Whether the oracleSourceConfig field is set.
   */
  @java.lang.Override
  public boolean hasOracleSourceConfig() {
    return sourceStreamConfigCase_ == 100;
  }
  /**
   *
   *
   * <pre>
   * Oracle data source configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.OracleSourceConfig oracle_source_config = 100;</code>
   *
   * @return The oracleSourceConfig.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.OracleSourceConfig getOracleSourceConfig() {
    if (sourceStreamConfigCase_ == 100) {
      return (com.google.cloud.datastream.v1.OracleSourceConfig) sourceStreamConfig_;
    }
    return com.google.cloud.datastream.v1.OracleSourceConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Oracle data source configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.OracleSourceConfig oracle_source_config = 100;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.OracleSourceConfigOrBuilder
      getOracleSourceConfigOrBuilder() {
    if (sourceStreamConfigCase_ == 100) {
      return (com.google.cloud.datastream.v1.OracleSourceConfig) sourceStreamConfig_;
    }
    return com.google.cloud.datastream.v1.OracleSourceConfig.getDefaultInstance();
  }

  public static final int MYSQL_SOURCE_CONFIG_FIELD_NUMBER = 101;
  /**
   *
   *
   * <pre>
   * MySQL data source configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.MysqlSourceConfig mysql_source_config = 101;</code>
   *
   * @return Whether the mysqlSourceConfig field is set.
   */
  @java.lang.Override
  public boolean hasMysqlSourceConfig() {
    return sourceStreamConfigCase_ == 101;
  }
  /**
   *
   *
   * <pre>
   * MySQL data source configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.MysqlSourceConfig mysql_source_config = 101;</code>
   *
   * @return The mysqlSourceConfig.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.MysqlSourceConfig getMysqlSourceConfig() {
    if (sourceStreamConfigCase_ == 101) {
      return (com.google.cloud.datastream.v1.MysqlSourceConfig) sourceStreamConfig_;
    }
    return com.google.cloud.datastream.v1.MysqlSourceConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * MySQL data source configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.MysqlSourceConfig mysql_source_config = 101;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.MysqlSourceConfigOrBuilder getMysqlSourceConfigOrBuilder() {
    if (sourceStreamConfigCase_ == 101) {
      return (com.google.cloud.datastream.v1.MysqlSourceConfig) sourceStreamConfig_;
    }
    return com.google.cloud.datastream.v1.MysqlSourceConfig.getDefaultInstance();
  }

  public static final int POSTGRESQL_SOURCE_CONFIG_FIELD_NUMBER = 102;
  /**
   *
   *
   * <pre>
   * PostgreSQL data source configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.PostgresqlSourceConfig postgresql_source_config = 102;</code>
   *
   * @return Whether the postgresqlSourceConfig field is set.
   */
  @java.lang.Override
  public boolean hasPostgresqlSourceConfig() {
    return sourceStreamConfigCase_ == 102;
  }
  /**
   *
   *
   * <pre>
   * PostgreSQL data source configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.PostgresqlSourceConfig postgresql_source_config = 102;</code>
   *
   * @return The postgresqlSourceConfig.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.PostgresqlSourceConfig getPostgresqlSourceConfig() {
    if (sourceStreamConfigCase_ == 102) {
      return (com.google.cloud.datastream.v1.PostgresqlSourceConfig) sourceStreamConfig_;
    }
    return com.google.cloud.datastream.v1.PostgresqlSourceConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * PostgreSQL data source configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.PostgresqlSourceConfig postgresql_source_config = 102;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.PostgresqlSourceConfigOrBuilder
      getPostgresqlSourceConfigOrBuilder() {
    if (sourceStreamConfigCase_ == 102) {
      return (com.google.cloud.datastream.v1.PostgresqlSourceConfig) sourceStreamConfig_;
    }
    return com.google.cloud.datastream.v1.PostgresqlSourceConfig.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceConnectionProfile_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, sourceConnectionProfile_);
    }
    if (sourceStreamConfigCase_ == 100) {
      output.writeMessage(
          100, (com.google.cloud.datastream.v1.OracleSourceConfig) sourceStreamConfig_);
    }
    if (sourceStreamConfigCase_ == 101) {
      output.writeMessage(
          101, (com.google.cloud.datastream.v1.MysqlSourceConfig) sourceStreamConfig_);
    }
    if (sourceStreamConfigCase_ == 102) {
      output.writeMessage(
          102, (com.google.cloud.datastream.v1.PostgresqlSourceConfig) sourceStreamConfig_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceConnectionProfile_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, sourceConnectionProfile_);
    }
    if (sourceStreamConfigCase_ == 100) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              100, (com.google.cloud.datastream.v1.OracleSourceConfig) sourceStreamConfig_);
    }
    if (sourceStreamConfigCase_ == 101) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              101, (com.google.cloud.datastream.v1.MysqlSourceConfig) sourceStreamConfig_);
    }
    if (sourceStreamConfigCase_ == 102) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              102, (com.google.cloud.datastream.v1.PostgresqlSourceConfig) sourceStreamConfig_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datastream.v1.SourceConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.datastream.v1.SourceConfig other =
        (com.google.cloud.datastream.v1.SourceConfig) obj;

    if (!getSourceConnectionProfile().equals(other.getSourceConnectionProfile())) return false;
    if (!getSourceStreamConfigCase().equals(other.getSourceStreamConfigCase())) return false;
    switch (sourceStreamConfigCase_) {
      case 100:
        if (!getOracleSourceConfig().equals(other.getOracleSourceConfig())) return false;
        break;
      case 101:
        if (!getMysqlSourceConfig().equals(other.getMysqlSourceConfig())) return false;
        break;
      case 102:
        if (!getPostgresqlSourceConfig().equals(other.getPostgresqlSourceConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SOURCE_CONNECTION_PROFILE_FIELD_NUMBER;
    hash = (53 * hash) + getSourceConnectionProfile().hashCode();
    switch (sourceStreamConfigCase_) {
      case 100:
        hash = (37 * hash) + ORACLE_SOURCE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getOracleSourceConfig().hashCode();
        break;
      case 101:
        hash = (37 * hash) + MYSQL_SOURCE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getMysqlSourceConfig().hashCode();
        break;
      case 102:
        hash = (37 * hash) + POSTGRESQL_SOURCE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getPostgresqlSourceConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datastream.v1.SourceConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.SourceConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.SourceConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.SourceConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.SourceConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.SourceConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.SourceConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.SourceConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.SourceConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.SourceConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.SourceConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.SourceConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datastream.v1.SourceConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The configuration of the stream source.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datastream.v1.SourceConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1.SourceConfig)
      com.google.cloud.datastream.v1.SourceConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_SourceConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_SourceConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1.SourceConfig.class,
              com.google.cloud.datastream.v1.SourceConfig.Builder.class);
    }

    // Construct using com.google.cloud.datastream.v1.SourceConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      sourceConnectionProfile_ = "";
      if (oracleSourceConfigBuilder_ != null) {
        oracleSourceConfigBuilder_.clear();
      }
      if (mysqlSourceConfigBuilder_ != null) {
        mysqlSourceConfigBuilder_.clear();
      }
      if (postgresqlSourceConfigBuilder_ != null) {
        postgresqlSourceConfigBuilder_.clear();
      }
      sourceStreamConfigCase_ = 0;
      sourceStreamConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_SourceConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.SourceConfig getDefaultInstanceForType() {
      return com.google.cloud.datastream.v1.SourceConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.SourceConfig build() {
      com.google.cloud.datastream.v1.SourceConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.SourceConfig buildPartial() {
      com.google.cloud.datastream.v1.SourceConfig result =
          new com.google.cloud.datastream.v1.SourceConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datastream.v1.SourceConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.sourceConnectionProfile_ = sourceConnectionProfile_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.datastream.v1.SourceConfig result) {
      result.sourceStreamConfigCase_ = sourceStreamConfigCase_;
      result.sourceStreamConfig_ = this.sourceStreamConfig_;
      if (sourceStreamConfigCase_ == 100 && oracleSourceConfigBuilder_ != null) {
        result.sourceStreamConfig_ = oracleSourceConfigBuilder_.build();
      }
      if (sourceStreamConfigCase_ == 101 && mysqlSourceConfigBuilder_ != null) {
        result.sourceStreamConfig_ = mysqlSourceConfigBuilder_.build();
      }
      if (sourceStreamConfigCase_ == 102 && postgresqlSourceConfigBuilder_ != null) {
        result.sourceStreamConfig_ = postgresqlSourceConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datastream.v1.SourceConfig) {
        return mergeFrom((com.google.cloud.datastream.v1.SourceConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datastream.v1.SourceConfig other) {
      if (other == com.google.cloud.datastream.v1.SourceConfig.getDefaultInstance()) return this;
      if (!other.getSourceConnectionProfile().isEmpty()) {
        sourceConnectionProfile_ = other.sourceConnectionProfile_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      switch (other.getSourceStreamConfigCase()) {
        case ORACLE_SOURCE_CONFIG:
          {
            mergeOracleSourceConfig(other.getOracleSourceConfig());
            break;
          }
        case MYSQL_SOURCE_CONFIG:
          {
            mergeMysqlSourceConfig(other.getMysqlSourceConfig());
            break;
          }
        case POSTGRESQL_SOURCE_CONFIG:
          {
            mergePostgresqlSourceConfig(other.getPostgresqlSourceConfig());
            break;
          }
        case SOURCESTREAMCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                sourceConnectionProfile_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 802:
              {
                input.readMessage(
                    getOracleSourceConfigFieldBuilder().getBuilder(), extensionRegistry);
                sourceStreamConfigCase_ = 100;
                break;
              } // case 802
            case 810:
              {
                input.readMessage(
                    getMysqlSourceConfigFieldBuilder().getBuilder(), extensionRegistry);
                sourceStreamConfigCase_ = 101;
                break;
              } // case 810
            case 818:
              {
                input.readMessage(
                    getPostgresqlSourceConfigFieldBuilder().getBuilder(), extensionRegistry);
                sourceStreamConfigCase_ = 102;
                break;
              } // case 818
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceStreamConfigCase_ = 0;
    private java.lang.Object sourceStreamConfig_;

    public SourceStreamConfigCase getSourceStreamConfigCase() {
      return SourceStreamConfigCase.forNumber(sourceStreamConfigCase_);
    }

    public Builder clearSourceStreamConfig() {
      sourceStreamConfigCase_ = 0;
      sourceStreamConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object sourceConnectionProfile_ = "";
    /**
     *
     *
     * <pre>
     * Required. Source connection profile resoource.
     * Format: `projects/{project}/locations/{location}/connectionProfiles/{name}`
     * </pre>
     *
     * <code>
     * string source_connection_profile = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The sourceConnectionProfile.
     */
    public java.lang.String getSourceConnectionProfile() {
      java.lang.Object ref = sourceConnectionProfile_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceConnectionProfile_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Source connection profile resoource.
     * Format: `projects/{project}/locations/{location}/connectionProfiles/{name}`
     * </pre>
     *
     * <code>
     * string source_connection_profile = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for sourceConnectionProfile.
     */
    public com.google.protobuf.ByteString getSourceConnectionProfileBytes() {
      java.lang.Object ref = sourceConnectionProfile_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceConnectionProfile_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Source connection profile resoource.
     * Format: `projects/{project}/locations/{location}/connectionProfiles/{name}`
     * </pre>
     *
     * <code>
     * string source_connection_profile = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The sourceConnectionProfile to set.
     * @return This builder for chaining.
     */
    public Builder setSourceConnectionProfile(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceConnectionProfile_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Source connection profile resoource.
     * Format: `projects/{project}/locations/{location}/connectionProfiles/{name}`
     * </pre>
     *
     * <code>
     * string source_connection_profile = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceConnectionProfile() {
      sourceConnectionProfile_ = getDefaultInstance().getSourceConnectionProfile();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Source connection profile resoource.
     * Format: `projects/{project}/locations/{location}/connectionProfiles/{name}`
     * </pre>
     *
     * <code>
     * string source_connection_profile = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for sourceConnectionProfile to set.
     * @return This builder for chaining.
     */
    public Builder setSourceConnectionProfileBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceConnectionProfile_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.OracleSourceConfig,
            com.google.cloud.datastream.v1.OracleSourceConfig.Builder,
            com.google.cloud.datastream.v1.OracleSourceConfigOrBuilder>
        oracleSourceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Oracle data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.OracleSourceConfig oracle_source_config = 100;</code>
     *
     * @return Whether the oracleSourceConfig field is set.
     */
    @java.lang.Override
    public boolean hasOracleSourceConfig() {
      return sourceStreamConfigCase_ == 100;
    }
    /**
     *
     *
     * <pre>
     * Oracle data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.OracleSourceConfig oracle_source_config = 100;</code>
     *
     * @return The oracleSourceConfig.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.OracleSourceConfig getOracleSourceConfig() {
      if (oracleSourceConfigBuilder_ == null) {
        if (sourceStreamConfigCase_ == 100) {
          return (com.google.cloud.datastream.v1.OracleSourceConfig) sourceStreamConfig_;
        }
        return com.google.cloud.datastream.v1.OracleSourceConfig.getDefaultInstance();
      } else {
        if (sourceStreamConfigCase_ == 100) {
          return oracleSourceConfigBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1.OracleSourceConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Oracle data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.OracleSourceConfig oracle_source_config = 100;</code>
     */
    public Builder setOracleSourceConfig(com.google.cloud.datastream.v1.OracleSourceConfig value) {
      if (oracleSourceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceStreamConfig_ = value;
        onChanged();
      } else {
        oracleSourceConfigBuilder_.setMessage(value);
      }
      sourceStreamConfigCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Oracle data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.OracleSourceConfig oracle_source_config = 100;</code>
     */
    public Builder setOracleSourceConfig(
        com.google.cloud.datastream.v1.OracleSourceConfig.Builder builderForValue) {
      if (oracleSourceConfigBuilder_ == null) {
        sourceStreamConfig_ = builderForValue.build();
        onChanged();
      } else {
        oracleSourceConfigBuilder_.setMessage(builderForValue.build());
      }
      sourceStreamConfigCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Oracle data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.OracleSourceConfig oracle_source_config = 100;</code>
     */
    public Builder mergeOracleSourceConfig(
        com.google.cloud.datastream.v1.OracleSourceConfig value) {
      if (oracleSourceConfigBuilder_ == null) {
        if (sourceStreamConfigCase_ == 100
            && sourceStreamConfig_
                != com.google.cloud.datastream.v1.OracleSourceConfig.getDefaultInstance()) {
          sourceStreamConfig_ =
              com.google.cloud.datastream.v1.OracleSourceConfig.newBuilder(
                      (com.google.cloud.datastream.v1.OracleSourceConfig) sourceStreamConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sourceStreamConfig_ = value;
        }
        onChanged();
      } else {
        if (sourceStreamConfigCase_ == 100) {
          oracleSourceConfigBuilder_.mergeFrom(value);
        } else {
          oracleSourceConfigBuilder_.setMessage(value);
        }
      }
      sourceStreamConfigCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Oracle data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.OracleSourceConfig oracle_source_config = 100;</code>
     */
    public Builder clearOracleSourceConfig() {
      if (oracleSourceConfigBuilder_ == null) {
        if (sourceStreamConfigCase_ == 100) {
          sourceStreamConfigCase_ = 0;
          sourceStreamConfig_ = null;
          onChanged();
        }
      } else {
        if (sourceStreamConfigCase_ == 100) {
          sourceStreamConfigCase_ = 0;
          sourceStreamConfig_ = null;
        }
        oracleSourceConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Oracle data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.OracleSourceConfig oracle_source_config = 100;</code>
     */
    public com.google.cloud.datastream.v1.OracleSourceConfig.Builder
        getOracleSourceConfigBuilder() {
      return getOracleSourceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Oracle data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.OracleSourceConfig oracle_source_config = 100;</code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.OracleSourceConfigOrBuilder
        getOracleSourceConfigOrBuilder() {
      if ((sourceStreamConfigCase_ == 100) && (oracleSourceConfigBuilder_ != null)) {
        return oracleSourceConfigBuilder_.getMessageOrBuilder();
      } else {
        if (sourceStreamConfigCase_ == 100) {
          return (com.google.cloud.datastream.v1.OracleSourceConfig) sourceStreamConfig_;
        }
        return com.google.cloud.datastream.v1.OracleSourceConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Oracle data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.OracleSourceConfig oracle_source_config = 100;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.OracleSourceConfig,
            com.google.cloud.datastream.v1.OracleSourceConfig.Builder,
            com.google.cloud.datastream.v1.OracleSourceConfigOrBuilder>
        getOracleSourceConfigFieldBuilder() {
      if (oracleSourceConfigBuilder_ == null) {
        if (!(sourceStreamConfigCase_ == 100)) {
          sourceStreamConfig_ =
              com.google.cloud.datastream.v1.OracleSourceConfig.getDefaultInstance();
        }
        oracleSourceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1.OracleSourceConfig,
                com.google.cloud.datastream.v1.OracleSourceConfig.Builder,
                com.google.cloud.datastream.v1.OracleSourceConfigOrBuilder>(
                (com.google.cloud.datastream.v1.OracleSourceConfig) sourceStreamConfig_,
                getParentForChildren(),
                isClean());
        sourceStreamConfig_ = null;
      }
      sourceStreamConfigCase_ = 100;
      onChanged();
      return oracleSourceConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.MysqlSourceConfig,
            com.google.cloud.datastream.v1.MysqlSourceConfig.Builder,
            com.google.cloud.datastream.v1.MysqlSourceConfigOrBuilder>
        mysqlSourceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * MySQL data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.MysqlSourceConfig mysql_source_config = 101;</code>
     *
     * @return Whether the mysqlSourceConfig field is set.
     */
    @java.lang.Override
    public boolean hasMysqlSourceConfig() {
      return sourceStreamConfigCase_ == 101;
    }
    /**
     *
     *
     * <pre>
     * MySQL data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.MysqlSourceConfig mysql_source_config = 101;</code>
     *
     * @return The mysqlSourceConfig.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.MysqlSourceConfig getMysqlSourceConfig() {
      if (mysqlSourceConfigBuilder_ == null) {
        if (sourceStreamConfigCase_ == 101) {
          return (com.google.cloud.datastream.v1.MysqlSourceConfig) sourceStreamConfig_;
        }
        return com.google.cloud.datastream.v1.MysqlSourceConfig.getDefaultInstance();
      } else {
        if (sourceStreamConfigCase_ == 101) {
          return mysqlSourceConfigBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1.MysqlSourceConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * MySQL data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.MysqlSourceConfig mysql_source_config = 101;</code>
     */
    public Builder setMysqlSourceConfig(com.google.cloud.datastream.v1.MysqlSourceConfig value) {
      if (mysqlSourceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceStreamConfig_ = value;
        onChanged();
      } else {
        mysqlSourceConfigBuilder_.setMessage(value);
      }
      sourceStreamConfigCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * MySQL data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.MysqlSourceConfig mysql_source_config = 101;</code>
     */
    public Builder setMysqlSourceConfig(
        com.google.cloud.datastream.v1.MysqlSourceConfig.Builder builderForValue) {
      if (mysqlSourceConfigBuilder_ == null) {
        sourceStreamConfig_ = builderForValue.build();
        onChanged();
      } else {
        mysqlSourceConfigBuilder_.setMessage(builderForValue.build());
      }
      sourceStreamConfigCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * MySQL data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.MysqlSourceConfig mysql_source_config = 101;</code>
     */
    public Builder mergeMysqlSourceConfig(com.google.cloud.datastream.v1.MysqlSourceConfig value) {
      if (mysqlSourceConfigBuilder_ == null) {
        if (sourceStreamConfigCase_ == 101
            && sourceStreamConfig_
                != com.google.cloud.datastream.v1.MysqlSourceConfig.getDefaultInstance()) {
          sourceStreamConfig_ =
              com.google.cloud.datastream.v1.MysqlSourceConfig.newBuilder(
                      (com.google.cloud.datastream.v1.MysqlSourceConfig) sourceStreamConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sourceStreamConfig_ = value;
        }
        onChanged();
      } else {
        if (sourceStreamConfigCase_ == 101) {
          mysqlSourceConfigBuilder_.mergeFrom(value);
        } else {
          mysqlSourceConfigBuilder_.setMessage(value);
        }
      }
      sourceStreamConfigCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * MySQL data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.MysqlSourceConfig mysql_source_config = 101;</code>
     */
    public Builder clearMysqlSourceConfig() {
      if (mysqlSourceConfigBuilder_ == null) {
        if (sourceStreamConfigCase_ == 101) {
          sourceStreamConfigCase_ = 0;
          sourceStreamConfig_ = null;
          onChanged();
        }
      } else {
        if (sourceStreamConfigCase_ == 101) {
          sourceStreamConfigCase_ = 0;
          sourceStreamConfig_ = null;
        }
        mysqlSourceConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * MySQL data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.MysqlSourceConfig mysql_source_config = 101;</code>
     */
    public com.google.cloud.datastream.v1.MysqlSourceConfig.Builder getMysqlSourceConfigBuilder() {
      return getMysqlSourceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * MySQL data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.MysqlSourceConfig mysql_source_config = 101;</code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.MysqlSourceConfigOrBuilder
        getMysqlSourceConfigOrBuilder() {
      if ((sourceStreamConfigCase_ == 101) && (mysqlSourceConfigBuilder_ != null)) {
        return mysqlSourceConfigBuilder_.getMessageOrBuilder();
      } else {
        if (sourceStreamConfigCase_ == 101) {
          return (com.google.cloud.datastream.v1.MysqlSourceConfig) sourceStreamConfig_;
        }
        return com.google.cloud.datastream.v1.MysqlSourceConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * MySQL data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.MysqlSourceConfig mysql_source_config = 101;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.MysqlSourceConfig,
            com.google.cloud.datastream.v1.MysqlSourceConfig.Builder,
            com.google.cloud.datastream.v1.MysqlSourceConfigOrBuilder>
        getMysqlSourceConfigFieldBuilder() {
      if (mysqlSourceConfigBuilder_ == null) {
        if (!(sourceStreamConfigCase_ == 101)) {
          sourceStreamConfig_ =
              com.google.cloud.datastream.v1.MysqlSourceConfig.getDefaultInstance();
        }
        mysqlSourceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1.MysqlSourceConfig,
                com.google.cloud.datastream.v1.MysqlSourceConfig.Builder,
                com.google.cloud.datastream.v1.MysqlSourceConfigOrBuilder>(
                (com.google.cloud.datastream.v1.MysqlSourceConfig) sourceStreamConfig_,
                getParentForChildren(),
                isClean());
        sourceStreamConfig_ = null;
      }
      sourceStreamConfigCase_ = 101;
      onChanged();
      return mysqlSourceConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.PostgresqlSourceConfig,
            com.google.cloud.datastream.v1.PostgresqlSourceConfig.Builder,
            com.google.cloud.datastream.v1.PostgresqlSourceConfigOrBuilder>
        postgresqlSourceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * PostgreSQL data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlSourceConfig postgresql_source_config = 102;
     * </code>
     *
     * @return Whether the postgresqlSourceConfig field is set.
     */
    @java.lang.Override
    public boolean hasPostgresqlSourceConfig() {
      return sourceStreamConfigCase_ == 102;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlSourceConfig postgresql_source_config = 102;
     * </code>
     *
     * @return The postgresqlSourceConfig.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.PostgresqlSourceConfig getPostgresqlSourceConfig() {
      if (postgresqlSourceConfigBuilder_ == null) {
        if (sourceStreamConfigCase_ == 102) {
          return (com.google.cloud.datastream.v1.PostgresqlSourceConfig) sourceStreamConfig_;
        }
        return com.google.cloud.datastream.v1.PostgresqlSourceConfig.getDefaultInstance();
      } else {
        if (sourceStreamConfigCase_ == 102) {
          return postgresqlSourceConfigBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1.PostgresqlSourceConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlSourceConfig postgresql_source_config = 102;
     * </code>
     */
    public Builder setPostgresqlSourceConfig(
        com.google.cloud.datastream.v1.PostgresqlSourceConfig value) {
      if (postgresqlSourceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceStreamConfig_ = value;
        onChanged();
      } else {
        postgresqlSourceConfigBuilder_.setMessage(value);
      }
      sourceStreamConfigCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlSourceConfig postgresql_source_config = 102;
     * </code>
     */
    public Builder setPostgresqlSourceConfig(
        com.google.cloud.datastream.v1.PostgresqlSourceConfig.Builder builderForValue) {
      if (postgresqlSourceConfigBuilder_ == null) {
        sourceStreamConfig_ = builderForValue.build();
        onChanged();
      } else {
        postgresqlSourceConfigBuilder_.setMessage(builderForValue.build());
      }
      sourceStreamConfigCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlSourceConfig postgresql_source_config = 102;
     * </code>
     */
    public Builder mergePostgresqlSourceConfig(
        com.google.cloud.datastream.v1.PostgresqlSourceConfig value) {
      if (postgresqlSourceConfigBuilder_ == null) {
        if (sourceStreamConfigCase_ == 102
            && sourceStreamConfig_
                != com.google.cloud.datastream.v1.PostgresqlSourceConfig.getDefaultInstance()) {
          sourceStreamConfig_ =
              com.google.cloud.datastream.v1.PostgresqlSourceConfig.newBuilder(
                      (com.google.cloud.datastream.v1.PostgresqlSourceConfig) sourceStreamConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sourceStreamConfig_ = value;
        }
        onChanged();
      } else {
        if (sourceStreamConfigCase_ == 102) {
          postgresqlSourceConfigBuilder_.mergeFrom(value);
        } else {
          postgresqlSourceConfigBuilder_.setMessage(value);
        }
      }
      sourceStreamConfigCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlSourceConfig postgresql_source_config = 102;
     * </code>
     */
    public Builder clearPostgresqlSourceConfig() {
      if (postgresqlSourceConfigBuilder_ == null) {
        if (sourceStreamConfigCase_ == 102) {
          sourceStreamConfigCase_ = 0;
          sourceStreamConfig_ = null;
          onChanged();
        }
      } else {
        if (sourceStreamConfigCase_ == 102) {
          sourceStreamConfigCase_ = 0;
          sourceStreamConfig_ = null;
        }
        postgresqlSourceConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlSourceConfig postgresql_source_config = 102;
     * </code>
     */
    public com.google.cloud.datastream.v1.PostgresqlSourceConfig.Builder
        getPostgresqlSourceConfigBuilder() {
      return getPostgresqlSourceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlSourceConfig postgresql_source_config = 102;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.PostgresqlSourceConfigOrBuilder
        getPostgresqlSourceConfigOrBuilder() {
      if ((sourceStreamConfigCase_ == 102) && (postgresqlSourceConfigBuilder_ != null)) {
        return postgresqlSourceConfigBuilder_.getMessageOrBuilder();
      } else {
        if (sourceStreamConfigCase_ == 102) {
          return (com.google.cloud.datastream.v1.PostgresqlSourceConfig) sourceStreamConfig_;
        }
        return com.google.cloud.datastream.v1.PostgresqlSourceConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * PostgreSQL data source configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.PostgresqlSourceConfig postgresql_source_config = 102;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1.PostgresqlSourceConfig,
            com.google.cloud.datastream.v1.PostgresqlSourceConfig.Builder,
            com.google.cloud.datastream.v1.PostgresqlSourceConfigOrBuilder>
        getPostgresqlSourceConfigFieldBuilder() {
      if (postgresqlSourceConfigBuilder_ == null) {
        if (!(sourceStreamConfigCase_ == 102)) {
          sourceStreamConfig_ =
              com.google.cloud.datastream.v1.PostgresqlSourceConfig.getDefaultInstance();
        }
        postgresqlSourceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1.PostgresqlSourceConfig,
                com.google.cloud.datastream.v1.PostgresqlSourceConfig.Builder,
                com.google.cloud.datastream.v1.PostgresqlSourceConfigOrBuilder>(
                (com.google.cloud.datastream.v1.PostgresqlSourceConfig) sourceStreamConfig_,
                getParentForChildren(),
                isClean());
        sourceStreamConfig_ = null;
      }
      sourceStreamConfigCase_ = 102;
      onChanged();
      return postgresqlSourceConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1.SourceConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1.SourceConfig)
  private static final com.google.cloud.datastream.v1.SourceConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datastream.v1.SourceConfig();
  }

  public static com.google.cloud.datastream.v1.SourceConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SourceConfig> PARSER =
      new com.google.protobuf.AbstractParser<SourceConfig>() {
        @java.lang.Override
        public SourceConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SourceConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SourceConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datastream.v1.SourceConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
