/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datastream/v1/datastream_resources.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.datastream.v1;

/**
 *
 *
 * <pre>
 * A validation to perform on a stream.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datastream.v1.Validation}
 */
public final class Validation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1.Validation)
    ValidationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Validation.newBuilder() to construct.
  private Validation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Validation() {
    description_ = "";
    state_ = 0;
    message_ = java.util.Collections.emptyList();
    code_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Validation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datastream.v1.DatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1_Validation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datastream.v1.DatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1_Validation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datastream.v1.Validation.class,
            com.google.cloud.datastream.v1.Validation.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Validation execution state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.datastream.v1.Validation.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Validation did not execute.
     * </pre>
     *
     * <code>NOT_EXECUTED = 1;</code>
     */
    NOT_EXECUTED(1),
    /**
     *
     *
     * <pre>
     * Validation failed.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    FAILED(2),
    /**
     *
     *
     * <pre>
     * Validation passed.
     * </pre>
     *
     * <code>PASSED = 3;</code>
     */
    PASSED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Validation did not execute.
     * </pre>
     *
     * <code>NOT_EXECUTED = 1;</code>
     */
    public static final int NOT_EXECUTED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Validation failed.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    public static final int FAILED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Validation passed.
     * </pre>
     *
     * <code>PASSED = 3;</code>
     */
    public static final int PASSED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return NOT_EXECUTED;
        case 2:
          return FAILED;
        case 3:
          return PASSED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.datastream.v1.Validation.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.datastream.v1.Validation.State)
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * A short description of the validation.
   * </pre>
   *
   * <code>string description = 1;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A short description of the validation.
   * </pre>
   *
   * <code>string description = 1;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 2;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Validation execution status.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.Validation.State state = 2;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Validation execution status.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1.Validation.State state = 2;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.Validation.State getState() {
    com.google.cloud.datastream.v1.Validation.State result =
        com.google.cloud.datastream.v1.Validation.State.forNumber(state_);
    return result == null ? com.google.cloud.datastream.v1.Validation.State.UNRECOGNIZED : result;
  }

  public static final int MESSAGE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.datastream.v1.ValidationMessage> message_;
  /**
   *
   *
   * <pre>
   * Messages reflecting the validation results.
   * </pre>
   *
   * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datastream.v1.ValidationMessage> getMessageList() {
    return message_;
  }
  /**
   *
   *
   * <pre>
   * Messages reflecting the validation results.
   * </pre>
   *
   * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.datastream.v1.ValidationMessageOrBuilder>
      getMessageOrBuilderList() {
    return message_;
  }
  /**
   *
   *
   * <pre>
   * Messages reflecting the validation results.
   * </pre>
   *
   * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
   */
  @java.lang.Override
  public int getMessageCount() {
    return message_.size();
  }
  /**
   *
   *
   * <pre>
   * Messages reflecting the validation results.
   * </pre>
   *
   * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.ValidationMessage getMessage(int index) {
    return message_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Messages reflecting the validation results.
   * </pre>
   *
   * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1.ValidationMessageOrBuilder getMessageOrBuilder(int index) {
    return message_.get(index);
  }

  public static final int CODE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object code_ = "";
  /**
   *
   *
   * <pre>
   * A custom code identifying this validation.
   * </pre>
   *
   * <code>string code = 4;</code>
   *
   * @return The code.
   */
  @java.lang.Override
  public java.lang.String getCode() {
    java.lang.Object ref = code_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      code_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A custom code identifying this validation.
   * </pre>
   *
   * <code>string code = 4;</code>
   *
   * @return The bytes for code.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCodeBytes() {
    java.lang.Object ref = code_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      code_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, description_);
    }
    if (state_ != com.google.cloud.datastream.v1.Validation.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, state_);
    }
    for (int i = 0; i < message_.size(); i++) {
      output.writeMessage(3, message_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(code_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, code_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, description_);
    }
    if (state_ != com.google.cloud.datastream.v1.Validation.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, state_);
    }
    for (int i = 0; i < message_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, message_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(code_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, code_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datastream.v1.Validation)) {
      return super.equals(obj);
    }
    com.google.cloud.datastream.v1.Validation other =
        (com.google.cloud.datastream.v1.Validation) obj;

    if (!getDescription().equals(other.getDescription())) return false;
    if (state_ != other.state_) return false;
    if (!getMessageList().equals(other.getMessageList())) return false;
    if (!getCode().equals(other.getCode())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (getMessageCount() > 0) {
      hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getMessageList().hashCode();
    }
    hash = (37 * hash) + CODE_FIELD_NUMBER;
    hash = (53 * hash) + getCode().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datastream.v1.Validation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.Validation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.Validation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.Validation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.Validation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1.Validation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.Validation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.Validation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.Validation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.Validation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1.Validation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1.Validation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datastream.v1.Validation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A validation to perform on a stream.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datastream.v1.Validation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1.Validation)
      com.google.cloud.datastream.v1.ValidationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_Validation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_Validation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1.Validation.class,
              com.google.cloud.datastream.v1.Validation.Builder.class);
    }

    // Construct using com.google.cloud.datastream.v1.Validation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      description_ = "";
      state_ = 0;
      if (messageBuilder_ == null) {
        message_ = java.util.Collections.emptyList();
      } else {
        message_ = null;
        messageBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      code_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datastream.v1.DatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1_Validation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.Validation getDefaultInstanceForType() {
      return com.google.cloud.datastream.v1.Validation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.Validation build() {
      com.google.cloud.datastream.v1.Validation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1.Validation buildPartial() {
      com.google.cloud.datastream.v1.Validation result =
          new com.google.cloud.datastream.v1.Validation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.datastream.v1.Validation result) {
      if (messageBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          message_ = java.util.Collections.unmodifiableList(message_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.message_ = message_;
      } else {
        result.message_ = messageBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.datastream.v1.Validation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.code_ = code_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datastream.v1.Validation) {
        return mergeFrom((com.google.cloud.datastream.v1.Validation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datastream.v1.Validation other) {
      if (other == com.google.cloud.datastream.v1.Validation.getDefaultInstance()) return this;
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (messageBuilder_ == null) {
        if (!other.message_.isEmpty()) {
          if (message_.isEmpty()) {
            message_ = other.message_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureMessageIsMutable();
            message_.addAll(other.message_);
          }
          onChanged();
        }
      } else {
        if (!other.message_.isEmpty()) {
          if (messageBuilder_.isEmpty()) {
            messageBuilder_.dispose();
            messageBuilder_ = null;
            message_ = other.message_;
            bitField0_ = (bitField0_ & ~0x00000004);
            messageBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMessageFieldBuilder()
                    : null;
          } else {
            messageBuilder_.addAllMessages(other.message_);
          }
        }
      }
      if (!other.getCode().isEmpty()) {
        code_ = other.code_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                com.google.cloud.datastream.v1.ValidationMessage m =
                    input.readMessage(
                        com.google.cloud.datastream.v1.ValidationMessage.parser(),
                        extensionRegistry);
                if (messageBuilder_ == null) {
                  ensureMessageIsMutable();
                  message_.add(m);
                } else {
                  messageBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                code_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * A short description of the validation.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A short description of the validation.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A short description of the validation.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A short description of the validation.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A short description of the validation.
     * </pre>
     *
     * <code>string description = 1;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Validation execution status.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.Validation.State state = 2;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Validation execution status.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.Validation.State state = 2;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Validation execution status.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.Validation.State state = 2;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1.Validation.State getState() {
      com.google.cloud.datastream.v1.Validation.State result =
          com.google.cloud.datastream.v1.Validation.State.forNumber(state_);
      return result == null ? com.google.cloud.datastream.v1.Validation.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Validation execution status.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.Validation.State state = 2;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.datastream.v1.Validation.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Validation execution status.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1.Validation.State state = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000002);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.datastream.v1.ValidationMessage> message_ =
        java.util.Collections.emptyList();

    private void ensureMessageIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        message_ =
            new java.util.ArrayList<com.google.cloud.datastream.v1.ValidationMessage>(message_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datastream.v1.ValidationMessage,
            com.google.cloud.datastream.v1.ValidationMessage.Builder,
            com.google.cloud.datastream.v1.ValidationMessageOrBuilder>
        messageBuilder_;

    /**
     *
     *
     * <pre>
     * Messages reflecting the validation results.
     * </pre>
     *
     * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
     */
    public java.util.List<com.google.cloud.datastream.v1.ValidationMessage> getMessageList() {
      if (messageBuilder_ == null) {
        return java.util.Collections.unmodifiableList(message_);
      } else {
        return messageBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Messages reflecting the validation results.
     * </pre>
     *
     * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
     */
    public int getMessageCount() {
      if (messageBuilder_ == null) {
        return message_.size();
      } else {
        return messageBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Messages reflecting the validation results.
     * </pre>
     *
     * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
     */
    public com.google.cloud.datastream.v1.ValidationMessage getMessage(int index) {
      if (messageBuilder_ == null) {
        return message_.get(index);
      } else {
        return messageBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Messages reflecting the validation results.
     * </pre>
     *
     * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
     */
    public Builder setMessage(int index, com.google.cloud.datastream.v1.ValidationMessage value) {
      if (messageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMessageIsMutable();
        message_.set(index, value);
        onChanged();
      } else {
        messageBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Messages reflecting the validation results.
     * </pre>
     *
     * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
     */
    public Builder setMessage(
        int index, com.google.cloud.datastream.v1.ValidationMessage.Builder builderForValue) {
      if (messageBuilder_ == null) {
        ensureMessageIsMutable();
        message_.set(index, builderForValue.build());
        onChanged();
      } else {
        messageBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Messages reflecting the validation results.
     * </pre>
     *
     * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
     */
    public Builder addMessage(com.google.cloud.datastream.v1.ValidationMessage value) {
      if (messageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMessageIsMutable();
        message_.add(value);
        onChanged();
      } else {
        messageBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Messages reflecting the validation results.
     * </pre>
     *
     * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
     */
    public Builder addMessage(int index, com.google.cloud.datastream.v1.ValidationMessage value) {
      if (messageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMessageIsMutable();
        message_.add(index, value);
        onChanged();
      } else {
        messageBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Messages reflecting the validation results.
     * </pre>
     *
     * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
     */
    public Builder addMessage(
        com.google.cloud.datastream.v1.ValidationMessage.Builder builderForValue) {
      if (messageBuilder_ == null) {
        ensureMessageIsMutable();
        message_.add(builderForValue.build());
        onChanged();
      } else {
        messageBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Messages reflecting the validation results.
     * </pre>
     *
     * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
     */
    public Builder addMessage(
        int index, com.google.cloud.datastream.v1.ValidationMessage.Builder builderForValue) {
      if (messageBuilder_ == null) {
        ensureMessageIsMutable();
        message_.add(index, builderForValue.build());
        onChanged();
      } else {
        messageBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Messages reflecting the validation results.
     * </pre>
     *
     * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
     */
    public Builder addAllMessage(
        java.lang.Iterable<? extends com.google.cloud.datastream.v1.ValidationMessage> values) {
      if (messageBuilder_ == null) {
        ensureMessageIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, message_);
        onChanged();
      } else {
        messageBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Messages reflecting the validation results.
     * </pre>
     *
     * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
     */
    public Builder clearMessage() {
      if (messageBuilder_ == null) {
        message_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        messageBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Messages reflecting the validation results.
     * </pre>
     *
     * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
     */
    public Builder removeMessage(int index) {
      if (messageBuilder_ == null) {
        ensureMessageIsMutable();
        message_.remove(index);
        onChanged();
      } else {
        messageBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Messages reflecting the validation results.
     * </pre>
     *
     * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
     */
    public com.google.cloud.datastream.v1.ValidationMessage.Builder getMessageBuilder(int index) {
      return getMessageFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Messages reflecting the validation results.
     * </pre>
     *
     * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
     */
    public com.google.cloud.datastream.v1.ValidationMessageOrBuilder getMessageOrBuilder(
        int index) {
      if (messageBuilder_ == null) {
        return message_.get(index);
      } else {
        return messageBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Messages reflecting the validation results.
     * </pre>
     *
     * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.datastream.v1.ValidationMessageOrBuilder>
        getMessageOrBuilderList() {
      if (messageBuilder_ != null) {
        return messageBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(message_);
      }
    }
    /**
     *
     *
     * <pre>
     * Messages reflecting the validation results.
     * </pre>
     *
     * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
     */
    public com.google.cloud.datastream.v1.ValidationMessage.Builder addMessageBuilder() {
      return getMessageFieldBuilder()
          .addBuilder(com.google.cloud.datastream.v1.ValidationMessage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Messages reflecting the validation results.
     * </pre>
     *
     * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
     */
    public com.google.cloud.datastream.v1.ValidationMessage.Builder addMessageBuilder(int index) {
      return getMessageFieldBuilder()
          .addBuilder(index, com.google.cloud.datastream.v1.ValidationMessage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Messages reflecting the validation results.
     * </pre>
     *
     * <code>repeated .google.cloud.datastream.v1.ValidationMessage message = 3;</code>
     */
    public java.util.List<com.google.cloud.datastream.v1.ValidationMessage.Builder>
        getMessageBuilderList() {
      return getMessageFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datastream.v1.ValidationMessage,
            com.google.cloud.datastream.v1.ValidationMessage.Builder,
            com.google.cloud.datastream.v1.ValidationMessageOrBuilder>
        getMessageFieldBuilder() {
      if (messageBuilder_ == null) {
        messageBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datastream.v1.ValidationMessage,
                com.google.cloud.datastream.v1.ValidationMessage.Builder,
                com.google.cloud.datastream.v1.ValidationMessageOrBuilder>(
                message_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        message_ = null;
      }
      return messageBuilder_;
    }

    private java.lang.Object code_ = "";
    /**
     *
     *
     * <pre>
     * A custom code identifying this validation.
     * </pre>
     *
     * <code>string code = 4;</code>
     *
     * @return The code.
     */
    public java.lang.String getCode() {
      java.lang.Object ref = code_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        code_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A custom code identifying this validation.
     * </pre>
     *
     * <code>string code = 4;</code>
     *
     * @return The bytes for code.
     */
    public com.google.protobuf.ByteString getCodeBytes() {
      java.lang.Object ref = code_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        code_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A custom code identifying this validation.
     * </pre>
     *
     * <code>string code = 4;</code>
     *
     * @param value The code to set.
     * @return This builder for chaining.
     */
    public Builder setCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      code_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A custom code identifying this validation.
     * </pre>
     *
     * <code>string code = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCode() {
      code_ = getDefaultInstance().getCode();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A custom code identifying this validation.
     * </pre>
     *
     * <code>string code = 4;</code>
     *
     * @param value The bytes for code to set.
     * @return This builder for chaining.
     */
    public Builder setCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      code_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1.Validation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1.Validation)
  private static final com.google.cloud.datastream.v1.Validation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datastream.v1.Validation();
  }

  public static com.google.cloud.datastream.v1.Validation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Validation> PARSER =
      new com.google.protobuf.AbstractParser<Validation>() {
        @java.lang.Override
        public Validation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Validation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Validation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datastream.v1.Validation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
