/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastream.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RouteName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PRIVATE_CONNECTION_ROUTE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/privateConnections/{private_connection}/routes/{route}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String privateConnection;
    private final String route;

    @Deprecated
    protected RouteName() {
        this.project = null;
        this.location = null;
        this.privateConnection = null;
        this.route = null;
    }

    private RouteName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.privateConnection = (String)Preconditions.checkNotNull((Object)builder.getPrivateConnection());
        this.route = (String)Preconditions.checkNotNull((Object)builder.getRoute());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPrivateConnection() {
        return this.privateConnection;
    }

    public String getRoute() {
        return this.route;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RouteName of(String project, String location, String privateConnection, String route) {
        return RouteName.newBuilder().setProject(project).setLocation(location).setPrivateConnection(privateConnection).setRoute(route).build();
    }

    public static String format(String project, String location, String privateConnection, String route) {
        return RouteName.newBuilder().setProject(project).setLocation(location).setPrivateConnection(privateConnection).setRoute(route).build().toString();
    }

    public static RouteName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PRIVATE_CONNECTION_ROUTE.validatedMatch(formattedString, "RouteName.parse: formattedString not in valid format");
        return RouteName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("private_connection"), (String)matchMap.get("route"));
    }

    public static List<RouteName> parseList(List<String> formattedStrings) {
        ArrayList<RouteName> list = new ArrayList<RouteName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RouteName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RouteName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RouteName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PRIVATE_CONNECTION_ROUTE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RouteName routeName = this;
            synchronized (routeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.privateConnection != null) {
                        fieldMapBuilder.put((Object)"private_connection", (Object)this.privateConnection);
                    }
                    if (this.route != null) {
                        fieldMapBuilder.put((Object)"route", (Object)this.route);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PRIVATE_CONNECTION_ROUTE.instantiate(new String[]{"project", this.project, "location", this.location, "private_connection", this.privateConnection, "route", this.route});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RouteName that = (RouteName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.privateConnection, that.privateConnection) && Objects.equals(this.route, that.route);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.privateConnection);
        h *= 1000003;
        return h ^= Objects.hashCode(this.route);
    }

    public static class Builder {
        private String project;
        private String location;
        private String privateConnection;
        private String route;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPrivateConnection() {
            return this.privateConnection;
        }

        public String getRoute() {
            return this.route;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPrivateConnection(String privateConnection) {
            this.privateConnection = privateConnection;
            return this;
        }

        public Builder setRoute(String route) {
            this.route = route;
            return this;
        }

        private Builder(RouteName routeName) {
            this.project = routeName.project;
            this.location = routeName.location;
            this.privateConnection = routeName.privateConnection;
            this.route = routeName.route;
        }

        public RouteName build() {
            return new RouteName(this);
        }
    }
}

