/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datastream/v1alpha1/datastream_resources.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.datastream.v1alpha1;

/** Protobuf type {@code google.cloud.datastream.v1alpha1.ConnectionProfile} */
public final class ConnectionProfile extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1alpha1.ConnectionProfile)
    ConnectionProfileOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ConnectionProfile.newBuilder() to construct.
  private ConnectionProfile(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ConnectionProfile() {
    name_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ConnectionProfile();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1alpha1_ConnectionProfile_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1alpha1_ConnectionProfile_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datastream.v1alpha1.ConnectionProfile.class,
            com.google.cloud.datastream.v1alpha1.ConnectionProfile.Builder.class);
  }

  private int bitField0_;
  private int profileCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object profile_;

  public enum ProfileCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ORACLE_PROFILE(100),
    GCS_PROFILE(101),
    MYSQL_PROFILE(102),
    PROFILE_NOT_SET(0);
    private final int value;

    private ProfileCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ProfileCase valueOf(int value) {
      return forNumber(value);
    }

    public static ProfileCase forNumber(int value) {
      switch (value) {
        case 100:
          return ORACLE_PROFILE;
        case 101:
          return GCS_PROFILE;
        case 102:
          return MYSQL_PROFILE;
        case 0:
          return PROFILE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ProfileCase getProfileCase() {
    return ProfileCase.forNumber(profileCase_);
  }

  private int connectivityCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object connectivity_;

  public enum ConnectivityCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    NO_CONNECTIVITY(200),
    STATIC_SERVICE_IP_CONNECTIVITY(201),
    FORWARD_SSH_CONNECTIVITY(202),
    PRIVATE_CONNECTIVITY(203),
    CONNECTIVITY_NOT_SET(0);
    private final int value;

    private ConnectivityCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ConnectivityCase valueOf(int value) {
      return forNumber(value);
    }

    public static ConnectivityCase forNumber(int value) {
      switch (value) {
        case 200:
          return NO_CONNECTIVITY;
        case 201:
          return STATIC_SERVICE_IP_CONNECTIVITY;
        case 202:
          return FORWARD_SSH_CONNECTIVITY;
        case 203:
          return PRIVATE_CONNECTIVITY;
        case 0:
          return CONNECTIVITY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ConnectivityCase getConnectivityCase() {
    return ConnectivityCase.forNumber(connectivityCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The resource's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The create time of the resource.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The create time of the resource.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The create time of the resource.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The update time of the resource.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The update time of the resource.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The update time of the resource.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
                .internal_static_google_cloud_datastream_v1alpha1_ConnectionProfile_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. Display name.
   * </pre>
   *
   * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Display name.
   * </pre>
   *
   * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORACLE_PROFILE_FIELD_NUMBER = 100;
  /**
   *
   *
   * <pre>
   * Oracle ConnectionProfile configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.OracleProfile oracle_profile = 100;</code>
   *
   * @return Whether the oracleProfile field is set.
   */
  @java.lang.Override
  public boolean hasOracleProfile() {
    return profileCase_ == 100;
  }
  /**
   *
   *
   * <pre>
   * Oracle ConnectionProfile configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.OracleProfile oracle_profile = 100;</code>
   *
   * @return The oracleProfile.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.OracleProfile getOracleProfile() {
    if (profileCase_ == 100) {
      return (com.google.cloud.datastream.v1alpha1.OracleProfile) profile_;
    }
    return com.google.cloud.datastream.v1alpha1.OracleProfile.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Oracle ConnectionProfile configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.OracleProfile oracle_profile = 100;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.OracleProfileOrBuilder getOracleProfileOrBuilder() {
    if (profileCase_ == 100) {
      return (com.google.cloud.datastream.v1alpha1.OracleProfile) profile_;
    }
    return com.google.cloud.datastream.v1alpha1.OracleProfile.getDefaultInstance();
  }

  public static final int GCS_PROFILE_FIELD_NUMBER = 101;
  /**
   *
   *
   * <pre>
   * Cloud Storage ConnectionProfile configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.GcsProfile gcs_profile = 101;</code>
   *
   * @return Whether the gcsProfile field is set.
   */
  @java.lang.Override
  public boolean hasGcsProfile() {
    return profileCase_ == 101;
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage ConnectionProfile configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.GcsProfile gcs_profile = 101;</code>
   *
   * @return The gcsProfile.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.GcsProfile getGcsProfile() {
    if (profileCase_ == 101) {
      return (com.google.cloud.datastream.v1alpha1.GcsProfile) profile_;
    }
    return com.google.cloud.datastream.v1alpha1.GcsProfile.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage ConnectionProfile configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.GcsProfile gcs_profile = 101;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.GcsProfileOrBuilder getGcsProfileOrBuilder() {
    if (profileCase_ == 101) {
      return (com.google.cloud.datastream.v1alpha1.GcsProfile) profile_;
    }
    return com.google.cloud.datastream.v1alpha1.GcsProfile.getDefaultInstance();
  }

  public static final int MYSQL_PROFILE_FIELD_NUMBER = 102;
  /**
   *
   *
   * <pre>
   * MySQL ConnectionProfile configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.MysqlProfile mysql_profile = 102;</code>
   *
   * @return Whether the mysqlProfile field is set.
   */
  @java.lang.Override
  public boolean hasMysqlProfile() {
    return profileCase_ == 102;
  }
  /**
   *
   *
   * <pre>
   * MySQL ConnectionProfile configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.MysqlProfile mysql_profile = 102;</code>
   *
   * @return The mysqlProfile.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.MysqlProfile getMysqlProfile() {
    if (profileCase_ == 102) {
      return (com.google.cloud.datastream.v1alpha1.MysqlProfile) profile_;
    }
    return com.google.cloud.datastream.v1alpha1.MysqlProfile.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * MySQL ConnectionProfile configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.MysqlProfile mysql_profile = 102;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.MysqlProfileOrBuilder getMysqlProfileOrBuilder() {
    if (profileCase_ == 102) {
      return (com.google.cloud.datastream.v1alpha1.MysqlProfile) profile_;
    }
    return com.google.cloud.datastream.v1alpha1.MysqlProfile.getDefaultInstance();
  }

  public static final int NO_CONNECTIVITY_FIELD_NUMBER = 200;
  /**
   *
   *
   * <pre>
   * No connectivity option chosen.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.NoConnectivitySettings no_connectivity = 200;</code>
   *
   * @return Whether the noConnectivity field is set.
   */
  @java.lang.Override
  public boolean hasNoConnectivity() {
    return connectivityCase_ == 200;
  }
  /**
   *
   *
   * <pre>
   * No connectivity option chosen.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.NoConnectivitySettings no_connectivity = 200;</code>
   *
   * @return The noConnectivity.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.NoConnectivitySettings getNoConnectivity() {
    if (connectivityCase_ == 200) {
      return (com.google.cloud.datastream.v1alpha1.NoConnectivitySettings) connectivity_;
    }
    return com.google.cloud.datastream.v1alpha1.NoConnectivitySettings.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * No connectivity option chosen.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.NoConnectivitySettings no_connectivity = 200;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.NoConnectivitySettingsOrBuilder
      getNoConnectivityOrBuilder() {
    if (connectivityCase_ == 200) {
      return (com.google.cloud.datastream.v1alpha1.NoConnectivitySettings) connectivity_;
    }
    return com.google.cloud.datastream.v1alpha1.NoConnectivitySettings.getDefaultInstance();
  }

  public static final int STATIC_SERVICE_IP_CONNECTIVITY_FIELD_NUMBER = 201;
  /**
   *
   *
   * <pre>
   * Static Service IP connectivity.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity static_service_ip_connectivity = 201;
   * </code>
   *
   * @return Whether the staticServiceIpConnectivity field is set.
   */
  @java.lang.Override
  public boolean hasStaticServiceIpConnectivity() {
    return connectivityCase_ == 201;
  }
  /**
   *
   *
   * <pre>
   * Static Service IP connectivity.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity static_service_ip_connectivity = 201;
   * </code>
   *
   * @return The staticServiceIpConnectivity.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity
      getStaticServiceIpConnectivity() {
    if (connectivityCase_ == 201) {
      return (com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity) connectivity_;
    }
    return com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Static Service IP connectivity.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity static_service_ip_connectivity = 201;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivityOrBuilder
      getStaticServiceIpConnectivityOrBuilder() {
    if (connectivityCase_ == 201) {
      return (com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity) connectivity_;
    }
    return com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity.getDefaultInstance();
  }

  public static final int FORWARD_SSH_CONNECTIVITY_FIELD_NUMBER = 202;
  /**
   *
   *
   * <pre>
   * Forward SSH tunnel connectivity.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 202;
   * </code>
   *
   * @return Whether the forwardSshConnectivity field is set.
   */
  @java.lang.Override
  public boolean hasForwardSshConnectivity() {
    return connectivityCase_ == 202;
  }
  /**
   *
   *
   * <pre>
   * Forward SSH tunnel connectivity.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 202;
   * </code>
   *
   * @return The forwardSshConnectivity.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity
      getForwardSshConnectivity() {
    if (connectivityCase_ == 202) {
      return (com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity) connectivity_;
    }
    return com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Forward SSH tunnel connectivity.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 202;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivityOrBuilder
      getForwardSshConnectivityOrBuilder() {
    if (connectivityCase_ == 202) {
      return (com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity) connectivity_;
    }
    return com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity.getDefaultInstance();
  }

  public static final int PRIVATE_CONNECTIVITY_FIELD_NUMBER = 203;
  /**
   *
   *
   * <pre>
   * Private connectivity.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.PrivateConnectivity private_connectivity = 203;</code>
   *
   * @return Whether the privateConnectivity field is set.
   */
  @java.lang.Override
  public boolean hasPrivateConnectivity() {
    return connectivityCase_ == 203;
  }
  /**
   *
   *
   * <pre>
   * Private connectivity.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.PrivateConnectivity private_connectivity = 203;</code>
   *
   * @return The privateConnectivity.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.PrivateConnectivity getPrivateConnectivity() {
    if (connectivityCase_ == 203) {
      return (com.google.cloud.datastream.v1alpha1.PrivateConnectivity) connectivity_;
    }
    return com.google.cloud.datastream.v1alpha1.PrivateConnectivity.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Private connectivity.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.PrivateConnectivity private_connectivity = 203;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.PrivateConnectivityOrBuilder
      getPrivateConnectivityOrBuilder() {
    if (connectivityCase_ == 203) {
      return (com.google.cloud.datastream.v1alpha1.PrivateConnectivity) connectivity_;
    }
    return com.google.cloud.datastream.v1alpha1.PrivateConnectivity.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, displayName_);
    }
    if (profileCase_ == 100) {
      output.writeMessage(100, (com.google.cloud.datastream.v1alpha1.OracleProfile) profile_);
    }
    if (profileCase_ == 101) {
      output.writeMessage(101, (com.google.cloud.datastream.v1alpha1.GcsProfile) profile_);
    }
    if (profileCase_ == 102) {
      output.writeMessage(102, (com.google.cloud.datastream.v1alpha1.MysqlProfile) profile_);
    }
    if (connectivityCase_ == 200) {
      output.writeMessage(
          200, (com.google.cloud.datastream.v1alpha1.NoConnectivitySettings) connectivity_);
    }
    if (connectivityCase_ == 201) {
      output.writeMessage(
          201, (com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity) connectivity_);
    }
    if (connectivityCase_ == 202) {
      output.writeMessage(
          202, (com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity) connectivity_);
    }
    if (connectivityCase_ == 203) {
      output.writeMessage(
          203, (com.google.cloud.datastream.v1alpha1.PrivateConnectivity) connectivity_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, displayName_);
    }
    if (profileCase_ == 100) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              100, (com.google.cloud.datastream.v1alpha1.OracleProfile) profile_);
    }
    if (profileCase_ == 101) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              101, (com.google.cloud.datastream.v1alpha1.GcsProfile) profile_);
    }
    if (profileCase_ == 102) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              102, (com.google.cloud.datastream.v1alpha1.MysqlProfile) profile_);
    }
    if (connectivityCase_ == 200) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              200, (com.google.cloud.datastream.v1alpha1.NoConnectivitySettings) connectivity_);
    }
    if (connectivityCase_ == 201) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              201,
              (com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity) connectivity_);
    }
    if (connectivityCase_ == 202) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              202,
              (com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity) connectivity_);
    }
    if (connectivityCase_ == 203) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              203, (com.google.cloud.datastream.v1alpha1.PrivateConnectivity) connectivity_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datastream.v1alpha1.ConnectionProfile)) {
      return super.equals(obj);
    }
    com.google.cloud.datastream.v1alpha1.ConnectionProfile other =
        (com.google.cloud.datastream.v1alpha1.ConnectionProfile) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getProfileCase().equals(other.getProfileCase())) return false;
    switch (profileCase_) {
      case 100:
        if (!getOracleProfile().equals(other.getOracleProfile())) return false;
        break;
      case 101:
        if (!getGcsProfile().equals(other.getGcsProfile())) return false;
        break;
      case 102:
        if (!getMysqlProfile().equals(other.getMysqlProfile())) return false;
        break;
      case 0:
      default:
    }
    if (!getConnectivityCase().equals(other.getConnectivityCase())) return false;
    switch (connectivityCase_) {
      case 200:
        if (!getNoConnectivity().equals(other.getNoConnectivity())) return false;
        break;
      case 201:
        if (!getStaticServiceIpConnectivity().equals(other.getStaticServiceIpConnectivity()))
          return false;
        break;
      case 202:
        if (!getForwardSshConnectivity().equals(other.getForwardSshConnectivity())) return false;
        break;
      case 203:
        if (!getPrivateConnectivity().equals(other.getPrivateConnectivity())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    switch (profileCase_) {
      case 100:
        hash = (37 * hash) + ORACLE_PROFILE_FIELD_NUMBER;
        hash = (53 * hash) + getOracleProfile().hashCode();
        break;
      case 101:
        hash = (37 * hash) + GCS_PROFILE_FIELD_NUMBER;
        hash = (53 * hash) + getGcsProfile().hashCode();
        break;
      case 102:
        hash = (37 * hash) + MYSQL_PROFILE_FIELD_NUMBER;
        hash = (53 * hash) + getMysqlProfile().hashCode();
        break;
      case 0:
      default:
    }
    switch (connectivityCase_) {
      case 200:
        hash = (37 * hash) + NO_CONNECTIVITY_FIELD_NUMBER;
        hash = (53 * hash) + getNoConnectivity().hashCode();
        break;
      case 201:
        hash = (37 * hash) + STATIC_SERVICE_IP_CONNECTIVITY_FIELD_NUMBER;
        hash = (53 * hash) + getStaticServiceIpConnectivity().hashCode();
        break;
      case 202:
        hash = (37 * hash) + FORWARD_SSH_CONNECTIVITY_FIELD_NUMBER;
        hash = (53 * hash) + getForwardSshConnectivity().hashCode();
        break;
      case 203:
        hash = (37 * hash) + PRIVATE_CONNECTIVITY_FIELD_NUMBER;
        hash = (53 * hash) + getPrivateConnectivity().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datastream.v1alpha1.ConnectionProfile parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1alpha1.ConnectionProfile parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1alpha1.ConnectionProfile parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1alpha1.ConnectionProfile parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1alpha1.ConnectionProfile parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1alpha1.ConnectionProfile parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1alpha1.ConnectionProfile parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1alpha1.ConnectionProfile parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1alpha1.ConnectionProfile parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1alpha1.ConnectionProfile parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1alpha1.ConnectionProfile parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1alpha1.ConnectionProfile parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datastream.v1alpha1.ConnectionProfile prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /** Protobuf type {@code google.cloud.datastream.v1alpha1.ConnectionProfile} */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1alpha1.ConnectionProfile)
      com.google.cloud.datastream.v1alpha1.ConnectionProfileOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1alpha1_ConnectionProfile_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1alpha1_ConnectionProfile_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1alpha1.ConnectionProfile.class,
              com.google.cloud.datastream.v1alpha1.ConnectionProfile.Builder.class);
    }

    // Construct using com.google.cloud.datastream.v1alpha1.ConnectionProfile.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      displayName_ = "";
      if (oracleProfileBuilder_ != null) {
        oracleProfileBuilder_.clear();
      }
      if (gcsProfileBuilder_ != null) {
        gcsProfileBuilder_.clear();
      }
      if (mysqlProfileBuilder_ != null) {
        mysqlProfileBuilder_.clear();
      }
      if (noConnectivityBuilder_ != null) {
        noConnectivityBuilder_.clear();
      }
      if (staticServiceIpConnectivityBuilder_ != null) {
        staticServiceIpConnectivityBuilder_.clear();
      }
      if (forwardSshConnectivityBuilder_ != null) {
        forwardSshConnectivityBuilder_.clear();
      }
      if (privateConnectivityBuilder_ != null) {
        privateConnectivityBuilder_.clear();
      }
      profileCase_ = 0;
      profile_ = null;
      connectivityCase_ = 0;
      connectivity_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1alpha1_ConnectionProfile_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.ConnectionProfile getDefaultInstanceForType() {
      return com.google.cloud.datastream.v1alpha1.ConnectionProfile.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.ConnectionProfile build() {
      com.google.cloud.datastream.v1alpha1.ConnectionProfile result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.ConnectionProfile buildPartial() {
      com.google.cloud.datastream.v1alpha1.ConnectionProfile result =
          new com.google.cloud.datastream.v1alpha1.ConnectionProfile(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datastream.v1alpha1.ConnectionProfile result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.displayName_ = displayName_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.datastream.v1alpha1.ConnectionProfile result) {
      result.profileCase_ = profileCase_;
      result.profile_ = this.profile_;
      if (profileCase_ == 100 && oracleProfileBuilder_ != null) {
        result.profile_ = oracleProfileBuilder_.build();
      }
      if (profileCase_ == 101 && gcsProfileBuilder_ != null) {
        result.profile_ = gcsProfileBuilder_.build();
      }
      if (profileCase_ == 102 && mysqlProfileBuilder_ != null) {
        result.profile_ = mysqlProfileBuilder_.build();
      }
      result.connectivityCase_ = connectivityCase_;
      result.connectivity_ = this.connectivity_;
      if (connectivityCase_ == 200 && noConnectivityBuilder_ != null) {
        result.connectivity_ = noConnectivityBuilder_.build();
      }
      if (connectivityCase_ == 201 && staticServiceIpConnectivityBuilder_ != null) {
        result.connectivity_ = staticServiceIpConnectivityBuilder_.build();
      }
      if (connectivityCase_ == 202 && forwardSshConnectivityBuilder_ != null) {
        result.connectivity_ = forwardSshConnectivityBuilder_.build();
      }
      if (connectivityCase_ == 203 && privateConnectivityBuilder_ != null) {
        result.connectivity_ = privateConnectivityBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datastream.v1alpha1.ConnectionProfile) {
        return mergeFrom((com.google.cloud.datastream.v1alpha1.ConnectionProfile) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datastream.v1alpha1.ConnectionProfile other) {
      if (other == com.google.cloud.datastream.v1alpha1.ConnectionProfile.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000008;
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      switch (other.getProfileCase()) {
        case ORACLE_PROFILE:
          {
            mergeOracleProfile(other.getOracleProfile());
            break;
          }
        case GCS_PROFILE:
          {
            mergeGcsProfile(other.getGcsProfile());
            break;
          }
        case MYSQL_PROFILE:
          {
            mergeMysqlProfile(other.getMysqlProfile());
            break;
          }
        case PROFILE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getConnectivityCase()) {
        case NO_CONNECTIVITY:
          {
            mergeNoConnectivity(other.getNoConnectivity());
            break;
          }
        case STATIC_SERVICE_IP_CONNECTIVITY:
          {
            mergeStaticServiceIpConnectivity(other.getStaticServiceIpConnectivity());
            break;
          }
        case FORWARD_SSH_CONNECTIVITY:
          {
            mergeForwardSshConnectivity(other.getForwardSshConnectivity());
            break;
          }
        case PRIVATE_CONNECTIVITY:
          {
            mergePrivateConnectivity(other.getPrivateConnectivity());
            break;
          }
        case CONNECTIVITY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 802:
              {
                input.readMessage(getOracleProfileFieldBuilder().getBuilder(), extensionRegistry);
                profileCase_ = 100;
                break;
              } // case 802
            case 810:
              {
                input.readMessage(getGcsProfileFieldBuilder().getBuilder(), extensionRegistry);
                profileCase_ = 101;
                break;
              } // case 810
            case 818:
              {
                input.readMessage(getMysqlProfileFieldBuilder().getBuilder(), extensionRegistry);
                profileCase_ = 102;
                break;
              } // case 818
            case 1602:
              {
                input.readMessage(getNoConnectivityFieldBuilder().getBuilder(), extensionRegistry);
                connectivityCase_ = 200;
                break;
              } // case 1602
            case 1610:
              {
                input.readMessage(
                    getStaticServiceIpConnectivityFieldBuilder().getBuilder(), extensionRegistry);
                connectivityCase_ = 201;
                break;
              } // case 1610
            case 1618:
              {
                input.readMessage(
                    getForwardSshConnectivityFieldBuilder().getBuilder(), extensionRegistry);
                connectivityCase_ = 202;
                break;
              } // case 1618
            case 1626:
              {
                input.readMessage(
                    getPrivateConnectivityFieldBuilder().getBuilder(), extensionRegistry);
                connectivityCase_ = 203;
                break;
              } // case 1626
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int profileCase_ = 0;
    private java.lang.Object profile_;

    public ProfileCase getProfileCase() {
      return ProfileCase.forNumber(profileCase_);
    }

    public Builder clearProfile() {
      profileCase_ = 0;
      profile_ = null;
      onChanged();
      return this;
    }

    private int connectivityCase_ = 0;
    private java.lang.Object connectivity_;

    public ConnectivityCase getConnectivityCase() {
      return ConnectivityCase.forNumber(connectivityCase_);
    }

    public Builder clearConnectivity() {
      connectivityCase_ = 0;
      connectivity_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The create time of the resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The create time of the resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The create time of the resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The create time of the resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The create time of the resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The create time of the resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The create time of the resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The create time of the resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The create time of the resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The update time of the resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The update time of the resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The update time of the resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The update time of the resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The update time of the resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The update time of the resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The update time of the resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The update time of the resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The update time of the resource.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. Display name.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Display name.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Display name.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Display name.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Display name.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.OracleProfile,
            com.google.cloud.datastream.v1alpha1.OracleProfile.Builder,
            com.google.cloud.datastream.v1alpha1.OracleProfileOrBuilder>
        oracleProfileBuilder_;
    /**
     *
     *
     * <pre>
     * Oracle ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleProfile oracle_profile = 100;</code>
     *
     * @return Whether the oracleProfile field is set.
     */
    @java.lang.Override
    public boolean hasOracleProfile() {
      return profileCase_ == 100;
    }
    /**
     *
     *
     * <pre>
     * Oracle ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleProfile oracle_profile = 100;</code>
     *
     * @return The oracleProfile.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.OracleProfile getOracleProfile() {
      if (oracleProfileBuilder_ == null) {
        if (profileCase_ == 100) {
          return (com.google.cloud.datastream.v1alpha1.OracleProfile) profile_;
        }
        return com.google.cloud.datastream.v1alpha1.OracleProfile.getDefaultInstance();
      } else {
        if (profileCase_ == 100) {
          return oracleProfileBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1alpha1.OracleProfile.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Oracle ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleProfile oracle_profile = 100;</code>
     */
    public Builder setOracleProfile(com.google.cloud.datastream.v1alpha1.OracleProfile value) {
      if (oracleProfileBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        profile_ = value;
        onChanged();
      } else {
        oracleProfileBuilder_.setMessage(value);
      }
      profileCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Oracle ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleProfile oracle_profile = 100;</code>
     */
    public Builder setOracleProfile(
        com.google.cloud.datastream.v1alpha1.OracleProfile.Builder builderForValue) {
      if (oracleProfileBuilder_ == null) {
        profile_ = builderForValue.build();
        onChanged();
      } else {
        oracleProfileBuilder_.setMessage(builderForValue.build());
      }
      profileCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Oracle ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleProfile oracle_profile = 100;</code>
     */
    public Builder mergeOracleProfile(com.google.cloud.datastream.v1alpha1.OracleProfile value) {
      if (oracleProfileBuilder_ == null) {
        if (profileCase_ == 100
            && profile_
                != com.google.cloud.datastream.v1alpha1.OracleProfile.getDefaultInstance()) {
          profile_ =
              com.google.cloud.datastream.v1alpha1.OracleProfile.newBuilder(
                      (com.google.cloud.datastream.v1alpha1.OracleProfile) profile_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          profile_ = value;
        }
        onChanged();
      } else {
        if (profileCase_ == 100) {
          oracleProfileBuilder_.mergeFrom(value);
        } else {
          oracleProfileBuilder_.setMessage(value);
        }
      }
      profileCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Oracle ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleProfile oracle_profile = 100;</code>
     */
    public Builder clearOracleProfile() {
      if (oracleProfileBuilder_ == null) {
        if (profileCase_ == 100) {
          profileCase_ = 0;
          profile_ = null;
          onChanged();
        }
      } else {
        if (profileCase_ == 100) {
          profileCase_ = 0;
          profile_ = null;
        }
        oracleProfileBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Oracle ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleProfile oracle_profile = 100;</code>
     */
    public com.google.cloud.datastream.v1alpha1.OracleProfile.Builder getOracleProfileBuilder() {
      return getOracleProfileFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Oracle ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleProfile oracle_profile = 100;</code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.OracleProfileOrBuilder getOracleProfileOrBuilder() {
      if ((profileCase_ == 100) && (oracleProfileBuilder_ != null)) {
        return oracleProfileBuilder_.getMessageOrBuilder();
      } else {
        if (profileCase_ == 100) {
          return (com.google.cloud.datastream.v1alpha1.OracleProfile) profile_;
        }
        return com.google.cloud.datastream.v1alpha1.OracleProfile.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Oracle ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleProfile oracle_profile = 100;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.OracleProfile,
            com.google.cloud.datastream.v1alpha1.OracleProfile.Builder,
            com.google.cloud.datastream.v1alpha1.OracleProfileOrBuilder>
        getOracleProfileFieldBuilder() {
      if (oracleProfileBuilder_ == null) {
        if (!(profileCase_ == 100)) {
          profile_ = com.google.cloud.datastream.v1alpha1.OracleProfile.getDefaultInstance();
        }
        oracleProfileBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1alpha1.OracleProfile,
                com.google.cloud.datastream.v1alpha1.OracleProfile.Builder,
                com.google.cloud.datastream.v1alpha1.OracleProfileOrBuilder>(
                (com.google.cloud.datastream.v1alpha1.OracleProfile) profile_,
                getParentForChildren(),
                isClean());
        profile_ = null;
      }
      profileCase_ = 100;
      onChanged();
      return oracleProfileBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.GcsProfile,
            com.google.cloud.datastream.v1alpha1.GcsProfile.Builder,
            com.google.cloud.datastream.v1alpha1.GcsProfileOrBuilder>
        gcsProfileBuilder_;
    /**
     *
     *
     * <pre>
     * Cloud Storage ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.GcsProfile gcs_profile = 101;</code>
     *
     * @return Whether the gcsProfile field is set.
     */
    @java.lang.Override
    public boolean hasGcsProfile() {
      return profileCase_ == 101;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.GcsProfile gcs_profile = 101;</code>
     *
     * @return The gcsProfile.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.GcsProfile getGcsProfile() {
      if (gcsProfileBuilder_ == null) {
        if (profileCase_ == 101) {
          return (com.google.cloud.datastream.v1alpha1.GcsProfile) profile_;
        }
        return com.google.cloud.datastream.v1alpha1.GcsProfile.getDefaultInstance();
      } else {
        if (profileCase_ == 101) {
          return gcsProfileBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1alpha1.GcsProfile.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.GcsProfile gcs_profile = 101;</code>
     */
    public Builder setGcsProfile(com.google.cloud.datastream.v1alpha1.GcsProfile value) {
      if (gcsProfileBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        profile_ = value;
        onChanged();
      } else {
        gcsProfileBuilder_.setMessage(value);
      }
      profileCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.GcsProfile gcs_profile = 101;</code>
     */
    public Builder setGcsProfile(
        com.google.cloud.datastream.v1alpha1.GcsProfile.Builder builderForValue) {
      if (gcsProfileBuilder_ == null) {
        profile_ = builderForValue.build();
        onChanged();
      } else {
        gcsProfileBuilder_.setMessage(builderForValue.build());
      }
      profileCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.GcsProfile gcs_profile = 101;</code>
     */
    public Builder mergeGcsProfile(com.google.cloud.datastream.v1alpha1.GcsProfile value) {
      if (gcsProfileBuilder_ == null) {
        if (profileCase_ == 101
            && profile_ != com.google.cloud.datastream.v1alpha1.GcsProfile.getDefaultInstance()) {
          profile_ =
              com.google.cloud.datastream.v1alpha1.GcsProfile.newBuilder(
                      (com.google.cloud.datastream.v1alpha1.GcsProfile) profile_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          profile_ = value;
        }
        onChanged();
      } else {
        if (profileCase_ == 101) {
          gcsProfileBuilder_.mergeFrom(value);
        } else {
          gcsProfileBuilder_.setMessage(value);
        }
      }
      profileCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.GcsProfile gcs_profile = 101;</code>
     */
    public Builder clearGcsProfile() {
      if (gcsProfileBuilder_ == null) {
        if (profileCase_ == 101) {
          profileCase_ = 0;
          profile_ = null;
          onChanged();
        }
      } else {
        if (profileCase_ == 101) {
          profileCase_ = 0;
          profile_ = null;
        }
        gcsProfileBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.GcsProfile gcs_profile = 101;</code>
     */
    public com.google.cloud.datastream.v1alpha1.GcsProfile.Builder getGcsProfileBuilder() {
      return getGcsProfileFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.GcsProfile gcs_profile = 101;</code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.GcsProfileOrBuilder getGcsProfileOrBuilder() {
      if ((profileCase_ == 101) && (gcsProfileBuilder_ != null)) {
        return gcsProfileBuilder_.getMessageOrBuilder();
      } else {
        if (profileCase_ == 101) {
          return (com.google.cloud.datastream.v1alpha1.GcsProfile) profile_;
        }
        return com.google.cloud.datastream.v1alpha1.GcsProfile.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.GcsProfile gcs_profile = 101;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.GcsProfile,
            com.google.cloud.datastream.v1alpha1.GcsProfile.Builder,
            com.google.cloud.datastream.v1alpha1.GcsProfileOrBuilder>
        getGcsProfileFieldBuilder() {
      if (gcsProfileBuilder_ == null) {
        if (!(profileCase_ == 101)) {
          profile_ = com.google.cloud.datastream.v1alpha1.GcsProfile.getDefaultInstance();
        }
        gcsProfileBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1alpha1.GcsProfile,
                com.google.cloud.datastream.v1alpha1.GcsProfile.Builder,
                com.google.cloud.datastream.v1alpha1.GcsProfileOrBuilder>(
                (com.google.cloud.datastream.v1alpha1.GcsProfile) profile_,
                getParentForChildren(),
                isClean());
        profile_ = null;
      }
      profileCase_ = 101;
      onChanged();
      return gcsProfileBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.MysqlProfile,
            com.google.cloud.datastream.v1alpha1.MysqlProfile.Builder,
            com.google.cloud.datastream.v1alpha1.MysqlProfileOrBuilder>
        mysqlProfileBuilder_;
    /**
     *
     *
     * <pre>
     * MySQL ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlProfile mysql_profile = 102;</code>
     *
     * @return Whether the mysqlProfile field is set.
     */
    @java.lang.Override
    public boolean hasMysqlProfile() {
      return profileCase_ == 102;
    }
    /**
     *
     *
     * <pre>
     * MySQL ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlProfile mysql_profile = 102;</code>
     *
     * @return The mysqlProfile.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.MysqlProfile getMysqlProfile() {
      if (mysqlProfileBuilder_ == null) {
        if (profileCase_ == 102) {
          return (com.google.cloud.datastream.v1alpha1.MysqlProfile) profile_;
        }
        return com.google.cloud.datastream.v1alpha1.MysqlProfile.getDefaultInstance();
      } else {
        if (profileCase_ == 102) {
          return mysqlProfileBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1alpha1.MysqlProfile.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * MySQL ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlProfile mysql_profile = 102;</code>
     */
    public Builder setMysqlProfile(com.google.cloud.datastream.v1alpha1.MysqlProfile value) {
      if (mysqlProfileBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        profile_ = value;
        onChanged();
      } else {
        mysqlProfileBuilder_.setMessage(value);
      }
      profileCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * MySQL ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlProfile mysql_profile = 102;</code>
     */
    public Builder setMysqlProfile(
        com.google.cloud.datastream.v1alpha1.MysqlProfile.Builder builderForValue) {
      if (mysqlProfileBuilder_ == null) {
        profile_ = builderForValue.build();
        onChanged();
      } else {
        mysqlProfileBuilder_.setMessage(builderForValue.build());
      }
      profileCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * MySQL ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlProfile mysql_profile = 102;</code>
     */
    public Builder mergeMysqlProfile(com.google.cloud.datastream.v1alpha1.MysqlProfile value) {
      if (mysqlProfileBuilder_ == null) {
        if (profileCase_ == 102
            && profile_ != com.google.cloud.datastream.v1alpha1.MysqlProfile.getDefaultInstance()) {
          profile_ =
              com.google.cloud.datastream.v1alpha1.MysqlProfile.newBuilder(
                      (com.google.cloud.datastream.v1alpha1.MysqlProfile) profile_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          profile_ = value;
        }
        onChanged();
      } else {
        if (profileCase_ == 102) {
          mysqlProfileBuilder_.mergeFrom(value);
        } else {
          mysqlProfileBuilder_.setMessage(value);
        }
      }
      profileCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * MySQL ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlProfile mysql_profile = 102;</code>
     */
    public Builder clearMysqlProfile() {
      if (mysqlProfileBuilder_ == null) {
        if (profileCase_ == 102) {
          profileCase_ = 0;
          profile_ = null;
          onChanged();
        }
      } else {
        if (profileCase_ == 102) {
          profileCase_ = 0;
          profile_ = null;
        }
        mysqlProfileBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * MySQL ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlProfile mysql_profile = 102;</code>
     */
    public com.google.cloud.datastream.v1alpha1.MysqlProfile.Builder getMysqlProfileBuilder() {
      return getMysqlProfileFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * MySQL ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlProfile mysql_profile = 102;</code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.MysqlProfileOrBuilder getMysqlProfileOrBuilder() {
      if ((profileCase_ == 102) && (mysqlProfileBuilder_ != null)) {
        return mysqlProfileBuilder_.getMessageOrBuilder();
      } else {
        if (profileCase_ == 102) {
          return (com.google.cloud.datastream.v1alpha1.MysqlProfile) profile_;
        }
        return com.google.cloud.datastream.v1alpha1.MysqlProfile.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * MySQL ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlProfile mysql_profile = 102;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.MysqlProfile,
            com.google.cloud.datastream.v1alpha1.MysqlProfile.Builder,
            com.google.cloud.datastream.v1alpha1.MysqlProfileOrBuilder>
        getMysqlProfileFieldBuilder() {
      if (mysqlProfileBuilder_ == null) {
        if (!(profileCase_ == 102)) {
          profile_ = com.google.cloud.datastream.v1alpha1.MysqlProfile.getDefaultInstance();
        }
        mysqlProfileBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1alpha1.MysqlProfile,
                com.google.cloud.datastream.v1alpha1.MysqlProfile.Builder,
                com.google.cloud.datastream.v1alpha1.MysqlProfileOrBuilder>(
                (com.google.cloud.datastream.v1alpha1.MysqlProfile) profile_,
                getParentForChildren(),
                isClean());
        profile_ = null;
      }
      profileCase_ = 102;
      onChanged();
      return mysqlProfileBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.NoConnectivitySettings,
            com.google.cloud.datastream.v1alpha1.NoConnectivitySettings.Builder,
            com.google.cloud.datastream.v1alpha1.NoConnectivitySettingsOrBuilder>
        noConnectivityBuilder_;
    /**
     *
     *
     * <pre>
     * No connectivity option chosen.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.NoConnectivitySettings no_connectivity = 200;</code>
     *
     * @return Whether the noConnectivity field is set.
     */
    @java.lang.Override
    public boolean hasNoConnectivity() {
      return connectivityCase_ == 200;
    }
    /**
     *
     *
     * <pre>
     * No connectivity option chosen.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.NoConnectivitySettings no_connectivity = 200;</code>
     *
     * @return The noConnectivity.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.NoConnectivitySettings getNoConnectivity() {
      if (noConnectivityBuilder_ == null) {
        if (connectivityCase_ == 200) {
          return (com.google.cloud.datastream.v1alpha1.NoConnectivitySettings) connectivity_;
        }
        return com.google.cloud.datastream.v1alpha1.NoConnectivitySettings.getDefaultInstance();
      } else {
        if (connectivityCase_ == 200) {
          return noConnectivityBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1alpha1.NoConnectivitySettings.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * No connectivity option chosen.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.NoConnectivitySettings no_connectivity = 200;</code>
     */
    public Builder setNoConnectivity(
        com.google.cloud.datastream.v1alpha1.NoConnectivitySettings value) {
      if (noConnectivityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectivity_ = value;
        onChanged();
      } else {
        noConnectivityBuilder_.setMessage(value);
      }
      connectivityCase_ = 200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * No connectivity option chosen.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.NoConnectivitySettings no_connectivity = 200;</code>
     */
    public Builder setNoConnectivity(
        com.google.cloud.datastream.v1alpha1.NoConnectivitySettings.Builder builderForValue) {
      if (noConnectivityBuilder_ == null) {
        connectivity_ = builderForValue.build();
        onChanged();
      } else {
        noConnectivityBuilder_.setMessage(builderForValue.build());
      }
      connectivityCase_ = 200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * No connectivity option chosen.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.NoConnectivitySettings no_connectivity = 200;</code>
     */
    public Builder mergeNoConnectivity(
        com.google.cloud.datastream.v1alpha1.NoConnectivitySettings value) {
      if (noConnectivityBuilder_ == null) {
        if (connectivityCase_ == 200
            && connectivity_
                != com.google.cloud.datastream.v1alpha1.NoConnectivitySettings
                    .getDefaultInstance()) {
          connectivity_ =
              com.google.cloud.datastream.v1alpha1.NoConnectivitySettings.newBuilder(
                      (com.google.cloud.datastream.v1alpha1.NoConnectivitySettings) connectivity_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          connectivity_ = value;
        }
        onChanged();
      } else {
        if (connectivityCase_ == 200) {
          noConnectivityBuilder_.mergeFrom(value);
        } else {
          noConnectivityBuilder_.setMessage(value);
        }
      }
      connectivityCase_ = 200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * No connectivity option chosen.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.NoConnectivitySettings no_connectivity = 200;</code>
     */
    public Builder clearNoConnectivity() {
      if (noConnectivityBuilder_ == null) {
        if (connectivityCase_ == 200) {
          connectivityCase_ = 0;
          connectivity_ = null;
          onChanged();
        }
      } else {
        if (connectivityCase_ == 200) {
          connectivityCase_ = 0;
          connectivity_ = null;
        }
        noConnectivityBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * No connectivity option chosen.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.NoConnectivitySettings no_connectivity = 200;</code>
     */
    public com.google.cloud.datastream.v1alpha1.NoConnectivitySettings.Builder
        getNoConnectivityBuilder() {
      return getNoConnectivityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * No connectivity option chosen.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.NoConnectivitySettings no_connectivity = 200;</code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.NoConnectivitySettingsOrBuilder
        getNoConnectivityOrBuilder() {
      if ((connectivityCase_ == 200) && (noConnectivityBuilder_ != null)) {
        return noConnectivityBuilder_.getMessageOrBuilder();
      } else {
        if (connectivityCase_ == 200) {
          return (com.google.cloud.datastream.v1alpha1.NoConnectivitySettings) connectivity_;
        }
        return com.google.cloud.datastream.v1alpha1.NoConnectivitySettings.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * No connectivity option chosen.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.NoConnectivitySettings no_connectivity = 200;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.NoConnectivitySettings,
            com.google.cloud.datastream.v1alpha1.NoConnectivitySettings.Builder,
            com.google.cloud.datastream.v1alpha1.NoConnectivitySettingsOrBuilder>
        getNoConnectivityFieldBuilder() {
      if (noConnectivityBuilder_ == null) {
        if (!(connectivityCase_ == 200)) {
          connectivity_ =
              com.google.cloud.datastream.v1alpha1.NoConnectivitySettings.getDefaultInstance();
        }
        noConnectivityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1alpha1.NoConnectivitySettings,
                com.google.cloud.datastream.v1alpha1.NoConnectivitySettings.Builder,
                com.google.cloud.datastream.v1alpha1.NoConnectivitySettingsOrBuilder>(
                (com.google.cloud.datastream.v1alpha1.NoConnectivitySettings) connectivity_,
                getParentForChildren(),
                isClean());
        connectivity_ = null;
      }
      connectivityCase_ = 200;
      onChanged();
      return noConnectivityBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity,
            com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity.Builder,
            com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivityOrBuilder>
        staticServiceIpConnectivityBuilder_;
    /**
     *
     *
     * <pre>
     * Static Service IP connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity static_service_ip_connectivity = 201;
     * </code>
     *
     * @return Whether the staticServiceIpConnectivity field is set.
     */
    @java.lang.Override
    public boolean hasStaticServiceIpConnectivity() {
      return connectivityCase_ == 201;
    }
    /**
     *
     *
     * <pre>
     * Static Service IP connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity static_service_ip_connectivity = 201;
     * </code>
     *
     * @return The staticServiceIpConnectivity.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity
        getStaticServiceIpConnectivity() {
      if (staticServiceIpConnectivityBuilder_ == null) {
        if (connectivityCase_ == 201) {
          return (com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity) connectivity_;
        }
        return com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity
            .getDefaultInstance();
      } else {
        if (connectivityCase_ == 201) {
          return staticServiceIpConnectivityBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Static Service IP connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity static_service_ip_connectivity = 201;
     * </code>
     */
    public Builder setStaticServiceIpConnectivity(
        com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity value) {
      if (staticServiceIpConnectivityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectivity_ = value;
        onChanged();
      } else {
        staticServiceIpConnectivityBuilder_.setMessage(value);
      }
      connectivityCase_ = 201;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Static Service IP connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity static_service_ip_connectivity = 201;
     * </code>
     */
    public Builder setStaticServiceIpConnectivity(
        com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity.Builder builderForValue) {
      if (staticServiceIpConnectivityBuilder_ == null) {
        connectivity_ = builderForValue.build();
        onChanged();
      } else {
        staticServiceIpConnectivityBuilder_.setMessage(builderForValue.build());
      }
      connectivityCase_ = 201;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Static Service IP connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity static_service_ip_connectivity = 201;
     * </code>
     */
    public Builder mergeStaticServiceIpConnectivity(
        com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity value) {
      if (staticServiceIpConnectivityBuilder_ == null) {
        if (connectivityCase_ == 201
            && connectivity_
                != com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity
                    .getDefaultInstance()) {
          connectivity_ =
              com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity.newBuilder(
                      (com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity)
                          connectivity_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          connectivity_ = value;
        }
        onChanged();
      } else {
        if (connectivityCase_ == 201) {
          staticServiceIpConnectivityBuilder_.mergeFrom(value);
        } else {
          staticServiceIpConnectivityBuilder_.setMessage(value);
        }
      }
      connectivityCase_ = 201;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Static Service IP connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity static_service_ip_connectivity = 201;
     * </code>
     */
    public Builder clearStaticServiceIpConnectivity() {
      if (staticServiceIpConnectivityBuilder_ == null) {
        if (connectivityCase_ == 201) {
          connectivityCase_ = 0;
          connectivity_ = null;
          onChanged();
        }
      } else {
        if (connectivityCase_ == 201) {
          connectivityCase_ = 0;
          connectivity_ = null;
        }
        staticServiceIpConnectivityBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Static Service IP connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity static_service_ip_connectivity = 201;
     * </code>
     */
    public com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity.Builder
        getStaticServiceIpConnectivityBuilder() {
      return getStaticServiceIpConnectivityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Static Service IP connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity static_service_ip_connectivity = 201;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivityOrBuilder
        getStaticServiceIpConnectivityOrBuilder() {
      if ((connectivityCase_ == 201) && (staticServiceIpConnectivityBuilder_ != null)) {
        return staticServiceIpConnectivityBuilder_.getMessageOrBuilder();
      } else {
        if (connectivityCase_ == 201) {
          return (com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity) connectivity_;
        }
        return com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Static Service IP connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity static_service_ip_connectivity = 201;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity,
            com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity.Builder,
            com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivityOrBuilder>
        getStaticServiceIpConnectivityFieldBuilder() {
      if (staticServiceIpConnectivityBuilder_ == null) {
        if (!(connectivityCase_ == 201)) {
          connectivity_ =
              com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity.getDefaultInstance();
        }
        staticServiceIpConnectivityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity,
                com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity.Builder,
                com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivityOrBuilder>(
                (com.google.cloud.datastream.v1alpha1.StaticServiceIpConnectivity) connectivity_,
                getParentForChildren(),
                isClean());
        connectivity_ = null;
      }
      connectivityCase_ = 201;
      onChanged();
      return staticServiceIpConnectivityBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity,
            com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity.Builder,
            com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivityOrBuilder>
        forwardSshConnectivityBuilder_;
    /**
     *
     *
     * <pre>
     * Forward SSH tunnel connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 202;
     * </code>
     *
     * @return Whether the forwardSshConnectivity field is set.
     */
    @java.lang.Override
    public boolean hasForwardSshConnectivity() {
      return connectivityCase_ == 202;
    }
    /**
     *
     *
     * <pre>
     * Forward SSH tunnel connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 202;
     * </code>
     *
     * @return The forwardSshConnectivity.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity
        getForwardSshConnectivity() {
      if (forwardSshConnectivityBuilder_ == null) {
        if (connectivityCase_ == 202) {
          return (com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity) connectivity_;
        }
        return com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity
            .getDefaultInstance();
      } else {
        if (connectivityCase_ == 202) {
          return forwardSshConnectivityBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Forward SSH tunnel connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 202;
     * </code>
     */
    public Builder setForwardSshConnectivity(
        com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity value) {
      if (forwardSshConnectivityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectivity_ = value;
        onChanged();
      } else {
        forwardSshConnectivityBuilder_.setMessage(value);
      }
      connectivityCase_ = 202;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Forward SSH tunnel connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 202;
     * </code>
     */
    public Builder setForwardSshConnectivity(
        com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity.Builder builderForValue) {
      if (forwardSshConnectivityBuilder_ == null) {
        connectivity_ = builderForValue.build();
        onChanged();
      } else {
        forwardSshConnectivityBuilder_.setMessage(builderForValue.build());
      }
      connectivityCase_ = 202;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Forward SSH tunnel connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 202;
     * </code>
     */
    public Builder mergeForwardSshConnectivity(
        com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity value) {
      if (forwardSshConnectivityBuilder_ == null) {
        if (connectivityCase_ == 202
            && connectivity_
                != com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity
                    .getDefaultInstance()) {
          connectivity_ =
              com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity.newBuilder(
                      (com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity)
                          connectivity_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          connectivity_ = value;
        }
        onChanged();
      } else {
        if (connectivityCase_ == 202) {
          forwardSshConnectivityBuilder_.mergeFrom(value);
        } else {
          forwardSshConnectivityBuilder_.setMessage(value);
        }
      }
      connectivityCase_ = 202;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Forward SSH tunnel connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 202;
     * </code>
     */
    public Builder clearForwardSshConnectivity() {
      if (forwardSshConnectivityBuilder_ == null) {
        if (connectivityCase_ == 202) {
          connectivityCase_ = 0;
          connectivity_ = null;
          onChanged();
        }
      } else {
        if (connectivityCase_ == 202) {
          connectivityCase_ = 0;
          connectivity_ = null;
        }
        forwardSshConnectivityBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Forward SSH tunnel connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 202;
     * </code>
     */
    public com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity.Builder
        getForwardSshConnectivityBuilder() {
      return getForwardSshConnectivityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Forward SSH tunnel connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 202;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivityOrBuilder
        getForwardSshConnectivityOrBuilder() {
      if ((connectivityCase_ == 202) && (forwardSshConnectivityBuilder_ != null)) {
        return forwardSshConnectivityBuilder_.getMessageOrBuilder();
      } else {
        if (connectivityCase_ == 202) {
          return (com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity) connectivity_;
        }
        return com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Forward SSH tunnel connectivity.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity forward_ssh_connectivity = 202;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity,
            com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity.Builder,
            com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivityOrBuilder>
        getForwardSshConnectivityFieldBuilder() {
      if (forwardSshConnectivityBuilder_ == null) {
        if (!(connectivityCase_ == 202)) {
          connectivity_ =
              com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity
                  .getDefaultInstance();
        }
        forwardSshConnectivityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity,
                com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity.Builder,
                com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivityOrBuilder>(
                (com.google.cloud.datastream.v1alpha1.ForwardSshTunnelConnectivity) connectivity_,
                getParentForChildren(),
                isClean());
        connectivity_ = null;
      }
      connectivityCase_ = 202;
      onChanged();
      return forwardSshConnectivityBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.PrivateConnectivity,
            com.google.cloud.datastream.v1alpha1.PrivateConnectivity.Builder,
            com.google.cloud.datastream.v1alpha1.PrivateConnectivityOrBuilder>
        privateConnectivityBuilder_;
    /**
     *
     *
     * <pre>
     * Private connectivity.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.PrivateConnectivity private_connectivity = 203;
     * </code>
     *
     * @return Whether the privateConnectivity field is set.
     */
    @java.lang.Override
    public boolean hasPrivateConnectivity() {
      return connectivityCase_ == 203;
    }
    /**
     *
     *
     * <pre>
     * Private connectivity.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.PrivateConnectivity private_connectivity = 203;
     * </code>
     *
     * @return The privateConnectivity.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.PrivateConnectivity getPrivateConnectivity() {
      if (privateConnectivityBuilder_ == null) {
        if (connectivityCase_ == 203) {
          return (com.google.cloud.datastream.v1alpha1.PrivateConnectivity) connectivity_;
        }
        return com.google.cloud.datastream.v1alpha1.PrivateConnectivity.getDefaultInstance();
      } else {
        if (connectivityCase_ == 203) {
          return privateConnectivityBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1alpha1.PrivateConnectivity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Private connectivity.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.PrivateConnectivity private_connectivity = 203;
     * </code>
     */
    public Builder setPrivateConnectivity(
        com.google.cloud.datastream.v1alpha1.PrivateConnectivity value) {
      if (privateConnectivityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        connectivity_ = value;
        onChanged();
      } else {
        privateConnectivityBuilder_.setMessage(value);
      }
      connectivityCase_ = 203;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Private connectivity.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.PrivateConnectivity private_connectivity = 203;
     * </code>
     */
    public Builder setPrivateConnectivity(
        com.google.cloud.datastream.v1alpha1.PrivateConnectivity.Builder builderForValue) {
      if (privateConnectivityBuilder_ == null) {
        connectivity_ = builderForValue.build();
        onChanged();
      } else {
        privateConnectivityBuilder_.setMessage(builderForValue.build());
      }
      connectivityCase_ = 203;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Private connectivity.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.PrivateConnectivity private_connectivity = 203;
     * </code>
     */
    public Builder mergePrivateConnectivity(
        com.google.cloud.datastream.v1alpha1.PrivateConnectivity value) {
      if (privateConnectivityBuilder_ == null) {
        if (connectivityCase_ == 203
            && connectivity_
                != com.google.cloud.datastream.v1alpha1.PrivateConnectivity.getDefaultInstance()) {
          connectivity_ =
              com.google.cloud.datastream.v1alpha1.PrivateConnectivity.newBuilder(
                      (com.google.cloud.datastream.v1alpha1.PrivateConnectivity) connectivity_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          connectivity_ = value;
        }
        onChanged();
      } else {
        if (connectivityCase_ == 203) {
          privateConnectivityBuilder_.mergeFrom(value);
        } else {
          privateConnectivityBuilder_.setMessage(value);
        }
      }
      connectivityCase_ = 203;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Private connectivity.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.PrivateConnectivity private_connectivity = 203;
     * </code>
     */
    public Builder clearPrivateConnectivity() {
      if (privateConnectivityBuilder_ == null) {
        if (connectivityCase_ == 203) {
          connectivityCase_ = 0;
          connectivity_ = null;
          onChanged();
        }
      } else {
        if (connectivityCase_ == 203) {
          connectivityCase_ = 0;
          connectivity_ = null;
        }
        privateConnectivityBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Private connectivity.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.PrivateConnectivity private_connectivity = 203;
     * </code>
     */
    public com.google.cloud.datastream.v1alpha1.PrivateConnectivity.Builder
        getPrivateConnectivityBuilder() {
      return getPrivateConnectivityFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Private connectivity.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.PrivateConnectivity private_connectivity = 203;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.PrivateConnectivityOrBuilder
        getPrivateConnectivityOrBuilder() {
      if ((connectivityCase_ == 203) && (privateConnectivityBuilder_ != null)) {
        return privateConnectivityBuilder_.getMessageOrBuilder();
      } else {
        if (connectivityCase_ == 203) {
          return (com.google.cloud.datastream.v1alpha1.PrivateConnectivity) connectivity_;
        }
        return com.google.cloud.datastream.v1alpha1.PrivateConnectivity.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Private connectivity.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.PrivateConnectivity private_connectivity = 203;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.PrivateConnectivity,
            com.google.cloud.datastream.v1alpha1.PrivateConnectivity.Builder,
            com.google.cloud.datastream.v1alpha1.PrivateConnectivityOrBuilder>
        getPrivateConnectivityFieldBuilder() {
      if (privateConnectivityBuilder_ == null) {
        if (!(connectivityCase_ == 203)) {
          connectivity_ =
              com.google.cloud.datastream.v1alpha1.PrivateConnectivity.getDefaultInstance();
        }
        privateConnectivityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1alpha1.PrivateConnectivity,
                com.google.cloud.datastream.v1alpha1.PrivateConnectivity.Builder,
                com.google.cloud.datastream.v1alpha1.PrivateConnectivityOrBuilder>(
                (com.google.cloud.datastream.v1alpha1.PrivateConnectivity) connectivity_,
                getParentForChildren(),
                isClean());
        connectivity_ = null;
      }
      connectivityCase_ = 203;
      onChanged();
      return privateConnectivityBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1alpha1.ConnectionProfile)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1alpha1.ConnectionProfile)
  private static final com.google.cloud.datastream.v1alpha1.ConnectionProfile DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datastream.v1alpha1.ConnectionProfile();
  }

  public static com.google.cloud.datastream.v1alpha1.ConnectionProfile getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConnectionProfile> PARSER =
      new com.google.protobuf.AbstractParser<ConnectionProfile>() {
        @java.lang.Override
        public ConnectionProfile parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ConnectionProfile> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConnectionProfile> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.ConnectionProfile getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
