/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datastream/v1alpha1/datastream.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.datastream.v1alpha1;

/**
 *
 *
 * <pre>
 * Request message for 'discover' ConnectionProfile request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest}
 */
public final class DiscoverConnectionProfileRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest)
    DiscoverConnectionProfileRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DiscoverConnectionProfileRequest.newBuilder() to construct.
  private DiscoverConnectionProfileRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DiscoverConnectionProfileRequest() {
    parent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DiscoverConnectionProfileRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datastream.v1alpha1.CloudDatastreamServiceProto
        .internal_static_google_cloud_datastream_v1alpha1_DiscoverConnectionProfileRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datastream.v1alpha1.CloudDatastreamServiceProto
        .internal_static_google_cloud_datastream_v1alpha1_DiscoverConnectionProfileRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest.class,
            com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest.Builder.class);
  }

  private int targetCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object target_;

  public enum TargetCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CONNECTION_PROFILE(200),
    CONNECTION_PROFILE_NAME(201),
    TARGET_NOT_SET(0);
    private final int value;

    private TargetCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TargetCase valueOf(int value) {
      return forNumber(value);
    }

    public static TargetCase forNumber(int value) {
      switch (value) {
        case 200:
          return CONNECTION_PROFILE;
        case 201:
          return CONNECTION_PROFILE_NAME;
        case 0:
          return TARGET_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TargetCase getTargetCase() {
    return TargetCase.forNumber(targetCase_);
  }

  private int depthCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object depth_;

  public enum DepthCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    RECURSIVE(3),
    RECURSION_DEPTH(4),
    DEPTH_NOT_SET(0);
    private final int value;

    private DepthCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DepthCase valueOf(int value) {
      return forNumber(value);
    }

    public static DepthCase forNumber(int value) {
      switch (value) {
        case 3:
          return RECURSIVE;
        case 4:
          return RECURSION_DEPTH;
        case 0:
          return DEPTH_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DepthCase getDepthCase() {
    return DepthCase.forNumber(depthCase_);
  }

  private int dataObjectCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object dataObject_;

  public enum DataObjectCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ORACLE_RDBMS(100),
    MYSQL_RDBMS(101),
    DATAOBJECT_NOT_SET(0);
    private final int value;

    private DataObjectCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataObjectCase valueOf(int value) {
      return forNumber(value);
    }

    public static DataObjectCase forNumber(int value) {
      switch (value) {
        case 100:
          return ORACLE_RDBMS;
        case 101:
          return MYSQL_RDBMS;
        case 0:
          return DATAOBJECT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DataObjectCase getDataObjectCase() {
    return DataObjectCase.forNumber(dataObjectCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The parent resource of the ConnectionProfile type. Must be in the
   * format `projects/&#42;&#47;locations/&#42;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent resource of the ConnectionProfile type. Must be in the
   * format `projects/&#42;&#47;locations/&#42;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONNECTION_PROFILE_FIELD_NUMBER = 200;
  /**
   *
   *
   * <pre>
   * An ad-hoc ConnectionProfile configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.ConnectionProfile connection_profile = 200;</code>
   *
   * @return Whether the connectionProfile field is set.
   */
  @java.lang.Override
  public boolean hasConnectionProfile() {
    return targetCase_ == 200;
  }
  /**
   *
   *
   * <pre>
   * An ad-hoc ConnectionProfile configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.ConnectionProfile connection_profile = 200;</code>
   *
   * @return The connectionProfile.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.ConnectionProfile getConnectionProfile() {
    if (targetCase_ == 200) {
      return (com.google.cloud.datastream.v1alpha1.ConnectionProfile) target_;
    }
    return com.google.cloud.datastream.v1alpha1.ConnectionProfile.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An ad-hoc ConnectionProfile configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.ConnectionProfile connection_profile = 200;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.ConnectionProfileOrBuilder
      getConnectionProfileOrBuilder() {
    if (targetCase_ == 200) {
      return (com.google.cloud.datastream.v1alpha1.ConnectionProfile) target_;
    }
    return com.google.cloud.datastream.v1alpha1.ConnectionProfile.getDefaultInstance();
  }

  public static final int CONNECTION_PROFILE_NAME_FIELD_NUMBER = 201;
  /**
   *
   *
   * <pre>
   * A reference to an existing ConnectionProfile.
   * </pre>
   *
   * <code>string connection_profile_name = 201;</code>
   *
   * @return Whether the connectionProfileName field is set.
   */
  public boolean hasConnectionProfileName() {
    return targetCase_ == 201;
  }
  /**
   *
   *
   * <pre>
   * A reference to an existing ConnectionProfile.
   * </pre>
   *
   * <code>string connection_profile_name = 201;</code>
   *
   * @return The connectionProfileName.
   */
  public java.lang.String getConnectionProfileName() {
    java.lang.Object ref = "";
    if (targetCase_ == 201) {
      ref = target_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (targetCase_ == 201) {
        target_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A reference to an existing ConnectionProfile.
   * </pre>
   *
   * <code>string connection_profile_name = 201;</code>
   *
   * @return The bytes for connectionProfileName.
   */
  public com.google.protobuf.ByteString getConnectionProfileNameBytes() {
    java.lang.Object ref = "";
    if (targetCase_ == 201) {
      ref = target_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (targetCase_ == 201) {
        target_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RECURSIVE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Whether to retrieve the full hierarchy of data objects (TRUE) or only the
   * current level (FALSE).
   * </pre>
   *
   * <code>bool recursive = 3;</code>
   *
   * @return Whether the recursive field is set.
   */
  @java.lang.Override
  public boolean hasRecursive() {
    return depthCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Whether to retrieve the full hierarchy of data objects (TRUE) or only the
   * current level (FALSE).
   * </pre>
   *
   * <code>bool recursive = 3;</code>
   *
   * @return The recursive.
   */
  @java.lang.Override
  public boolean getRecursive() {
    if (depthCase_ == 3) {
      return (java.lang.Boolean) depth_;
    }
    return false;
  }

  public static final int RECURSION_DEPTH_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * The number of hierarchy levels below the current level to be retrieved.
   * </pre>
   *
   * <code>int32 recursion_depth = 4;</code>
   *
   * @return Whether the recursionDepth field is set.
   */
  @java.lang.Override
  public boolean hasRecursionDepth() {
    return depthCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * The number of hierarchy levels below the current level to be retrieved.
   * </pre>
   *
   * <code>int32 recursion_depth = 4;</code>
   *
   * @return The recursionDepth.
   */
  @java.lang.Override
  public int getRecursionDepth() {
    if (depthCase_ == 4) {
      return (java.lang.Integer) depth_;
    }
    return 0;
  }

  public static final int ORACLE_RDBMS_FIELD_NUMBER = 100;
  /**
   *
   *
   * <pre>
   * Oracle RDBMS to enrich with child data objects and metadata.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_rdbms = 100;</code>
   *
   * @return Whether the oracleRdbms field is set.
   */
  @java.lang.Override
  public boolean hasOracleRdbms() {
    return dataObjectCase_ == 100;
  }
  /**
   *
   *
   * <pre>
   * Oracle RDBMS to enrich with child data objects and metadata.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_rdbms = 100;</code>
   *
   * @return The oracleRdbms.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.OracleRdbms getOracleRdbms() {
    if (dataObjectCase_ == 100) {
      return (com.google.cloud.datastream.v1alpha1.OracleRdbms) dataObject_;
    }
    return com.google.cloud.datastream.v1alpha1.OracleRdbms.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Oracle RDBMS to enrich with child data objects and metadata.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_rdbms = 100;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.OracleRdbmsOrBuilder getOracleRdbmsOrBuilder() {
    if (dataObjectCase_ == 100) {
      return (com.google.cloud.datastream.v1alpha1.OracleRdbms) dataObject_;
    }
    return com.google.cloud.datastream.v1alpha1.OracleRdbms.getDefaultInstance();
  }

  public static final int MYSQL_RDBMS_FIELD_NUMBER = 101;
  /**
   *
   *
   * <pre>
   * MySQL RDBMS to enrich with child data objects and metadata.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_rdbms = 101;</code>
   *
   * @return Whether the mysqlRdbms field is set.
   */
  @java.lang.Override
  public boolean hasMysqlRdbms() {
    return dataObjectCase_ == 101;
  }
  /**
   *
   *
   * <pre>
   * MySQL RDBMS to enrich with child data objects and metadata.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_rdbms = 101;</code>
   *
   * @return The mysqlRdbms.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.MysqlRdbms getMysqlRdbms() {
    if (dataObjectCase_ == 101) {
      return (com.google.cloud.datastream.v1alpha1.MysqlRdbms) dataObject_;
    }
    return com.google.cloud.datastream.v1alpha1.MysqlRdbms.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * MySQL RDBMS to enrich with child data objects and metadata.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_rdbms = 101;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.MysqlRdbmsOrBuilder getMysqlRdbmsOrBuilder() {
    if (dataObjectCase_ == 101) {
      return (com.google.cloud.datastream.v1alpha1.MysqlRdbms) dataObject_;
    }
    return com.google.cloud.datastream.v1alpha1.MysqlRdbms.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (depthCase_ == 3) {
      output.writeBool(3, (boolean) ((java.lang.Boolean) depth_));
    }
    if (depthCase_ == 4) {
      output.writeInt32(4, (int) ((java.lang.Integer) depth_));
    }
    if (dataObjectCase_ == 100) {
      output.writeMessage(100, (com.google.cloud.datastream.v1alpha1.OracleRdbms) dataObject_);
    }
    if (dataObjectCase_ == 101) {
      output.writeMessage(101, (com.google.cloud.datastream.v1alpha1.MysqlRdbms) dataObject_);
    }
    if (targetCase_ == 200) {
      output.writeMessage(200, (com.google.cloud.datastream.v1alpha1.ConnectionProfile) target_);
    }
    if (targetCase_ == 201) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 201, target_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (depthCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              3, (boolean) ((java.lang.Boolean) depth_));
    }
    if (depthCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              4, (int) ((java.lang.Integer) depth_));
    }
    if (dataObjectCase_ == 100) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              100, (com.google.cloud.datastream.v1alpha1.OracleRdbms) dataObject_);
    }
    if (dataObjectCase_ == 101) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              101, (com.google.cloud.datastream.v1alpha1.MysqlRdbms) dataObject_);
    }
    if (targetCase_ == 200) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              200, (com.google.cloud.datastream.v1alpha1.ConnectionProfile) target_);
    }
    if (targetCase_ == 201) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(201, target_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest other =
        (com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getTargetCase().equals(other.getTargetCase())) return false;
    switch (targetCase_) {
      case 200:
        if (!getConnectionProfile().equals(other.getConnectionProfile())) return false;
        break;
      case 201:
        if (!getConnectionProfileName().equals(other.getConnectionProfileName())) return false;
        break;
      case 0:
      default:
    }
    if (!getDepthCase().equals(other.getDepthCase())) return false;
    switch (depthCase_) {
      case 3:
        if (getRecursive() != other.getRecursive()) return false;
        break;
      case 4:
        if (getRecursionDepth() != other.getRecursionDepth()) return false;
        break;
      case 0:
      default:
    }
    if (!getDataObjectCase().equals(other.getDataObjectCase())) return false;
    switch (dataObjectCase_) {
      case 100:
        if (!getOracleRdbms().equals(other.getOracleRdbms())) return false;
        break;
      case 101:
        if (!getMysqlRdbms().equals(other.getMysqlRdbms())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    switch (targetCase_) {
      case 200:
        hash = (37 * hash) + CONNECTION_PROFILE_FIELD_NUMBER;
        hash = (53 * hash) + getConnectionProfile().hashCode();
        break;
      case 201:
        hash = (37 * hash) + CONNECTION_PROFILE_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getConnectionProfileName().hashCode();
        break;
      case 0:
      default:
    }
    switch (depthCase_) {
      case 3:
        hash = (37 * hash) + RECURSIVE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRecursive());
        break;
      case 4:
        hash = (37 * hash) + RECURSION_DEPTH_FIELD_NUMBER;
        hash = (53 * hash) + getRecursionDepth();
        break;
      case 0:
      default:
    }
    switch (dataObjectCase_) {
      case 100:
        hash = (37 * hash) + ORACLE_RDBMS_FIELD_NUMBER;
        hash = (53 * hash) + getOracleRdbms().hashCode();
        break;
      case 101:
        hash = (37 * hash) + MYSQL_RDBMS_FIELD_NUMBER;
        hash = (53 * hash) + getMysqlRdbms().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for 'discover' ConnectionProfile request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest)
      com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1alpha1.CloudDatastreamServiceProto
          .internal_static_google_cloud_datastream_v1alpha1_DiscoverConnectionProfileRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1alpha1.CloudDatastreamServiceProto
          .internal_static_google_cloud_datastream_v1alpha1_DiscoverConnectionProfileRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest.class,
              com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      if (connectionProfileBuilder_ != null) {
        connectionProfileBuilder_.clear();
      }
      if (oracleRdbmsBuilder_ != null) {
        oracleRdbmsBuilder_.clear();
      }
      if (mysqlRdbmsBuilder_ != null) {
        mysqlRdbmsBuilder_.clear();
      }
      targetCase_ = 0;
      target_ = null;
      depthCase_ = 0;
      depth_ = null;
      dataObjectCase_ = 0;
      dataObject_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datastream.v1alpha1.CloudDatastreamServiceProto
          .internal_static_google_cloud_datastream_v1alpha1_DiscoverConnectionProfileRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest
        getDefaultInstanceForType() {
      return com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest build() {
      com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest buildPartial() {
      com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest result =
          new com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest result) {
      result.targetCase_ = targetCase_;
      result.target_ = this.target_;
      if (targetCase_ == 200 && connectionProfileBuilder_ != null) {
        result.target_ = connectionProfileBuilder_.build();
      }
      result.depthCase_ = depthCase_;
      result.depth_ = this.depth_;
      result.dataObjectCase_ = dataObjectCase_;
      result.dataObject_ = this.dataObject_;
      if (dataObjectCase_ == 100 && oracleRdbmsBuilder_ != null) {
        result.dataObject_ = oracleRdbmsBuilder_.build();
      }
      if (dataObjectCase_ == 101 && mysqlRdbmsBuilder_ != null) {
        result.dataObject_ = mysqlRdbmsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest) {
        return mergeFrom(
            (com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest other) {
      if (other
          == com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest
              .getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      switch (other.getTargetCase()) {
        case CONNECTION_PROFILE:
          {
            mergeConnectionProfile(other.getConnectionProfile());
            break;
          }
        case CONNECTION_PROFILE_NAME:
          {
            targetCase_ = 201;
            target_ = other.target_;
            onChanged();
            break;
          }
        case TARGET_NOT_SET:
          {
            break;
          }
      }
      switch (other.getDepthCase()) {
        case RECURSIVE:
          {
            setRecursive(other.getRecursive());
            break;
          }
        case RECURSION_DEPTH:
          {
            setRecursionDepth(other.getRecursionDepth());
            break;
          }
        case DEPTH_NOT_SET:
          {
            break;
          }
      }
      switch (other.getDataObjectCase()) {
        case ORACLE_RDBMS:
          {
            mergeOracleRdbms(other.getOracleRdbms());
            break;
          }
        case MYSQL_RDBMS:
          {
            mergeMysqlRdbms(other.getMysqlRdbms());
            break;
          }
        case DATAOBJECT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 24:
              {
                depth_ = input.readBool();
                depthCase_ = 3;
                break;
              } // case 24
            case 32:
              {
                depth_ = input.readInt32();
                depthCase_ = 4;
                break;
              } // case 32
            case 802:
              {
                input.readMessage(getOracleRdbmsFieldBuilder().getBuilder(), extensionRegistry);
                dataObjectCase_ = 100;
                break;
              } // case 802
            case 810:
              {
                input.readMessage(getMysqlRdbmsFieldBuilder().getBuilder(), extensionRegistry);
                dataObjectCase_ = 101;
                break;
              } // case 810
            case 1602:
              {
                input.readMessage(
                    getConnectionProfileFieldBuilder().getBuilder(), extensionRegistry);
                targetCase_ = 200;
                break;
              } // case 1602
            case 1610:
              {
                java.lang.String s = input.readStringRequireUtf8();
                targetCase_ = 201;
                target_ = s;
                break;
              } // case 1610
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int targetCase_ = 0;
    private java.lang.Object target_;

    public TargetCase getTargetCase() {
      return TargetCase.forNumber(targetCase_);
    }

    public Builder clearTarget() {
      targetCase_ = 0;
      target_ = null;
      onChanged();
      return this;
    }

    private int depthCase_ = 0;
    private java.lang.Object depth_;

    public DepthCase getDepthCase() {
      return DepthCase.forNumber(depthCase_);
    }

    public Builder clearDepth() {
      depthCase_ = 0;
      depth_ = null;
      onChanged();
      return this;
    }

    private int dataObjectCase_ = 0;
    private java.lang.Object dataObject_;

    public DataObjectCase getDataObjectCase() {
      return DataObjectCase.forNumber(dataObjectCase_);
    }

    public Builder clearDataObject() {
      dataObjectCase_ = 0;
      dataObject_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent resource of the ConnectionProfile type. Must be in the
     * format `projects/&#42;&#47;locations/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource of the ConnectionProfile type. Must be in the
     * format `projects/&#42;&#47;locations/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource of the ConnectionProfile type. Must be in the
     * format `projects/&#42;&#47;locations/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource of the ConnectionProfile type. Must be in the
     * format `projects/&#42;&#47;locations/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent resource of the ConnectionProfile type. Must be in the
     * format `projects/&#42;&#47;locations/&#42;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.ConnectionProfile,
            com.google.cloud.datastream.v1alpha1.ConnectionProfile.Builder,
            com.google.cloud.datastream.v1alpha1.ConnectionProfileOrBuilder>
        connectionProfileBuilder_;
    /**
     *
     *
     * <pre>
     * An ad-hoc ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.ConnectionProfile connection_profile = 200;</code>
     *
     * @return Whether the connectionProfile field is set.
     */
    @java.lang.Override
    public boolean hasConnectionProfile() {
      return targetCase_ == 200;
    }
    /**
     *
     *
     * <pre>
     * An ad-hoc ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.ConnectionProfile connection_profile = 200;</code>
     *
     * @return The connectionProfile.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.ConnectionProfile getConnectionProfile() {
      if (connectionProfileBuilder_ == null) {
        if (targetCase_ == 200) {
          return (com.google.cloud.datastream.v1alpha1.ConnectionProfile) target_;
        }
        return com.google.cloud.datastream.v1alpha1.ConnectionProfile.getDefaultInstance();
      } else {
        if (targetCase_ == 200) {
          return connectionProfileBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1alpha1.ConnectionProfile.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An ad-hoc ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.ConnectionProfile connection_profile = 200;</code>
     */
    public Builder setConnectionProfile(
        com.google.cloud.datastream.v1alpha1.ConnectionProfile value) {
      if (connectionProfileBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        target_ = value;
        onChanged();
      } else {
        connectionProfileBuilder_.setMessage(value);
      }
      targetCase_ = 200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An ad-hoc ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.ConnectionProfile connection_profile = 200;</code>
     */
    public Builder setConnectionProfile(
        com.google.cloud.datastream.v1alpha1.ConnectionProfile.Builder builderForValue) {
      if (connectionProfileBuilder_ == null) {
        target_ = builderForValue.build();
        onChanged();
      } else {
        connectionProfileBuilder_.setMessage(builderForValue.build());
      }
      targetCase_ = 200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An ad-hoc ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.ConnectionProfile connection_profile = 200;</code>
     */
    public Builder mergeConnectionProfile(
        com.google.cloud.datastream.v1alpha1.ConnectionProfile value) {
      if (connectionProfileBuilder_ == null) {
        if (targetCase_ == 200
            && target_
                != com.google.cloud.datastream.v1alpha1.ConnectionProfile.getDefaultInstance()) {
          target_ =
              com.google.cloud.datastream.v1alpha1.ConnectionProfile.newBuilder(
                      (com.google.cloud.datastream.v1alpha1.ConnectionProfile) target_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          target_ = value;
        }
        onChanged();
      } else {
        if (targetCase_ == 200) {
          connectionProfileBuilder_.mergeFrom(value);
        } else {
          connectionProfileBuilder_.setMessage(value);
        }
      }
      targetCase_ = 200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An ad-hoc ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.ConnectionProfile connection_profile = 200;</code>
     */
    public Builder clearConnectionProfile() {
      if (connectionProfileBuilder_ == null) {
        if (targetCase_ == 200) {
          targetCase_ = 0;
          target_ = null;
          onChanged();
        }
      } else {
        if (targetCase_ == 200) {
          targetCase_ = 0;
          target_ = null;
        }
        connectionProfileBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An ad-hoc ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.ConnectionProfile connection_profile = 200;</code>
     */
    public com.google.cloud.datastream.v1alpha1.ConnectionProfile.Builder
        getConnectionProfileBuilder() {
      return getConnectionProfileFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An ad-hoc ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.ConnectionProfile connection_profile = 200;</code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.ConnectionProfileOrBuilder
        getConnectionProfileOrBuilder() {
      if ((targetCase_ == 200) && (connectionProfileBuilder_ != null)) {
        return connectionProfileBuilder_.getMessageOrBuilder();
      } else {
        if (targetCase_ == 200) {
          return (com.google.cloud.datastream.v1alpha1.ConnectionProfile) target_;
        }
        return com.google.cloud.datastream.v1alpha1.ConnectionProfile.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An ad-hoc ConnectionProfile configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.ConnectionProfile connection_profile = 200;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.ConnectionProfile,
            com.google.cloud.datastream.v1alpha1.ConnectionProfile.Builder,
            com.google.cloud.datastream.v1alpha1.ConnectionProfileOrBuilder>
        getConnectionProfileFieldBuilder() {
      if (connectionProfileBuilder_ == null) {
        if (!(targetCase_ == 200)) {
          target_ = com.google.cloud.datastream.v1alpha1.ConnectionProfile.getDefaultInstance();
        }
        connectionProfileBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1alpha1.ConnectionProfile,
                com.google.cloud.datastream.v1alpha1.ConnectionProfile.Builder,
                com.google.cloud.datastream.v1alpha1.ConnectionProfileOrBuilder>(
                (com.google.cloud.datastream.v1alpha1.ConnectionProfile) target_,
                getParentForChildren(),
                isClean());
        target_ = null;
      }
      targetCase_ = 200;
      onChanged();
      return connectionProfileBuilder_;
    }

    /**
     *
     *
     * <pre>
     * A reference to an existing ConnectionProfile.
     * </pre>
     *
     * <code>string connection_profile_name = 201;</code>
     *
     * @return Whether the connectionProfileName field is set.
     */
    @java.lang.Override
    public boolean hasConnectionProfileName() {
      return targetCase_ == 201;
    }
    /**
     *
     *
     * <pre>
     * A reference to an existing ConnectionProfile.
     * </pre>
     *
     * <code>string connection_profile_name = 201;</code>
     *
     * @return The connectionProfileName.
     */
    @java.lang.Override
    public java.lang.String getConnectionProfileName() {
      java.lang.Object ref = "";
      if (targetCase_ == 201) {
        ref = target_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (targetCase_ == 201) {
          target_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A reference to an existing ConnectionProfile.
     * </pre>
     *
     * <code>string connection_profile_name = 201;</code>
     *
     * @return The bytes for connectionProfileName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getConnectionProfileNameBytes() {
      java.lang.Object ref = "";
      if (targetCase_ == 201) {
        ref = target_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (targetCase_ == 201) {
          target_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A reference to an existing ConnectionProfile.
     * </pre>
     *
     * <code>string connection_profile_name = 201;</code>
     *
     * @param value The connectionProfileName to set.
     * @return This builder for chaining.
     */
    public Builder setConnectionProfileName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetCase_ = 201;
      target_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A reference to an existing ConnectionProfile.
     * </pre>
     *
     * <code>string connection_profile_name = 201;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearConnectionProfileName() {
      if (targetCase_ == 201) {
        targetCase_ = 0;
        target_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A reference to an existing ConnectionProfile.
     * </pre>
     *
     * <code>string connection_profile_name = 201;</code>
     *
     * @param value The bytes for connectionProfileName to set.
     * @return This builder for chaining.
     */
    public Builder setConnectionProfileNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetCase_ = 201;
      target_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether to retrieve the full hierarchy of data objects (TRUE) or only the
     * current level (FALSE).
     * </pre>
     *
     * <code>bool recursive = 3;</code>
     *
     * @return Whether the recursive field is set.
     */
    public boolean hasRecursive() {
      return depthCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Whether to retrieve the full hierarchy of data objects (TRUE) or only the
     * current level (FALSE).
     * </pre>
     *
     * <code>bool recursive = 3;</code>
     *
     * @return The recursive.
     */
    public boolean getRecursive() {
      if (depthCase_ == 3) {
        return (java.lang.Boolean) depth_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * Whether to retrieve the full hierarchy of data objects (TRUE) or only the
     * current level (FALSE).
     * </pre>
     *
     * <code>bool recursive = 3;</code>
     *
     * @param value The recursive to set.
     * @return This builder for chaining.
     */
    public Builder setRecursive(boolean value) {

      depthCase_ = 3;
      depth_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether to retrieve the full hierarchy of data objects (TRUE) or only the
     * current level (FALSE).
     * </pre>
     *
     * <code>bool recursive = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRecursive() {
      if (depthCase_ == 3) {
        depthCase_ = 0;
        depth_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The number of hierarchy levels below the current level to be retrieved.
     * </pre>
     *
     * <code>int32 recursion_depth = 4;</code>
     *
     * @return Whether the recursionDepth field is set.
     */
    public boolean hasRecursionDepth() {
      return depthCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * The number of hierarchy levels below the current level to be retrieved.
     * </pre>
     *
     * <code>int32 recursion_depth = 4;</code>
     *
     * @return The recursionDepth.
     */
    public int getRecursionDepth() {
      if (depthCase_ == 4) {
        return (java.lang.Integer) depth_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * The number of hierarchy levels below the current level to be retrieved.
     * </pre>
     *
     * <code>int32 recursion_depth = 4;</code>
     *
     * @param value The recursionDepth to set.
     * @return This builder for chaining.
     */
    public Builder setRecursionDepth(int value) {

      depthCase_ = 4;
      depth_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of hierarchy levels below the current level to be retrieved.
     * </pre>
     *
     * <code>int32 recursion_depth = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRecursionDepth() {
      if (depthCase_ == 4) {
        depthCase_ = 0;
        depth_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.OracleRdbms,
            com.google.cloud.datastream.v1alpha1.OracleRdbms.Builder,
            com.google.cloud.datastream.v1alpha1.OracleRdbmsOrBuilder>
        oracleRdbmsBuilder_;
    /**
     *
     *
     * <pre>
     * Oracle RDBMS to enrich with child data objects and metadata.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_rdbms = 100;</code>
     *
     * @return Whether the oracleRdbms field is set.
     */
    @java.lang.Override
    public boolean hasOracleRdbms() {
      return dataObjectCase_ == 100;
    }
    /**
     *
     *
     * <pre>
     * Oracle RDBMS to enrich with child data objects and metadata.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_rdbms = 100;</code>
     *
     * @return The oracleRdbms.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.OracleRdbms getOracleRdbms() {
      if (oracleRdbmsBuilder_ == null) {
        if (dataObjectCase_ == 100) {
          return (com.google.cloud.datastream.v1alpha1.OracleRdbms) dataObject_;
        }
        return com.google.cloud.datastream.v1alpha1.OracleRdbms.getDefaultInstance();
      } else {
        if (dataObjectCase_ == 100) {
          return oracleRdbmsBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1alpha1.OracleRdbms.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Oracle RDBMS to enrich with child data objects and metadata.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_rdbms = 100;</code>
     */
    public Builder setOracleRdbms(com.google.cloud.datastream.v1alpha1.OracleRdbms value) {
      if (oracleRdbmsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataObject_ = value;
        onChanged();
      } else {
        oracleRdbmsBuilder_.setMessage(value);
      }
      dataObjectCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Oracle RDBMS to enrich with child data objects and metadata.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_rdbms = 100;</code>
     */
    public Builder setOracleRdbms(
        com.google.cloud.datastream.v1alpha1.OracleRdbms.Builder builderForValue) {
      if (oracleRdbmsBuilder_ == null) {
        dataObject_ = builderForValue.build();
        onChanged();
      } else {
        oracleRdbmsBuilder_.setMessage(builderForValue.build());
      }
      dataObjectCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Oracle RDBMS to enrich with child data objects and metadata.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_rdbms = 100;</code>
     */
    public Builder mergeOracleRdbms(com.google.cloud.datastream.v1alpha1.OracleRdbms value) {
      if (oracleRdbmsBuilder_ == null) {
        if (dataObjectCase_ == 100
            && dataObject_
                != com.google.cloud.datastream.v1alpha1.OracleRdbms.getDefaultInstance()) {
          dataObject_ =
              com.google.cloud.datastream.v1alpha1.OracleRdbms.newBuilder(
                      (com.google.cloud.datastream.v1alpha1.OracleRdbms) dataObject_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dataObject_ = value;
        }
        onChanged();
      } else {
        if (dataObjectCase_ == 100) {
          oracleRdbmsBuilder_.mergeFrom(value);
        } else {
          oracleRdbmsBuilder_.setMessage(value);
        }
      }
      dataObjectCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Oracle RDBMS to enrich with child data objects and metadata.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_rdbms = 100;</code>
     */
    public Builder clearOracleRdbms() {
      if (oracleRdbmsBuilder_ == null) {
        if (dataObjectCase_ == 100) {
          dataObjectCase_ = 0;
          dataObject_ = null;
          onChanged();
        }
      } else {
        if (dataObjectCase_ == 100) {
          dataObjectCase_ = 0;
          dataObject_ = null;
        }
        oracleRdbmsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Oracle RDBMS to enrich with child data objects and metadata.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_rdbms = 100;</code>
     */
    public com.google.cloud.datastream.v1alpha1.OracleRdbms.Builder getOracleRdbmsBuilder() {
      return getOracleRdbmsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Oracle RDBMS to enrich with child data objects and metadata.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_rdbms = 100;</code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.OracleRdbmsOrBuilder getOracleRdbmsOrBuilder() {
      if ((dataObjectCase_ == 100) && (oracleRdbmsBuilder_ != null)) {
        return oracleRdbmsBuilder_.getMessageOrBuilder();
      } else {
        if (dataObjectCase_ == 100) {
          return (com.google.cloud.datastream.v1alpha1.OracleRdbms) dataObject_;
        }
        return com.google.cloud.datastream.v1alpha1.OracleRdbms.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Oracle RDBMS to enrich with child data objects and metadata.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_rdbms = 100;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.OracleRdbms,
            com.google.cloud.datastream.v1alpha1.OracleRdbms.Builder,
            com.google.cloud.datastream.v1alpha1.OracleRdbmsOrBuilder>
        getOracleRdbmsFieldBuilder() {
      if (oracleRdbmsBuilder_ == null) {
        if (!(dataObjectCase_ == 100)) {
          dataObject_ = com.google.cloud.datastream.v1alpha1.OracleRdbms.getDefaultInstance();
        }
        oracleRdbmsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1alpha1.OracleRdbms,
                com.google.cloud.datastream.v1alpha1.OracleRdbms.Builder,
                com.google.cloud.datastream.v1alpha1.OracleRdbmsOrBuilder>(
                (com.google.cloud.datastream.v1alpha1.OracleRdbms) dataObject_,
                getParentForChildren(),
                isClean());
        dataObject_ = null;
      }
      dataObjectCase_ = 100;
      onChanged();
      return oracleRdbmsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.MysqlRdbms,
            com.google.cloud.datastream.v1alpha1.MysqlRdbms.Builder,
            com.google.cloud.datastream.v1alpha1.MysqlRdbmsOrBuilder>
        mysqlRdbmsBuilder_;
    /**
     *
     *
     * <pre>
     * MySQL RDBMS to enrich with child data objects and metadata.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_rdbms = 101;</code>
     *
     * @return Whether the mysqlRdbms field is set.
     */
    @java.lang.Override
    public boolean hasMysqlRdbms() {
      return dataObjectCase_ == 101;
    }
    /**
     *
     *
     * <pre>
     * MySQL RDBMS to enrich with child data objects and metadata.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_rdbms = 101;</code>
     *
     * @return The mysqlRdbms.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.MysqlRdbms getMysqlRdbms() {
      if (mysqlRdbmsBuilder_ == null) {
        if (dataObjectCase_ == 101) {
          return (com.google.cloud.datastream.v1alpha1.MysqlRdbms) dataObject_;
        }
        return com.google.cloud.datastream.v1alpha1.MysqlRdbms.getDefaultInstance();
      } else {
        if (dataObjectCase_ == 101) {
          return mysqlRdbmsBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1alpha1.MysqlRdbms.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * MySQL RDBMS to enrich with child data objects and metadata.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_rdbms = 101;</code>
     */
    public Builder setMysqlRdbms(com.google.cloud.datastream.v1alpha1.MysqlRdbms value) {
      if (mysqlRdbmsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataObject_ = value;
        onChanged();
      } else {
        mysqlRdbmsBuilder_.setMessage(value);
      }
      dataObjectCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * MySQL RDBMS to enrich with child data objects and metadata.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_rdbms = 101;</code>
     */
    public Builder setMysqlRdbms(
        com.google.cloud.datastream.v1alpha1.MysqlRdbms.Builder builderForValue) {
      if (mysqlRdbmsBuilder_ == null) {
        dataObject_ = builderForValue.build();
        onChanged();
      } else {
        mysqlRdbmsBuilder_.setMessage(builderForValue.build());
      }
      dataObjectCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * MySQL RDBMS to enrich with child data objects and metadata.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_rdbms = 101;</code>
     */
    public Builder mergeMysqlRdbms(com.google.cloud.datastream.v1alpha1.MysqlRdbms value) {
      if (mysqlRdbmsBuilder_ == null) {
        if (dataObjectCase_ == 101
            && dataObject_
                != com.google.cloud.datastream.v1alpha1.MysqlRdbms.getDefaultInstance()) {
          dataObject_ =
              com.google.cloud.datastream.v1alpha1.MysqlRdbms.newBuilder(
                      (com.google.cloud.datastream.v1alpha1.MysqlRdbms) dataObject_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dataObject_ = value;
        }
        onChanged();
      } else {
        if (dataObjectCase_ == 101) {
          mysqlRdbmsBuilder_.mergeFrom(value);
        } else {
          mysqlRdbmsBuilder_.setMessage(value);
        }
      }
      dataObjectCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * MySQL RDBMS to enrich with child data objects and metadata.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_rdbms = 101;</code>
     */
    public Builder clearMysqlRdbms() {
      if (mysqlRdbmsBuilder_ == null) {
        if (dataObjectCase_ == 101) {
          dataObjectCase_ = 0;
          dataObject_ = null;
          onChanged();
        }
      } else {
        if (dataObjectCase_ == 101) {
          dataObjectCase_ = 0;
          dataObject_ = null;
        }
        mysqlRdbmsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * MySQL RDBMS to enrich with child data objects and metadata.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_rdbms = 101;</code>
     */
    public com.google.cloud.datastream.v1alpha1.MysqlRdbms.Builder getMysqlRdbmsBuilder() {
      return getMysqlRdbmsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * MySQL RDBMS to enrich with child data objects and metadata.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_rdbms = 101;</code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.MysqlRdbmsOrBuilder getMysqlRdbmsOrBuilder() {
      if ((dataObjectCase_ == 101) && (mysqlRdbmsBuilder_ != null)) {
        return mysqlRdbmsBuilder_.getMessageOrBuilder();
      } else {
        if (dataObjectCase_ == 101) {
          return (com.google.cloud.datastream.v1alpha1.MysqlRdbms) dataObject_;
        }
        return com.google.cloud.datastream.v1alpha1.MysqlRdbms.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * MySQL RDBMS to enrich with child data objects and metadata.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_rdbms = 101;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.MysqlRdbms,
            com.google.cloud.datastream.v1alpha1.MysqlRdbms.Builder,
            com.google.cloud.datastream.v1alpha1.MysqlRdbmsOrBuilder>
        getMysqlRdbmsFieldBuilder() {
      if (mysqlRdbmsBuilder_ == null) {
        if (!(dataObjectCase_ == 101)) {
          dataObject_ = com.google.cloud.datastream.v1alpha1.MysqlRdbms.getDefaultInstance();
        }
        mysqlRdbmsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1alpha1.MysqlRdbms,
                com.google.cloud.datastream.v1alpha1.MysqlRdbms.Builder,
                com.google.cloud.datastream.v1alpha1.MysqlRdbmsOrBuilder>(
                (com.google.cloud.datastream.v1alpha1.MysqlRdbms) dataObject_,
                getParentForChildren(),
                isClean());
        dataObject_ = null;
      }
      dataObjectCase_ = 101;
      onChanged();
      return mysqlRdbmsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest)
  private static final com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest();
  }

  public static com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DiscoverConnectionProfileRequest> PARSER =
      new com.google.protobuf.AbstractParser<DiscoverConnectionProfileRequest>() {
        @java.lang.Override
        public DiscoverConnectionProfileRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DiscoverConnectionProfileRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DiscoverConnectionProfileRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.DiscoverConnectionProfileRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
