/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datastream/v1alpha1/datastream_resources.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.datastream.v1alpha1;

/**
 *
 *
 * <pre>
 * Google Cloud Storage destination configuration
 * </pre>
 *
 * Protobuf type {@code google.cloud.datastream.v1alpha1.GcsDestinationConfig}
 */
public final class GcsDestinationConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1alpha1.GcsDestinationConfig)
    GcsDestinationConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GcsDestinationConfig.newBuilder() to construct.
  private GcsDestinationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GcsDestinationConfig() {
    path_ = "";
    gcsFileFormat_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GcsDestinationConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1alpha1_GcsDestinationConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1alpha1_GcsDestinationConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datastream.v1alpha1.GcsDestinationConfig.class,
            com.google.cloud.datastream.v1alpha1.GcsDestinationConfig.Builder.class);
  }

  private int bitField0_;
  private int fileFormatCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object fileFormat_;

  public enum FileFormatCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AVRO_FILE_FORMAT(100),
    JSON_FILE_FORMAT(101),
    FILEFORMAT_NOT_SET(0);
    private final int value;

    private FileFormatCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FileFormatCase valueOf(int value) {
      return forNumber(value);
    }

    public static FileFormatCase forNumber(int value) {
      switch (value) {
        case 100:
          return AVRO_FILE_FORMAT;
        case 101:
          return JSON_FILE_FORMAT;
        case 0:
          return FILEFORMAT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public FileFormatCase getFileFormatCase() {
    return FileFormatCase.forNumber(fileFormatCase_);
  }

  public static final int PATH_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object path_ = "";
  /**
   *
   *
   * <pre>
   * Path inside the Cloud Storage bucket to write data to.
   * </pre>
   *
   * <code>string path = 1;</code>
   *
   * @return The path.
   */
  @java.lang.Override
  public java.lang.String getPath() {
    java.lang.Object ref = path_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      path_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Path inside the Cloud Storage bucket to write data to.
   * </pre>
   *
   * <code>string path = 1;</code>
   *
   * @return The bytes for path.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPathBytes() {
    java.lang.Object ref = path_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      path_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GCS_FILE_FORMAT_FIELD_NUMBER = 2;
  private int gcsFileFormat_ = 0;
  /**
   *
   *
   * <pre>
   * File format that data should be written in.
   * Deprecated field - use file_format instead.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.GcsFileFormat gcs_file_format = 2 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.datastream.v1alpha1.GcsDestinationConfig.gcs_file_format is
   *     deprecated. See google/cloud/datastream/v1alpha1/datastream_resources.proto;l=476
   * @return The enum numeric value on the wire for gcsFileFormat.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getGcsFileFormatValue() {
    return gcsFileFormat_;
  }
  /**
   *
   *
   * <pre>
   * File format that data should be written in.
   * Deprecated field - use file_format instead.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.GcsFileFormat gcs_file_format = 2 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.datastream.v1alpha1.GcsDestinationConfig.gcs_file_format is
   *     deprecated. See google/cloud/datastream/v1alpha1/datastream_resources.proto;l=476
   * @return The gcsFileFormat.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.datastream.v1alpha1.GcsFileFormat getGcsFileFormat() {
    com.google.cloud.datastream.v1alpha1.GcsFileFormat result =
        com.google.cloud.datastream.v1alpha1.GcsFileFormat.forNumber(gcsFileFormat_);
    return result == null
        ? com.google.cloud.datastream.v1alpha1.GcsFileFormat.UNRECOGNIZED
        : result;
  }

  public static final int FILE_ROTATION_MB_FIELD_NUMBER = 3;
  private int fileRotationMb_ = 0;
  /**
   *
   *
   * <pre>
   * The maximum file size to be saved in the bucket.
   * </pre>
   *
   * <code>int32 file_rotation_mb = 3;</code>
   *
   * @return The fileRotationMb.
   */
  @java.lang.Override
  public int getFileRotationMb() {
    return fileRotationMb_;
  }

  public static final int FILE_ROTATION_INTERVAL_FIELD_NUMBER = 4;
  private com.google.protobuf.Duration fileRotationInterval_;
  /**
   *
   *
   * <pre>
   * The maximum duration for which new events are added before a file is
   * closed and a new file is created.
   * </pre>
   *
   * <code>.google.protobuf.Duration file_rotation_interval = 4;</code>
   *
   * @return Whether the fileRotationInterval field is set.
   */
  @java.lang.Override
  public boolean hasFileRotationInterval() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The maximum duration for which new events are added before a file is
   * closed and a new file is created.
   * </pre>
   *
   * <code>.google.protobuf.Duration file_rotation_interval = 4;</code>
   *
   * @return The fileRotationInterval.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getFileRotationInterval() {
    return fileRotationInterval_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : fileRotationInterval_;
  }
  /**
   *
   *
   * <pre>
   * The maximum duration for which new events are added before a file is
   * closed and a new file is created.
   * </pre>
   *
   * <code>.google.protobuf.Duration file_rotation_interval = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getFileRotationIntervalOrBuilder() {
    return fileRotationInterval_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : fileRotationInterval_;
  }

  public static final int AVRO_FILE_FORMAT_FIELD_NUMBER = 100;
  /**
   *
   *
   * <pre>
   * AVRO file format configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.AvroFileFormat avro_file_format = 100;</code>
   *
   * @return Whether the avroFileFormat field is set.
   */
  @java.lang.Override
  public boolean hasAvroFileFormat() {
    return fileFormatCase_ == 100;
  }
  /**
   *
   *
   * <pre>
   * AVRO file format configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.AvroFileFormat avro_file_format = 100;</code>
   *
   * @return The avroFileFormat.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.AvroFileFormat getAvroFileFormat() {
    if (fileFormatCase_ == 100) {
      return (com.google.cloud.datastream.v1alpha1.AvroFileFormat) fileFormat_;
    }
    return com.google.cloud.datastream.v1alpha1.AvroFileFormat.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * AVRO file format configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.AvroFileFormat avro_file_format = 100;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.AvroFileFormatOrBuilder getAvroFileFormatOrBuilder() {
    if (fileFormatCase_ == 100) {
      return (com.google.cloud.datastream.v1alpha1.AvroFileFormat) fileFormat_;
    }
    return com.google.cloud.datastream.v1alpha1.AvroFileFormat.getDefaultInstance();
  }

  public static final int JSON_FILE_FORMAT_FIELD_NUMBER = 101;
  /**
   *
   *
   * <pre>
   * JSON file format configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.JsonFileFormat json_file_format = 101;</code>
   *
   * @return Whether the jsonFileFormat field is set.
   */
  @java.lang.Override
  public boolean hasJsonFileFormat() {
    return fileFormatCase_ == 101;
  }
  /**
   *
   *
   * <pre>
   * JSON file format configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.JsonFileFormat json_file_format = 101;</code>
   *
   * @return The jsonFileFormat.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.JsonFileFormat getJsonFileFormat() {
    if (fileFormatCase_ == 101) {
      return (com.google.cloud.datastream.v1alpha1.JsonFileFormat) fileFormat_;
    }
    return com.google.cloud.datastream.v1alpha1.JsonFileFormat.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * JSON file format configuration.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.JsonFileFormat json_file_format = 101;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.JsonFileFormatOrBuilder getJsonFileFormatOrBuilder() {
    if (fileFormatCase_ == 101) {
      return (com.google.cloud.datastream.v1alpha1.JsonFileFormat) fileFormat_;
    }
    return com.google.cloud.datastream.v1alpha1.JsonFileFormat.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, path_);
    }
    if (gcsFileFormat_
        != com.google.cloud.datastream.v1alpha1.GcsFileFormat.GCS_FILE_FORMAT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, gcsFileFormat_);
    }
    if (fileRotationMb_ != 0) {
      output.writeInt32(3, fileRotationMb_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getFileRotationInterval());
    }
    if (fileFormatCase_ == 100) {
      output.writeMessage(100, (com.google.cloud.datastream.v1alpha1.AvroFileFormat) fileFormat_);
    }
    if (fileFormatCase_ == 101) {
      output.writeMessage(101, (com.google.cloud.datastream.v1alpha1.JsonFileFormat) fileFormat_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(path_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, path_);
    }
    if (gcsFileFormat_
        != com.google.cloud.datastream.v1alpha1.GcsFileFormat.GCS_FILE_FORMAT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, gcsFileFormat_);
    }
    if (fileRotationMb_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, fileRotationMb_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, getFileRotationInterval());
    }
    if (fileFormatCase_ == 100) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              100, (com.google.cloud.datastream.v1alpha1.AvroFileFormat) fileFormat_);
    }
    if (fileFormatCase_ == 101) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              101, (com.google.cloud.datastream.v1alpha1.JsonFileFormat) fileFormat_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datastream.v1alpha1.GcsDestinationConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.datastream.v1alpha1.GcsDestinationConfig other =
        (com.google.cloud.datastream.v1alpha1.GcsDestinationConfig) obj;

    if (!getPath().equals(other.getPath())) return false;
    if (gcsFileFormat_ != other.gcsFileFormat_) return false;
    if (getFileRotationMb() != other.getFileRotationMb()) return false;
    if (hasFileRotationInterval() != other.hasFileRotationInterval()) return false;
    if (hasFileRotationInterval()) {
      if (!getFileRotationInterval().equals(other.getFileRotationInterval())) return false;
    }
    if (!getFileFormatCase().equals(other.getFileFormatCase())) return false;
    switch (fileFormatCase_) {
      case 100:
        if (!getAvroFileFormat().equals(other.getAvroFileFormat())) return false;
        break;
      case 101:
        if (!getJsonFileFormat().equals(other.getJsonFileFormat())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PATH_FIELD_NUMBER;
    hash = (53 * hash) + getPath().hashCode();
    hash = (37 * hash) + GCS_FILE_FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + gcsFileFormat_;
    hash = (37 * hash) + FILE_ROTATION_MB_FIELD_NUMBER;
    hash = (53 * hash) + getFileRotationMb();
    if (hasFileRotationInterval()) {
      hash = (37 * hash) + FILE_ROTATION_INTERVAL_FIELD_NUMBER;
      hash = (53 * hash) + getFileRotationInterval().hashCode();
    }
    switch (fileFormatCase_) {
      case 100:
        hash = (37 * hash) + AVRO_FILE_FORMAT_FIELD_NUMBER;
        hash = (53 * hash) + getAvroFileFormat().hashCode();
        break;
      case 101:
        hash = (37 * hash) + JSON_FILE_FORMAT_FIELD_NUMBER;
        hash = (53 * hash) + getJsonFileFormat().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datastream.v1alpha1.GcsDestinationConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1alpha1.GcsDestinationConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1alpha1.GcsDestinationConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1alpha1.GcsDestinationConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1alpha1.GcsDestinationConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1alpha1.GcsDestinationConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1alpha1.GcsDestinationConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1alpha1.GcsDestinationConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1alpha1.GcsDestinationConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1alpha1.GcsDestinationConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1alpha1.GcsDestinationConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1alpha1.GcsDestinationConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datastream.v1alpha1.GcsDestinationConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Google Cloud Storage destination configuration
   * </pre>
   *
   * Protobuf type {@code google.cloud.datastream.v1alpha1.GcsDestinationConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1alpha1.GcsDestinationConfig)
      com.google.cloud.datastream.v1alpha1.GcsDestinationConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1alpha1_GcsDestinationConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1alpha1_GcsDestinationConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1alpha1.GcsDestinationConfig.class,
              com.google.cloud.datastream.v1alpha1.GcsDestinationConfig.Builder.class);
    }

    // Construct using com.google.cloud.datastream.v1alpha1.GcsDestinationConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFileRotationIntervalFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      path_ = "";
      gcsFileFormat_ = 0;
      fileRotationMb_ = 0;
      fileRotationInterval_ = null;
      if (fileRotationIntervalBuilder_ != null) {
        fileRotationIntervalBuilder_.dispose();
        fileRotationIntervalBuilder_ = null;
      }
      if (avroFileFormatBuilder_ != null) {
        avroFileFormatBuilder_.clear();
      }
      if (jsonFileFormatBuilder_ != null) {
        jsonFileFormatBuilder_.clear();
      }
      fileFormatCase_ = 0;
      fileFormat_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1alpha1_GcsDestinationConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.GcsDestinationConfig getDefaultInstanceForType() {
      return com.google.cloud.datastream.v1alpha1.GcsDestinationConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.GcsDestinationConfig build() {
      com.google.cloud.datastream.v1alpha1.GcsDestinationConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.GcsDestinationConfig buildPartial() {
      com.google.cloud.datastream.v1alpha1.GcsDestinationConfig result =
          new com.google.cloud.datastream.v1alpha1.GcsDestinationConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datastream.v1alpha1.GcsDestinationConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.path_ = path_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.gcsFileFormat_ = gcsFileFormat_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.fileRotationMb_ = fileRotationMb_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.fileRotationInterval_ =
            fileRotationIntervalBuilder_ == null
                ? fileRotationInterval_
                : fileRotationIntervalBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.datastream.v1alpha1.GcsDestinationConfig result) {
      result.fileFormatCase_ = fileFormatCase_;
      result.fileFormat_ = this.fileFormat_;
      if (fileFormatCase_ == 100 && avroFileFormatBuilder_ != null) {
        result.fileFormat_ = avroFileFormatBuilder_.build();
      }
      if (fileFormatCase_ == 101 && jsonFileFormatBuilder_ != null) {
        result.fileFormat_ = jsonFileFormatBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datastream.v1alpha1.GcsDestinationConfig) {
        return mergeFrom((com.google.cloud.datastream.v1alpha1.GcsDestinationConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datastream.v1alpha1.GcsDestinationConfig other) {
      if (other == com.google.cloud.datastream.v1alpha1.GcsDestinationConfig.getDefaultInstance())
        return this;
      if (!other.getPath().isEmpty()) {
        path_ = other.path_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.gcsFileFormat_ != 0) {
        setGcsFileFormatValue(other.getGcsFileFormatValue());
      }
      if (other.getFileRotationMb() != 0) {
        setFileRotationMb(other.getFileRotationMb());
      }
      if (other.hasFileRotationInterval()) {
        mergeFileRotationInterval(other.getFileRotationInterval());
      }
      switch (other.getFileFormatCase()) {
        case AVRO_FILE_FORMAT:
          {
            mergeAvroFileFormat(other.getAvroFileFormat());
            break;
          }
        case JSON_FILE_FORMAT:
          {
            mergeJsonFileFormat(other.getJsonFileFormat());
            break;
          }
        case FILEFORMAT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                path_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                gcsFileFormat_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                fileRotationMb_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(
                    getFileRotationIntervalFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 802:
              {
                input.readMessage(getAvroFileFormatFieldBuilder().getBuilder(), extensionRegistry);
                fileFormatCase_ = 100;
                break;
              } // case 802
            case 810:
              {
                input.readMessage(getJsonFileFormatFieldBuilder().getBuilder(), extensionRegistry);
                fileFormatCase_ = 101;
                break;
              } // case 810
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int fileFormatCase_ = 0;
    private java.lang.Object fileFormat_;

    public FileFormatCase getFileFormatCase() {
      return FileFormatCase.forNumber(fileFormatCase_);
    }

    public Builder clearFileFormat() {
      fileFormatCase_ = 0;
      fileFormat_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object path_ = "";
    /**
     *
     *
     * <pre>
     * Path inside the Cloud Storage bucket to write data to.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @return The path.
     */
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Path inside the Cloud Storage bucket to write data to.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @return The bytes for path.
     */
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Path inside the Cloud Storage bucket to write data to.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @param value The path to set.
     * @return This builder for chaining.
     */
    public Builder setPath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      path_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Path inside the Cloud Storage bucket to write data to.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPath() {
      path_ = getDefaultInstance().getPath();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Path inside the Cloud Storage bucket to write data to.
     * </pre>
     *
     * <code>string path = 1;</code>
     *
     * @param value The bytes for path to set.
     * @return This builder for chaining.
     */
    public Builder setPathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      path_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int gcsFileFormat_ = 0;
    /**
     *
     *
     * <pre>
     * File format that data should be written in.
     * Deprecated field - use file_format instead.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.GcsFileFormat gcs_file_format = 2 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.datastream.v1alpha1.GcsDestinationConfig.gcs_file_format is
     *     deprecated. See google/cloud/datastream/v1alpha1/datastream_resources.proto;l=476
     * @return The enum numeric value on the wire for gcsFileFormat.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getGcsFileFormatValue() {
      return gcsFileFormat_;
    }
    /**
     *
     *
     * <pre>
     * File format that data should be written in.
     * Deprecated field - use file_format instead.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.GcsFileFormat gcs_file_format = 2 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.datastream.v1alpha1.GcsDestinationConfig.gcs_file_format is
     *     deprecated. See google/cloud/datastream/v1alpha1/datastream_resources.proto;l=476
     * @param value The enum numeric value on the wire for gcsFileFormat to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setGcsFileFormatValue(int value) {
      gcsFileFormat_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * File format that data should be written in.
     * Deprecated field - use file_format instead.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.GcsFileFormat gcs_file_format = 2 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.datastream.v1alpha1.GcsDestinationConfig.gcs_file_format is
     *     deprecated. See google/cloud/datastream/v1alpha1/datastream_resources.proto;l=476
     * @return The gcsFileFormat.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.datastream.v1alpha1.GcsFileFormat getGcsFileFormat() {
      com.google.cloud.datastream.v1alpha1.GcsFileFormat result =
          com.google.cloud.datastream.v1alpha1.GcsFileFormat.forNumber(gcsFileFormat_);
      return result == null
          ? com.google.cloud.datastream.v1alpha1.GcsFileFormat.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * File format that data should be written in.
     * Deprecated field - use file_format instead.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.GcsFileFormat gcs_file_format = 2 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.datastream.v1alpha1.GcsDestinationConfig.gcs_file_format is
     *     deprecated. See google/cloud/datastream/v1alpha1/datastream_resources.proto;l=476
     * @param value The gcsFileFormat to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setGcsFileFormat(com.google.cloud.datastream.v1alpha1.GcsFileFormat value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      gcsFileFormat_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * File format that data should be written in.
     * Deprecated field - use file_format instead.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.GcsFileFormat gcs_file_format = 2 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.datastream.v1alpha1.GcsDestinationConfig.gcs_file_format is
     *     deprecated. See google/cloud/datastream/v1alpha1/datastream_resources.proto;l=476
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearGcsFileFormat() {
      bitField0_ = (bitField0_ & ~0x00000002);
      gcsFileFormat_ = 0;
      onChanged();
      return this;
    }

    private int fileRotationMb_;
    /**
     *
     *
     * <pre>
     * The maximum file size to be saved in the bucket.
     * </pre>
     *
     * <code>int32 file_rotation_mb = 3;</code>
     *
     * @return The fileRotationMb.
     */
    @java.lang.Override
    public int getFileRotationMb() {
      return fileRotationMb_;
    }
    /**
     *
     *
     * <pre>
     * The maximum file size to be saved in the bucket.
     * </pre>
     *
     * <code>int32 file_rotation_mb = 3;</code>
     *
     * @param value The fileRotationMb to set.
     * @return This builder for chaining.
     */
    public Builder setFileRotationMb(int value) {

      fileRotationMb_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum file size to be saved in the bucket.
     * </pre>
     *
     * <code>int32 file_rotation_mb = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFileRotationMb() {
      bitField0_ = (bitField0_ & ~0x00000004);
      fileRotationMb_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration fileRotationInterval_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        fileRotationIntervalBuilder_;
    /**
     *
     *
     * <pre>
     * The maximum duration for which new events are added before a file is
     * closed and a new file is created.
     * </pre>
     *
     * <code>.google.protobuf.Duration file_rotation_interval = 4;</code>
     *
     * @return Whether the fileRotationInterval field is set.
     */
    public boolean hasFileRotationInterval() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The maximum duration for which new events are added before a file is
     * closed and a new file is created.
     * </pre>
     *
     * <code>.google.protobuf.Duration file_rotation_interval = 4;</code>
     *
     * @return The fileRotationInterval.
     */
    public com.google.protobuf.Duration getFileRotationInterval() {
      if (fileRotationIntervalBuilder_ == null) {
        return fileRotationInterval_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : fileRotationInterval_;
      } else {
        return fileRotationIntervalBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum duration for which new events are added before a file is
     * closed and a new file is created.
     * </pre>
     *
     * <code>.google.protobuf.Duration file_rotation_interval = 4;</code>
     */
    public Builder setFileRotationInterval(com.google.protobuf.Duration value) {
      if (fileRotationIntervalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fileRotationInterval_ = value;
      } else {
        fileRotationIntervalBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum duration for which new events are added before a file is
     * closed and a new file is created.
     * </pre>
     *
     * <code>.google.protobuf.Duration file_rotation_interval = 4;</code>
     */
    public Builder setFileRotationInterval(com.google.protobuf.Duration.Builder builderForValue) {
      if (fileRotationIntervalBuilder_ == null) {
        fileRotationInterval_ = builderForValue.build();
      } else {
        fileRotationIntervalBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum duration for which new events are added before a file is
     * closed and a new file is created.
     * </pre>
     *
     * <code>.google.protobuf.Duration file_rotation_interval = 4;</code>
     */
    public Builder mergeFileRotationInterval(com.google.protobuf.Duration value) {
      if (fileRotationIntervalBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && fileRotationInterval_ != null
            && fileRotationInterval_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getFileRotationIntervalBuilder().mergeFrom(value);
        } else {
          fileRotationInterval_ = value;
        }
      } else {
        fileRotationIntervalBuilder_.mergeFrom(value);
      }
      if (fileRotationInterval_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum duration for which new events are added before a file is
     * closed and a new file is created.
     * </pre>
     *
     * <code>.google.protobuf.Duration file_rotation_interval = 4;</code>
     */
    public Builder clearFileRotationInterval() {
      bitField0_ = (bitField0_ & ~0x00000008);
      fileRotationInterval_ = null;
      if (fileRotationIntervalBuilder_ != null) {
        fileRotationIntervalBuilder_.dispose();
        fileRotationIntervalBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum duration for which new events are added before a file is
     * closed and a new file is created.
     * </pre>
     *
     * <code>.google.protobuf.Duration file_rotation_interval = 4;</code>
     */
    public com.google.protobuf.Duration.Builder getFileRotationIntervalBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getFileRotationIntervalFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The maximum duration for which new events are added before a file is
     * closed and a new file is created.
     * </pre>
     *
     * <code>.google.protobuf.Duration file_rotation_interval = 4;</code>
     */
    public com.google.protobuf.DurationOrBuilder getFileRotationIntervalOrBuilder() {
      if (fileRotationIntervalBuilder_ != null) {
        return fileRotationIntervalBuilder_.getMessageOrBuilder();
      } else {
        return fileRotationInterval_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : fileRotationInterval_;
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum duration for which new events are added before a file is
     * closed and a new file is created.
     * </pre>
     *
     * <code>.google.protobuf.Duration file_rotation_interval = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getFileRotationIntervalFieldBuilder() {
      if (fileRotationIntervalBuilder_ == null) {
        fileRotationIntervalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getFileRotationInterval(), getParentForChildren(), isClean());
        fileRotationInterval_ = null;
      }
      return fileRotationIntervalBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.AvroFileFormat,
            com.google.cloud.datastream.v1alpha1.AvroFileFormat.Builder,
            com.google.cloud.datastream.v1alpha1.AvroFileFormatOrBuilder>
        avroFileFormatBuilder_;
    /**
     *
     *
     * <pre>
     * AVRO file format configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.AvroFileFormat avro_file_format = 100;</code>
     *
     * @return Whether the avroFileFormat field is set.
     */
    @java.lang.Override
    public boolean hasAvroFileFormat() {
      return fileFormatCase_ == 100;
    }
    /**
     *
     *
     * <pre>
     * AVRO file format configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.AvroFileFormat avro_file_format = 100;</code>
     *
     * @return The avroFileFormat.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.AvroFileFormat getAvroFileFormat() {
      if (avroFileFormatBuilder_ == null) {
        if (fileFormatCase_ == 100) {
          return (com.google.cloud.datastream.v1alpha1.AvroFileFormat) fileFormat_;
        }
        return com.google.cloud.datastream.v1alpha1.AvroFileFormat.getDefaultInstance();
      } else {
        if (fileFormatCase_ == 100) {
          return avroFileFormatBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1alpha1.AvroFileFormat.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * AVRO file format configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.AvroFileFormat avro_file_format = 100;</code>
     */
    public Builder setAvroFileFormat(com.google.cloud.datastream.v1alpha1.AvroFileFormat value) {
      if (avroFileFormatBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fileFormat_ = value;
        onChanged();
      } else {
        avroFileFormatBuilder_.setMessage(value);
      }
      fileFormatCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * AVRO file format configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.AvroFileFormat avro_file_format = 100;</code>
     */
    public Builder setAvroFileFormat(
        com.google.cloud.datastream.v1alpha1.AvroFileFormat.Builder builderForValue) {
      if (avroFileFormatBuilder_ == null) {
        fileFormat_ = builderForValue.build();
        onChanged();
      } else {
        avroFileFormatBuilder_.setMessage(builderForValue.build());
      }
      fileFormatCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * AVRO file format configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.AvroFileFormat avro_file_format = 100;</code>
     */
    public Builder mergeAvroFileFormat(com.google.cloud.datastream.v1alpha1.AvroFileFormat value) {
      if (avroFileFormatBuilder_ == null) {
        if (fileFormatCase_ == 100
            && fileFormat_
                != com.google.cloud.datastream.v1alpha1.AvroFileFormat.getDefaultInstance()) {
          fileFormat_ =
              com.google.cloud.datastream.v1alpha1.AvroFileFormat.newBuilder(
                      (com.google.cloud.datastream.v1alpha1.AvroFileFormat) fileFormat_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          fileFormat_ = value;
        }
        onChanged();
      } else {
        if (fileFormatCase_ == 100) {
          avroFileFormatBuilder_.mergeFrom(value);
        } else {
          avroFileFormatBuilder_.setMessage(value);
        }
      }
      fileFormatCase_ = 100;
      return this;
    }
    /**
     *
     *
     * <pre>
     * AVRO file format configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.AvroFileFormat avro_file_format = 100;</code>
     */
    public Builder clearAvroFileFormat() {
      if (avroFileFormatBuilder_ == null) {
        if (fileFormatCase_ == 100) {
          fileFormatCase_ = 0;
          fileFormat_ = null;
          onChanged();
        }
      } else {
        if (fileFormatCase_ == 100) {
          fileFormatCase_ = 0;
          fileFormat_ = null;
        }
        avroFileFormatBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * AVRO file format configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.AvroFileFormat avro_file_format = 100;</code>
     */
    public com.google.cloud.datastream.v1alpha1.AvroFileFormat.Builder getAvroFileFormatBuilder() {
      return getAvroFileFormatFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * AVRO file format configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.AvroFileFormat avro_file_format = 100;</code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.AvroFileFormatOrBuilder
        getAvroFileFormatOrBuilder() {
      if ((fileFormatCase_ == 100) && (avroFileFormatBuilder_ != null)) {
        return avroFileFormatBuilder_.getMessageOrBuilder();
      } else {
        if (fileFormatCase_ == 100) {
          return (com.google.cloud.datastream.v1alpha1.AvroFileFormat) fileFormat_;
        }
        return com.google.cloud.datastream.v1alpha1.AvroFileFormat.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * AVRO file format configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.AvroFileFormat avro_file_format = 100;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.AvroFileFormat,
            com.google.cloud.datastream.v1alpha1.AvroFileFormat.Builder,
            com.google.cloud.datastream.v1alpha1.AvroFileFormatOrBuilder>
        getAvroFileFormatFieldBuilder() {
      if (avroFileFormatBuilder_ == null) {
        if (!(fileFormatCase_ == 100)) {
          fileFormat_ = com.google.cloud.datastream.v1alpha1.AvroFileFormat.getDefaultInstance();
        }
        avroFileFormatBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1alpha1.AvroFileFormat,
                com.google.cloud.datastream.v1alpha1.AvroFileFormat.Builder,
                com.google.cloud.datastream.v1alpha1.AvroFileFormatOrBuilder>(
                (com.google.cloud.datastream.v1alpha1.AvroFileFormat) fileFormat_,
                getParentForChildren(),
                isClean());
        fileFormat_ = null;
      }
      fileFormatCase_ = 100;
      onChanged();
      return avroFileFormatBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.JsonFileFormat,
            com.google.cloud.datastream.v1alpha1.JsonFileFormat.Builder,
            com.google.cloud.datastream.v1alpha1.JsonFileFormatOrBuilder>
        jsonFileFormatBuilder_;
    /**
     *
     *
     * <pre>
     * JSON file format configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.JsonFileFormat json_file_format = 101;</code>
     *
     * @return Whether the jsonFileFormat field is set.
     */
    @java.lang.Override
    public boolean hasJsonFileFormat() {
      return fileFormatCase_ == 101;
    }
    /**
     *
     *
     * <pre>
     * JSON file format configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.JsonFileFormat json_file_format = 101;</code>
     *
     * @return The jsonFileFormat.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.JsonFileFormat getJsonFileFormat() {
      if (jsonFileFormatBuilder_ == null) {
        if (fileFormatCase_ == 101) {
          return (com.google.cloud.datastream.v1alpha1.JsonFileFormat) fileFormat_;
        }
        return com.google.cloud.datastream.v1alpha1.JsonFileFormat.getDefaultInstance();
      } else {
        if (fileFormatCase_ == 101) {
          return jsonFileFormatBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1alpha1.JsonFileFormat.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * JSON file format configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.JsonFileFormat json_file_format = 101;</code>
     */
    public Builder setJsonFileFormat(com.google.cloud.datastream.v1alpha1.JsonFileFormat value) {
      if (jsonFileFormatBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        fileFormat_ = value;
        onChanged();
      } else {
        jsonFileFormatBuilder_.setMessage(value);
      }
      fileFormatCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * JSON file format configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.JsonFileFormat json_file_format = 101;</code>
     */
    public Builder setJsonFileFormat(
        com.google.cloud.datastream.v1alpha1.JsonFileFormat.Builder builderForValue) {
      if (jsonFileFormatBuilder_ == null) {
        fileFormat_ = builderForValue.build();
        onChanged();
      } else {
        jsonFileFormatBuilder_.setMessage(builderForValue.build());
      }
      fileFormatCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * JSON file format configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.JsonFileFormat json_file_format = 101;</code>
     */
    public Builder mergeJsonFileFormat(com.google.cloud.datastream.v1alpha1.JsonFileFormat value) {
      if (jsonFileFormatBuilder_ == null) {
        if (fileFormatCase_ == 101
            && fileFormat_
                != com.google.cloud.datastream.v1alpha1.JsonFileFormat.getDefaultInstance()) {
          fileFormat_ =
              com.google.cloud.datastream.v1alpha1.JsonFileFormat.newBuilder(
                      (com.google.cloud.datastream.v1alpha1.JsonFileFormat) fileFormat_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          fileFormat_ = value;
        }
        onChanged();
      } else {
        if (fileFormatCase_ == 101) {
          jsonFileFormatBuilder_.mergeFrom(value);
        } else {
          jsonFileFormatBuilder_.setMessage(value);
        }
      }
      fileFormatCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * JSON file format configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.JsonFileFormat json_file_format = 101;</code>
     */
    public Builder clearJsonFileFormat() {
      if (jsonFileFormatBuilder_ == null) {
        if (fileFormatCase_ == 101) {
          fileFormatCase_ = 0;
          fileFormat_ = null;
          onChanged();
        }
      } else {
        if (fileFormatCase_ == 101) {
          fileFormatCase_ = 0;
          fileFormat_ = null;
        }
        jsonFileFormatBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * JSON file format configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.JsonFileFormat json_file_format = 101;</code>
     */
    public com.google.cloud.datastream.v1alpha1.JsonFileFormat.Builder getJsonFileFormatBuilder() {
      return getJsonFileFormatFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * JSON file format configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.JsonFileFormat json_file_format = 101;</code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.JsonFileFormatOrBuilder
        getJsonFileFormatOrBuilder() {
      if ((fileFormatCase_ == 101) && (jsonFileFormatBuilder_ != null)) {
        return jsonFileFormatBuilder_.getMessageOrBuilder();
      } else {
        if (fileFormatCase_ == 101) {
          return (com.google.cloud.datastream.v1alpha1.JsonFileFormat) fileFormat_;
        }
        return com.google.cloud.datastream.v1alpha1.JsonFileFormat.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * JSON file format configuration.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.JsonFileFormat json_file_format = 101;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.JsonFileFormat,
            com.google.cloud.datastream.v1alpha1.JsonFileFormat.Builder,
            com.google.cloud.datastream.v1alpha1.JsonFileFormatOrBuilder>
        getJsonFileFormatFieldBuilder() {
      if (jsonFileFormatBuilder_ == null) {
        if (!(fileFormatCase_ == 101)) {
          fileFormat_ = com.google.cloud.datastream.v1alpha1.JsonFileFormat.getDefaultInstance();
        }
        jsonFileFormatBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1alpha1.JsonFileFormat,
                com.google.cloud.datastream.v1alpha1.JsonFileFormat.Builder,
                com.google.cloud.datastream.v1alpha1.JsonFileFormatOrBuilder>(
                (com.google.cloud.datastream.v1alpha1.JsonFileFormat) fileFormat_,
                getParentForChildren(),
                isClean());
        fileFormat_ = null;
      }
      fileFormatCase_ = 101;
      onChanged();
      return jsonFileFormatBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1alpha1.GcsDestinationConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1alpha1.GcsDestinationConfig)
  private static final com.google.cloud.datastream.v1alpha1.GcsDestinationConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datastream.v1alpha1.GcsDestinationConfig();
  }

  public static com.google.cloud.datastream.v1alpha1.GcsDestinationConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GcsDestinationConfig> PARSER =
      new com.google.protobuf.AbstractParser<GcsDestinationConfig>() {
        @java.lang.Override
        public GcsDestinationConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GcsDestinationConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GcsDestinationConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.GcsDestinationConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
