/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datastream/v1alpha1/datastream_resources.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.datastream.v1alpha1;

/** Protobuf type {@code google.cloud.datastream.v1alpha1.Stream} */
public final class Stream extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1alpha1.Stream)
    StreamOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Stream.newBuilder() to construct.
  private Stream(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Stream() {
    name_ = "";
    displayName_ = "";
    state_ = 0;
    errors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Stream();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1alpha1_Stream_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
        .internal_static_google_cloud_datastream_v1alpha1_Stream_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datastream.v1alpha1.Stream.class,
            com.google.cloud.datastream.v1alpha1.Stream.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Stream state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.datastream.v1alpha1.Stream.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified stream state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The stream has been created.
     * </pre>
     *
     * <code>CREATED = 1;</code>
     */
    CREATED(1),
    /**
     *
     *
     * <pre>
     * The stream is running.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * The stream is paused.
     * </pre>
     *
     * <code>PAUSED = 3;</code>
     */
    PAUSED(3),
    /**
     *
     *
     * <pre>
     * The stream is in maintenance mode.
     *
     * Updates are rejected on the resource in this state.
     * </pre>
     *
     * <code>MAINTENANCE = 4;</code>
     */
    MAINTENANCE(4),
    /**
     *
     *
     * <pre>
     * The stream is experiencing an error that is preventing data from being
     * streamed.
     * </pre>
     *
     * <code>FAILED = 5;</code>
     */
    FAILED(5),
    /**
     *
     *
     * <pre>
     * The stream has experienced a terminal failure.
     * </pre>
     *
     * <code>FAILED_PERMANENTLY = 6;</code>
     */
    FAILED_PERMANENTLY(6),
    /**
     *
     *
     * <pre>
     * The stream is starting, but not yet running.
     * </pre>
     *
     * <code>STARTING = 7;</code>
     */
    STARTING(7),
    /**
     *
     *
     * <pre>
     * The Stream is no longer reading new events, but still writing events in
     * the buffer.
     * </pre>
     *
     * <code>DRAINING = 8;</code>
     */
    DRAINING(8),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified stream state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The stream has been created.
     * </pre>
     *
     * <code>CREATED = 1;</code>
     */
    public static final int CREATED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The stream is running.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The stream is paused.
     * </pre>
     *
     * <code>PAUSED = 3;</code>
     */
    public static final int PAUSED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The stream is in maintenance mode.
     *
     * Updates are rejected on the resource in this state.
     * </pre>
     *
     * <code>MAINTENANCE = 4;</code>
     */
    public static final int MAINTENANCE_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The stream is experiencing an error that is preventing data from being
     * streamed.
     * </pre>
     *
     * <code>FAILED = 5;</code>
     */
    public static final int FAILED_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The stream has experienced a terminal failure.
     * </pre>
     *
     * <code>FAILED_PERMANENTLY = 6;</code>
     */
    public static final int FAILED_PERMANENTLY_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The stream is starting, but not yet running.
     * </pre>
     *
     * <code>STARTING = 7;</code>
     */
    public static final int STARTING_VALUE = 7;
    /**
     *
     *
     * <pre>
     * The Stream is no longer reading new events, but still writing events in
     * the buffer.
     * </pre>
     *
     * <code>DRAINING = 8;</code>
     */
    public static final int DRAINING_VALUE = 8;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return CREATED;
        case 2:
          return RUNNING;
        case 3:
          return PAUSED;
        case 4:
          return MAINTENANCE;
        case 5:
          return FAILED;
        case 6:
          return FAILED_PERMANENTLY;
        case 7:
          return STARTING;
        case 8:
          return DRAINING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.datastream.v1alpha1.Stream.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.datastream.v1alpha1.Stream.State)
  }

  public interface BackfillAllStrategyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Oracle data source objects to avoid backfilling.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_excluded_objects = 1;</code>
     *
     * @return Whether the oracleExcludedObjects field is set.
     */
    boolean hasOracleExcludedObjects();
    /**
     *
     *
     * <pre>
     * Oracle data source objects to avoid backfilling.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_excluded_objects = 1;</code>
     *
     * @return The oracleExcludedObjects.
     */
    com.google.cloud.datastream.v1alpha1.OracleRdbms getOracleExcludedObjects();
    /**
     *
     *
     * <pre>
     * Oracle data source objects to avoid backfilling.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_excluded_objects = 1;</code>
     */
    com.google.cloud.datastream.v1alpha1.OracleRdbmsOrBuilder getOracleExcludedObjectsOrBuilder();

    /**
     *
     *
     * <pre>
     * MySQL data source objects to avoid backfilling.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_excluded_objects = 2;</code>
     *
     * @return Whether the mysqlExcludedObjects field is set.
     */
    boolean hasMysqlExcludedObjects();
    /**
     *
     *
     * <pre>
     * MySQL data source objects to avoid backfilling.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_excluded_objects = 2;</code>
     *
     * @return The mysqlExcludedObjects.
     */
    com.google.cloud.datastream.v1alpha1.MysqlRdbms getMysqlExcludedObjects();
    /**
     *
     *
     * <pre>
     * MySQL data source objects to avoid backfilling.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_excluded_objects = 2;</code>
     */
    com.google.cloud.datastream.v1alpha1.MysqlRdbmsOrBuilder getMysqlExcludedObjectsOrBuilder();

    com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.ExcludedObjectsCase
        getExcludedObjectsCase();
  }
  /**
   *
   *
   * <pre>
   * Backfill strategy to automatically backfill the Stream's objects.
   * Specific objects can be excluded.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy}
   */
  public static final class BackfillAllStrategy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy)
      BackfillAllStrategyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BackfillAllStrategy.newBuilder() to construct.
    private BackfillAllStrategy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BackfillAllStrategy() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BackfillAllStrategy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1alpha1_Stream_BackfillAllStrategy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1alpha1_Stream_BackfillAllStrategy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.class,
              com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.Builder.class);
    }

    private int excludedObjectsCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object excludedObjects_;

    public enum ExcludedObjectsCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      ORACLE_EXCLUDED_OBJECTS(1),
      MYSQL_EXCLUDED_OBJECTS(2),
      EXCLUDEDOBJECTS_NOT_SET(0);
      private final int value;

      private ExcludedObjectsCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ExcludedObjectsCase valueOf(int value) {
        return forNumber(value);
      }

      public static ExcludedObjectsCase forNumber(int value) {
        switch (value) {
          case 1:
            return ORACLE_EXCLUDED_OBJECTS;
          case 2:
            return MYSQL_EXCLUDED_OBJECTS;
          case 0:
            return EXCLUDEDOBJECTS_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ExcludedObjectsCase getExcludedObjectsCase() {
      return ExcludedObjectsCase.forNumber(excludedObjectsCase_);
    }

    public static final int ORACLE_EXCLUDED_OBJECTS_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * Oracle data source objects to avoid backfilling.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_excluded_objects = 1;</code>
     *
     * @return Whether the oracleExcludedObjects field is set.
     */
    @java.lang.Override
    public boolean hasOracleExcludedObjects() {
      return excludedObjectsCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Oracle data source objects to avoid backfilling.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_excluded_objects = 1;</code>
     *
     * @return The oracleExcludedObjects.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.OracleRdbms getOracleExcludedObjects() {
      if (excludedObjectsCase_ == 1) {
        return (com.google.cloud.datastream.v1alpha1.OracleRdbms) excludedObjects_;
      }
      return com.google.cloud.datastream.v1alpha1.OracleRdbms.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Oracle data source objects to avoid backfilling.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_excluded_objects = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.OracleRdbmsOrBuilder
        getOracleExcludedObjectsOrBuilder() {
      if (excludedObjectsCase_ == 1) {
        return (com.google.cloud.datastream.v1alpha1.OracleRdbms) excludedObjects_;
      }
      return com.google.cloud.datastream.v1alpha1.OracleRdbms.getDefaultInstance();
    }

    public static final int MYSQL_EXCLUDED_OBJECTS_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * MySQL data source objects to avoid backfilling.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_excluded_objects = 2;</code>
     *
     * @return Whether the mysqlExcludedObjects field is set.
     */
    @java.lang.Override
    public boolean hasMysqlExcludedObjects() {
      return excludedObjectsCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * MySQL data source objects to avoid backfilling.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_excluded_objects = 2;</code>
     *
     * @return The mysqlExcludedObjects.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.MysqlRdbms getMysqlExcludedObjects() {
      if (excludedObjectsCase_ == 2) {
        return (com.google.cloud.datastream.v1alpha1.MysqlRdbms) excludedObjects_;
      }
      return com.google.cloud.datastream.v1alpha1.MysqlRdbms.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * MySQL data source objects to avoid backfilling.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_excluded_objects = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.MysqlRdbmsOrBuilder
        getMysqlExcludedObjectsOrBuilder() {
      if (excludedObjectsCase_ == 2) {
        return (com.google.cloud.datastream.v1alpha1.MysqlRdbms) excludedObjects_;
      }
      return com.google.cloud.datastream.v1alpha1.MysqlRdbms.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (excludedObjectsCase_ == 1) {
        output.writeMessage(1, (com.google.cloud.datastream.v1alpha1.OracleRdbms) excludedObjects_);
      }
      if (excludedObjectsCase_ == 2) {
        output.writeMessage(2, (com.google.cloud.datastream.v1alpha1.MysqlRdbms) excludedObjects_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (excludedObjectsCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.cloud.datastream.v1alpha1.OracleRdbms) excludedObjects_);
      }
      if (excludedObjectsCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, (com.google.cloud.datastream.v1alpha1.MysqlRdbms) excludedObjects_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy)) {
        return super.equals(obj);
      }
      com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy other =
          (com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy) obj;

      if (!getExcludedObjectsCase().equals(other.getExcludedObjectsCase())) return false;
      switch (excludedObjectsCase_) {
        case 1:
          if (!getOracleExcludedObjects().equals(other.getOracleExcludedObjects())) return false;
          break;
        case 2:
          if (!getMysqlExcludedObjects().equals(other.getMysqlExcludedObjects())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (excludedObjectsCase_) {
        case 1:
          hash = (37 * hash) + ORACLE_EXCLUDED_OBJECTS_FIELD_NUMBER;
          hash = (53 * hash) + getOracleExcludedObjects().hashCode();
          break;
        case 2:
          hash = (37 * hash) + MYSQL_EXCLUDED_OBJECTS_FIELD_NUMBER;
          hash = (53 * hash) + getMysqlExcludedObjects().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Backfill strategy to automatically backfill the Stream's objects.
     * Specific objects can be excluded.
     * </pre>
     *
     * Protobuf type {@code google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy)
        com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1alpha1_Stream_BackfillAllStrategy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1alpha1_Stream_BackfillAllStrategy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.class,
                com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.Builder.class);
      }

      // Construct using
      // com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (oracleExcludedObjectsBuilder_ != null) {
          oracleExcludedObjectsBuilder_.clear();
        }
        if (mysqlExcludedObjectsBuilder_ != null) {
          mysqlExcludedObjectsBuilder_.clear();
        }
        excludedObjectsCase_ = 0;
        excludedObjects_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1alpha1_Stream_BackfillAllStrategy_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy
          getDefaultInstanceForType() {
        return com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy build() {
        com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy buildPartial() {
        com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy result =
            new com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy result) {
        result.excludedObjectsCase_ = excludedObjectsCase_;
        result.excludedObjects_ = this.excludedObjects_;
        if (excludedObjectsCase_ == 1 && oracleExcludedObjectsBuilder_ != null) {
          result.excludedObjects_ = oracleExcludedObjectsBuilder_.build();
        }
        if (excludedObjectsCase_ == 2 && mysqlExcludedObjectsBuilder_ != null) {
          result.excludedObjects_ = mysqlExcludedObjectsBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy) {
          return mergeFrom((com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy other) {
        if (other
            == com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.getDefaultInstance())
          return this;
        switch (other.getExcludedObjectsCase()) {
          case ORACLE_EXCLUDED_OBJECTS:
            {
              mergeOracleExcludedObjects(other.getOracleExcludedObjects());
              break;
            }
          case MYSQL_EXCLUDED_OBJECTS:
            {
              mergeMysqlExcludedObjects(other.getMysqlExcludedObjects());
              break;
            }
          case EXCLUDEDOBJECTS_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getOracleExcludedObjectsFieldBuilder().getBuilder(), extensionRegistry);
                  excludedObjectsCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getMysqlExcludedObjectsFieldBuilder().getBuilder(), extensionRegistry);
                  excludedObjectsCase_ = 2;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int excludedObjectsCase_ = 0;
      private java.lang.Object excludedObjects_;

      public ExcludedObjectsCase getExcludedObjectsCase() {
        return ExcludedObjectsCase.forNumber(excludedObjectsCase_);
      }

      public Builder clearExcludedObjects() {
        excludedObjectsCase_ = 0;
        excludedObjects_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.datastream.v1alpha1.OracleRdbms,
              com.google.cloud.datastream.v1alpha1.OracleRdbms.Builder,
              com.google.cloud.datastream.v1alpha1.OracleRdbmsOrBuilder>
          oracleExcludedObjectsBuilder_;
      /**
       *
       *
       * <pre>
       * Oracle data source objects to avoid backfilling.
       * </pre>
       *
       * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_excluded_objects = 1;</code>
       *
       * @return Whether the oracleExcludedObjects field is set.
       */
      @java.lang.Override
      public boolean hasOracleExcludedObjects() {
        return excludedObjectsCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * Oracle data source objects to avoid backfilling.
       * </pre>
       *
       * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_excluded_objects = 1;</code>
       *
       * @return The oracleExcludedObjects.
       */
      @java.lang.Override
      public com.google.cloud.datastream.v1alpha1.OracleRdbms getOracleExcludedObjects() {
        if (oracleExcludedObjectsBuilder_ == null) {
          if (excludedObjectsCase_ == 1) {
            return (com.google.cloud.datastream.v1alpha1.OracleRdbms) excludedObjects_;
          }
          return com.google.cloud.datastream.v1alpha1.OracleRdbms.getDefaultInstance();
        } else {
          if (excludedObjectsCase_ == 1) {
            return oracleExcludedObjectsBuilder_.getMessage();
          }
          return com.google.cloud.datastream.v1alpha1.OracleRdbms.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Oracle data source objects to avoid backfilling.
       * </pre>
       *
       * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_excluded_objects = 1;</code>
       */
      public Builder setOracleExcludedObjects(
          com.google.cloud.datastream.v1alpha1.OracleRdbms value) {
        if (oracleExcludedObjectsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          excludedObjects_ = value;
          onChanged();
        } else {
          oracleExcludedObjectsBuilder_.setMessage(value);
        }
        excludedObjectsCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Oracle data source objects to avoid backfilling.
       * </pre>
       *
       * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_excluded_objects = 1;</code>
       */
      public Builder setOracleExcludedObjects(
          com.google.cloud.datastream.v1alpha1.OracleRdbms.Builder builderForValue) {
        if (oracleExcludedObjectsBuilder_ == null) {
          excludedObjects_ = builderForValue.build();
          onChanged();
        } else {
          oracleExcludedObjectsBuilder_.setMessage(builderForValue.build());
        }
        excludedObjectsCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Oracle data source objects to avoid backfilling.
       * </pre>
       *
       * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_excluded_objects = 1;</code>
       */
      public Builder mergeOracleExcludedObjects(
          com.google.cloud.datastream.v1alpha1.OracleRdbms value) {
        if (oracleExcludedObjectsBuilder_ == null) {
          if (excludedObjectsCase_ == 1
              && excludedObjects_
                  != com.google.cloud.datastream.v1alpha1.OracleRdbms.getDefaultInstance()) {
            excludedObjects_ =
                com.google.cloud.datastream.v1alpha1.OracleRdbms.newBuilder(
                        (com.google.cloud.datastream.v1alpha1.OracleRdbms) excludedObjects_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            excludedObjects_ = value;
          }
          onChanged();
        } else {
          if (excludedObjectsCase_ == 1) {
            oracleExcludedObjectsBuilder_.mergeFrom(value);
          } else {
            oracleExcludedObjectsBuilder_.setMessage(value);
          }
        }
        excludedObjectsCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Oracle data source objects to avoid backfilling.
       * </pre>
       *
       * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_excluded_objects = 1;</code>
       */
      public Builder clearOracleExcludedObjects() {
        if (oracleExcludedObjectsBuilder_ == null) {
          if (excludedObjectsCase_ == 1) {
            excludedObjectsCase_ = 0;
            excludedObjects_ = null;
            onChanged();
          }
        } else {
          if (excludedObjectsCase_ == 1) {
            excludedObjectsCase_ = 0;
            excludedObjects_ = null;
          }
          oracleExcludedObjectsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Oracle data source objects to avoid backfilling.
       * </pre>
       *
       * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_excluded_objects = 1;</code>
       */
      public com.google.cloud.datastream.v1alpha1.OracleRdbms.Builder
          getOracleExcludedObjectsBuilder() {
        return getOracleExcludedObjectsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Oracle data source objects to avoid backfilling.
       * </pre>
       *
       * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_excluded_objects = 1;</code>
       */
      @java.lang.Override
      public com.google.cloud.datastream.v1alpha1.OracleRdbmsOrBuilder
          getOracleExcludedObjectsOrBuilder() {
        if ((excludedObjectsCase_ == 1) && (oracleExcludedObjectsBuilder_ != null)) {
          return oracleExcludedObjectsBuilder_.getMessageOrBuilder();
        } else {
          if (excludedObjectsCase_ == 1) {
            return (com.google.cloud.datastream.v1alpha1.OracleRdbms) excludedObjects_;
          }
          return com.google.cloud.datastream.v1alpha1.OracleRdbms.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Oracle data source objects to avoid backfilling.
       * </pre>
       *
       * <code>.google.cloud.datastream.v1alpha1.OracleRdbms oracle_excluded_objects = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.datastream.v1alpha1.OracleRdbms,
              com.google.cloud.datastream.v1alpha1.OracleRdbms.Builder,
              com.google.cloud.datastream.v1alpha1.OracleRdbmsOrBuilder>
          getOracleExcludedObjectsFieldBuilder() {
        if (oracleExcludedObjectsBuilder_ == null) {
          if (!(excludedObjectsCase_ == 1)) {
            excludedObjects_ =
                com.google.cloud.datastream.v1alpha1.OracleRdbms.getDefaultInstance();
          }
          oracleExcludedObjectsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.datastream.v1alpha1.OracleRdbms,
                  com.google.cloud.datastream.v1alpha1.OracleRdbms.Builder,
                  com.google.cloud.datastream.v1alpha1.OracleRdbmsOrBuilder>(
                  (com.google.cloud.datastream.v1alpha1.OracleRdbms) excludedObjects_,
                  getParentForChildren(),
                  isClean());
          excludedObjects_ = null;
        }
        excludedObjectsCase_ = 1;
        onChanged();
        return oracleExcludedObjectsBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.datastream.v1alpha1.MysqlRdbms,
              com.google.cloud.datastream.v1alpha1.MysqlRdbms.Builder,
              com.google.cloud.datastream.v1alpha1.MysqlRdbmsOrBuilder>
          mysqlExcludedObjectsBuilder_;
      /**
       *
       *
       * <pre>
       * MySQL data source objects to avoid backfilling.
       * </pre>
       *
       * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_excluded_objects = 2;</code>
       *
       * @return Whether the mysqlExcludedObjects field is set.
       */
      @java.lang.Override
      public boolean hasMysqlExcludedObjects() {
        return excludedObjectsCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * MySQL data source objects to avoid backfilling.
       * </pre>
       *
       * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_excluded_objects = 2;</code>
       *
       * @return The mysqlExcludedObjects.
       */
      @java.lang.Override
      public com.google.cloud.datastream.v1alpha1.MysqlRdbms getMysqlExcludedObjects() {
        if (mysqlExcludedObjectsBuilder_ == null) {
          if (excludedObjectsCase_ == 2) {
            return (com.google.cloud.datastream.v1alpha1.MysqlRdbms) excludedObjects_;
          }
          return com.google.cloud.datastream.v1alpha1.MysqlRdbms.getDefaultInstance();
        } else {
          if (excludedObjectsCase_ == 2) {
            return mysqlExcludedObjectsBuilder_.getMessage();
          }
          return com.google.cloud.datastream.v1alpha1.MysqlRdbms.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * MySQL data source objects to avoid backfilling.
       * </pre>
       *
       * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_excluded_objects = 2;</code>
       */
      public Builder setMysqlExcludedObjects(
          com.google.cloud.datastream.v1alpha1.MysqlRdbms value) {
        if (mysqlExcludedObjectsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          excludedObjects_ = value;
          onChanged();
        } else {
          mysqlExcludedObjectsBuilder_.setMessage(value);
        }
        excludedObjectsCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * MySQL data source objects to avoid backfilling.
       * </pre>
       *
       * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_excluded_objects = 2;</code>
       */
      public Builder setMysqlExcludedObjects(
          com.google.cloud.datastream.v1alpha1.MysqlRdbms.Builder builderForValue) {
        if (mysqlExcludedObjectsBuilder_ == null) {
          excludedObjects_ = builderForValue.build();
          onChanged();
        } else {
          mysqlExcludedObjectsBuilder_.setMessage(builderForValue.build());
        }
        excludedObjectsCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * MySQL data source objects to avoid backfilling.
       * </pre>
       *
       * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_excluded_objects = 2;</code>
       */
      public Builder mergeMysqlExcludedObjects(
          com.google.cloud.datastream.v1alpha1.MysqlRdbms value) {
        if (mysqlExcludedObjectsBuilder_ == null) {
          if (excludedObjectsCase_ == 2
              && excludedObjects_
                  != com.google.cloud.datastream.v1alpha1.MysqlRdbms.getDefaultInstance()) {
            excludedObjects_ =
                com.google.cloud.datastream.v1alpha1.MysqlRdbms.newBuilder(
                        (com.google.cloud.datastream.v1alpha1.MysqlRdbms) excludedObjects_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            excludedObjects_ = value;
          }
          onChanged();
        } else {
          if (excludedObjectsCase_ == 2) {
            mysqlExcludedObjectsBuilder_.mergeFrom(value);
          } else {
            mysqlExcludedObjectsBuilder_.setMessage(value);
          }
        }
        excludedObjectsCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * MySQL data source objects to avoid backfilling.
       * </pre>
       *
       * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_excluded_objects = 2;</code>
       */
      public Builder clearMysqlExcludedObjects() {
        if (mysqlExcludedObjectsBuilder_ == null) {
          if (excludedObjectsCase_ == 2) {
            excludedObjectsCase_ = 0;
            excludedObjects_ = null;
            onChanged();
          }
        } else {
          if (excludedObjectsCase_ == 2) {
            excludedObjectsCase_ = 0;
            excludedObjects_ = null;
          }
          mysqlExcludedObjectsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * MySQL data source objects to avoid backfilling.
       * </pre>
       *
       * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_excluded_objects = 2;</code>
       */
      public com.google.cloud.datastream.v1alpha1.MysqlRdbms.Builder
          getMysqlExcludedObjectsBuilder() {
        return getMysqlExcludedObjectsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * MySQL data source objects to avoid backfilling.
       * </pre>
       *
       * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_excluded_objects = 2;</code>
       */
      @java.lang.Override
      public com.google.cloud.datastream.v1alpha1.MysqlRdbmsOrBuilder
          getMysqlExcludedObjectsOrBuilder() {
        if ((excludedObjectsCase_ == 2) && (mysqlExcludedObjectsBuilder_ != null)) {
          return mysqlExcludedObjectsBuilder_.getMessageOrBuilder();
        } else {
          if (excludedObjectsCase_ == 2) {
            return (com.google.cloud.datastream.v1alpha1.MysqlRdbms) excludedObjects_;
          }
          return com.google.cloud.datastream.v1alpha1.MysqlRdbms.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * MySQL data source objects to avoid backfilling.
       * </pre>
       *
       * <code>.google.cloud.datastream.v1alpha1.MysqlRdbms mysql_excluded_objects = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.datastream.v1alpha1.MysqlRdbms,
              com.google.cloud.datastream.v1alpha1.MysqlRdbms.Builder,
              com.google.cloud.datastream.v1alpha1.MysqlRdbmsOrBuilder>
          getMysqlExcludedObjectsFieldBuilder() {
        if (mysqlExcludedObjectsBuilder_ == null) {
          if (!(excludedObjectsCase_ == 2)) {
            excludedObjects_ = com.google.cloud.datastream.v1alpha1.MysqlRdbms.getDefaultInstance();
          }
          mysqlExcludedObjectsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.datastream.v1alpha1.MysqlRdbms,
                  com.google.cloud.datastream.v1alpha1.MysqlRdbms.Builder,
                  com.google.cloud.datastream.v1alpha1.MysqlRdbmsOrBuilder>(
                  (com.google.cloud.datastream.v1alpha1.MysqlRdbms) excludedObjects_,
                  getParentForChildren(),
                  isClean());
          excludedObjects_ = null;
        }
        excludedObjectsCase_ = 2;
        onChanged();
        return mysqlExcludedObjectsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy)
    private static final com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy();
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BackfillAllStrategy> PARSER =
        new com.google.protobuf.AbstractParser<BackfillAllStrategy>() {
          @java.lang.Override
          public BackfillAllStrategy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BackfillAllStrategy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BackfillAllStrategy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface BackfillNoneStrategyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Backfill strategy to disable automatic backfill for the Stream's objects.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy}
   */
  public static final class BackfillNoneStrategy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy)
      BackfillNoneStrategyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use BackfillNoneStrategy.newBuilder() to construct.
    private BackfillNoneStrategy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private BackfillNoneStrategy() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new BackfillNoneStrategy();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1alpha1_Stream_BackfillNoneStrategy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1alpha1_Stream_BackfillNoneStrategy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy.class,
              com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy)) {
        return super.equals(obj);
      }
      com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy other =
          (com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Backfill strategy to disable automatic backfill for the Stream's objects.
     * </pre>
     *
     * Protobuf type {@code google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy)
        com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1alpha1_Stream_BackfillNoneStrategy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1alpha1_Stream_BackfillNoneStrategy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy.class,
                com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy.Builder.class);
      }

      // Construct using
      // com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
            .internal_static_google_cloud_datastream_v1alpha1_Stream_BackfillNoneStrategy_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy
          getDefaultInstanceForType() {
        return com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy build() {
        com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy buildPartial() {
        com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy result =
            new com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy) {
          return mergeFrom(
              (com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy other) {
        if (other
            == com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy
                .getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy)
    private static final com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy();
    }

    public static com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BackfillNoneStrategy> PARSER =
        new com.google.protobuf.AbstractParser<BackfillNoneStrategy>() {
          @java.lang.Override
          public BackfillNoneStrategy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<BackfillNoneStrategy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BackfillNoneStrategy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int backfillStrategyCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object backfillStrategy_;

  public enum BackfillStrategyCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BACKFILL_ALL(101),
    BACKFILL_NONE(102),
    BACKFILLSTRATEGY_NOT_SET(0);
    private final int value;

    private BackfillStrategyCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BackfillStrategyCase valueOf(int value) {
      return forNumber(value);
    }

    public static BackfillStrategyCase forNumber(int value) {
      switch (value) {
        case 101:
          return BACKFILL_ALL;
        case 102:
          return BACKFILL_NONE;
        case 0:
          return BACKFILLSTRATEGY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public BackfillStrategyCase getBackfillStrategyCase() {
    return BackfillStrategyCase.forNumber(backfillStrategyCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The stream's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The stream's name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The creation time of the stream.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation time of the stream.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The creation time of the stream.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last update time of the stream.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update time of the stream.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update time of the stream.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 4;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
                .internal_static_google_cloud_datastream_v1alpha1_Stream_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. Display name.
   * </pre>
   *
   * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Display name.
   * </pre>
   *
   * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.datastream.v1alpha1.SourceConfig sourceConfig_;
  /**
   *
   *
   * <pre>
   * Required. Source connection profile configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1alpha1.SourceConfig source_config = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the sourceConfig field is set.
   */
  @java.lang.Override
  public boolean hasSourceConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Source connection profile configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1alpha1.SourceConfig source_config = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The sourceConfig.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.SourceConfig getSourceConfig() {
    return sourceConfig_ == null
        ? com.google.cloud.datastream.v1alpha1.SourceConfig.getDefaultInstance()
        : sourceConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. Source connection profile configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1alpha1.SourceConfig source_config = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.SourceConfigOrBuilder getSourceConfigOrBuilder() {
    return sourceConfig_ == null
        ? com.google.cloud.datastream.v1alpha1.SourceConfig.getDefaultInstance()
        : sourceConfig_;
  }

  public static final int DESTINATION_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.datastream.v1alpha1.DestinationConfig destinationConfig_;
  /**
   *
   *
   * <pre>
   * Required. Destination connection profile configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1alpha1.DestinationConfig destination_config = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the destinationConfig field is set.
   */
  @java.lang.Override
  public boolean hasDestinationConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Destination connection profile configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1alpha1.DestinationConfig destination_config = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The destinationConfig.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.DestinationConfig getDestinationConfig() {
    return destinationConfig_ == null
        ? com.google.cloud.datastream.v1alpha1.DestinationConfig.getDefaultInstance()
        : destinationConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. Destination connection profile configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.datastream.v1alpha1.DestinationConfig destination_config = 7 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.DestinationConfigOrBuilder
      getDestinationConfigOrBuilder() {
    return destinationConfig_ == null
        ? com.google.cloud.datastream.v1alpha1.DestinationConfig.getDefaultInstance()
        : destinationConfig_;
  }

  public static final int STATE_FIELD_NUMBER = 8;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * The state of the stream.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.Stream.State state = 8;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * The state of the stream.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.Stream.State state = 8;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.Stream.State getState() {
    com.google.cloud.datastream.v1alpha1.Stream.State result =
        com.google.cloud.datastream.v1alpha1.Stream.State.forNumber(state_);
    return result == null ? com.google.cloud.datastream.v1alpha1.Stream.State.UNRECOGNIZED : result;
  }

  public static final int BACKFILL_ALL_FIELD_NUMBER = 101;
  /**
   *
   *
   * <pre>
   * Automatically backfill objects included in the stream source
   * configuration. Specific objects can be excluded.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy backfill_all = 101;</code>
   *
   * @return Whether the backfillAll field is set.
   */
  @java.lang.Override
  public boolean hasBackfillAll() {
    return backfillStrategyCase_ == 101;
  }
  /**
   *
   *
   * <pre>
   * Automatically backfill objects included in the stream source
   * configuration. Specific objects can be excluded.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy backfill_all = 101;</code>
   *
   * @return The backfillAll.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy getBackfillAll() {
    if (backfillStrategyCase_ == 101) {
      return (com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy) backfillStrategy_;
    }
    return com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Automatically backfill objects included in the stream source
   * configuration. Specific objects can be excluded.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy backfill_all = 101;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategyOrBuilder
      getBackfillAllOrBuilder() {
    if (backfillStrategyCase_ == 101) {
      return (com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy) backfillStrategy_;
    }
    return com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.getDefaultInstance();
  }

  public static final int BACKFILL_NONE_FIELD_NUMBER = 102;
  /**
   *
   *
   * <pre>
   * Do not automatically backfill any objects.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy backfill_none = 102;</code>
   *
   * @return Whether the backfillNone field is set.
   */
  @java.lang.Override
  public boolean hasBackfillNone() {
    return backfillStrategyCase_ == 102;
  }
  /**
   *
   *
   * <pre>
   * Do not automatically backfill any objects.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy backfill_none = 102;</code>
   *
   * @return The backfillNone.
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy getBackfillNone() {
    if (backfillStrategyCase_ == 102) {
      return (com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy) backfillStrategy_;
    }
    return com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Do not automatically backfill any objects.
   * </pre>
   *
   * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy backfill_none = 102;</code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategyOrBuilder
      getBackfillNoneOrBuilder() {
    if (backfillStrategyCase_ == 102) {
      return (com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy) backfillStrategy_;
    }
    return com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy.getDefaultInstance();
  }

  public static final int ERRORS_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.datastream.v1alpha1.Error> errors_;
  /**
   *
   *
   * <pre>
   * Output only. Errors on the Stream.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datastream.v1alpha1.Error> getErrorsList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors on the Stream.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.datastream.v1alpha1.ErrorOrBuilder>
      getErrorsOrBuilderList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors on the Stream.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getErrorsCount() {
    return errors_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors on the Stream.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.Error getErrors(int index) {
    return errors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Errors on the Stream.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.ErrorOrBuilder getErrorsOrBuilder(int index) {
    return errors_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 4);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, displayName_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(6, getSourceConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(7, getDestinationConfig());
    }
    if (state_ != com.google.cloud.datastream.v1alpha1.Stream.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(8, state_);
    }
    for (int i = 0; i < errors_.size(); i++) {
      output.writeMessage(9, errors_.get(i));
    }
    if (backfillStrategyCase_ == 101) {
      output.writeMessage(
          101, (com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy) backfillStrategy_);
    }
    if (backfillStrategyCase_ == 102) {
      output.writeMessage(
          102,
          (com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy) backfillStrategy_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, displayName_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getSourceConfig());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getDestinationConfig());
    }
    if (state_ != com.google.cloud.datastream.v1alpha1.Stream.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, state_);
    }
    for (int i = 0; i < errors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, errors_.get(i));
    }
    if (backfillStrategyCase_ == 101) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              101,
              (com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy) backfillStrategy_);
    }
    if (backfillStrategyCase_ == 102) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              102,
              (com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy) backfillStrategy_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datastream.v1alpha1.Stream)) {
      return super.equals(obj);
    }
    com.google.cloud.datastream.v1alpha1.Stream other =
        (com.google.cloud.datastream.v1alpha1.Stream) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasSourceConfig() != other.hasSourceConfig()) return false;
    if (hasSourceConfig()) {
      if (!getSourceConfig().equals(other.getSourceConfig())) return false;
    }
    if (hasDestinationConfig() != other.hasDestinationConfig()) return false;
    if (hasDestinationConfig()) {
      if (!getDestinationConfig().equals(other.getDestinationConfig())) return false;
    }
    if (state_ != other.state_) return false;
    if (!getErrorsList().equals(other.getErrorsList())) return false;
    if (!getBackfillStrategyCase().equals(other.getBackfillStrategyCase())) return false;
    switch (backfillStrategyCase_) {
      case 101:
        if (!getBackfillAll().equals(other.getBackfillAll())) return false;
        break;
      case 102:
        if (!getBackfillNone().equals(other.getBackfillNone())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasSourceConfig()) {
      hash = (37 * hash) + SOURCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getSourceConfig().hashCode();
    }
    if (hasDestinationConfig()) {
      hash = (37 * hash) + DESTINATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDestinationConfig().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (getErrorsCount() > 0) {
      hash = (37 * hash) + ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getErrorsList().hashCode();
    }
    switch (backfillStrategyCase_) {
      case 101:
        hash = (37 * hash) + BACKFILL_ALL_FIELD_NUMBER;
        hash = (53 * hash) + getBackfillAll().hashCode();
        break;
      case 102:
        hash = (37 * hash) + BACKFILL_NONE_FIELD_NUMBER;
        hash = (53 * hash) + getBackfillNone().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datastream.v1alpha1.Stream parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1alpha1.Stream parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1alpha1.Stream parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1alpha1.Stream parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1alpha1.Stream parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datastream.v1alpha1.Stream parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1alpha1.Stream parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1alpha1.Stream parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1alpha1.Stream parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1alpha1.Stream parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datastream.v1alpha1.Stream parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datastream.v1alpha1.Stream parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datastream.v1alpha1.Stream prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /** Protobuf type {@code google.cloud.datastream.v1alpha1.Stream} */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datastream.v1alpha1.Stream)
      com.google.cloud.datastream.v1alpha1.StreamOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1alpha1_Stream_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1alpha1_Stream_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datastream.v1alpha1.Stream.class,
              com.google.cloud.datastream.v1alpha1.Stream.Builder.class);
    }

    // Construct using com.google.cloud.datastream.v1alpha1.Stream.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getSourceConfigFieldBuilder();
        getDestinationConfigFieldBuilder();
        getErrorsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      displayName_ = "";
      sourceConfig_ = null;
      if (sourceConfigBuilder_ != null) {
        sourceConfigBuilder_.dispose();
        sourceConfigBuilder_ = null;
      }
      destinationConfig_ = null;
      if (destinationConfigBuilder_ != null) {
        destinationConfigBuilder_.dispose();
        destinationConfigBuilder_ = null;
      }
      state_ = 0;
      if (backfillAllBuilder_ != null) {
        backfillAllBuilder_.clear();
      }
      if (backfillNoneBuilder_ != null) {
        backfillNoneBuilder_.clear();
      }
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
      } else {
        errors_ = null;
        errorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      backfillStrategyCase_ = 0;
      backfillStrategy_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datastream.v1alpha1.CloudDatastreamResourcesProto
          .internal_static_google_cloud_datastream_v1alpha1_Stream_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.Stream getDefaultInstanceForType() {
      return com.google.cloud.datastream.v1alpha1.Stream.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.Stream build() {
      com.google.cloud.datastream.v1alpha1.Stream result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.Stream buildPartial() {
      com.google.cloud.datastream.v1alpha1.Stream result =
          new com.google.cloud.datastream.v1alpha1.Stream(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.datastream.v1alpha1.Stream result) {
      if (errorsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          errors_ = java.util.Collections.unmodifiableList(errors_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.errors_ = errors_;
      } else {
        result.errors_ = errorsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.datastream.v1alpha1.Stream result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.sourceConfig_ =
            sourceConfigBuilder_ == null ? sourceConfig_ : sourceConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.destinationConfig_ =
            destinationConfigBuilder_ == null
                ? destinationConfig_
                : destinationConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.state_ = state_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.datastream.v1alpha1.Stream result) {
      result.backfillStrategyCase_ = backfillStrategyCase_;
      result.backfillStrategy_ = this.backfillStrategy_;
      if (backfillStrategyCase_ == 101 && backfillAllBuilder_ != null) {
        result.backfillStrategy_ = backfillAllBuilder_.build();
      }
      if (backfillStrategyCase_ == 102 && backfillNoneBuilder_ != null) {
        result.backfillStrategy_ = backfillNoneBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datastream.v1alpha1.Stream) {
        return mergeFrom((com.google.cloud.datastream.v1alpha1.Stream) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datastream.v1alpha1.Stream other) {
      if (other == com.google.cloud.datastream.v1alpha1.Stream.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000008;
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasSourceConfig()) {
        mergeSourceConfig(other.getSourceConfig());
      }
      if (other.hasDestinationConfig()) {
        mergeDestinationConfig(other.getDestinationConfig());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (errorsBuilder_ == null) {
        if (!other.errors_.isEmpty()) {
          if (errors_.isEmpty()) {
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureErrorsIsMutable();
            errors_.addAll(other.errors_);
          }
          onChanged();
        }
      } else {
        if (!other.errors_.isEmpty()) {
          if (errorsBuilder_.isEmpty()) {
            errorsBuilder_.dispose();
            errorsBuilder_ = null;
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000400);
            errorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getErrorsFieldBuilder()
                    : null;
          } else {
            errorsBuilder_.addAllMessages(other.errors_);
          }
        }
      }
      switch (other.getBackfillStrategyCase()) {
        case BACKFILL_ALL:
          {
            mergeBackfillAll(other.getBackfillAll());
            break;
          }
        case BACKFILL_NONE:
          {
            mergeBackfillNone(other.getBackfillNone());
            break;
          }
        case BACKFILLSTRATEGY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getSourceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getDestinationConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 74:
              {
                com.google.cloud.datastream.v1alpha1.Error m =
                    input.readMessage(
                        com.google.cloud.datastream.v1alpha1.Error.parser(), extensionRegistry);
                if (errorsBuilder_ == null) {
                  ensureErrorsIsMutable();
                  errors_.add(m);
                } else {
                  errorsBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 810:
              {
                input.readMessage(getBackfillAllFieldBuilder().getBuilder(), extensionRegistry);
                backfillStrategyCase_ = 101;
                break;
              } // case 810
            case 818:
              {
                input.readMessage(getBackfillNoneFieldBuilder().getBuilder(), extensionRegistry);
                backfillStrategyCase_ = 102;
                break;
              } // case 818
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int backfillStrategyCase_ = 0;
    private java.lang.Object backfillStrategy_;

    public BackfillStrategyCase getBackfillStrategyCase() {
      return BackfillStrategyCase.forNumber(backfillStrategyCase_);
    }

    public Builder clearBackfillStrategy() {
      backfillStrategyCase_ = 0;
      backfillStrategy_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The stream's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The stream's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The stream's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The stream's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The stream's name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The creation time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last update time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update time of the stream.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000008;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. Display name.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Display name.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Display name.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Display name.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Display name.
     * </pre>
     *
     * <code>string display_name = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.cloud.datastream.v1alpha1.SourceConfig sourceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.SourceConfig,
            com.google.cloud.datastream.v1alpha1.SourceConfig.Builder,
            com.google.cloud.datastream.v1alpha1.SourceConfigOrBuilder>
        sourceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Source connection profile configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.SourceConfig source_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the sourceConfig field is set.
     */
    public boolean hasSourceConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Source connection profile configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.SourceConfig source_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The sourceConfig.
     */
    public com.google.cloud.datastream.v1alpha1.SourceConfig getSourceConfig() {
      if (sourceConfigBuilder_ == null) {
        return sourceConfig_ == null
            ? com.google.cloud.datastream.v1alpha1.SourceConfig.getDefaultInstance()
            : sourceConfig_;
      } else {
        return sourceConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Source connection profile configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.SourceConfig source_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setSourceConfig(com.google.cloud.datastream.v1alpha1.SourceConfig value) {
      if (sourceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceConfig_ = value;
      } else {
        sourceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Source connection profile configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.SourceConfig source_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setSourceConfig(
        com.google.cloud.datastream.v1alpha1.SourceConfig.Builder builderForValue) {
      if (sourceConfigBuilder_ == null) {
        sourceConfig_ = builderForValue.build();
      } else {
        sourceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Source connection profile configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.SourceConfig source_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeSourceConfig(com.google.cloud.datastream.v1alpha1.SourceConfig value) {
      if (sourceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && sourceConfig_ != null
            && sourceConfig_
                != com.google.cloud.datastream.v1alpha1.SourceConfig.getDefaultInstance()) {
          getSourceConfigBuilder().mergeFrom(value);
        } else {
          sourceConfig_ = value;
        }
      } else {
        sourceConfigBuilder_.mergeFrom(value);
      }
      if (sourceConfig_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Source connection profile configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.SourceConfig source_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearSourceConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      sourceConfig_ = null;
      if (sourceConfigBuilder_ != null) {
        sourceConfigBuilder_.dispose();
        sourceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Source connection profile configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.SourceConfig source_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datastream.v1alpha1.SourceConfig.Builder getSourceConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getSourceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Source connection profile configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.SourceConfig source_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datastream.v1alpha1.SourceConfigOrBuilder getSourceConfigOrBuilder() {
      if (sourceConfigBuilder_ != null) {
        return sourceConfigBuilder_.getMessageOrBuilder();
      } else {
        return sourceConfig_ == null
            ? com.google.cloud.datastream.v1alpha1.SourceConfig.getDefaultInstance()
            : sourceConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Source connection profile configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.SourceConfig source_config = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.SourceConfig,
            com.google.cloud.datastream.v1alpha1.SourceConfig.Builder,
            com.google.cloud.datastream.v1alpha1.SourceConfigOrBuilder>
        getSourceConfigFieldBuilder() {
      if (sourceConfigBuilder_ == null) {
        sourceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1alpha1.SourceConfig,
                com.google.cloud.datastream.v1alpha1.SourceConfig.Builder,
                com.google.cloud.datastream.v1alpha1.SourceConfigOrBuilder>(
                getSourceConfig(), getParentForChildren(), isClean());
        sourceConfig_ = null;
      }
      return sourceConfigBuilder_;
    }

    private com.google.cloud.datastream.v1alpha1.DestinationConfig destinationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.DestinationConfig,
            com.google.cloud.datastream.v1alpha1.DestinationConfig.Builder,
            com.google.cloud.datastream.v1alpha1.DestinationConfigOrBuilder>
        destinationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Destination connection profile configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.DestinationConfig destination_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the destinationConfig field is set.
     */
    public boolean hasDestinationConfig() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Destination connection profile configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.DestinationConfig destination_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The destinationConfig.
     */
    public com.google.cloud.datastream.v1alpha1.DestinationConfig getDestinationConfig() {
      if (destinationConfigBuilder_ == null) {
        return destinationConfig_ == null
            ? com.google.cloud.datastream.v1alpha1.DestinationConfig.getDefaultInstance()
            : destinationConfig_;
      } else {
        return destinationConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Destination connection profile configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.DestinationConfig destination_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDestinationConfig(
        com.google.cloud.datastream.v1alpha1.DestinationConfig value) {
      if (destinationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destinationConfig_ = value;
      } else {
        destinationConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Destination connection profile configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.DestinationConfig destination_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setDestinationConfig(
        com.google.cloud.datastream.v1alpha1.DestinationConfig.Builder builderForValue) {
      if (destinationConfigBuilder_ == null) {
        destinationConfig_ = builderForValue.build();
      } else {
        destinationConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Destination connection profile configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.DestinationConfig destination_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeDestinationConfig(
        com.google.cloud.datastream.v1alpha1.DestinationConfig value) {
      if (destinationConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && destinationConfig_ != null
            && destinationConfig_
                != com.google.cloud.datastream.v1alpha1.DestinationConfig.getDefaultInstance()) {
          getDestinationConfigBuilder().mergeFrom(value);
        } else {
          destinationConfig_ = value;
        }
      } else {
        destinationConfigBuilder_.mergeFrom(value);
      }
      if (destinationConfig_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Destination connection profile configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.DestinationConfig destination_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearDestinationConfig() {
      bitField0_ = (bitField0_ & ~0x00000040);
      destinationConfig_ = null;
      if (destinationConfigBuilder_ != null) {
        destinationConfigBuilder_.dispose();
        destinationConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Destination connection profile configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.DestinationConfig destination_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datastream.v1alpha1.DestinationConfig.Builder
        getDestinationConfigBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getDestinationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Destination connection profile configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.DestinationConfig destination_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datastream.v1alpha1.DestinationConfigOrBuilder
        getDestinationConfigOrBuilder() {
      if (destinationConfigBuilder_ != null) {
        return destinationConfigBuilder_.getMessageOrBuilder();
      } else {
        return destinationConfig_ == null
            ? com.google.cloud.datastream.v1alpha1.DestinationConfig.getDefaultInstance()
            : destinationConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Destination connection profile configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.datastream.v1alpha1.DestinationConfig destination_config = 7 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.DestinationConfig,
            com.google.cloud.datastream.v1alpha1.DestinationConfig.Builder,
            com.google.cloud.datastream.v1alpha1.DestinationConfigOrBuilder>
        getDestinationConfigFieldBuilder() {
      if (destinationConfigBuilder_ == null) {
        destinationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1alpha1.DestinationConfig,
                com.google.cloud.datastream.v1alpha1.DestinationConfig.Builder,
                com.google.cloud.datastream.v1alpha1.DestinationConfigOrBuilder>(
                getDestinationConfig(), getParentForChildren(), isClean());
        destinationConfig_ = null;
      }
      return destinationConfigBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * The state of the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.State state = 8;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * The state of the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.State state = 8;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.State state = 8;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.Stream.State getState() {
      com.google.cloud.datastream.v1alpha1.Stream.State result =
          com.google.cloud.datastream.v1alpha1.Stream.State.forNumber(state_);
      return result == null
          ? com.google.cloud.datastream.v1alpha1.Stream.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The state of the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.State state = 8;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.datastream.v1alpha1.Stream.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of the stream.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.State state = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000080);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy,
            com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.Builder,
            com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategyOrBuilder>
        backfillAllBuilder_;
    /**
     *
     *
     * <pre>
     * Automatically backfill objects included in the stream source
     * configuration. Specific objects can be excluded.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy backfill_all = 101;</code>
     *
     * @return Whether the backfillAll field is set.
     */
    @java.lang.Override
    public boolean hasBackfillAll() {
      return backfillStrategyCase_ == 101;
    }
    /**
     *
     *
     * <pre>
     * Automatically backfill objects included in the stream source
     * configuration. Specific objects can be excluded.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy backfill_all = 101;</code>
     *
     * @return The backfillAll.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy getBackfillAll() {
      if (backfillAllBuilder_ == null) {
        if (backfillStrategyCase_ == 101) {
          return (com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy)
              backfillStrategy_;
        }
        return com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.getDefaultInstance();
      } else {
        if (backfillStrategyCase_ == 101) {
          return backfillAllBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Automatically backfill objects included in the stream source
     * configuration. Specific objects can be excluded.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy backfill_all = 101;</code>
     */
    public Builder setBackfillAll(
        com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy value) {
      if (backfillAllBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        backfillStrategy_ = value;
        onChanged();
      } else {
        backfillAllBuilder_.setMessage(value);
      }
      backfillStrategyCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Automatically backfill objects included in the stream source
     * configuration. Specific objects can be excluded.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy backfill_all = 101;</code>
     */
    public Builder setBackfillAll(
        com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.Builder builderForValue) {
      if (backfillAllBuilder_ == null) {
        backfillStrategy_ = builderForValue.build();
        onChanged();
      } else {
        backfillAllBuilder_.setMessage(builderForValue.build());
      }
      backfillStrategyCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Automatically backfill objects included in the stream source
     * configuration. Specific objects can be excluded.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy backfill_all = 101;</code>
     */
    public Builder mergeBackfillAll(
        com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy value) {
      if (backfillAllBuilder_ == null) {
        if (backfillStrategyCase_ == 101
            && backfillStrategy_
                != com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy
                    .getDefaultInstance()) {
          backfillStrategy_ =
              com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.newBuilder(
                      (com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy)
                          backfillStrategy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          backfillStrategy_ = value;
        }
        onChanged();
      } else {
        if (backfillStrategyCase_ == 101) {
          backfillAllBuilder_.mergeFrom(value);
        } else {
          backfillAllBuilder_.setMessage(value);
        }
      }
      backfillStrategyCase_ = 101;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Automatically backfill objects included in the stream source
     * configuration. Specific objects can be excluded.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy backfill_all = 101;</code>
     */
    public Builder clearBackfillAll() {
      if (backfillAllBuilder_ == null) {
        if (backfillStrategyCase_ == 101) {
          backfillStrategyCase_ = 0;
          backfillStrategy_ = null;
          onChanged();
        }
      } else {
        if (backfillStrategyCase_ == 101) {
          backfillStrategyCase_ = 0;
          backfillStrategy_ = null;
        }
        backfillAllBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Automatically backfill objects included in the stream source
     * configuration. Specific objects can be excluded.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy backfill_all = 101;</code>
     */
    public com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.Builder
        getBackfillAllBuilder() {
      return getBackfillAllFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Automatically backfill objects included in the stream source
     * configuration. Specific objects can be excluded.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy backfill_all = 101;</code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategyOrBuilder
        getBackfillAllOrBuilder() {
      if ((backfillStrategyCase_ == 101) && (backfillAllBuilder_ != null)) {
        return backfillAllBuilder_.getMessageOrBuilder();
      } else {
        if (backfillStrategyCase_ == 101) {
          return (com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy)
              backfillStrategy_;
        }
        return com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Automatically backfill objects included in the stream source
     * configuration. Specific objects can be excluded.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy backfill_all = 101;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy,
            com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.Builder,
            com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategyOrBuilder>
        getBackfillAllFieldBuilder() {
      if (backfillAllBuilder_ == null) {
        if (!(backfillStrategyCase_ == 101)) {
          backfillStrategy_ =
              com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.getDefaultInstance();
        }
        backfillAllBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy,
                com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy.Builder,
                com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategyOrBuilder>(
                (com.google.cloud.datastream.v1alpha1.Stream.BackfillAllStrategy) backfillStrategy_,
                getParentForChildren(),
                isClean());
        backfillStrategy_ = null;
      }
      backfillStrategyCase_ = 101;
      onChanged();
      return backfillAllBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy,
            com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy.Builder,
            com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategyOrBuilder>
        backfillNoneBuilder_;
    /**
     *
     *
     * <pre>
     * Do not automatically backfill any objects.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy backfill_none = 102;
     * </code>
     *
     * @return Whether the backfillNone field is set.
     */
    @java.lang.Override
    public boolean hasBackfillNone() {
      return backfillStrategyCase_ == 102;
    }
    /**
     *
     *
     * <pre>
     * Do not automatically backfill any objects.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy backfill_none = 102;
     * </code>
     *
     * @return The backfillNone.
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy getBackfillNone() {
      if (backfillNoneBuilder_ == null) {
        if (backfillStrategyCase_ == 102) {
          return (com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy)
              backfillStrategy_;
        }
        return com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy
            .getDefaultInstance();
      } else {
        if (backfillStrategyCase_ == 102) {
          return backfillNoneBuilder_.getMessage();
        }
        return com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Do not automatically backfill any objects.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy backfill_none = 102;
     * </code>
     */
    public Builder setBackfillNone(
        com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy value) {
      if (backfillNoneBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        backfillStrategy_ = value;
        onChanged();
      } else {
        backfillNoneBuilder_.setMessage(value);
      }
      backfillStrategyCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Do not automatically backfill any objects.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy backfill_none = 102;
     * </code>
     */
    public Builder setBackfillNone(
        com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy.Builder builderForValue) {
      if (backfillNoneBuilder_ == null) {
        backfillStrategy_ = builderForValue.build();
        onChanged();
      } else {
        backfillNoneBuilder_.setMessage(builderForValue.build());
      }
      backfillStrategyCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Do not automatically backfill any objects.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy backfill_none = 102;
     * </code>
     */
    public Builder mergeBackfillNone(
        com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy value) {
      if (backfillNoneBuilder_ == null) {
        if (backfillStrategyCase_ == 102
            && backfillStrategy_
                != com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy
                    .getDefaultInstance()) {
          backfillStrategy_ =
              com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy.newBuilder(
                      (com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy)
                          backfillStrategy_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          backfillStrategy_ = value;
        }
        onChanged();
      } else {
        if (backfillStrategyCase_ == 102) {
          backfillNoneBuilder_.mergeFrom(value);
        } else {
          backfillNoneBuilder_.setMessage(value);
        }
      }
      backfillStrategyCase_ = 102;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Do not automatically backfill any objects.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy backfill_none = 102;
     * </code>
     */
    public Builder clearBackfillNone() {
      if (backfillNoneBuilder_ == null) {
        if (backfillStrategyCase_ == 102) {
          backfillStrategyCase_ = 0;
          backfillStrategy_ = null;
          onChanged();
        }
      } else {
        if (backfillStrategyCase_ == 102) {
          backfillStrategyCase_ = 0;
          backfillStrategy_ = null;
        }
        backfillNoneBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Do not automatically backfill any objects.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy backfill_none = 102;
     * </code>
     */
    public com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy.Builder
        getBackfillNoneBuilder() {
      return getBackfillNoneFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Do not automatically backfill any objects.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy backfill_none = 102;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategyOrBuilder
        getBackfillNoneOrBuilder() {
      if ((backfillStrategyCase_ == 102) && (backfillNoneBuilder_ != null)) {
        return backfillNoneBuilder_.getMessageOrBuilder();
      } else {
        if (backfillStrategyCase_ == 102) {
          return (com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy)
              backfillStrategy_;
        }
        return com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Do not automatically backfill any objects.
     * </pre>
     *
     * <code>.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy backfill_none = 102;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy,
            com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy.Builder,
            com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategyOrBuilder>
        getBackfillNoneFieldBuilder() {
      if (backfillNoneBuilder_ == null) {
        if (!(backfillStrategyCase_ == 102)) {
          backfillStrategy_ =
              com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy.getDefaultInstance();
        }
        backfillNoneBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy,
                com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy.Builder,
                com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategyOrBuilder>(
                (com.google.cloud.datastream.v1alpha1.Stream.BackfillNoneStrategy)
                    backfillStrategy_,
                getParentForChildren(),
                isClean());
        backfillStrategy_ = null;
      }
      backfillStrategyCase_ = 102;
      onChanged();
      return backfillNoneBuilder_;
    }

    private java.util.List<com.google.cloud.datastream.v1alpha1.Error> errors_ =
        java.util.Collections.emptyList();

    private void ensureErrorsIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        errors_ = new java.util.ArrayList<com.google.cloud.datastream.v1alpha1.Error>(errors_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.Error,
            com.google.cloud.datastream.v1alpha1.Error.Builder,
            com.google.cloud.datastream.v1alpha1.ErrorOrBuilder>
        errorsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Errors on the Stream.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.datastream.v1alpha1.Error> getErrorsList() {
      if (errorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(errors_);
      } else {
        return errorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors on the Stream.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getErrorsCount() {
      if (errorsBuilder_ == null) {
        return errors_.size();
      } else {
        return errorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors on the Stream.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datastream.v1alpha1.Error getErrors(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors on the Stream.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setErrors(int index, com.google.cloud.datastream.v1alpha1.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.set(index, value);
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors on the Stream.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setErrors(
        int index, com.google.cloud.datastream.v1alpha1.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.set(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors on the Stream.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(com.google.cloud.datastream.v1alpha1.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors on the Stream.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(int index, com.google.cloud.datastream.v1alpha1.Error value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(index, value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors on the Stream.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(com.google.cloud.datastream.v1alpha1.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors on the Stream.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addErrors(
        int index, com.google.cloud.datastream.v1alpha1.Error.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors on the Stream.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllErrors(
        java.lang.Iterable<? extends com.google.cloud.datastream.v1alpha1.Error> values) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, errors_);
        onChanged();
      } else {
        errorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors on the Stream.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearErrors() {
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        errorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors on the Stream.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeErrors(int index) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.remove(index);
        onChanged();
      } else {
        errorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors on the Stream.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datastream.v1alpha1.Error.Builder getErrorsBuilder(int index) {
      return getErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors on the Stream.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datastream.v1alpha1.ErrorOrBuilder getErrorsOrBuilder(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors on the Stream.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.datastream.v1alpha1.ErrorOrBuilder>
        getErrorsOrBuilderList() {
      if (errorsBuilder_ != null) {
        return errorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(errors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors on the Stream.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datastream.v1alpha1.Error.Builder addErrorsBuilder() {
      return getErrorsFieldBuilder()
          .addBuilder(com.google.cloud.datastream.v1alpha1.Error.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors on the Stream.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datastream.v1alpha1.Error.Builder addErrorsBuilder(int index) {
      return getErrorsFieldBuilder()
          .addBuilder(index, com.google.cloud.datastream.v1alpha1.Error.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Errors on the Stream.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datastream.v1alpha1.Error errors = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.datastream.v1alpha1.Error.Builder>
        getErrorsBuilderList() {
      return getErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datastream.v1alpha1.Error,
            com.google.cloud.datastream.v1alpha1.Error.Builder,
            com.google.cloud.datastream.v1alpha1.ErrorOrBuilder>
        getErrorsFieldBuilder() {
      if (errorsBuilder_ == null) {
        errorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datastream.v1alpha1.Error,
                com.google.cloud.datastream.v1alpha1.Error.Builder,
                com.google.cloud.datastream.v1alpha1.ErrorOrBuilder>(
                errors_, ((bitField0_ & 0x00000400) != 0), getParentForChildren(), isClean());
        errors_ = null;
      }
      return errorsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datastream.v1alpha1.Stream)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datastream.v1alpha1.Stream)
  private static final com.google.cloud.datastream.v1alpha1.Stream DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datastream.v1alpha1.Stream();
  }

  public static com.google.cloud.datastream.v1alpha1.Stream getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Stream> PARSER =
      new com.google.protobuf.AbstractParser<Stream>() {
        @java.lang.Override
        public Stream parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Stream> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Stream> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datastream.v1alpha1.Stream getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
