/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.deploy.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RolloutName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DELIVERY_PIPELINE_RELEASE_ROLLOUT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/releases/{release}/rollouts/{rollout}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String deliveryPipeline;
    private final String release;
    private final String rollout;

    @Deprecated
    protected RolloutName() {
        this.project = null;
        this.location = null;
        this.deliveryPipeline = null;
        this.release = null;
        this.rollout = null;
    }

    private RolloutName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.deliveryPipeline = (String)Preconditions.checkNotNull((Object)builder.getDeliveryPipeline());
        this.release = (String)Preconditions.checkNotNull((Object)builder.getRelease());
        this.rollout = (String)Preconditions.checkNotNull((Object)builder.getRollout());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDeliveryPipeline() {
        return this.deliveryPipeline;
    }

    public String getRelease() {
        return this.release;
    }

    public String getRollout() {
        return this.rollout;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RolloutName of(String project, String location, String deliveryPipeline, String release, String rollout) {
        return RolloutName.newBuilder().setProject(project).setLocation(location).setDeliveryPipeline(deliveryPipeline).setRelease(release).setRollout(rollout).build();
    }

    public static String format(String project, String location, String deliveryPipeline, String release, String rollout) {
        return RolloutName.newBuilder().setProject(project).setLocation(location).setDeliveryPipeline(deliveryPipeline).setRelease(release).setRollout(rollout).build().toString();
    }

    public static RolloutName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DELIVERY_PIPELINE_RELEASE_ROLLOUT.validatedMatch(formattedString, "RolloutName.parse: formattedString not in valid format");
        return RolloutName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("delivery_pipeline"), (String)matchMap.get("release"), (String)matchMap.get("rollout"));
    }

    public static List<RolloutName> parseList(List<String> formattedStrings) {
        ArrayList<RolloutName> list = new ArrayList<RolloutName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RolloutName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RolloutName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RolloutName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DELIVERY_PIPELINE_RELEASE_ROLLOUT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RolloutName rolloutName = this;
            synchronized (rolloutName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.deliveryPipeline != null) {
                        fieldMapBuilder.put((Object)"delivery_pipeline", (Object)this.deliveryPipeline);
                    }
                    if (this.release != null) {
                        fieldMapBuilder.put((Object)"release", (Object)this.release);
                    }
                    if (this.rollout != null) {
                        fieldMapBuilder.put((Object)"rollout", (Object)this.rollout);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DELIVERY_PIPELINE_RELEASE_ROLLOUT.instantiate(new String[]{"project", this.project, "location", this.location, "delivery_pipeline", this.deliveryPipeline, "release", this.release, "rollout", this.rollout});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            RolloutName that = (RolloutName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.deliveryPipeline, that.deliveryPipeline) && Objects.equals(this.release, that.release) && Objects.equals(this.rollout, that.rollout);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.deliveryPipeline);
        h *= 1000003;
        h ^= Objects.hashCode(this.release);
        h *= 1000003;
        return h ^= Objects.hashCode(this.rollout);
    }

    public static class Builder {
        private String project;
        private String location;
        private String deliveryPipeline;
        private String release;
        private String rollout;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDeliveryPipeline() {
            return this.deliveryPipeline;
        }

        public String getRelease() {
            return this.release;
        }

        public String getRollout() {
            return this.rollout;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDeliveryPipeline(String deliveryPipeline) {
            this.deliveryPipeline = deliveryPipeline;
            return this;
        }

        public Builder setRelease(String release) {
            this.release = release;
            return this;
        }

        public Builder setRollout(String rollout) {
            this.rollout = rollout;
            return this;
        }

        private Builder(RolloutName rolloutName) {
            this.project = rolloutName.project;
            this.location = rolloutName.location;
            this.deliveryPipeline = rolloutName.deliveryPipeline;
            this.release = rolloutName.release;
            this.rollout = rolloutName.rollout;
        }

        public RolloutName build() {
            return new RolloutName(this);
        }
    }
}

