/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * An `Automation` resource in the Cloud Deploy API.
 *
 * An `Automation` enables the automation of manually driven actions for
 * a Delivery Pipeline, which includes Release promotion amongst Targets,
 * Rollout repair and Rollout deployment strategy advancement. The intention
 * of Automation is to reduce manual intervention in the continuous delivery
 * process.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.Automation}
 */
public final class Automation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.Automation)
    AutomationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Automation.newBuilder() to construct.
  private Automation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Automation() {
    name_ = "";
    uid_ = "";
    description_ = "";
    etag_ = "";
    serviceAccount_ = "";
    rules_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Automation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_Automation_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 6:
        return internalGetAnnotations();
      case 7:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_Automation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.Automation.class,
            com.google.cloud.deploy.v1.Automation.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of the `Automation`. Format is
   * `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automations/{automation}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the `Automation`. Format is
   * `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automations/{automation}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the `Automation`.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the `Automation`.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Description of the `Automation`. Max length is 255 characters.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Description of the `Automation`. Max length is 255 characters.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the automation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the automation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the automation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the automation was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the automation was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the automation was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 6;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.deploy.v1.CloudDeployProto
                .internal_static_google_cloud_deploy_v1_Automation_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user, and not by Cloud Deploy. Annotations must meet the following
   * constraints:
   *
   * * Annotations are key/value pairs.
   * * Valid annotation keys have two segments: an optional prefix and name,
   * separated by a slash (`/`).
   * * The name segment is required and must be 63 characters or less,
   * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
   * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
   * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
   * a series of DNS labels separated by dots(`.`), not longer than 253
   * characters in total, followed by a slash (`/`).
   *
   * See
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user, and not by Cloud Deploy. Annotations must meet the following
   * constraints:
   *
   * * Annotations are key/value pairs.
   * * Valid annotation keys have two segments: an optional prefix and name,
   * separated by a slash (`/`).
   * * The name segment is required and must be 63 characters or less,
   * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
   * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
   * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
   * a series of DNS labels separated by dots(`.`), not longer than 253
   * characters in total, followed by a slash (`/`).
   *
   * See
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user, and not by Cloud Deploy. Annotations must meet the following
   * constraints:
   *
   * * Annotations are key/value pairs.
   * * Valid annotation keys have two segments: an optional prefix and name,
   * separated by a slash (`/`).
   * * The name segment is required and must be 63 characters or less,
   * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
   * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
   * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
   * a series of DNS labels separated by dots(`.`), not longer than 253
   * characters in total, followed by a slash (`/`).
   *
   * See
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user, and not by Cloud Deploy. Annotations must meet the following
   * constraints:
   *
   * * Annotations are key/value pairs.
   * * Valid annotation keys have two segments: an optional prefix and name,
   * separated by a slash (`/`).
   * * The name segment is required and must be 63 characters or less,
   * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
   * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
   * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
   * a series of DNS labels separated by dots(`.`), not longer than 253
   * characters in total, followed by a slash (`/`).
   *
   * See
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LABELS_FIELD_NUMBER = 7;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.deploy.v1.CloudDeployProto
                .internal_static_google_cloud_deploy_v1_Automation_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 63 characters.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 63 characters.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 63 characters.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 63 characters.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ETAG_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The weak etag of the `Automation` resource.
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The weak etag of the `Automation` resource.
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUSPENDED_FIELD_NUMBER = 9;
  private boolean suspended_ = false;
  /**
   *
   *
   * <pre>
   * Optional. When Suspended, automation is deactivated from execution.
   * </pre>
   *
   * <code>bool suspended = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The suspended.
   */
  @java.lang.Override
  public boolean getSuspended() {
    return suspended_;
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * Required. Email address of the user-managed IAM service account that
   * creates Cloud Deploy release and rollout resources.
   * </pre>
   *
   * <code>string service_account = 10 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Email address of the user-managed IAM service account that
   * creates Cloud Deploy release and rollout resources.
   * </pre>
   *
   * <code>string service_account = 10 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SELECTOR_FIELD_NUMBER = 11;
  private com.google.cloud.deploy.v1.AutomationResourceSelector selector_;
  /**
   *
   *
   * <pre>
   * Required. Selected resources to which the automation will be applied.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AutomationResourceSelector selector = 11 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the selector field is set.
   */
  @java.lang.Override
  public boolean hasSelector() {
    return selector_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Selected resources to which the automation will be applied.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AutomationResourceSelector selector = 11 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The selector.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AutomationResourceSelector getSelector() {
    return selector_ == null
        ? com.google.cloud.deploy.v1.AutomationResourceSelector.getDefaultInstance()
        : selector_;
  }
  /**
   *
   *
   * <pre>
   * Required. Selected resources to which the automation will be applied.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AutomationResourceSelector selector = 11 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AutomationResourceSelectorOrBuilder getSelectorOrBuilder() {
    return selector_ == null
        ? com.google.cloud.deploy.v1.AutomationResourceSelector.getDefaultInstance()
        : selector_;
  }

  public static final int RULES_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.deploy.v1.AutomationRule> rules_;
  /**
   *
   *
   * <pre>
   * Required. List of Automation rules associated with the Automation resource.
   * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
   * Note: the order of the rules here is not the same as the order of
   * execution.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.deploy.v1.AutomationRule> getRulesList() {
    return rules_;
  }
  /**
   *
   *
   * <pre>
   * Required. List of Automation rules associated with the Automation resource.
   * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
   * Note: the order of the rules here is not the same as the order of
   * execution.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.deploy.v1.AutomationRuleOrBuilder>
      getRulesOrBuilderList() {
    return rules_;
  }
  /**
   *
   *
   * <pre>
   * Required. List of Automation rules associated with the Automation resource.
   * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
   * Note: the order of the rules here is not the same as the order of
   * execution.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getRulesCount() {
    return rules_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. List of Automation rules associated with the Automation resource.
   * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
   * Note: the order of the rules here is not the same as the order of
   * execution.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AutomationRule getRules(int index) {
    return rules_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. List of Automation rules associated with the Automation resource.
   * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
   * Note: the order of the rules here is not the same as the order of
   * execution.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AutomationRuleOrBuilder getRulesOrBuilder(int index) {
    return rules_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (createTime_ != null) {
      output.writeMessage(4, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(5, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 6);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 7);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, etag_);
    }
    if (suspended_ != false) {
      output.writeBool(9, suspended_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, serviceAccount_);
    }
    if (selector_ != null) {
      output.writeMessage(11, getSelector());
    }
    for (int i = 0; i < rules_.size(); i++) {
      output.writeMessage(14, rules_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, annotations__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, etag_);
    }
    if (suspended_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, suspended_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, serviceAccount_);
    }
    if (selector_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getSelector());
    }
    for (int i = 0; i < rules_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, rules_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.Automation)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.Automation other = (com.google.cloud.deploy.v1.Automation) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (getSuspended() != other.getSuspended()) return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (hasSelector() != other.hasSelector()) return false;
    if (hasSelector()) {
      if (!getSelector().equals(other.getSelector())) return false;
    }
    if (!getRulesList().equals(other.getRulesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + SUSPENDED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSuspended());
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    if (hasSelector()) {
      hash = (37 * hash) + SELECTOR_FIELD_NUMBER;
      hash = (53 * hash) + getSelector().hashCode();
    }
    if (getRulesCount() > 0) {
      hash = (37 * hash) + RULES_FIELD_NUMBER;
      hash = (53 * hash) + getRulesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.Automation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Automation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Automation parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Automation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Automation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Automation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Automation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Automation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Automation parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Automation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Automation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Automation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.Automation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An `Automation` resource in the Cloud Deploy API.
   *
   * An `Automation` enables the automation of manually driven actions for
   * a Delivery Pipeline, which includes Release promotion amongst Targets,
   * Rollout repair and Rollout deployment strategy advancement. The intention
   * of Automation is to reduce manual intervention in the continuous delivery
   * process.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.Automation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.Automation)
      com.google.cloud.deploy.v1.AutomationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Automation_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 6:
          return internalGetAnnotations();
        case 7:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 6:
          return internalGetMutableAnnotations();
        case 7:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Automation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.Automation.class,
              com.google.cloud.deploy.v1.Automation.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.Automation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      uid_ = "";
      description_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableAnnotations().clear();
      internalGetMutableLabels().clear();
      etag_ = "";
      suspended_ = false;
      serviceAccount_ = "";
      selector_ = null;
      if (selectorBuilder_ != null) {
        selectorBuilder_.dispose();
        selectorBuilder_ = null;
      }
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
      } else {
        rules_ = null;
        rulesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000800);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Automation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Automation getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.Automation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Automation build() {
      com.google.cloud.deploy.v1.Automation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Automation buildPartial() {
      com.google.cloud.deploy.v1.Automation result =
          new com.google.cloud.deploy.v1.Automation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.deploy.v1.Automation result) {
      if (rulesBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)) {
          rules_ = java.util.Collections.unmodifiableList(rules_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.rules_ = rules_;
      } else {
        result.rules_ = rulesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.deploy.v1.Automation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uid_ = uid_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.suspended_ = suspended_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.selector_ = selectorBuilder_ == null ? selector_ : selectorBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.Automation) {
        return mergeFrom((com.google.cloud.deploy.v1.Automation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.Automation other) {
      if (other == com.google.cloud.deploy.v1.Automation.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000020;
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000040;
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.getSuspended() != false) {
        setSuspended(other.getSuspended());
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasSelector()) {
        mergeSelector(other.getSelector());
      }
      if (rulesBuilder_ == null) {
        if (!other.rules_.isEmpty()) {
          if (rules_.isEmpty()) {
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureRulesIsMutable();
            rules_.addAll(other.rules_);
          }
          onChanged();
        }
      } else {
        if (!other.rules_.isEmpty()) {
          if (rulesBuilder_.isEmpty()) {
            rulesBuilder_.dispose();
            rulesBuilder_ = null;
            rules_ = other.rules_;
            bitField0_ = (bitField0_ & ~0x00000800);
            rulesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRulesFieldBuilder()
                    : null;
          } else {
            rulesBuilder_.addAllMessages(other.rules_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 72:
              {
                suspended_ = input.readBool();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 82:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getSelectorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 114:
              {
                com.google.cloud.deploy.v1.AutomationRule m =
                    input.readMessage(
                        com.google.cloud.deploy.v1.AutomationRule.parser(), extensionRegistry);
                if (rulesBuilder_ == null) {
                  ensureRulesIsMutable();
                  rules_.add(m);
                } else {
                  rulesBuilder_.addMessage(m);
                }
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the `Automation`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automations/{automation}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `Automation`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automations/{automation}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `Automation`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automations/{automation}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `Automation`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automations/{automation}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `Automation`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automations/{automation}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `Automation`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `Automation`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `Automation`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `Automation`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `Automation`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Description of the `Automation`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of the `Automation`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of the `Automation`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of the `Automation`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of the `Automation`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automation was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automation was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automation was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automation was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automation was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automation was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automation was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automation was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automation was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automation was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user, and not by Cloud Deploy. Annotations must meet the following
     * constraints:
     *
     * * Annotations are key/value pairs.
     * * Valid annotation keys have two segments: an optional prefix and name,
     * separated by a slash (`/`).
     * * The name segment is required and must be 63 characters or less,
     * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
     * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
     * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
     * a series of DNS labels separated by dots(`.`), not longer than 253
     * characters in total, followed by a slash (`/`).
     *
     * See
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }
    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user, and not by Cloud Deploy. Annotations must meet the following
     * constraints:
     *
     * * Annotations are key/value pairs.
     * * Valid annotation keys have two segments: an optional prefix and name,
     * separated by a slash (`/`).
     * * The name segment is required and must be 63 characters or less,
     * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
     * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
     * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
     * a series of DNS labels separated by dots(`.`), not longer than 253
     * characters in total, followed by a slash (`/`).
     *
     * See
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user, and not by Cloud Deploy. Annotations must meet the following
     * constraints:
     *
     * * Annotations are key/value pairs.
     * * Valid annotation keys have two segments: an optional prefix and name,
     * separated by a slash (`/`).
     * * The name segment is required and must be 63 characters or less,
     * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
     * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
     * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
     * a series of DNS labels separated by dots(`.`), not longer than 253
     * characters in total, followed by a slash (`/`).
     *
     * See
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user, and not by Cloud Deploy. Annotations must meet the following
     * constraints:
     *
     * * Annotations are key/value pairs.
     * * Valid annotation keys have two segments: an optional prefix and name,
     * separated by a slash (`/`).
     * * The name segment is required and must be 63 characters or less,
     * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
     * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
     * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
     * a series of DNS labels separated by dots(`.`), not longer than 253
     * characters in total, followed by a slash (`/`).
     *
     * See
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000020);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user, and not by Cloud Deploy. Annotations must meet the following
     * constraints:
     *
     * * Annotations are key/value pairs.
     * * Valid annotation keys have two segments: an optional prefix and name,
     * separated by a slash (`/`).
     * * The name segment is required and must be 63 characters or less,
     * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
     * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
     * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
     * a series of DNS labels separated by dots(`.`), not longer than 253
     * characters in total, followed by a slash (`/`).
     *
     * See
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000020;
      return internalGetMutableAnnotations().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user, and not by Cloud Deploy. Annotations must meet the following
     * constraints:
     *
     * * Annotations are key/value pairs.
     * * Valid annotation keys have two segments: an optional prefix and name,
     * separated by a slash (`/`).
     * * The name segment is required and must be 63 characters or less,
     * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
     * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
     * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
     * a series of DNS labels separated by dots(`.`), not longer than 253
     * characters in total, followed by a slash (`/`).
     *
     * See
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000020;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User annotations. These attributes can only be set and used by
     * the user, and not by Cloud Deploy. Annotations must meet the following
     * constraints:
     *
     * * Annotations are key/value pairs.
     * * Valid annotation keys have two segments: an optional prefix and name,
     * separated by a slash (`/`).
     * * The name segment is required and must be 63 characters or less,
     * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
     * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
     * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
     * a series of DNS labels separated by dots(`.`), not longer than 253
     * characters in total, followed by a slash (`/`).
     *
     * See
     * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
     * for more details.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000020;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 63 characters.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 63 characters.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 63 characters.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 63 characters.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 63 characters.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000040;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 63 characters.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 63 characters.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The weak etag of the `Automation` resource.
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The weak etag of the `Automation` resource.
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The weak etag of the `Automation` resource.
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The weak etag of the `Automation` resource.
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The weak etag of the `Automation` resource.
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private boolean suspended_;
    /**
     *
     *
     * <pre>
     * Optional. When Suspended, automation is deactivated from execution.
     * </pre>
     *
     * <code>bool suspended = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The suspended.
     */
    @java.lang.Override
    public boolean getSuspended() {
      return suspended_;
    }
    /**
     *
     *
     * <pre>
     * Optional. When Suspended, automation is deactivated from execution.
     * </pre>
     *
     * <code>bool suspended = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The suspended to set.
     * @return This builder for chaining.
     */
    public Builder setSuspended(boolean value) {

      suspended_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. When Suspended, automation is deactivated from execution.
     * </pre>
     *
     * <code>bool suspended = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuspended() {
      bitField0_ = (bitField0_ & ~0x00000100);
      suspended_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Required. Email address of the user-managed IAM service account that
     * creates Cloud Deploy release and rollout resources.
     * </pre>
     *
     * <code>string service_account = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Email address of the user-managed IAM service account that
     * creates Cloud Deploy release and rollout resources.
     * </pre>
     *
     * <code>string service_account = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Email address of the user-managed IAM service account that
     * creates Cloud Deploy release and rollout resources.
     * </pre>
     *
     * <code>string service_account = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Email address of the user-managed IAM service account that
     * creates Cloud Deploy release and rollout resources.
     * </pre>
     *
     * <code>string service_account = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Email address of the user-managed IAM service account that
     * creates Cloud Deploy release and rollout resources.
     * </pre>
     *
     * <code>string service_account = 10 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.cloud.deploy.v1.AutomationResourceSelector selector_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.AutomationResourceSelector,
            com.google.cloud.deploy.v1.AutomationResourceSelector.Builder,
            com.google.cloud.deploy.v1.AutomationResourceSelectorOrBuilder>
        selectorBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the automation will be applied.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationResourceSelector selector = 11 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the selector field is set.
     */
    public boolean hasSelector() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the automation will be applied.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationResourceSelector selector = 11 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The selector.
     */
    public com.google.cloud.deploy.v1.AutomationResourceSelector getSelector() {
      if (selectorBuilder_ == null) {
        return selector_ == null
            ? com.google.cloud.deploy.v1.AutomationResourceSelector.getDefaultInstance()
            : selector_;
      } else {
        return selectorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the automation will be applied.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationResourceSelector selector = 11 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setSelector(com.google.cloud.deploy.v1.AutomationResourceSelector value) {
      if (selectorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        selector_ = value;
      } else {
        selectorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the automation will be applied.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationResourceSelector selector = 11 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setSelector(
        com.google.cloud.deploy.v1.AutomationResourceSelector.Builder builderForValue) {
      if (selectorBuilder_ == null) {
        selector_ = builderForValue.build();
      } else {
        selectorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the automation will be applied.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationResourceSelector selector = 11 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeSelector(com.google.cloud.deploy.v1.AutomationResourceSelector value) {
      if (selectorBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && selector_ != null
            && selector_
                != com.google.cloud.deploy.v1.AutomationResourceSelector.getDefaultInstance()) {
          getSelectorBuilder().mergeFrom(value);
        } else {
          selector_ = value;
        }
      } else {
        selectorBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the automation will be applied.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationResourceSelector selector = 11 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearSelector() {
      bitField0_ = (bitField0_ & ~0x00000400);
      selector_ = null;
      if (selectorBuilder_ != null) {
        selectorBuilder_.dispose();
        selectorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the automation will be applied.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationResourceSelector selector = 11 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.AutomationResourceSelector.Builder getSelectorBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getSelectorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the automation will be applied.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationResourceSelector selector = 11 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.AutomationResourceSelectorOrBuilder getSelectorOrBuilder() {
      if (selectorBuilder_ != null) {
        return selectorBuilder_.getMessageOrBuilder();
      } else {
        return selector_ == null
            ? com.google.cloud.deploy.v1.AutomationResourceSelector.getDefaultInstance()
            : selector_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Selected resources to which the automation will be applied.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationResourceSelector selector = 11 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.AutomationResourceSelector,
            com.google.cloud.deploy.v1.AutomationResourceSelector.Builder,
            com.google.cloud.deploy.v1.AutomationResourceSelectorOrBuilder>
        getSelectorFieldBuilder() {
      if (selectorBuilder_ == null) {
        selectorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.AutomationResourceSelector,
                com.google.cloud.deploy.v1.AutomationResourceSelector.Builder,
                com.google.cloud.deploy.v1.AutomationResourceSelectorOrBuilder>(
                getSelector(), getParentForChildren(), isClean());
        selector_ = null;
      }
      return selectorBuilder_;
    }

    private java.util.List<com.google.cloud.deploy.v1.AutomationRule> rules_ =
        java.util.Collections.emptyList();

    private void ensureRulesIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        rules_ = new java.util.ArrayList<com.google.cloud.deploy.v1.AutomationRule>(rules_);
        bitField0_ |= 0x00000800;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.AutomationRule,
            com.google.cloud.deploy.v1.AutomationRule.Builder,
            com.google.cloud.deploy.v1.AutomationRuleOrBuilder>
        rulesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. List of Automation rules associated with the Automation resource.
     * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
     * Note: the order of the rules here is not the same as the order of
     * execution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.AutomationRule> getRulesList() {
      if (rulesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rules_);
      } else {
        return rulesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. List of Automation rules associated with the Automation resource.
     * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
     * Note: the order of the rules here is not the same as the order of
     * execution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getRulesCount() {
      if (rulesBuilder_ == null) {
        return rules_.size();
      } else {
        return rulesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. List of Automation rules associated with the Automation resource.
     * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
     * Note: the order of the rules here is not the same as the order of
     * execution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.AutomationRule getRules(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. List of Automation rules associated with the Automation resource.
     * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
     * Note: the order of the rules here is not the same as the order of
     * execution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRules(int index, com.google.cloud.deploy.v1.AutomationRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.set(index, value);
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of Automation rules associated with the Automation resource.
     * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
     * Note: the order of the rules here is not the same as the order of
     * execution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRules(
        int index, com.google.cloud.deploy.v1.AutomationRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.set(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of Automation rules associated with the Automation resource.
     * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
     * Note: the order of the rules here is not the same as the order of
     * execution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRules(com.google.cloud.deploy.v1.AutomationRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of Automation rules associated with the Automation resource.
     * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
     * Note: the order of the rules here is not the same as the order of
     * execution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRules(int index, com.google.cloud.deploy.v1.AutomationRule value) {
      if (rulesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRulesIsMutable();
        rules_.add(index, value);
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of Automation rules associated with the Automation resource.
     * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
     * Note: the order of the rules here is not the same as the order of
     * execution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRules(com.google.cloud.deploy.v1.AutomationRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of Automation rules associated with the Automation resource.
     * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
     * Note: the order of the rules here is not the same as the order of
     * execution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRules(
        int index, com.google.cloud.deploy.v1.AutomationRule.Builder builderForValue) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.add(index, builderForValue.build());
        onChanged();
      } else {
        rulesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of Automation rules associated with the Automation resource.
     * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
     * Note: the order of the rules here is not the same as the order of
     * execution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllRules(
        java.lang.Iterable<? extends com.google.cloud.deploy.v1.AutomationRule> values) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rules_);
        onChanged();
      } else {
        rulesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of Automation rules associated with the Automation resource.
     * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
     * Note: the order of the rules here is not the same as the order of
     * execution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearRules() {
      if (rulesBuilder_ == null) {
        rules_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        rulesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of Automation rules associated with the Automation resource.
     * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
     * Note: the order of the rules here is not the same as the order of
     * execution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeRules(int index) {
      if (rulesBuilder_ == null) {
        ensureRulesIsMutable();
        rules_.remove(index);
        onChanged();
      } else {
        rulesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. List of Automation rules associated with the Automation resource.
     * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
     * Note: the order of the rules here is not the same as the order of
     * execution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.AutomationRule.Builder getRulesBuilder(int index) {
      return getRulesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. List of Automation rules associated with the Automation resource.
     * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
     * Note: the order of the rules here is not the same as the order of
     * execution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.AutomationRuleOrBuilder getRulesOrBuilder(int index) {
      if (rulesBuilder_ == null) {
        return rules_.get(index);
      } else {
        return rulesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. List of Automation rules associated with the Automation resource.
     * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
     * Note: the order of the rules here is not the same as the order of
     * execution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.deploy.v1.AutomationRuleOrBuilder>
        getRulesOrBuilderList() {
      if (rulesBuilder_ != null) {
        return rulesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rules_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. List of Automation rules associated with the Automation resource.
     * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
     * Note: the order of the rules here is not the same as the order of
     * execution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.AutomationRule.Builder addRulesBuilder() {
      return getRulesFieldBuilder()
          .addBuilder(com.google.cloud.deploy.v1.AutomationRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. List of Automation rules associated with the Automation resource.
     * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
     * Note: the order of the rules here is not the same as the order of
     * execution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.AutomationRule.Builder addRulesBuilder(int index) {
      return getRulesFieldBuilder()
          .addBuilder(index, com.google.cloud.deploy.v1.AutomationRule.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. List of Automation rules associated with the Automation resource.
     * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
     * Note: the order of the rules here is not the same as the order of
     * execution.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.AutomationRule.Builder> getRulesBuilderList() {
      return getRulesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.AutomationRule,
            com.google.cloud.deploy.v1.AutomationRule.Builder,
            com.google.cloud.deploy.v1.AutomationRuleOrBuilder>
        getRulesFieldBuilder() {
      if (rulesBuilder_ == null) {
        rulesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.deploy.v1.AutomationRule,
                com.google.cloud.deploy.v1.AutomationRule.Builder,
                com.google.cloud.deploy.v1.AutomationRuleOrBuilder>(
                rules_, ((bitField0_ & 0x00000800) != 0), getParentForChildren(), isClean());
        rules_ = null;
      }
      return rulesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.Automation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.Automation)
  private static final com.google.cloud.deploy.v1.Automation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.Automation();
  }

  public static com.google.cloud.deploy.v1.Automation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Automation> PARSER =
      new com.google.protobuf.AbstractParser<Automation>() {
        @java.lang.Override
        public Automation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Automation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Automation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.Automation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
