/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

public interface AutomationOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.deploy.v1.Automation)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. Name of the `Automation`. Format is
   * `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automations/{automation}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Output only. Name of the `Automation`. Format is
   * `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automations/{automation}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the `Automation`.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  java.lang.String getUid();
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the `Automation`.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  com.google.protobuf.ByteString getUidBytes();

  /**
   *
   *
   * <pre>
   * Optional. Description of the `Automation`. Max length is 255 characters.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * Optional. Description of the `Automation`. Max length is 255 characters.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Output only. Time at which the automation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the automation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the automation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Time at which the automation was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the automation was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. Time at which the automation was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user, and not by Cloud Deploy. Annotations must meet the following
   * constraints:
   *
   * * Annotations are key/value pairs.
   * * Valid annotation keys have two segments: an optional prefix and name,
   * separated by a slash (`/`).
   * * The name segment is required and must be 63 characters or less,
   * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
   * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
   * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
   * a series of DNS labels separated by dots(`.`), not longer than 253
   * characters in total, followed by a slash (`/`).
   *
   * See
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getAnnotationsCount();
  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user, and not by Cloud Deploy. Annotations must meet the following
   * constraints:
   *
   * * Annotations are key/value pairs.
   * * Valid annotation keys have two segments: an optional prefix and name,
   * separated by a slash (`/`).
   * * The name segment is required and must be 63 characters or less,
   * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
   * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
   * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
   * a series of DNS labels separated by dots(`.`), not longer than 253
   * characters in total, followed by a slash (`/`).
   *
   * See
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  boolean containsAnnotations(java.lang.String key);
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getAnnotations();
  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user, and not by Cloud Deploy. Annotations must meet the following
   * constraints:
   *
   * * Annotations are key/value pairs.
   * * Valid annotation keys have two segments: an optional prefix and name,
   * separated by a slash (`/`).
   * * The name segment is required and must be 63 characters or less,
   * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
   * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
   * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
   * a series of DNS labels separated by dots(`.`), not longer than 253
   * characters in total, followed by a slash (`/`).
   *
   * See
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap();
  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user, and not by Cloud Deploy. Annotations must meet the following
   * constraints:
   *
   * * Annotations are key/value pairs.
   * * Valid annotation keys have two segments: an optional prefix and name,
   * separated by a slash (`/`).
   * * The name segment is required and must be 63 characters or less,
   * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
   * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
   * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
   * a series of DNS labels separated by dots(`.`), not longer than 253
   * characters in total, followed by a slash (`/`).
   *
   * See
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  /* nullable */
  java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Optional. User annotations. These attributes can only be set and used by
   * the user, and not by Cloud Deploy. Annotations must meet the following
   * constraints:
   *
   * * Annotations are key/value pairs.
   * * Valid annotation keys have two segments: an optional prefix and name,
   * separated by a slash (`/`).
   * * The name segment is required and must be 63 characters or less,
   * beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
   * dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
   * * The prefix is optional. If specified, the prefix must be a DNS subdomain:
   * a series of DNS labels separated by dots(`.`), not longer than 253
   * characters in total, followed by a slash (`/`).
   *
   * See
   * https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
   * for more details.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.lang.String getAnnotationsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Optional. Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 63 characters.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * Optional. Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 63 characters.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  boolean containsLabels(java.lang.String key);
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();
  /**
   *
   *
   * <pre>
   * Optional. Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 63 characters.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();
  /**
   *
   *
   * <pre>
   * Optional. Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 63 characters.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);
  /**
   *
   *
   * <pre>
   * Optional. Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 63 characters.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Optional. The weak etag of the `Automation` resource.
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The etag.
   */
  java.lang.String getEtag();
  /**
   *
   *
   * <pre>
   * Optional. The weak etag of the `Automation` resource.
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for etag.
   */
  com.google.protobuf.ByteString getEtagBytes();

  /**
   *
   *
   * <pre>
   * Optional. When Suspended, automation is deactivated from execution.
   * </pre>
   *
   * <code>bool suspended = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The suspended.
   */
  boolean getSuspended();

  /**
   *
   *
   * <pre>
   * Required. Email address of the user-managed IAM service account that
   * creates Cloud Deploy release and rollout resources.
   * </pre>
   *
   * <code>string service_account = 10 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The serviceAccount.
   */
  java.lang.String getServiceAccount();
  /**
   *
   *
   * <pre>
   * Required. Email address of the user-managed IAM service account that
   * creates Cloud Deploy release and rollout resources.
   * </pre>
   *
   * <code>string service_account = 10 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for serviceAccount.
   */
  com.google.protobuf.ByteString getServiceAccountBytes();

  /**
   *
   *
   * <pre>
   * Required. Selected resources to which the automation will be applied.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AutomationResourceSelector selector = 11 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the selector field is set.
   */
  boolean hasSelector();
  /**
   *
   *
   * <pre>
   * Required. Selected resources to which the automation will be applied.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AutomationResourceSelector selector = 11 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The selector.
   */
  com.google.cloud.deploy.v1.AutomationResourceSelector getSelector();
  /**
   *
   *
   * <pre>
   * Required. Selected resources to which the automation will be applied.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AutomationResourceSelector selector = 11 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.deploy.v1.AutomationResourceSelectorOrBuilder getSelectorOrBuilder();

  /**
   *
   *
   * <pre>
   * Required. List of Automation rules associated with the Automation resource.
   * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
   * Note: the order of the rules here is not the same as the order of
   * execution.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<com.google.cloud.deploy.v1.AutomationRule> getRulesList();
  /**
   *
   *
   * <pre>
   * Required. List of Automation rules associated with the Automation resource.
   * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
   * Note: the order of the rules here is not the same as the order of
   * execution.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.deploy.v1.AutomationRule getRules(int index);
  /**
   *
   *
   * <pre>
   * Required. List of Automation rules associated with the Automation resource.
   * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
   * Note: the order of the rules here is not the same as the order of
   * execution.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  int getRulesCount();
  /**
   *
   *
   * <pre>
   * Required. List of Automation rules associated with the Automation resource.
   * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
   * Note: the order of the rules here is not the same as the order of
   * execution.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  java.util.List<? extends com.google.cloud.deploy.v1.AutomationRuleOrBuilder>
      getRulesOrBuilderList();
  /**
   *
   *
   * <pre>
   * Required. List of Automation rules associated with the Automation resource.
   * Must have at least one rule and limited to 250 rules per Delivery Pipeline.
   * Note: the order of the rules here is not the same as the order of
   * execution.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.AutomationRule rules = 14 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.cloud.deploy.v1.AutomationRuleOrBuilder getRulesOrBuilder(int index);
}
