/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * An `AutomationRun` resource in the Cloud Deploy API.
 *
 * An `AutomationRun` represents an automation execution instance of an
 * automation rule.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.AutomationRun}
 */
public final class AutomationRun extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.AutomationRun)
    AutomationRunOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AutomationRun.newBuilder() to construct.
  private AutomationRun(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AutomationRun() {
    name_ = "";
    etag_ = "";
    serviceAccount_ = "";
    targetId_ = "";
    state_ = 0;
    stateDescription_ = "";
    ruleId_ = "";
    automationId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AutomationRun();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_AutomationRun_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_AutomationRun_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.AutomationRun.class,
            com.google.cloud.deploy.v1.AutomationRun.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Valid state of an `AutomationRun`.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.deploy.v1.AutomationRun.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The `AutomationRun` has an unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The `AutomationRun` has succeeded.
     * </pre>
     *
     * <code>SUCCEEDED = 1;</code>
     */
    SUCCEEDED(1),
    /**
     *
     *
     * <pre>
     * The `AutomationRun` was cancelled.
     * </pre>
     *
     * <code>CANCELLED = 2;</code>
     */
    CANCELLED(2),
    /**
     *
     *
     * <pre>
     * The `AutomationRun` has failed.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    FAILED(3),
    /**
     *
     *
     * <pre>
     * The `AutomationRun` is in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 4;</code>
     */
    IN_PROGRESS(4),
    /**
     *
     *
     * <pre>
     * The `AutomationRun` is pending.
     * </pre>
     *
     * <code>PENDING = 5;</code>
     */
    PENDING(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The `AutomationRun` has an unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The `AutomationRun` has succeeded.
     * </pre>
     *
     * <code>SUCCEEDED = 1;</code>
     */
    public static final int SUCCEEDED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The `AutomationRun` was cancelled.
     * </pre>
     *
     * <code>CANCELLED = 2;</code>
     */
    public static final int CANCELLED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The `AutomationRun` has failed.
     * </pre>
     *
     * <code>FAILED = 3;</code>
     */
    public static final int FAILED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The `AutomationRun` is in progress.
     * </pre>
     *
     * <code>IN_PROGRESS = 4;</code>
     */
    public static final int IN_PROGRESS_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The `AutomationRun` is pending.
     * </pre>
     *
     * <code>PENDING = 5;</code>
     */
    public static final int PENDING_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return SUCCEEDED;
        case 2:
          return CANCELLED;
        case 3:
          return FAILED;
        case 4:
          return IN_PROGRESS;
        case 5:
          return PENDING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.deploy.v1.AutomationRun.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.deploy.v1.AutomationRun.State)
  }

  private int operationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object operation_;

  public enum OperationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PROMOTE_RELEASE_OPERATION(13),
    ADVANCE_ROLLOUT_OPERATION(14),
    REPAIR_ROLLOUT_OPERATION(17),
    OPERATION_NOT_SET(0);
    private final int value;

    private OperationCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OperationCase valueOf(int value) {
      return forNumber(value);
    }

    public static OperationCase forNumber(int value) {
      switch (value) {
        case 13:
          return PROMOTE_RELEASE_OPERATION;
        case 14:
          return ADVANCE_ROLLOUT_OPERATION;
        case 17:
          return REPAIR_ROLLOUT_OPERATION;
        case 0:
          return OPERATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public OperationCase getOperationCase() {
    return OperationCase.forNumber(operationCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of the `AutomationRun`. Format is
   * `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automationRuns/{automation_run}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the `AutomationRun`. Format is
   * `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automationRuns/{automation_run}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `AutomationRun` was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `AutomationRun` was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `AutomationRun` was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the automationRun was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the automationRun was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the automationRun was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int ETAG_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The weak etag of the `AutomationRun` resource.
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The weak etag of the `AutomationRun` resource.
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Email address of the user-managed IAM service account that
   * performs the operations against Cloud Deploy resources.
   * </pre>
   *
   * <code>string service_account = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Email address of the user-managed IAM service account that
   * performs the operations against Cloud Deploy resources.
   * </pre>
   *
   * <code>string service_account = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUTOMATION_SNAPSHOT_FIELD_NUMBER = 6;
  private com.google.cloud.deploy.v1.Automation automationSnapshot_;
  /**
   *
   *
   * <pre>
   * Output only. Snapshot of the Automation taken at AutomationRun creation
   * time.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Automation automation_snapshot = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the automationSnapshot field is set.
   */
  @java.lang.Override
  public boolean hasAutomationSnapshot() {
    return automationSnapshot_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Snapshot of the Automation taken at AutomationRun creation
   * time.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Automation automation_snapshot = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The automationSnapshot.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.Automation getAutomationSnapshot() {
    return automationSnapshot_ == null
        ? com.google.cloud.deploy.v1.Automation.getDefaultInstance()
        : automationSnapshot_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Snapshot of the Automation taken at AutomationRun creation
   * time.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Automation automation_snapshot = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AutomationOrBuilder getAutomationSnapshotOrBuilder() {
    return automationSnapshot_ == null
        ? com.google.cloud.deploy.v1.Automation.getDefaultInstance()
        : automationSnapshot_;
  }

  public static final int TARGET_ID_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object targetId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The ID of the target that represents the promotion stage that
   * initiates the `AutomationRun`. The value of this field is the last segment
   * of a target name.
   * </pre>
   *
   * <code>string target_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The targetId.
   */
  @java.lang.Override
  public java.lang.String getTargetId() {
    java.lang.Object ref = targetId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      targetId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The ID of the target that represents the promotion stage that
   * initiates the `AutomationRun`. The value of this field is the last segment
   * of a target name.
   * </pre>
   *
   * <code>string target_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for targetId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetIdBytes() {
    java.lang.Object ref = targetId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      targetId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 8;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Current state of the `AutomationRun`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AutomationRun.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Current state of the `AutomationRun`.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AutomationRun.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AutomationRun.State getState() {
    com.google.cloud.deploy.v1.AutomationRun.State result =
        com.google.cloud.deploy.v1.AutomationRun.State.forNumber(state_);
    return result == null ? com.google.cloud.deploy.v1.AutomationRun.State.UNRECOGNIZED : result;
  }

  public static final int STATE_DESCRIPTION_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stateDescription_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Explains the current state of the `AutomationRun`. Present
   * only an explanation is needed.
   * </pre>
   *
   * <code>string state_description = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The stateDescription.
   */
  @java.lang.Override
  public java.lang.String getStateDescription() {
    java.lang.Object ref = stateDescription_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stateDescription_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Explains the current state of the `AutomationRun`. Present
   * only an explanation is needed.
   * </pre>
   *
   * <code>string state_description = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for stateDescription.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateDescriptionBytes() {
    java.lang.Object ref = stateDescription_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stateDescription_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 11;
  private com.google.protobuf.Timestamp expireTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time the `AutomationRun` will expire. An `AutomationRun` will
   * expire after 14 days from its creation date.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return expireTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time the `AutomationRun` will expire. An `AutomationRun` will
   * expire after 14 days from its creation date.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time the `AutomationRun` will expire. An `AutomationRun` will
   * expire after 14 days from its creation date.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }

  public static final int RULE_ID_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object ruleId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The ID of the automation rule that initiated the operation.
   * </pre>
   *
   * <code>string rule_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The ruleId.
   */
  @java.lang.Override
  public java.lang.String getRuleId() {
    java.lang.Object ref = ruleId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      ruleId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The ID of the automation rule that initiated the operation.
   * </pre>
   *
   * <code>string rule_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for ruleId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRuleIdBytes() {
    java.lang.Object ref = ruleId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      ruleId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AUTOMATION_ID_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object automationId_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The ID of the automation that initiated the operation.
   * </pre>
   *
   * <code>string automation_id = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The automationId.
   */
  @java.lang.Override
  public java.lang.String getAutomationId() {
    java.lang.Object ref = automationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      automationId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The ID of the automation that initiated the operation.
   * </pre>
   *
   * <code>string automation_id = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for automationId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAutomationIdBytes() {
    java.lang.Object ref = automationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      automationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PROMOTE_RELEASE_OPERATION_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Output only. Promotes a release to a specified 'Target'.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PromoteReleaseOperation promote_release_operation = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the promoteReleaseOperation field is set.
   */
  @java.lang.Override
  public boolean hasPromoteReleaseOperation() {
    return operationCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * Output only. Promotes a release to a specified 'Target'.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PromoteReleaseOperation promote_release_operation = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The promoteReleaseOperation.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.PromoteReleaseOperation getPromoteReleaseOperation() {
    if (operationCase_ == 13) {
      return (com.google.cloud.deploy.v1.PromoteReleaseOperation) operation_;
    }
    return com.google.cloud.deploy.v1.PromoteReleaseOperation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Promotes a release to a specified 'Target'.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PromoteReleaseOperation promote_release_operation = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.PromoteReleaseOperationOrBuilder
      getPromoteReleaseOperationOrBuilder() {
    if (operationCase_ == 13) {
      return (com.google.cloud.deploy.v1.PromoteReleaseOperation) operation_;
    }
    return com.google.cloud.deploy.v1.PromoteReleaseOperation.getDefaultInstance();
  }

  public static final int ADVANCE_ROLLOUT_OPERATION_FIELD_NUMBER = 14;
  /**
   *
   *
   * <pre>
   * Output only. Advances a rollout to the next phase.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AdvanceRolloutOperation advance_rollout_operation = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the advanceRolloutOperation field is set.
   */
  @java.lang.Override
  public boolean hasAdvanceRolloutOperation() {
    return operationCase_ == 14;
  }
  /**
   *
   *
   * <pre>
   * Output only. Advances a rollout to the next phase.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AdvanceRolloutOperation advance_rollout_operation = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The advanceRolloutOperation.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AdvanceRolloutOperation getAdvanceRolloutOperation() {
    if (operationCase_ == 14) {
      return (com.google.cloud.deploy.v1.AdvanceRolloutOperation) operation_;
    }
    return com.google.cloud.deploy.v1.AdvanceRolloutOperation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Advances a rollout to the next phase.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AdvanceRolloutOperation advance_rollout_operation = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AdvanceRolloutOperationOrBuilder
      getAdvanceRolloutOperationOrBuilder() {
    if (operationCase_ == 14) {
      return (com.google.cloud.deploy.v1.AdvanceRolloutOperation) operation_;
    }
    return com.google.cloud.deploy.v1.AdvanceRolloutOperation.getDefaultInstance();
  }

  public static final int REPAIR_ROLLOUT_OPERATION_FIELD_NUMBER = 17;
  /**
   *
   *
   * <pre>
   * Output only. Repairs a failed 'Rollout'.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.RepairRolloutOperation repair_rollout_operation = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the repairRolloutOperation field is set.
   */
  @java.lang.Override
  public boolean hasRepairRolloutOperation() {
    return operationCase_ == 17;
  }
  /**
   *
   *
   * <pre>
   * Output only. Repairs a failed 'Rollout'.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.RepairRolloutOperation repair_rollout_operation = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The repairRolloutOperation.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RepairRolloutOperation getRepairRolloutOperation() {
    if (operationCase_ == 17) {
      return (com.google.cloud.deploy.v1.RepairRolloutOperation) operation_;
    }
    return com.google.cloud.deploy.v1.RepairRolloutOperation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Repairs a failed 'Rollout'.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.RepairRolloutOperation repair_rollout_operation = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RepairRolloutOperationOrBuilder
      getRepairRolloutOperationOrBuilder() {
    if (operationCase_ == 17) {
      return (com.google.cloud.deploy.v1.RepairRolloutOperation) operation_;
    }
    return com.google.cloud.deploy.v1.RepairRolloutOperation.getDefaultInstance();
  }

  public static final int WAIT_UNTIL_TIME_FIELD_NUMBER = 16;
  private com.google.protobuf.Timestamp waitUntilTime_;
  /**
   *
   *
   * <pre>
   * Output only. Earliest time the `AutomationRun` will attempt to resume.
   * Wait-time is configured by `wait` in automation rule.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp wait_until_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the waitUntilTime field is set.
   */
  @java.lang.Override
  public boolean hasWaitUntilTime() {
    return waitUntilTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Earliest time the `AutomationRun` will attempt to resume.
   * Wait-time is configured by `wait` in automation rule.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp wait_until_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The waitUntilTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getWaitUntilTime() {
    return waitUntilTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : waitUntilTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Earliest time the `AutomationRun` will attempt to resume.
   * Wait-time is configured by `wait` in automation rule.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp wait_until_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getWaitUntilTimeOrBuilder() {
    return waitUntilTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : waitUntilTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (createTime_ != null) {
      output.writeMessage(2, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(3, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, etag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, serviceAccount_);
    }
    if (automationSnapshot_ != null) {
      output.writeMessage(6, getAutomationSnapshot());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, targetId_);
    }
    if (state_ != com.google.cloud.deploy.v1.AutomationRun.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(8, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateDescription_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, stateDescription_);
    }
    if (expireTime_ != null) {
      output.writeMessage(11, getExpireTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ruleId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, ruleId_);
    }
    if (operationCase_ == 13) {
      output.writeMessage(13, (com.google.cloud.deploy.v1.PromoteReleaseOperation) operation_);
    }
    if (operationCase_ == 14) {
      output.writeMessage(14, (com.google.cloud.deploy.v1.AdvanceRolloutOperation) operation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(automationId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, automationId_);
    }
    if (waitUntilTime_ != null) {
      output.writeMessage(16, getWaitUntilTime());
    }
    if (operationCase_ == 17) {
      output.writeMessage(17, (com.google.cloud.deploy.v1.RepairRolloutOperation) operation_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, etag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccount_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, serviceAccount_);
    }
    if (automationSnapshot_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getAutomationSnapshot());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, targetId_);
    }
    if (state_ != com.google.cloud.deploy.v1.AutomationRun.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateDescription_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, stateDescription_);
    }
    if (expireTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getExpireTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(ruleId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, ruleId_);
    }
    if (operationCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.cloud.deploy.v1.PromoteReleaseOperation) operation_);
    }
    if (operationCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14, (com.google.cloud.deploy.v1.AdvanceRolloutOperation) operation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(automationId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, automationId_);
    }
    if (waitUntilTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getWaitUntilTime());
    }
    if (operationCase_ == 17) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, (com.google.cloud.deploy.v1.RepairRolloutOperation) operation_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.AutomationRun)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.AutomationRun other = (com.google.cloud.deploy.v1.AutomationRun) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    if (hasAutomationSnapshot() != other.hasAutomationSnapshot()) return false;
    if (hasAutomationSnapshot()) {
      if (!getAutomationSnapshot().equals(other.getAutomationSnapshot())) return false;
    }
    if (!getTargetId().equals(other.getTargetId())) return false;
    if (state_ != other.state_) return false;
    if (!getStateDescription().equals(other.getStateDescription())) return false;
    if (hasExpireTime() != other.hasExpireTime()) return false;
    if (hasExpireTime()) {
      if (!getExpireTime().equals(other.getExpireTime())) return false;
    }
    if (!getRuleId().equals(other.getRuleId())) return false;
    if (!getAutomationId().equals(other.getAutomationId())) return false;
    if (hasWaitUntilTime() != other.hasWaitUntilTime()) return false;
    if (hasWaitUntilTime()) {
      if (!getWaitUntilTime().equals(other.getWaitUntilTime())) return false;
    }
    if (!getOperationCase().equals(other.getOperationCase())) return false;
    switch (operationCase_) {
      case 13:
        if (!getPromoteReleaseOperation().equals(other.getPromoteReleaseOperation())) return false;
        break;
      case 14:
        if (!getAdvanceRolloutOperation().equals(other.getAdvanceRolloutOperation())) return false;
        break;
      case 17:
        if (!getRepairRolloutOperation().equals(other.getRepairRolloutOperation())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccount().hashCode();
    if (hasAutomationSnapshot()) {
      hash = (37 * hash) + AUTOMATION_SNAPSHOT_FIELD_NUMBER;
      hash = (53 * hash) + getAutomationSnapshot().hashCode();
    }
    hash = (37 * hash) + TARGET_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTargetId().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + STATE_DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getStateDescription().hashCode();
    if (hasExpireTime()) {
      hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpireTime().hashCode();
    }
    hash = (37 * hash) + RULE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRuleId().hashCode();
    hash = (37 * hash) + AUTOMATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getAutomationId().hashCode();
    if (hasWaitUntilTime()) {
      hash = (37 * hash) + WAIT_UNTIL_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getWaitUntilTime().hashCode();
    }
    switch (operationCase_) {
      case 13:
        hash = (37 * hash) + PROMOTE_RELEASE_OPERATION_FIELD_NUMBER;
        hash = (53 * hash) + getPromoteReleaseOperation().hashCode();
        break;
      case 14:
        hash = (37 * hash) + ADVANCE_ROLLOUT_OPERATION_FIELD_NUMBER;
        hash = (53 * hash) + getAdvanceRolloutOperation().hashCode();
        break;
      case 17:
        hash = (37 * hash) + REPAIR_ROLLOUT_OPERATION_FIELD_NUMBER;
        hash = (53 * hash) + getRepairRolloutOperation().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.AutomationRun parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.AutomationRun parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.AutomationRun parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.AutomationRun parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.AutomationRun parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.AutomationRun parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.AutomationRun parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.AutomationRun parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.AutomationRun parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.AutomationRun parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.AutomationRun parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.AutomationRun parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.AutomationRun prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An `AutomationRun` resource in the Cloud Deploy API.
   *
   * An `AutomationRun` represents an automation execution instance of an
   * automation rule.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.AutomationRun}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.AutomationRun)
      com.google.cloud.deploy.v1.AutomationRunOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_AutomationRun_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_AutomationRun_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.AutomationRun.class,
              com.google.cloud.deploy.v1.AutomationRun.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.AutomationRun.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      etag_ = "";
      serviceAccount_ = "";
      automationSnapshot_ = null;
      if (automationSnapshotBuilder_ != null) {
        automationSnapshotBuilder_.dispose();
        automationSnapshotBuilder_ = null;
      }
      targetId_ = "";
      state_ = 0;
      stateDescription_ = "";
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      ruleId_ = "";
      automationId_ = "";
      if (promoteReleaseOperationBuilder_ != null) {
        promoteReleaseOperationBuilder_.clear();
      }
      if (advanceRolloutOperationBuilder_ != null) {
        advanceRolloutOperationBuilder_.clear();
      }
      if (repairRolloutOperationBuilder_ != null) {
        repairRolloutOperationBuilder_.clear();
      }
      waitUntilTime_ = null;
      if (waitUntilTimeBuilder_ != null) {
        waitUntilTimeBuilder_.dispose();
        waitUntilTimeBuilder_ = null;
      }
      operationCase_ = 0;
      operation_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_AutomationRun_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.AutomationRun getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.AutomationRun.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.AutomationRun build() {
      com.google.cloud.deploy.v1.AutomationRun result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.AutomationRun buildPartial() {
      com.google.cloud.deploy.v1.AutomationRun result =
          new com.google.cloud.deploy.v1.AutomationRun(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.AutomationRun result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.serviceAccount_ = serviceAccount_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.automationSnapshot_ =
            automationSnapshotBuilder_ == null
                ? automationSnapshot_
                : automationSnapshotBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.targetId_ = targetId_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.stateDescription_ = stateDescription_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.expireTime_ = expireTimeBuilder_ == null ? expireTime_ : expireTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.ruleId_ = ruleId_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.automationId_ = automationId_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.waitUntilTime_ =
            waitUntilTimeBuilder_ == null ? waitUntilTime_ : waitUntilTimeBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.deploy.v1.AutomationRun result) {
      result.operationCase_ = operationCase_;
      result.operation_ = this.operation_;
      if (operationCase_ == 13 && promoteReleaseOperationBuilder_ != null) {
        result.operation_ = promoteReleaseOperationBuilder_.build();
      }
      if (operationCase_ == 14 && advanceRolloutOperationBuilder_ != null) {
        result.operation_ = advanceRolloutOperationBuilder_.build();
      }
      if (operationCase_ == 17 && repairRolloutOperationBuilder_ != null) {
        result.operation_ = repairRolloutOperationBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.AutomationRun) {
        return mergeFrom((com.google.cloud.deploy.v1.AutomationRun) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.AutomationRun other) {
      if (other == com.google.cloud.deploy.v1.AutomationRun.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getServiceAccount().isEmpty()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasAutomationSnapshot()) {
        mergeAutomationSnapshot(other.getAutomationSnapshot());
      }
      if (!other.getTargetId().isEmpty()) {
        targetId_ = other.targetId_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getStateDescription().isEmpty()) {
        stateDescription_ = other.stateDescription_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasExpireTime()) {
        mergeExpireTime(other.getExpireTime());
      }
      if (!other.getRuleId().isEmpty()) {
        ruleId_ = other.ruleId_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (!other.getAutomationId().isEmpty()) {
        automationId_ = other.automationId_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.hasWaitUntilTime()) {
        mergeWaitUntilTime(other.getWaitUntilTime());
      }
      switch (other.getOperationCase()) {
        case PROMOTE_RELEASE_OPERATION:
          {
            mergePromoteReleaseOperation(other.getPromoteReleaseOperation());
            break;
          }
        case ADVANCE_ROLLOUT_OPERATION:
          {
            mergeAdvanceRolloutOperation(other.getAdvanceRolloutOperation());
            break;
          }
        case REPAIR_ROLLOUT_OPERATION:
          {
            mergeRepairRolloutOperation(other.getRepairRolloutOperation());
            break;
          }
        case OPERATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getAutomationSnapshotFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                targetId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 74:
              {
                stateDescription_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 90:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            case 98:
              {
                ruleId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getPromoteReleaseOperationFieldBuilder().getBuilder(), extensionRegistry);
                operationCase_ = 13;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(
                    getAdvanceRolloutOperationFieldBuilder().getBuilder(), extensionRegistry);
                operationCase_ = 14;
                break;
              } // case 114
            case 122:
              {
                automationId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 122
            case 130:
              {
                input.readMessage(getWaitUntilTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00008000;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(
                    getRepairRolloutOperationFieldBuilder().getBuilder(), extensionRegistry);
                operationCase_ = 17;
                break;
              } // case 138
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int operationCase_ = 0;
    private java.lang.Object operation_;

    public OperationCase getOperationCase() {
      return OperationCase.forNumber(operationCase_);
    }

    public Builder clearOperation() {
      operationCase_ = 0;
      operation_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the `AutomationRun`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automationRuns/{automation_run}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `AutomationRun`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automationRuns/{automation_run}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `AutomationRun`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automationRuns/{automation_run}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `AutomationRun`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automationRuns/{automation_run}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the `AutomationRun`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automationRuns/{automation_run}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `AutomationRun` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `AutomationRun` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `AutomationRun` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `AutomationRun` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `AutomationRun` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `AutomationRun` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `AutomationRun` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `AutomationRun` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `AutomationRun` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automationRun was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automationRun was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automationRun was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automationRun was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automationRun was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automationRun was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automationRun was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automationRun was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the automationRun was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The weak etag of the `AutomationRun` resource.
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The weak etag of the `AutomationRun` resource.
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The weak etag of the `AutomationRun` resource.
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The weak etag of the `AutomationRun` resource.
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The weak etag of the `AutomationRun` resource.
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccount_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Email address of the user-managed IAM service account that
     * performs the operations against Cloud Deploy resources.
     * </pre>
     *
     * <code>string service_account = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Email address of the user-managed IAM service account that
     * performs the operations against Cloud Deploy resources.
     * </pre>
     *
     * <code>string service_account = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Email address of the user-managed IAM service account that
     * performs the operations against Cloud Deploy resources.
     * </pre>
     *
     * <code>string service_account = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Email address of the user-managed IAM service account that
     * performs the operations against Cloud Deploy resources.
     * </pre>
     *
     * <code>string service_account = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Email address of the user-managed IAM service account that
     * performs the operations against Cloud Deploy resources.
     * </pre>
     *
     * <code>string service_account = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.cloud.deploy.v1.Automation automationSnapshot_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.Automation,
            com.google.cloud.deploy.v1.Automation.Builder,
            com.google.cloud.deploy.v1.AutomationOrBuilder>
        automationSnapshotBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the Automation taken at AutomationRun creation
     * time.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Automation automation_snapshot = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the automationSnapshot field is set.
     */
    public boolean hasAutomationSnapshot() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the Automation taken at AutomationRun creation
     * time.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Automation automation_snapshot = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The automationSnapshot.
     */
    public com.google.cloud.deploy.v1.Automation getAutomationSnapshot() {
      if (automationSnapshotBuilder_ == null) {
        return automationSnapshot_ == null
            ? com.google.cloud.deploy.v1.Automation.getDefaultInstance()
            : automationSnapshot_;
      } else {
        return automationSnapshotBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the Automation taken at AutomationRun creation
     * time.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Automation automation_snapshot = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAutomationSnapshot(com.google.cloud.deploy.v1.Automation value) {
      if (automationSnapshotBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        automationSnapshot_ = value;
      } else {
        automationSnapshotBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the Automation taken at AutomationRun creation
     * time.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Automation automation_snapshot = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAutomationSnapshot(
        com.google.cloud.deploy.v1.Automation.Builder builderForValue) {
      if (automationSnapshotBuilder_ == null) {
        automationSnapshot_ = builderForValue.build();
      } else {
        automationSnapshotBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the Automation taken at AutomationRun creation
     * time.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Automation automation_snapshot = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeAutomationSnapshot(com.google.cloud.deploy.v1.Automation value) {
      if (automationSnapshotBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && automationSnapshot_ != null
            && automationSnapshot_ != com.google.cloud.deploy.v1.Automation.getDefaultInstance()) {
          getAutomationSnapshotBuilder().mergeFrom(value);
        } else {
          automationSnapshot_ = value;
        }
      } else {
        automationSnapshotBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the Automation taken at AutomationRun creation
     * time.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Automation automation_snapshot = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAutomationSnapshot() {
      bitField0_ = (bitField0_ & ~0x00000020);
      automationSnapshot_ = null;
      if (automationSnapshotBuilder_ != null) {
        automationSnapshotBuilder_.dispose();
        automationSnapshotBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the Automation taken at AutomationRun creation
     * time.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Automation automation_snapshot = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.Automation.Builder getAutomationSnapshotBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getAutomationSnapshotFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the Automation taken at AutomationRun creation
     * time.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Automation automation_snapshot = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.AutomationOrBuilder getAutomationSnapshotOrBuilder() {
      if (automationSnapshotBuilder_ != null) {
        return automationSnapshotBuilder_.getMessageOrBuilder();
      } else {
        return automationSnapshot_ == null
            ? com.google.cloud.deploy.v1.Automation.getDefaultInstance()
            : automationSnapshot_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the Automation taken at AutomationRun creation
     * time.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Automation automation_snapshot = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.Automation,
            com.google.cloud.deploy.v1.Automation.Builder,
            com.google.cloud.deploy.v1.AutomationOrBuilder>
        getAutomationSnapshotFieldBuilder() {
      if (automationSnapshotBuilder_ == null) {
        automationSnapshotBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.Automation,
                com.google.cloud.deploy.v1.Automation.Builder,
                com.google.cloud.deploy.v1.AutomationOrBuilder>(
                getAutomationSnapshot(), getParentForChildren(), isClean());
        automationSnapshot_ = null;
      }
      return automationSnapshotBuilder_;
    }

    private java.lang.Object targetId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The ID of the target that represents the promotion stage that
     * initiates the `AutomationRun`. The value of this field is the last segment
     * of a target name.
     * </pre>
     *
     * <code>string target_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The targetId.
     */
    public java.lang.String getTargetId() {
      java.lang.Object ref = targetId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the target that represents the promotion stage that
     * initiates the `AutomationRun`. The value of this field is the last segment
     * of a target name.
     * </pre>
     *
     * <code>string target_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for targetId.
     */
    public com.google.protobuf.ByteString getTargetIdBytes() {
      java.lang.Object ref = targetId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the target that represents the promotion stage that
     * initiates the `AutomationRun`. The value of this field is the last segment
     * of a target name.
     * </pre>
     *
     * <code>string target_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The targetId to set.
     * @return This builder for chaining.
     */
    public Builder setTargetId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      targetId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the target that represents the promotion stage that
     * initiates the `AutomationRun`. The value of this field is the last segment
     * of a target name.
     * </pre>
     *
     * <code>string target_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetId() {
      targetId_ = getDefaultInstance().getTargetId();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the target that represents the promotion stage that
     * initiates the `AutomationRun`. The value of this field is the last segment
     * of a target name.
     * </pre>
     *
     * <code>string target_id = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for targetId to set.
     * @return This builder for chaining.
     */
    public Builder setTargetIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      targetId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Current state of the `AutomationRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRun.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the `AutomationRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRun.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the `AutomationRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRun.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.AutomationRun.State getState() {
      com.google.cloud.deploy.v1.AutomationRun.State result =
          com.google.cloud.deploy.v1.AutomationRun.State.forNumber(state_);
      return result == null ? com.google.cloud.deploy.v1.AutomationRun.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the `AutomationRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRun.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.deploy.v1.AutomationRun.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the `AutomationRun`.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRun.State state = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000080);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object stateDescription_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Explains the current state of the `AutomationRun`. Present
     * only an explanation is needed.
     * </pre>
     *
     * <code>string state_description = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The stateDescription.
     */
    public java.lang.String getStateDescription() {
      java.lang.Object ref = stateDescription_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateDescription_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Explains the current state of the `AutomationRun`. Present
     * only an explanation is needed.
     * </pre>
     *
     * <code>string state_description = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for stateDescription.
     */
    public com.google.protobuf.ByteString getStateDescriptionBytes() {
      java.lang.Object ref = stateDescription_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stateDescription_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Explains the current state of the `AutomationRun`. Present
     * only an explanation is needed.
     * </pre>
     *
     * <code>string state_description = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The stateDescription to set.
     * @return This builder for chaining.
     */
    public Builder setStateDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stateDescription_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Explains the current state of the `AutomationRun`. Present
     * only an explanation is needed.
     * </pre>
     *
     * <code>string state_description = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStateDescription() {
      stateDescription_ = getDefaultInstance().getStateDescription();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Explains the current state of the `AutomationRun`. Present
     * only an explanation is needed.
     * </pre>
     *
     * <code>string state_description = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for stateDescription to set.
     * @return This builder for chaining.
     */
    public Builder setStateDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stateDescription_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp expireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time the `AutomationRun` will expire. An `AutomationRun` will
     * expire after 14 days from its creation date.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the expireTime field is set.
     */
    public boolean hasExpireTime() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the `AutomationRun` will expire. An `AutomationRun` will
     * expire after 14 days from its creation date.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The expireTime.
     */
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      } else {
        return expireTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the `AutomationRun` will expire. An `AutomationRun` will
     * expire after 14 days from its creation date.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expireTime_ = value;
      } else {
        expireTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the `AutomationRun` will expire. An `AutomationRun` will
     * expire after 14 days from its creation date.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expireTime_ = builderForValue.build();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the `AutomationRun` will expire. An `AutomationRun` will
     * expire after 14 days from its creation date.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && expireTime_ != null
            && expireTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getExpireTimeBuilder().mergeFrom(value);
        } else {
          expireTime_ = value;
        }
      } else {
        expireTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the `AutomationRun` will expire. An `AutomationRun` will
     * expire after 14 days from its creation date.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearExpireTime() {
      bitField0_ = (bitField0_ & ~0x00000200);
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the `AutomationRun` will expire. An `AutomationRun` will
     * expire after 14 days from its creation date.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the `AutomationRun` will expire. An `AutomationRun` will
     * expire after 14 days from its creation date.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if (expireTimeBuilder_ != null) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the `AutomationRun` will expire. An `AutomationRun` will
     * expire after 14 days from its creation date.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExpireTime(), getParentForChildren(), isClean());
        expireTime_ = null;
      }
      return expireTimeBuilder_;
    }

    private java.lang.Object ruleId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The ID of the automation rule that initiated the operation.
     * </pre>
     *
     * <code>string rule_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The ruleId.
     */
    public java.lang.String getRuleId() {
      java.lang.Object ref = ruleId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ruleId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the automation rule that initiated the operation.
     * </pre>
     *
     * <code>string rule_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for ruleId.
     */
    public com.google.protobuf.ByteString getRuleIdBytes() {
      java.lang.Object ref = ruleId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ruleId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the automation rule that initiated the operation.
     * </pre>
     *
     * <code>string rule_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The ruleId to set.
     * @return This builder for chaining.
     */
    public Builder setRuleId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ruleId_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the automation rule that initiated the operation.
     * </pre>
     *
     * <code>string rule_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRuleId() {
      ruleId_ = getDefaultInstance().getRuleId();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the automation rule that initiated the operation.
     * </pre>
     *
     * <code>string rule_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for ruleId to set.
     * @return This builder for chaining.
     */
    public Builder setRuleIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ruleId_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object automationId_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The ID of the automation that initiated the operation.
     * </pre>
     *
     * <code>string automation_id = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The automationId.
     */
    public java.lang.String getAutomationId() {
      java.lang.Object ref = automationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        automationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the automation that initiated the operation.
     * </pre>
     *
     * <code>string automation_id = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for automationId.
     */
    public com.google.protobuf.ByteString getAutomationIdBytes() {
      java.lang.Object ref = automationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        automationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the automation that initiated the operation.
     * </pre>
     *
     * <code>string automation_id = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The automationId to set.
     * @return This builder for chaining.
     */
    public Builder setAutomationId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      automationId_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the automation that initiated the operation.
     * </pre>
     *
     * <code>string automation_id = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutomationId() {
      automationId_ = getDefaultInstance().getAutomationId();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The ID of the automation that initiated the operation.
     * </pre>
     *
     * <code>string automation_id = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for automationId to set.
     * @return This builder for chaining.
     */
    public Builder setAutomationIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      automationId_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.PromoteReleaseOperation,
            com.google.cloud.deploy.v1.PromoteReleaseOperation.Builder,
            com.google.cloud.deploy.v1.PromoteReleaseOperationOrBuilder>
        promoteReleaseOperationBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Promotes a release to a specified 'Target'.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PromoteReleaseOperation promote_release_operation = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the promoteReleaseOperation field is set.
     */
    @java.lang.Override
    public boolean hasPromoteReleaseOperation() {
      return operationCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * Output only. Promotes a release to a specified 'Target'.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PromoteReleaseOperation promote_release_operation = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The promoteReleaseOperation.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.PromoteReleaseOperation getPromoteReleaseOperation() {
      if (promoteReleaseOperationBuilder_ == null) {
        if (operationCase_ == 13) {
          return (com.google.cloud.deploy.v1.PromoteReleaseOperation) operation_;
        }
        return com.google.cloud.deploy.v1.PromoteReleaseOperation.getDefaultInstance();
      } else {
        if (operationCase_ == 13) {
          return promoteReleaseOperationBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.PromoteReleaseOperation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Promotes a release to a specified 'Target'.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PromoteReleaseOperation promote_release_operation = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPromoteReleaseOperation(
        com.google.cloud.deploy.v1.PromoteReleaseOperation value) {
      if (promoteReleaseOperationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
        onChanged();
      } else {
        promoteReleaseOperationBuilder_.setMessage(value);
      }
      operationCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Promotes a release to a specified 'Target'.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PromoteReleaseOperation promote_release_operation = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPromoteReleaseOperation(
        com.google.cloud.deploy.v1.PromoteReleaseOperation.Builder builderForValue) {
      if (promoteReleaseOperationBuilder_ == null) {
        operation_ = builderForValue.build();
        onChanged();
      } else {
        promoteReleaseOperationBuilder_.setMessage(builderForValue.build());
      }
      operationCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Promotes a release to a specified 'Target'.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PromoteReleaseOperation promote_release_operation = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePromoteReleaseOperation(
        com.google.cloud.deploy.v1.PromoteReleaseOperation value) {
      if (promoteReleaseOperationBuilder_ == null) {
        if (operationCase_ == 13
            && operation_
                != com.google.cloud.deploy.v1.PromoteReleaseOperation.getDefaultInstance()) {
          operation_ =
              com.google.cloud.deploy.v1.PromoteReleaseOperation.newBuilder(
                      (com.google.cloud.deploy.v1.PromoteReleaseOperation) operation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          operation_ = value;
        }
        onChanged();
      } else {
        if (operationCase_ == 13) {
          promoteReleaseOperationBuilder_.mergeFrom(value);
        } else {
          promoteReleaseOperationBuilder_.setMessage(value);
        }
      }
      operationCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Promotes a release to a specified 'Target'.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PromoteReleaseOperation promote_release_operation = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPromoteReleaseOperation() {
      if (promoteReleaseOperationBuilder_ == null) {
        if (operationCase_ == 13) {
          operationCase_ = 0;
          operation_ = null;
          onChanged();
        }
      } else {
        if (operationCase_ == 13) {
          operationCase_ = 0;
          operation_ = null;
        }
        promoteReleaseOperationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Promotes a release to a specified 'Target'.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PromoteReleaseOperation promote_release_operation = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.PromoteReleaseOperation.Builder
        getPromoteReleaseOperationBuilder() {
      return getPromoteReleaseOperationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Promotes a release to a specified 'Target'.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PromoteReleaseOperation promote_release_operation = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.PromoteReleaseOperationOrBuilder
        getPromoteReleaseOperationOrBuilder() {
      if ((operationCase_ == 13) && (promoteReleaseOperationBuilder_ != null)) {
        return promoteReleaseOperationBuilder_.getMessageOrBuilder();
      } else {
        if (operationCase_ == 13) {
          return (com.google.cloud.deploy.v1.PromoteReleaseOperation) operation_;
        }
        return com.google.cloud.deploy.v1.PromoteReleaseOperation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Promotes a release to a specified 'Target'.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PromoteReleaseOperation promote_release_operation = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.PromoteReleaseOperation,
            com.google.cloud.deploy.v1.PromoteReleaseOperation.Builder,
            com.google.cloud.deploy.v1.PromoteReleaseOperationOrBuilder>
        getPromoteReleaseOperationFieldBuilder() {
      if (promoteReleaseOperationBuilder_ == null) {
        if (!(operationCase_ == 13)) {
          operation_ = com.google.cloud.deploy.v1.PromoteReleaseOperation.getDefaultInstance();
        }
        promoteReleaseOperationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.PromoteReleaseOperation,
                com.google.cloud.deploy.v1.PromoteReleaseOperation.Builder,
                com.google.cloud.deploy.v1.PromoteReleaseOperationOrBuilder>(
                (com.google.cloud.deploy.v1.PromoteReleaseOperation) operation_,
                getParentForChildren(),
                isClean());
        operation_ = null;
      }
      operationCase_ = 13;
      onChanged();
      return promoteReleaseOperationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.AdvanceRolloutOperation,
            com.google.cloud.deploy.v1.AdvanceRolloutOperation.Builder,
            com.google.cloud.deploy.v1.AdvanceRolloutOperationOrBuilder>
        advanceRolloutOperationBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Advances a rollout to the next phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceRolloutOperation advance_rollout_operation = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the advanceRolloutOperation field is set.
     */
    @java.lang.Override
    public boolean hasAdvanceRolloutOperation() {
      return operationCase_ == 14;
    }
    /**
     *
     *
     * <pre>
     * Output only. Advances a rollout to the next phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceRolloutOperation advance_rollout_operation = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The advanceRolloutOperation.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.AdvanceRolloutOperation getAdvanceRolloutOperation() {
      if (advanceRolloutOperationBuilder_ == null) {
        if (operationCase_ == 14) {
          return (com.google.cloud.deploy.v1.AdvanceRolloutOperation) operation_;
        }
        return com.google.cloud.deploy.v1.AdvanceRolloutOperation.getDefaultInstance();
      } else {
        if (operationCase_ == 14) {
          return advanceRolloutOperationBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.AdvanceRolloutOperation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Advances a rollout to the next phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceRolloutOperation advance_rollout_operation = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAdvanceRolloutOperation(
        com.google.cloud.deploy.v1.AdvanceRolloutOperation value) {
      if (advanceRolloutOperationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
        onChanged();
      } else {
        advanceRolloutOperationBuilder_.setMessage(value);
      }
      operationCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Advances a rollout to the next phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceRolloutOperation advance_rollout_operation = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAdvanceRolloutOperation(
        com.google.cloud.deploy.v1.AdvanceRolloutOperation.Builder builderForValue) {
      if (advanceRolloutOperationBuilder_ == null) {
        operation_ = builderForValue.build();
        onChanged();
      } else {
        advanceRolloutOperationBuilder_.setMessage(builderForValue.build());
      }
      operationCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Advances a rollout to the next phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceRolloutOperation advance_rollout_operation = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeAdvanceRolloutOperation(
        com.google.cloud.deploy.v1.AdvanceRolloutOperation value) {
      if (advanceRolloutOperationBuilder_ == null) {
        if (operationCase_ == 14
            && operation_
                != com.google.cloud.deploy.v1.AdvanceRolloutOperation.getDefaultInstance()) {
          operation_ =
              com.google.cloud.deploy.v1.AdvanceRolloutOperation.newBuilder(
                      (com.google.cloud.deploy.v1.AdvanceRolloutOperation) operation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          operation_ = value;
        }
        onChanged();
      } else {
        if (operationCase_ == 14) {
          advanceRolloutOperationBuilder_.mergeFrom(value);
        } else {
          advanceRolloutOperationBuilder_.setMessage(value);
        }
      }
      operationCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Advances a rollout to the next phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceRolloutOperation advance_rollout_operation = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAdvanceRolloutOperation() {
      if (advanceRolloutOperationBuilder_ == null) {
        if (operationCase_ == 14) {
          operationCase_ = 0;
          operation_ = null;
          onChanged();
        }
      } else {
        if (operationCase_ == 14) {
          operationCase_ = 0;
          operation_ = null;
        }
        advanceRolloutOperationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Advances a rollout to the next phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceRolloutOperation advance_rollout_operation = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.AdvanceRolloutOperation.Builder
        getAdvanceRolloutOperationBuilder() {
      return getAdvanceRolloutOperationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Advances a rollout to the next phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceRolloutOperation advance_rollout_operation = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.AdvanceRolloutOperationOrBuilder
        getAdvanceRolloutOperationOrBuilder() {
      if ((operationCase_ == 14) && (advanceRolloutOperationBuilder_ != null)) {
        return advanceRolloutOperationBuilder_.getMessageOrBuilder();
      } else {
        if (operationCase_ == 14) {
          return (com.google.cloud.deploy.v1.AdvanceRolloutOperation) operation_;
        }
        return com.google.cloud.deploy.v1.AdvanceRolloutOperation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Advances a rollout to the next phase.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AdvanceRolloutOperation advance_rollout_operation = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.AdvanceRolloutOperation,
            com.google.cloud.deploy.v1.AdvanceRolloutOperation.Builder,
            com.google.cloud.deploy.v1.AdvanceRolloutOperationOrBuilder>
        getAdvanceRolloutOperationFieldBuilder() {
      if (advanceRolloutOperationBuilder_ == null) {
        if (!(operationCase_ == 14)) {
          operation_ = com.google.cloud.deploy.v1.AdvanceRolloutOperation.getDefaultInstance();
        }
        advanceRolloutOperationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.AdvanceRolloutOperation,
                com.google.cloud.deploy.v1.AdvanceRolloutOperation.Builder,
                com.google.cloud.deploy.v1.AdvanceRolloutOperationOrBuilder>(
                (com.google.cloud.deploy.v1.AdvanceRolloutOperation) operation_,
                getParentForChildren(),
                isClean());
        operation_ = null;
      }
      operationCase_ = 14;
      onChanged();
      return advanceRolloutOperationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.RepairRolloutOperation,
            com.google.cloud.deploy.v1.RepairRolloutOperation.Builder,
            com.google.cloud.deploy.v1.RepairRolloutOperationOrBuilder>
        repairRolloutOperationBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Repairs a failed 'Rollout'.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairRolloutOperation repair_rollout_operation = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the repairRolloutOperation field is set.
     */
    @java.lang.Override
    public boolean hasRepairRolloutOperation() {
      return operationCase_ == 17;
    }
    /**
     *
     *
     * <pre>
     * Output only. Repairs a failed 'Rollout'.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairRolloutOperation repair_rollout_operation = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The repairRolloutOperation.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.RepairRolloutOperation getRepairRolloutOperation() {
      if (repairRolloutOperationBuilder_ == null) {
        if (operationCase_ == 17) {
          return (com.google.cloud.deploy.v1.RepairRolloutOperation) operation_;
        }
        return com.google.cloud.deploy.v1.RepairRolloutOperation.getDefaultInstance();
      } else {
        if (operationCase_ == 17) {
          return repairRolloutOperationBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.RepairRolloutOperation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Repairs a failed 'Rollout'.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairRolloutOperation repair_rollout_operation = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRepairRolloutOperation(
        com.google.cloud.deploy.v1.RepairRolloutOperation value) {
      if (repairRolloutOperationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        operation_ = value;
        onChanged();
      } else {
        repairRolloutOperationBuilder_.setMessage(value);
      }
      operationCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Repairs a failed 'Rollout'.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairRolloutOperation repair_rollout_operation = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRepairRolloutOperation(
        com.google.cloud.deploy.v1.RepairRolloutOperation.Builder builderForValue) {
      if (repairRolloutOperationBuilder_ == null) {
        operation_ = builderForValue.build();
        onChanged();
      } else {
        repairRolloutOperationBuilder_.setMessage(builderForValue.build());
      }
      operationCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Repairs a failed 'Rollout'.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairRolloutOperation repair_rollout_operation = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRepairRolloutOperation(
        com.google.cloud.deploy.v1.RepairRolloutOperation value) {
      if (repairRolloutOperationBuilder_ == null) {
        if (operationCase_ == 17
            && operation_
                != com.google.cloud.deploy.v1.RepairRolloutOperation.getDefaultInstance()) {
          operation_ =
              com.google.cloud.deploy.v1.RepairRolloutOperation.newBuilder(
                      (com.google.cloud.deploy.v1.RepairRolloutOperation) operation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          operation_ = value;
        }
        onChanged();
      } else {
        if (operationCase_ == 17) {
          repairRolloutOperationBuilder_.mergeFrom(value);
        } else {
          repairRolloutOperationBuilder_.setMessage(value);
        }
      }
      operationCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Repairs a failed 'Rollout'.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairRolloutOperation repair_rollout_operation = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRepairRolloutOperation() {
      if (repairRolloutOperationBuilder_ == null) {
        if (operationCase_ == 17) {
          operationCase_ = 0;
          operation_ = null;
          onChanged();
        }
      } else {
        if (operationCase_ == 17) {
          operationCase_ = 0;
          operation_ = null;
        }
        repairRolloutOperationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Repairs a failed 'Rollout'.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairRolloutOperation repair_rollout_operation = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.RepairRolloutOperation.Builder
        getRepairRolloutOperationBuilder() {
      return getRepairRolloutOperationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Repairs a failed 'Rollout'.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairRolloutOperation repair_rollout_operation = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.RepairRolloutOperationOrBuilder
        getRepairRolloutOperationOrBuilder() {
      if ((operationCase_ == 17) && (repairRolloutOperationBuilder_ != null)) {
        return repairRolloutOperationBuilder_.getMessageOrBuilder();
      } else {
        if (operationCase_ == 17) {
          return (com.google.cloud.deploy.v1.RepairRolloutOperation) operation_;
        }
        return com.google.cloud.deploy.v1.RepairRolloutOperation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Repairs a failed 'Rollout'.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RepairRolloutOperation repair_rollout_operation = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.RepairRolloutOperation,
            com.google.cloud.deploy.v1.RepairRolloutOperation.Builder,
            com.google.cloud.deploy.v1.RepairRolloutOperationOrBuilder>
        getRepairRolloutOperationFieldBuilder() {
      if (repairRolloutOperationBuilder_ == null) {
        if (!(operationCase_ == 17)) {
          operation_ = com.google.cloud.deploy.v1.RepairRolloutOperation.getDefaultInstance();
        }
        repairRolloutOperationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.RepairRolloutOperation,
                com.google.cloud.deploy.v1.RepairRolloutOperation.Builder,
                com.google.cloud.deploy.v1.RepairRolloutOperationOrBuilder>(
                (com.google.cloud.deploy.v1.RepairRolloutOperation) operation_,
                getParentForChildren(),
                isClean());
        operation_ = null;
      }
      operationCase_ = 17;
      onChanged();
      return repairRolloutOperationBuilder_;
    }

    private com.google.protobuf.Timestamp waitUntilTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        waitUntilTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Earliest time the `AutomationRun` will attempt to resume.
     * Wait-time is configured by `wait` in automation rule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp wait_until_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the waitUntilTime field is set.
     */
    public boolean hasWaitUntilTime() {
      return ((bitField0_ & 0x00008000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest time the `AutomationRun` will attempt to resume.
     * Wait-time is configured by `wait` in automation rule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp wait_until_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The waitUntilTime.
     */
    public com.google.protobuf.Timestamp getWaitUntilTime() {
      if (waitUntilTimeBuilder_ == null) {
        return waitUntilTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : waitUntilTime_;
      } else {
        return waitUntilTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest time the `AutomationRun` will attempt to resume.
     * Wait-time is configured by `wait` in automation rule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp wait_until_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setWaitUntilTime(com.google.protobuf.Timestamp value) {
      if (waitUntilTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        waitUntilTime_ = value;
      } else {
        waitUntilTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest time the `AutomationRun` will attempt to resume.
     * Wait-time is configured by `wait` in automation rule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp wait_until_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setWaitUntilTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (waitUntilTimeBuilder_ == null) {
        waitUntilTime_ = builderForValue.build();
      } else {
        waitUntilTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest time the `AutomationRun` will attempt to resume.
     * Wait-time is configured by `wait` in automation rule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp wait_until_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeWaitUntilTime(com.google.protobuf.Timestamp value) {
      if (waitUntilTimeBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)
            && waitUntilTime_ != null
            && waitUntilTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getWaitUntilTimeBuilder().mergeFrom(value);
        } else {
          waitUntilTime_ = value;
        }
      } else {
        waitUntilTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest time the `AutomationRun` will attempt to resume.
     * Wait-time is configured by `wait` in automation rule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp wait_until_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearWaitUntilTime() {
      bitField0_ = (bitField0_ & ~0x00008000);
      waitUntilTime_ = null;
      if (waitUntilTimeBuilder_ != null) {
        waitUntilTimeBuilder_.dispose();
        waitUntilTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest time the `AutomationRun` will attempt to resume.
     * Wait-time is configured by `wait` in automation rule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp wait_until_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getWaitUntilTimeBuilder() {
      bitField0_ |= 0x00008000;
      onChanged();
      return getWaitUntilTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest time the `AutomationRun` will attempt to resume.
     * Wait-time is configured by `wait` in automation rule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp wait_until_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getWaitUntilTimeOrBuilder() {
      if (waitUntilTimeBuilder_ != null) {
        return waitUntilTimeBuilder_.getMessageOrBuilder();
      } else {
        return waitUntilTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : waitUntilTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Earliest time the `AutomationRun` will attempt to resume.
     * Wait-time is configured by `wait` in automation rule.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp wait_until_time = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getWaitUntilTimeFieldBuilder() {
      if (waitUntilTimeBuilder_ == null) {
        waitUntilTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getWaitUntilTime(), getParentForChildren(), isClean());
        waitUntilTime_ = null;
      }
      return waitUntilTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.AutomationRun)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.AutomationRun)
  private static final com.google.cloud.deploy.v1.AutomationRun DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.AutomationRun();
  }

  public static com.google.cloud.deploy.v1.AutomationRun getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AutomationRun> PARSER =
      new com.google.protobuf.AbstractParser<AutomationRun>() {
        @java.lang.Override
        public AutomationRun parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AutomationRun> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AutomationRun> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.AutomationRun getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
