/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * CreateRolloutRequest is the request object used by `CreateRollout`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.CreateRolloutRequest}
 */
public final class CreateRolloutRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.CreateRolloutRequest)
    CreateRolloutRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateRolloutRequest.newBuilder() to construct.
  private CreateRolloutRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateRolloutRequest() {
    parent_ = "";
    rolloutId_ = "";
    requestId_ = "";
    startingPhaseId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateRolloutRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_CreateRolloutRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_CreateRolloutRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.CreateRolloutRequest.class,
            com.google.cloud.deploy.v1.CreateRolloutRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The parent collection in which the `Rollout` should be created.
   * Format should be
   * `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The parent collection in which the `Rollout` should be created.
   * Format should be
   * `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROLLOUT_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rolloutId_ = "";
  /**
   *
   *
   * <pre>
   * Required. ID of the `Rollout`.
   * </pre>
   *
   * <code>string rollout_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The rolloutId.
   */
  @java.lang.Override
  public java.lang.String getRolloutId() {
    java.lang.Object ref = rolloutId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rolloutId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. ID of the `Rollout`.
   * </pre>
   *
   * <code>string rollout_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for rolloutId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRolloutIdBytes() {
    java.lang.Object ref = rolloutId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rolloutId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROLLOUT_FIELD_NUMBER = 3;
  private com.google.cloud.deploy.v1.Rollout rollout_;
  /**
   *
   *
   * <pre>
   * Required. The `Rollout` to create.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.Rollout rollout = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the rollout field is set.
   */
  @java.lang.Override
  public boolean hasRollout() {
    return rollout_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The `Rollout` to create.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.Rollout rollout = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The rollout.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.Rollout getRollout() {
    return rollout_ == null ? com.google.cloud.deploy.v1.Rollout.getDefaultInstance() : rollout_;
  }
  /**
   *
   *
   * <pre>
   * Required. The `Rollout` to create.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.Rollout rollout = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RolloutOrBuilder getRolloutOrBuilder() {
    return rollout_ == null ? com.google.cloud.deploy.v1.Rollout.getDefaultInstance() : rollout_;
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A request ID to identify requests. Specify a unique request ID
   * so that if you must retry your request, the server will know to ignore
   * the request if it has already been completed. The server will guarantee
   * that for at least 60 minutes since the first request.
   *
   * For example, consider a situation where you make an initial request and the
   * request times out. If you make the request again with the same request ID,
   * the server can check if original operation with the same request ID was
   * received, and if so, will ignore the second request. This prevents clients
   * from accidentally creating duplicate commitments.
   *
   * The request ID must be a valid UUID with the exception that zero UUID is
   * not supported (00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A request ID to identify requests. Specify a unique request ID
   * so that if you must retry your request, the server will know to ignore
   * the request if it has already been completed. The server will guarantee
   * that for at least 60 minutes since the first request.
   *
   * For example, consider a situation where you make an initial request and the
   * request times out. If you make the request again with the same request ID,
   * the server can check if original operation with the same request ID was
   * received, and if so, will ignore the second request. This prevents clients
   * from accidentally creating duplicate commitments.
   *
   * The request ID must be a valid UUID with the exception that zero UUID is
   * not supported (00000000-0000-0000-0000-000000000000).
   * </pre>
   *
   * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALIDATE_ONLY_FIELD_NUMBER = 5;
  private boolean validateOnly_ = false;
  /**
   *
   *
   * <pre>
   * Optional. If set to true, the request is validated and the user is provided
   * with an expected result, but no actual change is made.
   * </pre>
   *
   * <code>bool validate_only = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The validateOnly.
   */
  @java.lang.Override
  public boolean getValidateOnly() {
    return validateOnly_;
  }

  public static final int STARTING_PHASE_ID_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object startingPhaseId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. The starting phase ID for the `Rollout`. If empty the `Rollout`
   * will start at the first phase.
   * </pre>
   *
   * <code>string starting_phase_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The startingPhaseId.
   */
  @java.lang.Override
  public java.lang.String getStartingPhaseId() {
    java.lang.Object ref = startingPhaseId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      startingPhaseId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The starting phase ID for the `Rollout`. If empty the `Rollout`
   * will start at the first phase.
   * </pre>
   *
   * <code>string starting_phase_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for startingPhaseId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStartingPhaseIdBytes() {
    java.lang.Object ref = startingPhaseId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      startingPhaseId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rolloutId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, rolloutId_);
    }
    if (rollout_ != null) {
      output.writeMessage(3, getRollout());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, requestId_);
    }
    if (validateOnly_ != false) {
      output.writeBool(5, validateOnly_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(startingPhaseId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, startingPhaseId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rolloutId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, rolloutId_);
    }
    if (rollout_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRollout());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, requestId_);
    }
    if (validateOnly_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, validateOnly_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(startingPhaseId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, startingPhaseId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.CreateRolloutRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.CreateRolloutRequest other =
        (com.google.cloud.deploy.v1.CreateRolloutRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getRolloutId().equals(other.getRolloutId())) return false;
    if (hasRollout() != other.hasRollout()) return false;
    if (hasRollout()) {
      if (!getRollout().equals(other.getRollout())) return false;
    }
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (getValidateOnly() != other.getValidateOnly()) return false;
    if (!getStartingPhaseId().equals(other.getStartingPhaseId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + ROLLOUT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRolloutId().hashCode();
    if (hasRollout()) {
      hash = (37 * hash) + ROLLOUT_FIELD_NUMBER;
      hash = (53 * hash) + getRollout().hashCode();
    }
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (37 * hash) + VALIDATE_ONLY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getValidateOnly());
    hash = (37 * hash) + STARTING_PHASE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getStartingPhaseId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.CreateRolloutRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.CreateRolloutRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CreateRolloutRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.CreateRolloutRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CreateRolloutRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.CreateRolloutRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CreateRolloutRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.CreateRolloutRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CreateRolloutRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.CreateRolloutRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.CreateRolloutRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.CreateRolloutRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.CreateRolloutRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * CreateRolloutRequest is the request object used by `CreateRollout`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.CreateRolloutRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.CreateRolloutRequest)
      com.google.cloud.deploy.v1.CreateRolloutRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_CreateRolloutRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_CreateRolloutRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.CreateRolloutRequest.class,
              com.google.cloud.deploy.v1.CreateRolloutRequest.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.CreateRolloutRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      rolloutId_ = "";
      rollout_ = null;
      if (rolloutBuilder_ != null) {
        rolloutBuilder_.dispose();
        rolloutBuilder_ = null;
      }
      requestId_ = "";
      validateOnly_ = false;
      startingPhaseId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_CreateRolloutRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.CreateRolloutRequest getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.CreateRolloutRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.CreateRolloutRequest build() {
      com.google.cloud.deploy.v1.CreateRolloutRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.CreateRolloutRequest buildPartial() {
      com.google.cloud.deploy.v1.CreateRolloutRequest result =
          new com.google.cloud.deploy.v1.CreateRolloutRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.CreateRolloutRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.rolloutId_ = rolloutId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.rollout_ = rolloutBuilder_ == null ? rollout_ : rolloutBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.requestId_ = requestId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.validateOnly_ = validateOnly_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.startingPhaseId_ = startingPhaseId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.CreateRolloutRequest) {
        return mergeFrom((com.google.cloud.deploy.v1.CreateRolloutRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.CreateRolloutRequest other) {
      if (other == com.google.cloud.deploy.v1.CreateRolloutRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getRolloutId().isEmpty()) {
        rolloutId_ = other.rolloutId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasRollout()) {
        mergeRollout(other.getRollout());
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getValidateOnly() != false) {
        setValidateOnly(other.getValidateOnly());
      }
      if (!other.getStartingPhaseId().isEmpty()) {
        startingPhaseId_ = other.startingPhaseId_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                rolloutId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getRolloutFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                validateOnly_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 58:
              {
                startingPhaseId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The parent collection in which the `Rollout` should be created.
     * Format should be
     * `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent collection in which the `Rollout` should be created.
     * Format should be
     * `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The parent collection in which the `Rollout` should be created.
     * Format should be
     * `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent collection in which the `Rollout` should be created.
     * Format should be
     * `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The parent collection in which the `Rollout` should be created.
     * Format should be
     * `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object rolloutId_ = "";
    /**
     *
     *
     * <pre>
     * Required. ID of the `Rollout`.
     * </pre>
     *
     * <code>string rollout_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The rolloutId.
     */
    public java.lang.String getRolloutId() {
      java.lang.Object ref = rolloutId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rolloutId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the `Rollout`.
     * </pre>
     *
     * <code>string rollout_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for rolloutId.
     */
    public com.google.protobuf.ByteString getRolloutIdBytes() {
      java.lang.Object ref = rolloutId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rolloutId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the `Rollout`.
     * </pre>
     *
     * <code>string rollout_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The rolloutId to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rolloutId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the `Rollout`.
     * </pre>
     *
     * <code>string rollout_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRolloutId() {
      rolloutId_ = getDefaultInstance().getRolloutId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the `Rollout`.
     * </pre>
     *
     * <code>string rollout_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for rolloutId to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rolloutId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.deploy.v1.Rollout rollout_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.Rollout,
            com.google.cloud.deploy.v1.Rollout.Builder,
            com.google.cloud.deploy.v1.RolloutOrBuilder>
        rolloutBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The `Rollout` to create.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.Rollout rollout = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the rollout field is set.
     */
    public boolean hasRollout() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The `Rollout` to create.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.Rollout rollout = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The rollout.
     */
    public com.google.cloud.deploy.v1.Rollout getRollout() {
      if (rolloutBuilder_ == null) {
        return rollout_ == null
            ? com.google.cloud.deploy.v1.Rollout.getDefaultInstance()
            : rollout_;
      } else {
        return rolloutBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The `Rollout` to create.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.Rollout rollout = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRollout(com.google.cloud.deploy.v1.Rollout value) {
      if (rolloutBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rollout_ = value;
      } else {
        rolloutBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `Rollout` to create.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.Rollout rollout = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRollout(com.google.cloud.deploy.v1.Rollout.Builder builderForValue) {
      if (rolloutBuilder_ == null) {
        rollout_ = builderForValue.build();
      } else {
        rolloutBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `Rollout` to create.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.Rollout rollout = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeRollout(com.google.cloud.deploy.v1.Rollout value) {
      if (rolloutBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && rollout_ != null
            && rollout_ != com.google.cloud.deploy.v1.Rollout.getDefaultInstance()) {
          getRolloutBuilder().mergeFrom(value);
        } else {
          rollout_ = value;
        }
      } else {
        rolloutBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `Rollout` to create.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.Rollout rollout = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearRollout() {
      bitField0_ = (bitField0_ & ~0x00000004);
      rollout_ = null;
      if (rolloutBuilder_ != null) {
        rolloutBuilder_.dispose();
        rolloutBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `Rollout` to create.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.Rollout rollout = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.Rollout.Builder getRolloutBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getRolloutFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The `Rollout` to create.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.Rollout rollout = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.RolloutOrBuilder getRolloutOrBuilder() {
      if (rolloutBuilder_ != null) {
        return rolloutBuilder_.getMessageOrBuilder();
      } else {
        return rollout_ == null
            ? com.google.cloud.deploy.v1.Rollout.getDefaultInstance()
            : rollout_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The `Rollout` to create.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.Rollout rollout = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.Rollout,
            com.google.cloud.deploy.v1.Rollout.Builder,
            com.google.cloud.deploy.v1.RolloutOrBuilder>
        getRolloutFieldBuilder() {
      if (rolloutBuilder_ == null) {
        rolloutBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.Rollout,
                com.google.cloud.deploy.v1.Rollout.Builder,
                com.google.cloud.deploy.v1.RolloutOrBuilder>(
                getRollout(), getParentForChildren(), isClean());
        rollout_ = null;
      }
      return rolloutBuilder_;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A request ID to identify requests. Specify a unique request ID
     * so that if you must retry your request, the server will know to ignore
     * the request if it has already been completed. The server will guarantee
     * that for at least 60 minutes since the first request.
     *
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID,
     * the server can check if original operation with the same request ID was
     * received, and if so, will ignore the second request. This prevents clients
     * from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID to identify requests. Specify a unique request ID
     * so that if you must retry your request, the server will know to ignore
     * the request if it has already been completed. The server will guarantee
     * that for at least 60 minutes since the first request.
     *
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID,
     * the server can check if original operation with the same request ID was
     * received, and if so, will ignore the second request. This prevents clients
     * from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID to identify requests. Specify a unique request ID
     * so that if you must retry your request, the server will know to ignore
     * the request if it has already been completed. The server will guarantee
     * that for at least 60 minutes since the first request.
     *
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID,
     * the server can check if original operation with the same request ID was
     * received, and if so, will ignore the second request. This prevents clients
     * from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID to identify requests. Specify a unique request ID
     * so that if you must retry your request, the server will know to ignore
     * the request if it has already been completed. The server will guarantee
     * that for at least 60 minutes since the first request.
     *
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID,
     * the server can check if original operation with the same request ID was
     * received, and if so, will ignore the second request. This prevents clients
     * from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A request ID to identify requests. Specify a unique request ID
     * so that if you must retry your request, the server will know to ignore
     * the request if it has already been completed. The server will guarantee
     * that for at least 60 minutes since the first request.
     *
     * For example, consider a situation where you make an initial request and the
     * request times out. If you make the request again with the same request ID,
     * the server can check if original operation with the same request ID was
     * received, and if so, will ignore the second request. This prevents clients
     * from accidentally creating duplicate commitments.
     *
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     * </pre>
     *
     * <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean validateOnly_;
    /**
     *
     *
     * <pre>
     * Optional. If set to true, the request is validated and the user is provided
     * with an expected result, but no actual change is made.
     * </pre>
     *
     * <code>bool validate_only = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The validateOnly.
     */
    @java.lang.Override
    public boolean getValidateOnly() {
      return validateOnly_;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set to true, the request is validated and the user is provided
     * with an expected result, but no actual change is made.
     * </pre>
     *
     * <code>bool validate_only = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The validateOnly to set.
     * @return This builder for chaining.
     */
    public Builder setValidateOnly(boolean value) {

      validateOnly_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If set to true, the request is validated and the user is provided
     * with an expected result, but no actual change is made.
     * </pre>
     *
     * <code>bool validate_only = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidateOnly() {
      bitField0_ = (bitField0_ & ~0x00000010);
      validateOnly_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object startingPhaseId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The starting phase ID for the `Rollout`. If empty the `Rollout`
     * will start at the first phase.
     * </pre>
     *
     * <code>string starting_phase_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The startingPhaseId.
     */
    public java.lang.String getStartingPhaseId() {
      java.lang.Object ref = startingPhaseId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        startingPhaseId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The starting phase ID for the `Rollout`. If empty the `Rollout`
     * will start at the first phase.
     * </pre>
     *
     * <code>string starting_phase_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for startingPhaseId.
     */
    public com.google.protobuf.ByteString getStartingPhaseIdBytes() {
      java.lang.Object ref = startingPhaseId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        startingPhaseId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The starting phase ID for the `Rollout`. If empty the `Rollout`
     * will start at the first phase.
     * </pre>
     *
     * <code>string starting_phase_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The startingPhaseId to set.
     * @return This builder for chaining.
     */
    public Builder setStartingPhaseId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      startingPhaseId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The starting phase ID for the `Rollout`. If empty the `Rollout`
     * will start at the first phase.
     * </pre>
     *
     * <code>string starting_phase_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStartingPhaseId() {
      startingPhaseId_ = getDefaultInstance().getStartingPhaseId();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The starting phase ID for the `Rollout`. If empty the `Rollout`
     * will start at the first phase.
     * </pre>
     *
     * <code>string starting_phase_id = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for startingPhaseId to set.
     * @return This builder for chaining.
     */
    public Builder setStartingPhaseIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      startingPhaseId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.CreateRolloutRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.CreateRolloutRequest)
  private static final com.google.cloud.deploy.v1.CreateRolloutRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.CreateRolloutRequest();
  }

  public static com.google.cloud.deploy.v1.CreateRolloutRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateRolloutRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateRolloutRequest>() {
        @java.lang.Override
        public CreateRolloutRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateRolloutRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateRolloutRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.CreateRolloutRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
