/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * A `DeliveryPipeline` resource in the Cloud Deploy API.
 *
 * A `DeliveryPipeline` defines a pipeline through which a Skaffold
 * configuration can progress.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.DeliveryPipeline}
 */
public final class DeliveryPipeline extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.DeliveryPipeline)
    DeliveryPipelineOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DeliveryPipeline.newBuilder() to construct.
  private DeliveryPipeline(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DeliveryPipeline() {
    name_ = "";
    uid_ = "";
    description_ = "";
    etag_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DeliveryPipeline();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_DeliveryPipeline_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetAnnotations();
      case 5:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_DeliveryPipeline_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.DeliveryPipeline.class,
            com.google.cloud.deploy.v1.DeliveryPipeline.Builder.class);
  }

  private int pipelineCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object pipeline_;

  public enum PipelineCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SERIAL_PIPELINE(8),
    PIPELINE_NOT_SET(0);
    private final int value;

    private PipelineCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PipelineCase valueOf(int value) {
      return forNumber(value);
    }

    public static PipelineCase forNumber(int value) {
      switch (value) {
        case 8:
          return SERIAL_PIPELINE;
        case 0:
          return PIPELINE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PipelineCase getPipelineCase() {
    return PipelineCase.forNumber(pipelineCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Name of the `DeliveryPipeline`. Format is
   * `projects/{project}/locations/{location}/deliveryPipelines/[a-z][a-z0-9&#92;-]{0,62}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Name of the `DeliveryPipeline`. Format is
   * `projects/{project}/locations/{location}/deliveryPipelines/[a-z][a-z0-9&#92;-]{0,62}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the `DeliveryPipeline`.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the `DeliveryPipeline`.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Description of the `DeliveryPipeline`. Max length is 255 characters.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Description of the `DeliveryPipeline`. Max length is 255 characters.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 4;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.deploy.v1.CloudDeployProto
                .internal_static_google_cloud_deploy_v1_DeliveryPipeline_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LABELS_FIELD_NUMBER = 5;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.deploy.v1.CloudDeployProto
                .internal_static_google_cloud_deploy_v1_DeliveryPipeline_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the pipeline was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the pipeline was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the pipeline was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Most recent time at which the pipeline was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Most recent time at which the pipeline was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Most recent time at which the pipeline was updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int SERIAL_PIPELINE_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * SerialPipeline defines a sequential set of stages for a
   * `DeliveryPipeline`.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.SerialPipeline serial_pipeline = 8;</code>
   *
   * @return Whether the serialPipeline field is set.
   */
  @java.lang.Override
  public boolean hasSerialPipeline() {
    return pipelineCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * SerialPipeline defines a sequential set of stages for a
   * `DeliveryPipeline`.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.SerialPipeline serial_pipeline = 8;</code>
   *
   * @return The serialPipeline.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.SerialPipeline getSerialPipeline() {
    if (pipelineCase_ == 8) {
      return (com.google.cloud.deploy.v1.SerialPipeline) pipeline_;
    }
    return com.google.cloud.deploy.v1.SerialPipeline.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * SerialPipeline defines a sequential set of stages for a
   * `DeliveryPipeline`.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.SerialPipeline serial_pipeline = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.SerialPipelineOrBuilder getSerialPipelineOrBuilder() {
    if (pipelineCase_ == 8) {
      return (com.google.cloud.deploy.v1.SerialPipeline) pipeline_;
    }
    return com.google.cloud.deploy.v1.SerialPipeline.getDefaultInstance();
  }

  public static final int CONDITION_FIELD_NUMBER = 11;
  private com.google.cloud.deploy.v1.PipelineCondition condition_;
  /**
   *
   *
   * <pre>
   * Output only. Information around the state of the Delivery Pipeline.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PipelineCondition condition = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the condition field is set.
   */
  @java.lang.Override
  public boolean hasCondition() {
    return condition_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information around the state of the Delivery Pipeline.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PipelineCondition condition = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The condition.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.PipelineCondition getCondition() {
    return condition_ == null
        ? com.google.cloud.deploy.v1.PipelineCondition.getDefaultInstance()
        : condition_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information around the state of the Delivery Pipeline.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.PipelineCondition condition = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.PipelineConditionOrBuilder getConditionOrBuilder() {
    return condition_ == null
        ? com.google.cloud.deploy.v1.PipelineCondition.getDefaultInstance()
        : condition_;
  }

  public static final int ETAG_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 10;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 10;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUSPENDED_FIELD_NUMBER = 12;
  private boolean suspended_ = false;
  /**
   *
   *
   * <pre>
   * When suspended, no new releases or rollouts can be created,
   * but in-progress ones will complete.
   * </pre>
   *
   * <code>bool suspended = 12;</code>
   *
   * @return The suspended.
   */
  @java.lang.Override
  public boolean getSuspended() {
    return suspended_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 4);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 5);
    if (createTime_ != null) {
      output.writeMessage(6, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(7, getUpdateTime());
    }
    if (pipelineCase_ == 8) {
      output.writeMessage(8, (com.google.cloud.deploy.v1.SerialPipeline) pipeline_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, etag_);
    }
    if (condition_ != null) {
      output.writeMessage(11, getCondition());
    }
    if (suspended_ != false) {
      output.writeBool(12, suspended_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, annotations__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, labels__);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getUpdateTime());
    }
    if (pipelineCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.deploy.v1.SerialPipeline) pipeline_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, etag_);
    }
    if (condition_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getCondition());
    }
    if (suspended_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(12, suspended_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.DeliveryPipeline)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.DeliveryPipeline other =
        (com.google.cloud.deploy.v1.DeliveryPipeline) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasCondition() != other.hasCondition()) return false;
    if (hasCondition()) {
      if (!getCondition().equals(other.getCondition())) return false;
    }
    if (!getEtag().equals(other.getEtag())) return false;
    if (getSuspended() != other.getSuspended()) return false;
    if (!getPipelineCase().equals(other.getPipelineCase())) return false;
    switch (pipelineCase_) {
      case 8:
        if (!getSerialPipeline().equals(other.getSerialPipeline())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasCondition()) {
      hash = (37 * hash) + CONDITION_FIELD_NUMBER;
      hash = (53 * hash) + getCondition().hashCode();
    }
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + SUSPENDED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSuspended());
    switch (pipelineCase_) {
      case 8:
        hash = (37 * hash) + SERIAL_PIPELINE_FIELD_NUMBER;
        hash = (53 * hash) + getSerialPipeline().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.DeliveryPipeline parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.DeliveryPipeline parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.DeliveryPipeline parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.DeliveryPipeline parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.DeliveryPipeline parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.DeliveryPipeline parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.DeliveryPipeline parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.DeliveryPipeline parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.DeliveryPipeline parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.DeliveryPipeline parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.DeliveryPipeline parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.DeliveryPipeline parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.DeliveryPipeline prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A `DeliveryPipeline` resource in the Cloud Deploy API.
   *
   * A `DeliveryPipeline` defines a pipeline through which a Skaffold
   * configuration can progress.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.DeliveryPipeline}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.DeliveryPipeline)
      com.google.cloud.deploy.v1.DeliveryPipelineOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_DeliveryPipeline_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetAnnotations();
        case 5:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableAnnotations();
        case 5:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_DeliveryPipeline_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.DeliveryPipeline.class,
              com.google.cloud.deploy.v1.DeliveryPipeline.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.DeliveryPipeline.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      uid_ = "";
      description_ = "";
      internalGetMutableAnnotations().clear();
      internalGetMutableLabels().clear();
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      if (serialPipelineBuilder_ != null) {
        serialPipelineBuilder_.clear();
      }
      condition_ = null;
      if (conditionBuilder_ != null) {
        conditionBuilder_.dispose();
        conditionBuilder_ = null;
      }
      etag_ = "";
      suspended_ = false;
      pipelineCase_ = 0;
      pipeline_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_DeliveryPipeline_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.DeliveryPipeline getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.DeliveryPipeline.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.DeliveryPipeline build() {
      com.google.cloud.deploy.v1.DeliveryPipeline result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.DeliveryPipeline buildPartial() {
      com.google.cloud.deploy.v1.DeliveryPipeline result =
          new com.google.cloud.deploy.v1.DeliveryPipeline(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.DeliveryPipeline result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uid_ = uid_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.condition_ = conditionBuilder_ == null ? condition_ : conditionBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.suspended_ = suspended_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.deploy.v1.DeliveryPipeline result) {
      result.pipelineCase_ = pipelineCase_;
      result.pipeline_ = this.pipeline_;
      if (pipelineCase_ == 8 && serialPipelineBuilder_ != null) {
        result.pipeline_ = serialPipelineBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.DeliveryPipeline) {
        return mergeFrom((com.google.cloud.deploy.v1.DeliveryPipeline) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.DeliveryPipeline other) {
      if (other == com.google.cloud.deploy.v1.DeliveryPipeline.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000008;
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000010;
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasCondition()) {
        mergeCondition(other.getCondition());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.getSuspended() != false) {
        setSuspended(other.getSuspended());
      }
      switch (other.getPipelineCase()) {
        case SERIAL_PIPELINE:
          {
            mergeSerialPipeline(other.getSerialPipeline());
            break;
          }
        case PIPELINE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getSerialPipelineFieldBuilder().getBuilder(), extensionRegistry);
                pipelineCase_ = 8;
                break;
              } // case 66
            case 82:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(getConditionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 90
            case 96:
              {
                suspended_ = input.readBool();
                bitField0_ |= 0x00000400;
                break;
              } // case 96
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int pipelineCase_ = 0;
    private java.lang.Object pipeline_;

    public PipelineCase getPipelineCase() {
      return PipelineCase.forNumber(pipelineCase_);
    }

    public Builder clearPipeline() {
      pipelineCase_ = 0;
      pipeline_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Name of the `DeliveryPipeline`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the `DeliveryPipeline`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the `DeliveryPipeline`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the `DeliveryPipeline`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the `DeliveryPipeline`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `DeliveryPipeline`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `DeliveryPipeline`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `DeliveryPipeline`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `DeliveryPipeline`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `DeliveryPipeline`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Description of the `DeliveryPipeline`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the `DeliveryPipeline`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the `DeliveryPipeline`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the `DeliveryPipeline`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the `DeliveryPipeline`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }
    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000008;
      return internalGetMutableAnnotations().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000010;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the pipeline was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the pipeline was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the pipeline was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the pipeline was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the pipeline was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the pipeline was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the pipeline was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the pipeline was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the pipeline was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the pipeline was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the pipeline was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the pipeline was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the pipeline was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the pipeline was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the pipeline was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the pipeline was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the pipeline was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Most recent time at which the pipeline was updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.SerialPipeline,
            com.google.cloud.deploy.v1.SerialPipeline.Builder,
            com.google.cloud.deploy.v1.SerialPipelineOrBuilder>
        serialPipelineBuilder_;
    /**
     *
     *
     * <pre>
     * SerialPipeline defines a sequential set of stages for a
     * `DeliveryPipeline`.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.SerialPipeline serial_pipeline = 8;</code>
     *
     * @return Whether the serialPipeline field is set.
     */
    @java.lang.Override
    public boolean hasSerialPipeline() {
      return pipelineCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * SerialPipeline defines a sequential set of stages for a
     * `DeliveryPipeline`.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.SerialPipeline serial_pipeline = 8;</code>
     *
     * @return The serialPipeline.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.SerialPipeline getSerialPipeline() {
      if (serialPipelineBuilder_ == null) {
        if (pipelineCase_ == 8) {
          return (com.google.cloud.deploy.v1.SerialPipeline) pipeline_;
        }
        return com.google.cloud.deploy.v1.SerialPipeline.getDefaultInstance();
      } else {
        if (pipelineCase_ == 8) {
          return serialPipelineBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.SerialPipeline.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * SerialPipeline defines a sequential set of stages for a
     * `DeliveryPipeline`.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.SerialPipeline serial_pipeline = 8;</code>
     */
    public Builder setSerialPipeline(com.google.cloud.deploy.v1.SerialPipeline value) {
      if (serialPipelineBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pipeline_ = value;
        onChanged();
      } else {
        serialPipelineBuilder_.setMessage(value);
      }
      pipelineCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * SerialPipeline defines a sequential set of stages for a
     * `DeliveryPipeline`.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.SerialPipeline serial_pipeline = 8;</code>
     */
    public Builder setSerialPipeline(
        com.google.cloud.deploy.v1.SerialPipeline.Builder builderForValue) {
      if (serialPipelineBuilder_ == null) {
        pipeline_ = builderForValue.build();
        onChanged();
      } else {
        serialPipelineBuilder_.setMessage(builderForValue.build());
      }
      pipelineCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * SerialPipeline defines a sequential set of stages for a
     * `DeliveryPipeline`.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.SerialPipeline serial_pipeline = 8;</code>
     */
    public Builder mergeSerialPipeline(com.google.cloud.deploy.v1.SerialPipeline value) {
      if (serialPipelineBuilder_ == null) {
        if (pipelineCase_ == 8
            && pipeline_ != com.google.cloud.deploy.v1.SerialPipeline.getDefaultInstance()) {
          pipeline_ =
              com.google.cloud.deploy.v1.SerialPipeline.newBuilder(
                      (com.google.cloud.deploy.v1.SerialPipeline) pipeline_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          pipeline_ = value;
        }
        onChanged();
      } else {
        if (pipelineCase_ == 8) {
          serialPipelineBuilder_.mergeFrom(value);
        } else {
          serialPipelineBuilder_.setMessage(value);
        }
      }
      pipelineCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * SerialPipeline defines a sequential set of stages for a
     * `DeliveryPipeline`.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.SerialPipeline serial_pipeline = 8;</code>
     */
    public Builder clearSerialPipeline() {
      if (serialPipelineBuilder_ == null) {
        if (pipelineCase_ == 8) {
          pipelineCase_ = 0;
          pipeline_ = null;
          onChanged();
        }
      } else {
        if (pipelineCase_ == 8) {
          pipelineCase_ = 0;
          pipeline_ = null;
        }
        serialPipelineBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * SerialPipeline defines a sequential set of stages for a
     * `DeliveryPipeline`.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.SerialPipeline serial_pipeline = 8;</code>
     */
    public com.google.cloud.deploy.v1.SerialPipeline.Builder getSerialPipelineBuilder() {
      return getSerialPipelineFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * SerialPipeline defines a sequential set of stages for a
     * `DeliveryPipeline`.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.SerialPipeline serial_pipeline = 8;</code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.SerialPipelineOrBuilder getSerialPipelineOrBuilder() {
      if ((pipelineCase_ == 8) && (serialPipelineBuilder_ != null)) {
        return serialPipelineBuilder_.getMessageOrBuilder();
      } else {
        if (pipelineCase_ == 8) {
          return (com.google.cloud.deploy.v1.SerialPipeline) pipeline_;
        }
        return com.google.cloud.deploy.v1.SerialPipeline.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * SerialPipeline defines a sequential set of stages for a
     * `DeliveryPipeline`.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.SerialPipeline serial_pipeline = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.SerialPipeline,
            com.google.cloud.deploy.v1.SerialPipeline.Builder,
            com.google.cloud.deploy.v1.SerialPipelineOrBuilder>
        getSerialPipelineFieldBuilder() {
      if (serialPipelineBuilder_ == null) {
        if (!(pipelineCase_ == 8)) {
          pipeline_ = com.google.cloud.deploy.v1.SerialPipeline.getDefaultInstance();
        }
        serialPipelineBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.SerialPipeline,
                com.google.cloud.deploy.v1.SerialPipeline.Builder,
                com.google.cloud.deploy.v1.SerialPipelineOrBuilder>(
                (com.google.cloud.deploy.v1.SerialPipeline) pipeline_,
                getParentForChildren(),
                isClean());
        pipeline_ = null;
      }
      pipelineCase_ = 8;
      onChanged();
      return serialPipelineBuilder_;
    }

    private com.google.cloud.deploy.v1.PipelineCondition condition_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.PipelineCondition,
            com.google.cloud.deploy.v1.PipelineCondition.Builder,
            com.google.cloud.deploy.v1.PipelineConditionOrBuilder>
        conditionBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Delivery Pipeline.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PipelineCondition condition = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the condition field is set.
     */
    public boolean hasCondition() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Delivery Pipeline.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PipelineCondition condition = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The condition.
     */
    public com.google.cloud.deploy.v1.PipelineCondition getCondition() {
      if (conditionBuilder_ == null) {
        return condition_ == null
            ? com.google.cloud.deploy.v1.PipelineCondition.getDefaultInstance()
            : condition_;
      } else {
        return conditionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Delivery Pipeline.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PipelineCondition condition = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCondition(com.google.cloud.deploy.v1.PipelineCondition value) {
      if (conditionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        condition_ = value;
      } else {
        conditionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Delivery Pipeline.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PipelineCondition condition = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCondition(
        com.google.cloud.deploy.v1.PipelineCondition.Builder builderForValue) {
      if (conditionBuilder_ == null) {
        condition_ = builderForValue.build();
      } else {
        conditionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Delivery Pipeline.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PipelineCondition condition = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCondition(com.google.cloud.deploy.v1.PipelineCondition value) {
      if (conditionBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && condition_ != null
            && condition_ != com.google.cloud.deploy.v1.PipelineCondition.getDefaultInstance()) {
          getConditionBuilder().mergeFrom(value);
        } else {
          condition_ = value;
        }
      } else {
        conditionBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Delivery Pipeline.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PipelineCondition condition = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCondition() {
      bitField0_ = (bitField0_ & ~0x00000100);
      condition_ = null;
      if (conditionBuilder_ != null) {
        conditionBuilder_.dispose();
        conditionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Delivery Pipeline.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PipelineCondition condition = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.PipelineCondition.Builder getConditionBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getConditionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Delivery Pipeline.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PipelineCondition condition = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.PipelineConditionOrBuilder getConditionOrBuilder() {
      if (conditionBuilder_ != null) {
        return conditionBuilder_.getMessageOrBuilder();
      } else {
        return condition_ == null
            ? com.google.cloud.deploy.v1.PipelineCondition.getDefaultInstance()
            : condition_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Delivery Pipeline.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.PipelineCondition condition = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.PipelineCondition,
            com.google.cloud.deploy.v1.PipelineCondition.Builder,
            com.google.cloud.deploy.v1.PipelineConditionOrBuilder>
        getConditionFieldBuilder() {
      if (conditionBuilder_ == null) {
        conditionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.PipelineCondition,
                com.google.cloud.deploy.v1.PipelineCondition.Builder,
                com.google.cloud.deploy.v1.PipelineConditionOrBuilder>(
                getCondition(), getParentForChildren(), isClean());
        condition_ = null;
      }
      return conditionBuilder_;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 10;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 10;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 10;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 10;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private boolean suspended_;
    /**
     *
     *
     * <pre>
     * When suspended, no new releases or rollouts can be created,
     * but in-progress ones will complete.
     * </pre>
     *
     * <code>bool suspended = 12;</code>
     *
     * @return The suspended.
     */
    @java.lang.Override
    public boolean getSuspended() {
      return suspended_;
    }
    /**
     *
     *
     * <pre>
     * When suspended, no new releases or rollouts can be created,
     * but in-progress ones will complete.
     * </pre>
     *
     * <code>bool suspended = 12;</code>
     *
     * @param value The suspended to set.
     * @return This builder for chaining.
     */
    public Builder setSuspended(boolean value) {

      suspended_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When suspended, no new releases or rollouts can be created,
     * but in-progress ones will complete.
     * </pre>
     *
     * <code>bool suspended = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuspended() {
      bitField0_ = (bitField0_ & ~0x00000400);
      suspended_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.DeliveryPipeline)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.DeliveryPipeline)
  private static final com.google.cloud.deploy.v1.DeliveryPipeline DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.DeliveryPipeline();
  }

  public static com.google.cloud.deploy.v1.DeliveryPipeline getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeliveryPipeline> PARSER =
      new com.google.protobuf.AbstractParser<DeliveryPipeline>() {
        @java.lang.Override
        public DeliveryPipeline parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DeliveryPipeline> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeliveryPipeline> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.DeliveryPipeline getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
