/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * KubernetesConfig contains the Kubernetes runtime configuration.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.KubernetesConfig}
 */
public final class KubernetesConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.KubernetesConfig)
    KubernetesConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use KubernetesConfig.newBuilder() to construct.
  private KubernetesConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private KubernetesConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new KubernetesConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_KubernetesConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_KubernetesConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.KubernetesConfig.class,
            com.google.cloud.deploy.v1.KubernetesConfig.Builder.class);
  }

  public interface GatewayServiceMeshOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Name of the Gateway API HTTPRoute.
     * </pre>
     *
     * <code>string http_route = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The httpRoute.
     */
    java.lang.String getHttpRoute();
    /**
     *
     *
     * <pre>
     * Required. Name of the Gateway API HTTPRoute.
     * </pre>
     *
     * <code>string http_route = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for httpRoute.
     */
    com.google.protobuf.ByteString getHttpRouteBytes();

    /**
     *
     *
     * <pre>
     * Required. Name of the Kubernetes Service.
     * </pre>
     *
     * <code>string service = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The service.
     */
    java.lang.String getService();
    /**
     *
     *
     * <pre>
     * Required. Name of the Kubernetes Service.
     * </pre>
     *
     * <code>string service = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for service.
     */
    com.google.protobuf.ByteString getServiceBytes();

    /**
     *
     *
     * <pre>
     * Required. Name of the Kubernetes Deployment whose traffic is managed by
     * the specified HTTPRoute and Service.
     * </pre>
     *
     * <code>string deployment = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The deployment.
     */
    java.lang.String getDeployment();
    /**
     *
     *
     * <pre>
     * Required. Name of the Kubernetes Deployment whose traffic is managed by
     * the specified HTTPRoute and Service.
     * </pre>
     *
     * <code>string deployment = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for deployment.
     */
    com.google.protobuf.ByteString getDeploymentBytes();

    /**
     *
     *
     * <pre>
     * Optional. The time to wait for route updates to propagate. The maximum
     * configurable time is 3 hours, in seconds format. If unspecified, there is
     * no wait time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration route_update_wait_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the routeUpdateWaitTime field is set.
     */
    boolean hasRouteUpdateWaitTime();
    /**
     *
     *
     * <pre>
     * Optional. The time to wait for route updates to propagate. The maximum
     * configurable time is 3 hours, in seconds format. If unspecified, there is
     * no wait time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration route_update_wait_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The routeUpdateWaitTime.
     */
    com.google.protobuf.Duration getRouteUpdateWaitTime();
    /**
     *
     *
     * <pre>
     * Optional. The time to wait for route updates to propagate. The maximum
     * configurable time is 3 hours, in seconds format. If unspecified, there is
     * no wait time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration route_update_wait_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.protobuf.DurationOrBuilder getRouteUpdateWaitTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Information about the Kubernetes Gateway API service mesh configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh}
   */
  public static final class GatewayServiceMesh extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh)
      GatewayServiceMeshOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use GatewayServiceMesh.newBuilder() to construct.
    private GatewayServiceMesh(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GatewayServiceMesh() {
      httpRoute_ = "";
      service_ = "";
      deployment_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GatewayServiceMesh();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_KubernetesConfig_GatewayServiceMesh_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_KubernetesConfig_GatewayServiceMesh_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.class,
              com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.Builder.class);
    }

    public static final int HTTP_ROUTE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object httpRoute_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the Gateway API HTTPRoute.
     * </pre>
     *
     * <code>string http_route = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The httpRoute.
     */
    @java.lang.Override
    public java.lang.String getHttpRoute() {
      java.lang.Object ref = httpRoute_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        httpRoute_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the Gateway API HTTPRoute.
     * </pre>
     *
     * <code>string http_route = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for httpRoute.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getHttpRouteBytes() {
      java.lang.Object ref = httpRoute_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        httpRoute_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SERVICE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object service_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the Kubernetes Service.
     * </pre>
     *
     * <code>string service = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The service.
     */
    @java.lang.Override
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the Kubernetes Service.
     * </pre>
     *
     * <code>string service = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for service.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DEPLOYMENT_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object deployment_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the Kubernetes Deployment whose traffic is managed by
     * the specified HTTPRoute and Service.
     * </pre>
     *
     * <code>string deployment = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The deployment.
     */
    @java.lang.Override
    public java.lang.String getDeployment() {
      java.lang.Object ref = deployment_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deployment_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the Kubernetes Deployment whose traffic is managed by
     * the specified HTTPRoute and Service.
     * </pre>
     *
     * <code>string deployment = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for deployment.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDeploymentBytes() {
      java.lang.Object ref = deployment_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deployment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ROUTE_UPDATE_WAIT_TIME_FIELD_NUMBER = 4;
    private com.google.protobuf.Duration routeUpdateWaitTime_;
    /**
     *
     *
     * <pre>
     * Optional. The time to wait for route updates to propagate. The maximum
     * configurable time is 3 hours, in seconds format. If unspecified, there is
     * no wait time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration route_update_wait_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the routeUpdateWaitTime field is set.
     */
    @java.lang.Override
    public boolean hasRouteUpdateWaitTime() {
      return routeUpdateWaitTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time to wait for route updates to propagate. The maximum
     * configurable time is 3 hours, in seconds format. If unspecified, there is
     * no wait time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration route_update_wait_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The routeUpdateWaitTime.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getRouteUpdateWaitTime() {
      return routeUpdateWaitTime_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : routeUpdateWaitTime_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The time to wait for route updates to propagate. The maximum
     * configurable time is 3 hours, in seconds format. If unspecified, there is
     * no wait time.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration route_update_wait_time = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getRouteUpdateWaitTimeOrBuilder() {
      return routeUpdateWaitTime_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : routeUpdateWaitTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(httpRoute_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, httpRoute_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, service_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployment_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, deployment_);
      }
      if (routeUpdateWaitTime_ != null) {
        output.writeMessage(4, getRouteUpdateWaitTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(httpRoute_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, httpRoute_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, service_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployment_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, deployment_);
      }
      if (routeUpdateWaitTime_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRouteUpdateWaitTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh)) {
        return super.equals(obj);
      }
      com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh other =
          (com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh) obj;

      if (!getHttpRoute().equals(other.getHttpRoute())) return false;
      if (!getService().equals(other.getService())) return false;
      if (!getDeployment().equals(other.getDeployment())) return false;
      if (hasRouteUpdateWaitTime() != other.hasRouteUpdateWaitTime()) return false;
      if (hasRouteUpdateWaitTime()) {
        if (!getRouteUpdateWaitTime().equals(other.getRouteUpdateWaitTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + HTTP_ROUTE_FIELD_NUMBER;
      hash = (53 * hash) + getHttpRoute().hashCode();
      hash = (37 * hash) + SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getService().hashCode();
      hash = (37 * hash) + DEPLOYMENT_FIELD_NUMBER;
      hash = (53 * hash) + getDeployment().hashCode();
      if (hasRouteUpdateWaitTime()) {
        hash = (37 * hash) + ROUTE_UPDATE_WAIT_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getRouteUpdateWaitTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Information about the Kubernetes Gateway API service mesh configuration.
     * </pre>
     *
     * Protobuf type {@code google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh)
        com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMeshOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_KubernetesConfig_GatewayServiceMesh_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_KubernetesConfig_GatewayServiceMesh_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.class,
                com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.Builder.class);
      }

      // Construct using com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        httpRoute_ = "";
        service_ = "";
        deployment_ = "";
        routeUpdateWaitTime_ = null;
        if (routeUpdateWaitTimeBuilder_ != null) {
          routeUpdateWaitTimeBuilder_.dispose();
          routeUpdateWaitTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_KubernetesConfig_GatewayServiceMesh_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh
          getDefaultInstanceForType() {
        return com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh build() {
        com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh buildPartial() {
        com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh result =
            new com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.httpRoute_ = httpRoute_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.service_ = service_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.deployment_ = deployment_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.routeUpdateWaitTime_ =
              routeUpdateWaitTimeBuilder_ == null
                  ? routeUpdateWaitTime_
                  : routeUpdateWaitTimeBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh) {
          return mergeFrom((com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh other) {
        if (other
            == com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.getDefaultInstance())
          return this;
        if (!other.getHttpRoute().isEmpty()) {
          httpRoute_ = other.httpRoute_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getService().isEmpty()) {
          service_ = other.service_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getDeployment().isEmpty()) {
          deployment_ = other.deployment_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.hasRouteUpdateWaitTime()) {
          mergeRouteUpdateWaitTime(other.getRouteUpdateWaitTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  httpRoute_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  service_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  deployment_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getRouteUpdateWaitTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object httpRoute_ = "";
      /**
       *
       *
       * <pre>
       * Required. Name of the Gateway API HTTPRoute.
       * </pre>
       *
       * <code>string http_route = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The httpRoute.
       */
      public java.lang.String getHttpRoute() {
        java.lang.Object ref = httpRoute_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          httpRoute_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Gateway API HTTPRoute.
       * </pre>
       *
       * <code>string http_route = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for httpRoute.
       */
      public com.google.protobuf.ByteString getHttpRouteBytes() {
        java.lang.Object ref = httpRoute_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          httpRoute_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Gateway API HTTPRoute.
       * </pre>
       *
       * <code>string http_route = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The httpRoute to set.
       * @return This builder for chaining.
       */
      public Builder setHttpRoute(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        httpRoute_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Gateway API HTTPRoute.
       * </pre>
       *
       * <code>string http_route = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHttpRoute() {
        httpRoute_ = getDefaultInstance().getHttpRoute();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Gateway API HTTPRoute.
       * </pre>
       *
       * <code>string http_route = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for httpRoute to set.
       * @return This builder for chaining.
       */
      public Builder setHttpRouteBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        httpRoute_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object service_ = "";
      /**
       *
       *
       * <pre>
       * Required. Name of the Kubernetes Service.
       * </pre>
       *
       * <code>string service = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The service.
       */
      public java.lang.String getService() {
        java.lang.Object ref = service_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          service_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Kubernetes Service.
       * </pre>
       *
       * <code>string service = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for service.
       */
      public com.google.protobuf.ByteString getServiceBytes() {
        java.lang.Object ref = service_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          service_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Kubernetes Service.
       * </pre>
       *
       * <code>string service = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The service to set.
       * @return This builder for chaining.
       */
      public Builder setService(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        service_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Kubernetes Service.
       * </pre>
       *
       * <code>string service = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearService() {
        service_ = getDefaultInstance().getService();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Kubernetes Service.
       * </pre>
       *
       * <code>string service = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for service to set.
       * @return This builder for chaining.
       */
      public Builder setServiceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        service_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object deployment_ = "";
      /**
       *
       *
       * <pre>
       * Required. Name of the Kubernetes Deployment whose traffic is managed by
       * the specified HTTPRoute and Service.
       * </pre>
       *
       * <code>string deployment = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The deployment.
       */
      public java.lang.String getDeployment() {
        java.lang.Object ref = deployment_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          deployment_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Kubernetes Deployment whose traffic is managed by
       * the specified HTTPRoute and Service.
       * </pre>
       *
       * <code>string deployment = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for deployment.
       */
      public com.google.protobuf.ByteString getDeploymentBytes() {
        java.lang.Object ref = deployment_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          deployment_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Kubernetes Deployment whose traffic is managed by
       * the specified HTTPRoute and Service.
       * </pre>
       *
       * <code>string deployment = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The deployment to set.
       * @return This builder for chaining.
       */
      public Builder setDeployment(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        deployment_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Kubernetes Deployment whose traffic is managed by
       * the specified HTTPRoute and Service.
       * </pre>
       *
       * <code>string deployment = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDeployment() {
        deployment_ = getDefaultInstance().getDeployment();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Kubernetes Deployment whose traffic is managed by
       * the specified HTTPRoute and Service.
       * </pre>
       *
       * <code>string deployment = 3 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for deployment to set.
       * @return This builder for chaining.
       */
      public Builder setDeploymentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        deployment_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private com.google.protobuf.Duration routeUpdateWaitTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          routeUpdateWaitTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. The time to wait for route updates to propagate. The maximum
       * configurable time is 3 hours, in seconds format. If unspecified, there is
       * no wait time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration route_update_wait_time = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the routeUpdateWaitTime field is set.
       */
      public boolean hasRouteUpdateWaitTime() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * Optional. The time to wait for route updates to propagate. The maximum
       * configurable time is 3 hours, in seconds format. If unspecified, there is
       * no wait time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration route_update_wait_time = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The routeUpdateWaitTime.
       */
      public com.google.protobuf.Duration getRouteUpdateWaitTime() {
        if (routeUpdateWaitTimeBuilder_ == null) {
          return routeUpdateWaitTime_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : routeUpdateWaitTime_;
        } else {
          return routeUpdateWaitTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The time to wait for route updates to propagate. The maximum
       * configurable time is 3 hours, in seconds format. If unspecified, there is
       * no wait time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration route_update_wait_time = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setRouteUpdateWaitTime(com.google.protobuf.Duration value) {
        if (routeUpdateWaitTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          routeUpdateWaitTime_ = value;
        } else {
          routeUpdateWaitTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The time to wait for route updates to propagate. The maximum
       * configurable time is 3 hours, in seconds format. If unspecified, there is
       * no wait time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration route_update_wait_time = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setRouteUpdateWaitTime(com.google.protobuf.Duration.Builder builderForValue) {
        if (routeUpdateWaitTimeBuilder_ == null) {
          routeUpdateWaitTime_ = builderForValue.build();
        } else {
          routeUpdateWaitTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The time to wait for route updates to propagate. The maximum
       * configurable time is 3 hours, in seconds format. If unspecified, there is
       * no wait time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration route_update_wait_time = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeRouteUpdateWaitTime(com.google.protobuf.Duration value) {
        if (routeUpdateWaitTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && routeUpdateWaitTime_ != null
              && routeUpdateWaitTime_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getRouteUpdateWaitTimeBuilder().mergeFrom(value);
          } else {
            routeUpdateWaitTime_ = value;
          }
        } else {
          routeUpdateWaitTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The time to wait for route updates to propagate. The maximum
       * configurable time is 3 hours, in seconds format. If unspecified, there is
       * no wait time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration route_update_wait_time = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearRouteUpdateWaitTime() {
        bitField0_ = (bitField0_ & ~0x00000008);
        routeUpdateWaitTime_ = null;
        if (routeUpdateWaitTimeBuilder_ != null) {
          routeUpdateWaitTimeBuilder_.dispose();
          routeUpdateWaitTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The time to wait for route updates to propagate. The maximum
       * configurable time is 3 hours, in seconds format. If unspecified, there is
       * no wait time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration route_update_wait_time = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.Duration.Builder getRouteUpdateWaitTimeBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getRouteUpdateWaitTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. The time to wait for route updates to propagate. The maximum
       * configurable time is 3 hours, in seconds format. If unspecified, there is
       * no wait time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration route_update_wait_time = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.protobuf.DurationOrBuilder getRouteUpdateWaitTimeOrBuilder() {
        if (routeUpdateWaitTimeBuilder_ != null) {
          return routeUpdateWaitTimeBuilder_.getMessageOrBuilder();
        } else {
          return routeUpdateWaitTime_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : routeUpdateWaitTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The time to wait for route updates to propagate. The maximum
       * configurable time is 3 hours, in seconds format. If unspecified, there is
       * no wait time.
       * </pre>
       *
       * <code>
       * .google.protobuf.Duration route_update_wait_time = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getRouteUpdateWaitTimeFieldBuilder() {
        if (routeUpdateWaitTimeBuilder_ == null) {
          routeUpdateWaitTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getRouteUpdateWaitTime(), getParentForChildren(), isClean());
          routeUpdateWaitTime_ = null;
        }
        return routeUpdateWaitTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh)
    private static final com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh();
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GatewayServiceMesh> PARSER =
        new com.google.protobuf.AbstractParser<GatewayServiceMesh>() {
          @java.lang.Override
          public GatewayServiceMesh parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GatewayServiceMesh> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GatewayServiceMesh> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ServiceNetworkingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Name of the Kubernetes Service.
     * </pre>
     *
     * <code>string service = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The service.
     */
    java.lang.String getService();
    /**
     *
     *
     * <pre>
     * Required. Name of the Kubernetes Service.
     * </pre>
     *
     * <code>string service = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for service.
     */
    com.google.protobuf.ByteString getServiceBytes();

    /**
     *
     *
     * <pre>
     * Required. Name of the Kubernetes Deployment whose traffic is managed by
     * the specified Service.
     * </pre>
     *
     * <code>string deployment = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The deployment.
     */
    java.lang.String getDeployment();
    /**
     *
     *
     * <pre>
     * Required. Name of the Kubernetes Deployment whose traffic is managed by
     * the specified Service.
     * </pre>
     *
     * <code>string deployment = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for deployment.
     */
    com.google.protobuf.ByteString getDeploymentBytes();

    /**
     *
     *
     * <pre>
     * Optional. Whether to disable Pod overprovisioning. If Pod
     * overprovisioning is disabled then Cloud Deploy will limit the number of
     * total Pods used for the deployment strategy to the number of Pods the
     * Deployment has on the cluster.
     * </pre>
     *
     * <code>bool disable_pod_overprovisioning = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The disablePodOverprovisioning.
     */
    boolean getDisablePodOverprovisioning();
  }
  /**
   *
   *
   * <pre>
   * Information about the Kubernetes Service networking configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking}
   */
  public static final class ServiceNetworking extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking)
      ServiceNetworkingOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ServiceNetworking.newBuilder() to construct.
    private ServiceNetworking(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ServiceNetworking() {
      service_ = "";
      deployment_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ServiceNetworking();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_KubernetesConfig_ServiceNetworking_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_KubernetesConfig_ServiceNetworking_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking.class,
              com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking.Builder.class);
    }

    public static final int SERVICE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object service_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the Kubernetes Service.
     * </pre>
     *
     * <code>string service = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The service.
     */
    @java.lang.Override
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the Kubernetes Service.
     * </pre>
     *
     * <code>string service = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for service.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DEPLOYMENT_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object deployment_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the Kubernetes Deployment whose traffic is managed by
     * the specified Service.
     * </pre>
     *
     * <code>string deployment = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The deployment.
     */
    @java.lang.Override
    public java.lang.String getDeployment() {
      java.lang.Object ref = deployment_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deployment_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the Kubernetes Deployment whose traffic is managed by
     * the specified Service.
     * </pre>
     *
     * <code>string deployment = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for deployment.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDeploymentBytes() {
      java.lang.Object ref = deployment_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deployment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DISABLE_POD_OVERPROVISIONING_FIELD_NUMBER = 3;
    private boolean disablePodOverprovisioning_ = false;
    /**
     *
     *
     * <pre>
     * Optional. Whether to disable Pod overprovisioning. If Pod
     * overprovisioning is disabled then Cloud Deploy will limit the number of
     * total Pods used for the deployment strategy to the number of Pods the
     * Deployment has on the cluster.
     * </pre>
     *
     * <code>bool disable_pod_overprovisioning = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The disablePodOverprovisioning.
     */
    @java.lang.Override
    public boolean getDisablePodOverprovisioning() {
      return disablePodOverprovisioning_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, service_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployment_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, deployment_);
      }
      if (disablePodOverprovisioning_ != false) {
        output.writeBool(3, disablePodOverprovisioning_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, service_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployment_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, deployment_);
      }
      if (disablePodOverprovisioning_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(3, disablePodOverprovisioning_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking)) {
        return super.equals(obj);
      }
      com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking other =
          (com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking) obj;

      if (!getService().equals(other.getService())) return false;
      if (!getDeployment().equals(other.getDeployment())) return false;
      if (getDisablePodOverprovisioning() != other.getDisablePodOverprovisioning()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SERVICE_FIELD_NUMBER;
      hash = (53 * hash) + getService().hashCode();
      hash = (37 * hash) + DEPLOYMENT_FIELD_NUMBER;
      hash = (53 * hash) + getDeployment().hashCode();
      hash = (37 * hash) + DISABLE_POD_OVERPROVISIONING_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisablePodOverprovisioning());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Information about the Kubernetes Service networking configuration.
     * </pre>
     *
     * Protobuf type {@code google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking)
        com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworkingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_KubernetesConfig_ServiceNetworking_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_KubernetesConfig_ServiceNetworking_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking.class,
                com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking.Builder.class);
      }

      // Construct using com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        service_ = "";
        deployment_ = "";
        disablePodOverprovisioning_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_KubernetesConfig_ServiceNetworking_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking
          getDefaultInstanceForType() {
        return com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking build() {
        com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking buildPartial() {
        com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking result =
            new com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.service_ = service_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.deployment_ = deployment_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.disablePodOverprovisioning_ = disablePodOverprovisioning_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking) {
          return mergeFrom((com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking other) {
        if (other
            == com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking.getDefaultInstance())
          return this;
        if (!other.getService().isEmpty()) {
          service_ = other.service_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDeployment().isEmpty()) {
          deployment_ = other.deployment_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.getDisablePodOverprovisioning() != false) {
          setDisablePodOverprovisioning(other.getDisablePodOverprovisioning());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  service_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  deployment_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  disablePodOverprovisioning_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object service_ = "";
      /**
       *
       *
       * <pre>
       * Required. Name of the Kubernetes Service.
       * </pre>
       *
       * <code>string service = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The service.
       */
      public java.lang.String getService() {
        java.lang.Object ref = service_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          service_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Kubernetes Service.
       * </pre>
       *
       * <code>string service = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for service.
       */
      public com.google.protobuf.ByteString getServiceBytes() {
        java.lang.Object ref = service_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          service_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Kubernetes Service.
       * </pre>
       *
       * <code>string service = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The service to set.
       * @return This builder for chaining.
       */
      public Builder setService(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        service_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Kubernetes Service.
       * </pre>
       *
       * <code>string service = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearService() {
        service_ = getDefaultInstance().getService();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Kubernetes Service.
       * </pre>
       *
       * <code>string service = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for service to set.
       * @return This builder for chaining.
       */
      public Builder setServiceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        service_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object deployment_ = "";
      /**
       *
       *
       * <pre>
       * Required. Name of the Kubernetes Deployment whose traffic is managed by
       * the specified Service.
       * </pre>
       *
       * <code>string deployment = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The deployment.
       */
      public java.lang.String getDeployment() {
        java.lang.Object ref = deployment_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          deployment_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Kubernetes Deployment whose traffic is managed by
       * the specified Service.
       * </pre>
       *
       * <code>string deployment = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for deployment.
       */
      public com.google.protobuf.ByteString getDeploymentBytes() {
        java.lang.Object ref = deployment_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          deployment_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Kubernetes Deployment whose traffic is managed by
       * the specified Service.
       * </pre>
       *
       * <code>string deployment = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The deployment to set.
       * @return This builder for chaining.
       */
      public Builder setDeployment(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        deployment_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Kubernetes Deployment whose traffic is managed by
       * the specified Service.
       * </pre>
       *
       * <code>string deployment = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDeployment() {
        deployment_ = getDefaultInstance().getDeployment();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Name of the Kubernetes Deployment whose traffic is managed by
       * the specified Service.
       * </pre>
       *
       * <code>string deployment = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for deployment to set.
       * @return This builder for chaining.
       */
      public Builder setDeploymentBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        deployment_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private boolean disablePodOverprovisioning_;
      /**
       *
       *
       * <pre>
       * Optional. Whether to disable Pod overprovisioning. If Pod
       * overprovisioning is disabled then Cloud Deploy will limit the number of
       * total Pods used for the deployment strategy to the number of Pods the
       * Deployment has on the cluster.
       * </pre>
       *
       * <code>bool disable_pod_overprovisioning = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The disablePodOverprovisioning.
       */
      @java.lang.Override
      public boolean getDisablePodOverprovisioning() {
        return disablePodOverprovisioning_;
      }
      /**
       *
       *
       * <pre>
       * Optional. Whether to disable Pod overprovisioning. If Pod
       * overprovisioning is disabled then Cloud Deploy will limit the number of
       * total Pods used for the deployment strategy to the number of Pods the
       * Deployment has on the cluster.
       * </pre>
       *
       * <code>bool disable_pod_overprovisioning = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The disablePodOverprovisioning to set.
       * @return This builder for chaining.
       */
      public Builder setDisablePodOverprovisioning(boolean value) {

        disablePodOverprovisioning_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Whether to disable Pod overprovisioning. If Pod
       * overprovisioning is disabled then Cloud Deploy will limit the number of
       * total Pods used for the deployment strategy to the number of Pods the
       * Deployment has on the cluster.
       * </pre>
       *
       * <code>bool disable_pod_overprovisioning = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisablePodOverprovisioning() {
        bitField0_ = (bitField0_ & ~0x00000004);
        disablePodOverprovisioning_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking)
    private static final com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking();
    }

    public static com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ServiceNetworking> PARSER =
        new com.google.protobuf.AbstractParser<ServiceNetworking>() {
          @java.lang.Override
          public ServiceNetworking parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ServiceNetworking> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ServiceNetworking> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int serviceDefinitionCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object serviceDefinition_;

  public enum ServiceDefinitionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GATEWAY_SERVICE_MESH(1),
    SERVICE_NETWORKING(2),
    SERVICEDEFINITION_NOT_SET(0);
    private final int value;

    private ServiceDefinitionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ServiceDefinitionCase valueOf(int value) {
      return forNumber(value);
    }

    public static ServiceDefinitionCase forNumber(int value) {
      switch (value) {
        case 1:
          return GATEWAY_SERVICE_MESH;
        case 2:
          return SERVICE_NETWORKING;
        case 0:
          return SERVICEDEFINITION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ServiceDefinitionCase getServiceDefinitionCase() {
    return ServiceDefinitionCase.forNumber(serviceDefinitionCase_);
  }

  public static final int GATEWAY_SERVICE_MESH_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Kubernetes Gateway API service mesh configuration.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh gateway_service_mesh = 1;
   * </code>
   *
   * @return Whether the gatewayServiceMesh field is set.
   */
  @java.lang.Override
  public boolean hasGatewayServiceMesh() {
    return serviceDefinitionCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Kubernetes Gateway API service mesh configuration.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh gateway_service_mesh = 1;
   * </code>
   *
   * @return The gatewayServiceMesh.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh getGatewayServiceMesh() {
    if (serviceDefinitionCase_ == 1) {
      return (com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh) serviceDefinition_;
    }
    return com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Kubernetes Gateway API service mesh configuration.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh gateway_service_mesh = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMeshOrBuilder
      getGatewayServiceMeshOrBuilder() {
    if (serviceDefinitionCase_ == 1) {
      return (com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh) serviceDefinition_;
    }
    return com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.getDefaultInstance();
  }

  public static final int SERVICE_NETWORKING_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Kubernetes Service networking configuration.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking service_networking = 2;</code>
   *
   * @return Whether the serviceNetworking field is set.
   */
  @java.lang.Override
  public boolean hasServiceNetworking() {
    return serviceDefinitionCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Kubernetes Service networking configuration.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking service_networking = 2;</code>
   *
   * @return The serviceNetworking.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking getServiceNetworking() {
    if (serviceDefinitionCase_ == 2) {
      return (com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking) serviceDefinition_;
    }
    return com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Kubernetes Service networking configuration.
   * </pre>
   *
   * <code>.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking service_networking = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworkingOrBuilder
      getServiceNetworkingOrBuilder() {
    if (serviceDefinitionCase_ == 2) {
      return (com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking) serviceDefinition_;
    }
    return com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (serviceDefinitionCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh) serviceDefinition_);
    }
    if (serviceDefinitionCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking) serviceDefinition_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (serviceDefinitionCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh) serviceDefinition_);
    }
    if (serviceDefinitionCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking) serviceDefinition_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.KubernetesConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.KubernetesConfig other =
        (com.google.cloud.deploy.v1.KubernetesConfig) obj;

    if (!getServiceDefinitionCase().equals(other.getServiceDefinitionCase())) return false;
    switch (serviceDefinitionCase_) {
      case 1:
        if (!getGatewayServiceMesh().equals(other.getGatewayServiceMesh())) return false;
        break;
      case 2:
        if (!getServiceNetworking().equals(other.getServiceNetworking())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (serviceDefinitionCase_) {
      case 1:
        hash = (37 * hash) + GATEWAY_SERVICE_MESH_FIELD_NUMBER;
        hash = (53 * hash) + getGatewayServiceMesh().hashCode();
        break;
      case 2:
        hash = (37 * hash) + SERVICE_NETWORKING_FIELD_NUMBER;
        hash = (53 * hash) + getServiceNetworking().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.KubernetesConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.KubernetesConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.KubernetesConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.KubernetesConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.KubernetesConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.KubernetesConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.KubernetesConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.KubernetesConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.KubernetesConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.KubernetesConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.KubernetesConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.KubernetesConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.KubernetesConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * KubernetesConfig contains the Kubernetes runtime configuration.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.KubernetesConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.KubernetesConfig)
      com.google.cloud.deploy.v1.KubernetesConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_KubernetesConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_KubernetesConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.KubernetesConfig.class,
              com.google.cloud.deploy.v1.KubernetesConfig.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.KubernetesConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (gatewayServiceMeshBuilder_ != null) {
        gatewayServiceMeshBuilder_.clear();
      }
      if (serviceNetworkingBuilder_ != null) {
        serviceNetworkingBuilder_.clear();
      }
      serviceDefinitionCase_ = 0;
      serviceDefinition_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_KubernetesConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.KubernetesConfig getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.KubernetesConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.KubernetesConfig build() {
      com.google.cloud.deploy.v1.KubernetesConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.KubernetesConfig buildPartial() {
      com.google.cloud.deploy.v1.KubernetesConfig result =
          new com.google.cloud.deploy.v1.KubernetesConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.deploy.v1.KubernetesConfig result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.deploy.v1.KubernetesConfig result) {
      result.serviceDefinitionCase_ = serviceDefinitionCase_;
      result.serviceDefinition_ = this.serviceDefinition_;
      if (serviceDefinitionCase_ == 1 && gatewayServiceMeshBuilder_ != null) {
        result.serviceDefinition_ = gatewayServiceMeshBuilder_.build();
      }
      if (serviceDefinitionCase_ == 2 && serviceNetworkingBuilder_ != null) {
        result.serviceDefinition_ = serviceNetworkingBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.KubernetesConfig) {
        return mergeFrom((com.google.cloud.deploy.v1.KubernetesConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.KubernetesConfig other) {
      if (other == com.google.cloud.deploy.v1.KubernetesConfig.getDefaultInstance()) return this;
      switch (other.getServiceDefinitionCase()) {
        case GATEWAY_SERVICE_MESH:
          {
            mergeGatewayServiceMesh(other.getGatewayServiceMesh());
            break;
          }
        case SERVICE_NETWORKING:
          {
            mergeServiceNetworking(other.getServiceNetworking());
            break;
          }
        case SERVICEDEFINITION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getGatewayServiceMeshFieldBuilder().getBuilder(), extensionRegistry);
                serviceDefinitionCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getServiceNetworkingFieldBuilder().getBuilder(), extensionRegistry);
                serviceDefinitionCase_ = 2;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int serviceDefinitionCase_ = 0;
    private java.lang.Object serviceDefinition_;

    public ServiceDefinitionCase getServiceDefinitionCase() {
      return ServiceDefinitionCase.forNumber(serviceDefinitionCase_);
    }

    public Builder clearServiceDefinition() {
      serviceDefinitionCase_ = 0;
      serviceDefinition_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh,
            com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.Builder,
            com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMeshOrBuilder>
        gatewayServiceMeshBuilder_;
    /**
     *
     *
     * <pre>
     * Kubernetes Gateway API service mesh configuration.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh gateway_service_mesh = 1;
     * </code>
     *
     * @return Whether the gatewayServiceMesh field is set.
     */
    @java.lang.Override
    public boolean hasGatewayServiceMesh() {
      return serviceDefinitionCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes Gateway API service mesh configuration.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh gateway_service_mesh = 1;
     * </code>
     *
     * @return The gatewayServiceMesh.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh getGatewayServiceMesh() {
      if (gatewayServiceMeshBuilder_ == null) {
        if (serviceDefinitionCase_ == 1) {
          return (com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh)
              serviceDefinition_;
        }
        return com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.getDefaultInstance();
      } else {
        if (serviceDefinitionCase_ == 1) {
          return gatewayServiceMeshBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes Gateway API service mesh configuration.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh gateway_service_mesh = 1;
     * </code>
     */
    public Builder setGatewayServiceMesh(
        com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh value) {
      if (gatewayServiceMeshBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceDefinition_ = value;
        onChanged();
      } else {
        gatewayServiceMeshBuilder_.setMessage(value);
      }
      serviceDefinitionCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes Gateway API service mesh configuration.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh gateway_service_mesh = 1;
     * </code>
     */
    public Builder setGatewayServiceMesh(
        com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.Builder builderForValue) {
      if (gatewayServiceMeshBuilder_ == null) {
        serviceDefinition_ = builderForValue.build();
        onChanged();
      } else {
        gatewayServiceMeshBuilder_.setMessage(builderForValue.build());
      }
      serviceDefinitionCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes Gateway API service mesh configuration.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh gateway_service_mesh = 1;
     * </code>
     */
    public Builder mergeGatewayServiceMesh(
        com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh value) {
      if (gatewayServiceMeshBuilder_ == null) {
        if (serviceDefinitionCase_ == 1
            && serviceDefinition_
                != com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh
                    .getDefaultInstance()) {
          serviceDefinition_ =
              com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.newBuilder(
                      (com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh)
                          serviceDefinition_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          serviceDefinition_ = value;
        }
        onChanged();
      } else {
        if (serviceDefinitionCase_ == 1) {
          gatewayServiceMeshBuilder_.mergeFrom(value);
        } else {
          gatewayServiceMeshBuilder_.setMessage(value);
        }
      }
      serviceDefinitionCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes Gateway API service mesh configuration.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh gateway_service_mesh = 1;
     * </code>
     */
    public Builder clearGatewayServiceMesh() {
      if (gatewayServiceMeshBuilder_ == null) {
        if (serviceDefinitionCase_ == 1) {
          serviceDefinitionCase_ = 0;
          serviceDefinition_ = null;
          onChanged();
        }
      } else {
        if (serviceDefinitionCase_ == 1) {
          serviceDefinitionCase_ = 0;
          serviceDefinition_ = null;
        }
        gatewayServiceMeshBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes Gateway API service mesh configuration.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh gateway_service_mesh = 1;
     * </code>
     */
    public com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.Builder
        getGatewayServiceMeshBuilder() {
      return getGatewayServiceMeshFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Kubernetes Gateway API service mesh configuration.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh gateway_service_mesh = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMeshOrBuilder
        getGatewayServiceMeshOrBuilder() {
      if ((serviceDefinitionCase_ == 1) && (gatewayServiceMeshBuilder_ != null)) {
        return gatewayServiceMeshBuilder_.getMessageOrBuilder();
      } else {
        if (serviceDefinitionCase_ == 1) {
          return (com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh)
              serviceDefinition_;
        }
        return com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes Gateway API service mesh configuration.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh gateway_service_mesh = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh,
            com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.Builder,
            com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMeshOrBuilder>
        getGatewayServiceMeshFieldBuilder() {
      if (gatewayServiceMeshBuilder_ == null) {
        if (!(serviceDefinitionCase_ == 1)) {
          serviceDefinition_ =
              com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.getDefaultInstance();
        }
        gatewayServiceMeshBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh,
                com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh.Builder,
                com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMeshOrBuilder>(
                (com.google.cloud.deploy.v1.KubernetesConfig.GatewayServiceMesh) serviceDefinition_,
                getParentForChildren(),
                isClean());
        serviceDefinition_ = null;
      }
      serviceDefinitionCase_ = 1;
      onChanged();
      return gatewayServiceMeshBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking,
            com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking.Builder,
            com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworkingOrBuilder>
        serviceNetworkingBuilder_;
    /**
     *
     *
     * <pre>
     * Kubernetes Service networking configuration.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking service_networking = 2;
     * </code>
     *
     * @return Whether the serviceNetworking field is set.
     */
    @java.lang.Override
    public boolean hasServiceNetworking() {
      return serviceDefinitionCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes Service networking configuration.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking service_networking = 2;
     * </code>
     *
     * @return The serviceNetworking.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking getServiceNetworking() {
      if (serviceNetworkingBuilder_ == null) {
        if (serviceDefinitionCase_ == 2) {
          return (com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking) serviceDefinition_;
        }
        return com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking.getDefaultInstance();
      } else {
        if (serviceDefinitionCase_ == 2) {
          return serviceNetworkingBuilder_.getMessage();
        }
        return com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes Service networking configuration.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking service_networking = 2;
     * </code>
     */
    public Builder setServiceNetworking(
        com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking value) {
      if (serviceNetworkingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceDefinition_ = value;
        onChanged();
      } else {
        serviceNetworkingBuilder_.setMessage(value);
      }
      serviceDefinitionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes Service networking configuration.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking service_networking = 2;
     * </code>
     */
    public Builder setServiceNetworking(
        com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking.Builder builderForValue) {
      if (serviceNetworkingBuilder_ == null) {
        serviceDefinition_ = builderForValue.build();
        onChanged();
      } else {
        serviceNetworkingBuilder_.setMessage(builderForValue.build());
      }
      serviceDefinitionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes Service networking configuration.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking service_networking = 2;
     * </code>
     */
    public Builder mergeServiceNetworking(
        com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking value) {
      if (serviceNetworkingBuilder_ == null) {
        if (serviceDefinitionCase_ == 2
            && serviceDefinition_
                != com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking
                    .getDefaultInstance()) {
          serviceDefinition_ =
              com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking.newBuilder(
                      (com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking)
                          serviceDefinition_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          serviceDefinition_ = value;
        }
        onChanged();
      } else {
        if (serviceDefinitionCase_ == 2) {
          serviceNetworkingBuilder_.mergeFrom(value);
        } else {
          serviceNetworkingBuilder_.setMessage(value);
        }
      }
      serviceDefinitionCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes Service networking configuration.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking service_networking = 2;
     * </code>
     */
    public Builder clearServiceNetworking() {
      if (serviceNetworkingBuilder_ == null) {
        if (serviceDefinitionCase_ == 2) {
          serviceDefinitionCase_ = 0;
          serviceDefinition_ = null;
          onChanged();
        }
      } else {
        if (serviceDefinitionCase_ == 2) {
          serviceDefinitionCase_ = 0;
          serviceDefinition_ = null;
        }
        serviceNetworkingBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Kubernetes Service networking configuration.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking service_networking = 2;
     * </code>
     */
    public com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking.Builder
        getServiceNetworkingBuilder() {
      return getServiceNetworkingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Kubernetes Service networking configuration.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking service_networking = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworkingOrBuilder
        getServiceNetworkingOrBuilder() {
      if ((serviceDefinitionCase_ == 2) && (serviceNetworkingBuilder_ != null)) {
        return serviceNetworkingBuilder_.getMessageOrBuilder();
      } else {
        if (serviceDefinitionCase_ == 2) {
          return (com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking) serviceDefinition_;
        }
        return com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Kubernetes Service networking configuration.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking service_networking = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking,
            com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking.Builder,
            com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworkingOrBuilder>
        getServiceNetworkingFieldBuilder() {
      if (serviceNetworkingBuilder_ == null) {
        if (!(serviceDefinitionCase_ == 2)) {
          serviceDefinition_ =
              com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking.getDefaultInstance();
        }
        serviceNetworkingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking,
                com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking.Builder,
                com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworkingOrBuilder>(
                (com.google.cloud.deploy.v1.KubernetesConfig.ServiceNetworking) serviceDefinition_,
                getParentForChildren(),
                isClean());
        serviceDefinition_ = null;
      }
      serviceDefinitionCase_ = 2;
      onChanged();
      return serviceNetworkingBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.KubernetesConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.KubernetesConfig)
  private static final com.google.cloud.deploy.v1.KubernetesConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.KubernetesConfig();
  }

  public static com.google.cloud.deploy.v1.KubernetesConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<KubernetesConfig> PARSER =
      new com.google.protobuf.AbstractParser<KubernetesConfig>() {
        @java.lang.Override
        public KubernetesConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<KubernetesConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<KubernetesConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.KubernetesConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
