/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * A `Release` resource in the Cloud Deploy API.
 *
 * A `Release` defines a specific Skaffold configuration instance
 * that can be deployed.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.Release}
 */
public final class Release extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.Release)
    ReleaseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Release.newBuilder() to construct.
  private Release(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Release() {
    name_ = "";
    uid_ = "";
    description_ = "";
    skaffoldConfigUri_ = "";
    skaffoldConfigPath_ = "";
    buildArtifacts_ = java.util.Collections.emptyList();
    targetSnapshots_ = java.util.Collections.emptyList();
    renderState_ = 0;
    etag_ = "";
    skaffoldVersion_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Release();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_Release_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetAnnotations();
      case 5:
        return internalGetLabels();
      case 20:
        return internalGetTargetArtifacts();
      case 22:
        return internalGetTargetRenders();
      case 25:
        return internalGetDeployParameters();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_Release_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.Release.class,
            com.google.cloud.deploy.v1.Release.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Valid states of the render operation.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.deploy.v1.Release.RenderState}
   */
  public enum RenderState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The render state is unspecified.
     * </pre>
     *
     * <code>RENDER_STATE_UNSPECIFIED = 0;</code>
     */
    RENDER_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * All rendering operations have completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 1;</code>
     */
    SUCCEEDED(1),
    /**
     *
     *
     * <pre>
     * All rendering operations have completed, and one or more have failed.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    FAILED(2),
    /**
     *
     *
     * <pre>
     * Rendering has started and is not complete.
     * </pre>
     *
     * <code>IN_PROGRESS = 3;</code>
     */
    IN_PROGRESS(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The render state is unspecified.
     * </pre>
     *
     * <code>RENDER_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int RENDER_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * All rendering operations have completed successfully.
     * </pre>
     *
     * <code>SUCCEEDED = 1;</code>
     */
    public static final int SUCCEEDED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * All rendering operations have completed, and one or more have failed.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    public static final int FAILED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Rendering has started and is not complete.
     * </pre>
     *
     * <code>IN_PROGRESS = 3;</code>
     */
    public static final int IN_PROGRESS_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RenderState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RenderState forNumber(int value) {
      switch (value) {
        case 0:
          return RENDER_STATE_UNSPECIFIED;
        case 1:
          return SUCCEEDED;
        case 2:
          return FAILED;
        case 3:
          return IN_PROGRESS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RenderState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RenderState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RenderState>() {
          public RenderState findValueByNumber(int number) {
            return RenderState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.deploy.v1.Release.getDescriptor().getEnumTypes().get(0);
    }

    private static final RenderState[] VALUES = values();

    public static RenderState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RenderState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.deploy.v1.Release.RenderState)
  }

  public interface TargetRenderOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.deploy.v1.Release.TargetRender)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Cloud Build `Build` object that is
     * used to render the manifest for this target. Format is
     * `projects/{project}/locations/{location}/builds/{build}`.
     * </pre>
     *
     * <code>
     * string rendering_build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The renderingBuild.
     */
    java.lang.String getRenderingBuild();
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Cloud Build `Build` object that is
     * used to render the manifest for this target. Format is
     * `projects/{project}/locations/{location}/builds/{build}`.
     * </pre>
     *
     * <code>
     * string rendering_build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for renderingBuild.
     */
    com.google.protobuf.ByteString getRenderingBuildBytes();

    /**
     *
     *
     * <pre>
     * Output only. Current state of the render operation for this Target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.TargetRender.TargetRenderState rendering_state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for renderingState.
     */
    int getRenderingStateValue();
    /**
     *
     *
     * <pre>
     * Output only. Current state of the render operation for this Target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.TargetRender.TargetRenderState rendering_state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The renderingState.
     */
    com.google.cloud.deploy.v1.Release.TargetRender.TargetRenderState getRenderingState();

    /**
     *
     *
     * <pre>
     * Output only. Metadata related to the `Release` render for this Target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RenderMetadata metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the metadata field is set.
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * Output only. Metadata related to the `Release` render for this Target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RenderMetadata metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The metadata.
     */
    com.google.cloud.deploy.v1.RenderMetadata getMetadata();
    /**
     *
     *
     * <pre>
     * Output only. Metadata related to the `Release` render for this Target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RenderMetadata metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    com.google.cloud.deploy.v1.RenderMetadataOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * Output only. Reason this render failed. This will always be unspecified
     * while the render in progress.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.TargetRender.FailureCause failure_cause = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for failureCause.
     */
    int getFailureCauseValue();
    /**
     *
     *
     * <pre>
     * Output only. Reason this render failed. This will always be unspecified
     * while the render in progress.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.TargetRender.FailureCause failure_cause = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The failureCause.
     */
    com.google.cloud.deploy.v1.Release.TargetRender.FailureCause getFailureCause();

    /**
     *
     *
     * <pre>
     * Output only. Additional information about the render failure, if
     * available.
     * </pre>
     *
     * <code>string failure_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The failureMessage.
     */
    java.lang.String getFailureMessage();
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the render failure, if
     * available.
     * </pre>
     *
     * <code>string failure_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for failureMessage.
     */
    com.google.protobuf.ByteString getFailureMessageBytes();
  }
  /**
   *
   *
   * <pre>
   * Details of rendering for a single target.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.Release.TargetRender}
   */
  public static final class TargetRender extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.Release.TargetRender)
      TargetRenderOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TargetRender.newBuilder() to construct.
    private TargetRender(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TargetRender() {
      renderingBuild_ = "";
      renderingState_ = 0;
      failureCause_ = 0;
      failureMessage_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TargetRender();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Release_TargetRender_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Release_TargetRender_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.Release.TargetRender.class,
              com.google.cloud.deploy.v1.Release.TargetRender.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Valid states of the render operation.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.deploy.v1.Release.TargetRender.TargetRenderState}
     */
    public enum TargetRenderState implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * The render operation state is unspecified.
       * </pre>
       *
       * <code>TARGET_RENDER_STATE_UNSPECIFIED = 0;</code>
       */
      TARGET_RENDER_STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The render operation has completed successfully.
       * </pre>
       *
       * <code>SUCCEEDED = 1;</code>
       */
      SUCCEEDED(1),
      /**
       *
       *
       * <pre>
       * The render operation has failed.
       * </pre>
       *
       * <code>FAILED = 2;</code>
       */
      FAILED(2),
      /**
       *
       *
       * <pre>
       * The render operation is in progress.
       * </pre>
       *
       * <code>IN_PROGRESS = 3;</code>
       */
      IN_PROGRESS(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * The render operation state is unspecified.
       * </pre>
       *
       * <code>TARGET_RENDER_STATE_UNSPECIFIED = 0;</code>
       */
      public static final int TARGET_RENDER_STATE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The render operation has completed successfully.
       * </pre>
       *
       * <code>SUCCEEDED = 1;</code>
       */
      public static final int SUCCEEDED_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The render operation has failed.
       * </pre>
       *
       * <code>FAILED = 2;</code>
       */
      public static final int FAILED_VALUE = 2;
      /**
       *
       *
       * <pre>
       * The render operation is in progress.
       * </pre>
       *
       * <code>IN_PROGRESS = 3;</code>
       */
      public static final int IN_PROGRESS_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static TargetRenderState valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static TargetRenderState forNumber(int value) {
        switch (value) {
          case 0:
            return TARGET_RENDER_STATE_UNSPECIFIED;
          case 1:
            return SUCCEEDED;
          case 2:
            return FAILED;
          case 3:
            return IN_PROGRESS;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<TargetRenderState>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<TargetRenderState>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<TargetRenderState>() {
                public TargetRenderState findValueByNumber(int number) {
                  return TargetRenderState.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.deploy.v1.Release.TargetRender.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final TargetRenderState[] VALUES = values();

      public static TargetRenderState valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private TargetRenderState(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.deploy.v1.Release.TargetRender.TargetRenderState)
    }

    /**
     *
     *
     * <pre>
     * Well-known rendering failures.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.deploy.v1.Release.TargetRender.FailureCause}
     */
    public enum FailureCause implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * No reason for failure is specified.
       * </pre>
       *
       * <code>FAILURE_CAUSE_UNSPECIFIED = 0;</code>
       */
      FAILURE_CAUSE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Cloud Build is not available, either because it is not enabled or
       * because Cloud Deploy has insufficient permissions. See [required
       * permission](https://cloud.google.com/deploy/docs/cloud-deploy-service-account#required_permissions).
       * </pre>
       *
       * <code>CLOUD_BUILD_UNAVAILABLE = 1;</code>
       */
      CLOUD_BUILD_UNAVAILABLE(1),
      /**
       *
       *
       * <pre>
       * The render operation did not complete successfully; check Cloud Build
       * logs.
       * </pre>
       *
       * <code>EXECUTION_FAILED = 2;</code>
       */
      EXECUTION_FAILED(2),
      /**
       *
       *
       * <pre>
       * Cloud Build failed to fulfill Cloud Deploy's request. See
       * failure_message for additional details.
       * </pre>
       *
       * <code>CLOUD_BUILD_REQUEST_FAILED = 3;</code>
       */
      CLOUD_BUILD_REQUEST_FAILED(3),
      /**
       *
       *
       * <pre>
       * The render operation did not complete successfully because the
       * verification stanza required for verify was not found on the skaffold
       * configuration.
       * </pre>
       *
       * <code>VERIFICATION_CONFIG_NOT_FOUND = 4;</code>
       */
      VERIFICATION_CONFIG_NOT_FOUND(4),
      /**
       *
       *
       * <pre>
       * The render operation did not complete successfully because the custom
       * action required for predeploy or postdeploy was not found in the
       * skaffold configuration. See failure_message for additional details.
       * </pre>
       *
       * <code>CUSTOM_ACTION_NOT_FOUND = 5;</code>
       */
      CUSTOM_ACTION_NOT_FOUND(5),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * No reason for failure is specified.
       * </pre>
       *
       * <code>FAILURE_CAUSE_UNSPECIFIED = 0;</code>
       */
      public static final int FAILURE_CAUSE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Cloud Build is not available, either because it is not enabled or
       * because Cloud Deploy has insufficient permissions. See [required
       * permission](https://cloud.google.com/deploy/docs/cloud-deploy-service-account#required_permissions).
       * </pre>
       *
       * <code>CLOUD_BUILD_UNAVAILABLE = 1;</code>
       */
      public static final int CLOUD_BUILD_UNAVAILABLE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The render operation did not complete successfully; check Cloud Build
       * logs.
       * </pre>
       *
       * <code>EXECUTION_FAILED = 2;</code>
       */
      public static final int EXECUTION_FAILED_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Cloud Build failed to fulfill Cloud Deploy's request. See
       * failure_message for additional details.
       * </pre>
       *
       * <code>CLOUD_BUILD_REQUEST_FAILED = 3;</code>
       */
      public static final int CLOUD_BUILD_REQUEST_FAILED_VALUE = 3;
      /**
       *
       *
       * <pre>
       * The render operation did not complete successfully because the
       * verification stanza required for verify was not found on the skaffold
       * configuration.
       * </pre>
       *
       * <code>VERIFICATION_CONFIG_NOT_FOUND = 4;</code>
       */
      public static final int VERIFICATION_CONFIG_NOT_FOUND_VALUE = 4;
      /**
       *
       *
       * <pre>
       * The render operation did not complete successfully because the custom
       * action required for predeploy or postdeploy was not found in the
       * skaffold configuration. See failure_message for additional details.
       * </pre>
       *
       * <code>CUSTOM_ACTION_NOT_FOUND = 5;</code>
       */
      public static final int CUSTOM_ACTION_NOT_FOUND_VALUE = 5;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static FailureCause valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static FailureCause forNumber(int value) {
        switch (value) {
          case 0:
            return FAILURE_CAUSE_UNSPECIFIED;
          case 1:
            return CLOUD_BUILD_UNAVAILABLE;
          case 2:
            return EXECUTION_FAILED;
          case 3:
            return CLOUD_BUILD_REQUEST_FAILED;
          case 4:
            return VERIFICATION_CONFIG_NOT_FOUND;
          case 5:
            return CUSTOM_ACTION_NOT_FOUND;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<FailureCause> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<FailureCause> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<FailureCause>() {
            public FailureCause findValueByNumber(int number) {
              return FailureCause.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.deploy.v1.Release.TargetRender.getDescriptor()
            .getEnumTypes()
            .get(1);
      }

      private static final FailureCause[] VALUES = values();

      public static FailureCause valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private FailureCause(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.deploy.v1.Release.TargetRender.FailureCause)
    }

    public static final int RENDERING_BUILD_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object renderingBuild_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Cloud Build `Build` object that is
     * used to render the manifest for this target. Format is
     * `projects/{project}/locations/{location}/builds/{build}`.
     * </pre>
     *
     * <code>
     * string rendering_build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The renderingBuild.
     */
    @java.lang.Override
    public java.lang.String getRenderingBuild() {
      java.lang.Object ref = renderingBuild_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        renderingBuild_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource name of the Cloud Build `Build` object that is
     * used to render the manifest for this target. Format is
     * `projects/{project}/locations/{location}/builds/{build}`.
     * </pre>
     *
     * <code>
     * string rendering_build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for renderingBuild.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRenderingBuildBytes() {
      java.lang.Object ref = renderingBuild_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        renderingBuild_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int RENDERING_STATE_FIELD_NUMBER = 2;
    private int renderingState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Current state of the render operation for this Target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.TargetRender.TargetRenderState rendering_state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for renderingState.
     */
    @java.lang.Override
    public int getRenderingStateValue() {
      return renderingState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the render operation for this Target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.TargetRender.TargetRenderState rendering_state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The renderingState.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.Release.TargetRender.TargetRenderState getRenderingState() {
      com.google.cloud.deploy.v1.Release.TargetRender.TargetRenderState result =
          com.google.cloud.deploy.v1.Release.TargetRender.TargetRenderState.forNumber(
              renderingState_);
      return result == null
          ? com.google.cloud.deploy.v1.Release.TargetRender.TargetRenderState.UNRECOGNIZED
          : result;
    }

    public static final int METADATA_FIELD_NUMBER = 6;
    private com.google.cloud.deploy.v1.RenderMetadata metadata_;
    /**
     *
     *
     * <pre>
     * Output only. Metadata related to the `Release` render for this Target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RenderMetadata metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the metadata field is set.
     */
    @java.lang.Override
    public boolean hasMetadata() {
      return metadata_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata related to the `Release` render for this Target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RenderMetadata metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The metadata.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.RenderMetadata getMetadata() {
      return metadata_ == null
          ? com.google.cloud.deploy.v1.RenderMetadata.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metadata related to the `Release` render for this Target.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.RenderMetadata metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.RenderMetadataOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? com.google.cloud.deploy.v1.RenderMetadata.getDefaultInstance()
          : metadata_;
    }

    public static final int FAILURE_CAUSE_FIELD_NUMBER = 4;
    private int failureCause_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Reason this render failed. This will always be unspecified
     * while the render in progress.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.TargetRender.FailureCause failure_cause = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for failureCause.
     */
    @java.lang.Override
    public int getFailureCauseValue() {
      return failureCause_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Reason this render failed. This will always be unspecified
     * while the render in progress.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.TargetRender.FailureCause failure_cause = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The failureCause.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.Release.TargetRender.FailureCause getFailureCause() {
      com.google.cloud.deploy.v1.Release.TargetRender.FailureCause result =
          com.google.cloud.deploy.v1.Release.TargetRender.FailureCause.forNumber(failureCause_);
      return result == null
          ? com.google.cloud.deploy.v1.Release.TargetRender.FailureCause.UNRECOGNIZED
          : result;
    }

    public static final int FAILURE_MESSAGE_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object failureMessage_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the render failure, if
     * available.
     * </pre>
     *
     * <code>string failure_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The failureMessage.
     */
    @java.lang.Override
    public java.lang.String getFailureMessage() {
      java.lang.Object ref = failureMessage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        failureMessage_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about the render failure, if
     * available.
     * </pre>
     *
     * <code>string failure_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for failureMessage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFailureMessageBytes() {
      java.lang.Object ref = failureMessage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        failureMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(renderingBuild_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, renderingBuild_);
      }
      if (renderingState_
          != com.google.cloud.deploy.v1.Release.TargetRender.TargetRenderState
              .TARGET_RENDER_STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, renderingState_);
      }
      if (failureCause_
          != com.google.cloud.deploy.v1.Release.TargetRender.FailureCause.FAILURE_CAUSE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, failureCause_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(failureMessage_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, failureMessage_);
      }
      if (metadata_ != null) {
        output.writeMessage(6, getMetadata());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(renderingBuild_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, renderingBuild_);
      }
      if (renderingState_
          != com.google.cloud.deploy.v1.Release.TargetRender.TargetRenderState
              .TARGET_RENDER_STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, renderingState_);
      }
      if (failureCause_
          != com.google.cloud.deploy.v1.Release.TargetRender.FailureCause.FAILURE_CAUSE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, failureCause_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(failureMessage_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, failureMessage_);
      }
      if (metadata_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getMetadata());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.deploy.v1.Release.TargetRender)) {
        return super.equals(obj);
      }
      com.google.cloud.deploy.v1.Release.TargetRender other =
          (com.google.cloud.deploy.v1.Release.TargetRender) obj;

      if (!getRenderingBuild().equals(other.getRenderingBuild())) return false;
      if (renderingState_ != other.renderingState_) return false;
      if (hasMetadata() != other.hasMetadata()) return false;
      if (hasMetadata()) {
        if (!getMetadata().equals(other.getMetadata())) return false;
      }
      if (failureCause_ != other.failureCause_) return false;
      if (!getFailureMessage().equals(other.getFailureMessage())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + RENDERING_BUILD_FIELD_NUMBER;
      hash = (53 * hash) + getRenderingBuild().hashCode();
      hash = (37 * hash) + RENDERING_STATE_FIELD_NUMBER;
      hash = (53 * hash) + renderingState_;
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      hash = (37 * hash) + FAILURE_CAUSE_FIELD_NUMBER;
      hash = (53 * hash) + failureCause_;
      hash = (37 * hash) + FAILURE_MESSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getFailureMessage().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.deploy.v1.Release.TargetRender parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.Release.TargetRender parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.Release.TargetRender parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.Release.TargetRender parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.Release.TargetRender parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.Release.TargetRender parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.Release.TargetRender parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.Release.TargetRender parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.Release.TargetRender parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.Release.TargetRender parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.Release.TargetRender parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.Release.TargetRender parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.deploy.v1.Release.TargetRender prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Details of rendering for a single target.
     * </pre>
     *
     * Protobuf type {@code google.cloud.deploy.v1.Release.TargetRender}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.Release.TargetRender)
        com.google.cloud.deploy.v1.Release.TargetRenderOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_Release_TargetRender_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_Release_TargetRender_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.deploy.v1.Release.TargetRender.class,
                com.google.cloud.deploy.v1.Release.TargetRender.Builder.class);
      }

      // Construct using com.google.cloud.deploy.v1.Release.TargetRender.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        renderingBuild_ = "";
        renderingState_ = 0;
        metadata_ = null;
        if (metadataBuilder_ != null) {
          metadataBuilder_.dispose();
          metadataBuilder_ = null;
        }
        failureCause_ = 0;
        failureMessage_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_Release_TargetRender_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.Release.TargetRender getDefaultInstanceForType() {
        return com.google.cloud.deploy.v1.Release.TargetRender.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.Release.TargetRender build() {
        com.google.cloud.deploy.v1.Release.TargetRender result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.Release.TargetRender buildPartial() {
        com.google.cloud.deploy.v1.Release.TargetRender result =
            new com.google.cloud.deploy.v1.Release.TargetRender(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.deploy.v1.Release.TargetRender result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.renderingBuild_ = renderingBuild_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.renderingState_ = renderingState_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.failureCause_ = failureCause_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.failureMessage_ = failureMessage_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.deploy.v1.Release.TargetRender) {
          return mergeFrom((com.google.cloud.deploy.v1.Release.TargetRender) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.deploy.v1.Release.TargetRender other) {
        if (other == com.google.cloud.deploy.v1.Release.TargetRender.getDefaultInstance())
          return this;
        if (!other.getRenderingBuild().isEmpty()) {
          renderingBuild_ = other.renderingBuild_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.renderingState_ != 0) {
          setRenderingStateValue(other.getRenderingStateValue());
        }
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (other.failureCause_ != 0) {
          setFailureCauseValue(other.getFailureCauseValue());
        }
        if (!other.getFailureMessage().isEmpty()) {
          failureMessage_ = other.failureMessage_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  renderingBuild_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  renderingState_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 32:
                {
                  failureCause_ = input.readEnum();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 42:
                {
                  failureMessage_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 50
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object renderingBuild_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The resource name of the Cloud Build `Build` object that is
       * used to render the manifest for this target. Format is
       * `projects/{project}/locations/{location}/builds/{build}`.
       * </pre>
       *
       * <code>
       * string rendering_build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The renderingBuild.
       */
      public java.lang.String getRenderingBuild() {
        java.lang.Object ref = renderingBuild_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          renderingBuild_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The resource name of the Cloud Build `Build` object that is
       * used to render the manifest for this target. Format is
       * `projects/{project}/locations/{location}/builds/{build}`.
       * </pre>
       *
       * <code>
       * string rendering_build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for renderingBuild.
       */
      public com.google.protobuf.ByteString getRenderingBuildBytes() {
        java.lang.Object ref = renderingBuild_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          renderingBuild_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The resource name of the Cloud Build `Build` object that is
       * used to render the manifest for this target. Format is
       * `projects/{project}/locations/{location}/builds/{build}`.
       * </pre>
       *
       * <code>
       * string rendering_build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The renderingBuild to set.
       * @return This builder for chaining.
       */
      public Builder setRenderingBuild(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        renderingBuild_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The resource name of the Cloud Build `Build` object that is
       * used to render the manifest for this target. Format is
       * `projects/{project}/locations/{location}/builds/{build}`.
       * </pre>
       *
       * <code>
       * string rendering_build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRenderingBuild() {
        renderingBuild_ = getDefaultInstance().getRenderingBuild();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The resource name of the Cloud Build `Build` object that is
       * used to render the manifest for this target. Format is
       * `projects/{project}/locations/{location}/builds/{build}`.
       * </pre>
       *
       * <code>
       * string rendering_build = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for renderingBuild to set.
       * @return This builder for chaining.
       */
      public Builder setRenderingBuildBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        renderingBuild_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int renderingState_ = 0;
      /**
       *
       *
       * <pre>
       * Output only. Current state of the render operation for this Target.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Release.TargetRender.TargetRenderState rendering_state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for renderingState.
       */
      @java.lang.Override
      public int getRenderingStateValue() {
        return renderingState_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Current state of the render operation for this Target.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Release.TargetRender.TargetRenderState rendering_state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for renderingState to set.
       * @return This builder for chaining.
       */
      public Builder setRenderingStateValue(int value) {
        renderingState_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Current state of the render operation for this Target.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Release.TargetRender.TargetRenderState rendering_state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The renderingState.
       */
      @java.lang.Override
      public com.google.cloud.deploy.v1.Release.TargetRender.TargetRenderState getRenderingState() {
        com.google.cloud.deploy.v1.Release.TargetRender.TargetRenderState result =
            com.google.cloud.deploy.v1.Release.TargetRender.TargetRenderState.forNumber(
                renderingState_);
        return result == null
            ? com.google.cloud.deploy.v1.Release.TargetRender.TargetRenderState.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Output only. Current state of the render operation for this Target.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Release.TargetRender.TargetRenderState rendering_state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The renderingState to set.
       * @return This builder for chaining.
       */
      public Builder setRenderingState(
          com.google.cloud.deploy.v1.Release.TargetRender.TargetRenderState value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        renderingState_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Current state of the render operation for this Target.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Release.TargetRender.TargetRenderState rendering_state = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRenderingState() {
        bitField0_ = (bitField0_ & ~0x00000002);
        renderingState_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.deploy.v1.RenderMetadata metadata_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.deploy.v1.RenderMetadata,
              com.google.cloud.deploy.v1.RenderMetadata.Builder,
              com.google.cloud.deploy.v1.RenderMetadataOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * Output only. Metadata related to the `Release` render for this Target.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.RenderMetadata metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return Whether the metadata field is set.
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Output only. Metadata related to the `Release` render for this Target.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.RenderMetadata metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The metadata.
       */
      public com.google.cloud.deploy.v1.RenderMetadata getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? com.google.cloud.deploy.v1.RenderMetadata.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Metadata related to the `Release` render for this Target.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.RenderMetadata metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setMetadata(com.google.cloud.deploy.v1.RenderMetadata value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Metadata related to the `Release` render for this Target.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.RenderMetadata metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder setMetadata(
          com.google.cloud.deploy.v1.RenderMetadata.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Metadata related to the `Release` render for this Target.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.RenderMetadata metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder mergeMetadata(com.google.cloud.deploy.v1.RenderMetadata value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && metadata_ != null
              && metadata_ != com.google.cloud.deploy.v1.RenderMetadata.getDefaultInstance()) {
            getMetadataBuilder().mergeFrom(value);
          } else {
            metadata_ = value;
          }
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Metadata related to the `Release` render for this Target.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.RenderMetadata metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public Builder clearMetadata() {
        bitField0_ = (bitField0_ & ~0x00000004);
        metadata_ = null;
        if (metadataBuilder_ != null) {
          metadataBuilder_.dispose();
          metadataBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Metadata related to the `Release` render for this Target.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.RenderMetadata metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.deploy.v1.RenderMetadata.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Output only. Metadata related to the `Release` render for this Target.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.RenderMetadata metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      public com.google.cloud.deploy.v1.RenderMetadataOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? com.google.cloud.deploy.v1.RenderMetadata.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Metadata related to the `Release` render for this Target.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.RenderMetadata metadata = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.deploy.v1.RenderMetadata,
              com.google.cloud.deploy.v1.RenderMetadata.Builder,
              com.google.cloud.deploy.v1.RenderMetadataOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.deploy.v1.RenderMetadata,
                  com.google.cloud.deploy.v1.RenderMetadata.Builder,
                  com.google.cloud.deploy.v1.RenderMetadataOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private int failureCause_ = 0;
      /**
       *
       *
       * <pre>
       * Output only. Reason this render failed. This will always be unspecified
       * while the render in progress.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Release.TargetRender.FailureCause failure_cause = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The enum numeric value on the wire for failureCause.
       */
      @java.lang.Override
      public int getFailureCauseValue() {
        return failureCause_;
      }
      /**
       *
       *
       * <pre>
       * Output only. Reason this render failed. This will always be unspecified
       * while the render in progress.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Release.TargetRender.FailureCause failure_cause = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The enum numeric value on the wire for failureCause to set.
       * @return This builder for chaining.
       */
      public Builder setFailureCauseValue(int value) {
        failureCause_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Reason this render failed. This will always be unspecified
       * while the render in progress.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Release.TargetRender.FailureCause failure_cause = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return The failureCause.
       */
      @java.lang.Override
      public com.google.cloud.deploy.v1.Release.TargetRender.FailureCause getFailureCause() {
        com.google.cloud.deploy.v1.Release.TargetRender.FailureCause result =
            com.google.cloud.deploy.v1.Release.TargetRender.FailureCause.forNumber(failureCause_);
        return result == null
            ? com.google.cloud.deploy.v1.Release.TargetRender.FailureCause.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Output only. Reason this render failed. This will always be unspecified
       * while the render in progress.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Release.TargetRender.FailureCause failure_cause = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @param value The failureCause to set.
       * @return This builder for chaining.
       */
      public Builder setFailureCause(
          com.google.cloud.deploy.v1.Release.TargetRender.FailureCause value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        failureCause_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Reason this render failed. This will always be unspecified
       * while the render in progress.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Release.TargetRender.FailureCause failure_cause = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFailureCause() {
        bitField0_ = (bitField0_ & ~0x00000008);
        failureCause_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object failureMessage_ = "";
      /**
       *
       *
       * <pre>
       * Output only. Additional information about the render failure, if
       * available.
       * </pre>
       *
       * <code>string failure_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The failureMessage.
       */
      public java.lang.String getFailureMessage() {
        java.lang.Object ref = failureMessage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          failureMessage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Additional information about the render failure, if
       * available.
       * </pre>
       *
       * <code>string failure_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for failureMessage.
       */
      public com.google.protobuf.ByteString getFailureMessageBytes() {
        java.lang.Object ref = failureMessage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          failureMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. Additional information about the render failure, if
       * available.
       * </pre>
       *
       * <code>string failure_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The failureMessage to set.
       * @return This builder for chaining.
       */
      public Builder setFailureMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        failureMessage_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Additional information about the render failure, if
       * available.
       * </pre>
       *
       * <code>string failure_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFailureMessage() {
        failureMessage_ = getDefaultInstance().getFailureMessage();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. Additional information about the render failure, if
       * available.
       * </pre>
       *
       * <code>string failure_message = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for failureMessage to set.
       * @return This builder for chaining.
       */
      public Builder setFailureMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        failureMessage_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.Release.TargetRender)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.Release.TargetRender)
    private static final com.google.cloud.deploy.v1.Release.TargetRender DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.Release.TargetRender();
    }

    public static com.google.cloud.deploy.v1.Release.TargetRender getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TargetRender> PARSER =
        new com.google.protobuf.AbstractParser<TargetRender>() {
          @java.lang.Override
          public TargetRender parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TargetRender> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TargetRender> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Release.TargetRender getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ReleaseReadyConditionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.deploy.v1.Release.ReleaseReadyCondition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * True if the Release is in a valid state. Otherwise at least one condition
     * in `ReleaseCondition` is in an invalid state. Iterate over those
     * conditions and see which condition(s) has status = false to find out what
     * is wrong with the Release.
     * </pre>
     *
     * <code>bool status = 1;</code>
     *
     * @return The status.
     */
    boolean getStatus();
  }
  /**
   *
   *
   * <pre>
   * ReleaseReadyCondition contains information around the status of the
   * Release. If a release is not ready, you cannot create a rollout with the
   * release.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.Release.ReleaseReadyCondition}
   */
  public static final class ReleaseReadyCondition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.Release.ReleaseReadyCondition)
      ReleaseReadyConditionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ReleaseReadyCondition.newBuilder() to construct.
    private ReleaseReadyCondition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReleaseReadyCondition() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReleaseReadyCondition();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Release_ReleaseReadyCondition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Release_ReleaseReadyCondition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.Release.ReleaseReadyCondition.class,
              com.google.cloud.deploy.v1.Release.ReleaseReadyCondition.Builder.class);
    }

    public static final int STATUS_FIELD_NUMBER = 1;
    private boolean status_ = false;
    /**
     *
     *
     * <pre>
     * True if the Release is in a valid state. Otherwise at least one condition
     * in `ReleaseCondition` is in an invalid state. Iterate over those
     * conditions and see which condition(s) has status = false to find out what
     * is wrong with the Release.
     * </pre>
     *
     * <code>bool status = 1;</code>
     *
     * @return The status.
     */
    @java.lang.Override
    public boolean getStatus() {
      return status_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (status_ != false) {
        output.writeBool(1, status_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (status_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, status_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.deploy.v1.Release.ReleaseReadyCondition)) {
        return super.equals(obj);
      }
      com.google.cloud.deploy.v1.Release.ReleaseReadyCondition other =
          (com.google.cloud.deploy.v1.Release.ReleaseReadyCondition) obj;

      if (getStatus() != other.getStatus()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getStatus());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseReadyCondition parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseReadyCondition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseReadyCondition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseReadyCondition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseReadyCondition parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseReadyCondition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseReadyCondition parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseReadyCondition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseReadyCondition parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseReadyCondition parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseReadyCondition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseReadyCondition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.deploy.v1.Release.ReleaseReadyCondition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * ReleaseReadyCondition contains information around the status of the
     * Release. If a release is not ready, you cannot create a rollout with the
     * release.
     * </pre>
     *
     * Protobuf type {@code google.cloud.deploy.v1.Release.ReleaseReadyCondition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.Release.ReleaseReadyCondition)
        com.google.cloud.deploy.v1.Release.ReleaseReadyConditionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_Release_ReleaseReadyCondition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_Release_ReleaseReadyCondition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.deploy.v1.Release.ReleaseReadyCondition.class,
                com.google.cloud.deploy.v1.Release.ReleaseReadyCondition.Builder.class);
      }

      // Construct using com.google.cloud.deploy.v1.Release.ReleaseReadyCondition.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        status_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_Release_ReleaseReadyCondition_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.Release.ReleaseReadyCondition getDefaultInstanceForType() {
        return com.google.cloud.deploy.v1.Release.ReleaseReadyCondition.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.Release.ReleaseReadyCondition build() {
        com.google.cloud.deploy.v1.Release.ReleaseReadyCondition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.Release.ReleaseReadyCondition buildPartial() {
        com.google.cloud.deploy.v1.Release.ReleaseReadyCondition result =
            new com.google.cloud.deploy.v1.Release.ReleaseReadyCondition(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.deploy.v1.Release.ReleaseReadyCondition result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.status_ = status_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.deploy.v1.Release.ReleaseReadyCondition) {
          return mergeFrom((com.google.cloud.deploy.v1.Release.ReleaseReadyCondition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.deploy.v1.Release.ReleaseReadyCondition other) {
        if (other == com.google.cloud.deploy.v1.Release.ReleaseReadyCondition.getDefaultInstance())
          return this;
        if (other.getStatus() != false) {
          setStatus(other.getStatus());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  status_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean status_;
      /**
       *
       *
       * <pre>
       * True if the Release is in a valid state. Otherwise at least one condition
       * in `ReleaseCondition` is in an invalid state. Iterate over those
       * conditions and see which condition(s) has status = false to find out what
       * is wrong with the Release.
       * </pre>
       *
       * <code>bool status = 1;</code>
       *
       * @return The status.
       */
      @java.lang.Override
      public boolean getStatus() {
        return status_;
      }
      /**
       *
       *
       * <pre>
       * True if the Release is in a valid state. Otherwise at least one condition
       * in `ReleaseCondition` is in an invalid state. Iterate over those
       * conditions and see which condition(s) has status = false to find out what
       * is wrong with the Release.
       * </pre>
       *
       * <code>bool status = 1;</code>
       *
       * @param value The status to set.
       * @return This builder for chaining.
       */
      public Builder setStatus(boolean value) {

        status_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * True if the Release is in a valid state. Otherwise at least one condition
       * in `ReleaseCondition` is in an invalid state. Iterate over those
       * conditions and see which condition(s) has status = false to find out what
       * is wrong with the Release.
       * </pre>
       *
       * <code>bool status = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.Release.ReleaseReadyCondition)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.Release.ReleaseReadyCondition)
    private static final com.google.cloud.deploy.v1.Release.ReleaseReadyCondition DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.Release.ReleaseReadyCondition();
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseReadyCondition getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReleaseReadyCondition> PARSER =
        new com.google.protobuf.AbstractParser<ReleaseReadyCondition>() {
          @java.lang.Override
          public ReleaseReadyCondition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ReleaseReadyCondition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReleaseReadyCondition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Release.ReleaseReadyCondition getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SkaffoldSupportedConditionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.deploy.v1.Release.SkaffoldSupportedCondition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * True if the version of skaffold used by this release is supported.
     * </pre>
     *
     * <code>bool status = 1;</code>
     *
     * @return The status.
     */
    boolean getStatus();

    /**
     *
     *
     * <pre>
     * The skaffold support state for this release's version of skaffold.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.SkaffoldSupportState skaffold_support_state = 2;</code>
     *
     * @return The enum numeric value on the wire for skaffoldSupportState.
     */
    int getSkaffoldSupportStateValue();
    /**
     *
     *
     * <pre>
     * The skaffold support state for this release's version of skaffold.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.SkaffoldSupportState skaffold_support_state = 2;</code>
     *
     * @return The skaffoldSupportState.
     */
    com.google.cloud.deploy.v1.SkaffoldSupportState getSkaffoldSupportState();

    /**
     *
     *
     * <pre>
     * The time at which this release's version of skaffold will enter
     * maintenance mode.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp maintenance_mode_time = 3;</code>
     *
     * @return Whether the maintenanceModeTime field is set.
     */
    boolean hasMaintenanceModeTime();
    /**
     *
     *
     * <pre>
     * The time at which this release's version of skaffold will enter
     * maintenance mode.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp maintenance_mode_time = 3;</code>
     *
     * @return The maintenanceModeTime.
     */
    com.google.protobuf.Timestamp getMaintenanceModeTime();
    /**
     *
     *
     * <pre>
     * The time at which this release's version of skaffold will enter
     * maintenance mode.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp maintenance_mode_time = 3;</code>
     */
    com.google.protobuf.TimestampOrBuilder getMaintenanceModeTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * The time at which this release's version of skaffold will no longer be
     * supported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp support_expiration_time = 4;</code>
     *
     * @return Whether the supportExpirationTime field is set.
     */
    boolean hasSupportExpirationTime();
    /**
     *
     *
     * <pre>
     * The time at which this release's version of skaffold will no longer be
     * supported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp support_expiration_time = 4;</code>
     *
     * @return The supportExpirationTime.
     */
    com.google.protobuf.Timestamp getSupportExpirationTime();
    /**
     *
     *
     * <pre>
     * The time at which this release's version of skaffold will no longer be
     * supported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp support_expiration_time = 4;</code>
     */
    com.google.protobuf.TimestampOrBuilder getSupportExpirationTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * SkaffoldSupportedCondition contains information about when support for the
   * release's version of skaffold ends.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.Release.SkaffoldSupportedCondition}
   */
  public static final class SkaffoldSupportedCondition
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.Release.SkaffoldSupportedCondition)
      SkaffoldSupportedConditionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SkaffoldSupportedCondition.newBuilder() to construct.
    private SkaffoldSupportedCondition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SkaffoldSupportedCondition() {
      skaffoldSupportState_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SkaffoldSupportedCondition();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Release_SkaffoldSupportedCondition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Release_SkaffoldSupportedCondition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition.class,
              com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition.Builder.class);
    }

    public static final int STATUS_FIELD_NUMBER = 1;
    private boolean status_ = false;
    /**
     *
     *
     * <pre>
     * True if the version of skaffold used by this release is supported.
     * </pre>
     *
     * <code>bool status = 1;</code>
     *
     * @return The status.
     */
    @java.lang.Override
    public boolean getStatus() {
      return status_;
    }

    public static final int SKAFFOLD_SUPPORT_STATE_FIELD_NUMBER = 2;
    private int skaffoldSupportState_ = 0;
    /**
     *
     *
     * <pre>
     * The skaffold support state for this release's version of skaffold.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.SkaffoldSupportState skaffold_support_state = 2;</code>
     *
     * @return The enum numeric value on the wire for skaffoldSupportState.
     */
    @java.lang.Override
    public int getSkaffoldSupportStateValue() {
      return skaffoldSupportState_;
    }
    /**
     *
     *
     * <pre>
     * The skaffold support state for this release's version of skaffold.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.SkaffoldSupportState skaffold_support_state = 2;</code>
     *
     * @return The skaffoldSupportState.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.SkaffoldSupportState getSkaffoldSupportState() {
      com.google.cloud.deploy.v1.SkaffoldSupportState result =
          com.google.cloud.deploy.v1.SkaffoldSupportState.forNumber(skaffoldSupportState_);
      return result == null ? com.google.cloud.deploy.v1.SkaffoldSupportState.UNRECOGNIZED : result;
    }

    public static final int MAINTENANCE_MODE_TIME_FIELD_NUMBER = 3;
    private com.google.protobuf.Timestamp maintenanceModeTime_;
    /**
     *
     *
     * <pre>
     * The time at which this release's version of skaffold will enter
     * maintenance mode.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp maintenance_mode_time = 3;</code>
     *
     * @return Whether the maintenanceModeTime field is set.
     */
    @java.lang.Override
    public boolean hasMaintenanceModeTime() {
      return maintenanceModeTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time at which this release's version of skaffold will enter
     * maintenance mode.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp maintenance_mode_time = 3;</code>
     *
     * @return The maintenanceModeTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getMaintenanceModeTime() {
      return maintenanceModeTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : maintenanceModeTime_;
    }
    /**
     *
     *
     * <pre>
     * The time at which this release's version of skaffold will enter
     * maintenance mode.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp maintenance_mode_time = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getMaintenanceModeTimeOrBuilder() {
      return maintenanceModeTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : maintenanceModeTime_;
    }

    public static final int SUPPORT_EXPIRATION_TIME_FIELD_NUMBER = 4;
    private com.google.protobuf.Timestamp supportExpirationTime_;
    /**
     *
     *
     * <pre>
     * The time at which this release's version of skaffold will no longer be
     * supported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp support_expiration_time = 4;</code>
     *
     * @return Whether the supportExpirationTime field is set.
     */
    @java.lang.Override
    public boolean hasSupportExpirationTime() {
      return supportExpirationTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The time at which this release's version of skaffold will no longer be
     * supported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp support_expiration_time = 4;</code>
     *
     * @return The supportExpirationTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getSupportExpirationTime() {
      return supportExpirationTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : supportExpirationTime_;
    }
    /**
     *
     *
     * <pre>
     * The time at which this release's version of skaffold will no longer be
     * supported.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp support_expiration_time = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getSupportExpirationTimeOrBuilder() {
      return supportExpirationTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : supportExpirationTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (status_ != false) {
        output.writeBool(1, status_);
      }
      if (skaffoldSupportState_
          != com.google.cloud.deploy.v1.SkaffoldSupportState.SKAFFOLD_SUPPORT_STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, skaffoldSupportState_);
      }
      if (maintenanceModeTime_ != null) {
        output.writeMessage(3, getMaintenanceModeTime());
      }
      if (supportExpirationTime_ != null) {
        output.writeMessage(4, getSupportExpirationTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (status_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, status_);
      }
      if (skaffoldSupportState_
          != com.google.cloud.deploy.v1.SkaffoldSupportState.SKAFFOLD_SUPPORT_STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, skaffoldSupportState_);
      }
      if (maintenanceModeTime_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMaintenanceModeTime());
      }
      if (supportExpirationTime_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(4, getSupportExpirationTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition)) {
        return super.equals(obj);
      }
      com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition other =
          (com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition) obj;

      if (getStatus() != other.getStatus()) return false;
      if (skaffoldSupportState_ != other.skaffoldSupportState_) return false;
      if (hasMaintenanceModeTime() != other.hasMaintenanceModeTime()) return false;
      if (hasMaintenanceModeTime()) {
        if (!getMaintenanceModeTime().equals(other.getMaintenanceModeTime())) return false;
      }
      if (hasSupportExpirationTime() != other.hasSupportExpirationTime()) return false;
      if (hasSupportExpirationTime()) {
        if (!getSupportExpirationTime().equals(other.getSupportExpirationTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getStatus());
      hash = (37 * hash) + SKAFFOLD_SUPPORT_STATE_FIELD_NUMBER;
      hash = (53 * hash) + skaffoldSupportState_;
      if (hasMaintenanceModeTime()) {
        hash = (37 * hash) + MAINTENANCE_MODE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getMaintenanceModeTime().hashCode();
      }
      if (hasSupportExpirationTime()) {
        hash = (37 * hash) + SUPPORT_EXPIRATION_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getSupportExpirationTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * SkaffoldSupportedCondition contains information about when support for the
     * release's version of skaffold ends.
     * </pre>
     *
     * Protobuf type {@code google.cloud.deploy.v1.Release.SkaffoldSupportedCondition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.Release.SkaffoldSupportedCondition)
        com.google.cloud.deploy.v1.Release.SkaffoldSupportedConditionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_Release_SkaffoldSupportedCondition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_Release_SkaffoldSupportedCondition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition.class,
                com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition.Builder.class);
      }

      // Construct using com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        status_ = false;
        skaffoldSupportState_ = 0;
        maintenanceModeTime_ = null;
        if (maintenanceModeTimeBuilder_ != null) {
          maintenanceModeTimeBuilder_.dispose();
          maintenanceModeTimeBuilder_ = null;
        }
        supportExpirationTime_ = null;
        if (supportExpirationTimeBuilder_ != null) {
          supportExpirationTimeBuilder_.dispose();
          supportExpirationTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_Release_SkaffoldSupportedCondition_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition
          getDefaultInstanceForType() {
        return com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition build() {
        com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition buildPartial() {
        com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition result =
            new com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.status_ = status_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.skaffoldSupportState_ = skaffoldSupportState_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.maintenanceModeTime_ =
              maintenanceModeTimeBuilder_ == null
                  ? maintenanceModeTime_
                  : maintenanceModeTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.supportExpirationTime_ =
              supportExpirationTimeBuilder_ == null
                  ? supportExpirationTime_
                  : supportExpirationTimeBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition) {
          return mergeFrom((com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition other) {
        if (other
            == com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition.getDefaultInstance())
          return this;
        if (other.getStatus() != false) {
          setStatus(other.getStatus());
        }
        if (other.skaffoldSupportState_ != 0) {
          setSkaffoldSupportStateValue(other.getSkaffoldSupportStateValue());
        }
        if (other.hasMaintenanceModeTime()) {
          mergeMaintenanceModeTime(other.getMaintenanceModeTime());
        }
        if (other.hasSupportExpirationTime()) {
          mergeSupportExpirationTime(other.getSupportExpirationTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  status_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  skaffoldSupportState_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  input.readMessage(
                      getMaintenanceModeTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getSupportExpirationTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean status_;
      /**
       *
       *
       * <pre>
       * True if the version of skaffold used by this release is supported.
       * </pre>
       *
       * <code>bool status = 1;</code>
       *
       * @return The status.
       */
      @java.lang.Override
      public boolean getStatus() {
        return status_;
      }
      /**
       *
       *
       * <pre>
       * True if the version of skaffold used by this release is supported.
       * </pre>
       *
       * <code>bool status = 1;</code>
       *
       * @param value The status to set.
       * @return This builder for chaining.
       */
      public Builder setStatus(boolean value) {

        status_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * True if the version of skaffold used by this release is supported.
       * </pre>
       *
       * <code>bool status = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = false;
        onChanged();
        return this;
      }

      private int skaffoldSupportState_ = 0;
      /**
       *
       *
       * <pre>
       * The skaffold support state for this release's version of skaffold.
       * </pre>
       *
       * <code>.google.cloud.deploy.v1.SkaffoldSupportState skaffold_support_state = 2;</code>
       *
       * @return The enum numeric value on the wire for skaffoldSupportState.
       */
      @java.lang.Override
      public int getSkaffoldSupportStateValue() {
        return skaffoldSupportState_;
      }
      /**
       *
       *
       * <pre>
       * The skaffold support state for this release's version of skaffold.
       * </pre>
       *
       * <code>.google.cloud.deploy.v1.SkaffoldSupportState skaffold_support_state = 2;</code>
       *
       * @param value The enum numeric value on the wire for skaffoldSupportState to set.
       * @return This builder for chaining.
       */
      public Builder setSkaffoldSupportStateValue(int value) {
        skaffoldSupportState_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The skaffold support state for this release's version of skaffold.
       * </pre>
       *
       * <code>.google.cloud.deploy.v1.SkaffoldSupportState skaffold_support_state = 2;</code>
       *
       * @return The skaffoldSupportState.
       */
      @java.lang.Override
      public com.google.cloud.deploy.v1.SkaffoldSupportState getSkaffoldSupportState() {
        com.google.cloud.deploy.v1.SkaffoldSupportState result =
            com.google.cloud.deploy.v1.SkaffoldSupportState.forNumber(skaffoldSupportState_);
        return result == null
            ? com.google.cloud.deploy.v1.SkaffoldSupportState.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The skaffold support state for this release's version of skaffold.
       * </pre>
       *
       * <code>.google.cloud.deploy.v1.SkaffoldSupportState skaffold_support_state = 2;</code>
       *
       * @param value The skaffoldSupportState to set.
       * @return This builder for chaining.
       */
      public Builder setSkaffoldSupportState(
          com.google.cloud.deploy.v1.SkaffoldSupportState value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        skaffoldSupportState_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The skaffold support state for this release's version of skaffold.
       * </pre>
       *
       * <code>.google.cloud.deploy.v1.SkaffoldSupportState skaffold_support_state = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSkaffoldSupportState() {
        bitField0_ = (bitField0_ & ~0x00000002);
        skaffoldSupportState_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.Timestamp maintenanceModeTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          maintenanceModeTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The time at which this release's version of skaffold will enter
       * maintenance mode.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp maintenance_mode_time = 3;</code>
       *
       * @return Whether the maintenanceModeTime field is set.
       */
      public boolean hasMaintenanceModeTime() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The time at which this release's version of skaffold will enter
       * maintenance mode.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp maintenance_mode_time = 3;</code>
       *
       * @return The maintenanceModeTime.
       */
      public com.google.protobuf.Timestamp getMaintenanceModeTime() {
        if (maintenanceModeTimeBuilder_ == null) {
          return maintenanceModeTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : maintenanceModeTime_;
        } else {
          return maintenanceModeTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The time at which this release's version of skaffold will enter
       * maintenance mode.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp maintenance_mode_time = 3;</code>
       */
      public Builder setMaintenanceModeTime(com.google.protobuf.Timestamp value) {
        if (maintenanceModeTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          maintenanceModeTime_ = value;
        } else {
          maintenanceModeTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time at which this release's version of skaffold will enter
       * maintenance mode.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp maintenance_mode_time = 3;</code>
       */
      public Builder setMaintenanceModeTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (maintenanceModeTimeBuilder_ == null) {
          maintenanceModeTime_ = builderForValue.build();
        } else {
          maintenanceModeTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time at which this release's version of skaffold will enter
       * maintenance mode.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp maintenance_mode_time = 3;</code>
       */
      public Builder mergeMaintenanceModeTime(com.google.protobuf.Timestamp value) {
        if (maintenanceModeTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && maintenanceModeTime_ != null
              && maintenanceModeTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getMaintenanceModeTimeBuilder().mergeFrom(value);
          } else {
            maintenanceModeTime_ = value;
          }
        } else {
          maintenanceModeTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time at which this release's version of skaffold will enter
       * maintenance mode.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp maintenance_mode_time = 3;</code>
       */
      public Builder clearMaintenanceModeTime() {
        bitField0_ = (bitField0_ & ~0x00000004);
        maintenanceModeTime_ = null;
        if (maintenanceModeTimeBuilder_ != null) {
          maintenanceModeTimeBuilder_.dispose();
          maintenanceModeTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time at which this release's version of skaffold will enter
       * maintenance mode.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp maintenance_mode_time = 3;</code>
       */
      public com.google.protobuf.Timestamp.Builder getMaintenanceModeTimeBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getMaintenanceModeTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The time at which this release's version of skaffold will enter
       * maintenance mode.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp maintenance_mode_time = 3;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getMaintenanceModeTimeOrBuilder() {
        if (maintenanceModeTimeBuilder_ != null) {
          return maintenanceModeTimeBuilder_.getMessageOrBuilder();
        } else {
          return maintenanceModeTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : maintenanceModeTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The time at which this release's version of skaffold will enter
       * maintenance mode.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp maintenance_mode_time = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getMaintenanceModeTimeFieldBuilder() {
        if (maintenanceModeTimeBuilder_ == null) {
          maintenanceModeTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getMaintenanceModeTime(), getParentForChildren(), isClean());
          maintenanceModeTime_ = null;
        }
        return maintenanceModeTimeBuilder_;
      }

      private com.google.protobuf.Timestamp supportExpirationTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          supportExpirationTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The time at which this release's version of skaffold will no longer be
       * supported.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp support_expiration_time = 4;</code>
       *
       * @return Whether the supportExpirationTime field is set.
       */
      public boolean hasSupportExpirationTime() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * The time at which this release's version of skaffold will no longer be
       * supported.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp support_expiration_time = 4;</code>
       *
       * @return The supportExpirationTime.
       */
      public com.google.protobuf.Timestamp getSupportExpirationTime() {
        if (supportExpirationTimeBuilder_ == null) {
          return supportExpirationTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : supportExpirationTime_;
        } else {
          return supportExpirationTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The time at which this release's version of skaffold will no longer be
       * supported.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp support_expiration_time = 4;</code>
       */
      public Builder setSupportExpirationTime(com.google.protobuf.Timestamp value) {
        if (supportExpirationTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          supportExpirationTime_ = value;
        } else {
          supportExpirationTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time at which this release's version of skaffold will no longer be
       * supported.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp support_expiration_time = 4;</code>
       */
      public Builder setSupportExpirationTime(
          com.google.protobuf.Timestamp.Builder builderForValue) {
        if (supportExpirationTimeBuilder_ == null) {
          supportExpirationTime_ = builderForValue.build();
        } else {
          supportExpirationTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time at which this release's version of skaffold will no longer be
       * supported.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp support_expiration_time = 4;</code>
       */
      public Builder mergeSupportExpirationTime(com.google.protobuf.Timestamp value) {
        if (supportExpirationTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && supportExpirationTime_ != null
              && supportExpirationTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getSupportExpirationTimeBuilder().mergeFrom(value);
          } else {
            supportExpirationTime_ = value;
          }
        } else {
          supportExpirationTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time at which this release's version of skaffold will no longer be
       * supported.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp support_expiration_time = 4;</code>
       */
      public Builder clearSupportExpirationTime() {
        bitField0_ = (bitField0_ & ~0x00000008);
        supportExpirationTime_ = null;
        if (supportExpirationTimeBuilder_ != null) {
          supportExpirationTimeBuilder_.dispose();
          supportExpirationTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The time at which this release's version of skaffold will no longer be
       * supported.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp support_expiration_time = 4;</code>
       */
      public com.google.protobuf.Timestamp.Builder getSupportExpirationTimeBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getSupportExpirationTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The time at which this release's version of skaffold will no longer be
       * supported.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp support_expiration_time = 4;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getSupportExpirationTimeOrBuilder() {
        if (supportExpirationTimeBuilder_ != null) {
          return supportExpirationTimeBuilder_.getMessageOrBuilder();
        } else {
          return supportExpirationTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : supportExpirationTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The time at which this release's version of skaffold will no longer be
       * supported.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp support_expiration_time = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getSupportExpirationTimeFieldBuilder() {
        if (supportExpirationTimeBuilder_ == null) {
          supportExpirationTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getSupportExpirationTime(), getParentForChildren(), isClean());
          supportExpirationTime_ = null;
        }
        return supportExpirationTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.Release.SkaffoldSupportedCondition)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.Release.SkaffoldSupportedCondition)
    private static final com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition();
    }

    public static com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SkaffoldSupportedCondition> PARSER =
        new com.google.protobuf.AbstractParser<SkaffoldSupportedCondition>() {
          @java.lang.Override
          public SkaffoldSupportedCondition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SkaffoldSupportedCondition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SkaffoldSupportedCondition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ReleaseConditionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.deploy.v1.Release.ReleaseCondition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Details around the Releases's overall status.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.Release.ReleaseReadyCondition release_ready_condition = 1;
     * </code>
     *
     * @return Whether the releaseReadyCondition field is set.
     */
    boolean hasReleaseReadyCondition();
    /**
     *
     *
     * <pre>
     * Details around the Releases's overall status.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.Release.ReleaseReadyCondition release_ready_condition = 1;
     * </code>
     *
     * @return The releaseReadyCondition.
     */
    com.google.cloud.deploy.v1.Release.ReleaseReadyCondition getReleaseReadyCondition();
    /**
     *
     *
     * <pre>
     * Details around the Releases's overall status.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.Release.ReleaseReadyCondition release_ready_condition = 1;
     * </code>
     */
    com.google.cloud.deploy.v1.Release.ReleaseReadyConditionOrBuilder
        getReleaseReadyConditionOrBuilder();

    /**
     *
     *
     * <pre>
     * Details around the support state of the release's skaffold
     * version.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.SkaffoldSupportedCondition skaffold_supported_condition = 2;
     * </code>
     *
     * @return Whether the skaffoldSupportedCondition field is set.
     */
    boolean hasSkaffoldSupportedCondition();
    /**
     *
     *
     * <pre>
     * Details around the support state of the release's skaffold
     * version.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.SkaffoldSupportedCondition skaffold_supported_condition = 2;
     * </code>
     *
     * @return The skaffoldSupportedCondition.
     */
    com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition getSkaffoldSupportedCondition();
    /**
     *
     *
     * <pre>
     * Details around the support state of the release's skaffold
     * version.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.SkaffoldSupportedCondition skaffold_supported_condition = 2;
     * </code>
     */
    com.google.cloud.deploy.v1.Release.SkaffoldSupportedConditionOrBuilder
        getSkaffoldSupportedConditionOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * ReleaseCondition contains all conditions relevant to a Release.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.Release.ReleaseCondition}
   */
  public static final class ReleaseCondition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.Release.ReleaseCondition)
      ReleaseConditionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ReleaseCondition.newBuilder() to construct.
    private ReleaseCondition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReleaseCondition() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReleaseCondition();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Release_ReleaseCondition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Release_ReleaseCondition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.Release.ReleaseCondition.class,
              com.google.cloud.deploy.v1.Release.ReleaseCondition.Builder.class);
    }

    public static final int RELEASE_READY_CONDITION_FIELD_NUMBER = 1;
    private com.google.cloud.deploy.v1.Release.ReleaseReadyCondition releaseReadyCondition_;
    /**
     *
     *
     * <pre>
     * Details around the Releases's overall status.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.Release.ReleaseReadyCondition release_ready_condition = 1;
     * </code>
     *
     * @return Whether the releaseReadyCondition field is set.
     */
    @java.lang.Override
    public boolean hasReleaseReadyCondition() {
      return releaseReadyCondition_ != null;
    }
    /**
     *
     *
     * <pre>
     * Details around the Releases's overall status.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.Release.ReleaseReadyCondition release_ready_condition = 1;
     * </code>
     *
     * @return The releaseReadyCondition.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.Release.ReleaseReadyCondition getReleaseReadyCondition() {
      return releaseReadyCondition_ == null
          ? com.google.cloud.deploy.v1.Release.ReleaseReadyCondition.getDefaultInstance()
          : releaseReadyCondition_;
    }
    /**
     *
     *
     * <pre>
     * Details around the Releases's overall status.
     * </pre>
     *
     * <code>.google.cloud.deploy.v1.Release.ReleaseReadyCondition release_ready_condition = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.Release.ReleaseReadyConditionOrBuilder
        getReleaseReadyConditionOrBuilder() {
      return releaseReadyCondition_ == null
          ? com.google.cloud.deploy.v1.Release.ReleaseReadyCondition.getDefaultInstance()
          : releaseReadyCondition_;
    }

    public static final int SKAFFOLD_SUPPORTED_CONDITION_FIELD_NUMBER = 2;
    private com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition
        skaffoldSupportedCondition_;
    /**
     *
     *
     * <pre>
     * Details around the support state of the release's skaffold
     * version.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.SkaffoldSupportedCondition skaffold_supported_condition = 2;
     * </code>
     *
     * @return Whether the skaffoldSupportedCondition field is set.
     */
    @java.lang.Override
    public boolean hasSkaffoldSupportedCondition() {
      return skaffoldSupportedCondition_ != null;
    }
    /**
     *
     *
     * <pre>
     * Details around the support state of the release's skaffold
     * version.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.SkaffoldSupportedCondition skaffold_supported_condition = 2;
     * </code>
     *
     * @return The skaffoldSupportedCondition.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition
        getSkaffoldSupportedCondition() {
      return skaffoldSupportedCondition_ == null
          ? com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition.getDefaultInstance()
          : skaffoldSupportedCondition_;
    }
    /**
     *
     *
     * <pre>
     * Details around the support state of the release's skaffold
     * version.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.SkaffoldSupportedCondition skaffold_supported_condition = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.Release.SkaffoldSupportedConditionOrBuilder
        getSkaffoldSupportedConditionOrBuilder() {
      return skaffoldSupportedCondition_ == null
          ? com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition.getDefaultInstance()
          : skaffoldSupportedCondition_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (releaseReadyCondition_ != null) {
        output.writeMessage(1, getReleaseReadyCondition());
      }
      if (skaffoldSupportedCondition_ != null) {
        output.writeMessage(2, getSkaffoldSupportedCondition());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (releaseReadyCondition_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, getReleaseReadyCondition());
      }
      if (skaffoldSupportedCondition_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, getSkaffoldSupportedCondition());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.deploy.v1.Release.ReleaseCondition)) {
        return super.equals(obj);
      }
      com.google.cloud.deploy.v1.Release.ReleaseCondition other =
          (com.google.cloud.deploy.v1.Release.ReleaseCondition) obj;

      if (hasReleaseReadyCondition() != other.hasReleaseReadyCondition()) return false;
      if (hasReleaseReadyCondition()) {
        if (!getReleaseReadyCondition().equals(other.getReleaseReadyCondition())) return false;
      }
      if (hasSkaffoldSupportedCondition() != other.hasSkaffoldSupportedCondition()) return false;
      if (hasSkaffoldSupportedCondition()) {
        if (!getSkaffoldSupportedCondition().equals(other.getSkaffoldSupportedCondition()))
          return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasReleaseReadyCondition()) {
        hash = (37 * hash) + RELEASE_READY_CONDITION_FIELD_NUMBER;
        hash = (53 * hash) + getReleaseReadyCondition().hashCode();
      }
      if (hasSkaffoldSupportedCondition()) {
        hash = (37 * hash) + SKAFFOLD_SUPPORTED_CONDITION_FIELD_NUMBER;
        hash = (53 * hash) + getSkaffoldSupportedCondition().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseCondition parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseCondition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseCondition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseCondition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseCondition parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseCondition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseCondition parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseCondition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseCondition parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseCondition parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseCondition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseCondition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.deploy.v1.Release.ReleaseCondition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * ReleaseCondition contains all conditions relevant to a Release.
     * </pre>
     *
     * Protobuf type {@code google.cloud.deploy.v1.Release.ReleaseCondition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.Release.ReleaseCondition)
        com.google.cloud.deploy.v1.Release.ReleaseConditionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_Release_ReleaseCondition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_Release_ReleaseCondition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.deploy.v1.Release.ReleaseCondition.class,
                com.google.cloud.deploy.v1.Release.ReleaseCondition.Builder.class);
      }

      // Construct using com.google.cloud.deploy.v1.Release.ReleaseCondition.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        releaseReadyCondition_ = null;
        if (releaseReadyConditionBuilder_ != null) {
          releaseReadyConditionBuilder_.dispose();
          releaseReadyConditionBuilder_ = null;
        }
        skaffoldSupportedCondition_ = null;
        if (skaffoldSupportedConditionBuilder_ != null) {
          skaffoldSupportedConditionBuilder_.dispose();
          skaffoldSupportedConditionBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.deploy.v1.CloudDeployProto
            .internal_static_google_cloud_deploy_v1_Release_ReleaseCondition_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.Release.ReleaseCondition getDefaultInstanceForType() {
        return com.google.cloud.deploy.v1.Release.ReleaseCondition.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.Release.ReleaseCondition build() {
        com.google.cloud.deploy.v1.Release.ReleaseCondition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.deploy.v1.Release.ReleaseCondition buildPartial() {
        com.google.cloud.deploy.v1.Release.ReleaseCondition result =
            new com.google.cloud.deploy.v1.Release.ReleaseCondition(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.deploy.v1.Release.ReleaseCondition result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.releaseReadyCondition_ =
              releaseReadyConditionBuilder_ == null
                  ? releaseReadyCondition_
                  : releaseReadyConditionBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.skaffoldSupportedCondition_ =
              skaffoldSupportedConditionBuilder_ == null
                  ? skaffoldSupportedCondition_
                  : skaffoldSupportedConditionBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.deploy.v1.Release.ReleaseCondition) {
          return mergeFrom((com.google.cloud.deploy.v1.Release.ReleaseCondition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.deploy.v1.Release.ReleaseCondition other) {
        if (other == com.google.cloud.deploy.v1.Release.ReleaseCondition.getDefaultInstance())
          return this;
        if (other.hasReleaseReadyCondition()) {
          mergeReleaseReadyCondition(other.getReleaseReadyCondition());
        }
        if (other.hasSkaffoldSupportedCondition()) {
          mergeSkaffoldSupportedCondition(other.getSkaffoldSupportedCondition());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getReleaseReadyConditionFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getSkaffoldSupportedConditionFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.deploy.v1.Release.ReleaseReadyCondition releaseReadyCondition_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.deploy.v1.Release.ReleaseReadyCondition,
              com.google.cloud.deploy.v1.Release.ReleaseReadyCondition.Builder,
              com.google.cloud.deploy.v1.Release.ReleaseReadyConditionOrBuilder>
          releaseReadyConditionBuilder_;
      /**
       *
       *
       * <pre>
       * Details around the Releases's overall status.
       * </pre>
       *
       * <code>.google.cloud.deploy.v1.Release.ReleaseReadyCondition release_ready_condition = 1;
       * </code>
       *
       * @return Whether the releaseReadyCondition field is set.
       */
      public boolean hasReleaseReadyCondition() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Details around the Releases's overall status.
       * </pre>
       *
       * <code>.google.cloud.deploy.v1.Release.ReleaseReadyCondition release_ready_condition = 1;
       * </code>
       *
       * @return The releaseReadyCondition.
       */
      public com.google.cloud.deploy.v1.Release.ReleaseReadyCondition getReleaseReadyCondition() {
        if (releaseReadyConditionBuilder_ == null) {
          return releaseReadyCondition_ == null
              ? com.google.cloud.deploy.v1.Release.ReleaseReadyCondition.getDefaultInstance()
              : releaseReadyCondition_;
        } else {
          return releaseReadyConditionBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Details around the Releases's overall status.
       * </pre>
       *
       * <code>.google.cloud.deploy.v1.Release.ReleaseReadyCondition release_ready_condition = 1;
       * </code>
       */
      public Builder setReleaseReadyCondition(
          com.google.cloud.deploy.v1.Release.ReleaseReadyCondition value) {
        if (releaseReadyConditionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          releaseReadyCondition_ = value;
        } else {
          releaseReadyConditionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details around the Releases's overall status.
       * </pre>
       *
       * <code>.google.cloud.deploy.v1.Release.ReleaseReadyCondition release_ready_condition = 1;
       * </code>
       */
      public Builder setReleaseReadyCondition(
          com.google.cloud.deploy.v1.Release.ReleaseReadyCondition.Builder builderForValue) {
        if (releaseReadyConditionBuilder_ == null) {
          releaseReadyCondition_ = builderForValue.build();
        } else {
          releaseReadyConditionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details around the Releases's overall status.
       * </pre>
       *
       * <code>.google.cloud.deploy.v1.Release.ReleaseReadyCondition release_ready_condition = 1;
       * </code>
       */
      public Builder mergeReleaseReadyCondition(
          com.google.cloud.deploy.v1.Release.ReleaseReadyCondition value) {
        if (releaseReadyConditionBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && releaseReadyCondition_ != null
              && releaseReadyCondition_
                  != com.google.cloud.deploy.v1.Release.ReleaseReadyCondition
                      .getDefaultInstance()) {
            getReleaseReadyConditionBuilder().mergeFrom(value);
          } else {
            releaseReadyCondition_ = value;
          }
        } else {
          releaseReadyConditionBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details around the Releases's overall status.
       * </pre>
       *
       * <code>.google.cloud.deploy.v1.Release.ReleaseReadyCondition release_ready_condition = 1;
       * </code>
       */
      public Builder clearReleaseReadyCondition() {
        bitField0_ = (bitField0_ & ~0x00000001);
        releaseReadyCondition_ = null;
        if (releaseReadyConditionBuilder_ != null) {
          releaseReadyConditionBuilder_.dispose();
          releaseReadyConditionBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details around the Releases's overall status.
       * </pre>
       *
       * <code>.google.cloud.deploy.v1.Release.ReleaseReadyCondition release_ready_condition = 1;
       * </code>
       */
      public com.google.cloud.deploy.v1.Release.ReleaseReadyCondition.Builder
          getReleaseReadyConditionBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getReleaseReadyConditionFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Details around the Releases's overall status.
       * </pre>
       *
       * <code>.google.cloud.deploy.v1.Release.ReleaseReadyCondition release_ready_condition = 1;
       * </code>
       */
      public com.google.cloud.deploy.v1.Release.ReleaseReadyConditionOrBuilder
          getReleaseReadyConditionOrBuilder() {
        if (releaseReadyConditionBuilder_ != null) {
          return releaseReadyConditionBuilder_.getMessageOrBuilder();
        } else {
          return releaseReadyCondition_ == null
              ? com.google.cloud.deploy.v1.Release.ReleaseReadyCondition.getDefaultInstance()
              : releaseReadyCondition_;
        }
      }
      /**
       *
       *
       * <pre>
       * Details around the Releases's overall status.
       * </pre>
       *
       * <code>.google.cloud.deploy.v1.Release.ReleaseReadyCondition release_ready_condition = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.deploy.v1.Release.ReleaseReadyCondition,
              com.google.cloud.deploy.v1.Release.ReleaseReadyCondition.Builder,
              com.google.cloud.deploy.v1.Release.ReleaseReadyConditionOrBuilder>
          getReleaseReadyConditionFieldBuilder() {
        if (releaseReadyConditionBuilder_ == null) {
          releaseReadyConditionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.deploy.v1.Release.ReleaseReadyCondition,
                  com.google.cloud.deploy.v1.Release.ReleaseReadyCondition.Builder,
                  com.google.cloud.deploy.v1.Release.ReleaseReadyConditionOrBuilder>(
                  getReleaseReadyCondition(), getParentForChildren(), isClean());
          releaseReadyCondition_ = null;
        }
        return releaseReadyConditionBuilder_;
      }

      private com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition
          skaffoldSupportedCondition_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition,
              com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition.Builder,
              com.google.cloud.deploy.v1.Release.SkaffoldSupportedConditionOrBuilder>
          skaffoldSupportedConditionBuilder_;
      /**
       *
       *
       * <pre>
       * Details around the support state of the release's skaffold
       * version.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Release.SkaffoldSupportedCondition skaffold_supported_condition = 2;
       * </code>
       *
       * @return Whether the skaffoldSupportedCondition field is set.
       */
      public boolean hasSkaffoldSupportedCondition() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Details around the support state of the release's skaffold
       * version.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Release.SkaffoldSupportedCondition skaffold_supported_condition = 2;
       * </code>
       *
       * @return The skaffoldSupportedCondition.
       */
      public com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition
          getSkaffoldSupportedCondition() {
        if (skaffoldSupportedConditionBuilder_ == null) {
          return skaffoldSupportedCondition_ == null
              ? com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition.getDefaultInstance()
              : skaffoldSupportedCondition_;
        } else {
          return skaffoldSupportedConditionBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Details around the support state of the release's skaffold
       * version.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Release.SkaffoldSupportedCondition skaffold_supported_condition = 2;
       * </code>
       */
      public Builder setSkaffoldSupportedCondition(
          com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition value) {
        if (skaffoldSupportedConditionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          skaffoldSupportedCondition_ = value;
        } else {
          skaffoldSupportedConditionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details around the support state of the release's skaffold
       * version.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Release.SkaffoldSupportedCondition skaffold_supported_condition = 2;
       * </code>
       */
      public Builder setSkaffoldSupportedCondition(
          com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition.Builder builderForValue) {
        if (skaffoldSupportedConditionBuilder_ == null) {
          skaffoldSupportedCondition_ = builderForValue.build();
        } else {
          skaffoldSupportedConditionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details around the support state of the release's skaffold
       * version.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Release.SkaffoldSupportedCondition skaffold_supported_condition = 2;
       * </code>
       */
      public Builder mergeSkaffoldSupportedCondition(
          com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition value) {
        if (skaffoldSupportedConditionBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && skaffoldSupportedCondition_ != null
              && skaffoldSupportedCondition_
                  != com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition
                      .getDefaultInstance()) {
            getSkaffoldSupportedConditionBuilder().mergeFrom(value);
          } else {
            skaffoldSupportedCondition_ = value;
          }
        } else {
          skaffoldSupportedConditionBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details around the support state of the release's skaffold
       * version.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Release.SkaffoldSupportedCondition skaffold_supported_condition = 2;
       * </code>
       */
      public Builder clearSkaffoldSupportedCondition() {
        bitField0_ = (bitField0_ & ~0x00000002);
        skaffoldSupportedCondition_ = null;
        if (skaffoldSupportedConditionBuilder_ != null) {
          skaffoldSupportedConditionBuilder_.dispose();
          skaffoldSupportedConditionBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Details around the support state of the release's skaffold
       * version.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Release.SkaffoldSupportedCondition skaffold_supported_condition = 2;
       * </code>
       */
      public com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition.Builder
          getSkaffoldSupportedConditionBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSkaffoldSupportedConditionFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Details around the support state of the release's skaffold
       * version.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Release.SkaffoldSupportedCondition skaffold_supported_condition = 2;
       * </code>
       */
      public com.google.cloud.deploy.v1.Release.SkaffoldSupportedConditionOrBuilder
          getSkaffoldSupportedConditionOrBuilder() {
        if (skaffoldSupportedConditionBuilder_ != null) {
          return skaffoldSupportedConditionBuilder_.getMessageOrBuilder();
        } else {
          return skaffoldSupportedCondition_ == null
              ? com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition.getDefaultInstance()
              : skaffoldSupportedCondition_;
        }
      }
      /**
       *
       *
       * <pre>
       * Details around the support state of the release's skaffold
       * version.
       * </pre>
       *
       * <code>
       * .google.cloud.deploy.v1.Release.SkaffoldSupportedCondition skaffold_supported_condition = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition,
              com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition.Builder,
              com.google.cloud.deploy.v1.Release.SkaffoldSupportedConditionOrBuilder>
          getSkaffoldSupportedConditionFieldBuilder() {
        if (skaffoldSupportedConditionBuilder_ == null) {
          skaffoldSupportedConditionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition,
                  com.google.cloud.deploy.v1.Release.SkaffoldSupportedCondition.Builder,
                  com.google.cloud.deploy.v1.Release.SkaffoldSupportedConditionOrBuilder>(
                  getSkaffoldSupportedCondition(), getParentForChildren(), isClean());
          skaffoldSupportedCondition_ = null;
        }
        return skaffoldSupportedConditionBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.Release.ReleaseCondition)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.Release.ReleaseCondition)
    private static final com.google.cloud.deploy.v1.Release.ReleaseCondition DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.Release.ReleaseCondition();
    }

    public static com.google.cloud.deploy.v1.Release.ReleaseCondition getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReleaseCondition> PARSER =
        new com.google.protobuf.AbstractParser<ReleaseCondition>() {
          @java.lang.Override
          public ReleaseCondition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ReleaseCondition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReleaseCondition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Release.ReleaseCondition getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Optional. Name of the `Release`. Format is
   * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/[a-z][a-z0-9&#92;-]{0,62}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Name of the `Release`. Format is
   * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/[a-z][a-z0-9&#92;-]{0,62}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uid_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the `Release`.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uid.
   */
  @java.lang.Override
  public java.lang.String getUid() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uid_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier of the `Release`.
   * </pre>
   *
   * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uid.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUidBytes() {
    java.lang.Object ref = uid_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uid_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Description of the `Release`. Max length is 255 characters.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Description of the `Release`. Max length is 255 characters.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 4;

  private static final class AnnotationsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.deploy.v1.CloudDeployProto
                .internal_static_google_cloud_deploy_v1_Release_AnnotationsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetAnnotations() {
    if (annotations_ == null) {
      return com.google.protobuf.MapField.emptyMapField(AnnotationsDefaultEntryHolder.defaultEntry);
    }
    return annotations_;
  }

  public int getAnnotationsCount() {
    return internalGetAnnotations().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
   * for more details such as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  @java.lang.Override
  public boolean containsAnnotations(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetAnnotations().getMap().containsKey(key);
  }
  /** Use {@link #getAnnotationsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
    return getAnnotationsMap();
  }
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
   * for more details such as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
    return internalGetAnnotations().getMap();
  }
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
   * for more details such as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getAnnotationsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * User annotations. These attributes can only be set and used by the
   * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
   * for more details such as format and size limitations.
   * </pre>
   *
   * <code>map&lt;string, string&gt; annotations = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int LABELS_FIELD_NUMBER = 5;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.deploy.v1.CloudDeployProto
                .internal_static_google_cloud_deploy_v1_Release_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels are attributes that can be set and used by both the
   * user and by Cloud Deploy. Labels must meet the following constraints:
   *
   * * Keys and values can contain only lowercase letters, numeric characters,
   * underscores, and dashes.
   * * All characters must use UTF-8 encoding, and international characters are
   * allowed.
   * * Keys must start with a lowercase letter or international character.
   * * Each resource is limited to a maximum of 64 labels.
   *
   * Both keys and values are additionally constrained to be &lt;= 128 bytes.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 5;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int ABANDONED_FIELD_NUMBER = 23;
  private boolean abandoned_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Indicates whether this is an abandoned release.
   * </pre>
   *
   * <code>bool abandoned = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The abandoned.
   */
  @java.lang.Override
  public boolean getAbandoned() {
    return abandoned_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Release` was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Release` was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the `Release` was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int RENDER_START_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp renderStartTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the render began.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp render_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the renderStartTime field is set.
   */
  @java.lang.Override
  public boolean hasRenderStartTime() {
    return renderStartTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the render began.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp render_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The renderStartTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getRenderStartTime() {
    return renderStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : renderStartTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the render began.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp render_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getRenderStartTimeOrBuilder() {
    return renderStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : renderStartTime_;
  }

  public static final int RENDER_END_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp renderEndTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the render completed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp render_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the renderEndTime field is set.
   */
  @java.lang.Override
  public boolean hasRenderEndTime() {
    return renderEndTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the render completed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp render_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The renderEndTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getRenderEndTime() {
    return renderEndTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : renderEndTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the render completed.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp render_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getRenderEndTimeOrBuilder() {
    return renderEndTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : renderEndTime_;
  }

  public static final int SKAFFOLD_CONFIG_URI_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private volatile java.lang.Object skaffoldConfigUri_ = "";
  /**
   *
   *
   * <pre>
   * Cloud Storage URI of tar.gz archive containing Skaffold configuration.
   * </pre>
   *
   * <code>string skaffold_config_uri = 17;</code>
   *
   * @return The skaffoldConfigUri.
   */
  @java.lang.Override
  public java.lang.String getSkaffoldConfigUri() {
    java.lang.Object ref = skaffoldConfigUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      skaffoldConfigUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Cloud Storage URI of tar.gz archive containing Skaffold configuration.
   * </pre>
   *
   * <code>string skaffold_config_uri = 17;</code>
   *
   * @return The bytes for skaffoldConfigUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSkaffoldConfigUriBytes() {
    java.lang.Object ref = skaffoldConfigUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      skaffoldConfigUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SKAFFOLD_CONFIG_PATH_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object skaffoldConfigPath_ = "";
  /**
   *
   *
   * <pre>
   * Filepath of the Skaffold config inside of the config URI.
   * </pre>
   *
   * <code>string skaffold_config_path = 9;</code>
   *
   * @return The skaffoldConfigPath.
   */
  @java.lang.Override
  public java.lang.String getSkaffoldConfigPath() {
    java.lang.Object ref = skaffoldConfigPath_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      skaffoldConfigPath_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Filepath of the Skaffold config inside of the config URI.
   * </pre>
   *
   * <code>string skaffold_config_path = 9;</code>
   *
   * @return The bytes for skaffoldConfigPath.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSkaffoldConfigPathBytes() {
    java.lang.Object ref = skaffoldConfigPath_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      skaffoldConfigPath_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BUILD_ARTIFACTS_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.deploy.v1.BuildArtifact> buildArtifacts_;
  /**
   *
   *
   * <pre>
   * List of artifacts to pass through to Skaffold command.
   * </pre>
   *
   * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.deploy.v1.BuildArtifact> getBuildArtifactsList() {
    return buildArtifacts_;
  }
  /**
   *
   *
   * <pre>
   * List of artifacts to pass through to Skaffold command.
   * </pre>
   *
   * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.deploy.v1.BuildArtifactOrBuilder>
      getBuildArtifactsOrBuilderList() {
    return buildArtifacts_;
  }
  /**
   *
   *
   * <pre>
   * List of artifacts to pass through to Skaffold command.
   * </pre>
   *
   * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
   */
  @java.lang.Override
  public int getBuildArtifactsCount() {
    return buildArtifacts_.size();
  }
  /**
   *
   *
   * <pre>
   * List of artifacts to pass through to Skaffold command.
   * </pre>
   *
   * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.BuildArtifact getBuildArtifacts(int index) {
    return buildArtifacts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * List of artifacts to pass through to Skaffold command.
   * </pre>
   *
   * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.BuildArtifactOrBuilder getBuildArtifactsOrBuilder(int index) {
    return buildArtifacts_.get(index);
  }

  public static final int DELIVERY_PIPELINE_SNAPSHOT_FIELD_NUMBER = 11;
  private com.google.cloud.deploy.v1.DeliveryPipeline deliveryPipelineSnapshot_;
  /**
   *
   *
   * <pre>
   * Output only. Snapshot of the parent pipeline taken at release creation
   * time.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeliveryPipeline delivery_pipeline_snapshot = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the deliveryPipelineSnapshot field is set.
   */
  @java.lang.Override
  public boolean hasDeliveryPipelineSnapshot() {
    return deliveryPipelineSnapshot_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Snapshot of the parent pipeline taken at release creation
   * time.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeliveryPipeline delivery_pipeline_snapshot = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The deliveryPipelineSnapshot.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeliveryPipeline getDeliveryPipelineSnapshot() {
    return deliveryPipelineSnapshot_ == null
        ? com.google.cloud.deploy.v1.DeliveryPipeline.getDefaultInstance()
        : deliveryPipelineSnapshot_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Snapshot of the parent pipeline taken at release creation
   * time.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.DeliveryPipeline delivery_pipeline_snapshot = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.DeliveryPipelineOrBuilder
      getDeliveryPipelineSnapshotOrBuilder() {
    return deliveryPipelineSnapshot_ == null
        ? com.google.cloud.deploy.v1.DeliveryPipeline.getDefaultInstance()
        : deliveryPipelineSnapshot_;
  }

  public static final int TARGET_SNAPSHOTS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.deploy.v1.Target> targetSnapshots_;
  /**
   *
   *
   * <pre>
   * Output only. Snapshot of the targets taken at release creation time.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.deploy.v1.Target> getTargetSnapshotsList() {
    return targetSnapshots_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Snapshot of the targets taken at release creation time.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.deploy.v1.TargetOrBuilder>
      getTargetSnapshotsOrBuilderList() {
    return targetSnapshots_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Snapshot of the targets taken at release creation time.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getTargetSnapshotsCount() {
    return targetSnapshots_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Snapshot of the targets taken at release creation time.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.Target getTargetSnapshots(int index) {
    return targetSnapshots_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Snapshot of the targets taken at release creation time.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.TargetOrBuilder getTargetSnapshotsOrBuilder(int index) {
    return targetSnapshots_.get(index);
  }

  public static final int RENDER_STATE_FIELD_NUMBER = 13;
  private int renderState_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Current state of the render operation.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Release.RenderState render_state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for renderState.
   */
  @java.lang.Override
  public int getRenderStateValue() {
    return renderState_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Current state of the render operation.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Release.RenderState render_state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The renderState.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.Release.RenderState getRenderState() {
    com.google.cloud.deploy.v1.Release.RenderState result =
        com.google.cloud.deploy.v1.Release.RenderState.forNumber(renderState_);
    return result == null ? com.google.cloud.deploy.v1.Release.RenderState.UNRECOGNIZED : result;
  }

  public static final int ETAG_FIELD_NUMBER = 16;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 16;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This checksum is computed by the server based on the value of other
   * fields, and may be sent on update and delete requests to ensure the
   * client has an up-to-date value before proceeding.
   * </pre>
   *
   * <code>string etag = 16;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SKAFFOLD_VERSION_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private volatile java.lang.Object skaffoldVersion_ = "";
  /**
   *
   *
   * <pre>
   * The Skaffold version to use when operating on this release, such as
   * "1.20.0". Not all versions are valid; Cloud Deploy supports a specific set
   * of versions.
   *
   * If unset, the most recent supported Skaffold version will be used.
   * </pre>
   *
   * <code>string skaffold_version = 19;</code>
   *
   * @return The skaffoldVersion.
   */
  @java.lang.Override
  public java.lang.String getSkaffoldVersion() {
    java.lang.Object ref = skaffoldVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      skaffoldVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Skaffold version to use when operating on this release, such as
   * "1.20.0". Not all versions are valid; Cloud Deploy supports a specific set
   * of versions.
   *
   * If unset, the most recent supported Skaffold version will be used.
   * </pre>
   *
   * <code>string skaffold_version = 19;</code>
   *
   * @return The bytes for skaffoldVersion.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSkaffoldVersionBytes() {
    java.lang.Object ref = skaffoldVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      skaffoldVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_ARTIFACTS_FIELD_NUMBER = 20;

  private static final class TargetArtifactsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.deploy.v1.TargetArtifact>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.deploy.v1.TargetArtifact>newDefaultInstance(
                    com.google.cloud.deploy.v1.CloudDeployProto
                        .internal_static_google_cloud_deploy_v1_Release_TargetArtifactsEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.cloud.deploy.v1.TargetArtifact.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.cloud.deploy.v1.TargetArtifact>
      targetArtifacts_;

  private com.google.protobuf.MapField<java.lang.String, com.google.cloud.deploy.v1.TargetArtifact>
      internalGetTargetArtifacts() {
    if (targetArtifacts_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          TargetArtifactsDefaultEntryHolder.defaultEntry);
    }
    return targetArtifacts_;
  }

  public int getTargetArtifactsCount() {
    return internalGetTargetArtifacts().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Map from target ID to the target artifacts created
   * during the render operation.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.deploy.v1.TargetArtifact&gt; target_artifacts = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsTargetArtifacts(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetTargetArtifacts().getMap().containsKey(key);
  }
  /** Use {@link #getTargetArtifactsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.deploy.v1.TargetArtifact>
      getTargetArtifacts() {
    return getTargetArtifactsMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Map from target ID to the target artifacts created
   * during the render operation.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.deploy.v1.TargetArtifact&gt; target_artifacts = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.deploy.v1.TargetArtifact>
      getTargetArtifactsMap() {
    return internalGetTargetArtifacts().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Map from target ID to the target artifacts created
   * during the render operation.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.deploy.v1.TargetArtifact&gt; target_artifacts = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.deploy.v1.TargetArtifact getTargetArtifactsOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.deploy.v1.TargetArtifact defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.deploy.v1.TargetArtifact> map =
        internalGetTargetArtifacts().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. Map from target ID to the target artifacts created
   * during the render operation.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.deploy.v1.TargetArtifact&gt; target_artifacts = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.TargetArtifact getTargetArtifactsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.deploy.v1.TargetArtifact> map =
        internalGetTargetArtifacts().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int TARGET_RENDERS_FIELD_NUMBER = 22;

  private static final class TargetRendersDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.deploy.v1.Release.TargetRender>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.deploy.v1.Release.TargetRender>
                    newDefaultInstance(
                        com.google.cloud.deploy.v1.CloudDeployProto
                            .internal_static_google_cloud_deploy_v1_Release_TargetRendersEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.deploy.v1.Release.TargetRender.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.deploy.v1.Release.TargetRender>
      targetRenders_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.deploy.v1.Release.TargetRender>
      internalGetTargetRenders() {
    if (targetRenders_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          TargetRendersDefaultEntryHolder.defaultEntry);
    }
    return targetRenders_;
  }

  public int getTargetRendersCount() {
    return internalGetTargetRenders().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Map from target ID to details of the render operation for that
   * target.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.deploy.v1.Release.TargetRender&gt; target_renders = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public boolean containsTargetRenders(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetTargetRenders().getMap().containsKey(key);
  }
  /** Use {@link #getTargetRendersMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.deploy.v1.Release.TargetRender>
      getTargetRenders() {
    return getTargetRendersMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Map from target ID to details of the render operation for that
   * target.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.deploy.v1.Release.TargetRender&gt; target_renders = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.deploy.v1.Release.TargetRender>
      getTargetRendersMap() {
    return internalGetTargetRenders().getMap();
  }
  /**
   *
   *
   * <pre>
   * Output only. Map from target ID to details of the render operation for that
   * target.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.deploy.v1.Release.TargetRender&gt; target_renders = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.deploy.v1.Release.TargetRender getTargetRendersOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.deploy.v1.Release.TargetRender defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.deploy.v1.Release.TargetRender> map =
        internalGetTargetRenders().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Output only. Map from target ID to details of the render operation for that
   * target.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.deploy.v1.Release.TargetRender&gt; target_renders = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.Release.TargetRender getTargetRendersOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.deploy.v1.Release.TargetRender> map =
        internalGetTargetRenders().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int CONDITION_FIELD_NUMBER = 24;
  private com.google.cloud.deploy.v1.Release.ReleaseCondition condition_;
  /**
   *
   *
   * <pre>
   * Output only. Information around the state of the Release.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Release.ReleaseCondition condition = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the condition field is set.
   */
  @java.lang.Override
  public boolean hasCondition() {
    return condition_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information around the state of the Release.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Release.ReleaseCondition condition = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The condition.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.Release.ReleaseCondition getCondition() {
    return condition_ == null
        ? com.google.cloud.deploy.v1.Release.ReleaseCondition.getDefaultInstance()
        : condition_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information around the state of the Release.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.Release.ReleaseCondition condition = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.Release.ReleaseConditionOrBuilder getConditionOrBuilder() {
    return condition_ == null
        ? com.google.cloud.deploy.v1.Release.ReleaseCondition.getDefaultInstance()
        : condition_;
  }

  public static final int DEPLOY_PARAMETERS_FIELD_NUMBER = 25;

  private static final class DeployParametersDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.deploy.v1.CloudDeployProto
                .internal_static_google_cloud_deploy_v1_Release_DeployParametersEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> deployParameters_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetDeployParameters() {
    if (deployParameters_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          DeployParametersDefaultEntryHolder.defaultEntry);
    }
    return deployParameters_;
  }

  public int getDeployParametersCount() {
    return internalGetDeployParameters().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The deploy parameters to use for all targets in this release.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; deploy_parameters = 25 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsDeployParameters(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetDeployParameters().getMap().containsKey(key);
  }
  /** Use {@link #getDeployParametersMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getDeployParameters() {
    return getDeployParametersMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The deploy parameters to use for all targets in this release.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; deploy_parameters = 25 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getDeployParametersMap() {
    return internalGetDeployParameters().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The deploy parameters to use for all targets in this release.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; deploy_parameters = 25 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getDeployParametersOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDeployParameters().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The deploy parameters to use for all targets in this release.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; deploy_parameters = 25 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getDeployParametersOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDeployParameters().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, uid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetAnnotations(), AnnotationsDefaultEntryHolder.defaultEntry, 4);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 5);
    if (createTime_ != null) {
      output.writeMessage(6, getCreateTime());
    }
    if (renderStartTime_ != null) {
      output.writeMessage(7, getRenderStartTime());
    }
    if (renderEndTime_ != null) {
      output.writeMessage(8, getRenderEndTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(skaffoldConfigPath_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, skaffoldConfigPath_);
    }
    for (int i = 0; i < buildArtifacts_.size(); i++) {
      output.writeMessage(10, buildArtifacts_.get(i));
    }
    if (deliveryPipelineSnapshot_ != null) {
      output.writeMessage(11, getDeliveryPipelineSnapshot());
    }
    for (int i = 0; i < targetSnapshots_.size(); i++) {
      output.writeMessage(12, targetSnapshots_.get(i));
    }
    if (renderState_
        != com.google.cloud.deploy.v1.Release.RenderState.RENDER_STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(13, renderState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 16, etag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(skaffoldConfigUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, skaffoldConfigUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(skaffoldVersion_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, skaffoldVersion_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetTargetArtifacts(), TargetArtifactsDefaultEntryHolder.defaultEntry, 20);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetTargetRenders(), TargetRendersDefaultEntryHolder.defaultEntry, 22);
    if (abandoned_ != false) {
      output.writeBool(23, abandoned_);
    }
    if (condition_ != null) {
      output.writeMessage(24, getCondition());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetDeployParameters(), DeployParametersDefaultEntryHolder.defaultEntry, 25);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uid_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, uid_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetAnnotations().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
          AnnotationsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, annotations__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, labels__);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (renderStartTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getRenderStartTime());
    }
    if (renderEndTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getRenderEndTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(skaffoldConfigPath_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, skaffoldConfigPath_);
    }
    for (int i = 0; i < buildArtifacts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, buildArtifacts_.get(i));
    }
    if (deliveryPipelineSnapshot_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, getDeliveryPipelineSnapshot());
    }
    for (int i = 0; i < targetSnapshots_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, targetSnapshots_.get(i));
    }
    if (renderState_
        != com.google.cloud.deploy.v1.Release.RenderState.RENDER_STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(13, renderState_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(16, etag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(skaffoldConfigUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, skaffoldConfigUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(skaffoldVersion_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, skaffoldVersion_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.deploy.v1.TargetArtifact> entry :
        internalGetTargetArtifacts().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.deploy.v1.TargetArtifact>
          targetArtifacts__ =
              TargetArtifactsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(20, targetArtifacts__);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.deploy.v1.Release.TargetRender>
        entry : internalGetTargetRenders().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.deploy.v1.Release.TargetRender>
          targetRenders__ =
              TargetRendersDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, targetRenders__);
    }
    if (abandoned_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(23, abandoned_);
    }
    if (condition_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(24, getCondition());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetDeployParameters().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> deployParameters__ =
          DeployParametersDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(25, deployParameters__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.Release)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.Release other = (com.google.cloud.deploy.v1.Release) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getUid().equals(other.getUid())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!internalGetAnnotations().equals(other.internalGetAnnotations())) return false;
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (getAbandoned() != other.getAbandoned()) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasRenderStartTime() != other.hasRenderStartTime()) return false;
    if (hasRenderStartTime()) {
      if (!getRenderStartTime().equals(other.getRenderStartTime())) return false;
    }
    if (hasRenderEndTime() != other.hasRenderEndTime()) return false;
    if (hasRenderEndTime()) {
      if (!getRenderEndTime().equals(other.getRenderEndTime())) return false;
    }
    if (!getSkaffoldConfigUri().equals(other.getSkaffoldConfigUri())) return false;
    if (!getSkaffoldConfigPath().equals(other.getSkaffoldConfigPath())) return false;
    if (!getBuildArtifactsList().equals(other.getBuildArtifactsList())) return false;
    if (hasDeliveryPipelineSnapshot() != other.hasDeliveryPipelineSnapshot()) return false;
    if (hasDeliveryPipelineSnapshot()) {
      if (!getDeliveryPipelineSnapshot().equals(other.getDeliveryPipelineSnapshot())) return false;
    }
    if (!getTargetSnapshotsList().equals(other.getTargetSnapshotsList())) return false;
    if (renderState_ != other.renderState_) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getSkaffoldVersion().equals(other.getSkaffoldVersion())) return false;
    if (!internalGetTargetArtifacts().equals(other.internalGetTargetArtifacts())) return false;
    if (!internalGetTargetRenders().equals(other.internalGetTargetRenders())) return false;
    if (hasCondition() != other.hasCondition()) return false;
    if (hasCondition()) {
      if (!getCondition().equals(other.getCondition())) return false;
    }
    if (!internalGetDeployParameters().equals(other.internalGetDeployParameters())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + UID_FIELD_NUMBER;
    hash = (53 * hash) + getUid().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (!internalGetAnnotations().getMap().isEmpty()) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetAnnotations().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + ABANDONED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAbandoned());
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasRenderStartTime()) {
      hash = (37 * hash) + RENDER_START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getRenderStartTime().hashCode();
    }
    if (hasRenderEndTime()) {
      hash = (37 * hash) + RENDER_END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getRenderEndTime().hashCode();
    }
    hash = (37 * hash) + SKAFFOLD_CONFIG_URI_FIELD_NUMBER;
    hash = (53 * hash) + getSkaffoldConfigUri().hashCode();
    hash = (37 * hash) + SKAFFOLD_CONFIG_PATH_FIELD_NUMBER;
    hash = (53 * hash) + getSkaffoldConfigPath().hashCode();
    if (getBuildArtifactsCount() > 0) {
      hash = (37 * hash) + BUILD_ARTIFACTS_FIELD_NUMBER;
      hash = (53 * hash) + getBuildArtifactsList().hashCode();
    }
    if (hasDeliveryPipelineSnapshot()) {
      hash = (37 * hash) + DELIVERY_PIPELINE_SNAPSHOT_FIELD_NUMBER;
      hash = (53 * hash) + getDeliveryPipelineSnapshot().hashCode();
    }
    if (getTargetSnapshotsCount() > 0) {
      hash = (37 * hash) + TARGET_SNAPSHOTS_FIELD_NUMBER;
      hash = (53 * hash) + getTargetSnapshotsList().hashCode();
    }
    hash = (37 * hash) + RENDER_STATE_FIELD_NUMBER;
    hash = (53 * hash) + renderState_;
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    hash = (37 * hash) + SKAFFOLD_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getSkaffoldVersion().hashCode();
    if (!internalGetTargetArtifacts().getMap().isEmpty()) {
      hash = (37 * hash) + TARGET_ARTIFACTS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetTargetArtifacts().hashCode();
    }
    if (!internalGetTargetRenders().getMap().isEmpty()) {
      hash = (37 * hash) + TARGET_RENDERS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetTargetRenders().hashCode();
    }
    if (hasCondition()) {
      hash = (37 * hash) + CONDITION_FIELD_NUMBER;
      hash = (53 * hash) + getCondition().hashCode();
    }
    if (!internalGetDeployParameters().getMap().isEmpty()) {
      hash = (37 * hash) + DEPLOY_PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetDeployParameters().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.Release parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Release parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Release parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Release parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Release parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.Release parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Release parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Release parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Release parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Release parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.Release parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.Release parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.Release prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A `Release` resource in the Cloud Deploy API.
   *
   * A `Release` defines a specific Skaffold configuration instance
   * that can be deployed.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.Release}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.Release)
      com.google.cloud.deploy.v1.ReleaseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Release_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetAnnotations();
        case 5:
          return internalGetLabels();
        case 20:
          return internalGetTargetArtifacts();
        case 22:
          return internalGetTargetRenders();
        case 25:
          return internalGetDeployParameters();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableAnnotations();
        case 5:
          return internalGetMutableLabels();
        case 20:
          return internalGetMutableTargetArtifacts();
        case 22:
          return internalGetMutableTargetRenders();
        case 25:
          return internalGetMutableDeployParameters();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Release_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.Release.class,
              com.google.cloud.deploy.v1.Release.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.Release.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      uid_ = "";
      description_ = "";
      internalGetMutableAnnotations().clear();
      internalGetMutableLabels().clear();
      abandoned_ = false;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      renderStartTime_ = null;
      if (renderStartTimeBuilder_ != null) {
        renderStartTimeBuilder_.dispose();
        renderStartTimeBuilder_ = null;
      }
      renderEndTime_ = null;
      if (renderEndTimeBuilder_ != null) {
        renderEndTimeBuilder_.dispose();
        renderEndTimeBuilder_ = null;
      }
      skaffoldConfigUri_ = "";
      skaffoldConfigPath_ = "";
      if (buildArtifactsBuilder_ == null) {
        buildArtifacts_ = java.util.Collections.emptyList();
      } else {
        buildArtifacts_ = null;
        buildArtifactsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000800);
      deliveryPipelineSnapshot_ = null;
      if (deliveryPipelineSnapshotBuilder_ != null) {
        deliveryPipelineSnapshotBuilder_.dispose();
        deliveryPipelineSnapshotBuilder_ = null;
      }
      if (targetSnapshotsBuilder_ == null) {
        targetSnapshots_ = java.util.Collections.emptyList();
      } else {
        targetSnapshots_ = null;
        targetSnapshotsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00002000);
      renderState_ = 0;
      etag_ = "";
      skaffoldVersion_ = "";
      internalGetMutableTargetArtifacts().clear();
      internalGetMutableTargetRenders().clear();
      condition_ = null;
      if (conditionBuilder_ != null) {
        conditionBuilder_.dispose();
        conditionBuilder_ = null;
      }
      internalGetMutableDeployParameters().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_Release_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Release getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.Release.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Release build() {
      com.google.cloud.deploy.v1.Release result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.Release buildPartial() {
      com.google.cloud.deploy.v1.Release result = new com.google.cloud.deploy.v1.Release(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.deploy.v1.Release result) {
      if (buildArtifactsBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)) {
          buildArtifacts_ = java.util.Collections.unmodifiableList(buildArtifacts_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.buildArtifacts_ = buildArtifacts_;
      } else {
        result.buildArtifacts_ = buildArtifactsBuilder_.build();
      }
      if (targetSnapshotsBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)) {
          targetSnapshots_ = java.util.Collections.unmodifiableList(targetSnapshots_);
          bitField0_ = (bitField0_ & ~0x00002000);
        }
        result.targetSnapshots_ = targetSnapshots_;
      } else {
        result.targetSnapshots_ = targetSnapshotsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.deploy.v1.Release result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.uid_ = uid_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.annotations_ = internalGetAnnotations();
        result.annotations_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.abandoned_ = abandoned_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.renderStartTime_ =
            renderStartTimeBuilder_ == null ? renderStartTime_ : renderStartTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.renderEndTime_ =
            renderEndTimeBuilder_ == null ? renderEndTime_ : renderEndTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.skaffoldConfigUri_ = skaffoldConfigUri_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.skaffoldConfigPath_ = skaffoldConfigPath_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.deliveryPipelineSnapshot_ =
            deliveryPipelineSnapshotBuilder_ == null
                ? deliveryPipelineSnapshot_
                : deliveryPipelineSnapshotBuilder_.build();
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.renderState_ = renderState_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.skaffoldVersion_ = skaffoldVersion_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.targetArtifacts_ = internalGetTargetArtifacts();
        result.targetArtifacts_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.targetRenders_ = internalGetTargetRenders();
        result.targetRenders_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.condition_ = conditionBuilder_ == null ? condition_ : conditionBuilder_.build();
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.deployParameters_ = internalGetDeployParameters();
        result.deployParameters_.makeImmutable();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.Release) {
        return mergeFrom((com.google.cloud.deploy.v1.Release) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.Release other) {
      if (other == com.google.cloud.deploy.v1.Release.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getUid().isEmpty()) {
        uid_ = other.uid_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      internalGetMutableAnnotations().mergeFrom(other.internalGetAnnotations());
      bitField0_ |= 0x00000008;
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000010;
      if (other.getAbandoned() != false) {
        setAbandoned(other.getAbandoned());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasRenderStartTime()) {
        mergeRenderStartTime(other.getRenderStartTime());
      }
      if (other.hasRenderEndTime()) {
        mergeRenderEndTime(other.getRenderEndTime());
      }
      if (!other.getSkaffoldConfigUri().isEmpty()) {
        skaffoldConfigUri_ = other.skaffoldConfigUri_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.getSkaffoldConfigPath().isEmpty()) {
        skaffoldConfigPath_ = other.skaffoldConfigPath_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (buildArtifactsBuilder_ == null) {
        if (!other.buildArtifacts_.isEmpty()) {
          if (buildArtifacts_.isEmpty()) {
            buildArtifacts_ = other.buildArtifacts_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureBuildArtifactsIsMutable();
            buildArtifacts_.addAll(other.buildArtifacts_);
          }
          onChanged();
        }
      } else {
        if (!other.buildArtifacts_.isEmpty()) {
          if (buildArtifactsBuilder_.isEmpty()) {
            buildArtifactsBuilder_.dispose();
            buildArtifactsBuilder_ = null;
            buildArtifacts_ = other.buildArtifacts_;
            bitField0_ = (bitField0_ & ~0x00000800);
            buildArtifactsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getBuildArtifactsFieldBuilder()
                    : null;
          } else {
            buildArtifactsBuilder_.addAllMessages(other.buildArtifacts_);
          }
        }
      }
      if (other.hasDeliveryPipelineSnapshot()) {
        mergeDeliveryPipelineSnapshot(other.getDeliveryPipelineSnapshot());
      }
      if (targetSnapshotsBuilder_ == null) {
        if (!other.targetSnapshots_.isEmpty()) {
          if (targetSnapshots_.isEmpty()) {
            targetSnapshots_ = other.targetSnapshots_;
            bitField0_ = (bitField0_ & ~0x00002000);
          } else {
            ensureTargetSnapshotsIsMutable();
            targetSnapshots_.addAll(other.targetSnapshots_);
          }
          onChanged();
        }
      } else {
        if (!other.targetSnapshots_.isEmpty()) {
          if (targetSnapshotsBuilder_.isEmpty()) {
            targetSnapshotsBuilder_.dispose();
            targetSnapshotsBuilder_ = null;
            targetSnapshots_ = other.targetSnapshots_;
            bitField0_ = (bitField0_ & ~0x00002000);
            targetSnapshotsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTargetSnapshotsFieldBuilder()
                    : null;
          } else {
            targetSnapshotsBuilder_.addAllMessages(other.targetSnapshots_);
          }
        }
      }
      if (other.renderState_ != 0) {
        setRenderStateValue(other.getRenderStateValue());
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (!other.getSkaffoldVersion().isEmpty()) {
        skaffoldVersion_ = other.skaffoldVersion_;
        bitField0_ |= 0x00010000;
        onChanged();
      }
      internalGetMutableTargetArtifacts().mergeFrom(other.internalGetTargetArtifacts());
      bitField0_ |= 0x00020000;
      internalGetMutableTargetRenders().mergeFrom(other.internalGetTargetRenders());
      bitField0_ |= 0x00040000;
      if (other.hasCondition()) {
        mergeCondition(other.getCondition());
      }
      internalGetMutableDeployParameters().mergeFrom(other.internalGetDeployParameters());
      bitField0_ |= 0x00100000;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                uid_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> annotations__ =
                    input.readMessage(
                        AnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableAnnotations()
                    .getMutableMap()
                    .put(annotations__.getKey(), annotations__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getRenderStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getRenderEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 74:
              {
                skaffoldConfigPath_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 74
            case 82:
              {
                com.google.cloud.deploy.v1.BuildArtifact m =
                    input.readMessage(
                        com.google.cloud.deploy.v1.BuildArtifact.parser(), extensionRegistry);
                if (buildArtifactsBuilder_ == null) {
                  ensureBuildArtifactsIsMutable();
                  buildArtifacts_.add(m);
                } else {
                  buildArtifactsBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 90:
              {
                input.readMessage(
                    getDeliveryPipelineSnapshotFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 90
            case 98:
              {
                com.google.cloud.deploy.v1.Target m =
                    input.readMessage(
                        com.google.cloud.deploy.v1.Target.parser(), extensionRegistry);
                if (targetSnapshotsBuilder_ == null) {
                  ensureTargetSnapshotsIsMutable();
                  targetSnapshots_.add(m);
                } else {
                  targetSnapshotsBuilder_.addMessage(m);
                }
                break;
              } // case 98
            case 104:
              {
                renderState_ = input.readEnum();
                bitField0_ |= 0x00004000;
                break;
              } // case 104
            case 130:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 130
            case 138:
              {
                skaffoldConfigUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 138
            case 154:
              {
                skaffoldVersion_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00010000;
                break;
              } // case 154
            case 162:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.deploy.v1.TargetArtifact>
                    targetArtifacts__ =
                        input.readMessage(
                            TargetArtifactsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableTargetArtifacts()
                    .getMutableMap()
                    .put(targetArtifacts__.getKey(), targetArtifacts__.getValue());
                bitField0_ |= 0x00020000;
                break;
              } // case 162
            case 178:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.deploy.v1.Release.TargetRender>
                    targetRenders__ =
                        input.readMessage(
                            TargetRendersDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableTargetRenders()
                    .getMutableMap()
                    .put(targetRenders__.getKey(), targetRenders__.getValue());
                bitField0_ |= 0x00040000;
                break;
              } // case 178
            case 184:
              {
                abandoned_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 184
            case 194:
              {
                input.readMessage(getConditionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00080000;
                break;
              } // case 194
            case 202:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    deployParameters__ =
                        input.readMessage(
                            DeployParametersDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableDeployParameters()
                    .getMutableMap()
                    .put(deployParameters__.getKey(), deployParameters__.getValue());
                bitField0_ |= 0x00100000;
                break;
              } // case 202
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Name of the `Release`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the `Release`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the `Release`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the `Release`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Name of the `Release`. Format is
     * `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object uid_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `Release`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uid.
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `Release`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uid.
     */
    public com.google.protobuf.ByteString getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `Release`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uid to set.
     * @return This builder for chaining.
     */
    public Builder setUid(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `Release`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUid() {
      uid_ = getDefaultInstance().getUid();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier of the `Release`.
     * </pre>
     *
     * <code>string uid = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uid to set.
     * @return This builder for chaining.
     */
    public Builder setUidBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uid_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Description of the `Release`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the `Release`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the `Release`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the `Release`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the `Release`. Max length is 255 characters.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> annotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetAnnotations() {
      if (annotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            AnnotationsDefaultEntryHolder.defaultEntry);
      }
      return annotations_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableAnnotations() {
      if (annotations_ == null) {
        annotations_ =
            com.google.protobuf.MapField.newMapField(AnnotationsDefaultEntryHolder.defaultEntry);
      }
      if (!annotations_.isMutable()) {
        annotations_ = annotations_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return annotations_;
    }

    public int getAnnotationsCount() {
      return internalGetAnnotations().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
     * for more details such as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    @java.lang.Override
    public boolean containsAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetAnnotations().getMap().containsKey(key);
    }
    /** Use {@link #getAnnotationsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getAnnotations() {
      return getAnnotationsMap();
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
     * for more details such as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getAnnotationsMap() {
      return internalGetAnnotations().getMap();
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
     * for more details such as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getAnnotationsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
     * for more details such as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearAnnotations() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableAnnotations().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
     * for more details such as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    public Builder removeAnnotations(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableAnnotations().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableAnnotations() {
      bitField0_ |= 0x00000008;
      return internalGetMutableAnnotations().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
     * for more details such as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    public Builder putAnnotations(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableAnnotations().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * User annotations. These attributes can only be set and used by the
     * user, and not by Cloud Deploy. See https://google.aip.dev/128#annotations
     * for more details such as format and size limitations.
     * </pre>
     *
     * <code>map&lt;string, string&gt; annotations = 4;</code>
     */
    public Builder putAllAnnotations(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableAnnotations().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000010;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels are attributes that can be set and used by both the
     * user and by Cloud Deploy. Labels must meet the following constraints:
     *
     * * Keys and values can contain only lowercase letters, numeric characters,
     * underscores, and dashes.
     * * All characters must use UTF-8 encoding, and international characters are
     * allowed.
     * * Keys must start with a lowercase letter or international character.
     * * Each resource is limited to a maximum of 64 labels.
     *
     * Both keys and values are additionally constrained to be &lt;= 128 bytes.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 5;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private boolean abandoned_;
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether this is an abandoned release.
     * </pre>
     *
     * <code>bool abandoned = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The abandoned.
     */
    @java.lang.Override
    public boolean getAbandoned() {
      return abandoned_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether this is an abandoned release.
     * </pre>
     *
     * <code>bool abandoned = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The abandoned to set.
     * @return This builder for chaining.
     */
    public Builder setAbandoned(boolean value) {

      abandoned_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether this is an abandoned release.
     * </pre>
     *
     * <code>bool abandoned = 23 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAbandoned() {
      bitField0_ = (bitField0_ & ~0x00000020);
      abandoned_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Release` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Release` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Release` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Release` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Release` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Release` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Release` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Release` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the `Release` was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp renderStartTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        renderStartTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the render began.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp render_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the renderStartTime field is set.
     */
    public boolean hasRenderStartTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the render began.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp render_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The renderStartTime.
     */
    public com.google.protobuf.Timestamp getRenderStartTime() {
      if (renderStartTimeBuilder_ == null) {
        return renderStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : renderStartTime_;
      } else {
        return renderStartTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the render began.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp render_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRenderStartTime(com.google.protobuf.Timestamp value) {
      if (renderStartTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        renderStartTime_ = value;
      } else {
        renderStartTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the render began.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp render_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRenderStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (renderStartTimeBuilder_ == null) {
        renderStartTime_ = builderForValue.build();
      } else {
        renderStartTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the render began.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp render_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRenderStartTime(com.google.protobuf.Timestamp value) {
      if (renderStartTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && renderStartTime_ != null
            && renderStartTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getRenderStartTimeBuilder().mergeFrom(value);
        } else {
          renderStartTime_ = value;
        }
      } else {
        renderStartTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the render began.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp render_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRenderStartTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      renderStartTime_ = null;
      if (renderStartTimeBuilder_ != null) {
        renderStartTimeBuilder_.dispose();
        renderStartTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the render began.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp render_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getRenderStartTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getRenderStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the render began.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp render_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getRenderStartTimeOrBuilder() {
      if (renderStartTimeBuilder_ != null) {
        return renderStartTimeBuilder_.getMessageOrBuilder();
      } else {
        return renderStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : renderStartTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the render began.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp render_start_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getRenderStartTimeFieldBuilder() {
      if (renderStartTimeBuilder_ == null) {
        renderStartTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getRenderStartTime(), getParentForChildren(), isClean());
        renderStartTime_ = null;
      }
      return renderStartTimeBuilder_;
    }

    private com.google.protobuf.Timestamp renderEndTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        renderEndTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the render completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp render_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the renderEndTime field is set.
     */
    public boolean hasRenderEndTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the render completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp render_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The renderEndTime.
     */
    public com.google.protobuf.Timestamp getRenderEndTime() {
      if (renderEndTimeBuilder_ == null) {
        return renderEndTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : renderEndTime_;
      } else {
        return renderEndTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the render completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp render_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRenderEndTime(com.google.protobuf.Timestamp value) {
      if (renderEndTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        renderEndTime_ = value;
      } else {
        renderEndTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the render completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp render_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRenderEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (renderEndTimeBuilder_ == null) {
        renderEndTime_ = builderForValue.build();
      } else {
        renderEndTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the render completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp render_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeRenderEndTime(com.google.protobuf.Timestamp value) {
      if (renderEndTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && renderEndTime_ != null
            && renderEndTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getRenderEndTimeBuilder().mergeFrom(value);
        } else {
          renderEndTime_ = value;
        }
      } else {
        renderEndTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the render completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp render_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRenderEndTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      renderEndTime_ = null;
      if (renderEndTimeBuilder_ != null) {
        renderEndTimeBuilder_.dispose();
        renderEndTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the render completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp render_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getRenderEndTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getRenderEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the render completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp render_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getRenderEndTimeOrBuilder() {
      if (renderEndTimeBuilder_ != null) {
        return renderEndTimeBuilder_.getMessageOrBuilder();
      } else {
        return renderEndTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : renderEndTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the render completed.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp render_end_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getRenderEndTimeFieldBuilder() {
      if (renderEndTimeBuilder_ == null) {
        renderEndTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getRenderEndTime(), getParentForChildren(), isClean());
        renderEndTime_ = null;
      }
      return renderEndTimeBuilder_;
    }

    private java.lang.Object skaffoldConfigUri_ = "";
    /**
     *
     *
     * <pre>
     * Cloud Storage URI of tar.gz archive containing Skaffold configuration.
     * </pre>
     *
     * <code>string skaffold_config_uri = 17;</code>
     *
     * @return The skaffoldConfigUri.
     */
    public java.lang.String getSkaffoldConfigUri() {
      java.lang.Object ref = skaffoldConfigUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        skaffoldConfigUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage URI of tar.gz archive containing Skaffold configuration.
     * </pre>
     *
     * <code>string skaffold_config_uri = 17;</code>
     *
     * @return The bytes for skaffoldConfigUri.
     */
    public com.google.protobuf.ByteString getSkaffoldConfigUriBytes() {
      java.lang.Object ref = skaffoldConfigUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        skaffoldConfigUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage URI of tar.gz archive containing Skaffold configuration.
     * </pre>
     *
     * <code>string skaffold_config_uri = 17;</code>
     *
     * @param value The skaffoldConfigUri to set.
     * @return This builder for chaining.
     */
    public Builder setSkaffoldConfigUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      skaffoldConfigUri_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage URI of tar.gz archive containing Skaffold configuration.
     * </pre>
     *
     * <code>string skaffold_config_uri = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSkaffoldConfigUri() {
      skaffoldConfigUri_ = getDefaultInstance().getSkaffoldConfigUri();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cloud Storage URI of tar.gz archive containing Skaffold configuration.
     * </pre>
     *
     * <code>string skaffold_config_uri = 17;</code>
     *
     * @param value The bytes for skaffoldConfigUri to set.
     * @return This builder for chaining.
     */
    public Builder setSkaffoldConfigUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      skaffoldConfigUri_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object skaffoldConfigPath_ = "";
    /**
     *
     *
     * <pre>
     * Filepath of the Skaffold config inside of the config URI.
     * </pre>
     *
     * <code>string skaffold_config_path = 9;</code>
     *
     * @return The skaffoldConfigPath.
     */
    public java.lang.String getSkaffoldConfigPath() {
      java.lang.Object ref = skaffoldConfigPath_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        skaffoldConfigPath_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Filepath of the Skaffold config inside of the config URI.
     * </pre>
     *
     * <code>string skaffold_config_path = 9;</code>
     *
     * @return The bytes for skaffoldConfigPath.
     */
    public com.google.protobuf.ByteString getSkaffoldConfigPathBytes() {
      java.lang.Object ref = skaffoldConfigPath_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        skaffoldConfigPath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Filepath of the Skaffold config inside of the config URI.
     * </pre>
     *
     * <code>string skaffold_config_path = 9;</code>
     *
     * @param value The skaffoldConfigPath to set.
     * @return This builder for chaining.
     */
    public Builder setSkaffoldConfigPath(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      skaffoldConfigPath_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filepath of the Skaffold config inside of the config URI.
     * </pre>
     *
     * <code>string skaffold_config_path = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSkaffoldConfigPath() {
      skaffoldConfigPath_ = getDefaultInstance().getSkaffoldConfigPath();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Filepath of the Skaffold config inside of the config URI.
     * </pre>
     *
     * <code>string skaffold_config_path = 9;</code>
     *
     * @param value The bytes for skaffoldConfigPath to set.
     * @return This builder for chaining.
     */
    public Builder setSkaffoldConfigPathBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      skaffoldConfigPath_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.deploy.v1.BuildArtifact> buildArtifacts_ =
        java.util.Collections.emptyList();

    private void ensureBuildArtifactsIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        buildArtifacts_ =
            new java.util.ArrayList<com.google.cloud.deploy.v1.BuildArtifact>(buildArtifacts_);
        bitField0_ |= 0x00000800;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.BuildArtifact,
            com.google.cloud.deploy.v1.BuildArtifact.Builder,
            com.google.cloud.deploy.v1.BuildArtifactOrBuilder>
        buildArtifactsBuilder_;

    /**
     *
     *
     * <pre>
     * List of artifacts to pass through to Skaffold command.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
     */
    public java.util.List<com.google.cloud.deploy.v1.BuildArtifact> getBuildArtifactsList() {
      if (buildArtifactsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(buildArtifacts_);
      } else {
        return buildArtifactsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * List of artifacts to pass through to Skaffold command.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
     */
    public int getBuildArtifactsCount() {
      if (buildArtifactsBuilder_ == null) {
        return buildArtifacts_.size();
      } else {
        return buildArtifactsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * List of artifacts to pass through to Skaffold command.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
     */
    public com.google.cloud.deploy.v1.BuildArtifact getBuildArtifacts(int index) {
      if (buildArtifactsBuilder_ == null) {
        return buildArtifacts_.get(index);
      } else {
        return buildArtifactsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of artifacts to pass through to Skaffold command.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
     */
    public Builder setBuildArtifacts(int index, com.google.cloud.deploy.v1.BuildArtifact value) {
      if (buildArtifactsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBuildArtifactsIsMutable();
        buildArtifacts_.set(index, value);
        onChanged();
      } else {
        buildArtifactsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of artifacts to pass through to Skaffold command.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
     */
    public Builder setBuildArtifacts(
        int index, com.google.cloud.deploy.v1.BuildArtifact.Builder builderForValue) {
      if (buildArtifactsBuilder_ == null) {
        ensureBuildArtifactsIsMutable();
        buildArtifacts_.set(index, builderForValue.build());
        onChanged();
      } else {
        buildArtifactsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of artifacts to pass through to Skaffold command.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
     */
    public Builder addBuildArtifacts(com.google.cloud.deploy.v1.BuildArtifact value) {
      if (buildArtifactsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBuildArtifactsIsMutable();
        buildArtifacts_.add(value);
        onChanged();
      } else {
        buildArtifactsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of artifacts to pass through to Skaffold command.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
     */
    public Builder addBuildArtifacts(int index, com.google.cloud.deploy.v1.BuildArtifact value) {
      if (buildArtifactsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureBuildArtifactsIsMutable();
        buildArtifacts_.add(index, value);
        onChanged();
      } else {
        buildArtifactsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of artifacts to pass through to Skaffold command.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
     */
    public Builder addBuildArtifacts(
        com.google.cloud.deploy.v1.BuildArtifact.Builder builderForValue) {
      if (buildArtifactsBuilder_ == null) {
        ensureBuildArtifactsIsMutable();
        buildArtifacts_.add(builderForValue.build());
        onChanged();
      } else {
        buildArtifactsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of artifacts to pass through to Skaffold command.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
     */
    public Builder addBuildArtifacts(
        int index, com.google.cloud.deploy.v1.BuildArtifact.Builder builderForValue) {
      if (buildArtifactsBuilder_ == null) {
        ensureBuildArtifactsIsMutable();
        buildArtifacts_.add(index, builderForValue.build());
        onChanged();
      } else {
        buildArtifactsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of artifacts to pass through to Skaffold command.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
     */
    public Builder addAllBuildArtifacts(
        java.lang.Iterable<? extends com.google.cloud.deploy.v1.BuildArtifact> values) {
      if (buildArtifactsBuilder_ == null) {
        ensureBuildArtifactsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, buildArtifacts_);
        onChanged();
      } else {
        buildArtifactsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of artifacts to pass through to Skaffold command.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
     */
    public Builder clearBuildArtifacts() {
      if (buildArtifactsBuilder_ == null) {
        buildArtifacts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        buildArtifactsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of artifacts to pass through to Skaffold command.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
     */
    public Builder removeBuildArtifacts(int index) {
      if (buildArtifactsBuilder_ == null) {
        ensureBuildArtifactsIsMutable();
        buildArtifacts_.remove(index);
        onChanged();
      } else {
        buildArtifactsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * List of artifacts to pass through to Skaffold command.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
     */
    public com.google.cloud.deploy.v1.BuildArtifact.Builder getBuildArtifactsBuilder(int index) {
      return getBuildArtifactsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * List of artifacts to pass through to Skaffold command.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
     */
    public com.google.cloud.deploy.v1.BuildArtifactOrBuilder getBuildArtifactsOrBuilder(int index) {
      if (buildArtifactsBuilder_ == null) {
        return buildArtifacts_.get(index);
      } else {
        return buildArtifactsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * List of artifacts to pass through to Skaffold command.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
     */
    public java.util.List<? extends com.google.cloud.deploy.v1.BuildArtifactOrBuilder>
        getBuildArtifactsOrBuilderList() {
      if (buildArtifactsBuilder_ != null) {
        return buildArtifactsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(buildArtifacts_);
      }
    }
    /**
     *
     *
     * <pre>
     * List of artifacts to pass through to Skaffold command.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
     */
    public com.google.cloud.deploy.v1.BuildArtifact.Builder addBuildArtifactsBuilder() {
      return getBuildArtifactsFieldBuilder()
          .addBuilder(com.google.cloud.deploy.v1.BuildArtifact.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of artifacts to pass through to Skaffold command.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
     */
    public com.google.cloud.deploy.v1.BuildArtifact.Builder addBuildArtifactsBuilder(int index) {
      return getBuildArtifactsFieldBuilder()
          .addBuilder(index, com.google.cloud.deploy.v1.BuildArtifact.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * List of artifacts to pass through to Skaffold command.
     * </pre>
     *
     * <code>repeated .google.cloud.deploy.v1.BuildArtifact build_artifacts = 10;</code>
     */
    public java.util.List<com.google.cloud.deploy.v1.BuildArtifact.Builder>
        getBuildArtifactsBuilderList() {
      return getBuildArtifactsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.BuildArtifact,
            com.google.cloud.deploy.v1.BuildArtifact.Builder,
            com.google.cloud.deploy.v1.BuildArtifactOrBuilder>
        getBuildArtifactsFieldBuilder() {
      if (buildArtifactsBuilder_ == null) {
        buildArtifactsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.deploy.v1.BuildArtifact,
                com.google.cloud.deploy.v1.BuildArtifact.Builder,
                com.google.cloud.deploy.v1.BuildArtifactOrBuilder>(
                buildArtifacts_,
                ((bitField0_ & 0x00000800) != 0),
                getParentForChildren(),
                isClean());
        buildArtifacts_ = null;
      }
      return buildArtifactsBuilder_;
    }

    private com.google.cloud.deploy.v1.DeliveryPipeline deliveryPipelineSnapshot_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.DeliveryPipeline,
            com.google.cloud.deploy.v1.DeliveryPipeline.Builder,
            com.google.cloud.deploy.v1.DeliveryPipelineOrBuilder>
        deliveryPipelineSnapshotBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the parent pipeline taken at release creation
     * time.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeliveryPipeline delivery_pipeline_snapshot = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the deliveryPipelineSnapshot field is set.
     */
    public boolean hasDeliveryPipelineSnapshot() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the parent pipeline taken at release creation
     * time.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeliveryPipeline delivery_pipeline_snapshot = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The deliveryPipelineSnapshot.
     */
    public com.google.cloud.deploy.v1.DeliveryPipeline getDeliveryPipelineSnapshot() {
      if (deliveryPipelineSnapshotBuilder_ == null) {
        return deliveryPipelineSnapshot_ == null
            ? com.google.cloud.deploy.v1.DeliveryPipeline.getDefaultInstance()
            : deliveryPipelineSnapshot_;
      } else {
        return deliveryPipelineSnapshotBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the parent pipeline taken at release creation
     * time.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeliveryPipeline delivery_pipeline_snapshot = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeliveryPipelineSnapshot(com.google.cloud.deploy.v1.DeliveryPipeline value) {
      if (deliveryPipelineSnapshotBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deliveryPipelineSnapshot_ = value;
      } else {
        deliveryPipelineSnapshotBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the parent pipeline taken at release creation
     * time.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeliveryPipeline delivery_pipeline_snapshot = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDeliveryPipelineSnapshot(
        com.google.cloud.deploy.v1.DeliveryPipeline.Builder builderForValue) {
      if (deliveryPipelineSnapshotBuilder_ == null) {
        deliveryPipelineSnapshot_ = builderForValue.build();
      } else {
        deliveryPipelineSnapshotBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the parent pipeline taken at release creation
     * time.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeliveryPipeline delivery_pipeline_snapshot = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDeliveryPipelineSnapshot(
        com.google.cloud.deploy.v1.DeliveryPipeline value) {
      if (deliveryPipelineSnapshotBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && deliveryPipelineSnapshot_ != null
            && deliveryPipelineSnapshot_
                != com.google.cloud.deploy.v1.DeliveryPipeline.getDefaultInstance()) {
          getDeliveryPipelineSnapshotBuilder().mergeFrom(value);
        } else {
          deliveryPipelineSnapshot_ = value;
        }
      } else {
        deliveryPipelineSnapshotBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the parent pipeline taken at release creation
     * time.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeliveryPipeline delivery_pipeline_snapshot = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDeliveryPipelineSnapshot() {
      bitField0_ = (bitField0_ & ~0x00001000);
      deliveryPipelineSnapshot_ = null;
      if (deliveryPipelineSnapshotBuilder_ != null) {
        deliveryPipelineSnapshotBuilder_.dispose();
        deliveryPipelineSnapshotBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the parent pipeline taken at release creation
     * time.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeliveryPipeline delivery_pipeline_snapshot = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeliveryPipeline.Builder
        getDeliveryPipelineSnapshotBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getDeliveryPipelineSnapshotFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the parent pipeline taken at release creation
     * time.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeliveryPipeline delivery_pipeline_snapshot = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.DeliveryPipelineOrBuilder
        getDeliveryPipelineSnapshotOrBuilder() {
      if (deliveryPipelineSnapshotBuilder_ != null) {
        return deliveryPipelineSnapshotBuilder_.getMessageOrBuilder();
      } else {
        return deliveryPipelineSnapshot_ == null
            ? com.google.cloud.deploy.v1.DeliveryPipeline.getDefaultInstance()
            : deliveryPipelineSnapshot_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the parent pipeline taken at release creation
     * time.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.DeliveryPipeline delivery_pipeline_snapshot = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.DeliveryPipeline,
            com.google.cloud.deploy.v1.DeliveryPipeline.Builder,
            com.google.cloud.deploy.v1.DeliveryPipelineOrBuilder>
        getDeliveryPipelineSnapshotFieldBuilder() {
      if (deliveryPipelineSnapshotBuilder_ == null) {
        deliveryPipelineSnapshotBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.DeliveryPipeline,
                com.google.cloud.deploy.v1.DeliveryPipeline.Builder,
                com.google.cloud.deploy.v1.DeliveryPipelineOrBuilder>(
                getDeliveryPipelineSnapshot(), getParentForChildren(), isClean());
        deliveryPipelineSnapshot_ = null;
      }
      return deliveryPipelineSnapshotBuilder_;
    }

    private java.util.List<com.google.cloud.deploy.v1.Target> targetSnapshots_ =
        java.util.Collections.emptyList();

    private void ensureTargetSnapshotsIsMutable() {
      if (!((bitField0_ & 0x00002000) != 0)) {
        targetSnapshots_ =
            new java.util.ArrayList<com.google.cloud.deploy.v1.Target>(targetSnapshots_);
        bitField0_ |= 0x00002000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.Target,
            com.google.cloud.deploy.v1.Target.Builder,
            com.google.cloud.deploy.v1.TargetOrBuilder>
        targetSnapshotsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the targets taken at release creation time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.Target> getTargetSnapshotsList() {
      if (targetSnapshotsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(targetSnapshots_);
      } else {
        return targetSnapshotsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the targets taken at release creation time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getTargetSnapshotsCount() {
      if (targetSnapshotsBuilder_ == null) {
        return targetSnapshots_.size();
      } else {
        return targetSnapshotsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the targets taken at release creation time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.Target getTargetSnapshots(int index) {
      if (targetSnapshotsBuilder_ == null) {
        return targetSnapshots_.get(index);
      } else {
        return targetSnapshotsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the targets taken at release creation time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTargetSnapshots(int index, com.google.cloud.deploy.v1.Target value) {
      if (targetSnapshotsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTargetSnapshotsIsMutable();
        targetSnapshots_.set(index, value);
        onChanged();
      } else {
        targetSnapshotsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the targets taken at release creation time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setTargetSnapshots(
        int index, com.google.cloud.deploy.v1.Target.Builder builderForValue) {
      if (targetSnapshotsBuilder_ == null) {
        ensureTargetSnapshotsIsMutable();
        targetSnapshots_.set(index, builderForValue.build());
        onChanged();
      } else {
        targetSnapshotsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the targets taken at release creation time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTargetSnapshots(com.google.cloud.deploy.v1.Target value) {
      if (targetSnapshotsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTargetSnapshotsIsMutable();
        targetSnapshots_.add(value);
        onChanged();
      } else {
        targetSnapshotsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the targets taken at release creation time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTargetSnapshots(int index, com.google.cloud.deploy.v1.Target value) {
      if (targetSnapshotsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTargetSnapshotsIsMutable();
        targetSnapshots_.add(index, value);
        onChanged();
      } else {
        targetSnapshotsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the targets taken at release creation time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTargetSnapshots(com.google.cloud.deploy.v1.Target.Builder builderForValue) {
      if (targetSnapshotsBuilder_ == null) {
        ensureTargetSnapshotsIsMutable();
        targetSnapshots_.add(builderForValue.build());
        onChanged();
      } else {
        targetSnapshotsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the targets taken at release creation time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addTargetSnapshots(
        int index, com.google.cloud.deploy.v1.Target.Builder builderForValue) {
      if (targetSnapshotsBuilder_ == null) {
        ensureTargetSnapshotsIsMutable();
        targetSnapshots_.add(index, builderForValue.build());
        onChanged();
      } else {
        targetSnapshotsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the targets taken at release creation time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllTargetSnapshots(
        java.lang.Iterable<? extends com.google.cloud.deploy.v1.Target> values) {
      if (targetSnapshotsBuilder_ == null) {
        ensureTargetSnapshotsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, targetSnapshots_);
        onChanged();
      } else {
        targetSnapshotsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the targets taken at release creation time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearTargetSnapshots() {
      if (targetSnapshotsBuilder_ == null) {
        targetSnapshots_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00002000);
        onChanged();
      } else {
        targetSnapshotsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the targets taken at release creation time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeTargetSnapshots(int index) {
      if (targetSnapshotsBuilder_ == null) {
        ensureTargetSnapshotsIsMutable();
        targetSnapshots_.remove(index);
        onChanged();
      } else {
        targetSnapshotsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the targets taken at release creation time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.Target.Builder getTargetSnapshotsBuilder(int index) {
      return getTargetSnapshotsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the targets taken at release creation time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.TargetOrBuilder getTargetSnapshotsOrBuilder(int index) {
      if (targetSnapshotsBuilder_ == null) {
        return targetSnapshots_.get(index);
      } else {
        return targetSnapshotsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the targets taken at release creation time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.deploy.v1.TargetOrBuilder>
        getTargetSnapshotsOrBuilderList() {
      if (targetSnapshotsBuilder_ != null) {
        return targetSnapshotsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(targetSnapshots_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the targets taken at release creation time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.Target.Builder addTargetSnapshotsBuilder() {
      return getTargetSnapshotsFieldBuilder()
          .addBuilder(com.google.cloud.deploy.v1.Target.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the targets taken at release creation time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.Target.Builder addTargetSnapshotsBuilder(int index) {
      return getTargetSnapshotsFieldBuilder()
          .addBuilder(index, com.google.cloud.deploy.v1.Target.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Snapshot of the targets taken at release creation time.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.Target target_snapshots = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.Target.Builder>
        getTargetSnapshotsBuilderList() {
      return getTargetSnapshotsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.Target,
            com.google.cloud.deploy.v1.Target.Builder,
            com.google.cloud.deploy.v1.TargetOrBuilder>
        getTargetSnapshotsFieldBuilder() {
      if (targetSnapshotsBuilder_ == null) {
        targetSnapshotsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.deploy.v1.Target,
                com.google.cloud.deploy.v1.Target.Builder,
                com.google.cloud.deploy.v1.TargetOrBuilder>(
                targetSnapshots_,
                ((bitField0_ & 0x00002000) != 0),
                getParentForChildren(),
                isClean());
        targetSnapshots_ = null;
      }
      return targetSnapshotsBuilder_;
    }

    private int renderState_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Current state of the render operation.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.RenderState render_state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for renderState.
     */
    @java.lang.Override
    public int getRenderStateValue() {
      return renderState_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the render operation.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.RenderState render_state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for renderState to set.
     * @return This builder for chaining.
     */
    public Builder setRenderStateValue(int value) {
      renderState_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the render operation.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.RenderState render_state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The renderState.
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.Release.RenderState getRenderState() {
      com.google.cloud.deploy.v1.Release.RenderState result =
          com.google.cloud.deploy.v1.Release.RenderState.forNumber(renderState_);
      return result == null ? com.google.cloud.deploy.v1.Release.RenderState.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the render operation.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.RenderState render_state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The renderState to set.
     * @return This builder for chaining.
     */
    public Builder setRenderState(com.google.cloud.deploy.v1.Release.RenderState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00004000;
      renderState_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Current state of the render operation.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.RenderState render_state = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRenderState() {
      bitField0_ = (bitField0_ & ~0x00004000);
      renderState_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 16;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 16;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 16;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This checksum is computed by the server based on the value of other
     * fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     * </pre>
     *
     * <code>string etag = 16;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private java.lang.Object skaffoldVersion_ = "";
    /**
     *
     *
     * <pre>
     * The Skaffold version to use when operating on this release, such as
     * "1.20.0". Not all versions are valid; Cloud Deploy supports a specific set
     * of versions.
     *
     * If unset, the most recent supported Skaffold version will be used.
     * </pre>
     *
     * <code>string skaffold_version = 19;</code>
     *
     * @return The skaffoldVersion.
     */
    public java.lang.String getSkaffoldVersion() {
      java.lang.Object ref = skaffoldVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        skaffoldVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Skaffold version to use when operating on this release, such as
     * "1.20.0". Not all versions are valid; Cloud Deploy supports a specific set
     * of versions.
     *
     * If unset, the most recent supported Skaffold version will be used.
     * </pre>
     *
     * <code>string skaffold_version = 19;</code>
     *
     * @return The bytes for skaffoldVersion.
     */
    public com.google.protobuf.ByteString getSkaffoldVersionBytes() {
      java.lang.Object ref = skaffoldVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        skaffoldVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Skaffold version to use when operating on this release, such as
     * "1.20.0". Not all versions are valid; Cloud Deploy supports a specific set
     * of versions.
     *
     * If unset, the most recent supported Skaffold version will be used.
     * </pre>
     *
     * <code>string skaffold_version = 19;</code>
     *
     * @param value The skaffoldVersion to set.
     * @return This builder for chaining.
     */
    public Builder setSkaffoldVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      skaffoldVersion_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Skaffold version to use when operating on this release, such as
     * "1.20.0". Not all versions are valid; Cloud Deploy supports a specific set
     * of versions.
     *
     * If unset, the most recent supported Skaffold version will be used.
     * </pre>
     *
     * <code>string skaffold_version = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSkaffoldVersion() {
      skaffoldVersion_ = getDefaultInstance().getSkaffoldVersion();
      bitField0_ = (bitField0_ & ~0x00010000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Skaffold version to use when operating on this release, such as
     * "1.20.0". Not all versions are valid; Cloud Deploy supports a specific set
     * of versions.
     *
     * If unset, the most recent supported Skaffold version will be used.
     * </pre>
     *
     * <code>string skaffold_version = 19;</code>
     *
     * @param value The bytes for skaffoldVersion to set.
     * @return This builder for chaining.
     */
    public Builder setSkaffoldVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      skaffoldVersion_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.deploy.v1.TargetArtifact>
        targetArtifacts_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.deploy.v1.TargetArtifact>
        internalGetTargetArtifacts() {
      if (targetArtifacts_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            TargetArtifactsDefaultEntryHolder.defaultEntry);
      }
      return targetArtifacts_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.deploy.v1.TargetArtifact>
        internalGetMutableTargetArtifacts() {
      if (targetArtifacts_ == null) {
        targetArtifacts_ =
            com.google.protobuf.MapField.newMapField(
                TargetArtifactsDefaultEntryHolder.defaultEntry);
      }
      if (!targetArtifacts_.isMutable()) {
        targetArtifacts_ = targetArtifacts_.copy();
      }
      bitField0_ |= 0x00020000;
      onChanged();
      return targetArtifacts_;
    }

    public int getTargetArtifactsCount() {
      return internalGetTargetArtifacts().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from target ID to the target artifacts created
     * during the render operation.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.TargetArtifact&gt; target_artifacts = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsTargetArtifacts(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetTargetArtifacts().getMap().containsKey(key);
    }
    /** Use {@link #getTargetArtifactsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.deploy.v1.TargetArtifact>
        getTargetArtifacts() {
      return getTargetArtifactsMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from target ID to the target artifacts created
     * during the render operation.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.TargetArtifact&gt; target_artifacts = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.deploy.v1.TargetArtifact>
        getTargetArtifactsMap() {
      return internalGetTargetArtifacts().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from target ID to the target artifacts created
     * during the render operation.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.TargetArtifact&gt; target_artifacts = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.deploy.v1.TargetArtifact getTargetArtifactsOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.deploy.v1.TargetArtifact defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.deploy.v1.TargetArtifact> map =
          internalGetTargetArtifacts().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from target ID to the target artifacts created
     * during the render operation.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.TargetArtifact&gt; target_artifacts = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.TargetArtifact getTargetArtifactsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.deploy.v1.TargetArtifact> map =
          internalGetTargetArtifacts().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearTargetArtifacts() {
      bitField0_ = (bitField0_ & ~0x00020000);
      internalGetMutableTargetArtifacts().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from target ID to the target artifacts created
     * during the render operation.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.TargetArtifact&gt; target_artifacts = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeTargetArtifacts(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableTargetArtifacts().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.deploy.v1.TargetArtifact>
        getMutableTargetArtifacts() {
      bitField0_ |= 0x00020000;
      return internalGetMutableTargetArtifacts().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from target ID to the target artifacts created
     * during the render operation.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.TargetArtifact&gt; target_artifacts = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putTargetArtifacts(
        java.lang.String key, com.google.cloud.deploy.v1.TargetArtifact value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableTargetArtifacts().getMutableMap().put(key, value);
      bitField0_ |= 0x00020000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from target ID to the target artifacts created
     * during the render operation.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.TargetArtifact&gt; target_artifacts = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllTargetArtifacts(
        java.util.Map<java.lang.String, com.google.cloud.deploy.v1.TargetArtifact> values) {
      internalGetMutableTargetArtifacts().getMutableMap().putAll(values);
      bitField0_ |= 0x00020000;
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.deploy.v1.Release.TargetRender>
        targetRenders_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.deploy.v1.Release.TargetRender>
        internalGetTargetRenders() {
      if (targetRenders_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            TargetRendersDefaultEntryHolder.defaultEntry);
      }
      return targetRenders_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.deploy.v1.Release.TargetRender>
        internalGetMutableTargetRenders() {
      if (targetRenders_ == null) {
        targetRenders_ =
            com.google.protobuf.MapField.newMapField(TargetRendersDefaultEntryHolder.defaultEntry);
      }
      if (!targetRenders_.isMutable()) {
        targetRenders_ = targetRenders_.copy();
      }
      bitField0_ |= 0x00040000;
      onChanged();
      return targetRenders_;
    }

    public int getTargetRendersCount() {
      return internalGetTargetRenders().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from target ID to details of the render operation for that
     * target.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.Release.TargetRender&gt; target_renders = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public boolean containsTargetRenders(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetTargetRenders().getMap().containsKey(key);
    }
    /** Use {@link #getTargetRendersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.deploy.v1.Release.TargetRender>
        getTargetRenders() {
      return getTargetRendersMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from target ID to details of the render operation for that
     * target.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.Release.TargetRender&gt; target_renders = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.deploy.v1.Release.TargetRender>
        getTargetRendersMap() {
      return internalGetTargetRenders().getMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from target ID to details of the render operation for that
     * target.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.Release.TargetRender&gt; target_renders = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.deploy.v1.Release.TargetRender getTargetRendersOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.deploy.v1.Release.TargetRender defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.deploy.v1.Release.TargetRender> map =
          internalGetTargetRenders().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from target ID to details of the render operation for that
     * target.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.Release.TargetRender&gt; target_renders = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.deploy.v1.Release.TargetRender getTargetRendersOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.deploy.v1.Release.TargetRender> map =
          internalGetTargetRenders().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearTargetRenders() {
      bitField0_ = (bitField0_ & ~0x00040000);
      internalGetMutableTargetRenders().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from target ID to details of the render operation for that
     * target.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.Release.TargetRender&gt; target_renders = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeTargetRenders(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableTargetRenders().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.deploy.v1.Release.TargetRender>
        getMutableTargetRenders() {
      bitField0_ |= 0x00040000;
      return internalGetMutableTargetRenders().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from target ID to details of the render operation for that
     * target.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.Release.TargetRender&gt; target_renders = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putTargetRenders(
        java.lang.String key, com.google.cloud.deploy.v1.Release.TargetRender value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableTargetRenders().getMutableMap().put(key, value);
      bitField0_ |= 0x00040000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Map from target ID to details of the render operation for that
     * target.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.deploy.v1.Release.TargetRender&gt; target_renders = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder putAllTargetRenders(
        java.util.Map<java.lang.String, com.google.cloud.deploy.v1.Release.TargetRender> values) {
      internalGetMutableTargetRenders().getMutableMap().putAll(values);
      bitField0_ |= 0x00040000;
      return this;
    }

    private com.google.cloud.deploy.v1.Release.ReleaseCondition condition_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.Release.ReleaseCondition,
            com.google.cloud.deploy.v1.Release.ReleaseCondition.Builder,
            com.google.cloud.deploy.v1.Release.ReleaseConditionOrBuilder>
        conditionBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Release.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.ReleaseCondition condition = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the condition field is set.
     */
    public boolean hasCondition() {
      return ((bitField0_ & 0x00080000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Release.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.ReleaseCondition condition = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The condition.
     */
    public com.google.cloud.deploy.v1.Release.ReleaseCondition getCondition() {
      if (conditionBuilder_ == null) {
        return condition_ == null
            ? com.google.cloud.deploy.v1.Release.ReleaseCondition.getDefaultInstance()
            : condition_;
      } else {
        return conditionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Release.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.ReleaseCondition condition = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCondition(com.google.cloud.deploy.v1.Release.ReleaseCondition value) {
      if (conditionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        condition_ = value;
      } else {
        conditionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Release.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.ReleaseCondition condition = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCondition(
        com.google.cloud.deploy.v1.Release.ReleaseCondition.Builder builderForValue) {
      if (conditionBuilder_ == null) {
        condition_ = builderForValue.build();
      } else {
        conditionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Release.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.ReleaseCondition condition = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCondition(com.google.cloud.deploy.v1.Release.ReleaseCondition value) {
      if (conditionBuilder_ == null) {
        if (((bitField0_ & 0x00080000) != 0)
            && condition_ != null
            && condition_
                != com.google.cloud.deploy.v1.Release.ReleaseCondition.getDefaultInstance()) {
          getConditionBuilder().mergeFrom(value);
        } else {
          condition_ = value;
        }
      } else {
        conditionBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Release.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.ReleaseCondition condition = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCondition() {
      bitField0_ = (bitField0_ & ~0x00080000);
      condition_ = null;
      if (conditionBuilder_ != null) {
        conditionBuilder_.dispose();
        conditionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Release.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.ReleaseCondition condition = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.Release.ReleaseCondition.Builder getConditionBuilder() {
      bitField0_ |= 0x00080000;
      onChanged();
      return getConditionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Release.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.ReleaseCondition condition = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.Release.ReleaseConditionOrBuilder getConditionOrBuilder() {
      if (conditionBuilder_ != null) {
        return conditionBuilder_.getMessageOrBuilder();
      } else {
        return condition_ == null
            ? com.google.cloud.deploy.v1.Release.ReleaseCondition.getDefaultInstance()
            : condition_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the Release.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.Release.ReleaseCondition condition = 24 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.Release.ReleaseCondition,
            com.google.cloud.deploy.v1.Release.ReleaseCondition.Builder,
            com.google.cloud.deploy.v1.Release.ReleaseConditionOrBuilder>
        getConditionFieldBuilder() {
      if (conditionBuilder_ == null) {
        conditionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.Release.ReleaseCondition,
                com.google.cloud.deploy.v1.Release.ReleaseCondition.Builder,
                com.google.cloud.deploy.v1.Release.ReleaseConditionOrBuilder>(
                getCondition(), getParentForChildren(), isClean());
        condition_ = null;
      }
      return conditionBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> deployParameters_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetDeployParameters() {
      if (deployParameters_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            DeployParametersDefaultEntryHolder.defaultEntry);
      }
      return deployParameters_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableDeployParameters() {
      if (deployParameters_ == null) {
        deployParameters_ =
            com.google.protobuf.MapField.newMapField(
                DeployParametersDefaultEntryHolder.defaultEntry);
      }
      if (!deployParameters_.isMutable()) {
        deployParameters_ = deployParameters_.copy();
      }
      bitField0_ |= 0x00100000;
      onChanged();
      return deployParameters_;
    }

    public int getDeployParametersCount() {
      return internalGetDeployParameters().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for all targets in this release.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; deploy_parameters = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsDeployParameters(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetDeployParameters().getMap().containsKey(key);
    }
    /** Use {@link #getDeployParametersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getDeployParameters() {
      return getDeployParametersMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for all targets in this release.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; deploy_parameters = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getDeployParametersMap() {
      return internalGetDeployParameters().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for all targets in this release.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; deploy_parameters = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getDeployParametersOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetDeployParameters().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for all targets in this release.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; deploy_parameters = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getDeployParametersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetDeployParameters().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearDeployParameters() {
      bitField0_ = (bitField0_ & ~0x00100000);
      internalGetMutableDeployParameters().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for all targets in this release.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; deploy_parameters = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeDeployParameters(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableDeployParameters().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableDeployParameters() {
      bitField0_ |= 0x00100000;
      return internalGetMutableDeployParameters().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for all targets in this release.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; deploy_parameters = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putDeployParameters(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableDeployParameters().getMutableMap().put(key, value);
      bitField0_ |= 0x00100000;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The deploy parameters to use for all targets in this release.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; deploy_parameters = 25 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllDeployParameters(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableDeployParameters().getMutableMap().putAll(values);
      bitField0_ |= 0x00100000;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.Release)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.Release)
  private static final com.google.cloud.deploy.v1.Release DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.Release();
  }

  public static com.google.cloud.deploy.v1.Release getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Release> PARSER =
      new com.google.protobuf.AbstractParser<Release>() {
        @java.lang.Override
        public Release parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Release> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Release> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.Release getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
