/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * Contains the information for an automated `repair rollout` operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.RepairRolloutOperation}
 */
public final class RepairRolloutOperation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.RepairRolloutOperation)
    RepairRolloutOperationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RepairRolloutOperation.newBuilder() to construct.
  private RepairRolloutOperation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RepairRolloutOperation() {
    rollout_ = "";
    repairPhases_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RepairRolloutOperation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_RepairRolloutOperation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_RepairRolloutOperation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.RepairRolloutOperation.class,
            com.google.cloud.deploy.v1.RepairRolloutOperation.Builder.class);
  }

  public static final int ROLLOUT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object rollout_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of the rollout that initiates the `AutomationRun`.
   * </pre>
   *
   * <code>string rollout = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The rollout.
   */
  @java.lang.Override
  public java.lang.String getRollout() {
    java.lang.Object ref = rollout_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      rollout_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of the rollout that initiates the `AutomationRun`.
   * </pre>
   *
   * <code>string rollout = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for rollout.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRolloutBytes() {
    java.lang.Object ref = rollout_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      rollout_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CURRENT_REPAIR_MODE_INDEX_FIELD_NUMBER = 2;
  private long currentRepairModeIndex_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The index of the current repair action in the repair sequence.
   * </pre>
   *
   * <code>int64 current_repair_mode_index = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The currentRepairModeIndex.
   */
  @java.lang.Override
  public long getCurrentRepairModeIndex() {
    return currentRepairModeIndex_;
  }

  public static final int REPAIR_PHASES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.deploy.v1.RepairPhase> repairPhases_;
  /**
   *
   *
   * <pre>
   * Output only. Records of the repair attempts. Each repair phase may have
   * multiple retry attempts or single rollback attempt.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.deploy.v1.RepairPhase> getRepairPhasesList() {
    return repairPhases_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Records of the repair attempts. Each repair phase may have
   * multiple retry attempts or single rollback attempt.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.deploy.v1.RepairPhaseOrBuilder>
      getRepairPhasesOrBuilderList() {
    return repairPhases_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Records of the repair attempts. Each repair phase may have
   * multiple retry attempts or single rollback attempt.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getRepairPhasesCount() {
    return repairPhases_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Records of the repair attempts. Each repair phase may have
   * multiple retry attempts or single rollback attempt.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RepairPhase getRepairPhases(int index) {
    return repairPhases_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Records of the repair attempts. Each repair phase may have
   * multiple retry attempts or single rollback attempt.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RepairPhaseOrBuilder getRepairPhasesOrBuilder(int index) {
    return repairPhases_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rollout_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, rollout_);
    }
    if (currentRepairModeIndex_ != 0L) {
      output.writeInt64(2, currentRepairModeIndex_);
    }
    for (int i = 0; i < repairPhases_.size(); i++) {
      output.writeMessage(3, repairPhases_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rollout_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, rollout_);
    }
    if (currentRepairModeIndex_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, currentRepairModeIndex_);
    }
    for (int i = 0; i < repairPhases_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, repairPhases_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.RepairRolloutOperation)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.RepairRolloutOperation other =
        (com.google.cloud.deploy.v1.RepairRolloutOperation) obj;

    if (!getRollout().equals(other.getRollout())) return false;
    if (getCurrentRepairModeIndex() != other.getCurrentRepairModeIndex()) return false;
    if (!getRepairPhasesList().equals(other.getRepairPhasesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ROLLOUT_FIELD_NUMBER;
    hash = (53 * hash) + getRollout().hashCode();
    hash = (37 * hash) + CURRENT_REPAIR_MODE_INDEX_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCurrentRepairModeIndex());
    if (getRepairPhasesCount() > 0) {
      hash = (37 * hash) + REPAIR_PHASES_FIELD_NUMBER;
      hash = (53 * hash) + getRepairPhasesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.RepairRolloutOperation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutOperation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutOperation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutOperation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutOperation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutOperation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutOperation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutOperation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutOperation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutOperation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutOperation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutOperation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.RepairRolloutOperation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Contains the information for an automated `repair rollout` operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.RepairRolloutOperation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.RepairRolloutOperation)
      com.google.cloud.deploy.v1.RepairRolloutOperationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RepairRolloutOperation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RepairRolloutOperation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.RepairRolloutOperation.class,
              com.google.cloud.deploy.v1.RepairRolloutOperation.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.RepairRolloutOperation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      rollout_ = "";
      currentRepairModeIndex_ = 0L;
      if (repairPhasesBuilder_ == null) {
        repairPhases_ = java.util.Collections.emptyList();
      } else {
        repairPhases_ = null;
        repairPhasesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RepairRolloutOperation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RepairRolloutOperation getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.RepairRolloutOperation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RepairRolloutOperation build() {
      com.google.cloud.deploy.v1.RepairRolloutOperation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RepairRolloutOperation buildPartial() {
      com.google.cloud.deploy.v1.RepairRolloutOperation result =
          new com.google.cloud.deploy.v1.RepairRolloutOperation(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.deploy.v1.RepairRolloutOperation result) {
      if (repairPhasesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          repairPhases_ = java.util.Collections.unmodifiableList(repairPhases_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.repairPhases_ = repairPhases_;
      } else {
        result.repairPhases_ = repairPhasesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.deploy.v1.RepairRolloutOperation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.rollout_ = rollout_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.currentRepairModeIndex_ = currentRepairModeIndex_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.RepairRolloutOperation) {
        return mergeFrom((com.google.cloud.deploy.v1.RepairRolloutOperation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.RepairRolloutOperation other) {
      if (other == com.google.cloud.deploy.v1.RepairRolloutOperation.getDefaultInstance())
        return this;
      if (!other.getRollout().isEmpty()) {
        rollout_ = other.rollout_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getCurrentRepairModeIndex() != 0L) {
        setCurrentRepairModeIndex(other.getCurrentRepairModeIndex());
      }
      if (repairPhasesBuilder_ == null) {
        if (!other.repairPhases_.isEmpty()) {
          if (repairPhases_.isEmpty()) {
            repairPhases_ = other.repairPhases_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureRepairPhasesIsMutable();
            repairPhases_.addAll(other.repairPhases_);
          }
          onChanged();
        }
      } else {
        if (!other.repairPhases_.isEmpty()) {
          if (repairPhasesBuilder_.isEmpty()) {
            repairPhasesBuilder_.dispose();
            repairPhasesBuilder_ = null;
            repairPhases_ = other.repairPhases_;
            bitField0_ = (bitField0_ & ~0x00000004);
            repairPhasesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRepairPhasesFieldBuilder()
                    : null;
          } else {
            repairPhasesBuilder_.addAllMessages(other.repairPhases_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                rollout_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                currentRepairModeIndex_ = input.readInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                com.google.cloud.deploy.v1.RepairPhase m =
                    input.readMessage(
                        com.google.cloud.deploy.v1.RepairPhase.parser(), extensionRegistry);
                if (repairPhasesBuilder_ == null) {
                  ensureRepairPhasesIsMutable();
                  repairPhases_.add(m);
                } else {
                  repairPhasesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object rollout_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of the rollout that initiates the `AutomationRun`.
     * </pre>
     *
     * <code>string rollout = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The rollout.
     */
    public java.lang.String getRollout() {
      java.lang.Object ref = rollout_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rollout_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the rollout that initiates the `AutomationRun`.
     * </pre>
     *
     * <code>string rollout = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for rollout.
     */
    public com.google.protobuf.ByteString getRolloutBytes() {
      java.lang.Object ref = rollout_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rollout_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the rollout that initiates the `AutomationRun`.
     * </pre>
     *
     * <code>string rollout = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The rollout to set.
     * @return This builder for chaining.
     */
    public Builder setRollout(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      rollout_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the rollout that initiates the `AutomationRun`.
     * </pre>
     *
     * <code>string rollout = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRollout() {
      rollout_ = getDefaultInstance().getRollout();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the rollout that initiates the `AutomationRun`.
     * </pre>
     *
     * <code>string rollout = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for rollout to set.
     * @return This builder for chaining.
     */
    public Builder setRolloutBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      rollout_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private long currentRepairModeIndex_;
    /**
     *
     *
     * <pre>
     * Output only. The index of the current repair action in the repair sequence.
     * </pre>
     *
     * <code>int64 current_repair_mode_index = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The currentRepairModeIndex.
     */
    @java.lang.Override
    public long getCurrentRepairModeIndex() {
      return currentRepairModeIndex_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The index of the current repair action in the repair sequence.
     * </pre>
     *
     * <code>int64 current_repair_mode_index = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The currentRepairModeIndex to set.
     * @return This builder for chaining.
     */
    public Builder setCurrentRepairModeIndex(long value) {

      currentRepairModeIndex_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The index of the current repair action in the repair sequence.
     * </pre>
     *
     * <code>int64 current_repair_mode_index = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCurrentRepairModeIndex() {
      bitField0_ = (bitField0_ & ~0x00000002);
      currentRepairModeIndex_ = 0L;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.deploy.v1.RepairPhase> repairPhases_ =
        java.util.Collections.emptyList();

    private void ensureRepairPhasesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        repairPhases_ =
            new java.util.ArrayList<com.google.cloud.deploy.v1.RepairPhase>(repairPhases_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.RepairPhase,
            com.google.cloud.deploy.v1.RepairPhase.Builder,
            com.google.cloud.deploy.v1.RepairPhaseOrBuilder>
        repairPhasesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Records of the repair attempts. Each repair phase may have
     * multiple retry attempts or single rollback attempt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.RepairPhase> getRepairPhasesList() {
      if (repairPhasesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(repairPhases_);
      } else {
        return repairPhasesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the repair attempts. Each repair phase may have
     * multiple retry attempts or single rollback attempt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getRepairPhasesCount() {
      if (repairPhasesBuilder_ == null) {
        return repairPhases_.size();
      } else {
        return repairPhasesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the repair attempts. Each repair phase may have
     * multiple retry attempts or single rollback attempt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.RepairPhase getRepairPhases(int index) {
      if (repairPhasesBuilder_ == null) {
        return repairPhases_.get(index);
      } else {
        return repairPhasesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the repair attempts. Each repair phase may have
     * multiple retry attempts or single rollback attempt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRepairPhases(int index, com.google.cloud.deploy.v1.RepairPhase value) {
      if (repairPhasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRepairPhasesIsMutable();
        repairPhases_.set(index, value);
        onChanged();
      } else {
        repairPhasesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the repair attempts. Each repair phase may have
     * multiple retry attempts or single rollback attempt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setRepairPhases(
        int index, com.google.cloud.deploy.v1.RepairPhase.Builder builderForValue) {
      if (repairPhasesBuilder_ == null) {
        ensureRepairPhasesIsMutable();
        repairPhases_.set(index, builderForValue.build());
        onChanged();
      } else {
        repairPhasesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the repair attempts. Each repair phase may have
     * multiple retry attempts or single rollback attempt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addRepairPhases(com.google.cloud.deploy.v1.RepairPhase value) {
      if (repairPhasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRepairPhasesIsMutable();
        repairPhases_.add(value);
        onChanged();
      } else {
        repairPhasesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the repair attempts. Each repair phase may have
     * multiple retry attempts or single rollback attempt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addRepairPhases(int index, com.google.cloud.deploy.v1.RepairPhase value) {
      if (repairPhasesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRepairPhasesIsMutable();
        repairPhases_.add(index, value);
        onChanged();
      } else {
        repairPhasesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the repair attempts. Each repair phase may have
     * multiple retry attempts or single rollback attempt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addRepairPhases(com.google.cloud.deploy.v1.RepairPhase.Builder builderForValue) {
      if (repairPhasesBuilder_ == null) {
        ensureRepairPhasesIsMutable();
        repairPhases_.add(builderForValue.build());
        onChanged();
      } else {
        repairPhasesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the repair attempts. Each repair phase may have
     * multiple retry attempts or single rollback attempt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addRepairPhases(
        int index, com.google.cloud.deploy.v1.RepairPhase.Builder builderForValue) {
      if (repairPhasesBuilder_ == null) {
        ensureRepairPhasesIsMutable();
        repairPhases_.add(index, builderForValue.build());
        onChanged();
      } else {
        repairPhasesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the repair attempts. Each repair phase may have
     * multiple retry attempts or single rollback attempt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllRepairPhases(
        java.lang.Iterable<? extends com.google.cloud.deploy.v1.RepairPhase> values) {
      if (repairPhasesBuilder_ == null) {
        ensureRepairPhasesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, repairPhases_);
        onChanged();
      } else {
        repairPhasesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the repair attempts. Each repair phase may have
     * multiple retry attempts or single rollback attempt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearRepairPhases() {
      if (repairPhasesBuilder_ == null) {
        repairPhases_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        repairPhasesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the repair attempts. Each repair phase may have
     * multiple retry attempts or single rollback attempt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeRepairPhases(int index) {
      if (repairPhasesBuilder_ == null) {
        ensureRepairPhasesIsMutable();
        repairPhases_.remove(index);
        onChanged();
      } else {
        repairPhasesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the repair attempts. Each repair phase may have
     * multiple retry attempts or single rollback attempt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.RepairPhase.Builder getRepairPhasesBuilder(int index) {
      return getRepairPhasesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the repair attempts. Each repair phase may have
     * multiple retry attempts or single rollback attempt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.RepairPhaseOrBuilder getRepairPhasesOrBuilder(int index) {
      if (repairPhasesBuilder_ == null) {
        return repairPhases_.get(index);
      } else {
        return repairPhasesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the repair attempts. Each repair phase may have
     * multiple retry attempts or single rollback attempt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.deploy.v1.RepairPhaseOrBuilder>
        getRepairPhasesOrBuilderList() {
      if (repairPhasesBuilder_ != null) {
        return repairPhasesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(repairPhases_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the repair attempts. Each repair phase may have
     * multiple retry attempts or single rollback attempt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.RepairPhase.Builder addRepairPhasesBuilder() {
      return getRepairPhasesFieldBuilder()
          .addBuilder(com.google.cloud.deploy.v1.RepairPhase.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the repair attempts. Each repair phase may have
     * multiple retry attempts or single rollback attempt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.RepairPhase.Builder addRepairPhasesBuilder(int index) {
      return getRepairPhasesFieldBuilder()
          .addBuilder(index, com.google.cloud.deploy.v1.RepairPhase.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Records of the repair attempts. Each repair phase may have
     * multiple retry attempts or single rollback attempt.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairPhase repair_phases = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.RepairPhase.Builder>
        getRepairPhasesBuilderList() {
      return getRepairPhasesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.RepairPhase,
            com.google.cloud.deploy.v1.RepairPhase.Builder,
            com.google.cloud.deploy.v1.RepairPhaseOrBuilder>
        getRepairPhasesFieldBuilder() {
      if (repairPhasesBuilder_ == null) {
        repairPhasesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.deploy.v1.RepairPhase,
                com.google.cloud.deploy.v1.RepairPhase.Builder,
                com.google.cloud.deploy.v1.RepairPhaseOrBuilder>(
                repairPhases_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        repairPhases_ = null;
      }
      return repairPhasesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.RepairRolloutOperation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.RepairRolloutOperation)
  private static final com.google.cloud.deploy.v1.RepairRolloutOperation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.RepairRolloutOperation();
  }

  public static com.google.cloud.deploy.v1.RepairRolloutOperation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RepairRolloutOperation> PARSER =
      new com.google.protobuf.AbstractParser<RepairRolloutOperation>() {
        @java.lang.Override
        public RepairRolloutOperation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RepairRolloutOperation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RepairRolloutOperation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.RepairRolloutOperation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
