/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/deploy/v1/cloud_deploy.proto

package com.google.cloud.deploy.v1;

/**
 *
 *
 * <pre>
 * The `RepairRolloutRule` automation rule will automatically repair a failed
 * `Rollout`.
 * </pre>
 *
 * Protobuf type {@code google.cloud.deploy.v1.RepairRolloutRule}
 */
public final class RepairRolloutRule extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.deploy.v1.RepairRolloutRule)
    RepairRolloutRuleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RepairRolloutRule.newBuilder() to construct.
  private RepairRolloutRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RepairRolloutRule() {
    id_ = "";
    sourcePhases_ = com.google.protobuf.LazyStringArrayList.emptyList();
    jobs_ = com.google.protobuf.LazyStringArrayList.emptyList();
    repairModes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RepairRolloutRule();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_RepairRolloutRule_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.deploy.v1.CloudDeployProto
        .internal_static_google_cloud_deploy_v1_RepairRolloutRule_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.deploy.v1.RepairRolloutRule.class,
            com.google.cloud.deploy.v1.RepairRolloutRule.Builder.class);
  }

  public static final int ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object id_ = "";
  /**
   *
   *
   * <pre>
   * Required. ID of the rule. This id must be unique in the `Automation`
   * resource to which this rule belongs. The format is `[a-z][a-z0-9&#92;-]{0,62}`.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. ID of the rule. This id must be unique in the `Automation`
   * resource to which this rule belongs. The format is `[a-z][a-z0-9&#92;-]{0,62}`.
   * </pre>
   *
   * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for id.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_PHASES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList sourcePhases_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Phases within which jobs are subject to automatic repair actions
   * on failure. Proceeds only after phase name matched any one in the list, or
   * for all phases if unspecified. This value must consist of lower-case
   * letters, numbers, and hyphens, start with a letter and end with a letter or
   * a number, and have a max length of 63 characters. In other words, it must
   * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>repeated string source_phases = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the sourcePhases.
   */
  public com.google.protobuf.ProtocolStringList getSourcePhasesList() {
    return sourcePhases_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Phases within which jobs are subject to automatic repair actions
   * on failure. Proceeds only after phase name matched any one in the list, or
   * for all phases if unspecified. This value must consist of lower-case
   * letters, numbers, and hyphens, start with a letter and end with a letter or
   * a number, and have a max length of 63 characters. In other words, it must
   * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>repeated string source_phases = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of sourcePhases.
   */
  public int getSourcePhasesCount() {
    return sourcePhases_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Phases within which jobs are subject to automatic repair actions
   * on failure. Proceeds only after phase name matched any one in the list, or
   * for all phases if unspecified. This value must consist of lower-case
   * letters, numbers, and hyphens, start with a letter and end with a letter or
   * a number, and have a max length of 63 characters. In other words, it must
   * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>repeated string source_phases = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The sourcePhases at the given index.
   */
  public java.lang.String getSourcePhases(int index) {
    return sourcePhases_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Phases within which jobs are subject to automatic repair actions
   * on failure. Proceeds only after phase name matched any one in the list, or
   * for all phases if unspecified. This value must consist of lower-case
   * letters, numbers, and hyphens, start with a letter and end with a letter or
   * a number, and have a max length of 63 characters. In other words, it must
   * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>repeated string source_phases = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the sourcePhases at the given index.
   */
  public com.google.protobuf.ByteString getSourcePhasesBytes(int index) {
    return sourcePhases_.getByteString(index);
  }

  public static final int JOBS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList jobs_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Optional. Jobs to repair. Proceeds only after job name matched any one in
   * the list, or for all jobs if unspecified or empty. The phase that includes
   * the job must match the phase ID specified in `source_phase`. This value
   * must consist of lower-case letters, numbers, and hyphens, start with a
   * letter and end with a letter or a number, and have a max length of 63
   * characters. In other words, it must match the following regex:
   * `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>repeated string jobs = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the jobs.
   */
  public com.google.protobuf.ProtocolStringList getJobsList() {
    return jobs_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Jobs to repair. Proceeds only after job name matched any one in
   * the list, or for all jobs if unspecified or empty. The phase that includes
   * the job must match the phase ID specified in `source_phase`. This value
   * must consist of lower-case letters, numbers, and hyphens, start with a
   * letter and end with a letter or a number, and have a max length of 63
   * characters. In other words, it must match the following regex:
   * `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>repeated string jobs = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of jobs.
   */
  public int getJobsCount() {
    return jobs_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Jobs to repair. Proceeds only after job name matched any one in
   * the list, or for all jobs if unspecified or empty. The phase that includes
   * the job must match the phase ID specified in `source_phase`. This value
   * must consist of lower-case letters, numbers, and hyphens, start with a
   * letter and end with a letter or a number, and have a max length of 63
   * characters. In other words, it must match the following regex:
   * `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>repeated string jobs = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The jobs at the given index.
   */
  public java.lang.String getJobs(int index) {
    return jobs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Jobs to repair. Proceeds only after job name matched any one in
   * the list, or for all jobs if unspecified or empty. The phase that includes
   * the job must match the phase ID specified in `source_phase`. This value
   * must consist of lower-case letters, numbers, and hyphens, start with a
   * letter and end with a letter or a number, and have a max length of 63
   * characters. In other words, it must match the following regex:
   * `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
   * </pre>
   *
   * <code>repeated string jobs = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the jobs at the given index.
   */
  public com.google.protobuf.ByteString getJobsBytes(int index) {
    return jobs_.getByteString(index);
  }

  public static final int REPAIR_MODES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.deploy.v1.RepairMode> repairModes_;
  /**
   *
   *
   * <pre>
   * Required. Defines the types of automatic repair actions for failed jobs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.deploy.v1.RepairMode> getRepairModesList() {
    return repairModes_;
  }
  /**
   *
   *
   * <pre>
   * Required. Defines the types of automatic repair actions for failed jobs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.deploy.v1.RepairModeOrBuilder>
      getRepairModesOrBuilderList() {
    return repairModes_;
  }
  /**
   *
   *
   * <pre>
   * Required. Defines the types of automatic repair actions for failed jobs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getRepairModesCount() {
    return repairModes_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Defines the types of automatic repair actions for failed jobs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RepairMode getRepairModes(int index) {
    return repairModes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Defines the types of automatic repair actions for failed jobs.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.RepairModeOrBuilder getRepairModesOrBuilder(int index) {
    return repairModes_.get(index);
  }

  public static final int CONDITION_FIELD_NUMBER = 6;
  private com.google.cloud.deploy.v1.AutomationRuleCondition condition_;
  /**
   *
   *
   * <pre>
   * Output only. Information around the state of the 'Automation' rule.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AutomationRuleCondition condition = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the condition field is set.
   */
  @java.lang.Override
  public boolean hasCondition() {
    return condition_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information around the state of the 'Automation' rule.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AutomationRuleCondition condition = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The condition.
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AutomationRuleCondition getCondition() {
    return condition_ == null
        ? com.google.cloud.deploy.v1.AutomationRuleCondition.getDefaultInstance()
        : condition_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Information around the state of the 'Automation' rule.
   * </pre>
   *
   * <code>
   * .google.cloud.deploy.v1.AutomationRuleCondition condition = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.deploy.v1.AutomationRuleConditionOrBuilder getConditionOrBuilder() {
    return condition_ == null
        ? com.google.cloud.deploy.v1.AutomationRuleCondition.getDefaultInstance()
        : condition_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    for (int i = 0; i < sourcePhases_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sourcePhases_.getRaw(i));
    }
    for (int i = 0; i < jobs_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, jobs_.getRaw(i));
    }
    for (int i = 0; i < repairModes_.size(); i++) {
      output.writeMessage(4, repairModes_.get(i));
    }
    if (condition_ != null) {
      output.writeMessage(6, getCondition());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(id_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < sourcePhases_.size(); i++) {
        dataSize += computeStringSizeNoTag(sourcePhases_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getSourcePhasesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < jobs_.size(); i++) {
        dataSize += computeStringSizeNoTag(jobs_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getJobsList().size();
    }
    for (int i = 0; i < repairModes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, repairModes_.get(i));
    }
    if (condition_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCondition());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.deploy.v1.RepairRolloutRule)) {
      return super.equals(obj);
    }
    com.google.cloud.deploy.v1.RepairRolloutRule other =
        (com.google.cloud.deploy.v1.RepairRolloutRule) obj;

    if (!getId().equals(other.getId())) return false;
    if (!getSourcePhasesList().equals(other.getSourcePhasesList())) return false;
    if (!getJobsList().equals(other.getJobsList())) return false;
    if (!getRepairModesList().equals(other.getRepairModesList())) return false;
    if (hasCondition() != other.hasCondition()) return false;
    if (hasCondition()) {
      if (!getCondition().equals(other.getCondition())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    if (getSourcePhasesCount() > 0) {
      hash = (37 * hash) + SOURCE_PHASES_FIELD_NUMBER;
      hash = (53 * hash) + getSourcePhasesList().hashCode();
    }
    if (getJobsCount() > 0) {
      hash = (37 * hash) + JOBS_FIELD_NUMBER;
      hash = (53 * hash) + getJobsList().hashCode();
    }
    if (getRepairModesCount() > 0) {
      hash = (37 * hash) + REPAIR_MODES_FIELD_NUMBER;
      hash = (53 * hash) + getRepairModesList().hashCode();
    }
    if (hasCondition()) {
      hash = (37 * hash) + CONDITION_FIELD_NUMBER;
      hash = (53 * hash) + getCondition().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.deploy.v1.RepairRolloutRule parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutRule parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutRule parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutRule parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutRule parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutRule parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutRule parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutRule parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutRule parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutRule parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutRule parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.deploy.v1.RepairRolloutRule parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.deploy.v1.RepairRolloutRule prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The `RepairRolloutRule` automation rule will automatically repair a failed
   * `Rollout`.
   * </pre>
   *
   * Protobuf type {@code google.cloud.deploy.v1.RepairRolloutRule}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.deploy.v1.RepairRolloutRule)
      com.google.cloud.deploy.v1.RepairRolloutRuleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RepairRolloutRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RepairRolloutRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.deploy.v1.RepairRolloutRule.class,
              com.google.cloud.deploy.v1.RepairRolloutRule.Builder.class);
    }

    // Construct using com.google.cloud.deploy.v1.RepairRolloutRule.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      id_ = "";
      sourcePhases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      jobs_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (repairModesBuilder_ == null) {
        repairModes_ = java.util.Collections.emptyList();
      } else {
        repairModes_ = null;
        repairModesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      condition_ = null;
      if (conditionBuilder_ != null) {
        conditionBuilder_.dispose();
        conditionBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.deploy.v1.CloudDeployProto
          .internal_static_google_cloud_deploy_v1_RepairRolloutRule_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RepairRolloutRule getDefaultInstanceForType() {
      return com.google.cloud.deploy.v1.RepairRolloutRule.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RepairRolloutRule build() {
      com.google.cloud.deploy.v1.RepairRolloutRule result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.deploy.v1.RepairRolloutRule buildPartial() {
      com.google.cloud.deploy.v1.RepairRolloutRule result =
          new com.google.cloud.deploy.v1.RepairRolloutRule(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.deploy.v1.RepairRolloutRule result) {
      if (repairModesBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          repairModes_ = java.util.Collections.unmodifiableList(repairModes_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.repairModes_ = repairModes_;
      } else {
        result.repairModes_ = repairModesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.deploy.v1.RepairRolloutRule result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.id_ = id_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        sourcePhases_.makeImmutable();
        result.sourcePhases_ = sourcePhases_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        jobs_.makeImmutable();
        result.jobs_ = jobs_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.condition_ = conditionBuilder_ == null ? condition_ : conditionBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.deploy.v1.RepairRolloutRule) {
        return mergeFrom((com.google.cloud.deploy.v1.RepairRolloutRule) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.deploy.v1.RepairRolloutRule other) {
      if (other == com.google.cloud.deploy.v1.RepairRolloutRule.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.sourcePhases_.isEmpty()) {
        if (sourcePhases_.isEmpty()) {
          sourcePhases_ = other.sourcePhases_;
          bitField0_ |= 0x00000002;
        } else {
          ensureSourcePhasesIsMutable();
          sourcePhases_.addAll(other.sourcePhases_);
        }
        onChanged();
      }
      if (!other.jobs_.isEmpty()) {
        if (jobs_.isEmpty()) {
          jobs_ = other.jobs_;
          bitField0_ |= 0x00000004;
        } else {
          ensureJobsIsMutable();
          jobs_.addAll(other.jobs_);
        }
        onChanged();
      }
      if (repairModesBuilder_ == null) {
        if (!other.repairModes_.isEmpty()) {
          if (repairModes_.isEmpty()) {
            repairModes_ = other.repairModes_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureRepairModesIsMutable();
            repairModes_.addAll(other.repairModes_);
          }
          onChanged();
        }
      } else {
        if (!other.repairModes_.isEmpty()) {
          if (repairModesBuilder_.isEmpty()) {
            repairModesBuilder_.dispose();
            repairModesBuilder_ = null;
            repairModes_ = other.repairModes_;
            bitField0_ = (bitField0_ & ~0x00000008);
            repairModesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRepairModesFieldBuilder()
                    : null;
          } else {
            repairModesBuilder_.addAllMessages(other.repairModes_);
          }
        }
      }
      if (other.hasCondition()) {
        mergeCondition(other.getCondition());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                id_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureSourcePhasesIsMutable();
                sourcePhases_.add(s);
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureJobsIsMutable();
                jobs_.add(s);
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.deploy.v1.RepairMode m =
                    input.readMessage(
                        com.google.cloud.deploy.v1.RepairMode.parser(), extensionRegistry);
                if (repairModesBuilder_ == null) {
                  ensureRepairModesIsMutable();
                  repairModes_.add(m);
                } else {
                  repairModesBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 50:
              {
                input.readMessage(getConditionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object id_ = "";
    /**
     *
     *
     * <pre>
     * Required. ID of the rule. This id must be unique in the `Automation`
     * resource to which this rule belongs. The format is `[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The id.
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the rule. This id must be unique in the `Automation`
     * resource to which this rule belongs. The format is `[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for id.
     */
    public com.google.protobuf.ByteString getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the rule. This id must be unique in the `Automation`
     * resource to which this rule belongs. The format is `[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the rule. This id must be unique in the `Automation`
     * resource to which this rule belongs. The format is `[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      id_ = getDefaultInstance().getId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. ID of the rule. This id must be unique in the `Automation`
     * resource to which this rule belongs. The format is `[a-z][a-z0-9&#92;-]{0,62}`.
     * </pre>
     *
     * <code>string id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for id to set.
     * @return This builder for chaining.
     */
    public Builder setIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      id_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList sourcePhases_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureSourcePhasesIsMutable() {
      if (!sourcePhases_.isModifiable()) {
        sourcePhases_ = new com.google.protobuf.LazyStringArrayList(sourcePhases_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * Optional. Phases within which jobs are subject to automatic repair actions
     * on failure. Proceeds only after phase name matched any one in the list, or
     * for all phases if unspecified. This value must consist of lower-case
     * letters, numbers, and hyphens, start with a letter and end with a letter or
     * a number, and have a max length of 63 characters. In other words, it must
     * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string source_phases = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the sourcePhases.
     */
    public com.google.protobuf.ProtocolStringList getSourcePhasesList() {
      sourcePhases_.makeImmutable();
      return sourcePhases_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Phases within which jobs are subject to automatic repair actions
     * on failure. Proceeds only after phase name matched any one in the list, or
     * for all phases if unspecified. This value must consist of lower-case
     * letters, numbers, and hyphens, start with a letter and end with a letter or
     * a number, and have a max length of 63 characters. In other words, it must
     * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string source_phases = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of sourcePhases.
     */
    public int getSourcePhasesCount() {
      return sourcePhases_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Phases within which jobs are subject to automatic repair actions
     * on failure. Proceeds only after phase name matched any one in the list, or
     * for all phases if unspecified. This value must consist of lower-case
     * letters, numbers, and hyphens, start with a letter and end with a letter or
     * a number, and have a max length of 63 characters. In other words, it must
     * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string source_phases = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The sourcePhases at the given index.
     */
    public java.lang.String getSourcePhases(int index) {
      return sourcePhases_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Phases within which jobs are subject to automatic repair actions
     * on failure. Proceeds only after phase name matched any one in the list, or
     * for all phases if unspecified. This value must consist of lower-case
     * letters, numbers, and hyphens, start with a letter and end with a letter or
     * a number, and have a max length of 63 characters. In other words, it must
     * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string source_phases = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the sourcePhases at the given index.
     */
    public com.google.protobuf.ByteString getSourcePhasesBytes(int index) {
      return sourcePhases_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Phases within which jobs are subject to automatic repair actions
     * on failure. Proceeds only after phase name matched any one in the list, or
     * for all phases if unspecified. This value must consist of lower-case
     * letters, numbers, and hyphens, start with a letter and end with a letter or
     * a number, and have a max length of 63 characters. In other words, it must
     * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string source_phases = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The sourcePhases to set.
     * @return This builder for chaining.
     */
    public Builder setSourcePhases(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourcePhasesIsMutable();
      sourcePhases_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Phases within which jobs are subject to automatic repair actions
     * on failure. Proceeds only after phase name matched any one in the list, or
     * for all phases if unspecified. This value must consist of lower-case
     * letters, numbers, and hyphens, start with a letter and end with a letter or
     * a number, and have a max length of 63 characters. In other words, it must
     * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string source_phases = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The sourcePhases to add.
     * @return This builder for chaining.
     */
    public Builder addSourcePhases(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureSourcePhasesIsMutable();
      sourcePhases_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Phases within which jobs are subject to automatic repair actions
     * on failure. Proceeds only after phase name matched any one in the list, or
     * for all phases if unspecified. This value must consist of lower-case
     * letters, numbers, and hyphens, start with a letter and end with a letter or
     * a number, and have a max length of 63 characters. In other words, it must
     * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string source_phases = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The sourcePhases to add.
     * @return This builder for chaining.
     */
    public Builder addAllSourcePhases(java.lang.Iterable<java.lang.String> values) {
      ensureSourcePhasesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sourcePhases_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Phases within which jobs are subject to automatic repair actions
     * on failure. Proceeds only after phase name matched any one in the list, or
     * for all phases if unspecified. This value must consist of lower-case
     * letters, numbers, and hyphens, start with a letter and end with a letter or
     * a number, and have a max length of 63 characters. In other words, it must
     * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string source_phases = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourcePhases() {
      sourcePhases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Phases within which jobs are subject to automatic repair actions
     * on failure. Proceeds only after phase name matched any one in the list, or
     * for all phases if unspecified. This value must consist of lower-case
     * letters, numbers, and hyphens, start with a letter and end with a letter or
     * a number, and have a max length of 63 characters. In other words, it must
     * match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string source_phases = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the sourcePhases to add.
     * @return This builder for chaining.
     */
    public Builder addSourcePhasesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureSourcePhasesIsMutable();
      sourcePhases_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList jobs_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureJobsIsMutable() {
      if (!jobs_.isModifiable()) {
        jobs_ = new com.google.protobuf.LazyStringArrayList(jobs_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Optional. Jobs to repair. Proceeds only after job name matched any one in
     * the list, or for all jobs if unspecified or empty. The phase that includes
     * the job must match the phase ID specified in `source_phase`. This value
     * must consist of lower-case letters, numbers, and hyphens, start with a
     * letter and end with a letter or a number, and have a max length of 63
     * characters. In other words, it must match the following regex:
     * `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string jobs = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the jobs.
     */
    public com.google.protobuf.ProtocolStringList getJobsList() {
      jobs_.makeImmutable();
      return jobs_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Jobs to repair. Proceeds only after job name matched any one in
     * the list, or for all jobs if unspecified or empty. The phase that includes
     * the job must match the phase ID specified in `source_phase`. This value
     * must consist of lower-case letters, numbers, and hyphens, start with a
     * letter and end with a letter or a number, and have a max length of 63
     * characters. In other words, it must match the following regex:
     * `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string jobs = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of jobs.
     */
    public int getJobsCount() {
      return jobs_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Jobs to repair. Proceeds only after job name matched any one in
     * the list, or for all jobs if unspecified or empty. The phase that includes
     * the job must match the phase ID specified in `source_phase`. This value
     * must consist of lower-case letters, numbers, and hyphens, start with a
     * letter and end with a letter or a number, and have a max length of 63
     * characters. In other words, it must match the following regex:
     * `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string jobs = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The jobs at the given index.
     */
    public java.lang.String getJobs(int index) {
      return jobs_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Jobs to repair. Proceeds only after job name matched any one in
     * the list, or for all jobs if unspecified or empty. The phase that includes
     * the job must match the phase ID specified in `source_phase`. This value
     * must consist of lower-case letters, numbers, and hyphens, start with a
     * letter and end with a letter or a number, and have a max length of 63
     * characters. In other words, it must match the following regex:
     * `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string jobs = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the jobs at the given index.
     */
    public com.google.protobuf.ByteString getJobsBytes(int index) {
      return jobs_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Jobs to repair. Proceeds only after job name matched any one in
     * the list, or for all jobs if unspecified or empty. The phase that includes
     * the job must match the phase ID specified in `source_phase`. This value
     * must consist of lower-case letters, numbers, and hyphens, start with a
     * letter and end with a letter or a number, and have a max length of 63
     * characters. In other words, it must match the following regex:
     * `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string jobs = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The jobs to set.
     * @return This builder for chaining.
     */
    public Builder setJobs(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureJobsIsMutable();
      jobs_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Jobs to repair. Proceeds only after job name matched any one in
     * the list, or for all jobs if unspecified or empty. The phase that includes
     * the job must match the phase ID specified in `source_phase`. This value
     * must consist of lower-case letters, numbers, and hyphens, start with a
     * letter and end with a letter or a number, and have a max length of 63
     * characters. In other words, it must match the following regex:
     * `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string jobs = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The jobs to add.
     * @return This builder for chaining.
     */
    public Builder addJobs(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureJobsIsMutable();
      jobs_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Jobs to repair. Proceeds only after job name matched any one in
     * the list, or for all jobs if unspecified or empty. The phase that includes
     * the job must match the phase ID specified in `source_phase`. This value
     * must consist of lower-case letters, numbers, and hyphens, start with a
     * letter and end with a letter or a number, and have a max length of 63
     * characters. In other words, it must match the following regex:
     * `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string jobs = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The jobs to add.
     * @return This builder for chaining.
     */
    public Builder addAllJobs(java.lang.Iterable<java.lang.String> values) {
      ensureJobsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, jobs_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Jobs to repair. Proceeds only after job name matched any one in
     * the list, or for all jobs if unspecified or empty. The phase that includes
     * the job must match the phase ID specified in `source_phase`. This value
     * must consist of lower-case letters, numbers, and hyphens, start with a
     * letter and end with a letter or a number, and have a max length of 63
     * characters. In other words, it must match the following regex:
     * `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string jobs = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJobs() {
      jobs_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Jobs to repair. Proceeds only after job name matched any one in
     * the list, or for all jobs if unspecified or empty. The phase that includes
     * the job must match the phase ID specified in `source_phase`. This value
     * must consist of lower-case letters, numbers, and hyphens, start with a
     * letter and end with a letter or a number, and have a max length of 63
     * characters. In other words, it must match the following regex:
     * `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
     * </pre>
     *
     * <code>repeated string jobs = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the jobs to add.
     * @return This builder for chaining.
     */
    public Builder addJobsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureJobsIsMutable();
      jobs_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.deploy.v1.RepairMode> repairModes_ =
        java.util.Collections.emptyList();

    private void ensureRepairModesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        repairModes_ = new java.util.ArrayList<com.google.cloud.deploy.v1.RepairMode>(repairModes_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.RepairMode,
            com.google.cloud.deploy.v1.RepairMode.Builder,
            com.google.cloud.deploy.v1.RepairModeOrBuilder>
        repairModesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Defines the types of automatic repair actions for failed jobs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.RepairMode> getRepairModesList() {
      if (repairModesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(repairModes_);
      } else {
        return repairModesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Defines the types of automatic repair actions for failed jobs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getRepairModesCount() {
      if (repairModesBuilder_ == null) {
        return repairModes_.size();
      } else {
        return repairModesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Defines the types of automatic repair actions for failed jobs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.RepairMode getRepairModes(int index) {
      if (repairModesBuilder_ == null) {
        return repairModes_.get(index);
      } else {
        return repairModesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Defines the types of automatic repair actions for failed jobs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRepairModes(int index, com.google.cloud.deploy.v1.RepairMode value) {
      if (repairModesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRepairModesIsMutable();
        repairModes_.set(index, value);
        onChanged();
      } else {
        repairModesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Defines the types of automatic repair actions for failed jobs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRepairModes(
        int index, com.google.cloud.deploy.v1.RepairMode.Builder builderForValue) {
      if (repairModesBuilder_ == null) {
        ensureRepairModesIsMutable();
        repairModes_.set(index, builderForValue.build());
        onChanged();
      } else {
        repairModesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Defines the types of automatic repair actions for failed jobs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRepairModes(com.google.cloud.deploy.v1.RepairMode value) {
      if (repairModesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRepairModesIsMutable();
        repairModes_.add(value);
        onChanged();
      } else {
        repairModesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Defines the types of automatic repair actions for failed jobs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRepairModes(int index, com.google.cloud.deploy.v1.RepairMode value) {
      if (repairModesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRepairModesIsMutable();
        repairModes_.add(index, value);
        onChanged();
      } else {
        repairModesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Defines the types of automatic repair actions for failed jobs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRepairModes(com.google.cloud.deploy.v1.RepairMode.Builder builderForValue) {
      if (repairModesBuilder_ == null) {
        ensureRepairModesIsMutable();
        repairModes_.add(builderForValue.build());
        onChanged();
      } else {
        repairModesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Defines the types of automatic repair actions for failed jobs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addRepairModes(
        int index, com.google.cloud.deploy.v1.RepairMode.Builder builderForValue) {
      if (repairModesBuilder_ == null) {
        ensureRepairModesIsMutable();
        repairModes_.add(index, builderForValue.build());
        onChanged();
      } else {
        repairModesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Defines the types of automatic repair actions for failed jobs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllRepairModes(
        java.lang.Iterable<? extends com.google.cloud.deploy.v1.RepairMode> values) {
      if (repairModesBuilder_ == null) {
        ensureRepairModesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, repairModes_);
        onChanged();
      } else {
        repairModesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Defines the types of automatic repair actions for failed jobs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearRepairModes() {
      if (repairModesBuilder_ == null) {
        repairModes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        repairModesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Defines the types of automatic repair actions for failed jobs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeRepairModes(int index) {
      if (repairModesBuilder_ == null) {
        ensureRepairModesIsMutable();
        repairModes_.remove(index);
        onChanged();
      } else {
        repairModesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Defines the types of automatic repair actions for failed jobs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.RepairMode.Builder getRepairModesBuilder(int index) {
      return getRepairModesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Defines the types of automatic repair actions for failed jobs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.RepairModeOrBuilder getRepairModesOrBuilder(int index) {
      if (repairModesBuilder_ == null) {
        return repairModes_.get(index);
      } else {
        return repairModesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Defines the types of automatic repair actions for failed jobs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.deploy.v1.RepairModeOrBuilder>
        getRepairModesOrBuilderList() {
      if (repairModesBuilder_ != null) {
        return repairModesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(repairModes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Defines the types of automatic repair actions for failed jobs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.RepairMode.Builder addRepairModesBuilder() {
      return getRepairModesFieldBuilder()
          .addBuilder(com.google.cloud.deploy.v1.RepairMode.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Defines the types of automatic repair actions for failed jobs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.deploy.v1.RepairMode.Builder addRepairModesBuilder(int index) {
      return getRepairModesFieldBuilder()
          .addBuilder(index, com.google.cloud.deploy.v1.RepairMode.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Defines the types of automatic repair actions for failed jobs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.deploy.v1.RepairMode repair_modes = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.deploy.v1.RepairMode.Builder>
        getRepairModesBuilderList() {
      return getRepairModesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.deploy.v1.RepairMode,
            com.google.cloud.deploy.v1.RepairMode.Builder,
            com.google.cloud.deploy.v1.RepairModeOrBuilder>
        getRepairModesFieldBuilder() {
      if (repairModesBuilder_ == null) {
        repairModesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.deploy.v1.RepairMode,
                com.google.cloud.deploy.v1.RepairMode.Builder,
                com.google.cloud.deploy.v1.RepairModeOrBuilder>(
                repairModes_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        repairModes_ = null;
      }
      return repairModesBuilder_;
    }

    private com.google.cloud.deploy.v1.AutomationRuleCondition condition_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.AutomationRuleCondition,
            com.google.cloud.deploy.v1.AutomationRuleCondition.Builder,
            com.google.cloud.deploy.v1.AutomationRuleConditionOrBuilder>
        conditionBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the 'Automation' rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the condition field is set.
     */
    public boolean hasCondition() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the 'Automation' rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The condition.
     */
    public com.google.cloud.deploy.v1.AutomationRuleCondition getCondition() {
      if (conditionBuilder_ == null) {
        return condition_ == null
            ? com.google.cloud.deploy.v1.AutomationRuleCondition.getDefaultInstance()
            : condition_;
      } else {
        return conditionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the 'Automation' rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCondition(com.google.cloud.deploy.v1.AutomationRuleCondition value) {
      if (conditionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        condition_ = value;
      } else {
        conditionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the 'Automation' rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCondition(
        com.google.cloud.deploy.v1.AutomationRuleCondition.Builder builderForValue) {
      if (conditionBuilder_ == null) {
        condition_ = builderForValue.build();
      } else {
        conditionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the 'Automation' rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCondition(com.google.cloud.deploy.v1.AutomationRuleCondition value) {
      if (conditionBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && condition_ != null
            && condition_
                != com.google.cloud.deploy.v1.AutomationRuleCondition.getDefaultInstance()) {
          getConditionBuilder().mergeFrom(value);
        } else {
          condition_ = value;
        }
      } else {
        conditionBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the 'Automation' rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCondition() {
      bitField0_ = (bitField0_ & ~0x00000010);
      condition_ = null;
      if (conditionBuilder_ != null) {
        conditionBuilder_.dispose();
        conditionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the 'Automation' rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.AutomationRuleCondition.Builder getConditionBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getConditionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the 'Automation' rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.deploy.v1.AutomationRuleConditionOrBuilder getConditionOrBuilder() {
      if (conditionBuilder_ != null) {
        return conditionBuilder_.getMessageOrBuilder();
      } else {
        return condition_ == null
            ? com.google.cloud.deploy.v1.AutomationRuleCondition.getDefaultInstance()
            : condition_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Information around the state of the 'Automation' rule.
     * </pre>
     *
     * <code>
     * .google.cloud.deploy.v1.AutomationRuleCondition condition = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.deploy.v1.AutomationRuleCondition,
            com.google.cloud.deploy.v1.AutomationRuleCondition.Builder,
            com.google.cloud.deploy.v1.AutomationRuleConditionOrBuilder>
        getConditionFieldBuilder() {
      if (conditionBuilder_ == null) {
        conditionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.deploy.v1.AutomationRuleCondition,
                com.google.cloud.deploy.v1.AutomationRuleCondition.Builder,
                com.google.cloud.deploy.v1.AutomationRuleConditionOrBuilder>(
                getCondition(), getParentForChildren(), isClean());
        condition_ = null;
      }
      return conditionBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.deploy.v1.RepairRolloutRule)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.deploy.v1.RepairRolloutRule)
  private static final com.google.cloud.deploy.v1.RepairRolloutRule DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.deploy.v1.RepairRolloutRule();
  }

  public static com.google.cloud.deploy.v1.RepairRolloutRule getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RepairRolloutRule> PARSER =
      new com.google.protobuf.AbstractParser<RepairRolloutRule>() {
        @java.lang.Override
        public RepairRolloutRule parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RepairRolloutRule> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RepairRolloutRule> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.deploy.v1.RepairRolloutRule getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
